define("tiny_teamsmeeting/commands",["exports","editor_tiny/utils","core/str","./common","./options","core/ajax"],(function(_exports,_utils,_str,_common,_options,_ajax){var obj;
/**
   * Commands helper for the Moodle tiny_teamsmeeting plugin.
   *
   * @copyright   2023 Enovation Solutions
   * @author      Oliwer Banach <oliwer.banach@enovation.ie>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.getSetup=void 0,_ajax=(obj=_ajax)&&obj.__esModule?obj:{default:obj};const dialogApiReference={current:null};_exports.getSetup=async()=>{const[createMeetingButtonNameTitle,buttonImage]=await Promise.all([(0,_str.get_string)("pluginname",_common.component),(0,_utils.getButtonImage)("icon",_common.component)]);return editor=>{editor.ui.registry.addIcon(_common.icon,buttonImage.html),editor.ui.registry.addToggleButton(_common.createMeetingButtonName,{icon:_common.icon,tooltip:createMeetingButtonNameTitle,onAction:openDialog(editor),onSetup:toggleActiveState(editor)}),window.addEventListener("message",(event=>{event.data&&"meetingUrl"===event.data.action&&updateMeetingUrlInput(event.data.url)}))}};const openDialog=editor=>async()=>{const[modalTitle,buttonPrimaryLabel,buttonSecondaryLabel,inputUrlLabel,inputUrlPlaceholder,checkboxNewWindowLabel]=await Promise.all([(0,_str.get_string)("tiny_modal_title",_common.component),(0,_str.get_string)("tiny_button_primary_label",_common.component),(0,_str.get_string)("tiny_button_secondary_label",_common.component),(0,_str.get_string)("tiny_input_url_label",_common.component),(0,_str.get_string)("tiny_input_url_placeholder",_common.component),(0,_str.get_string)("tiny_checkbox_new_window_label",_common.component)]);let iframeData=await getIframeData(editor);dialogApiReference.current=editor.windowManager.open({title:modalTitle,body:{type:"panel",items:[{type:"htmlpanel",html:'<iframe id="msteams-frame" src="'.concat(iframeData.url,'" style="width: 100%; height: 480px"></iframe>')},{type:"input",name:"meetingUrl",label:inputUrlLabel,enabled:!1,placeholder:inputUrlPlaceholder},{type:"checkbox",name:"newWindowCheckbox",label:checkboxNewWindowLabel}]},buttons:[{type:"cancel",text:buttonSecondaryLabel},{type:"submit",text:buttonPrimaryLabel,primary:!0}],onSubmit:handleSubmitAction(editor)}),dialogApiReference.current.setData({meetingUrl:iframeData.meetingUrl,newWindowCheckbox:iframeData.newWindow})},handleSubmitAction=editor=>api=>{var _selectedNode$parentN,_selectedNode$parentN2;const data=api.getData(),meetingUrl=data.meetingUrl,targetType=data.newWindowCheckbox?"_blank":"";let selectedNode=editor.selection.getNode(),linkNode=null;if("A"===selectedNode.nodeName&&"tiny_meeting_link"===selectedNode.id?linkNode=selectedNode:"A"===(null===(_selectedNode$parentN=selectedNode.parentNode)||void 0===_selectedNode$parentN?void 0:_selectedNode$parentN.nodeName)&&"tiny_meeting_link"===(null===(_selectedNode$parentN2=selectedNode.parentNode)||void 0===_selectedNode$parentN2?void 0:_selectedNode$parentN2.id)&&(linkNode=selectedNode.parentNode),linkNode)editor.dom.setAttrib(linkNode,"href",meetingUrl),editor.dom.setAttrib(linkNode,"target",targetType);else{let selectedContent=editor.selection.getContent({format:"text"}),contentToInsert=selectedContent||meetingUrl;editor.insertContent('<a id="tiny_meeting_link" href="'.concat(meetingUrl,'" target="').concat(targetType,'">').concat(contentToInsert,"</a>"))}api.close()},updateMeetingUrlInput=url=>{dialogApiReference.current&&dialogApiReference.current.setData({meetingUrl:url})},getIframeData=async editor=>{let data=getMeetingUrlFormSelectedNode(editor);if(data&&data.link){const result=await _ajax.default.call([{methodname:"tiny_teamsmeeting_get_meeting_details",args:{url:data.link}}])[0];return{url:result.url,meetingUrl:result.status?data.link:"",newWindow:"_blank"===data.target}}return{url:"".concat((0,_options.getAppurl)(editor),"?url=").concat((0,_options.getClientdomain)(editor),"&locale=").concat((0,_options.getLocaleValue)(editor),"&msession=").concat((0,_options.getMsession)(editor),"&editor=tiny&courseid=").concat((0,_options.getCourseId)(editor)),meetingUrl:"",newWindow:!1}},getMeetingUrlFormSelectedNode=editor=>{var _selectedNode$parentN3,_linkNode;let selectedNode=editor.selection.getNode(),linkNode=null;var _linkNode2,_linkNode3;return"A"===selectedNode.nodeName?linkNode=selectedNode:"A"===(null===(_selectedNode$parentN3=selectedNode.parentNode)||void 0===_selectedNode$parentN3?void 0:_selectedNode$parentN3.nodeName)&&(linkNode=selectedNode.parentNode),"tiny_meeting_link"===(null===(_linkNode=linkNode)||void 0===_linkNode?void 0:_linkNode.id)?{link:null===(_linkNode2=linkNode)||void 0===_linkNode2?void 0:_linkNode2.getAttribute("href"),target:null===(_linkNode3=linkNode)||void 0===_linkNode3?void 0:_linkNode3.getAttribute("target")}:null},toggleActiveState=editor=>buttonApi=>(editor.on("NodeChange",(()=>handleNodeChange(editor,buttonApi))),function(){editor.on("NodeChange",(()=>handleNodeChange(editor,buttonApi)))}),handleNodeChange=(editor,buttonApi)=>{var _selectedNode$parentN4;const selectedNode=editor.selection.getNode(),isActive="tiny_meeting_link"===selectedNode.id||"tiny_meeting_link"===(null===(_selectedNode$parentN4=selectedNode.parentNode)||void 0===_selectedNode$parentN4?void 0:_selectedNode$parentN4.id);buttonApi.setActive(isActive)}}));

//# sourceMappingURL=commands.min.js.map