/*
 Copyright 2016 Google Inc. All Rights Reserved.
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/

this.workbox = this.workbox || {};
(function (exports) {
'use strict';

let tmpIdbName=`workbox-cache-expiration`;self&&self.registration&&(tmpIdbName+=`-${self.registration.scope}`);const idbName=tmpIdbName;const idbVersion=1;const urlPropertyName='url';const timestampPropertyName='timestamp';

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var idb=createCommonjsModule(function(a){'use strict';(function(){function b(r){return Array.prototype.slice.call(r)}function c(r){return new Promise(function(s,t){r.onsuccess=function(){s(r.result);},r.onerror=function(){t(r.error);};})}function d(r,s,t){var u,v=new Promise(function(w,x){u=r[s].apply(r,t),c(u).then(w,x);});return v.request=u,v}function e(r,s,t){var u=d(r,s,t);return u.then(function(v){return v?new k(v,u.request):void 0})}function f(r,s,t){t.forEach(function(u){Object.defineProperty(r.prototype,u,{get:function(){return this[s][u]},set:function(v){this[s][u]=v;}});});}function g(r,s,t,u){u.forEach(function(v){v in t.prototype&&(r.prototype[v]=function(){return d(this[s],v,arguments)});});}function h(r,s,t,u){u.forEach(function(v){v in t.prototype&&(r.prototype[v]=function(){return this[s][v].apply(this[s],arguments)});});}function i(r,s,t,u){u.forEach(function(v){v in t.prototype&&(r.prototype[v]=function(){return e(this[s],v,arguments)});});}function j(r){this._index=r;}function k(r,s){this._cursor=r,this._request=s;}function l(r){this._store=r;}function m(r){this._tx=r,this.complete=new Promise(function(s,t){r.oncomplete=function(){s();},r.onerror=function(){t(r.error);},r.onabort=function(){t(r.error);};});}function n(r,s,t){this._db=r,this.oldVersion=s,this.transaction=new m(t);}function o(r){this._db=r;}f(j,'_index',['name','keyPath','multiEntry','unique']),g(j,'_index',IDBIndex,['get','getKey','getAll','getAllKeys','count']),i(j,'_index',IDBIndex,['openCursor','openKeyCursor']),f(k,'_cursor',['direction','key','primaryKey','value']),g(k,'_cursor',IDBCursor,['update','delete']),['advance','continue','continuePrimaryKey'].forEach(function(r){r in IDBCursor.prototype&&(k.prototype[r]=function(){var s=this,t=arguments;return Promise.resolve().then(function(){return s._cursor[r].apply(s._cursor,t),c(s._request).then(function(u){return u?new k(u,s._request):void 0})})});}),l.prototype.createIndex=function(){return new j(this._store.createIndex.apply(this._store,arguments))},l.prototype.index=function(){return new j(this._store.index.apply(this._store,arguments))},f(l,'_store',['name','keyPath','indexNames','autoIncrement']),g(l,'_store',IDBObjectStore,['put','add','delete','clear','get','getAll','getKey','getAllKeys','count']),i(l,'_store',IDBObjectStore,['openCursor','openKeyCursor']),h(l,'_store',IDBObjectStore,['deleteIndex']),m.prototype.objectStore=function(){return new l(this._tx.objectStore.apply(this._tx,arguments))},f(m,'_tx',['objectStoreNames','mode']),h(m,'_tx',IDBTransaction,['abort']),n.prototype.createObjectStore=function(){return new l(this._db.createObjectStore.apply(this._db,arguments))},f(n,'_db',['name','version','objectStoreNames']),h(n,'_db',IDBDatabase,['deleteObjectStore','close']),o.prototype.transaction=function(){return new m(this._db.transaction.apply(this._db,arguments))},f(o,'_db',['name','version','objectStoreNames']),h(o,'_db',IDBDatabase,['close']),['openCursor','openKeyCursor'].forEach(function(r){[l,j].forEach(function(s){s.prototype[r.replace('open','iterate')]=function(){var t=b(arguments),u=t[t.length-1],v=this._store||this._index,w=v[r].apply(v,t.slice(0,-1));w.onsuccess=function(){u(w.result);};};});}),[j,l].forEach(function(r){r.prototype.getAll||(r.prototype.getAll=function(s,t){var u=this,v=[];return new Promise(function(w){u.iterateCursor(s,function(x){return x?(v.push(x.value),void 0!==t&&v.length==t?void w(v):void x.continue()):void w(v)});})});});var q={open:function(r,s,t){var u=d(indexedDB,'open',[r,s]),v=u.request;return v.onupgradeneeded=function(w){t&&t(new n(v.result,w.oldVersion,v.transaction));},u.then(function(w){return new o(w)})},delete:function(r){return d(indexedDB,'deleteDatabase',[r])}};a.exports=q,a.exports.default=a.exports;})();});

var ErrorStackParser = {parse:()=>[]};

function isInstance(a,b){const c=Object.keys(a).pop();a[c]instanceof b||throwError(`The '${c}' parameter must be an instance of
      '${b.name}'`);}function isType(a,b){const c=Object.keys(a).pop(),d=typeof a[c];d!==b&&throwError(`The '${c}' parameter has the wrong type. (Expected:
      ${b}, actual: ${d})`);}function isArrayOfType(a,b){const c=Object.keys(a).pop(),d=`The '${c}' parameter should be an array containing
    one or more '${b}' elements.`;Array.isArray(a[c])||throwError(d);for(let e of a[c])typeof e!==b&&throwError(d);}function throwError(a){a=a.replace(/\s+/g,' ');const b=new Error(a);b.name='assertion-failed';const c=ErrorStackParser.parse(b);throw 3<=c.length&&(b.message=`Invalid call to ${c[2].functionName}() — `+a),b}

class LogGroup{constructor(){this._logs=[],this._childGroups=[],this._isFallbackMode=!1;const a=/Firefox\/(\d*)\.\d*/.exec(navigator.userAgent);if(a)try{const b=parseInt(a[1],10);55>b&&(this._isFallbackMode=!0);}catch(b){this._isFallbackMode=!0;}/Edge\/\d*\.\d*/.exec(navigator.userAgent)&&(this._isFallbackMode=!0);}addPrimaryLog(a){this._primaryLog=a;}addLog(a){this._logs.push(a);}addChildGroup(a){0===a._logs.length||this._childGroups.push(a);}print(){return 0===this._logs.length&&0===this._childGroups.length?void this._printLogDetails(this._primaryLog):void(this._primaryLog&&(this._isFallbackMode?this._printLogDetails(this._primaryLog):console.groupCollapsed(...this._getLogContent(this._primaryLog))),this._logs.forEach((a)=>{this._printLogDetails(a);}),this._childGroups.forEach((a)=>{a.print();}),this._primaryLog&&!this._isFallbackMode&&console.groupEnd())}_printLogDetails(a){const b=a.logFunc?a.logFunc:console.log;b(...this._getLogContent(a));}_getLogContent(a){let b=a.message;this._isFallbackMode&&'string'==typeof b&&(b=b.replace(/%c/g,''));let c=[b];return!this._isFallbackMode&&a.colors&&(c=c.concat(a.colors)),a.args&&(c=c.concat(a.args)),c}}

function isDevBuild(){return`dev`==`prod`}

self.workbox=self.workbox||{},self.workbox.LOG_LEVEL=self.workbox.LOG_LEVEL||{none:-1,verbose:0,debug:1,warn:2,error:3};const LIGHT_GREY=`#bdc3c7`; const DARK_GREY=`#7f8c8d`; const LIGHT_GREEN=`#2ecc71`; const LIGHT_YELLOW=`#f1c40f`; const LIGHT_RED=`#e74c3c`; const LIGHT_BLUE=`#3498db`;class LogHelper{constructor(){this._defaultLogLevel=isDevBuild()?self.workbox.LOG_LEVEL.debug:self.workbox.LOG_LEVEL.warn;}log(a){this._printMessage(self.workbox.LOG_LEVEL.verbose,a);}debug(a){this._printMessage(self.workbox.LOG_LEVEL.debug,a);}warn(a){this._printMessage(self.workbox.LOG_LEVEL.warn,a);}error(a){this._printMessage(self.workbox.LOG_LEVEL.error,a);}_printMessage(a,b){if(this._shouldLogMessage(a,b)){const c=this._getAllLogGroups(a,b);c.print();}}_getAllLogGroups(a,b){const c=new LogGroup,d=this._getPrimaryMessageDetails(a,b);if(c.addPrimaryLog(d),b.error){const f={message:b.error,logFunc:console.error};c.addLog(f);}const e=new LogGroup;if(b.that&&b.that.constructor&&b.that.constructor.name){const f=b.that.constructor.name;e.addLog(this._getKeyValueDetails('class',f));}return b.data&&('object'!=typeof b.data||b.data instanceof Array?e.addLog(this._getKeyValueDetails('additionalData',b.data)):Object.keys(b.data).forEach((f)=>{e.addLog(this._getKeyValueDetails(f,b.data[f]));})),c.addChildGroup(e),c}_getKeyValueDetails(a,b){return{message:`%c${a}: `,colors:[`color: ${LIGHT_BLUE}`],args:b}}_getPrimaryMessageDetails(a,b){let c,d;a===self.workbox.LOG_LEVEL.verbose?(c='Info',d=LIGHT_GREY):a===self.workbox.LOG_LEVEL.debug?(c='Debug',d=LIGHT_GREEN):a===self.workbox.LOG_LEVEL.warn?(c='Warn',d=LIGHT_YELLOW):a===self.workbox.LOG_LEVEL.error?(c='Error',d=LIGHT_RED):void 0;let e=`%c🔧 %c[${c}]`;const f=[`color: ${LIGHT_GREY}`,`color: ${d}`];let g;return'string'==typeof b?g=b:b.message&&(g=b.message),g&&(g=g.replace(/\s+/g,' '),e+=`%c ${g}`,f.push(`color: ${DARK_GREY}; font-weight: normal`)),{message:e,colors:f}}_shouldLogMessage(a,b){if(!b)return!1;let c=this._defaultLogLevel;return self&&self.workbox&&'number'==typeof self.workbox.logLevel&&(c=self.workbox.logLevel),c===self.workbox.LOG_LEVEL.none||a<c?!1:!0}}var logHelper = new LogHelper;

class ErrorFactory$1{constructor(a){this._errors=a;}createError(a,b){if(!(a in this._errors))throw new Error(`Unable to generate error '${a}'.`);let c=this._errors[a].replace(/\s+/g,' '),d=null;b&&(c+=` [${b.message}]`,d=b.stack);const e=new Error;return e.name=a,e.message=c,e.stack=d,e}}

const errors={"max-entries-or-age-required":`Either the maxEntries or maxAgeSeconds
    parameters (or both) are required when constructing Plugin.`,"max-entries-must-be-number":`The maxEntries parameter to the Plugin
    constructor must either be a number or undefined.`,"max-age-seconds-must-be-number":`The maxAgeSeconds parameter to the Plugin
    constructor must either be a number or undefined.`};var ErrorFactory = new ErrorFactory$1(errors);

class CacheExpiration{constructor({maxEntries:a,maxAgeSeconds:b}={}){if(!(a||b))throw ErrorFactory.createError('max-entries-or-age-required');if(a&&'number'!=typeof a)throw ErrorFactory.createError('max-entries-must-be-number');if(b&&'number'!=typeof b)throw ErrorFactory.createError('max-age-seconds-must-be-number');this.maxEntries=a,this.maxAgeSeconds=b,this._dbs=new Map,this._caches=new Map,this._expirationMutex=!1,this._timestampForNextRun=null;}async getDB({cacheName:a}={}){isType({cacheName:a},'string');const b=`${idbName}-${a}`;if(!this._dbs.has(b)){const c=await idb.open(b,idbVersion,(d)=>{const e=d.createObjectStore(a,{keyPath:urlPropertyName});e.createIndex(timestampPropertyName,timestampPropertyName,{unique:!1});});this._dbs.set(b,c);}return this._dbs.get(b)}async getCache({cacheName:a}={}){if(isType({cacheName:a},'string'),!this._caches.has(a)){const b=await caches.open(a);this._caches.set(a,b);}return this._caches.get(a)}isResponseFresh({cacheName:a,cachedResponse:b,now:c}={}){if(b&&this.maxAgeSeconds){isInstance({cachedResponse:b},Response);const d=b.headers.get('date');if(d){'undefined'==typeof c&&(c=Date.now());const e=new Date(d),f=e.getTime();return!!isNaN(f)||f+1e3*this.maxAgeSeconds>c}return this.expireEntries({cacheName:a,now:c}),!0}return!0}async updateTimestamp({cacheName:a,url:b,now:c}={}){isType({url:b},'string'),isType({cacheName:a},'string');const d=new URL(b,location);d.hash='','undefined'==typeof c&&(c=Date.now());const e=await this.getDB({cacheName:a}),f=e.transaction(a,'readwrite');f.objectStore(a).put({[timestampPropertyName]:c,[urlPropertyName]:d.href}),await f.complete;}async expireEntries({cacheName:a,now:b}={}){if(this._expirationMutex)return void(this._timestampForNextRun=b);this._expirationMutex=!0,isType({cacheName:a},'string'),'undefined'==typeof b&&(b=Date.now());const c=this.maxAgeSeconds?await this.findOldEntries({cacheName:a,now:b}):[],d=this.maxEntries?await this.findExtraEntries({cacheName:a}):[],e=[...new Set(c.concat(d))];if(await this.deleteFromCacheAndIDB({cacheName:a,urls:e}),0<e.length&&logHelper.debug({that:this,message:'Expired entries have been removed from the cache.',data:{cacheName:a,urls:e}}),this._expirationMutex=!1,this._timestampForNextRun){const f=this._timestampForNextRun;return this._timestampForNextRun=null,this.expireEntries({cacheName:a,now:f})}}async findOldEntries({cacheName:a,now:b}={}){isType({cacheName:a},'string'),isType({now:b},'number');const c=b-1e3*this.maxAgeSeconds,d=[],e=await this.getDB({cacheName:a}),f=e.transaction(a,'readonly'),g=f.objectStore(a),h=g.index(timestampPropertyName);return h.iterateCursor((i)=>{i&&(i.value[timestampPropertyName]<c&&d.push(i.value[urlPropertyName]),i.continue());}),await f.complete,d}async findExtraEntries({cacheName:a}={}){isType({cacheName:a},'string');const b=[],c=await this.getDB({cacheName:a});let d=c.transaction(a,'readonly'),e=d.objectStore(a),f=e.index(timestampPropertyName);const g=await f.count();return g>this.maxEntries&&(d=c.transaction(a,'readonly'),e=d.objectStore(a),f=e.index(timestampPropertyName),f.iterateCursor((h)=>{h&&(b.push(h.value[urlPropertyName]),g-b.length>this.maxEntries&&h.continue());})),await d.complete,b}async deleteFromCacheAndIDB({cacheName:a,urls:b}={}){if(isType({cacheName:a},'string'),isArrayOfType({urls:b},'string'),0<b.length){const c=await this.getCache({cacheName:a}),d=await this.getDB({cacheName:a});for(let e of b){await c.delete(e);const f=d.transaction(a,'readwrite'),g=f.objectStore(a);g.delete(e),await f.complete;}}}}

class CacheExpirationPlugin extends CacheExpiration{cachedResponseWillBeUsed({cacheName:a,cachedResponse:b,now:c}={}){return this.isResponseFresh({cacheName:a,cachedResponse:b,now:c})?b:null}async cacheDidUpdate({cacheName:a,newResponse:b,url:c,now:d}={}){isType({cacheName:a},'string'),isInstance({newResponse:b},Response),'undefined'==typeof d&&(d=Date.now()),await this.updateTimestamp({cacheName:a,url:c,now:d}),await this.expireEntries({cacheName:a,now:d});}}

exports.timestampPropertyName = timestampPropertyName;
exports.urlPropertyName = urlPropertyName;
exports.CacheExpiration = CacheExpiration;
exports.CacheExpirationPlugin = CacheExpirationPlugin;

}((this.workbox.cacheExpiration = this.workbox.cacheExpiration || {})));
//# sourceMappingURL=workbox-cache-expiration.prod.v2.0.0.js.map
