<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Coursecompleted access plugin settings and presets.
 *
 * @package   enrol_coursecompleted
 * @copyright eWallah (www.eWallah.net)
 * @author    Renaat Debleu <info@eWallah.net>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

if ($ADMIN->fulltree) {
    $plugin = 'enrol_coursecompleted';

    $settings->add(
        new admin_setting_heading(
            $plugin . '_settings',
            '',
            get_string('pluginname_desc', $plugin)
        )
    );

    $settings->add(
        new admin_setting_heading(
            $plugin . '_defaults',
            get_string('enrolinstancedefaults', 'admin'),
            get_string('enrolinstancedefaults_desc', 'admin'),
        )
    );

    $settings->add(
        new admin_setting_configcheckbox(
            "{$plugin}/defaultenrol",
            get_string('defaultenrol', 'enrol'),
            get_string('defaultenrol_desc', 'enrol'),
            0
        )
    );

    if (!during_initial_install()) {
        $roptions = [
            ENROL_EXT_REMOVED_KEEP => get_string('extremovedkeep', 'enrol'),
            ENROL_EXT_REMOVED_SUSPENDNOROLES => get_string('extremovedsuspendnoroles', 'enrol'),
            ENROL_EXT_REMOVED_UNENROL => get_string('extremovedunenrol', 'enrol'),
        ];

        $options = get_default_enrol_roles(context_system::instance());
        $student = get_archetype_roles('student');
        $student = reset($student);

        $settings->add(
            new admin_setting_configselect(
                name: "{$plugin}/expiredaction",
                visiblename: get_string(identifier: 'expiredaction', component: $plugin),
                description: get_string(identifier: 'expiredaction_help', component: $plugin),
                defaultsetting: ENROL_EXT_REMOVED_SUSPENDNOROLES,
                choices: $roptions
            )
        );

        $settings->add(
            new admin_setting_configselect(
                name: "{$plugin}/roleid",
                visiblename: get_string(identifier: 'defaultrole', component: $plugin),
                description: get_string(identifier: 'defaultrole_desc', component: $plugin),
                defaultsetting: $student->id,
                choices: $options
            )
        );
    }

    $settings->add(
        new admin_setting_configduration(
            "{$plugin}/enrolperiod",
            get_string('enrolperiod', $plugin),
            get_string('enrolperiod_desc', $plugin),
            0
        )
    );

    $settings->add(
        new admin_setting_configcheckbox(
            "{$plugin}/tryunenrol",
            get_string('tryunenrol', $plugin),
            get_string('tryunenrol_help', $plugin),
            0
        )
    );

    $settings->add(
        new admin_setting_configselect(
            name: "{$plugin}/welcome",
            visiblename: get_string(identifier: 'welcome', component: $plugin),
            description: get_string(identifier: 'welcome_help', component: $plugin),
            defaultsetting: ENROL_SEND_EMAIL_FROM_COURSE_CONTACT,
            choices: enrol_coursecompleted_plugin::email_options()
        )
    );

    $settings->add(
        new admin_setting_configcheckbox(
            "{$plugin}/svglearnpath",
            get_string('svglearnpath', $plugin),
            get_string('svglearnpath_help', $plugin),
            1
        )
    );

    $settings->add(
        new admin_setting_configcheckbox(
            "{$plugin}/keepgroup",
            get_string('keepgroup', $plugin),
            get_string('keepgroup_help', $plugin),
            1
        )
    );
}
