<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The banner rule updated event.
 *
 * @package    local_categorybanner
 * @copyright  2025 Your Name <your@email.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace local_categorybanner\event;

defined('MOODLE_INTERNAL') || die();

/**
 * The banner rule updated event class.
 *
 * @property-read array $other {
 *      Extra information about the event.
 *
 *      - int categoryid: The ID of the category this banner belongs to
 *      - bool global: Whether this is a global banner
 *      - bool subcategories: Whether this banner applies to subcategories
 * }
 *
 * @package    local_categorybanner
 * @copyright  2025 Your Name <your@email.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class banner_rule_updated extends \core\event\base {

    /**
     * Init method.
     *
     * @return void
     */
    protected function init() {
        $this->data['crud'] = 'u';
        $this->data['edulevel'] = self::LEVEL_OTHER;
    }

    /**
     * Returns description of what happened.
     *
     * @return string
     */
    public function get_description() {
        if ($this->other['global']) {
            return "The user with id '{$this->userid}' updated the global banner rule with id '{$this->objectid}'.";
        }
        return "The user with id '{$this->userid}' updated the banner rule with id '{$this->objectid}' for category with id '{$this->other['categoryid']}'.";
    }

    /**
     * Return localised event name.
     *
     * @return string
     */
    public static function get_name() {
        return get_string('eventbannerruleupdated', 'local_categorybanner');
    }

    /**
     * Get URL related to the action.
     *
     * @return \moodle_url
     */
    public function get_url() {
        return new \moodle_url('/local/categorybanner/edit_rule.php', array('id' => $this->objectid));
    }

    /**
     * Custom validation.
     *
     * @throws \coding_exception
     * @return void
     */
    protected function validate_data() {
        parent::validate_data();

        if (!isset($this->other['categoryid'])) {
            throw new \coding_exception('The \'categoryid\' value must be set in other.');
        }
        if (!isset($this->other['global'])) {
            throw new \coding_exception('The \'global\' value must be set in other.');
        }
        if (!isset($this->other['subcategories'])) {
            throw new \coding_exception('The \'subcategories\' value must be set in other.');
        }
    }

    /**
     * Get backup/restore mappings.
     *
     * @return array
     */
    public static function get_objectid_mapping() {
        return array('db' => 'local_categorybanner', 'restore' => 'local_categorybanner');
    }
}
