define("local_pg/beautifier",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.beautify=void 0;var hasRequiredOutput,js={exports:{}},src={},javascript={exports:{}},beautifier$2={},output={};function requireOutput(){if(hasRequiredOutput)return output;function OutputLine(parent){this.__parent=parent,this.__character_count=0,this.__indent_count=-1,this.__alignment_count=0,this.__wrap_point_index=0,this.__wrap_point_character_count=0,this.__wrap_point_indent_count=-1,this.__wrap_point_alignment_count=0,this.__items=[]}function IndentStringCache(options,baseIndentString){this.__cache=[""],this.__indent_size=options.indent_size,this.__indent_string=options.indent_char,options.indent_with_tabs||(this.__indent_string=new Array(options.indent_size+1).join(options.indent_char)),baseIndentString=baseIndentString||"",options.indent_level>0&&(baseIndentString=new Array(options.indent_level+1).join(this.__indent_string)),this.__base_string=baseIndentString,this.__base_string_length=baseIndentString.length}function Output(options,baseIndentString){this.__indent_cache=new IndentStringCache(options,baseIndentString),this.raw=!1,this._end_with_newline=options.end_with_newline,this.indent_size=options.indent_size,this.wrap_line_length=options.wrap_line_length,this.indent_empty_lines=options.indent_empty_lines,this.__lines=[],this.previous_line=null,this.current_line=null,this.next_line=new OutputLine(this),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1,this.__add_outputline()}return hasRequiredOutput=1,OutputLine.prototype.clone_empty=function(){var line=new OutputLine(this.__parent);return line.set_indent(this.__indent_count,this.__alignment_count),line},OutputLine.prototype.item=function(index){return index<0?this.__items[this.__items.length+index]:this.__items[index]},OutputLine.prototype.has_match=function(pattern){for(var lastCheckedOutput=this.__items.length-1;lastCheckedOutput>=0;lastCheckedOutput--)if(this.__items[lastCheckedOutput].match(pattern))return!0;return!1},OutputLine.prototype.set_indent=function(indent,alignment){this.is_empty()&&(this.__indent_count=indent||0,this.__alignment_count=alignment||0,this.__character_count=this.__parent.get_indent_size(this.__indent_count,this.__alignment_count))},OutputLine.prototype._set_wrap_point=function(){this.__parent.wrap_line_length&&(this.__wrap_point_index=this.__items.length,this.__wrap_point_character_count=this.__character_count,this.__wrap_point_indent_count=this.__parent.next_line.__indent_count,this.__wrap_point_alignment_count=this.__parent.next_line.__alignment_count)},OutputLine.prototype._should_wrap=function(){return this.__wrap_point_index&&this.__character_count>this.__parent.wrap_line_length&&this.__wrap_point_character_count>this.__parent.next_line.__character_count},OutputLine.prototype._allow_wrap=function(){if(this._should_wrap()){this.__parent.add_new_line();var next=this.__parent.current_line;return next.set_indent(this.__wrap_point_indent_count,this.__wrap_point_alignment_count),next.__items=this.__items.slice(this.__wrap_point_index),this.__items=this.__items.slice(0,this.__wrap_point_index),next.__character_count+=this.__character_count-this.__wrap_point_character_count,this.__character_count=this.__wrap_point_character_count," "===next.__items[0]&&(next.__items.splice(0,1),next.__character_count-=1),!0}return!1},OutputLine.prototype.is_empty=function(){return 0===this.__items.length},OutputLine.prototype.last=function(){return this.is_empty()?null:this.__items[this.__items.length-1]},OutputLine.prototype.push=function(item){this.__items.push(item);var last_newline_index=item.lastIndexOf("\n");-1!==last_newline_index?this.__character_count=item.length-last_newline_index:this.__character_count+=item.length},OutputLine.prototype.pop=function(){var item=null;return this.is_empty()||(item=this.__items.pop(),this.__character_count-=item.length),item},OutputLine.prototype._remove_indent=function(){this.__indent_count>0&&(this.__indent_count-=1,this.__character_count-=this.__parent.indent_size)},OutputLine.prototype._remove_wrap_indent=function(){this.__wrap_point_indent_count>0&&(this.__wrap_point_indent_count-=1)},OutputLine.prototype.trim=function(){for(;" "===this.last();)this.__items.pop(),this.__character_count-=1},OutputLine.prototype.toString=function(){var result="";return this.is_empty()?this.__parent.indent_empty_lines&&(result=this.__parent.get_indent_string(this.__indent_count)):(result=this.__parent.get_indent_string(this.__indent_count,this.__alignment_count),result+=this.__items.join("")),result},IndentStringCache.prototype.get_indent_size=function(indent,column){var result=this.__base_string_length;return column=column||0,indent<0&&(result=0),result+=indent*this.__indent_size,result+=column},IndentStringCache.prototype.get_indent_string=function(indent_level,column){var result=this.__base_string;return column=column||0,indent_level<0&&(indent_level=0,result=""),column+=indent_level*this.__indent_size,this.__ensure_cache(column),result+=this.__cache[column]},IndentStringCache.prototype.__ensure_cache=function(column){for(;column>=this.__cache.length;)this.__add_column()},IndentStringCache.prototype.__add_column=function(){var column=this.__cache.length,indent=0,result="";this.__indent_size&&column>=this.__indent_size&&(column-=(indent=Math.floor(column/this.__indent_size))*this.__indent_size,result=new Array(indent+1).join(this.__indent_string)),column&&(result+=new Array(column+1).join(" ")),this.__cache.push(result)},Output.prototype.__add_outputline=function(){this.previous_line=this.current_line,this.current_line=this.next_line.clone_empty(),this.__lines.push(this.current_line)},Output.prototype.get_line_number=function(){return this.__lines.length},Output.prototype.get_indent_string=function(indent,column){return this.__indent_cache.get_indent_string(indent,column)},Output.prototype.get_indent_size=function(indent,column){return this.__indent_cache.get_indent_size(indent,column)},Output.prototype.is_empty=function(){return!this.previous_line&&this.current_line.is_empty()},Output.prototype.add_new_line=function(force_newline){return!(this.is_empty()||!force_newline&&this.just_added_newline())&&(this.raw||this.__add_outputline(),!0)},Output.prototype.get_code=function(eol){this.trim(!0);var last_item=this.current_line.pop();last_item&&("\n"===last_item[last_item.length-1]&&(last_item=last_item.replace(/\n+$/g,"")),this.current_line.push(last_item)),this._end_with_newline&&this.__add_outputline();var sweet_code=this.__lines.join("\n");return"\n"!==eol&&(sweet_code=sweet_code.replace(/[\n]/g,eol)),sweet_code},Output.prototype.set_wrap_point=function(){this.current_line._set_wrap_point()},Output.prototype.set_indent=function(indent,alignment){return indent=indent||0,alignment=alignment||0,this.next_line.set_indent(indent,alignment),this.__lines.length>1?(this.current_line.set_indent(indent,alignment),!0):(this.current_line.set_indent(),!1)},Output.prototype.add_raw_token=function(token){for(var x=0;x<token.newlines;x++)this.__add_outputline();this.current_line.set_indent(-1),this.current_line.push(token.whitespace_before),this.current_line.push(token.text),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1},Output.prototype.add_token=function(printable_token){this.__add_space_before_token(),this.current_line.push(printable_token),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=this.current_line._allow_wrap()},Output.prototype.__add_space_before_token=function(){this.space_before_token&&!this.just_added_newline()&&(this.non_breaking_space||this.set_wrap_point(),this.current_line.push(" "))},Output.prototype.remove_indent=function(index){for(var output_length=this.__lines.length;index<output_length;)this.__lines[index]._remove_indent(),index++;this.current_line._remove_wrap_indent()},Output.prototype.trim=function(eat_newlines){for(eat_newlines=void 0!==eat_newlines&&eat_newlines,this.current_line.trim();eat_newlines&&this.__lines.length>1&&this.current_line.is_empty();)this.__lines.pop(),this.current_line=this.__lines[this.__lines.length-1],this.current_line.trim();this.previous_line=this.__lines.length>1?this.__lines[this.__lines.length-2]:null},Output.prototype.just_added_newline=function(){return this.current_line.is_empty()},Output.prototype.just_added_blankline=function(){return this.is_empty()||this.current_line.is_empty()&&this.previous_line.is_empty()},Output.prototype.ensure_empty_line_above=function(starts_with,ends_with){for(var index=this.__lines.length-2;index>=0;){var potentialEmptyLine=this.__lines[index];if(potentialEmptyLine.is_empty())break;if(0!==potentialEmptyLine.item(0).indexOf(starts_with)&&potentialEmptyLine.item(-1)!==ends_with){this.__lines.splice(index+1,0,new OutputLine(this)),this.previous_line=this.__lines[this.__lines.length-2];break}index--}},output.Output=Output,output}var hasRequiredToken,token={};function requireToken(){if(hasRequiredToken)return token;return hasRequiredToken=1,token.Token=function(type,text,newlines,whitespace_before){this.type=type,this.text=text,this.comments_before=null,this.newlines=newlines||0,this.whitespace_before=whitespace_before||"",this.parent=null,this.next=null,this.previous=null,this.opened=null,this.closed=null,this.directives=null},token}var hasRequiredAcorn,acorn={};function requireAcorn(){return hasRequiredAcorn||(hasRequiredAcorn=1,nonASCIIidentifierChars="\\u0300-\\u036f\\u0483-\\u0487\\u0591-\\u05bd\\u05bf\\u05c1\\u05c2\\u05c4\\u05c5\\u05c7\\u0610-\\u061a\\u0620-\\u0649\\u0672-\\u06d3\\u06e7-\\u06e8\\u06fb-\\u06fc\\u0730-\\u074a\\u0800-\\u0814\\u081b-\\u0823\\u0825-\\u0827\\u0829-\\u082d\\u0840-\\u0857\\u08e4-\\u08fe\\u0900-\\u0903\\u093a-\\u093c\\u093e-\\u094f\\u0951-\\u0957\\u0962-\\u0963\\u0966-\\u096f\\u0981-\\u0983\\u09bc\\u09be-\\u09c4\\u09c7\\u09c8\\u09d7\\u09df-\\u09e0\\u0a01-\\u0a03\\u0a3c\\u0a3e-\\u0a42\\u0a47\\u0a48\\u0a4b-\\u0a4d\\u0a51\\u0a66-\\u0a71\\u0a75\\u0a81-\\u0a83\\u0abc\\u0abe-\\u0ac5\\u0ac7-\\u0ac9\\u0acb-\\u0acd\\u0ae2-\\u0ae3\\u0ae6-\\u0aef\\u0b01-\\u0b03\\u0b3c\\u0b3e-\\u0b44\\u0b47\\u0b48\\u0b4b-\\u0b4d\\u0b56\\u0b57\\u0b5f-\\u0b60\\u0b66-\\u0b6f\\u0b82\\u0bbe-\\u0bc2\\u0bc6-\\u0bc8\\u0bca-\\u0bcd\\u0bd7\\u0be6-\\u0bef\\u0c01-\\u0c03\\u0c46-\\u0c48\\u0c4a-\\u0c4d\\u0c55\\u0c56\\u0c62-\\u0c63\\u0c66-\\u0c6f\\u0c82\\u0c83\\u0cbc\\u0cbe-\\u0cc4\\u0cc6-\\u0cc8\\u0cca-\\u0ccd\\u0cd5\\u0cd6\\u0ce2-\\u0ce3\\u0ce6-\\u0cef\\u0d02\\u0d03\\u0d46-\\u0d48\\u0d57\\u0d62-\\u0d63\\u0d66-\\u0d6f\\u0d82\\u0d83\\u0dca\\u0dcf-\\u0dd4\\u0dd6\\u0dd8-\\u0ddf\\u0df2\\u0df3\\u0e34-\\u0e3a\\u0e40-\\u0e45\\u0e50-\\u0e59\\u0eb4-\\u0eb9\\u0ec8-\\u0ecd\\u0ed0-\\u0ed9\\u0f18\\u0f19\\u0f20-\\u0f29\\u0f35\\u0f37\\u0f39\\u0f41-\\u0f47\\u0f71-\\u0f84\\u0f86-\\u0f87\\u0f8d-\\u0f97\\u0f99-\\u0fbc\\u0fc6\\u1000-\\u1029\\u1040-\\u1049\\u1067-\\u106d\\u1071-\\u1074\\u1082-\\u108d\\u108f-\\u109d\\u135d-\\u135f\\u170e-\\u1710\\u1720-\\u1730\\u1740-\\u1750\\u1772\\u1773\\u1780-\\u17b2\\u17dd\\u17e0-\\u17e9\\u180b-\\u180d\\u1810-\\u1819\\u1920-\\u192b\\u1930-\\u193b\\u1951-\\u196d\\u19b0-\\u19c0\\u19c8-\\u19c9\\u19d0-\\u19d9\\u1a00-\\u1a15\\u1a20-\\u1a53\\u1a60-\\u1a7c\\u1a7f-\\u1a89\\u1a90-\\u1a99\\u1b46-\\u1b4b\\u1b50-\\u1b59\\u1b6b-\\u1b73\\u1bb0-\\u1bb9\\u1be6-\\u1bf3\\u1c00-\\u1c22\\u1c40-\\u1c49\\u1c5b-\\u1c7d\\u1cd0-\\u1cd2\\u1d00-\\u1dbe\\u1e01-\\u1f15\\u200c\\u200d\\u203f\\u2040\\u2054\\u20d0-\\u20dc\\u20e1\\u20e5-\\u20f0\\u2d81-\\u2d96\\u2de0-\\u2dff\\u3021-\\u3028\\u3099\\u309a\\ua640-\\ua66d\\ua674-\\ua67d\\ua69f\\ua6f0-\\ua6f1\\ua7f8-\\ua800\\ua806\\ua80b\\ua823-\\ua827\\ua880-\\ua881\\ua8b4-\\ua8c4\\ua8d0-\\ua8d9\\ua8f3-\\ua8f7\\ua900-\\ua909\\ua926-\\ua92d\\ua930-\\ua945\\ua980-\\ua983\\ua9b3-\\ua9c0\\uaa00-\\uaa27\\uaa40-\\uaa41\\uaa4c-\\uaa4d\\uaa50-\\uaa59\\uaa7b\\uaae0-\\uaae9\\uaaf2-\\uaaf3\\uabc0-\\uabe1\\uabec\\uabed\\uabf0-\\uabf9\\ufb20-\\ufb28\\ufe00-\\ufe0f\\ufe20-\\ufe26\\ufe33\\ufe34\\ufe4d-\\ufe4f\\uff10-\\uff19\\uff3f",identifierStart="(?:\\\\u[0-9a-fA-F]{4}|\\\\u\\{[0-9a-fA-F]+\\}|[\\x23\\x24\\x40\\x41-\\x5a\\x5f\\x61-\\x7a"+(nonASCIIidentifierStartChars="\\xaa\\xb5\\xba\\xc0-\\xd6\\xd8-\\xf6\\xf8-\\u02c1\\u02c6-\\u02d1\\u02e0-\\u02e4\\u02ec\\u02ee\\u0370-\\u0374\\u0376\\u0377\\u037a-\\u037d\\u0386\\u0388-\\u038a\\u038c\\u038e-\\u03a1\\u03a3-\\u03f5\\u03f7-\\u0481\\u048a-\\u0527\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05d0-\\u05ea\\u05f0-\\u05f2\\u0620-\\u064a\\u066e\\u066f\\u0671-\\u06d3\\u06d5\\u06e5\\u06e6\\u06ee\\u06ef\\u06fa-\\u06fc\\u06ff\\u0710\\u0712-\\u072f\\u074d-\\u07a5\\u07b1\\u07ca-\\u07ea\\u07f4\\u07f5\\u07fa\\u0800-\\u0815\\u081a\\u0824\\u0828\\u0840-\\u0858\\u08a0\\u08a2-\\u08ac\\u0904-\\u0939\\u093d\\u0950\\u0958-\\u0961\\u0971-\\u0977\\u0979-\\u097f\\u0985-\\u098c\\u098f\\u0990\\u0993-\\u09a8\\u09aa-\\u09b0\\u09b2\\u09b6-\\u09b9\\u09bd\\u09ce\\u09dc\\u09dd\\u09df-\\u09e1\\u09f0\\u09f1\\u0a05-\\u0a0a\\u0a0f\\u0a10\\u0a13-\\u0a28\\u0a2a-\\u0a30\\u0a32\\u0a33\\u0a35\\u0a36\\u0a38\\u0a39\\u0a59-\\u0a5c\\u0a5e\\u0a72-\\u0a74\\u0a85-\\u0a8d\\u0a8f-\\u0a91\\u0a93-\\u0aa8\\u0aaa-\\u0ab0\\u0ab2\\u0ab3\\u0ab5-\\u0ab9\\u0abd\\u0ad0\\u0ae0\\u0ae1\\u0b05-\\u0b0c\\u0b0f\\u0b10\\u0b13-\\u0b28\\u0b2a-\\u0b30\\u0b32\\u0b33\\u0b35-\\u0b39\\u0b3d\\u0b5c\\u0b5d\\u0b5f-\\u0b61\\u0b71\\u0b83\\u0b85-\\u0b8a\\u0b8e-\\u0b90\\u0b92-\\u0b95\\u0b99\\u0b9a\\u0b9c\\u0b9e\\u0b9f\\u0ba3\\u0ba4\\u0ba8-\\u0baa\\u0bae-\\u0bb9\\u0bd0\\u0c05-\\u0c0c\\u0c0e-\\u0c10\\u0c12-\\u0c28\\u0c2a-\\u0c33\\u0c35-\\u0c39\\u0c3d\\u0c58\\u0c59\\u0c60\\u0c61\\u0c85-\\u0c8c\\u0c8e-\\u0c90\\u0c92-\\u0ca8\\u0caa-\\u0cb3\\u0cb5-\\u0cb9\\u0cbd\\u0cde\\u0ce0\\u0ce1\\u0cf1\\u0cf2\\u0d05-\\u0d0c\\u0d0e-\\u0d10\\u0d12-\\u0d3a\\u0d3d\\u0d4e\\u0d60\\u0d61\\u0d7a-\\u0d7f\\u0d85-\\u0d96\\u0d9a-\\u0db1\\u0db3-\\u0dbb\\u0dbd\\u0dc0-\\u0dc6\\u0e01-\\u0e30\\u0e32\\u0e33\\u0e40-\\u0e46\\u0e81\\u0e82\\u0e84\\u0e87\\u0e88\\u0e8a\\u0e8d\\u0e94-\\u0e97\\u0e99-\\u0e9f\\u0ea1-\\u0ea3\\u0ea5\\u0ea7\\u0eaa\\u0eab\\u0ead-\\u0eb0\\u0eb2\\u0eb3\\u0ebd\\u0ec0-\\u0ec4\\u0ec6\\u0edc-\\u0edf\\u0f00\\u0f40-\\u0f47\\u0f49-\\u0f6c\\u0f88-\\u0f8c\\u1000-\\u102a\\u103f\\u1050-\\u1055\\u105a-\\u105d\\u1061\\u1065\\u1066\\u106e-\\u1070\\u1075-\\u1081\\u108e\\u10a0-\\u10c5\\u10c7\\u10cd\\u10d0-\\u10fa\\u10fc-\\u1248\\u124a-\\u124d\\u1250-\\u1256\\u1258\\u125a-\\u125d\\u1260-\\u1288\\u128a-\\u128d\\u1290-\\u12b0\\u12b2-\\u12b5\\u12b8-\\u12be\\u12c0\\u12c2-\\u12c5\\u12c8-\\u12d6\\u12d8-\\u1310\\u1312-\\u1315\\u1318-\\u135a\\u1380-\\u138f\\u13a0-\\u13f4\\u1401-\\u166c\\u166f-\\u167f\\u1681-\\u169a\\u16a0-\\u16ea\\u16ee-\\u16f0\\u1700-\\u170c\\u170e-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176c\\u176e-\\u1770\\u1780-\\u17b3\\u17d7\\u17dc\\u1820-\\u1877\\u1880-\\u18a8\\u18aa\\u18b0-\\u18f5\\u1900-\\u191c\\u1950-\\u196d\\u1970-\\u1974\\u1980-\\u19ab\\u19c1-\\u19c7\\u1a00-\\u1a16\\u1a20-\\u1a54\\u1aa7\\u1b05-\\u1b33\\u1b45-\\u1b4b\\u1b83-\\u1ba0\\u1bae\\u1baf\\u1bba-\\u1be5\\u1c00-\\u1c23\\u1c4d-\\u1c4f\\u1c5a-\\u1c7d\\u1ce9-\\u1cec\\u1cee-\\u1cf1\\u1cf5\\u1cf6\\u1d00-\\u1dbf\\u1e00-\\u1f15\\u1f18-\\u1f1d\\u1f20-\\u1f45\\u1f48-\\u1f4d\\u1f50-\\u1f57\\u1f59\\u1f5b\\u1f5d\\u1f5f-\\u1f7d\\u1f80-\\u1fb4\\u1fb6-\\u1fbc\\u1fbe\\u1fc2-\\u1fc4\\u1fc6-\\u1fcc\\u1fd0-\\u1fd3\\u1fd6-\\u1fdb\\u1fe0-\\u1fec\\u1ff2-\\u1ff4\\u1ff6-\\u1ffc\\u2071\\u207f\\u2090-\\u209c\\u2102\\u2107\\u210a-\\u2113\\u2115\\u2119-\\u211d\\u2124\\u2126\\u2128\\u212a-\\u212d\\u212f-\\u2139\\u213c-\\u213f\\u2145-\\u2149\\u214e\\u2160-\\u2188\\u2c00-\\u2c2e\\u2c30-\\u2c5e\\u2c60-\\u2ce4\\u2ceb-\\u2cee\\u2cf2\\u2cf3\\u2d00-\\u2d25\\u2d27\\u2d2d\\u2d30-\\u2d67\\u2d6f\\u2d80-\\u2d96\\u2da0-\\u2da6\\u2da8-\\u2dae\\u2db0-\\u2db6\\u2db8-\\u2dbe\\u2dc0-\\u2dc6\\u2dc8-\\u2dce\\u2dd0-\\u2dd6\\u2dd8-\\u2dde\\u2e2f\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303c\\u3041-\\u3096\\u309d-\\u309f\\u30a1-\\u30fa\\u30fc-\\u30ff\\u3105-\\u312d\\u3131-\\u318e\\u31a0-\\u31ba\\u31f0-\\u31ff\\u3400-\\u4db5\\u4e00-\\u9fcc\\ua000-\\ua48c\\ua4d0-\\ua4fd\\ua500-\\ua60c\\ua610-\\ua61f\\ua62a\\ua62b\\ua640-\\ua66e\\ua67f-\\ua697\\ua6a0-\\ua6ef\\ua717-\\ua71f\\ua722-\\ua788\\ua78b-\\ua78e\\ua790-\\ua793\\ua7a0-\\ua7aa\\ua7f8-\\ua801\\ua803-\\ua805\\ua807-\\ua80a\\ua80c-\\ua822\\ua840-\\ua873\\ua882-\\ua8b3\\ua8f2-\\ua8f7\\ua8fb\\ua90a-\\ua925\\ua930-\\ua946\\ua960-\\ua97c\\ua984-\\ua9b2\\ua9cf\\uaa00-\\uaa28\\uaa40-\\uaa42\\uaa44-\\uaa4b\\uaa60-\\uaa76\\uaa7a\\uaa80-\\uaaaf\\uaab1\\uaab5\\uaab6\\uaab9-\\uaabd\\uaac0\\uaac2\\uaadb-\\uaadd\\uaae0-\\uaaea\\uaaf2-\\uaaf4\\uab01-\\uab06\\uab09-\\uab0e\\uab11-\\uab16\\uab20-\\uab26\\uab28-\\uab2e\\uabc0-\\uabe2\\uac00-\\ud7a3\\ud7b0-\\ud7c6\\ud7cb-\\ud7fb\\uf900-\\ufa6d\\ufa70-\\ufad9\\ufb00-\\ufb06\\ufb13-\\ufb17\\ufb1d\\ufb1f-\\ufb28\\ufb2a-\\ufb36\\ufb38-\\ufb3c\\ufb3e\\ufb40\\ufb41\\ufb43\\ufb44\\ufb46-\\ufbb1\\ufbd3-\\ufd3d\\ufd50-\\ufd8f\\ufd92-\\ufdc7\\ufdf0-\\ufdfb\\ufe70-\\ufe74\\ufe76-\\ufefc\\uff21-\\uff3a\\uff41-\\uff5a\\uff66-\\uffbe\\uffc2-\\uffc7\\uffca-\\uffcf\\uffd2-\\uffd7\\uffda-\\uffdc")+"])",(exports=acorn).identifier=new RegExp(identifierStart+"(?:\\\\u[0-9a-fA-F]{4}|\\\\u\\{[0-9a-fA-F]+\\}|[\\x24\\x30-\\x39\\x41-\\x5a\\x5f\\x61-\\x7a\\xaa\\xb5\\xba\\xc0-\\xd6\\xd8-\\xf6\\xf8-\\u02c1\\u02c6-\\u02d1\\u02e0-\\u02e4\\u02ec\\u02ee\\u0370-\\u0374\\u0376\\u0377\\u037a-\\u037d\\u0386\\u0388-\\u038a\\u038c\\u038e-\\u03a1\\u03a3-\\u03f5\\u03f7-\\u0481\\u048a-\\u0527\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05d0-\\u05ea\\u05f0-\\u05f2\\u0620-\\u064a\\u066e\\u066f\\u0671-\\u06d3\\u06d5\\u06e5\\u06e6\\u06ee\\u06ef\\u06fa-\\u06fc\\u06ff\\u0710\\u0712-\\u072f\\u074d-\\u07a5\\u07b1\\u07ca-\\u07ea\\u07f4\\u07f5\\u07fa\\u0800-\\u0815\\u081a\\u0824\\u0828\\u0840-\\u0858\\u08a0\\u08a2-\\u08ac\\u0904-\\u0939\\u093d\\u0950\\u0958-\\u0961\\u0971-\\u0977\\u0979-\\u097f\\u0985-\\u098c\\u098f\\u0990\\u0993-\\u09a8\\u09aa-\\u09b0\\u09b2\\u09b6-\\u09b9\\u09bd\\u09ce\\u09dc\\u09dd\\u09df-\\u09e1\\u09f0\\u09f1\\u0a05-\\u0a0a\\u0a0f\\u0a10\\u0a13-\\u0a28\\u0a2a-\\u0a30\\u0a32\\u0a33\\u0a35\\u0a36\\u0a38\\u0a39\\u0a59-\\u0a5c\\u0a5e\\u0a72-\\u0a74\\u0a85-\\u0a8d\\u0a8f-\\u0a91\\u0a93-\\u0aa8\\u0aaa-\\u0ab0\\u0ab2\\u0ab3\\u0ab5-\\u0ab9\\u0abd\\u0ad0\\u0ae0\\u0ae1\\u0b05-\\u0b0c\\u0b0f\\u0b10\\u0b13-\\u0b28\\u0b2a-\\u0b30\\u0b32\\u0b33\\u0b35-\\u0b39\\u0b3d\\u0b5c\\u0b5d\\u0b5f-\\u0b61\\u0b71\\u0b83\\u0b85-\\u0b8a\\u0b8e-\\u0b90\\u0b92-\\u0b95\\u0b99\\u0b9a\\u0b9c\\u0b9e\\u0b9f\\u0ba3\\u0ba4\\u0ba8-\\u0baa\\u0bae-\\u0bb9\\u0bd0\\u0c05-\\u0c0c\\u0c0e-\\u0c10\\u0c12-\\u0c28\\u0c2a-\\u0c33\\u0c35-\\u0c39\\u0c3d\\u0c58\\u0c59\\u0c60\\u0c61\\u0c85-\\u0c8c\\u0c8e-\\u0c90\\u0c92-\\u0ca8\\u0caa-\\u0cb3\\u0cb5-\\u0cb9\\u0cbd\\u0cde\\u0ce0\\u0ce1\\u0cf1\\u0cf2\\u0d05-\\u0d0c\\u0d0e-\\u0d10\\u0d12-\\u0d3a\\u0d3d\\u0d4e\\u0d60\\u0d61\\u0d7a-\\u0d7f\\u0d85-\\u0d96\\u0d9a-\\u0db1\\u0db3-\\u0dbb\\u0dbd\\u0dc0-\\u0dc6\\u0e01-\\u0e30\\u0e32\\u0e33\\u0e40-\\u0e46\\u0e81\\u0e82\\u0e84\\u0e87\\u0e88\\u0e8a\\u0e8d\\u0e94-\\u0e97\\u0e99-\\u0e9f\\u0ea1-\\u0ea3\\u0ea5\\u0ea7\\u0eaa\\u0eab\\u0ead-\\u0eb0\\u0eb2\\u0eb3\\u0ebd\\u0ec0-\\u0ec4\\u0ec6\\u0edc-\\u0edf\\u0f00\\u0f40-\\u0f47\\u0f49-\\u0f6c\\u0f88-\\u0f8c\\u1000-\\u102a\\u103f\\u1050-\\u1055\\u105a-\\u105d\\u1061\\u1065\\u1066\\u106e-\\u1070\\u1075-\\u1081\\u108e\\u10a0-\\u10c5\\u10c7\\u10cd\\u10d0-\\u10fa\\u10fc-\\u1248\\u124a-\\u124d\\u1250-\\u1256\\u1258\\u125a-\\u125d\\u1260-\\u1288\\u128a-\\u128d\\u1290-\\u12b0\\u12b2-\\u12b5\\u12b8-\\u12be\\u12c0\\u12c2-\\u12c5\\u12c8-\\u12d6\\u12d8-\\u1310\\u1312-\\u1315\\u1318-\\u135a\\u1380-\\u138f\\u13a0-\\u13f4\\u1401-\\u166c\\u166f-\\u167f\\u1681-\\u169a\\u16a0-\\u16ea\\u16ee-\\u16f0\\u1700-\\u170c\\u170e-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176c\\u176e-\\u1770\\u1780-\\u17b3\\u17d7\\u17dc\\u1820-\\u1877\\u1880-\\u18a8\\u18aa\\u18b0-\\u18f5\\u1900-\\u191c\\u1950-\\u196d\\u1970-\\u1974\\u1980-\\u19ab\\u19c1-\\u19c7\\u1a00-\\u1a16\\u1a20-\\u1a54\\u1aa7\\u1b05-\\u1b33\\u1b45-\\u1b4b\\u1b83-\\u1ba0\\u1bae\\u1baf\\u1bba-\\u1be5\\u1c00-\\u1c23\\u1c4d-\\u1c4f\\u1c5a-\\u1c7d\\u1ce9-\\u1cec\\u1cee-\\u1cf1\\u1cf5\\u1cf6\\u1d00-\\u1dbf\\u1e00-\\u1f15\\u1f18-\\u1f1d\\u1f20-\\u1f45\\u1f48-\\u1f4d\\u1f50-\\u1f57\\u1f59\\u1f5b\\u1f5d\\u1f5f-\\u1f7d\\u1f80-\\u1fb4\\u1fb6-\\u1fbc\\u1fbe\\u1fc2-\\u1fc4\\u1fc6-\\u1fcc\\u1fd0-\\u1fd3\\u1fd6-\\u1fdb\\u1fe0-\\u1fec\\u1ff2-\\u1ff4\\u1ff6-\\u1ffc\\u2071\\u207f\\u2090-\\u209c\\u2102\\u2107\\u210a-\\u2113\\u2115\\u2119-\\u211d\\u2124\\u2126\\u2128\\u212a-\\u212d\\u212f-\\u2139\\u213c-\\u213f\\u2145-\\u2149\\u214e\\u2160-\\u2188\\u2c00-\\u2c2e\\u2c30-\\u2c5e\\u2c60-\\u2ce4\\u2ceb-\\u2cee\\u2cf2\\u2cf3\\u2d00-\\u2d25\\u2d27\\u2d2d\\u2d30-\\u2d67\\u2d6f\\u2d80-\\u2d96\\u2da0-\\u2da6\\u2da8-\\u2dae\\u2db0-\\u2db6\\u2db8-\\u2dbe\\u2dc0-\\u2dc6\\u2dc8-\\u2dce\\u2dd0-\\u2dd6\\u2dd8-\\u2dde\\u2e2f\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303c\\u3041-\\u3096\\u309d-\\u309f\\u30a1-\\u30fa\\u30fc-\\u30ff\\u3105-\\u312d\\u3131-\\u318e\\u31a0-\\u31ba\\u31f0-\\u31ff\\u3400-\\u4db5\\u4e00-\\u9fcc\\ua000-\\ua48c\\ua4d0-\\ua4fd\\ua500-\\ua60c\\ua610-\\ua61f\\ua62a\\ua62b\\ua640-\\ua66e\\ua67f-\\ua697\\ua6a0-\\ua6ef\\ua717-\\ua71f\\ua722-\\ua788\\ua78b-\\ua78e\\ua790-\\ua793\\ua7a0-\\ua7aa\\ua7f8-\\ua801\\ua803-\\ua805\\ua807-\\ua80a\\ua80c-\\ua822\\ua840-\\ua873\\ua882-\\ua8b3\\ua8f2-\\ua8f7\\ua8fb\\ua90a-\\ua925\\ua930-\\ua946\\ua960-\\ua97c\\ua984-\\ua9b2\\ua9cf\\uaa00-\\uaa28\\uaa40-\\uaa42\\uaa44-\\uaa4b\\uaa60-\\uaa76\\uaa7a\\uaa80-\\uaaaf\\uaab1\\uaab5\\uaab6\\uaab9-\\uaabd\\uaac0\\uaac2\\uaadb-\\uaadd\\uaae0-\\uaaea\\uaaf2-\\uaaf4\\uab01-\\uab06\\uab09-\\uab0e\\uab11-\\uab16\\uab20-\\uab26\\uab28-\\uab2e\\uabc0-\\uabe2\\uac00-\\ud7a3\\ud7b0-\\ud7c6\\ud7cb-\\ud7fb\\uf900-\\ufa6d\\ufa70-\\ufad9\\ufb00-\\ufb06\\ufb13-\\ufb17\\ufb1d\\ufb1f-\\ufb28\\ufb2a-\\ufb36\\ufb38-\\ufb3c\\ufb3e\\ufb40\\ufb41\\ufb43\\ufb44\\ufb46-\\ufbb1\\ufbd3-\\ufd3d\\ufd50-\\ufd8f\\ufd92-\\ufdc7\\ufdf0-\\ufdfb\\ufe70-\\ufe74\\ufe76-\\ufefc\\uff21-\\uff3a\\uff41-\\uff5a\\uff66-\\uffbe\\uffc2-\\uffc7\\uffca-\\uffcf\\uffd2-\\uffd7\\uffda-\\uffdc\\u0300-\\u036f\\u0483-\\u0487\\u0591-\\u05bd\\u05bf\\u05c1\\u05c2\\u05c4\\u05c5\\u05c7\\u0610-\\u061a\\u0620-\\u0649\\u0672-\\u06d3\\u06e7-\\u06e8\\u06fb-\\u06fc\\u0730-\\u074a\\u0800-\\u0814\\u081b-\\u0823\\u0825-\\u0827\\u0829-\\u082d\\u0840-\\u0857\\u08e4-\\u08fe\\u0900-\\u0903\\u093a-\\u093c\\u093e-\\u094f\\u0951-\\u0957\\u0962-\\u0963\\u0966-\\u096f\\u0981-\\u0983\\u09bc\\u09be-\\u09c4\\u09c7\\u09c8\\u09d7\\u09df-\\u09e0\\u0a01-\\u0a03\\u0a3c\\u0a3e-\\u0a42\\u0a47\\u0a48\\u0a4b-\\u0a4d\\u0a51\\u0a66-\\u0a71\\u0a75\\u0a81-\\u0a83\\u0abc\\u0abe-\\u0ac5\\u0ac7-\\u0ac9\\u0acb-\\u0acd\\u0ae2-\\u0ae3\\u0ae6-\\u0aef\\u0b01-\\u0b03\\u0b3c\\u0b3e-\\u0b44\\u0b47\\u0b48\\u0b4b-\\u0b4d\\u0b56\\u0b57\\u0b5f-\\u0b60\\u0b66-\\u0b6f\\u0b82\\u0bbe-\\u0bc2\\u0bc6-\\u0bc8\\u0bca-\\u0bcd\\u0bd7\\u0be6-\\u0bef\\u0c01-\\u0c03\\u0c46-\\u0c48\\u0c4a-\\u0c4d\\u0c55\\u0c56\\u0c62-\\u0c63\\u0c66-\\u0c6f\\u0c82\\u0c83\\u0cbc\\u0cbe-\\u0cc4\\u0cc6-\\u0cc8\\u0cca-\\u0ccd\\u0cd5\\u0cd6\\u0ce2-\\u0ce3\\u0ce6-\\u0cef\\u0d02\\u0d03\\u0d46-\\u0d48\\u0d57\\u0d62-\\u0d63\\u0d66-\\u0d6f\\u0d82\\u0d83\\u0dca\\u0dcf-\\u0dd4\\u0dd6\\u0dd8-\\u0ddf\\u0df2\\u0df3\\u0e34-\\u0e3a\\u0e40-\\u0e45\\u0e50-\\u0e59\\u0eb4-\\u0eb9\\u0ec8-\\u0ecd\\u0ed0-\\u0ed9\\u0f18\\u0f19\\u0f20-\\u0f29\\u0f35\\u0f37\\u0f39\\u0f41-\\u0f47\\u0f71-\\u0f84\\u0f86-\\u0f87\\u0f8d-\\u0f97\\u0f99-\\u0fbc\\u0fc6\\u1000-\\u1029\\u1040-\\u1049\\u1067-\\u106d\\u1071-\\u1074\\u1082-\\u108d\\u108f-\\u109d\\u135d-\\u135f\\u170e-\\u1710\\u1720-\\u1730\\u1740-\\u1750\\u1772\\u1773\\u1780-\\u17b2\\u17dd\\u17e0-\\u17e9\\u180b-\\u180d\\u1810-\\u1819\\u1920-\\u192b\\u1930-\\u193b\\u1951-\\u196d\\u19b0-\\u19c0\\u19c8-\\u19c9\\u19d0-\\u19d9\\u1a00-\\u1a15\\u1a20-\\u1a53\\u1a60-\\u1a7c\\u1a7f-\\u1a89\\u1a90-\\u1a99\\u1b46-\\u1b4b\\u1b50-\\u1b59\\u1b6b-\\u1b73\\u1bb0-\\u1bb9\\u1be6-\\u1bf3\\u1c00-\\u1c22\\u1c40-\\u1c49\\u1c5b-\\u1c7d\\u1cd0-\\u1cd2\\u1d00-\\u1dbe\\u1e01-\\u1f15\\u200c\\u200d\\u203f\\u2040\\u2054\\u20d0-\\u20dc\\u20e1\\u20e5-\\u20f0\\u2d81-\\u2d96\\u2de0-\\u2dff\\u3021-\\u3028\\u3099\\u309a\\ua640-\\ua66d\\ua674-\\ua67d\\ua69f\\ua6f0-\\ua6f1\\ua7f8-\\ua800\\ua806\\ua80b\\ua823-\\ua827\\ua880-\\ua881\\ua8b4-\\ua8c4\\ua8d0-\\ua8d9\\ua8f3-\\ua8f7\\ua900-\\ua909\\ua926-\\ua92d\\ua930-\\ua945\\ua980-\\ua983\\ua9b3-\\ua9c0\\uaa00-\\uaa27\\uaa40-\\uaa41\\uaa4c-\\uaa4d\\uaa50-\\uaa59\\uaa7b\\uaae0-\\uaae9\\uaaf2-\\uaaf3\\uabc0-\\uabe1\\uabec\\uabed\\uabf0-\\uabf9\\ufb20-\\ufb28\\ufe00-\\ufe0f\\ufe20-\\ufe26\\ufe33\\ufe34\\ufe4d-\\ufe4f\\uff10-\\uff19\\uff3f])*","g"),exports.identifierStart=new RegExp(identifierStart),exports.identifierMatch=new RegExp("(?:\\\\u[0-9a-fA-F]{4}|\\\\u\\{[0-9a-fA-F]+\\}|[\\x24\\x30-\\x39\\x41-\\x5a\\x5f\\x61-\\x7a"+nonASCIIidentifierStartChars+nonASCIIidentifierChars+"])+"),exports.newline=/[\n\r\u2028\u2029]/,exports.lineBreak=new RegExp("\r\n|"+exports.newline.source),exports.allLineBreaks=new RegExp(exports.lineBreak.source,"g")),acorn;var exports,nonASCIIidentifierStartChars,nonASCIIidentifierChars,identifierStart}var hasRequiredOptions$3,hasRequiredOptions$2,options$3={},options$2={};function requireOptions$3(){if(hasRequiredOptions$3)return options$2;function Options(options,merge_child_field){this.raw_options=_mergeOpts(options,merge_child_field),this.disabled=this._get_boolean("disabled"),this.eol=this._get_characters("eol","auto"),this.end_with_newline=this._get_boolean("end_with_newline"),this.indent_size=this._get_number("indent_size",4),this.indent_char=this._get_characters("indent_char"," "),this.indent_level=this._get_number("indent_level"),this.preserve_newlines=this._get_boolean("preserve_newlines",!0),this.max_preserve_newlines=this._get_number("max_preserve_newlines",32786),this.preserve_newlines||(this.max_preserve_newlines=0),this.indent_with_tabs=this._get_boolean("indent_with_tabs","\t"===this.indent_char),this.indent_with_tabs&&(this.indent_char="\t",1===this.indent_size&&(this.indent_size=4)),this.wrap_line_length=this._get_number("wrap_line_length",this._get_number("max_char")),this.indent_empty_lines=this._get_boolean("indent_empty_lines"),this.templating=this._get_selection_list("templating",["auto","none","angular","django","erb","handlebars","php","smarty"],["auto"])}function _mergeOpts(allOptions,childFieldName){var name,finalOpts={};for(name in allOptions=_normalizeOpts(allOptions))name!==childFieldName&&(finalOpts[name]=allOptions[name]);if(childFieldName&&allOptions[childFieldName])for(name in allOptions[childFieldName])finalOpts[name]=allOptions[childFieldName][name];return finalOpts}function _normalizeOpts(options){var key,convertedOpts={};for(key in options){convertedOpts[key.replace(/-/g,"_")]=options[key]}return convertedOpts}return hasRequiredOptions$3=1,Options.prototype._get_array=function(name,default_value){var option_value=this.raw_options[name],result=default_value||[];return"object"==typeof option_value?null!==option_value&&"function"==typeof option_value.concat&&(result=option_value.concat()):"string"==typeof option_value&&(result=option_value.split(/[^a-zA-Z0-9_\/\-]+/)),result},Options.prototype._get_boolean=function(name,default_value){var option_value=this.raw_options[name];return void 0===option_value?!!default_value:!!option_value},Options.prototype._get_characters=function(name,default_value){var option_value=this.raw_options[name],result=default_value||"";return"string"==typeof option_value&&(result=option_value.replace(/\\r/,"\r").replace(/\\n/,"\n").replace(/\\t/,"\t")),result},Options.prototype._get_number=function(name,default_value){var option_value=this.raw_options[name];default_value=parseInt(default_value,10),isNaN(default_value)&&(default_value=0);var result=parseInt(option_value,10);return isNaN(result)&&(result=default_value),result},Options.prototype._get_selection=function(name,selection_list,default_value){var result=this._get_selection_list(name,selection_list,default_value);if(1!==result.length)throw new Error("Invalid Option Value: The option '"+name+"' can only be one of the following values:\n"+selection_list+"\nYou passed in: '"+this.raw_options[name]+"'");return result[0]},Options.prototype._get_selection_list=function(name,selection_list,default_value){if(!selection_list||0===selection_list.length)throw new Error("Selection list cannot be empty.");if(default_value=default_value||[selection_list[0]],!this._is_valid_selection(default_value,selection_list))throw new Error("Invalid Default Value!");var result=this._get_array(name,default_value);if(!this._is_valid_selection(result,selection_list))throw new Error("Invalid Option Value: The option '"+name+"' can contain only the following values:\n"+selection_list+"\nYou passed in: '"+this.raw_options[name]+"'");return result},Options.prototype._is_valid_selection=function(result,selection_list){return result.length&&selection_list.length&&!result.some((function(item){return-1===selection_list.indexOf(item)}))},options$2.Options=Options,options$2.normalizeOpts=_normalizeOpts,options$2.mergeOpts=_mergeOpts,options$2}function requireOptions$2(){if(hasRequiredOptions$2)return options$3;hasRequiredOptions$2=1;var BaseOptions=requireOptions$3().Options,validPositionValues=["before-newline","after-newline","preserve-newline"];function Options(options){BaseOptions.call(this,options,"js");var raw_brace_style=this.raw_options.brace_style||null;"expand-strict"===raw_brace_style?this.raw_options.brace_style="expand":"collapse-preserve-inline"===raw_brace_style?this.raw_options.brace_style="collapse,preserve-inline":void 0!==this.raw_options.braces_on_own_line&&(this.raw_options.brace_style=this.raw_options.braces_on_own_line?"expand":"collapse");var brace_style_split=this._get_selection_list("brace_style",["collapse","expand","end-expand","none","preserve-inline"]);this.brace_preserve_inline=!1,this.brace_style="collapse";for(var bs=0;bs<brace_style_split.length;bs++)"preserve-inline"===brace_style_split[bs]?this.brace_preserve_inline=!0:this.brace_style=brace_style_split[bs];this.unindent_chained_methods=this._get_boolean("unindent_chained_methods"),this.break_chained_methods=this._get_boolean("break_chained_methods"),this.space_in_paren=this._get_boolean("space_in_paren"),this.space_in_empty_paren=this._get_boolean("space_in_empty_paren"),this.jslint_happy=this._get_boolean("jslint_happy"),this.space_after_anon_function=this._get_boolean("space_after_anon_function"),this.space_after_named_function=this._get_boolean("space_after_named_function"),this.keep_array_indentation=this._get_boolean("keep_array_indentation"),this.space_before_conditional=this._get_boolean("space_before_conditional",!0),this.unescape_strings=this._get_boolean("unescape_strings"),this.e4x=this._get_boolean("e4x"),this.comma_first=this._get_boolean("comma_first"),this.operator_position=this._get_selection("operator_position",validPositionValues),this.test_output_raw=this._get_boolean("test_output_raw"),this.jslint_happy&&(this.space_after_anon_function=!0)}return Options.prototype=new BaseOptions,options$3.Options=Options,options$3}var hasRequiredInputscanner,tokenizer$2={},inputscanner={};function requireInputscanner(){if(hasRequiredInputscanner)return inputscanner;hasRequiredInputscanner=1;var regexp_has_sticky=RegExp.prototype.hasOwnProperty("sticky");function InputScanner(input_string){this.__input=input_string||"",this.__input_length=this.__input.length,this.__position=0}return InputScanner.prototype.restart=function(){this.__position=0},InputScanner.prototype.back=function(){this.__position>0&&(this.__position-=1)},InputScanner.prototype.hasNext=function(){return this.__position<this.__input_length},InputScanner.prototype.next=function(){var val=null;return this.hasNext()&&(val=this.__input.charAt(this.__position),this.__position+=1),val},InputScanner.prototype.peek=function(index){var val=null;return index=index||0,(index+=this.__position)>=0&&index<this.__input_length&&(val=this.__input.charAt(index)),val},InputScanner.prototype.__match=function(pattern,index){pattern.lastIndex=index;var pattern_match=pattern.exec(this.__input);return!pattern_match||regexp_has_sticky&&pattern.sticky||pattern_match.index!==index&&(pattern_match=null),pattern_match},InputScanner.prototype.test=function(pattern,index){return index=index||0,(index+=this.__position)>=0&&index<this.__input_length&&!!this.__match(pattern,index)},InputScanner.prototype.testChar=function(pattern,index){var val=this.peek(index);return pattern.lastIndex=0,null!==val&&pattern.test(val)},InputScanner.prototype.match=function(pattern){var pattern_match=this.__match(pattern,this.__position);return pattern_match?this.__position+=pattern_match[0].length:pattern_match=null,pattern_match},InputScanner.prototype.read=function(starting_pattern,until_pattern,until_after){var match,val="";return starting_pattern&&(match=this.match(starting_pattern))&&(val+=match[0]),!until_pattern||!match&&starting_pattern||(val+=this.readUntil(until_pattern,until_after)),val},InputScanner.prototype.readUntil=function(pattern,until_after){var val,match_index=this.__position;pattern.lastIndex=this.__position;var pattern_match=pattern.exec(this.__input);return pattern_match?(match_index=pattern_match.index,until_after&&(match_index+=pattern_match[0].length)):match_index=this.__input_length,val=this.__input.substring(this.__position,match_index),this.__position=match_index,val},InputScanner.prototype.readUntilAfter=function(pattern){return this.readUntil(pattern,!0)},InputScanner.prototype.get_regexp=function(pattern,match_from){var result=null,flags="g";return match_from&&regexp_has_sticky&&(flags="y"),"string"==typeof pattern&&""!==pattern?result=new RegExp(pattern,flags):pattern&&(result=new RegExp(pattern.source,flags)),result},InputScanner.prototype.get_literal_regexp=function(literal_string){return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"))},InputScanner.prototype.peekUntilAfter=function(pattern){var start=this.__position,val=this.readUntilAfter(pattern);return this.__position=start,val},InputScanner.prototype.lookBack=function(testVal){var start=this.__position-1;return start>=testVal.length&&this.__input.substring(start-testVal.length,start).toLowerCase()===testVal},inputscanner.InputScanner=InputScanner,inputscanner}var hasRequiredTokenstream,tokenizer$1={},tokenstream={};var hasRequiredPattern,hasRequiredWhitespacepattern,hasRequiredTokenizer$2,whitespacepattern={},pattern={};function requirePattern(){if(hasRequiredPattern)return pattern;function Pattern(input_scanner,parent){this._input=input_scanner,this._starting_pattern=null,this._match_pattern=null,this._until_pattern=null,this._until_after=!1,parent&&(this._starting_pattern=this._input.get_regexp(parent._starting_pattern,!0),this._match_pattern=this._input.get_regexp(parent._match_pattern,!0),this._until_pattern=this._input.get_regexp(parent._until_pattern),this._until_after=parent._until_after)}return hasRequiredPattern=1,Pattern.prototype.read=function(){var result=this._input.read(this._starting_pattern);return this._starting_pattern&&!result||(result+=this._input.read(this._match_pattern,this._until_pattern,this._until_after)),result},Pattern.prototype.read_match=function(){return this._input.match(this._match_pattern)},Pattern.prototype.until_after=function(pattern){var result=this._create();return result._until_after=!0,result._until_pattern=this._input.get_regexp(pattern),result._update(),result},Pattern.prototype.until=function(pattern){var result=this._create();return result._until_after=!1,result._until_pattern=this._input.get_regexp(pattern),result._update(),result},Pattern.prototype.starting_with=function(pattern){var result=this._create();return result._starting_pattern=this._input.get_regexp(pattern,!0),result._update(),result},Pattern.prototype.matching=function(pattern){var result=this._create();return result._match_pattern=this._input.get_regexp(pattern,!0),result._update(),result},Pattern.prototype._create=function(){return new Pattern(this._input,this)},Pattern.prototype._update=function(){},pattern.Pattern=Pattern,pattern}function requireTokenizer$2(){if(hasRequiredTokenizer$2)return tokenizer$1;hasRequiredTokenizer$2=1;var InputScanner=requireInputscanner().InputScanner,Token=requireToken().Token,TokenStream=function(){if(hasRequiredTokenstream)return tokenstream;function TokenStream(parent_token){this.__tokens=[],this.__tokens_length=this.__tokens.length,this.__position=0,this.__parent_token=parent_token}return hasRequiredTokenstream=1,TokenStream.prototype.restart=function(){this.__position=0},TokenStream.prototype.isEmpty=function(){return 0===this.__tokens_length},TokenStream.prototype.hasNext=function(){return this.__position<this.__tokens_length},TokenStream.prototype.next=function(){var val=null;return this.hasNext()&&(val=this.__tokens[this.__position],this.__position+=1),val},TokenStream.prototype.peek=function(index){var val=null;return index=index||0,(index+=this.__position)>=0&&index<this.__tokens_length&&(val=this.__tokens[index]),val},TokenStream.prototype.add=function(token){this.__parent_token&&(token.parent=this.__parent_token),this.__tokens.push(token),this.__tokens_length+=1},tokenstream.TokenStream=TokenStream,tokenstream}().TokenStream,WhitespacePattern=function(){if(hasRequiredWhitespacepattern)return whitespacepattern;hasRequiredWhitespacepattern=1;var Pattern=requirePattern().Pattern;function WhitespacePattern(input_scanner,parent){Pattern.call(this,input_scanner,parent),parent?this._line_regexp=this._input.get_regexp(parent._line_regexp):this.__set_whitespace_patterns("",""),this.newline_count=0,this.whitespace_before_token=""}return WhitespacePattern.prototype=new Pattern,WhitespacePattern.prototype.__set_whitespace_patterns=function(whitespace_chars,newline_chars){whitespace_chars+="\\t ",newline_chars+="\\n\\r",this._match_pattern=this._input.get_regexp("["+whitespace_chars+newline_chars+"]+",!0),this._newline_regexp=this._input.get_regexp("\\r\\n|["+newline_chars+"]")},WhitespacePattern.prototype.read=function(){this.newline_count=0,this.whitespace_before_token="";var resulting_string=this._input.read(this._match_pattern);if(" "===resulting_string)this.whitespace_before_token=" ";else if(resulting_string){var matches=this.__split(this._newline_regexp,resulting_string);this.newline_count=matches.length-1,this.whitespace_before_token=matches[this.newline_count]}return resulting_string},WhitespacePattern.prototype.matching=function(whitespace_chars,newline_chars){var result=this._create();return result.__set_whitespace_patterns(whitespace_chars,newline_chars),result._update(),result},WhitespacePattern.prototype._create=function(){return new WhitespacePattern(this._input,this)},WhitespacePattern.prototype.__split=function(regexp,input_string){regexp.lastIndex=0;for(var start_index=0,result=[],next_match=regexp.exec(input_string);next_match;)result.push(input_string.substring(start_index,next_match.index)),start_index=next_match.index+next_match[0].length,next_match=regexp.exec(input_string);return start_index<input_string.length?result.push(input_string.substring(start_index,input_string.length)):result.push(""),result},whitespacepattern.WhitespacePattern=WhitespacePattern,whitespacepattern}().WhitespacePattern,TOKEN={START:"TK_START",RAW:"TK_RAW",EOF:"TK_EOF"},Tokenizer=function(input_string,options){this._input=new InputScanner(input_string),this._options=options||{},this.__tokens=null,this._patterns={},this._patterns.whitespace=new WhitespacePattern(this._input)};return Tokenizer.prototype.tokenize=function(){var current;this._input.restart(),this.__tokens=new TokenStream,this._reset();for(var previous=new Token(TOKEN.START,""),open_token=null,open_stack=[],comments=new TokenStream;previous.type!==TOKEN.EOF;){for(current=this._get_next_token(previous,open_token);this._is_comment(current);)comments.add(current),current=this._get_next_token(previous,open_token);comments.isEmpty()||(current.comments_before=comments,comments=new TokenStream),current.parent=open_token,this._is_opening(current)?(open_stack.push(open_token),open_token=current):open_token&&this._is_closing(current,open_token)&&(current.opened=open_token,open_token.closed=current,open_token=open_stack.pop(),current.parent=open_token),current.previous=previous,previous.next=current,this.__tokens.add(current),previous=current}return this.__tokens},Tokenizer.prototype._is_first_token=function(){return this.__tokens.isEmpty()},Tokenizer.prototype._reset=function(){},Tokenizer.prototype._get_next_token=function(previous_token,open_token){this._readWhitespace();var resulting_string=this._input.read(/.+/g);return resulting_string?this._create_token(TOKEN.RAW,resulting_string):this._create_token(TOKEN.EOF,"")},Tokenizer.prototype._is_comment=function(current_token){return!1},Tokenizer.prototype._is_opening=function(current_token){return!1},Tokenizer.prototype._is_closing=function(current_token,open_token){return!1},Tokenizer.prototype._create_token=function(type,text){return new Token(type,text,this._patterns.whitespace.newline_count,this._patterns.whitespace.whitespace_before_token)},Tokenizer.prototype._readWhitespace=function(){return this._patterns.whitespace.read()},tokenizer$1.Tokenizer=Tokenizer,tokenizer$1.TOKEN=TOKEN,tokenizer$1}var hasRequiredDirectives,directives={};function requireDirectives(){if(hasRequiredDirectives)return directives;function Directives(start_block_pattern,end_block_pattern){start_block_pattern="string"==typeof start_block_pattern?start_block_pattern:start_block_pattern.source,end_block_pattern="string"==typeof end_block_pattern?end_block_pattern:end_block_pattern.source,this.__directives_block_pattern=new RegExp(start_block_pattern+/ beautify( \w+[:]\w+)+ /.source+end_block_pattern,"g"),this.__directive_pattern=/ (\w+)[:](\w+)/g,this.__directives_end_ignore_pattern=new RegExp(start_block_pattern+/\sbeautify\signore:end\s/.source+end_block_pattern,"g")}return hasRequiredDirectives=1,Directives.prototype.get_directives=function(text){if(!text.match(this.__directives_block_pattern))return null;var directives={};this.__directive_pattern.lastIndex=0;for(var directive_match=this.__directive_pattern.exec(text);directive_match;)directives[directive_match[1]]=directive_match[2],directive_match=this.__directive_pattern.exec(text);return directives},Directives.prototype.readIgnored=function(input){return input.readUntilAfter(this.__directives_end_ignore_pattern)},directives.Directives=Directives,directives}var hasRequiredTemplatablepattern,hasRequiredTokenizer$1,hasRequiredBeautifier$2,hasRequiredJavascript,templatablepattern={};function requireTemplatablepattern(){if(hasRequiredTemplatablepattern)return templatablepattern;hasRequiredTemplatablepattern=1;var Pattern=requirePattern().Pattern,template_names={django:!1,erb:!1,handlebars:!1,php:!1,smarty:!1,angular:!1};function TemplatablePattern(input_scanner,parent){Pattern.call(this,input_scanner,parent),this.__template_pattern=null,this._disabled=Object.assign({},template_names),this._excluded=Object.assign({},template_names),parent&&(this.__template_pattern=this._input.get_regexp(parent.__template_pattern),this._excluded=Object.assign(this._excluded,parent._excluded),this._disabled=Object.assign(this._disabled,parent._disabled));var pattern=new Pattern(input_scanner);this.__patterns={handlebars_comment:pattern.starting_with(/{{!--/).until_after(/--}}/),handlebars_unescaped:pattern.starting_with(/{{{/).until_after(/}}}/),handlebars:pattern.starting_with(/{{/).until_after(/}}/),php:pattern.starting_with(/<\?(?:[= ]|php)/).until_after(/\?>/),erb:pattern.starting_with(/<%[^%]/).until_after(/[^%]%>/),django:pattern.starting_with(/{%/).until_after(/%}/),django_value:pattern.starting_with(/{{/).until_after(/}}/),django_comment:pattern.starting_with(/{#/).until_after(/#}/),smarty:pattern.starting_with(/{(?=[^}{\s\n])/).until_after(/[^\s\n]}/),smarty_comment:pattern.starting_with(/{\*/).until_after(/\*}/),smarty_literal:pattern.starting_with(/{literal}/).until_after(/{\/literal}/)}}return TemplatablePattern.prototype=new Pattern,TemplatablePattern.prototype._create=function(){return new TemplatablePattern(this._input,this)},TemplatablePattern.prototype._update=function(){this.__set_templated_pattern()},TemplatablePattern.prototype.disable=function(language){var result=this._create();return result._disabled[language]=!0,result._update(),result},TemplatablePattern.prototype.read_options=function(options){var result=this._create();for(var language in template_names)result._disabled[language]=-1===options.templating.indexOf(language);return result._update(),result},TemplatablePattern.prototype.exclude=function(language){var result=this._create();return result._excluded[language]=!0,result._update(),result},TemplatablePattern.prototype.read=function(){var result="";result=this._match_pattern?this._input.read(this._starting_pattern):this._input.read(this._starting_pattern,this.__template_pattern);for(var next=this._read_template();next;)this._match_pattern?next+=this._input.read(this._match_pattern):next+=this._input.readUntil(this.__template_pattern),result+=next,next=this._read_template();return this._until_after&&(result+=this._input.readUntilAfter(this._until_pattern)),result},TemplatablePattern.prototype.__set_templated_pattern=function(){var items=[];this._disabled.php||items.push(this.__patterns.php._starting_pattern.source),this._disabled.handlebars||items.push(this.__patterns.handlebars._starting_pattern.source),this._disabled.angular||items.push(this.__patterns.handlebars._starting_pattern.source),this._disabled.erb||items.push(this.__patterns.erb._starting_pattern.source),this._disabled.django||(items.push(this.__patterns.django._starting_pattern.source),items.push(this.__patterns.django_value._starting_pattern.source),items.push(this.__patterns.django_comment._starting_pattern.source)),this._disabled.smarty||items.push(this.__patterns.smarty._starting_pattern.source),this._until_pattern&&items.push(this._until_pattern.source),this.__template_pattern=this._input.get_regexp("(?:"+items.join("|")+")")},TemplatablePattern.prototype._read_template=function(){var resulting_string="",c=this._input.peek();if("<"===c){var peek1=this._input.peek(1);this._disabled.php||this._excluded.php||"?"!==peek1||(resulting_string=resulting_string||this.__patterns.php.read()),this._disabled.erb||this._excluded.erb||"%"!==peek1||(resulting_string=resulting_string||this.__patterns.erb.read())}else"{"===c&&(this._disabled.handlebars||this._excluded.handlebars||(resulting_string=(resulting_string=(resulting_string=resulting_string||this.__patterns.handlebars_comment.read())||this.__patterns.handlebars_unescaped.read())||this.__patterns.handlebars.read()),this._disabled.django||(this._excluded.django||this._excluded.handlebars||(resulting_string=resulting_string||this.__patterns.django_value.read()),this._excluded.django||(resulting_string=(resulting_string=resulting_string||this.__patterns.django_comment.read())||this.__patterns.django.read())),this._disabled.smarty||this._disabled.django&&this._disabled.handlebars&&(resulting_string=(resulting_string=(resulting_string=resulting_string||this.__patterns.smarty_comment.read())||this.__patterns.smarty_literal.read())||this.__patterns.smarty.read()));return resulting_string},templatablepattern.TemplatablePattern=TemplatablePattern,templatablepattern}function requireTokenizer$1(){if(hasRequiredTokenizer$1)return tokenizer$2;hasRequiredTokenizer$1=1;var InputScanner=requireInputscanner().InputScanner,BaseTokenizer=requireTokenizer$2().Tokenizer,BASETOKEN=requireTokenizer$2().TOKEN,Directives=requireDirectives().Directives,acorn=requireAcorn(),Pattern=requirePattern().Pattern,TemplatablePattern=requireTemplatablepattern().TemplatablePattern;function in_array(what,arr){return-1!==arr.indexOf(what)}var TOKEN={START_EXPR:"TK_START_EXPR",END_EXPR:"TK_END_EXPR",START_BLOCK:"TK_START_BLOCK",END_BLOCK:"TK_END_BLOCK",WORD:"TK_WORD",RESERVED:"TK_RESERVED",SEMICOLON:"TK_SEMICOLON",STRING:"TK_STRING",EQUALS:"TK_EQUALS",OPERATOR:"TK_OPERATOR",COMMA:"TK_COMMA",BLOCK_COMMENT:"TK_BLOCK_COMMENT",COMMENT:"TK_COMMENT",DOT:"TK_DOT",UNKNOWN:"TK_UNKNOWN",START:BASETOKEN.START,RAW:BASETOKEN.RAW,EOF:BASETOKEN.EOF},directives_core=new Directives(/\/\*/,/\*\//),number_pattern=/0[xX][0123456789abcdefABCDEF_]*n?|0[oO][01234567_]*n?|0[bB][01_]*n?|\d[\d_]*n|(?:\.\d[\d_]*|\d[\d_]*\.?[\d_]*)(?:[eE][+-]?[\d_]+)?/,digit=/[0-9]/,dot_pattern=/[^\d\.]/,positionable_operators=">>> === !== &&= ??= ||= << && >= ** != == <= >> || ?? |> < / - + > : & % ? ^ | *".split(" "),punct=">>>= ... >>= <<= === >>> !== **= &&= ??= ||= => ^= :: /= << <= == && -= >= >> != -- += ** || ?? ++ %= &= *= |= |> = ! ? > < : / ^ - + * & % ~ |";punct=(punct="\\?\\.(?!\\d) "+(punct=punct.replace(/[-[\]{}()*+?.,\\^$|#]/g,"\\$&"))).replace(/ /g,"|");var in_html_comment,punct_pattern=new RegExp(punct),line_starters="continue,try,throw,return,var,let,const,if,switch,case,default,for,while,break,function,import,export".split(","),reserved_words=line_starters.concat(["do","in","of","else","get","set","new","catch","finally","typeof","yield","async","await","from","as","class","extends"]),reserved_word_pattern=new RegExp("^(?:"+reserved_words.join("|")+")$"),Tokenizer=function(input_string,options){BaseTokenizer.call(this,input_string,options),this._patterns.whitespace=this._patterns.whitespace.matching(/\u00A0\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff/.source,/\u2028\u2029/.source);var pattern_reader=new Pattern(this._input),templatable=new TemplatablePattern(this._input).read_options(this._options);this.__patterns={template:templatable,identifier:templatable.starting_with(acorn.identifier).matching(acorn.identifierMatch),number:pattern_reader.matching(number_pattern),punct:pattern_reader.matching(punct_pattern),comment:pattern_reader.starting_with(/\/\//).until(/[\n\r\u2028\u2029]/),block_comment:pattern_reader.starting_with(/\/\*/).until_after(/\*\//),html_comment_start:pattern_reader.matching(/<!--/),html_comment_end:pattern_reader.matching(/-->/),include:pattern_reader.starting_with(/#include/).until_after(acorn.lineBreak),shebang:pattern_reader.starting_with(/#!/).until_after(acorn.lineBreak),xml:pattern_reader.matching(/[\s\S]*?<(\/?)([-a-zA-Z:0-9_.]+|{[^}]+?}|!\[CDATA\[[^\]]*?\]\]|)(\s*{[^}]+?}|\s+[-a-zA-Z:0-9_.]+|\s+[-a-zA-Z:0-9_.]+\s*=\s*('[^']*'|"[^"]*"|{([^{}]|{[^}]+?})+?}))*\s*(\/?)\s*>/),single_quote:templatable.until(/['\\\n\r\u2028\u2029]/),double_quote:templatable.until(/["\\\n\r\u2028\u2029]/),template_text:templatable.until(/[`\\$]/),template_expression:templatable.until(/[`}\\]/)}};return(Tokenizer.prototype=new BaseTokenizer)._is_comment=function(current_token){return current_token.type===TOKEN.COMMENT||current_token.type===TOKEN.BLOCK_COMMENT||current_token.type===TOKEN.UNKNOWN},Tokenizer.prototype._is_opening=function(current_token){return current_token.type===TOKEN.START_BLOCK||current_token.type===TOKEN.START_EXPR},Tokenizer.prototype._is_closing=function(current_token,open_token){return(current_token.type===TOKEN.END_BLOCK||current_token.type===TOKEN.END_EXPR)&&open_token&&("]"===current_token.text&&"["===open_token.text||")"===current_token.text&&"("===open_token.text||"}"===current_token.text&&"{"===open_token.text)},Tokenizer.prototype._reset=function(){in_html_comment=!1},Tokenizer.prototype._get_next_token=function(previous_token,open_token){var token=null;this._readWhitespace();var c=this._input.peek();return null===c?this._create_token(TOKEN.EOF,""):token=(token=(token=(token=(token=(token=(token=(token=(token=(token=token||this._read_non_javascript(c))||this._read_string(c))||this._read_pair(c,this._input.peek(1)))||this._read_word(previous_token))||this._read_singles(c))||this._read_comment(c))||this._read_regexp(c,previous_token))||this._read_xml(c,previous_token))||this._read_punctuation())||this._create_token(TOKEN.UNKNOWN,this._input.next())},Tokenizer.prototype._read_word=function(previous_token){var resulting_string;return""!==(resulting_string=this.__patterns.identifier.read())?(resulting_string=resulting_string.replace(acorn.allLineBreaks,"\n"),previous_token.type!==TOKEN.DOT&&(previous_token.type!==TOKEN.RESERVED||"set"!==previous_token.text&&"get"!==previous_token.text)&&reserved_word_pattern.test(resulting_string)?"in"!==resulting_string&&"of"!==resulting_string||previous_token.type!==TOKEN.WORD&&previous_token.type!==TOKEN.STRING?this._create_token(TOKEN.RESERVED,resulting_string):this._create_token(TOKEN.OPERATOR,resulting_string):this._create_token(TOKEN.WORD,resulting_string)):""!==(resulting_string=this.__patterns.number.read())?this._create_token(TOKEN.WORD,resulting_string):void 0},Tokenizer.prototype._read_singles=function(c){var token=null;return"("===c||"["===c?token=this._create_token(TOKEN.START_EXPR,c):")"===c||"]"===c?token=this._create_token(TOKEN.END_EXPR,c):"{"===c?token=this._create_token(TOKEN.START_BLOCK,c):"}"===c?token=this._create_token(TOKEN.END_BLOCK,c):";"===c?token=this._create_token(TOKEN.SEMICOLON,c):"."===c&&dot_pattern.test(this._input.peek(1))?token=this._create_token(TOKEN.DOT,c):","===c&&(token=this._create_token(TOKEN.COMMA,c)),token&&this._input.next(),token},Tokenizer.prototype._read_pair=function(c,d){var token=null;return"#"===c&&"{"===d&&(token=this._create_token(TOKEN.START_BLOCK,c+d)),token&&(this._input.next(),this._input.next()),token},Tokenizer.prototype._read_punctuation=function(){var resulting_string=this.__patterns.punct.read();if(""!==resulting_string)return"="===resulting_string?this._create_token(TOKEN.EQUALS,resulting_string):"?."===resulting_string?this._create_token(TOKEN.DOT,resulting_string):this._create_token(TOKEN.OPERATOR,resulting_string)},Tokenizer.prototype._read_non_javascript=function(c){var resulting_string="";if("#"===c){if(this._is_first_token()&&(resulting_string=this.__patterns.shebang.read()))return this._create_token(TOKEN.UNKNOWN,resulting_string.trim()+"\n");if(resulting_string=this.__patterns.include.read())return this._create_token(TOKEN.UNKNOWN,resulting_string.trim()+"\n");c=this._input.next();var sharp="#";if(this._input.hasNext()&&this._input.testChar(digit)){do{sharp+=c=this._input.next()}while(this._input.hasNext()&&"#"!==c&&"="!==c);return"#"===c||("["===this._input.peek()&&"]"===this._input.peek(1)?(sharp+="[]",this._input.next(),this._input.next()):"{"===this._input.peek()&&"}"===this._input.peek(1)&&(sharp+="{}",this._input.next(),this._input.next())),this._create_token(TOKEN.WORD,sharp)}this._input.back()}else if("<"===c&&this._is_first_token()){if(resulting_string=this.__patterns.html_comment_start.read()){for(;this._input.hasNext()&&!this._input.testChar(acorn.newline);)resulting_string+=this._input.next();return in_html_comment=!0,this._create_token(TOKEN.COMMENT,resulting_string)}}else if(in_html_comment&&"-"===c&&(resulting_string=this.__patterns.html_comment_end.read()))return in_html_comment=!1,this._create_token(TOKEN.COMMENT,resulting_string);return null},Tokenizer.prototype._read_comment=function(c){var token=null;if("/"===c){var comment="";if("*"===this._input.peek(1)){comment=this.__patterns.block_comment.read();var directives=directives_core.get_directives(comment);directives&&"start"===directives.ignore&&(comment+=directives_core.readIgnored(this._input)),comment=comment.replace(acorn.allLineBreaks,"\n"),(token=this._create_token(TOKEN.BLOCK_COMMENT,comment)).directives=directives}else"/"===this._input.peek(1)&&(comment=this.__patterns.comment.read(),token=this._create_token(TOKEN.COMMENT,comment))}return token},Tokenizer.prototype._read_string=function(c){if("`"===c||"'"===c||'"'===c){var resulting_string=this._input.next();return this.has_char_escapes=!1,resulting_string+="`"===c?this._read_string_recursive("`",!0,"${"):this._read_string_recursive(c),this.has_char_escapes&&this._options.unescape_strings&&(resulting_string=function(s){var out="",escaped=0,input_scan=new InputScanner(s),matched=null;for(;input_scan.hasNext();)if((matched=input_scan.match(/([\s]|[^\\]|\\\\)+/g))&&(out+=matched[0]),"\\"===input_scan.peek()){if(input_scan.next(),"x"===input_scan.peek())matched=input_scan.match(/x([0-9A-Fa-f]{2})/g);else{if("u"!==input_scan.peek()){out+="\\",input_scan.hasNext()&&(out+=input_scan.next());continue}(matched=input_scan.match(/u([0-9A-Fa-f]{4})/g))||(matched=input_scan.match(/u\{([0-9A-Fa-f]+)\}/g))}if(!matched)return s;if((escaped=parseInt(matched[1],16))>126&&escaped<=255&&0===matched[0].indexOf("x"))return s;out+=escaped>=0&&escaped<32||escaped>1114111?"\\"+matched[0]:34===escaped||39===escaped||92===escaped?"\\"+String.fromCharCode(escaped):String.fromCharCode(escaped)}return out}(resulting_string)),this._input.peek()===c&&(resulting_string+=this._input.next()),resulting_string=resulting_string.replace(acorn.allLineBreaks,"\n"),this._create_token(TOKEN.STRING,resulting_string)}return null},Tokenizer.prototype._allow_regexp_or_xml=function(previous_token){return previous_token.type===TOKEN.RESERVED&&in_array(previous_token.text,["return","case","throw","else","do","typeof","yield"])||previous_token.type===TOKEN.END_EXPR&&")"===previous_token.text&&previous_token.opened.previous.type===TOKEN.RESERVED&&in_array(previous_token.opened.previous.text,["if","while","for"])||in_array(previous_token.type,[TOKEN.COMMENT,TOKEN.START_EXPR,TOKEN.START_BLOCK,TOKEN.START,TOKEN.END_BLOCK,TOKEN.OPERATOR,TOKEN.EQUALS,TOKEN.EOF,TOKEN.SEMICOLON,TOKEN.COMMA])},Tokenizer.prototype._read_regexp=function(c,previous_token){if("/"===c&&this._allow_regexp_or_xml(previous_token)){for(var resulting_string=this._input.next(),esc=!1,in_char_class=!1;this._input.hasNext()&&(esc||in_char_class||this._input.peek()!==c)&&!this._input.testChar(acorn.newline);)resulting_string+=this._input.peek(),esc?esc=!1:(esc="\\"===this._input.peek(),"["===this._input.peek()?in_char_class=!0:"]"===this._input.peek()&&(in_char_class=!1)),this._input.next();return this._input.peek()===c&&(resulting_string+=this._input.next(),resulting_string+=this._input.read(acorn.identifier)),this._create_token(TOKEN.STRING,resulting_string)}return null},Tokenizer.prototype._read_xml=function(c,previous_token){if(this._options.e4x&&"<"===c&&this._allow_regexp_or_xml(previous_token)){var xmlStr="",match=this.__patterns.xml.read_match();if(match){for(var rootTag=match[2].replace(/^{\s+/,"{").replace(/\s+}$/,"}"),isCurlyRoot=0===rootTag.indexOf("{"),depth=0;match;){var isEndTag=!!match[1],tagName=match[2];if(!(!!match[match.length-1]||"![CDATA["===tagName.slice(0,8))&&(tagName===rootTag||isCurlyRoot&&tagName.replace(/^{\s+/,"{").replace(/\s+}$/,"}"))&&(isEndTag?--depth:++depth),xmlStr+=match[0],depth<=0)break;match=this.__patterns.xml.read_match()}return match||(xmlStr+=this._input.match(/[\s\S]*/g)[0]),xmlStr=xmlStr.replace(acorn.allLineBreaks,"\n"),this._create_token(TOKEN.STRING,xmlStr)}}return null},Tokenizer.prototype._read_string_recursive=function(delimiter,allow_unescaped_newlines,start_sub){var current_char,pattern;"'"===delimiter?pattern=this.__patterns.single_quote:'"'===delimiter?pattern=this.__patterns.double_quote:"`"===delimiter?pattern=this.__patterns.template_text:"}"===delimiter&&(pattern=this.__patterns.template_expression);for(var resulting_string=pattern.read(),next="";this._input.hasNext();){if((next=this._input.next())===delimiter||!allow_unescaped_newlines&&acorn.newline.test(next)){this._input.back();break}"\\"===next&&this._input.hasNext()?("x"===(current_char=this._input.peek())||"u"===current_char?this.has_char_escapes=!0:"\r"===current_char&&"\n"===this._input.peek(1)&&this._input.next(),next+=this._input.next()):start_sub&&("${"===start_sub&&"$"===next&&"{"===this._input.peek()&&(next+=this._input.next()),start_sub===next&&(next+="`"===delimiter?this._read_string_recursive("}",allow_unescaped_newlines,"`"):this._read_string_recursive("`",allow_unescaped_newlines,"${"),this._input.hasNext()&&(next+=this._input.next()))),resulting_string+=next+=pattern.read()}return resulting_string},tokenizer$2.Tokenizer=Tokenizer,tokenizer$2.TOKEN=TOKEN,tokenizer$2.positionable_operators=positionable_operators.slice(),tokenizer$2.line_starters=line_starters.slice(),tokenizer$2}function requireBeautifier$2(){if(hasRequiredBeautifier$2)return beautifier$2;hasRequiredBeautifier$2=1;var Output=requireOutput().Output,Token=requireToken().Token,acorn=requireAcorn(),Options=requireOptions$2().Options,Tokenizer=requireTokenizer$1().Tokenizer,line_starters=requireTokenizer$1().line_starters,positionable_operators=requireTokenizer$1().positionable_operators,TOKEN=requireTokenizer$1().TOKEN;function in_array(what,arr){return-1!==arr.indexOf(what)}function reserved_word(token,word){return token&&token.type===TOKEN.RESERVED&&token.text===word}function reserved_array(token,words){return token&&token.type===TOKEN.RESERVED&&in_array(token.text,words)}var special_words=["case","return","do","if","throw","else","await","break","continue","async"],OPERATOR_POSITION=function(list){for(var result={},x=0;x<list.length;x++)result[list[x].replace(/-/g,"_")]=list[x];return result}(["before-newline","after-newline","preserve-newline"]),OPERATOR_POSITION_BEFORE_OR_PRESERVE=[OPERATOR_POSITION.before_newline,OPERATOR_POSITION.preserve_newline],MODE_BlockStatement="BlockStatement",MODE_Statement="Statement",MODE_ObjectLiteral="ObjectLiteral",MODE_ArrayLiteral="ArrayLiteral",MODE_ForInitializer="ForInitializer",MODE_Conditional="Conditional",MODE_Expression="Expression";function remove_redundant_indentation(output,frame){frame.multiline_frame||frame.mode===MODE_ForInitializer||frame.mode===MODE_Conditional||output.remove_indent(frame.start_line_index)}function is_array(mode){return mode===MODE_ArrayLiteral}function is_expression(mode){return in_array(mode,[MODE_Expression,MODE_ForInitializer,MODE_Conditional])}function Beautifier(source_text,options){options=options||{},this._source_text=source_text||"",this._output=null,this._tokens=null,this._last_last_text=null,this._flags=null,this._previous_flags=null,this._flag_store=null,this._options=new Options(options)}Beautifier.prototype.create_flags=function(flags_base,mode){var next_indent_level=0;return flags_base&&(next_indent_level=flags_base.indentation_level,!this._output.just_added_newline()&&flags_base.line_indent_level>next_indent_level&&(next_indent_level=flags_base.line_indent_level)),{mode:mode,parent:flags_base,last_token:flags_base?flags_base.last_token:new Token(TOKEN.START_BLOCK,""),last_word:flags_base?flags_base.last_word:"",declaration_statement:!1,declaration_assignment:!1,multiline_frame:!1,inline_frame:!1,if_block:!1,else_block:!1,class_start_block:!1,do_block:!1,do_while:!1,import_block:!1,in_case_statement:!1,in_case:!1,case_body:!1,case_block:!1,indentation_level:next_indent_level,alignment:0,line_indent_level:flags_base?flags_base.line_indent_level:next_indent_level,start_line_index:this._output.get_line_number(),ternary_depth:0}},Beautifier.prototype._reset=function(source_text){var baseIndentString=source_text.match(/^[\t ]*/)[0];this._last_last_text="",this._output=new Output(this._options,baseIndentString),this._output.raw=this._options.test_output_raw,this._flag_store=[],this.set_mode(MODE_BlockStatement);var tokenizer=new Tokenizer(source_text,this._options);return this._tokens=tokenizer.tokenize(),source_text},Beautifier.prototype.beautify=function(){if(this._options.disabled)return this._source_text;var source_text=this._reset(this._source_text),eol=this._options.eol;"auto"===this._options.eol&&(eol="\n",source_text&&acorn.lineBreak.test(source_text||"")&&(eol=source_text.match(acorn.lineBreak)[0]));for(var current_token=this._tokens.next();current_token;)this.handle_token(current_token),this._last_last_text=this._flags.last_token.text,this._flags.last_token=current_token,current_token=this._tokens.next();return this._output.get_code(eol)},Beautifier.prototype.handle_token=function(current_token,preserve_statement_flags){current_token.type===TOKEN.START_EXPR?this.handle_start_expr(current_token):current_token.type===TOKEN.END_EXPR?this.handle_end_expr(current_token):current_token.type===TOKEN.START_BLOCK?this.handle_start_block(current_token):current_token.type===TOKEN.END_BLOCK?this.handle_end_block(current_token):current_token.type===TOKEN.WORD||current_token.type===TOKEN.RESERVED?this.handle_word(current_token):current_token.type===TOKEN.SEMICOLON?this.handle_semicolon(current_token):current_token.type===TOKEN.STRING?this.handle_string(current_token):current_token.type===TOKEN.EQUALS?this.handle_equals(current_token):current_token.type===TOKEN.OPERATOR?this.handle_operator(current_token):current_token.type===TOKEN.COMMA?this.handle_comma(current_token):current_token.type===TOKEN.BLOCK_COMMENT?this.handle_block_comment(current_token,preserve_statement_flags):current_token.type===TOKEN.COMMENT?this.handle_comment(current_token,preserve_statement_flags):current_token.type===TOKEN.DOT?this.handle_dot(current_token):current_token.type===TOKEN.EOF?this.handle_eof(current_token):(current_token.type,TOKEN.UNKNOWN,this.handle_unknown(current_token,preserve_statement_flags))},Beautifier.prototype.handle_whitespace_and_comments=function(current_token,preserve_statement_flags){var newlines=current_token.newlines,keep_whitespace=this._options.keep_array_indentation&&is_array(this._flags.mode);if(current_token.comments_before)for(var comment_token=current_token.comments_before.next();comment_token;)this.handle_whitespace_and_comments(comment_token,preserve_statement_flags),this.handle_token(comment_token,preserve_statement_flags),comment_token=current_token.comments_before.next();if(keep_whitespace)for(var i=0;i<newlines;i+=1)this.print_newline(i>0,preserve_statement_flags);else if(this._options.max_preserve_newlines&&newlines>this._options.max_preserve_newlines&&(newlines=this._options.max_preserve_newlines),this._options.preserve_newlines&&newlines>1){this.print_newline(!1,preserve_statement_flags);for(var j=1;j<newlines;j+=1)this.print_newline(!0,preserve_statement_flags)}};var newline_restricted_tokens=["async","break","continue","return","throw","yield"];return Beautifier.prototype.allow_wrap_or_preserved_newline=function(current_token,force_linewrap){if(force_linewrap=void 0!==force_linewrap&&force_linewrap,!this._output.just_added_newline()){var shouldPreserveOrForce=this._options.preserve_newlines&&current_token.newlines||force_linewrap;if(in_array(this._flags.last_token.text,positionable_operators)||in_array(current_token.text,positionable_operators)){var shouldPrintOperatorNewline=in_array(this._flags.last_token.text,positionable_operators)&&in_array(this._options.operator_position,OPERATOR_POSITION_BEFORE_OR_PRESERVE)||in_array(current_token.text,positionable_operators);shouldPreserveOrForce=shouldPreserveOrForce&&shouldPrintOperatorNewline}if(shouldPreserveOrForce)this.print_newline(!1,!0);else if(this._options.wrap_line_length){if(reserved_array(this._flags.last_token,newline_restricted_tokens))return;this._output.set_wrap_point()}}},Beautifier.prototype.print_newline=function(force_newline,preserve_statement_flags){if(!preserve_statement_flags&&";"!==this._flags.last_token.text&&","!==this._flags.last_token.text&&"="!==this._flags.last_token.text&&(this._flags.last_token.type!==TOKEN.OPERATOR||"--"===this._flags.last_token.text||"++"===this._flags.last_token.text))for(var next_token=this._tokens.peek();!(this._flags.mode!==MODE_Statement||this._flags.if_block&&reserved_word(next_token,"else")||this._flags.do_block);)this.restore_mode();this._output.add_new_line(force_newline)&&(this._flags.multiline_frame=!0)},Beautifier.prototype.print_token_line_indentation=function(current_token){this._output.just_added_newline()&&(this._options.keep_array_indentation&&current_token.newlines&&("["===current_token.text||is_array(this._flags.mode))?(this._output.current_line.set_indent(-1),this._output.current_line.push(current_token.whitespace_before),this._output.space_before_token=!1):this._output.set_indent(this._flags.indentation_level,this._flags.alignment)&&(this._flags.line_indent_level=this._flags.indentation_level))},Beautifier.prototype.print_token=function(current_token){if(this._output.raw)this._output.add_raw_token(current_token);else{if(this._options.comma_first&&current_token.previous&&current_token.previous.type===TOKEN.COMMA&&this._output.just_added_newline()&&","===this._output.previous_line.last()){var popped=this._output.previous_line.pop();this._output.previous_line.is_empty()&&(this._output.previous_line.push(popped),this._output.trim(!0),this._output.current_line.pop(),this._output.trim()),this.print_token_line_indentation(current_token),this._output.add_token(","),this._output.space_before_token=!0}this.print_token_line_indentation(current_token),this._output.non_breaking_space=!0,this._output.add_token(current_token.text),this._output.previous_token_wrapped&&(this._flags.multiline_frame=!0)}},Beautifier.prototype.indent=function(){this._flags.indentation_level+=1,this._output.set_indent(this._flags.indentation_level,this._flags.alignment)},Beautifier.prototype.deindent=function(){this._flags.indentation_level>0&&(!this._flags.parent||this._flags.indentation_level>this._flags.parent.indentation_level)&&(this._flags.indentation_level-=1,this._output.set_indent(this._flags.indentation_level,this._flags.alignment))},Beautifier.prototype.set_mode=function(mode){this._flags?(this._flag_store.push(this._flags),this._previous_flags=this._flags):this._previous_flags=this.create_flags(null,mode),this._flags=this.create_flags(this._previous_flags,mode),this._output.set_indent(this._flags.indentation_level,this._flags.alignment)},Beautifier.prototype.restore_mode=function(){this._flag_store.length>0&&(this._previous_flags=this._flags,this._flags=this._flag_store.pop(),this._previous_flags.mode===MODE_Statement&&remove_redundant_indentation(this._output,this._previous_flags),this._output.set_indent(this._flags.indentation_level,this._flags.alignment))},Beautifier.prototype.start_of_object_property=function(){return this._flags.parent.mode===MODE_ObjectLiteral&&this._flags.mode===MODE_Statement&&(":"===this._flags.last_token.text&&0===this._flags.ternary_depth||reserved_array(this._flags.last_token,["get","set"]))},Beautifier.prototype.start_of_statement=function(current_token){var start=!1;return!!(start=(start=(start=(start=(start=(start=(start=start||reserved_array(this._flags.last_token,["var","let","const"])&&current_token.type===TOKEN.WORD)||reserved_word(this._flags.last_token,"do"))||!(this._flags.parent.mode===MODE_ObjectLiteral&&this._flags.mode===MODE_Statement)&&reserved_array(this._flags.last_token,newline_restricted_tokens)&&!current_token.newlines)||reserved_word(this._flags.last_token,"else")&&!(reserved_word(current_token,"if")&&!current_token.comments_before))||this._flags.last_token.type===TOKEN.END_EXPR&&(this._previous_flags.mode===MODE_ForInitializer||this._previous_flags.mode===MODE_Conditional))||this._flags.last_token.type===TOKEN.WORD&&this._flags.mode===MODE_BlockStatement&&!this._flags.in_case&&!("--"===current_token.text||"++"===current_token.text)&&"function"!==this._last_last_text&&current_token.type!==TOKEN.WORD&&current_token.type!==TOKEN.RESERVED)||this._flags.mode===MODE_ObjectLiteral&&(":"===this._flags.last_token.text&&0===this._flags.ternary_depth||reserved_array(this._flags.last_token,["get","set"])))&&(this.set_mode(MODE_Statement),this.indent(),this.handle_whitespace_and_comments(current_token,!0),this.start_of_object_property()||this.allow_wrap_or_preserved_newline(current_token,reserved_array(current_token,["do","for","if","while"])),!0)},Beautifier.prototype.handle_start_expr=function(current_token){this.start_of_statement(current_token)||this.handle_whitespace_and_comments(current_token);var next_mode=MODE_Expression;if("["===current_token.text){if(this._flags.last_token.type===TOKEN.WORD||")"===this._flags.last_token.text)return reserved_array(this._flags.last_token,line_starters)&&(this._output.space_before_token=!0),this.print_token(current_token),this.set_mode(next_mode),this.indent(),void(this._options.space_in_paren&&(this._output.space_before_token=!0));next_mode=MODE_ArrayLiteral,is_array(this._flags.mode)&&("["!==this._flags.last_token.text&&(","!==this._flags.last_token.text||"]"!==this._last_last_text&&"}"!==this._last_last_text)||this._options.keep_array_indentation||this.print_newline()),in_array(this._flags.last_token.type,[TOKEN.START_EXPR,TOKEN.END_EXPR,TOKEN.WORD,TOKEN.OPERATOR,TOKEN.DOT])||(this._output.space_before_token=!0)}else{if(this._flags.last_token.type===TOKEN.RESERVED)"for"===this._flags.last_token.text?(this._output.space_before_token=this._options.space_before_conditional,next_mode=MODE_ForInitializer):in_array(this._flags.last_token.text,["if","while","switch"])?(this._output.space_before_token=this._options.space_before_conditional,next_mode=MODE_Conditional):in_array(this._flags.last_word,["await","async"])?this._output.space_before_token=!0:"import"===this._flags.last_token.text&&""===current_token.whitespace_before?this._output.space_before_token=!1:(in_array(this._flags.last_token.text,line_starters)||"catch"===this._flags.last_token.text)&&(this._output.space_before_token=!0);else if(this._flags.last_token.type===TOKEN.EQUALS||this._flags.last_token.type===TOKEN.OPERATOR)this.start_of_object_property()||this.allow_wrap_or_preserved_newline(current_token);else if(this._flags.last_token.type===TOKEN.WORD){this._output.space_before_token=!1;var peek_back_two=this._tokens.peek(-3);if(this._options.space_after_named_function&&peek_back_two){var peek_back_three=this._tokens.peek(-4);reserved_array(peek_back_two,["async","function"])||"*"===peek_back_two.text&&reserved_array(peek_back_three,["async","function"])?this._output.space_before_token=!0:this._flags.mode===MODE_ObjectLiteral?"{"!==peek_back_two.text&&","!==peek_back_two.text&&("*"!==peek_back_two.text||"{"!==peek_back_three.text&&","!==peek_back_three.text)||(this._output.space_before_token=!0):this._flags.parent&&this._flags.parent.class_start_block&&(this._output.space_before_token=!0)}}else this.allow_wrap_or_preserved_newline(current_token);(this._flags.last_token.type===TOKEN.RESERVED&&("function"===this._flags.last_word||"typeof"===this._flags.last_word)||"*"===this._flags.last_token.text&&(in_array(this._last_last_text,["function","yield"])||this._flags.mode===MODE_ObjectLiteral&&in_array(this._last_last_text,["{",","])))&&(this._output.space_before_token=this._options.space_after_anon_function)}";"===this._flags.last_token.text||this._flags.last_token.type===TOKEN.START_BLOCK?this.print_newline():this._flags.last_token.type!==TOKEN.END_EXPR&&this._flags.last_token.type!==TOKEN.START_EXPR&&this._flags.last_token.type!==TOKEN.END_BLOCK&&"."!==this._flags.last_token.text&&this._flags.last_token.type!==TOKEN.COMMA||this.allow_wrap_or_preserved_newline(current_token,current_token.newlines),this.print_token(current_token),this.set_mode(next_mode),this._options.space_in_paren&&(this._output.space_before_token=!0),this.indent()},Beautifier.prototype.handle_end_expr=function(current_token){for(;this._flags.mode===MODE_Statement;)this.restore_mode();this.handle_whitespace_and_comments(current_token),this._flags.multiline_frame&&this.allow_wrap_or_preserved_newline(current_token,"]"===current_token.text&&is_array(this._flags.mode)&&!this._options.keep_array_indentation),this._options.space_in_paren&&(this._flags.last_token.type!==TOKEN.START_EXPR||this._options.space_in_empty_paren?this._output.space_before_token=!0:(this._output.trim(),this._output.space_before_token=!1)),this.deindent(),this.print_token(current_token),this.restore_mode(),remove_redundant_indentation(this._output,this._previous_flags),this._flags.do_while&&this._previous_flags.mode===MODE_Conditional&&(this._previous_flags.mode=MODE_Expression,this._flags.do_block=!1,this._flags.do_while=!1)},Beautifier.prototype.handle_start_block=function(current_token){this.handle_whitespace_and_comments(current_token);var next_token=this._tokens.peek(),second_token=this._tokens.peek(1);"switch"===this._flags.last_word&&this._flags.last_token.type===TOKEN.END_EXPR?(this.set_mode(MODE_BlockStatement),this._flags.in_case_statement=!0):this._flags.case_body?this.set_mode(MODE_BlockStatement):second_token&&(in_array(second_token.text,[":",","])&&in_array(next_token.type,[TOKEN.STRING,TOKEN.WORD,TOKEN.RESERVED])||in_array(next_token.text,["get","set","..."])&&in_array(second_token.type,[TOKEN.WORD,TOKEN.RESERVED]))?in_array(this._last_last_text,["class","interface"])&&!in_array(second_token.text,[":",","])?this.set_mode(MODE_BlockStatement):this.set_mode(MODE_ObjectLiteral):this._flags.last_token.type===TOKEN.OPERATOR&&"=>"===this._flags.last_token.text?this.set_mode(MODE_BlockStatement):in_array(this._flags.last_token.type,[TOKEN.EQUALS,TOKEN.START_EXPR,TOKEN.COMMA,TOKEN.OPERATOR])||reserved_array(this._flags.last_token,["return","throw","import","default"])?this.set_mode(MODE_ObjectLiteral):this.set_mode(MODE_BlockStatement),this._flags.last_token&&reserved_array(this._flags.last_token.previous,["class","extends"])&&(this._flags.class_start_block=!0);var empty_braces=!next_token.comments_before&&"}"===next_token.text,empty_anonymous_function=empty_braces&&"function"===this._flags.last_word&&this._flags.last_token.type===TOKEN.END_EXPR;if(this._options.brace_preserve_inline){var index=0,check_token=null;this._flags.inline_frame=!0;do{if(index+=1,(check_token=this._tokens.peek(index-1)).newlines){this._flags.inline_frame=!1;break}}while(check_token.type!==TOKEN.EOF&&(check_token.type!==TOKEN.END_BLOCK||check_token.opened!==current_token))}("expand"===this._options.brace_style||"none"===this._options.brace_style&&current_token.newlines)&&!this._flags.inline_frame?this._flags.last_token.type!==TOKEN.OPERATOR&&(empty_anonymous_function||this._flags.last_token.type===TOKEN.EQUALS||reserved_array(this._flags.last_token,special_words)&&"else"!==this._flags.last_token.text)?this._output.space_before_token=!0:this.print_newline(!1,!0):(!is_array(this._previous_flags.mode)||this._flags.last_token.type!==TOKEN.START_EXPR&&this._flags.last_token.type!==TOKEN.COMMA||((this._flags.last_token.type===TOKEN.COMMA||this._options.space_in_paren)&&(this._output.space_before_token=!0),(this._flags.last_token.type===TOKEN.COMMA||this._flags.last_token.type===TOKEN.START_EXPR&&this._flags.inline_frame)&&(this.allow_wrap_or_preserved_newline(current_token),this._previous_flags.multiline_frame=this._previous_flags.multiline_frame||this._flags.multiline_frame,this._flags.multiline_frame=!1)),this._flags.last_token.type!==TOKEN.OPERATOR&&this._flags.last_token.type!==TOKEN.START_EXPR&&(in_array(this._flags.last_token.type,[TOKEN.START_BLOCK,TOKEN.SEMICOLON])&&!this._flags.inline_frame?this.print_newline():this._output.space_before_token=!0)),this.print_token(current_token),this.indent(),empty_braces||this._options.brace_preserve_inline&&this._flags.inline_frame||this.print_newline()},Beautifier.prototype.handle_end_block=function(current_token){for(this.handle_whitespace_and_comments(current_token);this._flags.mode===MODE_Statement;)this.restore_mode();var empty_braces=this._flags.last_token.type===TOKEN.START_BLOCK;this._flags.inline_frame&&!empty_braces?this._output.space_before_token=!0:"expand"===this._options.brace_style?empty_braces||this.print_newline():empty_braces||(is_array(this._flags.mode)&&this._options.keep_array_indentation?(this._options.keep_array_indentation=!1,this.print_newline(),this._options.keep_array_indentation=!0):this.print_newline()),this.restore_mode(),this.print_token(current_token)},Beautifier.prototype.handle_word=function(current_token){if(current_token.type===TOKEN.RESERVED)if(in_array(current_token.text,["set","get"])&&this._flags.mode!==MODE_ObjectLiteral)current_token.type=TOKEN.WORD;else if("import"===current_token.text&&in_array(this._tokens.peek().text,["(","."]))current_token.type=TOKEN.WORD;else if(in_array(current_token.text,["as","from"])&&!this._flags.import_block)current_token.type=TOKEN.WORD;else if(this._flags.mode===MODE_ObjectLiteral){":"===this._tokens.peek().text&&(current_token.type=TOKEN.WORD)}if(this.start_of_statement(current_token)?reserved_array(this._flags.last_token,["var","let","const"])&&current_token.type===TOKEN.WORD&&(this._flags.declaration_statement=!0):!current_token.newlines||is_expression(this._flags.mode)||this._flags.last_token.type===TOKEN.OPERATOR&&"--"!==this._flags.last_token.text&&"++"!==this._flags.last_token.text||this._flags.last_token.type===TOKEN.EQUALS||!this._options.preserve_newlines&&reserved_array(this._flags.last_token,["var","let","const","set","get"])?this.handle_whitespace_and_comments(current_token):(this.handle_whitespace_and_comments(current_token),this.print_newline()),this._flags.do_block&&!this._flags.do_while){if(reserved_word(current_token,"while"))return this._output.space_before_token=!0,this.print_token(current_token),this._output.space_before_token=!0,void(this._flags.do_while=!0);this.print_newline(),this._flags.do_block=!1}if(this._flags.if_block)if(!this._flags.else_block&&reserved_word(current_token,"else"))this._flags.else_block=!0;else{for(;this._flags.mode===MODE_Statement;)this.restore_mode();this._flags.if_block=!1,this._flags.else_block=!1}if(this._flags.in_case_statement&&reserved_array(current_token,["case","default"]))return this.print_newline(),this._flags.case_block||!this._flags.case_body&&!this._options.jslint_happy||this.deindent(),this._flags.case_body=!1,this.print_token(current_token),void(this._flags.in_case=!0);if(this._flags.last_token.type!==TOKEN.COMMA&&this._flags.last_token.type!==TOKEN.START_EXPR&&this._flags.last_token.type!==TOKEN.EQUALS&&this._flags.last_token.type!==TOKEN.OPERATOR||this.start_of_object_property()||in_array(this._flags.last_token.text,["+","-"])&&":"===this._last_last_text&&this._flags.parent.mode===MODE_ObjectLiteral||this.allow_wrap_or_preserved_newline(current_token),reserved_word(current_token,"function"))return(in_array(this._flags.last_token.text,["}",";"])||this._output.just_added_newline()&&!in_array(this._flags.last_token.text,["(","[","{",":","=",","])&&this._flags.last_token.type!==TOKEN.OPERATOR)&&(this._output.just_added_blankline()||current_token.comments_before||(this.print_newline(),this.print_newline(!0))),this._flags.last_token.type===TOKEN.RESERVED||this._flags.last_token.type===TOKEN.WORD?reserved_array(this._flags.last_token,["get","set","new","export"])||reserved_array(this._flags.last_token,newline_restricted_tokens)||reserved_word(this._flags.last_token,"default")&&"export"===this._last_last_text||"declare"===this._flags.last_token.text?this._output.space_before_token=!0:this.print_newline():this._flags.last_token.type===TOKEN.OPERATOR||"="===this._flags.last_token.text?this._output.space_before_token=!0:(this._flags.multiline_frame||!is_expression(this._flags.mode)&&!is_array(this._flags.mode))&&this.print_newline(),this.print_token(current_token),void(this._flags.last_word=current_token.text);var prefix="NONE";(this._flags.last_token.type===TOKEN.END_BLOCK?this._previous_flags.inline_frame?prefix="SPACE":reserved_array(current_token,["else","catch","finally","from"])?"expand"===this._options.brace_style||"end-expand"===this._options.brace_style||"none"===this._options.brace_style&&current_token.newlines?prefix="NEWLINE":(prefix="SPACE",this._output.space_before_token=!0):prefix="NEWLINE":this._flags.last_token.type===TOKEN.SEMICOLON&&this._flags.mode===MODE_BlockStatement?prefix="NEWLINE":this._flags.last_token.type===TOKEN.SEMICOLON&&is_expression(this._flags.mode)?prefix="SPACE":this._flags.last_token.type===TOKEN.STRING?prefix="NEWLINE":this._flags.last_token.type===TOKEN.RESERVED||this._flags.last_token.type===TOKEN.WORD||"*"===this._flags.last_token.text&&(in_array(this._last_last_text,["function","yield"])||this._flags.mode===MODE_ObjectLiteral&&in_array(this._last_last_text,["{",","]))?prefix="SPACE":this._flags.last_token.type===TOKEN.START_BLOCK?prefix=this._flags.inline_frame?"SPACE":"NEWLINE":this._flags.last_token.type===TOKEN.END_EXPR&&(this._output.space_before_token=!0,prefix="NEWLINE"),reserved_array(current_token,line_starters)&&")"!==this._flags.last_token.text&&(prefix=this._flags.inline_frame||"else"===this._flags.last_token.text||"export"===this._flags.last_token.text?"SPACE":"NEWLINE"),reserved_array(current_token,["else","catch","finally"]))?(this._flags.last_token.type!==TOKEN.END_BLOCK||this._previous_flags.mode!==MODE_BlockStatement||"expand"===this._options.brace_style||"end-expand"===this._options.brace_style||"none"===this._options.brace_style&&current_token.newlines)&&!this._flags.inline_frame?this.print_newline():(this._output.trim(!0),"}"!==this._output.current_line.last()&&this.print_newline(),this._output.space_before_token=!0):"NEWLINE"===prefix?reserved_array(this._flags.last_token,special_words)||"declare"===this._flags.last_token.text&&reserved_array(current_token,["var","let","const"])?this._output.space_before_token=!0:this._flags.last_token.type!==TOKEN.END_EXPR?this._flags.last_token.type===TOKEN.START_EXPR&&reserved_array(current_token,["var","let","const"])||":"===this._flags.last_token.text||(reserved_word(current_token,"if")&&reserved_word(current_token.previous,"else")?this._output.space_before_token=!0:this.print_newline()):reserved_array(current_token,line_starters)&&")"!==this._flags.last_token.text&&this.print_newline():this._flags.multiline_frame&&is_array(this._flags.mode)&&","===this._flags.last_token.text&&"}"===this._last_last_text?this.print_newline():"SPACE"===prefix&&(this._output.space_before_token=!0);!current_token.previous||current_token.previous.type!==TOKEN.WORD&&current_token.previous.type!==TOKEN.RESERVED||(this._output.space_before_token=!0),this.print_token(current_token),this._flags.last_word=current_token.text,current_token.type===TOKEN.RESERVED&&("do"===current_token.text?this._flags.do_block=!0:"if"===current_token.text?this._flags.if_block=!0:"import"===current_token.text?this._flags.import_block=!0:this._flags.import_block&&reserved_word(current_token,"from")&&(this._flags.import_block=!1))},Beautifier.prototype.handle_semicolon=function(current_token){this.start_of_statement(current_token)?this._output.space_before_token=!1:this.handle_whitespace_and_comments(current_token);for(var next_token=this._tokens.peek();!(this._flags.mode!==MODE_Statement||this._flags.if_block&&reserved_word(next_token,"else")||this._flags.do_block);)this.restore_mode();this._flags.import_block&&(this._flags.import_block=!1),this.print_token(current_token)},Beautifier.prototype.handle_string=function(current_token){(!current_token.text.startsWith("`")||0!==current_token.newlines||""!==current_token.whitespace_before||")"!==current_token.previous.text&&this._flags.last_token.type!==TOKEN.WORD)&&(this.start_of_statement(current_token)?this._output.space_before_token=!0:(this.handle_whitespace_and_comments(current_token),this._flags.last_token.type===TOKEN.RESERVED||this._flags.last_token.type===TOKEN.WORD||this._flags.inline_frame?this._output.space_before_token=!0:this._flags.last_token.type===TOKEN.COMMA||this._flags.last_token.type===TOKEN.START_EXPR||this._flags.last_token.type===TOKEN.EQUALS||this._flags.last_token.type===TOKEN.OPERATOR?this.start_of_object_property()||this.allow_wrap_or_preserved_newline(current_token):!current_token.text.startsWith("`")||this._flags.last_token.type!==TOKEN.END_EXPR||"]"!==current_token.previous.text&&")"!==current_token.previous.text||0!==current_token.newlines?this.print_newline():this._output.space_before_token=!0)),this.print_token(current_token)},Beautifier.prototype.handle_equals=function(current_token){this.start_of_statement(current_token)||this.handle_whitespace_and_comments(current_token),this._flags.declaration_statement&&(this._flags.declaration_assignment=!0),this._output.space_before_token=!0,this.print_token(current_token),this._output.space_before_token=!0},Beautifier.prototype.handle_comma=function(current_token){this.handle_whitespace_and_comments(current_token,!0),this.print_token(current_token),this._output.space_before_token=!0,this._flags.declaration_statement?(is_expression(this._flags.parent.mode)&&(this._flags.declaration_assignment=!1),this._flags.declaration_assignment?(this._flags.declaration_assignment=!1,this.print_newline(!1,!0)):this._options.comma_first&&this.allow_wrap_or_preserved_newline(current_token)):this._flags.mode===MODE_ObjectLiteral||this._flags.mode===MODE_Statement&&this._flags.parent.mode===MODE_ObjectLiteral?(this._flags.mode===MODE_Statement&&this.restore_mode(),this._flags.inline_frame||this.print_newline()):this._options.comma_first&&this.allow_wrap_or_preserved_newline(current_token)},Beautifier.prototype.handle_operator=function(current_token){var isGeneratorAsterisk="*"===current_token.text&&(reserved_array(this._flags.last_token,["function","yield"])||in_array(this._flags.last_token.type,[TOKEN.START_BLOCK,TOKEN.COMMA,TOKEN.END_BLOCK,TOKEN.SEMICOLON])),isUnary=in_array(current_token.text,["-","+"])&&(in_array(this._flags.last_token.type,[TOKEN.START_BLOCK,TOKEN.START_EXPR,TOKEN.EQUALS,TOKEN.OPERATOR])||in_array(this._flags.last_token.text,line_starters)||","===this._flags.last_token.text);if(this.start_of_statement(current_token));else{var preserve_statement_flags=!isGeneratorAsterisk;this.handle_whitespace_and_comments(current_token,preserve_statement_flags)}if("*"!==current_token.text||this._flags.last_token.type!==TOKEN.DOT)if("::"!==current_token.text)if(in_array(current_token.text,["-","+"])&&this.start_of_object_property())this.print_token(current_token);else{if(this._flags.last_token.type===TOKEN.OPERATOR&&in_array(this._options.operator_position,OPERATOR_POSITION_BEFORE_OR_PRESERVE)&&this.allow_wrap_or_preserved_newline(current_token),":"===current_token.text&&this._flags.in_case)return this.print_token(current_token),this._flags.in_case=!1,this._flags.case_body=!0,void(this._tokens.peek().type!==TOKEN.START_BLOCK?(this.indent(),this.print_newline(),this._flags.case_block=!1):(this._flags.case_block=!0,this._output.space_before_token=!0));var space_before=!0,space_after=!0,in_ternary=!1;if(":"===current_token.text?0===this._flags.ternary_depth?space_before=!1:(this._flags.ternary_depth-=1,in_ternary=!0):"?"===current_token.text&&(this._flags.ternary_depth+=1),!isUnary&&!isGeneratorAsterisk&&this._options.preserve_newlines&&in_array(current_token.text,positionable_operators)){var isColon=":"===current_token.text,isTernaryColon=isColon&&in_ternary,isOtherColon=isColon&&!in_ternary;switch(this._options.operator_position){case OPERATOR_POSITION.before_newline:return this._output.space_before_token=!isOtherColon,this.print_token(current_token),isColon&&!isTernaryColon||this.allow_wrap_or_preserved_newline(current_token),void(this._output.space_before_token=!0);case OPERATOR_POSITION.after_newline:return this._output.space_before_token=!0,!isColon||isTernaryColon?this._tokens.peek().newlines?this.print_newline(!1,!0):this.allow_wrap_or_preserved_newline(current_token):this._output.space_before_token=!1,this.print_token(current_token),void(this._output.space_before_token=!0);case OPERATOR_POSITION.preserve_newline:return isOtherColon||this.allow_wrap_or_preserved_newline(current_token),space_before=!(this._output.just_added_newline()||isOtherColon),this._output.space_before_token=space_before,this.print_token(current_token),void(this._output.space_before_token=!0)}}if(isGeneratorAsterisk){this.allow_wrap_or_preserved_newline(current_token),space_before=!1;var next_token=this._tokens.peek();space_after=next_token&&in_array(next_token.type,[TOKEN.WORD,TOKEN.RESERVED])}else if("..."===current_token.text)this.allow_wrap_or_preserved_newline(current_token),space_before=this._flags.last_token.type===TOKEN.START_BLOCK,space_after=!1;else if(in_array(current_token.text,["--","++","!","~"])||isUnary){if(this._flags.last_token.type!==TOKEN.COMMA&&this._flags.last_token.type!==TOKEN.START_EXPR||this.allow_wrap_or_preserved_newline(current_token),space_before=!1,space_after=!1,current_token.newlines&&("--"===current_token.text||"++"===current_token.text||"~"===current_token.text)){var new_line_needed=reserved_array(this._flags.last_token,special_words)&&current_token.newlines;new_line_needed&&(this._previous_flags.if_block||this._previous_flags.else_block)&&this.restore_mode(),this.print_newline(new_line_needed,!0)}";"===this._flags.last_token.text&&is_expression(this._flags.mode)&&(space_before=!0),this._flags.last_token.type===TOKEN.RESERVED?space_before=!0:this._flags.last_token.type===TOKEN.END_EXPR?space_before=!("]"===this._flags.last_token.text&&("--"===current_token.text||"++"===current_token.text)):this._flags.last_token.type===TOKEN.OPERATOR&&(space_before=in_array(current_token.text,["--","-","++","+"])&&in_array(this._flags.last_token.text,["--","-","++","+"]),in_array(current_token.text,["+","-"])&&in_array(this._flags.last_token.text,["--","++"])&&(space_after=!0)),(this._flags.mode!==MODE_BlockStatement||this._flags.inline_frame)&&this._flags.mode!==MODE_Statement||"{"!==this._flags.last_token.text&&";"!==this._flags.last_token.text||this.print_newline()}this._output.space_before_token=this._output.space_before_token||space_before,this.print_token(current_token),this._output.space_before_token=space_after}else this.print_token(current_token);else this.print_token(current_token)},Beautifier.prototype.handle_block_comment=function(current_token,preserve_statement_flags){return this._output.raw?(this._output.add_raw_token(current_token),void(current_token.directives&&"end"===current_token.directives.preserve&&(this._output.raw=this._options.test_output_raw))):current_token.directives?(this.print_newline(!1,preserve_statement_flags),this.print_token(current_token),"start"===current_token.directives.preserve&&(this._output.raw=!0),void this.print_newline(!1,!0)):acorn.newline.test(current_token.text)||current_token.newlines?void this.print_block_commment(current_token,preserve_statement_flags):(this._output.space_before_token=!0,this.print_token(current_token),void(this._output.space_before_token=!0))},Beautifier.prototype.print_block_commment=function(current_token,preserve_statement_flags){var j,lines=function(s){for(var out=[],idx=(s=s.replace(acorn.allLineBreaks,"\n")).indexOf("\n");-1!==idx;)out.push(s.substring(0,idx)),idx=(s=s.substring(idx+1)).indexOf("\n");return s.length&&out.push(s),out}(current_token.text),javadoc=!1,starless=!1,lastIndent=current_token.whitespace_before,lastIndentLength=lastIndent.length;if(this.print_newline(!1,preserve_statement_flags),this.print_token_line_indentation(current_token),this._output.add_token(lines[0]),this.print_newline(!1,preserve_statement_flags),lines.length>1){for(javadoc=function(lines,c){for(var i=0;i<lines.length;i++)if(lines[i].trim().charAt(0)!==c)return!1;return!0}(lines=lines.slice(1),"*"),starless=function(lines,indent){for(var line,i=0,len=lines.length;i<len;i++)if((line=lines[i])&&0!==line.indexOf(indent))return!1;return!0}(lines,lastIndent),javadoc&&(this._flags.alignment=1),j=0;j<lines.length;j++)javadoc?(this.print_token_line_indentation(current_token),this._output.add_token(lines[j].replace(/^\s+/g,""))):starless&&lines[j]?(this.print_token_line_indentation(current_token),this._output.add_token(lines[j].substring(lastIndentLength))):(this._output.current_line.set_indent(-1),this._output.add_token(lines[j])),this.print_newline(!1,preserve_statement_flags);this._flags.alignment=0}},Beautifier.prototype.handle_comment=function(current_token,preserve_statement_flags){current_token.newlines?this.print_newline(!1,preserve_statement_flags):this._output.trim(!0),this._output.space_before_token=!0,this.print_token(current_token),this.print_newline(!1,preserve_statement_flags)},Beautifier.prototype.handle_dot=function(current_token){this.start_of_statement(current_token)||this.handle_whitespace_and_comments(current_token,!0),this._flags.last_token.text.match("^[0-9]+$")&&(this._output.space_before_token=!0),reserved_array(this._flags.last_token,special_words)?this._output.space_before_token=!1:this.allow_wrap_or_preserved_newline(current_token,")"===this._flags.last_token.text&&this._options.break_chained_methods),this._options.unindent_chained_methods&&this._output.just_added_newline()&&this.deindent(),this.print_token(current_token)},Beautifier.prototype.handle_unknown=function(current_token,preserve_statement_flags){this.print_token(current_token),"\n"===current_token.text[current_token.text.length-1]&&this.print_newline(!1,preserve_statement_flags)},Beautifier.prototype.handle_eof=function(current_token){for(;this._flags.mode===MODE_Statement;)this.restore_mode();this.handle_whitespace_and_comments(current_token)},beautifier$2.Beautifier=Beautifier,beautifier$2}var hasRequiredOptions$1,hasRequiredBeautifier$1,hasRequiredCss,css={exports:{}},beautifier$1={},options$1={};function requireOptions$1(){if(hasRequiredOptions$1)return options$1;hasRequiredOptions$1=1;var BaseOptions=requireOptions$3().Options;function Options(options){BaseOptions.call(this,options,"css"),this.selector_separator_newline=this._get_boolean("selector_separator_newline",!0),this.newline_between_rules=this._get_boolean("newline_between_rules",!0);var space_around_selector_separator=this._get_boolean("space_around_selector_separator");this.space_around_combinator=this._get_boolean("space_around_combinator")||space_around_selector_separator;var brace_style_split=this._get_selection_list("brace_style",["collapse","expand","end-expand","none","preserve-inline"]);this.brace_style="collapse";for(var bs=0;bs<brace_style_split.length;bs++)"expand"!==brace_style_split[bs]?this.brace_style="collapse":this.brace_style=brace_style_split[bs]}return Options.prototype=new BaseOptions,options$1.Options=Options,options$1}function requireCss(){if(hasRequiredCss)return css.exports;hasRequiredCss=1;var Beautifier=function(){if(hasRequiredBeautifier$1)return beautifier$1;hasRequiredBeautifier$1=1;var Options=requireOptions$1().Options,Output=requireOutput().Output,InputScanner=requireInputscanner().InputScanner,directives_core=new(0,requireDirectives().Directives)(/\/\*/,/\*\//),lineBreak=/\r\n|[\r\n]/,allLineBreaks=/\r\n|[\r\n]/g,whitespaceChar=/\s/,whitespacePattern=/(?:\s|\n)+/g,block_comment_pattern=/\/\*(?:[\s\S]*?)((?:\*\/)|$)/g,comment_pattern=/\/\/(?:[^\n\r\u2028\u2029]*)/g;function Beautifier(source_text,options){this._source_text=source_text||"",this._options=new Options(options),this._ch=null,this._input=null,this.NESTED_AT_RULE={page:!0,"font-face":!0,keyframes:!0,media:!0,supports:!0,document:!0},this.CONDITIONAL_GROUP_RULE={media:!0,supports:!0,document:!0},this.NON_SEMICOLON_NEWLINE_PROPERTY=["grid-template-areas","grid-template"]}return Beautifier.prototype.eatString=function(endChars){var result="";for(this._ch=this._input.next();this._ch;){if(result+=this._ch,"\\"===this._ch)result+=this._input.next();else if(-1!==endChars.indexOf(this._ch)||"\n"===this._ch)break;this._ch=this._input.next()}return result},Beautifier.prototype.eatWhitespace=function(allowAtLeastOneNewLine){for(var result=whitespaceChar.test(this._input.peek()),newline_count=0;whitespaceChar.test(this._input.peek());)this._ch=this._input.next(),allowAtLeastOneNewLine&&"\n"===this._ch&&(0===newline_count||newline_count<this._options.max_preserve_newlines)&&(newline_count++,this._output.add_new_line(!0));return result},Beautifier.prototype.foundNestedPseudoClass=function(){for(var openParen=0,i=1,ch=this._input.peek(i);ch;){if("{"===ch)return!0;if("("===ch)openParen+=1;else if(")"===ch){if(0===openParen)return!1;openParen-=1}else if(";"===ch||"}"===ch)return!1;i++,ch=this._input.peek(i)}return!1},Beautifier.prototype.print_string=function(output_string){this._output.set_indent(this._indentLevel),this._output.non_breaking_space=!0,this._output.add_token(output_string)},Beautifier.prototype.preserveSingleSpace=function(isAfterSpace){isAfterSpace&&(this._output.space_before_token=!0)},Beautifier.prototype.indent=function(){this._indentLevel++},Beautifier.prototype.outdent=function(){this._indentLevel>0&&this._indentLevel--},Beautifier.prototype.beautify=function(){if(this._options.disabled)return this._source_text;var source_text=this._source_text,eol=this._options.eol;"auto"===eol&&(eol="\n",source_text&&lineBreak.test(source_text||"")&&(eol=source_text.match(lineBreak)[0]));var baseIndentString=(source_text=source_text.replace(allLineBreaks,"\n")).match(/^[\t ]*/)[0];this._output=new Output(this._options,baseIndentString),this._input=new InputScanner(source_text),this._indentLevel=0,this._nestedLevel=0,this._ch=null;for(var isAfterSpace,previous_ch,parenLevel=0,insideRule=!1,insidePropertyValue=!1,enteringConditionalGroup=!1,insideNonNestedAtRule=!1,insideScssMap=!1,topCharacter=this._ch,insideNonSemiColonValues=!1;isAfterSpace=""!==this._input.read(whitespacePattern),previous_ch=topCharacter,this._ch=this._input.next(),"\\"===this._ch&&this._input.hasNext()&&(this._ch+=this._input.next()),topCharacter=this._ch,this._ch;)if("/"===this._ch&&"*"===this._input.peek()){this._output.add_new_line(),this._input.back();var comment=this._input.read(block_comment_pattern),directives=directives_core.get_directives(comment);directives&&"start"===directives.ignore&&(comment+=directives_core.readIgnored(this._input)),this.print_string(comment),this.eatWhitespace(!0),this._output.add_new_line()}else if("/"===this._ch&&"/"===this._input.peek())this._output.space_before_token=!0,this._input.back(),this.print_string(this._input.read(comment_pattern)),this.eatWhitespace(!0);else if("$"===this._ch){this.preserveSingleSpace(isAfterSpace),this.print_string(this._ch);var variable=this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);variable.match(/[ :]$/)&&(variable=this.eatString(": ").replace(/\s+$/,""),this.print_string(variable),this._output.space_before_token=!0),0===parenLevel&&-1!==variable.indexOf(":")&&(insidePropertyValue=!0,this.indent())}else if("@"===this._ch)if(this.preserveSingleSpace(isAfterSpace),"{"===this._input.peek())this.print_string(this._ch+this.eatString("}"));else{this.print_string(this._ch);var variableOrRule=this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);variableOrRule.match(/[ :]$/)&&(variableOrRule=this.eatString(": ").replace(/\s+$/,""),this.print_string(variableOrRule),this._output.space_before_token=!0),0===parenLevel&&-1!==variableOrRule.indexOf(":")?(insidePropertyValue=!0,this.indent()):variableOrRule in this.NESTED_AT_RULE?(this._nestedLevel+=1,variableOrRule in this.CONDITIONAL_GROUP_RULE&&(enteringConditionalGroup=!0)):0!==parenLevel||insidePropertyValue||(insideNonNestedAtRule=!0)}else if("#"===this._ch&&"{"===this._input.peek())this.preserveSingleSpace(isAfterSpace),this.print_string(this._ch+this.eatString("}"));else if("{"===this._ch)insidePropertyValue&&(insidePropertyValue=!1,this.outdent()),insideNonNestedAtRule=!1,enteringConditionalGroup?(enteringConditionalGroup=!1,insideRule=this._indentLevel>=this._nestedLevel):insideRule=this._indentLevel>=this._nestedLevel-1,this._options.newline_between_rules&&insideRule&&this._output.previous_line&&"{"!==this._output.previous_line.item(-1)&&this._output.ensure_empty_line_above("/",","),this._output.space_before_token=!0,"expand"===this._options.brace_style?(this._output.add_new_line(),this.print_string(this._ch),this.indent(),this._output.set_indent(this._indentLevel)):("("===previous_ch?this._output.space_before_token=!1:","!==previous_ch&&this.indent(),this.print_string(this._ch)),this.eatWhitespace(!0),this._output.add_new_line();else if("}"===this._ch)this.outdent(),this._output.add_new_line(),"{"===previous_ch&&this._output.trim(!0),insidePropertyValue&&(this.outdent(),insidePropertyValue=!1),this.print_string(this._ch),insideRule=!1,this._nestedLevel&&this._nestedLevel--,this.eatWhitespace(!0),this._output.add_new_line(),this._options.newline_between_rules&&!this._output.just_added_blankline()&&"}"!==this._input.peek()&&this._output.add_new_line(!0),")"===this._input.peek()&&(this._output.trim(!0),"expand"===this._options.brace_style&&this._output.add_new_line(!0));else if(":"===this._ch){for(var i=0;i<this.NON_SEMICOLON_NEWLINE_PROPERTY.length;i++)if(this._input.lookBack(this.NON_SEMICOLON_NEWLINE_PROPERTY[i])){insideNonSemiColonValues=!0;break}!insideRule&&!enteringConditionalGroup||this._input.lookBack("&")||this.foundNestedPseudoClass()||this._input.lookBack("(")||insideNonNestedAtRule||0!==parenLevel?(this._input.lookBack(" ")&&(this._output.space_before_token=!0),":"===this._input.peek()?(this._ch=this._input.next(),this.print_string("::")):this.print_string(":")):(this.print_string(":"),insidePropertyValue||(insidePropertyValue=!0,this._output.space_before_token=!0,this.eatWhitespace(!0),this.indent()))}else if('"'===this._ch||"'"===this._ch){var preserveQuoteSpace='"'===previous_ch||"'"===previous_ch;this.preserveSingleSpace(preserveQuoteSpace||isAfterSpace),this.print_string(this._ch+this.eatString(this._ch)),this.eatWhitespace(!0)}else if(";"===this._ch)insideNonSemiColonValues=!1,0===parenLevel?(insidePropertyValue&&(this.outdent(),insidePropertyValue=!1),insideNonNestedAtRule=!1,this.print_string(this._ch),this.eatWhitespace(!0),"/"!==this._input.peek()&&this._output.add_new_line()):(this.print_string(this._ch),this.eatWhitespace(!0),this._output.space_before_token=!0);else if("("===this._ch)if(this._input.lookBack("url"))this.print_string(this._ch),this.eatWhitespace(),parenLevel++,this.indent(),this._ch=this._input.next(),")"===this._ch||'"'===this._ch||"'"===this._ch?this._input.back():this._ch&&(this.print_string(this._ch+this.eatString(")")),parenLevel&&(parenLevel--,this.outdent()));else{var space_needed=!1;this._input.lookBack("with")&&(space_needed=!0),this.preserveSingleSpace(isAfterSpace||space_needed),this.print_string(this._ch),insidePropertyValue&&"$"===previous_ch&&this._options.selector_separator_newline?(this._output.add_new_line(),insideScssMap=!0):(this.eatWhitespace(),parenLevel++,this.indent())}else if(")"===this._ch)parenLevel&&(parenLevel--,this.outdent()),insideScssMap&&";"===this._input.peek()&&this._options.selector_separator_newline&&(insideScssMap=!1,this.outdent(),this._output.add_new_line()),this.print_string(this._ch);else if(","===this._ch)this.print_string(this._ch),this.eatWhitespace(!0),!this._options.selector_separator_newline||insidePropertyValue&&!insideScssMap||0!==parenLevel||insideNonNestedAtRule?this._output.space_before_token=!0:this._output.add_new_line();else if(">"!==this._ch&&"+"!==this._ch&&"~"!==this._ch||insidePropertyValue||0!==parenLevel)if("]"===this._ch)this.print_string(this._ch);else if("["===this._ch)this.preserveSingleSpace(isAfterSpace),this.print_string(this._ch);else if("="===this._ch)this.eatWhitespace(),this.print_string("="),whitespaceChar.test(this._ch)&&(this._ch="");else if("!"!==this._ch||this._input.lookBack("\\")){var preserveAfterSpace='"'===previous_ch||"'"===previous_ch;this.preserveSingleSpace(preserveAfterSpace||isAfterSpace),this.print_string(this._ch),!this._output.just_added_newline()&&"\n"===this._input.peek()&&insideNonSemiColonValues&&this._output.add_new_line()}else this._output.space_before_token=!0,this.print_string(this._ch);else this._options.space_around_combinator?(this._output.space_before_token=!0,this.print_string(this._ch),this._output.space_before_token=!0):(this.print_string(this._ch),this.eatWhitespace(),this._ch&&whitespaceChar.test(this._ch)&&(this._ch=""));return this._output.get_code(eol)},beautifier$1.Beautifier=Beautifier,beautifier$1}().Beautifier,Options=requireOptions$1().Options;return css.exports=function(source_text,options){return new Beautifier(source_text,options).beautify()},css.exports.defaultOptions=function(){return new Options},css.exports}var hasRequiredOptions,html={exports:{}},beautifier={},options={};function requireOptions(){if(hasRequiredOptions)return options;hasRequiredOptions=1;var BaseOptions=requireOptions$3().Options;function Options(options){BaseOptions.call(this,options,"html"),1===this.templating.length&&"auto"===this.templating[0]&&(this.templating=["django","erb","handlebars","php"]),this.indent_inner_html=this._get_boolean("indent_inner_html"),this.indent_body_inner_html=this._get_boolean("indent_body_inner_html",!0),this.indent_head_inner_html=this._get_boolean("indent_head_inner_html",!0),this.indent_handlebars=this._get_boolean("indent_handlebars",!0),this.wrap_attributes=this._get_selection("wrap_attributes",["auto","force","force-aligned","force-expand-multiline","aligned-multiple","preserve","preserve-aligned"]),this.wrap_attributes_min_attrs=this._get_number("wrap_attributes_min_attrs",2),this.wrap_attributes_indent_size=this._get_number("wrap_attributes_indent_size",this.indent_size),this.extra_liners=this._get_array("extra_liners",["head","body","/html"]),this.inline=this._get_array("inline",["a","abbr","area","audio","b","bdi","bdo","br","button","canvas","cite","code","data","datalist","del","dfn","em","embed","i","iframe","img","input","ins","kbd","keygen","label","map","mark","math","meter","noscript","object","output","progress","q","ruby","s","samp","select","small","span","strong","sub","sup","svg","template","textarea","time","u","var","video","wbr","text","acronym","big","strike","tt"]),this.inline_custom_elements=this._get_boolean("inline_custom_elements",!0),this.void_elements=this._get_array("void_elements",["area","base","br","col","embed","hr","img","input","keygen","link","menuitem","meta","param","source","track","wbr","!doctype","?xml","basefont","isindex"]),this.unformatted=this._get_array("unformatted",[]),this.content_unformatted=this._get_array("content_unformatted",["pre","textarea"]),this.unformatted_content_delimiter=this._get_characters("unformatted_content_delimiter"),this.indent_scripts=this._get_selection("indent_scripts",["normal","keep","separate"])}return Options.prototype=new BaseOptions,options.Options=Options,options}var hasRequiredTokenizer,hasRequiredBeautifier,hasRequiredHtml,hasRequiredSrc,hasRequiredJs,tokenizer={};function requireTokenizer(){if(hasRequiredTokenizer)return tokenizer;hasRequiredTokenizer=1;var BaseTokenizer=requireTokenizer$2().Tokenizer,BASETOKEN=requireTokenizer$2().TOKEN,Directives=requireDirectives().Directives,TemplatablePattern=requireTemplatablepattern().TemplatablePattern,Pattern=requirePattern().Pattern,TOKEN={TAG_OPEN:"TK_TAG_OPEN",TAG_CLOSE:"TK_TAG_CLOSE",CONTROL_FLOW_OPEN:"TK_CONTROL_FLOW_OPEN",CONTROL_FLOW_CLOSE:"TK_CONTROL_FLOW_CLOSE",ATTRIBUTE:"TK_ATTRIBUTE",EQUALS:"TK_EQUALS",VALUE:"TK_VALUE",COMMENT:"TK_COMMENT",TEXT:"TK_TEXT",UNKNOWN:"TK_UNKNOWN",START:BASETOKEN.START,RAW:BASETOKEN.RAW,EOF:BASETOKEN.EOF},directives_core=new Directives(/<\!--/,/-->/),Tokenizer=function(input_string,options){BaseTokenizer.call(this,input_string,options),this._current_tag_name="";var templatable_reader=new TemplatablePattern(this._input).read_options(this._options),pattern_reader=new Pattern(this._input);if(this.__patterns={word:templatable_reader.until(/[\n\r\t <]/),word_control_flow_close_excluded:templatable_reader.until(/[\n\r\t <}]/),single_quote:templatable_reader.until_after(/'/),double_quote:templatable_reader.until_after(/"/),attribute:templatable_reader.until(/[\n\r\t =>]|\/>/),element_name:templatable_reader.until(/[\n\r\t >\/]/),angular_control_flow_start:pattern_reader.matching(/\@[a-zA-Z]+[^({]*[({]/),handlebars_comment:pattern_reader.starting_with(/{{!--/).until_after(/--}}/),handlebars:pattern_reader.starting_with(/{{/).until_after(/}}/),handlebars_open:pattern_reader.until(/[\n\r\t }]/),handlebars_raw_close:pattern_reader.until(/}}/),comment:pattern_reader.starting_with(/<!--/).until_after(/-->/),cdata:pattern_reader.starting_with(/<!\[CDATA\[/).until_after(/]]>/),conditional_comment:pattern_reader.starting_with(/<!\[/).until_after(/]>/),processing:pattern_reader.starting_with(/<\?/).until_after(/\?>/)},this._options.indent_handlebars&&(this.__patterns.word=this.__patterns.word.exclude("handlebars"),this.__patterns.word_control_flow_close_excluded=this.__patterns.word_control_flow_close_excluded.exclude("handlebars")),this._unformatted_content_delimiter=null,this._options.unformatted_content_delimiter){var literal_regexp=this._input.get_literal_regexp(this._options.unformatted_content_delimiter);this.__patterns.unformatted_content_delimiter=pattern_reader.matching(literal_regexp).until_after(literal_regexp)}};return(Tokenizer.prototype=new BaseTokenizer)._is_comment=function(current_token){return!1},Tokenizer.prototype._is_opening=function(current_token){return current_token.type===TOKEN.TAG_OPEN||current_token.type===TOKEN.CONTROL_FLOW_OPEN},Tokenizer.prototype._is_closing=function(current_token,open_token){return current_token.type===TOKEN.TAG_CLOSE&&open_token&&((">"===current_token.text||"/>"===current_token.text)&&"<"===open_token.text[0]||"}}"===current_token.text&&"{"===open_token.text[0]&&"{"===open_token.text[1])||current_token.type===TOKEN.CONTROL_FLOW_CLOSE&&"}"===current_token.text&&open_token.text.endsWith("{")},Tokenizer.prototype._reset=function(){this._current_tag_name=""},Tokenizer.prototype._get_next_token=function(previous_token,open_token){var token=null;this._readWhitespace();var c=this._input.peek();return null===c?this._create_token(TOKEN.EOF,""):token=(token=(token=(token=(token=(token=(token=(token=(token=(token=(token=token||this._read_open_handlebars(c,open_token))||this._read_attribute(c,previous_token,open_token))||this._read_close(c,open_token))||this._read_script_and_style(c,previous_token))||this._read_control_flows(c,open_token))||this._read_raw_content(c,previous_token,open_token))||this._read_content_word(c,open_token))||this._read_comment_or_cdata(c))||this._read_processing(c))||this._read_open(c,open_token))||this._create_token(TOKEN.UNKNOWN,this._input.next())},Tokenizer.prototype._read_comment_or_cdata=function(c){var token=null,resulting_string=null,directives=null;"<"===c&&("!"===this._input.peek(1)&&((resulting_string=this.__patterns.comment.read())?(directives=directives_core.get_directives(resulting_string))&&"start"===directives.ignore&&(resulting_string+=directives_core.readIgnored(this._input)):resulting_string=this.__patterns.cdata.read()),resulting_string&&((token=this._create_token(TOKEN.COMMENT,resulting_string)).directives=directives));return token},Tokenizer.prototype._read_processing=function(c){var token=null,resulting_string=null;if("<"===c){var peek1=this._input.peek(1);"!"!==peek1&&"?"!==peek1||(resulting_string=(resulting_string=this.__patterns.conditional_comment.read())||this.__patterns.processing.read()),resulting_string&&((token=this._create_token(TOKEN.COMMENT,resulting_string)).directives=null)}return token},Tokenizer.prototype._read_open=function(c,open_token){var resulting_string=null,token=null;return open_token&&open_token.type!==TOKEN.CONTROL_FLOW_OPEN||"<"===c&&(resulting_string=this._input.next(),"/"===this._input.peek()&&(resulting_string+=this._input.next()),resulting_string+=this.__patterns.element_name.read(),token=this._create_token(TOKEN.TAG_OPEN,resulting_string)),token},Tokenizer.prototype._read_open_handlebars=function(c,open_token){var resulting_string=null,token=null;return open_token&&open_token.type!==TOKEN.CONTROL_FLOW_OPEN||(this._options.templating.includes("angular")||this._options.indent_handlebars)&&"{"===c&&"{"===this._input.peek(1)&&(this._options.indent_handlebars&&"!"===this._input.peek(2)?(resulting_string=(resulting_string=this.__patterns.handlebars_comment.read())||this.__patterns.handlebars.read(),token=this._create_token(TOKEN.COMMENT,resulting_string)):(resulting_string=this.__patterns.handlebars_open.read(),token=this._create_token(TOKEN.TAG_OPEN,resulting_string))),token},Tokenizer.prototype._read_control_flows=function(c,open_token){var resulting_string="",token=null;if(!this._options.templating.includes("angular"))return token;if("@"===c){if(""===(resulting_string=this.__patterns.angular_control_flow_start.read()))return token;for(var opening_parentheses_count=resulting_string.endsWith("(")?1:0,closing_parentheses_count=0;!resulting_string.endsWith("{")||opening_parentheses_count!==closing_parentheses_count;){var next_char=this._input.next();if(null===next_char)break;"("===next_char?opening_parentheses_count++:")"===next_char&&closing_parentheses_count++,resulting_string+=next_char}token=this._create_token(TOKEN.CONTROL_FLOW_OPEN,resulting_string)}else"}"===c&&open_token&&open_token.type===TOKEN.CONTROL_FLOW_OPEN&&(resulting_string=this._input.next(),token=this._create_token(TOKEN.CONTROL_FLOW_CLOSE,resulting_string));return token},Tokenizer.prototype._read_close=function(c,open_token){var resulting_string=null,token=null;return open_token&&open_token.type===TOKEN.TAG_OPEN&&("<"===open_token.text[0]&&(">"===c||"/"===c&&">"===this._input.peek(1))?(resulting_string=this._input.next(),"/"===c&&(resulting_string+=this._input.next()),token=this._create_token(TOKEN.TAG_CLOSE,resulting_string)):"{"===open_token.text[0]&&"}"===c&&"}"===this._input.peek(1)&&(this._input.next(),this._input.next(),token=this._create_token(TOKEN.TAG_CLOSE,"}}"))),token},Tokenizer.prototype._read_attribute=function(c,previous_token,open_token){var token=null,resulting_string="";if(open_token&&"<"===open_token.text[0])if("="===c)token=this._create_token(TOKEN.EQUALS,this._input.next());else if('"'===c||"'"===c){var content=this._input.next();content+='"'===c?this.__patterns.double_quote.read():this.__patterns.single_quote.read(),token=this._create_token(TOKEN.VALUE,content)}else(resulting_string=this.__patterns.attribute.read())&&(token=previous_token.type===TOKEN.EQUALS?this._create_token(TOKEN.VALUE,resulting_string):this._create_token(TOKEN.ATTRIBUTE,resulting_string));return token},Tokenizer.prototype._is_content_unformatted=function(tag_name){return-1===this._options.void_elements.indexOf(tag_name)&&(-1!==this._options.content_unformatted.indexOf(tag_name)||-1!==this._options.unformatted.indexOf(tag_name))},Tokenizer.prototype._read_raw_content=function(c,previous_token,open_token){var resulting_string="";if(open_token&&"{"===open_token.text[0])resulting_string=this.__patterns.handlebars_raw_close.read();else if(previous_token.type===TOKEN.TAG_CLOSE&&"<"===previous_token.opened.text[0]&&"/"!==previous_token.text[0]){var tag_name=previous_token.opened.text.substr(1).toLowerCase();this._is_content_unformatted(tag_name)&&(resulting_string=this._input.readUntil(new RegExp("</"+tag_name+"[\\n\\r\\t ]*?>","ig")))}return resulting_string?this._create_token(TOKEN.TEXT,resulting_string):null},Tokenizer.prototype._read_script_and_style=function(c,previous_token){if(previous_token.type===TOKEN.TAG_CLOSE&&"<"===previous_token.opened.text[0]&&"/"!==previous_token.text[0]){var tag_name=previous_token.opened.text.substr(1).toLowerCase();if("script"===tag_name||"style"===tag_name){var token=this._read_comment_or_cdata(c);if(token)return token.type=TOKEN.TEXT,token;var resulting_string=this._input.readUntil(new RegExp("</"+tag_name+"[\\n\\r\\t ]*?>","ig"));if(resulting_string)return this._create_token(TOKEN.TEXT,resulting_string)}}return null},Tokenizer.prototype._read_content_word=function(c,open_token){var resulting_string="";return this._options.unformatted_content_delimiter&&c===this._options.unformatted_content_delimiter[0]&&(resulting_string=this.__patterns.unformatted_content_delimiter.read()),resulting_string||(resulting_string=open_token&&open_token.type===TOKEN.CONTROL_FLOW_OPEN?this.__patterns.word_control_flow_close_excluded.read():this.__patterns.word.read()),resulting_string?this._create_token(TOKEN.TEXT,resulting_string):null},tokenizer.Tokenizer=Tokenizer,tokenizer.TOKEN=TOKEN,tokenizer}function requireBeautifier(){if(hasRequiredBeautifier)return beautifier;hasRequiredBeautifier=1;var Options=requireOptions().Options,Output=requireOutput().Output,Tokenizer=requireTokenizer().Tokenizer,TOKEN=requireTokenizer().TOKEN,lineBreak=/\r\n|[\r\n]/,allLineBreaks=/\r\n|[\r\n]/g,Printer=function(options,base_indent_string){this.indent_level=0,this.alignment_size=0,this.max_preserve_newlines=options.max_preserve_newlines,this.preserve_newlines=options.preserve_newlines,this._output=new Output(options,base_indent_string)};Printer.prototype.current_line_has_match=function(pattern){return this._output.current_line.has_match(pattern)},Printer.prototype.set_space_before_token=function(value,non_breaking){this._output.space_before_token=value,this._output.non_breaking_space=non_breaking},Printer.prototype.set_wrap_point=function(){this._output.set_indent(this.indent_level,this.alignment_size),this._output.set_wrap_point()},Printer.prototype.add_raw_token=function(token){this._output.add_raw_token(token)},Printer.prototype.print_preserved_newlines=function(raw_token){var newlines=0;raw_token.type!==TOKEN.TEXT&&raw_token.previous.type!==TOKEN.TEXT&&(newlines=raw_token.newlines?1:0),this.preserve_newlines&&(newlines=raw_token.newlines<this.max_preserve_newlines+1?raw_token.newlines:this.max_preserve_newlines+1);for(var n=0;n<newlines;n++)this.print_newline(n>0);return 0!==newlines},Printer.prototype.traverse_whitespace=function(raw_token){return!(!raw_token.whitespace_before&&!raw_token.newlines)&&(this.print_preserved_newlines(raw_token)||(this._output.space_before_token=!0),!0)},Printer.prototype.previous_token_wrapped=function(){return this._output.previous_token_wrapped},Printer.prototype.print_newline=function(force){this._output.add_new_line(force)},Printer.prototype.print_token=function(token){token.text&&(this._output.set_indent(this.indent_level,this.alignment_size),this._output.add_token(token.text))},Printer.prototype.indent=function(){this.indent_level++},Printer.prototype.deindent=function(){this.indent_level>0&&(this.indent_level--,this._output.set_indent(this.indent_level,this.alignment_size))},Printer.prototype.get_full_indent=function(level){return(level=this.indent_level+(level||0))<1?"":this._output.get_indent_string(level)};var get_custom_beautifier_name=function(tag_check,raw_token){var typeAttribute=null,result=null;return raw_token.closed?("script"===tag_check?typeAttribute="text/javascript":"style"===tag_check&&(typeAttribute="text/css"),typeAttribute=function(start_token){for(var result=null,raw_token=start_token.next;raw_token.type!==TOKEN.EOF&&start_token.closed!==raw_token;){if(raw_token.type===TOKEN.ATTRIBUTE&&"type"===raw_token.text){raw_token.next&&raw_token.next.type===TOKEN.EQUALS&&raw_token.next.next&&raw_token.next.next.type===TOKEN.VALUE&&(result=raw_token.next.next.text);break}raw_token=raw_token.next}return result}(raw_token)||typeAttribute,typeAttribute.search("text/css")>-1?result="css":typeAttribute.search(/module|((text|application|dojo)\/(x-)?(javascript|ecmascript|jscript|livescript|(ld\+)?json|method|aspect))/)>-1?result="javascript":typeAttribute.search(/(text|application|dojo)\/(x-)?(html)/)>-1?result="html":typeAttribute.search(/test\/null/)>-1&&(result="null"),result):null};function in_array(what,arr){return-1!==arr.indexOf(what)}function TagFrame(parent,parser_token,indent_level){this.parent=parent||null,this.tag=parser_token?parser_token.tag_name:"",this.indent_level=indent_level||0,this.parser_token=parser_token||null}function TagStack(printer){this._printer=printer,this._current_frame=null}function Beautifier(source_text,options,js_beautify,css_beautify){this._source_text=source_text||"",options=options||{},this._js_beautify=js_beautify,this._css_beautify=css_beautify,this._tag_stack=null;var optionHtml=new Options(options,"html");this._options=optionHtml,this._is_wrap_attributes_force="force"===this._options.wrap_attributes.substr(0,"force".length),this._is_wrap_attributes_force_expand_multiline="force-expand-multiline"===this._options.wrap_attributes,this._is_wrap_attributes_force_aligned="force-aligned"===this._options.wrap_attributes,this._is_wrap_attributes_aligned_multiple="aligned-multiple"===this._options.wrap_attributes,this._is_wrap_attributes_preserve="preserve"===this._options.wrap_attributes.substr(0,"preserve".length),this._is_wrap_attributes_preserve_aligned="preserve-aligned"===this._options.wrap_attributes}TagStack.prototype.get_parser_token=function(){return this._current_frame?this._current_frame.parser_token:null},TagStack.prototype.record_tag=function(parser_token){var new_frame=new TagFrame(this._current_frame,parser_token,this._printer.indent_level);this._current_frame=new_frame},TagStack.prototype._try_pop_frame=function(frame){var parser_token=null;return frame&&(parser_token=frame.parser_token,this._printer.indent_level=frame.indent_level,this._current_frame=frame.parent),parser_token},TagStack.prototype._get_frame=function(tag_list,stop_list){for(var frame=this._current_frame;frame&&-1===tag_list.indexOf(frame.tag);){if(stop_list&&-1!==stop_list.indexOf(frame.tag)){frame=null;break}frame=frame.parent}return frame},TagStack.prototype.try_pop=function(tag,stop_list){var frame=this._get_frame([tag],stop_list);return this._try_pop_frame(frame)},TagStack.prototype.indent_to_tag=function(tag_list){var frame=this._get_frame(tag_list);frame&&(this._printer.indent_level=frame.indent_level)},Beautifier.prototype.beautify=function(){if(this._options.disabled)return this._source_text;var source_text=this._source_text,eol=this._options.eol;"auto"===this._options.eol&&(eol="\n",source_text&&lineBreak.test(source_text)&&(eol=source_text.match(lineBreak)[0]));var baseIndentString=(source_text=source_text.replace(allLineBreaks,"\n")).match(/^[\t ]*/)[0],last_token={text:"",type:""},last_tag_token=new TagOpenParserToken(this._options),printer=new Printer(this._options,baseIndentString),tokens=new Tokenizer(source_text,this._options).tokenize();this._tag_stack=new TagStack(printer);for(var parser_token=null,raw_token=tokens.next();raw_token.type!==TOKEN.EOF;)raw_token.type===TOKEN.TAG_OPEN||raw_token.type===TOKEN.COMMENT?last_tag_token=parser_token=this._handle_tag_open(printer,raw_token,last_tag_token,last_token,tokens):raw_token.type===TOKEN.ATTRIBUTE||raw_token.type===TOKEN.EQUALS||raw_token.type===TOKEN.VALUE||raw_token.type===TOKEN.TEXT&&!last_tag_token.tag_complete?parser_token=this._handle_inside_tag(printer,raw_token,last_tag_token,last_token):raw_token.type===TOKEN.TAG_CLOSE?parser_token=this._handle_tag_close(printer,raw_token,last_tag_token):raw_token.type===TOKEN.TEXT?parser_token=this._handle_text(printer,raw_token,last_tag_token):raw_token.type===TOKEN.CONTROL_FLOW_OPEN?parser_token=this._handle_control_flow_open(printer,raw_token):raw_token.type===TOKEN.CONTROL_FLOW_CLOSE?parser_token=this._handle_control_flow_close(printer,raw_token):printer.add_raw_token(raw_token),last_token=parser_token,raw_token=tokens.next();return printer._output.get_code(eol)},Beautifier.prototype._handle_control_flow_open=function(printer,raw_token){var parser_token={text:raw_token.text,type:raw_token.type};return printer.set_space_before_token(raw_token.newlines||""!==raw_token.whitespace_before,!0),raw_token.newlines?printer.print_preserved_newlines(raw_token):printer.set_space_before_token(raw_token.newlines||""!==raw_token.whitespace_before,!0),printer.print_token(raw_token),printer.indent(),parser_token},Beautifier.prototype._handle_control_flow_close=function(printer,raw_token){var parser_token={text:raw_token.text,type:raw_token.type};return printer.deindent(),raw_token.newlines?printer.print_preserved_newlines(raw_token):printer.set_space_before_token(raw_token.newlines||""!==raw_token.whitespace_before,!0),printer.print_token(raw_token),parser_token},Beautifier.prototype._handle_tag_close=function(printer,raw_token,last_tag_token){var parser_token={text:raw_token.text,type:raw_token.type};return printer.alignment_size=0,last_tag_token.tag_complete=!0,printer.set_space_before_token(raw_token.newlines||""!==raw_token.whitespace_before,!0),last_tag_token.is_unformatted?printer.add_raw_token(raw_token):("<"===last_tag_token.tag_start_char&&(printer.set_space_before_token("/"===raw_token.text[0],!0),this._is_wrap_attributes_force_expand_multiline&&last_tag_token.has_wrapped_attrs&&printer.print_newline(!1)),printer.print_token(raw_token)),!last_tag_token.indent_content||last_tag_token.is_unformatted||last_tag_token.is_content_unformatted||(printer.indent(),last_tag_token.indent_content=!1),last_tag_token.is_inline_element||last_tag_token.is_unformatted||last_tag_token.is_content_unformatted||printer.set_wrap_point(),parser_token},Beautifier.prototype._handle_inside_tag=function(printer,raw_token,last_tag_token,last_token){var wrapped=last_tag_token.has_wrapped_attrs,parser_token={text:raw_token.text,type:raw_token.type};return printer.set_space_before_token(raw_token.newlines||""!==raw_token.whitespace_before,!0),last_tag_token.is_unformatted?printer.add_raw_token(raw_token):"{"===last_tag_token.tag_start_char&&raw_token.type===TOKEN.TEXT?printer.print_preserved_newlines(raw_token)?(raw_token.newlines=0,printer.add_raw_token(raw_token)):printer.print_token(raw_token):(raw_token.type===TOKEN.ATTRIBUTE?printer.set_space_before_token(!0):(raw_token.type===TOKEN.EQUALS||raw_token.type===TOKEN.VALUE&&raw_token.previous.type===TOKEN.EQUALS)&&printer.set_space_before_token(!1),raw_token.type===TOKEN.ATTRIBUTE&&"<"===last_tag_token.tag_start_char&&((this._is_wrap_attributes_preserve||this._is_wrap_attributes_preserve_aligned)&&(printer.traverse_whitespace(raw_token),wrapped=wrapped||0!==raw_token.newlines),this._is_wrap_attributes_force&&last_tag_token.attr_count>=this._options.wrap_attributes_min_attrs&&(last_token.type!==TOKEN.TAG_OPEN||this._is_wrap_attributes_force_expand_multiline)&&(printer.print_newline(!1),wrapped=!0)),printer.print_token(raw_token),wrapped=wrapped||printer.previous_token_wrapped(),last_tag_token.has_wrapped_attrs=wrapped),parser_token},Beautifier.prototype._handle_text=function(printer,raw_token,last_tag_token){var parser_token={text:raw_token.text,type:"TK_CONTENT"};return last_tag_token.custom_beautifier_name?this._print_custom_beatifier_text(printer,raw_token,last_tag_token):last_tag_token.is_unformatted||last_tag_token.is_content_unformatted?printer.add_raw_token(raw_token):(printer.traverse_whitespace(raw_token),printer.print_token(raw_token)),parser_token},Beautifier.prototype._print_custom_beatifier_text=function(printer,raw_token,last_tag_token){var local=this;if(""!==raw_token.text){var _beautifier,text=raw_token.text,script_indent_level=1,pre="",post="";"javascript"===last_tag_token.custom_beautifier_name&&"function"==typeof this._js_beautify?_beautifier=this._js_beautify:"css"===last_tag_token.custom_beautifier_name&&"function"==typeof this._css_beautify?_beautifier=this._css_beautify:"html"===last_tag_token.custom_beautifier_name&&(_beautifier=function(html_source,options){return new Beautifier(html_source,options,local._js_beautify,local._css_beautify).beautify()}),"keep"===this._options.indent_scripts?script_indent_level=0:"separate"===this._options.indent_scripts&&(script_indent_level=-printer.indent_level);var indentation=printer.get_full_indent(script_indent_level);if(text=text.replace(/\n[ \t]*$/,""),"html"!==last_tag_token.custom_beautifier_name&&"<"===text[0]&&text.match(/^(<!--|<!\[CDATA\[)/)){var matched=/^(<!--[^\n]*|<!\[CDATA\[)(\n?)([ \t\n]*)([\s\S]*)(-->|]]>)$/.exec(text);if(!matched)return void printer.add_raw_token(raw_token);pre=indentation+matched[1]+"\n",text=matched[4],matched[5]&&(post=indentation+matched[5]),text=text.replace(/\n[ \t]*$/,""),(matched[2]||-1!==matched[3].indexOf("\n"))&&(matched=matched[3].match(/[ \t]+$/))&&(raw_token.whitespace_before=matched[0])}if(text)if(_beautifier){var Child_options=function(){this.eol="\n"};Child_options.prototype=this._options.raw_options,text=_beautifier(indentation+text,new Child_options)}else{var white=raw_token.whitespace_before;white&&(text=text.replace(new RegExp("\n("+white+")?","g"),"\n")),text=indentation+text.replace(/\n/g,"\n"+indentation)}pre&&(text=text?pre+text+"\n"+post:pre+post),printer.print_newline(!1),text&&(raw_token.text=text,raw_token.whitespace_before="",raw_token.newlines=0,printer.add_raw_token(raw_token),printer.print_newline(!0))}},Beautifier.prototype._handle_tag_open=function(printer,raw_token,last_tag_token,last_token,tokens){var parser_token=this._get_tag_open_token(raw_token);if(!last_tag_token.is_unformatted&&!last_tag_token.is_content_unformatted||last_tag_token.is_empty_element||raw_token.type!==TOKEN.TAG_OPEN||parser_token.is_start_tag?(printer.traverse_whitespace(raw_token),this._set_tag_position(printer,raw_token,parser_token,last_tag_token,last_token),parser_token.is_inline_element||printer.set_wrap_point(),printer.print_token(raw_token)):(printer.add_raw_token(raw_token),parser_token.start_tag_token=this._tag_stack.try_pop(parser_token.tag_name)),parser_token.is_start_tag&&this._is_wrap_attributes_force){var peek_token,peek_index=0;do{(peek_token=tokens.peek(peek_index)).type===TOKEN.ATTRIBUTE&&(parser_token.attr_count+=1),peek_index+=1}while(peek_token.type!==TOKEN.EOF&&peek_token.type!==TOKEN.TAG_CLOSE)}return(this._is_wrap_attributes_force_aligned||this._is_wrap_attributes_aligned_multiple||this._is_wrap_attributes_preserve_aligned)&&(parser_token.alignment_size=raw_token.text.length+1),parser_token.tag_complete||parser_token.is_unformatted||(printer.alignment_size=parser_token.alignment_size),parser_token};var TagOpenParserToken=function(options,parent,raw_token){if(this.parent=parent||null,this.text="",this.type="TK_TAG_OPEN",this.tag_name="",this.is_inline_element=!1,this.is_unformatted=!1,this.is_content_unformatted=!1,this.is_empty_element=!1,this.is_start_tag=!1,this.is_end_tag=!1,this.indent_content=!1,this.multiline_content=!1,this.custom_beautifier_name=null,this.start_tag_token=null,this.attr_count=0,this.has_wrapped_attrs=!1,this.alignment_size=0,this.tag_complete=!1,this.tag_start_char="",this.tag_check="",raw_token){var tag_check_match;this.tag_start_char=raw_token.text[0],this.text=raw_token.text,"<"===this.tag_start_char?(tag_check_match=raw_token.text.match(/^<([^\s>]*)/),this.tag_check=tag_check_match?tag_check_match[1]:""):(tag_check_match=raw_token.text.match(/^{{~?(?:[\^]|#\*?)?([^\s}]+)/),this.tag_check=tag_check_match?tag_check_match[1]:"",(raw_token.text.startsWith("{{#>")||raw_token.text.startsWith("{{~#>"))&&">"===this.tag_check[0]&&(">"===this.tag_check&&null!==raw_token.next?this.tag_check=raw_token.next.text.split(" ")[0]:this.tag_check=raw_token.text.split(">")[1])),this.tag_check=this.tag_check.toLowerCase(),raw_token.type===TOKEN.COMMENT&&(this.tag_complete=!0),this.is_start_tag="/"!==this.tag_check.charAt(0),this.tag_name=this.is_start_tag?this.tag_check:this.tag_check.substr(1),this.is_end_tag=!this.is_start_tag||raw_token.closed&&"/>"===raw_token.closed.text;var handlebar_starts=2;"{"===this.tag_start_char&&this.text.length>=3&&"~"===this.text.charAt(2)&&(handlebar_starts=3),this.is_end_tag=this.is_end_tag||"{"===this.tag_start_char&&(!options.indent_handlebars||this.text.length<3||/[^#\^]/.test(this.text.charAt(handlebar_starts)))}else this.tag_complete=!0};Beautifier.prototype._get_tag_open_token=function(raw_token){var parser_token=new TagOpenParserToken(this._options,this._tag_stack.get_parser_token(),raw_token);return parser_token.alignment_size=this._options.wrap_attributes_indent_size,parser_token.is_end_tag=parser_token.is_end_tag||in_array(parser_token.tag_check,this._options.void_elements),parser_token.is_empty_element=parser_token.tag_complete||parser_token.is_start_tag&&parser_token.is_end_tag,parser_token.is_unformatted=!parser_token.tag_complete&&in_array(parser_token.tag_check,this._options.unformatted),parser_token.is_content_unformatted=!parser_token.is_empty_element&&in_array(parser_token.tag_check,this._options.content_unformatted),parser_token.is_inline_element=in_array(parser_token.tag_name,this._options.inline)||this._options.inline_custom_elements&&parser_token.tag_name.includes("-")||"{"===parser_token.tag_start_char,parser_token},Beautifier.prototype._set_tag_position=function(printer,raw_token,parser_token,last_tag_token,last_token){if(parser_token.is_empty_element||(parser_token.is_end_tag?parser_token.start_tag_token=this._tag_stack.try_pop(parser_token.tag_name):(this._do_optional_end_element(parser_token)&&(parser_token.is_inline_element||printer.print_newline(!1)),this._tag_stack.record_tag(parser_token),"script"!==parser_token.tag_name&&"style"!==parser_token.tag_name||parser_token.is_unformatted||parser_token.is_content_unformatted||(parser_token.custom_beautifier_name=get_custom_beautifier_name(parser_token.tag_check,raw_token)))),in_array(parser_token.tag_check,this._options.extra_liners)&&(printer.print_newline(!1),printer._output.just_added_blankline()||printer.print_newline(!0)),parser_token.is_empty_element){if("{"===parser_token.tag_start_char&&"else"===parser_token.tag_check)this._tag_stack.indent_to_tag(["if","unless","each"]),parser_token.indent_content=!0,printer.current_line_has_match(/{{#if/)||printer.print_newline(!1);"!--"===parser_token.tag_name&&last_token.type===TOKEN.TAG_CLOSE&&last_tag_token.is_end_tag&&-1===parser_token.text.indexOf("\n")||(parser_token.is_inline_element||parser_token.is_unformatted||printer.print_newline(!1),this._calcluate_parent_multiline(printer,parser_token))}else if(parser_token.is_end_tag){var do_end_expand=!1;do_end_expand=(do_end_expand=parser_token.start_tag_token&&parser_token.start_tag_token.multiline_content)||!parser_token.is_inline_element&&!(last_tag_token.is_inline_element||last_tag_token.is_unformatted)&&!(last_token.type===TOKEN.TAG_CLOSE&&parser_token.start_tag_token===last_tag_token)&&"TK_CONTENT"!==last_token.type,(parser_token.is_content_unformatted||parser_token.is_unformatted)&&(do_end_expand=!1),do_end_expand&&printer.print_newline(!1)}else parser_token.indent_content=!parser_token.custom_beautifier_name,"<"===parser_token.tag_start_char&&("html"===parser_token.tag_name?parser_token.indent_content=this._options.indent_inner_html:"head"===parser_token.tag_name?parser_token.indent_content=this._options.indent_head_inner_html:"body"===parser_token.tag_name&&(parser_token.indent_content=this._options.indent_body_inner_html)),parser_token.is_inline_element||parser_token.is_unformatted||"TK_CONTENT"===last_token.type&&!parser_token.is_content_unformatted||printer.print_newline(!1),this._calcluate_parent_multiline(printer,parser_token)},Beautifier.prototype._calcluate_parent_multiline=function(printer,parser_token){!parser_token.parent||!printer._output.just_added_newline()||(parser_token.is_inline_element||parser_token.is_unformatted)&&parser_token.parent.is_inline_element||(parser_token.parent.multiline_content=!0)};var p_closers=["address","article","aside","blockquote","details","div","dl","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","main","menu","nav","ol","p","pre","section","table","ul"],p_parent_excludes=["a","audio","del","ins","map","noscript","video"];return Beautifier.prototype._do_optional_end_element=function(parser_token){var result=null;if(!parser_token.is_empty_element&&parser_token.is_start_tag&&parser_token.parent){if("body"===parser_token.tag_name)result=result||this._tag_stack.try_pop("head");else if("li"===parser_token.tag_name)result=result||this._tag_stack.try_pop("li",["ol","ul","menu"]);else if("dd"===parser_token.tag_name||"dt"===parser_token.tag_name)result=(result=result||this._tag_stack.try_pop("dt",["dl"]))||this._tag_stack.try_pop("dd",["dl"]);else if("p"===parser_token.parent.tag_name&&-1!==p_closers.indexOf(parser_token.tag_name)){var p_parent=parser_token.parent.parent;p_parent&&-1!==p_parent_excludes.indexOf(p_parent.tag_name)||(result=result||this._tag_stack.try_pop("p"))}else"rp"===parser_token.tag_name||"rt"===parser_token.tag_name?result=(result=result||this._tag_stack.try_pop("rt",["ruby","rtc"]))||this._tag_stack.try_pop("rp",["ruby","rtc"]):"optgroup"===parser_token.tag_name?result=result||this._tag_stack.try_pop("optgroup",["select"]):"option"===parser_token.tag_name?result=result||this._tag_stack.try_pop("option",["select","datalist","optgroup"]):"colgroup"===parser_token.tag_name?result=result||this._tag_stack.try_pop("caption",["table"]):"thead"===parser_token.tag_name?result=(result=result||this._tag_stack.try_pop("caption",["table"]))||this._tag_stack.try_pop("colgroup",["table"]):"tbody"===parser_token.tag_name||"tfoot"===parser_token.tag_name?result=(result=(result=(result=result||this._tag_stack.try_pop("caption",["table"]))||this._tag_stack.try_pop("colgroup",["table"]))||this._tag_stack.try_pop("thead",["table"]))||this._tag_stack.try_pop("tbody",["table"]):"tr"===parser_token.tag_name?result=(result=(result=result||this._tag_stack.try_pop("caption",["table"]))||this._tag_stack.try_pop("colgroup",["table"]))||this._tag_stack.try_pop("tr",["table","thead","tbody","tfoot"]):"th"!==parser_token.tag_name&&"td"!==parser_token.tag_name||(result=(result=result||this._tag_stack.try_pop("td",["table","thead","tbody","tfoot","tr"]))||this._tag_stack.try_pop("th",["table","thead","tbody","tfoot","tr"]));return parser_token.parent=this._tag_stack.get_parser_token(),result}},beautifier.Beautifier=Beautifier,beautifier}function requireSrc(){if(hasRequiredSrc)return src;hasRequiredSrc=1;var js_beautify=function(){if(hasRequiredJavascript)return javascript.exports;hasRequiredJavascript=1;var Beautifier=requireBeautifier$2().Beautifier,Options=requireOptions$2().Options;return javascript.exports=function(js_source_text,options){return new Beautifier(js_source_text,options).beautify()},javascript.exports.defaultOptions=function(){return new Options},javascript.exports}(),css_beautify=requireCss(),html_beautify=function(){if(hasRequiredHtml)return html.exports;hasRequiredHtml=1;var Beautifier=requireBeautifier().Beautifier,Options=requireOptions().Options;return html.exports=function(html_source,options,js_beautify,css_beautify){return new Beautifier(html_source,options,js_beautify,css_beautify).beautify()},html.exports.defaultOptions=function(){return new Options},html.exports}();function style_html(html_source,options,js,css){return html_beautify(html_source,options,js=js||js_beautify,css=css||css_beautify)}return style_html.defaultOptions=html_beautify.defaultOptions,src.js=js_beautify,src.css=css_beautify,src.html=style_html,src}var jsExports=(hasRequiredJs||(hasRequiredJs=1,function(mod){var beautifier=requireSrc();beautifier.js_beautify=beautifier.js,beautifier.css_beautify=beautifier.css,beautifier.html_beautify=beautifier.html,mod.exports=function(js_beautify,css_beautify,html_beautify){var beautify=function(src,config){return js_beautify.js_beautify(src,config)};return beautify.js=js_beautify.js_beautify,beautify.css=css_beautify.css_beautify,beautify.html=html_beautify.html_beautify,beautify.js_beautify=js_beautify.js_beautify,beautify.css_beautify=css_beautify.css_beautify,beautify.html_beautify=html_beautify.html_beautify,beautify}(beautifier,beautifier,beautifier)}(js)),js.exports);const beautify={js:jsExports.js,css:jsExports.css};_exports.beautify=beautify}));

//# sourceMappingURL=beautifier.min.js.map