define("local_pg/preview",["exports","jquery","core/modal","core/prefetch","core/ajax","./beautifier","core/str","./codemirror"],(function(_exports,_jquery,_modal,_prefetch,_ajax,_beautifier,_str,_codemirror){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * This module is used to help preview the page and highlight syntax for css and js codes.
   *
   * @module     local_pg/preview
   * @copyright  2025 Mohammad Farouk <phun.for.physics@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_jquery=_interopRequireDefault(_jquery),_modal=_interopRequireDefault(_modal),_prefetch=_interopRequireDefault(_prefetch),_ajax=_interopRequireDefault(_ajax);let js_beautify=_beautifier.beautify.js,css_beautify=_beautifier.beautify.css;_prefetch.default.prefetchStrings("local_pg",["jssyntaxerror","csssyntaxerror"]);let cssEditorView,jsEditorView,draftLangs={};async function jsValidation(cm){let errorPlaceholder=(0,_jquery.default)("#js-text-error");var code=cm.state.doc.toString().trim();try{return Function(code),errorPlaceholder.text(""),errorPlaceholder.hide(),(0,_jquery.default)("input[type=submit]").removeAttr("disabled"),!0}catch(e){return errorPlaceholder.text(await(0,_str.get_string)("jssyntaxerror","local_pg",e.message)),errorPlaceholder.show(),(0,_jquery.default)("input[type=submit]").attr("disabled",!0),!1}}async function validateCSS(cm){let errorPlaceholder=(0,_jquery.default)("#css-text-error"),cssCode=cm.state.doc.toString().trim(),errors=[];if(void 0!==window.CSSLint){errors=window.CSSLint.verify(cssCode).messages.map((msg=>`Line ${msg.line}: ${msg.message}`))}else try{let style=document.createElement("style");style.textContent=cssCode,document.head.appendChild(style),0===style.sheet.cssRules.length&&""!==cssCode&&errors.push("Invalid CSS detected."),document.head.removeChild(style)}catch(e){errors.push("Invalid CSS syntax.")}return errors.length>0?(errorPlaceholder.text(await(0,_str.get_string)("csssyntaxerror","local_pg",errors.join("<br>\n"))),errorPlaceholder.show(),!0):(errorPlaceholder.text(""),errorPlaceholder.hide(),!1)}function handleEditorUpdate(textarea,validator){return _codemirror.EditorView.updateListener.of((update=>{if(update.docChanged){if(!validator(update))return;const newValue=update.state.doc.toString();textarea.value!==newValue&&(textarea.value=newValue)}}))}function saveDraftLang(){let lang=(0,_jquery.default)("[name=lang]").val(),title=(0,_jquery.default)("[name=header]").val(),content={text:(0,_jquery.default)('[name="content_editor[text]"]').val(),format:(0,_jquery.default)('[name="content_editor[format]"]').val(),itemid:(0,_jquery.default)('[name="content_editor[itemid]"]').val()};draftLangs[lang]={header:title,content:content}}_exports.init=()=>{(0,_jquery.default)((function(){let jsTextarea=document.querySelector('textarea[name="js"]');const jsCompartment=new _codemirror.Compartment,editorStyle=_codemirror.EditorView.theme({"&":{height:"300px",width:"100%",border:"1px solid #8f959e",borderRadius:"0.5rem"}});if(jsTextarea){const beautifiedJS=js_beautify(jsTextarea.value,{indent_size:4});jsTextarea.value=beautifiedJS;const jsContainer=document.createElement("div");jsContainer.style.width="100%",jsTextarea.style.display="none",jsTextarea.parentNode.insertBefore(jsContainer,jsTextarea.nextSibling),jsEditorView=new _codemirror.EditorView({state:_codemirror.EditorState.create({doc:beautifiedJS,extensions:[_codemirror.basicSetup,editorStyle,_codemirror.lang.javascript(),jsCompartment.of([]),handleEditorUpdate(jsTextarea,jsValidation)]}),parent:jsContainer})}let cssTextarea=document.querySelector('textarea[name="css"]');const cssCompartment=new _codemirror.Compartment;if(cssTextarea){const beautifiedCSS=css_beautify(cssTextarea.value,{indent_size:2});cssTextarea.value=beautifiedCSS;const cssContainer=document.createElement("div");cssContainer.style.width="100%",cssTextarea.style.display="none",cssTextarea.parentNode.insertBefore(cssContainer,cssTextarea.nextSibling),cssEditorView=new _codemirror.EditorView({state:_codemirror.EditorState.create({doc:beautifiedCSS,extensions:[_codemirror.basicSetup,_codemirror.lang.css(),editorStyle,cssCompartment.of([]),handleEditorUpdate(cssTextarea,validateCSS)]}),parent:cssContainer})}(0,_jquery.default)("[name=lang]").on("change",(function(){let readOnly=""!==(0,_jquery.default)(this).val();jsEditorView&&jsEditorView.dispatch({effects:jsCompartment.reconfigure(readOnly?_codemirror.EditorView.editable.of(!1):[])}),cssEditorView&&cssEditorView.dispatch({effects:cssCompartment.reconfigure(readOnly?_codemirror.EditorView.editable.of(!1):[])}),async function(){let lang=(0,_jquery.default)("[name=lang]").val(),disable=""!=lang;if((0,_jquery.default)("[name=shortname]").attr("readonly",disable),draftLangs[lang])return draftLangs[lang].header&&(0,_jquery.default)("[name=header]").val(draftLangs[lang].header),void(draftLangs[lang].content&&((0,_jquery.default)('[name="content_editor[text]"]').val(draftLangs[lang].content.text),(0,_jquery.default)('[name="content_editor[format]"]').val(draftLangs[lang].content.format),(0,_jquery.default)('[name="content_editor[itemid]"]').val(draftLangs[lang].content.itemid),(0,_jquery.default)("#id_content_editoreditable").html(draftLangs[lang].content.text)));draftLangs[lang]={header:void 0,content:{text:void 0,format:void 0,itemid:void 0}};let requests=_ajax.default.call([{methodname:"local_pg_get_lang_content",args:{id:(0,_jquery.default)("[name=id]").val(),lang:lang}}]),response=await requests[0];response.header&&((0,_jquery.default)("[name=header]").val(response.header),draftLangs[lang].header=response.header),response.content_editor&&response.content_editor.text&&(draftLangs[lang].content=response.content_editor,(0,_jquery.default)('[name="content_editor[text]"]').val(response.content_editor.text),(0,_jquery.default)("#id_content_editoreditable").html(response.content_editor.text),(0,_jquery.default)('[name="content_editor[format]"]').val(response.content_editor.format),(0,_jquery.default)('[name="content_editor[itemid]"]').val(response.content_editor.itemid))}()})),(0,_jquery.default)('button[name="preview"]').on("click",(function(){!async function(){let url=new URL(M.cfg.wwwroot+"/local/pg/preview.php");url.searchParams.set("shortname",(0,_jquery.default)('[name="shortname"]').val()),url.searchParams.set("header",(0,_jquery.default)('[name="header"]').val()),url.searchParams.set("content",(0,_jquery.default)('[name="content_editor[text]"]').val()),url.searchParams.set("contentformat",(0,_jquery.default)('[name="content_editor[format]"]').val()),url.searchParams.set("layout",(0,_jquery.default)('[name="layout"]').val()),url.searchParams.set("css",(0,_jquery.default)('[name="css"]').val()),url.searchParams.set("js",(0,_jquery.default)('[name="js"]').val()),url.searchParams.set("sesskey",M.cfg.sesskey);let idInput=(0,_jquery.default)('input[name="id"]');if(1==idInput.length){let id=idInput.val();id&&url.searchParams.set("id",id)}let lang=(0,_jquery.default)("[name=lang]").val();lang&&url.searchParams.set("lang",lang),(await _modal.default.create({large:!0,show:!0,removeOnClose:!0,body:`<iframe src="${url.href}" class="embed-responsive-item"></iframe>`,title:"Preview"})).show(),(0,_jquery.default)('[data-region="body"]').addClass("embed-responsive").addClass("embed-responsive-16by9"),(0,_jquery.default)('[data-region="modal"]').css({"max-width":"100%","max-height":"100%",padding:"0",margin:"0"})}()})),(0,_jquery.default)('[name="content_editor[text]"], [name="header"]').on("input, change",saveDraftLang),saveDraftLang()}))}}));

//# sourceMappingURL=preview.min.js.map