<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * The configuration for theme_nice is defined here.
 *
 * @package    theme_nice
 * @copyright  2025 Nice Learning <support@docs.nicelearning.org>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// Define the internal name of the theme
$THEME->name = 'nice';

// List of CSS stylesheet files (without the .css extension) to be included in every page.
$THEME->sheets = [
    'owlcarousel',
    'vars',
    'bootstrapmoodle',
    'nice',
    'dashboard',
    'footer',
    'style',
];

// CSS stylesheets to be included specifically in the HTML editor.
$THEME->editor_sheets = [];

// Parent theme: this theme inherits from; 'boost' provides the base styles and layout.
$THEME->parents = ['boost'];

// Specify the renderer factory to allow theme to override core renderers with its own implementations.
$THEME->rendererfactory = 'theme_overridden_renderer_factory';

// Specify blocks that must always be present on all pages; empty means no required blocks.
$THEME->requiredblocks = '';

// Define where the "Add a block" button appears; FLATNAV places it in the flat navigation drawer.
$THEME->addblockposition = BLOCK_ADDBLOCK_POSITION_FLATNAV;

$THEME->layouts = [
    // Minimal layout without blocks, used for simple pages needing maximum compatibility.
    'base' => array(
        'file' => 'columns2.php',
        'regions' => array(),
    ),
    // Standard page layout with multiple block regions, suitable for most pages with sidebars and additional content areas.
    'standard' => array(
        'file' => 'columns2.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'side-pre'),
        'defaultregion' => 'side-pre',
    ),
    // Main course page.
    'course' => array(
        'file' => 'columns2.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'side-pre'),
        'defaultregion' => 'side-pre',
        'options' => array('langmenu' => true),
    ),
    // Layout used for course category pages, supporting blocks and full-width regions.
    'coursecategory' => array(
        'file' => 'columns2.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'side-pre'),
        'defaultregion' => 'side-pre',
    ),
    // Layout for activity and resource pages within a course context.
    'incourse' => array(
        'file' => 'incourse.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'side-pre'),
        'defaultregion' => 'side-pre',
    ),
    // The site home page.
    'frontpage' => array(
        'file' => 'columns2.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'side-pre'),
        'defaultregion' => 'side-pre',
        'options' => array('nonavbar' => true),
    ),
    // Server administration scripts.
    'admin' => array(
        'file' => 'nice_dashboard.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'side-pre'),
        'defaultregion' => 'side-pre',
    ),
    // My courses page.
    'mycourses' => array(
        'file' => 'columns2.php',
        'regions' => ['side-pre'],
        'defaultregion' => 'side-pre',
        'options' => array('nonavbar' => true),
    ),
    // Layout for the user's personal dashboard page, with optional navbar hidden and language menu enabled.
    'mydashboard' => array(
        'file' => 'nice_my.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'side-pre'),
        'defaultregion' => 'side-pre',
        'options' => array('nonavbar' => true, 'langmenu' => true, 'nocontextheader' => true),
    ),
    // My public page.
    'mypublic' => array(
        'file' => 'columns2.php',
        'regions' => array('side-pre'),
        'defaultregion' => 'side-pre',
    ),
    // Layout used for the login page, with optional regions for additional content and a language menu available.
    'login' => array(
        'file' => 'login.php',
        'regions' => array('fullwidth-top', 'fullwidth-bottom', 'above-content', 'below-content', 'left', 'side-pre'),
        'options' => array('langmenu' => true),
        'defaultregion' => 'below-content',
    ),
    // Pop-up pages without navigation, blocks, or headers, using a minimal activity header.
    'popup' => array(
        'file' => 'columns1.php',
        'regions' => array(),
        'options' => array(
            'nofooter' => true,
            'nonavbar' => true,
            'activityheader' => [
                'notitle' => true,
                'nocompletion' => true,
                'nodescription' => true
            ]
        )
    ),
    // No blocks and minimal footer - used for legacy frame layouts only!
    'frametop' => array(
        'file' => 'columns1.php',
        'regions' => array(),
        'options' => array(
            'nofooter' => true,
            'nocoursefooter' => true,
            'activityheader' => [
                'nocompletion' => true
            ]
        ),
    ),
    // Embeded pages, like iframe/object embeded in moodleform - it needs as much space as possible.
    'embedded' => array(
        'file' => 'embedded.php',
        'regions' => array('side-pre'),
        'defaultregion' => 'side-pre',
    ),
    // Used during upgrade and install, and for the 'This site is undergoing maintenance' message.
    // This must not have any blocks, links, or API calls that would lead to database or cache interaction.
    // Please be extremely careful if you are modifying this layout.
    'maintenance' => array(
        'file' => 'maintenance.php',
        'regions' => array(),
    ),
    // Should display the content and basic headers only.
    'print' => array(
        'file' => 'columns1.php',
        'regions' => array(),
        'options' => array('nofooter' => true, 'nonavbar' => false, 'noactivityheader' => true),
    ),
    // The pagelayout used when a redirection is occuring.
    'redirect' => array(
        'file' => 'embedded.php',
        'regions' => array(),
    ),
    // The pagelayout used for reports.
    'report' => array(
        'file' => 'columns2.php',
        'regions' => array('side-pre'),
        'defaultregion' => 'side-pre',
    ),
    // The pagelayout used for safebrowser and securewindow.
    'secure' => array(
        'file' => 'secure.php',
        'regions' => array('side-pre'),
        'defaultregion' => 'side-pre'
    )
];

$THEME->scss = function($theme) {
    return theme_boost_get_main_scss_content($theme);
};

// Enable the edit switch (the gear icon) in page headers for editing course content or blocks.
$THEME->haseditswitch = true;

// Enable the new course index feature (left-hand side collapsible course navigation panel).
$THEME->usescourseindex = true;

// Define a function to post-process the compiled CSS, replacing placeholders with theme settings.
$THEME->csspostprocess = 'theme_nice_process_css';

// Specify the path to the theme's favicon icon.
$THEME->favicon = $CFG->wwwroot . '/theme/nice/pix/favicon.ico';

// List of JavaScript files to be included at the end of the page for better loading performance.
$THEME->javascripts_footer = [
    'jquery',
    'dashboard',
    'footer',
    'owl.carousel.min',
    'main'
];
