<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Nice Learning theme original text strings-
 *
 * @package     theme_nice
 * @category    string
 * @copyright   2025 Nice Learning <support@docs.nicelearning.org>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Protects the file from being accessed by a URL directly.
defined('MOODLE_INTERNAL') || die();

// Description shown when selecting the theme in Moodle admin UI.
$string['choosereadme'] = 'اضافة - مظهر - التعلم الجميل';

// The name of the theme plugin.
$string['pluginname'] = 'التعلم الجميل';

// Name for the full-width region at the top of the page layout.
$string['region-fullwidth-top'] = 'العرض الكامل في الأعلى';

// Name for the full-width region at the bottom of the page layout.
$string['region-fullwidth-bottom'] = 'العرض الكامل في الأسفل';

// Name for a region positioned above the main content area.
$string['region-above-content'] = 'فوق المحتوى';

// Name for a region positioned below the main content area.
$string['region-below-content'] = 'تحت المحتوى';

// Name for the left side region in the page layout.
$string['region-left'] = 'اليسار';

// This description will be shown in the admin theme selector.
$string['configtitle'] = 'إعدادات التعلم الجميل';

// Name of the first settings tab.
$string['generalsettings'] = 'الإعدادات العامة';

// The brand color setting.
$string['brandcolor'] = 'لون العلامة التجارية';

// The brand color setting description.
$string['brandcolor_desc'] = 'اللون الأساسي لعلامتك التجارية.';

// The second color setting.
$string['secondarycolor'] = 'اللون الثانوي';

// The second color setting description.
$string['secondarycolor_desc'] = 'اللون الثاني لعلامتك التجارية.';

// The name of the advanced settings tab.
$string['advancedsettings'] = 'الإعدادات المتقدمة';

// Raw SCSS setting.
$string['rawscss'] = 'SCSS الخام';

// Raw SCSS setting help text.
$string['rawscss_desc'] = 'استخدم هذا الحقل لتقديم كود SCSS أو CSS الذي سيتم حقنه في نهاية ورقة الأنماط.';

// Raw initial SCSS setting.
$string['rawscsspre'] = 'SCSS الأولي الخام';

// Raw initial SCSS setting help text.
$string['rawscsspre_desc'] = 'في هذا الحقل يمكنك تقديم كود SCSS الأولي، سيتم حقنه قبل كل شيء آخر. في معظم الأوقات ستستخدم هذا الإعداد لتحديد المتغيرات.';

// Border radius value.
$string['borderradius'] = "نصف قطر الحدود";

// Border radius description.
$string['borderradius_desc'] = "سيتم تطبيق قيمة نصف قطر الحدود في جميع أنحاء نظام إدارة التعلم، علمًا بأن القيمة الافتراضية هي 5 بكسل.";

// Navbar logo value.
$string['navbar_logo'] = "شعار شريط التنقل";

// Navbar logo description.
$string['navbar_logo_desc'] = "سيظهر هذا الشعار في شريط التنقل.";

// Navbar value.
$string['navbar_logo_width'] = "عرض شعار شريط التنقل";

// Navbar description.
$string['navbar_logo_width_desc'] = "عرض شعار شريط التنقل | القيمة الافتراضية هي: لا شيء، أضف القيمة بدون px";

// Card image overlay.
$string['card_image_overlay'] = "طبقة تغطية صورة البطاقة";

// Card image overlay description.
$string['card_image_overlay_desc'] = "تطبيق طبقة تغطية ستظهر على جميع البطاقات داخل نظام إدارة التعلم.";

// Homepage URL.
$string['home_page_link'] = "رابط الصفحة الرئيسية";

// Homepage description.
$string['home_page_link_desc'] = "فكر في تمكين أو تعطيل رابط الصفحة الرئيسية في شريط التنقل";

// Dashboard URL.
$string['dashboard_link'] = "رابط لوحة التحكم";

// Dashboard description.
$string['dashboard_link_desc'] = "فكر في تمكين أو تعطيل رابط لوحة التحكم في شريط التنقل";

// Logo URL.
$string['logo_url'] = "رابط الشعار";

// Homepage description.
$string['logo_url_desc'] = "حدد إذا كنت ترغب في أن يوجه الشعار المستخدمين إلى الصفحة الرئيسية أو لوحة التحكم";

// Boxshadow value.
$string['boxshadow'] = "ظل الصندوق";

// Boxshadow description.
$string['boxshadow_desc'] = "سيتم عكس قيمة ظل الصندوق إلى تصميم البطاقات. لإضافة ظل للصندوق، الرجاء استخدام النمط التالي: box-shadow: [الإزاحة الأفقية] [الإزاحة العمودية] [نصف قطر التمويه] rgba([قيمة اللون الأحمر], [قيمة اللون الأخضر], [قيمة اللون الأزرق], [الشفافية]);";

// Breadcrumb settings.
$string['breadcrumbsettings'] = "إعدادات المسار";

// Breadcrumb background.
$string['breadcrumbbackground'] = "خلفية المسار";

// Breadcrumb background description.
$string['breadcrumbbackground_desc'] = "أضف لون خلفية أو تدرج للمسار.";

// Breadcrumb color.
$string['breadcrumbcolor'] = "لون المسار";

// Breadcrumb color description.
$string['breadcrumbcolor_desc'] = "أضف لونًا لنص المسار الخاص بك | الافتراضي هو: أبيض.";

// Footer settings.
$string['scrolltotopsettings'] = "إعدادات التمرير إلى الأعلى";

// Scroll to top visibility.
$string['scroll_to_top_visibility'] = "رؤية زر التمرير إلى الأعلى";

$string['scroll_to_top_visibility_desc'] = "اختر ما إذا كنت ترغب في عرض وظيفة 'التمرير إلى الأعلى' | الافتراضي: عرض";

// Scroll to top background.
$string['scroll_to_top_background'] = "لون خلفية زر التمرير إلى الأعلى";

// Scroll to top background description.
$string['scroll_to_top_background_desc'] = "لون خلفية زر التمرير إلى الأعلى.";

// Footer settings.
$string['footersettings'] = "إعدادات تذييل الصفحة";

// Footer logo.
$string['footer_logo'] = "شعار التذييل";

// Footer logo description.
$string['footer_logo_desc'] = "سيظهر هذا الشعار في تذييل الصفحة.";

// Footer logo width.
$string['footer_logo_width'] = "عرض شعار التذييل | الافتراضي هو: لا شيء";

// Footer logo width description.
$string['footer_logo_width_desc'] = "أدخل العرض (مثل: 300، بدون 'بكسل').";

// Footer description.
$string['footer_description'] = "وصف التذييل";

// Footer width description.
$string['footer_description_desc'] = "أضف وصفًا إلى تذييل الصفحة.";

// Footer background.
$string['footer_background'] = "خلفية التذييل";

// Footer background description.
$string['footer_background_desc'] = "اللون الأساسي لخلفية لتذييل الصفحة.";

// Footer color.
$string['footer_color'] = "لون التذييل";

// Footer color description.
$string['footer_color_desc'] = "لون النص في تذييل الصفحة.";

// Footer title one.
$string['footer_column_title_one'] = "العنوان الأول";

// Footer title one description.
$string['footer_column_title_one_desc'] = "أضف عنوانًا إلى العامود.";

// Footer title two.
$string['footer_column_title_two'] = "العنوان الثاني";

// Footer title two description.
$string['footer_column_title_two_desc'] = "أضف عنوانًا إلى العامود.";

// Footer title three.
$string['footer_column_title_three'] = "العنوان الثالث";

// Footer title three description.
$string['footer_column_title_three_desc'] = "أضف عنوانًا إلى العامود.";

// Footer body one.
$string['footer_column_body_one'] = "العامود الاول";

// Footer body one description.
$string['footer_column_body_one_desc'] = "أضف محتوى إلى العامود الأول | يُسمح باستخدام HTML.";

// Footer body two.
$string['footer_column_body_two'] = "العامود الثاني";

// Footer body two description.
$string['footer_column_body_two_desc'] = "أضف محتوى إلى العامود الثاني | يُسمح باستخدام HTML.";

// Footer body three.
$string['footer_column_body_three'] = "العامود الثالث";

// Footer body three description.
$string['footer_column_body_three_desc'] = "أضف محتوى إلى العامود الثالث | يُسمح باستخدام HTML.";

// Footer copyright background.
$string['footer_copyright_background'] = "لون خلفية حقوق النشر في التذييل";

// Footer copyright background description.
$string['footer_copyright_background_desc'] = "اللون الأساسي لخلفية لقسم حقوق النشر.";

// Footer copyright color.
$string['footer_copyright_color'] = "لون حقوق النشر في التذييل";

// Footer copyright color description.
$string['footer_copyright_color_desc'] = "لون النص لقسم حقوق النشر في التذييل.";

// Footer copyright text.
$string['footer_copyright_text'] = "نص حقوق النشر";

// Footer title one description.
$string['footer_copyright_text_desc'] = "أضف نصًا إلى قسم حقوق النشر.";

// Social media settings.
$string['theme_nice_social_media_settings'] = "إعدادات وسائل التواصل الاجتماعي";

// Social media link target.
$string['social_media_link_target'] = "طريقة فتح روابط صفحات التواصل الاجتماعي";

// Social media link description.
$string['social_media_link_target_desc'] = "قرر ما إذا كان يجب فتح عناوين URL الخاصة بوسائل التواصل الاجتماعي في النافذة الحالية أو نافذة جديدة.";

// Social media | title.
$string['social_media_title'] = "عنوان وسائل التواصل الاجتماعي";

// Social media | title description.
$string['social_media_title_desc'] = "أضف عنوانًا لروابط وسائل التواصل الاجتماعي الخاصة بك";

// Social media | facebook url.
$string['facebook_url'] = "رابط فيسبوك";

// Social media | facebook url description.
$string['facebook_url_desc'] = "رابط صفحة شركتك على فيسبوك.";

// Social media | x url.
$string['x_url'] = "رابط تويتر";

// Social media | x url description.
$string['x_url_desc'] = "رابط صفحة شركتك على اكس.";

// Social media | instagram url.
$string['instagram_url'] = "رابط إنستجرام";

// Social media | instagram url description.
$string['instagram_url_desc'] = "رابط صفحة شركتك على إنستجرام.";

// Social media | youtube url.
$string['youtube_url'] = "رابط يوتيوب";

// Social media | youtube url description.
$string['youtube_url_desc'] = "رابط صفحة شركتك على يوتيوب.";

// Social media | linkedin url.
$string['linkedin_url'] = "رابط لينكدين";

// Social media | linkedin url description.
$string['linkedin_url_desc'] = "رابط صفحة شركتك على لينكدين.";

// Students.
$string['students'] = "طلاب";
