<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Nice Learning theme original text strings-
 *
 * @package     theme_nice
 * @category    string
 * @copyright   2025 Nice Learning <support@docs.nicelearning.org>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Protects the file from being accessed by a URL directly.
defined('MOODLE_INTERNAL') || die();

// Description shown when selecting the theme in Moodle admin UI.
$string['choosereadme'] = 'Nice Learning Moodle Theme';

// The name of the theme plugin.
$string['pluginname'] = 'Nice Learning';

// Name for the full-width region at the top of the page layout.
$string['region-fullwidth-top'] = 'Full width top';

// Name for the full-width region at the bottom of the page layout.
$string['region-fullwidth-bottom'] = 'Full width bottom';

// Name for a region positioned above the main content area.
$string['region-above-content'] = 'Above content';

// Name for a region positioned below the main content area.
$string['region-below-content'] = 'Below content';

// Name for the left side region in the page layout.
$string['region-left'] = 'Left';

// This description will be shown in the admin theme selector.
$string['configtitle'] = 'Nice learning settings';

// Name of the first settings tab.
$string['generalsettings'] = 'General settings';

// The brand color setting.
$string['brandcolor'] = 'Brand color';

// The brand color setting description.
$string['brandcolor_desc'] = 'The primary color of your brand.';

// The second color setting.
$string['secondarycolor'] = 'Secondary color';

// The second color setting description.
$string['secondarycolor_desc'] = 'The second color of your brand.';

// The name of the advanced settings tab.
$string['advancedsettings'] = 'Advanced settings';

// Raw SCSS setting.
$string['rawscss'] = 'Raw SCSS';

// Raw SCSS setting help text.
$string['rawscss_desc'] = 'Use this field to provide SCSS or CSS code which will be injected at the end of the style sheet.';

// Raw initial SCSS setting.
$string['rawscsspre'] = 'Raw initial SCSS';

// Raw initial SCSS setting help text.
$string['rawscsspre_desc'] = 'In this field you can provide initialising SCSS code, it will be injected before everything else. Most of the time you will use this setting to define variables.';

// Border radius value.
$string['borderradius'] = "Border radius";

// Border radius description.
$string['borderradius_desc'] = "The border radius value will be applied throughout the LMS. add the value without px.";

// Navbar logo value.
$string['navbar_logo'] = "Navbar logo";

// Navbar logo description.
$string['navbar_logo_desc'] = "This logo will appear on the navbar.";

// Navbar width value.
$string['navbar_logo_width'] = "Navbar logo width";

// Navbar description.
$string['navbar_logo_width_desc'] = "Navbar logo width | default is: none , add the value without px.";

// Card image overlay.
$string['card_image_overlay'] = "Card image overlay";

// Card image overlay description.
$string['card_image_overlay_desc'] = "Apply an overlay that will be universally reflected across all cards within LMS.";

// Homepage URL.
$string['home_page_link'] = "Homepage link";

// Homepage description.
$string['home_page_link_desc'] = "Consider enabling or disabling the homepage link in the navbar";

// Dashboard URL.
$string['dashboard_link'] = "Dashboard link";

// Dashboard description.
$string['dashboard_link_desc'] = "Consider enabling or disabling the Dashboard link in the navbar";

// Logo URL.
$string['logo_url'] = "Logo link";

// Homepage description.
$string['logo_url_desc'] = "Select whether you'd like the logo to direct users to the homepage or the dashboard";

// Boxshadow value.
$string['boxshadow'] = "Box shadow";

// Boxshadow description.
$string['boxshadow_desc'] = "Box shadow value will be reflected to cards design. To add a box shadow, please use the following pattern: box-shadow: [horizontal offset] [vertical offset] [blur radius] rgba([Red value], [Green value], [Blue value], [Opacity]);";

// Breadcrumb settings.
$string['breadcrumbsettings'] = "Breadcrumb settings";

// Breadcrumb background.
$string['breadcrumbbackground'] = "Breadcrumb background";

// Breadcrumb background description.
$string['breadcrumbbackground_desc'] = "Add a background color or gradient to the breadcrumb.";

// Breadcrumb color.
$string['breadcrumbcolor'] = "Breadcrumb color";

// Breadcrumb color description.
$string['breadcrumbcolor_desc'] = "Add a color for your breadcrumb text | default is: white.";

// Footer settings.
$string['scrolltotopsettings'] = "Scroll to top settings";

// Scroll to top visibility.
$string['scroll_to_top_visibility'] = "Visibility of the scroll to top";

$string['scroll_to_top_visibility_desc'] = "Choose whether to display the 'Scroll to Top' functionality | default: show";

// Scroll to top background.
$string['scroll_to_top_background'] = "Scroll to top background";

// Scroll to top background description.
$string['scroll_to_top_background_desc'] = "The background of your scroll to top section.";

// Footer settings.
$string['footersettings'] = "Footer settings";

// Footer logo.
$string['footer_logo'] = "Footer logo";

// Footer logo description.
$string['footer_logo_desc'] = "This logo will appear on the footer.";

// Footer logo width.
$string['footer_logo_width'] = "Footer logo width | default is: none";

// Footer logo width description.
$string['footer_logo_width_desc'] = "Enter width (e.g., 300, no 'px').";

// Footer description.
$string['footer_description'] = "Footer description";

// Footer width description.
$string['footer_description_desc'] = "Add a description to footer.";

// Footer background.
$string['footer_background'] = "Footer background";

// Footer background description.
$string['footer_background_desc'] = "The primary color of your footer.";

// Footer color.
$string['footer_color'] = "Footer color";

// Footer color description.
$string['footer_color_desc'] = "The text color of your footer.";

// Footer title one.
$string['footer_column_title_one'] = "Title one";

// Footer title one description.
$string['footer_column_title_one_desc'] = "Add a title to your body.";

// Footer title two.
$string['footer_column_title_two'] = "Title two";

// Footer title two description.
$string['footer_column_title_two_desc'] = "Add a title to your body.";

// Footer title three.
$string['footer_column_title_three'] = "Title three";

// Footer title three description.
$string['footer_column_title_three_desc'] = "Add a title to your body.";

// Footer body one.
$string['footer_column_body_one'] = "Body one";

// Footer body one description.
$string['footer_column_body_one_desc'] = "Add a body to your first column | HTML is allowed.";

// Footer body two.
$string['footer_column_body_two'] = "Body two";

// Footer body two description.
$string['footer_column_body_two_desc'] = "Add a body to your second column | HTML is allowed.";

// Footer body three.
$string['footer_column_body_three'] = "Body three";

// Footer body three description.
$string['footer_column_body_three_desc'] = "Add a body to your third column | HTML is allowed.";

// Footer copyright background.
$string['footer_copyright_background'] = "Footer copyright background";

// Footer copyright background description.
$string['footer_copyright_background_desc'] = "The primary color of your copyright section.";

// Footer copyright color.
$string['footer_copyright_color'] = "Footer copyright color";

// Footer copyright color description.
$string['footer_copyright_color_desc'] = "The text color of your copyright section.";

// Footer copyright text.
$string['footer_copyright_text'] = "Copyright text";

// Footer title one description.
$string['footer_copyright_text_desc'] = "Add a text to your copyright section.";

// Social media settings.
$string['theme_nice_social_media_settings'] = "Social settings";

// Social media link target.
$string['social_media_link_target'] = "Social media link target";

// Social media link description.
$string['social_media_link_target_desc'] = "Decide if social URLs should open in the current window or a new one.";

// Social media | title.
$string['social_media_title'] = "Social media title";

// Social media | title description.
$string['social_media_title_desc'] = "Add a title for your social media links";

// Social media | facebook url.
$string['facebook_url'] = "Facebook URL";

// Social media | facebook url description.
$string['facebook_url_desc'] = "Link to your company's Facebook page.";

// Social media | x url.
$string['x_url'] = "X URL";

// Social media | x url description.
$string['x_url_desc'] = "Link to your company's x page.";

// Social media | instagram url.
$string['instagram_url'] = "Instagram URL";

// Social media | instagram url description.
$string['instagram_url_desc'] = "Link to your company's Instagram page.";

// Social media | youtube url.
$string['youtube_url'] = "Youtube URL";

// Social media | youtube url description.
$string['youtube_url_desc'] = "Link to your company's Youtube page.";

// Social media | linkedin url.
$string['linkedin_url'] = "Linkedin URL";

// Social media | linkedin url description.
$string['linkedin_url_desc'] = "Link to your company's Linkedin page.";

// Students.
$string['students'] = "Students";
