define("mod_viewer3d/viewer3d",["exports","core/str"],(function(_exports,_str){
/**
   * Viewer3D module to display STL files using Three.js
   *
   * @module     mod_viewer3d/viewer3d
   * @copyright  2025 GFrancV <https://www.gfrancv.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
let scene,camera,renderer,controls,mesh;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0;const container=document.getElementById("viewer3d-container");function onWindowResize(){camera.aspect=container.clientWidth/container.clientHeight,camera.updateProjectionMatrix(),renderer.setSize(container.clientWidth,container.clientHeight)}function animate(){requestAnimationFrame(animate),controls.update(),renderer.render(scene,camera)}const init=stlurl=>{scene=new THREE.Scene,scene.background=new THREE.Color(15790320),camera=new THREE.PerspectiveCamera(75,container.clientWidth/container.clientHeight,.1,1e3),camera.position.z=5,renderer=new THREE.WebGLRenderer({antialias:!0}),renderer.setSize(container.clientWidth,container.clientHeight),container.appendChild(renderer.domElement);const ambientLight=new THREE.AmbientLight(4210752);scene.add(ambientLight);const directionalLight=new THREE.DirectionalLight(16777215,.5);directionalLight.position.set(1,1,1),scene.add(directionalLight),controls=new THREE.OrbitControls(camera,renderer.domElement),controls.enableDamping=!0,controls.dampingFactor=.25,controls.enableZoom=!0,function(stlurl){const loader=new THREE.STLLoader,stlUrl=stlurl;stlUrl?loader.load(stlUrl,(function(geometry){const material=new THREE.MeshPhongMaterial({color:43775,specular:1118481,shininess:200});mesh=new THREE.Mesh(geometry,material),geometry.computeBoundingBox();const boundingBox=geometry.boundingBox,center=new THREE.Vector3;boundingBox.getCenter(center),mesh.position.set(-center.x,-center.y,-center.z);const maxDim=Math.max(boundingBox.max.x-boundingBox.min.x,boundingBox.max.y-boundingBox.min.y,boundingBox.max.z-boundingBox.min.z);camera.position.z=2*maxDim,scene.add(mesh)}),(function(xhr){console.log(xhr.loaded/xhr.total*100+"% cargado")}),(function(error){console.error((0,_str.get_string)("nofoundstl","viewer3d"),error),container.innerHTML='<div class="alert alert-danger">'.concat((0,_str.get_string)("nofoundstl","viewer3d"),"</div>")})):container.innerHTML='<div class="alert alert-warning">'.concat((0,_str.get_string)("nofoundstl","viewer3d"),"</div>")}(stlurl),window.addEventListener("resize",onWindowResize),animate()};_exports.init=init,document.addEventListener("DOMContentLoaded",init)}));

//# sourceMappingURL=viewer3d.min.js.map