<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Class for the message provider
 * @package mod_ivs
 * @author Ghostthinker GmbH <info@interactive-video-suite.de>
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @copyright (C) 2017 onwards Ghostthinker GmbH (https://ghostthinker.de/)
 */

defined('MOODLE_INTERNAL') || die();

$messageproviders = array(
        'ivs_annotation_direct_mention' => array(
            'capability' => 'mod/ivs:view',
            'defaults' => array(
                'popup' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
                'email' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
            ),
        ),
        'ivs_annotation_indirect_mention' => array(
            'capability' => 'mod/ivs:view',
            'defaults' => array(
                'popup' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
                'email' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
            ),
        ),
        'ivs_annotation_reply' => array(
            'capability' => 'mod/ivs:view',
            'defaults' => array(
                'popup' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
                'email' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
            ),
        ),
        'ivs_annotation_conversation' => array(
            'capability' => 'mod/ivs:view',
            'defaults' => array(
                'popup' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
                'email' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
            ),
        ),
        'ivs_annotation_tag' => array(
            'capability' => 'mod/ivs:view',
            'defaults' => array(
                'popup' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
                'email' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
            ),
        ),
        'ivs_annotation_report' => array(
            'capability' => 'mod/ivs:view',
            'defaults' => array(
                'popup' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
                'email' => MESSAGE_PERMITTED + MESSAGE_DEFAULT_ENABLED,
            ),
        ),
);


