<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This class is used to restore ivs activitys
 * @package mod_ivs
 * @author Ghostthinker GmbH <info@interactive-video-suite.de>
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @copyright (C) 2017 onwards Ghostthinker GmbH (https://ghostthinker.de/)
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/mod/ivs/backup/moodle2/restore_ivs_stepslib.php');
require_once($CFG->dirroot . '/mod/ivs/backup/moodle2/restore_ivs_settingslib.php');

/**
 * Class restore_ivs_activity_task
 */
class restore_ivs_activity_task extends restore_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        // Add Match Answer Backup Setting.
        $settingmatchanswer = new restore_match_answer_setting('ivs_' . $this->oldmoduleid . '_include_match');
        $this->add_setting($settingmatchanswer);
        $this->plan->get_setting('users')->add_dependency($settingmatchanswer);

        $settingvideocomments = new restore_videocomments_setting('ivs_' . $this->oldmoduleid . '_include_videocomments');
        $this->add_setting($settingvideocomments);
        $this->plan->get_setting('users')->add_dependency($settingvideocomments);
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        // We have just one structure step here.
        $this->add_step(new restore_ivs_activity_structure_step('ivs_structure', 'ivs.xml'));
    }

    /**
     * Define the contents in the activity that must be
     * processed by the link decoder
     */
    public static function define_decode_contents() {
        $contents = array();

        $contents[] = new restore_decode_content('ivs', array('intro'), 'ivs');

        return $contents;
    }

    /**
     * Define the decoding rules for links belonging
     * to the activity to be executed by the link decoder
     */
    public static function define_decode_rules() {
        $rules = array();

        $rules[] = new restore_decode_rule('IVSVIEWBYID', '/mod/ivs/view.php?id=$1', 'course_module');
        $rules[] = new restore_decode_rule('IVSINDEX', '/mod/ivs/index.php?id=$1', 'course');

        return $rules;

    }

    /**
     * Define the restore log rules that will be applied
     * by the {@see restore_logs_processor} when restoring
     * ivs logs. It must return one array
     * of {@see restore_log_rule} objects
     */
    public static function define_restore_log_rules() {
        $rules = array();

        $rules[] = new restore_log_rule('ivs', 'add', 'view.php?id={course_module}', '{ivs}');
        $rules[] = new restore_log_rule('ivs', 'update', 'view.php?id={course_module}', '{ivs}');
        $rules[] = new restore_log_rule('ivs', 'view', 'view.php?id={course_module}', '{ivs}');

        return $rules;
    }

    /**
     * Define the restore log rules that will be applied
     * by the {@see restore_logs_processor} when restoring
     * course logs. It must return one array
     * of {@see restore_log_rule} objects
     *
     * Note this rules are applied when restoring course logs
     * by the restore final task, but are defined here at
     * activity level. All them are rules not linked to any module instance (cmid = 0)
     */
    public static function define_restore_log_rules_for_course() {
        $rules = array();

        $rules[] = new restore_log_rule('ivs', 'view all', 'index.php?id={course}', null);

        return $rules;
    }
}
