<?php
/**
 * AdminNeo - Powerful database manager in a single PHP file
 * v5.2.0
 *
 * Compiled with
 * drivers:   all
 * languages: all
 * themes:    all
 * config:    no
 *
 * @link https://www.adminneo.org/
 *
 * @author Peter Knut
 * @author Jakub Vrana (https://www.vrana.cz/)
 *
 * @copyright 2007-2025 Jakub Vrána
 * @copyright 2024-2025 Peter Knut
 *
 * @license Apache License, Version 2.0 (https://www.apache.org/licenses/LICENSE-2.0)
 * @license GNU General Public License, version 2 (https://www.gnu.org/licenses/gpl-2.0.html)
 */namespace
AdminNeo;defined('MOODLE_INTERNAL') || die;use
stdClass;use
Exception;use
PDO;use
PDOStatement;use
mysqli;use
mysqli_result;use
SQLite3;use
SQLite3Result;use
DateTime;use
MongoDB\BSON;use
MongoDB\Driver\BulkWrite;use
MongoDB\Driver\Command;use
MongoDB\Driver\Cursor;use
MongoDB\Driver\Manager;use
MongoDB\Driver\Query;abstract
class
Plugin{protected$admin;protected$config;protected$settings;protected$locale;function
inject($xa,Config$Yb,Settings$P,Locale$kg){$this->admin=$xa;$this->config=$Yb;$this->settings=$P;$this->locale=$kg;}}abstract
class
Origin
extends
Plugin{private$errors=[];private
static$instance=null;static
function
create(array$Yb=[],array$ri=[]){if(self::$instance)die("Admin instance already exists.\n");$xa=new
static();if(!$Yb&&file_exists("adminneo-config.php")){$Yb=include_once("adminneo-config.php");if(!is_array($Yb)){$Yb=[];$gg="href=https://github.com/adminneo-org/adminneo#configuration ".target_blank();$xa->addError(lang(0,"<b>adminneo-config.php</b>")." <a $gg>".lang(1)."</a>");}}$Yb=new
Config($Yb);$P=new
Settings($Yb);if(!$ri&&file_exists("adminneo-plugins.php")){$ri=include_once("adminneo-plugins.php");if(!is_array($ri)){$ri=[];$gg="href=https://github.com/adminneo-org/adminneo#plugins ".target_blank();$xa->addError(lang(0,"<b>adminneo-plugins.php</b>")." <a $gg>".lang(1)."</a>");}}self::$instance=$ri?new
Pluginer($xa,$ri):$xa;$xa->inject(self::$instance,$Yb,$P,Locale::get());foreach($ri
as$qi)$qi->inject(self::$instance,$Yb,$P,Locale::get());return
self::$instance;}static
function
get(){if(!self::$instance)die("Admin instance not found. Create instance by Admin::create() method at first.\n");return
self::$instance;}protected
function
__construct(){}function
getConfig(){return$this->config;}function
getSettings(){return$this->settings;}abstract
function
getOperators();abstract
function
getLikeOperator();abstract
function
getRegexpOperator();function
init(){}function
addError($k){$this->errors[]=$k;}function
getErrors(){return$this->errors;}abstract
function
getServiceTitle();function
getCredentials(){$O=$this->config->getServer(SERVER);return[$O?$O->getServer():SERVER,$_GET["username"],get_password()];}function
verifyDefaultPassword($E){$Pe=$this->config->getDefaultPasswordHash();if($Pe===null||$Pe==="")return
lang(2);elseif(!password_verify($E,$Pe))return
lang(3);return
true;}function
authenticate($V,$E){if($E==""){$Pe=$this->config->getDefaultPasswordHash();if($Pe===null)return
lang(4,target_blank());else
return$Pe==="";}return
true;}function
getPrivateKey($nc=false){return
get_private_key($nc);}function
getBruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
getServerName($O){if($O=="")return"";$Pj=$this->config->getServer($O);return$Pj?$Pj->getName():$O;}abstract
function
getDatabase();function
getDatabases($ie=true){return$this->filterListWithWildcards(get_databases($ie),$this->config->getHiddenDatabases(),false,Driver::get()->getSystemDatabases());}function
getSchemas(){return$this->filterListWithWildcards(schemas(),$this->config->getHiddenSchemas(),false,Driver::get()->getSystemSchemas());}function
getCollations(array$Jf=[]){$sm=$this->config->getVisibleCollations();$ae=$sm?array_merge($sm,$Jf):[];return$this->filterListWithWildcards(collations(),$ae,true);}private
function
filterListWithWildcards(array$jm,array$ae,$Lf,array$Nk=[]){if(!$jm||!$ae)return$jm;$t=array_search("__system",$ae);if($t!==false){unset($ae[$t]);$ae=array_merge($ae,$Nk);}array_walk($ae,function(&$Y){$Y=str_replace('\\*',".*",preg_quote($Y,"~"));});$li='~^('.implode("|",$ae).')$~';return$this->filterListWithPattern($jm,$li,$Lf);}private
function
filterListWithPattern(array$jm,$li,$Lf){$I=[];foreach($jm
as$v=>$Y){if(is_array($Y)){if($Dk=$this->filterListWithPattern($Y,$li,$Lf))$I[$v]=$Dk;}elseif(($Lf&&preg_match($li,$Y))||(!$Lf&&!preg_match($li,$Y)))$I[$v]=$Y;}return$I;}abstract
function
getQueryTimeout();function
sendHeaders(){}function
updateCspHeader(array&$rc){}function
printFavicons(){$Kb=validate_color_variant($this->config->getColorVariant());echo"<link rel='icon' type='image/x-icon' href='",link_files("favicon-$Kb.ico",[]),"' sizes='32x32'>\n","<link rel='icon' type='image/svg+xml' href='",link_files("favicon-$Kb.svg",[]),"'>\n","<link rel='apple-touch-icon' href='",link_files("apple-touch-icon-$Kb.png",[]),"'>\n";}abstract
function
printToHead();function
getCssUrls(){$Zl=$this->config->getCssUrls();foreach(["adminneo.css","adminneo-light.css","adminneo-dark.css"]as$o){if(file_exists($o))$Zl[]="$o?v=".filemtime($o);}return$Zl;}function
isLightModeForced(){return$this->isColorSchemeForced(false);}function
isDarkModeForced(){return$this->isColorSchemeForced(true);}private
function
isColorSchemeForced($wc){$Ng=$wc?Settings::$ColorSchemeDark:Settings::$ColorSchemeLight;$Og=$wc?Settings::$ColorSchemeLight:Settings::$ColorSchemeDark;$Wd=file_exists("adminneo-$Ng.css");$Xd=file_exists("adminneo-$Og.css");if($Wd&&!$Xd)return
true;return$this->settings->getColorScheme()==$Ng&&!($Wd
xor$Xd);}function
getJsUrls(){$Zl=$this->config->getJsUrls();$o="adminneo.js";if(file_exists($o))$Zl[]="$o?v=".filemtime($o);return$Zl;}abstract
function
printLoginForm();function
getLoginFormRow($Sd,$Qf,$l){if($Qf)return"<tr><th>$Qf</th><td>$l</td></tr>\n";else
return"$l\n";}function
printLogout(){echo"<div class='logout'>","<form action='' method='post'>\n",h($_GET["username"]),"<input type='submit' class='button' name='logout' value='",lang(5),"' id='logout'>",input_token(),"</form>","</div>\n";}function
getTableName(array$Rk){return
h($Rk["Name"]);}abstract
function
getFieldName(array$l,$Eh=0);function
formatComment($Qb){return
h($Qb);}abstract
function
printTableMenu(array$Rk,$Yj="");function
getForeignKeys($R){return
foreign_keys($R);}function
getBackwardKeys($R,$Qk){if(!$this->settings->isRelationLinks())return[];$L=backward_keys($R);$Nf=[];foreach($L
as$K){$r=$K["table_schema"].".".$K["table_name"];$Nf[$r]["schema"]=$K["table_schema"];$Nf[$r]["table"]=$K["table_name"];$Nf[$r]["constraints"][$K["constraint_name"]][$K["column_name"]]=$K["referenced_column_name"];}foreach($Nf
as$r=>$v){$_=$this->admin->getTableName(table_status($v["table"],true));if($_!=""){$_j=preg_quote($Qk);$N="(:|\\s*-)?\\s+";$Nf[$r]["name"]=(preg_match("(^$_j$N(.+)|^(.+?)$N$_j\$)iu",$_,$y)?$y[2].$y[3]:$_);}else
unset($Nf[$r]);}return$Nf;}function
printBackwardKeys(array$Ya,array$K){foreach($Ya
as$v){foreach($v["constraints"]as$fc){$Bg=preg_replace('~&ns=[^&]+&~',"&ns=".urldecode($v["schema"])."&",ME);$x=$Bg.'select='.urlencode($v["table"]);$q=0;foreach($fc
as$c=>$X){if(!isset($K[$X]))continue
2;$x
.=where_link($q++,$c,$K[$X]);}$_=preg_replace('(^'.preg_quote($_GET["select"]).(substr($_GET["select"],-1)=="s"?"?":"").'_)',"_",$v["name"]);$sl=implode(", ",array_keys($fc));echo"<a href='".h($x)."' title='".h($sl)."'>".h($_)."</a>";$x=$Bg.'edit='.urlencode($v["table"]);foreach($fc
as$c=>$X)$x
.="&set".urlencode("[".bracket_escape($c)."]")."=".urlencode($K[$X]);echo"<a href='".h($x)."' title='".lang(6)."'>",icon_solo("add"),"</a> ";}}}abstract
function
formatSelectQuery($G,$wk,$Od=false);abstract
function
formatMessageQuery($G,$pl,$Od=false);abstract
function
formatSqlCommandQuery($G);function
printAfterSqlCommand(){}abstract
function
getTableDescriptionFieldName($R);abstract
function
fillForeignDescriptions(array$L,array$le);function
getFieldValueLink($X,$l){if(is_mail($X))return"mailto:$X";if(is_web_url($X))return$X;return
null;}abstract
function
formatSelectionValue($X,$x,$l,$Oh);abstract
function
formatFieldValue($Y,array$l);abstract
function
printTableStructure(array$m);abstract
function
printTablePartitions(array$ai);abstract
function
printTableIndexes(array$u);abstract
function
printSelectionColumns(array$M,array$d);abstract
function
printSelectionSearch(array$Z,array$d,array$u);abstract
function
printSelectionOrder(array$Eh,array$d,array$u);abstract
function
printSelectionLimit($w);abstract
function
printSelectionLength($jl);abstract
function
printSelectionAction(array$u);function
isDataEditAllowed(){return!information_schema(DB);}abstract
function
processSelectionColumns(array$d,array$u);abstract
function
processSelectionSearch(array$m,array$u);abstract
function
processSelectionOrder(array$m,array$u);function
processSelectionLimit(){if(!isset($_GET["limit"]))return$this->settings->getRecordsPerPage();return$_GET["limit"]!=""?(int)$_GET["limit"]:null;}abstract
function
processSelectionLength();abstract
function
getFieldFunctions(array$l);abstract
function
getFieldInput($R,array$l,$Pa,$Y,$ve);function
getFieldInputHint($R,array$l,$Y){return
support("comment")?$this->admin->formatComment($l["comment"]):"";}abstract
function
processFieldInput($l,$Y,$ve="");function
detectJson($Td,&$Y,$Ai=null){if(is_array($Y)){$ge=JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|($this->config->isJsonValuesAutoFormat()?JSON_PRETTY_PRINT:0);$Y=json_encode($Y,$ge);return
true;}$ge=JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|($Ai?JSON_PRETTY_PRINT:0);if(str_contains($Td,"json")){if($Ai!==null&&$this->config->isJsonValuesAutoFormat())$Y=json_encode(json_decode($Y),$ge);return
true;}if(!$this->config->isJsonValuesDetection())return
false;if($Y!=""&&preg_match('~varchar|text|character varying|String|keyword~',$Td)&&($Y[0]=="{"||$Y[0]=="[")&&($Gf=json_decode($Y))){if($Ai!==null&&$this->config->isJsonValuesAutoFormat())$Y=json_encode($Gf,$ge);return
true;}return
false;}abstract
function
getDumpOutputs();abstract
function
getDumpFormats();abstract
function
sendDumpHeaders($cf,$Qg=false);function
dumpDatabase($yc){}abstract
function
dumpTable($R,$Ck,$pm=0);abstract
function
dumpData($R,$Ck,$G);abstract
function
getImportFilePath();abstract
function
printDatabaseMenu();function
printNavigation($Mg){$Wf=isset($_COOKIE["neo_version"])?$_COOKIE["neo_version"]:null;echo"<div class='header'>\n",$this->admin->getServiceTitle()."\n";if($Mg!="auth"){echo"<span class='version'>",h(preg_replace('~\\.0(-|$)~','$1',VERSION)),"<a id='version' class='version-badge' href='https://www.adminneo.org/download' ".target_blank()." title='".h($Wf)."'>";if($this->config->isVersionVerificationEnabled()&&$Wf&&version_compare(VERSION,$Wf)<0)echo
icon_solo("asterisk");echo"</a>","</span>\n";if($this->config->isVersionVerificationEnabled()&&!$Wf)echo
script("verifyVersion('".js_escape(ME)."', '".get_token()."');");}echo"</div>\n";}abstract
function
printDatabaseSwitcher($Mg);function
printTablesFilter(){echo"<div class='tables-filter jsonly'>"."<input id='tables-filter' type='search' class='input' autocomplete='off' placeholder='".lang(7)."'>".script("initTablesFilter(".json_encode($this->admin->getDatabase()).");")."</div>\n";}abstract
function
printTableList(array$T);function
getSettingsRows($Fe){$P=[];if($Fe==1){$B=get_language_options();if($B)$P["lang"]="<tr><th>".lang(8)."</th>"."<td>".html_select("lang",get_language_options(),Locale::get()->getLanguage())."</td></tr>\n";$B=[""=>lang(9),Settings::$ColorSchemeLight=>lang(10),Settings::$ColorSchemeDark=>lang(11)];$P["colorScheme"]="<tr><th>".lang(12)."</th>"."<td>".html_radios("colorScheme",$B,($pa=$this->settings->getParameter("colorScheme"))!==null?$pa:"")."</td></tr>\n";}elseif($Fe==2){$B=[""=>lang(13),true=>lang(14),false=>lang(15),];$j=$B[$this->config->isRelationLinks()];$B[""].=" ($j)";$P["relationLinks"]="<tr><th>".lang(16)."</th>"."<td>".html_radios("relationLinks",$B,($pa=$this->settings->getParameter("relationLinks"))!==null?$pa:"")."<span class='input-hint'>".lang(17)."</span>"."</td></tr>\n";$j=$this->config->getRecordsPerPage();$B=[""=>lang(13)." ($j)","20","30","50","70","100",];$P["recordsPerPage"]="<tr><th>".lang(18)."</th>"."<td>".html_select("recordsPerPage",$B,($pa=$this->settings->getParameter("recordsPerPage"))!==null?$pa:"")."<span class='input-hint'>".lang(19)."</span>"."</td></tr>\n";$j=($pa=$this->config->getEnumAsSelectThreshold())!==null?$pa:lang(20);$B=[""=>lang(13)." ($j)",-1=>lang(20),0=>lang(21),3=>lang(22,3),5=>lang(22,5),10=>lang(22,10),20=>lang(22,20),];$P["enumAsSelectThreshold"]="<tr><th>".lang(23)."</th>"."<td>".html_select("enumAsSelectThreshold",$B,($pa=$this->settings->getParameter("enumAsSelectThreshold"))!==null?$pa:"","","",true)."<span class='input-hint'>".lang(24)."</span>"."</td></tr>\n";}return$P;}abstract
function
getForeignColumnInfo(array$le,$c);}class
Pluginer{private
static$InternalMethods=["inject"=>true,"getConfig"=>true,];private
static$AppendMethods=["getErrors"=>true,"getFieldFunctions"=>true,"getDumpOutputs"=>true,"getDumpFormats"=>true,"getSettingsRows"=>true,];private$plugins;private$hooks=[];function
__construct(Origin$xa,array$ri){$this->plugins=$ri;foreach(get_class_methods('\AdminNeo\Origin')as$Kg){$this->hooks[$Kg]=[];if(!(isset(self::$InternalMethods[$Kg])?self::$InternalMethods[$Kg]:false)){foreach($ri
as$qi){if(method_exists($qi,$Kg))$this->hooks[$Kg][]=$qi;}}if(isset(self::$AppendMethods[$Kg])?self::$AppendMethods[$Kg]:false)array_unshift($this->hooks[$Kg],$xa);else$this->hooks[$Kg][]=$xa;}}function
getPlugins(){return$this->plugins;}function
__call($_,array$D){$Ka=isset(self::$AppendMethods[$_])?self::$AppendMethods[$_]:false;$I=$Ka?[]:null;assert(isset($this->hooks[$_]),"Calling unknown plugin method: $_");foreach($this->hooks[$_]as$qi){$Y=call_user_func_array([$qi,$_],$D);if($Y!==null){if($Ka)$I+=$Y;else
return$Y;}}return$I;}function
updateCspHeader(array&$rc){$this->__call(__FUNCTION__,[&$rc]);}function
detectJson($Td,&$Y,$Ai=null){return$this->__call(__FUNCTION__,[$Td,&$Y,$Ai]);}}class
Admin
extends
Origin{function
getOperators(){return
Driver::get()->getOperators();}function
getLikeOperator(){return
Driver::get()->getLikeOperator();}function
getRegexpOperator(){return
Driver::get()->getRegexpOperator();}function
getServiceTitle(){return"<a href='".h(HOME_URL)."'><svg role='img' class='logo' width='133' height='28'><desc>AdminNeo</desc><use href='".link_files("logo.svg",[])."#logo'/></svg></a>";}function
getDatabase(){return
DB;}function
getQueryTimeout(){return
2;}function
printToHead(){echo"<link rel='stylesheet' href='",link_files("jush.css",[]),"'>";if(!$this->admin->isLightModeForced())echo"<link rel='stylesheet' ".(!$this->admin->isDarkModeForced()?"media='(prefers-color-scheme: dark)' ":"")."href='",link_files("jush-dark.css",[]),"'>\n";echo
script_src(link_files("jush.js",[]),true);}function
printLoginForm(){$Wc=Drivers::getList();$Qj=$this->config->getServerPairs($Wc);$O=SERVER?:$this->config->getDefaultServer();echo"<table class='box box-light'>\n";if($Qj)echo$this->admin->getLoginFormRow('server',lang(25),"<select name='auth[server]'>".optionlist($Qj,$O,true)."</select>");else{$Uc=DRIVER?:$this->config->getDefaultDriver($Wc);if(count($Wc)>1)echo$this->admin->getLoginFormRow('driver',lang(26),html_select("auth[driver]",$Wc,$Uc).script("initLoginDriver(qsl('select'));",""));else
echo$this->admin->getLoginFormRow('driver','',input_hidden("auth[driver]",$Uc));echo$this->admin->getLoginFormRow('server',lang(25),'<input class="input" name="auth[server]" value="'.h($O).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">');}echo$this->admin->getLoginFormRow('username',lang(27),'<input class="input" name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'),$this->admin->getLoginFormRow('password',lang(28),'<input type="password" class="input" name="auth[password]" autocomplete="current-password">');if(!$Qj){$yc=isset($_GET["db"])?$_GET["db"]:$this->config->getDefaultDatabase();echo$this->admin->getLoginFormRow('db',lang(29),'<input class="input" name="auth[db]" value="'.h($yc).'" autocapitalize="off">');}echo"</table>\n","<p>","<input type='submit' class='button default' value='".lang(30)."'>",checkbox("auth[permanent]",1,$_COOKIE["neo_permanent"],lang(31)),"</p>\n";}function
getFieldName(array$l,$Eh=0){$U=$l["full_type"];$Qb=$l["comment"];$N=$U&&$Qb!=""?": ":"";return'<span title="'.h($U.$N.$Qb).'">'.h($l["field"]).'</span>';}function
printTableMenu(array$Rk,$Yj=""){echo'<p class="links top-tabs">';$hg=[];$Gj=($this->settings->isSelectionPreferred()&&!$this->settings->isNavigationReversed())||(!$this->settings->isSelectionPreferred()&&$this->settings->isNavigationReversed());if($Gj)$hg["select"]=[lang(32),"data"];if(support("table")||support("indexes"))$hg["table"]=[lang(33),"structure"];if(!$Gj)$hg["select"]=[lang(32),"data"];$Bf=false;if(support("table")){$Bf=is_view($Rk);if($Bf)$hg["view"]=[lang(34),"edit"];else$hg["create"]=[lang(35),"edit"];}if($Yj!==null)$hg["edit"]=[lang(6),"item-add"];$R=$Rk["Name"];foreach($hg
as$v=>$X)echo" <a href='",h(ME),"$v=",urlencode($R),($v=="edit"?$Yj:""),"'",bold(isset($_GET[$v])),">",icon($X[1]),"$X[0]</a>";echo
doc_link([DIALECT=>Driver::get()->tableHelp($R,$Bf)],icon("help").lang(36)),"\n";}function
formatSelectQuery($G,$wk,$Od=false){$Jk=support("sql");$um=!$Od?Driver::get()->warnings():null;if($Jk)$G
.=";";$Lk=DIALECT=="elastic"?"js":DIALECT;$J="<pre><code class='jush-$Lk'>".h(str_replace("\n"," ",$G))."</code></pre>\n";$J
.="<p class='links'>";if($Jk)$J
.="<a href='".h(ME)."sql=".urlencode($G)."'>".icon("edit").lang(37)."</a>";if($um)$J
.="<a href='#warnings' class='toggle'>".lang(38).icon_chevron_down()."</a>";$J
.=" <span class='time'>(".format_time($wk).")</span>";$J
.="</p>\n";if($um){$J
.=script("initToggles(qsl('p'));");$J
.="<div id='warnings' class='warnings hidden'>\n$um\n</div>\n";}return$J;}function
formatMessageQuery($G,$pl,$Od=false){restart_session();$Te=&get_session("queries");if(!isset($Te[$_GET["db"]]))$Te[$_GET["db"]]=[];if(strlen($G)>1e6)$G=preg_replace('~[\x80-\xFF]+$~','',substr($G,0,1e6))."\n…";$Te[$_GET["db"]][]=[$G,time(),$pl];$Jk=support("sql");$um=!$Od?Driver::get()->warnings():null;$qk="sql-".count($Te[$_GET["db"]]);$vm="warnings-".count($Te[$_GET["db"]]);$J=" ";if($um)$J
.="<a href='#$vm' class='toggle'>".lang(38).icon_chevron_down()."</a>, ";$Mi=support("sql")?lang(39):lang(40);$J
.="<a href='#$qk' class='toggle'>$Mi".icon_chevron_down()."</a>";$J
.=" <span class='time'>".@date("H:i:s")."</span>\n";if($um)$J
.="<div id='$vm' class='warnings hidden'>\n$um</div>\n";$J
.="<div id='$qk' class='hidden'>\n";$Lk=DIALECT=="elastic"?"js":DIALECT;$J
.="<pre><code class='jush-$Lk'>".truncate_utf8($G,1000)."</code></pre>\n";$J
.="<p class='links'>";if($Jk)$J
.="<a href='".h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Te[$_GET["db"]])-1))."'>".icon("edit").lang(37)."</a>";if($pl)$J
.=" <span class='time'>($pl)</span>";$J
.="</p>\n";$J
.="</div>\n";return$J;}function
formatSqlCommandQuery($G){if(preg_match('~^DELIMITER\s~i',$G))return"";return
truncate_utf8($G,1000);}function
getTableDescriptionFieldName($R){return"";}function
fillForeignDescriptions(array$L,array$le){return$L;}function
formatSelectionValue($X,$x,$l,$Oh){if($X===null)$il="<i>NULL</i>";elseif(!$l)$il=$X;elseif(preg_match("~char|binary|boolean~",$l["type"])&&!preg_match("~var~",$l["type"]))$il="<code>$X</code>";elseif(preg_match('~blob|bytea|raw|file~',$l["type"])&&!is_utf8($X))$il="<i>".lang(41,strlen($Oh))."</i>";elseif($this->admin->detectJson($l["type"],$Oh))$il="<code class='jush-js'>$X</code>";else$il=$X;if($x)$il="<a href='".h($x)."'".(is_web_url($x)?target_blank():"").">$il</a>";return$il;}function
formatFieldValue($Y,array$l){return$Y;}function
printTableStructure(array$m){echo"<div class='scrollable'>\n","<table class='nowrap'>\n","<thead><tr>","<th>",lang(42),"</th>","<td>",lang(43),"</td>","<td>",lang(44),"</td>";if(support("comment"))echo"<td>",lang(45),"</td>";echo"</tr></thead>\n";$fm=Driver::get()->getUserTypes();foreach($m
as$l){echo"<tr>","<th>",h($l["field"]),"</th>","<td>";$U=h($l["full_type"]);if(in_array($U,$fm))echo"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>";else
echo$U;if($l["null"])echo" <i>NULL</i>";if($l["auto_increment"])echo" <i>".lang(46)."</i>";$j=h($l["default"]);if(isset($l["default"]))echo" <span title='".lang(47)."'>[<b>",$l["generated"]?"<code class='jush-".DIALECT."'>$j</code>":$j,"</b>]</span>";echo"</td>","<td>",h($l["collation"]),"</td>";if(support("comment"))echo"<td>",$this->admin->formatComment($l["comment"]),"</td>";echo"\n";}echo"</table>\n","</div>\n";}function
printTablePartitions(array$ai){$bk=$ai["partition_by"]=="RANGE"||$ai["partition_by"]=="LIST";echo"<p>","<code>{$ai["partition_by"]} ({$ai["partition"]})</code>";if(!$bk)echo" ".lang(48).": ".h($ai["partitions"]);echo"</p>";if($bk){echo"<table>\n","<thead><tr><th>".lang(49)."</th><td>".lang(50)."</td></tr></thead>\n";foreach($ai["partition_names"]as$v=>$_)echo"<tr><th>".h($_)."</th><td>".h($ai["partition_values"][$v])."\n";echo"</table>\n";}}function
printTableIndexes(array$u){echo"<table>\n","<thead><tr><th>".lang(43)."</th><td>".lang(42)." (".lang(51).")</td></tr></thead>\n";foreach($u
as$_=>$t){ksort($t["columns"]);$Ci=[];foreach($t["columns"]as$v=>$X)$Ci[]="<i>".h($X)."</i>".($t["lengths"][$v]?"(".$t["lengths"][$v].")":"").($t["descs"][$v]?" DESC":"");echo"<tr title='".h($_)."'><th>$t[type]<td>".implode(", ",$Ci)."\n";}echo"</table>\n";}function
printSelectionColumns(array$M,array$d){print_fieldset_start("select",lang(52),"columns",(bool)$M,true);$M[""]=[];$q=0;foreach($M
as$v=>$X){$X=isset($_GET["columns"][$v])?$_GET["columns"][$v]:[];$c=select_input("name='columns[$q][col]'",$d,isset($X["col"])?$X["col"]:null,$v!==""?"selectFieldChange":"selectAddRow");echo"<div ",($v!=""?"":"class='no-sort'"),">",icon("handle","handle jsonly");if(Driver::get()->getFunctions()||Driver::get()->getGrouping())echo
html_select("columns[$q][fun]",[-1=>""]+array_filter([lang(53)=>Driver::get()->getFunctions(),lang(54)=>Driver::get()->getGrouping()]),isset($X["fun"])?$X["fun"]:null),help_script_command("value && value.replace(/ |\$/, '(') + ')'",true),script("qsl('select').onchange = (event) => { ".($v!==""?"":" qsl('select, input:not(.remove)', event.target.parentNode).onchange();")." };",""),"($c)";else
echo$c;echo" <button class='button light remove jsonly' title='",h(lang(55)),"'>",icon_solo("remove"),"</button>",script("qsl('#fieldset-select .remove').onclick = selectRemoveRow;",""),"</div>\n";$q++;}print_fieldset_end("select",true);}function
printSelectionSearch(array$Z,array$d,array$u){print_fieldset_start("search",lang(56),"search",(bool)$Z);foreach($u
as$q=>$t){if($t["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('AdminNeo\h',$t["columns"]))."</i>) AGAINST","<input type='search' class='input' name='fulltext[$q]' value='".h(isset($_GET["fulltext"][$q])?$_GET["fulltext"][$q]:null)."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$q]",1,isset($_GET["boolean"][$q]),"BOOL"),"</div>\n";}$qb="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],[[]])as$q=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->getOperators())))echo"<div>",select_input(" name='where[$q][col]'",$d,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(57).")"),html_select("where[$q][op]",$this->getOperators(),$X["op"],$qb),"<input type='search' class='input' name='where[$q][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $qb }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});","")," <button class='button light remove jsonly' title='".h(lang(55))."'>",icon_solo("remove"),"</button>",script('qsl("#fieldset-search .remove").onclick = selectRemoveRow;',""),"</div>\n";}print_fieldset_end("search");}function
printSelectionOrder(array$Eh,array$d,array$u){print_fieldset_start("sort",lang(58),"sort",(bool)$Eh,true);$_GET["order"][""]="";$q=0;foreach((array)$_GET["order"]as$v=>$X){if($v!=""&&$X=="")continue;echo"<div ",($v!=""?"":"class='no-sort'"),">",icon("handle","handle jsonly"),select_input("name='order[$q]'",$d,$X,$v!==""?"selectFieldChange":"selectAddRow")," ",checkbox("desc[$q]",1,isset($_GET["desc"][$v]),lang(59))," <button class='button light remove jsonly' title='",h(lang(55)),"'>",icon_solo("remove"),"</button>",script('qsl("#fieldset-sort .remove").onclick = selectRemoveRow;',""),"</div>\n";$q++;}print_fieldset_end("sort",true);}function
printSelectionLimit($w){echo"<fieldset><legend>".lang(60)."</legend><div class='fieldset-content'>","<input type='number' name='limit' class='input size' value='".h($w)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
printSelectionLength($jl){if($jl!==null)echo"<fieldset><legend>".lang(61)."</legend><div class='fieldset-content'>","<input type='number' name='text_length' class='input size' value='".h($jl)."'>","</div></fieldset>\n";}function
printSelectionAction(array$u){echo"<fieldset><legend>".lang(62)."</legend><div class='fieldset-content'>","<input type='submit' class='button' value='".lang(52)."'>"," <span id='noindex' title='".lang(63)."'></span>","<script".nonce().">\n";$d=new
stdClass();foreach($u
as$t){$tc=reset($t["columns"]);if($t["type"]!="FULLTEXT"&&$tc)$d->$tc=null;}echo"const indexColumns = ".json_encode($d,JSON_UNESCAPED_UNICODE).";\n","selectFieldChange.call(gid('form')['select']);\n","</script>\n","</div></fieldset>\n";}function
processSelectionColumns(array$d,array$u){$M=[];$De=[];foreach((array)$_GET["columns"]as$v=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],Driver::get()->getFunctions())||in_array($X["fun"],Driver::get()->getGrouping())))){$M[$v]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],Driver::get()->getGrouping()))$De[]=$M[$v];}}return[$M,$De];}function
processSelectionSearch(array$m,array$u){$J=[];foreach($u
as$q=>$t){if($t["type"]=="FULLTEXT"&&isset($_GET["fulltext"])&&$_GET["fulltext"][$q]!="")$J[]="MATCH (".implode(", ",array_map('AdminNeo\idf_escape',$t["columns"])).") AGAINST (".q($_GET["fulltext"][$q]).(isset($_GET["boolean"][$q])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$Z){$Fb=$Z["col"];$yh=$Z["op"];$X=$Z["val"];if("$Fb$X"!=""&&in_array($yh,$this->getOperators())){$zi="";$Wb=" $yh";if(preg_match('~IN$~',$yh)){$if=process_length($X);$Wb
.=" ".($if!=""?$if:"(NULL)");}elseif($yh=="SQL")$Wb=" $X";elseif($yh=="LIKE %%")$Wb=" LIKE ".$this->admin->processFieldInput(isset($m[$Fb])?$m[$Fb]:null,"%$X%");elseif($yh=="ILIKE %%")$Wb=" ILIKE ".$this->admin->processFieldInput(isset($m[$Fb])?$m[$Fb]:null,"%$X%");elseif($yh=="FIND_IN_SET"){$zi="$yh(".q($X).", ";$Wb=")";}elseif(!preg_match('~NULL$~',$yh))$Wb
.=" ".$this->admin->processFieldInput(isset($m[$Fb])?$m[$Fb]:null,$X);if($Fb!=""){$_j=isset($m[$Fb])?Driver::get()->convertSearch(idf_escape($Fb),$Z,$m[$Fb]):idf_escape($Fb);$J[]=$zi.$_j.$Wb;}else{$Mb=[];foreach($m
as$_=>$l){if(isset($l["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$yh)?',':'').']+$~',$X)||!preg_match('~'.number_type().'|bit~',$l["type"]))&&(!preg_match("~[\x80-\xFF]~",$X)||preg_match('~char|text|enum|set~',$l["type"]))&&(!preg_match('~date|timestamp~',$l["type"])||preg_match('~^\d+-\d+-\d+~',$X))&&(!preg_match('~^elastic~',DRIVER)||$l["type"]!="boolean"||preg_match('~true|false~',$X))&&(!preg_match('~^elastic~',DRIVER)||strpos($yh,"regexp")===false||preg_match('~text|keyword~',$l["type"])))$Mb[]=$zi.Driver::get()->convertSearch(idf_escape($_),$Z,$l).$Wb;}$J[]=($Mb?"(".implode(" OR ",$Mb).")":"1 = 0");}}}return$J;}function
processSelectionOrder(array$m,array$u){$J=[];foreach((array)$_GET["order"]as$v=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$v])?" DESC":"");}return$J;}function
processSelectionLength(){return
isset($_GET["text_length"])?$_GET["text_length"]:"100";}function
getFieldFunctions(array$l){$J=($l["null"]?"NULL/":"");$Wl=isset($_GET["select"])||where($_GET);foreach(Driver::get()->getEditFunctions()as$v=>$we){if(!$v||(!isset($_GET["call"])&&$Wl)){foreach($we
as$li=>$X){if(!$li||preg_match("~$li~",$l["type"]))$J
.="/$X";}}if($v&&!preg_match('~enum|set|blob|bytea|raw|file|bool~',$l["type"]))$J
.="/SQL";}if($l["auto_increment"]&&!$Wl)$J=lang(46);return
explode("/",$J);}function
getFieldInput($R,array$l,$Pa,$Y,$ve){return"";}function
processFieldInput($l,$Y,$ve=""){if($ve=="SQL")return$Y;if(!$l)return
q($Y);if(isset($l["type"]))$this->admin->detectJson($l["type"],$Y,false);$_=$l["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$ve))$J="$ve()";elseif(preg_match('~^current_(date|timestamp)$~',$ve))$J=$ve;elseif(preg_match('~^([+-]|\|\|)$~',$ve))$J=idf_escape($_)." $ve $J";elseif(preg_match('~^[+-] interval$~',$ve))$J=idf_escape($_)." $ve ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$ve))$J="$ve(".idf_escape($_).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$ve))$J="$ve($J)";elseif($l["type"]=="boolean"&&DIALECT=="elastic")$J=$J=="0"?"false":"true";return
unconvert_field($l,$J);}function
getDumpOutputs(){$Sh=['file'=>lang(64),'text'=>lang(65),];if(function_exists('gzencode'))$Sh['gz']='gzip';return$Sh;}function
getDumpFormats(){return(support("dump")?['sql'=>'SQL']:[])+['csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV'];}function
sendDumpHeaders($cf,$Qg=false){$Rh=$_POST["output"];$Kd=(str_contains($_POST["format"],"sql")?"sql":($Qg?"tar":"csv"));if($Rh=="gz"){header("Content-Type: application/x-gzip");ob_start(function($Q){return
gzencode($Q);},1e6);}elseif($Kd=="tar")header("Content-Type: application/x-tar");elseif($Kd=="sql")header("Content-Type: text/plain; charset=utf-8");else
header("Content-Type: text/csv; charset=utf-8");return$Kd;}function
dumpTable($R,$Ck,$pm=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Ck)dump_csv(array_keys(fields($R)));}else{if($pm==2){$m=[];foreach(fields($R)as$_=>$l)$m[]=idf_escape($_)." $l[full_type]";$nc="CREATE TABLE ".table($R)." (".implode(", ",$m).")";}else$nc=create_sql($R,$_POST["auto_increment"],$Ck);set_utf8mb4($nc);if($Ck&&$nc){if($Ck=="DROP+CREATE"||$pm==1)echo"DROP ".($pm==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($pm==1)$nc=remove_definer($nc);echo"$nc;\n\n";}}}function
dumpData($R,$Ck,$G){if($Ck){$wg=(DIALECT=="sqlite"?0:1048576);$m=[];$ef=false;if($_POST["format"]=="sql"){if($Ck=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$m=fields($R);if(DIALECT=="mssql"){foreach($m
as$l){if($l["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$ef=true;break;}}}}$I=Connection::get()->query($G,1);if($I){$rf="";$hb="";$Nf=[];$ye=[];$Gk="";while($K=($R!=''?$I->fetchAssoc():$I->fetchRow())){if(!$Nf){$jm=[];foreach($K
as$X){$l=$I->fetchField();if(!empty($m[$l->name]['generated'])){$ye[$l->name]=true;continue;}$Nf[]=$l->name;$v=idf_escape($l->name);$jm[]="$v = VALUES($v)";}$Gk=($Ck=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$jm):"").";\n";}if($_POST["format"]!="sql"){if($Ck=="table"){dump_csv($Nf);$Ck="INSERT";}dump_csv($K);}else{if(!$rf)$rf="INSERT INTO ".table($R)." (".implode(", ",array_map('AdminNeo\idf_escape',$Nf)).") VALUES";foreach($K
as$v=>$X){if(isset($ye[$v])){unset($K[$v]);continue;}$l=$m[$v];$K[$v]=($X!==null?unconvert_field($l,preg_match(number_type(),$l["type"])&&!preg_match('~\[~',$l["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$vj=($wg?"\n":" ")."(".implode(",\t",$K).")";if(!$hb)$hb=$rf.$vj;elseif(strlen($hb)+4+strlen($vj)+strlen($Gk)<$wg)$hb
.=",$vj";else{echo$hb.$Gk;$hb=$rf.$vj;}}}if($hb)echo$hb.$Gk;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",Connection::get()->getError())."\n";if($ef)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
getImportFilePath(){return"adminneo.sql";}function
printDatabaseMenu(){echo"<p class='links top-links'>\n";$gh=isset($_GET["ns"])?$_GET["ns"]:null;if($gh==""&&support("database"))echo'<a href="',h(ME),'database=">',icon("edit"),lang(66),"</a>\n";if($gh!=""&&support("scheme"))echo"<a href='",h(ME),"scheme='>",icon("edit"),lang(67),"</a>\n";if($gh!=="")echo'<a href="',h(ME),'schema=">',icon("schema"),lang(68),"</a>\n";if(support("privileges"))echo"<a href='",h(ME),"privileges='>",icon("users"),lang(69),"</a>\n";echo"</p>\n";}function
printNavigation($Mg){parent::printNavigation($Mg);if($Mg=="auth"){$Rh="";foreach((array)$_SESSION["pwds"]as$lm=>$Uj){foreach($Uj
as$O=>$gm){foreach($gm
as$V=>$E){if($E!==null){$Bc=$_SESSION["db"][$lm][$O][$V];foreach(($Bc?array_keys($Bc):[""])as$i){$Rj=$this->admin->getServerName($O);$sl=h(get_driver_name($lm,$O)).($V!=""||$Rj!=""?" - ":"").h($V).($V!=""&&$Rj!=""?"@":"").h($Rj).($i!=""?h(" - $i"):"");$Rh
.="<li><a href='".h(auth_url($lm,$O,$V,$i))."' class='primary' title='$sl'>$sl</a></li>\n";}}}}}if($Rh)echo"<nav id='logins'><menu>\n$Rh</menu></nav>\n";}else{$this->admin->printDatabaseSwitcher($Mg);$sa=[];if(DB==null||!$Mg){if(support("sql")){$sa[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".icon("command").lang(39)."</a>";$sa[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".icon("import").lang(70)."</a>";}$sa[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".icon("export").lang(71)."</a>";}if(DB==null)$sa[]='<a href="'.h(ME).'database="'.bold($_GET["database"]==="").">".icon("database-add").lang(72)."</a>\n";if(DB!=null&&$_GET["ns"]===""&&!$Mg)$sa[]='<a href="'.h(ME).'scheme="'.bold($_GET["scheme"]==="").">".icon("database-add").lang(73)."</a>\n";if(DB!=null&&$_GET["ns"]!==""&&!$Mg)$sa[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".icon("table-add").lang(74)."</a>\n";if($sa)echo"<p class='links'>".implode("\n",$sa)."</p>";$T=[];if($_GET["ns"]!==""&&!$Mg&&DB!=""){Connection::get()->selectDatabase(DB);$T=table_status('',true);}if($_GET["ns"]!==""&&!$Mg&&DB!=""){if($T){$this->admin->printTablesFilter();$this->admin->printTableList($T);}else
echo"<p class='message'>".lang(75)."</p>\n";}if(support("sql")||DIALECT=="elastic"){echo"<script".nonce().">\n";if(support("sql")&&$T){$hg=[];foreach($T
as$R=>$U)$hg[]=preg_quote($R,'/');echo"const jushLinks = { ".DIALECT.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$hg).")\\b/g ] };\n";foreach(["bac","bra","sqlite_quo","mssql_bra"]as$X)echo"jushLinks.$X = jushLinks.".DIALECT.";\n";}if(DIALECT!="elastic"&&$this->getConfig()->isSqlAutocompletionEnabled()&&(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"]))){$Zk=array_fill_keys(array_keys($T),[]);foreach(Driver::get()->getAllFields()as$R=>$m){foreach($m
as$l)$Zk[$R][]=$l["field"];}echo"window.addEventListener('DOMContentLoaded', () => { autocompletion = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Zk)."); });\n";}echo"</script>\n";}echo
script("let autocompletion;\nwindow.addEventListener('DOMContentLoaded', () => { initSyntaxHighlighting('".Connection::get()->getVersion()."', '".Connection::get()->getFlavor()."', autocompletion); });");}}function
printDatabaseSwitcher($Mg){$h=$this->admin->getDatabases();if(!$h&&DIALECT!="sqlite")return;echo"<div class='db-selector'><form action=''>";hidden_fields_get();echo"<div>";if($h)echo"<select id='database-select' name='db'>".optionlist([""=>lang(29)]+$h,DB)."</select>".script("mixin(gid('database-select'), {onmousedown: dbMouseDown, onchange: dbChange});");else
echo"<input id='database-select' class='input' name='db' value='".h(DB)."' autocapitalize='off'>\n";echo"<input type='submit' value='".lang(76)."' class='button ".($h?"hidden":"")."'>\n","</div>";if(support("scheme")&&$Mg!="db"&&DB!=""&&Connection::get()->selectDatabase(DB)){echo"<div>","<select id='scheme-select' name='ns'>".optionlist([""=>lang(77)]+$this->admin->getSchemas(),$_GET["ns"])."</select>".script("mixin(gid('scheme-select'), {onmousedown: dbMouseDown, onchange: dbChange});"),"</div>";if($_GET["ns"]!="")set_schema($_GET["ns"]);}foreach(["import","sql","schema","dump","privileges"]as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</form></div>\n";}function
printTableList(array$T){$Dg=($this->settings->isNavigationDual()?"class='dual'":($this->settings->isNavigationReversed()?"class='reversed'":""));echo"<nav id='tables'><menu $Dg>";foreach($T
as$R=>$zk){$_=$this->admin->getTableName($zk);if($_=="")continue;echo"<li>";$ta=in_array($R,[$_GET["table"],$_GET["select"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"]]);$Cb="primary".(is_view($zk)?" view":"");$Kk=support("table")||support("indexes");$Dj=h(ME)."select=".urlencode($R);$Sk=h(ME)."table=".urlencode($R);if($this->settings->isSelectionPreferred()){if($this->settings->isNavigationReversed()&&$Kk)echo" <a href='$Sk' title='",lang(33),"' class='secondary'>",icon("structure"),"</a>";echo"<a href='$Dj'",bold($ta,$Cb)," data-primary='true' title='$_'>$_</a>";if($this->settings->isNavigationDual()&&$Kk)echo" <a href='$Sk' title='",lang(33),"' class='secondary'>",icon_solo("structure"),"</a>";}else{if($this->settings->isNavigationReversed())echo" <a href='$Dj' title='",lang(32),"' class='secondary'>",icon("data"),"</a>";if($Kk)echo"<a href='$Sk'",bold($ta,$Cb)," data-primary='true' title='$_'>$_</a>";else
echo"<span data-primary='true'",bold($ta,$Cb),">$_</span>";if($this->settings->isNavigationDual())echo" <a href='$Dj' title='",lang(32),"' class='secondary'>",icon_solo("data"),"</a>";}echo"</li>\n";}echo"</menu></nav>\n";}function
getSettingsRows($Fe){$P=parent::getSettingsRows($Fe);if($Fe==1){$B=[""=>lang(13),Config::$NavigationSimple=>lang(78),Config::$NavigationDual=>lang(79),Config::$NavigationReversed=>lang(80)];$j=$B[$this->config->getNavigationMode()];$B[""].=" ($j)";$P["navigationMode"]="<tr><th>".lang(81)."</th>"."<td>".html_radios("navigationMode",$B,($pa=$this->settings->getParameter("navigationMode"))!==null?$pa:"")."<span class='input-hint'>".lang(82)."</span>"."</td></tr>\n";$B=[""=>lang(13),0=>lang(33),1=>lang(32),];$j=$B[$this->config->isSelectionPreferred()?1:0];$B[""].=" ($j)";$P["preferSelection"]="<tr><th>".lang(83)."</th>"."<td>".html_select("preferSelection",$B,($pa=$this->settings->getParameter("preferSelection"))!==null?$pa:"","","",true)."<span class='input-hint'>".lang(84)."</span>"."</td></tr>\n";}return$P;}function
getForeignColumnInfo(array$le,$c){return
null;}}class
TmpFile{private$handler;private$size;function
__construct(){$this->handler=tmpfile();}function
write($hc){if(!$this->handler)return;$this->size+=strlen($hc);fwrite($this->handler,$hc);}function
send(){if(!$this->handler)return;fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}function
select(Result$I,$f=null,$Ih=[],$w=0){$hg=[];$u=[];$d=[];$eb=[];$Ol=[];$J=[];for($q=0;(!$w||$q<$w)&&($K=$I->fetchRow());$q++){if(!$q){echo"<div class='scrollable'>\n","<table class='nowrap'>\n","<thead><tr>";for($Ff=0;$Ff<count($K);$Ff++){$l=$I->fetchField();if(!$l){echo"<th></th>";continue;}$_=$l->name;$Hh=isset($l->orgtable)?$l->orgtable:"";$Gh=isset($l->orgname)?$l->orgname:$_;if(isset($l->table))$J[$l->table]=$Hh;if($Ih&&DIALECT=="sql")$hg[$Ff]=($_=="table"?"table=":($_=="possible_keys"?"indexes=":null));elseif($Hh!=""){if(!isset($u[$Hh])){$u[$Hh]=[];foreach(indexes($Hh,$f)as$t){if($t["type"]=="PRIMARY"){$u[$Hh]=array_flip($t["columns"]);break;}}$d[$Hh]=$u[$Hh];}if(isset($d[$Hh][$Gh])){unset($d[$Hh][$Gh]);$u[$Hh][$Gh]=$Ff;$hg[$Ff]=$Hh;}}if($l->charsetnr==63)$eb[$Ff]=true;$Ol[$Ff]=$l->type;echo"<th".($Hh!=""||$l->name!=$Gh?" title='".h(($Hh!=""?"$Hh.":"").$Gh)."'":"").">".h($_).($Ih?doc_link(['sql'=>"explain-output.html#explain_".strtolower($_),'mariadb'=>"explain/#the-columns-in-explain-select",]):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$v=>$X){$x="";if(isset($hg[$v])&&!$d[$hg[$v]]){if($Ih&&DIALECT=="sql"){$R=$K[array_search("table=",$hg)];$x=ME.$hg[$v].urlencode($Ih[$R]!=""?$Ih[$R]:$R);}else{$x=ME."edit=".urlencode($hg[$v]);foreach($u[$hg[$v]]as$Fb=>$Ff)$x
.="&where".urlencode("[".bracket_escape($Fb)."]")."=".urlencode($K[$Ff]);}}elseif(is_web_url($X))$x=$X;if($X===null)$X="<i>NULL</i>";elseif($eb[$v]&&!is_utf8($X))$X="<i>".lang(41,strlen($X))."</i>";else{$X=h($X);if($Ol[$v]==254)$X="<code>$X</code>";}if($x)$X="<a href='".h($x)."'".(is_web_url($x)?target_blank():'').">$X</a>";$Cb=$Ol[$v]<=9||$Ol[$v]==246?"class='number'":"";echo"<td $Cb>$X</td>";}}echo($q?"</table>\n</div>":"<p class='message'>".lang(85))."\n";return$J;}function
referencable_primary($Ij){$J=[];foreach(table_status('',true)as$Uk=>$R){if($Uk!=$Ij&&fk_support($R)){foreach(fields($Uk)as$l){if($l["primary"]){if($J[$Uk]){unset($J[$Uk]);break;}$J[$Uk]=$l;}}}}return$J;}function
textarea($_,$Y,$L=10,$Mb=80){echo"<textarea name='".h($_)."' rows='$L' cols='$Mb' class='sqlarea jush-".DIALECT."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($Pa,$B,$Y="",$wh="",$oi=""){$cl=($B?"select":"input");return"<$cl $Pa".($B?"><option value=''>$oi".optionlist($B,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$oi'>").($wh?script("qsl('$cl').onchange = $wh;",""):"");}function
json_row($v,$X=null){static$be=true;if($be)echo"{";if($v!=""){echo($be?"":",")."\n\t\"".addcslashes($v,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\t\"\\/").'"':'null');$be=false;}else{echo"\n}\n";$be=true;}}function
edit_type($v,$l,$Ib,$me=[],$Nd=[]){$U=isset($l["type"])?$l["type"]:null;echo'<td><select name="',h($v),'[type]" class="type" aria-labelledby="label-type">';$Vc=Driver::get()->getTypes();if($U&&!isset($Vc[$U])&&!isset($me[$U])&&!in_array($U,$Nd))$Nd[]=$U;$Bk=Driver::get()->getStructuredTypes();if($me)$Bk[lang(86)]=$me;echo
optionlist(array_merge($Nd,$Bk),$U),'</select><td><input name="',h($v),'[length]" value="',h(isset($l["length"])?$l["length"]:null),'" size="3"',(!(isset($l["length"])?$l["length"]:null)&&preg_match('~var(char|binary)$~',$U)?" class='input required'":" class='input'"),' aria-labelledby="label-length"><td class="options">',($Ib?"<select name='".h($v)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'").'><option value="">('.lang(87).')'.optionlist($Ib,isset($l["collation"])?$l["collation"]:null).'</select>':''),(Driver::get()->getUnsigned()?"<select name='".h($v)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(Driver::get()->getUnsigned(),isset($l["unsigned"])?$l["unsigned"]:null).'</select>':''),(isset($l['on_update'])?"<select name='".h($v)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist([""=>"(".lang(88).")","CURRENT_TIMESTAMP"],(preg_match('~^CURRENT_TIMESTAMP~i',$l["on_update"])?"CURRENT_TIMESTAMP":$l["on_update"])).'</select>':''),($me?"<select name='".h($v)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(89).")".optionlist(Driver::get()->getOnActions(),isset($l["on_delete"])?$l["on_delete"]:null)."</select> ":" ");}function
get_partitions_info($R){$te="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=Connection::get()->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $te ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$of=[];list($of["partition_by"],$of["partition"],$of["partitions"])=$I->fetchRow();$ei=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $te AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$of["partition_names"]=array_keys($ei);$of["partition_values"]=array_values($ei);return$of;}function
process_length($bg){$sd=Driver::$EnumLengthPattern;return(preg_match("~^\\s*\\(?\\s*$sd(?:\\s*,\\s*$sd)*+\\s*\\)?\\s*\$~",$bg)&&preg_match_all("~$sd~",$bg,$z)?"(".implode(",",$z[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$bg)));}function
process_type($l,$Gb="COLLATE"){return" $l[type]".process_length($l["length"]).(preg_match(number_type(),$l["type"])&&in_array($l["unsigned"],Driver::get()->getUnsigned())?" $l[unsigned]":"").(preg_match('~char|text|enum|set~',$l["type"])&&$l["collation"]?" $Gb ".(DIALECT=="mssql"?$l["collation"]:q($l["collation"])):"");}function
process_field($l,$Ll){if($l["on_update"])$l["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$l["on_update"]);return[idf_escape(trim($l["field"])),process_type($Ll),($l["null"]?" NULL":" NOT NULL"),default_value($l),(preg_match('~timestamp|datetime~',$l["type"])&&$l["on_update"]?" ON UPDATE ".$l["on_update"]:""),(support("comment")&&$l["comment"]!=""?" COMMENT ".q($l["comment"]):""),($l["auto_increment"]?auto_increment():null),];}function
default_value($l){$j=$l["default"];if($j===null)return"";$xe=$l["generated"];if(in_array($xe,Driver::get()->getGenerated())){if(DIALECT=="mssql")return" AS ($j)".($xe=="VIRTUAL"?"":" $xe");else
return" GENERATED ALWAYS AS ($j) $xe";}if(stripos($j,"GENERATED ")===0)return" $j";if(preg_match('~char|binary|text|json|enum|set~',$l["type"])||preg_match('~^(?![a-z])~i',$j)){if(DIALECT=="sql"&&preg_match('~text|json~',$l["type"]))return" DEFAULT (".q($j).")";else
return" DEFAULT ".q($j);}else{$j=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$j);return" DEFAULT ".(DIALECT=="sqlite"?"($j)":$j);}}function
type_class($U){foreach(['char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',]as$v=>$X){if(preg_match("~$v|$X~",$U))return" class='$v'";}}function
edit_fields(array$m,array$Ib,$U="TABLE",$me=[]){$m=array_values($m);$Ub=$_POST?$_POST["comments"]:Admin::get()->getSettings()->getParameter("commentsOpened");$Rb=$Ub?"":"class='hidden'";echo"<thead><tr>\n";if(support("move_col"))echo"<td class='jsonly'></td>";if($U=="PROCEDURE")echo"<td></td>";echo"<th id='label-name'>",($U=="TABLE"?lang(90):lang(91)),"</th>\n","<td id='label-type'>",lang(43),"<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>",script("gid('enum-edit').onblur = onFieldLengthBlur;"),"</td>\n","<td id='label-length'>",lang("Length"),"</td>\n","<td>",lang(92),"</td>\n";if($U=="TABLE")echo"<td id='label-null'>NULL</td>\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='",lang(46),"'>AI</abbr>",doc_link(['sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",]),"</td>\n","<td id='label-default'>",lang(47),"</td>\n",support("comment")?"<td id='label-comment' $Rb>".lang(45)."</td>\n":"";echo"<td>","<button name='add[",(support("move_col")?0:count($m)),"]' value='1' title='",h(lang(93)),"' class='button light'>",icon_solo("add"),"</button>",script("row_count = ".count($m).";"),"</td>\n","</tr></thead>\n";$Cb=support("move_col")?"class='sortable'":"";echo"<tbody $Cb>\n";foreach($m
as$q=>$l){$q++;$Jh=$l[($_POST?"orig":"field")];$Rc=(isset($_POST["add"][$q-1])||(isset($l["field"])&&!(isset($_POST["drop_col"][$q])?$_POST["drop_col"][$q]:null)))&&(support("drop_col")||$Jh=="");$Ck=$Rc?"":"style='display: none;'";echo"<tr $Ck>\n";if(support("move_col"))echo"<td class='handle jsonly'>",icon_solo("handle"),"</td>";if($U=="PROCEDURE")echo"<td>",html_select("fields[$q][inout]",Driver::get()->getInOut(),$l["inout"]),"</td>\n";echo"<th>";if($Rc)echo"<input class='input' name='fields[$q][field]' value='",h($l["field"]),"' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$q][orig]",$Jh);edit_type("fields[$q]",$l,$Ib,$me);echo"</th>\n";if($U=="TABLE"){echo"<td>",checkbox("fields[$q][null]",1,$l["null"],"","","block","label-null"),"</td>\n";$xb=$l["auto_increment"]?"checked":"";echo"<td><label class='block'><input type='radio' name='auto_increment_col' value='$q' $xb aria-labelledby='label-ai'></label></td>\n","<td class='default-value'>";if(Driver::get()->getGenerated())echo
html_select("fields[$q][generated]",array_merge(["","DEFAULT"],Driver::get()->getGenerated()),$l["generated"]);else
echo
checkbox("fields[$q][generated]",1,$l["generated"],"","","","label-default");echo"<input class='input' name='fields[$q][default]' value='",h($l["default"]),"' aria-labelledby='label-default'>","</td>\n";if(support("comment")){$vg=Connection::get()->isMinVersion("5.5")?1024:255;echo"<td $Rb>","<input class='input' name='fields[$q][comment]' value='",h($l["comment"]),"' data-maxlength='$vg' aria-labelledby='label-comment'>","</td>\n";}}echo"<td>";if(support("move_col"))echo"<button name='add[$q]' value='1' title='".h(lang(93))."' class='button light'>",icon_solo("add"),"</button>","<button name='up[$q]' value='1' title='".h(lang(94))."' class='button light hidden'>",icon_solo("arrow-up"),"</button>","<button name='down[$q]' value='1' title='".h(lang(95))."' class='button light hidden'>",icon_solo("arrow-down"),"</button>";if($Jh==""||support("drop_col"))echo"<button name='drop_col[$q]' value='1' title='".h(lang(55))."' class='button light'>",icon_solo("remove"),"</button>";echo"</td>\n</tr>\n";}echo"</tbody>";}function
process_fields(&$m){$A=0;if($_POST["up"]){$Uf=0;foreach($m
as$v=>$l){if(key($_POST["up"])==$v){unset($m[$v]);array_splice($m,$Uf,0,[$l]);break;}if(isset($l["field"]))$Uf=$A;$A++;}}elseif($_POST["down"]){$qe=false;foreach($m
as$v=>$l){if(isset($l["field"])&&$qe){unset($m[key($_POST["down"])]);array_splice($m,$A,0,[$qe]);break;}if(key($_POST["down"])==$v)$qe=$l;$A++;}}elseif($_POST["add"]){$m=array_values($m);array_splice($m,key($_POST["add"]),0,[[]]);}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($y){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($y[0][0].$y[0][0],$y[0][0],substr($y[0],1,-1))),'\\'))."'";}function
grant($Ae,array$Fi,$d,$uh,$em){if(!$Fi)return
true;if($Fi==["ALL PRIVILEGES","GRANT OPTION"]){if($Ae)return(bool)queries("GRANT ALL PRIVILEGES ON $uh TO $em WITH GRANT OPTION");else
return
queries("REVOKE ALL PRIVILEGES ON $uh FROM $em")&&queries("REVOKE GRANT OPTION ON $uh FROM $em");}if($Fi==["GRANT OPTION","PROXY"]){if($Ae)return(bool)queries("GRANT PROXY ON $uh TO $em WITH GRANT OPTION");else
return(bool)queries("REVOKE PROXY ON $uh FROM $em");}return(bool)queries(($Ae?"GRANT ":"REVOKE ").preg_replace('~(GRANT OPTION)\([^)]*\)~','$1',implode("$d, ",$Fi).$d)." ON $uh ".($Ae?"TO ":"FROM ").$em);}function
drop_create($Xc,$nc,$Zc,$hl,$bd,$lg,$Hg,$Fg,$Gg,$rh,$bh){if($_POST["drop"])query_redirect($Xc,$lg,$Hg);elseif($rh=="")query_redirect($nc,$lg,$Gg);elseif($rh!=$bh){$pc=queries($nc);queries_redirect($lg,$Fg,$pc&&queries($Xc));if($pc)queries($Zc);}else
queries_redirect($lg,$Fg,queries($hl)&&queries($bd)&&queries($Xc)&&queries($nc));}function
create_trigger($uh,$K){$rl=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(DIALECT=="mssql"?$uh.$rl:$rl.$uh).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($pj,$K){$Yj=[];$m=(array)$K["fields"];ksort($m);$jf=implode("|",Driver::get()->getInOut());foreach($m
as$l){if($l["field"]!="")$Yj[]=(preg_match("~^($jf)\$~",$l["inout"])?"$l[inout] ":"").idf_escape($l["field"]).process_type($l,"CHARACTER SET");}$Gc=rtrim($K["definition"],";");return"CREATE $pj ".idf_escape(trim($K["name"]))." (".implode(", ",$Yj).")".($pj=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(DIALECT=="pgsql"?" AS ".q($Gc):"\n$Gc;");}function
remove_definer($G){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$G);}function
format_foreign_key($p){$vh=implode("|",Driver::get()->getOnActions());$i=$p["db"];$gh=$p["ns"];return" FOREIGN KEY (".implode(", ",array_map('AdminNeo\idf_escape',$p["source"])).") REFERENCES ".($i!=""&&$i!=$_GET["db"]?idf_escape($i).".":"").($gh!=""&&$gh!=$_GET["ns"]?idf_escape($gh).".":"").idf_escape($p["table"])." (".implode(", ",array_map('AdminNeo\idf_escape',$p["target"])).")".(preg_match("~^($vh)\$~",$p["on_delete"])?" ON DELETE $p[on_delete]":"").(preg_match("~^($vh)\$~",$p["on_update"])?" ON UPDATE $p[on_update]":"");}function
tar_file($o,$vl){$J=pack("a100a8a8a8a12a12",$o,644,0,0,decoct($vl->size),decoct(time()));$zb=8*32;for($q=0;$q<strlen($J);$q++)$zb+=ord($J[$q]);$J
.=sprintf("%06o",$zb)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$vl->send();echo
str_repeat("\0",511-($vl->size+511)%512);}function
ini_bytes($pf){$X=ini_get($pf);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$ki,$il="<sup>?</sup>"){if(!(isset($ki[DIALECT])?$ki[DIALECT]:null))return"";$mm=preg_replace('~^(\d\.?\d).*~s','\1',Connection::get()->getVersion());$Zl=['sql'=>"https://dev.mysql.com/doc/refman/$mm/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(Connection::get()->isCockroachDB()?"current":$mm)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".str_replace(".","",$mm)."&id=",'elastic'=>"https://www.elastic.co/guide/en/elasticsearch/reference/$mm/",];if(Connection::get()->isMariaDB()){$Zl['sql']="https://mariadb.com/kb/en/";$ki['sql']=isset($ki['mariadb'])?$ki['mariadb']:str_replace(".html","/",$ki['sql']);}return"<a href='".h($Zl[DIALECT].$ki[DIALECT].(DIALECT=='mssql'?"?view=sql-server-ver$mm":""))."'".target_blank().">$il</a>";}function
db_size($i){if(!Connection::get()->selectDatabase($i))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($nc){static$Yj=false;if(!$Yj&&preg_match('~\butf8mb4~i',$nc)){$Yj=true;echo"SET NAMES ".charset(Connection::get()).";\n\n";}}error_reporting(E_ALL&~E_DEPRECATED);set_error_handler(function($ud,$k){return(bool)preg_match('~^Undefined (array key|offset|index)~',$k);},E_WARNING|E_NOTICE);;$Zd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Zd||ini_get("filter.default_flags")){foreach(['_GET','_POST','_COOKIE','_SERVER']as$X){$Tl=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Tl)$$X=$Tl;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");class
Server{private$params;private$key;function
__construct(array$D,$v=null){$this->params=$D;$this->key=$v;}function
getKey(){return
isset($this->key)?$this->key:substr(md5($this->getDriver().$this->getServer()),0,8);}function
getDriver(){return$this->params["driver"];}function
getServer(){return
isset($this->params["server"])?$this->params["server"]:"";}function
getDatabase(){return
isset($this->params["database"])?$this->params["database"]:"";}function
getName(){return
isset($this->params["name"])?$this->params["name"]:(isset($this->params["server"])?$this->params["server"]:"");}function
getUsername(){return
isset($this->params["username"])?$this->params["username"]:"";}function
getPassword(){return
isset($this->params["password"])?$this->params["password"]:"";}function
hasCredentials(){return$this->getUsername()!=""||$this->getPassword()!="";}function
getConfigParams(){$D=isset($this->params["config"])?$this->params["config"]:[];$_e=["servers"];foreach($_e
as$Wh){if(isset($D[$Wh]))unset($D[$Wh]);}return$D;}}class
Config{static$NavigationSimple="simple";static$NavigationDual="dual";static$NavigationReversed="reversed";private$params;private$servers=[];function
__construct(array$D){$this->params=$D;if(isset($this->params["servers"])){foreach($this->params["servers"]as$v=>$O){$Pj=new
Server($O,is_string($v)?$v:null);$this->params["servers"][$v]=$Pj;$this->servers[$Pj->getKey()]=$Pj;}}}function
getTheme(){return
isset($this->params["theme"])?$this->params["theme"]:"default";}function
getColorVariant(){return
isset($this->params["colorVariant"])?$this->params["colorVariant"]:"blue";}function
getCssUrls(){return$this->parseList(isset($this->params["cssUrls"])?$this->params["cssUrls"]:[]);}function
getJsUrls(){return$this->parseList(isset($this->params["jsUrls"])?$this->params["jsUrls"]:[]);}function
getNavigationMode(){return
isset($this->params["navigationMode"])?$this->params["navigationMode"]:self::$NavigationSimple;}function
isNavigationSimple(){return$this->getNavigationMode()==self::$NavigationSimple;}function
isNavigationDual(){return$this->getNavigationMode()==self::$NavigationDual;}function
isNavigationReversed(){return$this->getNavigationMode()==self::$NavigationReversed;}function
isSelectionPreferred(){return
isset($this->params["preferSelection"])?$this->params["preferSelection"]:false;}function
isJsonValuesDetection(){return
isset($this->params["jsonValuesDetection"])?$this->params["jsonValuesDetection"]:false;}function
isJsonValuesAutoFormat(){return
isset($this->params["jsonValuesAutoFormat"])?$this->params["jsonValuesAutoFormat"]:false;}function
isRelationLinks(){return
isset($this->params["relationLinks"])?$this->params["relationLinks"]:false;}function
getRecordsPerPage(){return(int)(isset($this->params["recordsPerPage"])?$this->params["recordsPerPage"]:50);}function
getEnumAsSelectThreshold(){if(array_key_exists("enumAsSelectThreshold",$this->params))return$this->params["enumAsSelectThreshold"]!==null?(int)$this->params["enumAsSelectThreshold"]:null;else
return
5;}function
isVersionVerificationEnabled(){return
isset($this->params["versionVerification"])?$this->params["versionVerification"]:true;}function
isSqlAutocompletionEnabled(){return
isset($this->params["sqlAutocompletion"])?$this->params["sqlAutocompletion"]:true;}function
getHiddenDatabases(){return$this->parseList(isset($this->params["hiddenDatabases"])?$this->params["hiddenDatabases"]:[]);}function
getHiddenSchemas(){return$this->parseList(isset($this->params["hiddenSchemas"])?$this->params["hiddenSchemas"]:[]);}function
getVisibleCollations(){return$this->parseList(isset($this->params["visibleCollations"])?$this->params["visibleCollations"]:[]);}function
getDefaultDriver(array$Wc){$Uc=isset($this->params["defaultDriver"])?$this->params["defaultDriver"]:null;return$Uc&&isset($Wc[$Uc])?$Uc:key($Wc);}function
getDefaultServer(){$O=isset($this->params["defaultServer"])?$this->params["defaultServer"]:null;if($O===null)return
null;$Pj=isset($this->params["servers"][$O])?$this->params["servers"][$O]:null;if($Pj)return$Pj->getKey();return$O;}function
getDefaultDatabase(){return
isset($this->params["defaultDatabase"])?$this->params["defaultDatabase"]:null;}function
getDefaultPasswordHash(){return
isset($this->params["defaultPasswordHash"])?$this->params["defaultPasswordHash"]:null;}function
getSslKey(){return
isset($this->params["sslKey"])?$this->params["sslKey"]:null;}function
getSslCertificate(){return
isset($this->params["sslCertificate"])?$this->params["sslCertificate"]:null;}function
getSslCaCertificate(){return
isset($this->params["sslCaCertificate"])?$this->params["sslCaCertificate"]:null;}function
getSslTrustServerCertificate(){return
isset($this->params["sslTrustServerCertificate"])?$this->params["sslTrustServerCertificate"]:null;}function
getSslEncrypt(){return
isset($this->params["sslEncrypt"])?$this->params["sslEncrypt"]:null;}function
getSslMode(){return
isset($this->params["sslMode"])?$this->params["sslMode"]:null;}function
hasServers(){return
isset($this->params["servers"]);}function
getServerPairs(array$Wc){$ek=null;foreach($this->servers
as$O){if(!isset($Wc[$O->getDriver()]))continue;if(!$ek)$ek=$O->getDriver();elseif($O->getDriver()!=$ek){$ek=null;break;}}$Qj=[];foreach($this->servers
as$v=>$O){if(!isset($Wc[$O->getDriver()]))continue;$Oj=$O->getName();if($ek&&$Oj)$Qj[$v]=$Oj;else$Qj[$v]=$Wc[$O->getDriver()].($Oj!=""?" - $Oj":"");}return$Qj;}function
getServer($Nj){return
isset($this->servers[$Nj])?$this->servers[$Nj]:null;}function
applyServer($O){$O=$this->getServer($O);if(!$O)return;$this->params=array_merge($this->params,$O->getConfigParams());}private
function
parseList($jg){if(is_array($jg))return$jg;return
preg_split('~\s*,\s*~',(string)$jg);}}class
Settings{static$ColorSchemeLight="light";static$ColorSchemeDark="dark";private$config;private$params=[];function
__construct(Config$Yb){$this->config=$Yb;if(isset($_COOKIE["neo_settings"])){parse_str($_COOKIE["neo_settings"],$this->params);$this->save();}if(isset($this->params["comments"]))$this->updateParameters(["commentsOpened"=>$this->params["comments"],"indexOptions"=>$this->params["index_options"],"comments"=>null,"index_options"=>null,]);if(isset($_COOKIE["neo_export"])){parse_str($_COOKIE["neo_export"],$D);$this->updateParameters(["exportFormat"=>$D["format"],"exportOutput"=>$D["output"],]);unset($_COOKIE["neo_export"]);cookie("neo_export","",-3600);}if(isset($_COOKIE["neo_dump"])){parse_str($_COOKIE["neo_dump"],$D);$this->updateParameters(["dumpFormat"=>$D["format"],"dumpDbStyle"=>$D["db_style"],"dumpTypes"=>isset($D["types"])?$D["types"]:null,"dumpRoutines"=>isset($D["routines"])?$D["routines"]:null,"dumpEvents"=>isset($D["events"])?$D["events"]:null,"dumpTableStyle"=>$D["table_style"],"dumpAutoIncrement"=>isset($D["auto_increment"])?$D["auto_increment"]:null,"dumpTriggers"=>isset($D["triggers"])?$D["triggers"]:null,"dumpDataStyle"=>$D["data_style"],"dumpOutput"=>$D["output"],]);unset($_COOKIE["neo_dump"]);cookie("neo_dump","",-3600);}}function
getParameter($v,$j=null){return
isset($this->params[$v])?$this->params[$v]:$j;}function
updateParameter($v,$Y){$this->updateParameters([$v=>$Y]);}function
updateParameters(array$D){$this->params=array_filter(array_merge($this->params,$D),function($Y){return$Y!==null;});$this->save();}private
function
save(){cookie("neo_settings",http_build_query($this->params),7776000);}function
getColorScheme(){return$this->getParameter("colorScheme");}function
getNavigationMode(){return($pa=$this->getParameter("navigationMode"))!==null?$pa:$this->config->getNavigationMode();}function
isNavigationSimple(){return$this->getNavigationMode()==Config::$NavigationSimple;}function
isNavigationDual(){return$this->getNavigationMode()==Config::$NavigationDual;}function
isNavigationReversed(){return$this->getNavigationMode()==Config::$NavigationReversed;}function
isSelectionPreferred(){return($pa=$this->getParameter("preferSelection"))!==null?$pa:$this->config->isSelectionPreferred();}function
isRelationLinks(){return
isset($this->params["relationLinks"])?$this->params["relationLinks"]:$this->config->isRelationLinks();}function
getRecordsPerPage(){return($pa=$this->getParameter("recordsPerPage"))!==null?$pa:$this->config->getRecordsPerPage();}function
getEnumAsSelectThreshold(){$Y=$this->getParameter("enumAsSelectThreshold");if($Y<0)return
null;return$Y!==null?(int)$Y:$this->config->getEnumAsSelectThreshold();}}if(!function_exists("str_starts_with")){function
str_starts_with($Qe,$Yg){return
strpos($Qe,$Yg)===0;}}if(!function_exists("str_contains")){function
str_contains($Qe,$Yg){return
strpos($Qe,$Yg)!==false;}}if(!function_exists("password_verify")){function
password_verify($E,$Pe){return
false;}}function
version(){return
VERSION;}function
idf_unescape($s){if(!preg_match('~^[`\'"[]~',$s))return$s;$Uf=substr($s,-1);return
str_replace($Uf.$Uf,$Uf,substr($s,1,-1));}function
q($Q){return
Connection::get()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($Gi,$Zd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($v,$X)=each($Gi)){foreach($X
as$If=>$W){unset($Gi[$v][$If]);if(is_array($W)){$Gi[$v][stripslashes($If)]=$W;$Gi[]=&$Gi[$v][stripslashes($If)];}else$Gi[$v][stripslashes($If)]=($Zd?$W:stripslashes($W));}}}}function
bracket_escape($s,$Xa=false){static$Al=[':'=>':1',']'=>':2','['=>':3','"'=>':4'];return
strtr($s,($Xa?array_flip($Al):$Al));}function
min_version($mm,$rg=null,$f=null){if(!$f)$f=Connection::get();if($rg&&$f->isMariaDB())$mm=$rg;return$mm&&$f->isMinVersion($mm);}function
charset(Connection$f){return($f->isMinVersion("5.5.3")?"utf8mb4":"utf8");}function
link_files($_,array$Yd){switch($_){case'favicon-blue.ico':$o='favicon-blue-aca42af56791f1e5699f22fa8e5b7e29__59f1e890.ico';break;case'favicon-green.ico':$o='favicon-green-9d01f379ad1677541348f943c2ba7633__59f1e890.ico';break;case'favicon-red.ico':$o='favicon-red-6fc13ee62dc8da41da8e28c58d688139__59f1e890.ico';break;case'favicon-blue.svg':$o='favicon-blue-8d5d37563b5244e03e11135cc7939f80__59f1e890.svg';break;case'favicon-green.svg':$o='favicon-green-24369d344ab89ca286ec343b8fc15da0__59f1e890.svg';break;case'favicon-red.svg':$o='favicon-red-a6cbda011ea4968eaf8da0e2b8313082__59f1e890.svg';break;case'apple-touch-icon-blue.png':$o='apple-touch-icon-blue-b284772ce058bb3862fe232d7922f3e7__59f1e890.png';break;case'apple-touch-icon-green.png':$o='apple-touch-icon-green-c4ba0ad59ea8ecc2e5fdb53695c28e5a__59f1e890.png';break;case'apple-touch-icon-red.png':$o='apple-touch-icon-red-4f51a03407fbf4f1e8a8001a0a228048__59f1e890.png';break;case'logo.svg':$o='logo-d7973a9247fee3bb067889cb0a939951__59f1e890.svg';break;case'jush.css':$o='jush-88b9d6cd6243fee3ac011c7c6d4bf617__87a07c36.css';break;case'jush-dark.css':$o='jush-dark-ff7302bb2874a25b8a95a0f3da87e75d__59f1e890.css';break;case'jush.js':$o='jush-6930baf98aaca9134977e95fb01b2efa__ae054cac.js';break;case'icons.svg':$o='icons-b23ce0c785b91a784166ab29e9c8baf7__59f1e890.svg';break;case'default-blue.css':$o='default-blue-95968c021a129362d14532ede2609b64__b5158906.css';break;case'default-green.css':$o='default-green-d6ec966ffd4b974a4bc07b84216606bf__b5158906.css';break;case'default-red.css':$o='default-red-bb3e8b5d982a1e47c0fd59b587f4f89b__b5158906.css';break;case'default-blue-dark.css':$o='default-blue-dark-a561e9f648953832ebcc709da6f3074e__1fb23772.css';break;case'default-green-dark.css':$o='default-green-dark-871aa3f880fca82e71581a65b7d850f1__1fb23772.css';break;case'default-red-dark.css':$o='default-red-dark-f51ef74ef11aa4d84cd4becf148a354c__1fb23772.css';break;case'main.js':$o='main-7e0bd6eae3f122e36f650e1b722b5ad5__1fb23772.js';break;default:$o=null;break;}if(!$o)return
null;return
BASE_URL."?file=".urldecode($o);}function
ini_bool($Bh){$X=ini_get($Bh);return
preg_match('~^(on|true|yes)$~i',$X)||(int)$X;}function
sid(){static$J;if($J===null)$J=(session_id()&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
save_driver_name($Uc,$O,$_){restart_session();$_SESSION["drivers"][$Uc][$O]=$_;stop_session();}function
get_driver_name($Uc,$O=null){return
isset($_SESSION["drivers"][$Uc][$O])?$_SESSION["drivers"][$Uc][$O]:Drivers::get($Uc);}function
set_password($lm,$O,$V,$E){$_SESSION["pwds"][$lm][$O][$V]=($_COOKIE["neo_key"]&&is_string($E)?[encrypt_string($E,$_COOKIE["neo_key"])]:$E);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["neo_key"]?decrypt_string($J[0],$_COOKIE["neo_key"]):false);return$J;}function
get_vals($G,$c=0){$J=[];$I=Connection::get()->query($G);if(is_object($I)){while($K=$I->fetchRow())$J[]=$K[$c];}return$J;}function
get_key_vals($G,$f=null,$Zj=true){if(!$f)$f=Connection::get();$J=[];$I=$f->query($G);if(is_object($I)){while($K=$I->fetchRow()){if($Zj)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($G,$f=null,$k="<p class='error'>"){if(!$f)$f=Connection::get();$J=[];$I=$f->query($G);if(is_object($I)){while($K=$I->fetchAssoc())$J[]=$K;}elseif(!$I&&!is_object($f)&&$k&&(defined("AdminNeo\PAGE_HEADER")||$k=="-- "))echo$k.error()."\n";return$J;}function
unique_array($K,$u){foreach($u
as$t){if(preg_match("~PRIMARY|UNIQUE~",$t["type"])){$J=[];foreach($t["columns"]as$v){if(!isset($K[$v]))continue
2;$J[$v]=$K[$v];}return$J;}}}function
escape_key($v){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$v,$y))return$y[1].idf_escape(idf_unescape($y[2])).$y[3];return
idf_escape($v);}function
where($Z,$m=[]){$Xb=[];foreach((array)$Z["where"]as$v=>$X){$v=bracket_escape($v,1);$c=escape_key($v);$Vd=isset($m[$v]["type"])?$m[$v]["type"]:null;if(DIALECT=="sql"&&$Vd=="json")$Xb[]="$c = CAST(".q($X)." AS JSON)";elseif(DIALECT=="sql"&&is_numeric($X)&&strpos($X,".")!==false)$Xb[]="$c LIKE ".q($X);elseif(DIALECT=="mssql"&&strpos($Vd,"datetime")===false)$Xb[]="$c LIKE ".q(preg_replace('~[_%[]~','[\0]',$X));else$Xb[]="$c = ".(isset($m[$v])?unconvert_field($m[$v],q($X)):q($X));if(DIALECT=="sql"&&preg_match('~char|text~',$Vd)&&preg_match("~[^ -@]~",$X))$Xb[]="$c = ".q($X)." COLLATE ".charset(Connection::get())."_bin";}foreach((array)$Z["null"]as$v)$Xb[]=escape_key($v)." IS NULL";return
implode(" AND ",$Xb);}function
where_check($X,$m=[]){parse_str($X,$tb);remove_slashes([&$tb]);return
where($tb,$m);}function
where_link($q,$c,$Y,$zh="="){return"&where%5B$q%5D%5Bcol%5D=".urlencode($c)."&where%5B$q%5D%5Bop%5D=".urlencode(($Y!==null?$zh:"IS NULL"))."&where%5B$q%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($d,$m,$M=[]){$J="";foreach($d
as$v=>$X){if($M&&!in_array(idf_escape($v),$M))continue;$Na=convert_field($m[$v]);if($Na)$J
.=", $Na AS ".idf_escape($v);}return$J;}function
cookie($_,$Y,$dg=2592000){header("Set-Cookie: $_=".urlencode($Y).($dg?"; expires=".gmdate("D, d M Y H:i:s",time()+$dg)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($kc="neo_settings"){parse_str(isset($_COOKIE[$kc])?$_COOKIE[$kc]:"",$P);return$P;}function
get_setting($v,$kc="neo_settings"){$P=get_settings($kc);return
isset($P[$v])?$P[$v]:null;}function
save_settings(array$P,$kc="neo_settings"){cookie($kc,http_build_query($P+get_settings($kc)));}function
restart_session(){if(!ini_bool("session.use_cookies")&&session_status()==PHP_SESSION_NONE)session_start();}function
stop_session($je=false){$cm=ini_bool("session.use_cookies");if(!$cm||$je){session_write_close();if($cm&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($v){return$_SESSION[$v][DRIVER][SERVER][$_GET["username"]];}function
set_session($v,$X){$_SESSION[$v][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($lm,$O,$V,$i=null){$Xl=remove_from_uri(implode("|",array_keys(Drivers::getList()))."|username|ext|".($i!==null?"db|":"").($lm=='mssql'||$lm=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Xl,$y);return"$y[1]?".(sid()?session_name()."=".urlencode(session_id())."&":"").urlencode($lm)."=".urlencode($O)."&".($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($i!=""?"&db=".urlencode($i):"").($y[2]?"&$y[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($lg,$Eg=null){if($Eg!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($lg!==null?$lg:$_SERVER["REQUEST_URI"]))][]=$Eg;}if($lg!==null){if($lg=="")$lg=".";header("Location: $lg");exit;}}function
query_redirect($G,$lg,$Eg,$Ui=true,$Bd=true,$Od=false,$pl=""){if($Bd){$wk=microtime(true);$Od=!Connection::get()->query($G);$pl=format_time($wk);}$pk=$G?Admin::get()->formatMessageQuery($G,$pl,$Od):"";if($Od){Admin::get()->addError(error().$pk.script("initToggles();"));return
false;}if($Ui)redirect($lg,$Eg.$pk);return
true;}function
queries($G){static$Li=[];static$wk;if(!$wk)$wk=microtime(true);if($G===null)return[implode("\n",$Li),format_time($wk)];if(support("sql")){$Li[]=(preg_match('~;$~',$G)?"DELIMITER ;;\n$G;\nDELIMITER ":$G).";";return
Connection::get()->query($G);}else{$Li[]=$G;return[];}}function
apply_queries($G,$T,$wd='AdminNeo\table'){foreach($T
as$R){if(!queries("$G ".$wd($R)))return
false;}return
true;}function
queries_redirect($lg,$Eg,$Ui){list($Li,$pl)=queries(null);return
query_redirect($Li,$lg,$Eg,$Ui,false,!$Ui,$pl);}function
format_time($wk){return
lang(96,max(0,microtime(true)-$wk));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Wh=""){return
substr(preg_replace("~(?<=[?&])($Wh".(sid()?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($v,$Cc=false,$Jc=""){$n=$_FILES[$v];if(!$n)return
null;foreach($n
as$v=>$X)$n[$v]=(array)$X;$J='';foreach($n["error"]as$v=>$k){if($k)return$k;$_=$n["name"][$v];$wl=$n["tmp_name"][$v];$gc=file_get_contents($Cc&&preg_match('~\.gz$~',$_)?"compress.zlib://$wl":$wl);if($Cc){$wk=substr($gc,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$wk))$gc=iconv("utf-16","utf-8",$gc);elseif($wk=="\xEF\xBB\xBF")$gc=substr($gc,3);}if($Jc){if(!preg_match("~$Jc\\s*\$~",$gc))$gc
.=";";$gc
.="\n\n";}$J
.=$gc;}return$J;}function
upload_error($k){$zg=($k==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($k?lang(97).($zg?" ".lang(98,$zg):""):lang(99));}function
repeat_pattern($li,$bg){return
str_repeat("$li{0,65535}",$bg/65535)."$li{0,".($bg%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
truncate_utf8($Q,$bg=80){if($Q=="")return"";if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$bg).")($)?)u",$Q,$y))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$bg).")($)?)",$Q,$y);return
h($y[1]).(isset($y[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(100)),preg_split('~~u',lang(101),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Pd=false){$J=table_status($R,$Pd);return($J?:["Name"=>$R]);}function
column_foreign_keys($R){$J=[];foreach(Admin::get()->getForeignKeys($R)as$p){foreach($p["source"]as$X)$J[$X][]=$p;}return$J;}function
fields_from_edit(){$J=[];foreach((array)$_POST["field_keys"]as$v=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$v];$_POST["fields"][$X]=$_POST["field_vals"][$v];}}foreach((array)$_POST["fields"]as$v=>$X){$_=bracket_escape($v,1);$J[$_]=["field"=>$_,"privileges"=>["insert"=>1,"update"=>1,"where"=>1,"order"=>1],"null"=>1,"auto_increment"=>($v==Driver::get()->primary),];}return$J;}function
dump_headers($cf,$Rg=false){$cf=friendly_url($cf).date("-Ymd-His");$Kd=Admin::get()->sendDumpHeaders($cf,$Rg);$Rh=$_POST["output"];if($Rh!="text")header("Content-Disposition: attachment; filename=$cf.$Kd".($Rh!="file"&&preg_match('~^[0-9a-z]+$~',$Rh)?".$Rh":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$Kd;}function
dump_csv($K){foreach($K
as$v=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$K[$v]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($ve,$c){return($ve?($ve=="unixepoch"?"DATETIME($c, '$ve')":($ve=="count distinct"?"COUNT(DISTINCT ":strtoupper("$ve("))."$c)"):$c);}function
get_temp_dir(){$ji=ini_get("upload_tmp_dir");if(!$ji)$ji=sys_get_temp_dir();return$ji;}function
open_file_with_lock($o){if(is_link($o))return
null;$n=fopen($o,"c+");if(!$n)return
null;chmod($o,0660);if(!flock($n,LOCK_EX)){fclose($n);return
null;}return$n;}function
write_and_unlock_file($n,$g){rewind($n);fwrite($n,$g);ftruncate($n,strlen($g));unlock_file($n);}function
unlock_file($n){flock($n,LOCK_UN);fclose($n);}function
first(array$Ma){return
reset($Ma);}function
get_private_key($nc){$o=get_temp_dir()."/adminneo.key";if(!$nc&&!file_exists($o))return
false;$n=open_file_with_lock($o);if(!$n)return
false;$v=stream_get_contents($n);if(!$v){$v=get_random_string();write_and_unlock_file($n,$v);}else
unlock_file($n);return$v;}function
get_random_string($cb=false){$jb=function_exists('random_bytes')?random_bytes(32):uniqid(mt_rand(),true);return$cb?$jb:md5($jb);}function
select_value($X,$x,$l,$ll){if(is_array($X)){$J="";foreach($X
as$If=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($If):"")."<td>".select_value($W,$x,$l,$ll);return"<table>$J</table>";}if(!$x)$x=Admin::get()->getFieldValueLink($X,$l);$J=$l?Admin::get()->formatFieldValue($X,$l):$X;if($J!==null){if(!is_utf8($J))$J="\0";elseif($ll!=""&&is_shortable($l))$J=truncate_utf8($J,max(0,+$ll));else$J=h($J);}return
Admin::get()->formatSelectionValue($J,$x,$l,$X);}function
is_mail($Y){return
is_string($Y)&&filter_var($Y,FILTER_VALIDATE_EMAIL);}function
is_web_url($Y){if(!is_string($Y)||!preg_match('~^https?://~i',$Y))return
false;$Vb=parse_url($Y);if(!$Vb)return
false;$nd=array_map('urlencode',explode('/',$Vb['path']));$Yl=str_replace($Vb['path'],implode('/',$nd),$Y);parse_str($Vb['query'],$D);$Yl=str_replace($Vb['query'],http_build_query($D),$Yl);return(bool)filter_var($Yl,FILTER_VALIDATE_URL);}function
is_shortable($l){return$l?preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$l["type"]):false;}function
count_rows($R,$Z,$zf,$De){$G=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($zf&&(DIALECT=="sql"||count($De)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$De).")$G":"SELECT COUNT(*)".($zf?" FROM (SELECT 1$G GROUP BY ".implode(", ",$De).") x":$G));}function
slow_query($G){$i=Admin::get()->getDatabase();$ql=Admin::get()->getQueryTimeout();$hk=Driver::get()->slowQuery($G,$ql);if(!$hk&&support("kill")&&($f=connect())&&($i==""||$f->selectDatabase($i))){$Of=$f->getValue(connection_id());echo'<script',nonce(),'>
	const timeout = setTimeout(() => {
		ajax(\'',js_escape(ME),'script=kill\', function() {
		}, \'kill=',$Of,'&token=',get_token(),'\');
	}, ',1000*$ql,');
</script>
';}else$f=null;ob_flush();flush();$J=@get_key_vals(($hk?:$G),$f,false);if($f){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$Ri=rand(1,1e6);return($Ri^$_SESSION["token"]).":$Ri";}function
verify_token(){list($xl,$Ri)=explode(":",$_POST["token"]);return($Ri^$_SESSION["token"])==$xl;}function
lzw_decompress($cb){$Nc=256;$db=8;$Eb=[];$ij=0;$jj=0;for($q=0;$q<strlen($cb);$q++){$ij=($ij<<8)+ord($cb[$q]);$jj+=8;if($jj>=$db){$jj-=$db;$Eb[]=$ij>>$jj;$ij&=(1<<$jj)-1;$Nc++;if($Nc>>$db)$db++;}}$Mc=range("\0","\xFF");$J=$Em="";foreach($Eb
as$q=>$Db){$kd=$Mc[$Db];if(!isset($kd))$kd=$Em.$Em[0];$J
.=$kd;if($q)$Mc[]=$Em.$kd[0];$Em=$kd;}return$J;}function
script($lk,$_l="\n"){return"<script".nonce().">$lk</script>$_l";}function
script_src($Yl,$Fc=false){return"<script src='".h($Yl)."'".nonce().($Fc?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($_,$Y=""){return"<input type='hidden' name='".h($_)."' value='".h($Y)."'>";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return$Q!==null&&$Q!==""?str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8')):"";}function
icon_solo($r){return
icon($r,"solo");}function
icon_chevron_down(){return
icon("chevron-down","chevron");}function
icon_chevron_right(){return
icon("chevron-down","chevron-right");}function
icon($r,$Cb=null){$r=h($r);return"<svg class='icon ic-$r $Cb'><use href='".link_files("icons.svg",[])."#$r'/></svg>";}function
checkbox($_,$Y,$xb,$Qf="",$xh="",$Cb="",$Rf=""){$J="<input type='checkbox' name='$_' value='".h($Y)."'".($xb?" checked":"").($Rf?" aria-labelledby='$Rf'":"").">".($xh?script("qsl('input').onclick = function () { $xh };",""):"");return($Qf!=""||$Cb?"<label".($Cb?" class='$Cb'":"").">$J".h($Qf)."</label>":$J);}function
optionlist($B,$Fj=null,$dm=false){$J="";foreach($B
as$If=>$W){$Dh=[$If=>$W];if(is_array($W)){$J
.='<optgroup label="'.h($If).'">';$Dh=$W;}foreach($Dh
as$v=>$X)$J
.='<option'.($dm||is_string($v)?' value="'.h($v).'"':'').($Fj!==null&&($dm||is_string($v)?(string)$v:$X)===$Fj?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($_,$B,$Y="",$wh="",$Rf="",$dm=false){return"<select name='".h($_)."'".($Rf?" aria-labelledby='$Rf'":"").">".optionlist($B,$Y,$dm)."</select>".($wh?script("qsl('select').onchange = function () { $wh };",""):"");}function
html_radios($_,$B,$Y=""){$I="<span class='labels'>";foreach($B
as$v=>$X)$I
.="<label><input type='radio' name='".h($_)."' value='".h($v)."'".($v==$Y?" checked":"").">".h($X)."</label>";$I
.="</span>";return$I;}function
confirm($Eg="",$Hj="qsl('input')"){return
script("$Hj.onclick = () => confirm('".($Eg?js_escape($Eg):lang(102))."');","");}function
print_fieldset_start($r,$ag,$bf,$rm=false,$kk=false){echo"<fieldset id='fieldset-$r' class='closable ".(!$rm?" closed":"")."'>","<legend><a href='#'>$ag</a></legend>",icon($bf,"fieldset-icon jsonly"),"<div class='fieldset-content".($kk?" sortable":"")."'>";}function
print_fieldset_end($r,$kk=false){echo"</div>",script("initFieldset('$r');","");if($kk)echo
script("initSortable('#fieldset-$r .fieldset-content');","");echo"</fieldset>\n";}function
bold($fb,$Cb=""){return($fb?" class='$Cb active'":($Cb?" class='$Cb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($C,$sc){return"<li>".($C==$sc?"<strong>".($C+1)."</strong>":'<a href="'.h(remove_from_uri("page").($C?"&page=$C".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($C+1)."</a>")."</li>";}function
print_hidden_fields(array$Gi,array$gf=[],$zi=""){$I=false;foreach($Gi
as$v=>$X){if(!in_array($v,$gf)){if(is_array($X))print_hidden_fields($X,[],$v);else{$I=true;echo
input_hidden($zi?$zi."[$v]":$v,$X);}}}return$I;}function
hidden_fields_get(){if(sid())echo
input_hidden(session_name(),session_id());if(SERVER!==null)echo
input_hidden(DRIVER,SERVER);echo
input_hidden("username",$_GET["username"]);}function
enum_input($Pa,array$l,$Y,$ld=null,$wb=false){preg_match_all("~'((?:[^']|'')*)'~",$l["length"],$z);$jm=$z[1];$ol=Admin::get()->getSettings()->getEnumAsSelectThreshold();$M=!$wb&&$ol!==null&&count($jm)>$ol;$U=$wb?"checkbox":"radio";$ua=$M?"selected":"checked";$I=$M?"<select $Pa>":"<span class='labels'>";if($M&&$l["null"]&&$ld!==""){$xb=$Y===null?$ua:"";$I
.="<option value='__adminneo_empty__' disabled $xb></option>";}if($ld!==null){$xb=(is_array($Y)?in_array($ld,$Y):$Y===$ld)?$ua:"";if($M)$I
.="<option value='$ld' $xb>".lang(103)."</option>";else$I
.="<label><input type='$U' $Pa value='$ld' $xb><i>".lang(103)."</i></label>";}foreach($jm
as$X){if($ld===""&&$X==="")continue;$X=stripcslashes(str_replace("''","'",$X));$xb=is_array($Y)?in_array($X,$Y):$Y===$X;$xb=$xb?$ua:"";$pe=$X===""?("<i>".lang(103)."</i>"):h(Admin::get()->formatFieldValue($X,$l));if($M)$I
.="<option value='".h($X)."' $xb>$pe</option>";else$I
.=" <label><input type='$U' $Pa value='".h($X)."' $xb>$pe</label>";}$I
.=$M?"</select>":"</span>";return$I;}function
input($l,$Y,$ve,$Va=false){$_=h(bracket_escape($l["field"]));$Ol=Driver::get()->getTypes();$Hf=isset($l["type"])&&Admin::get()->detectJson($l["type"],$Y,true);$fj=(DIALECT=="mssql"&&$l["auto_increment"]);if($fj&&!$_POST["save"])$ve=null;if(in_array($l["type"],Driver::get()->getUserTypes())){$td=type_values($Ol[$l["type"]]);if($td){$l["type"]="enum";$l["length"]=$td;}}$Qc=stripos($l["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$Pa=" name='fields[$_]' $Qc".($Va?" autofocus":"");$we=(isset($_GET["select"])||$fj?["orig"=>lang(104)]:[])+Admin::get()->getFieldFunctions($l);$Ne=(in_array($ve,$we)||isset($we[$ve]));echo"<td class='function'>",Driver::get()->getUnconvertFunction($l)." ";if(count($we)>1){$Fj=$ve===null||$Ne?$ve:"";echo"<select name='function[$_]' $Qc>".optionlist($we,$Fj)."</select>",help_script_command("value.replace(/^SQL\$/, '')",true),script("qsl('select').onchange = functionChange;","");}else
echo
h(reset($we));echo"</td><td>";$qf=Admin::get()->getFieldInput(isset($_GET["edit"])?$_GET["edit"]:null,$l,$Pa,$Y,$ve);if($qf!="")echo$qf;elseif(preg_match('~bool~',$l["type"]))echo"<input type='hidden'$Pa value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Pa value='1'>";elseif($l["type"]=="enum")echo
enum_input($Pa,$l,$Y);elseif($l["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$l["length"],$z);echo"<span class='labels'>";foreach($z[1]as$X){$X=stripcslashes(str_replace("''","'",$X));$xb=$Y!==null&&in_array($X,explode(",",$Y),true);$xb=$xb?"checked":"";$pe=$X===""?("<i>".lang(103)."</i>"):h(Admin::get()->formatFieldValue($X,$l));echo" <label><input type='checkbox' name='fields[$_][]' value='".h($X)."' $xb>$pe</label>";}echo"</span>";}elseif(preg_match('~blob|bytea|raw|file~',$l["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$_'>";elseif($Hf)echo"<textarea$Pa cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($il=preg_match('~text|lob|memo~i',$l["type"]))||preg_match("~\n~",$Y)){if($il&&DIALECT!="sqlite")$Pa
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$Pa
.=" cols='30' rows='$L'";}echo"<textarea$Pa>".h($Y).'</textarea>';}else{$Ag=!preg_match('~int~',$l["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$l["length"],$y)?((preg_match("~binary~",$l["type"])?2:1)*$y[1]+($y[3]?1:0)+($y[2]&&!$l["unsigned"]?1:0)):($Ol&&$Ol[$l["type"]]?$Ol[$l["type"]]+($l["unsigned"]?0:1):0);if(DIALECT=='sql'&&Connection::get()->isMinVersion("5.6")&&preg_match('~time~',$l["type"]))$Ag+=7;echo"<input class='input'".((!$Ne||$ve==="")&&preg_match('~(?<!o)int(?!er)~',$l["type"])&&!preg_match('~\[\]~',$l["full_type"])?" type='number'":"").($ve!="now"?" value='".h($Y)."'":" data-last-value='".h($Y)."'").($Ag?" data-maxlength='$Ag'":"").(preg_match('~char|binary~',$l["type"])&&$Ag>20?" size='44'":"")."$Pa>";}$Se=Admin::get()->getFieldInputHint($_GET["edit"],$l,$Y);if($Se!="")echo" <span class='input-hint'>$Se</span>";$ce=0;foreach($we
as$v=>$X){if($v===""||!$X)break;$ce++;}if(count($we)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $ce);");}function
process_input($l){if(stripos($l["default"],"GENERATED ALWAYS AS ")===0)return
null;$s=bracket_escape($l["field"]);$ve=isset($_POST["function"][$s])?$_POST["function"][$s]:"";$Y=isset($_POST["fields"][$s])?$_POST["fields"][$s]:"";if($l["auto_increment"]&&$Y=="")return
null;if($ve=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$l["on_update"])?idf_escape($l["field"]):false);if($ve=="NULL")return"NULL";if($l["type"]=="set")$Y=implode(",",(array)$Y);if($ve=="json"){$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$l["type"])&&ini_bool("file_uploads")){$n=get_file("fields-$s");if(!is_string($n))return
false;return
Driver::get()->quoteBinary($n);}return
Admin::get()->processFieldInput($l,$Y,$ve);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$kj=$vd=[];foreach(table_status("",true)as$R=>$S){$Uk=Admin::get()->getTableName($S);if(!isset($S["Engine"])||$Uk==""||($_POST["tables"]&&!in_array($R,$_POST["tables"])))continue;$I=Connection::get()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",Admin::get()->processSelectionSearch(fields($R),[])),1));if($I&&!$I->fetchRow())continue;$x=h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]));if($I)$kj[]="<li><a href='$x'>".icon("search")."$Uk</a></li>";else$vd[]="<div class='error'><a href='$x'>$Uk</a>: ".error()."</div>";}if($kj)echo"<ul class='links'>\n",implode("\n",$kj),"</ul>\n";if($vd)echo
implode("\n",$vd),"\n";if(!$kj&&!$vd)echo"<p class='message'>".lang(75)."</p>\n";}function
help_script($il,$dk=false){return
script("initHelpFor(qsl('select, input'), '".h($il)."', $dk);","");}function
help_script_command($Ob,$dk=false){return
script("initHelpFor(qsl('select, input'), (value) => { return $Ob; }, $dk);","");}function
edit_form($R,$m,$K,$Wl){$Uk=Admin::get()->getTableName(table_status1($R,true));$sl=$Wl?lang(37):lang(105);page_header("$sl: $Uk",["select"=>[$R,$Uk],$sl]);if($K===false){echo"<p class='error'>".lang(85)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$m)echo"<p class='error'>".lang(106)."\n";else{echo"<table class='box'>".script("qsl('table').onkeydown = onEditingKeydown;");$Va=!$_POST;foreach($m
as$_=>$l){echo"<tr><th>".Admin::get()->getFieldName($l);$v=bracket_escape($_);$j=isset($_GET["set"][$v])?$_GET["set"][$v]:null;if($j===null){$j=$l["default"];if($l["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$j,$bj))$j=$bj[1];if(DIALECT=="sql"&&preg_match('~binary~',$l["type"]))$j=bin2hex($j);}$Y=($K!==null?($K[$_]!=""&&DIALECT=="sql"&&preg_match("~enum|set~",$l["type"])&&is_array($K[$_])?implode(",",$K[$_]):(is_bool($K[$_])?+$K[$_]:$K[$_])):(!$Wl&&$l["auto_increment"]?"":(isset($_GET["select"])?false:$j)));if(!$_POST["save"]&&is_string($Y))$Y=Admin::get()->formatFieldValue($Y,$l);$ve=($_POST["save"]?isset($_POST["function"][$_])?$_POST["function"][$_]:"":($Wl&&preg_match('~^CURRENT_TIMESTAMP~i',$l["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Wl&&$Y==$l["default"]&&preg_match('~^[\w.]+\(~',$Y))$ve="SQL";if(preg_match("~time~",$l["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$ve="now";}if($l["type"]=="uuid"&&$Y=="uuid()"){$Y="";$ve="uuid";}if($Va!==false)$Va=($l["auto_increment"]||$ve=="now"||$ve=="uuid"?null:true);input($l,$Y,$ve,$Va);if($Va)$Va=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input class='input' name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",Admin::get()->getFieldFunctions(["null"=>isset($_GET["select"])]))."<td><input class='input' name='field_vals[]'>"."\n";echo"</table>\n",script("initToggles(gid('form'));");}echo"<p>";if($m){echo"<input type='submit' class='button default' value='".lang(107)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' class='button' name='insert' value='".($Wl?lang(108):lang(109))."' title='Ctrl+Shift+Enter'>\n",($Wl?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(110)."…', this); };"):"");}echo($Wl?"<input type='submit' class='button' name='delete' value='".lang(111)."'>".confirm()."\n":"");if(isset($_GET["select"]))print_hidden_fields(["check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]]);echo
input_hidden("referer",isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),input_hidden("save","1"),input_token(),"</form>\n";}if(isset($_GET["file"]))load_compiled_file($_GET["file"]);function
load_compiled_file($o){if($o==""){http_response_code(404);exit;}if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){http_response_code(304);exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");switch(pathinfo($o,PATHINFO_EXTENSION)){case"css":header("Content-Type: text/css; charset=utf-8");break;case"js":header("Content-Type: text/javascript; charset=utf-8");break;case"ico":header("Content-Type: image/x-icon");break;case"png":header("Content-Type: image/png");break;case"svg":header("Content-Type: image/svg+xml");break;}switch($o){case'favicon-blue-aca42af56791f1e5699f22fa8e5b7e29__59f1e890.ico':$g='AAAAYCABAIIBAoMoAJAAtAAAiSgTiODQUGgVDgaSSQRClDoNABACANDjmej09IABDOSSIQSoWCOxSuTTYVCqFB8528NzaRRUiW0lmkhU2glwMWMEG4dHU0FM1UcbWO+AGLBIMVithI6mEzCebREEQS0WcMAaCyGYiC40MBVIMR0Th2CHoZ1YZSGGjGXFQUC4uDQsSoEligBk828vU8O3Gm2cDHezWY61Mt0ySXO3Xm826c18c3ceQQG14cEG/SGRQApEorDG8G4bg60meCwCuwAWF6AFQJ3aumYARIrBggA2AHEBjGMFegXW22ScGuZSAJFi0lWJEA11+mFS+Xa1x2QyklzegwgDwGeTC6gWBH6lS8BHIpgo/GIU3a7FGT14bw9jsaRbAAHRDmcd5+BuOoXhcIAbG2FIzlCIATEYKQElSD51DCbwxEYFp4DUVoznMNBrgqFYdwIbhAmwTBKHgJRcggLR3A2ehKHOUZAFiXIxl8XpHAAWgCDGAxOkQFIdmUTxcmYKYrgUFgRmeIAIEAPgkByOp9gQfAxgoABFjKCJzCUYBmEafAWD6bIBDQPobj8CpMGwTwRi2WIxkKZwnE2exIHsZgBmgX4rl+D54h6dwUAKTxgBuAZdEoT5XBSCo8loABIBGMZTCsWRKlEKQwBADxeAodoOjqAggASW4ChOfQ6GgUYpGACwym4XR6HYQIQkGLYuHOfxyHidxnnaaQqFsCJag6RobkSX5sk2IRFA8EJiGmUp0DQIxACUd4DkMERnA8MRTlMb53iyFhigiLYAE8YJEnuSRwguQx5kqCoMHwBY7FOEo1kgBAGkQWQgnaJZEmWTBBDKK5KiwUxJFyHg+l4aA0iWNA+DgFxpA6OxKEECxVAEAgWlkeoMneUJYl6Mg/A6dZOkIVh/DiFQ4iIQQPDkLgCgUIBrBOLYiGINB2nMA5nhIBx3nyUYJA4bxhhmLY3m6XxZg+UoGAgOZNEoZwdACCgJCYSoJniPYLECfoXBqfpTEiQwfiqS5xBqeAUAUdoIhSYgxmIforGkbQogYagYgAW4fjsYplCgUJwmUfRxF0fRAB2GgIkoQwPFSEhyHyGQ1l6MB2lSUwwhgDJ3EaHQRDCP5/n4UwvlsFhGlESBXm6L5/kkDQGAsbxCBydZCiiIJDFOT40G8Gw4DkMBri6I4ACYMIbhqEYKH0CIBGiVBPBCcpCmUEZdiYRQkDkLQaD2aBJnWRh5iGZJEB9AmMobAswFixBOnYS4PBzA9E2K1soiBDDGC2FMAw7gLhCB8EsO4RAJgdF+LYIAlxggqC6HsRYwBpDfGqdITIixhjdCINYFgqg+BbGKP4dgLxRhgB4K0GI/hpB0GwBsW4Ah8jqESJkZo1wrjuDcFMPYjQ6ibEsMYbw2g5jbCUK4NoMBoijHWOkV4Zgjh8E0KM+43wDjSFIHQWQthlD1HCLkR4vQVhOAQNkGolBUBbCaKUH4IBOh+H0LgDglwwirB+KYaYABlAzCSOIWAihkC+HMAwZwPxAD8EEB0DA5R6AfDSHQDQOgeAnCiLwNAphEj4DADgRwgBtgfE+JQMAtALjQGICQToygbhNGCEwYAshFAKCaDwOgJwwA9AQFkZACwZhkBcJgTgGx7B1BwEoQIJwaD+EMG4DAnwKjSG6EkCQ1gyA1GcPsdgqhgiWEIP0UY8xXCfAuJYJwUwEjkEMEkVYJhJgrCKNML40Q8BAFbOwZy0QDioAeCgHw3RbhKGcAMVQ/AeCBHiFETQTh9iyCKG8ZwlRyjeAULISQghhipGyHAd4QTgBsAqMoBwJAFByD2CgawQQZhAEAAYSQThVg6BcB4LwaQQC5HAEICInRFD4BcJYJYWjVBMBGO1FwkwUjOC+AYLobBThTBqAsQgzAlgLEmHARo3hPCuCCDULYqAZCMBeKcUQvhPjKByDYe4HQAioGoKgCYuQGgHHgB8Hg1RVgwEYNkMoZiHAACSEUJwRBXBCDAII=';break;case'favicon-green-9d01f379ad1677541348f943c2ba7633__59f1e890.ico':$g='AAAAYCABAIIBAoMdwJAAtAAAiSgTiODQUGgVDgaSSQRClDoNABACANDjmej09IABB8SSIQSoWCOxSuTSYXCqFH87k6GT8CgIoykVAk3Vo1kqCxqLDq0SguxCMWqKAW3RQWk0GjGIhgsBAthoqRgPAaG2m0isu3SomqNBrT0UbHYkioFxcTAINi6UB2YGmaiCwDyc1e3z6P2Ge3g3k2eSaSHe5GCvDuzx25x233yuTOBA88gkD2yPjUA1AIXiRTGJ3Y9WG0DwiVA9wUySWoSa8SMSlYKEKZQQsRYoTeqBYfmAfWY4QIzDs4iUBjgEQaKDEmHMP1IqiOExqSXcGjmGS8ZXO5icFnw0mc4xo3W4jD2Nw8gEK5zAY00An2jCgxQqb4oCKUZsnqEhmE8LIgl+GY5FCLxUncZoeH8RABAiB4wA4b4pHeDZXFkDorFuOgMgaHRQB0JQqCka4QG8JgDjABgymueQ7AWIIamiawVAoTA2gGJx4hmdgCDOY5FDOMAWHIK4ZAWRwtFGb4sBmDJVlCQRcAaSBgnQQhHgOKBgB4L5tg+T5jjCMwRDyOQEEkWhWHMeoIAcUgxFAfwKEcNxzDgaxCCAaBRiUTABksbgOlmbhfi2AJsgiTQfAYMIVAqAAjmwZR6GEawLB6NBWk8M4vHIYYqH4JpGE+EBHleURGE2M4qg2KJxgyOhWH+SY+g+WBdhSfpBA+CQkj+Jo3GKVgviSZQaA8YI8g4YYpE4KAZAARZSHqMYWHoGRgjADpOhQUJOnsbYygydonBOZhQGQJwsCIVxXEQYxmA4RxWkORpHEmQYeGMaZCjAJg0DIOoAieMZCAqfgvkkC5Yj2b5Rg8X4xkoBo2kgdwiFkTosEMLx9BaWJhBYKQ9EyNQ3GuAhSEAE40FcQ4XHoNYimsRhKn4AYAAQDQJjcOpnnmb46mQdgmmwewOh8fAFjrXYpHyOIyHiDApnE8QXnmXozn6fBNHIOo1BEGoBgsPZbl6UokAQSxOAcSgxgICoKDCIopEcVw3jWMZ5gYIJdB8QBnhgIBpAUAxfDIUxCnmHooDWHhFmCBgGBeW4HlwM4JkWDA9EAABWDoJIcHqcQPG4fpCmaIZeHaWwri+UpJnuYwqneeRqGMDoMg0S48EgD5ynOb46AAPg0gWXpWECKJtD4WRLAICgyCIXZGH4RImDcAgBlKbATEobgDh8Y4tnYMIrg4UZDAAZYklcDxPEiV54FcIY1C0BgCUUA/QZhIHCSsLA4h+jPEo90GoJhVg/AiAUOobR5giFSAwJYLBfgjGYIQdISBni/CCDMSwWxPACDOC8Qw+QLCODGDUKQbgBDdDoOADQS1DnqEqHwDgSx7A8EKHMbA0w+ASA+K0Vw1AJCCEUMwa4aAxjXHwFQMw5QDhKFSFwdQRgSALFgJUSQGQTiHBKN0Cg+BHBfD+KQbQGReCLDQDAYw6AlDdBCEgfYVRQjVDWGwIQLQvAhEoNkRAUgZBQAgLMKA+hQQSAKJMLgSBgh4EWGUDQKRNCxESHkaIjhWDYGWAYaAwgGB0CUG8LYIxMAlAGF0dIQgYCRD2A8co0hCjgGSO4TggBODFE6AoRiuxQAJEEPADYUhDCVBoBAPoJBjjnGABQOQuBjgaGsIEMI0ghhTByIofI4xgD1BwCYXYGAdh2FiCsNAxQdjsfIHQBgGAJBZD8GIQQkxGCiAON4RQHQohDBiPIEQIA4BeAeKIR4LQdB2DgKgHQkAcB2BOOsXYsBYjZGeG8Q4whwiNEKDMYYlBZg4CePwKgrQ5GjHAGkNImhiDzDWBsPAnRlD3HmKAGQPwsD2DyKMbQIhPgtHkNkIQUwBr2D6Iwb4qgMgOBkFoVY7BXDIFKGIMANwID8AeGQEQXgYCHHWKIURDgABJCKE5eoQgwCCA=';break;case'favicon-red-6fc13ee62dc8da41da8e28c58d688139__59f1e890.ico':$g='AAAAYCABAIIBAoMWQJAAtAAAiSgTiODQUGgVDgaSSQRClDoNABACANDjmej09IABBASSIQSoWCOxSuS0QFCOGH8qjMVlGiVYxFYj3YIVg2zGDEQgiiDyE1g6disE2QghIog8DAIXA+BzePkkHBIxEGqDwDXwSDcHkoRQk8FE7mI0QqPAwIxQgnY7hw4jCo1WLlk+GEnXcKl+mnSnnSmcSmXsshqNG60yq9X+33++H8+i2YE0h0wZn6aAUgGsWi8SUQ1VsxGusFiklA5yWXgUaAGJD+6lSBk8mAWcW4jBWXHQHmKDRCwBK9SOXQADz8xAOD1c4wuxwsuxC9GOoEM4CCCH4ESoaQQiQSKXieyk4UgyHEbWwzigAEyxSwYhWnFOLhVlgbJsCkaQwA8fhjAyGIqnQXgrgEUY7A4PpvgYMYcAQIgUEAP4dBgIAKg2FYbAyTpYi0LpGm4JgngYegyFiFIJEAYIHBwMpNgGFh6CSVY4CcGANGqTYViAV4MlCDwQEAcBEF2bQGF0NREjKEBakABIQCgK48AQHQYlEWgkHwMZtkIUpAnsBZkEiKgnD6DxkgGdICDsFQDmORYEC6RYFBuJJrlQcx8HWNQKBidglEacQiBIAAzBiTJoDebYcGMY5rCMRILBkH4kh0dwkjKeIzmwfxDEKdB9DkWhfj0QZ2ikUAnnKcpFDEJA1GmYZCT0PguHESxJBwf4QjgNRmgQYx1ECV5LkIH4ZjiBx9huDYYCmN5YC0bYsGAe4FjYLwzB8BxGHmGwXHEDBPhiBYbmsbhXCoPRWgGH4+kqYZIiQEJcCICxiAKRwTCucBAAwYBqH2QggC2TBMmiHB0DQdhHmYARHkMFgRDGKQYgecxwiYeQvh4NwDCQMwKgsMQBC2DBDF6JRQm6dg8jeAA/EKRhrgQSY1CQBIeDYOIYHCJAeBmeYqHkBJFmEHhUniTIrHQMWOFcAwNAyIBdAGYZKkEXgKBWTwBlKTQoD0eAOiQbwdnuNxAFOORECsA4DAmbBjjEPhaEobZQiqRBxAKUJ9AUO5anqMhoF8Tx9gKHRrkYKALG4fgJFmE5PnGAh6jcVpvDKJBsEgX53BMfR1joNYHB2bIiF4RwCGALZ2AsUZBn4X5UDiAQrE4AJHkwF4DnUCoQhGF5eA+dBiHMcg+k4GpFloQwmD+QJXCwDwtiQVJajIIwdgmN5HA+CBun4IQ0kYYoCFcXw1GCTI3neMJkHWRAZA+CyNUIwhAPhGAsPIHg7RfDrGcLIFICQMCZDcHwCgfxGBPGaJQXoEB/gnFeOAMo0BdCLAsPoJA4xfjIAENYVYCAchgHUAAFozQFiFEmCwVovw6qkFoHEBAygVscFWM0KwuQvi1CoDsdArRLDIBoo8Kw2hxCRCeCAF4mBGB/GmIQRYfA4gpAYMwSAhQbCSDCB0G4rgzjyDaCgQgqRMCxCcGQB4XB3BEE0PEdwKROgwB8PMBoIB/B9GEGsbgTQdhzBMMwF45QigFDKAUIo6AaDrCAG8UgEBSAtDYGMKo+xRjYESPoFYiwVjGD2OUewCBKhNDUKUFQshQg/EYA0eo6ggDLHmEkTgph3DADMDIHAnQ1CPDSCoH4OxbgVB+KwfgDx8hIA8PAdAdwcjBDEKQaAXxsBMC8BkJwBgGgyEqK4Fwtx1CFGgEsTgYgTi0FWN4A4SgpgFEaDUUAVxfDFC8EcMAXRcgXFSP4GwKBhgyESTocQWB1AeAMBsGIpwUgAE8JAegUgWCTCmPgbwcRIAgAgIsGw8xRhFA2EwLILRICNGKDAnQ4AuDqBcO4GgUh2DNCOAIaArBoAoHWKYDowAdjeBYGIGAAgfjPEiQ4AASQihOCIK4IQYBBAA==';break;case'favicon-blue-8d5d37563b5244e03e11135cc7939f80__59f1e890.svg':$g='PDmdjOIDwbTYbjmPREaDodDgOheLzvExcdxmLjecjOLxkMI8L4CZxEIDsaTKdyEbzxChgIJaMxkIJgIh8ChBNxBADoeTYZZrOKAICAbTKZDSYRAKDgcjKZjKcjmLTGbzZGRaczGaDLRB0IDIYTkaxSID3NqDZxcZzYeTgaLIIDMaTYbK6IxyOTEOTKNh2ID7ZrPf6APJBO57P5wPDgYTpbjGbDCc4SIrVbDRIzJCjaMhqLhsMByII6LhqMRwYxaMRdHRrohcMRuLc6MNbFxuNdiOc9oJkLtvsRppBqOJcLRwLhoMBpqdIONzuxwLdtuBbqxqNuqNBqOeqMxyMuqMhjyxd3hkLhh4ztF9MNTHL/QONbwRoNxuIBtqxwMxAMZa/IZP2Ob/Ok14cuJAkAP2O0Cva97wwC6oYhm7DkBuGbuhyGLqvSGg9Da9AYuw48JtO5j2v6F0NO42YaBs3qYBqFrdBszkYM4qLjho5bVOS7EaM5AsYtQ1cdwzGTytvCToyTJCPBi9bfBo06WvOHDlBA+j7BA2Ybxe/0uPRL0BhgFrzhkG6YwJLobQY20pwe14bu414Zw28ocvIGbbvQ9MPxmz0gv88sTM6GoZP5MswNU50ZTA4LTBwOzzo8Gj3tc7T+S0+76BpNSW06GUyOZA7QwJUMGUo5UHvPO0MU2FtIBw6NTtfWY9BEwCzrguQ2IUEYZjHC4xBika4rmFo5DqnqFDcN43D0p43hEF6asIkKag';break;case'favicon-green-24369d344ab89ca286ec343b8fc15da0__59f1e890.svg':$g='PDmdjOIDwbTYbjmPREaDodDgOheLzvExcdxmLjecjOLxkMI8L4CZxEIDsaTKdyEbzxChgIJaMxkIJgIh8ChBNxBADoeTYZZrOKAICAbTKZDSYRAKDgcjKZjKcjmLTGbzZGRaczGaDLRB0IDIYTkaxSID3NqDZxcZzYeTgaLIIDMaTYbK6IzCOTINruOxAfbNZ79QB5IJ3PZ/OB4cDCdLcYzYYTnCRFarYaJGZIUbRkNRcNhgORBHRcNRiODGLRiLo6NdCLhiNxbnBhrIuNxrsBznc/MhdttgNNGNRxLhaOBcNBgNNRoxxuN0OBbtduLdUNRt1BoNRz1BmORl1BkMeULu6MhcMPEdovpRqY5f5xxrOANBuNxANtUOBmIBjLfwGT9Dm/rotcHLhwG/79DtAj2Pc8EAOoGIZuu44bhm7gchi6j0BoPQ2vOGLruNCTTOW9j+BdDLttkGgbN4mAaha3IbM3F7Nqi4waOU1LkOvGbNwJGDTtVHUMRi8jbQi6EkSOjwYvU3oaNMlrzBw5IQPm+oQNkG8XP7Lbzy7AQYBa8wZBumMBy4G0FtrKUHNcG7ttcGcNPIHLxhm2zzvRD0ZM7ID+vJErOBqGT9zJL7UubGMvuA0ocDs8yPBo9zWuy/csvs+YaTSltOBlMblwM0EB1BBdJuTBzzTrC9NBbR4cOhUzXVkPQRL+s64LkNiFBGGErJGuK5haOQ6p6hQ3DeNw9KeN4RBemrBpCmoA==';break;case'favicon-red-a6cbda011ea4968eaf8da0e2b8313082__59f1e890.svg':$g='PDmdjOIDwbTYbjmPREaDodDgOheLzvExcdxmLjecjOLxkMI8L4CZxEIDsaTKdyEbzxChgIJaMxkIJgIh8ChBNxBADoeTYZZrOKAICAbTKZDSYRAKDgcjKZjKcjmLTGbzZGRaczGaDLRB0IDIYTkaxSID3NqDZxcZzYeTgaLIIDMaTYbK6IzKOByMRuZB2ID7ZrPf6APJBO57P5wPDgYTpbjGbDCc4SIrVbDRIzJCjaMhqLhsMByII6LhqMRwYxaMRdHRrohdehbnRhrYuNxqNxaOc9oJkLttuBppBqOJcLRwLhoMBpqdIONxus+OBbtduLdWNRt1hoNRz1hmORl1hkMeWLu+MhcMPIdovphqY5f6RxreCNBuNxANtWOBmIBilr9Bk/g5v+6bXhy4kCwC/g7QM9z4PFATrBiGbsuQG4Zu8vLrPUGg9Da9IYuy48KNO5j3P8Fy8u62QaBs3qYBq3LPM5GDOKi44aOW1Tkuy6DOQNGLUNXHUNRk8zbQm6UkSOjwYvY3waNOlr0Bw5QQPq+4QNkG8Xv/Lb0y7AgYBa9AZBumMCy4G0GtrKUINeG7uteGYYw08oZts9L1Q/GYbSA/7zRMzoahk/syS+1TnRlL7gtMHA7PQjwaPg1ztv7LL8PqGk0pbTYZTG5kENDAtPwbSTlQg9E6wzTIW0cHDpVK19Yj0ETALOuC5DYhQRjEjqRriuYWjkOqeoUNw3jcPSnjeEQXpqwiQpqA';break;case'apple-touch-icon-blue-b284772ce058bb3862fe232d7922f3e7__59f1e890.png':$g='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';break;case'apple-touch-icon-green-c4ba0ad59ea8ecc2e5fdb53695c28e5a__59f1e890.png':$g='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';break;case'apple-touch-icon-red-4f51a03407fbf4f1e8a8001a0a228048__59f1e890.png':$g='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';break;case'logo-d7973a9247fee3bb067889cb0a939951__59f1e890.svg':$g='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';break;case'jush-88b9d6cd6243fee3ac011c7c6d4bf617__87a07c36.css':$g='LjUdTmaD2LRadDKeDoLTGbzYbzkOhGMIoO4MYjPDIdEIkZo9FhacDQcI1D4jExgM5AczocjSbozDZMOjOcjKZTdK5bL4ycDYYZfJY5KByRorBjWZTyd4gZKFETcYTseZAaTJODoaTMaTKcqeOpsZJAdjCbDqZa+cDqcp8ZZAbjqbTFXa/KBuRrvIDCdJ2YjrCK/CLLIDUcxbGLqZhhio/BjGc8NiJlQ49HjKMJBIpJko3J8ri8xBs0LTmcTZh5jnY6ZjFrcwfYBAoJk4jZDkKINCIVTxSO9hAYGLTQdDaX4abRZseDx+TwDRGuLDavzdkLTebjL1ODmi+ZDeY+1z+5zOV4pGX+v2fKLcL6Ox4fYc+73z3tJocjDVN/1c18O47A7v884zDqNz6tU2zcJCkbeB2MQwjGNaajfAqnPtBLRQYziTN6/btvOOI6jfAQ4C+Mo3jo+D2weMcDpnDDSJ2mEGw880SjCOERvXEMdOcFsePc9UfRxHrqtKNgvyI+EjjShEkxzJbTC/HkoyRE46RcjkYJYl0Zp8oA3Ro9buSA20SC/Mz1yPNAwjlFT5RYED1sKPYzOuhaWDyNgyh1JqyjSMbfTG88iTlH0yRFNk3UHG8c0M/jzttOs7xjPU+DciA2sHGsFxKNCyjoGQ9xZCQ5QoN0LQRNsFQ2iDewvVbcoShbaQ69Y6DCM7jMg+C9jpXY50e4NfSnEVer5YFhOfYklPXYjH2DZ1kLINkstrWKD1nBtSQnCqvxhaDUTFH1cV0wtj1+wtlBbYkqWldNoyHZFm3leF12Jaj4WgL86Vg29ZN3WsHQhUtT1TF9sMLcWBU5cr4DwNskXLawdRgpKlqbcbq19h+IySvl0X4OeQ2hkLhjoOGKRhXyXL8wGGXfYsi2HecoZjamVWxaiz404KsZzf4W52tGYR89uLzeL+L3Xd2jPlpdnRzoEFaHnrnvamwz6mpClKYOWD1dQVDvPI910RmcbC/stGSftFO7U00mjLs0QWNtkmIRulG7c7g4DPtexxLptIRLv3AcJtszjayDTb1mXFcYNnHXpxCIQhPfHcHD8S8sMfMbZIlR4JbtUW/bDRyPhbO1tH0WTP1z1jE/D4cXNfZDDKu5ZlrYWqsrCtK4r2iuquDkPXzw5d54q5+F1exNkEAw95i+vbAOXWegML1jQMo2ZSMa1jmjnue957g7L3E1Sk6W5/TH28fa/2/8b9zq9r+j4c7zH6/ONI2ltDIGJ6Kkw3ELDuGUNIZzhg6DEQ4sSnDuOHc2zJ6KZ4JNpUK9JO0BQWwHgTAtTAclNBsfMc9csFV3woSGo5/hz0eQqcRBlM8L4WtvSuDKAZ9iXvcJcHQ3z2kfPgJYG8NoOg2EvDWCyIB1YhB0iIxUNIc25BkgJAaBECg6A6hDCMHcOg3Q8SbCUEDKVNByDOS8HRrzykFWywE1QIwZxxJAq0zxjQWvUYyfYiYM1AkGd9AV4BdI9A4BgDgsZZWeR6DIDE0KMUumpJmCORcjUuE8JCT8oMipGFvLi8wuoMAcyNZYGllzRI3kUkJIQwhkZIGUMWDaOy4Y6GrDMGEy5mUGR6IpI00cswRmVBmYqXBJHUy+MrLaNRznohbDQTYMwXQdBoDeHYrp4ZlzNDLM8HSECszUD2bohZVyGn4KydcHSFSuxHOwoJI6bQyxLIG9F7b3XvvhI5DsrsYQ+hhmZM4LrxyBRODa7yP5WStyCecH0=';break;case'jush-dark-ff7302bb2874a25b8a95a0f3da87e75d__59f1e890.css':$g='LjUdTmaD2LRadDKeDoLTGbzYbzkOhGY4oO4MYjPDIdEIkMY9FhaazKeTvEDJGofERGYTGZpAaTIZTcdDSZjSZTlKI4IzKNjLIDsYTYdTLOpUZhsNpAczocjSbozDZTEqRSoNTKdUBacDYYafRqpSZAbjqbTFOLAIxgYxhIDCdKaaTEdYRaRnFYMajmLYxaRgM6tDDne77Up2NBhiBhbYMcDQcLTFDHIMdkMLG5UNRljK3jxaczibL5UcxEsRirafQA==';break;case'jush-6930baf98aaca9134977e95fb01b2efa__ae054cac.js':$g='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';break;case'icons-b23ce0c785b91a784166ab29e9c8baf7__59f1e890.svg':$g='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';break;case'default-blue-95968c021a129362d14532ede2609b64__b5158906.css':$g='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';break;case'default-green-d6ec966ffd4b974a4bc07b84216606bf__b5158906.css':$g='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';break;case'default-red-bb3e8b5d982a1e47c0fd59b587f4f89b__b5158906.css':$g='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';break;case'default-blue-dark-a561e9f648953832ebcc709da6f3074e__1fb23772.css':$g='OjkbzedD2YzebDechaczGaDKbTKOjIYTkax2LRaYjeZDzGTOOhGMZFF4zG46dDKeDpIDHLZJGo4LTTBjdLJdGDdAzKLZRKpANqBJJzKJ5KZWcjOYjCKBkNRqLKbT6iLBoMBKKZJCDOb6LPhGOLBJDgYTcZTZHpAMrVYrJZpKcjIZTlIBpdZJDjDcYVPZWIzLf6yaTmdBaaDedrkOjQczZSxkMafVhYN8lkKvJDSbjgdcIYo/IZHGMzm8JfJBfzLmM1nLfep/QYwcjKcTqadkZNbiRGZBsM5Ic7MZTHhIpATuOjqcjYKBFEzoYR0aTaYTOZReczsZxWeDabB3SuANhoLCgSCcMi0eSENDEVzwdTGehgaTCSCkMDGRMOTBmZP6PIahmJsADsMY2jGOwmjUII7iaIYcj0MkDjSJIkC0OAtCwMghjEGYzhyJMFjPBwgjyJwhxLE4kjOLTujmMQiPmJIZCsNgtCmJIVvKIQ0DII4zxZGI0ioKgxjqJwiCKOYniGGgYieIo7jwJo0ylAYaDwJwYSkJw0ycJ4pjuGgmDUKoaCpJMxySO80CKPImSSGU0CyOYmioIQmicPKqibMMxzKGgrwoOwoDUO8ChmLQ3CgM4eh6ESsIwMTODoN43LQ0AYpfSlLBauIzDCOo2NKoyQJFTVJU5S9P1DUausIwzELnTKSOeMQ2J2z1TNCngw1una8L1TAZDDYliVrX1cNzWa6hpZFfha41lpAGdqpIgy4rQxblsep6qhKqCrUiFtsVyhLXW2pjIKoyQZhqy6MIgOY5uonY3jXbTGBQGIZBhcNwX7eAW3lejqhbe9p3Tfl/YCFgZhlgWCXrg98NNhV+hYp1wBzd9x4lgy5IChVdXTfwZsktWIjLeeJ5ChOE31k12hplWWZAOWRVexWY4zd4WY5gQ7ooNzMjPnV0hk8bKXAG1xJJWQ5jTTuLX1pLJslprLj6ICIDI+gQIY2QyjcECyDIEAUOmPFo5Wg7OakmoYjIOA4DwFI9oAgSCNE1bO3OuVoryNI6jmHQZbqHY+j7vKBj2jA2MzitS6RdessnjrAjdySVMKw7E8op4a6xzCMOBXDh7hfLG3Up4cMl0Wmadx7BOJ1DEZ31duhYGIYawyocYFyDBhaMPbWBzy522x119532AdIjNVI9ztZdx1mM5R2XojpStLo0uHP6ryrJBv6FJ+5Tvv2FWPw258dwfLgXz+7o/xKfy343H+epqN6n2vXfw+Z6SrFRGdI+6AFkAX5QDDKqCAr032PJfs9hpkAn0Krgaq1vz4IJPufu+SCz9ICKufU4CCL1ndOwgS5gPoA=';break;case'default-green-dark-871aa3f880fca82e71581a65b7d850f1__1fb23772.css':$g='OjkbzedD2YzebDechaczGaDKbTKOjIYTkax2LRaYjeZDzGTOOhGMZFF4zG46dDKeDpIDHLZJGo4LTTBjdLJdGDdAzKLZRKpANqBJJzKJ5KZWcjOYjCKBkNRqLKbT6iLBoMBKKZJCDOb6LPhGOLBJDgYTcZTZHpAMrVYrJZpKcjIZTlIBpdZJDjDcYVPZWIzLf6yaTmdBaaDedrkOjQczZSxkMafVhYN8lkKvJDSbjgdcIYo/IZHGMzm8JfJBfzLmM1nLfep/QYwcjKcTqadkZNbiRGZBsM5Ic7MZTHhIpATuOjqcjYKBFEzoYR0aTaYTOZReczsZxWeDabB3SuANhoLCgSCcMi0eSENDEVzwdTGehgaTCSCkMDGRMOTBmZP6PIahmJsADsMY2jGOwmjUII7iaIYcj0MkDjSJIkC0OAtCwMghjEGYzhyJMFjPBwgjyJwhxLE4kjOLTujmMQiPmJIZCsNgtCmJIVvKIQ0DII4zxZGI0ioKgxjqJwiCKOYniGGgYieIo7jwJo0ylAYaDwJwYSkJw0ycJ4pjuGgmDUKoaCpJMxySO80CKPImSSGU0CyOYmioIQmicPKqibMMxzKGgrwoOwoDUO8ChmLQ3CgM4eh6ESsIwMTODoN43LQ0AYpfSlLBauIzDCOo2NKoyQJFTVJU5S9P1DUausIwzELnTKSOeMQ2J2z1TNCngw1una8L1TAZDDYliVrX1cNzWa6hpZFfha41lpAGdqpIgy4rQxblsep6qhKqCrUiFtsVyhLXW2pjIKoyQZhqy6MIgOY5uonY3jXbTGBQGIZBhcNwX7eAW3lejqhbe9p3Tfl/YCFgZhlgWCXrg98NNhV+hYp1wBzd9x4lgy5IChVdXTfwZsktWIjLeeJ5ChOE31k12hplWWZAOWRVexWY4zd4WY5gQ7ooNzMjPnV0hk8bKXAG1xJJWQ5jTTuLX1pLJslprLj6ICIDI+gQIY2QyjcECyDIEAUOmPFo5Wg7OakmoYjIOA4DwFI9oAgSCNE1bO3OuVoryNI6jmHQZbqHY+j7vKBj2jA2MzitS4vk2fBvjrAjdySVMKw7E8ph2scwjDgVw4e4Xyxt94xb+M6xp3HsE4nTsRnfVYWFgYhgyQcMr2AW8gwYWjD2lgc8udtqX3Hdd4yvRozVSPc7WXbdXmVwMtcdJjpStLo0uHP313F3XBy+Be37tl+n8Ll/Hy3n/RqfJ/FjHyMn+Hor59fkfpyvyv4e4p1ViojOkfdA/Z8z2nowDVcZ5/b1XxuifPAsMqoICMwfa/V98E4Aqrgqq1vz4CFKxfY9Z0LTHMB9';break;case'default-red-dark-f51ef74ef11aa4d84cd4becf148a354c__1fb23772.css':$g='OjkbzedD2YzebDechaczGaDKbTKOjIYTkax2LRaYjeZDzGTOOhGMZFF4zG46dDKeDpIDHLZJGo4LTTBjdLJdGDdAzKLZRKpANqBJJzKJ5KZWcjOYjCKBkNRqLKbT6iLBoMBKKZJCDOb6LPhGOLBJDgYTcZTZHpAMrVYrJZpKcjIZTlIBpdZJDjDcYVPZWIzLf6yaTmdBaaDedrkOjQczZSxkMafVhYN8lkKvJDSbjgdcIYo/IZHGMzm8JfJBfzLmM1nLfep/QYwcjKcTqadkZNbiRGZBsM5Ic7MZTHhIpATuOjqcjYKBFEzoYR0aTaYTOZReczsZxWeDabB3SuANhoLCgSCcMi0eSENDEVzwdTGehgaTCSCkMDGRMOTBmZP6PIahmJsADsMY2jGOwmjUII7iaIYcj0MkDjSJIkC0OAtCwMghjEGYzhyJMFjPBwgjyJwhxLE4kjOLTujmMQiPmJIZCsNgtCmJIVvKIQ0DII4zxZGI0ioKgxjqJwiCKOYniGGgYieIo7jwJo0ylAYaDwJwYSkJw0ycJ4pjuGgmDUKoaCpJMxySO80CKPImSSGU0CyOYmioIQmicPKqibMMxzKGgrwoOwoDUO8ChmLQ3CgM4eh6ESsIwMTODoN43LQ0AYpfSlLBauIzDCOo2NKoyQJFTVJU5S9P1DUausIwzELnTKSOeMQ2J2z1TNCngw1una8L1TAZDDYliVrX1cNzWa6hpZFfha41lpAGdqpIgy4rQxblsep6qhKqCrUiFtsVyhLXW2pjIKoyQZhqy6MIgOY5uonY3jXbTGBQGIZBhcNwX7eAW3lejqhbe9p3Tfl/YCFgZhlgWCXrg98NNhV+hYp1wBzd9x4lgy5IChVdXTfwZsktWIjLeeJ5ChOE31k12hplWWZAOWRVexWY4zd4WY5gQ7ooNzMjPnV0hk8bKXAG1xJJWQ5jTTuLX1pLJslprLj6ICIDI+gQIY2QyjcECyDIEAUOmPFo5Wg7OakmoYjIOA4DwFI9oAgSCNE1bO3OuVoryNI6jmHQZbqHY+j7vKBj2jA2MzitS4UGOr3Bpdx8gN3JJUwrDsTymM6xpyMOBXDh7hfLG33yul9FpnSBbyDBhaMPUMRnfVpEFgYhh0dwMtzLBOJ29gc+udtqX3fe9/f9x0mOlK0uz3PVl3PWdf3mO036NOo0uHQX13fXcx7npWX6vwuX8bJfLVPu0vqn19b9vY+h86+fT5Hxfpy/7KqU8GVUCojOkfdC+R/78IAwDVc9RWL6nsA1aw9t9751WQEZg/NyzlnnwAgvA1v5CoHv7g1BJpj2w+g=';break;case'main-7e0bd6eae3f122e36f650e1b722b5ad5__1fb23772.js':$g='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';break;default:$g=null;break;}if(!$g){http_response_code(404);exit;}echo
lzw_decompress(base64_decode($g));exit;}if($_GET["script"]=="version"){$o=get_temp_dir()."/adminneo.version";@unlink($o);$n=open_file_with_lock($o);if($n)write_and_unlock_file($n,serialize(["version"=>$_POST["version"]]));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define("Adminneo\HTTPS",($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("neo_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes([&$_GET,&$_POST,&$_COOKIE],$Zd);@set_time_limit(0);@ini_set("precision",15);if(!isset($_COOKIE["neo_dump"])&&str_contains(isset($_COOKIE["neo_export"])?$_COOKIE["neo_export"]:"","db_style")){$_COOKIE["neo_dump"]=$_COOKIE["neo_export"];cookie("neo_dump",$_COOKIE["neo_dump"]);unset($_COOKIE["neo_export"]);cookie("neo_export","",-3600);}if(isset($_COOKIE["neo_import"])){$_COOKIE["neo_export"]=$_COOKIE["neo_import"];cookie("neo_export",$_COOKIE["neo_export"]);unset($_COOKIE["neo_import"]);cookie("neo_import","",-3600);}class
Locale{static$Languages=['en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lv'=>'Latviešu','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-BR'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-TW'=>'繁體中文',];private$language;private$translations;private
static$instance=null;static
function
create($Tf){if(self::$instance)die(__CLASS__." instance already exists.\n");return
self::$instance=new
static($Tf);}static
function
get(){if(!self::$instance)exit(__CLASS__." instance not found.\n");return
self::$instance;}protected
function
__construct($Tf){$this->language=$Tf;}function
getLanguage(){return$this->language;}function
setTranslations(array$Cl){$this->translations=$Cl;}function
getTranslations(){return$this->translations;}function
translate($v,$kh=null){$v=$this->convertTranslationKey($v);$Bl=isset($this->translations[$v])?$this->translations[$v]:$v;$Tf=$this->language;if(is_array($Bl)){$vi=($kh==1?0:($Tf=='cs'||$Tf=='sk'?($kh&&$kh<5?1:2):($Tf=='fr'?(!$kh?0:1):($Tf=='pl'?($kh%10>1&&$kh%10<5&&$kh/10%10!=1?1:2):($Tf=='sl'?($kh%100==1?0:($kh%100==2?1:($kh%100==3||$kh%100==4?2:3))):($Tf=='lt'?($kh%10==1&&$kh%100!=11?0:($kh%10>1&&$kh/10%10!=1?1:2)):($Tf=='lv'?($kh%10==1&&$kh%100!=11?0:($kh?1:2)):($Tf=='bs'||$Tf=='ru'||$Tf=='sr'||$Tf=='uk'?($kh%10==1&&$kh%100!=11?0:($kh%10>1&&$kh%10<5&&$kh/10%10!=1?1:2)):1))))))));$Bl=$Bl[$vi];}$Bl=str_replace("'",'’',$Bl);$La=func_get_args();array_shift($La);$ne=str_replace("%d","%s",$Bl);if($ne!=$Bl)$La[0]=format_number($kh);return
vsprintf($ne,$La);}function
convertTranslationKey($v){static$md=null;if(is_string($v)){if(!$md)$md=get_translations("en");if(($t=array_search($v,$md))!==false)$v=$t;elseif(($t=get_plural_translation_id($v))!==null)$v=$t;}return$v;}}function
get_available_languages(){return
array('ar'=>true,'bg'=>true,'bn'=>true,'bs'=>true,'ca'=>true,'cs'=>true,'da'=>true,'de'=>true,'el'=>true,'en'=>true,'es'=>true,'et'=>true,'fa'=>true,'fi'=>true,'fr'=>true,'gl'=>true,'he'=>true,'hi'=>true,'hu'=>true,'id'=>true,'it'=>true,'ja'=>true,'ka'=>true,'ko'=>true,'lt'=>true,'lv'=>true,'ms'=>true,'nl'=>true,'no'=>true,'pl'=>true,'pt-BR'=>true,'pt'=>true,'ro'=>true,'ru'=>true,'sk'=>true,'sl'=>true,'sr'=>true,'sv'=>true,'ta'=>true,'th'=>true,'tr'=>true,'uk'=>true,'vi'=>true,'zh-TW'=>true,'zh'=>true,);}function
get_lang(){return
Locale::get()->getLanguage();}function
lang($v,$kh=null){return
call_user_func_array([Locale::get(),"translate"],func_get_args());}function
get_language_options(){$Wa=get_available_languages();if(count($Wa)==1)return[];$B=[];foreach(Locale::$Languages
as$Tf=>$sl){if(isset($Wa[$Tf]))$B[$Tf]=$sl;}return$B;}function
language_select(){$B=get_language_options();if(!$B)return;echo"<form action='' method='post'>\n",html_select("lang",$B,Locale::get()->getLanguage(),"this.form.submit();"),"<input type='submit' value='".lang(76),"' class='button hidden'>\n",input_token(),"</form>\n";}$Wa=get_available_languages();$Tf=array_keys($Wa)[0];if(isset($_POST["lang"])&&isset($Wa[$_POST["lang"]])&&verify_token()){$_SESSION["lang"]=$_COOKIE["neo_lang"]=$_POST["lang"];$_SESSION["translations"]=[];if(!isset($_GET["settings"])){cookie("neo_lang",$_POST["lang"],7776000);redirect(remove_from_uri());}}if(isset($_COOKIE["neo_lang"])&&isset($Wa[$_COOKIE["neo_lang"]])){cookie("neo_lang",$_COOKIE["neo_lang"],7776000);$Tf=$_COOKIE["neo_lang"];}elseif(isset($_SESSION["lang"])&&isset($Wa[$_SESSION["lang"]]))$Tf=$_SESSION["lang"];elseif(isset($_SERVER["HTTP_ACCEPT_LANGUAGE"])){$qa=[];preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$z,PREG_SET_ORDER);foreach($z
as$y)$qa[$y[1]]=(isset($y[3])?$y[3]:1);arsort($qa);foreach($qa
as$v=>$Ki){if(isset($Wa[$v])){$Tf=$v;break;}$v=preg_replace('~-.*~','',$v);if(!isset($qa[$v])&&isset($Wa[$v])){$Tf=$v;break;}}}Locale::create($Tf);abstract
class
Connection{protected$flavor=null;protected$version;protected$affectedRows=0;protected$errno=0;protected$error="";protected$multiResult;private
static$instance=null;static
function
create(){if(self::$instance)die(__CLASS__." instance already exists.\n");return
self::$instance=new
static();}static
function
createSecondary(){return
new
static();}static
function
get(){if(!self::$instance)exit(__CLASS__." instance not found.\n");return
self::$instance;}protected
function
__construct(){}function
openPasswordless($O,$V,$E,$Ak=true){$Le=Admin::get()->getConfig()->getDefaultPasswordHash()!="";if($E!=""&&($Ak||$Le)&&$this->open($O,$V,"")){$I=Admin::get()->verifyDefaultPassword($E);if($I!==true){$this->error=$I;return
false;}return
true;}return$this->open($O,$V,$E);}abstract
function
open($O,$V,$E);function
getFlavor(){return$this->flavor;}function
isMariaDB(){return$this->flavor=="mariadb";}function
isCockroachDB(){return$this->flavor=="cockroach";}function
getVersion(){return$this->version;}function
isMinVersion($mm){return
version_compare($this->version,$mm)>=0;}function
getAffectedRows(){return$this->affectedRows;}function
setAffectedRows($_a){$this->affectedRows=$_a;}function
getErrno(){return$this->errno;}function
getError(){return$this->error;}function
setError($k){$this->error=$k;}abstract
function
selectDatabase($_);abstract
function
quote($Q);function
formatValue($Y,array$l){return$Y;}abstract
function
query($G,$Pl=false);function
getQueryInfo(){return
null;}function
getResult($G,$l=0){return$this->getValue($G,$l);}function
getValue($G,$Rd=0){$I=$this->query($G);if(!is_object($I))return
false;$K=$I->fetchRow();return$K?$K[$Rd]:false;}function
multiQuery($G){$this->multiResult=$this->query($G);return(bool)($this->multiResult);}function
storeResult($I=null){return$this->multiResult;}function
nextResult(){return
false;}}abstract
class
Result{protected$rowsCount;function
__construct($uj){$this->rowsCount=$uj;}function
getRowsCount(){return$this->rowsCount;}abstract
function
fetchAssoc();abstract
function
fetchRow();abstract
function
fetchField();function
seek($A){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoConnection
extends
Connection{protected$pdo;protected$multiResult;protected
function
dsn($cd,$V,$E,array$B=[]){$B[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;try{$this->pdo=new
PDO($cd,$V,$E,$B);}catch(Exception$Ad){$this->error=$Ad->getMessage();return
false;}$this->version=preg_replace('~^\D*([\d.]+).*~',"$1",(string)@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION));return
true;}function
quote($Q){return$this->pdo->quote($Q);}function
query($G,$Pl=false){$xk=$this->pdo->query($G);$this->error="";if(!$xk){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(112);return
false;}$I=new
PdoResult($xk);$this->storeResult($I);return$I;}function
storeResult($I=null){if(!$I){$I=$this->multiResult;if(!$I)return
false;}if($I->getColumnsCount())return$I;$this->affectedRows=$I->getAffectedRowsCount();return
true;}function
nextResult(){return$this->multiResult&&$this->multiResult->nextRowset();}}class
PdoResult
extends
Result{private$statement;private$offset=0;function
__construct(PDOStatement$xk){parent::__construct(max($xk->columnCount()?$xk->rowCount():0,0));$this->statement=$xk;}function
getColumnsCount(){return$this->statement->columnCount();}function
getAffectedRowsCount(){return$this->statement->rowCount();}function
fetchAssoc(){return$this->statement->fetch(PDO::FETCH_ASSOC);}function
fetchRow(){return$this->statement->fetch(PDO::FETCH_NUM);}function
fetchField(){$K=$this->statement->getColumnMeta($this->offset++);if($K===false)return
false;$U=$K["pdo_type"];$K["type"]=($U==PDO::PARAM_INT?0:15);$K["charsetnr"]=($U==\PDO::PARAM_LOB||(isset($K["flags"])&&in_array("blob",(array)$K["flags"]))?63:0);return(object)$K;}function
seek($A){for($q=0;$q<$A;$q++){if($this->statement->fetch()===false)return
false;;}return
true;}function
nextRowset(){$this->offset=0;return@$this->statement->nextRowset();}}}class
Drivers{private
static$drivers=[];private
static$extensions=[];static
function
add($r,$_,array$Ld){self::$drivers[$r]=$_;self::$extensions[$r]=$Ld;}static
function
setName($r,$_){if(isset(self::$drivers[$r]))self::$drivers[$r]=$_;}static
function
get($r){return
isset(self::$drivers[$r])?self::$drivers[$r]:null;}static
function
getList(){return
self::$drivers;}static
function
getExtensions($r){return
isset(self::$extensions[$r])?self::$extensions[$r]:[];}}function
get_drivers(){return
Drivers::getList();}abstract
class
Driver{static$EnumLengthPattern="'(?:''|[^'\\\\]|\\\\.)*'";protected$connection;protected$admin;protected$types=[];protected$unsigned=[];protected$generated=[];protected$operators=[];protected$likeOperator=null;protected$regexpOperator=null;protected$functions=[];protected$grouping=[];protected$inOut=["IN","OUT","INOUT"];protected$onActions=["RESTRICT","CASCADE","SET NULL","SET DEFAULT","NO ACTION"];protected$editFunctions=[];protected$systemDatabases=[];protected$systemSchemas=[];private
static$instance=null;static
function
create(Connection$f,$xa){if(self::$instance)die(__CLASS__." instance already exists.\n");return
self::$instance=new
static($f,$xa);}static
function
get(){if(!self::$instance)exit(__CLASS__." instance not found.\n");return
self::$instance;}protected
function
__construct(Connection$f,$xa){$this->connection=$f;$this->admin=$xa;}function
getTypes(){return
call_user_func_array("array_merge",array_values($this->types));}function
getStructuredTypes(){return
array_map("array_keys",$this->types);}function
setUserTypes(array$Ol){$this->types[lang(113)]=array_flip($Ol);}function
getUserTypes(){$v=lang(113);return
array_keys(isset($this->types[$v])?$this->types[$v]:[]);}function
getUnsigned(){return$this->unsigned;}function
getGenerated(){return$this->generated;}function
getOperators(){return$this->operators;}function
getLikeOperator(){return$this->likeOperator;}function
getRegexpOperator(){return$this->regexpOperator;}function
getFunctions(){return$this->functions;}function
getGrouping(){return$this->grouping;}function
getInOut(){return$this->inOut;}function
getOnActions(){return$this->onActions;}function
getEditFunctions(){return$this->editFunctions;}function
getSystemDatabases(){return$this->systemDatabases;}function
getSystemSchemas(){return$this->systemSchemas;}function
getUnconvertFunction(array$l){return"";}function
select($R,array$M,array$Z,array$De,array$Eh=[],$w=1,$C=0,$Ci=false){$zf=(count($De)<count($M));$G="SELECT".limit(($_GET["page"]!="last"&&$w!==null&&$De&&$zf&&DIALECT=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($De&&$zf?"\nGROUP BY ".implode(", ",$De):"").($Eh?"\nORDER BY ".implode(", ",$Eh):""),($w!==null?+$w:null),($C?$w*$C:0),"\n");$wk=microtime(true);$J=$this->connection->query($G);if($Ci)echo
Admin::get()->formatSelectQuery($G,$wk,!$J);return$J;}function
delete($R,$Oi,$w=0){$G="FROM ".table($R);return
queries("DELETE".($w?limit1($R,$G,$Oi):" $G$Oi"));}function
update($R,array$H,$Oi,$w=0,$N="\n"){$jm=[];foreach($H
as$v=>$X)$jm[]="$v = $X";$G=table($R)." SET$N".implode(",$N",$jm);return
queries("UPDATE".($w?limit1($R,$G,$Oi,$N):" $G$Oi"));}function
insert($R,array$H){return
queries("INSERT INTO ".table($R).($H?" (".implode(", ",array_keys($H)).")\nVALUES (".implode(", ",$H).")":" DEFAULT VALUES").$this->getInsertReturningSql($R));}function
getInsertReturningSql($R){return"";}function
insertUpdate($R,array$Ti,array$F){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($G,$ql){return
null;}function
convertSearch($s,array$Z,array$l){return$s;}function
quoteBinary($Q){return
q($Q);}function
warnings(){return
null;}function
tableHelp($_,$yf=false){return
null;}function
supportsIndex(array$Rk){return!is_view($Rk);}function
hasCStyleEscapes(){return
false;}function
engines(){return[];}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->connection);}function
getAllFields(){if(DB=="")return[];$Fa=[];$L=get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(DIALECT=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->connection);foreach($L
as$K){$K["null"]=($K["nullable"]=="YES");$Fa[$K["tab"]][]=$K;}return$Fa;}}Drivers::add("mysql","MySQL",["MySQLi","PDO_MySQL"]);if(isset($_GET["mysql"])){define("AdminNeo\DRIVER","mysql");define("AdminNeo\DIALECT","sql");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){define("AdminNeo\DRIVER_EXTENSION","MySQLi");class
MySqlConnection
extends
Connection{private$mysqli;protected
function
__construct(){parent::__construct();$this->mysqli=new
mysqli();$this->mysqli->init();}function
open($O,$V,$E,$yc=null,$ui=null,$ik=null){mysqli_report(MYSQLI_REPORT_OFF);list($Ye,$ui)=explode(":",$O,2);$v=Admin::get()->getConfig()->getSslKey();$pb=Admin::get()->getConfig()->getSslCertificate();$nb=Admin::get()->getConfig()->getSslCaCertificate();$uk=$v||$pb||$nb;if($uk){$this->mysqli->ssl_set($v,$pb,$nb,null,null);$ge=Admin::get()->getConfig()->getSslTrustServerCertificate()?64:MYSQLI_CLIENT_SSL;}else$ge=0;$ac=@$this->mysqli->real_connect(($O!=""?$Ye:ini_get("mysqli.default_host")),($O.$V!=""?$V:ini_get("mysqli.default_user")),($O.$V.$E!=""?$E:ini_get("mysqli.default_pw")),$yc,(is_numeric($ui)?$ui:ini_get("mysqli.default_port")),(!is_numeric($ui)?$ui:$ik),$ge);$this->mysqli->options(MYSQLI_OPT_LOCAL_INFILE,false);if($ac){$of=$this->mysqli->get_server_info();$this->version=str_replace("-MariaDB","",$of);$this->flavor=str_contains($of,"MariaDB")?"mariadb":null;}return$ac;}function
getAffectedRows(){return$this->mysqli->affected_rows;}function
getErrno(){return$this->mysqli->errno;}function
getError(){return$this->mysqli->error;}function
selectDatabase($_){return$this->mysqli->select_db($_);}function
setCharset($rb){if($this->mysqli->set_charset($rb))return
true;$this->mysqli->set_charset('utf8');return(bool)$this->query("SET NAMES $rb");}function
quote($Q){return"'".$this->mysqli->escape_string($Q)."'";}function
query($G,$Pl=false){$I=$this->mysqli->query($G);return
is_object($I)?new
MySqlResult($I):$I;}function
getQueryInfo(){return$this->mysqli->info;}function
multiQuery($G){return$this->mysqli->multi_query($G);}function
storeResult($I=null){$I=$this->mysqli->store_result();if(!$I)return
false;return
new
MySqlResult($I);}function
nextResult(){return$this->mysqli->more_results()&&$this->mysqli->next_result();}}class
MySqlResult
extends
Result{private$resource;function
__construct(mysqli_result$gj){parent::__construct($gj->num_rows);$this->resource=$gj;}function
fetchAssoc(){return$this->resource->fetch_assoc();}function
fetchRow(){return$this->resource->fetch_row();}function
fetchField(){return$this->resource->fetch_field();}function
seek($A){return$this->resource->data_seek($A);}}}elseif(extension_loaded("pdo_mysql")){define("AdminNeo\DRIVER_EXTENSION","PDO_MySQL");class
MySqlConnection
extends
PdoConnection{function
open($O,$V,$E){$cd="mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$O));$B=[PDO::MYSQL_ATTR_LOCAL_INFILE=>false];$v=Admin::get()->getConfig()->getSslKey();if($v)$B[PDO::MYSQL_ATTR_SSL_KEY]=$v;$pb=Admin::get()->getConfig()->getSslCertificate();if($pb)$B[PDO::MYSQL_ATTR_SSL_CERT]=$pb;$nb=Admin::get()->getConfig()->getSslCaCertificate();if($nb)$B[PDO::MYSQL_ATTR_SSL_CA]=$nb;$Kl=Admin::get()->getConfig()->getSslTrustServerCertificate();if($Kl!==null&&defined('\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT'))$B[PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=!$Kl;if(!$this->dsn($cd,$V,$E,$B))return
false;$nm=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);$this->flavor=str_contains($nm,"MariaDB")?"mariadb":null;return
true;}function
setCharset($rb){return(bool)$this->query("SET NAMES $rb");}function
selectDatabase($_){return(bool)$this->query("USE ".idf_escape($_));}function
query($G,$Pl=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Pl);return
parent::query($G,$Pl);}}}class
MySqlDriver
extends
Driver{protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->types=[lang(114)=>["tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21,],lang(115)=>["date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4,],lang(116)=>["char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295,],lang(117)=>["enum"=>65535,"set"=>64,],lang(118)=>["bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295,],lang(119)=>["geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0,],];$this->unsigned=["unsigned","zerofill","unsigned zerofill"];$qg=$f->isMariaDB();if($f->isMinVersion($qg?"10.2":"5.7"))$this->generated=["STORED","VIRTUAL"];$this->operators=["=","<",">","<=",">=","!=","LIKE","LIKE %%","NOT LIKE","IN","NOT IN","FIND_IN_SET","IS NULL","IS NOT NULL","REGEXP","NOT REGEXP","SQL",];$this->likeOperator="LIKE %%";$this->regexpOperator="REGEXP";$this->functions=["char_length","lower","upper","round","floor","ceil","date","from_unixtime","unix_timestamp","sec_to_time","time_to_sec",];$this->grouping=["sum","min","max","avg","count","count distinct","group_concat",];$this->editFunctions=[["char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",],[number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",]];if($f->isMinVersion($qg?"10.2":"5.7.8"))$this->types[lang(116)]["json"]=4294967295;if($qg&&$f->isMinVersion("10.7")){$this->types[lang(116)]["uuid"]=128;$this->editFunctions[0]['uuid']='uuid';}if($f->isMinVersion("9")){$this->types[lang(114)]["vector"]=16383;$this->editFunctions[0]['vector']='string_to_vector';}$this->systemDatabases=["mysql","information_schema","performance_schema","sys"];}function
insert($R,array$H){return($H?parent::insert($R,$H):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
getUnconvertFunction(array$l){if(preg_match("~binary~",$l["type"]))return"<code class='jush-sql'>UNHEX</code>";elseif($l["type"]=="bit")return
doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>");elseif(preg_match("~geometry|point|linestring|polygon~",$l["type"]))return"<code class='jush-sql'>GeomFromText</code>";else
return"";}function
insertUpdate($R,array$Ti,array$F){$d=array_keys(reset($Ti));$zi="INSERT INTO ".table($R)." (".implode(", ",$d).") VALUES\n";$jm=[];foreach($d
as$v)$jm[$v]="$v = VALUES($v)";$Gk="\nON DUPLICATE KEY UPDATE ".implode(", ",$jm);$jm=[];$bg=0;foreach($Ti
as$H){$Y="(".implode(", ",$H).")";if($jm&&(strlen($zi)+$bg+strlen($Y)+strlen($Gk)>1e6)){if(!queries($zi.implode(",\n",$jm).$Gk))return
false;$jm=[];$bg=0;}$jm[]=$Y;$bg+=strlen($Y)+2;}return
queries($zi.implode(",\n",$jm).$Gk);}function
slowQuery($G,$ql){$qg=$this->connection->isMariaDB();if(!$this->connection->isMinVersion($qg?"10.1.2":"5.7.8"))return
null;if($qg)return"SET STATEMENT max_statement_time=$ql FOR $G";elseif(preg_match('~^(SELECT\b)(.+)~is',$G,$y))return"$y[1] /*+ MAX_EXECUTION_TIME(".($ql*1000).") */ $y[2]";else
return
null;}function
convertSearch($s,array$Z,array$l){return(preg_match('~char|text|enum|set~',$l["type"])&&!preg_match("~^utf8~",$l["collation"])&&preg_match('~[\x80-\xFF]~',$Z['val'])?"CONVERT($s USING ".charset($this->connection).")":$s);}function
warnings(){$I=$this->connection->query("SHOW WARNINGS");if($I&&$I->getRowsCount()){ob_start();select($I);return
ob_get_clean();}return
null;}function
tableHelp($_,$yf=false){$qg=$this->connection->isMariaDB();if(information_schema(DB))return
strtolower("information-schema-".($qg?"$_-table/":str_replace("_","-",$_)."-table.html"));if(DB=="mysql")return($qg?"mysql$_-table/":"system-schema.html");return
null;}function
hasCStyleEscapes(){static$lb;if($lb===null){$rk=$this->connection->getValue("SHOW VARIABLES LIKE 'sql_mode'",1);$lb=(strpos($rk,'NO_BACKSLASH_ESCAPES')===false);}return$lb;}function
engines(){$rd=[];foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$rd[]=$K["Engine"];}return$rd;}}function
create_driver(Connection$f){return
MySqlDriver::create($f,Admin::get());}function
idf_escape($s){return"`".str_replace("`","``",$s)."`";}function
table($s){return
idf_escape($s);}function
connect($F=false,&$k=null){$f=$F?MySqlConnection::create():MySqlConnection::createSecondary();list($O,$V,$E)=Admin::get()->getCredentials();if(!$f->openPasswordless($O,$V,$E,false)){$k=$f->getError();if(function_exists('iconv')&&!is_utf8($k)&&strlen($vj=iconv("windows-1250","utf-8",$k))>strlen($k))$k=$vj;return
null;}$f->setCharset(charset($f));$f->query("SET sql_quote_show_create = 1, autocommit = 1");if($F&&$f->isMariaDB()){Drivers::setName(DRIVER,"MariaDB");save_driver_name(DRIVER,$O,"MariaDB");}return$f;}function
get_databases($ie){$J=get_session("dbs");if($J===null){$G="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($ie?slow_query($G):get_vals($G));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($G,$Z,$w,$A=0,$N=" "){return" $G$Z".($w!==null?$N."LIMIT $w".($A?" OFFSET $A":""):"");}function
limit1($R,$G,$Z,$N="\n"){return
limit($G,$Z,1,0,$N);}function
db_collation($i,$Ib){$J=null;$nc=Connection::get()->getValue("SHOW CREATE DATABASE ".idf_escape($i),1);if(preg_match('~ COLLATE ([^ ]+)~',$nc,$y))$J=$y[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$nc,$y))$J=$Ib[$y[1]][-1];return$J;}function
logged_user(){return
Connection::get()->getValue("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables($h){$J=[];foreach($h
as$i)$J[$i]=count(get_vals("SHOW TABLES IN ".idf_escape($i)));return$J;}function
table_status($_="",$Pd=false){if($Pd)$G="SELECT TABLE_NAME AS Name, ENGINE AS Engine, CREATE_OPTIONS AS Create_options, TABLES.TABLE_COLLATION AS Collation, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($_!=""?"AND TABLE_NAME = ".q($_):"ORDER BY Name");else$G="SHOW TABLE STATUS".($_!=""?" LIKE ".q(addcslashes($_,"%_\\")):"");$T=[];foreach(get_rows($G)as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($_!=""){$K["Name"]=$_;return$K;}$T[$K["Name"]]=$K;}return$T;}function
is_view($S){return$S["Engine"]===null;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"])||(preg_match('~NDB~i',$S["Engine"])&&Connection::get()->isMinVersion("5.6"));}function
fields($R){$qg=Connection::get()->isMariaDB();$J=[];foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$l=$K["COLUMN_NAME"];$U=preg_replace('~\s?/\*.+\*/~U',"",$K["COLUMN_TYPE"]);$Md=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Md,$xe);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$Ml);$j=$qg&&$K["COLUMN_DEFAULT"]=="NULL"?null:$K["COLUMN_DEFAULT"];if($j!==null){$Af=preg_match('~(text|json)~',$Ml[1]);if(!$qg&&$Af)$j=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($j));if($qg||$Af){$j=preg_replace_callback("~^'(.*)'$~",function($z){return
stripslashes(str_replace("''","'",$z[1]));},$j);}if(!$qg&&preg_match('~binary~',$Ml[1])&&preg_match('~^0x(\w*)$~',$j,$z))$j=pack("H*",$z[1]);}$ze=$K["GENERATION_EXPRESSION"];if(!$qg)$ze=preg_replace("~(^|,|\()(_\w+)?('.*')($|,|\))~",'\1\3\4',stripslashes($ze));$J[$l]=["field"=>$l,"full_type"=>$U,"type"=>$Ml[1],"length"=>$Ml[2],"unsigned"=>ltrim($Ml[3].$Ml[4]),"default"=>($xe?$ze:$j),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Md=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Md,$Ml)?$Ml[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",",$K["PRIVILEGES"]))+["where"=>1,"order"=>1],"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($xe[1]=="PERSISTENT"?"STORED":$xe[1]),];}return$J;}function
indexes($R,$f=null){$J=[];foreach(get_rows("SHOW INDEX FROM ".table($R),$f)as$K){$_=$K["Key_name"];$J[$_]["type"]=($_=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$_]["columns"][]=$K["Column_name"];$J[$_]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$_]["descs"][]=null;}return$J;}function
foreign_keys($R){static$li='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=[];$oc=Connection::get()->getValue("SHOW CREATE TABLE ".table($R),1);if($oc){$vh=implode("|",Driver::get()->getOnActions());preg_match_all("~CONSTRAINT ($li) FOREIGN KEY ?\\(((?:$li,? ?)+)\\) REFERENCES ($li)(?:\\.($li))? \\(((?:$li,? ?)+)\\)(?: ON DELETE ($vh))?(?: ON UPDATE ($vh))?~",$oc,$z,PREG_SET_ORDER);foreach($z
as$y){preg_match_all("~$li~",$y[2],$lk);preg_match_all("~$li~",$y[5],$el);$J[idf_unescape($y[1])]=["db"=>idf_unescape($y[4]!=""?$y[3]:$y[4]),"table"=>idf_unescape($y[4]!=""?$y[4]:$y[3]),"source"=>array_map('AdminNeo\idf_unescape',$lk[0]),"target"=>array_map('AdminNeo\idf_unescape',$el[0]),"on_delete"=>($y[6]?:"RESTRICT"),"on_update"=>($y[7]?:"RESTRICT"),];}}return$J;}function
backward_keys($R){$G="SELECT constraint_name, table_schema, table_name, column_name, referenced_column_name
FROM information_schema.key_column_usage
WHERE table_schema = ".q(DB)."
AND referenced_table_schema = ".q(DB)."
AND referenced_table_name = ".q($R)."
ORDER BY ordinal_position";return
get_rows($G,null,"");}function
view($_){return["select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',Connection::get()->getValue("SHOW CREATE VIEW ".table($_),1))];}function
collations(){$J=[];$G=Connection::get()->isMariaDB()&&Connection::get()->isMinVersion("10.10")?"SELECT CHARACTER_SET_NAME AS Charset, FULL_COLLATION_NAME AS Collation, IS_DEFAULT AS `Default` FROM information_schema.COLLATION_CHARACTER_SET_APPLICABILITY":"SHOW COLLATION";foreach(get_rows($G)as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$v=>$X)asort($J[$v]);return$J;}function
information_schema($i){return($i=="information_schema")||(Connection::get()->isMinVersion("5.5")&&$i=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",Connection::get()->getError()));}function
create_database($i,$Hb){return
queries("CREATE DATABASE ".idf_escape($i).($Hb?" COLLATE ".q($Hb):""));}function
drop_databases($h){$J=apply_queries("DROP DATABASE",$h,'AdminNeo\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($_,$Hb){$J=false;if(create_database($_,$Hb)){$T=[];$qm=[];foreach(tables_list()as$R=>$U){if($U=='VIEW')$qm[]=$R;else$T[]=$R;}$J=(!$T&&!$qm)||move_tables($T,$qm,$_);drop_databases($J?[DB]:[]);}return$J;}function
auto_increment(){$Ua=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$t){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$t["columns"],true)){$Ua="";break;}if($t["type"]=="PRIMARY")$Ua=" UNIQUE";}}return" AUTO_INCREMENT$Ua";}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){$b=[];foreach($m
as$l){if($l[1]){$j=$l[1][3];if(str_contains($j," GENERATED")){$l[1][3]=Connection::get()->isMariaDB()?"":$l[1][2];$l[1][2]=$j;}$b[]=($R!=""?($l[0]!=""?"CHANGE ".idf_escape($l[0]):"ADD"):" ")." ".implode($l[1]).($R!=""?$l[2]:"");}else$b[]="DROP ".idf_escape($l[0]);}$b=array_merge($b,$ke);$zk=($Qb!==null?" COMMENT=".q($Qb):"").($qd?" ENGINE=".q($qd):"").($Hb?" COLLATE ".q($Hb):"").($Ta!=""?" AUTO_INCREMENT=$Ta":"");if($R=="")return
queries("CREATE TABLE ".table($_)." (\n".implode(",\n",$b)."\n)$zk$di");if($R!=$_)$b[]="RENAME TO ".table($_);if($zk)$b[]=ltrim($zk);return($b||$di?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b).$di):true);}function
alter_indexes($R,$b){foreach($b
as$v=>$X)$b[$v]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$b));}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($qm){return
queries("DROP VIEW ".implode(", ",array_map('AdminNeo\table',$qm)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('AdminNeo\table',$T)));}function
move_tables($T,$qm,$el){$ej=[];foreach($T
as$R)$ej[]=table($R)." TO ".idf_escape($el).".".table($R);if(!$ej||queries("RENAME TABLE ".implode(", ",$ej))){$Hc=[];foreach($qm
as$R)$Hc[table($R)]=view($R);Connection::get()->selectDatabase($el);$i=idf_escape(DB);foreach($Hc
as$_=>$om){if(!queries("CREATE VIEW $_ AS ".str_replace(" $i."," ",$om["select"]))||!queries("DROP VIEW $i.$_"))return
false;}return
true;}return
false;}function
copy_tables($T,$qm,$el){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$_=($el==DB?table("copy_$R"):idf_escape($el).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $_"))||!queries("CREATE TABLE $_ LIKE ".table($R))||!queries("INSERT INTO $_ SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$Fl=$K["Trigger"];if(!queries("CREATE TRIGGER ".($el==DB?idf_escape("copy_$Fl"):idf_escape($el).".".idf_escape($Fl))." $K[Timing] $K[Event] ON $_ FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($qm
as$R){$_=($el==DB?table("copy_$R"):idf_escape($el).".".table($R));$om=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $_"))||!queries("CREATE VIEW $_ AS $om[select]"))return
false;}return
true;}function
trigger($_){if($_=="")return[];$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($_));return
reset($L);}function
triggers($R){$J=[];foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=[$K["Timing"],$K["Event"]];return$J;}function
trigger_options(){return["Timing"=>["BEFORE","AFTER"],"Event"=>["INSERT","UPDATE","DELETE"],"Type"=>["FOR EACH ROW"],];}function
routine($_,$U){$of=get_rows("SELECT ROUTINE_BODY, ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB)." AND ROUTINE_NAME = ".q($_))[0];$Ea=["bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar"];$nk="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$sd=Driver::$EnumLengthPattern;$Nl="((".implode("|",array_merge(array_keys(Driver::get()->getTypes()),$Ea)).")\\b(?:\\s*\\(((?:[^'\")]|$sd)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$jf=implode("|",Driver::get()->getInOut());$li="$nk*(".($U=="FUNCTION"?"":$jf).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Nl";$nc=Connection::get()->getValue("SHOW CREATE $U ".idf_escape($_),2);preg_match("~\\(((?:$li\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Nl\\s+":"")."(.*)~is",$nc,$y);$m=[];preg_match_all("~$li\\s*,?~is",$y[1],$z,PREG_SET_ORDER);foreach($z
as$Wh)$m[]=["field"=>str_replace("``","`",$Wh[2]).$Wh[3],"type"=>strtolower($Wh[5]),"length"=>preg_replace_callback("~$sd~s",'AdminNeo\normalize_enum',$Wh[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Wh[8] $Wh[7]"))),"null"=>1,"full_type"=>$Wh[4],"inout"=>strtoupper($Wh[1]),"collation"=>strtolower($Wh[9]),];return$U=="FUNCTION"?["fields"=>$m,"returns"=>["type"=>$y[12],"length"=>$y[13],"unsigned"=>$y[15],"collation"=>$y[16]],"definition"=>$y[17],"language"=>$of["ROUTINE_BODY"],"comment"=>$of["ROUTINE_COMMENT"],]:["fields"=>$m,"returns"=>null,"definition"=>$y[11],"language"=>$of["ROUTINE_BODY"],"comment"=>$of["ROUTINE_COMMENT"],];}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER, ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return[];}function
routine_id($_,$K){return
idf_escape($_);}function
last_id($I){return
Connection::get()->getValue("SELECT LAST_INSERT_ID()");}function
explain(Connection$f,$G){return$f->query("EXPLAIN ".(Connection::get()->isMinVersion("5.1")&&!Connection::get()->isMinVersion("5.7")?"PARTITIONS ":"").$G);}function
found_rows($S,$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ta,$Ck){$J=Connection::get()->getValue("SHOW CREATE TABLE ".table($R),1);if(!$Ta)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($yc){return"USE ".idf_escape($yc);}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field($l){if(preg_match("~binary~",$l["type"]))return"HEX(".idf_escape($l["field"]).")";if($l["type"]=="bit")return"BIN(".idf_escape($l["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$l["type"]))return(Connection::get()->isMinVersion("8")?"ST_":"")."AsWKT(".idf_escape($l["field"]).")";}function
unconvert_field(array$l,$J){if(preg_match("~binary~",$l["type"]))$J="UNHEX($J)";if($l["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$l["type"])){$zi=(Connection::get()->isMinVersion("8")?"ST_":"");$J=$zi."GeomFromText($J, $zi"."SRID($l[field]))";}return$J;}function
support($Qd){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(Connection::get()->isMinVersion("8")?"":"|descidx".(Connection::get()->isMinVersion("5.1")?"":"|event|partitioning")).(Connection::get()->isMinVersion(Connection::get()->isMariaDB()?"10.2.1":"8.0.16")?"":"|check")."~",$Qd);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
Connection::get()->getValue("SELECT @@max_connections");}}Drivers::add("pgsql","PostgreSQL",["PgSQL","PDO_PgSQL"]);if(isset($_GET["pgsql"])){define("AdminNeo\DRIVER","pgsql");define("AdminNeo\DIALECT","pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){define("AdminNeo\DRIVER_EXTENSION","PgSQL");class
PgSqlConnection
extends
Connection{var$timeout=0;private$connection;private$connectionString;private$hasDefaultDatabase=true;function
open($O,$V,$E){$i=Admin::get()->getDatabase();set_error_handler(function($ud,$k){if(ini_bool("html_errors"))$k=html_entity_decode(strip_tags($k));$k=preg_replace('~^[^:]*: ~','',$k);$this->error=$k;});$this->connectionString="host='".str_replace(":","' port='",addcslashes($O,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($E,"'\\")."'";$vk=Admin::get()->getConfig()->getSslMode();if($vk)$this->connectionString
.=" sslmode='$vk'";$this->connection=@pg_connect("$this->connectionString dbname='".($i!=""?addcslashes($i,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->connection&&$i!=""){$this->hasDefaultDatabase=false;$this->connection=@pg_connect("$this->connectionString dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->connection){$nm=$this->getValue("SELECT version()");$this->flavor=str_contains($nm,"CockroachDB")?"cockroach":null;$this->version=preg_replace('~^\D*([\d.]+[-\w]*).*~',"$1",$nm);pg_set_client_encoding($this->connection,"UTF8");}return(bool)$this->connection;}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->connection,$Q):"'".pg_escape_string($this->connection,$Q)."'");}function
formatValue($Y,array$l){if($l["type"]=="bytea"&&$Y!==null)return
pg_unescape_bytea($Y);return
parent::formatValue($Y,$l);}function
selectDatabase($_){if($_==Admin::get()->getDatabase())return$this->hasDefaultDatabase;$J=@pg_connect("$this->connectionString dbname='".addcslashes($_,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->connection=$J;return$J;}function
close(){$this->connection=@pg_connect("$this->connectionString dbname='postgres'");}function
query($G,$Pl=false){if(!$this->connection){$this->error="Invalid connection.";return
false;}$I=@pg_query($this->connection,$G);$this->error="";if(!$I){$this->error=pg_last_error($this->connection);$J=false;}elseif(!pg_num_fields($I)){$this->affectedRows=pg_affected_rows($I);$J=true;}else$J=new
PgSqlResult($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
getValue($G,$Rd=0){$I=$this->query($G);return
is_object($I)?$I->fetchValue($Rd):false;}function
warnings(){$I=pg_last_notice($this->connection);return$I?h($I):null;}}class
PgSqlResult
extends
Result{private$resource;private$offset=0;function
__construct($gj){parent::__construct(pg_num_rows($gj));$this->resource=$gj;}function
__destruct(){pg_free_result($this->resource);}function
fetchAssoc(){return
pg_fetch_assoc($this->resource);}function
fetchRow(){return
pg_fetch_row($this->resource);}function
fetchValue($Rd){return$this->getRowsCount()?pg_fetch_result($this->resource,0,$Rd):false;}function
fetchField(){$c=$this->offset++;$Hh=pg_field_table($this->resource,$c);if($Hh===false)return
false;$_=pg_field_name($this->resource,$c);if($_===false)return
false;$U=pg_field_type($this->resource,$c);if($U===false)return
false;return(object)['orgtable'=>$Hh,'name'=>$_,'type'=>$U,'charsetnr'=>($U=="bytea"?63:0),];}}}elseif(extension_loaded("pdo_pgsql")){define("AdminNeo\DRIVER_EXTENSION","PDO_PgSQL");class
PgSqlConnection
extends
PdoConnection{var$timeout=0;function
open($O,$V,$E){$i=Admin::get()->getDatabase();$cd="pgsql:host='".str_replace(":","' port='",addcslashes($O,"'\\"))."' client_encoding=utf8 dbname='".($i!=""?addcslashes($i,"'\\"):"postgres")."'";$vk=Admin::get()->getConfig()->getSslMode();if($vk)$cd
.=" sslmode='$vk'";if(!$this->dsn($cd,$V,$E))return
false;$nm=$this->getValue("SELECT version()");$this->flavor=str_contains($nm,"CockroachDB")?"cockroach":null;return
true;}function
selectDatabase($_){return
Admin::get()->getDatabase()==$_;}function
query($G,$Pl=false){$J=parent::query($G,$Pl);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){return
null;}function
close(){}}}class
PgSqlDriver
extends
Driver{protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->types=[lang(114)=>["smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20,],lang(115)=>["date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0,],lang(116)=>["character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0,],lang(118)=>["bit"=>0,"bit varying"=>0,"bytea"=>0,],lang(120)=>["cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0,],lang(119)=>["box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0,],];if($f->isMinVersion("9.2")){$this->types[lang(116)]["json"]=4294967295;if($f->isMinVersion("9.4"))$this->types[lang(116)]["jsonb"]=4294967295;}if($f->isMinVersion("12"))$this->generated=["STORED"];$this->operators=["=","<",">","<=",">=","!=","~","~*","!~","!~*","LIKE","LIKE %%","ILIKE","ILIKE %%","NOT LIKE","IN","NOT IN","IS NULL","IS NOT NULL",];$this->likeOperator="LIKE %%";$this->regexpOperator="~*";$this->functions=["char_length","lower","upper","round","to_hex","to_timestamp",];$this->grouping=["sum","min","max","avg","count","count distinct",];$this->editFunctions=[["char"=>"md5","date|time"=>"now",],[number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",]];$this->systemDatabases=["template1"];$this->systemSchemas=["information_schema","pg_catalog","pg_toast","pg_temp_*","pg_toast_temp_*"];}function
getInsertReturningSql($R){$Sa=array_filter(fields($R),function($l){return$l['auto_increment'];});return
count($Sa)==1?" RETURNING ".idf_escape(key($Sa)):"";}function
insertUpdate($R,array$Ti,array$F){foreach($Ti
as$H){$Wl=[];$Z=[];foreach($H
as$v=>$X){$Wl[]="$v = $X";if(isset($F[idf_unescape($v)]))$Z[]="$v = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Wl)." WHERE ".implode(" AND ",$Z))&&Connection::get()->getAffectedRows())||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($H)).") VALUES (".implode(", ",$H).")")))return
false;}return
true;}function
slowQuery($G,$ql){$this->connection->query("SET statement_timeout = ".(1000*$ql));$this->connection->timeout=1000*$ql;return$G;}function
convertSearch($s,array$Z,array$l){$kl="char|text";if(strpos($Z["op"],"LIKE")===false)$kl
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$kl~",$l["type"])?$s:"CAST($s AS text)");}function
quoteBinary($Q){return"'\\x".bin2hex($Q)."'";}function
warnings(){return$this->connection->warnings();}function
tableHelp($_,$yf=false){$hg=["information_schema"=>"infoschema","pg_catalog"=>($yf?"view":"catalog"),];$x=$hg[$_GET["ns"]];if($x)return"$x-".str_replace("_","-",$_).".html";return
null;}function
supportsIndex(array$Rk){return$Rk["Engine"]!="view";}function
hasCStyleEscapes(){static$lb;if($lb===null)$lb=($this->connection->getValue("SHOW standard_conforming_strings")=="off");return$lb;}}function
create_driver(Connection$f){return
PgSqlDriver::create($f,Admin::get());}function
idf_escape($s){return'"'.str_replace('"','""',$s).'"';}function
table($s){return
idf_escape($s);}function
connect($F=false,&$k=null){$f=$F?PgSqlConnection::create():PgSqlConnection::createSecondary();list($O,$V,$E)=Admin::get()->getCredentials();if($O=="")$O="localhost:5432";if(!$f->openPasswordless($O,$V,$E,false)){$k=$f->getError();return
null;}if($f->isMinVersion("9"))$f->query("SET application_name = 'AdminNeo'");if($F&&$f->isCockroachDB()){Drivers::setName(DRIVER,"CockroachDB");save_driver_name(DRIVER,$O,"CockroachDB");}return$f;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($G,$Z,$w,$A=0,$N=" "){return" $G$Z".($w!==null?$N."LIMIT $w".($A?" OFFSET $A":""):"");}function
limit1($R,$G,$Z,$N="\n"){return(preg_match('~^INTO~',$G)?limit($G,$Z,1,0,$N):" $G".(is_view(table_status1($R))?$Z:$N."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$N."LIMIT 1)"));}function
db_collation($i,$Ib){return
Connection::get()->getValue("SELECT datcollate FROM pg_database WHERE datname = ".q($i));}function
logged_user(){return
Connection::get()->getValue("SELECT user");}function
tables_list(){$G="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$G
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$G
.="
ORDER BY 1";return
get_key_vals($G);}function
count_tables($h){$J=[];foreach($h
as$i){if(Connection::get()->selectDatabase($i))$J[$i]=count(tables_list());}return$J;}function
table_status($_=""){static$Oe;if($Oe===null)$Oe=Connection::get()->getValue("SELECT 'pg_table_size'::regproc");$J=[];foreach(get_rows("SELECT
	c.relname AS \"Name\",
	CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\"".($Oe?",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\"":"").",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(Connection::get()->isMinVersion("12")?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	c.reltuples as \"Rows\",
	n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($_!=""?"AND relname = ".q($_):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;if($_!="")return
isset($J[$_])?$J[$_]:["Name"=>$_];else
return$J;}function
is_view($S){return
in_array($S["Engine"],["view","materialized view"]);}function
fk_support($S){return
true;}function
fields($R){$J=[];$Ea=['timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',];foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment".(Connection::get()->isMinVersion("10")?", a.attidentity".(Connection::get()->isMinVersion("12")?", a.attgenerated":""):"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($R)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$y);list(,$U,$bg,$K["length"],$wa,$Ma)=$y;$K["length"].=$Ma;$vb=$U.$wa;if(isset($Ea[$vb])){$K["type"]=$Ea[$vb];$K["full_type"]=$K["type"].$bg.$Ma;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$bg.$wa.$Ma;}if(in_array($K['attidentity'],['a','d']))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=["insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1];if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$y))$K["default"]=($y[1]=="NULL"?null:idf_unescape($y[1]).$y[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$f=null){if(!is_object($f))$f=Connection::get();$J=[];$Vk=$f->getValue("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($R));$d=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Vk AND attnum > 0",$f);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $Vk AND ci.oid = i.indexrelid ORDER BY indisprimary DESC, indisunique DESC",$f)as$K){$cj=$K["relname"];$J[$cj]["type"]=($K["indispartial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$cj]["columns"]=[];$J[$cj]["descs"]=[];if($K["indkey"]){foreach(explode(" ",$K["indkey"])as$mf)$J[$cj]["columns"][]=$d[$mf];foreach(explode(" ",$K["indoption"])as$nf)$J[$cj]["descs"][]=($nf&1?'1':null);}$J[$cj]["lengths"]=[];}return$J;}function
foreign_keys($R){$vh=implode("|",Driver::get()->getOnActions());$J=[];foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($R)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$y)){$K['source']=array_map('AdminNeo\idf_unescape',array_map('trim',explode(',',$y[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$y[2],$sg)){$K['ns']=idf_unescape($sg[2]);$K['table']=idf_unescape($sg[4]);}$K['target']=array_map('AdminNeo\idf_unescape',array_map('trim',explode(',',$y[3])));$K['on_delete']=(preg_match("~ON DELETE ($vh)~",$y[4],$sg)?$sg[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE ($vh)~",$y[4],$sg)?$sg[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
backward_keys($R){$G="SELECT s.constraint_name, s.table_schema, s.table_name, s.column_name, t.column_name AS referenced_column_name
FROM information_schema.key_column_usage s
JOIN information_schema.referential_constraints r USING (constraint_catalog, constraint_schema, constraint_name)
JOIN information_schema.key_column_usage t ON r.unique_constraint_catalog = t.constraint_catalog
	AND r.unique_constraint_schema = t.constraint_schema
	AND r.unique_constraint_name = t.constraint_name
	AND s.position_in_unique_constraint = t.ordinal_position
WHERE t.table_catalog = ".q(DB)."
AND t.table_schema = ".q($_GET["ns"])."
AND t.table_name = ".q($R)."
ORDER BY s.ordinal_position";return
get_rows($G,null,"");}function
view($_){return["select"=>trim(Connection::get()->getValue("SELECT pg_get_viewdef(".Connection::get()->getValue("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($_)).")"))];}function
collations(){return[];}function
information_schema($i){return
get_schema()=="information_schema";}function
error(){$J=h(Connection::get()->getError());if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$y))$J=$y[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($y[3]).'})(.*)~','\1<b>\2</b>',$y[2]).$y[4];return
nl2br($J);}function
create_database($i,$Hb){return
queries("CREATE DATABASE ".idf_escape($i).($Hb?" ENCODING ".idf_escape($Hb):""));}function
drop_databases($h){Connection::get()->close();return
apply_queries("DROP DATABASE",$h,'AdminNeo\idf_escape');}function
rename_database($_,$Hb){Connection::get()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($_));}function
auto_increment(){return"";}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){$b=[];$Li=[];if($R!=""&&$R!=$_)$Li[]="ALTER TABLE ".table($R)." RENAME TO ".table($_);$Kj="";foreach($m
as$l){$c=idf_escape($l[0]);$X=$l[1];if(!$X)$b[]="DROP $c";else{$im=$X[5];unset($X[5]);if($l[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($c!=$X[0])$Li[]="ALTER TABLE ".table($_)." RENAME $c TO $X[0]";$b[]="ALTER $c TYPE$X[1]";$Lj=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $c ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($Lj).")":"DROP DEFAULT"));if(isset($X[6]))$Kj="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($Lj)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $c ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($l[0]!=""||$im!="")$Li[]="COMMENT ON COLUMN ".table($_).".$X[0] IS ".($im!=""?substr($im,9):"''");}}$b=array_merge($b,$ke);if($R=="")array_unshift($Li,"CREATE TABLE ".table($_)." (\n".implode(",\n",$b)."\n)");elseif($b)array_unshift($Li,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($Kj)array_unshift($Li,$Kj);if($Qb!==null)$Li[]="COMMENT ON TABLE ".table($_)." IS ".q($Qb);if($Ta!="");foreach($Li
as$G){if(!queries($G))return
false;}return
true;}function
alter_indexes($R,$b){$nc=[];$Xc=[];$Li=[];foreach($b
as$X){if($X[0]!="INDEX")$nc[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$Xc[]=idf_escape($X[1]);else$Li[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($nc)array_unshift($Li,"ALTER TABLE ".table($R).implode(",",$nc));if($Xc)array_unshift($Li,"DROP INDEX ".implode(", ",$Xc));foreach($Li
as$G){if(!queries($G))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('AdminNeo\table',$T)));}function
drop_views($qm){return
drop_tables($qm);}function
drop_tables($T){foreach($T
as$R){$zk=table_status($R);if(!queries("DROP ".strtoupper($zk["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$qm,$el){foreach(array_merge($T,$qm)as$R){$zk=table_status($R);if(!queries("ALTER ".strtoupper($zk["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($el)))return
false;}return
true;}function
trigger($_,$R){if($_=="")return["Statement"=>"EXECUTE PROCEDURE ()"];$d=[];$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($_);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$d[]=$K["event_object_column"];$J=[];foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement" FROM information_schema.triggers '."$Z ORDER BY event_manipulation DESC")as$K){if($d&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$d);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=[];foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$Fl=trigger($K["trigger_name"],$R);$J[$Fl["Trigger"]]=[$Fl["Timing"],$Fl["Event"]];}return$J;}function
trigger_options(){return["Timing"=>["BEFORE","AFTER"],"Event"=>["INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"],"Type"=>["FOR EACH ROW","FOR EACH STATEMENT"],];}function
routine($_,$U){$of=get_rows('SELECT routine_definition, external_language, type_udt_name
			FROM information_schema.routines
			WHERE routine_schema = current_schema() AND specific_name = '.q($_))[0];$m=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
			FROM information_schema.parameters
			WHERE specific_schema = current_schema() AND specific_name = '.q($_).'
			ORDER BY ordinal_position');return["fields"=>$m,"returns"=>["type"=>$of["type_udt_name"]],"definition"=>$of["routine_definition"],"language"=>strtolower($of["external_language"]),"comment"=>null,];}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_name AS "ROUTINE_NAME", routine_type AS "ROUTINE_TYPE", type_udt_name AS "DTD_IDENTIFIER", null AS ROUTINE_COMMENT
			FROM information_schema.routines
			WHERE routine_schema = current_schema()
			ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($_,$K){$J=[];foreach($K["fields"]as$l){$bg=$l["length"];$J[]=$l["type"].($bg?"($bg)":"");}return
idf_escape($_)."(".implode(", ",$J).")";}function
last_id($I){$K=$I
instanceof
Result?$I->fetchRow():[];return$K?$K[0]:0;}function
explain(Connection$f,$G){return$f->query("EXPLAIN $G");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",Connection::get()->getValue("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$bj))return$bj[1];return
false;}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($r){$td=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $r ORDER BY enumsortorder");return($td?"'".implode("', '",array_map('addslashes',$td))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
Connection::get()->getValue("SELECT current_schema()");}function
set_schema($xj,$f=null){if(!$f)$f=Connection::get();$I=(bool)$f->query("SET search_path TO ".idf_escape($xj));Driver::get()->setUserTypes(types());return$I;}function
foreign_keys_sql($R){$J="";$zk=table_status($R);$fe=foreign_keys($R);ksort($fe);foreach($fe
as$ee=>$de)$J
.="ALTER TABLE ONLY ".idf_escape($zk['nspname']).".".idf_escape($zk['Name'])." ADD CONSTRAINT ".idf_escape($ee)." $de[definition] ".($de['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ta,$Ck){$lj=[];$Mj=[];$zk=table_status($R);if(is_view($zk)){$om=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $om[select]",";");}$m=fields($R);if(!$zk||empty($m))return
false;$J="CREATE TABLE ".idf_escape($zk['nspname']).".".idf_escape($zk['Name'])." (\n    ";foreach($m
as$l){$Zh=idf_escape($l['field']).' '.$l['full_type'].default_value($l).($l['attnotnull']?" NOT NULL":"");$lj[]=$Zh;if(preg_match('~nextval\(\'([^\']+)\'\)~',$l['default'],$z)){$Lj=$z[1];$ok=first(get_rows((Connection::get()->isMinVersion("10")?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($Lj)):"SELECT * FROM $Lj"),null,"-- "));$Mj[]=($Ck=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Lj;\n":"")."CREATE SEQUENCE $Lj INCREMENT $ok[increment_by] MINVALUE $ok[min_value] MAXVALUE $ok[max_value]".($Ta&&$ok['last_value']?" START ".($ok["last_value"]+1):"")." CACHE $ok[cache_value];";}}if(!empty($Mj))$J=implode("\n\n",$Mj)."\n\n$J";$F="";foreach(indexes($R)as$kf=>$t){if($t['type']=='PRIMARY'){$F=$kf;$lj[]="CONSTRAINT ".idf_escape($kf)." PRIMARY KEY (".implode(', ',array_map('AdminNeo\idf_escape',$t['columns'])).")";}}foreach(Driver::get()->checkConstraints($R)as$Zb=>$ec)$lj[]="CONSTRAINT ".idf_escape($Zb)." CHECK $ec";$J
.=implode(",\n    ",$lj)."\n) WITH (oids = ".($zk['Oid']?'true':'false').");";if($zk['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($zk['nspname']).".".idf_escape($zk['Name'])." IS ".q($zk['Comment']).";";foreach($m
as$Ud=>$l){if($l['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($zk['nspname']).".".idf_escape($zk['Name']).".".idf_escape($Ud)." IS ".q($l['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($F?" AND indexname != ".q($F):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$zk=table_status($R);$J="";foreach(triggers($R)as$El=>$Dl){$Fl=trigger($El,$zk['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($Fl['Trigger'])." $Fl[Timing] $Fl[Event] ON ".idf_escape($zk["nspname"]).".".idf_escape($zk['Name'])." $Fl[Type] $Fl[Statement];;\n";}return$J;}function
use_sql($yc){return"\connect ".idf_escape($yc);}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(Connection::get()->isMinVersion("9.2")?"pid":"procpid"));}function
convert_field($l){}function
unconvert_field(array$l,$J){return$J;}function
support($Qd){if($Qd=="processlist")return!Connection::get()->isCockroachDB();elseif($Qd=="materializedview")return
Connection::get()->isMinVersion("9.3");elseif($Qd=="procedure")return
Connection::get()->isMinVersion("11");return
preg_match('~^(check|database|table|columns|sql|indexes|descidx|comment|view|scheme|routine|sequence|trigger|type|variables|drop_col|kill|dump)$~',$Qd);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
Connection::get()->getValue("SHOW max_connections");}}Drivers::add("mssql","MS SQL",["SQLSRV","PDO_SQLSRV","PDO_DBLIB"]);if(isset($_GET["mssql"])){define("AdminNeo\DRIVER","mssql");define("AdminNeo\DIALECT","mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){define("AdminNeo\DRIVER_EXTENSION","sqlsrv");class
MsSqlConnection
extends
Connection{private$connection;protected$multiResult;function
open($O,$V,$E){$cc=["UID"=>$V,"PWD"=>$E,"CharacterSet"=>"UTF-8",];$od=Admin::get()->getConfig()->getSslEncrypt();if($od!==null)$cc["Encrypt"]=$od;$Jl=Admin::get()->getConfig()->getSslTrustServerCertificate();if($Jl!==null)$cc["TrustServerCertificate"]=$Jl;$i=Admin::get()->getDatabase();if($i!="")$cc["Database"]=$i;$this->connection=@sqlsrv_connect(preg_replace('~:~',',',$O),$cc);if($this->connection){$of=sqlsrv_server_info($this->connection);$this->version=$of['SQLServerVersion'];}else$this->resolveError();return(bool)$this->connection;}private
function
resolveError(){$this->error="";foreach(sqlsrv_errors()as$k){$this->errno=$k["code"];$this->error
.="$k[message]\n";}$this->error=rtrim($this->error);}function
quote($Q){return(contains_unicode($Q)?"N":"")."'".str_replace("'","''",$Q)."'";}function
selectDatabase($_){return$this->query(use_sql($_));}function
query($G,$Pl=false){$I=sqlsrv_query($this->connection,$G);$this->error="";if(!$I){$this->resolveError();return
false;}return$this->storeResult($I);}function
multiQuery($G){$this->multiResult=sqlsrv_query($this->connection,$G);$this->error="";if(!$this->multiResult){$this->resolveError();return
false;}return
true;}function
storeResult($I=null){if(!$I){$I=$this->multiResult;if(!$I)return
false;}if(sqlsrv_field_metadata($I))return
new
MsSqlResult($I);$this->affectedRows=sqlsrv_rows_affected($I);return
true;}function
nextResult(){return$this->multiResult&&sqlsrv_next_result($this->multiResult);}}class
MsSqlResult
extends
Result{private$resource;private$fields=false;private$offset=0;function
__construct($gj){parent::__construct(0);$this->resource=$gj;}function
__destruct(){sqlsrv_free_stmt($this->resource);}function
fetchAssoc(){return$this->convertRow(sqlsrv_fetch_array($this->resource,SQLSRV_FETCH_ASSOC));}function
fetchRow(){return$this->convertRow(sqlsrv_fetch_array($this->resource,SQLSRV_FETCH_NUMERIC));}private
function
convertRow($K){if(is_array($K)){foreach($K
as$v=>$X){if(is_a($X,'DateTime'))$K[$v]=$X->format("Y-m-d H:i:s");}}return$K;}function
fetchField(){if(!$this->fields){$this->fields=sqlsrv_field_metadata($this->resource);if(!$this->fields)return
false;}$l=$this->fields[$this->offset++];return(object)['name'=>$l["Name"],'type'=>($l["Type"]==1?254:15),'charsetnr'=>0,];}function
seek($A){for($q=0;$q<$A;$q++){if(!sqlsrv_fetch($this->resource))return
false;}return
true;}}function
last_id($I){return
Connection::get()->getValue("SELECT SCOPE_IDENTITY()");}function
explain(Connection$f,$G){$f->query("SET SHOWPLAN_ALL ON");$J=$f->query($G);$f->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MsSqlPdoConnection
extends
PdoConnection{function
selectDatabase($_){return(bool)$this->query(use_sql($_));}function
quote($Q){return(contains_unicode($Q)?"N":"").parent::quote($Q);}function
lastInsertId(){return$this->pdo->lastInsertId();}}if(extension_loaded("pdo_sqlsrv")){define("AdminNeo\DRIVER_EXTENSION","PDO_SQLSRV");class
MsSqlConnection
extends
MsSqlPdoConnection{function
open($O,$V,$E){$B=[];$od=Admin::get()->getConfig()->getSslEncrypt();if($od!==null)$B[]="Encrypt=$od";$Jl=Admin::get()->getConfig()->getSslTrustServerCertificate();if($Jl!==null)$B[]="TrustServerCertificate=$Jl";$Ch=$B?(";".implode(";",$B)):"";return$this->dsn("sqlsrv:Server=".str_replace(":",",",$O).$Ch,$V,$E);}}}elseif(extension_loaded("pdo_dblib")){define("AdminNeo\DRIVER_EXTENSION","PDO_DBLIB");class
MsSqlConnection
extends
MsSqlPdoConnection{function
open($O,$V,$E){return$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$O)),$V,$E);}}}function
last_id($I){$f=Connection::get();return$f->lastInsertId();}function
explain(Connection$f,$G){}}class
MsSqlDriver
extends
Driver{protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->types=[lang(114)=>["tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20,],lang(115)=>["date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10,],lang(116)=>["char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823,],lang(118)=>["binary"=>8000,"varbinary"=>8000,"image"=>2147483647,],];$this->generated=["PERSISTED","VIRTUAL"];$this->operators=["=","<",">","<=",">=","!=","LIKE","LIKE %%","NOT LIKE","IN","NOT IN","IS NULL","IS NOT NULL",];$this->likeOperator="LIKE %%";$this->functions=["len","lower","upper","round",];$this->grouping=["sum","min","max","avg","count","count distinct",];$this->onActions=["CASCADE","SET NULL","SET DEFAULT","NO ACTION"];$this->editFunctions=[["date|time"=>"getdate",],["int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",]];$this->systemDatabases=["INFORMATION_SCHEMA","guest","sys","db_*"];}function
insertUpdate($R,array$Ti,array$F){$m=fields($R);$Wl=[];$Z=[];$H=reset($Ti);$d="c".implode(", c",range(1,count($H)));$kb=0;$rf=[];foreach($H
as$v=>$X){$kb++;$_=idf_unescape($v);if(!$m[$_]["auto_increment"])$rf[$v]="c$kb";if(isset($F[$_]))$Z[]="$v = c$kb";else$Wl[]="$v = c$kb";}$jm=[];foreach($Ti
as$H)$jm[]="(".implode(", ",$H).")";if($Z){$df=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$jm)."\n) AS source ($d) ON ".implode(" AND ",$Z).($Wl?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$Wl):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($df?$H:$rf)).") VALUES (".($df?$d:implode(", ",$rf)).");");if($df)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($H)).") VALUES\n".implode(",\n",$jm));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($_,$yf=false){$hg=["sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",];$x=$hg[get_schema()];if($x)return"relational-databases/system-$x".preg_replace('~_~','-',strtolower($_))."-transact-sql";return
null;}}function
create_driver(Connection$f){return
MsSqlDriver::create($f,Admin::get());}function
contains_unicode($Q){return
strlen($Q)!=strlen(utf8_decode($Q));}function
idf_escape($s){return"[".str_replace("]","]]",$s)."]";}function
table($s){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($s);}function
connect($F=false,&$k=null){$f=$F?MsSqlConnection::create():MsSqlConnection::createSecondary();$qc=Admin::get()->getCredentials();if($qc[0]=="")$qc[0]="localhost:1433";if(!$f->open($qc[0],$qc[1],$qc[2])){$k=$f->getError();return
null;}return$f;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb') ORDER BY name");}function
limit($G,$Z,$w,$A=0,$N=" "){return($w!==null?" TOP (".($w+$A).")":"")." $G$Z";}function
limit1($R,$G,$Z,$N="\n"){return
limit($G,$Z,1,0,$N);}function
db_collation($i,$Ib){return
Connection::get()->getValue("SELECT collation_name FROM sys.databases WHERE name = ".q($i));}function
logged_user(){return
Connection::get()->getValue("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($h){$J=[];foreach($h
as$i){Connection::get()->selectDatabase($i);$J[$i]=Connection::get()->getValue("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($_=""){$J=[];foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment FROM sys.all_objects AS ao WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($_!=""?"AND name = ".q($_):"ORDER BY name"))as$K){if($_!="")return$K;$J[$K["Name"]]=$K;}return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$Sb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=[];$Tk=Connection::get()->getValue("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($Tk))as$K){$U=$K["type"];$bg=(preg_match("~char|binary~",$U)?$K["max_length"]/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=["field"=>$K["name"],"full_type"=>$U.($bg?"($bg)":""),"type"=>$U,"length"=>$bg,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$y)?str_replace("''","'",$y[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>["insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1],"primary"=>$K["is_primary_key"],"comment"=>$Sb[$K["name"]],];}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($Tk))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$f=null){$J=[];foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$f)as$K){$_=$K["name"];$J[$_]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$_]["lengths"]=[];$J[$_]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$_]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($_){return["select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',Connection::get()->getValue("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($_)))];}function
collations(){$J=[];foreach(get_vals("SELECT name FROM fn_helpcollations()")as$Hb)$J[preg_replace('~_.*~','',$Hb)][]=$Hb;return$J;}function
information_schema($i){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl2br(h(preg_replace('~^(\[[^]]*])+~m','',Connection::get()->getError())));}function
create_database($i,$Hb){return
queries("CREATE DATABASE ".idf_escape($i).(preg_match('~^[a-z0-9_]+$~i',$Hb)?" COLLATE $Hb":""));}function
drop_databases($h){return
queries("DROP DATABASE ".implode(", ",array_map('AdminNeo\idf_escape',$h)));}function
rename_database($_,$Hb){if(preg_match('~^[a-z0-9_]+$~i',$Hb))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $Hb");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($_));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){$b=[];$Sb=[];$Lh=fields($R);foreach($m
as$l){$c=idf_escape($l[0]);$X=$l[1];if(!$X)$b["DROP"][]=" COLUMN $c";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$Sb[$l[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($l[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($ke[$X[0]],16+strlen($X[0])):"");else{$j=$X[3];unset($X[3]);unset($X[6]);if($c!=$X[0])queries("EXEC sp_rename ".q(table($R).".$c").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$Kh=$Lh[$l[0]];if(default_value($Kh)!=$j){if($Kh["default"]!==null)$b["DROP"][]=" ".idf_escape($Kh["default_constraint"]);if($j)$b["ADD"][]="\n $j FOR $c";}}}}if($R=="")return
queries("CREATE TABLE ".table($_)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$_)queries("EXEC sp_rename ".q(table($R)).", ".q($_));if($ke)$b[""]=$ke;foreach($b
as$v=>$X){if(!queries("ALTER TABLE ".table($_)." $v".implode(",",$X)))return
false;}foreach($Sb
as$v=>$X){$Qb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($_).", @level2type = N'Column', @level2name = ".q($v));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$Qb.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($_).", @level2type = N'Column', @level2name = ".q($v));}return
true;}function
alter_indexes($R,$b){$t=[];$Xc=[];foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$Xc[]=idf_escape($X[1]);else$t[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$t||queries("DROP INDEX ".implode(", ",$t)))&&(!$Xc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$Xc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=[];$vh=Driver::get()->getOnActions();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$p=&$J[$K["FK_NAME"]];$p["db"]=$K["PKTABLE_QUALIFIER"];$p["ns"]=$K["PKTABLE_OWNER"];$p["table"]=$K["PKTABLE_NAME"];$p["on_update"]=$vh[$K["UPDATE_RULE"]];$p["on_delete"]=$vh[$K["DELETE_RULE"]];$p["source"][]=$K["FKCOLUMN_NAME"];$p["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
backward_keys($R){$G="SELECT fk.name AS constraint_name,
OBJECT_SCHEMA_NAME(fkc.parent_object_id) AS table_schema,
OBJECT_NAME(fkc.parent_object_id) AS table_name,
COL_NAME(fkc.parent_object_id, fkc.parent_column_id) AS column_name,
COL_NAME(fkc.referenced_object_id, fkc.referenced_column_id) AS referenced_column_name
FROM sys.foreign_key_columns fkc
JOIN sys.foreign_keys fk ON fkc.constraint_object_id = fk.object_id
WHERE OBJECT_SCHEMA_NAME(fkc.referenced_object_id) = ".q($_GET["ns"])."
AND OBJECT_NAME(fkc.referenced_object_id) = ".q($R)."
ORDER BY table_schema, table_name";return
get_rows($G,null,"");}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($qm){return
queries("DROP VIEW ".implode(", ",array_map('AdminNeo\table',$qm)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('AdminNeo\table',$T)));}function
move_tables($T,$qm,$el){return
apply_queries("ALTER SCHEMA ".idf_escape($el)." TRANSFER",array_merge($T,$qm));}function
trigger($_){if($_=="")return[];$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($_));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=[];foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=[$K["Timing"],$K["Event"]];return$J;}function
trigger_options(){return["Timing"=>["AFTER","INSTEAD OF"],"Event"=>["INSERT","UPDATE","DELETE"],"Type"=>["AS"],];}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
Connection::get()->getValue("SELECT SCHEMA_NAME()");}function
set_schema($xj,$f=null){$_GET["ns"]=$xj;return
true;}function
create_sql($R,$Ta,$Ck){if(is_view(table_status($R))){$om=view($R);return"CREATE VIEW ".table($R)." AS $om[select]";}$m=[];$F=false;foreach(fields($R)as$_=>$l){$X=process_field($l,$l);if($X[6])$F=true;$m[]=implode("",$X);}foreach(indexes($R)as$_=>$t){if(!$F||$t["type"]!="PRIMARY"){$d=[];foreach($t["columns"]as$v=>$X)$d[]=idf_escape($X).($t["descs"][$v]?" DESC":"");$_=idf_escape($_);$m[]=($t["type"]=="INDEX"?"INDEX $_":"CONSTRAINT $_ ".($t["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$d).")";}}foreach(Driver::get()->checkConstraints($R)as$_=>$tb)$m[]="CONSTRAINT ".idf_escape($_)." CHECK ($tb)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$m)."\n)";}function
foreign_keys_sql($R){$m=[];foreach(foreign_keys($R)as$ke)$m[]=ltrim(format_foreign_key($ke));return($m?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$m).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($yc){return"USE ".idf_escape($yc);}function
trigger_sql($R){$J="";foreach(triggers($R)as$_=>$Fl)$J
.=create_trigger(" ON ".table($R),trigger($_)).";";return$J;}function
convert_field($l){}function
unconvert_field(array$l,$J){return$J;}function
support($Qd){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Qd);}}Drivers::add("sqlite","SQLite",["SQLite3","PDO_SQLite"]);if(isset($_GET["sqlite"])){define("AdminNeo\DRIVER","sqlite");define("AdminNeo\DIALECT","sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){define("AdminNeo\DRIVER_EXTENSION","SQLite3");abstract
class
SqLiteConnectionBase
extends
Connection{private$sqlite;function
open($O,$V,$E){$this->sqlite=new
SQLite3($O);$this->version=$this->sqlite->version()["versionString"];return
true;}function
query($G,$Pl=false){$I=@$this->sqlite->query($G);$this->error="";if(!$I){$this->errno=$this->sqlite->lastErrorCode();$this->error=$this->sqlite->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
SqLiteResult($I);$this->affectedRows=$this->sqlite->changes();return
true;}function
quote($Q){if(is_utf8($Q))return"'".$this->sqlite->escapeString($Q)."'";else
return"x'".first(unpack('H*',$Q))."'";}}class
SqLiteResult
extends
Result{private$resource;private$offset=0;function
__construct(SQLite3Result$gj){parent::__construct(0);$this->resource=$gj;}function
__destruct(){return$this->resource->finalize();}function
fetchAssoc(){return$this->resource->fetchArray(SQLITE3_ASSOC);}function
fetchRow(){return$this->resource->fetchArray(SQLITE3_NUM);}function
fetchField(){$c=$this->offset++;$U=$this->resource->columnType($c);if($U===false)return
false;return(object)["name"=>$this->resource->columnName($c),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),];}}}elseif(extension_loaded("pdo_sqlite")){define("AdminNeo\DRIVER_EXTENSION","PDO_SQLite");abstract
class
SqLiteConnectionBase
extends
PdoConnection{function
open($O,$V,$E){return$this->dsn(DRIVER.":$O","","");}}}if(class_exists('AdminNeo\SqLiteConnectionBase')){class
SqLiteConnection
extends
SqLiteConnectionBase{protected
function
__construct(){parent::__construct();$this->open(":memory:","","");}function
open($O,$V,$E){if(!parent::open($O,$V,$E))return
false;$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}function
close(){$this->open(":memory:","","");}function
selectDatabase($_){if(is_readable($_)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$_)?$_:dirname($_SERVER["SCRIPT_FILENAME"])."/$_")." AS a"))return
self::open($_,"","");return
false;}}}class
SqliteDriver
extends
Driver{protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->types=[["integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0,]];if($f->isMinVersion("3.31"))$this->generated=["STORED","VIRTUAL"];$this->operators=["=","<",">","<=",">=","!=","LIKE","LIKE %%","NOT LIKE","IN","NOT IN","IS NULL","IS NOT NULL","SQL",];$this->likeOperator="LIKE %%";$this->functions=["length","lower","upper","round","hex","unixepoch",];$this->grouping=["sum","min","max","avg","count","count distinct","group_concat",];$this->editFunctions=[[],["integer|real|numeric"=>"+/-","text"=>"||",]];}function
getStructuredTypes(){return
parent::getStructuredTypes()[0];}function
insertUpdate($R,array$Ti,array$F){$jm=[];foreach($Ti
as$H)$jm[]="(".implode(", ",$H).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($Ti))).") VALUES\n".implode(",\n",$jm));}function
tableHelp($_,$yf=false){if($_=="sqlite_sequence")return"fileformat2.html#seqtab";if($_=="sqlite_master")return"fileformat2.html#$_";return
null;}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',$this->connection->getValue("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R)),$z);return
array_combine($z[2],$z[2]);}function
getAllFields(){$Fa=[];foreach(tables_list()as$R=>$U){foreach(fields($R)as$l)$Fa[$R][]=$l;}return$Fa;}}function
create_driver(Connection$f){return
SqliteDriver::create($f,Admin::get());}function
idf_escape($s){return'"'.str_replace('"','""',$s).'"';}function
table($s){return
idf_escape($s);}function
connect($F=false,&$k=null){$f=$F?SqLiteConnection::create():SqLiteConnection::createSecondary();$E=Admin::get()->getCredentials()[2];if($E!=""){$I=Admin::get()->verifyDefaultPassword($E);if($I!==true){$k=$I;return
null;}}return$f;}function
get_databases(){return[];}function
limit($G,$Z,$w,$A=0,$N=" "){return" $G$Z".($w!==null?$N."LIMIT $w".($A?" OFFSET $A":""):"");}function
limit1($R,$G,$Z,$N="\n"){return(preg_match('~^INTO~',$G)||Connection::get()->getValue("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($G,$Z,1,0,$N):" $G WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$N."LIMIT 1)");}function
db_collation($i,$Ib){return
Connection::get()->getValue("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($h){return[];}function
table_status($_=""){$J=[];foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($_!=""?"AND name = ".q($_):"ORDER BY name"))as$K){$K["Rows"]=Connection::get()->getValue("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return($_!=""?$J[$_]:$J);}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!Connection::get()->getValue("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=[];$F="";foreach(get_rows("PRAGMA table_".(Connection::get()->isMinVersion("3.31")?"x":"")."info(".table($R).")")as$K){$_=$K["name"];$U=strtolower($K["type"]);$j=$K["dflt_value"];$J[$_]=["field"=>$_,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$j,$y)?str_replace("''","'",$y[1]):($j=="NULL"?null:$j)),"null"=>!$K["notnull"],"privileges"=>["select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1],"primary"=>$K["pk"],];if($K["pk"]){if($F!="")$J[$F]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$_]["auto_increment"]=true;$F=$_;}}$pk=Connection::get()->getValue("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$s='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$s.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$pk,$z,PREG_SET_ORDER);foreach($z
as$y){$_=str_replace('""','"',preg_replace('~^"|"$~','',$y[1]));if($J[$_])$J[$_]["collation"]=trim($y[3],"'");}preg_match_all('~'.$s.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$pk,$z,PREG_SET_ORDER);foreach($z
as$y){$_=str_replace('""','"',preg_replace('~^"|"$~','',$y[1]));$J[$_]["default"]=$y[3];$J[$_]["generated"]=strtoupper($y[4]);}return$J;}function
indexes($R,$f=null){if(!is_object($f))$f=Connection::get();$J=[];$pk=$f->getValue("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$pk,$y)){$J[""]=["type"=>"PRIMARY","columns"=>[],"lengths"=>[],"descs"=>[]];preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$y[1],$z,PREG_SET_ORDER);foreach($z
as$y){$J[""]["columns"][]=idf_unescape($y[2]).$y[4];$J[""]["descs"][]=(preg_match('~DESC~i',$y[5])?'1':null);}}if(!$J){foreach(fields($R)as$_=>$l){if($l["primary"])$J[""]=["type"=>"PRIMARY","columns"=>[$_],"lengths"=>[],"descs"=>[null]];}}$tk=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$f);foreach(get_rows("PRAGMA index_list(".table($R).")",$f)as$K){$_=$K["name"];$t=["type"=>($K["unique"]?"UNIQUE":"INDEX")];$t["lengths"]=[];$t["descs"]=[];foreach(get_rows("PRAGMA index_info(".idf_escape($_).")",$f)as$sj){$t["columns"][]=$sj["name"];$t["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($_).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$tk[$_],$bj)){preg_match_all('/("[^"]*+")+( DESC)?/',$bj[2],$z);foreach($z[2]as$v=>$X){if($X)$t["descs"][$v]='1';}}if(!$J[""]||$t["type"]!="UNIQUE"||$t["columns"]!=$J[""]["columns"]||$t["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$_))$J[$_]=$t;}return$J;}function
foreign_keys($R){$J=[];foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$p=&$J[$K["id"]];if(!$p)$p=$K;$p["source"][]=$K["from"];$p["target"][]=$K["to"];}return$J;}function
backward_keys($R){return[];}function
view($_){return["select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',Connection::get()->getValue("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($_)))];}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):[]);}function
information_schema($i){return
false;}function
error(){return
h(Connection::get()->getError());}function
check_sqlite_name($_){$Ld="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Ld)\$~",$_)){Connection::get()->setError(lang(121,str_replace("|",", ",$Ld)));return
false;}return
true;}function
create_database($i,$Hb){if(file_exists($i)){Connection::get()->setError(lang(122));return
false;}if(!check_sqlite_name($i))return
false;try{$x=SqLiteConnection::createSecondary();$x->open($i,"","");}catch(Exception$zd){Connection::get()->setError($zd->getMessage());return
false;}$x->query('PRAGMA encoding = "UTF-8"');$x->query('CREATE TABLE adminneo (i)');$x->query('DROP TABLE adminneo');return
true;}function
drop_databases($h){Connection::get()->close();foreach($h
as$i){if(!@unlink($i)){Connection::get()->setError(lang(122));return
false;}}return
true;}function
rename_database($_,$Hb){if(!check_sqlite_name($_))return
false;Connection::get()->close();Connection::get()->setError(lang(122));return@rename(DB,$_);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){$bm=($R==""||$ke);foreach($m
as$l){if($l[0]!=""||!$l[1]||$l[2]){$bm=true;break;}}$Ja=[];$Ph=[];foreach($m
as$l){if(!$l[1])continue;if($l[0]!="")$Ph[$l[0]]=$l[1][0];$Ja[]=($bm?$l[1]:"ADD ".implode($l[1]));}if(!$bm){foreach($Ja
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$_&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($_)))return
false;}elseif(!recreate_table($R,$_,$Ja,$Ph,$ke,$Ta))return
false;if($Ta){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ta WHERE name = ".q($_));if(!Connection::get()->getAffectedRows())queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($_).", $Ta)");queries("COMMIT");}return
true;}function
recreate_table($R,$_,$m,$Ph,$ke,$Ta=0,$u=[],$Yc="",$va=""){if($R!=""){if(!$m){foreach(fields($R)as$v=>$l){if($u)$l["auto_increment"]=0;$m[]=process_field($l,$l);$Ph[$v]=idf_escape($v);}}$Bi=false;foreach($m
as$l){if($l[6])$Bi=true;}$ad=[];foreach($u
as$v=>$X){if($X[2]=="DROP"){$ad[$X[1]]=true;unset($u[$v]);}}foreach(indexes($R)as$Mf=>$t){$d=[];foreach($t["columns"]as$v=>$c){if(!isset($Ph[$c]))continue
2;$d[]=$Ph[$c].($t["descs"][$v]?" DESC":"");}if(!$ad[$Mf]){if($t["type"]!="PRIMARY"||!$Bi){$Mf=preg_replace('~^sqlite_~',"",$Mf);$u[]=[$t["type"],$Mf,$d];}}}foreach($u
as$v=>$X){if($X[0]=="PRIMARY"){unset($u[$v]);$ke[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$Mf=>$p){foreach($p["source"]as$v=>$c){if(!$Ph[$c])continue
2;$p["source"][$v]=idf_unescape($Ph[$c]);}if(!isset($ke[" $Mf"]))$ke[]=" ".format_foreign_key($p);}queries("BEGIN");}foreach($m
as$v=>$l){if(preg_match('~GENERATED~',$l[3]))unset($Ph[array_search($l[0],$Ph)]);$m[$v]="  ".implode($l);}$m=array_merge($m,array_filter($ke));foreach(Driver::get()->checkConstraints($R)as$tb){if($tb!=$Yc)$m[]="  CHECK ($tb)";}if($va)$m[]="  CHECK ($va)";$gl=($R==$_?"adminneo_$_":$_);if(!queries("CREATE TABLE ".table($gl)." (\n".implode(",\n",$m)."\n)"))return
false;if($R!=""){if($Ph&&!queries("INSERT INTO ".table($gl)." (".implode(", ",$Ph).") SELECT ".implode(", ",array_map('AdminNeo\idf_escape',array_keys($Ph)))." FROM ".table($R)))return
false;$Il=[];foreach(triggers($R)as$Gl=>$rl){$Fl=trigger($Gl);$Il[]="CREATE TRIGGER ".idf_escape($Gl)." ".implode(" ",$rl)." ON ".table($_)."\n$Fl[Statement]";}$Ta=$Ta?0:Connection::get()->getValue("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$_&&!queries("ALTER TABLE ".table($gl)." RENAME TO ".table($_)))||!alter_indexes($_,$u))return
false;if($Ta)queries("UPDATE sqlite_sequence SET seq = $Ta WHERE name = ".q($_));foreach($Il
as$Fl){if(!queries($Fl))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$_,$d){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($_!=""?$_:uniqid($R."_"))." ON ".table($R)." $d";}function
alter_indexes($R,$b){foreach($b
as$t){if($t[0]=="PRIMARY"||(preg_match('~^sqlite_~',$t[1])))return
recreate_table($R,$R,[],[],[],0,$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($qm){return
apply_queries("DROP VIEW",$qm);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$qm,$el){return
false;}function
trigger($_){if($_=="")return["Statement"=>"BEGIN\n\t;\nEND"];$s='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Hl=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$s\\s*(".implode("|",$Hl["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($s))?\\s+ON\\s*$s\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",Connection::get()->getValue("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($_)),$y);$nh=$y[3];return["Timing"=>strtoupper($y[1]),"Event"=>strtoupper($y[2]).($nh?" OF":""),"Of"=>idf_unescape($nh),"Trigger"=>$_,"Statement"=>$y[4],];}function
triggers($R){$J=[];$Hl=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Hl["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$y);$J[$K["name"]]=[$y[1],$y[2]];}return$J;}function
trigger_options(){return["Timing"=>["BEFORE","AFTER","INSTEAD OF"],"Event"=>["INSERT","UPDATE","UPDATE OF","DELETE"],"Type"=>["FOR EACH ROW"],];}function
begin(){return
queries("BEGIN");}function
last_id($I){return
Connection::get()->getValue("SELECT LAST_INSERT_ROWID()");}function
explain(Connection$f,$G){return$f->query("EXPLAIN QUERY PLAN $G");}function
found_rows($S,$Z){}function
types(){return[];}function
create_sql($R,$Ta,$Ck){$J=Connection::get()->getValue("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$_=>$t){if($_==''||strpos($_,"sqlite_")===0)continue;$J
.=";\n\n".index_sql($R,$t['type'],$_,"(".implode(", ",array_map('AdminNeo\idf_escape',$t['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($yc){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=[];foreach(get_rows("PRAGMA pragma_list")as$K){$_=$K["name"];if($_!="pragma_list"&&$_!="compile_options"){$J[$_]=[$_,''];foreach(get_rows("PRAGMA $_")as$tj)$J[$_][1].=implode(", ",$tj)."\n";}}return$J;}function
show_status(){$J=[];foreach(get_vals("PRAGMA compile_options")as$Bh)$J[]=explode("=",$Bh,2);return$J;}function
convert_field($l){}function
unconvert_field(array$l,$J){return$J;}function
support($Qd){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Qd);}}Drivers::add("oracle","Oracle (beta)",["OCI8","PDO_OCI"]);if(isset($_GET["oracle"])){define("AdminNeo\DRIVER","oracle");define("AdminNeo\DIALECT","oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){define("AdminNeo\DRIVER_EXTENSION","oci8");class
OracleConnection
extends
Connection{private$connection;private$dbName=null;function
open($O,$V,$E){$this->connection=@oci_new_connect($V,$E,$O,"AL32UTF8");if($this->connection){$this->version=oci_server_version($this->connection);return
true;}$k=oci_error();$this->error=$k["message"];return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
selectDatabase($_){$this->dbName=$_;return
true;}function
getAndClearDbName(){$_=$this->dbName?:DB;$this->dbName=null;return$_;}function
query($G,$Pl=false){$I=oci_parse($this->connection,$G);$this->error="";if(!$I){$k=oci_error($this->connection);$this->errno=$k["code"];$this->error=$k["message"];return
false;}set_error_handler(function($ud,$k){if(ini_bool("html_errors"))$k=html_entity_decode(strip_tags($k));$k=preg_replace('~^[^:]*: ~','',$k);$this->error=$k;});$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
OracleResult($I);$this->affectedRows=oci_num_rows($I);oci_free_statement($I);}return$J;}function
getValue($G,$Rd=0){$I=$this->query($G);return
is_object($I)?$I->fetchValue($Rd):false;}}class
OracleResult
extends
Result{private$resource;private$offset=1;function
__construct($I){parent::__construct(0);$this->resource=$I;}function
__destruct(){oci_free_statement($this->resource);}function
fetchAssoc(){return$this->convertRow(oci_fetch_assoc($this->resource));}function
fetchRow(){return$this->convertRow(oci_fetch_row($this->resource));}function
fetchValue($Rd){return
oci_fetch($this->resource)?oci_result($this->resource,$Rd+1):false;}private
function
convertRow($K){if(is_array($K)){foreach($K
as$v=>$X){if(is_a($X,'OCI-Lob'))$K[$v]=$X->load();}}return$K;}function
fetchField(){$c=$this->offset++;$_=oci_field_name($this->resource,$c);if($_===false)return
false;$U=oci_field_type($this->resource,$c);if($U===false)return
false;return(object)['name'=>$_,'type'=>$U,'charsetnr'=>(preg_match("~raw|blob|bfile~",$U)?63:0),];}}}elseif(extension_loaded("pdo_oci")){define("AdminNeo\DRIVER_EXTENSION","PDO_OCI");class
OracleConnection
extends
PdoConnection{private$dbName=null;function
open($O,$V,$E){return$this->dsn("oci:dbname=//$O;charset=AL32UTF8",$V,$E);}function
selectDatabase($_){$this->dbName=$_;return
true;}function
getAndClearDbName(){$_=$this->dbName?:DB;$this->dbName=null;return$_;}}}class
OracleDriver
extends
Driver{protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->types=[lang(114)=>["number"=>38,"binary_float"=>12,"binary_double"=>21,],lang(115)=>["date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28,],lang(116)=>["char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295,],lang(118)=>["raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296,],];$this->operators=["=","<",">","<=",">=","!=","LIKE","LIKE %%","NOT LIKE","IN","NOT IN","IS NULL","IS NOT NULL","SQL",];$this->likeOperator="LIKE %%";$this->functions=["length","lower","upper","round",];$this->grouping=["sum","min","max","avg","count","count distinct",];$this->editFunctions=[["date"=>"current_date","timestamp"=>"current_timestamp",],["number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",]];}function
begin(){return
true;}function
insertUpdate($R,array$Ti,array$F){foreach($Ti
as$H){$Wl=[];$Z=[];foreach($H
as$v=>$X){$Wl[]="$v = $X";if(isset($F[idf_unescape($v)]))$Z[]="$v = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Wl)." WHERE ".implode(" AND ",$Z))&&Connection::get()->getAffectedRows())||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($H)).") VALUES (".implode(", ",$H).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
create_driver(Connection$f){return
OracleDriver::create($f,Admin::get());}function
is_server_host_valid($Ze){return(bool)preg_match('~^[^/]+(/([^/:]+)?(:[^/:]+)?(/[^/:]+)?)?$~',$Ze);}function
idf_escape($s){return'"'.str_replace('"','""',$s).'"';}function
table($s){return
idf_escape($s);}function
connect($F=false,&$k=null){$f=$F?OracleConnection::create():OracleConnection::createSecondary();$qc=Admin::get()->getCredentials();if(!$f->open($qc[0],$qc[1],$qc[2])){$k=$f->getError();return
null;}return$f;}function
get_databases(){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($G,$Z,$w,$A=0,$N=" "){return($A?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $G$Z) t WHERE rownum <= ".($w+$A).") WHERE rnum > $A":($w!==null?" * FROM (SELECT $G$Z) WHERE rownum <= ".($w+$A):" $G$Z"));}function
limit1($R,$G,$Z,$N="\n"){return" $G$Z";}function
db_collation($i,$Ib){return
Connection::get()->getValue("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
Connection::get()->getValue("SELECT USER FROM DUAL");}function
where_owner($zi,$Th="owner"){if(!$_GET["ns"])return'';return"$zi$Th = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($d){$Th=where_owner('');return"(SELECT $d FROM all_views WHERE ".($Th?:"rownum < 0").")";}function
tables_list(){$om=views_table("view_name");$Th=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$Th
UNION SELECT view_name, 'view' FROM $om
ORDER BY 1");}function
count_tables($h){$J=[];foreach($h
as$i)$J[$i]=Connection::get()->getValue("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($i));return$J;}function
table_status($_=""){$J=[];$_j=q($_);$i=Connection::get()->getAndClearDbName();$om=views_table("view_name");$Th=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($i).$Th.($_!=""?" AND table_name = $_j":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $om".($_!=""?" WHERE view_name = $_j":"")."
ORDER BY 1")as$K){if($_!="")return$K;$J[$K["Name"]]=$K;}return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=[];$Th=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$Th ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$bg="$K[DATA_PRECISION],$K[DATA_SCALE]";if($bg==",")$bg=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=["field"=>$K["COLUMN_NAME"],"full_type"=>$U.($bg?"($bg)":""),"type"=>strtolower($U),"length"=>$bg,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>["insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1],];}return$J;}function
indexes($R,$f=null){$J=[];$Th=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$Th
ORDER BY ac.constraint_type, aic.column_position",$f)as$K){$kf=$K["INDEX_NAME"];$Nb=$K["DATA_DEFAULT"];$Nb=($Nb?trim($Nb,'"'):$K["COLUMN_NAME"]);$J[$kf]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$kf]["columns"][]=$Nb;$J[$kf]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$kf]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($_){$om=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$om.' WHERE view_name = '.q($_));return
reset($L);}function
collations(){return[];}function
information_schema($i){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(Connection::get()->getError());}function
explain(Connection$f,$G){$f->query("EXPLAIN PLAN FOR $G");return$f->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){$b=$Xc=[];$Lh=($R?fields($R):[]);foreach($m
as$l){$X=$l[1];if($X&&$l[0]!=""&&idf_escape($l[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($l[0])." TO $X[0]");$Kh=$Lh[$l[0]];if($X&&$Kh){$ph=process_field($Kh,$Kh);if($X[2]==$ph[2])$X[2]="";}if($X)$b[]=($R!=""?($l[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$Xc[]=idf_escape($l[0]);}if($R=="")return
queries("CREATE TABLE ".table($_)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$Xc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$Xc).")"))&&($R==$_||queries("ALTER TABLE ".table($R)." RENAME TO ".table($_)));}function
alter_indexes($R,$b){$Xc=[];$Li=[];foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$nc=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($Li,"ALTER TABLE ".table($R).$nc);}elseif($X[2]=="DROP")$Xc[]=idf_escape($X[1]);else$Li[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($Xc)array_unshift($Li,"DROP INDEX ".implode(", ",$Xc));foreach($Li
as$G){if(!queries($G))return
false;}return
true;}function
foreign_keys($R){$J=[];$G="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($G)as$K)$J[$K['NAME']]=["db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>[$K['SRC_COLUMN']],"target"=>[$K['DEST_COLUMN']],"on_delete"=>$K['ON_DELETE'],"on_update"=>null,];return$J;}function
backward_keys($R){return[];}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($qm){return
apply_queries("DROP VIEW",$qm);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return$J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1");}function
get_schema(){return
Connection::get()->getValue("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($xj,$f=null){if(!$f)$f=Connection::get();return(bool)$f->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($xj));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=[];$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$v=>$X)$J[]=[$v,$X];return$J;}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($l){}function
unconvert_field(array$l,$J){return$J;}function
support($Qd){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Qd);}}Drivers::add("mongo","MongoDB (alpha)",["mongodb"]);if(isset($_GET["mongo"])){define("AdminNeo\DRIVER","mongo");define("AdminNeo\DIALECT","mongo");if(class_exists('MongoDB\Driver\Manager')){define("AdminNeo\DRIVER_EXTENSION","MongoDB");class
MongoConnection
extends
Connection{private$manager;private$dbName;function
open($O,$V,$E,$_c=null,$Ra=null){$this->version=MONGODB_VERSION;$B=[];if($V.$E!=""){$B["username"]=$V;$B["password"]=$E;}if($_c)$B["db"]=$_c;if($Ra)$B["authSource"]=$Ra;$this->manager=new
Manager($O,$B);$this->dbName=$_c?:"default";return(bool)$this->executeCommand(['ping'=>1]);}function
executeCommand(array$Ob,$ya=false){try{return$this->manager->executeCommand($ya?"admin":$this->dbName,new
Command($Ob));}catch(\MongoDB\Driver\Exception\Exception$Ad){$this->error=$Ad->getMessage();return
null;}}function
executeQuery($Xg,Query$G,$B=null){try{return$this->manager->executeQuery($Xg,$G,$B);}catch(\MongoDB\Driver\Exception\Exception$Ad){$this->error=$Ad->getMessage();return
null;}}function
executeBulkWrite($Xg,BulkWrite$ib,$mc){try{$kj=$this->manager->executeBulkWrite($Xg,$ib);$this->affectedRows=$kj->$mc();return
true;}catch(Exception$Ad){$this->error=$Ad->getMessage();return
false;}}function
query($G,$Pl=false){return
false;}function
selectDatabase($_){$this->dbName=$_;return
true;}function
getDbName(){return$this->dbName;}function
quote($Q){return$Q;}}class
MongoResult
extends
Result{private$rows;private$charset;private$offset=0;function
__construct($I){$this->rows=$this->charset=[];foreach($I
as$Cf){$K=[];foreach($Cf
as$v=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->charset[$v]=63;$K[$v]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'."$X\")":(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->getData():(is_a($X,'MongoDB\BSON\Regex')?"$X":(is_object($X)||is_array($X)?json_encode($X,256):$X)))));}$this->rows[]=$K;foreach($K
as$v=>$X){if(!isset($this->rows[0][$v]))$this->rows[0][$v]=null;}}parent::__construct(count($this->rows));}function
fetchAssoc(){$K=current($this->rows);if(!$K)return$K;$g=[];foreach($this->rows[0]as$v=>$X)$g[$v]=$K[$v];next($this->rows);return$g;}function
fetchRow(){$g=$this->fetchAssoc();if(!$g)return$g;return
array_values($g);}function
fetchField(){$Nf=array_keys($this->rows[0]);$_=$Nf[$this->offset++];return(object)['name'=>$_,'type'=>15,'charsetnr'=>$this->charset[$_],];}}}class
MongoDriver
extends
Driver{var$primary="_id";protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->operators=["=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",];$this->likeOperator="LIKE %%";$this->regexpOperator="regex";$this->editFunctions=[["json"]];$this->systemDatabases=["admin","config","local"];}function
select($R,array$M,array$Z,array$De,array$Eh=[],$w=1,$C=0,$Ci=false){$M=($M==["*"]?[]:array_fill_keys($M,1));if(count($M)&&!isset($M['_id']))$M['_id']=0;$Z=where_to_query($Z);$jk=[];foreach($Eh
as$X){$X=preg_replace('~ DESC$~','',$X,1,$lc);$jk[$X]=($lc?-1:1);}$w=min(200,max(1,(int)$w));$gk=$C*$w;$G=new
Query($Z,['projection'=>$M,'limit'=>$w,'skip'=>$gk,'sort'=>$jk]);try{return
new
MongoResult(Connection::get()->executeQuery(Connection::get()->getDbName().".$R",$G));}catch(Exception$ed){Connection::get()->setError($ed->getMessage());return
false;}}function
update($R,array$H,$Oi,$w=0,$N="\n"){$i=Connection::get()->getDbName();$Z=sql_query_where_parser($Oi);$ib=new
BulkWrite([]);if(isset($H['_id']))unset($H['_id']);$dj=[];foreach($H
as$v=>$Y){if($Y=='NULL'){$dj[$v]=1;unset($H[$v]);}}$Wl=['$set'=>$H];if(count($dj))$Wl['$unset']=$dj;$ib->update($Z,$Wl,['upsert'=>false]);return
Connection::get()->executeBulkWrite("$i.$R",$ib,'getModifiedCount');}function
delete($R,$Oi,$w=0){$ib=new
BulkWrite([]);$ib->delete(sql_query_where_parser($Oi),['limit'=>$w]);return
Connection::get()->executeBulkWrite(Connection::get()->getDbName().".$R",$ib,'getDeletedCount');}function
insert($R,array$H){if($H['_id']=='')unset($H['_id']);$ib=new
BulkWrite([]);$ib->insert($H);return
Connection::get()->executeBulkWrite(Connection::get()->getDbName().".$R",$ib,'getInsertedCount');}}function
create_driver(Connection$f){return
MongoDriver::create($f,Admin::get());}function
get_databases($ie){$uc=Connection::get()->executeCommand(['listDatabases'=>1],true);if(!$uc)return[];$h=[];foreach($uc
as$Bc){foreach($Bc->databases
as$i)$h[]=$i->name;}return$h;}function
count_tables($h){$J=[];return$J;}function
tables_list(){$uc=Connection::get()->executeCommand(['listCollections'=>1]);if(!$uc)return[];$Jb=[];foreach($uc
as$I)$Jb[$I->name]='table';return$Jb;}function
drop_databases($h){return
false;}function
indexes($R,$f=null){$uc=Connection::get()->executeCommand(['listIndexes'=>$R]);if(!$uc)return[];$u=[];foreach($uc
as$t){$Lc=[];$d=[];foreach(get_object_vars($t->key)as$c=>$U){$Lc[]=($U==-1?'1':null);$d[]=$c;}$u[$t->name]=["type"=>($t->name=="_id_"?"PRIMARY":(isset($t->unique)?"UNIQUE":"INDEX")),"columns"=>$d,"lengths"=>[],"descs"=>$Lc,];}return$u;}function
fields($R){$m=fields_from_edit();if(!$m){$I=Driver::get()->select($R,["*"],[],[],[],10);if($I){while($K=$I->fetchAssoc()){foreach($K
as$v=>$X){$K[$v]=null;$m[$v]=["field"=>$v,"type"=>"string","null"=>($v!=Driver::get()->primary),"auto_increment"=>($v==Driver::get()->primary),"privileges"=>["insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1,],];}}}}return$m;}function
found_rows($S,$Z){$Z=where_to_query($Z);$uc=Connection::get()->executeCommand(['count'=>$S['Name'],'query'=>$Z]);if(!$uc)return
0;return$uc->toArray()[0]->n;}function
sql_query_where_parser($Oi){$Oi=preg_replace('~^\s*WHERE\s*~',"",$Oi);while($Oi[0]=="(")$Oi=preg_replace('~^\((.*)\)$~',"$1",$Oi);$Cm=explode(' AND ',$Oi);$Dm=explode(') OR (',$Oi);$Z=[];foreach($Cm
as$Am)$Z[]=trim($Am);if(count($Dm)==1)$Dm=[];elseif(count($Dm)>1)$Z=[];return
where_to_query($Z,$Dm);}function
where_to_query($zm=[],$_m=[]){$g=[];foreach(['and'=>$zm,'or'=>$_m]as$U=>$Z){if(is_array($Z)){foreach($Z
as$Id){list($Fb,$yh,$X)=explode(" ",$Id,3);if($Fb=="_id"&&preg_match('~^(MongoDB\\\\BSON\\\\ObjectID)\("(.+)"\)$~',$X,$y)){list(,$Cb,$X)=$y;$X=new$Cb($X);}if(!in_array($yh,Admin::get()->getOperators()))continue;if(preg_match('~^\(f\)(.+)~',$yh,$y)){$X=(float)$X;$yh=$y[1];}elseif(preg_match('~^\(date\)(.+)~',$yh,$y)){$zc=new
DateTime($X);$X=new
BSON\UTCDatetime($zc->getTimestamp()*1000);$yh=$y[1];}switch($yh){case'=':$yh='$eq';break;case'!=':$yh='$ne';break;case'>':$yh='$gt';break;case'<':$yh='$lt';break;case'>=':$yh='$gte';break;case'<=':$yh='$lte';break;case'regex':$yh='$regex';break;default:continue
2;}if($U=='and')$g['$and'][]=[$Fb=>[$yh=>$X]];elseif($U=='or')$g['$or'][]=[$Fb=>[$yh=>$X]];}}}return$g;}function
table($s){return$s;}function
idf_escape($s){return$s;}function
table_status($_="",$Pd=false){$J=[];foreach(tables_list()as$R=>$U){$J[$R]=["Name"=>$R];if($_==$R)return$J[$R];}return$J;}function
create_database($i,$Hb){return
true;}function
last_id($I){return
0;}function
error(){return
h(Connection::get()->getError());}function
collations(){return[];}function
logged_user(){$qc=Admin::get()->getCredentials();return$qc[1];}function
connect($F=false,&$k=null){$f=$F?MongoConnection::create():MongoConnection::createSecondary();list($O,$V,$E)=Admin::get()->getCredentials();if($O=="")$O="localhost:27017";$_c=Admin::get()->getDatabase();$Ra=getenv("MONGO_AUTH_SOURCE")?:null;if(!$f->open("mongodb://$O",$V,$E,$_c,$Ra)){$k=$f->getError();return
null;}return$f;}function
alter_indexes($R,$b){foreach($b
as$X){list($U,$_,$Yj)=$X;if($Yj=="DROP")$uc=Connection::get()->executeCommand(["dropIndexes"=>$R,"index"=>$_]);else{$d=[];foreach($Yj
as$c){$c=preg_replace('~ DESC$~','',$c,1,$lc);$d[$c]=$lc?-1:1;}$Ob=["createIndexes"=>$R,"indexes"=>[["key"=>$d,"name"=>$_,"unique"=>$U=="UNIQUE",]],];$uc=Connection::get()->executeCommand($Ob);}if(!$uc)return
false;}return
true;}function
support($Qd){return
preg_match("~database|indexes|descidx~",$Qd);}function
db_collation($i,$Ib){}function
information_schema(){}function
is_view($S){}function
convert_field($l){}function
unconvert_field(array$l,$J){return$J;}function
foreign_keys($R){return[];}function
backward_keys($R){return[];}function
fk_support($S){}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){if($R=="")return(bool)Connection::get()->executeCommand(["create"=>$_]);return
false;}function
drop_tables($T){foreach($T
as$_){if(!Connection::get()->executeCommand(["drop"=>$_]))return
false;}return
true;}function
truncate_tables($T){foreach($T
as$_){$Ob=["delete"=>$_,"deletes"=>[["q"=>(object)[],"limit"=>0,]],];if(!Connection::get()->executeCommand($Ob))return
false;}return
true;}}Drivers::add("elastic","Elasticsearch 7 (beta)",["json + allow_url_fopen"]);if(isset($_GET["elastic"])){define("AdminNeo\DRIVER","elastic");define("AdminNeo\DIALECT","elastic");if(ini_bool('allow_url_fopen')){define("AdminNeo\ELASTIC_DB_NAME","elastic");define("AdminNeo\DRIVER_EXTENSION","JSON");class
ElasticConnection
extends
Connection{private$serviceUrl;function
rootQuery($ji,$gc=null,$Kg='GET'){$B=['http'=>['method'=>$Kg,'content'=>$gc!==null?json_encode($gc):null,'header'=>$gc!==null?'Content-Type: application/json':[],'ignore_errors'=>1,'follow_location'=>0,'max_redirects'=>0,],];$Jl=Admin::get()->getConfig()->getSslTrustServerCertificate();if($Jl)$B["ssl"]=["verify_peer"=>false];$n=@file_get_contents("$this->serviceUrl/".ltrim($ji,'/'),false,stream_context_create($B));if($n===false){$this->error=lang(3);return
false;}$J=json_decode($n,true);if($J===null){$this->error=lang(3);return
false;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){if(isset($J['error']['root_cause'][0]['type']))$this->error=$J['error']['root_cause'][0]['type'].": ".$J['error']['root_cause'][0]['reason'];elseif(isset($J['status'])&&isset($J['error'])&&is_string($J['error']))$this->error=$J['error'];return
false;}return$J;}function
query($G,$Pl=false){return
false;}function
sendRequest($ji,$gc=null,$Kg='GET'){if($ji!=""&&$ji[0]=="S"&&preg_match('/SELECT 1 FROM ([^ ]+) WHERE (.+) LIMIT ([0-9]+)/',$ji,$z)){$Z=explode(" AND ",$z[2]);return
Driver::get()->select($z[1],["*"],$Z,[],[],$z[3]);}return$this->rootQuery($ji,$gc,$Kg);}function
open($O,$V,$E){$this->serviceUrl=build_http_url($O,$V,$E,"localhost",9200);if(!$this->serviceUrl){$this->error=lang(3);return
false;}$J=$this->sendRequest('');if(!$J)return
false;if(!isset($J['version']['number'])){$this->error=lang(3);return
false;}$this->version=$J['version']['number'];return
true;}function
selectDatabase($_){return
true;}function
quote($Q){return$Q;}}class
ElasticResult
extends
Result{private$rows;function
__construct(array$L){parent::__construct(count($L));$this->rows=$L;reset($this->rows);}function
fetchAssoc(){$J=current($this->rows);next($this->rows);return$J;}function
fetchRow(){$K=$this->fetchAssoc();return$K?array_values($K):false;}function
fetchField(){return
false;}}}class
ElasticDriver
extends
Driver{protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->types=[lang(114)=>["long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21,"boolean"=>1,],lang(115)=>["date"=>10,],lang(116)=>["string"=>65535,"text"=>65535,"keyword"=>65535,],lang(118)=>["binary"=>255,],];$this->operators=["must(term)","must(match)","must(regexp)","should(term)","should(match)","should(regexp)","must_not(term)","must_not(match)","must_not(regexp)",];$this->likeOperator="should(match)";$this->regexpOperator="should(regexp)";$this->editFunctions=[["json"]];}function
select($R,array$M,array$Z,array$De,array$Eh=[],$w=1,$C=0,$Ci=false){$g=[];if($M!=["*"])$g["fields"]=array_values($M);if($Eh){$jk=[];foreach($Eh
as$Fb){$Fb=preg_replace('~ DESC$~','',$Fb,1,$lc);$jk[]=($lc?[$Fb=>"desc"]:$Fb);}$g["sort"]=$jk;}if($w!==null){$g["size"]=+$w;if($C)$g["from"]=($C*$w);}foreach($Z
as$X){if(preg_match('~^\((.+ OR .+)\)$~',$X,$z)){$gi=explode(" OR ",$z[1]);foreach($gi
as$Zh)$this->addQueryCondition($Zh,$g);}else$this->addQueryCondition($X,$g);}$G="$R/_search";$wk=microtime(true);$_j=$this->connection->rootQuery($G,$g);if($Ci)echo$this->admin->formatSelectQuery("\"GET $G\": ".json_encode($g),$wk,!$_j);if(empty($_j))return
false;if($M==["*"])$Pk=array_keys(fields($R));$J=[];foreach($_j["hits"]["hits"]as$Ve){$K=[];if($M==["*"])$K["_id"]=$Ve["_id"];if($M!=["*"]){$m=[];foreach($M
as$v)$m[$v]=$v=="_id"?$Ve["_id"]:$Ve["_source"][$v];}else{foreach($Pk
as$v)$m[$v]=$v=="_id"?$Ve["_id"]:$Ve["_source"][$v];}foreach($m
as$v=>$X)$K[$v]=(is_array($X)?json_encode($X):$X);$J[]=$K;}return
new
ElasticResult($J);}private
function
addQueryCondition($X,&$g){list($Fb,$yh,$X)=explode(" ",$X,3);if($Fb=="_id"&&$yh=="="){$g["query"]["bool"]["must"][]=["term"=>[$Fb=>$X]];return;}if(!preg_match('~^([^(]+)\(([^)]+)\)$~',$yh,$z))return;$Ni=$z[1];$tg=$z[2];if($tg=="regexp")$g["query"]["bool"][$Ni][]=["regexp"=>[$Fb=>["value"=>$X,"flags"=>"ALL","case_insensitive"=>true,]]];else$g["query"]["bool"][$Ni][]=[$tg=>[$Fb=>$X]];}function
update($R,array$H,$Oi,$w=0,$N="\n"){$gi=preg_split('~ *= *~',$Oi);if(count($gi)!=2)return
false;$r=trim($gi[1]);$G="$R/_doc/$r";queries("\"POST $G\": ".json_encode($H));$hj=$this->connection->sendRequest($G,$H,'POST');if($hj)$this->connection->sendRequest("$R/_refresh");return$hj;}function
insert($R,array$H){$G="$R/_doc/";if(isset($H["_id"])&&$H["_id"]!="NULL"){$G
.=$H["_id"];unset($H["_id"]);}foreach($H
as$v=>$Y){if($Y=="NULL")unset($H[$v]);}queries("\"POST $G\": ".json_encode($H));$hj=$this->connection->sendRequest($G,$H,'POST');if(!$hj)return
false;$this->connection->sendRequest("$R/_refresh");$this->connection->last_id=$hj['_id'];return$hj['result'];}function
delete($R,$Oi,$w=0){$ff=[];if(isset($_GET["where"]["_id"])?$_GET["where"]["_id"]:null)$ff[]=$_GET["where"]["_id"];if(isset($_POST['check'])){foreach($_POST['check']as$tb){$gi=preg_split('~ *= *~',$tb);if(count($gi)==2)$ff[]=trim($gi[1]);}}$Aa=0;foreach($ff
as$r){$G="$R/_doc/$r";queries("\"DELETE $G\"");$hj=$this->connection->sendRequest($G,null,'DELETE');if(isset($hj['result'])&&$hj['result']=='deleted')$Aa++;}$this->connection->sendRequest("$R/_refresh");$this->connection->setAffectedRows($Aa);return$Aa;}}function
create_driver(Connection$f){return
ElasticDriver::create($f,Admin::get());}function
connect($F=false,&$k=null){$f=$F?ElasticConnection::create():ElasticConnection::createSecondary();list($O,$V,$E)=Admin::get()->getCredentials();if(!$f->openPasswordless($O,$V,$E)){$k=$f->getError();return
null;}return$f;}function
support($Qd){return
preg_match("~table|columns~",$Qd);}function
logged_user(){$qc=Admin::get()->getCredentials();return$qc[1];}function
get_databases(){return[ELASTIC_DB_NAME];}function
limit($G,$Z,$w,$A=0,$N=" "){return" $G$Z".($w!==null?$N."LIMIT $w".($A?" OFFSET $A":""):"");}function
collations(){return[];}function
db_collation($i,$Ib){}function
count_tables($h){$J=Connection::get()->rootQuery('_aliases');if(empty($J))return[ELASTIC_DB_NAME=>0];return[ELASTIC_DB_NAME=>count($J)];}function
tables_list(){$Ea=Connection::get()->rootQuery('_aliases');if(empty($Ea))return[];ksort($Ea);$T=[];foreach($Ea
as$_=>$t){if($_[0]==".")continue;$T[$_]="table";ksort($t["aliases"]);$T+=array_fill_keys(array_keys($t["aliases"]),"view");}return$T;}function
table_status($_="",$Pd=false){$yk=Connection::get()->rootQuery('_stats');$Ea=Connection::get()->rootQuery('_aliases');if(empty($yk)||empty($Ea))return[];$I=[];if($_!=""){if(isset($yk["indices"][$_]))return
format_index_status($_,$yk["indices"][$_]);else
foreach($Ea
as$kf=>$t){foreach($t["aliases"]as$Da=>$Ca){if($Da==$_)return
format_alias_status($Da,$yk["indices"][$kf]);}}}ksort($yk["indices"]);foreach($yk["indices"]as$_=>$t){if($_[0]==".")continue;$I[$_]=format_index_status($_,$t);if(!empty($Ea[$_]["aliases"])){ksort($Ea[$_]["aliases"]);foreach($Ea[$_]["aliases"]as$Da=>$Ca)$I[$Da]=format_alias_status($Da,$yk["indices"][$_]);}}return$I;}function
format_index_status($_,$t){return["Name"=>$_,"Engine"=>"Lucene","Oid"=>$t["uuid"],"Rows"=>$t["total"]["docs"]["count"],"Auto_increment"=>0,"Data_length"=>$t["total"]["store"]["size_in_bytes"],"Index_length"=>0,"Data_free"=>$t["total"]["store"]["reserved_in_bytes"],];}function
format_alias_status($_,$t){return["Name"=>$_,"Engine"=>"view","Rows"=>$t["total"]["docs"]["count"],];}function
is_view($S){return$S["Engine"]=="view";}function
error(){return
h(Connection::get()->getError());}function
information_schema(){}function
indexes($R,$f=null){return[["type"=>"PRIMARY","columns"=>["_id"]],];}function
fields($R){$og=Connection::get()->rootQuery("_mapping");if(!isset($og[$R])){$Ea=Connection::get()->rootQuery('_aliases');foreach($Ea
as$kf=>$t){foreach($t["aliases"]as$Da=>$Ca){if($Da==$R){$R=$kf;break;}}}}$pg=isset($og[$R]["mappings"]["properties"])?$og[$R]["mappings"]["properties"]:[];$I=["_id"=>["field"=>"_id","full_type"=>"_id","type"=>"_id","null"=>true,"privileges"=>["insert"=>1,"select"=>1,"where"=>1,"order"=>1],]];foreach($pg
as$_=>$l)$I[$_]=["field"=>$_,"full_type"=>$l["type"],"type"=>$l["type"],"null"=>true,"privileges"=>["insert"=>1,"select"=>1,"update"=>1,"where"=>!isset($l["index"])||$l["index"]?:null,"order"=>$l["type"]!="text"?:null],];return$I;}function
foreign_keys($R){return[];}function
backward_keys($R){return[];}function
table($s){return$s;}function
idf_escape($s){return$s;}function
convert_field($l){}function
unconvert_field(array$l,$J){return$J;}function
fk_support($S){}function
found_rows($S,$Z){return
null;}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){$Ii=[];foreach($m
as$l){if(!isset($l[1]))continue;$Ud=trim($l[1][0]);$Vd=trim($l[1][1]?:"text");$Ii[$Ud]=["type"=>$Vd,];}$pg=$Ii?["properties"=>$Ii]:new
\stdClass();if($R!=""){queries("\"POST $_/_mapping\": ".json_encode($pg));return
Connection::get()->rootQuery("$_/_mapping",$pg,"POST");}else{$gc=["mappings"=>$pg];queries("\"PUT $_\": ".json_encode($gc));return
Connection::get()->rootQuery($_,$gc,"PUT");}}function
drop_tables($T){$J=true;foreach($T
as$R){$R=urlencode($R);queries("\"DELETE $R\"");$J=$J&&Connection::get()->sendRequest($R,null,'DELETE');}return$J;}function
last_id($I){return
Connection::get()->last_id;}}Drivers::add("clickhouse","ClickHouse (alpha)",["allow_url_fopen"]);if(isset($_GET["clickhouse"])){define("AdminNeo\DRIVER","clickhouse");define("AdminNeo\DIALECT","clickhouse");if(ini_bool('allow_url_fopen')){define("AdminNeo\DRIVER_EXTENSION","JSON");class
ClickHouseConnection
extends
Connection{private$serviceUrl;private$dbName='default';function
rootQuery($i,$G){$n=@file_get_contents("$this->serviceUrl/?database=$i",false,stream_context_create(['http'=>['method'=>'POST','content'=>$this->isQuerySelectLike($G)?"$G FORMAT JSONCompact":$G,'header'=>'Content-type: application/x-www-form-urlencoded','ignore_errors'=>1,'follow_location'=>0,'max_redirects'=>0,]]));if($n===false){$this->error=lang(3);return
false;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){foreach($http_response_header
as$Re){if(preg_match('~^X-ClickHouse-Exception-Code:~i',$Re)){$this->error=preg_replace('~\(version [^(]+\(.+$~','',$n);return
false;}}$this->error=lang(3);return
false;}if(!$this->isQuerySelectLike($G)&&$n==='')return
true;$J=json_decode($n,true);if($J===null){$this->error=lang(3);return
false;}if(!isset($J['rows'])||!isset($J['data'])||!isset($J['meta'])){$this->error=lang(3);return
false;}return
new
ClickHouseResult($J['rows'],$J['data'],$J['meta']);}private
function
isQuerySelectLike($G){return(bool)preg_match('~^(select|show)~i',$G);}function
query($G,$Pl=false){return$this->rootQuery($this->dbName,$G);}function
open($O,$V,$E){$this->serviceUrl=build_http_url($O,$V,$E,"localhost",8123);if(!$this->serviceUrl){$this->error=lang(3);return
false;}$I=$this->query("SELECT version()");if(!$I)return
false;$this->version=$I->fetchRow()[0];return
true;}function
selectDatabase($_){$this->dbName=$_;return
true;}function
getDbName(){return$this->dbName;}function
quote($Q){return"'".addcslashes($Q,"\\'")."'";}function
getValue($G,$Rd=0){$I=$this->query($G);return$I['data'];}}class
ClickHouseResult
extends
Result{private$rows;private$columns;private$meta;private$offset=0;function
__construct($uj,array$g,array$Jg){parent::__construct($uj);$this->rows=[];foreach($g
as$Cf){$this->rows[]=array_map(function($X){return
is_scalar($X)?$X:json_encode($X,JSON_UNESCAPED_UNICODE);},$Cf);}$this->meta=$Jg;$this->columns=array_column($Jg,'name');reset($this->rows);}function
fetchAssoc(){$K=current($this->rows);next($this->rows);return$K!==false?array_combine($this->columns,$K):false;}function
fetchRow(){$K=current($this->rows);next($this->rows);return$K;}function
fetchField(){$c=$this->offset++;if($c>=count($this->columns))return
false;$c=$this->meta[$c];return(object)['name'=>$c['name'],'type'=>$c['type'],'charsetnr'=>0,];}}}class
ClickHouseDriver
extends
Driver{protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->types=[lang(114)=>["Int8"=>3,"Int16"=>5,"Int32"=>10,"Int64"=>19,"UInt8"=>3,"UInt16"=>5,"UInt32"=>10,"UInt64"=>20,"Float32"=>7,"Float64"=>16,'Decimal'=>38,'Decimal32'=>9,'Decimal64'=>18,'Decimal128'=>38,],lang(115)=>["Date"=>13,"DateTime"=>20,],lang(116)=>["String"=>0,],lang(118)=>["FixedString"=>0,],];$this->operators=["=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","NOT LIKE","IN","NOT IN","IS NULL","IS NOT NULL","SQL",];$this->likeOperator="LIKE %%";$this->grouping=["sum","min","max","avg","count","count distinct",];$this->systemDatabases=["INFORMATION_SCHEMA","information_schema","system"];}function
delete($R,$Oi,$w=0){if($Oi==='')$Oi='WHERE 1=1';return
queries("ALTER TABLE ".table($R)." DELETE $Oi");}function
update($R,array$H,$Oi,$w=0,$N="\n"){$jm=[];foreach($H
as$v=>$X)$jm[]="$v = $X";$G=$N.implode(",$N",$jm);return
queries("ALTER TABLE ".table($R)." UPDATE $G$Oi");}function
engines(){return['MergeTree'];}}function
create_driver(Connection$f){return
ClickHouseDriver::create($f,Admin::get());}function
idf_escape($s){return"`".str_replace("`","``",$s)."`";}function
table($s){return
idf_escape($s);}function
explain(Connection$f,$G){return
false;}function
found_rows($S,$Z){$L=get_vals("SELECT COUNT(*) FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):""));return
empty($L)?false:$L[0];}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){$b=$Eh=[];foreach($m
as$l){if($l[1][2]===" NULL")$l[1][1]=" Nullable({$l[1][1]})";elseif($l[1][2]===' NOT NULL')$l[1][2]='';if($l[1][3])$l[1][3]='';$b[]=($l[1]?($R!=""?($l[0]!=""?"MODIFY COLUMN ":"ADD COLUMN "):" ").implode($l[1]):"DROP COLUMN ".idf_escape($l[0]));$Eh[]=$l[1][0];}$b=array_merge($b,$ke);$zk=($qd?" ENGINE ".$qd:"");if($R=="")return
queries("CREATE TABLE ".table($_)." (\n".implode(",\n",$b)."\n)$zk$di".' ORDER BY ('.implode(',',$Eh).')');if($R!=$_){$I=queries("RENAME TABLE ".table($R)." TO ".table($_));if($b)$R=$_;else
return$I;}if($zk)$b[]=ltrim($zk);return($b||$di?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b).$di):true);}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($qm){return
drop_tables($qm);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
is_server_host_valid($Ze){return
strpos(rtrim($Ze,'/'),'/')===false;}function
connect($F=false,&$k=null){$f=$F?ClickHouseConnection::create():ClickHouseConnection::createSecondary();$qc=Admin::get()->getCredentials();if(!$f->open($qc[0],$qc[1],$qc[2])){$k=$f->getError();return
null;}return$f;}function
get_databases($ie){$I=get_rows('SHOW DATABASES');$J=[];foreach($I
as$K)$J[]=$K['name'];sort($J);return$J;}function
limit($G,$Z,$w,$A=0,$N=" "){return" $G$Z".($w!==null?$N."LIMIT $w".($A?", $A":""):"");}function
limit1($R,$G,$Z,$N="\n"){return
limit($G,$Z,1,0,$N);}function
db_collation($i,$Ib){}function
logged_user(){$qc=Admin::get()->getCredentials();return$qc[1];}function
tables_list(){$I=get_rows('SHOW TABLES');$J=[];foreach($I
as$K)$J[$K['name']]='table';ksort($J);return$J;}function
count_tables($h){return[];}function
table_status($_="",$Pd=false){$J=[];$T=get_rows("SELECT name, engine FROM system.tables WHERE database = ".q(Connection::get()->getDbName()));foreach($T
as$R){$J[$R['name']]=['Name'=>$R['name'],'Engine'=>$R['engine'],];if($_===$R['name'])return$J[$R['name']];}return$J;}function
is_view($S){return
false;}function
fk_support($S){return
false;}function
convert_field($l){}function
unconvert_field(array$l,$J){if(in_array($l['type'],["Int8","Int16","Int32","Int64","UInt8","UInt16","UInt32","UInt64","Float32","Float64"]))return"to$l[type]($J)";return$J;}function
fields($R){$J=[];$I=get_rows("SELECT name, type, default_expression FROM system.columns WHERE ".idf_escape('table')." = ".q($R));foreach($I
as$K){$U=trim($K['type']);$ih=strpos($U,'Nullable(')===0;$J[trim($K['name'])]=["field"=>trim($K['name']),"full_type"=>$U,"type"=>$U,"default"=>trim($K['default_expression']),"null"=>$ih,"auto_increment"=>'0',"privileges"=>["insert"=>1,"select"=>1,"update"=>0,"where"=>1,"order"=>1],];}return$J;}function
indexes($R,$f=null){return[];}function
foreign_keys($R){return[];}function
backward_keys($R){return[];}function
collations(){return[];}function
information_schema($i){return
false;}function
error(){return
h(Connection::get()->getError());}function
types(){return[];}function
auto_increment(){return'';}function
last_id($I){return
0;}function
support($Qd){return
preg_match("~^(columns|sql|status|table|drop_col)$~",$Qd);}}Drivers::add("simpledb","SimpleDB",["SimpleXML + allow_url_fopen"]);if(isset($_GET["simpledb"])){define("AdminNeo\DRIVER","simpledb");define("AdminNeo\DIALECT","simpledb");if(class_exists('SimpleXMLElement')&&ini_bool('allow_url_fopen')){define("AdminNeo\DRIVER_EXTENSION","SimpleXML");class
SimpleDbConnection
extends
Connection{private$serviceUrl;var$timeout=0;var$next;function
open($O,$V,$E){if($O==''){$this->error=lang(3);return
false;}$gi=parse_url($O);if(!$gi||!isset($gi['host'])||!preg_match('~^sdb\.([a-z0-9-]+\.)?amazonaws\.com$~i',$gi['host'])||isset($gi['port'])){$this->error=lang(3);return
false;}$this->serviceUrl=build_http_url($O,"","","");if(!$this->serviceUrl){$this->error=lang(3);return
false;}$this->version='2009-04-15';return(bool)sdb_request('ListDomains',['MaxNumberOfDomains'=>1],$this);}function
getServiceUrl(){return$this->serviceUrl;}function
selectDatabase($_){return$_=="domain";}function
query($G,$Pl=false){$D=['SelectExpression'=>$G,'ConsistentRead'=>'true'];if($this->next)$D['NextToken']=$this->next;$I=sdb_request_all('Select','Item',$D,$this->timeout);$this->timeout=0;if($I===false)return
false;if(preg_match('~^\s*SELECT\s+COUNT\(~i',$G)){$Hk=0;foreach($I
as$Cf)$Hk+=$Cf->Attribute->Value;$I=[(object)['Attribute'=>[(object)['Name'=>'Count','Value'=>$Hk,]]]];}return
new
SimpleDbResult($I);}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}}class
SimpleDbResult
extends
Result{private$rows;private$offset=0;function
__construct(array$I){$this->rows=[];foreach($I
as$Cf){$K=[];if($Cf->Name!='')$K['itemName()']=(string)$Cf->Name;foreach($Cf->Attribute
as$Oa){$_=$this->processValue($Oa->Name);$Y=$this->processValue($Oa->Value);if(isset($K[$_])){$K[$_]=(array)$K[$_];$K[$_][]=$Y;}else$K[$_]=$Y;}$this->rows[]=$K;foreach($K
as$v=>$X){if(!isset($this->rows[0][$v]))$this->rows[0][$v]=null;}}parent::__construct(count($this->rows));}private
function
processValue($kd){return(is_object($kd)&&$kd['encoding']=='base64'?base64_decode($kd):(string)$kd);}function
fetchAssoc(){$K=current($this->rows);if(!$K)return$K;$g=[];foreach($this->rows[0]as$v=>$X)$g[$v]=$K[$v];next($this->rows);return$g;}function
fetchRow(){$g=$this->fetchAssoc();return$g?array_values($g):$g;}function
fetchField(){$Nf=array_keys($this->rows[0]);return(object)['name'=>$Nf[$this->offset++],'type'=>15,'charsetnr'=>0,];}}}class
SimpleDbDriver
extends
Driver{var$primary="itemName()";protected
function
__construct(Connection$f,$xa){parent::__construct($f,$xa);$this->operators=["=","<",">","<=",">=","!=","LIKE","LIKE %%","NOT LIKE","IN","IS NULL","IS NOT NULL",];$this->likeOperator="LIKE %%";$this->grouping=["count",];$this->editFunctions=[["json"]];}private
function
chunkRequest($ff,$ra,$D,$Dd=[]){foreach(array_chunk($ff,25)as$_b){$Xh=$D;foreach($_b
as$q=>$r){$Xh["Item.$q.ItemName"]=$r;foreach($Dd
as$v=>$X)$Xh["Item.$q.$v"]=$X;}if(!sdb_request($ra,$Xh))return
false;}Connection::get()->setAffectedRows(count($ff));return
true;}private
function
extractIds($R,$Oi,$w){$J=[];if(preg_match_all("~itemName\(\) = (('[^']*+')+)~",$Oi,$z))$J=array_map('AdminNeo\idf_unescape',$z[1]);else{foreach(sdb_request_all('Select','Item',['SelectExpression'=>'SELECT itemName() FROM '.table($R).$Oi.($w?" LIMIT 1":"")])as$Cf)$J[]=$Cf->Name;}return$J;}function
select($R,array$M,array$Z,array$De,array$Eh=[],$w=1,$C=0,$Ci=false){Connection::get()->next=$_GET["next"];$J=parent::select($R,$M,$Z,$De,$Eh,$w,$C,$Ci);Connection::get()->next=0;return$J;}function
delete($R,$Oi,$w=0){return$this->chunkRequest($this->extractIds($R,$Oi,$w),'BatchDeleteAttributes',['DomainName'=>$R]);}function
update($R,array$H,$Oi,$w=0,$N="\n"){$Ic=[];$rf=[];$q=0;$ff=$this->extractIds($R,$Oi,$w);$r=idf_unescape($H["`itemName()`"]);unset($H["`itemName()`"]);foreach($H
as$v=>$X){$v=idf_unescape($v);if($X=="NULL"||($r!=""&&[$r]!=$ff))$Ic["Attribute.".count($Ic).".Name"]=$v;if($X!="NULL"){foreach((array)$X
as$If=>$W){$rf["Attribute.$q.Name"]=$v;$rf["Attribute.$q.Value"]=(is_array($X)?$W:idf_unescape($W));if(!$If)$rf["Attribute.$q.Replace"]="true";$q++;}}}$D=['DomainName'=>$R];return(!$rf||$this->chunkRequest(($r!=""?[$r]:$ff),'BatchPutAttributes',$D,$rf))&&(!$Ic||$this->chunkRequest($ff,'BatchDeleteAttributes',$D,$Ic));}function
insert($R,array$H){$D=["DomainName"=>$R];$q=0;foreach($H
as$_=>$Y){if($Y!="NULL"){$_=idf_unescape($_);if($_=="itemName()")$D["ItemName"]=idf_unescape($Y);else{foreach((array)$Y
as$X){$D["Attribute.$q.Name"]=$_;$D["Attribute.$q.Value"]=(is_array($Y)?$X:idf_unescape($Y));$q++;}}}}return
sdb_request('PutAttributes',$D);}function
insertUpdate($R,array$Ti,array$F){foreach($Ti
as$H){if(!$this->update($R,$H,"WHERE `itemName()` = ".q($H["`itemName()`"])))return
false;}return
true;}function
begin(){return
false;}function
commit(){return
false;}function
rollback(){return
false;}function
slowQuery($G,$ql){$this->connection->timeout=$ql;return$G;}}function
create_driver(Connection$f){return
SimpleDbDriver::create($f,Admin::get());}function
is_server_host_valid($Ze){return
strpos(rtrim($Ze,'/'),'/')===false;}function
connect($F=false,&$k=null){$f=$F?SimpleDbConnection::create():SimpleDbConnection::createSecondary();list($O,,$E)=Admin::get()->getCredentials();if(!$f->openPasswordless($O,"",$E)){$k=$f->getError();return
null;}return$f;}function
support($Qd){return
preg_match('~sql~',$Qd);}function
logged_user(){$qc=Admin::get()->getCredentials();return$qc[1];}function
get_databases(){return["domain"];}function
collations(){return[];}function
db_collation($i,$Ib){}function
tables_list(){$J=[];foreach(sdb_request_all('ListDomains','DomainName')as$R)$J[(string)$R]='table';if(Connection::get()->getError()&&defined("AdminNeo\PAGE_HEADER"))echo"<p class='error'>".error()."\n";return$J;}function
table_status($_="",$Pd=false){$J=[];foreach(($_!=""?[$_=>true]:tables_list())as$R=>$U){$K=["Name"=>$R,"Auto_increment"=>""];if(!$Pd){$Jg=sdb_request('DomainMetadata',['DomainName'=>$R]);if($Jg){foreach(["Rows"=>"ItemCount","Data_length"=>"ItemNamesSizeBytes","Index_length"=>"AttributeValuesSizeBytes","Data_free"=>"AttributeNamesSizeBytes",]as$v=>$X)$K[$v]=(string)$Jg->$X;}}if($_!="")return$K;$J[$R]=$K;}return$J;}function
explain(Connection$f,$G){return
false;}function
error(){return
h(Connection::get()->getError());}function
information_schema(){}function
indexes($R,$f=null){return[["type"=>"PRIMARY","columns"=>["itemName()"]],];}function
fields($R){return
fields_from_edit();}function
foreign_keys($R){return[];}function
backward_keys($R){return[];}function
table($s){return
idf_escape($s);}function
idf_escape($s){return"`".str_replace("`","``",$s)."`";}function
limit($G,$Z,$w,$A=0,$N=" "){return" $G$Z".($w!==null?$N."LIMIT $w":"");}function
unconvert_field(array$l,$J){return$J;}function
fk_support($S){}function
alter_table($R,$_,$m,$ke,$Qb,$qd,$Hb,$Ta,$di){return($R==""&&sdb_request('CreateDomain',['DomainName'=>$_]));}function
drop_tables($T){foreach($T
as$R){if(!sdb_request('DeleteDomain',['DomainName'=>$R]))return
false;}return
true;}function
count_tables($h){foreach($h
as$i)return[$i=>count(tables_list())];}function
found_rows($S,$Z){return($Z?null:$S["Rows"]);}function
last_id($I){return
0;}function
sdb_request($ra,$D=[],$f=null){if(!$f)$f=Connection::get();list($Ye,$D['AWSAccessKeyId'],$Bj)=Admin::get()->getCredentials();$D['Action']=$ra;$D['Timestamp']=gmdate('Y-m-d\TH:i:s+00:00');$D['Version']='2009-04-15';$D['SignatureVersion']=2;$D['SignatureMethod']='HmacSHA1';ksort($D);$G='';foreach($D
as$v=>$X)$G
.='&'.rawurlencode($v).'='.rawurlencode($X);$G=str_replace('%7E','~',substr($G,1));$G
.="&Signature=".urlencode(base64_encode(hash_hmac('sha1',"POST\n".preg_replace('~^https?://~','',$Ye)."\n/\n$G",$Bj,true)));$n=@file_get_contents($f->getServiceUrl(),false,stream_context_create(['http'=>['method'=>'POST','content'=>$G,'ignore_errors'=>1,'follow_location'=>0,'max_redirects'=>0,]]));if(!$n){$f->setError(error_get_last()['message']);return
false;}libxml_use_internal_errors(true);libxml_disable_entity_loader();$Fm=simplexml_load_string($n);if(!$Fm){$k=libxml_get_last_error();$f->setError($k->message);return
false;}if($Fm->Errors){$k=$Fm->Errors->Error;$f->setError("$k->Message ($k->Code)");return
false;}$f->setError('');$cl=$ra."Result";return$Fm->$cl?:true;}function
sdb_request_all($ra,$cl,$D=[],$ql=0){$J=[];$wk=($ql?microtime(true):0);$w=(preg_match('~LIMIT\s+(\d+)\s*$~i',$D['SelectExpression'],$y)?$y[1]:0);do{$Fm=sdb_request($ra,$D);if(!$Fm)break;foreach($Fm->$cl
as$kd)$J[]=$kd;if($w&&count($J)>=$w){$_GET["next"]=$Fm->NextToken;break;}if($ql&&microtime(true)-$wk>$ql)return
false;$D['NextToken']=$Fm->NextToken;if($w)$D['SelectExpression']=preg_replace('~\d+\s*$~',$w-count($J),$D['SelectExpression']);}while($Fm->NextToken);return$J;}}$si="adminneo-plugins";if(is_dir($si)){foreach(glob("$si/*.php")as$o)include_once$o;}function
get_translations($Sf){switch($Sf){case"_template":$e="exEMBEOhEJTmIDweBcIhYIhjAxEWIVDBEMohEoXDRnF4nDRpHBYIB4YRAaDkZTMPS4IjQdDocDmOi4L5md5sLjCZDaaTcbjKbxcbzkZ5mcDCczmd6EZJXBh9CR5MzCPoyIhrHIoNqxDRvWxEOK8Oa8MYFBIlFBjD7MeLRFrXaI3b4aMY/codV7sMa1ea7a6qMbBebFfooMrLEbZDRlasRhbdiBAJTJhbjjcVdcRVRleMtFb3nRlfdBgdBg86M8PZ41jNUIhnj9aM8rscxsc5sc/sdFsdJsdNrRpqcSIhpai3BTJCOHkuUIi7Hthwxps+ltelt+luelu+lvelv+GNeFFBrjIT5Oj5Op5Ot5Ox5O15NF54aNe95NN9BENvHDRs1jhhs9L/PW/zMP0GzOQQ+L/O4rL7v88CKBu/oRBvAEJwHC0Cws9quOwqobwZC0HK5CELQkhocQqHEMRU6KqhxDgcOtGMQIoHERhw+bhhxE4cRSEQcwqHMXSFDQcw4HMPSE96Ghyz4ShcGYzObJ7uKqHLvMiOYhSy8C/hgw7hrI8yEzPNC0Bg6IfzUyr9LJA8yBhJyHBg7UwxLO0TrJIK0wqtMjLTGC0BjDi0yYtM6rTEa0z0tM+BjPzDLGxaOS4v4ZUIuYZMqgzlS5UCDUzOS2xvTlGtDSrvUywbjokyIyKrWDJIW56HNQji/hnAFd03XDqV3Gq4VPXE8LhR4Zy2FCDBTXc/ODXS0OLS9R2nX66OpTFp2GuYaWKulj29R4aT4Gk/PEiFPoSHVQoTLi0PKjl2oNeMNBiGtDhrRIa0WGtGhrR77WkuYaz8/ixv/hN7htQ4bUTBOE0aG1HhtPgbT9Cixwvjd7hvQ4b0SG9FxFjdHhvPgbz9FeCIdFqxhwx7mJmEC0RkgbjuY/WdLZW7ALrV48JDWqKIlodZOcuYcXBHOcOQ5Sq55W2lUfH2YT9IeW0lQQcujeC5ySscl7FRcobFR8tbFMDCzFlrDQBazFTXtwYWDtluorOivMMz79MM7kuTbuUTsNtbFLJva08TDTF7tw+8MXYrF3EioYywwrAbdSW3Uou1NOMxGj1noVY6mitNc5x3T8gzfORHTU9U03osMdINOwrTtespX9O9VTsmU7yQZ8pTvLsVZW9hn21o89anm8Y6e9hpyFv7cGniBp2Ny+l21089eXv95fO3X38k6s31+A73gbCMVg23YRz2Ffaz3eYb+HgYj+gZBt4mKPwcIxhvbGnPMcgK7xj7bmQwKfOyWArsWUQDVc08hLUTkwVaSRVljnmXkEZ4YVmLe2bg6ZzBcjsFCJq3BkjRtzS4Wl7hK1AijUoMwrdi1aDjhiKtZc8kVvbXYfpvOGDJscPXJNmf2Dl40O1WGFBzDo1CFTUO6I03MuxqEOGoSYahBRwzUIjNQno1CJzUJBV5FJxUVwYoaV5FkuhXleJ1V5GBy0cHMxqPzF5zpp1LRXdQXZXQLiFh9A==";break;case"ar":$e="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";break;case"bg":$e="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";break;case"bn":$e="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";break;case"bs":$e="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";break;case"ca":$e="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";break;case"cs":$e="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";break;case"da":$e="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";break;case"de":$e="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";break;case"el":$e="exEMBEOhEJTmIDadTmdBAcjKdDqcjcIDDEzCcjkYTyLhELBEMYGIiab4cIDSbjNJDaYToaTebo5HhlISJLDCYjCczKIDIbzLBzcb4YczqcDhJIYcJyczvJDJMREM5CSTcdjCbDSZBBOjkdjKchBJBAY4cZDKbpbVznUBpISCZDbJycZTfPJ9QKFW6LRzlDDCYzHPznJzPFJ5NpxOhAdzSdDQbzrfhBSjnTKcLBAPDCIDRDjMPS4IjQdDocDmOi4L9Sd9YLjDcJObroLpIZ9TlMscjJoYMPjbJJ3J5ScpXLZePNSYR9UBrIWckWegGcv2eg2ejWcvWctGcteqzlvHRENucnWcrWcsRB3Wcs/az0D6WehmcrvEN+coGcr+z6WcXT5EE8QcOcSZnF2Z5HOq75YvEHKQiEPKtjyhYyja8QYoEggmDSM7RwwkCCJqOQ1wwmaCCGN42LEOYxjRCwywwqURDKMwwjqNg6QwtsRDSOY4DYjUMOaggkKzGKPBi8iCGcUZnkLBZDu6Z5CPq75amcXJnwFJL8Q2k41oOOi6jom42J+hsaq+s4xsIEDHJ2MaIoctCGjeO6oBjAiCCkMoxqcg44K+yYwjPJCPwfGkbRwhg3DqNoxUGN4zTTP7dIOMkfSAjQyq0k7DzLN8zDKqAZQ0ES5q8OTxBlEIRCCNg7o0OdWROkTgBAqw2DrNDHIqEASjJVkZhEItHDaiiDp1M4xx0mUeBEKjOp+x42K04aeU1II8zczdlz84yJjas46hBbFyWQMw0jLay11ZIgRGcSksv9ABfmcXkswXKpXS3Vkl3jJxG328F8PTVkvXiRj+3vfL1GcU74Ss60qvCmU93iTRnkS7d6F0Z5GX8mVE3iSQXPXecsO5hrzuzjbsvEGdTya67+u47xBvBmNXGcTmQP6XODFu9eBZtKec4sqNbGcSro3oXeWl9KjuvXm+O5Y9DtQajwZ2IZxQYle5ZOnA766rsl837Lio2gZxSbDpzqOle7+Fu7+hujsJnbHe+obVmN4bduG57i/bwbuEGnP5rT/4PrmAKolOY4TpmnSwX0pvi9xYu+/mtqjjArouNzCVprmSaZl0q77swpiiJjxBpU4kCoKgoTSONeIX2MQi2gqtDEPI6UPYIQeD4daC6jwaaXJ1+bLpIaa9t+B8JtYaWhFI2SDcPY8DJxD5/qGgl/2OAOfJ8qZ/h2p6G+T4v4XGhbv2PKbA+N7u86Wg6hLD3L5ayeBxKVWgtpdixhtzBhXMGc4lVz4NGSBQIuS17pHgaszFIvSADIgRA1Z42lxp1G1g1aW01/bZV7nuPtBZrwmz2JadW+lzThjvQjbafQXDektM5YceIGrgToH0FiftiTOGdQWfOJE/sQxbJWYq/SCzCWnRDF61M6gjYfQIgzENzDQYqsLXy3ZpEPnUCmGc/JxZ030s5c+DZmbIT4vkPEDZngnD6whS2etACWICstO0dQQsc4Sn9FaxI90fHHHja8fpvzEm7CCcSzkVh8GNuIadF4ZwrD/svF7HNtrnG5xnjvHuNcRzxuBk1H9ej/5Eg2fO29/DcXCt1cQM5ky8ioA2cpLCNThJQy0aRJEZ6UoFvshi2sG0CHwR3YceuW4lJcuoXm0FAEQ0tCOgY1Nz4N2ZiVX1Gw97HIVH3Z5N5zEQxZsvnGR4G7S15i3YM+SGR7XDMPmeVAG7Xp3zxjUlCGbnphTEmzMc+7bZ9r5nlP6elAHFRLcbNtwLEREsSFfHmhrjJSCCnwwCYbEl+xjnY5SZcxZEg3YwFMNIbUgKHBuyQIgdSroDVOn1VROlhEeBwq4JwYQ7IdJYS5cQbyzIDVsEwjRkCGKTIQGFT4bqeU+XCYsxoaFRBiTOCArAbkwlQBwsQKio6sJgdMCIHC0AoBypSRdCRf6orYKuGyqtV6s1bQHRGSr8KLM5j4xKQtGkBvnnM+99rBoAsPQA/1eh3GgisQGwlP726fkvQHAgTRz4EiRPXBkS4zhOnriVC6F0SkDCXQG6iysSoM2YgSJdlAzhM2WQMKGy0ZrSEeBzG9hkDJhPPahI9BzPGFyqmbFNiUQ4NiEbhIG20JZLwonpX1B0i24M5flAtAD7n9PrPZH9J6Dm2x2O9A5xsaYxQCbzLGSE2j1v6kyy4RKDnA3gm1eM/t5W8CAbhemB0epMvqvfbZgAJQXAzUpWMHLlIlC0SfQ5fNAGDXhPkIZkElLkUTaRHmwSUksH8kAVAHMWjpnrgBPSHcVr1yXfUfG7MYLt4hsJPRLD8oRHrc4IGYZ7MOJPvW4ZxguVgBzCFh51EGRf40kphpw2RWOpYF64lKB0pJ42yQLlPIMFT5VVcDAGIMgZg0BrLoHCD0kgwkHRVijVHOz0kBfkHaGAYNej2y4RmbloXnkrchkNyMnnTzc4Gb0Oz/TpnEfXNz52UnZPXIXDTUxatnmof6irHJmxLgG4OXrZGg0fSmlXRp8koZ4gG2TJtF16npyrghwt1XGneShSAj4MIEHQlDqqUmrYBUPSzMIQshMbyIYfexy7mZ6OcZy56DiGXUaybJrRKetn3TV1zC9Bk4Z6CuxPfjFmTJ+ogZmgaNOEJrWe1TKPZsUCPgxZ5NPQNxT56ESTlskIVatFBDuRMr4ciSJ5Bi9M67hcfUdPjR99qIG2nQjjKJfLdEQOBs2vk7z+GhH9wdtDf6Cj4uf3Q+eyuG8HsMRA5SF2ZtGbHT0c4SmC4h2Kk3nPd7qEDHe0lpuikictszXmfxj+es+JJVafl9+pYhoIEc4l8J8byx9blpjHDBNO0IPTkbbGoUtSQSmdJLHOb+16X1JAgyeQZNLyJkbKWOMQvpyhkeF/XliEGIoG4rXbCEkLTSRAiXbSwhiDUuAsZDiWKdeMhLuBDzHlPRMtBHKq+eOBElRQ78pMz6d6u+pkN6TrHYO0zdu6W+vMACQG9caJmEhTIeS0NwZ6x5bYwikNxslmpuTGZOtFPUzqGK0XwOhB0fAgKCX57ad1O9eUS75yp0oqQvegwbEZ2oa40P7eyGD6ckUVvTfiWJ1soSikR8tBflsl+ZEEZhq7jY+yT8eeuc5/RWSRap2xst2c8FQ+Gf75TT2Cr5+SlPqnxfnPqSh9Giz6iNT6y9p+T7KvJmry5o5w775s5e5AD8bpj8z+STL9TRr9h/pvJKoVgjh5Qj5mQkJaRNYkwg5bwpQwIkwiZOEE4OAyJQgyopo3QxYNANJFwhBDo0Z4wncFIMZG4nRPIGZnjZQ6g6zXcBDGLciBpqjB7a5fTPTG5z0Hxpa1hBcIg9jBR+Dp5lq3oZxzAWozC4ji7XDoTXRo0IzDbRkCL4sDRGRYgqhXQrIyYr4lY2ROpFYM4k4zClYnIncOpT5QqpgmBGRtp+485yzaJrTHaNLcLFrh7NTfz+qPzW5vDPcIRqZfrg5zBvEIb5o7ZiSa47MHxeEEAij1ol6qR7cHEOAOQ4ZcYrQMIMx4YsAogwAwQMxHCrAN8OwiYxgxxN5F4rYMJcbvZTos4tINhdxJIGZgAmpMoxInYMj2JQb3ZcwyDt0HxhIJwusZ4NJVRGSyg/zBsLCUBkDqSi0SZghuzg4Wy7TbT5bqo9jrD8jaSSAKAJB24FAgwFJs7JkRChzHxjpoKIZ+SQpnKPoW8Hy00b6eo9aExlrrDYiUwGJ2Q5w+hj6hTJRezsxn47THwIYKYKQIxk5mjThwxBDTjUJvDCSOC3ULcCUNRJIGhngUppyQo+Jsch59zEY9zEqGIQsJb57FRvLbJhjHTn5oJ+ThI65xLqxjrSMT49Y/TGroBA5BLIzXZzDgUkzrpHZpaJTJrJa3bshqEJDTpzjT8cbEzSCwbSccQRjULIot4uINwuYN8LzPEM5xqxDkUkzT0Ssk8Chso/g7gWJPJ6Tnx1hqD9LJb8L+49QKAJ4KYKkkK8CIjC0M69Ry0TpKZ8MoUQ5szT0lkrDNBirRBKLTZjxsySg7Eo6b6AUrUl676WTFSIkvczrhybTdo6jGy5BBSvUu6wrEQ9g9yTRqDJTGrXrJIEB1wJk4EgZjYEAIx2y/kRUQ8tCvaSTGEu8tktzRzUplknY+swhwKFz4p+Uh7+59ye5HZ84T7aKe87idBiSSY+ieDaAXswjkCIjM5h7lURhzY78TyTsl6BC+S8Rsa3pqa6El8hEJD8k27VwGKC4kL9g9BABlZu4HTH85hBYRMJdClB0BQEEeh24gxIZnhJ0KhqzZksZxKibrj06Eg50rsCSQrC0iAGqRbHjUqGpIa75lqQ6USERIZwMmSUM4jEg74XjCZtdCCwC5qxCViwpIZyjdU+Di7dqFYj4GqBEiiebIs0qkkwZIZ1AUqFERyeE88pRvRvhstLBJRmcQZsRshvxDCOg5yOxuxKT4tNoGzsDiKYzS5uhw6YMltOifTsjrFHZJIGxtqXjpNRxwy+0fRjx9SbFAIj4GxwI/SeCddS5855zCZKVINRSXbS1R6YEiCZI/K6aUS6zW7YM400b+6QC/ixBoLlSK9OhkgIZF4MZMJDCbgkIIbvh4YsdXhEpLqcqJbfqHg+SB1X5pdOA77Zi7FZRgdZkJFUQj6fNO0jSDSNTqhosItJFb9X9Hs3NK9X5wK2TNZKrb7Y4G587l7NTOVd9KcKptESDjCk1GKWRKo9EC9a9X6aUR6hKQ0hRiCj0c5DAHBU4IJ2oIIIYJAEB3Ir5dcEYksaQogowpD39hdEzds4a3RgjJTh5BMtTmgHBWx4o1IEFhZGZ3x4pK5fQ+Kxgj1mLrRLQ+K6EDhPRHj4TsJzNk1WMLDyMkZqE5s0aPY9c9gTT8C9kdA9lBtpL9YrVmVnKTL+FoFkpBVobX6Tdo0QjM8+kJNplpxp1qBLFqRgs+pYFqtnCvjzQEVngHBwLQ7UbPbKLG6QDRC7aKxsqvo9cztoo9lgCK0A5PIHBJdn7F1rdk49R4sd7Rlv8c7VdpYZwTVrNoiSlrkR8JFx4rVyNsFpFtb+Vy1zFuRJIHByibzrFf8BJpJPSBA/URieSONJFJUv9nJBJmF1J1FAjCLCc3SStQc4z6LbZJK245wRE48fyUERdg1R5oKeEAg/Y9cnE0xzklLCl4bW94rpZjk+xDAHMIEoM96EKeJglNoHMrjtDjjIr9k7Uf87t9DM7awO4MoMV8Rr11lBD9qWt719y7t5CgxeiIcjA6TazCa8Vu5p1vLKaYQ+lkKHt5BwI81r1JKITiQZyJpe6Kq8Uf1JK4Lsq/ZBeCJstP7jAHJ84TNkczJj7lhRByiysgMot27yd8SBEhjYM/o+TYrp58STl8R1C1k4I99Kw+ja1+VKq/s+bVZUrKw52Ih/2IzCMzzbVM9oKbB+VsYWuJ5nmKSeidOI4+r9k6xKxKWLeJ5pYT8pVHOAxAN82MWJl0mLpVjN452NjUmN5zi/VUsRyBeLeJ2OxtuPI6URKh7DA7mLFgqGeQGOmJ5wOERlg9WPSh+Ox86MLG9PWOxhIIjfAODH4H+OyBGSUlaDKEFP9bJUx1E9kfxqznDkePqWKXzpWR1saKhUpDI5x6iWTqmV9r6UxVq4C3OCYERVppaO1VuVTfeKKZwFyXGOM+LduLmXJtoS8kM9zB9vy4TrKwaPeXLhmZ2aBjuRaftg2W2QQmRJWZqW2Z6aDSuWdQBemdGb5VgGKXbso6ygTSblWJc+WR+ezEFL2fSZkLGRSfjNeRqUWamezIefLG9MGeFQGP+hedOYxUw51/lf1/zVzr53peMKSWLT+NzHdRFydsTVdsw6VtGbtqcCttzaVmj+GkOc1drSl0NwlsObw7ulRw82VtWW7RFm+mMQiv0Djr9PtkkllWER6AMi79qxN6uJWKmf+hgmTLmXdxmpbCmpphlWj4w7gV+iVR2imQOeuq9RmrSc+rmLGp2r6RGsJs+cuhLauius+i5wOVssCBcC7yiwbUelbas6TXLExfdUDssACQspcf0zrRSfs0h1dvkwJelLy5B6o6cL2xMQuxmH9vF9raOX7rCR8sETMSp6C3ew+p86ezuBrtFvcr1V+tjF8zpqxle2bUxWqwGrc3WrqP+t+qIV5Wp+2N2RFcDyVvSDjr5jAIgIRWrZJsssTapYdN9VdaevZ6G5MH+Zq85slNZv2saWSULTOuw7pUoGcKNNLiG70z2fuqmaeizLhr0KUAFOJ1mJOg7p2uiFW8mOomTLrk1gmcyf+H++hvdORKxtbLhwNoFH492Dt3GqeOWqu+EZOrLJXBrUV3DFOie8SO+s28pYefHC+IvB7yeuWhCee/fD+/uYwGaLWPyX9QTW/DHEtw3BIGdgeufFNg/GleighZ5mYRFZQ+MTBVkmA5yFyBfIpZ5payqTUAnIxr2GZqb9Ov49Z1kBtNiSlGp92fsSqRxK/I2axxOkRqcROaNmm9+u4GTL27fMum06i5GeN6PD2gBZ58+mldmkmcnFChXFXO2YwGlUnOaWfGR91Wtw3Pyeu5IGnF/QnGNSOqblSarNOPnI3HPPtgzB1E79Gtj7xd7m3AO/Vg+9vSeHvRfBKD2jLFBiiIo+cdcoePuy+VVGBJmIjoL484j6HUmAu92JvNdG+dnXELXXT/vXnHXRWenEAmQGvMY/xqHYmcxKShnOXDmWu/hUqH+XfGBslU593YZgvYsJxAJd7Q3UXHbB3cCeHcXafcnZle3ZHTWH+yyWS5WY1LWPDSvWeRPXvCXNXZfe+VnfWXvE+/PHfZXFgGSN3bfR/bvQ3gZwne3hRV1XZPwNYzgnMHAs4nmT5QTwgmVPlYNY3jAg5SPjYq8WFjvkBYnitXvknjQiYsgMrvvj+Y1RYtxHJQZF3ixf/BbFywqUufnfuaXX/gHhSV/n9ZTWy4fausnDvhBUqXXCzRPpVcc/fc/ZPbBf/R3a1QPSLbRzlaygdcnkHTHg3RTB3sFZfseVVYBJgR64phBnleXB1enBKdvfNhDgMc/fkgHX3QAGVbZJmNnvRiZ9qi3pu8Pa/FZUoG+Qg9ZiPvdsXfneOhXxhhBwJjRjnU3OnhBhB89dZ9POCRPwO4cqJzh8Li3QxhDWL9EvH1YmSlogdxcRlP8vWOlts7mHkh8J48SBP2tZs/OnaKn3N+X3bNKGsDZi5maypBF8GeXbxVinNCVtzBaVR8ZxtmuY1lOrP4EJDQGEO5Krv2ZeMhmlmoFytyGKeOV7M8H338yIult0n4n9WMLdg+ivv5X7cQRel0bRoEMDoByA2AKwMYVh5cJXTgJADqRAoPWk6QsOcRgpqN8Sy0F7mmRK5owVKt0epmGTsil5s02LXAoWGxxHwj0MvfOOhVSIFUCoBGAWgOIDK4od+u5T4mOzQAv1jQHgCoNQyvazowwxmgbNCzaa+FqOuqcAI+zshj0aq/WfgsSS7Ck4bIQqY2shyar9J649OeHF9n6Q6h8i4yOkMf0CDYU8qhkVxrJEQqFxYM+8QsQDhh7nF25AVGJppjRrlYamR9BXCpV5IkwFMvBL/EtUBwetZC/OW+NtVfA1liCMjGeEZlc6btE2C5FWL6w5wKNpy2THPgMgHIsRckgXaRkQxz0I0baMLTiJ2w+Q4Ro2sAIGQjWvLYRkMUOKMsbV2hytbOa4XwjI09cKhuJCrZtEDjdqTRvIy4hGjlGvTJWFsRUg5vf2oMLFmMYfY8QtIKR/hzQxzhiwdmVkMqFVDMcDCWEkpN9cM9PhdonxmLFAIIBTedhKysYzIp0F1EWiL4cQVAZkK2AphjwO4VuHCBhhuqOIZaO04olPU1OB1BIVEBgcFKHETRfpE9UHCCGsF7k0hmczWfThan+IbovB4yGbCHAZxHARcBABlA8AcAhwZUqBDdHzsySPB1Q0O22PkwhYfg5SI8kYiQKhzgY1w1hBFTFq+Uha/5NUbCHPjMh1EJCB21FGdvzA/yeVE6w2IOIPxngJJcJBzYWukDcyD8aW5CUntyBtaD8a8oyThkpRpKD8bakMVbC+klRDly4M7VMmwjR50lSwg/iOr2E3EDOAQXtdoGt09I1xnup2izB9E3JJkZ2+tYPEq3+5u4KiAxGSAbxVQHcrQPDGYtGBJhEqLW7rdpE9YwYzxTgxULjPY38CkqMGPNM0OBTaBjKJ+rMa3HAFbo+UI8EhbDwjAPoA==";break;case"en":$e="WxEJTmIDadTmdBAcjKdDqcjcIDDDzCcjkYTyLhELBETTfChAaTcZo6bTCdDSbzdGI0RJKYTEYTmZRAZDeZYGbjfCDmdTgcI7CDhMDmd46ZJUIiSbjsYTYaTIIJicjsZTkII6IDHCjIZTdJqYc6OQTIbZATjKb5nNZvOahPJ8coQYTGY5sc5AZ4hM5bL5iIDuaToaDedbiIKCc6HRRYIB4YRAaIUZh6XBEaDodDgcx0XBfnDvnxcYbHIDdZxdHTPnMPiTkZMpAh8bY7MpBIjlJJNKB5nDCPqOTDeZ8GdIyIrMd4+dDKbeKVJcbDLxSZETOdTCZ+jGiEeageYPy+kaTPluLLDka+KQzebKuczGaOX2RERDKZjCdTZxJWaTmcDYiziiQpz5CkMr/tyNw5vCNw1oGOi0Do56bIS+qqK4Ma7hAwKZDGhqFK6hI3juo8CjGoqBjgqjDOu+T6Ps/CEDcOo2jFFQ3jNCkTNagYyP4/yLDKp6QL1CMNQko6zKmOTiiCNg7otBSNI4jyljYOsJsCiIQBKMjiiLGQ2oggaYugMb9BEKjIJswQ2Ke2yZx8/48wyx0yDLMyToeNquDqEE3z5MIzDTAwyLA4opqpJVDu85TmI0KqojcMM9uKKChKI1ryr2mD5OAM6QUqqiSNLED2U+N1DwNO6EDIltDsE5CDjkOszIa+UmuUqo7UGO8mPzFUIjE6DiqSkUvR7M4romNy7yiEQpiiJisDeNtRy6jQkCoKgoQoOMroOjKAS4EAxDy5Ti3HcrlQULqNPVKw21QjQqDzFL0vXA883vaquTOILCLQpKsvirryvq+78hBKsr0qiaTQRZ1LLgwF9I0KymW+4roDcM7A1TMsziMOo3TwlFnCCM4zoUM6S4qEUCtkqdUom97ioiPI7vghVDp+4qtvcrke448KyTOKgyjwhGN46NEmZLeQRZENg2SNYSZPciLijmMOZI0N8U6hXEVVbYNOV9XKoPe5Yw01sq+vc+CSUqOQ0126DsWcJI2rfM4ijxvj0oUkqZbIl2zXdwTlbTuO2cQMvB6rYaNCdCEJUNR6Y0PtW5I0KY073yT5usNjiwLJSY2u42uPFlqUIIN6tukizhqtHCSSHSVd5ZBC/MANHIpkpsGcvNEJBB4UG7nz6Ju4uXeTepmqWC6HjpBBskLQOUReIIzZvEh41jK7zixNqfW6gJ4nBAKooCIIIqCK4v0hAIgiiYIv4XveCH0lSiNMSUmQtFT/T5BPDgxBJgZCnmlaScUjhUwQE8gcG+CBNA7tQBKC4GaOFnBVUk1ZDRaCeHsNEXlQR0CjhNDCHhz6MyINTREkFPwaXqF2D0bQgZAghFHCNDRwhagQE4IQ0g/gdCjkaI0DAGIMgZg0BqDYG4OAcpMI8HkwZbSFA/OKcuA4eTikdPESApixEElUTOFmK4aGuEyJwYZujdgyt4hDBEODZCZGBP48Ao4U41qHjWRANxT0TFdJAlcECQTAR+ggRFIUZS4RBaQmePiu2hkrVUudR6DCcQXkORQjpR1ILAXqTY4oTkZo1Dks4ljipGIac+fIKYdG6McWcEyIqzghRiDlF4jQRyzp7llLw4xC1MHof+dBTkES+koJkjdDR8JDtJK4XZkyW3uQ+mjLco5ApAFPm4QUg6FCGEOkAVYMQalVlYcTDJcs1iCELMEUZjUsjixoT6ROZoZgzPCDKUcJC1JYELJNLRe4bjSp4Y5HMOEb4fHYKe3wgceYhQvPYHdIJKiABUDeWhUZ3GRk7LmXUMx+HjnBJAHMxcwSIMsSGkNcZZEZHKKPRqjjN4IoJVoXQxFI2qKmpPSmXdKww0tIfS+Qq6yMLtTQzqHBeT+lyNoQ9DZHw3BwMIisxCmCns5DSe8gh4jLLkjvNAMZ9yYm/OC7SkFOg508j2XVPM0Q4BpK0Ys/zjy+0+IlSwlMZEqlOMMqIiK/aSqnrtMivNJq91Dr652uDridk9J+QQgxCEayHg+dCeS85oPOriX9qdYrAhyNsnsp4YQzNorXSKklenemBme1eAM6kgr9DSV8o8q3DF9DJG+AZbCRMjs2cYtFvW6lUlLMx2tsS22SLhDIKASFuSRmmnkgYKCBApIgR5rlQz/tWexNE5SCWXFJr+U8IYUwpBGhC+ElIIFESBuZaWoRIIUwrhamFMEqLlvRhim5QabSBtILpbUowIAoWIqiwOZJAijhJRxFZPqPYFlsJjfKPBAyFLeJsQgMz2kwlipgWZCB8CHhjPYX3DKKzsUzo2uQ8WCAnhTCokQMILgQIFDIrSsbhCWlWKqSDBmKpoTckGoI6pFXeI9IUngqZR57FYS1CMN8JTHBixitBaUJyZK7McEZbc3SPt7smYBP2ICoKJKpg8pRTLAOFL5P1ttu0JxqggjUrhM3tE9ou3MN9bHqrgYsRO27VlnSxJKQZdBA3Tp5B1O4wL2g6njwRdK8V1XXECOkcGhyYtH6aI0gXD6azmuWUOGmG6+6rSYWeqpMyQTy57r9m4p7cG133VzbcpsNynq7DKr1iyvEvMcJAfJiTD64rljIVsPEpCNNiyDIFpGzlnmDDkXTUocjsL+V+kvZ8Ck/PeDO+B8R6T4BjeS45yDat0HNboykqjJ9wSyPEdjbwIgoWCVI0p6xxXum3JK6U4exVnBFKmV2VSriNBPMJqtwLj3FEGuRs9bQQQhhIBBhxuiE58RBwsW4n+fSNBFk9tHjKV5droKeZwEC4SAlPe1sDl6IQ7rsBYQAKPKDubTQ6cop4TwlmLXHzEiE+lV8iBFzkqnO9m89hl0DoXMHt9FDN0eeVSnKLTWrIxBxaOeGEzlzfmfGumJ37Bz8Jc2yn8aUHgPpvZwQdAqTyPt+rJbNF5os6Hr1MqGi39NjvqhbtuEP4hK4YRs0FRUURoK4ZQxeKRVlyazpWRwzdDLFr5ViHlUe1vcKasPNBs53yVZyAiDkdmEEOZG9wirIoosRRpjyYVizyVs6HPsH+xjUQPPBDyeR2uGElRs3Pd+0IfSeM3SDnQg+L73PTX0U3D+W9T5oZc8lMVz8p431c84M9xqWEEBIt7ENLrHzJAotP/YcxR134iNFJ2ZnWP/zvsIW+DtIPAIF6L2cnAE6QrhpjObOL2T3j6wh63r6DpC3UAb7gh5D6AK4cBaZMBq2hwcCJTYvsCj+orSPZzYx0CkBDPi4YKcD0Aj40Cr75zsEsDTbrpAIZ6LlwKTgY0sEz5yspqZILqLmjqjqxEkGYmUCkG6zUHTmIga1DqrV7q4jTf4Mp74EB8I7kEDPb6KHjcTckKL2b+kFrw8K0J58UGsA0FDpAKbawujMRCLbQhZaZ/YgacAhDOzHoqC2ZwpDSUalKpiyicKy5LQkDZjzS5kNDbcNZGZBLMQyJCxkiGUOkNybIg8KohUJ0KDbMQR6ZFoITcw6hW7cB8sQg4oKxXkMD68LYo8T7X8UMA8KbpEUo5EIKda4YIadZhTYTkbg8N8LMMMEMKhL0WsU6F77K4bgywkVriDpDaCQ8Wrh5yAMsZBzsNBvqQMXbpZ+TE5aiu53ihYmzNTgQwjYsXsXLpEGUbkGkFkX8H0cUIEW77sVwsLbpPxkZp5s5FShbP5IJW0ZJxSkZkhBEe4mUeYujHZnbUIhYhqqSUZVLDkRMb0VMEYMshEM0YcCyt8h0dEAsUUcseIqomMicfjNMjbdRxQOkgxeaUchUBL6UkkiEFIEUY0kL/gEQIbc4NcksEQo8mBO8mUcj+0msmMXr70YsdrdiYxNDd7e0mcXRecohFUnMDjdzespUdLE8dcjBDUpLe8WEYkqkpze4KiV8aJgpzEp8isVEkyUAqMXsDbpCUIqslLpAJAmA+B1McKgY+QI4isr5l8ZYN58LlxccfwusXoNaGizTtSN0egxD+TO8MMwMHEJUl49j8ojRcZIZB5CJ0gjQJcwUvhIT3UqEHkJMwgwA5YgcOEE8I8HoESpQIaWQNgFbFCrsmR1wxxhaO6jh2ANIMw7gwCHibERiy5IYKoKgIwFoHCzBExoQM6jDmbokChz5vjpDobqc0j505rkMxqDx4xB7NJkEQBCSCZHs3A4qUKQ71x5COY2U747jFc2atCEo2QjxwrTY0Qu5ho7BjQmBZJNgmQhQnY/L8A6E0b+cMKWUd8iM/0xAmT5xmL7TQz2UxL7pr5Qb6Ry1BtBEXEhamdCc6UMJr4kwsjXkDpxhZzrLWwkh4jz5ERxZtdA0Iy+TXzmpmba538OkybUwjT2YxxlY/AiauU/aahqC3QEAJkABjz97/FINIZpolbH7xD6zgVF7QZDpGZ+SA5z7VA+UmzdrZ5ST0TVMgQoKujd1AjViB82gqxDYqrOBw4jaClK5r6YVNgOQO5ujVhREibQ5tTHZ0IIIhBT7g6VxSgLo=";break;case"es":$e="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";break;case"et":$e="exEMBEOhEJTmIDadTmdBAcjKdDqcjcIDDEzCcjkYTyLhELBEMYGIiab4cIDSbjNJDaYToaTebo5HhlISJLDCYjCczKIDIbzLBzcb4YczqcDhJIYcJyczvJDJMREM5CSTcdjCbDSZBBOjkdjKchBJBAY4cZDKbpbVznUBpISCZDbJycZTfPJ9QKFW6LRzlDDCYzHPznJzPFJ5NpxOhAdzSdDQbzrfhBSjnTKcLBAPDCIDRDjMPS4IjQdDocDmOi4L9Sd9YLjDcJObroLpIZ9TlMscjJoYMPjbJJ3J5ScpXLZePNSYR9UBrISYbzOaRAdmGpDYajDHRENucaTnmzWaTkajL2hvISpNzKbO0OJCSzL6+0OZCQjzWzzCzKbe0MYEggmDSM7Rv6kCCJqOQ1v6maCCGN42LEOYxjQ/byo8GKpQOMozDCOo2Do/q2wO7w4DYjT+uaggkKzCyPu4ggpronQyP688AJONaDjouo6JuNifobDavrOMbCBAxydjGiKHLQho3juqAYvcggpDKManIOOCvsmMIzxaGL6Q1DkPIYNw6jaMUtjeM0gyu3SDjJEkTDyMqtJOw8eyPHwyqgGT/hEuavDk7QZQMEQgjYO6NDnQkGJE4DpquOsgMcioQBLGiZQyEQizMNqKIOnUfjHECZREEQqM6n7HjYrThp5OSNSMzdRSs4yJjas46hBV9dU+Mw0vWMi10JFIRRirqv0JF9DjcuAypwnI0t+oSSUJGwRCWnLIjC7A3WmNNCSmEQoIuN8H0JMNm2faNGI8Gc/ue6Ktu8nTtBnQwlOrPK42chD41bFoZ0cKwwpsilnVyrN702JzqsbWg6DkOo1ogiNw3fU4mjqOoyM2qzXoeEAUCsJIiiuFN72NjeOs3Hs0qwreJYpiw5YwqNmKolN72xlmPXvcYrovb43DPdyo3UKYoiYFooOrm2iu0Gk/iQKgqChII40mhepQMLaCq0nDGu1TAQbEloRC6jwaYI+I5DPqVNioYZeboOGpVPuZSQpl75bXYwljeNtcrRg1B7XZggsjwWDDpUSh45JgyjtqVsCJDcOw/SI2UnqVx3KvrGsHc9v0yEQaXV0CW1u7Qaz+Kzq6eiEZ9bQw4DSNY1oV1tHCWOqrdbTYjDqN2K9Gl+Fo8GtTwCxt+xaGtjCK/ar5/5VmCfx2bhrbCrb4ycH+hcYpqRt3t3UNYwjQivJqvUrtz+KA0vE7KPBtQwqDLHKWsn3HdNHBso5/KXg7O7fs8JDwbE9BiR+VsMZFTtA2VOd8NhXiFmbQ4GkrAbn6nbWMG5h6eQxEZIUV870EVmM+M2RVdjBjBwRZ6xxjzMmJsVcizcGy4wgsJWhC46Qcw1nxP4/ZdQwxKoChK6YG6fwkhtL4nE8yhgio5iezcG6jjnl1Y4QeFiuV2nmU3FmGjNHInmeYucEEW4Ft+BEDdYx6WYBlKyCCOQIEfmNY6VAG6zFtFER6eZbAU2Zw2IieZ8a00SotBuuoIgdSrntT+lVQTtCPA4UME4MIdkBEsJcrgN5Zj2xYI0ZAhiayEBhTvByTQZ5OEvMWY0NEC4GwbRyVAHDck9x2Rw0cHCpwoM2JWHI+5f1bq8LEVeBTL5Zy7lssYKa9X9QsTqZOGTvzXy2WY7AWowxaldm4HRXJWgUHDjkGcicQQ8spkqtgOh1W+HqPZJVcYTwnAgCqFAIgQQqBFPauqegIAiBFCYEWfZ83XtuV2t8uJ81DOgDCrkh7NgQUKZuDlghV3cMdPnGE7xmw1NPDO88+bzH5hnW4CBuiPw5lHfCfNYzzaTJ5mQGGliPz5rMBKC4GabGjg5WwEaVDMaUk/RMa9cBsnwQNOoLVadGA1lQByuMJoYUc1NKvUiDJWCiERIUpcOYQqoLqqBBo6UdY7kQKef0GCfyPIXBgoat4MgZg0BqDYG4OD6Vud6TksKPytHhWcesH9alNztF4Ghm5/lTkkQESdg08SPgwmcd4n8f63LMCyZAzkmSdlBMmzaTSP0vI6i0HBjwdCdmOO9LJPlapAlXgtZayL47YWVo9R5fb6SEMcnAd595/mk21guCA7Eujv3EpBSJC5/iQhTkyYRAqhnfELW4gVRwVXilBDuRMr4ciSJRQwe9baPTsWGboGJ5JHwYqnCcmeEdZJKXqcAxwOB1XJ3EPAeuooZW4XLWY/l/d6QYgxWwgEheAkpH1scRdAq6gjl0ogxINMHQYp+JDNpBLIzZB0KagmdRH1CkhXK5yc94zNt0NHHaVBZwyEKtQQuryUQZKOrHAoNQdScR0qqfqEwYsZKbIMwgrWQSE4wIcRAiTCCwhiPIqQsZDiWTTDEffIhDzH1pQuDJU6H3D4gWNZlXZFydprDNBu1uWVmBIcEl8GUgSHktaK0fCq40HBuNkqRIyO7PhptDfyaZfHHEmLwX4NiEA7p1xkuoKkaCVhuPu8QohgDBBmQ9HY6BJw5mYYlMOVid07tlX6ZEMoKA5gpSivA9CFCS2rVoUowJJiJpI1gHAyKXDK4dK0HexCEyEICxSmlI6FCxodJ1qdQzsDrHYQgdF59KBa52sqQrU6jkYmVJdK6VwYb+PEY6ZgpWJNLHRS9Glrb/DBmVzOR8GamyqFWKwVpLRxH2JN2WSfbyPyck73qRbTpMD+1zuaYLa7pTJhlkya+vr1I7Y4JZHnf8b9hTEk7K/QrZid7xOHOEigZrUFg0iYEyulIFb7leY7YJOzvq5yenUs5aQ2LEQuDNZhNWX75J5aBLZQSGEpeJljdS2AnF1DJzjLqGHxlfUFaso8DcUWoXmjsh/DStBQCQ1hEywVnYusqyMg2pt/rqCKdKs7HcVdYxa1xC7U7mhvvQcVXYQwphSCNt5SREyj4HR7uMOxKtyWVDSlEGihqp1VJXVcnZ1NkshIoV2lAvEfo9rQC4EGI3iF6IjixLpOyDeAUcElNgebNJxK1zoreLNg2rIc1rrYZrvKfLev0uaPEKETDGhAxVqks+Z8ApsKATwphUBbF0h5OyV4plcVjCbmqthy8l5QifiPZse3H8KOdS4fuR8xuPIIcA0BwBaTpkIdPAKnzBsMiZRUIcIM3egwrSgmK8g14fCYIAjNXyESaJxSCTc79b6VZL5hEKN7nrtzISLyFzwBxKHhdqOaVxOpih9wEB/4iDyDhztJbCX4oQnTawsyiZaZ/Q8SxIGiqS3gOo7B0y9ZpJHrhrOR1wkLIKSbgYHSrwzB9KPzqTybqohBc7FoNkGQgxFBQyZ7dDcKPAMkH0Fi65SZZzCgGqXBmDAR5a5oNIPRL56IkJByJzURFBZhGJUa1EE57g97Fy6pC4Gp8btipoiAraIJ6hKIGpdSqbjr5MKaaaTQMoO4/oGx15xrCh+4qaJxH5wjyB44N0PJRx1R0TgaxIGzdiwKqsE6CQkKFTWAsxHKOUSBYxRArEGsPMLgNI0YNYN5AhC6u0SSGUPpcbAxj6bibibwWptEUhdQIZCgMZHJGpP4IbKC1AscWhBRC4G6hp2IUjA53ScTCQM5LwOTD7AiLCjoycYUYhkYKgKQJII4I4IoKUZYG73hugwaWhGpU4IwlRxpGpY0DBx0Bxi8E6Pa5puhhKJJkYIoKwIoJwKgKcbRbCHZZ8dZcbZA67npGpdSMSNUGpbg7A/oHBP6fQKgIIIYJAED1RmxIDMSiYvIogox8rnxKUYIUhqCkwg4n4k5ICVbCgHBRxso1IEEhDIArRmx6wj6XrERp5IybjaC6jTIhCbjG7yEG8lwOsH0jQHBwA6qICahjrHBKIHBF5r5sq+sjpI0Bx9JzQNZh6TUCjn0psmZorWsqMCEqgUjPhiDyJtJC4HBbAJcqpiEhEVJcAhi7wO7OSvAkLGo6SoYOaopOK5Qj4HJP8ukDku0vCo7Mac5gDqRKIHMILpCEztEvbGioL/zpI06rw/oHJTctEsEqyDCoMyiXzgytBj7gyOgwY2QuJUUyi+YqxSL6sz01jAQHJxLZQOqk0ykC4Op9aC8ykEZlsCKbh3CxIHJdS6cCah8kTZ0mx2ZPqtYkIKsJRjzZsmo2Um85K6Q8Q8jIMBrFsqQhirUwxQgGCASeAsK7k7Mr0Mcq85MJw9Y6T4QrU7EB5zQhJjoh8CoERPxvM8M907TSyT8+hPyN6eA6Sik7xZj4UBZahHbLpPxyy7wOCrywYmQGBz4i51cQlAJcE7xdQqkSowcXc9k8SOk8hzRjjzEsYmS5gglDR/QwZI5uhuxQjAYkIJ1C9E0Q5/yA0+q8IgkfUAyvk/M8q6k89F5U9HaHtHs8c94hhuhNDnMD1INE0TMBSF1D8rpzRCE/jnxQsBKFpaSMaQiiVEcJc57Z86M5FF6QKQZmtKdEIhkCRblEtHB8dNByNNVJE/bFtLBMC5tOQiNOk/U+Is1N7GZP8y8sK2TGahq70dDFtPidssFQCstNYzANsnVNzskn0oBPrGbC8VibqpZ/lH0qc807omSuVTabdTqb7lVD1UAhlP8+dLDLVU0VqpaiVVlO0/oGSl6dy1AFq/Beg0Yrwr7shLTg4rVFS3x8wldXxxlZTlKFaHi8wXh24zAwdYBtykwsyBVYgMThNZVSYUhp8G4k9DcDpoo6Z+a07slD1Ygq1YzHa1CEwldTKbNTkV0WE+rNsKQ0YFpvqyDGZcYIgIRRsOEU5QjVBG649YJt9gzY5g0DhkhkxlFPsCFV1QJgbC9hwndiBk4FNidUNIFUc+rddjDxVjdiVW1K1O5PrgBACNCNRkFh5ktjlgyZ0dwuCrtW1NtJ1kULlmzIondVdI8/VMFdNLAGaQNn1nFoUCFlM/oGc3SGYOdpIxT6h0yuUgVlyrtqQXkd4g4FEeUegKjD7LUhRzk3BUxQwJibhLVQxtgqaVhQgGiMNtbqM0o9a5AUhPNrdroijQon9uKX1RJGdOdnNUVQKujEVwUdKiVoNEFOtis/oGhZkc9wdPllEHdyKGM3bSh4p7R0hm7LVqAzYOFxVRZm1uNrCLSrtzh4zgZYpeNrJLN0qMomQGp/BLonJ2daJu92pRwJQ14zdwtkFQMJokN36Gdy9K5PsKIgl494Npc+CGVV95ZlcU6/El9XJZiMUEyDtXLAqNF3ZYpcZuZutaVj1Nlw0/sN49FFt815NlRZZP8Sd3d0EPxBsXqzYg5NIs7m4N4ozRBZZR0WZKwNd/Li1/h9xIdLERkK9/E2+A72kXWAAmUSNHRD5LZCeAhZcc0aAluAt4U4dQIG1yeDqjMAqadW1olkIGUUogk5hLOEuD96E7dzGBd0UZ9cEYeDzMKHi9OFl1LcmGGHMaIFEacasa8bJa8hS/ha8INqZa6vcGy4uEFStLEba8WKVZ8fd863c+VQIG5U6Psg159x0/U7mL5YwJEoixCtBkYJAnJCgMlscdgglylxZa8fLO17qu4kJ6YlZVuPZMJr+OwyuLlYkq7rmOQqBgorGNt0kDLgScRTFjtW2Q87ptU+shI99K0QomSSw94N53Mn5S9q0kzEUz17qW8SVSmRA8I8cS9TBcRU7ZB2SEuLq3onRHIEAIZiQNgFYNcTaH6/Q9ZPsoUub+K3bGDYBO4KoKgIwFoHCOgNxK5OJouYpnL/I3Qxo6RsslwMOYpbCOE9RzcwSOgnE6DaJo4GQHCqST4NIMwPJcRdWWkjp2b4i3lu2XUgpfmfA7yWjv5dN2DhA34kq097sxA5wN6oxqImSiw5wMpCkqjxy/s+syokKTSpo2RdJvJh89UYpI5Dw/aJJdJY2RgrLslfsBmGdFiw48kJdQM19jGRulFAE9ulb5CmOFanw9GmuLkUJLSE2mEfqjGNulOm2MtH+EM/s4GniBhIB9Yr2CAsIOAlouMKjnxeBP4KeDIlZo5eCS4upCRCmroqBeDagx4O6B2saDpeE9Ld9XxkEL5e4GBU57NFcUKk2E8BcxheBYyvgzYhykxEwsAMoPF0jgQl+udLRXMXZ2+UWrwGBbFFKqp/ux+ueobHJiZM5m5eBdQKWk5e9E4ERgpJRM+0JQwJ+qkDyE20J3ol5iRB4rG0JTaHYq99qF5d69bEQi6FmtgGKN7FGl0l5fF7Skqk61CymvSH20LAu4y2RfBcZwOoF0+3JdQN5QQO5my1Be7C15t4CcQnT1WaYn7D5gZQwII7B9J4Bd9TVHQtFdQ7BviIKyAkKEF8pGgPo=";break;case"fa":$e="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";break;case"fi":$e="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";break;case"fr":$e="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";break;case"gl":$e="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";break;case"he":$e="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";break;case"hi":$e="exEMBEOhEJTmIDadTmdBAcjKdDqcjcIDDEzCcjkYTyLhELBEMYGIiab4cIDSbjNJDaYToaTebo5HhlIXApFC4FKh5qn5qvpqrJxOlIuBBNVVPZquJqtZqsJwjZqoaKpErPanSlIrqbT5qpZqqKmqJquZwgJqgqnVVJTlIpKQpVJHREM5CSTcdjCbDSZBAczKcjtfxBJBAY4cZDKbpbeTnMRENJopEfUZrWlIv6/TanQMvmVIvqnR8/SaXW1LUJtaaDU5vOZ3SFJQNdQ6nk6pXKHQaTqrXmZzvNBpKzptRXlJYM9ZFLZlJaJrarZbs+LBAPDCIDRDjMPS4IjQdDocDmOi4L/Kd/QLjCZDbJzcZTeLpIZ/KcDCczmd5IZO7Bh8mpCpqU6aswqipk42CxNu0beuWHjyjC/64LkGrIlknBEpqS6akMmsMlIT65BsyMFFeq0OJqoSeKyuQbsinjZs4WS5BwyJWtgW6erkHKQiEPK+jyhYyjauQYoEggmDSM7vyKkCCCIi41yKmaCCGN42MIOYxjRIYyyKuknjKMwwjqNg6SKyEnjSOY4DYjUiwqggkL3LyPBjEaCOEQSfrPAUixdJCTjWg46DeEA6DCMQ2DKg7tL+xIxpOM9Dy4wqIocxSGjeO7HBjGqCCkMoxv2g44ME+wzzqj8eTDMcyoYNw6jaMTBDeMyG1FUgQDJNc2o0Mq+JPXaWOvRFFDKxwZSOEQnDKwI5LkGUnBEII2DujQ52jKiRJIMoQLwNg60ZSiKhAEoyWjMARCLWI2oog6/UWMczplNIRCo7NGDRK6+JSOVd17Nw80kii+jLeSWpehDEjqEF/BBhl3DMNODjIxtoziEThKc07SrXaM8Y03LOtzjsQMraNAZFD7RRMUpFw057iJq6TguO2BXWjT+RNEn2RqZBrUFDaNWZE1sVNg2ShFwuQZ2WmsLlLD8N5IVGm2m0mTONn2XEAqeo6nAiv6bbbKNnFebE0nBAt8oRBabdU9K2Um1Zuz6plNsRSEs2DbbejwZ3s0uTZc5zYprvJSajt2m4y18Y6gzfEag3Tm6bkK7JTpuVbkUme8nkhSN5jnGcBnaa7U2ea49BUCxNBhA6boopiiJjeMtn09psuQaWWJAqCoKFcDjcSF95JwtoKvk+QZFS5XPyXm8e1GmC6jwabK2+pcpFnr7jzzcLYtWfFh3nBe1D/FpqW2x+vx2T5Io+TNEUay95kKakjx5Fqnt2ZMmY4cwrRs3dIheu5wmzehVk1F4hhyjJhPlTdw+0x7p3wIMY4ahGBzH2M3ZM0x67RQoEXJawkNyFGnnDQY1YjwNWsOKT64dBgiEKPZdS2yDzpQRA1e/As5r/zUQdLFB9Cj5zbIbgAWVmJs4hIUfeWR+DPm/IUfw3snDMBSIIgIhSBBajlHMcMjc5aFILFViTCozjeWTCndG5Vv8O2ioAY8xyLEX0RQpKUcsyqOiPA2hejAoUZnqG4gi9x3RnGfQ0j69l8bMzeikaBIlET335O6gCVOQDzBZFXNxGYREFAbPnKwcooUWodA2fe3xl8D5TxVaOa9BjSjdvMcS+py0fYER5NRGaASJ4ZS1jciKC0r4op8NmURrMu4lQqF8iKOMkG9PsNmjlBiA2SSNY+R4G8KUOikdez4uM2oXutkdN9miLXszEbRMZpb0UFRSLOi178un/y9bu8yd5NYpzafPJmGUm58N9njNp98ZosCIkw5VGRYSxzLT2hObUVWWE1ZdFgS8bYtzalzJ2ZbuEWs7CmGkNqbVVA3aKEQOpeUaLLVCs8vy6CPA4WmE4MIdklEsJcRMNobzEI0W2EwjQbw6kMVsQgMKwg3U1pvCYEAdw0h0DQodRKiwQF6DcoMxwOF1BUqmt6qyg0aL2CgHKkRF0fhhXnTlhxhC8hsqkseqqgmL0xoLFcmtCCjQxkEzRAlDBSRfT7RAEQOIqwLe2g0oRyHtCARpF2B0MImQUBxBZ/RxypoBgvOpGkz7K2KJuyRqJzIDAiBzCmMz6TKnAr8z5nJHgcwvflJ+R9rJlorFhatlFrnstAQKWpqJqBVI7e/ZhqiF57xZrtAkUkDaM2kfOIqvJa2vmrJqghBk+7SPviGcx1Ih7pm/urQKW9pGQglBcDNW7WZAwxaHa6BEPmfFCoAKSzBomoxYKkzKR8Q7vR7gJZc4RloMldJxOG0kFrMTWt7XwrOAIPQ4Ms6Imt8EUuRRQgt8i5g5hCKmcqT9ggczPwoKS+UEicCMvCKV3Qpq/WAObh0nGH8DJGWWR5OwMGsCljUgMUsQxUk4flYY2UYoBivSKDCRhuJvlTm6KqTgpYcTkFJNI1DdUC4Sr/jEs4P8jvfb4gy0OR3zwDd0jPG777Ps+ltG9I0Vcmv/v7Bdn0yMSSzZO5BxRqmX4ONFOqNsOc9Nejlg+PZba+nJodjAUuMsj0byybOU1AyPgwgtKNyukcXk1EoZpzrnxSOJsVdZ8hZSplslVDpI0z9LaQjcVPTd0tB3Fl9mmVmkgYpGMjHkoQtdFP8bnFBm2HkmwvihOsyWtgYvZsxFo1AnjYZYLdEnKEsDMWC1u9+ic3rktUOgbhmpoXw36fIk2UUMZVGonNse8et33nSQKcYX+rtOMjMtkZOyd9cyE3CyR3USHqJNo3ip1Det05sU8ZGRGFW7QBSbM/ZlFGcN63clOFN/JYNAwGVRKcL4zCDujksgxtYgHCn87qIRuM6QDbdk/OJthK2qQ9x/bdGH/bWBk9nEeJb/YouRwLT+itGJ2BkurkJFS+chISQtXBECJEUImG8MQalREMMMGUliwAQBiR/0gh6+wyKdBkvZMy0OhPvyaVOysPoGwwelZahui7A4zBkyEJAbw2qq2SyoKZDyWhuDOtnoUFn5GoLYgW3mteetC3BKtoL087a6N5xZ7UGs/380Dg6IeEMGbx0RHrTOj+gkfBlM8zhyocZYwS3rl+gysQ+vm2BmLVfF+E4ggwXB1HoaFQKgqQsMmfYsrztNuwg/Ztz3TnTbsBMCpfhTYn4MOPe6eKxxg3F+Th3/n0c/J9wHK50w8geK5wG5ij17JxBe3+3+hBiDOF/rXuOrfBz7jLQPV2QbCKSbqH/enK18KRqiczawGZ7LXR9Yr78yCb+I1AUg6h/7jyC7JbCZvS269S77+73bmjuJL5dQuxcAvYEBUwOQlY95TJLAM4k46ikg+6rwN8EwiwM6o4mBL7cqyLtxkZ+SLDjL3orCvYUiagVzXozxtI2CKBAoycAJ9514XLPT2hkkCAUhD6PLQTyY0woSYjkzgiB56jlj8z10Cr2MC7OB6L37y68K66JYs0AJkJKBY0FRXashZ4EANwN4hglIOoNzr5L5lQJxQwMkN4v5L6Mq5KvDeiRzeBmgEAKAJB4T7MKZkbksAqywFAgwFIqbbK4w2Q1CNjzqMDoD5ZOwGaZ6gyu7kURorER7KcA0TbWx3oyKzEBCIbdAEAIYKYKQIyhLxgtSIbLCwxD7jMH8CJkkCZkrOKMSUqN0Twj4GiF6zDzLQsXaZa35s0LSerBzBS/Q6UX5kZ3Tc72pmzT0YT/gqZqjGTPUBxloqzkJ5gUSBi8Sh7GZ7EVr2MYTN7QD2sJTQcZpBqLETTdSz4yz3bebyEVTz8YsMrYLGIqbaL/qdr4KUrPT/ozjFcDCH7awGh770ptcQ55iz7tY0AKAJ4KYKg1hyqdYuEkZs6XwtUbL5LlcbrDTPRD8WEYDtZApqh0kSCxTKTjKNQoQWx6Mda5cdsZAGIGh87s8Rj+ozkjjUh2h20mY2DEoIx4LPTOMBDHjdC1MCjQa+y5L6w6D8wtTaLOLDws7eTWBkb+cgK6jOr677jxkHJ0csCvi8D0EDJOwGh98VxBLJUk5pCWL7soYGiV0khpL7rGCKJvBvQR8cSfUTsikd6BDwZucHjwslxrJ3R1Kxku6Cxup8su7VQ3EQzQwy5OCPCGKehBYtj8ggwHTDQ6kRMRbdUHkU0Y8VCy0dJ7Uqo2Eq72sbLXROBac3CMzOJjh3TJy/0lr+0L6CgGIGp7L+C60jsibNiHhF6hULIpJOEozcQppOCustr4MrDny0c5qKpup17KTGYGqBDYsdpODBDQpn0mSbz7aes+MoYGqZ4yyf0yrbTti+MMq5jxRwc8TNgGyFIphwgnFAyF5/y5A45IoGx7KNQ1CSJuZmzw4UhG5Bi6yFgj4Gx79ByYk2dCJ89ERys2Z6KYC5pO5981COic5OwGyKq40HhHJwlCKBCNLxFAyC0XkKkVKxb8DxkpdFgGyZ67rkYoZP6FNJJAygMMwUh2JOwG6P7fcmqRyEAj4G57JGEJlLEs6LS/EdlFgG6ec0I2Brq6bfg55P588yS2Y004xP5984px45k+dLQGIG6KoTCWCfLdTNgG6BCdSPlLaCz/KWB+T6BP6Z7bKir2L5MBSXwzlQC7BT00yH7tjf1IMHlBIoSANAMA8QriTFrRL9Muwj6mQyNTxyqS85Essub2j4RFYX5IoHBbZ6A8oEFW5MB5L3KC53UHjiYj1YA0VYTb0LBBht561VRNJ5NJVT400KT9ztj+CSqRz+ivxAtG77hBhxLK73B5dYNJTdz4qR9DZn1DLaLA1aNVzUg4T1zBhn1bDxqaFJ5u1bg3DT1cBmlcTcFTVYdZR3Nc4tldJjzK75dZpTy7RvVbq6L39Uq/Qtjy0MJ7kIsh8Ua/UBB3T6xBTF0d1W5PFX9cdVo2dV5kdeU0delBdbL7Qz1fR+Y2FfrQywVYFk1UCZc6MLj942FestNfDKVh7OR0FhJCdhYHCBFoVfdmdiU1KYJOyyYyNY9ctgYmoQLJ6ezK86dW7EUqDCy+i6K+4qJIq0oyLnNsC+qB6/DB1G0rMusx9sr9tl0s835OwHK3c68tA3DjAqdtDPIg1sqHtr7PLgc/8RjNgHJ87aNWb6DQ6C8YRjiHE4bWwHKuo2ZoC+dxg01x0Jo2Bw1mjL6eDdYHKKooTdyhr21srRxnztVrlu7SomqMVaiGNflp0llyqZ6bsv0bM9q49mkJz/6X0siwRZSbjhRFcbNtSBJs43h1yX14S494jAxZSF93aWAV03DWk/8xk/0g7uF4rJE6zPC+d3xm14F6Ey0ut8J76fyhaWlsF9C496N770JZSftvS+dStNN9N70Tt8J9991sB8a3B7oERZV0yGNDpaIGBlU3F80RgQLLgmTSlqY2EHKZaIWAq1uA4GCZ9E42dFN+FwrT8xV7sxdVFuImTXBPMtljtFDlFgs7ibOA7W5EhnBaLZJCyGLhIUiRWGp79Qsv6Y8w5tExNz1+d9V6eHJ8+IRnyWQ2jcWDdFV+Ngd7sJ2JeFbNEwmIchiGVQF4OJTLV4rfGFuJydjO1HeEl+Rm1+l/96lPbfJkyXk+OIqXyNUKUceN+HN2OOajtSkINjT/2QWLOGs0GPzzx3GKmNdeGQeH2PYmRZVVix7M2A5aQgdaBBqAqZaxS0+AeKz2Kb9f66NZBk1c08Judg9e9o1duTVO9TuSl519V+mUdckRt1F71WMBOVI2FddhWSLnCx8m8GqXmO13+RuPVVF4rods+YRyuTuRuNS+ePF7sQeQrm589H6xGWA5adw2EQeZN9d6gGVFzcLxjLDV8YVGo3FoYV8mB7iAcabDEvqWEbzfabEYQrEV8IBu0IRBkIifUBjtltxwmd7tmeLOw0UYTlx/q9mGCD+fid4qZupn2gAyUs2fKGJxLjNDdrZs0vxmyAbniLUiTt6LGiVw2isxUZDm6wuZw2eaCMeSKBGdZk2dsW4oRGRbSYeLmJ77pbT0h0DNZdK02Slt9MQykoK5roaF9BNAuReaeUGR2LGMd6kAQyOpziDFWY18+qWN2ZWqx7+rLbWrdKBrl/uql8Gqx8+sZwub1KKN7oZ99Px+GlDLMxByebr2Oa2qpdNPtP+QGEuRmvWR2vmtRdKBGuhFeu1/aGeauSGA4GaC2xUIOqFqGyKZ+ymfut90euMVmFqaSHE4paMZTfKZmVAtu0h7KKEz2A8i2Cz+V4a5NityD8yS1JSamj1p+pcooyNOzO9PGrmI95+JN/2sG0lOtlu4FIOaW4eWeMWw5eqKu36De5mQO42qe2W6O1y96vQ3GDWEeoZerwWe9K99WaWy7sNr1gO7+62ftxBjCFNOB8W827GxuzpjGptnxrMKW+eGe1ucjZQ31ybfd3ueu527Gr+cRjC4fAdJQtkbO++5+7Ga4Gp88ZkjMRvCGqHBGMPCmvomQGsvPB3DVt+9GpYGqKvDD4UynE2667GckyO8qDGzm+HEO8iM+fG4VovCetN+0/O2EJnHWs3Hu7V+1A/IMyeC+y2paPwyNJz+t83DutHI2llCXJ9FEh/DnHnBO6HI57/KHGvLvD+7buZ8/MO8O9KVF8dL8eXHewW4mNvL3KyKtLxudMEYW5vLnD3H3KyBHOyR/PHMXPnKt4oGyC3QE/sm3JiHTuaZ/RJvXRfIlQJlNTLeplKF+zSd5lJ7NR7bdidZN6XA/PfKnUXMtMwyPTzxjbiRz9CX+KuJHOXMl+wG58/VSi3UGU2wOMHUt+ulgG6J7LUVBky9uA9Pm325W6tCAmVQceLQmwU+RlKCwtlChxF1/YxVlkmGXEvWNUZBlODLGYuveyFY28qM/ONxHb1lmU0Mmwsx1kNZoGQHGopk1sfZeA9VeFqMyHCTZc5nUAc++XYtva/eTolcd65+EbO/1DWXtpz00xuFNkImQHB84tRAsKLEyFfLRzqaUfd25ue2k4dNdjAIYOgOQNgFdJS4y3s6elgHB97tVwiTYKoKgIwFoHEUk+cUS5RArfrEz7DR+k+Ruil1MIvl1kZ5VgGUtSYy7JkbsjVIXce49YtcdqmW9qzz6brdPcOZGQnYXeHifP9/OifDJBW2jlWXSzGfUQpnV2NTXjpAXj+ba8feWD7O2fZ/7/orEK7xka3gfUEes3PkfiEbViB0CxXlavTmEJ7mXVflt4ts2FudOemvCyFtnXPRq1+HdIj8rX/Ixoh7J+UB1oYUBonBtTWXGDj0dN+5Qtme3QImp+pBn1Vy18enM7GKLO8JmUpFUuPLmFGR34EsmFWA90v2yTWGKZLAiFdz7Bk/vrks9mn4Bqn4Xr+lgHPsV8n5J9D4MKUr/3+E/d/6/RF/P7fKX8D2P6ruH4j0fR/8uiHvLtG1FWvgMYy5f33OHIvUz0JpxZYKYlsSGH3GmmOAkKHsL7AACVlcwua+IIIBTF9gd4A4lwJXADX2v72eT5NQI1aHdAnIAa/h+0/wPrpyWJwVMlURYNMEbxpwxkPuMFCHAZxMoRcYgB4A4BDg/BTmAGmDSUFxy4xIdm/ADIEMIC9cCCB2PMJJDgGCrGZp68/cCMpoAZM96ssCdYmkj9igh2Eg8HCluQubDZha4rglmZTiQ1ceyaiIYgmhq7WImiG4JbE1AUY1czGNzaEEKjAx+xgCb7feBOxq7ioN8ixaPs9WND7l7QefTUDW2647oOk/Pdrn7DgIcVL2rLfnPcmYcCg4O76LHj8kzUFkmeCTI5qF15A2QhTBccHwWEASMtxIR5TMD9hwBzdhujBDcE1jUY6F28zuLotrYVKyABEB9A";break;case"hu":$e="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";break;case"id":$e="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";break;case"it":$e="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";break;case"ja":$e="exEMBEOhEJTmIHGgVe6UKjXKiEu40EknQv0pCUy5V+hXQpkDCUZCUFEkVCV9GHGgEEIhYIhjAxE6FSs3OtFg5kGhXKoFjKZXLRlMHGg0PQ15El/Q0zRokuZBQ0jTaGr6Yg0TCVW5Vevo0nITEUCpoShJNCU3EknPpYIhnQkEtaqkKYgZOgU/CVe6FUjXQqF5OJ1PJA50IoXKiqcgVPKJVaxpMCCZDaaTcTjKb4RCqhUkHVEHR6tCVdCVVY6HRc/SKVTEFiVxonMjlK51smqxeK1XF/XkDYLEgbJdLNaJ8KB4YRAaDkZTMPS4IjQdDocDmOi4L+ud+0LjDksobsuLjecjP1zgYTmczv4zJz4MPplNJsPOuYR8KbWNaEg1bElgiRRIksRBkQtYbJgcxLFgjpHqGViJFmqqromcxGF+cpClKtYbv2QyqksoZVrWHCYL6QC9E8tYcpgIQ8hAOY8jmOgyjatYYoEggmDSM7oxsl6CCIMI5DXGygoIIY3jY8cXjGNEaDLGy2yA5gwjqNg6Rsx8gDSOY4DYMI8xs/SCCQNIySgloYwOgh0ksURyF+n6XQ5HLKDWg46MwOgwjENgyoO5YzDK5Y3DGygzhAOknBAMY6jlQg6BAOQ3juF0bRIggpDKMb2IOOFBhA84zzQl0VymM0qyuEA3DqNoxVAN4zUlTdOhAMkuS9MAyjIEDKVsMM90TPk/UsoEcBEyw7UGtYZR+EQgjYO8wDnZkjBEJrxjKEA7DCNg6z/RI0DCNwQBKMlmSkEQi1YNoQPRF4yz8McsKBLQRCo5U/jRJNeDNJdby7L480Pd14XkOg0jfcg2jLVgQX8OQQYbVuHjTeIyDnYoRBlMYRIkuDUkGuTP2ZNePKI1ikkGpbUtac5UFcdJQxSoE6ZPAajkEWyjHKSBG2ZTGTqi1qpwlZlTZO1Gc5VlmclytYZ2Oob+kE/5BFIoZZ6hZxzFgXDaE0c5NOCVepv8iWsEHrSWhnazT5TqF0qkQT+5Dmi2Xsoa0kGUq5lcvpWnKVzbImcpSEScxNlpqGOqHD2QxAQeykDv5UcDwaJElw3EcVqGTMAnZY6hmxzluVB0k2Q2oaCdBWlMcpIkVqGkCmKImQgoZPayoZEsdY4kCoKgoIQQbSkEqhBFQzkCpaGlnXN4i5auofmBEGm3EFspBlSoZQMddJyk8RbHbyQUIkHB+WluobF7Ux3G/MoZQ93AjHZMdJAFGc5KlUx2bDmEuKJwQmhyiAFIY5oJm2QoeEEKMiT6xBvtbW9ZpECjQQMgcIKCEEj8rHgLAcloNVnDpEq+sQIlT8rWHSIEXA5hFN3BqulNoohzCVFgflezqBDE1EJDOGsN4QsdHSJkUjhhLH5c+KQThNRRH5ZsOQXYuxzCEEefmBIghelVeqDVpEQxGjpFA6oloNoPCIFtDxAzXBLCHHKK0S8P3MjkFwa8QRHxBPjjGtYcoixKjkF6JxAzchBuPNA5FsrhRCvKaI3QocDn3RjXsnATsbRMIGcaINyL3BBFiZ0VgdAoRUDnFILpAzJm3staYawxLlXLuEc04dxLi4xs2bm3U0AnnNyxQNFcp0jG7IGaQOYVAqYhiQQ21J6baihidi0htZxEpFPIKcIOZjIXqg3bcyiVBq2Wy9ElH4Tg5hETGJaDduUi5bO5IqL0w73pyt5kGh9EMcY/zinICIG8l5CFDkMU8QJIxBElOEIEs4gi0mNnKyaPwvxziUFQhuWk6Cqt3Bu0EKYaQ2peVIDdpARA6rdRGsdTSyg5BzV2iNZwTgwh2R2sBhLCw3pnRGtYJiYA3h1UirEEAbQwq+DdSulrCGFAgDuGlRSwk+raDYnZjKI10hUWHUqpiI17BQDlRhISLgwrzpew9Ja3Q2VIT8CCpYbk7saBwx2T5IRA1soBQIutBaDpyBwyaIw6RByKlsiOiL530s5g21lEbQQnhOBAFUKARAghUCKiNpFhQQBECKEwItjEVTIe09wQYoGes/JaDmZ4gyovbfkymzqKlrOAgGipdM652oqkiLh2Vn2OxyjwCIHLJgSguBmrIc4pxJIqloIMSpEn5zJkOJJABQxBlDIifxCRCTFiBEaWWghxKEW4aCOYTggHDPtuKIK47aZDlwemIIXReFyhzCEZm6ZS7sg5grcS4zaJ5kKkoOUTjyje3WrkWpNIMFjktwCs4GAMQZAzBoDUG1FUV4Bj0K4T9ayv3WKWIERY7xeCfRsDBdI5xUykwCvZDAg8OsdQqhdDOHZTCBLS5Rx08nJOZligk/4gSlx3mFMQTJcq2kiJJf67CckbxPF/JMVslcAtBklJTCpYTaCZbBh1pGTck4aEfa4RU7iXI3JhlYTGTzfnBLqJlHyzhyiJEVEOEGXVrRyEaOYTAjjSTQKHZoo5ijGZEBjIJnBEmdmfgGOcXwqXw23BiDFe0P42iXR9igS4pRzCZz45+NejSH6OTSDG4bxppvV0TAlkV9hBkleKj6Cogo6GlEG/NAhQxVaHSK1IQd1RB3N1eZ01gr9ZJpWaTAgxmTRnAIS4StgizYCLMMLwWo5hU4TEHFkidCyEwOLCQlBogRQEJuLsS7OCJs3hvHfcRkAEAiBKzkm/V/CwZlwAS7BOwCDkJFReszIr97Wlixcx3l0pwT224RKthdxBasRBqoiRi3jvUcyRUi+OCNEcI9P6t+Ft34IXslcOSRX4asuLaSZJNBFC2HMIXZGesccXBlKYQZZ2Q5cwQzYKYZTpKHWpr5oI5xEi5x3MuLRCTXuUNibM2peC+ixHKI8qkJ+BEJzHkKg3Kr5tUas2lCLlHDCxhrG+GxIHDG25SIHOlA74CCXMQ8Qw5RfVsKyIYvgqRTYUv7tcQO2dt9M29kRqJMEMClMOWfpgguBmbaJrpkJV90YgF0OcTMWa2s9cmSfwXTjTR3NFdIlJHxAzM8n48Rwnxyib7vsgQRI7++drjkNKNoeqXLk3wzuZdSwF32+20twu9+QafY7voQnBPzFIeUXyZKmzNV1J1cS453FZi2wQnu+3Sye1XS11r5tWxFkuh8bkJgzCmHMTe8nw5e3DlF0gP1v2+5m/7twHvKUXy+41vA/3cykKCcET942/6fm7a/Z9HvRjpnqtjMIQRAJ7JAR+gRC6QcwVrawsBBr7Lqr3jHLk4VDf4UpqhzTCTuTdrPZKLlhpQ1RlaVTfrkBtJkbPIRgjrk5rDDDIKga/72q4Yq8EoocE7ikFz1KgxKJoIKAJAKDZLZbZrZ4dDaLDQRAgzDTxAkIQT+DXEBMAjfgQYsC8Ktjp8F71RNIGaYLZQcrZjZzaDxyt0HA4cHRNIGhY7OEBbawVQIYKYKQIzhhlozzq78AlT8SL4QAQJOB+b/Tur5z/ri55zvhwbQjQzpUIjxwVS7i7wUi8AiSRw0B7RxDroiYdAWygUBKgb2YnzYJzIcoUQiIQQ4I3z/b540zb564yA7wyoy7WAiR5CRTT7zAQI0o4AnYWhnsTLpbF40YQY2xlqOgSRNrxDMLuj9bvD/xLJdIKAJ4KYKiU5pbr0RohK6rsLsbdz4ibUaIt6+y9ETwWDbLbrbMCYhIRbey1RzBwsaa6j/cUkPz/kZEQLEkdcaoVR2p26+i8TUhyYqkPIIx4Qc4WoRihonrPUKD+MKRszw75kbhkLHz0hCbqznyaz5kd8Uz9sMy2oXDOMBjOsbUEJpoqTlDspLMD5lKbhp0TzNTNjJ72QhL2jIgGi4a55qj3A1qORE4UwU5LJoKXKGxLJpAc7kbkrRAGpY4g0Go1g16CJrLDQTUpEPIEEHoKAc0LkL0IbaK9ZMT1g/0pwgxMSbLjxBz3KCBDRNKGJDrGREUs58q8xrC9BMUADtwvoRAc4VzTQlzBgmCFaFqF43IdAWIUJMRmzNLNaIhMTnL7oxDOqiRu0Wckks6+Z3SeJ4q5cGkbw0IQZvZvpkhNKMg/czYoxGwGyZ55J3bhCR4lwGybK0aC8R7+Upk1JNSc8iSbS5rhY1s0Z8s2o1E26aUTyWBzszx+CLKbs0aUwQRlRnIWUKLUDBrvk4KWU1UnoUgSyvCvQ1gigX6djLc0ZpAIYJAIoIYJYh6M4WgQhGwG5Y88E8U8iMyHieicKcc9K0MBMyoQSv89KbM+x4yv7hs7a15NKczvgTYXSAcVz+gV89LEgXqAQXiKtASS57Q0Aj82QG85BtJlh87UAG64cEE5M9MnoQ9AwRQTc9K+bP6Traaes+ZNIHBY6xYKgIM8AhE3B5Uyo1K/ArYrsirMkMiuZS80sWFBDPI0c0y0kzolwHBax6A64EBS5dJ6CtZS58tIdHBnMDLCYUKtkDjucmFKVLc4BzgWklrJ8mBS8AEDVMLlLyx+IQcyZ88JTICgLqFIFFy3RXkV7O1K8T1NVLi60Tbb4HEwlPxS51iUCUQXStaOBwqMyYpS7VJAMhEmhoxNIHLWjcUfby8g7XFSkhatowgw0xckbi60AtxkA0EE6OSgUXtTK5BGwHJ7FVEGtVby8fLcZySzsrVSx8FQtSx8tG7PA0UW8XI3AQKcIVqJtSx+FYJvwhIX6T6UKUdWCuwWLSQVs6QGIHJ/4WwRAcoRwXdWDJgXAQEqoVh0p051NWC+ZB9Nw0BCZzUlaIlMtLzd4GTAQ/ddp89d7GhxTG1elQJOVe554OcsddzfpChCzvtgEl9ewGCbKfaTCeZwteUFlLtgJZjD0tJyC+6VlA8dVMdhgu1hyeFiKftFc+TH1i9hq7Ne6fUtS05Y05FG5CM1CCde5m0Ttikw1izizDDDTDhYzUU1rGKBs2CCVmJjYGDVM3j3M39kCWNkVM4oDLwgj46U830kQVzXpjbRLvhny36IFrqFSErbhZjPo/dD6VKbslVnlqVezRVtMk8EVtjrBnzNK6tkAhMTMl1kdloGKS9tUlBuab9FllVQFllgRNVuSbduklJykdCVyXL5b2NM1uCiKXqdNN9tsllytetv6XgiVzR3UStADLdt9v7VNzKidMVqNz1jAoFe7vgSIXgctEYr5aq0NCYodCtmpzV2ghLq9vtL5XjClqFylldv1gQGSPU6s690U7Mwtzt5NqZjbeIgiu6vN6BlqV9kN19xJasec617SX1LDf6cd1F5c4kEYQKRU5QiU5khETNIyzJ7o3ASEAUaApDQ8WcWpoatjG54yuFH4n0EM5c5oiV+qzY277c21PRojH6f7IMPN/U5LrzdS/bJ9/zpoQOAMMa67qNlrlc6F8c7FJN5kwgrcwDV1kxEJapoIIgIRappFyc6TBKzDO9+10s7jLjBK0M0NHNj0dN7t116lez21q0zQoczlLF6Ved795RdCQWIF81w19JdCeGKk+KexdB+FDMBFzmJ+I1loGdDCblDd1t5FxGKIoAGaiOL6ZTV9lDgGKF6rBKK+OGNF4+G0LQt2PLhmOdFpjcM8vYSwRYcoU624GUQQgkgIQQcgXSMWQZawcwV4Rz0Ju+RdXrcqcbtTtjMBZgGieF3YQd3uMNnsTV8BetCQquU2PeK5erlmUmV1wtlOWGQZmyH0SmIk4WQbUVSj3UYCRuNOGwGiLpN1RmWuLgoEow/eYCCBnMpaDOZWQRjhrgREmwRSD9YZ8RZgGp7GaAiQnr+ib2J2VF4de0tFq2YJnOcdmqbzLTu+MdgQGp8ucIQWd1wmGuW5jh+Ge+fI1uGub05Gf804XN86e5ji4dFLQN2sQjQrQ+hGbzUWhhnmh7Qx8WU+fiLg/eirQWi9/mHadufkz+JOj2hxsOiB8WgQoE0gmE9k8c8s+Fnd6eNeO01el88OmM988+YmkhdOmE908wsmQNw+VONhjYGxe2oOmWnuPZkqS8/giU/2mmMWm1ewGzlmqU/F6M6Oki4ereqk7WHmkjUWsOrtMZkq+es97miRmqZApKZIu7+lsQGQG80uP5+pmqbOiuquc9y1ltAekw1hneV+OtewG6eGvuamo2dGwJjoJA9BJxc5muWWVqwRmp/6YaYqOIXYTCOQRxZiipBGzbHsTwR7g4RQc1bojG0RpB6C5z4smyb2R2SBD2w9ltF4twz1zVm4HDNASAREuhcuyhjdJeZ22Vwm2uSJoFKNPJ9B3EhZClfxBWfgHGpYOgOQNgFdPVHFrIxWbbaYX4V0NVekyG4yS9Vy8hzIKoKgIwFoHDfzI7J0PsY76FeyurYF4tMIidq6ajn+3FgVQdjaQticYSFiFx3TlEasHISZoDnJ0yHRoCCrF1YaAyOO8e8tNjk8flBFmp5Fwqhih0iu+0U9gVS4oTwLxB7VwUStRFaYoFUwggvQ/oQNaAXzPIX6OQVpo6bMX+aJo76a7uRxo7EiRMgISAcwTyQHGNl9jjGYibxT/OeZo7lmFvKASS34XaPbbvKnGK4fK65O6Ii9HPLxjYHLUXMOjXAJo6+fNT+oQCFbQwRhEHNhtlfGdd1Zu0nAjsnfO80vPSW8G9OkK+EJORqJ7HQJ3LhvF7EQtljWJPNV9pvWJc0XO6eHFoSQcyJSJglCO5qAGDFEBhBlaIc4R4urdjp3UEkyVCEgW/UGN5+k3uB4XPV3UDnLEManUBpFRcn5tlqoETOAjoQKMATAcoT7ghzQTaXAR4RwFAKyrYOpVo/HX5ri7vOQcvOhreSiJQcwT9cPX58ARAQ3JSe4GduIghOFrbQprZjvKTdHTy2/c6hQXfOsXtwVx0kRr4U/LaPhrZ0nfnLhraK58/MgXhrbKq2RxLoKzwtl2WdeguchqDX/POcQiUpeJmFxtl5hBARiNhwbSYQQh/cAEXFIsBqzxDbObQXwQohIUK2z/oF3mQEQPo=";break;case"ka":$e="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";break;case"ko":$e="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";break;case"lt":$e="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";break;case"lv":$e="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";break;case"ms":$e="exEMBEOhEJTmIDadTmdBAcjKdDqcjcIDDEzCcjkYTyLhELBEMYGIiab4cIDSbjNJDaYToaTebo5HhlISJLDCYjCczKIDIbzLBzcb4YczqcDhJIYcJyczvJDJMREM5CSTcdjCbDSZBBOjkdjKchBJBAY4cZDKbpbVznUBpISCZDbJycZTfPJ9QKFW6LRzlDDCYzHPznJzPFJ5NpxOhAdzSdDQbzrfhBSjnTKcLBAPDCIDRDjMPS4IjQdDocDmOi4L9Sd9YLjDcJObroLpIZ9TlMscjJoYMPjbJJ3J5ScpXLZePNSYR9UBrISYb8KazKbDrF46IhtUzoZTaIJwcjr1xvISVr+qbOuOJCQjCaJyYeuOfWea2eYX3OuMYFBCYaTO0b8pAgiajkNb8pmgghjeNixDmMY0O4Mr8qlAYyjMMI6jYOj8rbAY0jmOA2I0/LmoIJCswkjwYuzEw6jEOo3DOir8vG/iTjWg46LqOibjYn6Gwsr6zjGwgQMcnYxoihy0IaN47qgGL1IIKQyjGpyDjgr7JjCM8Uo++UKwvDKGDcOo2jFLQ3jNIErN0g4yQ/EKNDKrSTsPHkjR6MqoBk/YRLmrw5OuGUBBEII2DujQ50HBCROAECrOpH7HIqEASjJQcKBEIsyu6nKtunKsNplDoRCozqfseNitOGnk4xEPMis2nUfDG4yJjas46hBVtdO6Mw0umMi10HEoRCg6aNRmmUWBEKcPu2NtBxrP4wpWyazjOM8YPgmUpBEJabBBETqWWEQZTBY6KjONar0qMibOuGc/OewqVqJAyPBnQt6oQnI6jWEDpXa9F9UaKA0qwNE726qNNCgMKlQLSqFvANaIUFfVSiqnGFqViVzBnY2OPaEA1PMq95WaqiU3lamSDReVviui43MJRd9XSIKMvciYpiiJjrhpPwkCoKgoSAOI6p/UYRBpAQtoKrQxDy7br0u72qp+EQuo8GlGiXBczaFTQlLPD+hVLBQ2RFW+hWNsNcjdoVmiWs4wjTdqJiCyI36FagnYTvFx3cNOhW/iC+sal2569dPEpbtyPBrP3AxFw3J0K6SlDdk8Y3MGuD4SNOY8nTQjRgM7BuuGtS2Rz4zodGUecaEQa2MITqxj1lmiGi/Mdtak4X8Nwwhalfi9Zb4poVGHWXTuSI+cjwbaI17rhtQu7c5z0ZIm7ccexRogxx4AbU0JMzveicszLheTjI8/sVKwY2857FjRfdvsWbmEtoxYIu9eL1GXsdK2dIlb2HlwIM25xdi7iJrwR49hdLdloBpVyolcwN0/PpL400G6hQio4g+eJRoQiTwNXXAGCMAwRA3U07klkBzuMNBuqWFDxWTMoYLC9YwVA0mvM2/A85UAbrNCOtw8S1ApwMPE8uDCIUvA3XSER+RHgcJ+SooEnSmIsKFCcGEOx/iWOMIQG8sx6VGhMI0ZAhial/J2eLGN2cZjGGOTyGJHy40brEiwpoKieo+BufDFh1wcoMEXPoX9W6vCxFXDZHmPZWJCR+BEDiH8QV4Hed/JYHDdUYJEIoYN3cWFqJWbZGUl56VvhPCcCAKoUAiBBCoEU9K6ZXAgCIEUJgRZanxcqtYzYa2xLSI8DmMEwlsJnQWGUNCLj2nxdEwpcwOZALWgMHldaoDtngDmG6bR8VShHK+GFgJ0iKI8ZwCIHKxpyEZnOTsnCiXSzsWaCUFwM01zrBytQJp1UyN4YChdhIIEZIyDYVAHLy28B6V43iSJK3ykJO7NpGKrk0PFYmRZeCImFkGCFQpdIRqIJGKzOYxYdQ1B1KefkGCfiPIqBgoWmYMgZg0BqDYG4OD5UyfGG6TZlCWg/pcpqYgcyXhnpcqUnJWKXLGCav8NbeqXLNCDUAzZLV4MBVy/ZGE2g0sCDLBeDIYVKowIhVxbMNQ5hrJPWGIhVyTM2SgDCJkUVzH6ig/aAREw5zYdSCCaE9T9LpWfXyFquKpN6m4V8hU4GGgxP0SEJpZ1Y2IQCoViC8JjEfBio0KshCgh3ImV8ORJEoAxbK2dLC2VtvJRUDFUoTg3zMYzZ6H7vw1sLXhYqv6AVmhTDpIiUtnomN3Iy8CyS34cu/QCumcltSHyIQPFqFbeK8qEJCs9EVBluFbXcwuv5ELwJndSpUgyUAZKNpJQUO9KqWXqU0QYilQFLEHISQtIDGCLETDeGINSoixkOJYnRrN9yEEPMfS1FQMlSoatvZ9Y1V5Nxdm2moM0lE9oHWaEi6SB7jmkZugdxFlrAOfInOiD4IKLGFrIGVRNJqt0YuQ3q9S6QqFfXIrsnFkGApZDkkknClUGL2qliybdByrmYMHd3IRm0RBnrDR1ay/q/qWK0XFmwdEoLzJCqdIRJiDqzKUYGuaRkIVzDgZFLZlSmm6MWGgNKDyEH+NGd4naRyxoYJ1l1fh0KxLlLAmgOTJ5tZdUaFMn9YTt0eXGUUyOTHBLj0AvdgFYn1FYy6+gqpVysrYOIRUs5DMiknMxFInJO9SkWRkSfLqpQphvmJihUBg9QHUVdOYloZsbITh/mmRkdmEyRTRqA4auStBhDNN0vRgDBBmQzpTKRE47sLz1X9XOA06ajiCGyS1qlmk1R4YknYZJEKBBAUEhhKUYYMI+DNwBddzBpUChOhl5taBQCQ0jFoIAUEGBSq6pGszC1apRe+le7rVY4k0rPE73kOJ+CprIs4IAhhTCkEbGVKK/hoBcCC7hm2eo80GSSbZOmCVhyiGlKDTz1uC1pshSujWSq5R8GJ0lYT3Fa36nCjJF8bcg0mS2ABLLGXpQ4o0JTeTNkVk3watSMeRkX1BlpHila3mHkQCAt+Wi5l1ybVkyJRTOLueRXPliHFNbiM2FAJ4UwqJGx0VfHhPyL8fbskQNljIJdNR4rvokDw6WMO2jxzl9+WqlwoZsMUzWFkJhm8VvND6Cs/CZkii6aK/lg5t3SsIRmjmHInFEpGCcd1hSyrAivLVjMQ6KiKFqeOoXg48hxZvroH+wYZ3LRycGTkQDRr1FQNLj0acGHC05Op12yxLMxH0z2OocsMjwiHy3KEhCsV/WxBgdYI86dSsO2EX7533fdEmf8jL4VATjVv3SDIk0SGVGRYIEE4qcioGrZYeIk1hQ1EhuANIjJEhZrHIOQOB0awgGpag8r4BEiBaGrjZgLjpKAGpx5iIi5SrfpuR+CsI6SyDq52pFZPxiBiQ/J7IkJTgNQk8Exg4i5yKMxuTKQNYyMEzTgsyQoj4GxjaAwk8G75YGxYx5hM4r8Ey4I94jMEKnQkJmEExb6QJ9RhcGYNyUQnIwkExdIIZCAMcHAGKDgkIIbAg7YscLRfIj6EIkIEB14wL6pGhRsJ6Ax9sNYhRGhh5DB2isRghGhUoIwlQlhGhYwKQyMFZFSI4kJZCRAhYNJRJGhajthGjEpGI6Y6sJBGhdK5pbBGK16yKLIkIKJpYOQ+jQhvLNj2ZODgapJKAHBQoKRdwpKIQEBpQr4PI/IHBRprA1IEEWi+ZqaTsWhUsT0WTPDQpZRVxERHAiqcwiozBrA75D7uTQoMpk7b6TDL7hoihnis4tDS5OEYyv54r4Qj6T4kJrEWMUEYTQwzcbic0b0ZImEWhaiNkY62EcJb4JA16TkREWhdKf7yKgTyiHoGIHJP0figLyagiSJOA9z2AM5KCZAmh35bD1UEIHK9ikr1JZSvzuxRKi795FSaw8iCCxkg4/IHKHAr5CAtCuDpghsVskj1sC6jZk0lYjJtski4MaMDCwifo9b7R0kkhb5/wnTyEkhdIJJaL3hkpOApSzkcBPqDso7mi3hvKtityuhQamY7Q7i+kqJVzSyqb1cq7pSHkpEqT34Or4MsAmQGD/R+KuUrhOCwZPgGBUo8stqSMt4NJF4lkuRYyMJa6uKHpPpZos8FR2pPsBYlks7o4OaoktRb8vyFRxRyRc4GEoqoAMpHEshV0uJQayYghsxmwg4qkH0zqZKBImSz4kJ7Yip7pcxQkOr16AT2RZMssxMtEd01B1y673TvszROCtLqh4olZPgGMl82L2KrM2ijCgE4j283c2U5L3oNMzk1CJiBk3wNMs0284kB5a8vEvTLkzqw068vE6hc5PsQxdbKUwK7RKcQR785UpU9RhMZcXkREZ7AMaRPi9c1SUKsMKqi8vE7Upqm0/sKc/6Ujgs+M6Zjs/ZUoJc/yUZIs785hRhuCYovUIYsC3q8DzZSrIDXCrrNayCuC1j3bfrbAMIzEHszBN4NNEBgFD8V6Yg6g7qv9DyxNE6bZOA8ClZgLhC+JRiUFA9CS4q9cxEu1DsDEwwGRb4IgIRRjHFGK26mziSbBktGhsYmRfc9JkE+E6U8ym0FtL07FActJc4GcOtMlCkvZTKHCFJLdLxTL1or6C7GNAU20poGb29OsRNO9BdMLeEQ1PoltP86U8BPgGcoEOFQkRRhqm0S1ODIFO1R5oayhDNSpQseznCdbBz+ItIOBQYGjtbsz0xpi3VD6yxUKv6IMwwGhUsQLolMtPNM7B0QE987FMIGhZtWJO1Nk8JUiApkraBGJ1ZUlRZkr5AN6LoiNUVSKHVYh1R4AGT64gkS9ZVZlKgGpQs0EZxKi/hYsNx6UO9PD4Epr/LL9cbmdBdRBYpUoKldVL8pNBg9pPh28JaAxjAyM1ynI9agBI1eJYpaiGQhjAM0JYpb9bpHNBdM03Bc8Co8lE1X5Ph6tfBktgxtBZhQsLJKpgI9wg5NDircwN4oxOlihRtjkLbstkAMrioq6btkxQZ88L8MllbPDiosgMrArdwGUHQtxDRLRB9jtmVOkKYh4hVWdc1WoG1Ploz6tXNBtmRakNVo9hdQ9CpZlZBjxIdqtmUS1f8ONromULwgiqK39sazVRsRdsZg61y79csxVWqGFQcTNt9QFqNsZ11tyHViZaZY0ewOZCCLxc8Qs9zohadgdOpaa5gm0wKKkcYrVbBSdBclAlspsTgggJZBkw0VVyBUAMcDCsRWh6RnpQcWokIJDbl00XYk0qE5Sbs/InJPgHBtS4YNgFYMYrFlUpYzZmxy6wUbStTLReF2ZYy9qiJpjKdUp9pLqYlDgKoKgIwFoHF2ae8+0Z0vD0gvt2dqY7kBBSswECMc5ZV0xxEHtR6ngkKJKHQpVfYiawd4CtLBN4d3pwSsKt5PkgQ5wN8e7m50hhhQchw/l/hOFI0il1Ds010j4giczOVKkks1QMrNb6pSo6V0Y8F0omSdskFJMvB5CB6ttWoHJZsuo887EA6rE7eANJGE0vCv6Sl/NhMsduGFWDRdOEst1BdkglqikcBeZPwKdoRe5eUrAgi2greIV2WIjRIx4O+JBCE04qMteDmE1Dhzi3riBfUucL8iE3rKg7swGIhYxT4zZ2VTAsAMoPD5AwRxmIk5xzqbcR2LVqc1ibc0dFuIlJxcQIwhxLxecS0XpfUzwEQKwv4OtLQqKySyhbOHaDGRBfdtqREY5eS1WRbFDTwwadZfaHCgR4BfaqCGrouTRFcQ18826sR/73M6DzAwpy52pfdqeU2SihiSmShdIN5QIO6RBqxgziVgJg1bj/Zg0FqTZe85IOQnRF5pokLqAEQPo=";break;case"nl":$e="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";break;case"no":$e="exEMBEOhEJTmIDadTmdBAcjKdDqcjcIDDEzCcjkYTyLhELBEMYGIiab4cIDSbjNJDaYToaTebo5HhlISJLDCYjCczKIDIbzLBzcb4YczqcDhJIYcJyczvJDJMREM5CSTcdjCbDSZBBOjkdjKchBJBAY4cZDKbpbVznUBpISCZDbJycZTfPJ9QKFW6LRzlDDCYzHPznJzPFJ5NpxOhAdzSdDQbzrfhBSjnTKcLBAPDCIDRDjMPS4IjQdDocDmOi4L9Sd9YLjDcJObroLpIZ9TlMscjJoYMPjbJJ3J5ScpXLZePNSYR9UBrISYbzPhcjHRENpCTjzDdf1BvISpNzKbDZ1BxISmcDkw1Ka+oOZCQuyczzCzKbeoMYFBCYaTPo/ukCCJqOT2I8GKZoIIY3jYsQ5jGND6jK+6pQCMozDCOo2Do+62wCNI5jgNiNPu5qCCQrMIwK6yCCk8KcjUl6vvu7r9JONaDjouo6JuNifobCqvrOMbCBAxydjGiKHLQho3juqAYvLFYyjGpyDjgr7JjCM8UI+90KQtDCGDcOo2jFK43jNH0pt0g4yQ9ECNDKrSTsPHUiR2MqoBk/IRLmrw5OoGUABEII2DujQ50BA6ROAECrDYOsescioQBKMlAQmEQizENqKIOnUeDHDSZQ4EQqM6n7HjYrThp5N0QjzIbN0/KTjImNqzjqEFWVxTgzDS8IyLXQESBEKavz9QEVWK+Y6PrQEZhEIQ5DqNavjcMI7DdQEoBEKClqdQEuhEmsdMTLYZz257opMN1tI8GdBCgr6VtlJUFjOk7qBnRQrPCwoyJtfVMCtDytjpaY1ohP931JTQyJKO1fjvfViYcktyvC8d32UqiU31aEWTbLWFqjbgrouNzCURd9xCmKImBaNY3jbeieuoGk9iQKgqChHw40ghebwALaCq0MQ82a6lKhBo9m0QLqPBpRQlwUl7ZZvTAqDzK2b1IKgyxsOg5qQr7CZvYmqZos8dIdkgaWUILIjfGqHVutGb2gIkKwvDNGqvSGb25by+w9F7ZbdcXBpbWrqBrPd+t1X+SBrQUeDcM6zcbfl/cbTAjDqN0bcNGKPBrUgpjDtSUJZlPL8bYgjDVa3G2UKZhlxAgRBraA0DskmxjbB42aD0tuCnsnJ3EuPQrPzKPBtPYpjWjPmOoG1Ba/sPLcxLYbUUJCKjIrHXefz0MDZO0yvEFsGor61SRCM6HetYj1Dhq/n2Viyd4BcqcvdWg/srYa3ZErestxchN3/hzgIfUML1nEhyDSxFHi+HSAiBunsJIbS+LNZIDdQQRUbQdO4ooJ5RiHGkTpAonR3FMQnPQQ8ocDYDEeBuqSGEKSGMYPEdxYhVEtETh4jwORUAbrKWktQ7i0HpQFgfDZ4waYOI8O4uIIgdSrnkT2ixPxOlLEeBwoIJy2D+EsJcrYN7zgRA4UUEwjRkCGJnIQGFOa12IhnjMS8xZjQ0PpR4CB8aNioA4ayneQCNWVxrVIFCCRKw5HZL+rVXRYirvoXLH+QKwowQ/cuWc7RZoinkWUEZuqtwyBuduGuIh5FoNjL62V8ka1uBPCcCAKoUAiBBCoEU8i4paAgCIEUJgRZdntT21RBa7SzrYXcCIHK8SLupIetaZh7V+FXDOe1TATAyrrJa+g2R9D2qkCMGxpEcSjHtdhOaFRsovzOWUCUFwM00SJBytAJboDZEmDWtWQBOVmlhKMroNIbCoA5W4E0MKNopJjSJQVEJpCdq+eGHR25GDwmKSuQYIVB1xBGoLJ5sBgz6Ntn4tVJwME9ggPuDBQVLgZAzBoDUGwNwcHuQKDBRQRSwBkVyYOfpXwf0tUwjg+1OVSEkP4SeLNOViLGhUbGlqyorxzcvERHxpD+IPWbPt4CREkhnIOqw9QIHmklLNMp9LGSz0pWhG5+SWz8LcrgSU6Eky+k6hVWUsp/EgUtXFXUndd69EMNiCCcLSUCn4Oclltp/1BBTR4aQ/6igquhKCHciZXw5EkScDFTESVql9a3BcGIMVSBOTGrdklp1iLkLrXcls77Tu1YOWdkZ/63oeg8f9bgQiTjDFM/Oxa4gjl0VuwcNJ909HXhkn53KBlBL9XaVisRDAxMIrMRYO1BHLFmeGWcnZBknAyUVSBy1BJlSaI/TEkJBiKBuK1fAhJC6skRIsRMN4YnZKhLGQ4licWmHZvoQ8x5T7mKkK8G4hZDgWzfBaGh24ebiXtWIFkyBFK7BmDM+NPFzFlBIZnXIGUTIZMquYtxBMylQpDRwZOCUFJu4Cg6QdgpQS/HiSYnG8q4gqBvLqvQ7LoCiGAMEGZDEgDoEnDmZhg8kI8JzTm0t5ZkQygoDmClJy6DvIPJKwVWRSjArsSIg9dgcDIpYMqU03Riw0BpQcQird2CdpFLGhcnWW1BBVDovdfDl1GsZDzUEOmW1FDDEwwkEBkQ2O3DgQwFugbqn8vtn5dhEw4VlDdOfLamCqKOKyZNeZFW15Kz+ZhEAZX/6mTmlmOhMEJKk0Qwl9lFhcUSIRWUO1wiSwMWmGQrWmRS5bWIqYnckYzx7PE0wnaVg5HDlMRQM0Hi9ZGMrkh9C905mMMdmUnYc5pX/Ti2sNJast1UMRqth8E0r44km6DBCBQZrQCcXXdayN5LciBJ5bBPNv62okWYEAUAkBQBaZFiN4CdT7BQQYFNZiwTfDO7KTt1sP7yXFvsifCET3hQ2nsKoZw8qqSGEMKYUgjYPDetUiekVjXy0vAOJxDyTcTrahtQVCqGEJU4RVHWywzHhDpHa/UXXp7j0hpK619pUqUvZahRQSU0B5wym0rW7uFlaMcwUhzPyfkMDNZ1Thb3llzRyg8iYY0FmK62lVLPFyPg0c8gxHFPSbN2e4SbmUDiHguBAyEhSV3+zScvWkzFbCwdNIXRch14dMVlIMzEl6vgzkRRcS8OabSHMJ3ZoVDapKqhrUmiE+lAg4XbYMWJlzMKKKN3KCAIzPCwmFilB1IG/iJ9hVksdIGsEC0zJDyHkbIoVrmSc28mm6eFk7DQRdphWIVBzsms3z3v1oSMDeToypWJxe/W4FYi+5QxSr9+y1HREJEgxcde8g8XXDA66d64zfBODcc4VeP9LlDnHQS1YZdorZmb+AgxEZRQI7igN4ozsJDy6IGqQp9T8gj50w8wNIPSuQGpYhBKDjKxEZZT8ANgM5UUCJvKzqdJAoGpbj4TkjQCBiJxJwGpcShSDzcorECorRiIMpiZFJx5iQ+564kIkbusHpRRxRwpGAsAry2gGzTy+Ska0wGxhq+TL8JhG0JxtCgqNQGIGxZQJo9RjQj6mokJ/cHquibowqb5XSUpOKVB3BasL0LJcQIZB4MZGxGRPYIbACgJBxKS6KEA7yCQ6Kv5AoG6NsMqh6S0P63MQRTBeQ4jUhews5apGScglQlhGRYgKQyIk60yI8MLBa3sQRvJgMQRbhFgohDMSsQSwJLJphhC0wHBPaXQKgIIIYJAEDryCRHoi4nbrAvZsjeIj6MIkIIwMqgrvQ4Yn7TIXAORT4+6Ni94rQ1KlhAqQggZohpYjKd8a415GJqEYBDhogJaSrRYOgMyi4hgJ4JYzEbTYI9RiJAbvo6kcLZYyMcsZUc8dJSgrUbBK7YUdxarz0bpJ6TiIIEBmRmh8InzxIUscceohxJwHBFUawrT0UecckcwEEdAqBpcih9Eeki8jIEUgIHCfANSi8ZquiKQxpJYO79Km8YSgsBBN4hZsxAoHJPa9EmL0glqTosANKoMQyiL6pLhQSUj3Yrq0wHJRQK4MoMQrhPwFr1sAcmpTAJcksZS7w+4HJ05HCgcJBXUYkNwHJYhggg4nAkroKgsrLEK3ipSuSe47x25TkFiB0rMUhOKvwsCSstxcQKUbazYsD6SGUeAmSlQkMvqtLiD0x/or8oRPRQUw6+BK7cCqJdpPKnQ7w8A8SkUwD6cwYERPUBytkv67Zh8zxPRr0zK9JMyFEwUxoGDYs1LohQAGBZQ340gkk2cEcBDpyocwhwQi4loOZwwOc2UwjjMKb5cxKs80yxgggqgsxsK0pQC0466aomRAw5y3CNRQJTCBJcwib5osD8Yxooczsxq1D5J/zhYzj50coUqdqc6xCZhPL9U9KFkzb0yHU5jdE9U/E5c86JiGgMLmkyU80+h41AVAgsEmM/U85ltBIhhK8/5PK5ogkeULy8xoYEUTEnc/Ej0e0dUfQ14ycdoNMd8oVDkTU0dD4vtEKT8flEtE4jkbq8y88NKU6VMNs/EwKiUxq9wgiUg+qU0NaoM1QsFCZRKclG9IlHU0dBk1tCkKxVQMrSKu4NsLrySZJw7XMhb5orZ1JW6FYOi0ozAswhlK8hbXa4YnaTwk86BKqstNANlLJqws4zCu7wa8UABTgzxIAhxG8YtNCsyhikruC8yUdJdHI8JRJaELgUsU8B5RKBAIRRJcUMQmTLg/UQsM5mVLRLamK6ZiVBU0iFJPJfYkJgkHFUdHj6lUxgdUVCNBc1lHtUxUiuCxE+MG8HMz4GZisT1HdAxS5/VX80dJFTCANYkxNJ9WhS5biAQMsTxS6X1WdCNaJUZ6JtkEIGQGiyJR6yhUZ77fEz7uVVDATbANkhqjInZMoqxklbZUlFJesxNVk0z4BFcTNeVCUKNepZVeM/FZdVpQAGiANfZXR0B0Ql9gVZ1go9D7JOLClT4GlaaGKFTJB0M4VhImT9YgiHKGTGFhwMliBYcx4h4iNMZrljRRRYwNbBc9dAtKBYZTFldltf9ak00CQglmYs9l1I9fcxsC8MNgonVllnZYZZVjr6JsFlpYZaFpCHc6VjRbhrRK1edYNjTHy0tZVm0xp6FoM0pIlqEz8HxBEOQNc9ksoMqTxh8mLHhZJRUOMPds7ZjfhDJIEX4GUJQkNuEOduRMqTwsjVRZtu8J4t1uosEPUOZZLYsRD3tqtmAmULUPw/hkc/1nxPMMAggKlxhJNrVilgNyFhdr65UQFdwG1iaHSsFyaC7EpPYKgrJZ5QQJB5tdRZ5RS0Vl9ZgmQG60MVtns0sxqG4993s/Nx8z4G5Yh8AOarhZ9ftfFT4G5aAI4NLGCCakKC1dym0PxsFsyb4nESN3RLsiVj77Qg5bD6QyNz5ot8YwRK981b1gNGkV4kIJaZJbZQRpZHDn9bUZwggIIO189b8z8agHV8UbFEgUsf0z0ddGGBFE0f9GYmQHBUgIZg4NgFaVUn1szYT1BPxNqvAECss5b3BPIHB2CkJWzXTXg4KWwKgIwHDB6bp0KNIwmEkiN9WAxK72p5EoWBdI8nqDmHeCGASfBSeDInYr0D7Os1Is5bd0LCoGUlwgi0RHxkQr4Fp7bgSskheEStKtWDpX730z8myxq+y1iFZcJQSNykpcNlRE5cJTCkixWMRUl2SP9P5MDANbUsUzEB9PU8L588gigOxmSV8xoHJZQ7+PqfeP88diqdl9IGUt9zOJeRb52RohhmQOByWQ1qWSlNkzl4uSLH2T0xOS6gQlolb7kxgqBdB6MPQlaRJdCMQupBpB+WGVky9nIx4O4reV6J4qIGE0MzVBYwtXWWIGB07prwbvSIaC5dBYgnIwwhzypENI4PCGIyqM5fU2k+2LBc4GBaE56keb2bZbiUhX+M5d4GEvkbZkheFbB29/4OqbJd86ljjR6KQq5D2Z07FnJ2SfpfS0Atxa6cwrmgNeAMopSx+epYl/2QkEJeCUeR8Qy+NeTwZc2gJaCcqc+gJbhqmTWfhcQN5PwO6CWORfZ6NpVneZxQI7wrJD5EKZpfcIaspfDXC2Y6gkI2S5YPo=";break;case"pl":$e="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";break;case"pt-BR":$e="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";break;case"pt":$e="exEMBEOhEJTmIDadTmdBAcjKdDqcjcIDDEzCcjkYTyLhELBEMYGIiab4cIDSbjNJDaYToaTebo5HhlISJLDCYjCczKIDIbzLBzcb4YczqcDhJIYcJyczvJDJMREM5CSTcdjCbDSZBBOjkdjKchBJBAY4cZDKbpbVznUBpISCZDbJycZTfPJ9QKFW6LRzlDDCYzHPznJzPFJ5NpxOhAdzSdDQbzrfhBSjnTKcLBAPDCIDRDjMPS4IjQdDocDmOi4L9Sd9YLjDcJObroLpIZ9TlMscjJoYMPjbJJ3J5ScpXLZePNSYR9UBrISpX7ibovW8Ew1Gb46IhtIScbztdSkZTOaYX2I8N+dNzKbDD2RxUzJLpX2RzISEea2eYWZTb2RigSCCYNIztG/yQIImo5DW/yZoIIY3jYsQ5jGND+DK/ypQQMozDCOo2Do/y2wQ8g4PYPL/OaggkKzC6PBi7aCPC9hhlOYZap+/z0QCk41oOOi6jom42J+hsNq+s4xsIEDHJ2MaIoctCGjeO6oBi98YjKManIOOCvsmMIzxaj76w1DkPIYNw6jaMUvDeM0iy03SDviOcSo0MqtJOw8gyXIQyqgGUABEuavDk7IZQOEQgjYO6NDnQ8GpE4AQKsNg6yIxyKhAEoyUPDIRCLNI2oog6dSGMcQJlEQRCozqfseNitOGnkSRNJTN1NLLjImNqzjqEFZ19UYzDS9YyLXQ8UhEKavjsrKSUPGFJR+sCzBAIScp3awyNeN9HplHVBjfXqeJ2yI0qwPVu0MmUr2Ws40PamUyBFbDFW3btvqjQVQjojN2KjRImv4kg03UsFcXheSo0jZlTpc6Vq3y7IZ0+kaF3+ECf38yKI4WGdVpG+NiDG6dnIXj9lZENOSOnjY5Y6jOKWkqiU4pcOV5bgAZ3cK6Ljcwl9BnekHpWNyehAKYoiY7IaUEJAqCoKEijjS6F6bA4toKrQxDyOkxU4EGu6/R4uo8GlIwfSzpabT4qDSo+m1XtQwxo6zzBEGllaKs46GGUI5JdpuaDcskLLQuogsjce/pbLWm3CIkNw7D9KKvS+m3cKCLpbu0b30Gl6c2vrG4g7Ia0EKyruBfQa0TIOjMf0+GvXLOIIv09PiMOo3c9HCPBrVa3jT33W2U8Lf0L09pCgOQ3ydf/T3Dqqr6rL0I5KNnT3cJ7dLP3HgXos3DQnvsxBtQUBLjr7shtRIqDD2K66Rr48R/9tIiDuzr/b3UPBsT6GJIZW2ShufaqsM4dSLrcYADZZRN3AwNWkzkNLJSwL2W0tpiZHgbM4DeyOCrLg5vWPnBxdwRYRqXJWuVa62YWLcJ6voGzonArODYMMVJ41vHZBuoIJIbS+JBYADdRIRQ8RBfACIG7aXAnTgxC+DcSlPhDiaWAn8JGFg3bnFWAJ64srKCc3djQeDyNfVGkFNh7FkHnWkFUOcSQbrhhRFiHi7gphpiAkOHi9AiQKe0R4HCgjwqFJ0p2QCiQnBhWcGcljECEQfTEDhSITCNGQIYm4hAYU9HSkXI0l5izGhogDAMrAbkelQBw25PwIJSo9Pcqt5seCLn4L+rtYBYirwAjRKRHkawRA4jBGIMsZD9qjIceM8svgcLSCGvErxB2XkVTCGkjK+gcLhS0Gw9iuz3PcCcCAKoUAiBBCoEU9y9AnzfCIEUJgRZyn0UEd1ci3CxoQd4wsHMiFxwZBA6MYYoler+bwDlSITw4PFPop94aSSXnTDgHIYYs4yG/PoyE7yXilEZLHLI+jKqLlgoyZsnAaQ8UDWkCUFwM03r6ByuGMJ1wQQ4Mmt4OYwxWlegAWdZx0y6skQrNQN5UAcrufg/IhDf6Jvzp7BWn7zqYipU2HMIVQl6BGqYGWoAIHe0wmHGVP5/gYKCBBWBRIMAYgyZADWDoOD6ouBgpE56ozNmBL6GVdQP6wKfKsHpwVblVsFPGdKP5HwYLKKoVyalYFpBZMgZyRROygmThqug8SmC6lFW419JYaDySjq/W5cIR4FG6iSf9d1ooFsunqWgk9ozDJ4eIjV/lbl6WotJFYkwbrEFgks85AyggpyKMIgaIpWDo2lrOSEKspigh3ImV95wckqgxbc3Bby5ViNAhiZM9dlyWrpXWgZVcYRdK9ecvoGIMVlE1T4Tsx7MkXIvJCEM19WGF3pXCgJlF6ErH2JO39wLeL021LpQGJqDJBJ4TFWdRIUCxIcO+WAhS5oVrcmg/Ys9NXP1RSqDJSNVkKVYqcGpv8Y6vYdU+QYijR6okIIUQwhxECJYrLCGINSuixkOJYnhsR+MVUBMeU9Biq0PsArOsqxivyLk7TcGaUtnyPgyWkEifaDFwrMNI0FBi7kHhuNkqhJSP7JBphtZUrUQSD2dKCX6bSU08YdXoFQN5dWjH4d4UQwBggzIelYG+wIczML+lpIxPSemwnRMiGUFAcwUpVBmoJVqRyTEHVwUowNubNnBDcHAyKXzKlNN0YuziFCEIDNG2InaTCxodJ1o5RKzDKxia+cQk5r65rjL0YEytQUMO01jVyI81NbGYL4sCRRYm+klWsUE7+jlPlUUqVm7hxCKt9z7YHYiQ4XIRsCRTQhMEMPCVKdXDZZivKjY2dORpVpfXUWVpEimYJPmMm1qjaZw1elaDCGbWeuddBzz3ADbiejGGO0yVt+KTSyt9DSWrRy0r2E3hcGSGqXs1y3d5kJFwM6XPz4rkZnh3F4JqM3haMbX7dI2SIFAJDUyiRI5MCggwKWNELxKnQo7QKcaOXpS8uoaMSzD5RTW2ZH2nHODeGss4IAhhTCkEa3Idm/lYJ6C4ECoad28lucRDxFyXVaO9wktGUAYg0USFGBVrIYE7DbUiWULGSxAuul3WhLbtzDMCfGGPVsHFgwhLhNT5sOIhUiElN4ebG967AUMs5WjHWdIc9YhawHnKjLedEuaQEKkTDGhExXj0uJg7IDRT4UAnhTConvkp/Cc8NaQGcjLR0/ggPCGQOq6iwp9qNY1DqvexmGPjjHMnq7VrEgSRl/ZdSDJVBoqvJOqyJlFQia8wwYkBtJaWsCyilOGggCM1LFaee5F9JMQwM3lTqFdK/8xZUT18XbJP1IUPVAw/MWlBhOcGu73G1rhb5i/KMr4ih554wSHZFwGhdx1RwJv4rw8hEJeiFBIInpFB1Ir7oj5Q07FolgjLqQVJOYzboTDKMTlhqYgxFBRJASRhpBLQ34HSqJFB/IiAq5gy0oGqVSNInJFBVaO4PTBYGpvZcbTh9hFytQkJhxXRPBFBcJ5Cj5FCE6FL1jqLqZZ5KoGpegJrHaJpdLHhZwMoO4/x9AkIKw8iP0GjIx9wkIkZakMBSJ0Zxx26kBaBFwGxT4YYRpo6Cp34j4GyiyECCymIVsPDXUMBZR7pAY/kMDiBjYk7ASDsNKD5liEMM5dyhcODpiZwnaaINyaa+EPZohCoMaVxFyHq+bHSzTEMUJHJ95wIM5MIOS9CJYtw+KhhiJJcVkVxHL0o6DapKKVpHJVYIwlQljAQG5ZR5sAg+L3xH8WBaQIorxxEWByKKIGIG6OxuoVpbhHJoiLhc68AnrIyQItxqIIIIYJAEB6xwJIjJbxYvQowpDN4/wHCIojAuo6S1YohD6+6SQkJsI1KsZFyVIgZrRsKY6MpvEgg8UgxssgBERrTLsfC9oPBLIyLYZTYrUgo8oigMwh5boqEh5M8EEiRJ0CQMIzEhCZEZcjUjjvYERswj6YDkQNwNBNSepoxpCkKMciaIRKqZcgRrce8kArYOKnMkUiiehOLGLsRr4qBsJLS3UkBUsocnMkbWwg8pEjkZSr8lxKyOUoqIUeJdx9QxpKQO69Ctgqb8aIT7TEKoA/wHKH0tJuq2R+YnanzES64syN4loqxbhKqfImguorhZ0b8tzD6q6rJpEwRZ4sAO4MoMUF5FwHJT6I0nQ6cu0tsyKWAi5lxUZkoOcuhjUektyjxjA6cz8rM0K88tzKaMqiJwJx8yMACIC0qoYkIIo+LNiwYGIHJeg8MlAuo9aPD/rXgmSsIkM30gyR8P0jpQ6s048hI8rFQk6xDqs5quA9Q9hjT/g6Uvs5sG6L05USJks7s4pVZ+EHDHL1z+s5qMCfYw6Lo9k5paQ38Nc4pyJ5wOCqKvE4pdyeSDSfpzi2Ju85pekO0QRIg385clgmQ/45y6yFim1A5Q69I7jKtBk65+VCZT79z/S684K488gERRBVdDgw67ZKCfbWxQC9Q+zidDsqyJtEJRD+9F1Ey69BM8VFVCaOUKCFdD84dFcJ6LE9M5lBkCFHozdHBls6omRQK+ZeIlZgDDxrIEUj8fMqco0ksixIs38lUCU4lKol8iEkMypbkk0i86ElLfclZbwjklzDxtMTDmpfyaTEUEE7dHVJqKdOUTUTlJMSFJc9dJpudPk0sTdO1IlGQGRZQIMqyew6T/IsMVjpaDIhcRhcrc79IuwhAn435Ja6wzDc0TKYglrCRUdCMWcTItAkonKeptdVpbcRayLJlLk5IzxI5wr10ugrzE1Sy6RSCZlQtOlQ7YRSBcM888FWNSwoJSBdwIgIRSEK9QESRTxQUSqhosCbKe5TxRMMZlE8NQJQAGZSNby9tPFGRisMUANRNQVERkEUrhosBk5IJTxZUZxvs4Fc9MCtEZsZ7MVJSENJldyOVfwuoslXVcRdyCkP9e5xBT0bdeLq9gpQ7o4ggqimyhlihRKqw/pVRtLW1ij0oh0wTdVg0IJIcr5VSWB5zvKPFfE7U4U7lfZvQkMY9lsZTOlac8dmZ5lli2FnFRNmaD05YsB3Z3sudilhVnSh1n0ZNfFiliEyx3j5JZJQSKliMAdm9p4mR11Bwo6FhSosRayY9kcz5ZJ2hqoYYVVXNO9mNPNEUG0IwMttNtZJKudGNdtRcHduYOttVtlcFgNvMH8R9og6lulthZKZiLgnVw9uxfVRZcNq46YlpuNriolB9H9mRQEK1r1g1GNfcMIglhdya6xaJRKZpLINaxwg5NjpbigN4o0eAmQG1ON1N1bVDpYq7Wd2VEUOlJ92xeN1gMrpZwzHbjV3p4RD5L0VBBd2bd8W5L1zNIt3paQKl6AsFgFnZQERwgl6xAcV1oN7dpVwt70Vor5aJela8Wt8sXBcDSA/lytESIk21iZcBSIKq78Gkb9mFEFfYG5T9/BdF/QsV7N6YGSLS5V/JdV/dg+A0YokIJAnINBQ4G5aQKQoTWuClyIl7vN85cBdyH5Lr4OChMkgbM9nzXZJY6FIA7JsNrMApH2FdmRZFN8cJBxCJiJQ8eUfgrSyJH5IKwYGUfYgh0aJOIRDOEz8o/lL16ZsIxrDOJklmGpuZfwNgFbzoNJ6xSiuxIkz4MQkoutsKkEzZjU3AMIFpCJQEmAgiqyAYhLyZNjTAKoKgIwFoHBjRwsSETeNRGGJMjDMSPDmFMEk8hQk0uOKRdqlyMSmQo4yrMg9Y6hh9bAw1ZE+Jdt8ZlhE5dpemAMLb3KVtwEP8nF3Qr4i5QEt4kIJgN76g37ZQmxQ8v5AOVY+MTeWENpv6wJhYGUyQkIYYXRD6PBvGXZVY8NMcFdk4h+YQHLd87FVpjhwsqoEAFGZ5kpr7RuWBaVRoEGStVo4Z+KR8wYnOU9Y5Pwg9OV1rzl2BYt4+XcShH2Zog+bzdFc+cWWDOOcqx1XmdAsIOAlouMHt47R64DEIlZoU5wgg7qAhCugoqDR5hox4O+hT1higGE76NRjT7i/eiiWCK4Oo8g6aGC69SGbeeGiiB7SlLjrqKyI9sp0wjzR96p+Iiox6KCGOimcioxa1VEPOikJ4pRGgupAQOwh2ik3tNMAxgJ1Iv4OpNRilCgggJ+f0M2p1cgr9HJna6gtywWqel7ss56kOrF553iC2pyCaj4sIyKjVEukJoUakR55WrrLl2GTRgJeij4O5wMIZhi4Fvlv1xxihRAtxMJo5j7D2XoQAzgkj1bWdEBhYkJMGxQEQPo=";break;case"ro":$e="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";break;case"ru":$e="exEMBEOhEJTmIDadTmdBAcjKdDqcjcIDDEzCcjkYTyLhELBEMYGIiab4cIDSbjNJDaYToaTebo5HhlIWgkWgsGgt5uIGgtJu0F7QGii2ihZ5QVrPF+0F9PactWigGgtmguGgsp/UEFSpvUaY0F20UZMREM5CSTcdjCbDSZBAczKcjtcRBJBAY4cZDKbpbaznZBpISCZDbJycZTfR2hSWhS6bPp9UKlVKtWJxWp5Pl80UC0UE0UHjZ4up4sZ/OsZPpxQV7Q6LpcXOa4sK9TbCjxYIB4YRAaIcZh6XBEaDodDgcx0XBfyjvzRcYcJJzdiBdJDPyjgYTmczvJDJwoMPmhpttYmiiMXPKtrUJTK8vK6hqrVR5yjCPrINZokqG0Fyzyqo6EQbJoTqvssaJHp4nScKWXDOLFAQbpoUSftMXaqmi+RYQEHCaFenL+l1AQcpCIQ8rePKFjKNsBBigSCCYNIzuJFyQIIIiLjXFyZoIIY3jYuw5jGNEWDLFyzRwMozDCOo2DpFzAxwNI5jgNiNRc/SCCQtsjo8GMCIIaBPQAoLNvQWqgQyR8XQnGKTjWg46MSOgwjENgyoO364r2MaTjOEA6SKu6IocviGjeO6yBjDyCCkMoxu8g44Lo7Izy8j8SyVJknIYNw6jaMS6DeMyG0hSQQDJKkrI0Mq3JPVKWN5Os7jKsgZRgETDrmOUBBlG4RCCNg7o0OdfR6kSSDKEC1DYOs80CNCKhAEoyV9JIRCLT42oog64TwMcoJlKQRCo308jRIC3JSOVU1XK48z+ii3jLcCWpehC9jqEF2BBfVuDMNN6jIv9fS0ERoFCxavKwyVfTDhBKKu+aqKbEaZTdhBMGgXkEq48pGJzA6ukE2Lb19RuEE+rqpZBX1NYQmycQYzKftY1xCwEGdcmgSSvv/kpcZ1YExwhkqcQQz5GQhBSrhAzkMs7ks0vgWudWRnr+lirzaaVnVsGhleLNPkixafqSotAaBdM80G0kHnVyGhjadarNUH6UpSvTSWmjJ+rEMTSoKrasjwZ4PueRbtwe2kZp+jvGsEMkM0GdYgtCU51jJoFA2LVbXAEH5bieuwjw2U7Dvae7UX/VKoyO7wTnWYCmKImBbkUGtqzkBBpXIkCoKgoVMONnoX3sbi2gq3cinGgQFarYedAEOI96Pmv9ACmlkEQuo8GmsMdyXChEGmwQqqxf97uXOzSymObOr7Hb9pHx9jNnv8QTSvvhxfqFeKsLl3rEBoCQKu9pjjJEMiHYWIFtZXzGOtKk6IroiTYuDMW71zYl01G0gY4I+cESmNPNCfA8sDDVoZEc711DnWZlPLAUN3rMAoEXJavcNyAgas8ZWbQqROGqttEBDIjwNWiE+Qwesm8OmsH8EWeNrjjYdNgFI2ooLbD5FWaFEVuUBhZuqFmfFNcOnECjKcTiJMUoiwEbE1FtcOnNiyJ4WERzkSmi8J5EFqUGYiuoYUZuIbQTaukjUCIGrMDGwjbU1uJ5lnYwrI8DZngmz5nwbwgIGzRGJRJg6482LbI9vVQG1hiSaT/x7Kw4STDYIDFBjQfMW7H3JJmP9J4nCF3JxEQGuRqBmxCtcdi16SLiDNslbZEMokwkBwEbpAmEDeGzPYFuaBmsKTWlEZzJFzczXFoZbyhAQpsWOtwkjH4os4idzSKHNVNU1yiyYkRG1DEtITDRgYg9/AIgbs8Y2fB+cgUJNEFa6CB0/zPISaxH9kRqnGvSRCIOdjN5sISbAgZ7ZXUFTgnRKIG7cqFE6oZN9yEuEHuUnJPpxAkqHGooiUKbBijMPUcjGkQxZAbwEidFCH8hQbubFDOdqkSyPA3ZSFMNIbUrKYBuzAIgdS1odVyo9XhcFrEeBwsAJwYQ7IzJYS4iYbQ3l6Q6sgJhGg3h1IYqQhAYVYBuq1VyHAIA7hpUEoFOyeAQFsDcnEsgOFsBUrusuvScUOrkCgHKo5F0UBhXDV5fhdi1hsrsrWvKcGC1WcQgYzDuZEoPgdKavtOE1FQPRBgxguoYiOnsgGqzGXXSVfiU1+coWJuBfuh11An4AE8KaaaWjgILnzi2CIHE8bdt+gpCmLSJGeIGhfI600smTkeBy0S5zIroQhNnMCIJn4foklIbGU6AJUx8BEDlsDEret/m9NEqAiRoiRRI3JlZkp0FQj3NBxzE2GtpmzedxF9XVR6dDQ1icGBbokYgCUFwM1SrGuo5uzUJIzuSM2Z2/aDBoRfiGaEnV+mnntecWAxQsH432v6IAsgOXUCcJ/KCSpPywshmvLWYE0ypWkvjO0/ouWnw/cUwsQGISfi5cliYcQgBKLUDmELFciEKk4tQU2MIvsiYjQxia0bZ23QWvxeRtRWlFgwVyCBFwMFgZoBkDMGgNQbVERKl8GETZ1tqxTBcoYP8ztgdaINvwvsztys9Ocx9Lj/ZnpS/Rid+szwEFGTxBAgaYGeb1kCOUnSv2+ZHba6I0RGwIx9TKkiGih5jp8e6X+QHGTKRfH7VEwNVzRFxpUr5mnJGUoa6pz7bJBOjuzKrOUiI/lF1he2/es4D20lTga998UbM82Hqlm1wdgEfBi0Sn7U29yF2u1izUsGJ5fZLK5jx7j0FWNNagWCiwYvnPm60Rd0ixMiou11k14kbNyFPG7LKNnEMS3tlrZAssBuyS+mAmm2ZB2ouHtfU6DmocMRs6hiRWCmoPgZjXULQTGo2kQJM2Md2F3ejGl9XHCeRumI+r8mgmGoPixnQ97LU7eFOTMeo2WnsClGiiZ3c7qoMY+IMosGTWBSZFxI2oqhSUIZ+y837ghocxI8WwQYigbi3dWISQtUxECJdXLqGINSkCGF4DKSxVwIAxIo60Q9dIZOiLkSer3k2id45bgPE/mDd3JcD0IT3ojEAkBvDapgGIMmMhTIeS0NwZ8IcrtzrWB8dLVzPPS2vWhlT522jDBTeuPInx4kTICmXoikM1tk26B26uUmdEf0RTTymE99PPA+O8eU1ZUhHaNtVDOMs4llvCBBpIDzh0LusnkbYJaZbU0A9LULfk78q6qWL15LFCz8Z8QZZPZxpPRlN+ECZaZV0maH31LjX+jMaa5krFtId/NUC75L8pBtbND87pkDvo4m+njk2T6w+Y1r7LUpAT7pDL75/j3D8b3YpD3orr36l79T4T9rzD4ryT5BsL+h0b+zmb57/Rkb/iD76hah5j68AQzwjh7wj5nY/bSDcKGCei7Z0ZwInjcSaL5a9ZNIXY3LnT9r3AprpbSiKCZMG6AC1aJQzYRxRYGZoiJyEjl5ha0r3Z8Thj7Dvp+LQZqZjg0EJahLhZmqUzqBNbE5CCByLQ9RozHYXQ3MKwqjm76EEEFwpr5zgcLBvxqkLhJBbAtBZotoEBSgOQlY6ZQ5IIM4k43KpI7SwQN8QwiwM6tgmBJCjyBpqEM4pw2wqalw0r9iaIrC1DyiD6l0Jbf68UMRwkTb8zkb97vQr6ea4LKz0ZqEGj1SRK0j3LDb3bgj4yM7SEOyPcPCiAziTyoLZDpcJ8ETcY/qSylrGqS0JZiBHJWkRRVKxBXgEANwN4hglIOrrEJZjIJwxIMkaouJJB1Db4zUNI0Ipbm5u7mon0BbKznr2qCiZ7coqyWL9QyDIUTLzQy8Lal4FAgwFMJaRCzTSkeTn7/zoJKK5pz0UqVCbxkzebjQEAIYKYKQIwFr4aC7+Ropkr5Z+pvD549qQELaiBha+ASLH405RYGiTQ9y/MXEE8HyBLKUSsmqGLGiCBBaDryrvi08VqBcShkoyz1EdKRKdwoz9S2wXMjqMxhr2gQ48zmjoZKJrASsWQqsVamBj5CCJ7LMK8Ho9wrazkHEYSWAEAwYwoNww4N8NjDSY5n5ADpjT77TLjki5TUj7ZKJsBhT7z2z8I8knL2sObmprYRScQEAKAJ4KYKh3Bz6iQosjpsT2qNLmiZwoRpbc6Wr5gRTHb0UyD9EpQqyJLCkqCNMqRpcy4paHwn67oqI0Yr49g+aL7PynaLM2UW7Hwp0eh0DjjgjeMqpL4GhuUJyBMIDkby8uEB5sq/cwTGcwiWp2p24aLEQ/zEj0YEAIx4Q9UnjexqjnCfw9yQJDLX05sGsXEeLSRqDFEfbdZKKzI2LO7chpo0yF7LU0MpMlqAhmRELu8/L4EByV5wUAk4bh6Nz9z9ZlpDUSiBx7ZKLyK+yoKEDGp8gGIGjYUmB7RBMn5LJnhnwyUSpjwgwHTJhs8xQJAKEjSnbn08rakxIgxLMJqdZiZM8K6B7KVEtGJL4GprATxyL6LRlHjdyW72hygRZLJ9hsiIIQBLLu0I8rNIQj7Nw/ZrTYtCpLJzaMxz8yzlQGIGscw2MkDRcnMnqjIzqcKoM99HiRDF076ADGTcDz41kndBRzzRS4Dy1CySQmi3T/xvrZR+y0xFyTJCjd6WymZydQhrCFyhbe7ED0dQhsBjYoJ2CUCXRMBuSbjajAyJVS0r1QhxDlyPYzbjI+Zi4j4GyAgU0iQRlQibbIMerVgGzijTK9lSArEBsKSAM2MUFQi408y+ziRL6fblApqkE89Oyi9YRytYhogUVOCMKMNENJFYi8K9ckLXLkgq1aTIRNpsEylUlDlOg2lM8rxyTdRNpuTo8ko+BrpNpxAUrYoqxjqJ6CJ3Y+RvhtyZE7s6qKx0E3Dhqm9Y0IbAqfIGKnomjgD0C81hB1CJz+DQw1LadLFYlDNY6M7AzmDeYnTesuaGNg4HBXIIJ4IIIIYJB3DDUswzru708fIp4rx95BC1Qz71xRaq4mhMkzbdKdLS9lR3YQLwwHBZB6I5TMxL6vwgZ5R6MNJ0ddJ6wt1por9YZ5cu7hZ7tpBKT2SDh3VBbSSzjFI87HYXsNke8zApCTp69lRqIsT7lrlZUs7DVsIRFsdstWK0cTVtQn7iEM1t1vdoE7zcJtNugm1sjnBuq4KEDK1vRBqNy0FrAj4HE+Kzb8FdxNQWhmo28VcpdvBxj15FwHBMNpZ5ln9r1zbvdtAXsJ6gsKL3IslxluCBzLU4Fzl1KRTP11kWxM1190lv9rxA908oN20eN3EWr2t3dyBRhzanN1DY10B1CSleib1q1p10CRFt7DhtTD7XM6zIwXbEsMgqTFJFwHJnl7Bt5kTdTK865DB7d8E9hhjIVwL5a964NNZTLbF8NwS75L4HLozpF77qzTEqBraz9+NCV8hsFt7Pq5F7mAF8huRMi2lINjS3bcw+dnlCwHJxBCpkD2y3keZyNqgGIHKZjP8I1g4HJzZMie+BrVjFgmh9rCrXlF1jxvLZLZ1/t69vdthx1AVQQm5W7MgmmBeHsw0W9PKDuIRomIrQYRmASRjI799QLTmIJXzOdQ1IqmidOKLLLClLl+2IVIlRKkuLg/uLzcCbqEF+5XBuTKOMlBjLWLr6VB1RyFONgGE+K57acU7UVIyXRXCAh9A0WPymmQAGFLTCtLpxwgzPQmQGFMOPa5T57IFZEHSoQERXCRFSiGFS7u9s2NUURXxF9Qx9LnFSqT5qCURX66xsjX68xX68KTiV2UZsE/pmjCsyMpWOb/kVNAeJWUZuWW6dNAECOXgrlCTGNxR0mYAmVL4mmYc/Fij4EIeKSXuO2ZuTLhBMWaMZmamY+NNxObJX6nyoEmuL9OONZW5RlglZGO4xVj1c1NMmudbYWc1d1w9s+MJY9D4/onRpLlTop5JmOM9nuf2ZiVzWgzdfJ1c2wm43N2FviaOcGUGcSVz7gSOgt2eg67LLUs2hhvuhwWGiF3txqz0rWat9ufOUN5AjwmujVzef7aej1fFO+kWkl+dx0zmOcWGiqEFxUFImToo/b3lXczkT4aK1QQ8Tcr+dCNFsZW7NeolXTvk3epGpWpk7GnwoVwuqM4uouqtXupKe2rN7+a+dwoGqLAMVrcrWxDEN1Gl6QrSaLQqJTKRA4/rpjjjeGbybENiOT6htU6DXpty1TLz8LvdicTDpYoGplTty+VIQMNmYry6JEeyBKgxo71DW8TTpoaLp8iGG1tpY60WqjoOsWpRY5zeGSaY0Owc8uwuz6jFRDUZDZY5lIIgIRY+Tdu7WNVwmUFhMS9R7DZeG+xJa5olP1O+KlF4xmnmleiwphW4GZrG5VfW5lPWst2+RUV+6dcDXVPGIEU+lKRWOutGluTLNmdtjO428G7FDu4BxChSRh0Ly+5+H+KoX26aAm+b9i7W8mnu3u7pa7U63u/28e++82XO6Ra51FTdWRs2a++jjh8jNdi+OzXOOvCaEJXx3xAs5iV7QBcZoh/YpsBoQ3DprB/YnB1+vPDtcEmB8dwNudTlM7V7VV5xca+mmtfWkW7WXu7mdXDrAPHmhprnH+6Gn+cYGiNnIukPI+8j/nBU0ONgGlWFxHCGHwQlf6LCFXDvB3AVSGj+mxt/DvC+d17nLlBhB6SGTKHe9akMItBekFfdZvN0Jor+f6KKC0f1erG2vZgxZAYQVcDLC5+zWxpNVr3MNIRgYWs2X2IGNgGsvvPPBbLT/Zj3QcWKBy23RCBUHUidDRpXRxW4GpcnTVcPQ8EFj7mJM3RnR3JNzuKwmQGtUXMKhvTS2fVWG3RXVxtHRoXZg2/nSvOJx3XPGPTvVcLXVvUQsXRxg3AvDCkTd5gx1GQYX+p1QXUvM+XOeDvPP7d5W9PhMXB6YPCPQAmVQpMW5VZYr19W/GffdO6qQbO99WcPJWi5h+79YPd2OnYmmfcVTXW+9vfgqRtik4GQG2DlaMXAyWsvbIsOrph+QXhlac2GlPWI1viXdJzdaCCcXHizIfjGs+XPcXMHLHc2H1bfkFb3dPbnYpx/ivluTNYpMQ/j/xjqfLxDbD5iZPDhjG6uthkNjqQnZeieM/iGqBXwG/GGD3onRPUE53pHe+rmtPpa+noTenotVvh/kkyBW4G9eN1rz2hApnpfJvOfMl/nmhzaNumUTFKTxB1GBbbaQSZTxD2OgmptsDIVsVwsEmhVBjL4QOjGgsWFuXvpND3PwFuFfMMvWfvTC3GfxMV/xnMfwZA+oOTNkQmh/d9p2M8x0u3/zdGaz89MEhlBrFt/GnuNpIHT2WjMr6dOrd2zE2iOHvwv2TZH2jPE4OkqzsSv3PyXql4fxltek9x8FQGQHE4o/t5skQpIIYOgOQNgFYaAVMiSBlBNetsRpYRxj8njckUJxgR0HkqUCiRk9D8n4jYxW9yQmjo7LGzet6C+x2G7S78An3skTw9IKoKiRkBw/uXRDGmzCeMwK+hW0rURtC058gOJTxHpDXqCB8WtMgFrUwqp9wn6ixTyP+zaa4uAURCWpvmn5ZhI+e6QX2iEC/axsz8wtYbtlAxiPdtox/Vqvm3k7Pp9a28eUNvhp6XU92E6fxNzUH6JlDetfHxE9S+D94y4ssV0JWnTT7wv06kGXr5gn69kw8bGQatny+LX1lgXVYiQU19ATpaeyZX/HCYECXltsEyL0BNHXTskNaCPODQYmr5l9h8f+bWpgxo5QeDQwcELQMm7RshVKIZbDk1xW7CViyxwUjwfWZBgNJQ+9hBvHYPbIY3icRH5MNWhCgWDE7WhHkuTu7HM1m7wUCAi4QZlCEyUlUaHqTjh9de3AIhBDOmIYQQCmJEEWB2oVhVgMSJDEihKyy4WVixCuF0gdwt8LAJXCsYxttWuJrRuuUyYkrnoVj1g4ucRReshRyYV0v+M7HEHrA0hGBsEIJCvEtAxicAmA2MVBjhgGBARR+mHTPtfSd8OJhWRQTPBNj0Sp5siIHhWGrjixHY5sp1MCH7YVjPY5IMWGhqHzF424hKNDGiKPx1sKc3BAcfRDQ3ebwVxyFlN2hNCVqnFbNEKJCoTFTRy8mA3FOVITBxDCxbY92iOs2xlSPtQmwuROhmV9CbVqSUrJqOC0pI0N7bEmJnRKH0aEwdQ4lfgPoYi7CSDVE0fjsqoi5ycII6odkJDnXj1F0WX5dnjhjlgmIhchQaTskx8jdQiajMU6nBHnEG8JogNBBAIgPoA=";break;case"sk":$e="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";break;case"sl":$e="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";break;case"sr":$e="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";break;case"sv":$e="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";break;case"ta":$e="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";break;case"th":$e="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";break;case"tr":$e="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";break;case"uk":$e="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";break;case"vi":$e="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";break;case"zh-TW":$e="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";break;case"zh":$e="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";break;}return
json_decode(lzw_decompress(base64_decode($e)),true);}function
get_plural_translation_id($v){$ti=array('Too many unsuccessful logins, try again in %d minute(s).'=>129,'%d process(es) have been killed.'=>279,'%d query(s) executed OK.'=>186,'Query executed OK, %d row(s) affected.'=>184,'%d row(s) have been imported.'=>286,'Routine has been called, %d row(s) affected.'=>221,'%d row(s)'=>183,'%d byte(s)'=>41,'%d item(s) have been affected.'=>283,);return
isset($ti[$v])?$ti[$v]:null;}$Cl=$_SESSION["translations"];$Tf=Locale::get()->getLanguage();if($_SESSION["translations_version"]!=559102452){$Cl=[];$_SESSION["translations_version"]=559102452;}if($_SESSION["translations_language"]!=$Tf){$Cl=[];$_SESSION["translations_language"]=$Tf;}if(!$Cl){$Cl=get_translations($Tf);$_SESSION["translations"]=$Cl;}Locale::get()->setTranslations($Cl);$xa=null;$vc=false;$tf=null;if(function_exists('\adminneo_instance')){$xa=\adminneo_instance();$vc=true;}elseif(file_exists("adminneo-instance.php")){$xa=include_once"adminneo-instance.php";$vc=true;}if($vc&&!$xa
instanceof
Admin&&!$xa
instanceof
Pluginer){$xa=null;$gg="href=https://github.com/adminneo-org/adminneo#advanced-customizations ".target_blank();$tf=lang(123,"<b>adminneo-instance.php</b>","<b>adminneo_instance()</b>","Admin::create()")." <a $gg>".lang(1)."</a>";}if(!$xa)$xa=Admin::create();if($tf)$xa->addError($tf);if(!defined("AdminNeo\DRIVER")){define("AdminNeo\DRIVER",null);define("AdminNeo\DIALECT",null);}define("AdminNeo\SERVER",DRIVER?$_GET[DRIVER]:null);define("AdminNeo\DB",$_GET["db"]!=""?$_GET["db"]:null);define("AdminNeo\BASE_URL",preg_replace('~\?.*~','',relative_uri()));define("AdminNeo\ME",BASE_URL.'?'.(sid()?session_name()."=".urlencode(session_id()).'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));define("AdminNeo\HOME_URL",BASE_URL?:".");define("AdminNeo\SERVER_HOME_URL",substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1)?:".");const
VERSION="5.2.0";if(!ob_get_level())ob_start(null,4096);function
page_header($sl,$gb=[]){page_headers();if(is_ajax()&&Admin::get()->getErrors()){page_messages();exit;}if(!ob_get_level())ob_start(null,4096);$sl=strip_tags($sl);$Tj=$gb!==false&&$gb!==null&&SERVER!=""?" - ".h(Admin::get()->getServerName(SERVER)):"";$Wj=strip_tags(Admin::get()->getServiceTitle());$ul=$sl.$Tj." - ".($Wj!=""?$Wj:"AdminNeo");if(Admin::get()->getConfig()->isVersionVerificationEnabled()){$o=get_temp_dir()."/adminneo.version";if(!isset($_COOKIE["neo_version"])&&file_exists($o)&&($dg=filemtime($o)+86400-time())>0){$g=unserialize(file_get_contents($o));$_COOKIE["neo_version"]=$g["version"];cookie("neo_version",$g["version"],$dg);}}?>
<!DOCTYPE html>
<html lang="<?=Locale::get()->getLanguage();?>" dir="<?=lang(124);?>">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="robots" content="noindex, nofollow">
	<meta name="viewport" content="width=device-width, initial-scale=1"/>

	<title><?=$ul;echo'</title>

	';$Lb=validate_color_variant(Admin::get()->getConfig()->getColorVariant());echo"<link rel='stylesheet' href='",link_files("default-$Lb.css",[]),"'>\n";if(!Admin::get()->isLightModeForced())echo"<link rel='stylesheet' ".(!Admin::get()->isDarkModeForced()?"media='(prefers-color-scheme: dark)' ":"")."href='",link_files("default-$Lb-dark.css",[]),"'>\n";$ml=Admin::get()->getConfig()->getTheme();list($ml,$Lb)=validate_theme($ml,$Lb);if($ml!="default"){echo"<link rel='stylesheet' href='",link_files("$ml-$Lb.css",[]),"'>\n";if(!Admin::get()->isLightModeForced())echo"<link rel='stylesheet' ".(!Admin::get()->isDarkModeForced()?"media='(prefers-color-scheme: dark)' ":"")."href='",link_files("$ml-$Lb-dark.css",[]),"'>\n";}foreach(Admin::get()->getCssUrls()as$Yl){if(strpos($Yl,"adminneo-dark.css")===0&&!Admin::get()->isDarkModeForced())echo"<link rel='stylesheet' media='(prefers-color-scheme: dark)' href='",h($Yl),"'>\n";else
echo"<link rel='stylesheet' href='",h($Yl),"'>\n";}echo
script_src(link_files("main.js",[]));foreach(Admin::get()->getJsUrls()as$Yl)echo
script_src($Yl);Admin::get()->printFavicons();Admin::get()->printToHead();echo'</head>
<body class="',lang(124),' nojs">
<script',nonce(),'>
	const body = document.body;

	body.onkeydown = bodyKeydown;
	body.onclick = bodyClick;
	body.classList.replace("nojs", "js");

	const offlineMessage = \'',js_escape(lang(125)),'\';
	const thousandsSeparator = \'',js_escape(lang(100)),'\';
</script>


',"<div id='help' class='jush-".DIALECT." jsonly hidden'></div>",script("initHelpPopup();"),"<div id='content'>\n","<div class='header'>\n";if($gb!==null){echo'<nav class="breadcrumbs"><ul>','<li><a href="'.h(HOME_URL).'" title="',lang(126),'">',icon_solo("home"),'</a></li>';$Rj=SERVER!==null?Admin::get()->getServerName(SERVER):"";$Rj=$Rj!=""?h($Rj):lang(25);if($gb===false)echo"<li>$Rj</li>";else{$x=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);echo"<li><a href='".h($x)."' accesskey='1' title='Alt+Shift+1'>$Rj</a></li>";if($_GET["ns"]!=""||(DB!=""&&is_array($gb)))echo'<li><a href="'.h($x."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a></li>';if($gb===true){if($_GET["ns"]!="")echo'<li>'.h($_GET["ns"]).'</li>';else
echo"<li>",h(DB),"</li>";}else{if($_GET["ns"]!="")echo'<li><a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a></li>';foreach($gb
as$v=>$X){if(is_string($v)){$Kc=(is_array($X)?$X[1]:h($X));if($Kc!="")echo"<li><a href='".h(ME."$v=").urlencode(is_array($X)?$X[0]:$X)."'>$Kc</a></li>";}else
echo"<li>$X</li>\n";}}}echo"</ul></nav>";}echo"</div>\n","<h1>$sl</h1>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages();$h=&get_session("dbs");if(DB!=""&&$h&&!in_array(DB,$h,true))$h=null;stop_session();define("AdminNeo\PAGE_HEADER",1);}function
validate_color_variant($Lb){list(,$Lb)=validate_theme("default",$Lb);return$Lb;}function
validate_theme($ml,$Lb){$nl=get_available_themes();if(!isset($nl[$ml]))$ml="default";if(!isset($nl[$ml][$Lb])){reset($nl[$ml]);$Lb=key($nl[$ml]);}return[$ml,$Lb];}function
get_available_themes(){return
array('default'=>array('blue'=>true,'green'=>true,'red'=>true,),);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");header("X-Frame-Options: DENY");$rc=["script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self' https://api.github.com/repos/adminneo-org/adminneo/releases/latest","frame-src"=>"'self'","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",];Admin::get()->updateCspHeader($rc);$Pc=[];foreach($rc
as$Oc=>$mk)$Pc[]="$Oc $mk";header("Content-Security-Policy: ".implode("; ",$Pc));Admin::get()->sendHeaders();}function
get_nonce(){static$fh;if(!$fh)$fh=base64_encode(get_random_string(true));return$fh;}function
page_messages(){$Xl=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Ig=isset($_SESSION["messages"][$Xl])?$_SESSION["messages"][$Xl]:null;if($Ig){foreach($Ig
as$Eg)echo"<div class='message'>$Eg</div>\n",script("initToggles(qsl('.message'));");unset($_SESSION["messages"][$Xl]);}foreach(Admin::get()->getErrors()as$k)echo"<div class='error'>$k</div>\n";}function
page_footer($Mg=null){echo"</div>\n","<button id='navigation-button' class='button light navigation-button'>",icon_solo("menu"),icon_solo("close"),"</button>","<div id='navigation-panel' class='navigation-panel'>\n";Admin::get()->printNavigation($Mg);echo"<div class='footer'>\n","<div class='toolbox'>";if($Mg=="auth")language_select();else{$x=h(preg_replace('~\b(db|ns)=[^&]*&~',"",ME)."settings=");echo"<a class='button light' title='",lang(127),"' href='$x'>",icon_solo("settings"),"</a>";}echo"</div>";if($Mg!="auth")Admin::get()->printLogout();echo"</div>\n","</div>\n",script("initNavigation();");}function
int32($Ug){while($Ug>=2147483648)$Ug-=4294967296;while($Ug<=-2147483649)$Ug+=4294967296;return(int)$Ug;}function
long2str($W,$tm){$vj='';foreach($W
as$X)$vj
.=pack('V',$X);return$tm?substr($vj,0,end($W)):$vj;}function
str2long($vj,$tm){$W=array_values(unpack('V*',str_pad($vj,4*ceil(strlen($vj)/4),"\0")));if($tm)$W[]=strlen($vj);return$W;}function
xxtea_mx($Hm,$Gm,$Hk,$If){return
int32((($Hm>>5&0x7FFFFFF)^$Gm<<2)+(($Gm>>3&0x1FFFFFFF)^$Hm<<4))^int32(($Hk^$Gm)+($If^$Hm));}function
xxtea_encrypt_string($pi,$v){$v=array_values(unpack("V*",pack("H*",md5($v))));$W=str2long($pi,true);$Ug=count($W)-1;$Hm=$W[$Ug];$Gm=$W[0];$Ki=floor(6+52/($Ug+1));$Hk=0;while($Ki-->0){$Hk=int32($Hk+0x9E3779B9);$ed=$Hk>>2&3;for($Uh=0;$Uh<$Ug;$Uh++){$Gm=$W[$Uh+1];$Sg=xxtea_mx($Hm,$Gm,$Hk,$v[$Uh&3^$ed]);$Hm=int32($W[$Uh]+$Sg);$W[$Uh]=$Hm;}$Gm=$W[0];$Sg=xxtea_mx($Hm,$Gm,$Hk,$v[$Uh&3^$ed]);$Hm=int32($W[$Ug]+$Sg);$W[$Ug]=$Hm;}return
long2str($W,false);}function
xxtea_decrypt_string($g,$v){$v=array_values(unpack("V*",pack("H*",md5($v))));$W=str2long($g,false);$Ug=count($W)-1;$Hm=$W[$Ug];$Gm=$W[0];$Ki=floor(6+52/($Ug+1));$Hk=int32($Ki*0x9E3779B9);while($Hk){$ed=$Hk>>2&3;for($Uh=$Ug;$Uh>0;$Uh--){$Hm=$W[$Uh-1];$Sg=xxtea_mx($Hm,$Gm,$Hk,$v[$Uh&3^$ed]);$Gm=int32($W[$Uh]-$Sg);$W[$Uh]=$Gm;}$Hm=$W[$Ug];$Sg=xxtea_mx($Hm,$Gm,$Hk,$v[$Uh&3^$ed]);$Gm=int32($W[0]-$Sg);$W[0]=$Gm;$Hk=int32($Hk-0x9E3779B9);}return
long2str($W,true);}const
ENCRYPTION_GCM='aes-256-gcm';const
ENCRYPTION_CBC='aes-256-cbc';const
ENCRYPTION_TAG_LENGTH=16;const
ENCRYPTION_HMAC_LENGTH=64;function
generate_iv($bg){if(function_exists('random_bytes')){try{return
random_bytes($bg);}catch(Exception$ed){}}return
openssl_random_pseudo_bytes($bg);}function
hash_key($v){return
substr(hash('sha512',$v,true),0,32);}function
aes_encrypt_string($pi,$v){$Kg=PHP_VERSION_ID>=70100&&in_array(ENCRYPTION_GCM,openssl_get_cipher_methods())?ENCRYPTION_GCM:ENCRYPTION_CBC;$v=hash_key($v);$Df=generate_iv(openssl_cipher_iv_length($Kg)?:16);if($Kg==ENCRYPTION_GCM)$Bb=openssl_encrypt($pi,$Kg,$v,OPENSSL_RAW_DATA,$Df,$cl,"",ENCRYPTION_TAG_LENGTH);else{$Bb=openssl_encrypt($pi,$Kg,$v,OPENSSL_RAW_DATA,$Df);$cl=hash_hmac("sha512",$Df.$Bb,$v,true);}if($Bb===false)return
false;return$Df.$cl.$Bb;}function
aes_decrypt_string($g,$v){$Kg=PHP_VERSION_ID>=70100&&in_array(ENCRYPTION_GCM,openssl_get_cipher_methods())?ENCRYPTION_GCM:ENCRYPTION_CBC;$Ef=openssl_cipher_iv_length($Kg)?:16;$dl=$Kg==ENCRYPTION_GCM?ENCRYPTION_TAG_LENGTH:ENCRYPTION_HMAC_LENGTH;if(strlen($g)<$Ef+$dl)return
false;$v=hash_key($v);$Df=substr($g,0,$Ef);$cl=substr($g,$Ef,$dl);$Bb=substr($g,$Ef+$dl);if($Df===false||$cl===false||$Bb===false)return
false;if($Kg==ENCRYPTION_GCM)return
openssl_decrypt($Bb,$Kg,$v,OPENSSL_RAW_DATA,$Df,$cl);else{$We=hash_hmac('sha512',$Df.$Bb,$v,true);if(!hash_equals($cl,$We))return
false;return
openssl_decrypt($Bb,$Kg,$v,OPENSSL_RAW_DATA,$Df);}}function
encrypt_string($pi,$v){if($pi=="")return"";if(extension_loaded('openssl'))return
aes_encrypt_string($pi,$v);else
return
xxtea_encrypt_string($pi,$v);}function
decrypt_string($g,$v){if($g=="")return"";if(extension_loaded('openssl'))return
aes_decrypt_string($g,$v);else
return
xxtea_decrypt_string($g,$v);}$ni=[];if($_COOKIE["neo_permanent"]){foreach(explode(" ",$_COOKIE["neo_permanent"])as$X){list($v)=explode(":",$X);$ni[$v]=$X;}}function
validate_server_input(array&$ni){if(SERVER=="")return;$gi=parse_url(SERVER);if(!$gi)auth_error($ni);if(isset($gi['user'])||isset($gi['pass'])||isset($gi['query'])||isset($gi['fragment']))auth_error($ni);if(isset($gi['scheme'])&&!preg_match('~^(https?)$~i',$gi['scheme']))auth_error($ni);$Ze=(isset($gi['host'])?$gi['host']:'').(isset($gi['path'])?$gi['path']:'');if(!is_server_host_valid($Ze))auth_error($ni);if(isset($gi['port'])&&($gi['port']<1024||$gi['port']>65535))auth_error($ni,lang(128));}if(!function_exists('AdminNeo\is_server_host_valid')){function
is_server_host_valid($Ze){return
strpos($Ze,'/')===false;}}function
build_http_url($O,$V,$E,$Ec,$Dc=null){if(!preg_match('~^(https?://)?([^:]*)(:\d+)?$~',rtrim($O,'/'),$z))return
null;return($z[1]?:"http://").($V!==""||$E!==""?urlencode($V).":".urlencode($E)."@":"").($z[2]!==""?$z[2]:$Ec).(isset($z[3])?$z[3]:($Dc?":$Dc":""));}function
add_invalid_login(){$bb=get_temp_dir()."/adminneo.invalid";$n=null;foreach(glob("$bb*")?:[$bb]as$o){$n=open_file_with_lock($o);if($n)break;}if(!$n){$n=open_file_with_lock("$bb-".get_random_string());if(!$n)return;}$wf=unserialize(stream_get_contents($n));$pl=time();if($wf){foreach($wf
as$xf=>$X){if($X[0]<$pl)unset($wf[$xf]);}}$vf=&$wf[Admin::get()->getBruteForceKey()];if(!$vf)$vf=[$pl+30*60,0];$vf[1]++;write_and_unlock_file($n,serialize($wf));}function
check_invalid_login(array&$ni){$bb=get_temp_dir()."/adminneo.invalid";$wf=[];foreach(glob("$bb*")as$o){$n=open_file_with_lock($o);if($n){$wf=unserialize(stream_get_contents($n));unlock_file($n);break;}}$vf=($wf?$wf[Admin::get()->getBruteForceKey()]:[]);$eh=($vf&&$vf[1]>29?$vf[0]-time():0);if($eh>0)auth_error($ni,lang(129,ceil($eh/60)));}function
connect_to_db(array&$ni){if(Admin::get()->getConfig()->hasServers()&&!Admin::get()->getConfig()->getServer(SERVER))auth_error($ni);$f=connect(true,$k);if(!$f)connection_error(h($k),$ni);return$f;}function
authenticate(array&$ni){$I=Admin::get()->authenticate($_GET["username"],get_password());if($I!==true)connection_error($I,$ni);}function
connection_error($k,array&$ni){$k=$k?:lang(3);if(preg_match('~^ +| +$~',get_password()))$k
.="<br>".lang(130);auth_error($ni,$k);}Admin::get()->init();$Qa=isset($_POST["auth"])?$_POST["auth"]:null;if($Qa){$O=isset($Qa["server"])?$Qa["server"]:"";$Sj=Admin::get()->getConfig()->getServer($O);$Uc=$Sj?$Sj->getDriver():(isset($Qa["driver"])?$Qa["driver"]:"");$O=$Sj?$O:trim($O);$V=isset($Qa["username"])?$Qa["username"]:"";$E=isset($Qa["password"])?$Qa["password"]:"";if($Sj&&$Sj->hasCredentials()&&$V==""&&$E==""){$V=$Sj->getUsername();$E=$Sj->getPassword();}$i=$Sj?$Sj->getDatabase():(isset($Qa["db"])?$Qa["db"]:"");save_login($Uc,$O,$V,$E,$i);if($Qa["permanent"]){$v=implode("-",array_map("base64_encode",[$Uc,$O,$V,$i]));$Di=Admin::get()->getPrivateKey(true);$pd=$Di?encrypt_string($E,$Di):false;$ni[$v]="$v:".base64_encode($pd?:"");cookie("neo_permanent",implode(" ",$ni));}if(count($_POST)==1||DRIVER!=$Uc||SERVER!=$O||$_GET["username"]!==$V||DB!=$i)redirect(auth_url($Uc,$O,$V,$i));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(["pwds","db","dbs","queries"]as$v)set_session($v,null);unset_permanent($ni);redirect(SERVER_HOME_URL,lang(131));}elseif($ni&&!$_SESSION["pwds"]){$Di=Admin::get()->getPrivateKey();foreach($ni
as$v=>$X){list(,$Ab)=explode(":",$X);list($Uc,$O,$V,$i)=array_map("base64_decode",explode("-",$v));$E=$Di?decrypt_string(base64_decode($Ab),$Di):false;save_login($Uc,$O,$V,$E,$i);}}function
save_login($Uc,$O,$V,$E,$i=""){set_password($Uc,$O,$V,$E);$_SESSION["db"][$Uc][$O][$V][$i]=true;}function
unset_permanent(array&$ni){foreach($ni
as$v=>$X){list($Uc,$O,$V,$i)=array_map("base64_decode",explode("-",$v));if($Uc==DRIVER&&$O==SERVER&&$V==$_GET["username"]&&$i==DB)unset($ni[$v]);}cookie("neo_permanent",implode(" ",$ni));}function
auth_error(array&$ni,$k=null){$Xj=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Xj]||$_GET[$Xj])&&!$_SESSION["token"])$k=lang(132);else{restart_session();add_invalid_login();$E=get_password();if($E!==null){if($E===false)$k=lang(133);set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($ni);}}if(!$_COOKIE[$Xj]&&$_GET[$Xj]&&ini_bool("session.use_only_cookies"))$k=lang(134);if(!$k)$k=lang(3);Admin::get()->addError($k);print_login_page();}function
print_login_page(){$D=session_get_cookie_params();cookie("neo_key",($_COOKIE["neo_key"]?:get_random_string()),$D["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(30),null);echo"<form action='' method='post'>\n","<div>";if(print_hidden_fields($_POST,["auth"]))echo"<p class='message'>".lang(135)."\n";echo"</div>\n";Admin::get()->printLoginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!DRIVER){Admin::get()->addError(lang(136));page_header(lang(137),false);page_footer("auth");exit;}if(isset($_GET["username"])&&!defined('AdminNeo\DRIVER_EXTENSION')){Admin::get()->addError(lang(138,implode(", ",Drivers::getExtensions(DRIVER))));unset($_SESSION["pwds"][DRIVER]);unset_permanent($ni);page_header(lang(139),false);page_footer("auth");exit;}if(!isset($_GET["username"])||get_password()===null)print_login_page();validate_server_input($ni);check_invalid_login($ni);Admin::get()->getConfig()->applyServer(SERVER);$f=connect_to_db($ni);authenticate($ni);create_driver($f);if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){Admin::get()->addError(lang(140));page_header(lang(5));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Qa&&$_POST["token"])$_POST["token"]=get_token();if($_POST){if(!verify_token()){$pf="max_input_vars";$_g=ini_get($pf);if(extension_loaded("suhosin")){foreach(["suhosin.request.max_vars","suhosin.post.max_vars"]as$v){$X=ini_get($v);if($X&&(!$_g||$X<$_g)){$pf=$v;$_g=$X;}}}if(!$_POST["token"]&&$_g)Admin::get()->addError(lang(141,"'$pf'"));else
Admin::get()->addError(lang(140).' '.lang(142));$_POST=[];}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$k=lang(143,"'post_max_size'");if(isset($_GET["sql"]))$k
.=' '.lang(144);Admin::get()->addError($k);}if(isset($_GET["settings"])){$P=Admin::get()->getSettings();$ak=array_merge(Admin::get()->getSettingsRows(1),Admin::get()->getSettingsRows(2),Admin::get()->getSettingsRows(3));if($_POST){$D=[];foreach($ak
as$v=>$K){if($v!="lang"&&isset($_POST[$v])){$am=$_POST[$v]===""||(is_array($_POST[$v])&&in_array("",$_POST[$v]));$D[$v]=(!$am?$_POST[$v]:null);}}$P->updateParameters($D);redirect(remove_from_uri());}$sl=lang(127);page_header($sl,[$sl]);echo"<form id='settings' action='' method='post'>\n","<table class='box'>\n";foreach($ak
as$K)echo$K;echo"</table>\n","<p>","<input type='submit' value='".lang(107),"' class='button default hidden'>",input_token(),"</p>\n","</form>\n",script("initSettingsForm();");page_footer();exit;}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?Connection::get()->selectDatabase(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){Admin::get()->addError(lang(145));header("HTTP/1.1 404 Not Found");page_header(lang(29).": ".h(DB),true);}else{if($_POST["db"])queries_redirect(substr(ME,0,-1),lang(146),drop_databases($_POST["db"]));$Rj=Admin::get()->getServerName(SERVER);$sl=h(Drivers::get(DRIVER)).": ".($Rj!=""?h($Rj):lang(25));page_header($sl,false);$hg=['privileges'=>[lang(69),"users"],'processlist'=>[lang(147),"list"],'variables'=>[lang(148),"variable"],'status'=>[lang(149),"status"],];$ig="";foreach($hg
as$v=>$X){if(support($v))$ig
.="<a href='".h(ME)."$v='>".icon($X[1])."$X[0]</a>";}if($ig)echo"<p class='links top-links'>$ig</p>\n";echo"<p>".lang(150,Drivers::get(DRIVER),"<b>".h(Connection::get()->getVersion())."</b>","<b>".DRIVER_EXTENSION."</b>")."\n","<p>".lang(151,"<b>".h(logged_user())."</b>")."\n";$h=Admin::get()->getDatabases();if($h){$zj=support("scheme");$Ha=collations();echo"<form action='' method='post'>\n","<div class='table-footer-parent'>\n","<div class='scrollable'>\n","<table class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(29).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(152)."</a>":"")."<td>".lang(44)."<td>".lang(153)."<td>".lang(154)." - <a href='".h(ME)."dbsize=1'>".lang(155)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$h=($_GET["dbsize"]?count_tables($h):array_flip($h));foreach($h
as$i=>$T){$oj=h(ME)."db=".urlencode($i);$r=h("Db-".$i);echo"<tr>".(support("database")?"<td class='actions'>".checkbox("db[]",$i,in_array($i,(array)$_POST["db"]),"","","",$r):""),"<th><a href='$oj' id='$r'>".h($i)."</a>";$Hb=h(db_collation($i,$Ha));echo"<td>".(support("database")?"<a href='$oj".($zj?"&amp;ns=":"")."&amp;database=' title='".lang(66)."'>$Hb</a>":$Hb),"<td align='right'><a href='$oj&amp;schema=' id='tables-".h($i)."' title='".lang(68)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($i)."'>".($_GET["dbsize"]?db_size($i):"?"),"\n";}echo"</table>\n","</div>\n";if(support("database"))echo"<div class='table-footer'><div class='field-sets'>\n","<fieldset><legend>",lang(156)," <span id='selected'></span></legend><div class='fieldset-content'>\n",input_hidden("all"),script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };"),"<input type='submit' class='button' name='drop' value='",lang(157),"'>",confirm(),"\n","</div></fieldset>\n","</div></div>\n",script("initTableFooter()");echo"</div>\n",input_token(),"</form>\n",script("tableCheck();");}}echo'<p class="links"><a href="'.h(ME).'database=">'.icon("database-add").lang(72)."</a>\n";page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){Admin::get()->addError(lang(158));header("HTTP/1.1 404 Not Found");page_header(lang(77).": ".h($_GET["ns"]),true);page_footer("ns");exit;}}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$m=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=[idf_escape($_GET["field"])];$I=Driver::get()->select($a,$M,[where($_GET,$m)],$M);$K=($I?$I->fetchRow():[]);echo
Connection::get()->formatValue($K[0],$m[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$m=fields($a);if(!$m)Admin::get()->addError(error());$S=table_status1($a,true);$_=Admin::get()->getTableName($S);$nj=[];foreach($m
as$v=>$l)$nj+=$l["privileges"];$sl=$m&&is_view($S)?$S['Engine']=='materialized view'?lang(159):lang(160):lang(7);$Uk=$_!=""?$_:h($a);page_header("$sl: $Uk",[$Uk]);$Yj=null;if(isset($nj["insert"])||!support("table"))$Yj="";Admin::get()->printTableMenu($S,$Yj);$of=[];if(!preg_match("~sqlite|mssql|pgsql~",DIALECT)&&isset($S["Engine"]))$of[]=lang(161).": ".h($S["Engine"]);if(isset($S["Collation"]))$of[]=lang(44).": ".h($S["Collation"]);if($of)echo"<p>",implode(", ",$of),"</p>";if($m)Admin::get()->printTableStructure($m);$Qb=$S["Comment"];if($Qb!="")echo"<p class='keep-lines'>",lang(45),": ",Admin::get()->formatComment($Qb),"</p>\n";if(is_view($S))$gd='<p class="links"><a href="'.h(ME).'view='.urlencode($a).'">'.icon("edit").lang(34)."</a>\n";else$gd='<p class="links"><a href="'.h(ME).'create='.urlencode($a).'">'.icon("edit").lang(35)."</a>\n";if($of||$m||$Qb!="")echo$gd;if(support("partitioning")&&preg_match("~partitioned~",$S["Create_options"])){echo"<h2 id='partition-by'>".lang(162)."</h2>\n";$fi=get_partitions_info($a);Admin::get()->printTablePartitions($fi);echo$gd;}if(support("indexes")&&Driver::get()->supportsIndex($S)){echo"<h2 id='indexes'>".lang(163)."</h2>\n";$u=indexes($a);if($u)Admin::get()->printTableIndexes($u);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.icon("edit").lang(164)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h2 id='foreign-keys'>".lang(86)."</h2>\n";$me=foreign_keys($a);if($me){echo"<table>\n","<thead><tr><th>".lang(165)."<td>".lang(166)."<td>".lang(89)."<td>".lang(88)."<td></thead>\n";foreach($me
as$_=>$p)echo"<tr title='".h($_)."'>","<th><i>".implode("</i>, <i>",array_map('AdminNeo\h',$p["source"]))."</i>","<td><a href='".h($p["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($p["db"]),ME):($p["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($p["ns"]),ME):ME))."table=".urlencode($p["table"])."'>".($p["db"]!=""&&$p["db"]!=DB?"<b>".h($p["db"])."</b>.":"").($p["ns"]!=""&&$p["ns"]!=$_GET["ns"]?"<b>".h($p["ns"])."</b>.":"").h($p["table"])."</a>","(<i>".implode("</i>, <i>",array_map('AdminNeo\h',$p["target"]))."</i>)","<td>".h($p["on_delete"]),"<td>".h($p["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($_)).'">'.lang(167).'</a>',"\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.icon("add").lang(168)."</a>\n";}if(support("check")){echo"<h2 id='checks'>".lang(169)."</h2>\n";$ub=Driver::get()->checkConstraints($a);if($ub){echo"<table cellspacing='0'>\n";foreach($ub
as$v=>$X)echo"<tr title='".h($v)."'>","<td><code class='jush-".DIALECT."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($v))."'>".lang(167)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.icon("add").lang(170)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h2 id='triggers'>".lang(171)."</h2>\n";$Il=triggers($a);if($Il){echo"<table>\n";foreach($Il
as$v=>$X)echo"<tr><td>".h($X[0])."<td>".h($X[1])."<th>".h($v)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($v))."'>".lang(167)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.icon("add").lang(172)."</a>\n";}}elseif(isset($_GET["schema"])){$tl=h(": ".DB.($_GET["ns"]?".$_GET[ns]":""));page_header(lang(68).$tl,[lang(68)]);$Wk=[];$Xk=[];$la=($_GET["schema"]?:$_COOKIE["neo_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$la,$z,PREG_SET_ORDER);foreach($z
as$q=>$y){$Wk[$y[1]]=[$y[2],$y[3]];$Xk[]="\n\t'".js_escape($y[1])."': [ $y[2], $y[3] ]";}$yl=0;$ab=-1;$xj=[];$Yi=[];$Zf=[];$Ia=Driver::get()->getAllFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$vi=0;$xj[$R]["fields"]=[];foreach($Ia[$R]as$l){$vi+=1.25;$l["pos"]=$vi;$xj[$R]["fields"][$l["field"]]=$l;}$xj[$R]["pos"]=(isset($Wk[$R])?$Wk[$R]:[$yl,0]);foreach(Admin::get()->getForeignKeys($R)as$X){if(!$X["db"]){$Xf=$ab;if((isset($Wk[$R][1])?$Wk[$R][1]:0)||(isset($Wk[$X["table"]][1])?$Wk[$X["table"]][1]:0))$Xf=min(floatval(isset($Wk[$R][1])?$Wk[$R][1]:0),floatval(isset($Wk[$X["table"]][1])?$Wk[$X["table"]][1]:0))-1;else$ab-=.1;while($Zf[(string)$Xf])$Xf-=.0001;$xj[$R]["references"][$X["table"]][(string)$Xf]=[$X["source"],$X["target"]];$Yi[$X["table"]][$R][(string)$Xf]=$X["target"];$Zf[(string)$Xf]=true;}}$yl=max($yl,$xj[$R]["pos"][0]+2.5+$vi);}echo"<div id='schema' style='height: {$yl}em;'>\n","<script",nonce(),">\n","gid('schema').onselectstart = () => false;\n","const tablePos = {",implode(",",$Xk),"\n};\n","const em = gid('schema').offsetHeight / $yl;\n","document.onmousemove = schemaMousemove;\n","document.onmouseup = partialArg(schemaMouseup, '",js_escape(DB),"');\n","</script>\n";foreach($xj
as$_=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($_).'"><b>'.h($_)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$l){$X='<span'.type_class($l["type"]).' title="'.h($l["type"].($l["length"]?"($l[length])":"").($l["null"]?" NULL":'')).'">'.h($l["field"]).'</span>';echo"<br>".($l["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$fl=>$Zi){foreach($Zi
as$Xf=>$Vi){$Yf=$Xf-(isset($Wk[$_][1])?$Wk[$_][1]:0);$q=0;foreach($Vi[0]as$lk){echo"\n<div class='references' title='",h($fl),"' id='refs$Xf-$q' style='left: {$Yf}em; top: ",$R["fields"][$lk]["pos"],"em; padding-top: .5em;'>","<div style='border-top: 1px solid Gray; width: ".(-$Yf)."em;'></div>","</div>";$q++;}}}foreach((array)$Yi[$_]as$fl=>$Zi){foreach($Zi
as$Xf=>$d){$Yf=$Xf-(isset($Wk[$_][1])?$Wk[$_][1]:0);$q=0;foreach($d
as$el){echo"\n<div class='references' title='",h($fl),"' id='refd$Xf-$q' style='left: {$Yf}em; top: ".$R["fields"][$el]["pos"]."em; height: 1.25em;'>","<svg style='width: 1em; height: 1em; float: right;' viewBox='0 0 22 22' fill='currentColor'><path d='M11,19l10,-8l-10,-8l0,16Z'/></svg>","<div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$Yf)."em;'></div>","</div>";$q++;}}}echo"\n</div>\n";}foreach($xj
as$R){foreach((array)$R["references"]as$fl=>$Zi){foreach($Zi
as$Xf=>$Vi){$Lg=$yl;$yg=-10;foreach($Vi[0]as$v=>$lk){$wi=$R["pos"][0]+$R["fields"][$lk]["pos"];$xi=$xj[$fl]["pos"][0]+$xj[$fl]["fields"][$Vi[1][$v]]["pos"];$Lg=min($Lg,$wi,$xi);$yg=max($yg,$wi,$xi);}echo"<div class='references' id='refl$Xf' style='left: $Xf"."em; top: $Lg"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($yg-$Lg)."em;'></div></div>\n";}}}echo"</div>\n","<p class='links'>","<a href='",(ME."schema=".urlencode($la)),"' id='schema-link'>",lang(173),"</a>","</p>\n";}elseif(isset($_GET["dump"])){$a=$_GET["dump"];$P=Admin::get()->getSettings();if($_POST){$P->updateParameters(["dumpFormat"=>$_POST["format"],"dumpDbStyle"=>$_POST["db_style"],"dumpTypes"=>isset($_POST["types"])?$_POST["types"]:null,"dumpRoutines"=>isset($_POST["routines"])?$_POST["routines"]:null,"dumpEvents"=>isset($_POST["events"])?$_POST["events"]:null,"dumpTableStyle"=>$_POST["table_style"],"dumpAutoIncrement"=>isset($_POST["auto_increment"])?$_POST["auto_increment"]:null,"dumpTriggers"=>isset($_POST["triggers"])?$_POST["triggers"]:null,"dumpDataStyle"=>$_POST["data_style"],"dumpOutput"=>$_POST["output"],]);$Ek=array_flip(isset($_POST["databases"])?$_POST["databases"]:[])+array_flip(isset($_POST["tables"])?$_POST["tables"]:[])+array_flip(isset($_POST["data"])?$_POST["data"]:[]);if(count($Ek)==1)$cf=key($Ek);elseif(DB!==null)$cf=DB;else$cf=SERVER!=""?Admin::get()->getServerName(SERVER):"localhost";$Jd=dump_headers($cf,DB==null||count($Ek)>1);$_f=preg_match('~sql~',$_POST["format"]);if($_f){echo"-- AdminNeo ".VERSION." ".Drivers::get(DRIVER)." ".Connection::get()->getVersion()." dump\n\n";if(DIALECT=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";Connection::get()->query("SET time_zone = '+00:00'");Connection::get()->query("SET sql_mode = ''");}}$Ck=$_POST["db_style"];$h=[DB];if(DB==""){$h=$_POST["databases"];if(is_string($h))$h=explode("\n",rtrim(str_replace("\r","",$h),"\n"));}foreach((array)$h
as$i){Admin::get()->dumpDatabase($i);if(Connection::get()->selectDatabase($i)){if($_f&&preg_match('~CREATE~',$Ck)&&($nc=Connection::get()->getValue("SHOW CREATE DATABASE ".idf_escape($i),1))){set_utf8mb4($nc);if($Ck=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($i).";\n";echo"$nc;\n";}if($_f){if($Ck)echo
use_sql($i).";\n\n";$Qh="";if($_POST["types"]){foreach(types()as$r=>$U){$td=type_values($r);if($td)$Qh
.=($Ck!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($td);\n\n";else$Qh
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$_=$K["ROUTINE_NAME"];$pj=$K["ROUTINE_TYPE"];$nc=create_routine($pj,["name"=>$_]+routine($K["SPECIFIC_NAME"],$pj));set_utf8mb4($nc);$Qh
.=($Ck!='DROP+CREATE'?"DROP $pj IF EXISTS ".idf_escape($_).";;\n":"")."$nc;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$nc=remove_definer(Connection::get()->getValue("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($nc);$Qh
.=($Ck!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$nc;;\n\n";}}echo($Qh&&DIALECT=='sql'?"DELIMITER ;;\n\n$Qh"."DELIMITER ;\n\n":$Qh);}if($_POST["table_style"]||$_POST["data_style"]){$qm=[];foreach(table_status('',true)as$_=>$S){$R=(DB==""||in_array($_,(array)$_POST["tables"]));$g=(DB==""||in_array($_,(array)$_POST["data"]));if($R||$g){if($Jd=="tar"){$vl=new
TmpFile;ob_start([$vl,'write'],1e5);}Admin::get()->dumpTable($_,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$qm[]=$_;elseif($g){$m=fields($_);Admin::get()->dumpData($_,$_POST["data_style"],"SELECT *".convert_fields($m,$m)." FROM ".table($_));}if($_f&&$_POST["triggers"]&&$R&&($Il=trigger_sql($_)))echo"\nDELIMITER ;;\n$Il\nDELIMITER ;\n";if($Jd=="tar"){ob_end_flush();tar_file((DB!=""?"":"$i/")."$_.csv",$vl);}elseif($_f)echo"\n";}}if(function_exists('AdminNeo\foreign_keys_sql')){foreach(table_status('',true)as$_=>$S){$R=(DB==""||in_array($_,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($_);}}foreach($qm
as$om)Admin::get()->dumpTable($om,$_POST["table_style"],1);if($Jd=="tar")echo
pack("x512");}}}if($_f)echo"-- ".gmdate("Y-m-d H:i:s e")."\n";exit;}$_=DB!==null?h(DB):(SERVER!=""?h(Admin::get()->getServerName(SERVER)):lang(25));page_header(lang(71).": $_",($_GET["export"]!=""?["table"=>$_GET["export"]]:[lang(71)]));echo"<form action='' method='post'>\n","<table class='box'>\n";$Ac=['','USE','DROP+CREATE','CREATE'];$Yk=['','DROP+CREATE','CREATE'];$xc=['','TRUNCATE+INSERT','INSERT'];if(DIALECT=="sql")$xc[]='INSERT+UPDATE';echo"<tr><th>",lang(174),"</th><td>",html_radios("format",Admin::get()->getDumpFormats(),$P->getParameter("dumpFormat","sql")),"</td></tr>\n";if(DIALECT!="sqlite"){echo"<tr><th>",lang(29),"</th>","<td>",html_select('db_style',$Ac,$P->getParameter("dumpDbStyle",DB==""?"CREATE":"")),"<span class='labels'>";if(support("type"))echo
checkbox("types",1,$P->getParameter("dumpTypes"),lang(113));if(support("routine"))echo
checkbox("routines",1,$P->getParameter("dumpRoutines",$_GET["dump"]==""?"1":""),lang(175));if(support("event"))echo
checkbox("events",1,$P->getParameter("dumpEvents",$_GET["dump"]==""?"1":""),lang(176));echo"</span></td></tr>";}echo"<tr><th>",lang(153),"</th><td>",html_select('table_style',$Yk,$P->getParameter("dumpTableStyle","DROP+CREATE"))," <span class='labels'>",checkbox("auto_increment",1,$P->getParameter("dumpAutoIncrement"),lang(46));if(support("trigger"))echo
checkbox("triggers",1,$P->getParameter("dumpTriggers","1"),lang(171));echo"</span></td></tr>","<tr><th>",lang(177),"</th><td>",html_select("data_style",$xc,$P->getParameter("dumpDataStyle","INSERT")),"</td></tr>","<tr><th>",lang(178),"</th><td>",html_radios("output",Admin::get()->getDumpOutputs(),$P->getParameter("dumpOutput","file")),"</td></tr>\n","</table>\n","<p>","<input type='submit' class='button default' value='",lang(71),"'>",input_token(),"</p>\n","<table>\n",script("qsl('table').onclick = dumpClick;");$_i=[];if(DB!=""){$xb=($a!=""?"":" checked");echo"<thead><tr>","<th><label class='block'><input type='checkbox' id='check-tables'$xb>".lang(153)."</label>".script("gid('check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th class='right'><label class='block'>".lang(177)."<input type='checkbox' id='check-data'$xb></label>".script("gid('check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$qm="";$al=tables_list();foreach($al
as$_=>$U){$zi=preg_replace('~_.*~','',$_);$xb=($a==""||$a==(substr($a,-1)=="%"?"$zi%":$_));$Ci="<tr><td>".checkbox("tables[]",$_,$xb,$_,"","block");if($U!==null&&!preg_match('~table~i',$U))$qm
.="$Ci\n";else
echo"$Ci<td class='right'><label class='block'><span id='Rows-".h($_)."'></span>".checkbox("data[]",$_,$xb)."</label>\n";$_i[$zi]++;}echo$qm;if($al)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(29)."</label>",script("gid('check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$h=Admin::get()->getDatabases();if($h){foreach($h
as$i){if(!information_schema($i)){$zi=preg_replace('~_.*~','',$i);echo"<tr><td>".checkbox("databases[]",$i,$a==""||$a=="$zi%",$i,"","block")."\n";$_i[$zi]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo"</table>\n","</form>\n";$hg=[];foreach($_i
as$v=>$X){if($v!=""&&$X>1)$hg[]="<a href='".h(ME)."dump=".urlencode("$v%")."'>".icon("check").h($v)."*</a>";}if($hg)echo"<p class='links'>",implode("",$hg),"</p>\n";}elseif(isset($_GET["privileges"])){$tl=DB!=""?h(": ".DB):"";page_header(lang(69).$tl,[lang(69)]);echo'<p class="links top-links"><a href="',h(ME),'user=">',icon("user-add"),lang(179),"</a></p>\n";$I=Connection::get()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$Ae=$I;if(!$I)$I=Connection::get()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''>\n";hidden_fields_get();echo
input_hidden("db",DB);if(!$Ae)echo
input_hidden("grant");echo"\n","<div class='scrollable'>\n","<table class='checkable'>\n","<thead><tr><th>".lang(27)."<th>".lang(25)."<th></thead>\n";while($K=$I->fetchAssoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(37)."</a>\n";if(!$Ae||DB!="")echo"<tr><td><input class='input' name='user' autocapitalize='off'><td><input class='input' name='host' value='localhost' autocapitalize='off'><td><input type='submit' class='button' value='".lang(37)."'>\n";echo"</table>\n","</div>\n","</form>\n";}elseif(isset($_GET["sql"])){$P=Admin::get()->getSettings();if($_POST["export"]){$P->updateParameters(["exportFormat"=>$_POST["format"],"exportOutput"=>$_POST["output"],]);dump_headers("sql");Admin::get()->dumpTable("","");Admin::get()->dumpData("","table",$_POST["query"]);exit;}restart_session();$Ue=&get_session("queries");$Te=&$Ue[DB];if($_POST["clear"]){$Te=[];redirect(remove_from_uri("history"));}$sl=isset($_GET["import"])?lang(70):lang(39);page_header($sl,[$sl]);if($_POST){$se=false;if(!isset($_GET["import"]))$G=$_POST["query"];elseif($_POST["webfile"]){$hf=Admin::get()->getImportFilePath();if($hf){if(file_exists($hf))$se=fopen($hf,"rb");elseif(file_exists("$hf.gz"))$se=fopen("compress.zlib://$hf.gz","rb");}$G=$se?fread($se,1e6):false;}else$G=get_file("sql_file",true,";");if(is_string($G)){if(function_exists('memory_get_usage')&&($Cg=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Cg,2*strlen($G)+memory_get_usage()+8e6));if($G!=""&&strlen($G)<1e6){$Ki=$G.(preg_match("~;[ \t\r\n]*\$~",$G)?"":";");if(!$Te||first(end($Te))!=$Ki){restart_session();$Te[]=[$Ki,time()];set_session("queries",$Ue);stop_session();}}$nk="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Jc=";";$A=0;$ld=true;$bc=connect();if($bc&&DB!=""){$bc->selectDatabase(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$bc);}$Pb=0;$vd=[];$Yh='[\'"'.(DIALECT=="sql"?'`#':(DIALECT=="sqlite"?'`[':(DIALECT=="mssql"?'[':''))).']|/\*|-- |$'.(DIALECT=="pgsql"?'|\$[^$]*\$':'');$zl=microtime(true);$dd=Admin::get()->getDumpFormats();unset($dd["sql"]);while($G!=""){if(!$A&&preg_match("~^$nk*+DELIMITER\\s+(\\S+)~i",$G,$y)){$Jc=$y[1];$oe=Admin::get()->formatSqlCommandQuery(trim($y[0]));if($oe!="")echo"<pre><code class='jush-".DIALECT."'>$oe</code></pre>\n";$G=substr($G,strlen($y[0]));}else{preg_match('('.preg_quote($Jc)."\\s*|$Yh)",$G,$y,PREG_OFFSET_CAPTURE,$A);list($qe,$vi)=$y[0];if(!$qe&&$se&&!feof($se))$G
.=fread($se,1e5);else{if(!$qe&&rtrim($G)=="")break;$A=$vi+strlen($qe);if($qe&&rtrim($qe)!=$Jc){$mb=Driver::get()->hasCStyleEscapes()||(DIALECT=="pgsql"&&($vi>0&&strtolower($G[$vi-1])=="e"));$li='(';if($qe=='/*')$li
.='\*/';elseif($qe=='[')$li
.=']';elseif(preg_match('~^-- |^#~',$qe))$li
.="\n";else$li
.=preg_quote($qe).($mb?"|\\\\.":"");$li
.='|$)s';while(preg_match($li,$G,$y,PREG_OFFSET_CAPTURE,$A)){$vj=$y[0][0];if(!$vj&&$se&&!feof($se))$G
.=fread($se,1e5);else{$A=$y[0][1]+strlen($vj);if(!isset($vj[0])||$vj[0]!="\\")break;}}}else{$ld=false;$Ki=substr($G,0,$vi+strlen($Jc));$Pb++;$Ci="<pre id='sql-$Pb'><code class='jush-".DIALECT."'>".Admin::get()->formatSqlCommandQuery(trim($Ki))."</code></pre>\n";if(DIALECT=="sqlite"&&preg_match("~^$nk*+ATTACH\\b~i",$Ki,$y)){echo$Ci,"<p class='error'>".lang(180)."\n";$vd[]=" <a href='#sql-$Pb'>$Pb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$Ci;ob_flush();flush();}$wk=microtime(true);if(Connection::get()->multiQuery($Ki)&&is_object($bc)&&preg_match("~^$nk*+USE\\b~i",$Ki))$bc->query($Ki);do{$I=Connection::get()->storeResult();if(Connection::get()->getError()){echo($_POST["only_errors"]?$Ci:""),"<p class='error'>",lang(181),(!empty(Connection::get()->getErrno())?" (".Connection::get()->getErrno().")":""),": ",error()."</p>\n";$vd[]=" <a href='#sql-$Pb'>$Pb</a>";if($_POST["error_stops"])break
2;}else{$pl=" <span class='time'>(".format_time($wk).")</span>";$hd=(strlen($Ki)<1000?" <a href='".h(ME)."sql=".urlencode(trim($Ki))."'>".icon("edit").lang(37)."</a>":"");$Pi=Connection::get()->getQueryInfo();$za=Connection::get()->getAffectedRows();$um=($_POST["only_errors"]?null:Driver::get()->warnings());$wm="warnings-$Pb";$xm=$um?"<a href='#$wm' class='toggle'>".lang(38).icon_chevron_down()."</a>":null;$Ed=null;$Fd="explain-$Pb";$Gd=false;$Hd="export-$Pb";if(is_object($I)){if(!$_POST["only_errors"])echo"<div class='table-result'>\n";$w=$_POST["limit"];$Ih=select($I,$bc,[],$w);if(!$_POST["only_errors"]){echo"<p class='links'>";$jh=$I->getRowsCount();echo($jh?($w&&$jh>$w?lang(182,$w):"").lang(183,$jh):""),$pl,$hd,$xm;if($bc&&preg_match("~^($nk|\\()*+SELECT\\b~i",$Ki)&&($Ed=explain($bc,$Ki)))echo"<a href='#$Fd' class='toggle'>Explain".icon_chevron_down()."</a>";$Gd=true;echo"<a href='#$Hd' class='toggle'>".lang(71).icon_chevron_down()."</a>","</p>\n";}}else{if(preg_match("~^$nk*+(CREATE|DROP|ALTER)$nk++(DATABASE|SCHEMA)\\b~i",$Ki)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"]){echo"<p class='message' title='".h($Pi)."'>",lang(184,$za),"$pl $hd";if($xm)echo", $xm";echo"</p>\n";}}if(!$_POST["only_errors"])echo
script("initToggles(qsl('p'));");if($um)echo"<div id='$wm' class='hidden'>\n$um</div>\n";if($Ed){echo"<div id='$Fd' class='hidden explain'>\n";select($Ed,$bc,$Ih);echo"</div>\n";}if($Gd)echo"<form id='$Hd' action='' method='post' class='hidden'><p>\n",html_select("format",$dd,$P->getParameter("exportFormat")),html_select("output",Admin::get()->getDumpOutputs(),$P->getParameter("exportOutput"))." ",input_hidden("query",$Ki),input_token()," <input type='submit' class='button' name='export' value='".lang(71)."'>","</p></form>\n";if(is_object($I)&&!$_POST["only_errors"])echo"</div>\n";}$wk=microtime(true);}while(Connection::get()->nextResult());}$G=substr($G,$A);$A=0;}}}}if($ld)echo"<p class='message'>".lang(185)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(186,$Pb-count($vd))," <span class='time'>(".format_time($zl).")</span>\n";elseif($vd&&$Pb>1)echo"<p class='error'>".lang(181).": ".implode("",$vd)."\n";}else
echo"<p class='error'>".upload_error($G)."\n";}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!isset($_GET["import"])){$Ki=$_GET["sql"];if($_POST)$Ki=$_POST["query"];elseif($_GET["history"]=="all")$Ki=$Te;elseif($_GET["history"]!="")$Ki=$Te[$_GET["history"]][0];echo"<p>";textarea("query",$Ki,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."gid('form').onsubmit = partial(sqlSubmit, gid('form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"</p>","<p><input type='submit' class='button default' value='".lang(187)."' title='Ctrl+Enter'>",lang(188).": <input type='number' name='limit' class='input size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<div class='field-sets'>\n","<fieldset><legend>".lang(189)."</legend><div class='fieldset-content'>";$Ie=(extension_loaded("zlib")?"[.gz]":"");if(ini_bool("file_uploads"))echo"SQL$Ie (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>","<input type='submit' class='button default' value='".lang(187)."'>";else
echo
lang(190);echo"</div></fieldset>\n";$hf=Admin::get()->getImportFilePath();if($hf)echo"<fieldset><legend>".lang(191)."</legend><div class='fieldset-content'>",lang(192,"<code>".h($hf)."$Ie</code>"),' <input type="submit" class="button default" name="webfile" value="'.lang(193).'">',"</div></fieldset>\n";echo"</div>\n","<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(194)),checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(195)),input_token(),"</p>\n";if(!isset($_GET["import"]))Admin::get()->printAfterSqlCommand();if(!isset($_GET["import"])&&$Te){echo"<div class='field-sets'>\n";print_fieldset_start("history",lang(196),"history",$_GET["history"]!="");for($X=end($Te);$X;$X=prev($Te)){$v=key($Te);list($Ki,$pl,$jd)=$X;echo" <pre><code class='jush-".DIALECT."'>",truncate_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$Ki))))),"</code></pre>",'<p class="links">',"<a href='".h(ME."sql=&history=$v")."'>".icon("edit").lang(37)."</a>"," <span class='time' title='".@date('Y-m-d',$pl)."'>".@date("H:i:s",$pl).($jd?" ($jd)":"")."</span>","</p>";}echo"<p><input type='submit' class='button' name='clear' value='".lang(197)."'>\n","<a href='",h(ME."sql=&history=all")."' class='button light'>",icon("edit"),lang(198),"</a></p>\n";print_fieldset_end("history");echo"</div>\n";}echo"</form>\n";}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$m=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$m):""):where($_GET,$m));$Wl=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($m
as$_=>$l){if(!isset($l["privileges"][$Wl?"update":"insert"])||Admin::get()->getFieldName($l)==""||$l["generated"])unset($m[$_]);}if($_POST&&!isset($_GET["select"])){$lg=$_POST["referer"];if($_POST["insert"])$lg=($Wl?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$lg))$lg=ME."select=".urlencode($a);$u=indexes($a);$Rl=unique_array($_GET["where"],$u);$Qi="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($lg,lang(199),Driver::get()->delete($a,$Qi,!$Rl));else{$Yj=[];foreach($m
as$_=>$l){$X=process_input($l);if($X!==false&&$X!==null)$Yj[idf_escape($_)]=$X;}if($Wl){if(!$Yj)redirect($lg);queries_redirect($lg,lang(200),Driver::get()->update($a,$Yj,$Qi,!$Rl));if(is_ajax()){page_headers();page_messages();exit;}}else{$I=Driver::get()->insert($a,$Yj);$Vf=($I?last_id($I):0);queries_redirect($lg,lang(201,($Vf?" $Vf":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=[];foreach($m
as$_=>$l){if(isset($l["privileges"]["select"])){$Na=($_POST["clone"]&&$l["auto_increment"]?"''":convert_field($l));$M[]=($Na?"$Na AS ":"").idf_escape($_);}}$K=[];if(!support("table"))$M=["*"];if($M){$I=Driver::get()->select($a,$M,[$Z],$M,[],(isset($_GET["select"])?2:1));if(!$I)Admin::get()->addError(error());else{$K=$I->fetchAssoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetchAssoc()))$K=null;}}if(!support("table")&&!$m){if(!$Z){$I=Driver::get()->select($a,["*"],[],["*"]);$K=($I?$I->fetchAssoc():false);if(!$K)$K=[Driver::get()->primary=>""];}if($K){foreach($K
as$v=>$X){if(!$Z)$K[$v]=null;$m[$v]=["field"=>$v,"null"=>($v!=Driver::get()->primary),"auto_increment"=>($v==Driver::get()->primary)];}}}edit_form($a,$m,$K,$Wl);}elseif(isset($_GET["create"])){$a=$_GET["create"];$bi=[];foreach(['HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST']as$v)$bi[$v]=$v;$Xi=referencable_primary($a);$me=[];foreach($Xi
as$Uk=>$l)$me[str_replace("`","``",$Uk)."`".str_replace("`","``",$l["field"])]=$Uk;$Lh=[];$S=[];if($a!=""){$Lh=fields($a);$S=table_status($a);if(!$S)Admin::get()->addError(lang(75));}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)Admin::get()->getSettings()->updateParameter("commentsOpened",isset($_POST["comments"])?$_POST["comments"]:null);if($_POST&&!process_fields($K["fields"])&&!Admin::get()->getErrors()){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(202),drop_tables([$a]));else{$m=[];$Ia=[];$bm=false;$ke=[];$Kh=reset($Lh);$Ba=" FIRST";foreach($K["fields"]as$v=>$l){$p=$me[$l["type"]];$Ll=($p!==null?$Xi[$p]:$l);if($l["field"]!=""){if(!$l["generated"])$l["default"]=null;$Hi=process_field($l,$Ll);$Ia[]=[$l["orig"],$Hi,$Ba];if(!$Kh||$Hi!==process_field($Kh,$Kh)){$m[]=[$l["orig"],$Hi,$Ba];if($l["orig"]!=""||$Ba)$bm=true;}if($p!==null)$ke[idf_escape($l["field"])]=($a!=""&&DIALECT!="sqlite"?"ADD":" ").format_foreign_key(['table'=>$me[$l["type"]],'source'=>[$l["field"]],'target'=>[$Ll["field"]],'on_delete'=>$l["on_delete"],]);$Ba=" AFTER ".idf_escape($l["field"]);}elseif($l["orig"]!=""){$bm=true;$m[]=[$l["orig"]];}if($l["orig"]!=""){$Kh=next($Lh);if(!$Kh)$Ba="";}}$di="";if(support("partitioning")){if(isset($bi[$K["partition_by"]])){$D=[];foreach($K
as$v=>$X){if(preg_match('~^partition~',$v))$D[$v]=$X;}foreach($D["partition_names"]as$v=>$_){if($_===""){unset($D["partition_names"][$v]);unset($D["partition_values"][$v]);}}if($D!=get_partitions_info($a)){$ei=[];if($D["partition_by"]=='RANGE'||$D["partition_by"]=='LIST'){foreach($D["partition_names"]as$v=>$_){$Y=$D["partition_values"][$v];$ei[]="\n  PARTITION ".idf_escape($_)." VALUES ".($D["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$di
.="\nPARTITION BY {$D["partition_by"]}({$D["partition"]})";if($ei)$di
.=" (".implode(",",$ei)."\n)";elseif($D["partitions"])$di
.=" PARTITIONS ".(int)$D["partitions"];}}elseif(preg_match("~partitioned~",$S["Create_options"]))$di
.="\nREMOVE PARTITIONING";}$Eg=lang(203);if($a==""){cookie("neo_engine",isset($K["Engine"])?$K["Engine"]:"");$Eg=lang(204);}$_=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($_),$Eg,alter_table($a,$_,(DIALECT=="sqlite"&&($bm||$ke)?$Ia:$m),$ke,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$di));}}if($a!="")page_header(lang(35).": ".h($a),["table"=>$a,lang(35)]);else
page_header(lang(74),[lang(74)]);if(!$_POST){$Ol=Driver::get()->getTypes();$K=["Engine"=>$_COOKIE["neo_engine"],"fields"=>[["field"=>"","type"=>(isset($Ol["int"])?"int":(isset($Ol["integer"])?"integer":"")),"on_update"=>""]],"partition_names"=>[""],];if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=[];if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($Lh
as$l){$l["generated"]=$l["generated"]?:(isset($l["default"])?"DEFAULT":"");$K["fields"][]=$l;}if(support("partitioning")){$K+=get_partitions_info($a);$K["partition_names"][]="";$K["partition_values"][]="";}}}$Kf=[];if($K["Collation"])$Kf[$K["Collation"]]=true;foreach($K["fields"]as$l){if($l["collation"])$Kf[$l["collation"]]=true;}$Ib=Admin::get()->getCollations(array_keys($Kf));$rd=Driver::get()->engines();foreach($rd
as$qd){if(!strcasecmp($qd,$K["Engine"])){$K["Engine"]=$qd;break;}}echo"<form action='' method='post' id='form'>\n";if(support("columns")||$a==""){echo"<p>",lang(205),": ","<input class='input' name='name' data-maxlength='64' value='",h($K["name"]),"' autocapitalize='off'",(($a==""&&!$_POST)?" autofocus":""),">";if($rd)echo" ",html_select("Engine",[""=>"(".lang(206).")"]+$rd,$K["Engine"]),help_script_command("value",true);if($Ib&&!preg_match("~sqlite|mssql~",DIALECT))echo" ",html_select("Collation",[""=>"(".lang(87).")"]+$Ib,$K["Collation"]);echo" <input type='submit' class='button default' value='",lang(107),"'>","</p>";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$Ib,"TABLE",$me);echo"</table>\n",script("initFieldsEditing(gid('edit-fields'));");if(support("move_col"))echo
script("initSortable('#edit-fields tbody');");echo"</div>\n","<p>",lang(46),": ","<input type='number' class='input size' name='Auto_increment' size='6' value='",h($K["Auto_increment"]),"'>";$Ub=$_POST?$_POST["comments"]:Admin::get()->getSettings()->getParameter("commentsOpened");$Rb=$Ub?"":"hidden";if(support("comment")){echo
checkbox("comments",1,$Ub,lang(45),"editingCommentsClick(this, true);","jsonly")," ";if(preg_match('~\n~',$K["Comment"]))echo"<textarea name='Comment' rows='2' cols='20'",($Rb?" class='$Rb'":""),">",h($K["Comment"]),"</textarea>";else
echo"<input name='Comment' value='",h($K["Comment"]),"' data-maxlength='",(Connection::get()->isMinVersion("5.5")?2048:60),"' class='input $Rb'>";}echo"</p>\n<p>","<input type='submit' class='button default' value='",lang(107),"'>";}elseif($a!="")echo"<p>";if($a!="")echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>",confirm(lang(207,$a)),"</p>\n";if(support("partitioning")){echo"<div class='field-sets'>\n";$ci=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset_start("partition",lang(162),"split",(bool)$K["partition_by"]);echo"<p>",html_select("partition_by",[""=>""]+$bi,$K["partition_by"]),help_script_command("value.replace(/./, 'PARTITION BY \$&')",true),script("qsl('select').onchange = partitionByChange;"),"(<input class='input' name='partition' value='",h($K["partition"]),"'>) ",lang(48),": ","<input type='number' name='partitions' class='input size ",($ci||!$K["partition_by"]?"hidden":""),"' value='",h($K["partitions"]),"'>","</p>\n","<table id='partition-table'",($ci?"":" class='hidden'"),">\n","<thead><tr><th>",lang(208),"</th><th>",lang(50),"</th></tr></thead>\n";foreach($K["partition_names"]as$v=>$X){echo"<tr>","<td><input class='input' name='partition_names[]' value='",h($X),"' autocapitalize='off'>";if($v==count($K["partition_names"])-1)echo
script("qsl('input').oninput = partitionNameChange;");echo"</td>","<td><input class='input' name='partition_values[]' value='",h($K["partition_values"][$v]),"'></td>","</tr>\n";}echo"</table>\n","</p>\n";print_fieldset_end("partition");echo"</div>\n";}echo
input_token(),"</form>\n";}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$lf=["PRIMARY","UNIQUE","INDEX"];$S=table_status($a,true);$f=Connection::get();$qg=$f->isMariaDB();if(preg_match('~MyISAM|M?aria'.($f->isMinVersion($qg?"10.0.5":"5.6")?'|InnoDB':'').'~i',$S["Engine"]))$lf[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.($f->isMinVersion($qg?"10.2.2":"5.7")?'|InnoDB':'').'~i',$S["Engine"]))$lf[]="SPATIAL";$u=indexes($a);$F=[];if(DIALECT=="mongo"){$F=$u["_id_"];unset($lf[0]);unset($u["_id_"]);}$K=$_POST;if($K)Admin::get()->getSettings()->updateParameter("indexOptions",isset($K["options"])?$K["options"]:null);if($_POST&&!$_POST["add"]&&!$_POST["drop_col"]){$b=[];foreach($K["indexes"]as$t){$_=$t["name"];if(in_array($t["type"],$lf)){$d=[];$cg=[];$Lc=[];$Yj=[];ksort($t["columns"]);foreach($t["columns"]as$v=>$c){if($c!=""){$bg=isset($t["lengths"][$v])?$t["lengths"][$v]:null;$Kc=isset($t["descs"][$v])?$t["descs"][$v]:null;$Yj[]=idf_escape($c).($bg?"(".(+$bg).")":"").($Kc?" DESC":"");$d[]=$c;$cg[]=($bg?:null);$Lc[]=$Kc;}}$Cd=$u[$_];if($Cd){ksort($Cd["columns"]);ksort($Cd["lengths"]);ksort($Cd["descs"]);if($t["type"]==$Cd["type"]&&array_values($Cd["columns"])===$d&&(!$Cd["lengths"]||array_values($Cd["lengths"])===$cg)&&array_values($Cd["descs"])===$Lc){unset($u[$_]);continue;}}if($d)$b[]=[$t["type"],$_,$Yj];}}foreach($u
as$_=>$Cd)$b[]=[$Cd["type"],$_,"DROP"];if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(209),alter_indexes($a,$b));}page_header(lang(164),["table"=>$a,lang(164)],h($a));$m=array_keys(fields($a));if($_POST["add"]){foreach($K["indexes"]as$v=>$t){if($t["columns"][count($t["columns"])]!="")$K["indexes"][$v]["columns"][]="";}$t=end($K["indexes"]);if($t["type"]||array_filter($t["columns"],'strlen'))$K["indexes"][]=["columns"=>[1=>""]];}if(!$K){foreach($u
as$v=>$t){$u[$v]["name"]=$v;$u[$v]["columns"][]="";}$u[]=["columns"=>[1=>""]];$K["indexes"]=$u;}$cg=(DIALECT=="sql"||DIALECT=="mssql");$ck=$_POST?$_POST["options"]:Admin::get()->getSettings()->getParameter("indexOptions");echo"<form action='' method='post'>\n","<div class='scrollable'>\n","<table class='nowrap'>\n","<thead><tr>","<th id='label-type'>",lang(210),"</th>","<th><input type='submit' class='button invisible'>",lang(42).($cg?"<span class='idxopts".($ck?"":" hidden")."'> (".lang(51).")</span>":"");if($cg||support("descidx"))echo
checkbox("options",1,$ck,lang(92),"indexOptionsShow(this.checked)","jsonly")."\n";echo"</th>","<th id='label-name'>",lang(211),"</th>","<th>","<button name='add[0]' value='1' title='",lang(93),"' class='button light hidden'>",icon_solo("add"),"</button>","</th>","</tr></thead>\n";if($F){echo"<tr><td>PRIMARY<td>";foreach($F["columns"]as$v=>$c)echo
select_input(" disabled",$m,$c),"<label><input type='checkbox' disabled>".lang(59)."</label> ";echo"<td><td>\n";}$Ff=1;foreach($K["indexes"]as$t){if(!$_POST["drop_col"]||$Ff!=key($_POST["drop_col"])){echo"<tr><td>",html_select("indexes[$Ff][type]",[-1=>""]+$lf,$t["type"],($Ff==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type"),"</td>","<td>";ksort($t["columns"]);$q=1;foreach($t["columns"]as$v=>$c){echo"<span>".select_input(" name='indexes[$Ff][columns][$q]' title='".lang(42)."'",($m?array_combine($m,$m):$m),$c,"partial(".($q==count($t["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(DIALECT=="sql"?"":$_GET["indexes"]."_")."')"),"<span class='idxopts".($ck?"":" hidden")."'>",($cg?"<input type='number' name='indexes[$Ff][lengths][$q]' class='input size' value='".(h(isset($t["lengths"][$v])?$t["lengths"][$v]:""))."' title='".lang(212)."'>":""),(support("descidx")?checkbox("indexes[$Ff][descs][$q]",1,isset($t["descs"][$v])?$t["descs"][$v]:false,lang(59)):""),"</span> </span>";$q++;}echo"</td>","<td><input name='indexes[$Ff][name]' value='",h($t["name"]),"' class='input' autocapitalize='off' aria-labelledby='label-name'></td>\n","<td>","<button name='drop_col[$Ff]' value='1' title='",h(lang(55)),"' class='button light'>",icon_solo("remove"),"</button>",script("qsl('button').onclick = onRemoveIndexRowClick;"),"</td>\n";}$Ff++;}echo"</table>\n","</div>\n","<p>","<input type='submit' class='button default' value='",lang(107),"'>",input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!isset($_POST["add_x"])){$_=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(213),drop_databases([DB]));}elseif(DB!==$_){if(DB!=""){$_GET["db"]=$_;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($_),lang(214),rename_database($_,$K["collation"]));}else{$h=explode("\n",str_replace("\r","",$_));$Fk=true;$Uf="";foreach($h
as$i){if(count($h)==1||$i!=""){if(!create_database($i,$K["collation"]))$Fk=false;$Uf=$i;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Uf),lang(215),$Fk);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($_).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(216));}}if(DB!="")page_header(lang(66).": ".h(DB),[lang(66)]);else
page_header(lang(72),[lang(72)]);$_=DB;if($_POST)$_=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,collations());elseif(DIALECT=="sql"){foreach(get_vals("SHOW GRANTS")as$Ae){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$Ae,$y)&&$y[1]){$_=stripcslashes(idf_unescape("`$y[2]`"));break;}}}$Ib=Admin::get()->getCollations($K["collation"]?[$K["collation"]]:[]);echo"<form action='' method='post'>\n","<p>";if($_POST["add_x"]||strpos($_,"\n"))echo"<textarea id='name' name='name' rows='10' cols='40'>",h($_),"</textarea><br>\n";else
echo"<input class='input' name='name' id='name' value='",h($_),"' data-maxlength='64' autocapitalize='off' autofocus>\n";if($Ib)echo
html_select("collation",[""=>"(".lang(87).")"]+$Ib,$K["collation"]),doc_link(['sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",]),"\n";echo"<input type='submit' class='button default' value='",lang(107),"'>\n";if(DB!="")echo"<input type='submit' class='button' name='drop' value='".lang(157)."'>".confirm(lang(207,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<button name='add_x' value='1' title='",h(lang(93)),"' class='button light'>",icon_solo("add"),"</button>\n";echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST){$x=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$x,lang(217));else{$_=trim($K["name"]);$x
.=urlencode($_);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($_),$x,lang(218));elseif($_GET["ns"]!=$_)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($_),$x,lang(219));else
redirect($x);}}if($_GET["ns"]!="")page_header(lang(67).": ".h($_GET["ns"]),[lang(67)]);else
page_header(lang(73),[lang(73)]);if(!$K)$K["name"]=$_GET["ns"];echo"<form action='' method='post'>\n","<p>","<input class='input' name='name' id='name' value='",h($K["name"]),"' autocapitalize='off' autofocus>","<input type='submit' class='button default' value='",lang(107),"'>";if($_GET["ns"]!="")echo"<input type='submit' class='button' name='drop' value='".lang(157)."'>".confirm(lang(207,$_GET["ns"]))."\n";echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["call"])){$ka=$_GET["name"]?:$_GET["call"];page_header(lang(220).": ".h($ka),[lang(220)]);$pj=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$if=[];$Qh=[];foreach($pj["fields"]as$q=>$l){if(substr($l["inout"],-3)=="OUT")$Qh[$q]="@".idf_escape($l["field"])." AS ".idf_escape($l["field"]);if(!$l["inout"]||substr($l["inout"],0,2)=="IN")$if[]=$q;}if($_POST){$ob=[];foreach($pj["fields"]as$v=>$l){if(in_array($v,$if)){$X=process_input($l);if($X===false)$X="''";if(isset($Qh[$v]))Connection::get()->query("SET @".idf_escape($l["field"])." = $X");}$ob[]=(isset($Qh[$v])?"@".idf_escape($l["field"]):$X);}$G=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($ka)."(".implode(", ",$ob).")";$wk=microtime(true);$I=Connection::get()->multiQuery($G);$za=Connection::get()->getAffectedRows();echo
Admin::get()->formatSelectQuery($G,$wk,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$bc=connect();if($bc)$bc->selectDatabase(DB);do{$I=Connection::get()->storeResult();if(is_object($I))select($I,$bc);else
echo"<p class='message'>".lang(221,$za)." <span class='time'>".@date("H:i:s")."</span>\n";}while(Connection::get()->nextResult());if($Qh)select(Connection::get()->query("SELECT ".implode(", ",$Qh)));}}echo"<form action='' method='post'>\n";if($if){echo"<table class='box'>\n";foreach($if
as$v){$l=$pj["fields"][$v];$_=$l["field"];echo"<tr><th>".Admin::get()->getFieldName($l);$Y=isset($_POST["fields"][$_])?$_POST["fields"][$_]:"";if($Y!=""){if($l["type"]=="set")$Y=implode(",",$Y);}input($l,$Y,(string)(isset($_POST["function"][$_])?$_POST["function"][$_]:""));echo"\n";}echo"</table>\n";}echo"<p>\n","<input type='submit' class='button' value='",lang(220),"'>\n",input_token(),"</p>\n","</form>\n";$Qb=$pj["comment"];if($Qb!==null&&$Qb!==""){$Qb=h(trim($pj["comment"],"\n"));if(preg_match('~^ +~',$Qb,$z)){preg_match_all("~^($z[0]|$)~m",$Qb,$fg);if(count($fg[0])==substr_count($Qb,"\n"))$Qb=preg_replace("~^($z[0])~m","",$Qb);}$Qb=preg_replace('~(^|[^\n]\n)(Description|Parameters|Example)\n~',"$1\n<strong>$2</strong>\n",$Qb);echo"<pre class='comment'>$Qb</pre>\n";}}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$_=$_GET["name"];$K=$_POST;if($_POST&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$el=[];foreach($K["source"]as$v=>$X)$el[$v]=$K["target"][$v];$K["target"]=$el;}if(DIALECT=="sqlite")$I=recreate_table($a,$a,[],[],[" $_"=>($K["drop"]?"":" ".format_foreign_key($K))]);else{$b="ALTER TABLE ".table($a);$I=($_==""||queries("$b DROP ".(DIALECT=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($_)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(222):($_!=""?lang(223):lang(224))),$I);if(!$K["drop"])Admin::get()->addError(lang(225));}page_header(lang(226).": ".h($a),["table"=>$a,lang(226)]);if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=[];}elseif($_!=""){$me=foreign_keys($a);$K=$me[$_];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=[""];}echo"<form action='' method='post'>\n";$lk=array_keys(fields($a));if($K["db"]!="")Connection::get()->selectDatabase($K["db"]);if($K["ns"]!=""){$Mh=get_schema();set_schema($K["ns"]);}$Wi=array_keys(array_filter(table_status('',true),'AdminNeo\fk_support'));$el=array_keys(fields(in_array($K["table"],$Wi)?$K["table"]:reset($Wi)));$wh="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>",lang(227),": ",html_select("table",$Wi,$K["table"],$wh);if(support("scheme")){$yj=array_filter(Admin::get()->getSchemas(),function($xj){return!preg_match('~^information_schema$~i',$xj);});echo
lang(77),": ",html_select("ns",$yj,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$wh);if($K["ns"]!="")set_schema($Mh);}elseif(DIALECT!="sqlite"){$Bc=[];foreach(Admin::get()->getDatabases()as$i){if(!information_schema($i))$Bc[]=$i;}echo
lang(228),": ",html_select("db",$Bc,$K["db"]!=""?$K["db"]:$_GET["db"],$wh);}echo
input_hidden("change-js"),"<noscript><input type='submit' class='button' name='change' value='",lang(229),"'></noscript>","</p>\n","<table>","<thead><tr><th id='label-source'>",lang(165),"<th id='label-target'>",lang(166),"</thead>\n";$Ff=0;foreach($K["source"]as$v=>$X){echo"<tr>","<td>".html_select("source[".(+$v)."]",[-1=>""]+$lk,$X,($Ff==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$v)."]",$el,isset($K["target"][$v])?$K["target"][$v]:null,"","label-target");$Ff++;}echo"</table>\n","<noscript><p><input type='submit' class='button' name='add' value='",lang(230),"'></p></noscript>","<p>\n",lang(89),": ",html_select("on_delete",[-1=>""]+Driver::get()->getOnActions(),$K["on_delete"]),lang(88),": ",html_select("on_update",[-1=>""]+Driver::get()->getOnActions(),$K["on_update"]),doc_link(['sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",]),"</p>\n<p>","<input type='submit' class='button default' value='",lang(107),"'>";if($_!="")echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>",confirm(lang(207,$_));echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$Nh="VIEW";if(DIALECT=="pgsql"&&$a!=""){$zk=table_status($a);$Nh=strtoupper($zk["Engine"]);}if($_POST){$_=trim($K["name"]);$Na=" AS\n$K[select]";$lg=ME."table=".urlencode($_);$Eg=lang(231);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$_&&DIALECT!="sqlite"&&$U=="VIEW"&&$Nh=="VIEW")query_redirect((DIALECT=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($_).$Na,$lg,$Eg);else{$gl=$_."_adminneo_".uniqid();drop_create("DROP $Nh ".table($a),"CREATE $U ".table($_).$Na,"DROP $U ".table($_),"CREATE $U ".table($gl).$Na,"DROP $U ".table($gl),($_POST["drop"]?substr(ME,0,-1):$lg),lang(232),$Eg,lang(233),$a,$_);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($Nh!="VIEW");if($k=error())Admin::get()->addError($k);}if($a!="")page_header(lang(34).": ".h($a),["table"=>$a,lang(34)]);else
page_header(lang(234),[lang(234)]);echo"<form action='' method='post'>\n","<p>",lang(211),":","<input class='input' name='name' value='",h($K["name"]),"' data-maxlength='64' autocapitalize='off'>\n";if(support("materializedview"))echo
checkbox("materialized",1,$K["materialized"],lang(159));echo"</p>\n<p>";textarea("select",$K["select"]);echo"</p>\n<p>","<input type='submit' class='button default' value='",lang(107),"'>\n";if($a!="")echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>\n",confirm(lang(207,$a));echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["event"])){$da=$_GET["event"];$uf=["YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND"];$_k=["ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE"];$K=$_POST;if($_POST){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($da),substr(ME,0,-1),lang(235));elseif(in_array($K["INTERVAL_FIELD"],$uf)&&isset($_k[$K["STATUS"]])){$wj="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($da!=""?lang(236):lang(237)),queries(($da!=""?"ALTER EVENT ".idf_escape($da).$wj.($da!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$wj)."\n".$_k[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}if($da!="")page_header(lang(238).": ".h($da),[lang(238)]);else
page_header(lang(239),[lang(239)]);if(!$K&&$da!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($da));$K=reset($L);}echo"<form action='' method='post'>\n","<table class='box box-light'>\n","<tr><th>",lang(211),"</th><td>","<input class='input' name='EVENT_NAME' value='",h($K["EVENT_NAME"]),"' data-maxlength='64' autocapitalize='off'>","</td></tr>\n","<tr><th title='datetime'>",lang(240),"</th><td>","<input class='input' name='STARTS' value='",h("$K[EXECUTE_AT]$K[STARTS]"),"'>","</td></tr>\n","<tr><th title='datetime'>",lang(241),"</th><td>","<input class='input' name='ENDS' value='",h($K["ENDS"]),"'>","</td></tr>\n","<tr><th>",lang(242),"</th><td>","<input type='number' name='INTERVAL_VALUE' value='",h($K["INTERVAL_VALUE"]),"' class='input size'> ",html_select("INTERVAL_FIELD",$uf,$K["INTERVAL_FIELD"]),"</td></tr>\n","<tr><th>",lang(149),"</th><td>",html_select("STATUS",$_k,$K["STATUS"]),"</td></tr>\n","<tr><th>",lang(45),"</th><td>","<input class='input' name='EVENT_COMMENT' value='",h($K["EVENT_COMMENT"]),"' data-maxlength='64'>","</td></tr>\n","<tr><th></th><td>",checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(243)),"</td></tr>\n","</table>\n","<p>";textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo"</p>\n","<p>","<input type='submit' class='button default' value='",lang(107),"'>";if($da!="")echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>",confirm(lang(207,$da));echo"</p>\n",input_token(),"</form>\n";}elseif(isset($_GET["procedure"])){$ka=($_GET["name"]?:$_GET["procedure"]);$pj=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])){$Jh=routine($_GET["procedure"],$pj);$gl="$K[name]_adminneo_".uniqid();foreach($K["fields"]as$v=>$l){if($l["field"]=="")unset($K["fields"][$v]);}drop_create("DROP $pj ".routine_id($ka,$Jh),create_routine($pj,$K),"DROP $pj ".routine_id($K["name"],$K),create_routine($pj,["name"=>$gl]+$K),"DROP $pj ".routine_id($gl,$K),substr(ME,0,-1),lang(244),lang(245),lang(246),$ka,$K["name"]);}if($ka!=""){$sl=isset($_GET["function"])?lang(247):lang(248);page_header($sl.": ".h($ka),[$sl]);}else{$sl=isset($_GET["function"])?lang(249):lang(250);page_header($sl,[$sl]);}if(!$_POST){if($ka=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$pj);$K["name"]=$ka;}}$sb=get_vals("SHOW CHARACTER SET");sort($sb);$qj=routine_languages();echo"<form action='' method='post' id='form'>\n","<p>",lang(211),": ","<input class='input' name='name' value='",h($K["name"]),"' data-maxlength='64' autocapitalize='off'>";if($qj)echo
lang(8),": ",html_select("language",$qj,$K["language"]);echo"<input type='submit' class='button default' value='",lang(107),"'>","</p>\n","<div class='scrollable'>\n","<table class='nowrap' id='edit-fields'>\n";edit_fields($K["fields"],$sb,$pj);if(isset($_GET["function"])){echo"<tbody><tr>";if(support("move_col"))echo"<th></th>";echo"<th>",lang(251),"</th>";edit_type("returns",$K["returns"],$sb,[],(DIALECT=="pgsql"?["void","trigger"]:[]));echo"<td></td>","</tr></tbody>\n";}echo"</table>\n",script("initFieldsEditing(gid('edit-fields'));");if(support("move_col"))echo
script("initSortable('#edit-fields tbody');");echo"</div>\n","<p>";textarea("definition",$K["definition"]);echo"</p>\n<p>","<input type='submit' class='button default' value='",lang(107),"'>";if($ka!="")echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>",confirm(lang(207,$ka));echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["sequence"])){$ma=$_GET["sequence"];$K=$_POST;if($_POST){$x=substr(ME,0,-1);$_=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ma),$x,lang(252));elseif($ma=="")query_redirect("CREATE SEQUENCE ".idf_escape($_),$x,lang(253));elseif($ma!=$_)query_redirect("ALTER SEQUENCE ".idf_escape($ma)." RENAME TO ".idf_escape($_),$x,lang(254));else
redirect($x);}if($ma!="")page_header(lang(255).": ".h($ma),[h($ma)]);else
page_header(lang(256),[lang(257)]);if(!$K)$K["name"]=$ma;echo"<form action='' method='post'>\n","<p>","<input class='input' name='name' value='",h($K["name"]),"' autocapitalize='off'>","<input type='submit' class='button default' value='",lang(107),"'>";if($ma!="")echo"<input type='submit' class='button' name='drop' value='".lang(157)."'>".confirm(lang(207,$ma))."\n";echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["type"])){$na=$_GET["type"];$K=$_POST;if($_POST){$x=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($na),$x,lang(258));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$x,lang(259));}if($na!="")page_header(lang(260).": ".h($na),[h($na)]);else
page_header(lang(257),[lang(257)]);if(!$K)$K["as"]="AS ";echo"<form action='' method='post'>\n";if($na!=""){$Ol=Driver::get()->getTypes();$td=type_values($Ol[$na]);if($td)echo"<p><code class='jush-".DIALECT."'>ENUM (".h($td).")</code><p>\n";echo"<p>","<input type='submit' class='button' name='drop' value='".lang(157)."'>".confirm(lang(207,$na)),"</p>\n";}else{echo"<p>",lang(211).": <input class='input' name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(['pgsql'=>"datatype-enum.html",],"?"),"</p>\n<p>";textarea("as",$K["as"]);echo"</p>\n","<p><input type='submit' class='button default' value='".lang(107)."'></p>\n";}echo
input_token(),"</form>\n";}elseif(isset($_GET["check"])){$a=$_GET["check"];$_=$_GET["name"];$K=$_POST;if($K){if(DIALECT=="sqlite")$I=recreate_table($a,$a,[],[],[],0,[],$_,($K["drop"]?"":$K["clause"]));else{$I=($_==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($_)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(261):($_!=""?lang(262):lang(263))),$I);}page_header(($_!=""?lang(264).": ".h($_):lang(170)),["table"=>$a]);if(!$K){$yb=Driver::get()->checkConstraints($a);$K=["name"=>$_,"clause"=>$yb[$_]];}echo"<form action='' method='post'>\n","<p>";if(DIALECT!="sqlite")echo
lang(211).': <input name="name" value="'.h($K["name"]).'" class="input" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(['sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",],"?"),"</p>\n<p>";textarea("clause",$K["clause"]);echo"</p>\n<p>","<input type='submit' class='button default' value='",lang(107),"'>";if($_!="")echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>",confirm(lang(207,$_));echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$_=$_GET["name"];$Hl=trigger_options();$K=(array)trigger($_,$a)+["Trigger"=>$a."_bi"];if($_POST){if(in_array($_POST["Timing"],$Hl["Timing"])&&in_array($_POST["Event"],$Hl["Event"])&&in_array($_POST["Type"],$Hl["Type"])){$uh=" ON ".table($a);$Xc="DROP TRIGGER ".idf_escape($_).(DIALECT=="pgsql"?$uh:"");$lg=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($Xc,$lg,lang(265));else{if($_!="")queries($Xc);queries_redirect($lg,($_!=""?lang(266):lang(267)),queries(create_trigger($uh,$_POST)));if($_!="")queries(create_trigger($uh,$K+["Type"=>reset($Hl["Type"])]));}}$K=$_POST;}if($_!="")page_header(lang(268).": ".h($_),["table"=>$a,h($_)]);else
page_header(lang(269),["table"=>$a,lang(269)]);echo"<form action='' method='post' id='form'>\n","<table class='box box-light'>\n","<tr><th>",lang(270),"</th><td>",html_select("Timing",$Hl["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),"</td></tr>\n","<tr><th>",lang(271),"</th><td>",html_select("Event",$Hl["Event"],$K["Event"],"this.form['Timing'].onchange();");if(in_array("UPDATE OF",$Hl["Event"]))echo" <input name='Of' value='".h($K["Of"])."' class='input hidden'>";echo"</td></tr>\n","<tr><th>",lang(43),"</th><td>",html_select("Type",$Hl["Type"],$K["Type"]),"</td></tr>\n","</table>\n","<p>",lang(211),"<input class='input' name='Trigger' value='",h($K["Trigger"]),"' data-maxlength='64' autocapitalize='off'>","</p>\n",script("gid('form')['Timing'].onchange();"),"<p>";textarea("Statement",$K["Statement"]);echo"</p>\n","<p>","<input type='submit' class='button default' value='",lang(107),"'>";if($_!="")echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>",confirm(lang(207,$_));echo"</p>\n",input_token(),"</form>\n";}elseif(isset($_GET["user"])){$oa=$_GET["user"];$Fi=[""=>["All privileges"=>""]];foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$ic)$Fi[$ic][$K["Privilege"]]=$K["Comment"];}$Fi["Server Admin"]+=$Fi["File access on server"];$Fi["Databases"]["Create routine"]=$Fi["Procedures"]["Create routine"];unset($Fi["Procedures"]["Create routine"]);$Fi["Columns"]=[];foreach(["Select","Insert","Update","References"]as$X)$Fi["Columns"][$X]=$Fi["Tables"][$X];unset($Fi["Server Admin"]["Usage"]);foreach($Fi["Tables"]as$v=>$X)unset($Fi["Databases"][$v]);$ah=[];if($_POST){foreach($_POST["objects"]as$v=>$X)$ah[$X]=(array)$ah[$X]+(array)$_POST["grants"][$v];}$Ce=[];$sh="";if(isset($_GET["host"])&&($I=Connection::get()->query("SHOW GRANTS FOR ".q($oa)."@".q($_GET["host"])))){while($K=$I->fetchRow()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$y)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$y[1],$z,PREG_SET_ORDER)){foreach($z
as$X){if($X[1]!="USAGE")$Ce["$y[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$Ce["$y[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$y))$sh=$y[1];}}if($_POST){$th=(isset($_GET["host"])?q($oa)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $th",ME."privileges=",lang(272));else{$ch=q($_POST["user"])."@".q($_POST["host"]);$hi=$_POST["pass"];if($hi!=''&&!$_POST["hashed"]&&!Connection::get()->isMinVersion("8")){$hi=Connection::get()->getValue("SELECT PASSWORD(".q($hi).")");$k=!$hi;}else$k=false;$pc=false;if(!$k){if($th!=$ch){$pc=queries((Connection::get()->isMinVersion("5")?"CREATE USER":"GRANT USAGE ON *.* TO")." $ch IDENTIFIED BY ".(Connection::get()->isMinVersion("8")?"":"PASSWORD ").q($hi));$k=!$pc;}elseif($hi!=$sh){$ii=q($hi);if(Connection::get()->isMariaDB())$ii="PASSWORD($ii)";queries("SET PASSWORD FOR $ch = $ii");}}if(!$k){$mj=[];foreach($ah
as$mh=>$Ae){if(isset($_GET["grant"]))$Ae=array_filter($Ae);$Ae=array_keys($Ae);if(isset($_GET["grant"]))$mj=array_diff(array_keys(array_filter($ah[$mh],'strlen')),$Ae);elseif($th==$ch){$qh=array_keys((array)$Ce[$mh]);$mj=array_diff($qh,$Ae);$Ae=array_diff($Ae,$qh);unset($Ce[$mh]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$mh,$y)&&(!grant(false,$mj,$y[2],$y[1],$ch)||!grant(true,$Ae,$y[2],$y[1],$ch))){$k=true;break;}}}if(!$k&&isset($_GET["host"])){if($th!=$ch)queries("DROP USER $th");elseif(!isset($_GET["grant"])){foreach($Ce
as$mh=>$mj){if(preg_match('~^(.+)(\(.*\))?$~U',$mh,$y))grant(false,array_keys($mj),$y[2],$y[1],$ch);}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(273):lang(274)),!$k);if($pc)Connection::get()->query("DROP USER $ch");}}$sl=isset($_GET["host"])?lang(27).": ".h("$oa@$_GET[host]"):lang(179);$tl=isset($_GET["host"])?h($oa):lang(179);page_header($sl,["privileges"=>['',lang(69)],$tl]);if($_POST){$K=$_POST;$Ce=$ah;}else{$K=$_GET+["host"=>Connection::get()->getValue("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)")];$K["pass"]=$sh;if($sh!="")$K["hashed"]=true;if($Ce)$Ce[".*"]=[];elseif(DB!="")$Ce[idf_escape(addcslashes(DB,"%_\\")).".*"]=[];else$Ce["*.* "]=[];}echo"<form action='' method='post'>\n","<table class='box box-light'>\n","<tr><th>",lang(25),"</th>","<td><input class='input' name='host' data-maxlength='60' value='",h($K["host"]),"' autocapitalize='off'></td>\n","<tr><th>",lang(27),"</th>","<td><input class='input' name='user' data-maxlength='80' value='",h($K["user"]),"' autocapitalize='off'></td>\n",'<tr><th>',lang(28),"</th>","<td><input class='input' name='pass' id='pass' value='",h($K["pass"]),"' autocomplete='new-password'></td>\n";if(!$K["hashed"])echo
script("typePassword(gid('pass'));");if(!Connection::get()->isMinVersion("8"))echo
checkbox("hashed",1,$K["hashed"],lang(275),"typePassword(this.form['pass'], this.checked);");echo"</table>\n","<div class='scrollable'><table class='checkable'>\n","<thead><tr><th colspan='2'>".lang(69).doc_link(['sql'=>"grant.html#priv_level"])."</th>";$q=0;foreach($Ce
as$mh=>$Ae){echo"<th>";if($mh=="*.*")echo"*.*",input_hidden("objects[$q]","*.*");else
echo"<input class='input' name='objects[$q]' value='".h(trim($mh))."' size='10' autocapitalize='off'>";echo"</th>";$q++;}echo"</tr></thead>\n";foreach([""=>"","Server Admin"=>lang(25),"Databases"=>lang(29),"Tables"=>lang(7),"Columns"=>lang(42),"Procedures"=>lang(276),]as$ic=>$Kc){foreach((array)$Fi[$ic]as$Ei=>$Qb){echo"<tr>";if($Kc)echo"<td>$Kc</td>";echo"<td".(!$Kc?" colspan='2'":"").' lang="en" title="'.h($Qb).'">'.h($Ei)."</td>";$q=0;foreach($Ce
as$mh=>$Ae){$_="'grants[$q][".h(strtoupper($Ei))."]'";$Y=$Ae[strtoupper($Ei)];$Ji=strpos($mh,"@")!==false;$Zg=$mh==".*";$Ga=$Ei=="All privileges";$Be=$Ei=="Grant option";if($mh=="*.*"&&$Ei=="Proxy")echo"<td></td>";elseif($Ji&&$Ei!="Proxy"&&!$Be)echo"<td></td>";elseif($ic=="Server Admin"&&$mh!=(isset($Ce["*.*"])?"*.*":".*")&&!(($Ji||$Zg)&&$Ei=="Proxy"))echo"<td></td>";elseif(isset($_GET["grant"]))echo"<td><select name=$_>"."<option></option>"."<option value='1'".($Y?" selected":"").">".lang(277)."</option>"."<option value='0'".($Y=="0"?" selected":"").">".lang(278)."</option>"."</select></td>";else{echo"<td class='center'><label class='block'>","<input type='checkbox' name=$_ value='1'".($Y?" checked":"").($Ga?" id='grants-$q-all'":(!$Be?" class='grants-$q'":"")).">";if($Ga)echo
script("qsl('input').onclick = function () { if (this.checked) formUncheckAll('.grants-$q'); };");elseif(!$Be)echo
script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$q-all'); };");echo"</label>";}$q++;}echo"</tr>";}}echo"</table></div>\n","<p>","<input type='submit' class='button default' value='",lang(107),"'>\n";if(isset($_GET["host"]))echo"<input type='submit' class='button' name='drop' value='",lang(157),"'>\n",confirm(lang(207,"$oa@$_GET[host]"));echo
input_token(),"</p>\n","</form>\n";}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST){$Pf=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$Pf++;}queries_redirect(ME."processlist=",lang(279,$Pf),$Pf||!$_POST["kill"]);}}page_header(lang(147),[lang(147)]);echo"<form action='' method='post'>\n","<div class='scrollable'>\n","<table class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$q=-1;foreach(process_list()as$q=>$K){if(!$q){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$v=>$X)echo"<th>$v".doc_link(['sql'=>"show-processlist.html#processlist_".strtolower($v),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",]);echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[DIALECT=="sql"?"Id":"pid"],0):"");foreach($K
as$v=>$X)echo"<td>".((DIALECT=="sql"&&$v=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(DIALECT=="pgsql"&&$v=="current_query"&&$X!="<IDLE>")||(DIALECT=="oracle"&&$v=="sql_text"&&$X!="")?"<code class='jush-".DIALECT."'>".truncate_utf8($X,100).'</code> <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.icon("edit").lang(280).'</a>':h($X));echo"\n";}echo"</table>\n","</div>\n","<p>";if(support("kill"))echo($q+1)."/".lang(281,max_connections()),"<p><input type='submit' class='button' value='".lang(282)."'>\n";echo
input_token(),"</p>\n","</form>\n",script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$u=indexes($a);$m=fields($a);$me=column_foreign_keys($a);$oh=$S["Oid"];$nj=[];$d=[];$Aj=[];$Fh=[];$ll=null;foreach($m
as$v=>$l){$_=Admin::get()->getFieldName($l);$Vg=html_entity_decode(strip_tags($_),ENT_QUOTES);if(isset($l["privileges"]["select"])&&$_!=""){$d[$v]=$Vg;if(is_shortable($l))$ll=Admin::get()->processSelectionLength();}if(isset($l["privileges"]["where"])&&$_!="")$Aj[$v]=$Vg;if(isset($l["privileges"]["order"])&&$_!="")$Fh[$v]=$Vg;$nj+=$l["privileges"];}list($M,$De)=Admin::get()->processSelectionColumns($d,$u);$M=array_unique($M);$De=array_unique($De);$zf=count($De)<count($M);$Z=Admin::get()->processSelectionSearch($m,$u);$Eh=Admin::get()->processSelectionOrder($m,$u);$w=Admin::get()->processSelectionLimit();if($_GET["modify"]&&!Admin::get()->isDataEditAllowed())redirect(ME."select=".urlencode($a));if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Sl=>$K){$Na=convert_field($m[key($K)]);$M=[$Na?:idf_escape(key($K))];$Z[]=where_check($Sl,$m);$J=Driver::get()->select($a,$M,$Z,$M);if($J)echo
first($J->fetchRow());}exit;}$F=$Ul=null;foreach($u
as$t){if($t["type"]=="PRIMARY"){$F=array_flip($t["columns"]);$Ul=($M?$F:[]);foreach($Ul
as$v=>$X){if(in_array(idf_escape($v),$M))unset($Ul[$v]);}break;}}if($oh&&!$F){$F=$Ul=[$oh=>0];$u[]=["type"=>"PRIMARY","columns"=>[$oh]];}$P=Admin::get()->getSettings();if($_POST){$Bm=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$yb=[];foreach($_POST["check"]as$tb)$yb[]=where_check($tb,$m);$Bm[]="((".implode(") OR (",$yb)."))";}$Bm=($Bm?"\nWHERE ".implode(" AND ",$Bm):"");if($_POST["export"]){$P->updateParameters(["exportFormat"=>$_POST["format"],"exportOutput"=>$_POST["output"],]);dump_headers($a);Admin::get()->dumpTable($a,"");$te=($M?implode(", ",$M):"*").convert_fields($d,$m,$M)."\nFROM ".table($a);$Ge=($De&&$zf?"\nGROUP BY ".implode(", ",$De):"").($Eh?"\nORDER BY ".implode(", ",$Eh):"");if(!is_array($_POST["check"])||$F)$G="SELECT $te$Bm$Ge";else{$Ql=[];foreach($_POST["check"]as$X)$Ql[]="(SELECT".limit($te,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$m).$Ge,1).")";$G=implode(" UNION ALL ",$Ql);}Admin::get()->dumpData($a,"table",$G);exit;}if($_POST["save"]||$_POST["delete"]){$I=true;$za=0;$Yj=[];if(!$_POST["delete"]){$Jj=array_keys($_POST["fields"]+$_POST["function"]);foreach($Jj
as$_){$X=process_input($m[$_]);if($X!==null&&($_POST["clone"]||$X!==false))$Yj[idf_escape($_)]=($X!==false?$X:idf_escape($_));}}if($_POST["delete"]||$Yj){if($_POST["clone"])$G="INTO ".table($a)." (".implode(", ",array_keys($Yj)).")\nSELECT ".implode(", ",$Yj)."\nFROM ".table($a);if($_POST["all"]||($F&&is_array($_POST["check"]))||$zf){$I=($_POST["delete"]?Driver::get()->delete($a,$Bm):($_POST["clone"]?queries("INSERT $G$Bm".Driver::get()->getInsertReturningSql($a)):Driver::get()->update($a,$Yj,$Bm)));$za=Connection::get()->getAffectedRows();if(is_object($I))$za+=$I->getRowsCount();}else{foreach((array)$_POST["check"]as$X){$ym="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$m);$I=($_POST["delete"]?Driver::get()->delete($a,$ym,1):($_POST["clone"]?queries("INSERT".limit1($a,$G,$ym)):Driver::get()->update($a,$Yj,$ym,1)));if(!$I)break;$za+=Connection::get()->getAffectedRows();}}}$Eg=lang(283,$za);if($_POST["clone"]&&$I&&$za==1){$Vf=last_id($I);if($Vf)$Eg=lang(201," $Vf");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Eg,$I);if(!$_POST["delete"]){$yi=(array)$_POST["fields"];edit_form($a,array_intersect_key($m,$yi),$yi,!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])Admin::get()->addError(lang(284));else{$I=true;$za=0;foreach($_POST["val"]as$Sl=>$K){$Yj=[];foreach($K
as$v=>$X){$v=bracket_escape($v,1);$Yj[idf_escape($v)]=(preg_match('~char|text~',$m[$v]["type"])||$X!=""?Admin::get()->processFieldInput($m[$v],$X):"NULL");}$I=Driver::get()->update($a,$Yj," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Sl,$m),!$zf&&!$F," ");if(!$I)break;$za+=Connection::get()->getAffectedRows();}queries_redirect(remove_from_uri(),lang(283,$za),$I);}}elseif(!is_string($n=get_file("csv_file",true)))Admin::get()->addError(upload_error($n));elseif(!preg_match('~~u',$n))Admin::get()->addError(lang(285));else{$P->updateParameter("exportFormat",$_POST["import_format"]);$Mb=array_keys($m);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$n,$z);$za=count($z[0]);Driver::get()->begin();$N=($_POST["import_format"]=="csv;"?";":($_POST["import_format"]=="tsv"?"\t":","));$L=[];foreach($z[0]as$v=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$N]*)$N~",$X.$N,$ug);if(!$v&&!array_diff($ug[1],$Mb)){$Mb=$ug[1];$za--;}else{$Yj=[];foreach($ug[1]as$q=>$Fb)$Yj[idf_escape($Mb[$q])]=($Fb==""&&$m[$Mb[$q]]["null"]?"NULL":q(preg_match('~^".*"$~s',$Fb)?str_replace('""','"',substr($Fb,1,-1)):$Fb));$L[]=$Yj;}}$I=(!$L||Driver::get()->insertUpdate($a,$L,$F));if($I)Driver::get()->commit();queries_redirect(remove_from_uri("page"),lang(286,$za),$I);Driver::get()->rollback();}}$Uk=Admin::get()->getTableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(52).": $Uk",[$Uk]);$Yj=null;if(isset($nj["insert"])||!support("table")){$D=[];foreach((array)$_GET["where"]as$X){if(isset($me[$X["col"]])&&count($me[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$D["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$Yj=$D?"&".http_build_query($D):"";}Admin::get()->printTableMenu($S,$Yj);if(!$d&&support("table"))echo"<p class='error'>".lang(287).($m?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();if(DB!=""){echo
input_hidden("db",DB);if(isset($_GET["ns"]))echo
input_hidden("ns",$_GET["ns"]);}echo
input_hidden("select",$a),'<input type="submit" class="button" value="'.h(lang(52)).'">',"</div>\n","<div class='field-sets'>\n";Admin::get()->printSelectionColumns($M,$d);Admin::get()->printSelectionSearch($Z,$Aj,$u);Admin::get()->printSelectionOrder($Eh,$Fh,$u);Admin::get()->printSelectionLimit($w);Admin::get()->printSelectionLength($ll);Admin::get()->printSelectionAction($u);echo"</div>\n</form>\n";$C=isset($_GET["page"])?$_GET["page"]:null;if($C=="last"){$re=Connection::get()->getValue(count_rows($a,$Z,$zf,$De));$C=(int)floor(max(0,$re-1)/$w);}else{$re=false;$C=(int)$C;}$Cj=$M;$Ee=$De;if(!$Cj){$Cj[]="*";$jc=convert_fields($d,$m,$M);if($jc)$Cj[]=substr($jc,2);}foreach($M
as$v=>$X){$l=$m[idf_unescape($X)];if($l&&($Na=convert_field($l)))$Cj[$v]="$Na AS $X";}if(!$zf&&$Ul){foreach($Ul
as$v=>$X){$Cj[]=idf_escape($v);if($Ee)$Ee[]=idf_escape($v);}}$I=Driver::get()->select($a,$Cj,$Z,$Ee,$Eh,$w,$C,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(DIALECT=="mssql"&&$C)$I->seek($w*$C);echo"<form action='' method='post' enctype='multipart/form-data'>\n","<div class='table-footer-parent'>\n";$L=[];while($K=$I->fetchAssoc()){if($C&&DIALECT=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$w!==null&&$De&&$zf&&DIALECT=="sql")$re=Connection::get()->getValue(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(85)."\n";else{$Za=Admin::get()->getBackwardKeys($a,$Uk);echo"<div class='scrollable'>\n","<table id='table' class='nowrap checkable'>\n",script("mixin(gid('table'), {onclick: partialArg(tableClick, false, ".(Admin::get()->isDataEditAllowed()?"true":"false")."), ondblclick: partialArg(tableClick, true), onkeydown: onEditingKeydown});"),"<thead><tr>";if($De||!$M){echo"<th class='actions'><input type='checkbox' id='all-page' class='jsonly'>".script("gid('all-page').onclick = partial(formCheck, /check/);","");if(Admin::get()->isDataEditAllowed())echo" <a href='",h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."' title='",lang(288),"'>",icon_solo("edit-all"),"</a>";}$Wg=[];$we=[];reset($M);$Si=1;foreach($L[0]as$v=>$X){if(!isset($Ul[$v])){$Ej=key($M);$X=isset($_GET["columns"][$Ej])?$_GET["columns"][$Ej]:null;$l=$m[$M?($X?$X["col"]:current($M)):$v];$_=($l?Admin::get()->getFieldName($l,$Si):(isset($X["fun"])?"*":h($v)));if($_!=""){$Si++;$Wg[$v]=$_;$c=idf_escape($v);$af=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($v);$Kc="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($v))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$ue=apply_sql_function(isset($X["fun"])?$X["fun"]:null,$_);$kk=isset($l["privileges"]["order"])||$ue;if($kk)echo'<a href="',h($af.($Eh[0]==$c||$Eh[0]==$v||(!$Eh&&$zf&&$De[0]==$c)?$Kc:'')),'">',"$ue</a>";else
echo$ue;echo"<span class='column hidden'>";if($kk)echo"<a href='".h($af.$Kc)."' title='".lang(59)."' class='button light'>",icon_solo("arrow-down"),"</a>";if(!isset($X["fun"])&&isset($l["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(56).'" class="button light jsonly">',icon_solo("search"),'</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($v)."');");echo"</span>";}$we[$v]=isset($X["fun"])?$X["fun"]:null;next($M);}}$cg=[];if($_GET["modify"]){foreach($L
as$K){foreach($K
as$v=>$X)$cg[$v]=max($cg[$v],min(40,strlen(utf8_decode($X))));}}if($Za)echo"<th>".lang(16)."</th>";echo"</thead>\n";if(is_ajax())ob_end_clean();foreach(Admin::get()->fillForeignDescriptions($L,$me)as$Ug=>$K){$Rl=unique_array($L[$Ug],$u);if(!$Rl){$Rl=[];foreach($L[$Ug]as$v=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$v))$Rl[$v]=$X;}}$Sl="";foreach($Rl
as$v=>$X){$l=isset($m[$v])?$m[$v]:null;if((DIALECT=="sql"||DIALECT=="pgsql")&&$l&&preg_match('~char|text|enum|set~',$l["type"])&&strlen($X)>64){$v=(strpos($v,'(')?$v:idf_escape($v));$v="MD5(".(DIALECT!='sql'||preg_match("~^utf8~",isset($l["collation"])?$l["collation"]:"")?$v:"CONVERT($v USING ".charset(Connection::get()).")").")";$X=md5($X);}$Sl
.="&".($X!==null?urlencode("where[".bracket_escape($v)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($v));}echo"<tr>";if($De||!$M){echo"<td class='actions'>",checkbox("check[]",substr($Sl,1),in_array(substr($Sl,1),(array)$_POST["check"]));if(!$zf&&Admin::get()->isDataEditAllowed())echo" <a href='",h(ME."edit=".urlencode($a).$Sl),"' class='edit' title='",lang(37),"'>",icon_solo("edit"),"</a>";}foreach($K
as$v=>$X){if(isset($Wg[$v])){$l=isset($m[$v])?$m[$v]:null;$X=$l?Connection::get()->formatValue($X,$l):$X;$x="";if($l&&preg_match('~blob|bytea|raw|file~',$l["type"])&&$X!="")$x=ME.'download='.urlencode($a).'&field='.urlencode($v).$Sl;if(!$x&&$X!==null){foreach((array)$me[$v]as$p){if(count($me[$v])==1||end($p["source"])==$v){$x="";foreach($p["source"]as$q=>$lk)$x
.=where_link($q,$p["target"][$q],$L[$Ug][$lk]);$x=($p["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($p["db"]),ME):ME).'select='.urlencode($p["table"]).$x;if($p["ns"])$x=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($p["ns"]),$x);if(count($p["source"])==1)break;}}}if($v=="COUNT(*)"){$x=ME."select=".urlencode($a);$q=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Rl))$x
.=where_link($q++,$W["col"],$W["val"],$W["op"]);}foreach($Rl
as$If=>$W)$x
.=where_link($q++,$If,$W);}$hh=$X===null;$X=select_value($X,$x,$l,$ll);$xd=bracket_escape($v);$r=h("val[$Sl][$xd]");$Y=isset($_POST["val"][$Sl][$xd])?$_POST["val"][$Sl][$xd]:null;$id=!is_array($K[$v])&&is_utf8($X)&&$L[$Ug][$v]==$K[$v]&&!$we[$v]&&!(isset($l["generated"])?$l["generated"]:false);$il=$l&&preg_match('~text|json|lob~',$l["type"]);$lh=($l&&preg_match(number_type(),$l["type"]))||(!$l&&preg_match('~^ROUND|CHAR_LENGTH|FLOOR|CEIL|UNIX_TIMESTAMP|TIME_TO_SEC|SUM|MIN|MAX|AVG|COUNT\(~',$v));$Cb=$lh&&($hh||is_numeric(strip_tags($X)))?"class='number'":"";echo"<td id='$r' $Cb";if(($_GET["modify"]&&$id)||$Y!==null){$Je=h($Y!==null?$Y:$K[$v]);echo">".($il?"<textarea name='$r' cols='30' rows='".(substr_count($K[$v],"\n")+1)."'>$Je</textarea>":"<input class='input' name='$r' value='$Je' size='$cg[$v]'>");}else{$mg=strpos($X,"<i>…</i>");echo" data-text='".($mg?2:($il?1:0))."'".($id?"":" data-warning='".h(lang(289))."'").">$X";}}}if($Za){echo"<td>";Admin::get()->printBackwardKeys($Za,$L[$Ug]);echo"</td>";}echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n",script("initToggles(gid('table'));"),"</div>\n";}if(!is_ajax()){if($L||$C){$_d=true;if($_GET["page"]!="last"){if($w==""||(count($L)<$w&&($L||!$C)))$re=($C?$C*$w:0)+count($L);elseif(DIALECT!="sql"||!$zf){$re=($zf?false:found_rows($S,$Z));if($re<max(1e4,2*($C+1)*$w))$re=first(slow_query(count_rows($a,$Z,$zf,$De)));else$_d=false;}}$Vh=($w!==null&&($re===false||$re>$w||$C));if($Vh){if(($re===false?count($L)+1:$re-$C*$w)>$w)echo'<p class="links">','<a href="',h(remove_from_uri("page")."&page=".($C+1)),'" class="loadmore">',icon("expand"),lang(290),'</a>',script("qsl('a').onclick = partial(loadNextPage, ".(+$w).", '".lang(291)."…');","");echo"\n";}echo"<div class='table-footer'><div class='field-sets'>\n";if($Vh){$xg=($re===false?$C+(count($L)>=$w?2:1):(int)floor(($re-1)/$w));$Tc="<li>…</li>";echo"<fieldset>";if(DIALECT!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(292)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(292)."', '".($C+1)."')); return false; };"),"<div id='fieldset-pagination' class='fieldset-content'><ul class='pagination'>",pagination(0,$C);if($C>5)echo$Tc;for($q=max(1,$C-4);$q<min($xg,$C+5);$q++)echo
pagination($q,$C);if($xg>0){if($C+5<$xg)echo$Tc;echo($_d&&$re!==false?pagination($xg,$C):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$xg'>".lang(293)."</a>");}echo"</ul></div>";}else{echo"<legend>".lang(292)."</legend>","<div id='fieldset-pagination'><ul class='pagination'>",pagination(0,$C);if($C>1)echo$Tc;if($C)echo
pagination($C,$C);if($xg>$C){echo
pagination($C+1,$C);if($xg>$C+1)echo$Tc;}echo"</ul></div>";}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(294)."</legend><div class='fieldset-content'>";$Sc=($_d?"":"~ ").$re;echo
checkbox("all",1,0,($re!==false?($_d?"":"~ ").lang(183,$re):""),"const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Sc' : checked); selectCount('selected2', this.checked || !checked ? '$Sc' : checked);")."\n","</div></fieldset>\n";if(Admin::get()->isDataEditAllowed())echo"<fieldset",($_GET["modify"]?'':' class="jsonly"'),">","<legend>",lang(288),"</legend>","<div class='fieldset-content'>","<input type='submit' class='button' value='",lang(107),"'",($_GET["modify"]?"":" title='".lang(284)."'"),">","</div>","</fieldset>\n","<fieldset>","<legend>",lang(156)," <span id='selected'></span></legend>","<div class='fieldset-content'>","<input type='submit' class='button' name='edit' value='",lang(37),"'> ","<input type='submit' class='button' name='clone' value='",lang(280),"'> ","<input type='submit' class='button' name='delete' value='",lang(111),"'>",confirm(),"</div>","</fieldset>\n";$ne=Admin::get()->getDumpFormats();foreach((array)$_GET["columns"]as$c){if($c["fun"]){unset($ne['sql']);break;}}if($ne){print_fieldset_start("export",lang(71)." <span id='selected2'></span>","export");echo
html_select("format",$ne,$P->getParameter("exportFormat"));$Rh=Admin::get()->getDumpOutputs();echo($Rh?" ".html_select("output",$Rh,$P->getParameter("exportOutput")):"")," <input type='submit' class='button' name='export' value='".lang(71)."'>\n";print_fieldset_end("export");}echo"</div></div>\n",script("initTableFooter()");}echo"</div>\n";if(Admin::get()->isDataEditAllowed())echo"<p>","<a href='#import'>",icon("import"),lang(70)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"</p>","<p id='import'".($_POST["import"]?"":" class='hidden'").">","<input type='file' name='csv_file'> ",html_select("import_format",["csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"],$P->getParameter("exportFormat"))," <input type='submit' class='button default' name='import' value='".lang(70)."'>","</p>";echo
input_token(),"</form>\n",(!$De&&$M?"":script("tableCheck();"));}else
echo"</div>\n";}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$zk=isset($_GET["status"]);$sl=$zk?lang(149):lang(148);page_header($sl,[$sl]);$km=($zk?show_status():show_variables());if(!$km)echo"<p class='message'>",lang(85),"</p>\n";else{echo"<div class='scrollable'><table>\n";foreach($km
as$K){echo"<tr>";$v=array_shift($K);echo"<th><code class='jush-".DIALECT.($zk?"status":"set")."'>".h($v)."</code></th>";foreach($K
as$X)echo"<td>",nl2br(h($X)),"</td>";echo"</tr>\n";}echo"</table></div>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Ik=["Data_length"=>0,"Index_length"=>0,"Data_free"=>0];$g=[];foreach(table_status()as$_=>$S){$g["Comment-$_"]=h($S["Comment"]);if(!is_view($S)){foreach(["Engine","Collation"]as$v)$g["$v-$_"]=h($S[$v]);foreach($Ik+["Auto_increment"=>0,"Rows"=>0]as$v=>$X){if($S[$v]!=""){$X=format_number($S[$v]);if($X>=0)$g["$v-$_"]=($v=="Rows"&&$X&&$S["Engine"]==(DIALECT=="pgsql"?"table":"InnoDB")?"~ $X":$X);if(isset($Ik[$v]))$Ik[$v]+=($S["Engine"]!="InnoDB"||$v!="Data_free"?$S[$v]:0);}elseif(array_key_exists($v,$S))$g["$v-$_"]="?";}}}foreach($Ik
as$v=>$X)$g["sum-$v"]=format_number($X);echo
json_encode($g,JSON_UNESCAPED_UNICODE);}elseif($_GET["script"]=="kill")Connection::get()->query("KILL ".number($_POST["kill"]));else{$g=[];foreach(count_tables(Admin::get()->getDatabases())as$i=>$X){$g["tables-$i"]=$X;$g["size-$i"]=db_size($i);}echo
json_encode($g,JSON_UNESCAPED_UNICODE);}exit;}else{$bl=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($bl&&!$_POST["search"]){$I=true;$Eg="";if(DIALECT=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$Eg=lang(295);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Eg=lang(296);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Eg=lang(297);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$Eg=lang(298);}elseif(DIALECT=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$Eg
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(DIALECT!="sql"){$I=(DIALECT=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Eg=lang(299);}elseif(!$_POST["tables"])$Eg=lang(75);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('AdminNeo\idf_escape',$_POST["tables"])))){while($K=$I->fetchAssoc())$Eg
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Eg,$I);}if($_GET["ns"]=="")page_header(lang(29).": ".h(DB),true);else
page_header(lang(77).": ".h($_GET["ns"]),true);Admin::get()->printDatabaseMenu();if($_GET["ns"]===""){echo"<h2 id='schemas'>".lang(300)."</h2>\n";$yj=Admin::get()->getSchemas();if(!$yj)echo"<p class='message'>".lang(301)."\n";else{echo"<div class='scrollable'>\n","<table class='nowrap'>\n",'<thead><tr class="wrap"><th>',lang(77),"</th></tr></thead>";foreach($yj
as$_)echo"<tr><th><a href='",h(ME),"ns=".urlencode($_),"' title='",lang(302),"'>".h($_)."</a></th></tr>";echo'</table></div>';}echo'<p class="links"><a href="'.h(ME).'scheme=">'.icon("database-add").lang(73)."</a>\n";}else{echo"<h2 id='tables-views'>".lang(303)."</h2>\n";$al=tables_list();if(!$al)echo"<p class='message'>".lang(75)."\n";else{echo"<form action='' method='post'>\n","<div class='table-footer-parent'>\n";if(support("table")){echo"<div class='field-sets'>\n","<fieldset><legend>".lang(304)." <span id='selected2'></span></legend><div class='fieldset-content'>","<input type='search' class='input' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' class='button' name='search' value='".lang(56)."'>\n";if(Admin::get()->getRegexpOperator())echo"<p><label><input type='checkbox' name='regexp' value='1'".(empty($_POST['regexp'])?'':' checked').'>'.lang(305).'</label>',doc_link(['sql'=>'regexp.html','pgsql'=>'functions-matching.html#FUNCTIONS-POSIX-REGEXP','elastic'=>"regexp-syntax.html"])."</p>\n";echo"</div></fieldset>\n","</div>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=Admin::get()->getRegexpOperator()&&!empty($_POST['regexp'])?Admin::get()->getRegexpOperator():Admin::get()->getLikeOperator();search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td class="actions"><input id="check-all" type="checkbox" class="input jsonly">'.script("gid('check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(7),'<td>'.lang(161).doc_link(['sql'=>'storage-engines.html']),'<td>'.lang(44).doc_link(['sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/']),'<td>'.lang(306).doc_link(['sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286']),'<td>'.lang(307).doc_link(['sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT']),'<td>'.lang(308).doc_link(['sql'=>'show-table-status.html']),'<td>'.lang(46).doc_link(['sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/']),'<td>'.lang(309).doc_link(['sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286']),(support("comment")?'<td>'.lang(45).doc_link(['sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE']):''),"</thead>\n";$T=0;foreach($al
as$_=>$U){$om=($U!==null&&!preg_match('~table|sequence~i',$U));$r=h("Table-".$_);echo'<tr><td class="actions">'.checkbox(($om?"views[]":"tables[]"),$_,in_array($_,$bl,true),"","","",$r);if(!Admin::get()->getSettings()->isSelectionPreferred()&&(support("table")||support("indexes")))$ra="table";else$ra="select";echo"<th><a href='",h(ME),"$ra=",urlencode($_),"' id='$r'>",h($_),"</a></th>";if($om)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($_).'" title="'.lang(34).'">'.(preg_match('~materialized~i',$U)?lang(159):lang(160)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($_).'" title="'.lang(32).'">?</a>';else{foreach(["Engine"=>[],"Collation"=>[],"Data_length"=>["create",lang(35)],"Index_length"=>["indexes",lang(164)],"Data_free"=>["edit",lang(6)],"Auto_increment"=>["auto_increment=1&create",lang(35)],"Rows"=>["select",lang(32)],]as$v=>$x){$r=" id='$v-".h($_)."'";echo($x?"<td align='right'>".(support("table")||$v=="Rows"||(support("indexes")&&$v!="Data_length")?"<a href='".h(ME."$x[0]=").urlencode($_)."'$r title='$x[1]'>?</a>":"<span$r>?</span>"):"<td id='$v-".h($_)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($_)."'>":""),"\n";}echo"<tfoot><tr>","<td><th>".lang(281,count($al)),"<td>".h(DIALECT=="sql"?Connection::get()->getValue("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(["Data_length","Index_length","Data_free"]as$v)echo"<td align='right' id='sum-$v'>";echo"<td></td><td></td>";if(support("comment"))echo"<td></td>";echo"</tr></tfoot>\n","</table>\n","</div>\n";if(Admin::get()->isDataEditAllowed()){echo"<div class='table-footer'><div class='field-sets'>\n";$hm="<input type='submit' class='button' value='".lang(310)."'> ".help_script("VACUUM");$Ah="<input type='submit' class='button' name='optimize' value='".lang(311)."'> ".help_script(DIALECT=="sql"?"OPTIMIZE TABLE":"VACUUM OPTIMIZE");echo"<fieldset><legend>".lang(156)." <span id='selected'></span></legend><div class='fieldset-content'>".(DIALECT=="sqlite"?$hm."<input type='submit' class='button' name='check' value='".lang(312)."'> ".help_script("PRAGMA integrity_check"):(DIALECT=="pgsql"?$hm.$Ah:(DIALECT=="sql"?"<input type='submit' class='button' value='".lang(313)."'> ".help_script("ANALYZE TABLE").$Ah."<input type='submit' class='button' name='check' value='".lang(312)."'> ".help_script("CHECK TABLE")."<input type='submit' class='button' name='repair' value='".lang(314)."'> ".help_script("REPAIR TABLE"):"")))."<input type='submit' class='button' name='truncate' value='".lang(315)."'> ".help_script(DIALECT=="sqlite"?"DELETE":("TRUNCATE".(DIALECT=="pgsql"?"":" TABLE"))).confirm()."<input type='submit' class='button' name='drop' value='".lang(157)."'>".help_script("DROP TABLE").confirm()."\n";$h=(support("scheme")?Admin::get()->getSchemas():Admin::get()->getDatabases());if(count($h)!=1&&DIALECT!="sqlite"){$i=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(316).": ",($h?html_select("target",$h,$i):'<input class="input" name="target" value="'.h($i).'" autocapitalize="off">')," <input type='submit' class='button' name='move' value='".lang(317)."'>",(support("copy")?" <input type='submit' class='button' name='copy' value='".lang(318)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(319)):""),"\n";}echo
input_hidden("all"),script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n",script("initTableFooter()");}echo"</div>\n","</form>\n",script("tableCheck();");}echo'<p class="links"><a href="',h(ME),'create=">',icon("table-add"),lang(74),"</a>\n";if(support("view"))echo'<a href="',h(ME),'view=">',icon("view-add"),lang(234),"</a>\n";if(support("routine")){echo"<h2 id='routines'>".lang(175)."</h2>\n";$rj=routines();if($rj){$Tb=$rj[0]["ROUTINE_COMMENT"]!==null;echo"<table>\n",'<thead><tr>','<th>',lang(211),'</th><td>',lang(43),'</td><td>',lang(251),"</td>";if($Tb)echo"<td>",lang(45),"</td>";echo"<td></td>","</tr></thead>\n";foreach($rj
as$K){$_=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="',h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$_),'">',h($K["ROUTINE_NAME"]),'</a></th>','<td>',h($K["ROUTINE_TYPE"]),'</td>','<td>',h($K["DTD_IDENTIFIER"]),'</td>';if($Tb)echo'<td>',truncate_utf8(preg_replace('~\s{2,}~'," ",trim($K["ROUTINE_COMMENT"])),50),'</td>';echo'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$_).'">'.lang(167)."</a></td>";}echo"</table>\n";}echo'<p class="links">';if(support("procedure"))echo'<a href="',h(ME),'procedure=">',icon("function-add"),lang(250),"</a>";echo'<a href="',h(ME),'function=">',icon("function-add"),lang(249),"</a>\n","</p>\n";}if(support("sequence")){echo"<h2 id='sequences'>".lang(320)."</h2>\n";$Mj=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($Mj){echo"<table>\n","<thead><tr><th>",lang(211),"</th><td></td></tr></thead>\n";foreach($Mj
as$X)echo"<tr>","<th>",h($X),"</th>","<td><a href='",h(ME),"sequence=",urlencode($X),"'>",lang(167),"</a></td>\n";echo"</table>\n";}echo"<p class='links'><a href='",h(ME),"sequence='>",icon("add"),lang(256),"</a></p>\n";}if(support("type")){echo"<h2 id='user-types'>".lang(113)."</h2>\n";$fm=types();if($fm){echo"<table>\n","<thead><tr><th>",lang(211),"</th><td></td></tr></thead>\n";foreach($fm
as$X)echo"<tr>","<th>",h($X),"</th>","<td><a href='",h(ME),"type=",urlencode($X),"'>",lang(167),"</a></td>\n";echo"</table>\n";}echo"<p class='links'><a href='",h(ME),"type='>",icon("add"),lang(257),"</a></p>\n";}if(support("event")){echo"<h2 id='events'>".lang(176)."</h2>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(211)."<td>".lang(321)."<td>".lang(240)."<td>".lang(241)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(322)."<td>".$K["Execute at"]:lang(242)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(167).'</a>';echo"</table>\n";$yd=Connection::get()->getValue("SELECT @@event_scheduler");if($yd&&$yd!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($yd)."\n";}echo'<p class="links"><a href="',h(ME),'event=">',icon("event-add"),lang(239),"</a></p>\n";}if($al)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}page_footer();