<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * unilabel module.
 *
 * @package     mod_unilabel
 * @author      Andreas Grabs <info@grabs-edv.de>
 * @copyright   2018 onwards Grabs EDV {@link https://www.grabs-edv.de}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace mod_unilabel;

/**
 * Placeholder class if an active type is currently not installed or otherwise not available.
 * @package     mod_unilabel
 * @author      Andreas Grabs <info@grabs-edv.de>
 * @copyright   2018 onwards Grabs EDV {@link https://www.grabs-edv.de}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class unknown_type extends \mod_unilabel\content_type {
    /**
     * Dummy method to add form elements.
     *
     * @param  \mod_unilabel\edit_content_form $form
     * @param  \context                        $context
     * @return void
     */
    public function add_form_fragment(edit_content_form $form, \context $context) {
        return null;
    }

    /**
     * Get the an information to the user hwo to edit this type after creation.
     *
     * @return string
     */
    public function get_edit_info(): string {
        return '';
    }

    /**
     * Dummy method to get default data.
     *
     * @param  array     $data
     * @param  \stdClass $unilabel
     * @return array
     */
    public function get_form_default($data, $unilabel) {
        return $data;
    }

    /**
     * Get the namespace of this type.
     *
     * @return string
     */
    public function get_namespace() {
        return __NAMESPACE__;
    }

    /**
     * Get the localised name of this content type.
     *
     * @return string
     */
    public function get_name() {
        return get_string('unknowntype', 'mod_unilabel');
    }

    /**
     * Get the internal name of this content type.
     *
     * @return string
     */
    public function get_plugintype() {
        return 'unknowntype';
    }

    /**
     * Get the content for this content type.
     *
     * @param  \stdClass             $unilabel
     * @param  \stdClass             $cm
     * @param  \plugin_renderer_base $renderer
     * @return string
     */
    public function get_content($unilabel, $cm, \plugin_renderer_base $renderer) {
        return get_string('unknowntype', 'mod_unilabel');
    }

    /**
     * Dummy method to delete the content of this content type.
     *
     * @param  int  $unilabelid
     * @return bool
     */
    public function delete_content($unilabelid) {
        return true;
    }

    /**
     * Dummy method to save the content of this content type.
     *
     * @param  \stdClass $formdata
     * @param  \stdClass $unilabel
     * @return bool
     */
    public function save_content($formdata, $unilabel) {
        return true;
    }

    /**
     * Check that this plugin is activated on config settings.
     *
     * @return bool
     */
    public function is_active() {
        return true;
    }
}
