define("block_exaaichat/lib",["exports","./helper","core/localstorage","jquery"],(function(_exports,_helper,_localstorage,_jquery){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Functions for the chat interface
   *
   * @module     block_exaaichat
   * @copyright  2025 GTN Solutions https://gtn-solutions.com
   * @copyright  based on work by Limekiller https://github.com/Limekiller/moodle-block_openai_chat
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=async function(data){const{blockId:blockId,api_type:api_type,persistConvo:persistConvo,userName:userName,assistantName:assistantName,showlabels:showlabels,allow_access_to_current_page:allow_access_to_current_page}=data,[questionString,errorString]=await(0,_helper.getStrings)([{key:"askaquestion",component:"block_exaaichat"},{key:"erroroccurred",component:"block_exaaichat"}]),$form=(0,_jquery.default)(".block_exaaichat[data-instance-id='".concat(blockId,"']")),$input=$form.find(".exaaichat_input");let historyTimestamp=0;function addToChatLog(type,message,blockId){let messageContainer=document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_log"));messageContainer.classList.remove("hidden");const messageElem=document.createElement("div");messageElem.classList.add("chat_message");for(let className of type.split(" "))messageElem.classList.add(className);let label="";if(showlabels&&("user"==type?label=userName:"assistant"==type&&(label=assistantName)),label){const labelElement=document.createElement("div");labelElement.classList.add("chat_message_label"),labelElement.innerHTML=label,messageElem.append(labelElement)}const messageText=document.createElement("div");messageText.classList.add("chat_message_content"),messageText.innerHTML=message,messageElem.append(messageText),messageContainer.append(messageElem),messageContainer.scrollTop=messageContainer.scrollHeight,messageContainer.closest(".block_exaaichat > div").scrollTop=messageContainer.scrollHeight}function getAllChatsData(){let chatData=localStorage.getItem("block_exaaichat_data");return chatData&&(chatData=JSON.parse(chatData)),chatData||{}}function getBlockChatData(){return getAllChatsData()[blockId]||{}}function setBlockChatData(data){let chatData=getAllChatsData();chatData[blockId]&&(data={...chatData[blockId],...data}),chatData[blockId]=data,function(data){localStorage.setItem("block_exaaichat_data",JSON.stringify(data))}(chatData)}function addHistory(messages){let history=getBlockChatData().history||[];history=[...history,...messages],historyTimestamp=Date.now(),setBlockChatData({history:history,historyTimestamp:historyTimestamp})}function clearHistory(){$form.find(".exaaichat_log").html("").addClass("hidden")}function getPageContent(){const mainRegion=document.querySelector('[role="main"]');if(!mainRegion)return"";const clone=mainRegion.cloneNode(!0);return clone.querySelectorAll(".block_exaaichat, #ai-features").forEach((el=>el.remove())),clone.innerText||clone.textContent}const createCompletion=(message,blockId,api_type)=>{let threadId=null;if("assistant"===api_type||"responses"===api_type){threadId=getBlockChatData().threadId||null}let history=[];"assistant"==api_type||"responses"===api_type||(history=getBlockChatData().history||[]);let providerId=$form.find('select[name="ai_provider"]').val();document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_control_bar")).classList.add("disabled"),document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_input")).classList.remove("error"),document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_input")).placeholder=questionString,document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_input")).blur(),addToChatLog("assistant loading","...",blockId),fetch("".concat(M.cfg.wwwroot,"/blocks/exaaichat/api/completion.php?sesskey=").concat(M.cfg.sesskey),{method:"POST",body:JSON.stringify({message:message,history:history,blockId:blockId,providerId:providerId,threadId:threadId,pageContent:allow_access_to_current_page?getPageContent():null})}).then((async response=>{let messageContainer=document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_log"));if(messageContainer.removeChild(messageContainer.lastElementChild),$form.find(".exaaichat_control_bar").removeClass("disabled"),response.ok)return response.json();{const errorMessage=(0,_jquery.default)(await response.text()).find(".errormessage").text();throw Error(errorMessage||response.statusText)}})).then((data=>{if(data.error)throw new Error(data.error);addToChatLog("assistant",data.message,blockId),data.thread_id&&setBlockChatData({threadId:data.thread_id}),addHistory([{type:"user",message:message},{type:"assistant",message:data.message}]),$input.focus()})).catch((error=>{!function(error){console.error(error)}(error),addToChatLog("error",error.message,blockId),addHistory([{type:"user",message:message},{type:"error",message:error.message}]),document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_input")).classList.add("error"),document.querySelector(".block_exaaichat[data-instance-id='".concat(blockId,"'] .exaaichat_input")).placeholder=errorString,$input.focus()}))};function reloadChatHistory(){let chatData=getBlockChatData();historyTimestamp=chatData.historyTimestamp||0,clearHistory();let history=chatData.history||[];for(let message of history)addToChatLog(message.type,message.message,blockId)}persistConvo&&reloadChatHistory();window.addEventListener("resize",(event=>{event.stopImmediatePropagation()}),!0),$form.find(".exaaichat_input").on("keydown",(e=>{13===e.which&&""!==e.target.value&&(e.preventDefault(),addToChatLog("user",e.target.value,blockId),createCompletion(e.target.value,blockId,api_type),e.target.value="")})),$form.find(".exaaichat_input_submit_btn").on("click",(()=>{$input.val()?(addToChatLog("user",$input.val(),blockId),createCompletion($input.val(),blockId,api_type),$input.val("")):$input.focus()})),$form.find(".exaaichat_input_refresh_btn").on("click",(()=>{setBlockChatData({history:[],historyTimestamp:Date.now()}),clearHistory(),$input.focus()})),$form.find(".exaaichat_popout_btn, .exaaichat_btn_close").click((()=>{document.querySelector(".drawer.drawer-right")&&(document.querySelector(".drawer.drawer-right").style.zIndex="1041"),$form.toggleClass("expanded")}));const ai_provider=getBlockChatData().ai_provider;ai_provider&&$form.find('select[name="ai_provider"]').val(ai_provider);$form.find('select[name="ai_provider"]').on("change",(function(){setBlockChatData({ai_provider:this.value})})),$form.find(".disabled").removeClass("disabled"),window.addEventListener("storage",(event=>{if("block_exaaichat_data"!==event.key)return;const chatData=getBlockChatData();$form.find('select[name="ai_provider"]').val(chatData.ai_provider),historyTimestamp!=(chatData.historyTimestamp||0)&&reloadChatHistory()}))},_localstorage=_interopRequireDefault(_localstorage),_jquery=_interopRequireDefault(_jquery)}));

//# sourceMappingURL=lib.min.js.map