# exacomp: Exabis Competence Grid

exacomp is a free Moodle plugin designed to facilitate competency-based learning within Moodle courses. This innovative plugin empowers educators to design and deliver tailored learning experiences that cater to individual learner needs. 
By seamlessly integrating competency-based assessments and adaptive learning pathways, exacomp enables a dynamic educational environment where learners can take charge of their learning journey and educators can provide targeted support to help learners excel.


# INSTALLATION

This block is for Moodle 3.11 and 4.0, 4.1, 4.2 versions

1) Download the plugin from Moodle Plug-ins Repository. Please follow the instructions available in the Moodle Plug-ins Repository.
OR
2) Download directly from GitHub:
https://github.com/gtn/exacomp master Branch.

Save the zip file somewhere onto your local computer and extract all the files
Transfer the folder “exacomp” to the blocks-directory of Moodle
Log in as 'administrator' and click on the 'Home' link
You can now adjust settings in the administration panel. 
For more information on setting up the plug-in please refer to the documentation.
https://www.exabis.at/en


If you want to use Exabis Competence Grid Webservices read the "webservice-info.txt" and follow the steps.

You can import grid data from external systems, i.e. KOMET. The datastructure description you can find in data.xsd file.

# USAGE
Competency Grid Creation and Import:
With the EXAcomp plugin, you have the flexibility to create competency grids tailored to your course's requirements. Additionally, you can seamlessly import existing grids from the COMET tool on https://comet.edustandards.org, streamlining the setup process.

Diverse Learning Material Integration: 
EXAcomp offers versatile options for integrating learning materials into your courses. You can easily incorporate external links, files, or Moodle activities and resources, ensuring a rich and engaging learning experience for your students.

Student Engagement and Self-Assessment: 
Students using EXAcomp gain access to their competency grids, where they can view competencies and associated tasks. This feature empowers them to actively engage with course content, work on tasks, and submit their solutions. Moreover, students have the ability to self-assess both the completed tasks and their own competence levels, fostering a sense of ownership and reflection in their learning journey.

Teacher Assessment: 
EXAcomp equips educators with a comprehensive toolset for assessing student tasks and competencies. Teachers can efficiently evaluate students' task submissions and competency development, providing valuable feedback and guidance to support their progress.

This plugin's multifaceted capabilities contribute to a robust competency-based learning environment that benefits both students and educators.

# APPS
For an enhanced user experience, using the Dakora and Diggr applications is recommended. 
These apps feature interfaces designed around the concept of competence grids, making work with grids simple and efficient.
https://dakoraplus.eu/, https://dakoraplus.eu/diggr-plus

# LICENCE

Exabis Competence Grid is a free software: you can redistribute it and/or modify it. It is published under the terms of the GNU General Public License (Free Software Foundation), either version 3 of the License, or any later version. 
This script is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

# HISTORY

First official publishing-date: November 2011
Exabis Competence Grid was developed with kind support of the Federal Ministry of Education in Austria.
The goal of this module is to bring competencies that have been developed and provided from an xml-file into Moodle-courses. For this it is important to outline the process of implementation of national educational standards within all school-types in Austria.
In the past years many expert-groups in Austria were given the task of developing competencies that from a student sight can be expressed in form of “I can”-statements (example: “I can develop Excel formulas to solve a mathematical problem”).
These so-called descriptors document the acquisition of competencies (skills) in a certain subject. By this educational standards can be transported across a whole school-type giving teachers as well as students the opportunity to document their work with these competencies.
In addition all expert-groups developed prototypical examples that work with different competencies thus allowing teachers and students to work with these examples to acquire competencies and find orientation on how examples should be made from a teachers’ perspective to fulfill certain educational standards. 
Within the exabis-competencies-block  teachers may associate Moodle assignments with learning standards. 

# DISCLAIMER

As with any customization, it is recommended that you have a good backup of your Moodle site before attempting to install contributed code.
While those contributing code make every effort to provide the best code that they can, using contributed code nevertheless entails a certain degree of risk as contributed code is not as carefully reviewed and/or tested as the Moodle core code.
Hence, use this block at your own risk.

# AUTHOR
2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>

