/**
 * vis.js
 * https://github.com/almende/vis
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 4.18.1
 * @date    2017-01-29
 *
 * @license
 * Copyright (C) 2011-2016 Almende B.V, http://almende.com
 *
 * Vis.js is dual licensed under both
 *
 * * The Apache 2.0 License
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * and
 *
 * * The MIT License
 *   http://opensource.org/licenses/MIT
 *
 * Vis.js may be distributed under either license.
 */

"use strict";

(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["vis"] = factory();
	else
		root["vis"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var util = __webpack_require__(1);

  // Graph3d
  util.extend(exports, __webpack_require__(89));

  // Timeline & Graph2d
  util.extend(exports, __webpack_require__(112));

  // Network
  util.extend(exports, __webpack_require__(154));

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _getIterator2 = __webpack_require__(2);

  var _getIterator3 = _interopRequireDefault(_getIterator2);

  var _create = __webpack_require__(55);

  var _create2 = _interopRequireDefault(_create);

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  var _stringify = __webpack_require__(82);

  var _stringify2 = _interopRequireDefault(_stringify);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  // utility functions

  // first check if moment.js is already loaded in the browser window, if so,
  // use this instance. Else, load via commonjs.


  var moment = __webpack_require__(84);
  var uuid = __webpack_require__(88);

  /**
   * Test whether given object is a number
   * @param {*} object
   * @return {Boolean} isNumber
   */
  exports.isNumber = function (object) {
    return object instanceof Number || typeof object == 'number';
  };

  /**
   * Censors object elements containing dom elements
   * @param {*} object
   * @return {Object} object without elements
   */
  exports.elementsCensor = function (object) {
    if (!object) return;
    var replacer = function replacer(key, value) {
      if (value instanceof Element) {
        return "DOM Element";
      } else {
        return value;
      }
    };
    return JSON.parse((0, _stringify2['default'])(object, replacer));
  };

  /**
   * Remove everything in the DOM object
   * @param DOMobject
   */
  exports.recursiveDOMDelete = function (DOMobject) {
    if (DOMobject) {
      while (DOMobject.hasChildNodes() === true) {
        exports.recursiveDOMDelete(DOMobject.firstChild);
        DOMobject.removeChild(DOMobject.firstChild);
      }
    }
  };

  /**
   * this function gives you a range between 0 and 1 based on the min and max values in the set, the total sum of all values and the current value.
   *
   * @param min
   * @param max
   * @param total
   * @param value
   * @returns {number}
   */
  exports.giveRange = function (min, max, total, value) {
    if (max == min) {
      return 0.5;
    } else {
      var scale = 1 / (max - min);
      return Math.max(0, (value - min) * scale);
    }
  };

  /**
   * Test whether given object is a string
   * @param {*} object
   * @return {Boolean} isString
   */
  exports.isString = function (object) {
    return object instanceof String || typeof object == 'string';
  };

  /**
   * Test whether given object is a Date, or a String containing a Date
   * @param {Date | String} object
   * @return {Boolean} isDate
   */
  exports.isDate = function (object) {
    if (object instanceof Date) {
      return true;
    } else if (exports.isString(object)) {
      // test whether this string contains a date
      var match = ASPDateRegex.exec(object);
      if (match) {
        return true;
      } else if (!isNaN(Date.parse(object))) {
        return true;
      }
    }

    return false;
  };

  /**
   * Create a semi UUID
   * source: http://stackoverflow.com/a/105074/1262753
   * @return {String} uuid
   */
  exports.randomUUID = function () {
    return uuid.v4();
  };

  /**
   * assign all keys of an object that are not nested objects to a certain value (used for color objects).
   * @param obj
   * @param value
   */
  exports.assignAllKeys = function (obj, value) {
    for (var prop in obj) {
      if (obj.hasOwnProperty(prop)) {
        if ((0, _typeof3['default'])(obj[prop]) !== 'object') {
          obj[prop] = value;
        }
      }
    }
  };

  /**
   * Fill an object with a possibly partially defined other object. Only copies values if the a object has an object requiring values.
   * That means an object is not created on a property if only the b object has it.
   * @param obj
   * @param value
   */
  exports.fillIfDefined = function (a, b) {
    var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    for (var prop in a) {
      if (b[prop] !== undefined) {
        if ((0, _typeof3['default'])(b[prop]) !== 'object') {
          if ((b[prop] === undefined || b[prop] === null) && a[prop] !== undefined && allowDeletion === true) {
            delete a[prop];
          } else {
            a[prop] = b[prop];
          }
        } else {
          if ((0, _typeof3['default'])(a[prop]) === 'object') {
            exports.fillIfDefined(a[prop], b[prop], allowDeletion);
          }
        }
      }
    }
  };

  /**
   * Extend object a with the properties of object b or a series of objects
   * Only properties with defined values are copied
   * @param {Object} a
   * @param {... Object} b
   * @return {Object} a
   */
  exports.protoExtend = function (a, b) {
    for (var i = 1; i < arguments.length; i++) {
      var other = arguments[i];
      for (var prop in other) {
        a[prop] = other[prop];
      }
    }
    return a;
  };

  /**
   * Extend object a with the properties of object b or a series of objects
   * Only properties with defined values are copied
   * @param {Object} a
   * @param {... Object} b
   * @return {Object} a
   */
  exports.extend = function (a, b) {
    for (var i = 1; i < arguments.length; i++) {
      var other = arguments[i];
      for (var prop in other) {
        if (other.hasOwnProperty(prop)) {
          a[prop] = other[prop];
        }
      }
    }
    return a;
  };

  /**
   * Extend object a with selected properties of object b or a series of objects
   * Only properties with defined values are copied
   * @param {Array.<String>} props
   * @param {Object} a
   * @param {Object} b
   * @return {Object} a
   */
  exports.selectiveExtend = function (props, a, b) {
    if (!Array.isArray(props)) {
      throw new Error('Array with property names expected as first argument');
    }

    for (var i = 2; i < arguments.length; i++) {
      var other = arguments[i];

      for (var p = 0; p < props.length; p++) {
        var prop = props[p];
        if (other.hasOwnProperty(prop)) {
          a[prop] = other[prop];
        }
      }
    }
    return a;
  };

  /**
   * Extend object a with selected properties of object b or a series of objects
   * Only properties with defined values are copied
   * @param {Array.<String>} props
   * @param {Object} a
   * @param {Object} b
   * @return {Object} a
   */
  exports.selectiveDeepExtend = function (props, a, b) {
    var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

    // TODO: add support for Arrays to deepExtend
    if (Array.isArray(b)) {
      throw new TypeError('Arrays are not supported by deepExtend');
    }
    for (var i = 2; i < arguments.length; i++) {
      var other = arguments[i];
      for (var p = 0; p < props.length; p++) {
        var prop = props[p];
        if (other.hasOwnProperty(prop)) {
          if (b[prop] && b[prop].constructor === Object) {
            if (a[prop] === undefined) {
              a[prop] = {};
            }
            if (a[prop].constructor === Object) {
              exports.deepExtend(a[prop], b[prop], false, allowDeletion);
            } else {
              if (b[prop] === null && a[prop] !== undefined && allowDeletion === true) {
                delete a[prop];
              } else {
                a[prop] = b[prop];
              }
            }
          } else if (Array.isArray(b[prop])) {
            throw new TypeError('Arrays are not supported by deepExtend');
          } else {
            if (b[prop] === null && a[prop] !== undefined && allowDeletion === true) {
              delete a[prop];
            } else {
              a[prop] = b[prop];
            }
          }
        }
      }
    }
    return a;
  };

  /**
   * Extend object a with selected properties of object b or a series of objects
   * Only properties with defined values are copied
   * @param {Array.<String>} props
   * @param {Object} a
   * @param {Object} b
   * @return {Object} a
   */
  exports.selectiveNotDeepExtend = function (props, a, b) {
    var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

    // TODO: add support for Arrays to deepExtend
    if (Array.isArray(b)) {
      throw new TypeError('Arrays are not supported by deepExtend');
    }
    for (var prop in b) {
      if (b.hasOwnProperty(prop)) {
        if (props.indexOf(prop) == -1) {
          if (b[prop] && b[prop].constructor === Object) {
            if (a[prop] === undefined) {
              a[prop] = {};
            }
            if (a[prop].constructor === Object) {
              exports.deepExtend(a[prop], b[prop]);
            } else {
              if (b[prop] === null && a[prop] !== undefined && allowDeletion === true) {
                delete a[prop];
              } else {
                a[prop] = b[prop];
              }
            }
          } else if (Array.isArray(b[prop])) {
            a[prop] = [];
            for (var i = 0; i < b[prop].length; i++) {
              a[prop].push(b[prop][i]);
            }
          } else {
            if (b[prop] === null && a[prop] !== undefined && allowDeletion === true) {
              delete a[prop];
            } else {
              a[prop] = b[prop];
            }
          }
        }
      }
    }
    return a;
  };

  /**
   * Deep extend an object a with the properties of object b
   * @param {Object} a
   * @param {Object} b
   * @param [Boolean] protoExtend --> optional parameter. If true, the prototype values will also be extended.
   *                                  (ie. the options objects that inherit from others will also get the inherited options)
   * @param [Boolean] global      --> optional parameter. If true, the values of fields that are null will not deleted
   * @returns {Object}
   */
  exports.deepExtend = function (a, b, protoExtend, allowDeletion) {
    for (var prop in b) {
      if (b.hasOwnProperty(prop) || protoExtend === true) {
        if (b[prop] && b[prop].constructor === Object) {
          if (a[prop] === undefined) {
            a[prop] = {};
          }
          if (a[prop].constructor === Object) {
            exports.deepExtend(a[prop], b[prop], protoExtend);
          } else {
            if (b[prop] === null && a[prop] !== undefined && allowDeletion === true) {
              delete a[prop];
            } else {
              a[prop] = b[prop];
            }
          }
        } else if (Array.isArray(b[prop])) {
          a[prop] = [];
          for (var i = 0; i < b[prop].length; i++) {
            a[prop].push(b[prop][i]);
          }
        } else {
          if (b[prop] === null && a[prop] !== undefined && allowDeletion === true) {
            delete a[prop];
          } else {
            a[prop] = b[prop];
          }
        }
      }
    }
    return a;
  };

  /**
   * Test whether all elements in two arrays are equal.
   * @param {Array} a
   * @param {Array} b
   * @return {boolean} Returns true if both arrays have the same length and same
   *                   elements.
   */
  exports.equalArray = function (a, b) {
    if (a.length != b.length) return false;

    for (var i = 0, len = a.length; i < len; i++) {
      if (a[i] != b[i]) return false;
    }

    return true;
  };

  /**
   * Convert an object to another type
   * @param {Boolean | Number | String | Date | Moment | Null | undefined} object
   * @param {String | undefined} type   Name of the type. Available types:
   *                                    'Boolean', 'Number', 'String',
   *                                    'Date', 'Moment', ISODate', 'ASPDate'.
   * @return {*} object
   * @throws Error
   */
  exports.convert = function (object, type) {
    var match;

    if (object === undefined) {
      return undefined;
    }
    if (object === null) {
      return null;
    }

    if (!type) {
      return object;
    }
    if (!(typeof type === 'string') && !(type instanceof String)) {
      throw new Error('Type must be a string');
    }

    //noinspection FallthroughInSwitchStatementJS
    switch (type) {
      case 'boolean':
      case 'Boolean':
        return Boolean(object);

      case 'number':
      case 'Number':
        if (exports.isString(object) && !isNaN(Date.parse(object))) {
          return moment(object).valueOf();
        } else {
          return Number(object.valueOf());
        }
      case 'string':
      case 'String':
        return String(object);

      case 'Date':
        if (exports.isNumber(object)) {
          return new Date(object);
        }
        if (object instanceof Date) {
          return new Date(object.valueOf());
        } else if (moment.isMoment(object)) {
          return new Date(object.valueOf());
        }
        if (exports.isString(object)) {
          match = ASPDateRegex.exec(object);
          if (match) {
            // object is an ASP date
            return new Date(Number(match[1])); // parse number
          } else {
            return moment(new Date(object)).toDate(); // parse string
          }
        } else {
          throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type Date');
        }

      case 'Moment':
        if (exports.isNumber(object)) {
          return moment(object);
        }
        if (object instanceof Date) {
          return moment(object.valueOf());
        } else if (moment.isMoment(object)) {
          return moment(object);
        }
        if (exports.isString(object)) {
          match = ASPDateRegex.exec(object);
          if (match) {
            // object is an ASP date
            return moment(Number(match[1])); // parse number
          } else {
            return moment(object); // parse string
          }
        } else {
          throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type Date');
        }

      case 'ISODate':
        if (exports.isNumber(object)) {
          return new Date(object);
        } else if (object instanceof Date) {
          return object.toISOString();
        } else if (moment.isMoment(object)) {
          return object.toDate().toISOString();
        } else if (exports.isString(object)) {
          match = ASPDateRegex.exec(object);
          if (match) {
            // object is an ASP date
            return new Date(Number(match[1])).toISOString(); // parse number
          } else {
            return moment(object).format(); // ISO 8601
          }
        } else {
          throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type ISODate');
        }

      case 'ASPDate':
        if (exports.isNumber(object)) {
          return '/Date(' + object + ')/';
        } else if (object instanceof Date) {
          return '/Date(' + object.valueOf() + ')/';
        } else if (exports.isString(object)) {
          match = ASPDateRegex.exec(object);
          var value;
          if (match) {
            // object is an ASP date
            value = new Date(Number(match[1])).valueOf(); // parse number
          } else {
            value = new Date(object).valueOf(); // parse string
          }
          return '/Date(' + value + ')/';
        } else {
          throw new Error('Cannot convert object of type ' + exports.getType(object) + ' to type ASPDate');
        }

      default:
        throw new Error('Unknown type "' + type + '"');
    }
  };

  // parse ASP.Net Date pattern,
  // for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
  // code from http://momentjs.com/
  var ASPDateRegex = /^\/?Date\((\-?\d+)/i;

  /**
   * Get the type of an object, for example exports.getType([]) returns 'Array'
   * @param {*} object
   * @return {String} type
   */
  exports.getType = function (object) {
    var type = typeof object === 'undefined' ? 'undefined' : (0, _typeof3['default'])(object);

    if (type == 'object') {
      if (object === null) {
        return 'null';
      }
      if (object instanceof Boolean) {
        return 'Boolean';
      }
      if (object instanceof Number) {
        return 'Number';
      }
      if (object instanceof String) {
        return 'String';
      }
      if (Array.isArray(object)) {
        return 'Array';
      }
      if (object instanceof Date) {
        return 'Date';
      }
      return 'Object';
    } else if (type == 'number') {
      return 'Number';
    } else if (type == 'boolean') {
      return 'Boolean';
    } else if (type == 'string') {
      return 'String';
    } else if (type === undefined) {
      return 'undefined';
    }

    return type;
  };

  /**
   * Used to extend an array and copy it. This is used to propagate paths recursively.
   *
   * @param arr
   * @param newValue
   * @returns {Array}
   */
  exports.copyAndExtendArray = function (arr, newValue) {
    var newArr = [];
    for (var i = 0; i < arr.length; i++) {
      newArr.push(arr[i]);
    }
    newArr.push(newValue);
    return newArr;
  };

  /**
   * Used to extend an array and copy it. This is used to propagate paths recursively.
   *
   * @param arr
   * @param newValue
   * @returns {Array}
   */
  exports.copyArray = function (arr) {
    var newArr = [];
    for (var i = 0; i < arr.length; i++) {
      newArr.push(arr[i]);
    }
    return newArr;
  };

  /**
   * Retrieve the absolute left value of a DOM element
   * @param {Element} elem        A dom element, for example a div
   * @return {number} left        The absolute left position of this element
   *                              in the browser page.
   */
  exports.getAbsoluteLeft = function (elem) {
    return elem.getBoundingClientRect().left;
  };

  exports.getAbsoluteRight = function (elem) {
    return elem.getBoundingClientRect().right;
  };

  /**
   * Retrieve the absolute top value of a DOM element
   * @param {Element} elem        A dom element, for example a div
   * @return {number} top        The absolute top position of this element
   *                              in the browser page.
   */
  exports.getAbsoluteTop = function (elem) {
    return elem.getBoundingClientRect().top;
  };

  /**
   * add a className to the given elements style
   * @param {Element} elem
   * @param {String} className
   */
  exports.addClassName = function (elem, className) {
    var classes = elem.className.split(' ');
    if (classes.indexOf(className) == -1) {
      classes.push(className); // add the class to the array
      elem.className = classes.join(' ');
    }
  };

  /**
   * add a className to the given elements style
   * @param {Element} elem
   * @param {String} className
   */
  exports.removeClassName = function (elem, className) {
    var classes = elem.className.split(' ');
    var index = classes.indexOf(className);
    if (index != -1) {
      classes.splice(index, 1); // remove the class from the array
      elem.className = classes.join(' ');
    }
  };

  /**
   * For each method for both arrays and objects.
   * In case of an array, the built-in Array.forEach() is applied.
   * In case of an Object, the method loops over all properties of the object.
   * @param {Object | Array} object   An Object or Array
   * @param {function} callback       Callback method, called for each item in
   *                                  the object or array with three parameters:
   *                                  callback(value, index, object)
   */
  exports.forEach = function (object, callback) {
    var i, len;
    if (Array.isArray(object)) {
      // array
      for (i = 0, len = object.length; i < len; i++) {
        callback(object[i], i, object);
      }
    } else {
      // object
      for (i in object) {
        if (object.hasOwnProperty(i)) {
          callback(object[i], i, object);
        }
      }
    }
  };

  /**
   * Convert an object into an array: all objects properties are put into the
   * array. The resulting array is unordered.
   * @param {Object} object
   * @param {Array} array
   */
  exports.toArray = function (object) {
    var array = [];

    for (var prop in object) {
      if (object.hasOwnProperty(prop)) array.push(object[prop]);
    }

    return array;
  };

  /**
   * Update a property in an object
   * @param {Object} object
   * @param {String} key
   * @param {*} value
   * @return {Boolean} changed
   */
  exports.updateProperty = function (object, key, value) {
    if (object[key] !== value) {
      object[key] = value;
      return true;
    } else {
      return false;
    }
  };

  /**
   * Throttle the given function to be only executed once per animation frame
   * @param {function} fn
   * @returns {function} Returns the throttled function
   */
  exports.throttle = function (fn) {
    var scheduled = false;

    return function throttled() {
      if (!scheduled) {
        scheduled = true;
        requestAnimationFrame(function () {
          scheduled = false;
          fn();
        });
      }
    };
  };

  /**
   * Add and event listener. Works for all browsers
   * @param {Element}     element    An html element
   * @param {string}      action     The action, for example "click",
   *                                 without the prefix "on"
   * @param {function}    listener   The callback function to be executed
   * @param {boolean}     [useCapture]
   */
  exports.addEventListener = function (element, action, listener, useCapture) {
    if (element.addEventListener) {
      if (useCapture === undefined) useCapture = false;

      if (action === "mousewheel" && navigator.userAgent.indexOf("Firefox") >= 0) {
        action = "DOMMouseScroll"; // For Firefox
      }

      element.addEventListener(action, listener, useCapture);
    } else {
      element.attachEvent("on" + action, listener); // IE browsers
    }
  };

  /**
   * Remove an event listener from an element
   * @param {Element}     element         An html dom element
   * @param {string}      action          The name of the event, for example "mousedown"
   * @param {function}    listener        The listener function
   * @param {boolean}     [useCapture]
   */
  exports.removeEventListener = function (element, action, listener, useCapture) {
    if (element.removeEventListener) {
      // non-IE browsers
      if (useCapture === undefined) useCapture = false;

      if (action === "mousewheel" && navigator.userAgent.indexOf("Firefox") >= 0) {
        action = "DOMMouseScroll"; // For Firefox
      }

      element.removeEventListener(action, listener, useCapture);
    } else {
      // IE browsers
      element.detachEvent("on" + action, listener);
    }
  };

  /**
   * Cancels the event if it is cancelable, without stopping further propagation of the event.
   */
  exports.preventDefault = function (event) {
    if (!event) event = window.event;

    if (event.preventDefault) {
      event.preventDefault(); // non-IE browsers
    } else {
      event.returnValue = false; // IE browsers
    }
  };

  /**
   * Get HTML element which is the target of the event
   * @param {Event} event
   * @return {Element} target element
   */
  exports.getTarget = function (event) {
    // code from http://www.quirksmode.org/js/events_properties.html
    if (!event) {
      event = window.event;
    }

    var target;

    if (event.target) {
      target = event.target;
    } else if (event.srcElement) {
      target = event.srcElement;
    }

    if (target.nodeType != undefined && target.nodeType == 3) {
      // defeat Safari bug
      target = target.parentNode;
    }

    return target;
  };

  /**
   * Check if given element contains given parent somewhere in the DOM tree
   * @param {Element} element
   * @param {Element} parent
   */
  exports.hasParent = function (element, parent) {
    var e = element;

    while (e) {
      if (e === parent) {
        return true;
      }
      e = e.parentNode;
    }

    return false;
  };

  exports.option = {};

  /**
   * Convert a value into a boolean
   * @param {Boolean | function | undefined} value
   * @param {Boolean} [defaultValue]
   * @returns {Boolean} bool
   */
  exports.option.asBoolean = function (value, defaultValue) {
    if (typeof value == 'function') {
      value = value();
    }

    if (value != null) {
      return value != false;
    }

    return defaultValue || null;
  };

  /**
   * Convert a value into a number
   * @param {Boolean | function | undefined} value
   * @param {Number} [defaultValue]
   * @returns {Number} number
   */
  exports.option.asNumber = function (value, defaultValue) {
    if (typeof value == 'function') {
      value = value();
    }

    if (value != null) {
      return Number(value) || defaultValue || null;
    }

    return defaultValue || null;
  };

  /**
   * Convert a value into a string
   * @param {String | function | undefined} value
   * @param {String} [defaultValue]
   * @returns {String} str
   */
  exports.option.asString = function (value, defaultValue) {
    if (typeof value == 'function') {
      value = value();
    }

    if (value != null) {
      return String(value);
    }

    return defaultValue || null;
  };

  /**
   * Convert a size or location into a string with pixels or a percentage
   * @param {String | Number | function | undefined} value
   * @param {String} [defaultValue]
   * @returns {String} size
   */
  exports.option.asSize = function (value, defaultValue) {
    if (typeof value == 'function') {
      value = value();
    }

    if (exports.isString(value)) {
      return value;
    } else if (exports.isNumber(value)) {
      return value + 'px';
    } else {
      return defaultValue || null;
    }
  };

  /**
   * Convert a value into a DOM element
   * @param {HTMLElement | function | undefined} value
   * @param {HTMLElement} [defaultValue]
   * @returns {HTMLElement | null} dom
   */
  exports.option.asElement = function (value, defaultValue) {
    if (typeof value == 'function') {
      value = value();
    }

    return value || defaultValue || null;
  };

  /**
   * http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb
   *
   * @param {String} hex
   * @returns {{r: *, g: *, b: *}} | 255 range
   */
  exports.hexToRGB = function (hex) {
    // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function (m, r, g, b) {
      return r + r + g + g + b + b;
    });
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
      r: parseInt(result[1], 16),
      g: parseInt(result[2], 16),
      b: parseInt(result[3], 16)
    } : null;
  };

  /**
   * This function takes color in hex format or rgb() or rgba() format and overrides the opacity. Returns rgba() string.
   * @param color
   * @param opacity
   * @returns {*}
   */
  exports.overrideOpacity = function (color, opacity) {
    if (color.indexOf("rgba") != -1) {
      return color;
    } else if (color.indexOf("rgb") != -1) {
      var rgb = color.substr(color.indexOf("(") + 1).replace(")", "").split(",");
      return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + opacity + ")";
    } else {
      var rgb = exports.hexToRGB(color);
      if (rgb == null) {
        return color;
      } else {
        return "rgba(" + rgb.r + "," + rgb.g + "," + rgb.b + "," + opacity + ")";
      }
    }
  };

  /**
   *
   * @param red     0 -- 255
   * @param green   0 -- 255
   * @param blue    0 -- 255
   * @returns {string}
   * @constructor
   */
  exports.RGBToHex = function (red, green, blue) {
    return "#" + ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16).slice(1);
  };

  /**
   * Parse a color property into an object with border, background, and
   * highlight colors
   * @param {Object | String} color
   * @return {Object} colorObject
   */
  exports.parseColor = function (color) {
    var c;
    if (exports.isString(color) === true) {
      if (exports.isValidRGB(color) === true) {
        var rgb = color.substr(4).substr(0, color.length - 5).split(',').map(function (value) {
          return parseInt(value);
        });
        color = exports.RGBToHex(rgb[0], rgb[1], rgb[2]);
      }
      if (exports.isValidHex(color) === true) {
        var hsv = exports.hexToHSV(color);
        var lighterColorHSV = { h: hsv.h, s: hsv.s * 0.8, v: Math.min(1, hsv.v * 1.02) };
        var darkerColorHSV = { h: hsv.h, s: Math.min(1, hsv.s * 1.25), v: hsv.v * 0.8 };
        var darkerColorHex = exports.HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
        var lighterColorHex = exports.HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
        c = {
          background: color,
          border: darkerColorHex,
          highlight: {
            background: lighterColorHex,
            border: darkerColorHex
          },
          hover: {
            background: lighterColorHex,
            border: darkerColorHex
          }
        };
      } else {
        c = {
          background: color,
          border: color,
          highlight: {
            background: color,
            border: color
          },
          hover: {
            background: color,
            border: color
          }
        };
      }
    } else {
      c = {};
      c.background = color.background || undefined;
      c.border = color.border || undefined;

      if (exports.isString(color.highlight)) {
        c.highlight = {
          border: color.highlight,
          background: color.highlight
        };
      } else {
        c.highlight = {};
        c.highlight.background = color.highlight && color.highlight.background || undefined;
        c.highlight.border = color.highlight && color.highlight.border || undefined;
      }

      if (exports.isString(color.hover)) {
        c.hover = {
          border: color.hover,
          background: color.hover
        };
      } else {
        c.hover = {};
        c.hover.background = color.hover && color.hover.background || undefined;
        c.hover.border = color.hover && color.hover.border || undefined;
      }
    }

    return c;
  };

  /**
   * http://www.javascripter.net/faq/rgb2hsv.htm
   *
   * @param red
   * @param green
   * @param blue
   * @returns {*}
   * @constructor
   */
  exports.RGBToHSV = function (red, green, blue) {
    red = red / 255;green = green / 255;blue = blue / 255;
    var minRGB = Math.min(red, Math.min(green, blue));
    var maxRGB = Math.max(red, Math.max(green, blue));

    // Black-gray-white
    if (minRGB == maxRGB) {
      return { h: 0, s: 0, v: minRGB };
    }

    // Colors other than black-gray-white:
    var d = red == minRGB ? green - blue : blue == minRGB ? red - green : blue - red;
    var h = red == minRGB ? 3 : blue == minRGB ? 1 : 5;
    var hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
    var saturation = (maxRGB - minRGB) / maxRGB;
    var value = maxRGB;
    return { h: hue, s: saturation, v: value };
  };

  var cssUtil = {
    // split a string with css styles into an object with key/values
    split: function split(cssText) {
      var styles = {};

      cssText.split(';').forEach(function (style) {
        if (style.trim() != '') {
          var parts = style.split(':');
          var key = parts[0].trim();
          var value = parts[1].trim();
          styles[key] = value;
        }
      });

      return styles;
    },

    // build a css text string from an object with key/values
    join: function join(styles) {
      return (0, _keys2['default'])(styles).map(function (key) {
        return key + ': ' + styles[key];
      }).join('; ');
    }
  };

  /**
   * Append a string with css styles to an element
   * @param {Element} element
   * @param {String} cssText
   */
  exports.addCssText = function (element, cssText) {
    var currentStyles = cssUtil.split(element.style.cssText);
    var newStyles = cssUtil.split(cssText);
    var styles = exports.extend(currentStyles, newStyles);

    element.style.cssText = cssUtil.join(styles);
  };

  /**
   * Remove a string with css styles from an element
   * @param {Element} element
   * @param {String} cssText
   */
  exports.removeCssText = function (element, cssText) {
    var styles = cssUtil.split(element.style.cssText);
    var removeStyles = cssUtil.split(cssText);

    for (var key in removeStyles) {
      if (removeStyles.hasOwnProperty(key)) {
        delete styles[key];
      }
    }

    element.style.cssText = cssUtil.join(styles);
  };

  /**
   * https://gist.github.com/mjijackson/5311256
   * @param h
   * @param s
   * @param v
   * @returns {{r: number, g: number, b: number}}
   * @constructor
   */
  exports.HSVToRGB = function (h, s, v) {
    var r, g, b;

    var i = Math.floor(h * 6);
    var f = h * 6 - i;
    var p = v * (1 - s);
    var q = v * (1 - f * s);
    var t = v * (1 - (1 - f) * s);

    switch (i % 6) {
      case 0:
        r = v, g = t, b = p;break;
      case 1:
        r = q, g = v, b = p;break;
      case 2:
        r = p, g = v, b = t;break;
      case 3:
        r = p, g = q, b = v;break;
      case 4:
        r = t, g = p, b = v;break;
      case 5:
        r = v, g = p, b = q;break;
    }

    return { r: Math.floor(r * 255), g: Math.floor(g * 255), b: Math.floor(b * 255) };
  };

  exports.HSVToHex = function (h, s, v) {
    var rgb = exports.HSVToRGB(h, s, v);
    return exports.RGBToHex(rgb.r, rgb.g, rgb.b);
  };

  exports.hexToHSV = function (hex) {
    var rgb = exports.hexToRGB(hex);
    return exports.RGBToHSV(rgb.r, rgb.g, rgb.b);
  };

  exports.isValidHex = function (hex) {
    var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
    return isOk;
  };

  exports.isValidRGB = function (rgb) {
    rgb = rgb.replace(" ", "");
    var isOk = /rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/i.test(rgb);
    return isOk;
  };
  exports.isValidRGBA = function (rgba) {
    rgba = rgba.replace(" ", "");
    var isOk = /rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),(.{1,3})\)/i.test(rgba);
    return isOk;
  };

  /**
   * This recursively redirects the prototype of JSON objects to the referenceObject
   * This is used for default options.
   *
   * @param referenceObject
   * @returns {*}
   */
  exports.selectiveBridgeObject = function (fields, referenceObject) {
    if ((typeof referenceObject === 'undefined' ? 'undefined' : (0, _typeof3['default'])(referenceObject)) == "object") {
      var objectTo = (0, _create2['default'])(referenceObject);
      for (var i = 0; i < fields.length; i++) {
        if (referenceObject.hasOwnProperty(fields[i])) {
          if ((0, _typeof3['default'])(referenceObject[fields[i]]) == "object") {
            objectTo[fields[i]] = exports.bridgeObject(referenceObject[fields[i]]);
          }
        }
      }
      return objectTo;
    } else {
      return null;
    }
  };

  /**
   * This recursively redirects the prototype of JSON objects to the referenceObject
   * This is used for default options.
   *
   * @param referenceObject
   * @returns {*}
   */
  exports.bridgeObject = function (referenceObject) {
    if ((typeof referenceObject === 'undefined' ? 'undefined' : (0, _typeof3['default'])(referenceObject)) == "object") {
      var objectTo = (0, _create2['default'])(referenceObject);
      for (var i in referenceObject) {
        if (referenceObject.hasOwnProperty(i)) {
          if ((0, _typeof3['default'])(referenceObject[i]) == "object") {
            objectTo[i] = exports.bridgeObject(referenceObject[i]);
          }
        }
      }
      return objectTo;
    } else {
      return null;
    }
  };

  /**
   * This method provides a stable sort implementation, very fast for presorted data
   *
   * @param a the array
   * @param a order comparator
   * @returns {the array}
   */
  exports.insertSort = function (a, compare) {
    for (var i = 0; i < a.length; i++) {
      var k = a[i];
      for (var j = i; j > 0 && compare(k, a[j - 1]) < 0; j--) {
        a[j] = a[j - 1];
      }
      a[j] = k;
    }
    return a;
  };

  /**
   * this is used to set the options of subobjects in the options object. A requirement of these subobjects
   * is that they have an 'enabled' element which is optional for the user but mandatory for the program.
   *
   * @param [object] mergeTarget | this is either this.options or the options used for the groups.
   * @param [object] options     | options
   * @param [String] option      | this is the option key in the options argument
   */
  exports.mergeOptions = function (mergeTarget, options, option) {
    var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    var globalOptions = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

    if (options[option] === null) {
      mergeTarget[option] = (0, _create2['default'])(globalOptions[option]);
    } else {
      if (options[option] !== undefined) {
        if (typeof options[option] === 'boolean') {
          mergeTarget[option].enabled = options[option];
        } else {
          if (options[option].enabled === undefined) {
            mergeTarget[option].enabled = true;
          }
          for (var prop in options[option]) {
            if (options[option].hasOwnProperty(prop)) {
              mergeTarget[option][prop] = options[option][prop];
            }
          }
        }
      }
    }
  };

  /**
   * This function does a binary search for a visible item in a sorted list. If we find a visible item, the code that uses
   * this function will then iterate in both directions over this sorted list to find all visible items.
   *
   * @param {Item[]} orderedItems       | Items ordered by start
   * @param {function} comparator       | -1 is lower, 0 is equal, 1 is higher
   * @param {String} field
   * @param {String} field2
   * @returns {number}
   * @private
   */
  exports.binarySearchCustom = function (orderedItems, comparator, field, field2) {
    var maxIterations = 10000;
    var iteration = 0;
    var low = 0;
    var high = orderedItems.length - 1;

    while (low <= high && iteration < maxIterations) {
      var middle = Math.floor((low + high) / 2);

      var item = orderedItems[middle];
      var value = field2 === undefined ? item[field] : item[field][field2];

      var searchResult = comparator(value);
      if (searchResult == 0) {
        // jihaa, found a visible item!
        return middle;
      } else if (searchResult == -1) {
        // it is too small --> increase low
        low = middle + 1;
      } else {
        // it is too big --> decrease high
        high = middle - 1;
      }

      iteration++;
    }

    return -1;
  };

  /**
   * This function does a binary search for a specific value in a sorted array. If it does not exist but is in between of
   * two values, we return either the one before or the one after, depending on user input
   * If it is found, we return the index, else -1.
   *
   * @param {Array} orderedItems
   * @param {{start: number, end: number}} target
   * @param {String} field
   * @param {String} sidePreference   'before' or 'after'
   * @param {function} comparator an optional comparator, returning -1,0,1 for <,==,>.
   * @returns {number}
   * @private
   */
  exports.binarySearchValue = function (orderedItems, target, field, sidePreference, comparator) {
    var maxIterations = 10000;
    var iteration = 0;
    var low = 0;
    var high = orderedItems.length - 1;
    var prevValue, value, nextValue, middle;

    var comparator = comparator != undefined ? comparator : function (a, b) {
      return a == b ? 0 : a < b ? -1 : 1;
    };

    while (low <= high && iteration < maxIterations) {
      // get a new guess
      middle = Math.floor(0.5 * (high + low));
      prevValue = orderedItems[Math.max(0, middle - 1)][field];
      value = orderedItems[middle][field];
      nextValue = orderedItems[Math.min(orderedItems.length - 1, middle + 1)][field];

      if (comparator(value, target) == 0) {
        // we found the target
        return middle;
      } else if (comparator(prevValue, target) < 0 && comparator(value, target) > 0) {
        // target is in between of the previous and the current
        return sidePreference == 'before' ? Math.max(0, middle - 1) : middle;
      } else if (comparator(value, target) < 0 && comparator(nextValue, target) > 0) {
        // target is in between of the current and the next
        return sidePreference == 'before' ? middle : Math.min(orderedItems.length - 1, middle + 1);
      } else {
        // didnt find the target, we need to change our boundaries.
        if (comparator(value, target) < 0) {
          // it is too small --> increase low
          low = middle + 1;
        } else {
          // it is too big --> decrease high
          high = middle - 1;
        }
      }
      iteration++;
    }

    // didnt find anything. Return -1.
    return -1;
  };

  /*
   * Easing Functions - inspired from http://gizma.com/easing/
   * only considering the t value for the range [0, 1] => [0, 1]
   * https://gist.github.com/gre/1650294
   */
  exports.easingFunctions = {
    // no easing, no acceleration
    linear: function linear(t) {
      return t;
    },
    // accelerating from zero velocity
    easeInQuad: function easeInQuad(t) {
      return t * t;
    },
    // decelerating to zero velocity
    easeOutQuad: function easeOutQuad(t) {
      return t * (2 - t);
    },
    // acceleration until halfway, then deceleration
    easeInOutQuad: function easeInOutQuad(t) {
      return t < .5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
    },
    // accelerating from zero velocity
    easeInCubic: function easeInCubic(t) {
      return t * t * t;
    },
    // decelerating to zero velocity
    easeOutCubic: function easeOutCubic(t) {
      return --t * t * t + 1;
    },
    // acceleration until halfway, then deceleration
    easeInOutCubic: function easeInOutCubic(t) {
      return t < .5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
    },
    // accelerating from zero velocity
    easeInQuart: function easeInQuart(t) {
      return t * t * t * t;
    },
    // decelerating to zero velocity
    easeOutQuart: function easeOutQuart(t) {
      return 1 - --t * t * t * t;
    },
    // acceleration until halfway, then deceleration
    easeInOutQuart: function easeInOutQuart(t) {
      return t < .5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
    },
    // accelerating from zero velocity
    easeInQuint: function easeInQuint(t) {
      return t * t * t * t * t;
    },
    // decelerating to zero velocity
    easeOutQuint: function easeOutQuint(t) {
      return 1 + --t * t * t * t * t;
    },
    // acceleration until halfway, then deceleration
    easeInOutQuint: function easeInOutQuint(t) {
      return t < .5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
    }
  };

  exports.getScrollBarWidth = function () {
    var inner = document.createElement('p');
    inner.style.width = "100%";
    inner.style.height = "200px";

    var outer = document.createElement('div');
    outer.style.position = "absolute";
    outer.style.top = "0px";
    outer.style.left = "0px";
    outer.style.visibility = "hidden";
    outer.style.width = "200px";
    outer.style.height = "150px";
    outer.style.overflow = "hidden";
    outer.appendChild(inner);

    document.body.appendChild(outer);
    var w1 = inner.offsetWidth;
    outer.style.overflow = 'scroll';
    var w2 = inner.offsetWidth;
    if (w1 == w2) w2 = outer.clientWidth;

    document.body.removeChild(outer);

    return w1 - w2;
  };

  exports.topMost = function (pile, accessors) {
    var candidate = void 0;
    if (!Array.isArray(accessors)) {
      accessors = [accessors];
    }
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = (0, _getIterator3['default'])(pile), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var member = _step.value;

        if (member) {
          candidate = member[accessors[0]];
          for (var i = 1; i < accessors.length; i++) {
            if (candidate) {
              candidate = candidate[accessors[i]];
            } else {
              continue;
            }
          }
          if (typeof candidate != 'undefined') {
            break;
          }
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator['return']) {
          _iterator['return']();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return candidate;
  };

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(3), __esModule: true };

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(4);
  __webpack_require__(50);
  module.exports = __webpack_require__(52);

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(5);
  var global        = __webpack_require__(16)
    , hide          = __webpack_require__(20)
    , Iterators     = __webpack_require__(8)
    , TO_STRING_TAG = __webpack_require__(47)('toStringTag');

  for(var collections = ['NodeList', 'DOMTokenList', 'MediaList', 'StyleSheetList', 'CSSRuleList'], i = 0; i < 5; i++){
    var NAME       = collections[i]
      , Collection = global[NAME]
      , proto      = Collection && Collection.prototype;
    if(proto && !proto[TO_STRING_TAG])hide(proto, TO_STRING_TAG, NAME);
    Iterators[NAME] = Iterators.Array;
  }

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';
  var addToUnscopables = __webpack_require__(6)
    , step             = __webpack_require__(7)
    , Iterators        = __webpack_require__(8)
    , toIObject        = __webpack_require__(9);

  // 22.1.3.4 Array.prototype.entries()
  // 22.1.3.13 Array.prototype.keys()
  // 22.1.3.29 Array.prototype.values()
  // 22.1.3.30 Array.prototype[@@iterator]()
  module.exports = __webpack_require__(13)(Array, 'Array', function(iterated, kind){
    this._t = toIObject(iterated); // target
    this._i = 0;                   // next index
    this._k = kind;                // kind
  // 22.1.5.2.1 %ArrayIteratorPrototype%.next()
  }, function(){
    var O     = this._t
      , kind  = this._k
      , index = this._i++;
    if(!O || index >= O.length){
      this._t = undefined;
      return step(1);
    }
    if(kind == 'keys'  )return step(0, index);
    if(kind == 'values')return step(0, O[index]);
    return step(0, [index, O[index]]);
  }, 'values');

  // argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
  Iterators.Arguments = Iterators.Array;

  addToUnscopables('keys');
  addToUnscopables('values');
  addToUnscopables('entries');

/***/ },
/* 6 */
/***/ function(module, exports) {

  module.exports = function(){ /* empty */ };

/***/ },
/* 7 */
/***/ function(module, exports) {

  module.exports = function(done, value){
    return {value: value, done: !!done};
  };

/***/ },
/* 8 */
/***/ function(module, exports) {

  module.exports = {};

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

  // to indexed object, toObject with fallback for non-array-like ES3 strings
  var IObject = __webpack_require__(10)
    , defined = __webpack_require__(12);
  module.exports = function(it){
    return IObject(defined(it));
  };

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

  // fallback for non-array-like ES3 and non-enumerable old V8 strings
  var cof = __webpack_require__(11);
  module.exports = Object('z').propertyIsEnumerable(0) ? Object : function(it){
    return cof(it) == 'String' ? it.split('') : Object(it);
  };

/***/ },
/* 11 */
/***/ function(module, exports) {

  var toString = {}.toString;

  module.exports = function(it){
    return toString.call(it).slice(8, -1);
  };

/***/ },
/* 12 */
/***/ function(module, exports) {

  // 7.2.1 RequireObjectCoercible(argument)
  module.exports = function(it){
    if(it == undefined)throw TypeError("Can't call method on  " + it);
    return it;
  };

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';
  var LIBRARY        = __webpack_require__(14)
    , $export        = __webpack_require__(15)
    , redefine       = __webpack_require__(30)
    , hide           = __webpack_require__(20)
    , has            = __webpack_require__(31)
    , Iterators      = __webpack_require__(8)
    , $iterCreate    = __webpack_require__(32)
    , setToStringTag = __webpack_require__(46)
    , getPrototypeOf = __webpack_require__(48)
    , ITERATOR       = __webpack_require__(47)('iterator')
    , BUGGY          = !([].keys && 'next' in [].keys()) // Safari has buggy iterators w/o `next`
    , FF_ITERATOR    = '@@iterator'
    , KEYS           = 'keys'
    , VALUES         = 'values';

  var returnThis = function(){ return this; };

  module.exports = function(Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED){
    $iterCreate(Constructor, NAME, next);
    var getMethod = function(kind){
      if(!BUGGY && kind in proto)return proto[kind];
      switch(kind){
        case KEYS: return function keys(){ return new Constructor(this, kind); };
        case VALUES: return function values(){ return new Constructor(this, kind); };
      } return function entries(){ return new Constructor(this, kind); };
    };
    var TAG        = NAME + ' Iterator'
      , DEF_VALUES = DEFAULT == VALUES
      , VALUES_BUG = false
      , proto      = Base.prototype
      , $native    = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT]
      , $default   = $native || getMethod(DEFAULT)
      , $entries   = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined
      , $anyNative = NAME == 'Array' ? proto.entries || $native : $native
      , methods, key, IteratorPrototype;
    // Fix native
    if($anyNative){
      IteratorPrototype = getPrototypeOf($anyNative.call(new Base));
      if(IteratorPrototype !== Object.prototype){
        // Set @@toStringTag to native iterators
        setToStringTag(IteratorPrototype, TAG, true);
        // fix for some old engines
        if(!LIBRARY && !has(IteratorPrototype, ITERATOR))hide(IteratorPrototype, ITERATOR, returnThis);
      }
    }
    // fix Array#{values, @@iterator}.name in V8 / FF
    if(DEF_VALUES && $native && $native.name !== VALUES){
      VALUES_BUG = true;
      $default = function values(){ return $native.call(this); };
    }
    // Define iterator
    if((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])){
      hide(proto, ITERATOR, $default);
    }
    // Plug for library
    Iterators[NAME] = $default;
    Iterators[TAG]  = returnThis;
    if(DEFAULT){
      methods = {
        values:  DEF_VALUES ? $default : getMethod(VALUES),
        keys:    IS_SET     ? $default : getMethod(KEYS),
        entries: $entries
      };
      if(FORCED)for(key in methods){
        if(!(key in proto))redefine(proto, key, methods[key]);
      } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
    }
    return methods;
  };

/***/ },
/* 14 */
/***/ function(module, exports) {

  module.exports = true;

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

  var global    = __webpack_require__(16)
    , core      = __webpack_require__(17)
    , ctx       = __webpack_require__(18)
    , hide      = __webpack_require__(20)
    , PROTOTYPE = 'prototype';

  var $export = function(type, name, source){
    var IS_FORCED = type & $export.F
      , IS_GLOBAL = type & $export.G
      , IS_STATIC = type & $export.S
      , IS_PROTO  = type & $export.P
      , IS_BIND   = type & $export.B
      , IS_WRAP   = type & $export.W
      , exports   = IS_GLOBAL ? core : core[name] || (core[name] = {})
      , expProto  = exports[PROTOTYPE]
      , target    = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE]
      , key, own, out;
    if(IS_GLOBAL)source = name;
    for(key in source){
      // contains in native
      own = !IS_FORCED && target && target[key] !== undefined;
      if(own && key in exports)continue;
      // export native or passed
      out = own ? target[key] : source[key];
      // prevent global pollution for namespaces
      exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
      // bind timers to global for call from export context
      : IS_BIND && own ? ctx(out, global)
      // wrap global constructors for prevent change them in library
      : IS_WRAP && target[key] == out ? (function(C){
        var F = function(a, b, c){
          if(this instanceof C){
            switch(arguments.length){
              case 0: return new C;
              case 1: return new C(a);
              case 2: return new C(a, b);
            } return new C(a, b, c);
          } return C.apply(this, arguments);
        };
        F[PROTOTYPE] = C[PROTOTYPE];
        return F;
      // make static versions for prototype methods
      })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
      // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
      if(IS_PROTO){
        (exports.virtual || (exports.virtual = {}))[key] = out;
        // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
        if(type & $export.R && expProto && !expProto[key])hide(expProto, key, out);
      }
    }
  };
  // type bitmap
  $export.F = 1;   // forced
  $export.G = 2;   // global
  $export.S = 4;   // static
  $export.P = 8;   // proto
  $export.B = 16;  // bind
  $export.W = 32;  // wrap
  $export.U = 64;  // safe
  $export.R = 128; // real proto method for `library` 
  module.exports = $export;

/***/ },
/* 16 */
/***/ function(module, exports) {

  // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
  var global = module.exports = typeof window != 'undefined' && window.Math == Math
    ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();
  if(typeof __g == 'number')__g = global; // eslint-disable-line no-undef

/***/ },
/* 17 */
/***/ function(module, exports) {

  var core = module.exports = {version: '2.4.0'};
  if(typeof __e == 'number')__e = core; // eslint-disable-line no-undef

/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

  // optional / simple context binding
  var aFunction = __webpack_require__(19);
  module.exports = function(fn, that, length){
    aFunction(fn);
    if(that === undefined)return fn;
    switch(length){
      case 1: return function(a){
        return fn.call(that, a);
      };
      case 2: return function(a, b){
        return fn.call(that, a, b);
      };
      case 3: return function(a, b, c){
        return fn.call(that, a, b, c);
      };
    }
    return function(/* ...args */){
      return fn.apply(that, arguments);
    };
  };

/***/ },
/* 19 */
/***/ function(module, exports) {

  module.exports = function(it){
    if(typeof it != 'function')throw TypeError(it + ' is not a function!');
    return it;
  };

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

  var dP         = __webpack_require__(21)
    , createDesc = __webpack_require__(29);
  module.exports = __webpack_require__(25) ? function(object, key, value){
    return dP.f(object, key, createDesc(1, value));
  } : function(object, key, value){
    object[key] = value;
    return object;
  };

/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

  var anObject       = __webpack_require__(22)
    , IE8_DOM_DEFINE = __webpack_require__(24)
    , toPrimitive    = __webpack_require__(28)
    , dP             = Object.defineProperty;

  exports.f = __webpack_require__(25) ? Object.defineProperty : function defineProperty(O, P, Attributes){
    anObject(O);
    P = toPrimitive(P, true);
    anObject(Attributes);
    if(IE8_DOM_DEFINE)try {
      return dP(O, P, Attributes);
    } catch(e){ /* empty */ }
    if('get' in Attributes || 'set' in Attributes)throw TypeError('Accessors not supported!');
    if('value' in Attributes)O[P] = Attributes.value;
    return O;
  };

/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

  var isObject = __webpack_require__(23);
  module.exports = function(it){
    if(!isObject(it))throw TypeError(it + ' is not an object!');
    return it;
  };

/***/ },
/* 23 */
/***/ function(module, exports) {

  module.exports = function(it){
    return typeof it === 'object' ? it !== null : typeof it === 'function';
  };

/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = !__webpack_require__(25) && !__webpack_require__(26)(function(){
    return Object.defineProperty(__webpack_require__(27)('div'), 'a', {get: function(){ return 7; }}).a != 7;
  });

/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

  // Thank's IE8 for his funny defineProperty
  module.exports = !__webpack_require__(26)(function(){
    return Object.defineProperty({}, 'a', {get: function(){ return 7; }}).a != 7;
  });

/***/ },
/* 26 */
/***/ function(module, exports) {

  module.exports = function(exec){
    try {
      return !!exec();
    } catch(e){
      return true;
    }
  };

/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

  var isObject = __webpack_require__(23)
    , document = __webpack_require__(16).document
    // in old IE typeof document.createElement is 'object'
    , is = isObject(document) && isObject(document.createElement);
  module.exports = function(it){
    return is ? document.createElement(it) : {};
  };

/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

  // 7.1.1 ToPrimitive(input [, PreferredType])
  var isObject = __webpack_require__(23);
  // instead of the ES6 spec version, we didn't implement @@toPrimitive case
  // and the second argument - flag - preferred type is a string
  module.exports = function(it, S){
    if(!isObject(it))return it;
    var fn, val;
    if(S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it)))return val;
    if(typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it)))return val;
    if(!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it)))return val;
    throw TypeError("Can't convert object to primitive value");
  };

/***/ },
/* 29 */
/***/ function(module, exports) {

  module.exports = function(bitmap, value){
    return {
      enumerable  : !(bitmap & 1),
      configurable: !(bitmap & 2),
      writable    : !(bitmap & 4),
      value       : value
    };
  };

/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = __webpack_require__(20);

/***/ },
/* 31 */
/***/ function(module, exports) {

  var hasOwnProperty = {}.hasOwnProperty;
  module.exports = function(it, key){
    return hasOwnProperty.call(it, key);
  };

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';
  var create         = __webpack_require__(33)
    , descriptor     = __webpack_require__(29)
    , setToStringTag = __webpack_require__(46)
    , IteratorPrototype = {};

  // 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
  __webpack_require__(20)(IteratorPrototype, __webpack_require__(47)('iterator'), function(){ return this; });

  module.exports = function(Constructor, NAME, next){
    Constructor.prototype = create(IteratorPrototype, {next: descriptor(1, next)});
    setToStringTag(Constructor, NAME + ' Iterator');
  };

/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

  // 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
  var anObject    = __webpack_require__(22)
    , dPs         = __webpack_require__(34)
    , enumBugKeys = __webpack_require__(44)
    , IE_PROTO    = __webpack_require__(41)('IE_PROTO')
    , Empty       = function(){ /* empty */ }
    , PROTOTYPE   = 'prototype';

  // Create object with fake `null` prototype: use iframe Object with cleared prototype
  var createDict = function(){
    // Thrash, waste and sodomy: IE GC bug
    var iframe = __webpack_require__(27)('iframe')
      , i      = enumBugKeys.length
      , lt     = '<'
      , gt     = '>'
      , iframeDocument;
    iframe.style.display = 'none';
    __webpack_require__(45).appendChild(iframe);
    iframe.src = 'javascript:'; // eslint-disable-line no-script-url
    // createDict = iframe.contentWindow.Object;
    // html.removeChild(iframe);
    iframeDocument = iframe.contentWindow.document;
    iframeDocument.open();
    iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
    iframeDocument.close();
    createDict = iframeDocument.F;
    while(i--)delete createDict[PROTOTYPE][enumBugKeys[i]];
    return createDict();
  };

  module.exports = Object.create || function create(O, Properties){
    var result;
    if(O !== null){
      Empty[PROTOTYPE] = anObject(O);
      result = new Empty;
      Empty[PROTOTYPE] = null;
      // add "__proto__" for Object.getPrototypeOf polyfill
      result[IE_PROTO] = O;
    } else result = createDict();
    return Properties === undefined ? result : dPs(result, Properties);
  };


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

  var dP       = __webpack_require__(21)
    , anObject = __webpack_require__(22)
    , getKeys  = __webpack_require__(35);

  module.exports = __webpack_require__(25) ? Object.defineProperties : function defineProperties(O, Properties){
    anObject(O);
    var keys   = getKeys(Properties)
      , length = keys.length
      , i = 0
      , P;
    while(length > i)dP.f(O, P = keys[i++], Properties[P]);
    return O;
  };

/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

  // 19.1.2.14 / 15.2.3.14 Object.keys(O)
  var $keys       = __webpack_require__(36)
    , enumBugKeys = __webpack_require__(44);

  module.exports = Object.keys || function keys(O){
    return $keys(O, enumBugKeys);
  };

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

  var has          = __webpack_require__(31)
    , toIObject    = __webpack_require__(9)
    , arrayIndexOf = __webpack_require__(37)(false)
    , IE_PROTO     = __webpack_require__(41)('IE_PROTO');

  module.exports = function(object, names){
    var O      = toIObject(object)
      , i      = 0
      , result = []
      , key;
    for(key in O)if(key != IE_PROTO)has(O, key) && result.push(key);
    // Don't enum bug & hidden keys
    while(names.length > i)if(has(O, key = names[i++])){
      ~arrayIndexOf(result, key) || result.push(key);
    }
    return result;
  };

/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

  // false -> Array#indexOf
  // true  -> Array#includes
  var toIObject = __webpack_require__(9)
    , toLength  = __webpack_require__(38)
    , toIndex   = __webpack_require__(40);
  module.exports = function(IS_INCLUDES){
    return function($this, el, fromIndex){
      var O      = toIObject($this)
        , length = toLength(O.length)
        , index  = toIndex(fromIndex, length)
        , value;
      // Array#includes uses SameValueZero equality algorithm
      if(IS_INCLUDES && el != el)while(length > index){
        value = O[index++];
        if(value != value)return true;
      // Array#toIndex ignores holes, Array#includes - not
      } else for(;length > index; index++)if(IS_INCLUDES || index in O){
        if(O[index] === el)return IS_INCLUDES || index || 0;
      } return !IS_INCLUDES && -1;
    };
  };

/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

  // 7.1.15 ToLength
  var toInteger = __webpack_require__(39)
    , min       = Math.min;
  module.exports = function(it){
    return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
  };

/***/ },
/* 39 */
/***/ function(module, exports) {

  // 7.1.4 ToInteger
  var ceil  = Math.ceil
    , floor = Math.floor;
  module.exports = function(it){
    return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
  };

/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

  var toInteger = __webpack_require__(39)
    , max       = Math.max
    , min       = Math.min;
  module.exports = function(index, length){
    index = toInteger(index);
    return index < 0 ? max(index + length, 0) : min(index, length);
  };

/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

  var shared = __webpack_require__(42)('keys')
    , uid    = __webpack_require__(43);
  module.exports = function(key){
    return shared[key] || (shared[key] = uid(key));
  };

/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

  var global = __webpack_require__(16)
    , SHARED = '__core-js_shared__'
    , store  = global[SHARED] || (global[SHARED] = {});
  module.exports = function(key){
    return store[key] || (store[key] = {});
  };

/***/ },
/* 43 */
/***/ function(module, exports) {

  var id = 0
    , px = Math.random();
  module.exports = function(key){
    return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
  };

/***/ },
/* 44 */
/***/ function(module, exports) {

  // IE 8- don't enum bug keys
  module.exports = (
    'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
  ).split(',');

/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = __webpack_require__(16).document && document.documentElement;

/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

  var def = __webpack_require__(21).f
    , has = __webpack_require__(31)
    , TAG = __webpack_require__(47)('toStringTag');

  module.exports = function(it, tag, stat){
    if(it && !has(it = stat ? it : it.prototype, TAG))def(it, TAG, {configurable: true, value: tag});
  };

/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

  var store      = __webpack_require__(42)('wks')
    , uid        = __webpack_require__(43)
    , Symbol     = __webpack_require__(16).Symbol
    , USE_SYMBOL = typeof Symbol == 'function';

  var $exports = module.exports = function(name){
    return store[name] || (store[name] =
      USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
  };

  $exports.store = store;

/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

  // 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
  var has         = __webpack_require__(31)
    , toObject    = __webpack_require__(49)
    , IE_PROTO    = __webpack_require__(41)('IE_PROTO')
    , ObjectProto = Object.prototype;

  module.exports = Object.getPrototypeOf || function(O){
    O = toObject(O);
    if(has(O, IE_PROTO))return O[IE_PROTO];
    if(typeof O.constructor == 'function' && O instanceof O.constructor){
      return O.constructor.prototype;
    } return O instanceof Object ? ObjectProto : null;
  };

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

  // 7.1.13 ToObject(argument)
  var defined = __webpack_require__(12);
  module.exports = function(it){
    return Object(defined(it));
  };

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';
  var $at  = __webpack_require__(51)(true);

  // 21.1.3.27 String.prototype[@@iterator]()
  __webpack_require__(13)(String, 'String', function(iterated){
    this._t = String(iterated); // target
    this._i = 0;                // next index
  // 21.1.5.2.1 %StringIteratorPrototype%.next()
  }, function(){
    var O     = this._t
      , index = this._i
      , point;
    if(index >= O.length)return {value: undefined, done: true};
    point = $at(O, index);
    this._i += point.length;
    return {value: point, done: false};
  });

/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

  var toInteger = __webpack_require__(39)
    , defined   = __webpack_require__(12);
  // true  -> String#at
  // false -> String#codePointAt
  module.exports = function(TO_STRING){
    return function(that, pos){
      var s = String(defined(that))
        , i = toInteger(pos)
        , l = s.length
        , a, b;
      if(i < 0 || i >= l)return TO_STRING ? '' : undefined;
      a = s.charCodeAt(i);
      return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
        ? TO_STRING ? s.charAt(i) : a
        : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
    };
  };

/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

  var anObject = __webpack_require__(22)
    , get      = __webpack_require__(53);
  module.exports = __webpack_require__(17).getIterator = function(it){
    var iterFn = get(it);
    if(typeof iterFn != 'function')throw TypeError(it + ' is not iterable!');
    return anObject(iterFn.call(it));
  };

/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

  var classof   = __webpack_require__(54)
    , ITERATOR  = __webpack_require__(47)('iterator')
    , Iterators = __webpack_require__(8);
  module.exports = __webpack_require__(17).getIteratorMethod = function(it){
    if(it != undefined)return it[ITERATOR]
      || it['@@iterator']
      || Iterators[classof(it)];
  };

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

  // getting tag from 19.1.3.6 Object.prototype.toString()
  var cof = __webpack_require__(11)
    , TAG = __webpack_require__(47)('toStringTag')
    // ES3 wrong here
    , ARG = cof(function(){ return arguments; }()) == 'Arguments';

  // fallback for IE11 Script Access Denied error
  var tryGet = function(it, key){
    try {
      return it[key];
    } catch(e){ /* empty */ }
  };

  module.exports = function(it){
    var O, T, B;
    return it === undefined ? 'Undefined' : it === null ? 'Null'
      // @@toStringTag case
      : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
      // builtinTag case
      : ARG ? cof(O)
      // ES3 arguments fallback
      : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
  };

/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(56), __esModule: true };

/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(57);
  var $Object = __webpack_require__(17).Object;
  module.exports = function create(P, D){
    return $Object.create(P, D);
  };

/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

  var $export = __webpack_require__(15)
  // 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
  $export($export.S, 'Object', {create: __webpack_require__(33)});

/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(59), __esModule: true };

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(60);
  module.exports = __webpack_require__(17).Object.keys;

/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

  // 19.1.2.14 Object.keys(O)
  var toObject = __webpack_require__(49)
    , $keys    = __webpack_require__(35);

  __webpack_require__(61)('keys', function(){
    return function keys(it){
      return $keys(toObject(it));
    };
  });

/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

  // most Object methods by ES6 should accept primitives
  var $export = __webpack_require__(15)
    , core    = __webpack_require__(17)
    , fails   = __webpack_require__(26);
  module.exports = function(KEY, exec){
    var fn  = (core.Object || {})[KEY] || Object[KEY]
      , exp = {};
    exp[KEY] = exec(fn);
    $export($export.S + $export.F * fails(function(){ fn(1); }), 'Object', exp);
  };

/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

  "use strict";

  exports.__esModule = true;

  var _iterator = __webpack_require__(63);

  var _iterator2 = _interopRequireDefault(_iterator);

  var _symbol = __webpack_require__(66);

  var _symbol2 = _interopRequireDefault(_symbol);

  var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

  exports.default = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
    return typeof obj === "undefined" ? "undefined" : _typeof(obj);
  } : function (obj) {
    return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
  };

/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(64), __esModule: true };

/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(50);
  __webpack_require__(4);
  module.exports = __webpack_require__(65).f('iterator');

/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

  exports.f = __webpack_require__(47);

/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(67), __esModule: true };

/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(68);
  __webpack_require__(79);
  __webpack_require__(80);
  __webpack_require__(81);
  module.exports = __webpack_require__(17).Symbol;

/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';
  // ECMAScript 6 symbols shim
  var global         = __webpack_require__(16)
    , has            = __webpack_require__(31)
    , DESCRIPTORS    = __webpack_require__(25)
    , $export        = __webpack_require__(15)
    , redefine       = __webpack_require__(30)
    , META           = __webpack_require__(69).KEY
    , $fails         = __webpack_require__(26)
    , shared         = __webpack_require__(42)
    , setToStringTag = __webpack_require__(46)
    , uid            = __webpack_require__(43)
    , wks            = __webpack_require__(47)
    , wksExt         = __webpack_require__(65)
    , wksDefine      = __webpack_require__(70)
    , keyOf          = __webpack_require__(71)
    , enumKeys       = __webpack_require__(72)
    , isArray        = __webpack_require__(75)
    , anObject       = __webpack_require__(22)
    , toIObject      = __webpack_require__(9)
    , toPrimitive    = __webpack_require__(28)
    , createDesc     = __webpack_require__(29)
    , _create        = __webpack_require__(33)
    , gOPNExt        = __webpack_require__(76)
    , $GOPD          = __webpack_require__(78)
    , $DP            = __webpack_require__(21)
    , $keys          = __webpack_require__(35)
    , gOPD           = $GOPD.f
    , dP             = $DP.f
    , gOPN           = gOPNExt.f
    , $Symbol        = global.Symbol
    , $JSON          = global.JSON
    , _stringify     = $JSON && $JSON.stringify
    , PROTOTYPE      = 'prototype'
    , HIDDEN         = wks('_hidden')
    , TO_PRIMITIVE   = wks('toPrimitive')
    , isEnum         = {}.propertyIsEnumerable
    , SymbolRegistry = shared('symbol-registry')
    , AllSymbols     = shared('symbols')
    , OPSymbols      = shared('op-symbols')
    , ObjectProto    = Object[PROTOTYPE]
    , USE_NATIVE     = typeof $Symbol == 'function'
    , QObject        = global.QObject;
  // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
  var setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

  // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
  var setSymbolDesc = DESCRIPTORS && $fails(function(){
    return _create(dP({}, 'a', {
      get: function(){ return dP(this, 'a', {value: 7}).a; }
    })).a != 7;
  }) ? function(it, key, D){
    var protoDesc = gOPD(ObjectProto, key);
    if(protoDesc)delete ObjectProto[key];
    dP(it, key, D);
    if(protoDesc && it !== ObjectProto)dP(ObjectProto, key, protoDesc);
  } : dP;

  var wrap = function(tag){
    var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);
    sym._k = tag;
    return sym;
  };

  var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function(it){
    return typeof it == 'symbol';
  } : function(it){
    return it instanceof $Symbol;
  };

  var $defineProperty = function defineProperty(it, key, D){
    if(it === ObjectProto)$defineProperty(OPSymbols, key, D);
    anObject(it);
    key = toPrimitive(key, true);
    anObject(D);
    if(has(AllSymbols, key)){
      if(!D.enumerable){
        if(!has(it, HIDDEN))dP(it, HIDDEN, createDesc(1, {}));
        it[HIDDEN][key] = true;
      } else {
        if(has(it, HIDDEN) && it[HIDDEN][key])it[HIDDEN][key] = false;
        D = _create(D, {enumerable: createDesc(0, false)});
      } return setSymbolDesc(it, key, D);
    } return dP(it, key, D);
  };
  var $defineProperties = function defineProperties(it, P){
    anObject(it);
    var keys = enumKeys(P = toIObject(P))
      , i    = 0
      , l = keys.length
      , key;
    while(l > i)$defineProperty(it, key = keys[i++], P[key]);
    return it;
  };
  var $create = function create(it, P){
    return P === undefined ? _create(it) : $defineProperties(_create(it), P);
  };
  var $propertyIsEnumerable = function propertyIsEnumerable(key){
    var E = isEnum.call(this, key = toPrimitive(key, true));
    if(this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key))return false;
    return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
  };
  var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key){
    it  = toIObject(it);
    key = toPrimitive(key, true);
    if(it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key))return;
    var D = gOPD(it, key);
    if(D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key]))D.enumerable = true;
    return D;
  };
  var $getOwnPropertyNames = function getOwnPropertyNames(it){
    var names  = gOPN(toIObject(it))
      , result = []
      , i      = 0
      , key;
    while(names.length > i){
      if(!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META)result.push(key);
    } return result;
  };
  var $getOwnPropertySymbols = function getOwnPropertySymbols(it){
    var IS_OP  = it === ObjectProto
      , names  = gOPN(IS_OP ? OPSymbols : toIObject(it))
      , result = []
      , i      = 0
      , key;
    while(names.length > i){
      if(has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true))result.push(AllSymbols[key]);
    } return result;
  };

  // 19.4.1.1 Symbol([description])
  if(!USE_NATIVE){
    $Symbol = function Symbol(){
      if(this instanceof $Symbol)throw TypeError('Symbol is not a constructor!');
      var tag = uid(arguments.length > 0 ? arguments[0] : undefined);
      var $set = function(value){
        if(this === ObjectProto)$set.call(OPSymbols, value);
        if(has(this, HIDDEN) && has(this[HIDDEN], tag))this[HIDDEN][tag] = false;
        setSymbolDesc(this, tag, createDesc(1, value));
      };
      if(DESCRIPTORS && setter)setSymbolDesc(ObjectProto, tag, {configurable: true, set: $set});
      return wrap(tag);
    };
    redefine($Symbol[PROTOTYPE], 'toString', function toString(){
      return this._k;
    });

    $GOPD.f = $getOwnPropertyDescriptor;
    $DP.f   = $defineProperty;
    __webpack_require__(77).f = gOPNExt.f = $getOwnPropertyNames;
    __webpack_require__(74).f  = $propertyIsEnumerable;
    __webpack_require__(73).f = $getOwnPropertySymbols;

    if(DESCRIPTORS && !__webpack_require__(14)){
      redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);
    }

    wksExt.f = function(name){
      return wrap(wks(name));
    }
  }

  $export($export.G + $export.W + $export.F * !USE_NATIVE, {Symbol: $Symbol});

  for(var symbols = (
    // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14
    'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'
  ).split(','), i = 0; symbols.length > i; )wks(symbols[i++]);

  for(var symbols = $keys(wks.store), i = 0; symbols.length > i; )wksDefine(symbols[i++]);

  $export($export.S + $export.F * !USE_NATIVE, 'Symbol', {
    // 19.4.2.1 Symbol.for(key)
    'for': function(key){
      return has(SymbolRegistry, key += '')
        ? SymbolRegistry[key]
        : SymbolRegistry[key] = $Symbol(key);
    },
    // 19.4.2.5 Symbol.keyFor(sym)
    keyFor: function keyFor(key){
      if(isSymbol(key))return keyOf(SymbolRegistry, key);
      throw TypeError(key + ' is not a symbol!');
    },
    useSetter: function(){ setter = true; },
    useSimple: function(){ setter = false; }
  });

  $export($export.S + $export.F * !USE_NATIVE, 'Object', {
    // 19.1.2.2 Object.create(O [, Properties])
    create: $create,
    // 19.1.2.4 Object.defineProperty(O, P, Attributes)
    defineProperty: $defineProperty,
    // 19.1.2.3 Object.defineProperties(O, Properties)
    defineProperties: $defineProperties,
    // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
    getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
    // 19.1.2.7 Object.getOwnPropertyNames(O)
    getOwnPropertyNames: $getOwnPropertyNames,
    // 19.1.2.8 Object.getOwnPropertySymbols(O)
    getOwnPropertySymbols: $getOwnPropertySymbols
  });

  // 24.3.2 JSON.stringify(value [, replacer [, space]])
  $JSON && $export($export.S + $export.F * (!USE_NATIVE || $fails(function(){
    var S = $Symbol();
    // MS Edge converts symbol values to JSON as {}
    // WebKit converts symbol values to JSON as null
    // V8 throws on boxed symbols
    return _stringify([S]) != '[null]' || _stringify({a: S}) != '{}' || _stringify(Object(S)) != '{}';
  })), 'JSON', {
    stringify: function stringify(it){
      if(it === undefined || isSymbol(it))return; // IE8 returns string on undefined
      var args = [it]
        , i    = 1
        , replacer, $replacer;
      while(arguments.length > i)args.push(arguments[i++]);
      replacer = args[1];
      if(typeof replacer == 'function')$replacer = replacer;
      if($replacer || !isArray(replacer))replacer = function(key, value){
        if($replacer)value = $replacer.call(this, key, value);
        if(!isSymbol(value))return value;
      };
      args[1] = replacer;
      return _stringify.apply($JSON, args);
    }
  });

  // 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)
  $Symbol[PROTOTYPE][TO_PRIMITIVE] || __webpack_require__(20)($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
  // 19.4.3.5 Symbol.prototype[@@toStringTag]
  setToStringTag($Symbol, 'Symbol');
  // 20.2.1.9 Math[@@toStringTag]
  setToStringTag(Math, 'Math', true);
  // 24.3.3 JSON[@@toStringTag]
  setToStringTag(global.JSON, 'JSON', true);

/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

  var META     = __webpack_require__(43)('meta')
    , isObject = __webpack_require__(23)
    , has      = __webpack_require__(31)
    , setDesc  = __webpack_require__(21).f
    , id       = 0;
  var isExtensible = Object.isExtensible || function(){
    return true;
  };
  var FREEZE = !__webpack_require__(26)(function(){
    return isExtensible(Object.preventExtensions({}));
  });
  var setMeta = function(it){
    setDesc(it, META, {value: {
      i: 'O' + ++id, // object ID
      w: {}          // weak collections IDs
    }});
  };
  var fastKey = function(it, create){
    // return primitive with prefix
    if(!isObject(it))return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
    if(!has(it, META)){
      // can't set metadata to uncaught frozen object
      if(!isExtensible(it))return 'F';
      // not necessary to add metadata
      if(!create)return 'E';
      // add missing metadata
      setMeta(it);
    // return object ID
    } return it[META].i;
  };
  var getWeak = function(it, create){
    if(!has(it, META)){
      // can't set metadata to uncaught frozen object
      if(!isExtensible(it))return true;
      // not necessary to add metadata
      if(!create)return false;
      // add missing metadata
      setMeta(it);
    // return hash weak collections IDs
    } return it[META].w;
  };
  // add metadata on freeze-family methods calling
  var onFreeze = function(it){
    if(FREEZE && meta.NEED && isExtensible(it) && !has(it, META))setMeta(it);
    return it;
  };
  var meta = module.exports = {
    KEY:      META,
    NEED:     false,
    fastKey:  fastKey,
    getWeak:  getWeak,
    onFreeze: onFreeze
  };

/***/ },
/* 70 */
/***/ function(module, exports, __webpack_require__) {

  var global         = __webpack_require__(16)
    , core           = __webpack_require__(17)
    , LIBRARY        = __webpack_require__(14)
    , wksExt         = __webpack_require__(65)
    , defineProperty = __webpack_require__(21).f;
  module.exports = function(name){
    var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
    if(name.charAt(0) != '_' && !(name in $Symbol))defineProperty($Symbol, name, {value: wksExt.f(name)});
  };

/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

  var getKeys   = __webpack_require__(35)
    , toIObject = __webpack_require__(9);
  module.exports = function(object, el){
    var O      = toIObject(object)
      , keys   = getKeys(O)
      , length = keys.length
      , index  = 0
      , key;
    while(length > index)if(O[key = keys[index++]] === el)return key;
  };

/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

  // all enumerable object keys, includes symbols
  var getKeys = __webpack_require__(35)
    , gOPS    = __webpack_require__(73)
    , pIE     = __webpack_require__(74);
  module.exports = function(it){
    var result     = getKeys(it)
      , getSymbols = gOPS.f;
    if(getSymbols){
      var symbols = getSymbols(it)
        , isEnum  = pIE.f
        , i       = 0
        , key;
      while(symbols.length > i)if(isEnum.call(it, key = symbols[i++]))result.push(key);
    } return result;
  };

/***/ },
/* 73 */
/***/ function(module, exports) {

  exports.f = Object.getOwnPropertySymbols;

/***/ },
/* 74 */
/***/ function(module, exports) {

  exports.f = {}.propertyIsEnumerable;

/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

  // 7.2.2 IsArray(argument)
  var cof = __webpack_require__(11);
  module.exports = Array.isArray || function isArray(arg){
    return cof(arg) == 'Array';
  };

/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

  // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
  var toIObject = __webpack_require__(9)
    , gOPN      = __webpack_require__(77).f
    , toString  = {}.toString;

  var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
    ? Object.getOwnPropertyNames(window) : [];

  var getWindowNames = function(it){
    try {
      return gOPN(it);
    } catch(e){
      return windowNames.slice();
    }
  };

  module.exports.f = function getOwnPropertyNames(it){
    return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));
  };


/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

  // 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
  var $keys      = __webpack_require__(36)
    , hiddenKeys = __webpack_require__(44).concat('length', 'prototype');

  exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O){
    return $keys(O, hiddenKeys);
  };

/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

  var pIE            = __webpack_require__(74)
    , createDesc     = __webpack_require__(29)
    , toIObject      = __webpack_require__(9)
    , toPrimitive    = __webpack_require__(28)
    , has            = __webpack_require__(31)
    , IE8_DOM_DEFINE = __webpack_require__(24)
    , gOPD           = Object.getOwnPropertyDescriptor;

  exports.f = __webpack_require__(25) ? gOPD : function getOwnPropertyDescriptor(O, P){
    O = toIObject(O);
    P = toPrimitive(P, true);
    if(IE8_DOM_DEFINE)try {
      return gOPD(O, P);
    } catch(e){ /* empty */ }
    if(has(O, P))return createDesc(!pIE.f.call(O, P), O[P]);
  };

/***/ },
/* 79 */
/***/ function(module, exports) {

  

/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(70)('asyncIterator');

/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(70)('observable');

/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(83), __esModule: true };

/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

  var core  = __webpack_require__(17)
    , $JSON = core.JSON || (core.JSON = {stringify: JSON.stringify});
  module.exports = function stringify(it){ // eslint-disable-line no-unused-vars
    return $JSON.stringify.apply($JSON, arguments);
  };

/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  // first check if moment.js is already loaded in the browser window, if so,
  // use this instance. Else, load via commonjs.
  module.exports = typeof window !== 'undefined' && window['moment'] || __webpack_require__(85);

/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

  /* WEBPACK VAR INJECTION */(function(module) {//! moment.js
  //! version : 2.17.1
  //! authors : Tim Wood, Iskren Chernev, Moment.js contributors
  //! license : MIT
  //! momentjs.com

  ;(function (global, factory) {
       true ? module.exports = factory() :
      typeof define === 'function' && define.amd ? define(factory) :
      global.moment = factory()
  }(this, (function () { 'use strict';

  var hookCallback;

  function hooks () {
      return hookCallback.apply(null, arguments);
  }

  // This is done to register the method called with moment()
  // without creating circular dependencies.
  function setHookCallback (callback) {
      hookCallback = callback;
  }

  function isArray(input) {
      return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
  }

  function isObject(input) {
      // IE8 will treat undefined and null as object if it wasn't for
      // input != null
      return input != null && Object.prototype.toString.call(input) === '[object Object]';
  }

  function isObjectEmpty(obj) {
      var k;
      for (k in obj) {
          // even if its not own property I'd still call it non-empty
          return false;
      }
      return true;
  }

  function isNumber(input) {
      return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
  }

  function isDate(input) {
      return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
  }

  function map(arr, fn) {
      var res = [], i;
      for (i = 0; i < arr.length; ++i) {
          res.push(fn(arr[i], i));
      }
      return res;
  }

  function hasOwnProp(a, b) {
      return Object.prototype.hasOwnProperty.call(a, b);
  }

  function extend(a, b) {
      for (var i in b) {
          if (hasOwnProp(b, i)) {
              a[i] = b[i];
          }
      }

      if (hasOwnProp(b, 'toString')) {
          a.toString = b.toString;
      }

      if (hasOwnProp(b, 'valueOf')) {
          a.valueOf = b.valueOf;
      }

      return a;
  }

  function createUTC (input, format, locale, strict) {
      return createLocalOrUTC(input, format, locale, strict, true).utc();
  }

  function defaultParsingFlags() {
      // We need to deep clone this object.
      return {
          empty           : false,
          unusedTokens    : [],
          unusedInput     : [],
          overflow        : -2,
          charsLeftOver   : 0,
          nullInput       : false,
          invalidMonth    : null,
          invalidFormat   : false,
          userInvalidated : false,
          iso             : false,
          parsedDateParts : [],
          meridiem        : null
      };
  }

  function getParsingFlags(m) {
      if (m._pf == null) {
          m._pf = defaultParsingFlags();
      }
      return m._pf;
  }

  var some;
  if (Array.prototype.some) {
      some = Array.prototype.some;
  } else {
      some = function (fun) {
          var t = Object(this);
          var len = t.length >>> 0;

          for (var i = 0; i < len; i++) {
              if (i in t && fun.call(this, t[i], i, t)) {
                  return true;
              }
          }

          return false;
      };
  }

  var some$1 = some;

  function isValid(m) {
      if (m._isValid == null) {
          var flags = getParsingFlags(m);
          var parsedParts = some$1.call(flags.parsedDateParts, function (i) {
              return i != null;
          });
          var isNowValid = !isNaN(m._d.getTime()) &&
              flags.overflow < 0 &&
              !flags.empty &&
              !flags.invalidMonth &&
              !flags.invalidWeekday &&
              !flags.nullInput &&
              !flags.invalidFormat &&
              !flags.userInvalidated &&
              (!flags.meridiem || (flags.meridiem && parsedParts));

          if (m._strict) {
              isNowValid = isNowValid &&
                  flags.charsLeftOver === 0 &&
                  flags.unusedTokens.length === 0 &&
                  flags.bigHour === undefined;
          }

          if (Object.isFrozen == null || !Object.isFrozen(m)) {
              m._isValid = isNowValid;
          }
          else {
              return isNowValid;
          }
      }
      return m._isValid;
  }

  function createInvalid (flags) {
      var m = createUTC(NaN);
      if (flags != null) {
          extend(getParsingFlags(m), flags);
      }
      else {
          getParsingFlags(m).userInvalidated = true;
      }

      return m;
  }

  function isUndefined(input) {
      return input === void 0;
  }

  // Plugins that add properties should also add the key here (null value),
  // so we can properly clone ourselves.
  var momentProperties = hooks.momentProperties = [];

  function copyConfig(to, from) {
      var i, prop, val;

      if (!isUndefined(from._isAMomentObject)) {
          to._isAMomentObject = from._isAMomentObject;
      }
      if (!isUndefined(from._i)) {
          to._i = from._i;
      }
      if (!isUndefined(from._f)) {
          to._f = from._f;
      }
      if (!isUndefined(from._l)) {
          to._l = from._l;
      }
      if (!isUndefined(from._strict)) {
          to._strict = from._strict;
      }
      if (!isUndefined(from._tzm)) {
          to._tzm = from._tzm;
      }
      if (!isUndefined(from._isUTC)) {
          to._isUTC = from._isUTC;
      }
      if (!isUndefined(from._offset)) {
          to._offset = from._offset;
      }
      if (!isUndefined(from._pf)) {
          to._pf = getParsingFlags(from);
      }
      if (!isUndefined(from._locale)) {
          to._locale = from._locale;
      }

      if (momentProperties.length > 0) {
          for (i in momentProperties) {
              prop = momentProperties[i];
              val = from[prop];
              if (!isUndefined(val)) {
                  to[prop] = val;
              }
          }
      }

      return to;
  }

  var updateInProgress = false;

  // Moment prototype object
  function Moment(config) {
      copyConfig(this, config);
      this._d = new Date(config._d != null ? config._d.getTime() : NaN);
      if (!this.isValid()) {
          this._d = new Date(NaN);
      }
      // Prevent infinite loop in case updateOffset creates new moment
      // objects.
      if (updateInProgress === false) {
          updateInProgress = true;
          hooks.updateOffset(this);
          updateInProgress = false;
      }
  }

  function isMoment (obj) {
      return obj instanceof Moment || (obj != null && obj._isAMomentObject != null);
  }

  function absFloor (number) {
      if (number < 0) {
          // -0 -> 0
          return Math.ceil(number) || 0;
      } else {
          return Math.floor(number);
      }
  }

  function toInt(argumentForCoercion) {
      var coercedNumber = +argumentForCoercion,
          value = 0;

      if (coercedNumber !== 0 && isFinite(coercedNumber)) {
          value = absFloor(coercedNumber);
      }

      return value;
  }

  // compare two arrays, return the number of differences
  function compareArrays(array1, array2, dontConvert) {
      var len = Math.min(array1.length, array2.length),
          lengthDiff = Math.abs(array1.length - array2.length),
          diffs = 0,
          i;
      for (i = 0; i < len; i++) {
          if ((dontConvert && array1[i] !== array2[i]) ||
              (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))) {
              diffs++;
          }
      }
      return diffs + lengthDiff;
  }

  function warn(msg) {
      if (hooks.suppressDeprecationWarnings === false &&
              (typeof console !==  'undefined') && console.warn) {
          console.warn('Deprecation warning: ' + msg);
      }
  }

  function deprecate(msg, fn) {
      var firstTime = true;

      return extend(function () {
          if (hooks.deprecationHandler != null) {
              hooks.deprecationHandler(null, msg);
          }
          if (firstTime) {
              var args = [];
              var arg;
              for (var i = 0; i < arguments.length; i++) {
                  arg = '';
                  if (typeof arguments[i] === 'object') {
                      arg += '\n[' + i + '] ';
                      for (var key in arguments[0]) {
                          arg += key + ': ' + arguments[0][key] + ', ';
                      }
                      arg = arg.slice(0, -2); // Remove trailing comma and space
                  } else {
                      arg = arguments[i];
                  }
                  args.push(arg);
              }
              warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + (new Error()).stack);
              firstTime = false;
          }
          return fn.apply(this, arguments);
      }, fn);
  }

  var deprecations = {};

  function deprecateSimple(name, msg) {
      if (hooks.deprecationHandler != null) {
          hooks.deprecationHandler(name, msg);
      }
      if (!deprecations[name]) {
          warn(msg);
          deprecations[name] = true;
      }
  }

  hooks.suppressDeprecationWarnings = false;
  hooks.deprecationHandler = null;

  function isFunction(input) {
      return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
  }

  function set (config) {
      var prop, i;
      for (i in config) {
          prop = config[i];
          if (isFunction(prop)) {
              this[i] = prop;
          } else {
              this['_' + i] = prop;
          }
      }
      this._config = config;
      // Lenient ordinal parsing accepts just a number in addition to
      // number + (possibly) stuff coming from _ordinalParseLenient.
      this._ordinalParseLenient = new RegExp(this._ordinalParse.source + '|' + (/\d{1,2}/).source);
  }

  function mergeConfigs(parentConfig, childConfig) {
      var res = extend({}, parentConfig), prop;
      for (prop in childConfig) {
          if (hasOwnProp(childConfig, prop)) {
              if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
                  res[prop] = {};
                  extend(res[prop], parentConfig[prop]);
                  extend(res[prop], childConfig[prop]);
              } else if (childConfig[prop] != null) {
                  res[prop] = childConfig[prop];
              } else {
                  delete res[prop];
              }
          }
      }
      for (prop in parentConfig) {
          if (hasOwnProp(parentConfig, prop) &&
                  !hasOwnProp(childConfig, prop) &&
                  isObject(parentConfig[prop])) {
              // make sure changes to properties don't modify parent config
              res[prop] = extend({}, res[prop]);
          }
      }
      return res;
  }

  function Locale(config) {
      if (config != null) {
          this.set(config);
      }
  }

  var keys;

  if (Object.keys) {
      keys = Object.keys;
  } else {
      keys = function (obj) {
          var i, res = [];
          for (i in obj) {
              if (hasOwnProp(obj, i)) {
                  res.push(i);
              }
          }
          return res;
      };
  }

  var keys$1 = keys;

  var defaultCalendar = {
      sameDay : '[Today at] LT',
      nextDay : '[Tomorrow at] LT',
      nextWeek : 'dddd [at] LT',
      lastDay : '[Yesterday at] LT',
      lastWeek : '[Last] dddd [at] LT',
      sameElse : 'L'
  };

  function calendar (key, mom, now) {
      var output = this._calendar[key] || this._calendar['sameElse'];
      return isFunction(output) ? output.call(mom, now) : output;
  }

  var defaultLongDateFormat = {
      LTS  : 'h:mm:ss A',
      LT   : 'h:mm A',
      L    : 'MM/DD/YYYY',
      LL   : 'MMMM D, YYYY',
      LLL  : 'MMMM D, YYYY h:mm A',
      LLLL : 'dddd, MMMM D, YYYY h:mm A'
  };

  function longDateFormat (key) {
      var format = this._longDateFormat[key],
          formatUpper = this._longDateFormat[key.toUpperCase()];

      if (format || !formatUpper) {
          return format;
      }

      this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {
          return val.slice(1);
      });

      return this._longDateFormat[key];
  }

  var defaultInvalidDate = 'Invalid date';

  function invalidDate () {
      return this._invalidDate;
  }

  var defaultOrdinal = '%d';
  var defaultOrdinalParse = /\d{1,2}/;

  function ordinal (number) {
      return this._ordinal.replace('%d', number);
  }

  var defaultRelativeTime = {
      future : 'in %s',
      past   : '%s ago',
      s  : 'a few seconds',
      m  : 'a minute',
      mm : '%d minutes',
      h  : 'an hour',
      hh : '%d hours',
      d  : 'a day',
      dd : '%d days',
      M  : 'a month',
      MM : '%d months',
      y  : 'a year',
      yy : '%d years'
  };

  function relativeTime (number, withoutSuffix, string, isFuture) {
      var output = this._relativeTime[string];
      return (isFunction(output)) ?
          output(number, withoutSuffix, string, isFuture) :
          output.replace(/%d/i, number);
  }

  function pastFuture (diff, output) {
      var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
      return isFunction(format) ? format(output) : format.replace(/%s/i, output);
  }

  var aliases = {};

  function addUnitAlias (unit, shorthand) {
      var lowerCase = unit.toLowerCase();
      aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
  }

  function normalizeUnits(units) {
      return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
  }

  function normalizeObjectUnits(inputObject) {
      var normalizedInput = {},
          normalizedProp,
          prop;

      for (prop in inputObject) {
          if (hasOwnProp(inputObject, prop)) {
              normalizedProp = normalizeUnits(prop);
              if (normalizedProp) {
                  normalizedInput[normalizedProp] = inputObject[prop];
              }
          }
      }

      return normalizedInput;
  }

  var priorities = {};

  function addUnitPriority(unit, priority) {
      priorities[unit] = priority;
  }

  function getPrioritizedUnits(unitsObj) {
      var units = [];
      for (var u in unitsObj) {
          units.push({unit: u, priority: priorities[u]});
      }
      units.sort(function (a, b) {
          return a.priority - b.priority;
      });
      return units;
  }

  function makeGetSet (unit, keepTime) {
      return function (value) {
          if (value != null) {
              set$1(this, unit, value);
              hooks.updateOffset(this, keepTime);
              return this;
          } else {
              return get(this, unit);
          }
      };
  }

  function get (mom, unit) {
      return mom.isValid() ?
          mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
  }

  function set$1 (mom, unit, value) {
      if (mom.isValid()) {
          mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
      }
  }

  // MOMENTS

  function stringGet (units) {
      units = normalizeUnits(units);
      if (isFunction(this[units])) {
          return this[units]();
      }
      return this;
  }


  function stringSet (units, value) {
      if (typeof units === 'object') {
          units = normalizeObjectUnits(units);
          var prioritized = getPrioritizedUnits(units);
          for (var i = 0; i < prioritized.length; i++) {
              this[prioritized[i].unit](units[prioritized[i].unit]);
          }
      } else {
          units = normalizeUnits(units);
          if (isFunction(this[units])) {
              return this[units](value);
          }
      }
      return this;
  }

  function zeroFill(number, targetLength, forceSign) {
      var absNumber = '' + Math.abs(number),
          zerosToFill = targetLength - absNumber.length,
          sign = number >= 0;
      return (sign ? (forceSign ? '+' : '') : '-') +
          Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
  }

  var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;

  var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;

  var formatFunctions = {};

  var formatTokenFunctions = {};

  // token:    'M'
  // padded:   ['MM', 2]
  // ordinal:  'Mo'
  // callback: function () { this.month() + 1 }
  function addFormatToken (token, padded, ordinal, callback) {
      var func = callback;
      if (typeof callback === 'string') {
          func = function () {
              return this[callback]();
          };
      }
      if (token) {
          formatTokenFunctions[token] = func;
      }
      if (padded) {
          formatTokenFunctions[padded[0]] = function () {
              return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
          };
      }
      if (ordinal) {
          formatTokenFunctions[ordinal] = function () {
              return this.localeData().ordinal(func.apply(this, arguments), token);
          };
      }
  }

  function removeFormattingTokens(input) {
      if (input.match(/\[[\s\S]/)) {
          return input.replace(/^\[|\]$/g, '');
      }
      return input.replace(/\\/g, '');
  }

  function makeFormatFunction(format) {
      var array = format.match(formattingTokens), i, length;

      for (i = 0, length = array.length; i < length; i++) {
          if (formatTokenFunctions[array[i]]) {
              array[i] = formatTokenFunctions[array[i]];
          } else {
              array[i] = removeFormattingTokens(array[i]);
          }
      }

      return function (mom) {
          var output = '', i;
          for (i = 0; i < length; i++) {
              output += array[i] instanceof Function ? array[i].call(mom, format) : array[i];
          }
          return output;
      };
  }

  // format date using native date object
  function formatMoment(m, format) {
      if (!m.isValid()) {
          return m.localeData().invalidDate();
      }

      format = expandFormat(format, m.localeData());
      formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);

      return formatFunctions[format](m);
  }

  function expandFormat(format, locale) {
      var i = 5;

      function replaceLongDateFormatTokens(input) {
          return locale.longDateFormat(input) || input;
      }

      localFormattingTokens.lastIndex = 0;
      while (i >= 0 && localFormattingTokens.test(format)) {
          format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
          localFormattingTokens.lastIndex = 0;
          i -= 1;
      }

      return format;
  }

  var match1         = /\d/;            //       0 - 9
  var match2         = /\d\d/;          //      00 - 99
  var match3         = /\d{3}/;         //     000 - 999
  var match4         = /\d{4}/;         //    0000 - 9999
  var match6         = /[+-]?\d{6}/;    // -999999 - 999999
  var match1to2      = /\d\d?/;         //       0 - 99
  var match3to4      = /\d\d\d\d?/;     //     999 - 9999
  var match5to6      = /\d\d\d\d\d\d?/; //   99999 - 999999
  var match1to3      = /\d{1,3}/;       //       0 - 999
  var match1to4      = /\d{1,4}/;       //       0 - 9999
  var match1to6      = /[+-]?\d{1,6}/;  // -999999 - 999999

  var matchUnsigned  = /\d+/;           //       0 - inf
  var matchSigned    = /[+-]?\d+/;      //    -inf - inf

  var matchOffset    = /Z|[+-]\d\d:?\d\d/gi; // +00:00 -00:00 +0000 -0000 or Z
  var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z

  var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/; // 123456789 123456789.123

  // any word (or two) characters or numbers including two/three word month in arabic.
  // includes scottish gaelic two word and hyphenated months
  var matchWord = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i;


  var regexes = {};

  function addRegexToken (token, regex, strictRegex) {
      regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
          return (isStrict && strictRegex) ? strictRegex : regex;
      };
  }

  function getParseRegexForToken (token, config) {
      if (!hasOwnProp(regexes, token)) {
          return new RegExp(unescapeFormat(token));
      }

      return regexes[token](config._strict, config._locale);
  }

  // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
  function unescapeFormat(s) {
      return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
          return p1 || p2 || p3 || p4;
      }));
  }

  function regexEscape(s) {
      return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
  }

  var tokens = {};

  function addParseToken (token, callback) {
      var i, func = callback;
      if (typeof token === 'string') {
          token = [token];
      }
      if (isNumber(callback)) {
          func = function (input, array) {
              array[callback] = toInt(input);
          };
      }
      for (i = 0; i < token.length; i++) {
          tokens[token[i]] = func;
      }
  }

  function addWeekParseToken (token, callback) {
      addParseToken(token, function (input, array, config, token) {
          config._w = config._w || {};
          callback(input, config._w, config, token);
      });
  }

  function addTimeToArrayFromToken(token, input, config) {
      if (input != null && hasOwnProp(tokens, token)) {
          tokens[token](input, config._a, config, token);
      }
  }

  var YEAR = 0;
  var MONTH = 1;
  var DATE = 2;
  var HOUR = 3;
  var MINUTE = 4;
  var SECOND = 5;
  var MILLISECOND = 6;
  var WEEK = 7;
  var WEEKDAY = 8;

  var indexOf;

  if (Array.prototype.indexOf) {
      indexOf = Array.prototype.indexOf;
  } else {
      indexOf = function (o) {
          // I know
          var i;
          for (i = 0; i < this.length; ++i) {
              if (this[i] === o) {
                  return i;
              }
          }
          return -1;
      };
  }

  var indexOf$1 = indexOf;

  function daysInMonth(year, month) {
      return new Date(Date.UTC(year, month + 1, 0)).getUTCDate();
  }

  // FORMATTING

  addFormatToken('M', ['MM', 2], 'Mo', function () {
      return this.month() + 1;
  });

  addFormatToken('MMM', 0, 0, function (format) {
      return this.localeData().monthsShort(this, format);
  });

  addFormatToken('MMMM', 0, 0, function (format) {
      return this.localeData().months(this, format);
  });

  // ALIASES

  addUnitAlias('month', 'M');

  // PRIORITY

  addUnitPriority('month', 8);

  // PARSING

  addRegexToken('M',    match1to2);
  addRegexToken('MM',   match1to2, match2);
  addRegexToken('MMM',  function (isStrict, locale) {
      return locale.monthsShortRegex(isStrict);
  });
  addRegexToken('MMMM', function (isStrict, locale) {
      return locale.monthsRegex(isStrict);
  });

  addParseToken(['M', 'MM'], function (input, array) {
      array[MONTH] = toInt(input) - 1;
  });

  addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
      var month = config._locale.monthsParse(input, token, config._strict);
      // if we didn't find a month name, mark the date as invalid.
      if (month != null) {
          array[MONTH] = month;
      } else {
          getParsingFlags(config).invalidMonth = input;
      }
  });

  // LOCALES

  var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;
  var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');
  function localeMonths (m, format) {
      if (!m) {
          return this._months;
      }
      return isArray(this._months) ? this._months[m.month()] :
          this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
  }

  var defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');
  function localeMonthsShort (m, format) {
      if (!m) {
          return this._monthsShort;
      }
      return isArray(this._monthsShort) ? this._monthsShort[m.month()] :
          this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
  }

  function handleStrictParse(monthName, format, strict) {
      var i, ii, mom, llc = monthName.toLocaleLowerCase();
      if (!this._monthsParse) {
          // this is not used
          this._monthsParse = [];
          this._longMonthsParse = [];
          this._shortMonthsParse = [];
          for (i = 0; i < 12; ++i) {
              mom = createUTC([2000, i]);
              this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
              this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
          }
      }

      if (strict) {
          if (format === 'MMM') {
              ii = indexOf$1.call(this._shortMonthsParse, llc);
              return ii !== -1 ? ii : null;
          } else {
              ii = indexOf$1.call(this._longMonthsParse, llc);
              return ii !== -1 ? ii : null;
          }
      } else {
          if (format === 'MMM') {
              ii = indexOf$1.call(this._shortMonthsParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._longMonthsParse, llc);
              return ii !== -1 ? ii : null;
          } else {
              ii = indexOf$1.call(this._longMonthsParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._shortMonthsParse, llc);
              return ii !== -1 ? ii : null;
          }
      }
  }

  function localeMonthsParse (monthName, format, strict) {
      var i, mom, regex;

      if (this._monthsParseExact) {
          return handleStrictParse.call(this, monthName, format, strict);
      }

      if (!this._monthsParse) {
          this._monthsParse = [];
          this._longMonthsParse = [];
          this._shortMonthsParse = [];
      }

      // TODO: add sorting
      // Sorting makes sure if one month (or abbr) is a prefix of another
      // see sorting in computeMonthsParse
      for (i = 0; i < 12; i++) {
          // make the regex if we don't have it already
          mom = createUTC([2000, i]);
          if (strict && !this._longMonthsParse[i]) {
              this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
              this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
          }
          if (!strict && !this._monthsParse[i]) {
              regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
              this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
          }
          // test the regex
          if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
              return i;
          } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
              return i;
          } else if (!strict && this._monthsParse[i].test(monthName)) {
              return i;
          }
      }
  }

  // MOMENTS

  function setMonth (mom, value) {
      var dayOfMonth;

      if (!mom.isValid()) {
          // No op
          return mom;
      }

      if (typeof value === 'string') {
          if (/^\d+$/.test(value)) {
              value = toInt(value);
          } else {
              value = mom.localeData().monthsParse(value);
              // TODO: Another silent failure?
              if (!isNumber(value)) {
                  return mom;
              }
          }
      }

      dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
      mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
      return mom;
  }

  function getSetMonth (value) {
      if (value != null) {
          setMonth(this, value);
          hooks.updateOffset(this, true);
          return this;
      } else {
          return get(this, 'Month');
      }
  }

  function getDaysInMonth () {
      return daysInMonth(this.year(), this.month());
  }

  var defaultMonthsShortRegex = matchWord;
  function monthsShortRegex (isStrict) {
      if (this._monthsParseExact) {
          if (!hasOwnProp(this, '_monthsRegex')) {
              computeMonthsParse.call(this);
          }
          if (isStrict) {
              return this._monthsShortStrictRegex;
          } else {
              return this._monthsShortRegex;
          }
      } else {
          if (!hasOwnProp(this, '_monthsShortRegex')) {
              this._monthsShortRegex = defaultMonthsShortRegex;
          }
          return this._monthsShortStrictRegex && isStrict ?
              this._monthsShortStrictRegex : this._monthsShortRegex;
      }
  }

  var defaultMonthsRegex = matchWord;
  function monthsRegex (isStrict) {
      if (this._monthsParseExact) {
          if (!hasOwnProp(this, '_monthsRegex')) {
              computeMonthsParse.call(this);
          }
          if (isStrict) {
              return this._monthsStrictRegex;
          } else {
              return this._monthsRegex;
          }
      } else {
          if (!hasOwnProp(this, '_monthsRegex')) {
              this._monthsRegex = defaultMonthsRegex;
          }
          return this._monthsStrictRegex && isStrict ?
              this._monthsStrictRegex : this._monthsRegex;
      }
  }

  function computeMonthsParse () {
      function cmpLenRev(a, b) {
          return b.length - a.length;
      }

      var shortPieces = [], longPieces = [], mixedPieces = [],
          i, mom;
      for (i = 0; i < 12; i++) {
          // make the regex if we don't have it already
          mom = createUTC([2000, i]);
          shortPieces.push(this.monthsShort(mom, ''));
          longPieces.push(this.months(mom, ''));
          mixedPieces.push(this.months(mom, ''));
          mixedPieces.push(this.monthsShort(mom, ''));
      }
      // Sorting makes sure if one month (or abbr) is a prefix of another it
      // will match the longer piece.
      shortPieces.sort(cmpLenRev);
      longPieces.sort(cmpLenRev);
      mixedPieces.sort(cmpLenRev);
      for (i = 0; i < 12; i++) {
          shortPieces[i] = regexEscape(shortPieces[i]);
          longPieces[i] = regexEscape(longPieces[i]);
      }
      for (i = 0; i < 24; i++) {
          mixedPieces[i] = regexEscape(mixedPieces[i]);
      }

      this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
      this._monthsShortRegex = this._monthsRegex;
      this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
      this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
  }

  // FORMATTING

  addFormatToken('Y', 0, 0, function () {
      var y = this.year();
      return y <= 9999 ? '' + y : '+' + y;
  });

  addFormatToken(0, ['YY', 2], 0, function () {
      return this.year() % 100;
  });

  addFormatToken(0, ['YYYY',   4],       0, 'year');
  addFormatToken(0, ['YYYYY',  5],       0, 'year');
  addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');

  // ALIASES

  addUnitAlias('year', 'y');

  // PRIORITIES

  addUnitPriority('year', 1);

  // PARSING

  addRegexToken('Y',      matchSigned);
  addRegexToken('YY',     match1to2, match2);
  addRegexToken('YYYY',   match1to4, match4);
  addRegexToken('YYYYY',  match1to6, match6);
  addRegexToken('YYYYYY', match1to6, match6);

  addParseToken(['YYYYY', 'YYYYYY'], YEAR);
  addParseToken('YYYY', function (input, array) {
      array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
  });
  addParseToken('YY', function (input, array) {
      array[YEAR] = hooks.parseTwoDigitYear(input);
  });
  addParseToken('Y', function (input, array) {
      array[YEAR] = parseInt(input, 10);
  });

  // HELPERS

  function daysInYear(year) {
      return isLeapYear(year) ? 366 : 365;
  }

  function isLeapYear(year) {
      return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
  }

  // HOOKS

  hooks.parseTwoDigitYear = function (input) {
      return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
  };

  // MOMENTS

  var getSetYear = makeGetSet('FullYear', true);

  function getIsLeapYear () {
      return isLeapYear(this.year());
  }

  function createDate (y, m, d, h, M, s, ms) {
      //can't just apply() to create a date:
      //http://stackoverflow.com/questions/181348/instantiating-a-javascript-object-by-calling-prototype-constructor-apply
      var date = new Date(y, m, d, h, M, s, ms);

      //the date constructor remaps years 0-99 to 1900-1999
      if (y < 100 && y >= 0 && isFinite(date.getFullYear())) {
          date.setFullYear(y);
      }
      return date;
  }

  function createUTCDate (y) {
      var date = new Date(Date.UTC.apply(null, arguments));

      //the Date.UTC function remaps years 0-99 to 1900-1999
      if (y < 100 && y >= 0 && isFinite(date.getUTCFullYear())) {
          date.setUTCFullYear(y);
      }
      return date;
  }

  // start-of-first-week - start-of-year
  function firstWeekOffset(year, dow, doy) {
      var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
          fwd = 7 + dow - doy,
          // first-week day local weekday -- which local weekday is fwd
          fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;

      return -fwdlw + fwd - 1;
  }

  //http://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
  function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
      var localWeekday = (7 + weekday - dow) % 7,
          weekOffset = firstWeekOffset(year, dow, doy),
          dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
          resYear, resDayOfYear;

      if (dayOfYear <= 0) {
          resYear = year - 1;
          resDayOfYear = daysInYear(resYear) + dayOfYear;
      } else if (dayOfYear > daysInYear(year)) {
          resYear = year + 1;
          resDayOfYear = dayOfYear - daysInYear(year);
      } else {
          resYear = year;
          resDayOfYear = dayOfYear;
      }

      return {
          year: resYear,
          dayOfYear: resDayOfYear
      };
  }

  function weekOfYear(mom, dow, doy) {
      var weekOffset = firstWeekOffset(mom.year(), dow, doy),
          week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
          resWeek, resYear;

      if (week < 1) {
          resYear = mom.year() - 1;
          resWeek = week + weeksInYear(resYear, dow, doy);
      } else if (week > weeksInYear(mom.year(), dow, doy)) {
          resWeek = week - weeksInYear(mom.year(), dow, doy);
          resYear = mom.year() + 1;
      } else {
          resYear = mom.year();
          resWeek = week;
      }

      return {
          week: resWeek,
          year: resYear
      };
  }

  function weeksInYear(year, dow, doy) {
      var weekOffset = firstWeekOffset(year, dow, doy),
          weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
      return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
  }

  // FORMATTING

  addFormatToken('w', ['ww', 2], 'wo', 'week');
  addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

  // ALIASES

  addUnitAlias('week', 'w');
  addUnitAlias('isoWeek', 'W');

  // PRIORITIES

  addUnitPriority('week', 5);
  addUnitPriority('isoWeek', 5);

  // PARSING

  addRegexToken('w',  match1to2);
  addRegexToken('ww', match1to2, match2);
  addRegexToken('W',  match1to2);
  addRegexToken('WW', match1to2, match2);

  addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
      week[token.substr(0, 1)] = toInt(input);
  });

  // HELPERS

  // LOCALES

  function localeWeek (mom) {
      return weekOfYear(mom, this._week.dow, this._week.doy).week;
  }

  var defaultLocaleWeek = {
      dow : 0, // Sunday is the first day of the week.
      doy : 6  // The week that contains Jan 1st is the first week of the year.
  };

  function localeFirstDayOfWeek () {
      return this._week.dow;
  }

  function localeFirstDayOfYear () {
      return this._week.doy;
  }

  // MOMENTS

  function getSetWeek (input) {
      var week = this.localeData().week(this);
      return input == null ? week : this.add((input - week) * 7, 'd');
  }

  function getSetISOWeek (input) {
      var week = weekOfYear(this, 1, 4).week;
      return input == null ? week : this.add((input - week) * 7, 'd');
  }

  // FORMATTING

  addFormatToken('d', 0, 'do', 'day');

  addFormatToken('dd', 0, 0, function (format) {
      return this.localeData().weekdaysMin(this, format);
  });

  addFormatToken('ddd', 0, 0, function (format) {
      return this.localeData().weekdaysShort(this, format);
  });

  addFormatToken('dddd', 0, 0, function (format) {
      return this.localeData().weekdays(this, format);
  });

  addFormatToken('e', 0, 0, 'weekday');
  addFormatToken('E', 0, 0, 'isoWeekday');

  // ALIASES

  addUnitAlias('day', 'd');
  addUnitAlias('weekday', 'e');
  addUnitAlias('isoWeekday', 'E');

  // PRIORITY
  addUnitPriority('day', 11);
  addUnitPriority('weekday', 11);
  addUnitPriority('isoWeekday', 11);

  // PARSING

  addRegexToken('d',    match1to2);
  addRegexToken('e',    match1to2);
  addRegexToken('E',    match1to2);
  addRegexToken('dd',   function (isStrict, locale) {
      return locale.weekdaysMinRegex(isStrict);
  });
  addRegexToken('ddd',   function (isStrict, locale) {
      return locale.weekdaysShortRegex(isStrict);
  });
  addRegexToken('dddd',   function (isStrict, locale) {
      return locale.weekdaysRegex(isStrict);
  });

  addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
      var weekday = config._locale.weekdaysParse(input, token, config._strict);
      // if we didn't get a weekday name, mark the date as invalid
      if (weekday != null) {
          week.d = weekday;
      } else {
          getParsingFlags(config).invalidWeekday = input;
      }
  });

  addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
      week[token] = toInt(input);
  });

  // HELPERS

  function parseWeekday(input, locale) {
      if (typeof input !== 'string') {
          return input;
      }

      if (!isNaN(input)) {
          return parseInt(input, 10);
      }

      input = locale.weekdaysParse(input);
      if (typeof input === 'number') {
          return input;
      }

      return null;
  }

  function parseIsoWeekday(input, locale) {
      if (typeof input === 'string') {
          return locale.weekdaysParse(input) % 7 || 7;
      }
      return isNaN(input) ? null : input;
  }

  // LOCALES

  var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');
  function localeWeekdays (m, format) {
      if (!m) {
          return this._weekdays;
      }
      return isArray(this._weekdays) ? this._weekdays[m.day()] :
          this._weekdays[this._weekdays.isFormat.test(format) ? 'format' : 'standalone'][m.day()];
  }

  var defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');
  function localeWeekdaysShort (m) {
      return (m) ? this._weekdaysShort[m.day()] : this._weekdaysShort;
  }

  var defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');
  function localeWeekdaysMin (m) {
      return (m) ? this._weekdaysMin[m.day()] : this._weekdaysMin;
  }

  function handleStrictParse$1(weekdayName, format, strict) {
      var i, ii, mom, llc = weekdayName.toLocaleLowerCase();
      if (!this._weekdaysParse) {
          this._weekdaysParse = [];
          this._shortWeekdaysParse = [];
          this._minWeekdaysParse = [];

          for (i = 0; i < 7; ++i) {
              mom = createUTC([2000, 1]).day(i);
              this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
              this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
              this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
          }
      }

      if (strict) {
          if (format === 'dddd') {
              ii = indexOf$1.call(this._weekdaysParse, llc);
              return ii !== -1 ? ii : null;
          } else if (format === 'ddd') {
              ii = indexOf$1.call(this._shortWeekdaysParse, llc);
              return ii !== -1 ? ii : null;
          } else {
              ii = indexOf$1.call(this._minWeekdaysParse, llc);
              return ii !== -1 ? ii : null;
          }
      } else {
          if (format === 'dddd') {
              ii = indexOf$1.call(this._weekdaysParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._shortWeekdaysParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._minWeekdaysParse, llc);
              return ii !== -1 ? ii : null;
          } else if (format === 'ddd') {
              ii = indexOf$1.call(this._shortWeekdaysParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._weekdaysParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._minWeekdaysParse, llc);
              return ii !== -1 ? ii : null;
          } else {
              ii = indexOf$1.call(this._minWeekdaysParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._weekdaysParse, llc);
              if (ii !== -1) {
                  return ii;
              }
              ii = indexOf$1.call(this._shortWeekdaysParse, llc);
              return ii !== -1 ? ii : null;
          }
      }
  }

  function localeWeekdaysParse (weekdayName, format, strict) {
      var i, mom, regex;

      if (this._weekdaysParseExact) {
          return handleStrictParse$1.call(this, weekdayName, format, strict);
      }

      if (!this._weekdaysParse) {
          this._weekdaysParse = [];
          this._minWeekdaysParse = [];
          this._shortWeekdaysParse = [];
          this._fullWeekdaysParse = [];
      }

      for (i = 0; i < 7; i++) {
          // make the regex if we don't have it already

          mom = createUTC([2000, 1]).day(i);
          if (strict && !this._fullWeekdaysParse[i]) {
              this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\.?') + '$', 'i');
              this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\.?') + '$', 'i');
              this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\.?') + '$', 'i');
          }
          if (!this._weekdaysParse[i]) {
              regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
              this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
          }
          // test the regex
          if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
              return i;
          } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
              return i;
          } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
              return i;
          } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
              return i;
          }
      }
  }

  // MOMENTS

  function getSetDayOfWeek (input) {
      if (!this.isValid()) {
          return input != null ? this : NaN;
      }
      var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
      if (input != null) {
          input = parseWeekday(input, this.localeData());
          return this.add(input - day, 'd');
      } else {
          return day;
      }
  }

  function getSetLocaleDayOfWeek (input) {
      if (!this.isValid()) {
          return input != null ? this : NaN;
      }
      var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
      return input == null ? weekday : this.add(input - weekday, 'd');
  }

  function getSetISODayOfWeek (input) {
      if (!this.isValid()) {
          return input != null ? this : NaN;
      }

      // behaves the same as moment#day except
      // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
      // as a setter, sunday should belong to the previous week.

      if (input != null) {
          var weekday = parseIsoWeekday(input, this.localeData());
          return this.day(this.day() % 7 ? weekday : weekday - 7);
      } else {
          return this.day() || 7;
      }
  }

  var defaultWeekdaysRegex = matchWord;
  function weekdaysRegex (isStrict) {
      if (this._weekdaysParseExact) {
          if (!hasOwnProp(this, '_weekdaysRegex')) {
              computeWeekdaysParse.call(this);
          }
          if (isStrict) {
              return this._weekdaysStrictRegex;
          } else {
              return this._weekdaysRegex;
          }
      } else {
          if (!hasOwnProp(this, '_weekdaysRegex')) {
              this._weekdaysRegex = defaultWeekdaysRegex;
          }
          return this._weekdaysStrictRegex && isStrict ?
              this._weekdaysStrictRegex : this._weekdaysRegex;
      }
  }

  var defaultWeekdaysShortRegex = matchWord;
  function weekdaysShortRegex (isStrict) {
      if (this._weekdaysParseExact) {
          if (!hasOwnProp(this, '_weekdaysRegex')) {
              computeWeekdaysParse.call(this);
          }
          if (isStrict) {
              return this._weekdaysShortStrictRegex;
          } else {
              return this._weekdaysShortRegex;
          }
      } else {
          if (!hasOwnProp(this, '_weekdaysShortRegex')) {
              this._weekdaysShortRegex = defaultWeekdaysShortRegex;
          }
          return this._weekdaysShortStrictRegex && isStrict ?
              this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
      }
  }

  var defaultWeekdaysMinRegex = matchWord;
  function weekdaysMinRegex (isStrict) {
      if (this._weekdaysParseExact) {
          if (!hasOwnProp(this, '_weekdaysRegex')) {
              computeWeekdaysParse.call(this);
          }
          if (isStrict) {
              return this._weekdaysMinStrictRegex;
          } else {
              return this._weekdaysMinRegex;
          }
      } else {
          if (!hasOwnProp(this, '_weekdaysMinRegex')) {
              this._weekdaysMinRegex = defaultWeekdaysMinRegex;
          }
          return this._weekdaysMinStrictRegex && isStrict ?
              this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
      }
  }


  function computeWeekdaysParse () {
      function cmpLenRev(a, b) {
          return b.length - a.length;
      }

      var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [],
          i, mom, minp, shortp, longp;
      for (i = 0; i < 7; i++) {
          // make the regex if we don't have it already
          mom = createUTC([2000, 1]).day(i);
          minp = this.weekdaysMin(mom, '');
          shortp = this.weekdaysShort(mom, '');
          longp = this.weekdays(mom, '');
          minPieces.push(minp);
          shortPieces.push(shortp);
          longPieces.push(longp);
          mixedPieces.push(minp);
          mixedPieces.push(shortp);
          mixedPieces.push(longp);
      }
      // Sorting makes sure if one weekday (or abbr) is a prefix of another it
      // will match the longer piece.
      minPieces.sort(cmpLenRev);
      shortPieces.sort(cmpLenRev);
      longPieces.sort(cmpLenRev);
      mixedPieces.sort(cmpLenRev);
      for (i = 0; i < 7; i++) {
          shortPieces[i] = regexEscape(shortPieces[i]);
          longPieces[i] = regexEscape(longPieces[i]);
          mixedPieces[i] = regexEscape(mixedPieces[i]);
      }

      this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
      this._weekdaysShortRegex = this._weekdaysRegex;
      this._weekdaysMinRegex = this._weekdaysRegex;

      this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
      this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
      this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
  }

  // FORMATTING

  function hFormat() {
      return this.hours() % 12 || 12;
  }

  function kFormat() {
      return this.hours() || 24;
  }

  addFormatToken('H', ['HH', 2], 0, 'hour');
  addFormatToken('h', ['hh', 2], 0, hFormat);
  addFormatToken('k', ['kk', 2], 0, kFormat);

  addFormatToken('hmm', 0, 0, function () {
      return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
  });

  addFormatToken('hmmss', 0, 0, function () {
      return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) +
          zeroFill(this.seconds(), 2);
  });

  addFormatToken('Hmm', 0, 0, function () {
      return '' + this.hours() + zeroFill(this.minutes(), 2);
  });

  addFormatToken('Hmmss', 0, 0, function () {
      return '' + this.hours() + zeroFill(this.minutes(), 2) +
          zeroFill(this.seconds(), 2);
  });

  function meridiem (token, lowercase) {
      addFormatToken(token, 0, 0, function () {
          return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
      });
  }

  meridiem('a', true);
  meridiem('A', false);

  // ALIASES

  addUnitAlias('hour', 'h');

  // PRIORITY
  addUnitPriority('hour', 13);

  // PARSING

  function matchMeridiem (isStrict, locale) {
      return locale._meridiemParse;
  }

  addRegexToken('a',  matchMeridiem);
  addRegexToken('A',  matchMeridiem);
  addRegexToken('H',  match1to2);
  addRegexToken('h',  match1to2);
  addRegexToken('HH', match1to2, match2);
  addRegexToken('hh', match1to2, match2);

  addRegexToken('hmm', match3to4);
  addRegexToken('hmmss', match5to6);
  addRegexToken('Hmm', match3to4);
  addRegexToken('Hmmss', match5to6);

  addParseToken(['H', 'HH'], HOUR);
  addParseToken(['a', 'A'], function (input, array, config) {
      config._isPm = config._locale.isPM(input);
      config._meridiem = input;
  });
  addParseToken(['h', 'hh'], function (input, array, config) {
      array[HOUR] = toInt(input);
      getParsingFlags(config).bigHour = true;
  });
  addParseToken('hmm', function (input, array, config) {
      var pos = input.length - 2;
      array[HOUR] = toInt(input.substr(0, pos));
      array[MINUTE] = toInt(input.substr(pos));
      getParsingFlags(config).bigHour = true;
  });
  addParseToken('hmmss', function (input, array, config) {
      var pos1 = input.length - 4;
      var pos2 = input.length - 2;
      array[HOUR] = toInt(input.substr(0, pos1));
      array[MINUTE] = toInt(input.substr(pos1, 2));
      array[SECOND] = toInt(input.substr(pos2));
      getParsingFlags(config).bigHour = true;
  });
  addParseToken('Hmm', function (input, array, config) {
      var pos = input.length - 2;
      array[HOUR] = toInt(input.substr(0, pos));
      array[MINUTE] = toInt(input.substr(pos));
  });
  addParseToken('Hmmss', function (input, array, config) {
      var pos1 = input.length - 4;
      var pos2 = input.length - 2;
      array[HOUR] = toInt(input.substr(0, pos1));
      array[MINUTE] = toInt(input.substr(pos1, 2));
      array[SECOND] = toInt(input.substr(pos2));
  });

  // LOCALES

  function localeIsPM (input) {
      // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
      // Using charAt should be more compatible.
      return ((input + '').toLowerCase().charAt(0) === 'p');
  }

  var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;
  function localeMeridiem (hours, minutes, isLower) {
      if (hours > 11) {
          return isLower ? 'pm' : 'PM';
      } else {
          return isLower ? 'am' : 'AM';
      }
  }


  // MOMENTS

  // Setting the hour should keep the time, because the user explicitly
  // specified which hour he wants. So trying to maintain the same hour (in
  // a new timezone) makes sense. Adding/subtracting hours does not follow
  // this rule.
  var getSetHour = makeGetSet('Hours', true);

  // months
  // week
  // weekdays
  // meridiem
  var baseConfig = {
      calendar: defaultCalendar,
      longDateFormat: defaultLongDateFormat,
      invalidDate: defaultInvalidDate,
      ordinal: defaultOrdinal,
      ordinalParse: defaultOrdinalParse,
      relativeTime: defaultRelativeTime,

      months: defaultLocaleMonths,
      monthsShort: defaultLocaleMonthsShort,

      week: defaultLocaleWeek,

      weekdays: defaultLocaleWeekdays,
      weekdaysMin: defaultLocaleWeekdaysMin,
      weekdaysShort: defaultLocaleWeekdaysShort,

      meridiemParse: defaultLocaleMeridiemParse
  };

  // internal storage for locale config files
  var locales = {};
  var localeFamilies = {};
  var globalLocale;

  function normalizeLocale(key) {
      return key ? key.toLowerCase().replace('_', '-') : key;
  }

  // pick the locale from the array
  // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
  // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
  function chooseLocale(names) {
      var i = 0, j, next, locale, split;

      while (i < names.length) {
          split = normalizeLocale(names[i]).split('-');
          j = split.length;
          next = normalizeLocale(names[i + 1]);
          next = next ? next.split('-') : null;
          while (j > 0) {
              locale = loadLocale(split.slice(0, j).join('-'));
              if (locale) {
                  return locale;
              }
              if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {
                  //the next array item is better than a shallower substring of this one
                  break;
              }
              j--;
          }
          i++;
      }
      return null;
  }

  function loadLocale(name) {
      var oldLocale = null;
      // TODO: Find a better way to register and load all the locales in Node
      if (!locales[name] && (typeof module !== 'undefined') &&
              module && module.exports) {
          try {
              oldLocale = globalLocale._abbr;
              !(function webpackMissingModule() { var e = new Error("Cannot find module \"./locale\""); e.code = 'MODULE_NOT_FOUND'; throw e; }());
              // because defineLocale currently also sets the global locale, we
              // want to undo that for lazy loaded locales
              getSetGlobalLocale(oldLocale);
          } catch (e) { }
      }
      return locales[name];
  }

  // This function will load locale and then set the global locale.  If
  // no arguments are passed in, it will simply return the current global
  // locale key.
  function getSetGlobalLocale (key, values) {
      var data;
      if (key) {
          if (isUndefined(values)) {
              data = getLocale(key);
          }
          else {
              data = defineLocale(key, values);
          }

          if (data) {
              // moment.duration._locale = moment._locale = data;
              globalLocale = data;
          }
      }

      return globalLocale._abbr;
  }

  function defineLocale (name, config) {
      if (config !== null) {
          var parentConfig = baseConfig;
          config.abbr = name;
          if (locales[name] != null) {
              deprecateSimple('defineLocaleOverride',
                      'use moment.updateLocale(localeName, config) to change ' +
                      'an existing locale. moment.defineLocale(localeName, ' +
                      'config) should only be used for creating a new locale ' +
                      'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
              parentConfig = locales[name]._config;
          } else if (config.parentLocale != null) {
              if (locales[config.parentLocale] != null) {
                  parentConfig = locales[config.parentLocale]._config;
              } else {
                  if (!localeFamilies[config.parentLocale]) {
                      localeFamilies[config.parentLocale] = [];
                  }
                  localeFamilies[config.parentLocale].push({
                      name: name,
                      config: config
                  });
                  return null;
              }
          }
          locales[name] = new Locale(mergeConfigs(parentConfig, config));

          if (localeFamilies[name]) {
              localeFamilies[name].forEach(function (x) {
                  defineLocale(x.name, x.config);
              });
          }

          // backwards compat for now: also set the locale
          // make sure we set the locale AFTER all child locales have been
          // created, so we won't end up with the child locale set.
          getSetGlobalLocale(name);


          return locales[name];
      } else {
          // useful for testing
          delete locales[name];
          return null;
      }
  }

  function updateLocale(name, config) {
      if (config != null) {
          var locale, parentConfig = baseConfig;
          // MERGE
          if (locales[name] != null) {
              parentConfig = locales[name]._config;
          }
          config = mergeConfigs(parentConfig, config);
          locale = new Locale(config);
          locale.parentLocale = locales[name];
          locales[name] = locale;

          // backwards compat for now: also set the locale
          getSetGlobalLocale(name);
      } else {
          // pass null for config to unupdate, useful for tests
          if (locales[name] != null) {
              if (locales[name].parentLocale != null) {
                  locales[name] = locales[name].parentLocale;
              } else if (locales[name] != null) {
                  delete locales[name];
              }
          }
      }
      return locales[name];
  }

  // returns locale data
  function getLocale (key) {
      var locale;

      if (key && key._locale && key._locale._abbr) {
          key = key._locale._abbr;
      }

      if (!key) {
          return globalLocale;
      }

      if (!isArray(key)) {
          //short-circuit everything else
          locale = loadLocale(key);
          if (locale) {
              return locale;
          }
          key = [key];
      }

      return chooseLocale(key);
  }

  function listLocales() {
      return keys$1(locales);
  }

  function checkOverflow (m) {
      var overflow;
      var a = m._a;

      if (a && getParsingFlags(m).overflow === -2) {
          overflow =
              a[MONTH]       < 0 || a[MONTH]       > 11  ? MONTH :
              a[DATE]        < 1 || a[DATE]        > daysInMonth(a[YEAR], a[MONTH]) ? DATE :
              a[HOUR]        < 0 || a[HOUR]        > 24 || (a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0)) ? HOUR :
              a[MINUTE]      < 0 || a[MINUTE]      > 59  ? MINUTE :
              a[SECOND]      < 0 || a[SECOND]      > 59  ? SECOND :
              a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND :
              -1;

          if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
              overflow = DATE;
          }
          if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
              overflow = WEEK;
          }
          if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
              overflow = WEEKDAY;
          }

          getParsingFlags(m).overflow = overflow;
      }

      return m;
  }

  // iso 8601 regex
  // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
  var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
  var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;

  var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;

  var isoDates = [
      ['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/],
      ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/],
      ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/],
      ['GGGG-[W]WW', /\d{4}-W\d\d/, false],
      ['YYYY-DDD', /\d{4}-\d{3}/],
      ['YYYY-MM', /\d{4}-\d\d/, false],
      ['YYYYYYMMDD', /[+-]\d{10}/],
      ['YYYYMMDD', /\d{8}/],
      // YYYYMM is NOT allowed by the standard
      ['GGGG[W]WWE', /\d{4}W\d{3}/],
      ['GGGG[W]WW', /\d{4}W\d{2}/, false],
      ['YYYYDDD', /\d{7}/]
  ];

  // iso time formats and regexes
  var isoTimes = [
      ['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/],
      ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/],
      ['HH:mm:ss', /\d\d:\d\d:\d\d/],
      ['HH:mm', /\d\d:\d\d/],
      ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/],
      ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/],
      ['HHmmss', /\d\d\d\d\d\d/],
      ['HHmm', /\d\d\d\d/],
      ['HH', /\d\d/]
  ];

  var aspNetJsonRegex = /^\/?Date\((\-?\d+)/i;

  // date from iso format
  function configFromISO(config) {
      var i, l,
          string = config._i,
          match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
          allowTime, dateFormat, timeFormat, tzFormat;

      if (match) {
          getParsingFlags(config).iso = true;

          for (i = 0, l = isoDates.length; i < l; i++) {
              if (isoDates[i][1].exec(match[1])) {
                  dateFormat = isoDates[i][0];
                  allowTime = isoDates[i][2] !== false;
                  break;
              }
          }
          if (dateFormat == null) {
              config._isValid = false;
              return;
          }
          if (match[3]) {
              for (i = 0, l = isoTimes.length; i < l; i++) {
                  if (isoTimes[i][1].exec(match[3])) {
                      // match[2] should be 'T' or space
                      timeFormat = (match[2] || ' ') + isoTimes[i][0];
                      break;
                  }
              }
              if (timeFormat == null) {
                  config._isValid = false;
                  return;
              }
          }
          if (!allowTime && timeFormat != null) {
              config._isValid = false;
              return;
          }
          if (match[4]) {
              if (tzRegex.exec(match[4])) {
                  tzFormat = 'Z';
              } else {
                  config._isValid = false;
                  return;
              }
          }
          config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
          configFromStringAndFormat(config);
      } else {
          config._isValid = false;
      }
  }

  // date from iso format or fallback
  function configFromString(config) {
      var matched = aspNetJsonRegex.exec(config._i);

      if (matched !== null) {
          config._d = new Date(+matched[1]);
          return;
      }

      configFromISO(config);
      if (config._isValid === false) {
          delete config._isValid;
          hooks.createFromInputFallback(config);
      }
  }

  hooks.createFromInputFallback = deprecate(
      'value provided is not in a recognized ISO format. moment construction falls back to js Date(), ' +
      'which is not reliable across all browsers and versions. Non ISO date formats are ' +
      'discouraged and will be removed in an upcoming major release. Please refer to ' +
      'http://momentjs.com/guides/#/warnings/js-date/ for more info.',
      function (config) {
          config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
      }
  );

  // Pick the first defined of two or three arguments.
  function defaults(a, b, c) {
      if (a != null) {
          return a;
      }
      if (b != null) {
          return b;
      }
      return c;
  }

  function currentDateArray(config) {
      // hooks is actually the exported moment object
      var nowValue = new Date(hooks.now());
      if (config._useUTC) {
          return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
      }
      return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
  }

  // convert an array to a date.
  // the array should mirror the parameters below
  // note: all values past the year are optional and will default to the lowest possible value.
  // [year, month, day , hour, minute, second, millisecond]
  function configFromArray (config) {
      var i, date, input = [], currentDate, yearToUse;

      if (config._d) {
          return;
      }

      currentDate = currentDateArray(config);

      //compute day of the year from weeks and weekdays
      if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
          dayOfYearFromWeekInfo(config);
      }

      //if the day of the year is set, figure out what it is
      if (config._dayOfYear) {
          yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

          if (config._dayOfYear > daysInYear(yearToUse)) {
              getParsingFlags(config)._overflowDayOfYear = true;
          }

          date = createUTCDate(yearToUse, 0, config._dayOfYear);
          config._a[MONTH] = date.getUTCMonth();
          config._a[DATE] = date.getUTCDate();
      }

      // Default to current date.
      // * if no year, month, day of month are given, default to today
      // * if day of month is given, default month and year
      // * if month is given, default only year
      // * if year is given, don't default anything
      for (i = 0; i < 3 && config._a[i] == null; ++i) {
          config._a[i] = input[i] = currentDate[i];
      }

      // Zero out whatever was not defaulted, including time
      for (; i < 7; i++) {
          config._a[i] = input[i] = (config._a[i] == null) ? (i === 2 ? 1 : 0) : config._a[i];
      }

      // Check for 24:00:00.000
      if (config._a[HOUR] === 24 &&
              config._a[MINUTE] === 0 &&
              config._a[SECOND] === 0 &&
              config._a[MILLISECOND] === 0) {
          config._nextDay = true;
          config._a[HOUR] = 0;
      }

      config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
      // Apply timezone offset from input. The actual utcOffset can be changed
      // with parseZone.
      if (config._tzm != null) {
          config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
      }

      if (config._nextDay) {
          config._a[HOUR] = 24;
      }
  }

  function dayOfYearFromWeekInfo(config) {
      var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;

      w = config._w;
      if (w.GG != null || w.W != null || w.E != null) {
          dow = 1;
          doy = 4;

          // TODO: We need to take the current isoWeekYear, but that depends on
          // how we interpret now (local, utc, fixed offset). So create
          // a now version of current config (take local/utc/offset flags, and
          // create now).
          weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
          week = defaults(w.W, 1);
          weekday = defaults(w.E, 1);
          if (weekday < 1 || weekday > 7) {
              weekdayOverflow = true;
          }
      } else {
          dow = config._locale._week.dow;
          doy = config._locale._week.doy;

          var curWeek = weekOfYear(createLocal(), dow, doy);

          weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);

          // Default to current week.
          week = defaults(w.w, curWeek.week);

          if (w.d != null) {
              // weekday -- low day numbers are considered next week
              weekday = w.d;
              if (weekday < 0 || weekday > 6) {
                  weekdayOverflow = true;
              }
          } else if (w.e != null) {
              // local weekday -- counting starts from begining of week
              weekday = w.e + dow;
              if (w.e < 0 || w.e > 6) {
                  weekdayOverflow = true;
              }
          } else {
              // default to begining of week
              weekday = dow;
          }
      }
      if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
          getParsingFlags(config)._overflowWeeks = true;
      } else if (weekdayOverflow != null) {
          getParsingFlags(config)._overflowWeekday = true;
      } else {
          temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
          config._a[YEAR] = temp.year;
          config._dayOfYear = temp.dayOfYear;
      }
  }

  // constant that refers to the ISO standard
  hooks.ISO_8601 = function () {};

  // date from string and format string
  function configFromStringAndFormat(config) {
      // TODO: Move this to another part of the creation flow to prevent circular deps
      if (config._f === hooks.ISO_8601) {
          configFromISO(config);
          return;
      }

      config._a = [];
      getParsingFlags(config).empty = true;

      // This array is used to make a Date, either with `new Date` or `Date.UTC`
      var string = '' + config._i,
          i, parsedInput, tokens, token, skipped,
          stringLength = string.length,
          totalParsedInputLength = 0;

      tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];

      for (i = 0; i < tokens.length; i++) {
          token = tokens[i];
          parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];
          // console.log('token', token, 'parsedInput', parsedInput,
          //         'regex', getParseRegexForToken(token, config));
          if (parsedInput) {
              skipped = string.substr(0, string.indexOf(parsedInput));
              if (skipped.length > 0) {
                  getParsingFlags(config).unusedInput.push(skipped);
              }
              string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
              totalParsedInputLength += parsedInput.length;
          }
          // don't parse if it's not a known token
          if (formatTokenFunctions[token]) {
              if (parsedInput) {
                  getParsingFlags(config).empty = false;
              }
              else {
                  getParsingFlags(config).unusedTokens.push(token);
              }
              addTimeToArrayFromToken(token, parsedInput, config);
          }
          else if (config._strict && !parsedInput) {
              getParsingFlags(config).unusedTokens.push(token);
          }
      }

      // add remaining unparsed input length to the string
      getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;
      if (string.length > 0) {
          getParsingFlags(config).unusedInput.push(string);
      }

      // clear _12h flag if hour is <= 12
      if (config._a[HOUR] <= 12 &&
          getParsingFlags(config).bigHour === true &&
          config._a[HOUR] > 0) {
          getParsingFlags(config).bigHour = undefined;
      }

      getParsingFlags(config).parsedDateParts = config._a.slice(0);
      getParsingFlags(config).meridiem = config._meridiem;
      // handle meridiem
      config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);

      configFromArray(config);
      checkOverflow(config);
  }


  function meridiemFixWrap (locale, hour, meridiem) {
      var isPm;

      if (meridiem == null) {
          // nothing to do
          return hour;
      }
      if (locale.meridiemHour != null) {
          return locale.meridiemHour(hour, meridiem);
      } else if (locale.isPM != null) {
          // Fallback
          isPm = locale.isPM(meridiem);
          if (isPm && hour < 12) {
              hour += 12;
          }
          if (!isPm && hour === 12) {
              hour = 0;
          }
          return hour;
      } else {
          // this is not supposed to happen
          return hour;
      }
  }

  // date from string and array of format strings
  function configFromStringAndArray(config) {
      var tempConfig,
          bestMoment,

          scoreToBeat,
          i,
          currentScore;

      if (config._f.length === 0) {
          getParsingFlags(config).invalidFormat = true;
          config._d = new Date(NaN);
          return;
      }

      for (i = 0; i < config._f.length; i++) {
          currentScore = 0;
          tempConfig = copyConfig({}, config);
          if (config._useUTC != null) {
              tempConfig._useUTC = config._useUTC;
          }
          tempConfig._f = config._f[i];
          configFromStringAndFormat(tempConfig);

          if (!isValid(tempConfig)) {
              continue;
          }

          // if there is any input that was not parsed add a penalty for that format
          currentScore += getParsingFlags(tempConfig).charsLeftOver;

          //or tokens
          currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;

          getParsingFlags(tempConfig).score = currentScore;

          if (scoreToBeat == null || currentScore < scoreToBeat) {
              scoreToBeat = currentScore;
              bestMoment = tempConfig;
          }
      }

      extend(config, bestMoment || tempConfig);
  }

  function configFromObject(config) {
      if (config._d) {
          return;
      }

      var i = normalizeObjectUnits(config._i);
      config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {
          return obj && parseInt(obj, 10);
      });

      configFromArray(config);
  }

  function createFromConfig (config) {
      var res = new Moment(checkOverflow(prepareConfig(config)));
      if (res._nextDay) {
          // Adding is smart enough around DST
          res.add(1, 'd');
          res._nextDay = undefined;
      }

      return res;
  }

  function prepareConfig (config) {
      var input = config._i,
          format = config._f;

      config._locale = config._locale || getLocale(config._l);

      if (input === null || (format === undefined && input === '')) {
          return createInvalid({nullInput: true});
      }

      if (typeof input === 'string') {
          config._i = input = config._locale.preparse(input);
      }

      if (isMoment(input)) {
          return new Moment(checkOverflow(input));
      } else if (isDate(input)) {
          config._d = input;
      } else if (isArray(format)) {
          configFromStringAndArray(config);
      } else if (format) {
          configFromStringAndFormat(config);
      }  else {
          configFromInput(config);
      }

      if (!isValid(config)) {
          config._d = null;
      }

      return config;
  }

  function configFromInput(config) {
      var input = config._i;
      if (input === undefined) {
          config._d = new Date(hooks.now());
      } else if (isDate(input)) {
          config._d = new Date(input.valueOf());
      } else if (typeof input === 'string') {
          configFromString(config);
      } else if (isArray(input)) {
          config._a = map(input.slice(0), function (obj) {
              return parseInt(obj, 10);
          });
          configFromArray(config);
      } else if (typeof(input) === 'object') {
          configFromObject(config);
      } else if (isNumber(input)) {
          // from milliseconds
          config._d = new Date(input);
      } else {
          hooks.createFromInputFallback(config);
      }
  }

  function createLocalOrUTC (input, format, locale, strict, isUTC) {
      var c = {};

      if (locale === true || locale === false) {
          strict = locale;
          locale = undefined;
      }

      if ((isObject(input) && isObjectEmpty(input)) ||
              (isArray(input) && input.length === 0)) {
          input = undefined;
      }
      // object construction must be done this way.
      // https://github.com/moment/moment/issues/1423
      c._isAMomentObject = true;
      c._useUTC = c._isUTC = isUTC;
      c._l = locale;
      c._i = input;
      c._f = format;
      c._strict = strict;

      return createFromConfig(c);
  }

  function createLocal (input, format, locale, strict) {
      return createLocalOrUTC(input, format, locale, strict, false);
  }

  var prototypeMin = deprecate(
      'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',
      function () {
          var other = createLocal.apply(null, arguments);
          if (this.isValid() && other.isValid()) {
              return other < this ? this : other;
          } else {
              return createInvalid();
          }
      }
  );

  var prototypeMax = deprecate(
      'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',
      function () {
          var other = createLocal.apply(null, arguments);
          if (this.isValid() && other.isValid()) {
              return other > this ? this : other;
          } else {
              return createInvalid();
          }
      }
  );

  // Pick a moment m from moments so that m[fn](other) is true for all
  // other. This relies on the function fn to be transitive.
  //
  // moments should either be an array of moment objects or an array, whose
  // first element is an array of moment objects.
  function pickBy(fn, moments) {
      var res, i;
      if (moments.length === 1 && isArray(moments[0])) {
          moments = moments[0];
      }
      if (!moments.length) {
          return createLocal();
      }
      res = moments[0];
      for (i = 1; i < moments.length; ++i) {
          if (!moments[i].isValid() || moments[i][fn](res)) {
              res = moments[i];
          }
      }
      return res;
  }

  // TODO: Use [].sort instead?
  function min () {
      var args = [].slice.call(arguments, 0);

      return pickBy('isBefore', args);
  }

  function max () {
      var args = [].slice.call(arguments, 0);

      return pickBy('isAfter', args);
  }

  var now = function () {
      return Date.now ? Date.now() : +(new Date());
  };

  function Duration (duration) {
      var normalizedInput = normalizeObjectUnits(duration),
          years = normalizedInput.year || 0,
          quarters = normalizedInput.quarter || 0,
          months = normalizedInput.month || 0,
          weeks = normalizedInput.week || 0,
          days = normalizedInput.day || 0,
          hours = normalizedInput.hour || 0,
          minutes = normalizedInput.minute || 0,
          seconds = normalizedInput.second || 0,
          milliseconds = normalizedInput.millisecond || 0;

      // representation for dateAddRemove
      this._milliseconds = +milliseconds +
          seconds * 1e3 + // 1000
          minutes * 6e4 + // 1000 * 60
          hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
      // Because of dateAddRemove treats 24 hours as different from a
      // day when working around DST, we need to store them separately
      this._days = +days +
          weeks * 7;
      // It is impossible translate months into days without knowing
      // which months you are are talking about, so we have to store
      // it separately.
      this._months = +months +
          quarters * 3 +
          years * 12;

      this._data = {};

      this._locale = getLocale();

      this._bubble();
  }

  function isDuration (obj) {
      return obj instanceof Duration;
  }

  function absRound (number) {
      if (number < 0) {
          return Math.round(-1 * number) * -1;
      } else {
          return Math.round(number);
      }
  }

  // FORMATTING

  function offset (token, separator) {
      addFormatToken(token, 0, 0, function () {
          var offset = this.utcOffset();
          var sign = '+';
          if (offset < 0) {
              offset = -offset;
              sign = '-';
          }
          return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~(offset) % 60, 2);
      });
  }

  offset('Z', ':');
  offset('ZZ', '');

  // PARSING

  addRegexToken('Z',  matchShortOffset);
  addRegexToken('ZZ', matchShortOffset);
  addParseToken(['Z', 'ZZ'], function (input, array, config) {
      config._useUTC = true;
      config._tzm = offsetFromString(matchShortOffset, input);
  });

  // HELPERS

  // timezone chunker
  // '+10:00' > ['10',  '00']
  // '-1530'  > ['-15', '30']
  var chunkOffset = /([\+\-]|\d\d)/gi;

  function offsetFromString(matcher, string) {
      var matches = (string || '').match(matcher);

      if (matches === null) {
          return null;
      }

      var chunk   = matches[matches.length - 1] || [];
      var parts   = (chunk + '').match(chunkOffset) || ['-', 0, 0];
      var minutes = +(parts[1] * 60) + toInt(parts[2]);

      return minutes === 0 ?
        0 :
        parts[0] === '+' ? minutes : -minutes;
  }

  // Return a moment from input, that is local/utc/zone equivalent to model.
  function cloneWithOffset(input, model) {
      var res, diff;
      if (model._isUTC) {
          res = model.clone();
          diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
          // Use low-level api, because this fn is low-level api.
          res._d.setTime(res._d.valueOf() + diff);
          hooks.updateOffset(res, false);
          return res;
      } else {
          return createLocal(input).local();
      }
  }

  function getDateOffset (m) {
      // On Firefox.24 Date#getTimezoneOffset returns a floating point.
      // https://github.com/moment/moment/pull/1871
      return -Math.round(m._d.getTimezoneOffset() / 15) * 15;
  }

  // HOOKS

  // This function will be called whenever a moment is mutated.
  // It is intended to keep the offset in sync with the timezone.
  hooks.updateOffset = function () {};

  // MOMENTS

  // keepLocalTime = true means only change the timezone, without
  // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
  // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
  // +0200, so we adjust the time as needed, to be valid.
  //
  // Keeping the time actually adds/subtracts (one hour)
  // from the actual represented time. That is why we call updateOffset
  // a second time. In case it wants us to change the offset again
  // _changeInProgress == true case, then we have to adjust, because
  // there is no such time in the given timezone.
  function getSetOffset (input, keepLocalTime) {
      var offset = this._offset || 0,
          localAdjust;
      if (!this.isValid()) {
          return input != null ? this : NaN;
      }
      if (input != null) {
          if (typeof input === 'string') {
              input = offsetFromString(matchShortOffset, input);
              if (input === null) {
                  return this;
              }
          } else if (Math.abs(input) < 16) {
              input = input * 60;
          }
          if (!this._isUTC && keepLocalTime) {
              localAdjust = getDateOffset(this);
          }
          this._offset = input;
          this._isUTC = true;
          if (localAdjust != null) {
              this.add(localAdjust, 'm');
          }
          if (offset !== input) {
              if (!keepLocalTime || this._changeInProgress) {
                  addSubtract(this, createDuration(input - offset, 'm'), 1, false);
              } else if (!this._changeInProgress) {
                  this._changeInProgress = true;
                  hooks.updateOffset(this, true);
                  this._changeInProgress = null;
              }
          }
          return this;
      } else {
          return this._isUTC ? offset : getDateOffset(this);
      }
  }

  function getSetZone (input, keepLocalTime) {
      if (input != null) {
          if (typeof input !== 'string') {
              input = -input;
          }

          this.utcOffset(input, keepLocalTime);

          return this;
      } else {
          return -this.utcOffset();
      }
  }

  function setOffsetToUTC (keepLocalTime) {
      return this.utcOffset(0, keepLocalTime);
  }

  function setOffsetToLocal (keepLocalTime) {
      if (this._isUTC) {
          this.utcOffset(0, keepLocalTime);
          this._isUTC = false;

          if (keepLocalTime) {
              this.subtract(getDateOffset(this), 'm');
          }
      }
      return this;
  }

  function setOffsetToParsedOffset () {
      if (this._tzm != null) {
          this.utcOffset(this._tzm);
      } else if (typeof this._i === 'string') {
          var tZone = offsetFromString(matchOffset, this._i);
          if (tZone != null) {
              this.utcOffset(tZone);
          }
          else {
              this.utcOffset(0, true);
          }
      }
      return this;
  }

  function hasAlignedHourOffset (input) {
      if (!this.isValid()) {
          return false;
      }
      input = input ? createLocal(input).utcOffset() : 0;

      return (this.utcOffset() - input) % 60 === 0;
  }

  function isDaylightSavingTime () {
      return (
          this.utcOffset() > this.clone().month(0).utcOffset() ||
          this.utcOffset() > this.clone().month(5).utcOffset()
      );
  }

  function isDaylightSavingTimeShifted () {
      if (!isUndefined(this._isDSTShifted)) {
          return this._isDSTShifted;
      }

      var c = {};

      copyConfig(c, this);
      c = prepareConfig(c);

      if (c._a) {
          var other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
          this._isDSTShifted = this.isValid() &&
              compareArrays(c._a, other.toArray()) > 0;
      } else {
          this._isDSTShifted = false;
      }

      return this._isDSTShifted;
  }

  function isLocal () {
      return this.isValid() ? !this._isUTC : false;
  }

  function isUtcOffset () {
      return this.isValid() ? this._isUTC : false;
  }

  function isUtc () {
      return this.isValid() ? this._isUTC && this._offset === 0 : false;
  }

  // ASP.NET json date format regex
  var aspNetRegex = /^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;

  // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
  // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
  // and further modified to allow for strings containing both week and day
  var isoRegex = /^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;

  function createDuration (input, key) {
      var duration = input,
          // matching against regexp is expensive, do it on demand
          match = null,
          sign,
          ret,
          diffRes;

      if (isDuration(input)) {
          duration = {
              ms : input._milliseconds,
              d  : input._days,
              M  : input._months
          };
      } else if (isNumber(input)) {
          duration = {};
          if (key) {
              duration[key] = input;
          } else {
              duration.milliseconds = input;
          }
      } else if (!!(match = aspNetRegex.exec(input))) {
          sign = (match[1] === '-') ? -1 : 1;
          duration = {
              y  : 0,
              d  : toInt(match[DATE])                         * sign,
              h  : toInt(match[HOUR])                         * sign,
              m  : toInt(match[MINUTE])                       * sign,
              s  : toInt(match[SECOND])                       * sign,
              ms : toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match
          };
      } else if (!!(match = isoRegex.exec(input))) {
          sign = (match[1] === '-') ? -1 : 1;
          duration = {
              y : parseIso(match[2], sign),
              M : parseIso(match[3], sign),
              w : parseIso(match[4], sign),
              d : parseIso(match[5], sign),
              h : parseIso(match[6], sign),
              m : parseIso(match[7], sign),
              s : parseIso(match[8], sign)
          };
      } else if (duration == null) {// checks for null or undefined
          duration = {};
      } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
          diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));

          duration = {};
          duration.ms = diffRes.milliseconds;
          duration.M = diffRes.months;
      }

      ret = new Duration(duration);

      if (isDuration(input) && hasOwnProp(input, '_locale')) {
          ret._locale = input._locale;
      }

      return ret;
  }

  createDuration.fn = Duration.prototype;

  function parseIso (inp, sign) {
      // We'd normally use ~~inp for this, but unfortunately it also
      // converts floats to ints.
      // inp may be undefined, so careful calling replace on it.
      var res = inp && parseFloat(inp.replace(',', '.'));
      // apply sign while we're at it
      return (isNaN(res) ? 0 : res) * sign;
  }

  function positiveMomentsDifference(base, other) {
      var res = {milliseconds: 0, months: 0};

      res.months = other.month() - base.month() +
          (other.year() - base.year()) * 12;
      if (base.clone().add(res.months, 'M').isAfter(other)) {
          --res.months;
      }

      res.milliseconds = +other - +(base.clone().add(res.months, 'M'));

      return res;
  }

  function momentsDifference(base, other) {
      var res;
      if (!(base.isValid() && other.isValid())) {
          return {milliseconds: 0, months: 0};
      }

      other = cloneWithOffset(other, base);
      if (base.isBefore(other)) {
          res = positiveMomentsDifference(base, other);
      } else {
          res = positiveMomentsDifference(other, base);
          res.milliseconds = -res.milliseconds;
          res.months = -res.months;
      }

      return res;
  }

  // TODO: remove 'name' arg after deprecation is removed
  function createAdder(direction, name) {
      return function (val, period) {
          var dur, tmp;
          //invert the arguments, but complain about it
          if (period !== null && !isNaN(+period)) {
              deprecateSimple(name, 'moment().' + name  + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' +
              'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
              tmp = val; val = period; period = tmp;
          }

          val = typeof val === 'string' ? +val : val;
          dur = createDuration(val, period);
          addSubtract(this, dur, direction);
          return this;
      };
  }

  function addSubtract (mom, duration, isAdding, updateOffset) {
      var milliseconds = duration._milliseconds,
          days = absRound(duration._days),
          months = absRound(duration._months);

      if (!mom.isValid()) {
          // No op
          return;
      }

      updateOffset = updateOffset == null ? true : updateOffset;

      if (milliseconds) {
          mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
      }
      if (days) {
          set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
      }
      if (months) {
          setMonth(mom, get(mom, 'Month') + months * isAdding);
      }
      if (updateOffset) {
          hooks.updateOffset(mom, days || months);
      }
  }

  var add      = createAdder(1, 'add');
  var subtract = createAdder(-1, 'subtract');

  function getCalendarFormat(myMoment, now) {
      var diff = myMoment.diff(now, 'days', true);
      return diff < -6 ? 'sameElse' :
              diff < -1 ? 'lastWeek' :
              diff < 0 ? 'lastDay' :
              diff < 1 ? 'sameDay' :
              diff < 2 ? 'nextDay' :
              diff < 7 ? 'nextWeek' : 'sameElse';
  }

  function calendar$1 (time, formats) {
      // We want to compare the start of today, vs this.
      // Getting start-of-today depends on whether we're local/utc/offset or not.
      var now = time || createLocal(),
          sod = cloneWithOffset(now, this).startOf('day'),
          format = hooks.calendarFormat(this, sod) || 'sameElse';

      var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);

      return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
  }

  function clone () {
      return new Moment(this);
  }

  function isAfter (input, units) {
      var localInput = isMoment(input) ? input : createLocal(input);
      if (!(this.isValid() && localInput.isValid())) {
          return false;
      }
      units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
      if (units === 'millisecond') {
          return this.valueOf() > localInput.valueOf();
      } else {
          return localInput.valueOf() < this.clone().startOf(units).valueOf();
      }
  }

  function isBefore (input, units) {
      var localInput = isMoment(input) ? input : createLocal(input);
      if (!(this.isValid() && localInput.isValid())) {
          return false;
      }
      units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
      if (units === 'millisecond') {
          return this.valueOf() < localInput.valueOf();
      } else {
          return this.clone().endOf(units).valueOf() < localInput.valueOf();
      }
  }

  function isBetween (from, to, units, inclusivity) {
      inclusivity = inclusivity || '()';
      return (inclusivity[0] === '(' ? this.isAfter(from, units) : !this.isBefore(from, units)) &&
          (inclusivity[1] === ')' ? this.isBefore(to, units) : !this.isAfter(to, units));
  }

  function isSame (input, units) {
      var localInput = isMoment(input) ? input : createLocal(input),
          inputMs;
      if (!(this.isValid() && localInput.isValid())) {
          return false;
      }
      units = normalizeUnits(units || 'millisecond');
      if (units === 'millisecond') {
          return this.valueOf() === localInput.valueOf();
      } else {
          inputMs = localInput.valueOf();
          return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
      }
  }

  function isSameOrAfter (input, units) {
      return this.isSame(input, units) || this.isAfter(input,units);
  }

  function isSameOrBefore (input, units) {
      return this.isSame(input, units) || this.isBefore(input,units);
  }

  function diff (input, units, asFloat) {
      var that,
          zoneDelta,
          delta, output;

      if (!this.isValid()) {
          return NaN;
      }

      that = cloneWithOffset(input, this);

      if (!that.isValid()) {
          return NaN;
      }

      zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;

      units = normalizeUnits(units);

      if (units === 'year' || units === 'month' || units === 'quarter') {
          output = monthDiff(this, that);
          if (units === 'quarter') {
              output = output / 3;
          } else if (units === 'year') {
              output = output / 12;
          }
      } else {
          delta = this - that;
          output = units === 'second' ? delta / 1e3 : // 1000
              units === 'minute' ? delta / 6e4 : // 1000 * 60
              units === 'hour' ? delta / 36e5 : // 1000 * 60 * 60
              units === 'day' ? (delta - zoneDelta) / 864e5 : // 1000 * 60 * 60 * 24, negate dst
              units === 'week' ? (delta - zoneDelta) / 6048e5 : // 1000 * 60 * 60 * 24 * 7, negate dst
              delta;
      }
      return asFloat ? output : absFloor(output);
  }

  function monthDiff (a, b) {
      // difference in months
      var wholeMonthDiff = ((b.year() - a.year()) * 12) + (b.month() - a.month()),
          // b is in (anchor - 1 month, anchor + 1 month)
          anchor = a.clone().add(wholeMonthDiff, 'months'),
          anchor2, adjust;

      if (b - anchor < 0) {
          anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
          // linear across the month
          adjust = (b - anchor) / (anchor - anchor2);
      } else {
          anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
          // linear across the month
          adjust = (b - anchor) / (anchor2 - anchor);
      }

      //check for negative zero, return zero if negative zero
      return -(wholeMonthDiff + adjust) || 0;
  }

  hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
  hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

  function toString () {
      return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
  }

  function toISOString () {
      var m = this.clone().utc();
      if (0 < m.year() && m.year() <= 9999) {
          if (isFunction(Date.prototype.toISOString)) {
              // native implementation is ~50x faster, use it when we can
              return this.toDate().toISOString();
          } else {
              return formatMoment(m, 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]');
          }
      } else {
          return formatMoment(m, 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]');
      }
  }

  /**
   * Return a human readable representation of a moment that can
   * also be evaluated to get a new moment which is the same
   *
   * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
   */
  function inspect () {
      if (!this.isValid()) {
          return 'moment.invalid(/* ' + this._i + ' */)';
      }
      var func = 'moment';
      var zone = '';
      if (!this.isLocal()) {
          func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
          zone = 'Z';
      }
      var prefix = '[' + func + '("]';
      var year = (0 < this.year() && this.year() <= 9999) ? 'YYYY' : 'YYYYYY';
      var datetime = '-MM-DD[T]HH:mm:ss.SSS';
      var suffix = zone + '[")]';

      return this.format(prefix + year + datetime + suffix);
  }

  function format (inputString) {
      if (!inputString) {
          inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
      }
      var output = formatMoment(this, inputString);
      return this.localeData().postformat(output);
  }

  function from (time, withoutSuffix) {
      if (this.isValid() &&
              ((isMoment(time) && time.isValid()) ||
               createLocal(time).isValid())) {
          return createDuration({to: this, from: time}).locale(this.locale()).humanize(!withoutSuffix);
      } else {
          return this.localeData().invalidDate();
      }
  }

  function fromNow (withoutSuffix) {
      return this.from(createLocal(), withoutSuffix);
  }

  function to (time, withoutSuffix) {
      if (this.isValid() &&
              ((isMoment(time) && time.isValid()) ||
               createLocal(time).isValid())) {
          return createDuration({from: this, to: time}).locale(this.locale()).humanize(!withoutSuffix);
      } else {
          return this.localeData().invalidDate();
      }
  }

  function toNow (withoutSuffix) {
      return this.to(createLocal(), withoutSuffix);
  }

  // If passed a locale key, it will set the locale for this
  // instance.  Otherwise, it will return the locale configuration
  // variables for this instance.
  function locale (key) {
      var newLocaleData;

      if (key === undefined) {
          return this._locale._abbr;
      } else {
          newLocaleData = getLocale(key);
          if (newLocaleData != null) {
              this._locale = newLocaleData;
          }
          return this;
      }
  }

  var lang = deprecate(
      'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',
      function (key) {
          if (key === undefined) {
              return this.localeData();
          } else {
              return this.locale(key);
          }
      }
  );

  function localeData () {
      return this._locale;
  }

  function startOf (units) {
      units = normalizeUnits(units);
      // the following switch intentionally omits break keywords
      // to utilize falling through the cases.
      switch (units) {
          case 'year':
              this.month(0);
              /* falls through */
          case 'quarter':
          case 'month':
              this.date(1);
              /* falls through */
          case 'week':
          case 'isoWeek':
          case 'day':
          case 'date':
              this.hours(0);
              /* falls through */
          case 'hour':
              this.minutes(0);
              /* falls through */
          case 'minute':
              this.seconds(0);
              /* falls through */
          case 'second':
              this.milliseconds(0);
      }

      // weeks are a special case
      if (units === 'week') {
          this.weekday(0);
      }
      if (units === 'isoWeek') {
          this.isoWeekday(1);
      }

      // quarters are also special
      if (units === 'quarter') {
          this.month(Math.floor(this.month() / 3) * 3);
      }

      return this;
  }

  function endOf (units) {
      units = normalizeUnits(units);
      if (units === undefined || units === 'millisecond') {
          return this;
      }

      // 'date' is an alias for 'day', so it should be considered as such.
      if (units === 'date') {
          units = 'day';
      }

      return this.startOf(units).add(1, (units === 'isoWeek' ? 'week' : units)).subtract(1, 'ms');
  }

  function valueOf () {
      return this._d.valueOf() - ((this._offset || 0) * 60000);
  }

  function unix () {
      return Math.floor(this.valueOf() / 1000);
  }

  function toDate () {
      return new Date(this.valueOf());
  }

  function toArray () {
      var m = this;
      return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
  }

  function toObject () {
      var m = this;
      return {
          years: m.year(),
          months: m.month(),
          date: m.date(),
          hours: m.hours(),
          minutes: m.minutes(),
          seconds: m.seconds(),
          milliseconds: m.milliseconds()
      };
  }

  function toJSON () {
      // new Date(NaN).toJSON() === null
      return this.isValid() ? this.toISOString() : null;
  }

  function isValid$1 () {
      return isValid(this);
  }

  function parsingFlags () {
      return extend({}, getParsingFlags(this));
  }

  function invalidAt () {
      return getParsingFlags(this).overflow;
  }

  function creationData() {
      return {
          input: this._i,
          format: this._f,
          locale: this._locale,
          isUTC: this._isUTC,
          strict: this._strict
      };
  }

  // FORMATTING

  addFormatToken(0, ['gg', 2], 0, function () {
      return this.weekYear() % 100;
  });

  addFormatToken(0, ['GG', 2], 0, function () {
      return this.isoWeekYear() % 100;
  });

  function addWeekYearFormatToken (token, getter) {
      addFormatToken(0, [token, token.length], 0, getter);
  }

  addWeekYearFormatToken('gggg',     'weekYear');
  addWeekYearFormatToken('ggggg',    'weekYear');
  addWeekYearFormatToken('GGGG',  'isoWeekYear');
  addWeekYearFormatToken('GGGGG', 'isoWeekYear');

  // ALIASES

  addUnitAlias('weekYear', 'gg');
  addUnitAlias('isoWeekYear', 'GG');

  // PRIORITY

  addUnitPriority('weekYear', 1);
  addUnitPriority('isoWeekYear', 1);


  // PARSING

  addRegexToken('G',      matchSigned);
  addRegexToken('g',      matchSigned);
  addRegexToken('GG',     match1to2, match2);
  addRegexToken('gg',     match1to2, match2);
  addRegexToken('GGGG',   match1to4, match4);
  addRegexToken('gggg',   match1to4, match4);
  addRegexToken('GGGGG',  match1to6, match6);
  addRegexToken('ggggg',  match1to6, match6);

  addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
      week[token.substr(0, 2)] = toInt(input);
  });

  addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
      week[token] = hooks.parseTwoDigitYear(input);
  });

  // MOMENTS

  function getSetWeekYear (input) {
      return getSetWeekYearHelper.call(this,
              input,
              this.week(),
              this.weekday(),
              this.localeData()._week.dow,
              this.localeData()._week.doy);
  }

  function getSetISOWeekYear (input) {
      return getSetWeekYearHelper.call(this,
              input, this.isoWeek(), this.isoWeekday(), 1, 4);
  }

  function getISOWeeksInYear () {
      return weeksInYear(this.year(), 1, 4);
  }

  function getWeeksInYear () {
      var weekInfo = this.localeData()._week;
      return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
  }

  function getSetWeekYearHelper(input, week, weekday, dow, doy) {
      var weeksTarget;
      if (input == null) {
          return weekOfYear(this, dow, doy).year;
      } else {
          weeksTarget = weeksInYear(input, dow, doy);
          if (week > weeksTarget) {
              week = weeksTarget;
          }
          return setWeekAll.call(this, input, week, weekday, dow, doy);
      }
  }

  function setWeekAll(weekYear, week, weekday, dow, doy) {
      var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
          date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);

      this.year(date.getUTCFullYear());
      this.month(date.getUTCMonth());
      this.date(date.getUTCDate());
      return this;
  }

  // FORMATTING

  addFormatToken('Q', 0, 'Qo', 'quarter');

  // ALIASES

  addUnitAlias('quarter', 'Q');

  // PRIORITY

  addUnitPriority('quarter', 7);

  // PARSING

  addRegexToken('Q', match1);
  addParseToken('Q', function (input, array) {
      array[MONTH] = (toInt(input) - 1) * 3;
  });

  // MOMENTS

  function getSetQuarter (input) {
      return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
  }

  // FORMATTING

  addFormatToken('D', ['DD', 2], 'Do', 'date');

  // ALIASES

  addUnitAlias('date', 'D');

  // PRIOROITY
  addUnitPriority('date', 9);

  // PARSING

  addRegexToken('D',  match1to2);
  addRegexToken('DD', match1to2, match2);
  addRegexToken('Do', function (isStrict, locale) {
      return isStrict ? locale._ordinalParse : locale._ordinalParseLenient;
  });

  addParseToken(['D', 'DD'], DATE);
  addParseToken('Do', function (input, array) {
      array[DATE] = toInt(input.match(match1to2)[0], 10);
  });

  // MOMENTS

  var getSetDayOfMonth = makeGetSet('Date', true);

  // FORMATTING

  addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

  // ALIASES

  addUnitAlias('dayOfYear', 'DDD');

  // PRIORITY
  addUnitPriority('dayOfYear', 4);

  // PARSING

  addRegexToken('DDD',  match1to3);
  addRegexToken('DDDD', match3);
  addParseToken(['DDD', 'DDDD'], function (input, array, config) {
      config._dayOfYear = toInt(input);
  });

  // HELPERS

  // MOMENTS

  function getSetDayOfYear (input) {
      var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
      return input == null ? dayOfYear : this.add((input - dayOfYear), 'd');
  }

  // FORMATTING

  addFormatToken('m', ['mm', 2], 0, 'minute');

  // ALIASES

  addUnitAlias('minute', 'm');

  // PRIORITY

  addUnitPriority('minute', 14);

  // PARSING

  addRegexToken('m',  match1to2);
  addRegexToken('mm', match1to2, match2);
  addParseToken(['m', 'mm'], MINUTE);

  // MOMENTS

  var getSetMinute = makeGetSet('Minutes', false);

  // FORMATTING

  addFormatToken('s', ['ss', 2], 0, 'second');

  // ALIASES

  addUnitAlias('second', 's');

  // PRIORITY

  addUnitPriority('second', 15);

  // PARSING

  addRegexToken('s',  match1to2);
  addRegexToken('ss', match1to2, match2);
  addParseToken(['s', 'ss'], SECOND);

  // MOMENTS

  var getSetSecond = makeGetSet('Seconds', false);

  // FORMATTING

  addFormatToken('S', 0, 0, function () {
      return ~~(this.millisecond() / 100);
  });

  addFormatToken(0, ['SS', 2], 0, function () {
      return ~~(this.millisecond() / 10);
  });

  addFormatToken(0, ['SSS', 3], 0, 'millisecond');
  addFormatToken(0, ['SSSS', 4], 0, function () {
      return this.millisecond() * 10;
  });
  addFormatToken(0, ['SSSSS', 5], 0, function () {
      return this.millisecond() * 100;
  });
  addFormatToken(0, ['SSSSSS', 6], 0, function () {
      return this.millisecond() * 1000;
  });
  addFormatToken(0, ['SSSSSSS', 7], 0, function () {
      return this.millisecond() * 10000;
  });
  addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
      return this.millisecond() * 100000;
  });
  addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
      return this.millisecond() * 1000000;
  });


  // ALIASES

  addUnitAlias('millisecond', 'ms');

  // PRIORITY

  addUnitPriority('millisecond', 16);

  // PARSING

  addRegexToken('S',    match1to3, match1);
  addRegexToken('SS',   match1to3, match2);
  addRegexToken('SSS',  match1to3, match3);

  var token;
  for (token = 'SSSS'; token.length <= 9; token += 'S') {
      addRegexToken(token, matchUnsigned);
  }

  function parseMs(input, array) {
      array[MILLISECOND] = toInt(('0.' + input) * 1000);
  }

  for (token = 'S'; token.length <= 9; token += 'S') {
      addParseToken(token, parseMs);
  }
  // MOMENTS

  var getSetMillisecond = makeGetSet('Milliseconds', false);

  // FORMATTING

  addFormatToken('z',  0, 0, 'zoneAbbr');
  addFormatToken('zz', 0, 0, 'zoneName');

  // MOMENTS

  function getZoneAbbr () {
      return this._isUTC ? 'UTC' : '';
  }

  function getZoneName () {
      return this._isUTC ? 'Coordinated Universal Time' : '';
  }

  var proto = Moment.prototype;

  proto.add               = add;
  proto.calendar          = calendar$1;
  proto.clone             = clone;
  proto.diff              = diff;
  proto.endOf             = endOf;
  proto.format            = format;
  proto.from              = from;
  proto.fromNow           = fromNow;
  proto.to                = to;
  proto.toNow             = toNow;
  proto.get               = stringGet;
  proto.invalidAt         = invalidAt;
  proto.isAfter           = isAfter;
  proto.isBefore          = isBefore;
  proto.isBetween         = isBetween;
  proto.isSame            = isSame;
  proto.isSameOrAfter     = isSameOrAfter;
  proto.isSameOrBefore    = isSameOrBefore;
  proto.isValid           = isValid$1;
  proto.lang              = lang;
  proto.locale            = locale;
  proto.localeData        = localeData;
  proto.max               = prototypeMax;
  proto.min               = prototypeMin;
  proto.parsingFlags      = parsingFlags;
  proto.set               = stringSet;
  proto.startOf           = startOf;
  proto.subtract          = subtract;
  proto.toArray           = toArray;
  proto.toObject          = toObject;
  proto.toDate            = toDate;
  proto.toISOString       = toISOString;
  proto.inspect           = inspect;
  proto.toJSON            = toJSON;
  proto.toString          = toString;
  proto.unix              = unix;
  proto.valueOf           = valueOf;
  proto.creationData      = creationData;

  // Year
  proto.year       = getSetYear;
  proto.isLeapYear = getIsLeapYear;

  // Week Year
  proto.weekYear    = getSetWeekYear;
  proto.isoWeekYear = getSetISOWeekYear;

  // Quarter
  proto.quarter = proto.quarters = getSetQuarter;

  // Month
  proto.month       = getSetMonth;
  proto.daysInMonth = getDaysInMonth;

  // Week
  proto.week           = proto.weeks        = getSetWeek;
  proto.isoWeek        = proto.isoWeeks     = getSetISOWeek;
  proto.weeksInYear    = getWeeksInYear;
  proto.isoWeeksInYear = getISOWeeksInYear;

  // Day
  proto.date       = getSetDayOfMonth;
  proto.day        = proto.days             = getSetDayOfWeek;
  proto.weekday    = getSetLocaleDayOfWeek;
  proto.isoWeekday = getSetISODayOfWeek;
  proto.dayOfYear  = getSetDayOfYear;

  // Hour
  proto.hour = proto.hours = getSetHour;

  // Minute
  proto.minute = proto.minutes = getSetMinute;

  // Second
  proto.second = proto.seconds = getSetSecond;

  // Millisecond
  proto.millisecond = proto.milliseconds = getSetMillisecond;

  // Offset
  proto.utcOffset            = getSetOffset;
  proto.utc                  = setOffsetToUTC;
  proto.local                = setOffsetToLocal;
  proto.parseZone            = setOffsetToParsedOffset;
  proto.hasAlignedHourOffset = hasAlignedHourOffset;
  proto.isDST                = isDaylightSavingTime;
  proto.isLocal              = isLocal;
  proto.isUtcOffset          = isUtcOffset;
  proto.isUtc                = isUtc;
  proto.isUTC                = isUtc;

  // Timezone
  proto.zoneAbbr = getZoneAbbr;
  proto.zoneName = getZoneName;

  // Deprecations
  proto.dates  = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
  proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
  proto.years  = deprecate('years accessor is deprecated. Use year instead', getSetYear);
  proto.zone   = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
  proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);

  function createUnix (input) {
      return createLocal(input * 1000);
  }

  function createInZone () {
      return createLocal.apply(null, arguments).parseZone();
  }

  function preParsePostFormat (string) {
      return string;
  }

  var proto$1 = Locale.prototype;

  proto$1.calendar        = calendar;
  proto$1.longDateFormat  = longDateFormat;
  proto$1.invalidDate     = invalidDate;
  proto$1.ordinal         = ordinal;
  proto$1.preparse        = preParsePostFormat;
  proto$1.postformat      = preParsePostFormat;
  proto$1.relativeTime    = relativeTime;
  proto$1.pastFuture      = pastFuture;
  proto$1.set             = set;

  // Month
  proto$1.months            =        localeMonths;
  proto$1.monthsShort       =        localeMonthsShort;
  proto$1.monthsParse       =        localeMonthsParse;
  proto$1.monthsRegex       = monthsRegex;
  proto$1.monthsShortRegex  = monthsShortRegex;

  // Week
  proto$1.week = localeWeek;
  proto$1.firstDayOfYear = localeFirstDayOfYear;
  proto$1.firstDayOfWeek = localeFirstDayOfWeek;

  // Day of Week
  proto$1.weekdays       =        localeWeekdays;
  proto$1.weekdaysMin    =        localeWeekdaysMin;
  proto$1.weekdaysShort  =        localeWeekdaysShort;
  proto$1.weekdaysParse  =        localeWeekdaysParse;

  proto$1.weekdaysRegex       =        weekdaysRegex;
  proto$1.weekdaysShortRegex  =        weekdaysShortRegex;
  proto$1.weekdaysMinRegex    =        weekdaysMinRegex;

  // Hours
  proto$1.isPM = localeIsPM;
  proto$1.meridiem = localeMeridiem;

  function get$1 (format, index, field, setter) {
      var locale = getLocale();
      var utc = createUTC().set(setter, index);
      return locale[field](utc, format);
  }

  function listMonthsImpl (format, index, field) {
      if (isNumber(format)) {
          index = format;
          format = undefined;
      }

      format = format || '';

      if (index != null) {
          return get$1(format, index, field, 'month');
      }

      var i;
      var out = [];
      for (i = 0; i < 12; i++) {
          out[i] = get$1(format, i, field, 'month');
      }
      return out;
  }

  // ()
  // (5)
  // (fmt, 5)
  // (fmt)
  // (true)
  // (true, 5)
  // (true, fmt, 5)
  // (true, fmt)
  function listWeekdaysImpl (localeSorted, format, index, field) {
      if (typeof localeSorted === 'boolean') {
          if (isNumber(format)) {
              index = format;
              format = undefined;
          }

          format = format || '';
      } else {
          format = localeSorted;
          index = format;
          localeSorted = false;

          if (isNumber(format)) {
              index = format;
              format = undefined;
          }

          format = format || '';
      }

      var locale = getLocale(),
          shift = localeSorted ? locale._week.dow : 0;

      if (index != null) {
          return get$1(format, (index + shift) % 7, field, 'day');
      }

      var i;
      var out = [];
      for (i = 0; i < 7; i++) {
          out[i] = get$1(format, (i + shift) % 7, field, 'day');
      }
      return out;
  }

  function listMonths (format, index) {
      return listMonthsImpl(format, index, 'months');
  }

  function listMonthsShort (format, index) {
      return listMonthsImpl(format, index, 'monthsShort');
  }

  function listWeekdays (localeSorted, format, index) {
      return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
  }

  function listWeekdaysShort (localeSorted, format, index) {
      return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
  }

  function listWeekdaysMin (localeSorted, format, index) {
      return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
  }

  getSetGlobalLocale('en', {
      ordinalParse: /\d{1,2}(th|st|nd|rd)/,
      ordinal : function (number) {
          var b = number % 10,
              output = (toInt(number % 100 / 10) === 1) ? 'th' :
              (b === 1) ? 'st' :
              (b === 2) ? 'nd' :
              (b === 3) ? 'rd' : 'th';
          return number + output;
      }
  });

  // Side effect imports
  hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
  hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);

  var mathAbs = Math.abs;

  function abs () {
      var data           = this._data;

      this._milliseconds = mathAbs(this._milliseconds);
      this._days         = mathAbs(this._days);
      this._months       = mathAbs(this._months);

      data.milliseconds  = mathAbs(data.milliseconds);
      data.seconds       = mathAbs(data.seconds);
      data.minutes       = mathAbs(data.minutes);
      data.hours         = mathAbs(data.hours);
      data.months        = mathAbs(data.months);
      data.years         = mathAbs(data.years);

      return this;
  }

  function addSubtract$1 (duration, input, value, direction) {
      var other = createDuration(input, value);

      duration._milliseconds += direction * other._milliseconds;
      duration._days         += direction * other._days;
      duration._months       += direction * other._months;

      return duration._bubble();
  }

  // supports only 2.0-style add(1, 's') or add(duration)
  function add$1 (input, value) {
      return addSubtract$1(this, input, value, 1);
  }

  // supports only 2.0-style subtract(1, 's') or subtract(duration)
  function subtract$1 (input, value) {
      return addSubtract$1(this, input, value, -1);
  }

  function absCeil (number) {
      if (number < 0) {
          return Math.floor(number);
      } else {
          return Math.ceil(number);
      }
  }

  function bubble () {
      var milliseconds = this._milliseconds;
      var days         = this._days;
      var months       = this._months;
      var data         = this._data;
      var seconds, minutes, hours, years, monthsFromDays;

      // if we have a mix of positive and negative values, bubble down first
      // check: https://github.com/moment/moment/issues/2166
      if (!((milliseconds >= 0 && days >= 0 && months >= 0) ||
              (milliseconds <= 0 && days <= 0 && months <= 0))) {
          milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
          days = 0;
          months = 0;
      }

      // The following code bubbles up values, see the tests for
      // examples of what that means.
      data.milliseconds = milliseconds % 1000;

      seconds           = absFloor(milliseconds / 1000);
      data.seconds      = seconds % 60;

      minutes           = absFloor(seconds / 60);
      data.minutes      = minutes % 60;

      hours             = absFloor(minutes / 60);
      data.hours        = hours % 24;

      days += absFloor(hours / 24);

      // convert days to months
      monthsFromDays = absFloor(daysToMonths(days));
      months += monthsFromDays;
      days -= absCeil(monthsToDays(monthsFromDays));

      // 12 months -> 1 year
      years = absFloor(months / 12);
      months %= 12;

      data.days   = days;
      data.months = months;
      data.years  = years;

      return this;
  }

  function daysToMonths (days) {
      // 400 years have 146097 days (taking into account leap year rules)
      // 400 years have 12 months === 4800
      return days * 4800 / 146097;
  }

  function monthsToDays (months) {
      // the reverse of daysToMonths
      return months * 146097 / 4800;
  }

  function as (units) {
      var days;
      var months;
      var milliseconds = this._milliseconds;

      units = normalizeUnits(units);

      if (units === 'month' || units === 'year') {
          days   = this._days   + milliseconds / 864e5;
          months = this._months + daysToMonths(days);
          return units === 'month' ? months : months / 12;
      } else {
          // handle milliseconds separately because of floating point math errors (issue #1867)
          days = this._days + Math.round(monthsToDays(this._months));
          switch (units) {
              case 'week'   : return days / 7     + milliseconds / 6048e5;
              case 'day'    : return days         + milliseconds / 864e5;
              case 'hour'   : return days * 24    + milliseconds / 36e5;
              case 'minute' : return days * 1440  + milliseconds / 6e4;
              case 'second' : return days * 86400 + milliseconds / 1000;
              // Math.floor prevents floating point math errors here
              case 'millisecond': return Math.floor(days * 864e5) + milliseconds;
              default: throw new Error('Unknown unit ' + units);
          }
      }
  }

  // TODO: Use this.as('ms')?
  function valueOf$1 () {
      return (
          this._milliseconds +
          this._days * 864e5 +
          (this._months % 12) * 2592e6 +
          toInt(this._months / 12) * 31536e6
      );
  }

  function makeAs (alias) {
      return function () {
          return this.as(alias);
      };
  }

  var asMilliseconds = makeAs('ms');
  var asSeconds      = makeAs('s');
  var asMinutes      = makeAs('m');
  var asHours        = makeAs('h');
  var asDays         = makeAs('d');
  var asWeeks        = makeAs('w');
  var asMonths       = makeAs('M');
  var asYears        = makeAs('y');

  function get$2 (units) {
      units = normalizeUnits(units);
      return this[units + 's']();
  }

  function makeGetter(name) {
      return function () {
          return this._data[name];
      };
  }

  var milliseconds = makeGetter('milliseconds');
  var seconds      = makeGetter('seconds');
  var minutes      = makeGetter('minutes');
  var hours        = makeGetter('hours');
  var days         = makeGetter('days');
  var months       = makeGetter('months');
  var years        = makeGetter('years');

  function weeks () {
      return absFloor(this.days() / 7);
  }

  var round = Math.round;
  var thresholds = {
      s: 45,  // seconds to minute
      m: 45,  // minutes to hour
      h: 22,  // hours to day
      d: 26,  // days to month
      M: 11   // months to year
  };

  // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
  function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
      return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
  }

  function relativeTime$1 (posNegDuration, withoutSuffix, locale) {
      var duration = createDuration(posNegDuration).abs();
      var seconds  = round(duration.as('s'));
      var minutes  = round(duration.as('m'));
      var hours    = round(duration.as('h'));
      var days     = round(duration.as('d'));
      var months   = round(duration.as('M'));
      var years    = round(duration.as('y'));

      var a = seconds < thresholds.s && ['s', seconds]  ||
              minutes <= 1           && ['m']           ||
              minutes < thresholds.m && ['mm', minutes] ||
              hours   <= 1           && ['h']           ||
              hours   < thresholds.h && ['hh', hours]   ||
              days    <= 1           && ['d']           ||
              days    < thresholds.d && ['dd', days]    ||
              months  <= 1           && ['M']           ||
              months  < thresholds.M && ['MM', months]  ||
              years   <= 1           && ['y']           || ['yy', years];

      a[2] = withoutSuffix;
      a[3] = +posNegDuration > 0;
      a[4] = locale;
      return substituteTimeAgo.apply(null, a);
  }

  // This function allows you to set the rounding function for relative time strings
  function getSetRelativeTimeRounding (roundingFunction) {
      if (roundingFunction === undefined) {
          return round;
      }
      if (typeof(roundingFunction) === 'function') {
          round = roundingFunction;
          return true;
      }
      return false;
  }

  // This function allows you to set a threshold for relative time strings
  function getSetRelativeTimeThreshold (threshold, limit) {
      if (thresholds[threshold] === undefined) {
          return false;
      }
      if (limit === undefined) {
          return thresholds[threshold];
      }
      thresholds[threshold] = limit;
      return true;
  }

  function humanize (withSuffix) {
      var locale = this.localeData();
      var output = relativeTime$1(this, !withSuffix, locale);

      if (withSuffix) {
          output = locale.pastFuture(+this, output);
      }

      return locale.postformat(output);
  }

  var abs$1 = Math.abs;

  function toISOString$1() {
      // for ISO strings we do not use the normal bubbling rules:
      //  * milliseconds bubble up until they become hours
      //  * days do not bubble at all
      //  * months bubble up until they become years
      // This is because there is no context-free conversion between hours and days
      // (think of clock changes)
      // and also not between days and months (28-31 days per month)
      var seconds = abs$1(this._milliseconds) / 1000;
      var days         = abs$1(this._days);
      var months       = abs$1(this._months);
      var minutes, hours, years;

      // 3600 seconds -> 60 minutes -> 1 hour
      minutes           = absFloor(seconds / 60);
      hours             = absFloor(minutes / 60);
      seconds %= 60;
      minutes %= 60;

      // 12 months -> 1 year
      years  = absFloor(months / 12);
      months %= 12;


      // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
      var Y = years;
      var M = months;
      var D = days;
      var h = hours;
      var m = minutes;
      var s = seconds;
      var total = this.asSeconds();

      if (!total) {
          // this is the same as C#'s (Noda) and python (isodate)...
          // but not other JS (goog.date)
          return 'P0D';
      }

      return (total < 0 ? '-' : '') +
          'P' +
          (Y ? Y + 'Y' : '') +
          (M ? M + 'M' : '') +
          (D ? D + 'D' : '') +
          ((h || m || s) ? 'T' : '') +
          (h ? h + 'H' : '') +
          (m ? m + 'M' : '') +
          (s ? s + 'S' : '');
  }

  var proto$2 = Duration.prototype;

  proto$2.abs            = abs;
  proto$2.add            = add$1;
  proto$2.subtract       = subtract$1;
  proto$2.as             = as;
  proto$2.asMilliseconds = asMilliseconds;
  proto$2.asSeconds      = asSeconds;
  proto$2.asMinutes      = asMinutes;
  proto$2.asHours        = asHours;
  proto$2.asDays         = asDays;
  proto$2.asWeeks        = asWeeks;
  proto$2.asMonths       = asMonths;
  proto$2.asYears        = asYears;
  proto$2.valueOf        = valueOf$1;
  proto$2._bubble        = bubble;
  proto$2.get            = get$2;
  proto$2.milliseconds   = milliseconds;
  proto$2.seconds        = seconds;
  proto$2.minutes        = minutes;
  proto$2.hours          = hours;
  proto$2.days           = days;
  proto$2.weeks          = weeks;
  proto$2.months         = months;
  proto$2.years          = years;
  proto$2.humanize       = humanize;
  proto$2.toISOString    = toISOString$1;
  proto$2.toString       = toISOString$1;
  proto$2.toJSON         = toISOString$1;
  proto$2.locale         = locale;
  proto$2.localeData     = localeData;

  // Deprecations
  proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
  proto$2.lang = lang;

  // Side effect imports

  // FORMATTING

  addFormatToken('X', 0, 0, 'unix');
  addFormatToken('x', 0, 0, 'valueOf');

  // PARSING

  addRegexToken('x', matchSigned);
  addRegexToken('X', matchTimestamp);
  addParseToken('X', function (input, array, config) {
      config._d = new Date(parseFloat(input, 10) * 1000);
  });
  addParseToken('x', function (input, array, config) {
      config._d = new Date(toInt(input));
  });

  // Side effect imports


  hooks.version = '2.17.1';

  setHookCallback(createLocal);

  hooks.fn                    = proto;
  hooks.min                   = min;
  hooks.max                   = max;
  hooks.now                   = now;
  hooks.utc                   = createUTC;
  hooks.unix                  = createUnix;
  hooks.months                = listMonths;
  hooks.isDate                = isDate;
  hooks.locale                = getSetGlobalLocale;
  hooks.invalid               = createInvalid;
  hooks.duration              = createDuration;
  hooks.isMoment              = isMoment;
  hooks.weekdays              = listWeekdays;
  hooks.parseZone             = createInZone;
  hooks.localeData            = getLocale;
  hooks.isDuration            = isDuration;
  hooks.monthsShort           = listMonthsShort;
  hooks.weekdaysMin           = listWeekdaysMin;
  hooks.defineLocale          = defineLocale;
  hooks.updateLocale          = updateLocale;
  hooks.locales               = listLocales;
  hooks.weekdaysShort         = listWeekdaysShort;
  hooks.normalizeUnits        = normalizeUnits;
  hooks.relativeTimeRounding = getSetRelativeTimeRounding;
  hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
  hooks.calendarFormat        = getCalendarFormat;
  hooks.prototype             = proto;

  return hooks;

  })));

  /* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(86)(module)))

/***/ },
/* 86 */
/***/ function(module, exports) {

  module.exports = function(module) {
  	if(!module.webpackPolyfill) {
  		module.deprecate = function() {};
  		module.paths = [];
  		// module.parent = undefined by default
  		module.children = [];
  		module.webpackPolyfill = 1;
  	}
  	return module;
  }


/***/ },
/* 87 */
/***/ function(module, exports) {

  function webpackContext(req) {
  	throw new Error("Cannot find module '" + req + "'.");
  }
  webpackContext.keys = function() { return []; };
  webpackContext.resolve = webpackContext;
  module.exports = webpackContext;
  webpackContext.id = 87;


/***/ },
/* 88 */
/***/ function(module, exports) {

  /* WEBPACK VAR INJECTION */(function(global) {'use strict';

  var _rng;

  var globalVar = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : null;

  if (globalVar && globalVar.crypto && crypto.getRandomValues) {
    // WHATWG crypto-based RNG - http://wiki.whatwg.org/wiki/Crypto
    // Moderately fast, high quality
    var _rnds8 = new Uint8Array(16);
    _rng = function whatwgRNG() {
      crypto.getRandomValues(_rnds8);
      return _rnds8;
    };
  }

  if (!_rng) {
    // Math.random()-based (RNG)
    //
    // If all else fails, use Math.random().  It's fast, but is of unspecified
    // quality.
    var _rnds = new Array(16);
    _rng = function _rng() {
      for (var i = 0, r; i < 16; i++) {
        if ((i & 0x03) === 0) r = Math.random() * 0x100000000;
        _rnds[i] = r >>> ((i & 0x03) << 3) & 0xff;
      }

      return _rnds;
    };
  }

  //     uuid.js
  //
  //     Copyright (c) 2010-2012 Robert Kieffer
  //     MIT License - http://opensource.org/licenses/mit-license.php

  // Unique ID creation requires a high quality random # generator.  We feature
  // detect to determine the best RNG source, normalizing to a function that
  // returns 128-bits of randomness, since that's what's usually required

  //var _rng = require('./rng');

  // Maps for number <-> hex string conversion
  var _byteToHex = [];
  var _hexToByte = {};
  for (var i = 0; i < 256; i++) {
    _byteToHex[i] = (i + 0x100).toString(16).substr(1);
    _hexToByte[_byteToHex[i]] = i;
  }

  // **`parse()` - Parse a UUID into it's component bytes**
  function parse(s, buf, offset) {
    var i = buf && offset || 0,
        ii = 0;

    buf = buf || [];
    s.toLowerCase().replace(/[0-9a-f]{2}/g, function (oct) {
      if (ii < 16) {
        // Don't overflow!
        buf[i + ii++] = _hexToByte[oct];
      }
    });

    // Zero out remaining bytes if string was short
    while (ii < 16) {
      buf[i + ii++] = 0;
    }

    return buf;
  }

  // **`unparse()` - Convert UUID byte array (ala parse()) into a string**
  function unparse(buf, offset) {
    var i = offset || 0,
        bth = _byteToHex;
    return bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]];
  }

  // **`v1()` - Generate time-based UUID**
  //
  // Inspired by https://github.com/LiosK/UUID.js
  // and http://docs.python.org/library/uuid.html

  // random #'s we need to init node and clockseq
  var _seedBytes = _rng();

  // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
  var _nodeId = [_seedBytes[0] | 0x01, _seedBytes[1], _seedBytes[2], _seedBytes[3], _seedBytes[4], _seedBytes[5]];

  // Per 4.2.2, randomize (14 bit) clockseq
  var _clockseq = (_seedBytes[6] << 8 | _seedBytes[7]) & 0x3fff;

  // Previous uuid creation time
  var _lastMSecs = 0,
      _lastNSecs = 0;

  // See https://github.com/broofa/node-uuid for API details
  function v1(options, buf, offset) {
    var i = buf && offset || 0;
    var b = buf || [];

    options = options || {};

    var clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq;

    // UUID timestamps are 100 nano-second units since the Gregorian epoch,
    // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
    // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
    // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.
    var msecs = options.msecs !== undefined ? options.msecs : new Date().getTime();

    // Per 4.2.1.2, use count of uuid's generated during the current clock
    // cycle to simulate higher resolution clock
    var nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1;

    // Time since last uuid creation (in msecs)
    var dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000;

    // Per 4.2.1.2, Bump clockseq on clock regression
    if (dt < 0 && options.clockseq === undefined) {
      clockseq = clockseq + 1 & 0x3fff;
    }

    // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
    // time interval
    if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
      nsecs = 0;
    }

    // Per 4.2.1.2 Throw error if too many uuids are requested
    if (nsecs >= 10000) {
      throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');
    }

    _lastMSecs = msecs;
    _lastNSecs = nsecs;
    _clockseq = clockseq;

    // Per 4.1.4 - Convert from unix epoch to Gregorian epoch
    msecs += 12219292800000;

    // `time_low`
    var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
    b[i++] = tl >>> 24 & 0xff;
    b[i++] = tl >>> 16 & 0xff;
    b[i++] = tl >>> 8 & 0xff;
    b[i++] = tl & 0xff;

    // `time_mid`
    var tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
    b[i++] = tmh >>> 8 & 0xff;
    b[i++] = tmh & 0xff;

    // `time_high_and_version`
    b[i++] = tmh >>> 24 & 0xf | 0x10; // include version
    b[i++] = tmh >>> 16 & 0xff;

    // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)
    b[i++] = clockseq >>> 8 | 0x80;

    // `clock_seq_low`
    b[i++] = clockseq & 0xff;

    // `node`
    var node = options.node || _nodeId;
    for (var n = 0; n < 6; n++) {
      b[i + n] = node[n];
    }

    return buf ? buf : unparse(b);
  }

  // **`v4()` - Generate random UUID**

  // See https://github.com/broofa/node-uuid for API details
  function v4(options, buf, offset) {
    // Deprecated - 'format' argument, as supported in v1.2
    var i = buf && offset || 0;

    if (typeof options == 'string') {
      buf = options == 'binary' ? new Array(16) : null;
      options = null;
    }
    options = options || {};

    var rnds = options.random || (options.rng || _rng)();

    // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
    rnds[6] = rnds[6] & 0x0f | 0x40;
    rnds[8] = rnds[8] & 0x3f | 0x80;

    // Copy bytes to buffer, if provided
    if (buf) {
      for (var ii = 0; ii < 16; ii++) {
        buf[i + ii] = rnds[ii];
      }
    }

    return buf || unparse(rnds);
  }

  // Export public API
  var uuid = v4;
  uuid.v1 = v1;
  uuid.v4 = v4;
  uuid.parse = parse;
  uuid.unparse = unparse;

  module.exports = uuid;
  /* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  // utils
  exports.util = __webpack_require__(1);
  exports.DOMutil = __webpack_require__(90);

  // data
  exports.DataSet = __webpack_require__(91);
  exports.DataView = __webpack_require__(93);
  exports.Queue = __webpack_require__(92);

  // Graph3d
  exports.Graph3d = __webpack_require__(94);
  exports.graph3d = {
    Camera: __webpack_require__(98),
    Filter: __webpack_require__(103),
    Point2d: __webpack_require__(97),
    Point3d: __webpack_require__(96),
    Slider: __webpack_require__(104),
    StepNumber: __webpack_require__(105)
  };

  // bundled external libraries
  exports.moment = __webpack_require__(84);
  exports.Hammer = __webpack_require__(108);
  exports.keycharm = __webpack_require__(111);

/***/ },
/* 90 */
/***/ function(module, exports) {

  'use strict';

  // DOM utility methods

  /**
   * this prepares the JSON container for allocating SVG elements
   * @param JSONcontainer
   * @private
   */
  exports.prepareElements = function (JSONcontainer) {
    // cleanup the redundant svgElements;
    for (var elementType in JSONcontainer) {
      if (JSONcontainer.hasOwnProperty(elementType)) {
        JSONcontainer[elementType].redundant = JSONcontainer[elementType].used;
        JSONcontainer[elementType].used = [];
      }
    }
  };

  /**
   * this cleans up all the unused SVG elements. By asking for the parentNode, we only need to supply the JSON container from
   * which to remove the redundant elements.
   *
   * @param JSONcontainer
   * @private
   */
  exports.cleanupElements = function (JSONcontainer) {
    // cleanup the redundant svgElements;
    for (var elementType in JSONcontainer) {
      if (JSONcontainer.hasOwnProperty(elementType)) {
        if (JSONcontainer[elementType].redundant) {
          for (var i = 0; i < JSONcontainer[elementType].redundant.length; i++) {
            JSONcontainer[elementType].redundant[i].parentNode.removeChild(JSONcontainer[elementType].redundant[i]);
          }
          JSONcontainer[elementType].redundant = [];
        }
      }
    }
  };

  /**
   * Ensures that all elements are removed first up so they can be recreated cleanly
   * @param JSONcontainer
   */
  exports.resetElements = function (JSONcontainer) {
    exports.prepareElements(JSONcontainer);
    exports.cleanupElements(JSONcontainer);
    exports.prepareElements(JSONcontainer);
  };

  /**
   * Allocate or generate an SVG element if needed. Store a reference to it in the JSON container and draw it in the svgContainer
   * the JSON container and the SVG container have to be supplied so other svg containers (like the legend) can use this.
   *
   * @param elementType
   * @param JSONcontainer
   * @param svgContainer
   * @returns {*}
   * @private
   */
  exports.getSVGElement = function (elementType, JSONcontainer, svgContainer) {
    var element;
    // allocate SVG element, if it doesnt yet exist, create one.
    if (JSONcontainer.hasOwnProperty(elementType)) {
      // this element has been created before
      // check if there is an redundant element
      if (JSONcontainer[elementType].redundant.length > 0) {
        element = JSONcontainer[elementType].redundant[0];
        JSONcontainer[elementType].redundant.shift();
      } else {
        // create a new element and add it to the SVG
        element = document.createElementNS('http://www.w3.org/2000/svg', elementType);
        svgContainer.appendChild(element);
      }
    } else {
      // create a new element and add it to the SVG, also create a new object in the svgElements to keep track of it.
      element = document.createElementNS('http://www.w3.org/2000/svg', elementType);
      JSONcontainer[elementType] = { used: [], redundant: [] };
      svgContainer.appendChild(element);
    }
    JSONcontainer[elementType].used.push(element);
    return element;
  };

  /**
   * Allocate or generate an SVG element if needed. Store a reference to it in the JSON container and draw it in the svgContainer
   * the JSON container and the SVG container have to be supplied so other svg containers (like the legend) can use this.
   *
   * @param elementType
   * @param JSONcontainer
   * @param DOMContainer
   * @returns {*}
   * @private
   */
  exports.getDOMElement = function (elementType, JSONcontainer, DOMContainer, insertBefore) {
    var element;
    // allocate DOM element, if it doesnt yet exist, create one.
    if (JSONcontainer.hasOwnProperty(elementType)) {
      // this element has been created before
      // check if there is an redundant element
      if (JSONcontainer[elementType].redundant.length > 0) {
        element = JSONcontainer[elementType].redundant[0];
        JSONcontainer[elementType].redundant.shift();
      } else {
        // create a new element and add it to the SVG
        element = document.createElement(elementType);
        if (insertBefore !== undefined) {
          DOMContainer.insertBefore(element, insertBefore);
        } else {
          DOMContainer.appendChild(element);
        }
      }
    } else {
      // create a new element and add it to the SVG, also create a new object in the svgElements to keep track of it.
      element = document.createElement(elementType);
      JSONcontainer[elementType] = { used: [], redundant: [] };
      if (insertBefore !== undefined) {
        DOMContainer.insertBefore(element, insertBefore);
      } else {
        DOMContainer.appendChild(element);
      }
    }
    JSONcontainer[elementType].used.push(element);
    return element;
  };

  /**
   * Draw a point object. This is a separate function because it can also be called by the legend.
   * The reason the JSONcontainer and the target SVG svgContainer have to be supplied is so the legend can use these functions
   * as well.
   *
   * @param x
   * @param y
   * @param groupTemplate: A template containing the necessary information to draw the datapoint e.g., {style: 'circle', size: 5, className: 'className' }
   * @param JSONcontainer
   * @param svgContainer
   * @param labelObj
   * @returns {*}
   */
  exports.drawPoint = function (x, y, groupTemplate, JSONcontainer, svgContainer, labelObj) {
    var point;
    if (groupTemplate.style == 'circle') {
      point = exports.getSVGElement('circle', JSONcontainer, svgContainer);
      point.setAttributeNS(null, "cx", x);
      point.setAttributeNS(null, "cy", y);
      point.setAttributeNS(null, "r", 0.5 * groupTemplate.size);
    } else {
      point = exports.getSVGElement('rect', JSONcontainer, svgContainer);
      point.setAttributeNS(null, "x", x - 0.5 * groupTemplate.size);
      point.setAttributeNS(null, "y", y - 0.5 * groupTemplate.size);
      point.setAttributeNS(null, "width", groupTemplate.size);
      point.setAttributeNS(null, "height", groupTemplate.size);
    }

    if (groupTemplate.styles !== undefined) {
      point.setAttributeNS(null, "style", groupTemplate.styles);
    }
    point.setAttributeNS(null, "class", groupTemplate.className + " vis-point");
    //handle label


    if (labelObj) {
      var label = exports.getSVGElement('text', JSONcontainer, svgContainer);
      if (labelObj.xOffset) {
        x = x + labelObj.xOffset;
      }

      if (labelObj.yOffset) {
        y = y + labelObj.yOffset;
      }
      if (labelObj.content) {
        label.textContent = labelObj.content;
      }

      if (labelObj.className) {
        label.setAttributeNS(null, "class", labelObj.className + " vis-label");
      }
      label.setAttributeNS(null, "x", x);
      label.setAttributeNS(null, "y", y);
    }

    return point;
  };

  /**
   * draw a bar SVG element centered on the X coordinate
   *
   * @param x
   * @param y
   * @param className
   */
  exports.drawBar = function (x, y, width, height, className, JSONcontainer, svgContainer, style) {
    if (height != 0) {
      if (height < 0) {
        height *= -1;
        y -= height;
      }
      var rect = exports.getSVGElement('rect', JSONcontainer, svgContainer);
      rect.setAttributeNS(null, "x", x - 0.5 * width);
      rect.setAttributeNS(null, "y", y);
      rect.setAttributeNS(null, "width", width);
      rect.setAttributeNS(null, "height", height);
      rect.setAttributeNS(null, "class", className);
      if (style) {
        rect.setAttributeNS(null, "style", style);
      }
    }
  };

/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _stringify = __webpack_require__(82);

  var _stringify2 = _interopRequireDefault(_stringify);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var Queue = __webpack_require__(92);

  /**
   * DataSet
   *
   * Usage:
   *     var dataSet = new DataSet({
   *         fieldId: '_id',
   *         type: {
   *             // ...
   *         }
   *     });
   *
   *     dataSet.add(item);
   *     dataSet.add(data);
   *     dataSet.update(item);
   *     dataSet.update(data);
   *     dataSet.remove(id);
   *     dataSet.remove(ids);
   *     var data = dataSet.get();
   *     var data = dataSet.get(id);
   *     var data = dataSet.get(ids);
   *     var data = dataSet.get(ids, options, data);
   *     dataSet.clear();
   *
   * A data set can:
   * - add/remove/update data
   * - gives triggers upon changes in the data
   * - can  import/export data in various data formats
   *
   * @param {Array} [data]    Optional array with initial data
   * @param {Object} [options]   Available options:
   *                             {String} fieldId Field name of the id in the
   *                                              items, 'id' by default.
   *                             {Object.<String, String} type
   *                                              A map with field names as key,
   *                                              and the field type as value.
   *                             {Object} queue   Queue changes to the DataSet,
   *                                              flush them all at once.
   *                                              Queue options:
   *                                              - {number} delay  Delay in ms, null by default
   *                                              - {number} max    Maximum number of entries in the queue, Infinity by default
   * @constructor DataSet
   */
  // TODO: add a DataSet constructor DataSet(data, options)
  function DataSet(data, options) {
    // correctly read optional arguments
    if (data && !Array.isArray(data)) {
      options = data;
      data = null;
    }

    this._options = options || {};
    this._data = {}; // map with data indexed by id
    this.length = 0; // number of items in the DataSet
    this._fieldId = this._options.fieldId || 'id'; // name of the field containing id
    this._type = {}; // internal field types (NOTE: this can differ from this._options.type)

    // all variants of a Date are internally stored as Date, so we can convert
    // from everything to everything (also from ISODate to Number for example)
    if (this._options.type) {
      var fields = (0, _keys2['default'])(this._options.type);
      for (var i = 0, len = fields.length; i < len; i++) {
        var field = fields[i];
        var value = this._options.type[field];
        if (value == 'Date' || value == 'ISODate' || value == 'ASPDate') {
          this._type[field] = 'Date';
        } else {
          this._type[field] = value;
        }
      }
    }

    // TODO: deprecated since version 1.1.1 (or 2.0.0?)
    if (this._options.convert) {
      throw new Error('Option "convert" is deprecated. Use "type" instead.');
    }

    this._subscribers = {}; // event subscribers

    // add initial data when provided
    if (data) {
      this.add(data);
    }

    this.setOptions(options);
  }

  /**
   * @param {Object} [options]   Available options:
   *                             {Object} queue   Queue changes to the DataSet,
   *                                              flush them all at once.
   *                                              Queue options:
   *                                              - {number} delay  Delay in ms, null by default
   *                                              - {number} max    Maximum number of entries in the queue, Infinity by default
   * @param options
   */
  DataSet.prototype.setOptions = function (options) {
    if (options && options.queue !== undefined) {
      if (options.queue === false) {
        // delete queue if loaded
        if (this._queue) {
          this._queue.destroy();
          delete this._queue;
        }
      } else {
        // create queue and update its options
        if (!this._queue) {
          this._queue = Queue.extend(this, {
            replace: ['add', 'update', 'remove']
          });
        }

        if ((0, _typeof3['default'])(options.queue) === 'object') {
          this._queue.setOptions(options.queue);
        }
      }
    }
  };

  /**
   * Subscribe to an event, add an event listener
   * @param {String} event        Event name. Available events: 'put', 'update',
   *                              'remove'
   * @param {function} callback   Callback method. Called with three parameters:
   *                                  {String} event
   *                                  {Object | null} params
   *                                  {String | Number} senderId
   */
  DataSet.prototype.on = function (event, callback) {
    var subscribers = this._subscribers[event];
    if (!subscribers) {
      subscribers = [];
      this._subscribers[event] = subscribers;
    }

    subscribers.push({
      callback: callback
    });
  };

  // TODO: remove this deprecated function some day (replaced with `on` since version 0.5, deprecated since v4.0)
  DataSet.prototype.subscribe = function () {
    throw new Error('DataSet.subscribe is deprecated. Use DataSet.on instead.');
  };

  /**
   * Unsubscribe from an event, remove an event listener
   * @param {String} event
   * @param {function} callback
   */
  DataSet.prototype.off = function (event, callback) {
    var subscribers = this._subscribers[event];
    if (subscribers) {
      this._subscribers[event] = subscribers.filter(function (listener) {
        return listener.callback != callback;
      });
    }
  };

  // TODO: remove this deprecated function some day (replaced with `on` since version 0.5, deprecated since v4.0)
  DataSet.prototype.unsubscribe = function () {
    throw new Error('DataSet.unsubscribe is deprecated. Use DataSet.off instead.');
  };

  /**
   * Trigger an event
   * @param {String} event
   * @param {Object | null} params
   * @param {String} [senderId]       Optional id of the sender.
   * @private
   */
  DataSet.prototype._trigger = function (event, params, senderId) {
    if (event == '*') {
      throw new Error('Cannot trigger event *');
    }

    var subscribers = [];
    if (event in this._subscribers) {
      subscribers = subscribers.concat(this._subscribers[event]);
    }
    if ('*' in this._subscribers) {
      subscribers = subscribers.concat(this._subscribers['*']);
    }

    for (var i = 0, len = subscribers.length; i < len; i++) {
      var subscriber = subscribers[i];
      if (subscriber.callback) {
        subscriber.callback(event, params, senderId || null);
      }
    }
  };

  /**
   * Add data.
   * Adding an item will fail when there already is an item with the same id.
   * @param {Object | Array} data
   * @param {String} [senderId] Optional sender id
   * @return {Array} addedIds      Array with the ids of the added items
   */
  DataSet.prototype.add = function (data, senderId) {
    var addedIds = [],
        id,
        me = this;

    if (Array.isArray(data)) {
      // Array
      for (var i = 0, len = data.length; i < len; i++) {
        id = me._addItem(data[i]);
        addedIds.push(id);
      }
    } else if (data instanceof Object) {
      // Single item
      id = me._addItem(data);
      addedIds.push(id);
    } else {
      throw new Error('Unknown dataType');
    }

    if (addedIds.length) {
      this._trigger('add', { items: addedIds }, senderId);
    }

    return addedIds;
  };

  /**
   * Update existing items. When an item does not exist, it will be created
   * @param {Object | Array} data
   * @param {String} [senderId] Optional sender id
   * @return {Array} updatedIds     The ids of the added or updated items
   */
  DataSet.prototype.update = function (data, senderId) {
    var addedIds = [];
    var updatedIds = [];
    var oldData = [];
    var updatedData = [];
    var me = this;
    var fieldId = me._fieldId;

    var addOrUpdate = function addOrUpdate(item) {
      var id = item[fieldId];
      if (me._data[id]) {
        var oldItem = util.extend({}, me._data[id]);
        // update item
        id = me._updateItem(item);
        updatedIds.push(id);
        updatedData.push(item);
        oldData.push(oldItem);
      } else {
        // add new item
        id = me._addItem(item);
        addedIds.push(id);
      }
    };

    if (Array.isArray(data)) {
      // Array
      for (var i = 0, len = data.length; i < len; i++) {
        if (data[i] instanceof Object) {
          addOrUpdate(data[i]);
        } else {
          console.warn('Ignoring input item, which is not an object at index ' + i);
        }
      }
    } else if (data instanceof Object) {
      // Single item
      addOrUpdate(data);
    } else {
      throw new Error('Unknown dataType');
    }

    if (addedIds.length) {
      this._trigger('add', { items: addedIds }, senderId);
    }
    if (updatedIds.length) {
      var props = { items: updatedIds, oldData: oldData, data: updatedData };
      // TODO: remove deprecated property 'data' some day
      //Object.defineProperty(props, 'data', {
      //  'get': (function() {
      //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
      //    return updatedData;
      //  }).bind(this)
      //});
      this._trigger('update', props, senderId);
    }

    return addedIds.concat(updatedIds);
  };

  /**
   * Get a data item or multiple items.
   *
   * Usage:
   *
   *     get()
   *     get(options: Object)
   *
   *     get(id: Number | String)
   *     get(id: Number | String, options: Object)
   *
   *     get(ids: Number[] | String[])
   *     get(ids: Number[] | String[], options: Object)
   *
   * Where:
   *
   * {Number | String} id         The id of an item
   * {Number[] | String{}} ids    An array with ids of items
   * {Object} options             An Object with options. Available options:
   * {String} [returnType]        Type of data to be returned.
   *                              Can be 'Array' (default) or 'Object'.
   * {Object.<String, String>} [type]
   * {String[]} [fields]          field names to be returned
   * {function} [filter]          filter items
   * {String | function} [order]  Order the items by a field name or custom sort function.
   * @throws Error
   */
  DataSet.prototype.get = function (args) {
    var me = this;

    // parse the arguments
    var id, ids, options;
    var firstType = util.getType(arguments[0]);
    if (firstType == 'String' || firstType == 'Number') {
      // get(id [, options])
      id = arguments[0];
      options = arguments[1];
    } else if (firstType == 'Array') {
      // get(ids [, options])
      ids = arguments[0];
      options = arguments[1];
    } else {
      // get([, options])
      options = arguments[0];
    }

    // determine the return type
    var returnType;
    if (options && options.returnType) {
      var allowedValues = ['Array', 'Object'];
      returnType = allowedValues.indexOf(options.returnType) == -1 ? 'Array' : options.returnType;
    } else {
      returnType = 'Array';
    }

    // build options
    var type = options && options.type || this._options.type;
    var filter = options && options.filter;
    var items = [],
        item,
        itemIds,
        itemId,
        i,
        len;

    // convert items
    if (id != undefined) {
      // return a single item
      item = me._getItem(id, type);
      if (item && filter && !filter(item)) {
        item = null;
      }
    } else if (ids != undefined) {
      // return a subset of items
      for (i = 0, len = ids.length; i < len; i++) {
        item = me._getItem(ids[i], type);
        if (!filter || filter(item)) {
          items.push(item);
        }
      }
    } else {
      // return all items
      itemIds = (0, _keys2['default'])(this._data);
      for (i = 0, len = itemIds.length; i < len; i++) {
        itemId = itemIds[i];
        item = me._getItem(itemId, type);
        if (!filter || filter(item)) {
          items.push(item);
        }
      }
    }

    // order the results
    if (options && options.order && id == undefined) {
      this._sort(items, options.order);
    }

    // filter fields of the items
    if (options && options.fields) {
      var fields = options.fields;
      if (id != undefined) {
        item = this._filterFields(item, fields);
      } else {
        for (i = 0, len = items.length; i < len; i++) {
          items[i] = this._filterFields(items[i], fields);
        }
      }
    }

    // return the results
    if (returnType == 'Object') {
      var result = {},
          resultant;
      for (i = 0, len = items.length; i < len; i++) {
        resultant = items[i];
        result[resultant.id] = resultant;
      }
      return result;
    } else {
      if (id != undefined) {
        // a single item
        return item;
      } else {
        // just return our array
        return items;
      }
    }
  };

  /**
   * Get ids of all items or from a filtered set of items.
   * @param {Object} [options]    An Object with options. Available options:
   *                              {function} [filter] filter items
   *                              {String | function} [order] Order the items by
   *                                  a field name or custom sort function.
   * @return {Array} ids
   */
  DataSet.prototype.getIds = function (options) {
    var data = this._data,
        filter = options && options.filter,
        order = options && options.order,
        type = options && options.type || this._options.type,
        itemIds = (0, _keys2['default'])(data),
        i,
        len,
        id,
        item,
        items,
        ids = [];

    if (filter) {
      // get filtered items
      if (order) {
        // create ordered list
        items = [];
        for (i = 0, len = itemIds.length; i < len; i++) {
          id = itemIds[i];
          item = this._getItem(id, type);
          if (filter(item)) {
            items.push(item);
          }
        }

        this._sort(items, order);

        for (i = 0, len = items.length; i < len; i++) {
          ids.push(items[i][this._fieldId]);
        }
      } else {
        // create unordered list
        for (i = 0, len = itemIds.length; i < len; i++) {
          id = itemIds[i];
          item = this._getItem(id, type);
          if (filter(item)) {
            ids.push(item[this._fieldId]);
          }
        }
      }
    } else {
      // get all items
      if (order) {
        // create an ordered list
        items = [];
        for (i = 0, len = itemIds.length; i < len; i++) {
          id = itemIds[i];
          items.push(data[id]);
        }

        this._sort(items, order);

        for (i = 0, len = items.length; i < len; i++) {
          ids.push(items[i][this._fieldId]);
        }
      } else {
        // create unordered list
        for (i = 0, len = itemIds.length; i < len; i++) {
          id = itemIds[i];
          item = data[id];
          ids.push(item[this._fieldId]);
        }
      }
    }

    return ids;
  };

  /**
   * Returns the DataSet itself. Is overwritten for example by the DataView,
   * which returns the DataSet it is connected to instead.
   */
  DataSet.prototype.getDataSet = function () {
    return this;
  };

  /**
   * Execute a callback function for every item in the dataset.
   * @param {function} callback
   * @param {Object} [options]    Available options:
   *                              {Object.<String, String>} [type]
   *                              {String[]} [fields] filter fields
   *                              {function} [filter] filter items
   *                              {String | function} [order] Order the items by
   *                                  a field name or custom sort function.
   */
  DataSet.prototype.forEach = function (callback, options) {
    var filter = options && options.filter,
        type = options && options.type || this._options.type,
        data = this._data,
        itemIds = (0, _keys2['default'])(data),
        i,
        len,
        item,
        id;

    if (options && options.order) {
      // execute forEach on ordered list
      var items = this.get(options);

      for (i = 0, len = items.length; i < len; i++) {
        item = items[i];
        id = item[this._fieldId];
        callback(item, id);
      }
    } else {
      // unordered
      for (i = 0, len = itemIds.length; i < len; i++) {
        id = itemIds[i];
        item = this._getItem(id, type);
        if (!filter || filter(item)) {
          callback(item, id);
        }
      }
    }
  };

  /**
   * Map every item in the dataset.
   * @param {function} callback
   * @param {Object} [options]    Available options:
   *                              {Object.<String, String>} [type]
   *                              {String[]} [fields] filter fields
   *                              {function} [filter] filter items
   *                              {String | function} [order] Order the items by
   *                                  a field name or custom sort function.
   * @return {Object[]} mappedItems
   */
  DataSet.prototype.map = function (callback, options) {
    var filter = options && options.filter,
        type = options && options.type || this._options.type,
        mappedItems = [],
        data = this._data,
        itemIds = (0, _keys2['default'])(data),
        i,
        len,
        id,
        item;

    // convert and filter items
    for (i = 0, len = itemIds.length; i < len; i++) {
      id = itemIds[i];
      item = this._getItem(id, type);
      if (!filter || filter(item)) {
        mappedItems.push(callback(item, id));
      }
    }

    // order items
    if (options && options.order) {
      this._sort(mappedItems, options.order);
    }

    return mappedItems;
  };

  /**
   * Filter the fields of an item
   * @param {Object | null} item
   * @param {String[]} fields     Field names
   * @return {Object | null} filteredItem or null if no item is provided
   * @private
   */
  DataSet.prototype._filterFields = function (item, fields) {
    if (!item) {
      // item is null
      return item;
    }

    var filteredItem = {},
        itemFields = (0, _keys2['default'])(item),
        len = itemFields.length,
        i,
        field;

    if (Array.isArray(fields)) {
      for (i = 0; i < len; i++) {
        field = itemFields[i];
        if (fields.indexOf(field) != -1) {
          filteredItem[field] = item[field];
        }
      }
    } else {
      for (i = 0; i < len; i++) {
        field = itemFields[i];
        if (fields.hasOwnProperty(field)) {
          filteredItem[fields[field]] = item[field];
        }
      }
    }

    return filteredItem;
  };

  /**
   * Sort the provided array with items
   * @param {Object[]} items
   * @param {String | function} order      A field name or custom sort function.
   * @private
   */
  DataSet.prototype._sort = function (items, order) {
    if (util.isString(order)) {
      // order by provided field name
      var name = order; // field name
      items.sort(function (a, b) {
        var av = a[name];
        var bv = b[name];
        return av > bv ? 1 : av < bv ? -1 : 0;
      });
    } else if (typeof order === 'function') {
      // order by sort function
      items.sort(order);
    }
    // TODO: extend order by an Object {field:String, direction:String}
    //       where direction can be 'asc' or 'desc'
    else {
        throw new TypeError('Order must be a function or a string');
      }
  };

  /**
   * Remove an object by pointer or by id
   * @param {String | Number | Object | Array} id Object or id, or an array with
   *                                              objects or ids to be removed
   * @param {String} [senderId] Optional sender id
   * @return {Array} removedIds
   */
  DataSet.prototype.remove = function (id, senderId) {
    var removedIds = [],
        removedItems = [],
        ids = [],
        i,
        len,
        itemId,
        item;

    // force everything to be an array for simplicity
    ids = Array.isArray(id) ? id : [id];

    for (i = 0, len = ids.length; i < len; i++) {
      item = this._remove(ids[i]);
      if (item) {
        itemId = item[this._fieldId];
        if (itemId != undefined) {
          removedIds.push(itemId);
          removedItems.push(item);
        }
      }
    }

    if (removedIds.length) {
      this._trigger('remove', { items: removedIds, oldData: removedItems }, senderId);
    }

    return removedIds;
  };

  /**
   * Remove an item by its id
   * @param {Number | String | Object} id   id or item
   * @returns {Number | String | null} id
   * @private
   */
  DataSet.prototype._remove = function (id) {
    var item, ident;

    // confirm the id to use based on the args type
    if (util.isNumber(id) || util.isString(id)) {
      ident = id;
    } else if (id instanceof Object) {
      ident = id[this._fieldId]; // look for the identifier field using _fieldId
    }

    // do the remove if the item is found
    if (ident !== undefined && this._data[ident]) {
      item = this._data[ident];
      delete this._data[ident];
      this.length--;
      return item;
    }
    return null;
  };

  /**
   * Clear the data
   * @param {String} [senderId] Optional sender id
   * @return {Array} removedIds    The ids of all removed items
   */
  DataSet.prototype.clear = function (senderId) {
    var i, len;
    var ids = (0, _keys2['default'])(this._data);
    var items = [];

    for (i = 0, len = ids.length; i < len; i++) {
      items.push(this._data[ids[i]]);
    }

    this._data = {};
    this.length = 0;

    this._trigger('remove', { items: ids, oldData: items }, senderId);

    return ids;
  };

  /**
   * Find the item with maximum value of a specified field
   * @param {String} field
   * @return {Object | null} item  Item containing max value, or null if no items
   */
  DataSet.prototype.max = function (field) {
    var data = this._data,
        itemIds = (0, _keys2['default'])(data),
        max = null,
        maxField = null,
        i,
        len;

    for (i = 0, len = itemIds.length; i < len; i++) {
      var id = itemIds[i];
      var item = data[id];
      var itemField = item[field];
      if (itemField != null && (!max || itemField > maxField)) {
        max = item;
        maxField = itemField;
      }
    }

    return max;
  };

  /**
   * Find the item with minimum value of a specified field
   * @param {String} field
   * @return {Object | null} item  Item containing max value, or null if no items
   */
  DataSet.prototype.min = function (field) {
    var data = this._data,
        itemIds = (0, _keys2['default'])(data),
        min = null,
        minField = null,
        i,
        len;

    for (i = 0, len = itemIds.length; i < len; i++) {
      var id = itemIds[i];
      var item = data[id];
      var itemField = item[field];
      if (itemField != null && (!min || itemField < minField)) {
        min = item;
        minField = itemField;
      }
    }

    return min;
  };

  /**
   * Find all distinct values of a specified field
   * @param {String} field
   * @return {Array} values  Array containing all distinct values. If data items
   *                         do not contain the specified field are ignored.
   *                         The returned array is unordered.
   */
  DataSet.prototype.distinct = function (field) {
    var data = this._data;
    var itemIds = (0, _keys2['default'])(data);
    var values = [];
    var fieldType = this._options.type && this._options.type[field] || null;
    var count = 0;
    var i, j, len;

    for (i = 0, len = itemIds.length; i < len; i++) {
      var id = itemIds[i];
      var item = data[id];
      var value = item[field];
      var exists = false;
      for (j = 0; j < count; j++) {
        if (values[j] == value) {
          exists = true;
          break;
        }
      }
      if (!exists && value !== undefined) {
        values[count] = value;
        count++;
      }
    }

    if (fieldType) {
      for (i = 0, len = values.length; i < len; i++) {
        values[i] = util.convert(values[i], fieldType);
      }
    }

    return values;
  };

  /**
   * Add a single item. Will fail when an item with the same id already exists.
   * @param {Object} item
   * @return {String} id
   * @private
   */
  DataSet.prototype._addItem = function (item) {
    var id = item[this._fieldId];

    if (id != undefined) {
      // check whether this id is already taken
      if (this._data[id]) {
        // item already exists
        throw new Error('Cannot add item: item with id ' + id + ' already exists');
      }
    } else {
      // generate an id
      id = util.randomUUID();
      item[this._fieldId] = id;
    }

    var d = {},
        fields = (0, _keys2['default'])(item),
        i,
        len;
    for (i = 0, len = fields.length; i < len; i++) {
      var field = fields[i];
      var fieldType = this._type[field]; // type may be undefined
      d[field] = util.convert(item[field], fieldType);
    }
    this._data[id] = d;
    this.length++;

    return id;
  };

  /**
   * Get an item. Fields can be converted to a specific type
   * @param {String} id
   * @param {Object.<String, String>} [types]  field types to convert
   * @return {Object | null} item
   * @private
   */
  DataSet.prototype._getItem = function (id, types) {
    var field, value, i, len;

    // get the item from the dataset
    var raw = this._data[id];
    if (!raw) {
      return null;
    }

    // convert the items field types
    var converted = {},
        fields = (0, _keys2['default'])(raw);

    if (types) {
      for (i = 0, len = fields.length; i < len; i++) {
        field = fields[i];
        value = raw[field];
        converted[field] = util.convert(value, types[field]);
      }
    } else {
      // no field types specified, no converting needed
      for (i = 0, len = fields.length; i < len; i++) {
        field = fields[i];
        value = raw[field];
        converted[field] = value;
      }
    }

    if (!converted[this._fieldId]) {
      converted[this._fieldId] = raw.id;
    }

    return converted;
  };

  /**
   * Update a single item: merge with existing item.
   * Will fail when the item has no id, or when there does not exist an item
   * with the same id.
   * @param {Object} item
   * @return {String} id
   * @private
   */
  DataSet.prototype._updateItem = function (item) {
    var id = item[this._fieldId];
    if (id == undefined) {
      throw new Error('Cannot update item: item has no id (item: ' + (0, _stringify2['default'])(item) + ')');
    }
    var d = this._data[id];
    if (!d) {
      // item doesn't exist
      throw new Error('Cannot update item: no item with id ' + id + ' found');
    }

    // merge with current item
    var fields = (0, _keys2['default'])(item);
    for (var i = 0, len = fields.length; i < len; i++) {
      var field = fields[i];
      var fieldType = this._type[field]; // type may be undefined
      d[field] = util.convert(item[field], fieldType);
    }

    return id;
  };

  module.exports = DataSet;

/***/ },
/* 92 */
/***/ function(module, exports) {

  'use strict';

  /**
   * A queue
   * @param {Object} options
   *            Available options:
   *            - delay: number    When provided, the queue will be flushed
   *                               automatically after an inactivity of this delay
   *                               in milliseconds.
   *                               Default value is null.
   *            - max: number      When the queue exceeds the given maximum number
   *                               of entries, the queue is flushed automatically.
   *                               Default value of max is Infinity.
   * @constructor
   */
  function Queue(options) {
    // options
    this.delay = null;
    this.max = Infinity;

    // properties
    this._queue = [];
    this._timeout = null;
    this._extended = null;

    this.setOptions(options);
  }

  /**
   * Update the configuration of the queue
   * @param {Object} options
   *            Available options:
   *            - delay: number    When provided, the queue will be flushed
   *                               automatically after an inactivity of this delay
   *                               in milliseconds.
   *                               Default value is null.
   *            - max: number      When the queue exceeds the given maximum number
   *                               of entries, the queue is flushed automatically.
   *                               Default value of max is Infinity.
   * @param options
   */
  Queue.prototype.setOptions = function (options) {
    if (options && typeof options.delay !== 'undefined') {
      this.delay = options.delay;
    }
    if (options && typeof options.max !== 'undefined') {
      this.max = options.max;
    }

    this._flushIfNeeded();
  };

  /**
   * Extend an object with queuing functionality.
   * The object will be extended with a function flush, and the methods provided
   * in options.replace will be replaced with queued ones.
   * @param {Object} object
   * @param {Object} options
   *            Available options:
   *            - replace: Array.<string>
   *                               A list with method names of the methods
   *                               on the object to be replaced with queued ones.
   *            - delay: number    When provided, the queue will be flushed
   *                               automatically after an inactivity of this delay
   *                               in milliseconds.
   *                               Default value is null.
   *            - max: number      When the queue exceeds the given maximum number
   *                               of entries, the queue is flushed automatically.
   *                               Default value of max is Infinity.
   * @return {Queue} Returns the created queue
   */
  Queue.extend = function (object, options) {
    var queue = new Queue(options);

    if (object.flush !== undefined) {
      throw new Error('Target object already has a property flush');
    }
    object.flush = function () {
      queue.flush();
    };

    var methods = [{
      name: 'flush',
      original: undefined
    }];

    if (options && options.replace) {
      for (var i = 0; i < options.replace.length; i++) {
        var name = options.replace[i];
        methods.push({
          name: name,
          original: object[name]
        });
        queue.replace(object, name);
      }
    }

    queue._extended = {
      object: object,
      methods: methods
    };

    return queue;
  };

  /**
   * Destroy the queue. The queue will first flush all queued actions, and in
   * case it has extended an object, will restore the original object.
   */
  Queue.prototype.destroy = function () {
    this.flush();

    if (this._extended) {
      var object = this._extended.object;
      var methods = this._extended.methods;
      for (var i = 0; i < methods.length; i++) {
        var method = methods[i];
        if (method.original) {
          object[method.name] = method.original;
        } else {
          delete object[method.name];
        }
      }
      this._extended = null;
    }
  };

  /**
   * Replace a method on an object with a queued version
   * @param {Object} object   Object having the method
   * @param {string} method   The method name
   */
  Queue.prototype.replace = function (object, method) {
    var me = this;
    var original = object[method];
    if (!original) {
      throw new Error('Method ' + method + ' undefined');
    }

    object[method] = function () {
      // create an Array with the arguments
      var args = [];
      for (var i = 0; i < arguments.length; i++) {
        args[i] = arguments[i];
      }

      // add this call to the queue
      me.queue({
        args: args,
        fn: original,
        context: this
      });
    };
  };

  /**
   * Queue a call
   * @param {function | {fn: function, args: Array} | {fn: function, args: Array, context: Object}} entry
   */
  Queue.prototype.queue = function (entry) {
    if (typeof entry === 'function') {
      this._queue.push({ fn: entry });
    } else {
      this._queue.push(entry);
    }

    this._flushIfNeeded();
  };

  /**
   * Check whether the queue needs to be flushed
   * @private
   */
  Queue.prototype._flushIfNeeded = function () {
    // flush when the maximum is exceeded.
    if (this._queue.length > this.max) {
      this.flush();
    }

    // flush after a period of inactivity when a delay is configured
    clearTimeout(this._timeout);
    if (this.queue.length > 0 && typeof this.delay === 'number') {
      var me = this;
      this._timeout = setTimeout(function () {
        me.flush();
      }, this.delay);
    }
  };

  /**
   * Flush all queued calls
   */
  Queue.prototype.flush = function () {
    while (this._queue.length > 0) {
      var entry = this._queue.shift();
      entry.fn.apply(entry.context || entry.fn, entry.args || []);
    }
  };

  module.exports = Queue;

/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var DataSet = __webpack_require__(91);

  /**
   * DataView
   *
   * a dataview offers a filtered view on a dataset or an other dataview.
   *
   * @param {DataSet | DataView} data
   * @param {Object} [options]   Available options: see method get
   *
   * @constructor DataView
   */
  function DataView(data, options) {
    this._data = null;
    this._ids = {}; // ids of the items currently in memory (just contains a boolean true)
    this.length = 0; // number of items in the DataView
    this._options = options || {};
    this._fieldId = 'id'; // name of the field containing id
    this._subscribers = {}; // event subscribers

    var me = this;
    this.listener = function () {
      me._onEvent.apply(me, arguments);
    };

    this.setData(data);
  }

  // TODO: implement a function .config() to dynamically update things like configured filter
  // and trigger changes accordingly

  /**
   * Set a data source for the view
   * @param {DataSet | DataView} data
   */
  DataView.prototype.setData = function (data) {
    var ids, id, i, len, items;

    if (this._data) {
      // unsubscribe from current dataset
      if (this._data.off) {
        this._data.off('*', this.listener);
      }

      // trigger a remove of all items in memory
      ids = this._data.getIds({ filter: this._options && this._options.filter });
      items = [];

      for (i = 0, len = ids.length; i < len; i++) {
        items.push(this._data._data[ids[i]]);
      }

      this._ids = {};
      this.length = 0;
      this._trigger('remove', { items: ids, oldData: items });
    }

    this._data = data;

    if (this._data) {
      // update fieldId
      this._fieldId = this._options.fieldId || this._data && this._data.options && this._data.options.fieldId || 'id';

      // trigger an add of all added items
      ids = this._data.getIds({ filter: this._options && this._options.filter });
      for (i = 0, len = ids.length; i < len; i++) {
        id = ids[i];
        this._ids[id] = true;
      }
      this.length = ids.length;
      this._trigger('add', { items: ids });

      // subscribe to new dataset
      if (this._data.on) {
        this._data.on('*', this.listener);
      }
    }
  };

  /**
   * Refresh the DataView. Useful when the DataView has a filter function
   * containing a variable parameter.
   */
  DataView.prototype.refresh = function () {
    var id, i, len;
    var ids = this._data.getIds({ filter: this._options && this._options.filter }),
        oldIds = (0, _keys2['default'])(this._ids),
        newIds = {},
        addedIds = [],
        removedIds = [],
        removedItems = [];

    // check for additions
    for (i = 0, len = ids.length; i < len; i++) {
      id = ids[i];
      newIds[id] = true;
      if (!this._ids[id]) {
        addedIds.push(id);
        this._ids[id] = true;
      }
    }

    // check for removals
    for (i = 0, len = oldIds.length; i < len; i++) {
      id = oldIds[i];
      if (!newIds[id]) {
        removedIds.push(id);
        removedItems.push(this._data._data[id]);
        delete this._ids[id];
      }
    }

    this.length += addedIds.length - removedIds.length;

    // trigger events
    if (addedIds.length) {
      this._trigger('add', { items: addedIds });
    }
    if (removedIds.length) {
      this._trigger('remove', { items: removedIds, oldData: removedItems });
    }
  };

  /**
   * Get data from the data view
   *
   * Usage:
   *
   *     get()
   *     get(options: Object)
   *     get(options: Object, data: Array | DataTable)
   *
   *     get(id: Number)
   *     get(id: Number, options: Object)
   *     get(id: Number, options: Object, data: Array | DataTable)
   *
   *     get(ids: Number[])
   *     get(ids: Number[], options: Object)
   *     get(ids: Number[], options: Object, data: Array | DataTable)
   *
   * Where:
   *
   * {Number | String} id         The id of an item
   * {Number[] | String{}} ids    An array with ids of items
   * {Object} options             An Object with options. Available options:
   *                              {String} [type] Type of data to be returned. Can
   *                                              be 'DataTable' or 'Array' (default)
   *                              {Object.<String, String>} [convert]
   *                              {String[]} [fields] field names to be returned
   *                              {function} [filter] filter items
   *                              {String | function} [order] Order the items by
   *                                  a field name or custom sort function.
   * {Array | DataTable} [data]   If provided, items will be appended to this
   *                              array or table. Required in case of Google
   *                              DataTable.
   * @param args
   */
  DataView.prototype.get = function (args) {
    var me = this;

    // parse the arguments
    var ids, options, data;
    var firstType = util.getType(arguments[0]);
    if (firstType == 'String' || firstType == 'Number' || firstType == 'Array') {
      // get(id(s) [, options] [, data])
      ids = arguments[0]; // can be a single id or an array with ids
      options = arguments[1];
      data = arguments[2];
    } else {
      // get([, options] [, data])
      options = arguments[0];
      data = arguments[1];
    }

    // extend the options with the default options and provided options
    var viewOptions = util.extend({}, this._options, options);

    // create a combined filter method when needed
    if (this._options.filter && options && options.filter) {
      viewOptions.filter = function (item) {
        return me._options.filter(item) && options.filter(item);
      };
    }

    // build up the call to the linked data set
    var getArguments = [];
    if (ids != undefined) {
      getArguments.push(ids);
    }
    getArguments.push(viewOptions);
    getArguments.push(data);

    return this._data && this._data.get.apply(this._data, getArguments);
  };

  /**
   * Get ids of all items or from a filtered set of items.
   * @param {Object} [options]    An Object with options. Available options:
   *                              {function} [filter] filter items
   *                              {String | function} [order] Order the items by
   *                                  a field name or custom sort function.
   * @return {Array} ids
   */
  DataView.prototype.getIds = function (options) {
    var ids;

    if (this._data) {
      var defaultFilter = this._options.filter;
      var filter;

      if (options && options.filter) {
        if (defaultFilter) {
          filter = function filter(item) {
            return defaultFilter(item) && options.filter(item);
          };
        } else {
          filter = options.filter;
        }
      } else {
        filter = defaultFilter;
      }

      ids = this._data.getIds({
        filter: filter,
        order: options && options.order
      });
    } else {
      ids = [];
    }

    return ids;
  };

  /**
   * Map every item in the dataset.
   * @param {function} callback
   * @param {Object} [options]    Available options:
   *                              {Object.<String, String>} [type]
   *                              {String[]} [fields] filter fields
   *                              {function} [filter] filter items
   *                              {String | function} [order] Order the items by
   *                                  a field name or custom sort function.
   * @return {Object[]} mappedItems
   */
  DataView.prototype.map = function (callback, options) {
    var mappedItems = [];
    if (this._data) {
      var defaultFilter = this._options.filter;
      var filter;

      if (options && options.filter) {
        if (defaultFilter) {
          filter = function filter(item) {
            return defaultFilter(item) && options.filter(item);
          };
        } else {
          filter = options.filter;
        }
      } else {
        filter = defaultFilter;
      }

      mappedItems = this._data.map(callback, {
        filter: filter,
        order: options && options.order
      });
    } else {
      mappedItems = [];
    }

    return mappedItems;
  };

  /**
   * Get the DataSet to which this DataView is connected. In case there is a chain
   * of multiple DataViews, the root DataSet of this chain is returned.
   * @return {DataSet} dataSet
   */
  DataView.prototype.getDataSet = function () {
    var dataSet = this;
    while (dataSet instanceof DataView) {
      dataSet = dataSet._data;
    }
    return dataSet || null;
  };

  /**
   * Event listener. Will propagate all events from the connected data set to
   * the subscribers of the DataView, but will filter the items and only trigger
   * when there are changes in the filtered data set.
   * @param {String} event
   * @param {Object | null} params
   * @param {String} senderId
   * @private
   */
  DataView.prototype._onEvent = function (event, params, senderId) {
    var i, len, id, item;
    var ids = params && params.items;
    var addedIds = [],
        updatedIds = [],
        removedIds = [],
        oldItems = [],
        updatedItems = [],
        removedItems = [];

    if (ids && this._data) {
      switch (event) {
        case 'add':
          // filter the ids of the added items
          for (i = 0, len = ids.length; i < len; i++) {
            id = ids[i];
            item = this.get(id);
            if (item) {
              this._ids[id] = true;
              addedIds.push(id);
            }
          }

          break;

        case 'update':
          // determine the event from the views viewpoint: an updated
          // item can be added, updated, or removed from this view.
          for (i = 0, len = ids.length; i < len; i++) {
            id = ids[i];
            item = this.get(id);

            if (item) {
              if (this._ids[id]) {
                updatedIds.push(id);
                updatedItems.push(params.data[i]);
                oldItems.push(params.oldData[i]);
              } else {
                this._ids[id] = true;
                addedIds.push(id);
              }
            } else {
              if (this._ids[id]) {
                delete this._ids[id];
                removedIds.push(id);
                removedItems.push(params.oldData[i]);
              } else {
                // nothing interesting for me :-(
              }
            }
          }

          break;

        case 'remove':
          // filter the ids of the removed items
          for (i = 0, len = ids.length; i < len; i++) {
            id = ids[i];
            if (this._ids[id]) {
              delete this._ids[id];
              removedIds.push(id);
              removedItems.push(params.oldData[i]);
            }
          }

          break;
      }

      this.length += addedIds.length - removedIds.length;

      if (addedIds.length) {
        this._trigger('add', { items: addedIds }, senderId);
      }
      if (updatedIds.length) {
        this._trigger('update', { items: updatedIds, oldData: oldItems, data: updatedItems }, senderId);
      }
      if (removedIds.length) {
        this._trigger('remove', { items: removedIds, oldData: removedItems }, senderId);
      }
    }
  };

  // copy subscription functionality from DataSet
  DataView.prototype.on = DataSet.prototype.on;
  DataView.prototype.off = DataSet.prototype.off;
  DataView.prototype._trigger = DataSet.prototype._trigger;

  // TODO: make these functions deprecated (replaced with `on` and `off` since version 0.5)
  DataView.prototype.subscribe = DataView.prototype.on;
  DataView.prototype.unsubscribe = DataView.prototype.off;

  module.exports = DataView;

/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var Emitter = __webpack_require__(95);var DataSet = __webpack_require__(91);
  var DataView = __webpack_require__(93);
  var util = __webpack_require__(1);
  var Point3d = __webpack_require__(96);
  var Point2d = __webpack_require__(97);
  var Camera = __webpack_require__(98);
  var Filter = __webpack_require__(103);
  var Slider = __webpack_require__(104);
  var StepNumber = __webpack_require__(105);
  var Range = __webpack_require__(106);
  var Settings = __webpack_require__(107);

  /// enumerate the available styles
  Graph3d.STYLE = Settings.STYLE;

  /**
   * Following label is used in the settings to describe values which should be
   * determined by the code while running, from the current data and graph style.
   * 
   * Using 'undefined' directly achieves the same thing, but this is more
   * descriptive by describing the intent.
   */
  var autoByDefault = undefined;

  /**
   * Default values for option settings.
   *
   * These are the values used when a Graph3d instance is initialized without
   * custom settings.
   *
   * If a field is not in this list, a default value of 'autoByDefault' is assumed,
   * which is just an alias for 'undefined'.
   */
  var DEFAULTS = {
    width: '400px',
    height: '400px',
    filterLabel: 'time',
    legendLabel: 'value',
    xLabel: 'x',
    yLabel: 'y',
    zLabel: 'z',
    xValueLabel: function xValueLabel(v) {
      return v;
    },
    yValueLabel: function yValueLabel(v) {
      return v;
    },
    zValueLabel: function zValueLabel(v) {
      return v;
    },
    showGrid: true,
    showPerspective: true,
    showShadow: false,
    keepAspectRatio: true,
    verticalRatio: 0.5, // 0.1 to 1.0, where 1.0 results in a 'cube'
    dotSizeRatio: 0.02, // size of the dots as a fraction of the graph width

    showAnimationControls: autoByDefault,
    animationInterval: 1000, // milliseconds
    animationPreload: false,
    animationAutoStart: autoByDefault,

    axisColor: '#4D4D4D',
    gridColor: '#D3D3D3',
    xCenter: '55%',
    yCenter: '50%',

    style: Graph3d.STYLE.DOT,
    tooltip: false,
    showLegend: autoByDefault, // determined by graph style
    backgroundColor: autoByDefault,

    dataColor: {
      fill: '#7DC1FF',
      stroke: '#3267D2',
      strokeWidth: 1 // px
    },

    cameraPosition: {
      horizontal: 1.0,
      vertical: 0.5,
      distance: 1.7
    },

    xBarWidth: autoByDefault,
    yBarWidth: autoByDefault,
    valueMin: autoByDefault,
    valueMax: autoByDefault,
    xMin: autoByDefault,
    xMax: autoByDefault,
    xStep: autoByDefault,
    yMin: autoByDefault,
    yMax: autoByDefault,
    yStep: autoByDefault,
    zMin: autoByDefault,
    zMax: autoByDefault,
    zStep: autoByDefault
  };

  // -----------------------------------------------------------------------------
  // Class Graph3d
  // -----------------------------------------------------------------------------


  /**
   * @constructor Graph3d
   * Graph3d displays data in 3d.
   *
   * Graph3d is developed in javascript as a Google Visualization Chart.
   *
   * @param {Element} container   The DOM element in which the Graph3d will
   *                              be created. Normally a div element.
   * @param {DataSet | DataView | Array} [data]
   * @param {Object} [options]
   */
  function Graph3d(container, data, options) {
    if (!(this instanceof Graph3d)) {
      throw new SyntaxError('Constructor must be called with the new operator');
    }

    // create variables and set default values
    this.containerElement = container;

    this.dataTable = null; // The original data table
    this.dataPoints = null; // The table with point objects

    // create a frame and canvas
    this.create();

    Settings.setDefaults(DEFAULTS, this);

    // the column indexes
    this.colX = undefined;
    this.colY = undefined;
    this.colZ = undefined;
    this.colValue = undefined;
    this.colFilter = undefined;

    // TODO: customize axis range

    // apply options (also when undefined)
    this.setOptions(options);

    // apply data
    if (data) {
      this.setData(data);
    }
  }

  // Extend Graph3d with an Emitter mixin
  Emitter(Graph3d.prototype);

  /**
   * Calculate the scaling values, dependent on the range in x, y, and z direction
   */
  Graph3d.prototype._setScale = function () {
    this.scale = new Point3d(1 / this.xRange.range(), 1 / this.yRange.range(), 1 / this.zRange.range());

    // keep aspect ration between x and y scale if desired
    if (this.keepAspectRatio) {
      if (this.scale.x < this.scale.y) {
        //noinspection JSSuspiciousNameCombination
        this.scale.y = this.scale.x;
      } else {
        //noinspection JSSuspiciousNameCombination
        this.scale.x = this.scale.y;
      }
    }

    // scale the vertical axis
    this.scale.z *= this.verticalRatio;
    // TODO: can this be automated? verticalRatio?

    // determine scale for (optional) value
    if (this.valueRange !== undefined) {
      this.scale.value = 1 / this.valueRange.range();
    }

    // position the camera arm
    var xCenter = this.xRange.center() * this.scale.x;
    var yCenter = this.yRange.center() * this.scale.y;
    var zCenter = this.zRange.center() * this.scale.z;
    this.camera.setArmLocation(xCenter, yCenter, zCenter);
  };

  /**
   * Convert a 3D location to a 2D location on screen
   * Source: ttp://en.wikipedia.org/wiki/3D_projection
   *
   * @param   {Point3d} point3d  A 3D point with parameters x, y, z
   * @returns {Point2d} point2d  A 2D point with parameters x, y
   */
  Graph3d.prototype._convert3Dto2D = function (point3d) {
    var translation = this._convertPointToTranslation(point3d);
    return this._convertTranslationToScreen(translation);
  };

  /**
   * Convert a 3D location its translation seen from the camera
   * Source: http://en.wikipedia.org/wiki/3D_projection
   *
   * @param   {Point3d} point3d     A 3D point with parameters x, y, z
   * @returns {Point3d} translation A 3D point with parameters x, y, z This is
   *                                the translation of the point, seen from the
   *                                camera.
   */
  Graph3d.prototype._convertPointToTranslation = function (point3d) {
    var cameraLocation = this.camera.getCameraLocation(),
        cameraRotation = this.camera.getCameraRotation(),
        ax = point3d.x * this.scale.x,
        ay = point3d.y * this.scale.y,
        az = point3d.z * this.scale.z,
        cx = cameraLocation.x,
        cy = cameraLocation.y,
        cz = cameraLocation.z,


    // calculate angles
    sinTx = Math.sin(cameraRotation.x),
        cosTx = Math.cos(cameraRotation.x),
        sinTy = Math.sin(cameraRotation.y),
        cosTy = Math.cos(cameraRotation.y),
        sinTz = Math.sin(cameraRotation.z),
        cosTz = Math.cos(cameraRotation.z),


    // calculate translation
    dx = cosTy * (sinTz * (ay - cy) + cosTz * (ax - cx)) - sinTy * (az - cz),
        dy = sinTx * (cosTy * (az - cz) + sinTy * (sinTz * (ay - cy) + cosTz * (ax - cx))) + cosTx * (cosTz * (ay - cy) - sinTz * (ax - cx)),
        dz = cosTx * (cosTy * (az - cz) + sinTy * (sinTz * (ay - cy) + cosTz * (ax - cx))) - sinTx * (cosTz * (ay - cy) - sinTz * (ax - cx));

    return new Point3d(dx, dy, dz);
  };

  /**
   * Convert a translation point to a point on the screen
   *
   * @param   {Point3d} translation A 3D point with parameters x, y, z This is
   *                                the translation of the point, seen from the
   *                                camera.
   * @returns {Point2d} point2d     A 2D point with parameters x, y
   */
  Graph3d.prototype._convertTranslationToScreen = function (translation) {
    var ex = this.eye.x,
        ey = this.eye.y,
        ez = this.eye.z,
        dx = translation.x,
        dy = translation.y,
        dz = translation.z;

    // calculate position on screen from translation
    var bx;
    var by;
    if (this.showPerspective) {
      bx = (dx - ex) * (ez / dz);
      by = (dy - ey) * (ez / dz);
    } else {
      bx = dx * -(ez / this.camera.getArmLength());
      by = dy * -(ez / this.camera.getArmLength());
    }

    // shift and scale the point to the center of the screen
    // use the width of the graph to scale both horizontally and vertically.
    return new Point2d(this.currentXCenter + bx * this.frame.canvas.clientWidth, this.currentYCenter - by * this.frame.canvas.clientWidth);
  };

  /**
   * Calculate the translations and screen positions of all points
   */
  Graph3d.prototype._calcTranslations = function (points, sort) {
    if (sort === undefined) {
      sort = true;
    }

    for (var i = 0; i < points.length; i++) {
      var point = points[i];
      point.trans = this._convertPointToTranslation(point.point);
      point.screen = this._convertTranslationToScreen(point.trans);

      // calculate the translation of the point at the bottom (needed for sorting)
      var transBottom = this._convertPointToTranslation(point.bottom);
      point.dist = this.showPerspective ? transBottom.length() : -transBottom.z;
    }

    if (!sort) {
      return;
    }

    // sort the points on depth of their (x,y) position (not on z)
    var sortDepth = function sortDepth(a, b) {
      return b.dist - a.dist;
    };
    points.sort(sortDepth);
  };

  Graph3d.prototype.getNumberOfRows = function (data) {
    return data.length;
  };

  Graph3d.prototype.getNumberOfColumns = function (data) {
    var counter = 0;
    for (var column in data[0]) {
      if (data[0].hasOwnProperty(column)) {
        counter++;
      }
    }
    return counter;
  };

  Graph3d.prototype.getDistinctValues = function (data, column) {
    var distinctValues = [];
    for (var i = 0; i < data.length; i++) {
      if (distinctValues.indexOf(data[i][column]) == -1) {
        distinctValues.push(data[i][column]);
      }
    }
    return distinctValues;
  };

  /**
   * Get the absolute min/max values for the passed data column.
   *
   * @returns {Range} A Range instance with min/max members properly set.
   */
  Graph3d.prototype.getColumnRange = function (data, column) {
    var range = new Range();

    // Adjust the range so that it covers all values in the passed data elements.
    for (var i = 0; i < data.length; i++) {
      var item = data[i][column];
      range.adjust(item);
    }

    return range;
  };

  /**
   * Check if the state is consistent for the use of the value field.
   *
   * Throws if a problem is detected.
   */
  Graph3d.prototype._checkValueField = function (data) {

    var hasValueField = this.style === Graph3d.STYLE.BARCOLOR || this.style === Graph3d.STYLE.BARSIZE || this.style === Graph3d.STYLE.DOTCOLOR || this.style === Graph3d.STYLE.DOTSIZE;

    if (!hasValueField) {
      return; // No need to check further
    }

    // Following field must be present for the current graph style
    if (this.colValue === undefined) {
      throw new Error('Expected data to have ' + ' field \'style\' ' + ' for graph style \'' + this.style + '\'');
    }

    // The data must also contain this field.
    // Note that only first data element is checked.
    if (data[0][this.colValue] === undefined) {
      throw new Error('Expected data to have ' + ' field \'' + this.colValue + '\' ' + ' for graph style \'' + this.style + '\'');
    }
  };

  /**
   * Set default values for range
   *
   * The default values override the range values, if defined.
   *
   * Because it's possible that only defaultMin or defaultMax is set, it's better
   * to pass in a range already set with the min/max set from the data. Otherwise,
   * it's quite hard to process the min/max properly.
   */
  Graph3d.prototype._setRangeDefaults = function (range, defaultMin, defaultMax) {
    if (defaultMin !== undefined) {
      range.min = defaultMin;
    }

    if (defaultMax !== undefined) {
      range.max = defaultMax;
    }

    // This is the original way that the default min/max values were adjusted.
    // TODO: Perhaps it's better if an error is thrown if the values do not agree.
    //       But this will change the behaviour.
    if (range.max <= range.min) range.max = range.min + 1;
  };

  /**
   * Initialize the data from the data table. Calculate minimum and maximum values
   * and column index values
   * @param {Array | DataSet | DataView} rawData The data containing the items for
   *                                             the Graph.
   * @param {Number}                     style   Style Number
   */
  Graph3d.prototype._dataInitialize = function (rawData, style) {
    var me = this;

    // unsubscribe from the dataTable
    if (this.dataSet) {
      this.dataSet.off('*', this._onChange);
    }

    if (rawData === undefined) return;

    if (Array.isArray(rawData)) {
      rawData = new DataSet(rawData);
    }

    var data;
    if (rawData instanceof DataSet || rawData instanceof DataView) {
      data = rawData.get();
    } else {
      throw new Error('Array, DataSet, or DataView expected');
    }

    if (data.length == 0) return;

    this.dataSet = rawData;
    this.dataTable = data;

    // subscribe to changes in the dataset
    this._onChange = function () {
      me.setData(me.dataSet);
    };
    this.dataSet.on('*', this._onChange);

    // determine the location of x,y,z,value,filter columns
    this.colX = 'x';
    this.colY = 'y';
    this.colZ = 'z';

    var withBars = this.style == Graph3d.STYLE.BAR || this.style == Graph3d.STYLE.BARCOLOR || this.style == Graph3d.STYLE.BARSIZE;

    // determine barWidth from data
    if (withBars) {
      if (this.defaultXBarWidth !== undefined) {
        this.xBarWidth = this.defaultXBarWidth;
      } else {
        var dataX = this.getDistinctValues(data, this.colX);
        this.xBarWidth = dataX[1] - dataX[0] || 1;
      }

      if (this.defaultYBarWidth !== undefined) {
        this.yBarWidth = this.defaultYBarWidth;
      } else {
        var dataY = this.getDistinctValues(data, this.colY);
        this.yBarWidth = dataY[1] - dataY[0] || 1;
      }
    }

    // calculate minimums and maximums
    var NUMSTEPS = 5;

    var xRange = this.getColumnRange(data, this.colX);
    if (withBars) {
      xRange.expand(this.xBarWidth / 2);
    }
    this._setRangeDefaults(xRange, this.defaultXMin, this.defaultXMax);
    this.xRange = xRange;
    this.xStep = this.defaultXStep !== undefined ? this.defaultXStep : xRange.range() / NUMSTEPS;

    var yRange = this.getColumnRange(data, this.colY);
    if (withBars) {
      yRange.expand(this.yBarWidth / 2);
    }
    this._setRangeDefaults(yRange, this.defaultYMin, this.defaultYMax);
    this.yRange = yRange;
    this.yStep = this.defaultYStep !== undefined ? this.defaultYStep : yRange.range() / NUMSTEPS;

    var zRange = this.getColumnRange(data, this.colZ);
    this._setRangeDefaults(zRange, this.defaultZMin, this.defaultZMax);
    this.zRange = zRange;
    this.zStep = this.defaultZStep !== undefined ? this.defaultZStep : zRange.range() / NUMSTEPS;

    if (data[0].hasOwnProperty('style')) {
      this.colValue = 'style';
      var valueRange = this.getColumnRange(data, this.colValue);
      this._setRangeDefaults(valueRange, this.defaultValueMin, this.defaultValueMax);
      this.valueRange = valueRange;
    }

    // check if a filter column is provided
    // Needs to be started after zRange is defined
    if (data[0].hasOwnProperty('filter')) {
      // Only set this field if it's actually present
      this.colFilter = 'filter';

      if (this.dataFilter === undefined) {
        this.dataFilter = new Filter(rawData, this.colFilter, this);
        this.dataFilter.setOnLoadCallback(function () {
          me.redraw();
        });
      }
    }

    // set the scale dependent on the ranges.
    this._setScale();
  };

  /**
   * Filter the data based on the current filter
   *
   * @param   {Array} data
   * @returns {Array} dataPoints Array with point objects which can be drawn on
   *                             screen
   */
  Graph3d.prototype._getDataPoints = function (data) {
    // TODO: store the created matrix dataPoints in the filters instead of
    //       reloading each time.
    var x, y, i, z, obj, point;

    var dataPoints = [];

    if (this.style === Graph3d.STYLE.GRID || this.style === Graph3d.STYLE.SURFACE) {
      // copy all values from the google data table to a matrix
      // the provided values are supposed to form a grid of (x,y) positions

      // create two lists with all present x and y values
      var dataX = [];
      var dataY = [];
      for (i = 0; i < this.getNumberOfRows(data); i++) {
        x = data[i][this.colX] || 0;
        y = data[i][this.colY] || 0;

        if (dataX.indexOf(x) === -1) {
          dataX.push(x);
        }
        if (dataY.indexOf(y) === -1) {
          dataY.push(y);
        }
      }

      var sortNumber = function sortNumber(a, b) {
        return a - b;
      };
      dataX.sort(sortNumber);
      dataY.sort(sortNumber);

      // create a grid, a 2d matrix, with all values.
      var dataMatrix = []; // temporary data matrix
      for (i = 0; i < data.length; i++) {
        x = data[i][this.colX] || 0;
        y = data[i][this.colY] || 0;
        z = data[i][this.colZ] || 0;

        // TODO: implement Array().indexOf() for Internet Explorer
        var xIndex = dataX.indexOf(x);
        var yIndex = dataY.indexOf(y);

        if (dataMatrix[xIndex] === undefined) {
          dataMatrix[xIndex] = [];
        }

        var point3d = new Point3d();
        point3d.x = x;
        point3d.y = y;
        point3d.z = z;
        point3d.data = data[i];

        obj = {};
        obj.point = point3d;
        obj.trans = undefined;
        obj.screen = undefined;
        obj.bottom = new Point3d(x, y, this.zRange.min);

        dataMatrix[xIndex][yIndex] = obj;

        dataPoints.push(obj);
      }

      // fill in the pointers to the neighbors.
      for (x = 0; x < dataMatrix.length; x++) {
        for (y = 0; y < dataMatrix[x].length; y++) {
          if (dataMatrix[x][y]) {
            dataMatrix[x][y].pointRight = x < dataMatrix.length - 1 ? dataMatrix[x + 1][y] : undefined;
            dataMatrix[x][y].pointTop = y < dataMatrix[x].length - 1 ? dataMatrix[x][y + 1] : undefined;
            dataMatrix[x][y].pointCross = x < dataMatrix.length - 1 && y < dataMatrix[x].length - 1 ? dataMatrix[x + 1][y + 1] : undefined;
          }
        }
      }
    } else {
      // 'dot', 'dot-line', etc.
      this._checkValueField(data);

      // copy all values from the google data table to a list with Point3d objects
      for (i = 0; i < data.length; i++) {
        point = new Point3d();
        point.x = data[i][this.colX] || 0;
        point.y = data[i][this.colY] || 0;
        point.z = data[i][this.colZ] || 0;
        point.data = data[i];

        if (this.colValue !== undefined) {
          point.value = data[i][this.colValue] || 0;
        }

        obj = {};
        obj.point = point;
        obj.bottom = new Point3d(point.x, point.y, this.zRange.min);
        obj.trans = undefined;
        obj.screen = undefined;

        if (this.style === Graph3d.STYLE.LINE) {
          if (i > 0) {
            // Add next point for line drawing
            dataPoints[i - 1].pointNext = obj;
          }
        }

        dataPoints.push(obj);
      }
    }

    return dataPoints;
  };

  /**
   * Create the main frame for the Graph3d.
   *
   * This function is executed once when a Graph3d object is created. The frame
   * contains a canvas, and this canvas contains all objects like the axis and
   * nodes.
   */
  Graph3d.prototype.create = function () {
    // remove all elements from the container element.
    while (this.containerElement.hasChildNodes()) {
      this.containerElement.removeChild(this.containerElement.firstChild);
    }

    this.frame = document.createElement('div');
    this.frame.style.position = 'relative';
    this.frame.style.overflow = 'hidden';

    // create the graph canvas (HTML canvas element)
    this.frame.canvas = document.createElement('canvas');
    this.frame.canvas.style.position = 'relative';
    this.frame.appendChild(this.frame.canvas);
    //if (!this.frame.canvas.getContext) {
    {
      var noCanvas = document.createElement('DIV');
      noCanvas.style.color = 'red';
      noCanvas.style.fontWeight = 'bold';
      noCanvas.style.padding = '10px';
      noCanvas.innerHTML = 'Error: your browser does not support HTML canvas';
      this.frame.canvas.appendChild(noCanvas);
    }

    this.frame.filter = document.createElement('div');
    this.frame.filter.style.position = 'absolute';
    this.frame.filter.style.bottom = '0px';
    this.frame.filter.style.left = '0px';
    this.frame.filter.style.width = '100%';
    this.frame.appendChild(this.frame.filter);

    // add event listeners to handle moving and zooming the contents
    var me = this;
    var onmousedown = function onmousedown(event) {
      me._onMouseDown(event);
    };
    var ontouchstart = function ontouchstart(event) {
      me._onTouchStart(event);
    };
    var onmousewheel = function onmousewheel(event) {
      me._onWheel(event);
    };
    var ontooltip = function ontooltip(event) {
      me._onTooltip(event);
    };
    var onclick = function onclick(event) {
      me._onClick(event);
    };
    // TODO: these events are never cleaned up... can give a 'memory leakage'

    util.addEventListener(this.frame.canvas, 'keydown', onkeydown);
    util.addEventListener(this.frame.canvas, 'mousedown', onmousedown);
    util.addEventListener(this.frame.canvas, 'touchstart', ontouchstart);
    util.addEventListener(this.frame.canvas, 'mousewheel', onmousewheel);
    util.addEventListener(this.frame.canvas, 'mousemove', ontooltip);
    util.addEventListener(this.frame.canvas, 'click', onclick);

    // add the new graph to the container element
    this.containerElement.appendChild(this.frame);
  };

  /**
   * Set a new size for the graph
   */
  Graph3d.prototype._setSize = function (width, height) {
    this.frame.style.width = width;
    this.frame.style.height = height;

    this._resizeCanvas();
  };

  /**
   * Resize the canvas to the current size of the frame
   */
  Graph3d.prototype._resizeCanvas = function () {
    this.frame.canvas.style.width = '100%';
    this.frame.canvas.style.height = '100%';

    this.frame.canvas.width = this.frame.canvas.clientWidth;
    this.frame.canvas.height = this.frame.canvas.clientHeight;

    // adjust with for margin
    this.frame.filter.style.width = this.frame.canvas.clientWidth - 2 * 10 + 'px';
  };

  /**
   * Start animation
   */
  Graph3d.prototype.animationStart = function () {
    if (!this.frame.filter || !this.frame.filter.slider) throw new Error('No animation available');

    this.frame.filter.slider.play();
  };

  /**
   * Stop animation
   */
  Graph3d.prototype.animationStop = function () {
    if (!this.frame.filter || !this.frame.filter.slider) return;

    this.frame.filter.slider.stop();
  };

  /**
   * Resize the center position based on the current values in this.xCenter
   * and this.yCenter (which are strings with a percentage or a value
   * in pixels). The center positions are the variables this.currentXCenter
   * and this.currentYCenter
   */
  Graph3d.prototype._resizeCenter = function () {
    // calculate the horizontal center position
    if (this.xCenter.charAt(this.xCenter.length - 1) === '%') {
      this.currentXCenter = parseFloat(this.xCenter) / 100 * this.frame.canvas.clientWidth;
    } else {
      this.currentXCenter = parseFloat(this.xCenter); // supposed to be in px
    }

    // calculate the vertical center position
    if (this.yCenter.charAt(this.yCenter.length - 1) === '%') {
      this.currentYCenter = parseFloat(this.yCenter) / 100 * (this.frame.canvas.clientHeight - this.frame.filter.clientHeight);
    } else {
      this.currentYCenter = parseFloat(this.yCenter); // supposed to be in px
    }
  };

  /**
   * Retrieve the current camera rotation
   *
   * @returns {object} An object with parameters horizontal, vertical, and
   *                   distance
   */
  Graph3d.prototype.getCameraPosition = function () {
    var pos = this.camera.getArmRotation();
    pos.distance = this.camera.getArmLength();
    return pos;
  };

  /**
   * Load data into the 3D Graph
   */
  Graph3d.prototype._readData = function (data) {
    // read the data
    this._dataInitialize(data, this.style);

    if (this.dataFilter) {
      // apply filtering
      this.dataPoints = this.dataFilter._getDataPoints();
    } else {
      // no filtering. load all data
      this.dataPoints = this._getDataPoints(this.dataTable);
    }

    // draw the filter
    this._redrawFilter();
  };

  /**
   * Replace the dataset of the Graph3d
   *
   * @param {Array | DataSet | DataView} data
   */
  Graph3d.prototype.setData = function (data) {
    this._readData(data);
    this.redraw();

    // start animation when option is true
    if (this.animationAutoStart && this.dataFilter) {
      this.animationStart();
    }
  };

  /**
   * Update the options. Options will be merged with current options
   *
   * @param {Object} options
   */
  Graph3d.prototype.setOptions = function (options) {
    var cameraPosition = undefined;

    this.animationStop();

    Settings.setOptions(options, this);

    this.setPointDrawingMethod();
    this._setSize(this.width, this.height);

    // re-load the data
    if (this.dataTable) {
      this.setData(this.dataTable);
    }

    // start animation when option is true
    if (this.animationAutoStart && this.dataFilter) {
      this.animationStart();
    }
  };

  /**
   * Determine which point drawing method to use for the current graph style.
   */
  Graph3d.prototype.setPointDrawingMethod = function () {
    var method = undefined;

    switch (this.style) {
      case Graph3d.STYLE.BAR:
        method = Graph3d.prototype._redrawBarGraphPoint;
        break;
      case Graph3d.STYLE.BARCOLOR:
        method = Graph3d.prototype._redrawBarColorGraphPoint;
        break;
      case Graph3d.STYLE.BARSIZE:
        method = Graph3d.prototype._redrawBarSizeGraphPoint;
        break;
      case Graph3d.STYLE.DOT:
        method = Graph3d.prototype._redrawDotGraphPoint;
        break;
      case Graph3d.STYLE.DOTLINE:
        method = Graph3d.prototype._redrawDotLineGraphPoint;
        break;
      case Graph3d.STYLE.DOTCOLOR:
        method = Graph3d.prototype._redrawDotColorGraphPoint;
        break;
      case Graph3d.STYLE.DOTSIZE:
        method = Graph3d.prototype._redrawDotSizeGraphPoint;
        break;
      case Graph3d.STYLE.SURFACE:
        method = Graph3d.prototype._redrawSurfaceGraphPoint;
        break;
      case Graph3d.STYLE.GRID:
        method = Graph3d.prototype._redrawGridGraphPoint;
        break;
      case Graph3d.STYLE.LINE:
        method = Graph3d.prototype._redrawLineGraphPoint;
        break;
      default:
        throw new Error('Can not determine point drawing method ' + 'for graph style \'' + this.style + '\'');
        break;
    }

    this._pointDrawingMethod = method;
  };

  /**
   * Redraw the Graph.
   */
  Graph3d.prototype.redraw = function () {
    if (this.dataPoints === undefined) {
      throw new Error('Graph data not initialized');
    }

    this._resizeCanvas();
    this._resizeCenter();
    this._redrawSlider();
    this._redrawClear();
    this._redrawAxis();

    this._redrawDataGraph();

    this._redrawInfo();
    this._redrawLegend();
  };

  /**
   * Get drawing context without exposing canvas
   */
  Graph3d.prototype._getContext = function () {
    var canvas = this.frame.canvas;
    var ctx = canvas.getContext('2d');

    ctx.lineJoin = 'round';
    ctx.lineCap = 'round';

    return ctx;
  };

  /**
   * Clear the canvas before redrawing
   */
  Graph3d.prototype._redrawClear = function () {
    var canvas = this.frame.canvas;
    var ctx = canvas.getContext('2d');

    ctx.clearRect(0, 0, canvas.width, canvas.height);
  };

  Graph3d.prototype._dotSize = function () {
    return this.frame.clientWidth * this.dotSizeRatio;
  };

  /**
   * Get legend width
   */
  Graph3d.prototype._getLegendWidth = function () {
    var width;

    if (this.style === Graph3d.STYLE.DOTSIZE) {
      var dotSize = this._dotSize();
      width = dotSize / 2 + dotSize * 2;
    } else if (this.style === Graph3d.STYLE.BARSIZE) {
      width = this.xBarWidth;
    } else {
      width = 20;
    }
    return width;
  };

  /**
   * Redraw the legend based on size, dot color, or surface height
   */
  Graph3d.prototype._redrawLegend = function () {

    //Return without drawing anything, if no legend is specified
    if (this.showLegend !== true) {
      return;
    }

    // Do not draw legend when graph style does not support
    if (this.style === Graph3d.STYLE.LINE || this.style === Graph3d.STYLE.BARSIZE //TODO add legend support for BARSIZE
    ) {
        return;
      }

    // Legend types - size and color. Determine if size legend.
    var isSizeLegend = this.style === Graph3d.STYLE.BARSIZE || this.style === Graph3d.STYLE.DOTSIZE;

    // Legend is either tracking z values or style values. This flag if false means use z values.
    var isValueLegend = this.style === Graph3d.STYLE.DOTSIZE || this.style === Graph3d.STYLE.DOTCOLOR || this.style === Graph3d.STYLE.BARCOLOR;

    var height = Math.max(this.frame.clientHeight * 0.25, 100);
    var top = this.margin;
    var width = this._getLegendWidth(); // px - overwritten by size legend
    var right = this.frame.clientWidth - this.margin;
    var left = right - width;
    var bottom = top + height;

    var ctx = this._getContext();
    ctx.lineWidth = 1;
    ctx.font = '14px arial'; // TODO: put in options

    if (isSizeLegend === false) {
      // draw the color bar
      var ymin = 0;
      var ymax = height; // Todo: make height customizable
      var y;

      for (y = ymin; y < ymax; y++) {
        var f = (y - ymin) / (ymax - ymin);
        var hue = f * 240;
        var color = this._hsv2rgb(hue, 1, 1);

        ctx.strokeStyle = color;
        ctx.beginPath();
        ctx.moveTo(left, top + y);
        ctx.lineTo(right, top + y);
        ctx.stroke();
      }
      ctx.strokeStyle = this.axisColor;
      ctx.strokeRect(left, top, width, height);
    } else {

      // draw the size legend box
      var widthMin;
      if (this.style === Graph3d.STYLE.DOTSIZE) {
        var dotSize = this._dotSize();
        widthMin = dotSize / 2; // px
      } else if (this.style === Graph3d.STYLE.BARSIZE) {
        //widthMin = this.xBarWidth * 0.2 this is wrong - barwidth measures in terms of xvalues
      }
      ctx.strokeStyle = this.axisColor;
      ctx.fillStyle = this.dataColor.fill;
      ctx.beginPath();
      ctx.moveTo(left, top);
      ctx.lineTo(right, top);
      ctx.lineTo(right - width + widthMin, bottom);
      ctx.lineTo(left, bottom);
      ctx.closePath();
      ctx.fill();
      ctx.stroke();
    }

    // print value text along the legend edge
    var gridLineLen = 5; // px

    var legendMin = isValueLegend ? this.valueRange.min : this.zRange.min;
    var legendMax = isValueLegend ? this.valueRange.max : this.zRange.max;
    var step = new StepNumber(legendMin, legendMax, (legendMax - legendMin) / 5, true);
    step.start(true);

    var y;
    var from;
    var to;
    while (!step.end()) {
      y = bottom - (step.getCurrent() - legendMin) / (legendMax - legendMin) * height;
      from = new Point2d(left - gridLineLen, y);
      to = new Point2d(left, y);
      this._line(ctx, from, to);

      ctx.textAlign = 'right';
      ctx.textBaseline = 'middle';
      ctx.fillStyle = this.axisColor;
      ctx.fillText(step.getCurrent(), left - 2 * gridLineLen, y);

      step.next();
    }

    ctx.textAlign = 'right';
    ctx.textBaseline = 'top';
    var label = this.legendLabel;
    ctx.fillText(label, right, bottom + this.margin);
  };

  /**
   * Redraw the filter
   */
  Graph3d.prototype._redrawFilter = function () {
    this.frame.filter.innerHTML = '';

    if (this.dataFilter) {
      var options = {
        'visible': this.showAnimationControls
      };
      var slider = new Slider(this.frame.filter, options);
      this.frame.filter.slider = slider;

      // TODO: css here is not nice here...
      this.frame.filter.style.padding = '10px';
      //this.frame.filter.style.backgroundColor = '#EFEFEF';

      slider.setValues(this.dataFilter.values);
      slider.setPlayInterval(this.animationInterval);

      // create an event handler
      var me = this;
      var onchange = function onchange() {
        var index = slider.getIndex();

        me.dataFilter.selectValue(index);
        me.dataPoints = me.dataFilter._getDataPoints();

        me.redraw();
      };
      slider.setOnChangeCallback(onchange);
    } else {
      this.frame.filter.slider = undefined;
    }
  };

  /**
   * Redraw the slider
   */
  Graph3d.prototype._redrawSlider = function () {
    if (this.frame.filter.slider !== undefined) {
      this.frame.filter.slider.redraw();
    }
  };

  /**
   * Redraw common information
   */
  Graph3d.prototype._redrawInfo = function () {
    if (this.dataFilter) {
      var ctx = this._getContext();

      ctx.font = '14px arial'; // TODO: put in options
      ctx.lineStyle = 'gray';
      ctx.fillStyle = 'gray';
      ctx.textAlign = 'left';
      ctx.textBaseline = 'top';

      var x = this.margin;
      var y = this.margin;
      ctx.fillText(this.dataFilter.getLabel() + ': ' + this.dataFilter.getSelectedValue(), x, y);
    }
  };

  /**
   * Draw a line between 2d points 'from' and 'to'.
   *
   * If stroke style specified, set that as well.
   */
  Graph3d.prototype._line = function (ctx, from, to, strokeStyle) {
    if (strokeStyle !== undefined) {
      ctx.strokeStyle = strokeStyle;
    }

    ctx.beginPath();
    ctx.moveTo(from.x, from.y);
    ctx.lineTo(to.x, to.y);
    ctx.stroke();
  };

  Graph3d.prototype.drawAxisLabelX = function (ctx, point3d, text, armAngle, yMargin) {
    if (yMargin === undefined) {
      yMargin = 0;
    }

    var point2d = this._convert3Dto2D(point3d);

    if (Math.cos(armAngle * 2) > 0) {
      ctx.textAlign = 'center';
      ctx.textBaseline = 'top';
      point2d.y += yMargin;
    } else if (Math.sin(armAngle * 2) < 0) {
      ctx.textAlign = 'right';
      ctx.textBaseline = 'middle';
    } else {
      ctx.textAlign = 'left';
      ctx.textBaseline = 'middle';
    }

    ctx.fillStyle = this.axisColor;
    ctx.fillText(text, point2d.x, point2d.y);
  };

  Graph3d.prototype.drawAxisLabelY = function (ctx, point3d, text, armAngle, yMargin) {
    if (yMargin === undefined) {
      yMargin = 0;
    }

    var point2d = this._convert3Dto2D(point3d);

    if (Math.cos(armAngle * 2) < 0) {
      ctx.textAlign = 'center';
      ctx.textBaseline = 'top';
      point2d.y += yMargin;
    } else if (Math.sin(armAngle * 2) > 0) {
      ctx.textAlign = 'right';
      ctx.textBaseline = 'middle';
    } else {
      ctx.textAlign = 'left';
      ctx.textBaseline = 'middle';
    }

    ctx.fillStyle = this.axisColor;
    ctx.fillText(text, point2d.x, point2d.y);
  };

  Graph3d.prototype.drawAxisLabelZ = function (ctx, point3d, text, offset) {
    if (offset === undefined) {
      offset = 0;
    }

    var point2d = this._convert3Dto2D(point3d);
    ctx.textAlign = 'right';
    ctx.textBaseline = 'middle';
    ctx.fillStyle = this.axisColor;
    ctx.fillText(text, point2d.x - offset, point2d.y);
  };

  /**


  /**
   * Draw a line between 2d points 'from' and 'to'.
   *
   * If stroke style specified, set that as well.
   */
  Graph3d.prototype._line3d = function (ctx, from, to, strokeStyle) {
    var from2d = this._convert3Dto2D(from);
    var to2d = this._convert3Dto2D(to);

    this._line(ctx, from2d, to2d, strokeStyle);
  };

  /**
   * Redraw the axis
   */
  Graph3d.prototype._redrawAxis = function () {
    var ctx = this._getContext(),
        from,
        to,
        step,
        prettyStep,
        text,
        xText,
        yText,
        zText,
        offset,
        xOffset,
        yOffset;

    // TODO: get the actual rendered style of the containerElement
    //ctx.font = this.containerElement.style.font;
    ctx.font = 24 / this.camera.getArmLength() + 'px arial';

    // calculate the length for the short grid lines
    var gridLenX = 0.025 / this.scale.x;
    var gridLenY = 0.025 / this.scale.y;
    var textMargin = 5 / this.camera.getArmLength(); // px
    var armAngle = this.camera.getArmRotation().horizontal;
    var armVector = new Point2d(Math.cos(armAngle), Math.sin(armAngle));

    var xRange = this.xRange;
    var yRange = this.yRange;
    var zRange = this.zRange;

    // draw x-grid lines
    ctx.lineWidth = 1;
    prettyStep = this.defaultXStep === undefined;
    step = new StepNumber(xRange.min, xRange.max, this.xStep, prettyStep);
    step.start(true);

    while (!step.end()) {
      var x = step.getCurrent();

      if (this.showGrid) {
        from = new Point3d(x, yRange.min, zRange.min);
        to = new Point3d(x, yRange.max, zRange.min);
        this._line3d(ctx, from, to, this.gridColor);
      } else {
        from = new Point3d(x, yRange.min, zRange.min);
        to = new Point3d(x, yRange.min + gridLenX, zRange.min);
        this._line3d(ctx, from, to, this.axisColor);

        from = new Point3d(x, yRange.max, zRange.min);
        to = new Point3d(x, yRange.max - gridLenX, zRange.min);
        this._line3d(ctx, from, to, this.axisColor);
      }

      yText = armVector.x > 0 ? yRange.min : yRange.max;
      var point3d = new Point3d(x, yText, zRange.min);
      var msg = '  ' + this.xValueLabel(x) + '  ';
      this.drawAxisLabelX(ctx, point3d, msg, armAngle, textMargin);

      step.next();
    }

    // draw y-grid lines
    ctx.lineWidth = 1;
    prettyStep = this.defaultYStep === undefined;
    step = new StepNumber(yRange.min, yRange.max, this.yStep, prettyStep);
    step.start(true);

    while (!step.end()) {
      var y = step.getCurrent();

      if (this.showGrid) {
        from = new Point3d(xRange.min, y, zRange.min);
        to = new Point3d(xRange.max, y, zRange.min);
        this._line3d(ctx, from, to, this.gridColor);
      } else {
        from = new Point3d(xRange.min, y, zRange.min);
        to = new Point3d(xRange.min + gridLenY, y, zRange.min);
        this._line3d(ctx, from, to, this.axisColor);

        from = new Point3d(xRange.max, y, zRange.min);
        to = new Point3d(xRange.max - gridLenY, y, zRange.min);
        this._line3d(ctx, from, to, this.axisColor);
      }

      xText = armVector.y > 0 ? xRange.min : xRange.max;
      point3d = new Point3d(xText, y, zRange.min);
      var msg = '  ' + this.yValueLabel(y) + '  ';
      this.drawAxisLabelY(ctx, point3d, msg, armAngle, textMargin);

      step.next();
    }

    // draw z-grid lines and axis
    ctx.lineWidth = 1;
    prettyStep = this.defaultZStep === undefined;
    step = new StepNumber(zRange.min, zRange.max, this.zStep, prettyStep);
    step.start(true);

    xText = armVector.x > 0 ? xRange.min : xRange.max;
    yText = armVector.y < 0 ? yRange.min : yRange.max;

    while (!step.end()) {
      var z = step.getCurrent();

      // TODO: make z-grid lines really 3d?
      var from3d = new Point3d(xText, yText, z);
      var from2d = this._convert3Dto2D(from3d);
      to = new Point2d(from2d.x - textMargin, from2d.y);
      this._line(ctx, from2d, to, this.axisColor);

      var msg = this.zValueLabel(z) + ' ';
      this.drawAxisLabelZ(ctx, from3d, msg, 5);

      step.next();
    }

    ctx.lineWidth = 1;
    from = new Point3d(xText, yText, zRange.min);
    to = new Point3d(xText, yText, zRange.max);
    this._line3d(ctx, from, to, this.axisColor);

    // draw x-axis
    var xMin2d;
    var xMax2d;
    ctx.lineWidth = 1;

    // line at yMin
    xMin2d = new Point3d(xRange.min, yRange.min, zRange.min);
    xMax2d = new Point3d(xRange.max, yRange.min, zRange.min);
    this._line3d(ctx, xMin2d, xMax2d, this.axisColor);
    // line at ymax
    xMin2d = new Point3d(xRange.min, yRange.max, zRange.min);
    xMax2d = new Point3d(xRange.max, yRange.max, zRange.min);
    this._line3d(ctx, xMin2d, xMax2d, this.axisColor);

    // draw y-axis
    ctx.lineWidth = 1;
    // line at xMin
    from = new Point3d(xRange.min, yRange.min, zRange.min);
    to = new Point3d(xRange.min, yRange.max, zRange.min);
    this._line3d(ctx, from, to, this.axisColor);
    // line at xMax
    from = new Point3d(xRange.max, yRange.min, zRange.min);
    to = new Point3d(xRange.max, yRange.max, zRange.min);
    this._line3d(ctx, from, to, this.axisColor);

    // draw x-label
    var xLabel = this.xLabel;
    if (xLabel.length > 0) {
      yOffset = 0.1 / this.scale.y;
      xText = (xRange.max + 3 * xRange.min) / 4;
      yText = armVector.x > 0 ? yRange.min - yOffset : yRange.max + yOffset;
      text = new Point3d(xText, yText, zRange.min);
      this.drawAxisLabelX(ctx, text, xLabel, armAngle);
    }

    // draw y-label
    var yLabel = this.yLabel;
    if (yLabel.length > 0) {
      xOffset = 0.1 / this.scale.x;
      xText = armVector.y > 0 ? xRange.min - xOffset : xRange.max + xOffset;
      yText = (yRange.max + 3 * yRange.min) / 4;
      text = new Point3d(xText, yText, zRange.min);

      this.drawAxisLabelY(ctx, text, yLabel, armAngle);
    }

    // draw z-label
    var zLabel = this.zLabel;
    if (zLabel.length > 0) {
      offset = 30; // pixels.  // TODO: relate to the max width of the values on the z axis?
      xText = armVector.x > 0 ? xRange.min : xRange.max;
      yText = armVector.y < 0 ? yRange.min : yRange.max;
      zText = (zRange.max + 3 * zRange.min) / 4;
      text = new Point3d(xText, yText, zText);

      this.drawAxisLabelZ(ctx, text, zLabel, offset);
    }
  };

  /**
   * Calculate the color based on the given value.
   * @param {Number} H   Hue, a value be between 0 and 360
   * @param {Number} S   Saturation, a value between 0 and 1
   * @param {Number} V   Value, a value between 0 and 1
   */
  Graph3d.prototype._hsv2rgb = function (H, S, V) {
    var R, G, B, C, Hi, X;

    C = V * S;
    Hi = Math.floor(H / 60); // hi = 0,1,2,3,4,5
    X = C * (1 - Math.abs(H / 60 % 2 - 1));

    switch (Hi) {
      case 0:
        R = C;G = X;B = 0;break;
      case 1:
        R = X;G = C;B = 0;break;
      case 2:
        R = 0;G = C;B = X;break;
      case 3:
        R = 0;G = X;B = C;break;
      case 4:
        R = X;G = 0;B = C;break;
      case 5:
        R = C;G = 0;B = X;break;

      default:
        R = 0;G = 0;B = 0;break;
    }

    return 'RGB(' + parseInt(R * 255) + ',' + parseInt(G * 255) + ',' + parseInt(B * 255) + ')';
  };

  Graph3d.prototype._getStrokeWidth = function (point) {
    if (point !== undefined) {
      if (this.showPerspective) {
        return 1 / -point.trans.z * this.dataColor.strokeWidth;
      } else {
        return -(this.eye.z / this.camera.getArmLength()) * this.dataColor.strokeWidth;
      }
    }

    return this.dataColor.strokeWidth;
  };

  // -----------------------------------------------------------------------------
  // Drawing primitives for the graphs
  // -----------------------------------------------------------------------------


  /**
   * Draw a bar element in the view with the given properties.
   */
  Graph3d.prototype._redrawBar = function (ctx, point, xWidth, yWidth, color, borderColor) {
    var i, j, surface;

    // calculate all corner points
    var me = this;
    var point3d = point.point;
    var zMin = this.zRange.min;
    var top = [{ point: new Point3d(point3d.x - xWidth, point3d.y - yWidth, point3d.z) }, { point: new Point3d(point3d.x + xWidth, point3d.y - yWidth, point3d.z) }, { point: new Point3d(point3d.x + xWidth, point3d.y + yWidth, point3d.z) }, { point: new Point3d(point3d.x - xWidth, point3d.y + yWidth, point3d.z) }];
    var bottom = [{ point: new Point3d(point3d.x - xWidth, point3d.y - yWidth, zMin) }, { point: new Point3d(point3d.x + xWidth, point3d.y - yWidth, zMin) }, { point: new Point3d(point3d.x + xWidth, point3d.y + yWidth, zMin) }, { point: new Point3d(point3d.x - xWidth, point3d.y + yWidth, zMin) }];

    // calculate screen location of the points
    top.forEach(function (obj) {
      obj.screen = me._convert3Dto2D(obj.point);
    });
    bottom.forEach(function (obj) {
      obj.screen = me._convert3Dto2D(obj.point);
    });

    // create five sides, calculate both corner points and center points
    var surfaces = [{ corners: top, center: Point3d.avg(bottom[0].point, bottom[2].point) }, { corners: [top[0], top[1], bottom[1], bottom[0]], center: Point3d.avg(bottom[1].point, bottom[0].point) }, { corners: [top[1], top[2], bottom[2], bottom[1]], center: Point3d.avg(bottom[2].point, bottom[1].point) }, { corners: [top[2], top[3], bottom[3], bottom[2]], center: Point3d.avg(bottom[3].point, bottom[2].point) }, { corners: [top[3], top[0], bottom[0], bottom[3]], center: Point3d.avg(bottom[0].point, bottom[3].point) }];
    point.surfaces = surfaces;

    // calculate the distance of each of the surface centers to the camera
    for (j = 0; j < surfaces.length; j++) {
      surface = surfaces[j];
      var transCenter = this._convertPointToTranslation(surface.center);
      surface.dist = this.showPerspective ? transCenter.length() : -transCenter.z;
      // TODO: this dept calculation doesn't work 100% of the cases due to perspective,
      //     but the current solution is fast/simple and works in 99.9% of all cases
      //     the issue is visible in example 14, with graph.setCameraPosition({horizontal: 2.97, vertical: 0.5, distance: 0.9})
    }

    // order the surfaces by their (translated) depth
    surfaces.sort(function (a, b) {
      var diff = b.dist - a.dist;
      if (diff) return diff;

      // if equal depth, sort the top surface last
      if (a.corners === top) return 1;
      if (b.corners === top) return -1;

      // both are equal
      return 0;
    });

    // draw the ordered surfaces
    ctx.lineWidth = this._getStrokeWidth(point);
    ctx.strokeStyle = borderColor;
    ctx.fillStyle = color;
    // NOTE: we start at j=2 instead of j=0 as we don't need to draw the two surfaces at the backside
    for (j = 2; j < surfaces.length; j++) {
      surface = surfaces[j];
      this._polygon(ctx, surface.corners);
    }
  };

  /**
   * Draw a polygon using the passed points and fill it with the passed style and stroke.
   *
   * @param points      an array of points.
   * @param fillStyle   optional; the fill style to set
   * @param strokeStyle optional; the stroke style to set
   */
  Graph3d.prototype._polygon = function (ctx, points, fillStyle, strokeStyle) {
    if (points.length < 2) {
      return;
    }

    if (fillStyle !== undefined) {
      ctx.fillStyle = fillStyle;
    }
    if (strokeStyle !== undefined) {
      ctx.strokeStyle = strokeStyle;
    }
    ctx.beginPath();
    ctx.moveTo(points[0].screen.x, points[0].screen.y);

    for (var i = 1; i < points.length; ++i) {
      var point = points[i];
      ctx.lineTo(point.screen.x, point.screen.y);
    }

    ctx.closePath();
    ctx.fill();
    ctx.stroke(); // TODO: only draw stroke when strokeWidth > 0
  };

  /**
   * @param size optional; if not specified use value from 'this._dotSize()`
   */
  Graph3d.prototype._drawCircle = function (ctx, point, color, borderColor, size) {
    var radius = this._calcRadius(point, size);

    ctx.lineWidth = this._getStrokeWidth(point);
    ctx.strokeStyle = borderColor;
    ctx.fillStyle = color;
    ctx.beginPath();
    ctx.arc(point.screen.x, point.screen.y, radius, 0, Math.PI * 2, true);
    ctx.fill();
    ctx.stroke();
  };

  /**
   * Determine the colors for the 'regular' graph styles.
   */
  Graph3d.prototype._getColorsRegular = function (point) {
    // calculate Hue from the current value. At zMin the hue is 240, at zMax the hue is 0
    var hue = (1 - (point.point.z - this.zRange.min) * this.scale.z / this.verticalRatio) * 240;
    var color = this._hsv2rgb(hue, 1, 1);
    var borderColor = this._hsv2rgb(hue, 1, 0.8);

    return {
      fill: color,
      border: borderColor
    };
  };

  /**
   * Get the colors for the 'color' graph styles.
   * These styles are currently: 'bar-color' and 'dot-color'
   * Color may be set as a string representation of HTML color, like #ff00ff,
   * or calculated from a number, for example, distance from this point
   * The first option is useful when we have some pre-given legend, to which we have to adjust ourselves
   * The second option is useful when we are interested in automatically setting the color, from some value,
   * using some color scale
   */
  Graph3d.prototype._getColorsColor = function (point) {
    // calculate the color based on the value
    var color, borderColor;

    if (typeof point.point.value === "string") {
      color = point.point.value;
      borderColor = point.point.value;
    } else {
      var hue = (1 - (point.point.value - this.valueRange.min) * this.scale.value) * 240;
      color = this._hsv2rgb(hue, 1, 1);
      borderColor = this._hsv2rgb(hue, 1, 0.8);
    }
    return {
      fill: color,
      border: borderColor
    };
  };

  /**
   * Get the colors for the 'size' graph styles.
   * These styles are currently: 'bar-size' and 'dot-size'
   */
  Graph3d.prototype._getColorsSize = function () {
    return {
      fill: this.dataColor.fill,
      border: this.dataColor.stroke
    };
  };

  /**
   * Determine the size of a point on-screen, as determined by the
   * distance to the camera.
   *
   * @param size the size that needs to be translated to screen coordinates.
   *             optional; if not passed, use the default point size.
   */
  Graph3d.prototype._calcRadius = function (point, size) {
    if (size === undefined) {
      size = this._dotSize();
    }

    var radius;
    if (this.showPerspective) {
      radius = size / -point.trans.z;
    } else {
      radius = size * -(this.eye.z / this.camera.getArmLength());
    }
    if (radius < 0) {
      radius = 0;
    }

    return radius;
  };

  // -----------------------------------------------------------------------------
  // Methods for drawing points per graph style.
  // -----------------------------------------------------------------------------


  /**
   * Draw single datapoint for graph style 'bar'.
   */
  Graph3d.prototype._redrawBarGraphPoint = function (ctx, point) {
    var xWidth = this.xBarWidth / 2;
    var yWidth = this.yBarWidth / 2;
    var colors = this._getColorsRegular(point);

    this._redrawBar(ctx, point, xWidth, yWidth, colors.fill, colors.border);
  };

  /**
   * Draw single datapoint for graph style 'bar-color'.
   */
  Graph3d.prototype._redrawBarColorGraphPoint = function (ctx, point) {
    var xWidth = this.xBarWidth / 2;
    var yWidth = this.yBarWidth / 2;
    var colors = this._getColorsColor(point);

    this._redrawBar(ctx, point, xWidth, yWidth, colors.fill, colors.border);
  };

  /**
   * Draw single datapoint for graph style 'bar-size'.
   */
  Graph3d.prototype._redrawBarSizeGraphPoint = function (ctx, point) {
    // calculate size for the bar
    var fraction = (point.point.value - this.valueRange.min) / this.valueRange.range();
    var xWidth = this.xBarWidth / 2 * (fraction * 0.8 + 0.2);
    var yWidth = this.yBarWidth / 2 * (fraction * 0.8 + 0.2);

    var colors = this._getColorsSize();

    this._redrawBar(ctx, point, xWidth, yWidth, colors.fill, colors.border);
  };

  /**
   * Draw single datapoint for graph style 'dot'.
   */
  Graph3d.prototype._redrawDotGraphPoint = function (ctx, point) {
    var colors = this._getColorsRegular(point);

    this._drawCircle(ctx, point, colors.fill, colors.border);
  };

  /**
   * Draw single datapoint for graph style 'dot-line'.
   */
  Graph3d.prototype._redrawDotLineGraphPoint = function (ctx, point) {
    // draw a vertical line from the XY-plane to the graph value
    var from = this._convert3Dto2D(point.bottom);
    ctx.lineWidth = 1;
    this._line(ctx, from, point.screen, this.gridColor);

    this._redrawDotGraphPoint(ctx, point);
  };

  /**
   * Draw single datapoint for graph style 'dot-color'.
   */
  Graph3d.prototype._redrawDotColorGraphPoint = function (ctx, point) {
    var colors = this._getColorsColor(point);

    this._drawCircle(ctx, point, colors.fill, colors.border);
  };

  /**
   * Draw single datapoint for graph style 'dot-size'.
   */
  Graph3d.prototype._redrawDotSizeGraphPoint = function (ctx, point) {
    var dotSize = this._dotSize();
    var fraction = (point.point.value - this.valueRange.min) / this.valueRange.range();
    var size = dotSize / 2 + 2 * dotSize * fraction;
    var colors = this._getColorsSize();

    this._drawCircle(ctx, point, colors.fill, colors.border, size);
  };

  /**
   * Draw single datapoint for graph style 'surface'.
   */
  Graph3d.prototype._redrawSurfaceGraphPoint = function (ctx, point) {
    var right = point.pointRight;
    var top = point.pointTop;
    var cross = point.pointCross;

    if (point === undefined || right === undefined || top === undefined || cross === undefined) {
      return;
    }

    var topSideVisible = true;
    var fillStyle;
    var strokeStyle;
    var lineWidth;

    if (this.showGrayBottom || this.showShadow) {
      // calculate the cross product of the two vectors from center
      // to left and right, in order to know whether we are looking at the
      // bottom or at the top side. We can also use the cross product
      // for calculating light intensity
      var aDiff = Point3d.subtract(cross.trans, point.trans);
      var bDiff = Point3d.subtract(top.trans, right.trans);
      var crossproduct = Point3d.crossProduct(aDiff, bDiff);
      var len = crossproduct.length();
      // FIXME: there is a bug with determining the surface side (shadow or colored)

      topSideVisible = crossproduct.z > 0;
    }

    if (topSideVisible) {

      // calculate Hue from the current value. At zMin the hue is 240, at zMax the hue is 0
      var zAvg = (point.point.z + right.point.z + top.point.z + cross.point.z) / 4;
      var h = (1 - (zAvg - this.zRange.min) * this.scale.z / this.verticalRatio) * 240;
      var s = 1; // saturation
      var v;

      if (this.showShadow) {
        v = Math.min(1 + crossproduct.x / len / 2, 1); // value. TODO: scale
        fillStyle = this._hsv2rgb(h, s, v);
        strokeStyle = fillStyle;
      } else {
        v = 1;
        fillStyle = this._hsv2rgb(h, s, v);
        strokeStyle = this.axisColor; // TODO: should be customizable
      }
    } else {
      fillStyle = 'gray';
      strokeStyle = this.axisColor;
    }

    ctx.lineWidth = this._getStrokeWidth(point);
    // TODO: only draw stroke when strokeWidth > 0

    var points = [point, right, cross, top];
    this._polygon(ctx, points, fillStyle, strokeStyle);
  };

  /**
   * Helper method for _redrawGridGraphPoint()
   */
  Graph3d.prototype._drawGridLine = function (ctx, from, to) {
    if (from === undefined || to === undefined) {
      return;
    }

    // calculate Hue from the current value. At zMin the hue is 240, at zMax the hue is 0
    var zAvg = (from.point.z + to.point.z) / 2;
    var h = (1 - (zAvg - this.zRange.min) * this.scale.z / this.verticalRatio) * 240;

    ctx.lineWidth = this._getStrokeWidth(from) * 2;
    ctx.strokeStyle = this._hsv2rgb(h, 1, 1);
    this._line(ctx, from.screen, to.screen);
  };

  /**
   * Draw single datapoint for graph style 'Grid'.
   */
  Graph3d.prototype._redrawGridGraphPoint = function (ctx, point) {
    this._drawGridLine(ctx, point, point.pointRight);
    this._drawGridLine(ctx, point, point.pointTop);
  };

  /**
   * Draw single datapoint for graph style 'line'.
   */
  Graph3d.prototype._redrawLineGraphPoint = function (ctx, point) {
    if (point.pointNext === undefined) {
      return;
    }

    ctx.lineWidth = this._getStrokeWidth(point);
    ctx.strokeStyle = this.dataColor.stroke;

    this._line(ctx, point.screen, point.pointNext.screen);
  };

  /**
   * Draw all datapoints for currently selected graph style.
   *
   */
  Graph3d.prototype._redrawDataGraph = function () {
    var ctx = this._getContext();
    var i;

    if (this.dataPoints === undefined || this.dataPoints.length <= 0) return; // TODO: throw exception?

    this._calcTranslations(this.dataPoints);

    for (i = 0; i < this.dataPoints.length; i++) {
      var point = this.dataPoints[i];

      // Using call() ensures that the correct context is used
      this._pointDrawingMethod.call(this, ctx, point);
    }
  };

  // -----------------------------------------------------------------------------
  // End methods for drawing points per graph style.
  // -----------------------------------------------------------------------------

  /**
   * Store startX, startY and startOffset for mouse operations
   *
   * @param {Event}     event     The event that occurred
   */
  Graph3d.prototype._storeMousePosition = function (event) {
    // get mouse position (different code for IE and all other browsers)
    this.startMouseX = getMouseX(event);
    this.startMouseY = getMouseY(event);

    this._startCameraOffset = this.camera.getOffset();
  };

  /**
   * Start a moving operation inside the provided parent element
   * @param {Event}     event     The event that occurred (required for
   *                  retrieving the  mouse position)
   */
  Graph3d.prototype._onMouseDown = function (event) {
    event = event || window.event;

    // check if mouse is still down (may be up when focus is lost for example
    // in an iframe)
    if (this.leftButtonDown) {
      this._onMouseUp(event);
    }

    // only react on left mouse button down
    this.leftButtonDown = event.which ? event.which === 1 : event.button === 1;
    if (!this.leftButtonDown && !this.touchDown) return;

    this._storeMousePosition(event);

    this.startStart = new Date(this.start);
    this.startEnd = new Date(this.end);
    this.startArmRotation = this.camera.getArmRotation();

    this.frame.style.cursor = 'move';

    // add event listeners to handle moving the contents
    // we store the function onmousemove and onmouseup in the graph, so we can
    // remove the eventlisteners lateron in the function mouseUp()
    var me = this;
    this.onmousemove = function (event) {
      me._onMouseMove(event);
    };
    this.onmouseup = function (event) {
      me._onMouseUp(event);
    };
    util.addEventListener(document, 'mousemove', me.onmousemove);
    util.addEventListener(document, 'mouseup', me.onmouseup);
    util.preventDefault(event);
  };

  /**
   * Perform moving operating.
   * This function activated from within the funcion Graph.mouseDown().
   * @param {Event}   event  Well, eehh, the event
   */
  Graph3d.prototype._onMouseMove = function (event) {
    this.moving = true;
    event = event || window.event;

    // calculate change in mouse position
    var diffX = parseFloat(getMouseX(event)) - this.startMouseX;
    var diffY = parseFloat(getMouseY(event)) - this.startMouseY;

    // move with ctrl or rotate by other
    if (event && event.ctrlKey === true) {
      // calculate change in mouse position
      var scaleX = this.frame.clientWidth * 0.5;
      var scaleY = this.frame.clientHeight * 0.5;

      var offXNew = (this._startCameraOffset.x || 0) - diffX / scaleX * this.camera.armLength * 0.8;
      var offYNew = (this._startCameraOffset.y || 0) + diffY / scaleY * this.camera.armLength * 0.8;

      this.camera.setOffset(offXNew, offYNew);
      this._storeMousePosition(event);
    } else {
      var horizontalNew = this.startArmRotation.horizontal + diffX / 200;
      var verticalNew = this.startArmRotation.vertical + diffY / 200;

      var snapAngle = 4; // degrees
      var snapValue = Math.sin(snapAngle / 360 * 2 * Math.PI);

      // snap horizontally to nice angles at 0pi, 0.5pi, 1pi, 1.5pi, etc...
      // the -0.001 is to take care that the vertical axis is always drawn at the left front corner
      if (Math.abs(Math.sin(horizontalNew)) < snapValue) {
        horizontalNew = Math.round(horizontalNew / Math.PI) * Math.PI - 0.001;
      }
      if (Math.abs(Math.cos(horizontalNew)) < snapValue) {
        horizontalNew = (Math.round(horizontalNew / Math.PI - 0.5) + 0.5) * Math.PI - 0.001;
      }

      // snap vertically to nice angles
      if (Math.abs(Math.sin(verticalNew)) < snapValue) {
        verticalNew = Math.round(verticalNew / Math.PI) * Math.PI;
      }
      if (Math.abs(Math.cos(verticalNew)) < snapValue) {
        verticalNew = (Math.round(verticalNew / Math.PI - 0.5) + 0.5) * Math.PI;
      }
      this.camera.setArmRotation(horizontalNew, verticalNew);
    }

    this.redraw();

    // fire a cameraPositionChange event
    var parameters = this.getCameraPosition();
    this.emit('cameraPositionChange', parameters);

    util.preventDefault(event);
  };

  /**
   * Stop moving operating.
   * This function activated from within the funcion Graph.mouseDown().
   * @param {event}  event   The event
   */
  Graph3d.prototype._onMouseUp = function (event) {
    this.frame.style.cursor = 'auto';
    this.leftButtonDown = false;

    // remove event listeners here
    util.removeEventListener(document, 'mousemove', this.onmousemove);
    util.removeEventListener(document, 'mouseup', this.onmouseup);
    util.preventDefault(event);
  };

  /**
   * @param {event}  event   The event
   */
  Graph3d.prototype._onClick = function (event) {
    if (!this.onclick_callback) return;
    if (!this.moving) {
      var boundingRect = this.frame.getBoundingClientRect();
      var mouseX = getMouseX(event) - boundingRect.left;
      var mouseY = getMouseY(event) - boundingRect.top;
      var dataPoint = this._dataPointFromXY(mouseX, mouseY);
      if (dataPoint) this.onclick_callback(dataPoint.point.data);
    } else {
      // disable onclick callback, if it came immediately after rotate/pan
      this.moving = false;
    }
    util.preventDefault(event);
  };

  /**
   * After having moved the mouse, a tooltip should pop up when the mouse is resting on a data point
   * @param {Event}  event   A mouse move event
   */
  Graph3d.prototype._onTooltip = function (event) {
    var delay = 300; // ms
    var boundingRect = this.frame.getBoundingClientRect();
    var mouseX = getMouseX(event) - boundingRect.left;
    var mouseY = getMouseY(event) - boundingRect.top;

    if (!this.showTooltip) {
      return;
    }

    if (this.tooltipTimeout) {
      clearTimeout(this.tooltipTimeout);
    }

    // (delayed) display of a tooltip only if no mouse button is down
    if (this.leftButtonDown) {
      this._hideTooltip();
      return;
    }

    if (this.tooltip && this.tooltip.dataPoint) {
      // tooltip is currently visible
      var dataPoint = this._dataPointFromXY(mouseX, mouseY);
      if (dataPoint !== this.tooltip.dataPoint) {
        // datapoint changed
        if (dataPoint) {
          this._showTooltip(dataPoint);
        } else {
          this._hideTooltip();
        }
      }
    } else {
      // tooltip is currently not visible
      var me = this;
      this.tooltipTimeout = setTimeout(function () {
        me.tooltipTimeout = null;

        // show a tooltip if we have a data point
        var dataPoint = me._dataPointFromXY(mouseX, mouseY);
        if (dataPoint) {
          me._showTooltip(dataPoint);
        }
      }, delay);
    }
  };

  /**
   * Event handler for touchstart event on mobile devices
   */
  Graph3d.prototype._onTouchStart = function (event) {
    this.touchDown = true;

    var me = this;
    this.ontouchmove = function (event) {
      me._onTouchMove(event);
    };
    this.ontouchend = function (event) {
      me._onTouchEnd(event);
    };
    util.addEventListener(document, 'touchmove', me.ontouchmove);
    util.addEventListener(document, 'touchend', me.ontouchend);

    this._onMouseDown(event);
  };

  /**
   * Event handler for touchmove event on mobile devices
   */
  Graph3d.prototype._onTouchMove = function (event) {
    this._onMouseMove(event);
  };

  /**
   * Event handler for touchend event on mobile devices
   */
  Graph3d.prototype._onTouchEnd = function (event) {
    this.touchDown = false;

    util.removeEventListener(document, 'touchmove', this.ontouchmove);
    util.removeEventListener(document, 'touchend', this.ontouchend);

    this._onMouseUp(event);
  };

  /**
   * Event handler for mouse wheel event, used to zoom the graph
   * Code from http://adomas.org/javascript-mouse-wheel/
   * @param {event}  event   The event
   */
  Graph3d.prototype._onWheel = function (event) {
    if (!event) /* For IE. */
      event = window.event;

    // retrieve delta
    var delta = 0;
    if (event.wheelDelta) {
      /* IE/Opera. */
      delta = event.wheelDelta / 120;
    } else if (event.detail) {
      /* Mozilla case. */
      // In Mozilla, sign of delta is different than in IE.
      // Also, delta is multiple of 3.
      delta = -event.detail / 3;
    }

    // If delta is nonzero, handle it.
    // Basically, delta is now positive if wheel was scrolled up,
    // and negative, if wheel was scrolled down.
    if (delta) {
      var oldLength = this.camera.getArmLength();
      var newLength = oldLength * (1 - delta / 10);

      this.camera.setArmLength(newLength);
      this.redraw();

      this._hideTooltip();
    }

    // fire a cameraPositionChange event
    var parameters = this.getCameraPosition();
    this.emit('cameraPositionChange', parameters);

    // Prevent default actions caused by mouse wheel.
    // That might be ugly, but we handle scrolls somehow
    // anyway, so don't bother here..
    util.preventDefault(event);
  };

  /**
   * Test whether a point lies inside given 2D triangle
   *
   * @param   {Point2d}   point
   * @param   {Point2d[]} triangle
   * @returns {boolean}   true if given point lies inside or on the edge of the
   *                      triangle, false otherwise
   * @private
   */
  Graph3d.prototype._insideTriangle = function (point, triangle) {
    var a = triangle[0],
        b = triangle[1],
        c = triangle[2];

    function sign(x) {
      return x > 0 ? 1 : x < 0 ? -1 : 0;
    }

    var as = sign((b.x - a.x) * (point.y - a.y) - (b.y - a.y) * (point.x - a.x));
    var bs = sign((c.x - b.x) * (point.y - b.y) - (c.y - b.y) * (point.x - b.x));
    var cs = sign((a.x - c.x) * (point.y - c.y) - (a.y - c.y) * (point.x - c.x));

    // each of the three signs must be either equal to each other or zero
    return (as == 0 || bs == 0 || as == bs) && (bs == 0 || cs == 0 || bs == cs) && (as == 0 || cs == 0 || as == cs);
  };

  /**
   * Find a data point close to given screen position (x, y)
   *
   * @param   {Number} x
   * @param   {Number} y
   * @returns {Object | null} The closest data point or null if not close to any
   *                          data point
   * @private
   */
  Graph3d.prototype._dataPointFromXY = function (x, y) {
    var i,
        distMax = 100,
        // px
    dataPoint = null,
        closestDataPoint = null,
        closestDist = null,
        center = new Point2d(x, y);

    if (this.style === Graph3d.STYLE.BAR || this.style === Graph3d.STYLE.BARCOLOR || this.style === Graph3d.STYLE.BARSIZE) {
      // the data points are ordered from far away to closest
      for (i = this.dataPoints.length - 1; i >= 0; i--) {
        dataPoint = this.dataPoints[i];
        var surfaces = dataPoint.surfaces;
        if (surfaces) {
          for (var s = surfaces.length - 1; s >= 0; s--) {
            // split each surface in two triangles, and see if the center point is inside one of these
            var surface = surfaces[s];
            var corners = surface.corners;
            var triangle1 = [corners[0].screen, corners[1].screen, corners[2].screen];
            var triangle2 = [corners[2].screen, corners[3].screen, corners[0].screen];
            if (this._insideTriangle(center, triangle1) || this._insideTriangle(center, triangle2)) {
              // return immediately at the first hit
              return dataPoint;
            }
          }
        }
      }
    } else {
      // find the closest data point, using distance to the center of the point on 2d screen
      for (i = 0; i < this.dataPoints.length; i++) {
        dataPoint = this.dataPoints[i];
        var point = dataPoint.screen;
        if (point) {
          var distX = Math.abs(x - point.x);
          var distY = Math.abs(y - point.y);
          var dist = Math.sqrt(distX * distX + distY * distY);

          if ((closestDist === null || dist < closestDist) && dist < distMax) {
            closestDist = dist;
            closestDataPoint = dataPoint;
          }
        }
      }
    }

    return closestDataPoint;
  };

  /**
   * Display a tooltip for given data point
   * @param {Object} dataPoint
   * @private
   */
  Graph3d.prototype._showTooltip = function (dataPoint) {
    var content, line, dot;

    if (!this.tooltip) {
      content = document.createElement('div');
      content.style.position = 'absolute';
      content.style.padding = '10px';
      content.style.border = '1px solid #4d4d4d';
      content.style.color = '#1a1a1a';
      content.style.background = 'rgba(255,255,255,0.7)';
      content.style.borderRadius = '2px';
      content.style.boxShadow = '5px 5px 10px rgba(128,128,128,0.5)';

      line = document.createElement('div');
      line.style.position = 'absolute';
      line.style.height = '40px';
      line.style.width = '0';
      line.style.borderLeft = '1px solid #4d4d4d';

      dot = document.createElement('div');
      dot.style.position = 'absolute';
      dot.style.height = '0';
      dot.style.width = '0';
      dot.style.border = '5px solid #4d4d4d';
      dot.style.borderRadius = '5px';

      this.tooltip = {
        dataPoint: null,
        dom: {
          content: content,
          line: line,
          dot: dot
        }
      };
    } else {
      content = this.tooltip.dom.content;
      line = this.tooltip.dom.line;
      dot = this.tooltip.dom.dot;
    }

    this._hideTooltip();

    this.tooltip.dataPoint = dataPoint;
    if (typeof this.showTooltip === 'function') {
      content.innerHTML = this.showTooltip(dataPoint.point);
    } else {
      content.innerHTML = '<table>' + '<tr><td>' + this.xLabel + ':</td><td>' + dataPoint.point.x + '</td></tr>' + '<tr><td>' + this.yLabel + ':</td><td>' + dataPoint.point.y + '</td></tr>' + '<tr><td>' + this.zLabel + ':</td><td>' + dataPoint.point.z + '</td></tr>' + '</table>';
    }

    content.style.left = '0';
    content.style.top = '0';
    this.frame.appendChild(content);
    this.frame.appendChild(line);
    this.frame.appendChild(dot);

    // calculate sizes
    var contentWidth = content.offsetWidth;
    var contentHeight = content.offsetHeight;
    var lineHeight = line.offsetHeight;
    var dotWidth = dot.offsetWidth;
    var dotHeight = dot.offsetHeight;

    var left = dataPoint.screen.x - contentWidth / 2;
    left = Math.min(Math.max(left, 10), this.frame.clientWidth - 10 - contentWidth);

    line.style.left = dataPoint.screen.x + 'px';
    line.style.top = dataPoint.screen.y - lineHeight + 'px';
    content.style.left = left + 'px';
    content.style.top = dataPoint.screen.y - lineHeight - contentHeight + 'px';
    dot.style.left = dataPoint.screen.x - dotWidth / 2 + 'px';
    dot.style.top = dataPoint.screen.y - dotHeight / 2 + 'px';
  };

  /**
   * Hide the tooltip when displayed
   * @private
   */
  Graph3d.prototype._hideTooltip = function () {
    if (this.tooltip) {
      this.tooltip.dataPoint = null;

      for (var prop in this.tooltip.dom) {
        if (this.tooltip.dom.hasOwnProperty(prop)) {
          var elem = this.tooltip.dom[prop];
          if (elem && elem.parentNode) {
            elem.parentNode.removeChild(elem);
          }
        }
      }
    }
  };

  /**--------------------------------------------------------------------------**/

  /**
   * Get the horizontal mouse position from a mouse event
   *
   * @param   {Event}  event
   * @returns {Number} mouse x
   */
  function getMouseX(event) {
    if ('clientX' in event) return event.clientX;
    return event.targetTouches[0] && event.targetTouches[0].clientX || 0;
  }

  /**
   * Get the vertical mouse position from a mouse event
   *
   * @param   {Event}  event
   * @returns {Number} mouse y
   */
  function getMouseY(event) {
    if ('clientY' in event) return event.clientY;
    return event.targetTouches[0] && event.targetTouches[0].clientY || 0;
  }

  // -----------------------------------------------------------------------------
  //  Public methods for specific settings
  // -----------------------------------------------------------------------------

  /**
   * Set the rotation and distance of the camera
   *
   * @param {Object}  pos            An object with the camera position
   * @param {?Number} pos.horizontal The horizontal rotation, between 0 and 2*PI.
   *                                 Optional, can be left undefined.
   * @param {?Number} pos.vertical   The vertical rotation, between 0 and 0.5*PI.
   *                                 if vertical=0.5*PI, the graph is shown from
   *                                 the top. Optional, can be left undefined.
   * @param {?Number} pos.distance   The (normalized) distance of the camera to the
   *                                 center of the graph, a value between 0.71 and
   *                                 5.0. Optional, can be left undefined.
   */
  Graph3d.prototype.setCameraPosition = function (pos) {
    Settings.setCameraPosition(pos, this);
    this.redraw();
  };

  /**
   * Set a new size for the graph
   *
   * @param {string} width  Width in pixels or percentage (for example '800px'
   *                        or '50%')
   * @param {string} height Height in pixels or percentage  (for example '400px'
   *                        or '30%')
   */
  Graph3d.prototype.setSize = function (width, height) {
    this._setSize(width, height);
    this.redraw();
  };

  // -----------------------------------------------------------------------------
  //  End public methods for specific settings
  // -----------------------------------------------------------------------------


  module.exports = Graph3d;

/***/ },
/* 95 */
/***/ function(module, exports) {

  
  /**
   * Expose `Emitter`.
   */

  module.exports = Emitter;

  /**
   * Initialize a new `Emitter`.
   *
   * @api public
   */

  function Emitter(obj) {
    if (obj) return mixin(obj);
  };

  /**
   * Mixin the emitter properties.
   *
   * @param {Object} obj
   * @return {Object}
   * @api private
   */

  function mixin(obj) {
    for (var key in Emitter.prototype) {
      obj[key] = Emitter.prototype[key];
    }
    return obj;
  }

  /**
   * Listen on the given `event` with `fn`.
   *
   * @param {String} event
   * @param {Function} fn
   * @return {Emitter}
   * @api public
   */

  Emitter.prototype.on =
  Emitter.prototype.addEventListener = function(event, fn){
    this._callbacks = this._callbacks || {};
    (this._callbacks[event] = this._callbacks[event] || [])
      .push(fn);
    return this;
  };

  /**
   * Adds an `event` listener that will be invoked a single
   * time then automatically removed.
   *
   * @param {String} event
   * @param {Function} fn
   * @return {Emitter}
   * @api public
   */

  Emitter.prototype.once = function(event, fn){
    var self = this;
    this._callbacks = this._callbacks || {};

    function on() {
      self.off(event, on);
      fn.apply(this, arguments);
    }

    on.fn = fn;
    this.on(event, on);
    return this;
  };

  /**
   * Remove the given callback for `event` or all
   * registered callbacks.
   *
   * @param {String} event
   * @param {Function} fn
   * @return {Emitter}
   * @api public
   */

  Emitter.prototype.off =
  Emitter.prototype.removeListener =
  Emitter.prototype.removeAllListeners =
  Emitter.prototype.removeEventListener = function(event, fn){
    this._callbacks = this._callbacks || {};

    // all
    if (0 == arguments.length) {
      this._callbacks = {};
      return this;
    }

    // specific event
    var callbacks = this._callbacks[event];
    if (!callbacks) return this;

    // remove all handlers
    if (1 == arguments.length) {
      delete this._callbacks[event];
      return this;
    }

    // remove specific handler
    var cb;
    for (var i = 0; i < callbacks.length; i++) {
      cb = callbacks[i];
      if (cb === fn || cb.fn === fn) {
        callbacks.splice(i, 1);
        break;
      }
    }
    return this;
  };

  /**
   * Emit `event` with the given args.
   *
   * @param {String} event
   * @param {Mixed} ...
   * @return {Emitter}
   */

  Emitter.prototype.emit = function(event){
    this._callbacks = this._callbacks || {};
    var args = [].slice.call(arguments, 1)
      , callbacks = this._callbacks[event];

    if (callbacks) {
      callbacks = callbacks.slice(0);
      for (var i = 0, len = callbacks.length; i < len; ++i) {
        callbacks[i].apply(this, args);
      }
    }

    return this;
  };

  /**
   * Return array of callbacks for `event`.
   *
   * @param {String} event
   * @return {Array}
   * @api public
   */

  Emitter.prototype.listeners = function(event){
    this._callbacks = this._callbacks || {};
    return this._callbacks[event] || [];
  };

  /**
   * Check if this emitter has `event` handlers.
   *
   * @param {String} event
   * @return {Boolean}
   * @api public
   */

  Emitter.prototype.hasListeners = function(event){
    return !! this.listeners(event).length;
  };


/***/ },
/* 96 */
/***/ function(module, exports) {

  "use strict";

  /**
   * @prototype Point3d
   * @param {Number} [x]
   * @param {Number} [y]
   * @param {Number} [z]
   */
  function Point3d(x, y, z) {
    this.x = x !== undefined ? x : 0;
    this.y = y !== undefined ? y : 0;
    this.z = z !== undefined ? z : 0;
  };

  /**
   * Subtract the two provided points, returns a-b
   * @param {Point3d} a
   * @param {Point3d} b
   * @return {Point3d} a-b
   */
  Point3d.subtract = function (a, b) {
    var sub = new Point3d();
    sub.x = a.x - b.x;
    sub.y = a.y - b.y;
    sub.z = a.z - b.z;
    return sub;
  };

  /**
   * Add the two provided points, returns a+b
   * @param {Point3d} a
   * @param {Point3d} b
   * @return {Point3d} a+b
   */
  Point3d.add = function (a, b) {
    var sum = new Point3d();
    sum.x = a.x + b.x;
    sum.y = a.y + b.y;
    sum.z = a.z + b.z;
    return sum;
  };

  /**
   * Calculate the average of two 3d points
   * @param {Point3d} a
   * @param {Point3d} b
   * @return {Point3d} The average, (a+b)/2
   */
  Point3d.avg = function (a, b) {
    return new Point3d((a.x + b.x) / 2, (a.y + b.y) / 2, (a.z + b.z) / 2);
  };

  /**
   * Calculate the cross product of the two provided points, returns axb
   * Documentation: http://en.wikipedia.org/wiki/Cross_product
   * @param {Point3d} a
   * @param {Point3d} b
   * @return {Point3d} cross product axb
   */
  Point3d.crossProduct = function (a, b) {
    var crossproduct = new Point3d();

    crossproduct.x = a.y * b.z - a.z * b.y;
    crossproduct.y = a.z * b.x - a.x * b.z;
    crossproduct.z = a.x * b.y - a.y * b.x;

    return crossproduct;
  };

  /**
   * Rtrieve the length of the vector (or the distance from this point to the origin
   * @return {Number}  length
   */
  Point3d.prototype.length = function () {
    return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
  };

  module.exports = Point3d;

/***/ },
/* 97 */
/***/ function(module, exports) {

  "use strict";

  /**
   * @prototype Point2d
   * @param {Number} [x]
   * @param {Number} [y]
   */
  function Point2d(x, y) {
    this.x = x !== undefined ? x : 0;
    this.y = y !== undefined ? y : 0;
  }

  module.exports = Point2d;

/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _sign = __webpack_require__(99);

  var _sign2 = _interopRequireDefault(_sign);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var Point3d = __webpack_require__(96);

  /**
   * @class Camera
   * The camera is mounted on a (virtual) camera arm. The camera arm can rotate
   * The camera is always looking in the direction of the origin of the arm.
   * This way, the camera always rotates around one fixed point, the location
   * of the camera arm.
   *
   * Documentation:
   *   http://en.wikipedia.org/wiki/3D_projection
   */
  function Camera() {
    this.armLocation = new Point3d();
    this.armRotation = {};
    this.armRotation.horizontal = 0;
    this.armRotation.vertical = 0;
    this.armLength = 1.7;
    this.cameraOffset = new Point3d();
    this.offsetMultiplier = 0.6;

    this.cameraLocation = new Point3d();
    this.cameraRotation = new Point3d(0.5 * Math.PI, 0, 0);

    this.calculateCameraOrientation();
  }

  /**
   * Set offset camera in camera coordinates
   * @param {Number} x offset by camera horisontal
   * @param {Number} y offset by camera vertical
   */
  Camera.prototype.setOffset = function (x, y) {
    var abs = Math.abs,
        sign = _sign2['default'],
        mul = this.offsetMultiplier,
        border = this.armLength * mul;

    if (abs(x) > border) {
      x = sign(x) * border;
    }
    if (abs(y) > border) {
      y = sign(y) * border;
    }
    this.cameraOffset.x = x;
    this.cameraOffset.y = y;
    this.calculateCameraOrientation();
  };

  /**
   * Get camera offset by horizontal and vertical
   * @return {Point3d} x - horizontal offset, y - vertical offset, z - not used
   */
  Camera.prototype.getOffset = function (x, y) {
    return this.cameraOffset;
  };

  /**
   * Set the location (origin) of the arm
   * @param {Number} x  Normalized value of x
   * @param {Number} y  Normalized value of y
   * @param {Number} z  Normalized value of z
   */
  Camera.prototype.setArmLocation = function (x, y, z) {
    this.armLocation.x = x;
    this.armLocation.y = y;
    this.armLocation.z = z;

    this.calculateCameraOrientation();
  };

  /**
   * Set the rotation of the camera arm
   * @param {Number} horizontal   The horizontal rotation, between 0 and 2*PI.
   *                Optional, can be left undefined.
   * @param {Number} vertical   The vertical rotation, between 0 and 0.5*PI
   *                if vertical=0.5*PI, the graph is shown from the
   *                top. Optional, can be left undefined.
   */
  Camera.prototype.setArmRotation = function (horizontal, vertical) {
    if (horizontal !== undefined) {
      this.armRotation.horizontal = horizontal;
    }

    if (vertical !== undefined) {
      this.armRotation.vertical = vertical;
      if (this.armRotation.vertical < 0) this.armRotation.vertical = 0;
      if (this.armRotation.vertical > 0.5 * Math.PI) this.armRotation.vertical = 0.5 * Math.PI;
    }

    if (horizontal !== undefined || vertical !== undefined) {
      this.calculateCameraOrientation();
    }
  };

  /**
   * Retrieve the current arm rotation
   * @return {object}   An object with parameters horizontal and vertical
   */
  Camera.prototype.getArmRotation = function () {
    var rot = {};
    rot.horizontal = this.armRotation.horizontal;
    rot.vertical = this.armRotation.vertical;

    return rot;
  };

  /**
   * Set the (normalized) length of the camera arm.
   * @param {Number} length A length between 0.71 and 5.0
   */
  Camera.prototype.setArmLength = function (length) {
    if (length === undefined) return;

    this.armLength = length;

    // Radius must be larger than the corner of the graph,
    // which has a distance of sqrt(0.5^2+0.5^2) = 0.71 from the center of the
    // graph
    if (this.armLength < 0.71) this.armLength = 0.71;
    if (this.armLength > 5.0) this.armLength = 5.0;

    this.setOffset(this.cameraOffset.x, this.cameraOffset.y);
    this.calculateCameraOrientation();
  };

  /**
   * Retrieve the arm length
   * @return {Number} length
   */
  Camera.prototype.getArmLength = function () {
    return this.armLength;
  };

  /**
   * Retrieve the camera location
   * @return {Point3d} cameraLocation
   */
  Camera.prototype.getCameraLocation = function () {
    return this.cameraLocation;
  };

  /**
   * Retrieve the camera rotation
   * @return {Point3d} cameraRotation
   */
  Camera.prototype.getCameraRotation = function () {
    return this.cameraRotation;
  };

  /**
   * Calculate the location and rotation of the camera based on the
   * position and orientation of the camera arm
   */
  Camera.prototype.calculateCameraOrientation = function () {
    // calculate location of the camera
    this.cameraLocation.x = this.armLocation.x - this.armLength * Math.sin(this.armRotation.horizontal) * Math.cos(this.armRotation.vertical);
    this.cameraLocation.y = this.armLocation.y - this.armLength * Math.cos(this.armRotation.horizontal) * Math.cos(this.armRotation.vertical);
    this.cameraLocation.z = this.armLocation.z + this.armLength * Math.sin(this.armRotation.vertical);

    // calculate rotation of the camera
    this.cameraRotation.x = Math.PI / 2 - this.armRotation.vertical;
    this.cameraRotation.y = 0;
    this.cameraRotation.z = -this.armRotation.horizontal;

    var xa = this.cameraRotation.x;
    var ya = this.cameraRotation.y;
    var za = this.cameraRotation.z;
    var dx = this.cameraOffset.x;
    var dy = this.cameraOffset.y;
    var sin = Math.sin,
        cos = Math.cos;

    this.cameraLocation.x = this.cameraLocation.x + dx * cos(za) + dy * -sin(za) * cos(xa);
    this.cameraLocation.y = this.cameraLocation.y + dx * sin(za) + dy * cos(za) * cos(xa);
    this.cameraLocation.z = this.cameraLocation.z + dy * sin(xa);
  };

  module.exports = Camera;

/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(100), __esModule: true };

/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(101);
  module.exports = __webpack_require__(17).Math.sign;

/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

  // 20.2.2.28 Math.sign(x)
  var $export = __webpack_require__(15);

  $export($export.S, 'Math', {sign: __webpack_require__(102)});

/***/ },
/* 102 */
/***/ function(module, exports) {

  // 20.2.2.28 Math.sign(x)
  module.exports = Math.sign || function sign(x){
    return (x = +x) == 0 || x != x ? x : x < 0 ? -1 : 1;
  };

/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var DataView = __webpack_require__(93);

  /**
   * @class Filter
   *
   * @param {DataSet} data The google data table
   * @param {Number}  column             The index of the column to be filtered
   * @param {Graph} graph           The graph
   */
  function Filter(data, column, graph) {
    this.data = data;
    this.column = column;
    this.graph = graph; // the parent graph

    this.index = undefined;
    this.value = undefined;

    // read all distinct values and select the first one
    this.values = graph.getDistinctValues(data.get(), this.column);

    // sort both numeric and string values correctly
    this.values.sort(function (a, b) {
      return a > b ? 1 : a < b ? -1 : 0;
    });

    if (this.values.length > 0) {
      this.selectValue(0);
    }

    // create an array with the filtered datapoints. this will be loaded afterwards
    this.dataPoints = [];

    this.loaded = false;
    this.onLoadCallback = undefined;

    if (graph.animationPreload) {
      this.loaded = false;
      this.loadInBackground();
    } else {
      this.loaded = true;
    }
  };

  /**
   * Return the label
   * @return {string} label
   */
  Filter.prototype.isLoaded = function () {
    return this.loaded;
  };

  /**
   * Return the loaded progress
   * @return {Number} percentage between 0 and 100
   */
  Filter.prototype.getLoadedProgress = function () {
    var len = this.values.length;

    var i = 0;
    while (this.dataPoints[i]) {
      i++;
    }

    return Math.round(i / len * 100);
  };

  /**
   * Return the label
   * @return {string} label
   */
  Filter.prototype.getLabel = function () {
    return this.graph.filterLabel;
  };

  /**
   * Return the columnIndex of the filter
   * @return {Number} columnIndex
   */
  Filter.prototype.getColumn = function () {
    return this.column;
  };

  /**
   * Return the currently selected value. Returns undefined if there is no selection
   * @return {*} value
   */
  Filter.prototype.getSelectedValue = function () {
    if (this.index === undefined) return undefined;

    return this.values[this.index];
  };

  /**
   * Retrieve all values of the filter
   * @return {Array} values
   */
  Filter.prototype.getValues = function () {
    return this.values;
  };

  /**
   * Retrieve one value of the filter
   * @param {Number}  index
   * @return {*} value
   */
  Filter.prototype.getValue = function (index) {
    if (index >= this.values.length) throw new Error('Index out of range');

    return this.values[index];
  };

  /**
   * Retrieve the (filtered) dataPoints for the currently selected filter index
   * @param {Number} [index] (optional)
   * @return {Array} dataPoints
   */
  Filter.prototype._getDataPoints = function (index) {
    if (index === undefined) index = this.index;

    if (index === undefined) return [];

    var dataPoints;
    if (this.dataPoints[index]) {
      dataPoints = this.dataPoints[index];
    } else {
      var f = {};
      f.column = this.column;
      f.value = this.values[index];

      var dataView = new DataView(this.data, { filter: function filter(item) {
          return item[f.column] == f.value;
        } }).get();
      dataPoints = this.graph._getDataPoints(dataView);

      this.dataPoints[index] = dataPoints;
    }

    return dataPoints;
  };

  /**
   * Set a callback function when the filter is fully loaded.
   */
  Filter.prototype.setOnLoadCallback = function (callback) {
    this.onLoadCallback = callback;
  };

  /**
   * Add a value to the list with available values for this filter
   * No double entries will be created.
   * @param {Number} index
   */
  Filter.prototype.selectValue = function (index) {
    if (index >= this.values.length) throw new Error('Index out of range');

    this.index = index;
    this.value = this.values[index];
  };

  /**
   * Load all filtered rows in the background one by one
   * Start this method without providing an index!
   */
  Filter.prototype.loadInBackground = function (index) {
    if (index === undefined) index = 0;

    var frame = this.graph.frame;

    if (index < this.values.length) {
      var dataPointsTemp = this._getDataPoints(index);
      //this.graph.redrawInfo(); // TODO: not neat

      // create a progress box
      if (frame.progress === undefined) {
        frame.progress = document.createElement('DIV');
        frame.progress.style.position = 'absolute';
        frame.progress.style.color = 'gray';
        frame.appendChild(frame.progress);
      }
      var progress = this.getLoadedProgress();
      frame.progress.innerHTML = 'Loading animation... ' + progress + '%';
      // TODO: this is no nice solution...
      frame.progress.style.bottom = 60 + 'px'; // TODO: use height of slider
      frame.progress.style.left = 10 + 'px';

      var me = this;
      setTimeout(function () {
        me.loadInBackground(index + 1);
      }, 10);
      this.loaded = false;
    } else {
      this.loaded = true;

      // remove the progress box
      if (frame.progress !== undefined) {
        frame.removeChild(frame.progress);
        frame.progress = undefined;
      }

      if (this.onLoadCallback) this.onLoadCallback();
    }
  };

  module.exports = Filter;

/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var util = __webpack_require__(1);

  /**
   * @constructor Slider
   *
   * An html slider control with start/stop/prev/next buttons
   * @param {Element} container  The element where the slider will be created
   * @param {Object} options   Available options:
   *                 {boolean} visible   If true (default) the
   *                           slider is visible.
   */
  function Slider(container, options) {
    if (container === undefined) {
      throw new Error('No container element defined');
    }
    this.container = container;
    this.visible = options && options.visible != undefined ? options.visible : true;

    if (this.visible) {
      this.frame = document.createElement('DIV');
      //this.frame.style.backgroundColor = '#E5E5E5';
      this.frame.style.width = '100%';
      this.frame.style.position = 'relative';
      this.container.appendChild(this.frame);

      this.frame.prev = document.createElement('INPUT');
      this.frame.prev.type = 'BUTTON';
      this.frame.prev.value = 'Prev';
      this.frame.appendChild(this.frame.prev);

      this.frame.play = document.createElement('INPUT');
      this.frame.play.type = 'BUTTON';
      this.frame.play.value = 'Play';
      this.frame.appendChild(this.frame.play);

      this.frame.next = document.createElement('INPUT');
      this.frame.next.type = 'BUTTON';
      this.frame.next.value = 'Next';
      this.frame.appendChild(this.frame.next);

      this.frame.bar = document.createElement('INPUT');
      this.frame.bar.type = 'BUTTON';
      this.frame.bar.style.position = 'absolute';
      this.frame.bar.style.border = '1px solid red';
      this.frame.bar.style.width = '100px';
      this.frame.bar.style.height = '6px';
      this.frame.bar.style.borderRadius = '2px';
      this.frame.bar.style.MozBorderRadius = '2px';
      this.frame.bar.style.border = '1px solid #7F7F7F';
      this.frame.bar.style.backgroundColor = '#E5E5E5';
      this.frame.appendChild(this.frame.bar);

      this.frame.slide = document.createElement('INPUT');
      this.frame.slide.type = 'BUTTON';
      this.frame.slide.style.margin = '0px';
      this.frame.slide.value = ' ';
      this.frame.slide.style.position = 'relative';
      this.frame.slide.style.left = '-100px';
      this.frame.appendChild(this.frame.slide);

      // create events
      var me = this;
      this.frame.slide.onmousedown = function (event) {
        me._onMouseDown(event);
      };
      this.frame.prev.onclick = function (event) {
        me.prev(event);
      };
      this.frame.play.onclick = function (event) {
        me.togglePlay(event);
      };
      this.frame.next.onclick = function (event) {
        me.next(event);
      };
    }

    this.onChangeCallback = undefined;

    this.values = [];
    this.index = undefined;

    this.playTimeout = undefined;
    this.playInterval = 1000; // milliseconds
    this.playLoop = true;
  }

  /**
   * Select the previous index
   */
  Slider.prototype.prev = function () {
    var index = this.getIndex();
    if (index > 0) {
      index--;
      this.setIndex(index);
    }
  };

  /**
   * Select the next index
   */
  Slider.prototype.next = function () {
    var index = this.getIndex();
    if (index < this.values.length - 1) {
      index++;
      this.setIndex(index);
    }
  };

  /**
   * Select the next index
   */
  Slider.prototype.playNext = function () {
    var start = new Date();

    var index = this.getIndex();
    if (index < this.values.length - 1) {
      index++;
      this.setIndex(index);
    } else if (this.playLoop) {
      // jump to the start
      index = 0;
      this.setIndex(index);
    }

    var end = new Date();
    var diff = end - start;

    // calculate how much time it to to set the index and to execute the callback
    // function.
    var interval = Math.max(this.playInterval - diff, 0);
    // document.title = diff // TODO: cleanup

    var me = this;
    this.playTimeout = setTimeout(function () {
      me.playNext();
    }, interval);
  };

  /**
   * Toggle start or stop playing
   */
  Slider.prototype.togglePlay = function () {
    if (this.playTimeout === undefined) {
      this.play();
    } else {
      this.stop();
    }
  };

  /**
   * Start playing
   */
  Slider.prototype.play = function () {
    // Test whether already playing
    if (this.playTimeout) return;

    this.playNext();

    if (this.frame) {
      this.frame.play.value = 'Stop';
    }
  };

  /**
   * Stop playing
   */
  Slider.prototype.stop = function () {
    clearInterval(this.playTimeout);
    this.playTimeout = undefined;

    if (this.frame) {
      this.frame.play.value = 'Play';
    }
  };

  /**
   * Set a callback function which will be triggered when the value of the
   * slider bar has changed.
   */
  Slider.prototype.setOnChangeCallback = function (callback) {
    this.onChangeCallback = callback;
  };

  /**
   * Set the interval for playing the list
   * @param {Number} interval   The interval in milliseconds
   */
  Slider.prototype.setPlayInterval = function (interval) {
    this.playInterval = interval;
  };

  /**
   * Retrieve the current play interval
   * @return {Number} interval   The interval in milliseconds
   */
  Slider.prototype.getPlayInterval = function (interval) {
    return this.playInterval;
  };

  /**
   * Set looping on or off
   * @pararm {boolean} doLoop  If true, the slider will jump to the start when
   *               the end is passed, and will jump to the end
   *               when the start is passed.
   */
  Slider.prototype.setPlayLoop = function (doLoop) {
    this.playLoop = doLoop;
  };

  /**
   * Execute the onchange callback function
   */
  Slider.prototype.onChange = function () {
    if (this.onChangeCallback !== undefined) {
      this.onChangeCallback();
    }
  };

  /**
   * redraw the slider on the correct place
   */
  Slider.prototype.redraw = function () {
    if (this.frame) {
      // resize the bar
      this.frame.bar.style.top = this.frame.clientHeight / 2 - this.frame.bar.offsetHeight / 2 + 'px';
      this.frame.bar.style.width = this.frame.clientWidth - this.frame.prev.clientWidth - this.frame.play.clientWidth - this.frame.next.clientWidth - 30 + 'px';

      // position the slider button
      var left = this.indexToLeft(this.index);
      this.frame.slide.style.left = left + 'px';
    }
  };

  /**
   * Set the list with values for the slider
   * @param {Array} values   A javascript array with values (any type)
   */
  Slider.prototype.setValues = function (values) {
    this.values = values;

    if (this.values.length > 0) this.setIndex(0);else this.index = undefined;
  };

  /**
   * Select a value by its index
   * @param {Number} index
   */
  Slider.prototype.setIndex = function (index) {
    if (index < this.values.length) {
      this.index = index;

      this.redraw();
      this.onChange();
    } else {
      throw new Error('Index out of range');
    }
  };

  /**
   * retrieve the index of the currently selected vaue
   * @return {Number} index
   */
  Slider.prototype.getIndex = function () {
    return this.index;
  };

  /**
   * retrieve the currently selected value
   * @return {*} value
   */
  Slider.prototype.get = function () {
    return this.values[this.index];
  };

  Slider.prototype._onMouseDown = function (event) {
    // only react on left mouse button down
    var leftButtonDown = event.which ? event.which === 1 : event.button === 1;
    if (!leftButtonDown) return;

    this.startClientX = event.clientX;
    this.startSlideX = parseFloat(this.frame.slide.style.left);

    this.frame.style.cursor = 'move';

    // add event listeners to handle moving the contents
    // we store the function onmousemove and onmouseup in the graph, so we can
    // remove the eventlisteners lateron in the function mouseUp()
    var me = this;
    this.onmousemove = function (event) {
      me._onMouseMove(event);
    };
    this.onmouseup = function (event) {
      me._onMouseUp(event);
    };
    util.addEventListener(document, 'mousemove', this.onmousemove);
    util.addEventListener(document, 'mouseup', this.onmouseup);
    util.preventDefault(event);
  };

  Slider.prototype.leftToIndex = function (left) {
    var width = parseFloat(this.frame.bar.style.width) - this.frame.slide.clientWidth - 10;
    var x = left - 3;

    var index = Math.round(x / width * (this.values.length - 1));
    if (index < 0) index = 0;
    if (index > this.values.length - 1) index = this.values.length - 1;

    return index;
  };

  Slider.prototype.indexToLeft = function (index) {
    var width = parseFloat(this.frame.bar.style.width) - this.frame.slide.clientWidth - 10;

    var x = index / (this.values.length - 1) * width;
    var left = x + 3;

    return left;
  };

  Slider.prototype._onMouseMove = function (event) {
    var diff = event.clientX - this.startClientX;
    var x = this.startSlideX + diff;

    var index = this.leftToIndex(x);

    this.setIndex(index);

    util.preventDefault();
  };

  Slider.prototype._onMouseUp = function (event) {
    this.frame.style.cursor = 'auto';

    // remove event listeners
    util.removeEventListener(document, 'mousemove', this.onmousemove);
    util.removeEventListener(document, 'mouseup', this.onmouseup);

    util.preventDefault();
  };

  module.exports = Slider;

/***/ },
/* 105 */
/***/ function(module, exports) {

  'use strict';

  /**
   * @prototype StepNumber
   * The class StepNumber is an iterator for Numbers. You provide a start and end
   * value, and a best step size. StepNumber itself rounds to fixed values and
   * a finds the step that best fits the provided step.
   *
   * If prettyStep is true, the step size is chosen as close as possible to the
   * provided step, but being a round value like 1, 2, 5, 10, 20, 50, ....
   *
   * Example usage:
   *   var step = new StepNumber(0, 10, 2.5, true);
   *   step.start();
   *   while (!step.end()) {
   *   alert(step.getCurrent());
   *   step.next();
   *   }
   *
   * Version: 1.0
   *
   * @param {Number} start     The start value
   * @param {Number} end     The end value
   * @param {Number} step    Optional. Step size. Must be a positive value.
   * @param {boolean} prettyStep Optional. If true, the step size is rounded
   *               To a pretty step size (like 1, 2, 5, 10, 20, 50, ...)
   */
  function StepNumber(start, end, step, prettyStep) {
    // set default values
    this._start = 0;
    this._end = 0;
    this._step = 1;
    this.prettyStep = true;
    this.precision = 5;

    this._current = 0;
    this.setRange(start, end, step, prettyStep);
  };

  /**
   * Check for input values, to prevent disasters from happening
   *
   * Source: http://stackoverflow.com/a/1830844
   */
  StepNumber.prototype.isNumeric = function (n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
  };

  /**
   * Set a new range: start, end and step.
   *
   * @param {Number} start     The start value
   * @param {Number} end     The end value
   * @param {Number} step    Optional. Step size. Must be a positive value.
   * @param {boolean} prettyStep Optional. If true, the step size is rounded
   *               To a pretty step size (like 1, 2, 5, 10, 20, 50, ...)
   */
  StepNumber.prototype.setRange = function (start, end, step, prettyStep) {
    if (!this.isNumeric(start)) {
      throw new Error('Parameter \'start\' is not numeric; value: ' + start);
    }
    if (!this.isNumeric(end)) {
      throw new Error('Parameter \'end\' is not numeric; value: ' + start);
    }
    if (!this.isNumeric(step)) {
      throw new Error('Parameter \'step\' is not numeric; value: ' + start);
    }

    this._start = start ? start : 0;
    this._end = end ? end : 0;

    this.setStep(step, prettyStep);
  };

  /**
   * Set a new step size
   * @param {Number} step    New step size. Must be a positive value
   * @param {boolean} prettyStep Optional. If true, the provided step is rounded
   *               to a pretty step size (like 1, 2, 5, 10, 20, 50, ...)
   */
  StepNumber.prototype.setStep = function (step, prettyStep) {
    if (step === undefined || step <= 0) return;

    if (prettyStep !== undefined) this.prettyStep = prettyStep;

    if (this.prettyStep === true) this._step = StepNumber.calculatePrettyStep(step);else this._step = step;
  };

  /**
   * Calculate a nice step size, closest to the desired step size.
   * Returns a value in one of the ranges 1*10^n, 2*10^n, or 5*10^n, where n is an
   * integer Number. For example 1, 2, 5, 10, 20, 50, etc...
   * @param {Number}  step  Desired step size
   * @return {Number}     Nice step size
   */
  StepNumber.calculatePrettyStep = function (step) {
    var log10 = function log10(x) {
      return Math.log(x) / Math.LN10;
    };

    // try three steps (multiple of 1, 2, or 5
    var step1 = Math.pow(10, Math.round(log10(step))),
        step2 = 2 * Math.pow(10, Math.round(log10(step / 2))),
        step5 = 5 * Math.pow(10, Math.round(log10(step / 5)));

    // choose the best step (closest to minimum step)
    var prettyStep = step1;
    if (Math.abs(step2 - step) <= Math.abs(prettyStep - step)) prettyStep = step2;
    if (Math.abs(step5 - step) <= Math.abs(prettyStep - step)) prettyStep = step5;

    // for safety
    if (prettyStep <= 0) {
      prettyStep = 1;
    }

    return prettyStep;
  };

  /**
   * returns the current value of the step
   * @return {Number} current value
   */
  StepNumber.prototype.getCurrent = function () {
    return parseFloat(this._current.toPrecision(this.precision));
  };

  /**
   * returns the current step size
   * @return {Number} current step size
   */
  StepNumber.prototype.getStep = function () {
    return this._step;
  };

  /**
   * Set the current to its starting value.
   *
   * By default, this will be the largest value smaller than start, which
   * is a multiple of the step size.
   *
   * Parameters checkFirst is optional, default false.
   * If set to true, move the current value one step if smaller than start.
   */
  StepNumber.prototype.start = function (checkFirst) {
    if (checkFirst === undefined) {
      checkFirst = false;
    }

    this._current = this._start - this._start % this._step;

    if (checkFirst) {
      if (this.getCurrent() < this._start) {
        this.next();
      }
    }
  };

  /**
   * Do a step, add the step size to the current value
   */
  StepNumber.prototype.next = function () {
    this._current += this._step;
  };

  /**
   * Returns true whether the end is reached
   * @return {boolean}  True if the current value has passed the end value.
   */
  StepNumber.prototype.end = function () {
    return this._current > this._end;
  };

  module.exports = StepNumber;

/***/ },
/* 106 */
/***/ function(module, exports) {

  'use strict';

  /**
   * @prototype Range
   *
   * Helper class to make working with related min and max values easier.
   *
   * The range is inclusive; a given value is considered part of the range if:
   *
   *    this.min <= value <= this.max
   */
  function Range() {
    this.min = undefined;
    this.max = undefined;
  }

  /**
   * Adjust the range so that the passed value fits in it.
   *
   * If the value is outside of the current extremes, adjust
   * the min or max so that the value is within the range.
   *
   * @param {number} value Numeric value to fit in range
   */
  Range.prototype.adjust = function (value) {
    if (value === undefined) return;

    if (this.min === undefined || this.min > value) {
      this.min = value;
    }

    if (this.max === undefined || this.max < value) {
      this.max = value;
    }
  };

  /**
   * Adjust the current range so that the passed range fits in it.
   *
   * @param {Range} range Range instance to fit in current instance
   */
  Range.prototype.combine = function (range) {
    this.add(range.min);
    this.add(range.max);
  };

  /**
   * Expand the range by the given value
   *
   * min will be lowered by given value;
   * max will be raised by given value
   *
   * Shrinking by passing a negative value is allowed.
   *
   * @param {number} val Amount by which to expand or shrink current range with
   */
  Range.prototype.expand = function (val) {
    if (val === undefined) {
      return;
    }

    var newMin = this.min - val;
    var newMax = this.max + val;

    // Note that following allows newMin === newMax.
    // This should be OK, since method expand() allows this also.
    if (newMin > newMax) {
      throw new Error('Passed expansion value makes range invalid');
    }

    this.min = newMin;
    this.max = newMax;
  };

  /**
   * Determine the full range width of current instance.
   *
   * @returns {num} The calculated width of this range
   */
  Range.prototype.range = function () {
    return this.max - this.min;
  };

  /**
   * Determine the central point of current instance.
   *
   * @returns {number} the value in the middle of min and max
   */
  Range.prototype.center = function () {
    return (this.min + this.max) / 2;
  };

  module.exports = Range;

/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  ////////////////////////////////////////////////////////////////////////////////
  // This modules handles the options for Graph3d.
  //
  ////////////////////////////////////////////////////////////////////////////////
  var Camera = __webpack_require__(98);
  var Point3d = __webpack_require__(96);

  // enumerate the available styles
  var STYLE = {
    BAR: 0,
    BARCOLOR: 1,
    BARSIZE: 2,
    DOT: 3,
    DOTLINE: 4,
    DOTCOLOR: 5,
    DOTSIZE: 6,
    GRID: 7,
    LINE: 8,
    SURFACE: 9
  };

  // The string representations of the styles
  var STYLENAME = {
    'dot': STYLE.DOT,
    'dot-line': STYLE.DOTLINE,
    'dot-color': STYLE.DOTCOLOR,
    'dot-size': STYLE.DOTSIZE,
    'line': STYLE.LINE,
    'grid': STYLE.GRID,
    'surface': STYLE.SURFACE,
    'bar': STYLE.BAR,
    'bar-color': STYLE.BARCOLOR,
    'bar-size': STYLE.BARSIZE
  };

  /**
   * Field names in the options hash which are of relevance to the user.
   *
   * Specifically, these are the fields which require no special handling,
   * and can be directly copied over.
   */
  var OPTIONKEYS = ['width', 'height', 'filterLabel', 'legendLabel', 'xLabel', 'yLabel', 'zLabel', 'xValueLabel', 'yValueLabel', 'zValueLabel', 'showGrid', 'showPerspective', 'showShadow', 'keepAspectRatio', 'verticalRatio', 'dotSizeRatio', 'showAnimationControls', 'animationInterval', 'animationPreload', 'animationAutoStart', 'axisColor', 'gridColor', 'xCenter', 'yCenter'];

  /**
   * Field names in the options hash which are of relevance to the user.
   *
   * Same as OPTIONKEYS, but internally these fields are stored with 
   * prefix 'default' in the name.
   */
  var PREFIXEDOPTIONKEYS = ['xBarWidth', 'yBarWidth', 'valueMin', 'valueMax', 'xMin', 'xMax', 'xStep', 'yMin', 'yMax', 'yStep', 'zMin', 'zMax', 'zStep'];

  // Placeholder for DEFAULTS reference
  var DEFAULTS = undefined;

  /**
   * Check if given hash is empty.
   *
   * Source: http://stackoverflow.com/a/679937
   */
  function isEmpty(obj) {
    for (var prop in obj) {
      if (obj.hasOwnProperty(prop)) return false;
    }

    return true;
  }

  /**
   * Make first letter of parameter upper case.
   *
   * Source: http://stackoverflow.com/a/1026087
   */
  function capitalize(str) {
    if (str === undefined || str === "" || typeof str != "string") {
      return str;
    }

    return str.charAt(0).toUpperCase() + str.slice(1);
  }

  /**
   * Add a prefix to a field name, taking style guide into account
   */
  function prefixFieldName(prefix, fieldName) {
    if (prefix === undefined || prefix === "") {
      return fieldName;
    }

    return prefix + capitalize(fieldName);
  }

  /**
   * Forcibly copy fields from src to dst in a controlled manner.
   *
   * A given field in dst will always be overwitten. If this field
   * is undefined or not present in src, the field in dst will 
   * be explicitly set to undefined.
   * 
   * The intention here is to be able to reset all option fields.
   * 
   * Only the fields mentioned in array 'fields' will be handled.
   *
   * @param fields array with names of fields to copy
   * @param prefix optional; prefix to use for the target fields.
   */
  function forceCopy(src, dst, fields, prefix) {
    var srcKey;
    var dstKey;

    for (var i in fields) {
      srcKey = fields[i];
      dstKey = prefixFieldName(prefix, srcKey);

      dst[dstKey] = src[srcKey];
    }
  }

  /**
   * Copy fields from src to dst in a safe and controlled manner.
   *
   * Only the fields mentioned in array 'fields' will be copied over,
   * and only if these are actually defined.
   *
   * @param fields array with names of fields to copy
   * @param prefix optional; prefix to use for the target fields.
   */
  function safeCopy(src, dst, fields, prefix) {
    var srcKey;
    var dstKey;

    for (var i in fields) {
      srcKey = fields[i];
      if (src[srcKey] === undefined) continue;

      dstKey = prefixFieldName(prefix, srcKey);

      dst[dstKey] = src[srcKey];
    }
  }

  /**
   * Initialize dst with the values in src.
   *
   * src is the hash with the default values. 
   * A reference DEFAULTS to this hash is stored locally for 
   * further handling.
   *
   * For now, dst is assumed to be a Graph3d instance.
   */
  function setDefaults(src, dst) {
    if (src === undefined || isEmpty(src)) {
      throw new Error('No DEFAULTS passed');
    }
    if (dst === undefined) {
      throw new Error('No dst passed');
    }

    // Remember defaults for future reference
    DEFAULTS = src;

    // Handle the defaults which can be simply copied over
    forceCopy(src, dst, OPTIONKEYS);
    forceCopy(src, dst, PREFIXEDOPTIONKEYS, 'default');

    // Handle the more complex ('special') fields
    setSpecialSettings(src, dst);

    // Following are internal fields, not part of the user settings
    dst.margin = 10; // px
    dst.showGrayBottom = false; // TODO: this does not work correctly
    dst.showTooltip = false;
    dst.onclick_callback = null;
    dst.eye = new Point3d(0, 0, -1); // TODO: set eye.z about 3/4 of the width of the window?
  }

  function setOptions(options, dst) {
    if (options === undefined) {
      return;
    }
    if (dst === undefined) {
      throw new Error('No dst passed');
    }

    if (DEFAULTS === undefined || isEmpty(DEFAULTS)) {
      throw new Error('DEFAULTS not set for module Settings');
    }

    // Handle the parameters which can be simply copied over
    safeCopy(options, dst, OPTIONKEYS);
    safeCopy(options, dst, PREFIXEDOPTIONKEYS, 'default');

    // Handle the more complex ('special') fields
    setSpecialSettings(options, dst);
  }

  /**
   * Special handling for certain parameters
   *
   * 'Special' here means: setting requires more than a simple copy
   */
  function setSpecialSettings(src, dst) {
    if (src.backgroundColor !== undefined) {
      setBackgroundColor(src.backgroundColor, dst);
    }

    setDataColor(src.dataColor, dst);
    setStyle(src.style, dst);
    setShowLegend(src.showLegend, dst);
    setCameraPosition(src.cameraPosition, dst);

    // As special fields go, this is an easy one; just a translation of the name.
    // Can't use this.tooltip directly, because that field exists internally
    if (src.tooltip !== undefined) {
      dst.showTooltip = src.tooltip;
    }
    if (src.onclick != undefined) {
      dst.onclick_callback = src.onclick;
    }
  }

  /**
   * Set the value of setting 'showLegend'
   *
   * This depends on the value of the style fields, so it must be called
   * after the style field has been initialized.
   */
  function setShowLegend(showLegend, dst) {
    if (showLegend === undefined) {
      // If the default was auto, make a choice for this field
      var isAutoByDefault = DEFAULTS.showLegend === undefined;

      if (isAutoByDefault) {
        // these styles default to having legends
        var isLegendGraphStyle = dst.style === STYLE.DOTCOLOR || dst.style === STYLE.DOTSIZE;

        dst.showLegend = isLegendGraphStyle;
      } else {
        // Leave current value as is
      }
    } else {
      dst.showLegend = showLegend;
    }
  }

  /**
   * Retrieve the style index from given styleName
   * @param {string} styleName  Style name such as 'dot', 'grid', 'dot-line'
   * @return {Number} styleNumber Enumeration value representing the style, or -1
   *                when not found
   */
  function getStyleNumberByName(styleName) {
    var number = STYLENAME[styleName];

    if (number === undefined) {
      return -1;
    }

    return number;
  }

  /**
   * Check if given number is a valid style number.
   *
   * @return true if valid, false otherwise
   */
  function checkStyleNumber(style) {
    var valid = false;

    for (var n in STYLE) {
      if (STYLE[n] === style) {
        valid = true;
        break;
      }
    }

    return valid;
  }

  function setStyle(style, dst) {
    if (style === undefined) {
      return; // Nothing to do
    }

    var styleNumber;

    if (typeof style === 'string') {
      styleNumber = getStyleNumberByName(style);

      if (styleNumber === -1) {
        throw new Error('Style \'' + style + '\' is invalid');
      }
    } else {
      // Do a pedantic check on style number value
      if (!checkStyleNumber(style)) {
        throw new Error('Style \'' + style + '\' is invalid');
      }

      styleNumber = style;
    }

    dst.style = styleNumber;
  }

  /**
   * Set the background styling for the graph
   * @param {string | {fill: string, stroke: string, strokeWidth: string}} backgroundColor
   */
  function setBackgroundColor(backgroundColor, dst) {
    var fill = 'white';
    var stroke = 'gray';
    var strokeWidth = 1;

    if (typeof backgroundColor === 'string') {
      fill = backgroundColor;
      stroke = 'none';
      strokeWidth = 0;
    } else if ((typeof backgroundColor === 'undefined' ? 'undefined' : (0, _typeof3['default'])(backgroundColor)) === 'object') {
      if (backgroundColor.fill !== undefined) fill = backgroundColor.fill;
      if (backgroundColor.stroke !== undefined) stroke = backgroundColor.stroke;
      if (backgroundColor.strokeWidth !== undefined) strokeWidth = backgroundColor.strokeWidth;
    } else {
      throw new Error('Unsupported type of backgroundColor');
    }

    dst.frame.style.backgroundColor = fill;
    dst.frame.style.borderColor = stroke;
    dst.frame.style.borderWidth = strokeWidth + 'px';
    dst.frame.style.borderStyle = 'solid';
  }

  function setDataColor(dataColor, dst) {
    if (dataColor === undefined) {
      return; // Nothing to do
    }

    if (dst.dataColor === undefined) {
      dst.dataColor = {};
    }

    if (typeof dataColor === 'string') {
      dst.dataColor.fill = dataColor;
      dst.dataColor.stroke = dataColor;
    } else {
      if (dataColor.fill) {
        dst.dataColor.fill = dataColor.fill;
      }
      if (dataColor.stroke) {
        dst.dataColor.stroke = dataColor.stroke;
      }
      if (dataColor.strokeWidth !== undefined) {
        dst.dataColor.strokeWidth = dataColor.strokeWidth;
      }
    }
  }

  function setCameraPosition(cameraPosition, dst) {
    var camPos = cameraPosition;
    if (camPos === undefined) {
      return;
    }

    if (dst.camera === undefined) {
      dst.camera = new Camera();
    }

    dst.camera.setArmRotation(camPos.horizontal, camPos.vertical);
    dst.camera.setArmLength(camPos.distance);
  }

  module.exports.STYLE = STYLE;
  module.exports.setDefaults = setDefaults;
  module.exports.setOptions = setOptions;
  module.exports.setCameraPosition = setCameraPosition;

/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  // Only load hammer.js when in a browser environment
  // (loading hammer.js in a node.js environment gives errors)
  if (typeof window !== 'undefined') {
    var propagating = __webpack_require__(109);
    var Hammer = window['Hammer'] || __webpack_require__(110);
    module.exports = propagating(Hammer, {
      preventDefault: 'mouse'
    });
  } else {
    module.exports = function () {
      throw Error('hammer.js is only available in a browser, not in node.js.');
    };
  }

/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

  var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;'use strict';

  (function (factory) {
    if (true) {
      // AMD. Register as an anonymous module.
      !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else if (typeof exports === 'object') {
      // Node. Does not work with strict CommonJS, but
      // only CommonJS-like environments that support module.exports,
      // like Node.
      module.exports = factory();
    } else {
      // Browser globals (root is window)
      window.propagating = factory();
    }
  }(function () {
    var _firstTarget = null; // singleton, will contain the target element where the touch event started

    /**
     * Extend an Hammer.js instance with event propagation.
     *
     * Features:
     * - Events emitted by hammer will propagate in order from child to parent
     *   elements.
     * - Events are extended with a function `event.stopPropagation()` to stop
     *   propagation to parent elements.
     * - An option `preventDefault` to stop all default browser behavior.
     *
     * Usage:
     *   var hammer = propagatingHammer(new Hammer(element));
     *   var hammer = propagatingHammer(new Hammer(element), {preventDefault: true});
     *
     * @param {Hammer.Manager} hammer   An hammer instance.
     * @param {Object} [options]        Available options:
     *                                  - `preventDefault: true | false | 'mouse' | 'touch' | 'pen'`.
     *                                    Enforce preventing the default browser behavior.
     *                                    Cannot be set to `false`.
     * @return {Hammer.Manager} Returns the same hammer instance with extended
     *                          functionality
     */
    return function propagating(hammer, options) {
      var _options = options || {
        preventDefault: false
      };

      if (hammer.Manager) {
        // This looks like the Hammer constructor.
        // Overload the constructors with our own.
        var Hammer = hammer;

        var PropagatingHammer = function(element, options) {
          var o = Object.create(_options);
          if (options) Hammer.assign(o, options);
          return propagating(new Hammer(element, o), o);
        };
        Hammer.assign(PropagatingHammer, Hammer);

        PropagatingHammer.Manager = function (element, options) {
          var o = Object.create(_options);
          if (options) Hammer.assign(o, options);
          return propagating(new Hammer.Manager(element, o), o);
        };

        return PropagatingHammer;
      }

      // create a wrapper object which will override the functions
      // `on`, `off`, `destroy`, and `emit` of the hammer instance
      var wrapper = Object.create(hammer);

      // attach to DOM element
      var element = hammer.element;

      if(!element.hammer) element.hammer = [];
      element.hammer.push(wrapper);

      // register an event to catch the start of a gesture and store the
      // target in a singleton
      hammer.on('hammer.input', function (event) {
        if (_options.preventDefault === true || (_options.preventDefault === event.pointerType)) {
          event.preventDefault();
        }
        if (event.isFirst) {
          _firstTarget = event.target;
        }
      });

      /** @type {Object.<String, Array.<function>>} */
      wrapper._handlers = {};

      /**
       * Register a handler for one or multiple events
       * @param {String} events    A space separated string with events
       * @param {function} handler A callback function, called as handler(event)
       * @returns {Hammer.Manager} Returns the hammer instance
       */
      wrapper.on = function (events, handler) {
        // register the handler
        split(events).forEach(function (event) {
          var _handlers = wrapper._handlers[event];
          if (!_handlers) {
            wrapper._handlers[event] = _handlers = [];

            // register the static, propagated handler
            hammer.on(event, propagatedHandler);
          }
          _handlers.push(handler);
        });

        return wrapper;
      };

      /**
       * Unregister a handler for one or multiple events
       * @param {String} events      A space separated string with events
       * @param {function} [handler] Optional. The registered handler. If not
       *                             provided, all handlers for given events
       *                             are removed.
       * @returns {Hammer.Manager}   Returns the hammer instance
       */
      wrapper.off = function (events, handler) {
        // unregister the handler
        split(events).forEach(function (event) {
          var _handlers = wrapper._handlers[event];
          if (_handlers) {
            _handlers = handler ? _handlers.filter(function (h) {
              return h !== handler;
            }) : [];

            if (_handlers.length > 0) {
              wrapper._handlers[event] = _handlers;
            }
            else {
              // remove static, propagated handler
              hammer.off(event, propagatedHandler);
              delete wrapper._handlers[event];
            }
          }
        });

        return wrapper;
      };

      /**
       * Emit to the event listeners
       * @param {string} eventType
       * @param {Event} event
       */
      wrapper.emit = function(eventType, event) {
        _firstTarget = event.target;
        hammer.emit(eventType, event);
      };

      wrapper.destroy = function () {
        // Detach from DOM element
        var hammers = hammer.element.hammer;
        var idx = hammers.indexOf(wrapper);
        if(idx !== -1) hammers.splice(idx,1);
        if(!hammers.length) delete hammer.element.hammer;

        // clear all handlers
        wrapper._handlers = {};

        // call original hammer destroy
        hammer.destroy();
      };

      // split a string with space separated words
      function split(events) {
        return events.match(/[^ ]+/g);
      }

      /**
       * A static event handler, applying event propagation.
       * @param {Object} event
       */
      function propagatedHandler(event) {
        // let only a single hammer instance handle this event
        if (event.type !== 'hammer.input') {
          // it is possible that the same srcEvent is used with multiple hammer events,
          // we keep track on which events are handled in an object _handled
          if (!event.srcEvent._handled) {
            event.srcEvent._handled = {};
          }

          if (event.srcEvent._handled[event.type]) {
            return;
          }
          else {
            event.srcEvent._handled[event.type] = true;
          }
        }

        // attach a stopPropagation function to the event
        var stopped = false;
        event.stopPropagation = function () {
          stopped = true;
        };

        //wrap the srcEvent's stopPropagation to also stop hammer propagation:
        var srcStop = event.srcEvent.stopPropagation.bind(event.srcEvent);
        if(typeof srcStop == "function") {
          event.srcEvent.stopPropagation = function(){
            srcStop();
            event.stopPropagation();
          }
        }

        // attach firstTarget property to the event
        event.firstTarget = _firstTarget;

        // propagate over all elements (until stopped)
        var elem = _firstTarget;
        while (elem && !stopped) {
          var elemHammer = elem.hammer;
          if(elemHammer){
            var _handlers;
            for(var k = 0; k < elemHammer.length; k++){
              _handlers = elemHammer[k]._handlers[event.type];
              if(_handlers) for (var i = 0; i < _handlers.length && !stopped; i++) {
                _handlers[i](event);
              }
            }
          }
          elem = elem.parentNode;
        }
      }

      return wrapper;
    };
  }));


/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

  var __WEBPACK_AMD_DEFINE_RESULT__;/*! Hammer.JS - v2.0.7 - 2016-04-22
   * http://hammerjs.github.io/
   *
   * Copyright (c) 2016 Jorik Tangelder;
   * Licensed under the MIT license */
  (function(window, document, exportName, undefined) {
    'use strict';

  var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
  var TEST_ELEMENT = document.createElement('div');

  var TYPE_FUNCTION = 'function';

  var round = Math.round;
  var abs = Math.abs;
  var now = Date.now;

  /**
   * set a timeout with a given scope
   * @param {Function} fn
   * @param {Number} timeout
   * @param {Object} context
   * @returns {number}
   */
  function setTimeoutContext(fn, timeout, context) {
      return setTimeout(bindFn(fn, context), timeout);
  }

  /**
   * if the argument is an array, we want to execute the fn on each entry
   * if it aint an array we don't want to do a thing.
   * this is used by all the methods that accept a single and array argument.
   * @param {*|Array} arg
   * @param {String} fn
   * @param {Object} [context]
   * @returns {Boolean}
   */
  function invokeArrayArg(arg, fn, context) {
      if (Array.isArray(arg)) {
          each(arg, context[fn], context);
          return true;
      }
      return false;
  }

  /**
   * walk objects and arrays
   * @param {Object} obj
   * @param {Function} iterator
   * @param {Object} context
   */
  function each(obj, iterator, context) {
      var i;

      if (!obj) {
          return;
      }

      if (obj.forEach) {
          obj.forEach(iterator, context);
      } else if (obj.length !== undefined) {
          i = 0;
          while (i < obj.length) {
              iterator.call(context, obj[i], i, obj);
              i++;
          }
      } else {
          for (i in obj) {
              obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
          }
      }
  }

  /**
   * wrap a method with a deprecation warning and stack trace
   * @param {Function} method
   * @param {String} name
   * @param {String} message
   * @returns {Function} A new function wrapping the supplied method.
   */
  function deprecate(method, name, message) {
      var deprecationMessage = 'DEPRECATED METHOD: ' + name + '\n' + message + ' AT \n';
      return function() {
          var e = new Error('get-stack-trace');
          var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '')
              .replace(/^\s+at\s+/gm, '')
              .replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';

          var log = window.console && (window.console.warn || window.console.log);
          if (log) {
              log.call(window.console, deprecationMessage, stack);
          }
          return method.apply(this, arguments);
      };
  }

  /**
   * extend object.
   * means that properties in dest will be overwritten by the ones in src.
   * @param {Object} target
   * @param {...Object} objects_to_assign
   * @returns {Object} target
   */
  var assign;
  if (typeof Object.assign !== 'function') {
      assign = function assign(target) {
          if (target === undefined || target === null) {
              throw new TypeError('Cannot convert undefined or null to object');
          }

          var output = Object(target);
          for (var index = 1; index < arguments.length; index++) {
              var source = arguments[index];
              if (source !== undefined && source !== null) {
                  for (var nextKey in source) {
                      if (source.hasOwnProperty(nextKey)) {
                          output[nextKey] = source[nextKey];
                      }
                  }
              }
          }
          return output;
      };
  } else {
      assign = Object.assign;
  }

  /**
   * extend object.
   * means that properties in dest will be overwritten by the ones in src.
   * @param {Object} dest
   * @param {Object} src
   * @param {Boolean} [merge=false]
   * @returns {Object} dest
   */
  var extend = deprecate(function extend(dest, src, merge) {
      var keys = Object.keys(src);
      var i = 0;
      while (i < keys.length) {
          if (!merge || (merge && dest[keys[i]] === undefined)) {
              dest[keys[i]] = src[keys[i]];
          }
          i++;
      }
      return dest;
  }, 'extend', 'Use `assign`.');

  /**
   * merge the values from src in the dest.
   * means that properties that exist in dest will not be overwritten by src
   * @param {Object} dest
   * @param {Object} src
   * @returns {Object} dest
   */
  var merge = deprecate(function merge(dest, src) {
      return extend(dest, src, true);
  }, 'merge', 'Use `assign`.');

  /**
   * simple class inheritance
   * @param {Function} child
   * @param {Function} base
   * @param {Object} [properties]
   */
  function inherit(child, base, properties) {
      var baseP = base.prototype,
          childP;

      childP = child.prototype = Object.create(baseP);
      childP.constructor = child;
      childP._super = baseP;

      if (properties) {
          assign(childP, properties);
      }
  }

  /**
   * simple function bind
   * @param {Function} fn
   * @param {Object} context
   * @returns {Function}
   */
  function bindFn(fn, context) {
      return function boundFn() {
          return fn.apply(context, arguments);
      };
  }

  /**
   * let a boolean value also be a function that must return a boolean
   * this first item in args will be used as the context
   * @param {Boolean|Function} val
   * @param {Array} [args]
   * @returns {Boolean}
   */
  function boolOrFn(val, args) {
      if (typeof val == TYPE_FUNCTION) {
          return val.apply(args ? args[0] || undefined : undefined, args);
      }
      return val;
  }

  /**
   * use the val2 when val1 is undefined
   * @param {*} val1
   * @param {*} val2
   * @returns {*}
   */
  function ifUndefined(val1, val2) {
      return (val1 === undefined) ? val2 : val1;
  }

  /**
   * addEventListener with multiple events at once
   * @param {EventTarget} target
   * @param {String} types
   * @param {Function} handler
   */
  function addEventListeners(target, types, handler) {
      each(splitStr(types), function(type) {
          target.addEventListener(type, handler, false);
      });
  }

  /**
   * removeEventListener with multiple events at once
   * @param {EventTarget} target
   * @param {String} types
   * @param {Function} handler
   */
  function removeEventListeners(target, types, handler) {
      each(splitStr(types), function(type) {
          target.removeEventListener(type, handler, false);
      });
  }

  /**
   * find if a node is in the given parent
   * @method hasParent
   * @param {HTMLElement} node
   * @param {HTMLElement} parent
   * @return {Boolean} found
   */
  function hasParent(node, parent) {
      while (node) {
          if (node == parent) {
              return true;
          }
          node = node.parentNode;
      }
      return false;
  }

  /**
   * small indexOf wrapper
   * @param {String} str
   * @param {String} find
   * @returns {Boolean} found
   */
  function inStr(str, find) {
      return str.indexOf(find) > -1;
  }

  /**
   * split string on whitespace
   * @param {String} str
   * @returns {Array} words
   */
  function splitStr(str) {
      return str.trim().split(/\s+/g);
  }

  /**
   * find if a array contains the object using indexOf or a simple polyFill
   * @param {Array} src
   * @param {String} find
   * @param {String} [findByKey]
   * @return {Boolean|Number} false when not found, or the index
   */
  function inArray(src, find, findByKey) {
      if (src.indexOf && !findByKey) {
          return src.indexOf(find);
      } else {
          var i = 0;
          while (i < src.length) {
              if ((findByKey && src[i][findByKey] == find) || (!findByKey && src[i] === find)) {
                  return i;
              }
              i++;
          }
          return -1;
      }
  }

  /**
   * convert array-like objects to real arrays
   * @param {Object} obj
   * @returns {Array}
   */
  function toArray(obj) {
      return Array.prototype.slice.call(obj, 0);
  }

  /**
   * unique array with objects based on a key (like 'id') or just by the array's value
   * @param {Array} src [{id:1},{id:2},{id:1}]
   * @param {String} [key]
   * @param {Boolean} [sort=False]
   * @returns {Array} [{id:1},{id:2}]
   */
  function uniqueArray(src, key, sort) {
      var results = [];
      var values = [];
      var i = 0;

      while (i < src.length) {
          var val = key ? src[i][key] : src[i];
          if (inArray(values, val) < 0) {
              results.push(src[i]);
          }
          values[i] = val;
          i++;
      }

      if (sort) {
          if (!key) {
              results = results.sort();
          } else {
              results = results.sort(function sortUniqueArray(a, b) {
                  return a[key] > b[key];
              });
          }
      }

      return results;
  }

  /**
   * get the prefixed property
   * @param {Object} obj
   * @param {String} property
   * @returns {String|Undefined} prefixed
   */
  function prefixed(obj, property) {
      var prefix, prop;
      var camelProp = property[0].toUpperCase() + property.slice(1);

      var i = 0;
      while (i < VENDOR_PREFIXES.length) {
          prefix = VENDOR_PREFIXES[i];
          prop = (prefix) ? prefix + camelProp : property;

          if (prop in obj) {
              return prop;
          }
          i++;
      }
      return undefined;
  }

  /**
   * get a unique id
   * @returns {number} uniqueId
   */
  var _uniqueId = 1;
  function uniqueId() {
      return _uniqueId++;
  }

  /**
   * get the window object of an element
   * @param {HTMLElement} element
   * @returns {DocumentView|Window}
   */
  function getWindowForElement(element) {
      var doc = element.ownerDocument || element;
      return (doc.defaultView || doc.parentWindow || window);
  }

  var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;

  var SUPPORT_TOUCH = ('ontouchstart' in window);
  var SUPPORT_POINTER_EVENTS = prefixed(window, 'PointerEvent') !== undefined;
  var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);

  var INPUT_TYPE_TOUCH = 'touch';
  var INPUT_TYPE_PEN = 'pen';
  var INPUT_TYPE_MOUSE = 'mouse';
  var INPUT_TYPE_KINECT = 'kinect';

  var COMPUTE_INTERVAL = 25;

  var INPUT_START = 1;
  var INPUT_MOVE = 2;
  var INPUT_END = 4;
  var INPUT_CANCEL = 8;

  var DIRECTION_NONE = 1;
  var DIRECTION_LEFT = 2;
  var DIRECTION_RIGHT = 4;
  var DIRECTION_UP = 8;
  var DIRECTION_DOWN = 16;

  var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
  var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
  var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;

  var PROPS_XY = ['x', 'y'];
  var PROPS_CLIENT_XY = ['clientX', 'clientY'];

  /**
   * create new input type manager
   * @param {Manager} manager
   * @param {Function} callback
   * @returns {Input}
   * @constructor
   */
  function Input(manager, callback) {
      var self = this;
      this.manager = manager;
      this.callback = callback;
      this.element = manager.element;
      this.target = manager.options.inputTarget;

      // smaller wrapper around the handler, for the scope and the enabled state of the manager,
      // so when disabled the input events are completely bypassed.
      this.domHandler = function(ev) {
          if (boolOrFn(manager.options.enable, [manager])) {
              self.handler(ev);
          }
      };

      this.init();

  }

  Input.prototype = {
      /**
       * should handle the inputEvent data and trigger the callback
       * @virtual
       */
      handler: function() { },

      /**
       * bind the events
       */
      init: function() {
          this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
          this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
          this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
      },

      /**
       * unbind the events
       */
      destroy: function() {
          this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
          this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
          this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
      }
  };

  /**
   * create new input type manager
   * called by the Manager constructor
   * @param {Hammer} manager
   * @returns {Input}
   */
  function createInputInstance(manager) {
      var Type;
      var inputClass = manager.options.inputClass;

      if (inputClass) {
          Type = inputClass;
      } else if (SUPPORT_POINTER_EVENTS) {
          Type = PointerEventInput;
      } else if (SUPPORT_ONLY_TOUCH) {
          Type = TouchInput;
      } else if (!SUPPORT_TOUCH) {
          Type = MouseInput;
      } else {
          Type = TouchMouseInput;
      }
      return new (Type)(manager, inputHandler);
  }

  /**
   * handle input events
   * @param {Manager} manager
   * @param {String} eventType
   * @param {Object} input
   */
  function inputHandler(manager, eventType, input) {
      var pointersLen = input.pointers.length;
      var changedPointersLen = input.changedPointers.length;
      var isFirst = (eventType & INPUT_START && (pointersLen - changedPointersLen === 0));
      var isFinal = (eventType & (INPUT_END | INPUT_CANCEL) && (pointersLen - changedPointersLen === 0));

      input.isFirst = !!isFirst;
      input.isFinal = !!isFinal;

      if (isFirst) {
          manager.session = {};
      }

      // source event is the normalized value of the domEvents
      // like 'touchstart, mouseup, pointerdown'
      input.eventType = eventType;

      // compute scale, rotation etc
      computeInputData(manager, input);

      // emit secret event
      manager.emit('hammer.input', input);

      manager.recognize(input);
      manager.session.prevInput = input;
  }

  /**
   * extend the data with some usable properties like scale, rotate, velocity etc
   * @param {Object} manager
   * @param {Object} input
   */
  function computeInputData(manager, input) {
      var session = manager.session;
      var pointers = input.pointers;
      var pointersLength = pointers.length;

      // store the first input to calculate the distance and direction
      if (!session.firstInput) {
          session.firstInput = simpleCloneInputData(input);
      }

      // to compute scale and rotation we need to store the multiple touches
      if (pointersLength > 1 && !session.firstMultiple) {
          session.firstMultiple = simpleCloneInputData(input);
      } else if (pointersLength === 1) {
          session.firstMultiple = false;
      }

      var firstInput = session.firstInput;
      var firstMultiple = session.firstMultiple;
      var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;

      var center = input.center = getCenter(pointers);
      input.timeStamp = now();
      input.deltaTime = input.timeStamp - firstInput.timeStamp;

      input.angle = getAngle(offsetCenter, center);
      input.distance = getDistance(offsetCenter, center);

      computeDeltaXY(session, input);
      input.offsetDirection = getDirection(input.deltaX, input.deltaY);

      var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
      input.overallVelocityX = overallVelocity.x;
      input.overallVelocityY = overallVelocity.y;
      input.overallVelocity = (abs(overallVelocity.x) > abs(overallVelocity.y)) ? overallVelocity.x : overallVelocity.y;

      input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
      input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;

      input.maxPointers = !session.prevInput ? input.pointers.length : ((input.pointers.length >
          session.prevInput.maxPointers) ? input.pointers.length : session.prevInput.maxPointers);

      computeIntervalInputData(session, input);

      // find the correct target
      var target = manager.element;
      if (hasParent(input.srcEvent.target, target)) {
          target = input.srcEvent.target;
      }
      input.target = target;
  }

  function computeDeltaXY(session, input) {
      var center = input.center;
      var offset = session.offsetDelta || {};
      var prevDelta = session.prevDelta || {};
      var prevInput = session.prevInput || {};

      if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
          prevDelta = session.prevDelta = {
              x: prevInput.deltaX || 0,
              y: prevInput.deltaY || 0
          };

          offset = session.offsetDelta = {
              x: center.x,
              y: center.y
          };
      }

      input.deltaX = prevDelta.x + (center.x - offset.x);
      input.deltaY = prevDelta.y + (center.y - offset.y);
  }

  /**
   * velocity is calculated every x ms
   * @param {Object} session
   * @param {Object} input
   */
  function computeIntervalInputData(session, input) {
      var last = session.lastInterval || input,
          deltaTime = input.timeStamp - last.timeStamp,
          velocity, velocityX, velocityY, direction;

      if (input.eventType != INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
          var deltaX = input.deltaX - last.deltaX;
          var deltaY = input.deltaY - last.deltaY;

          var v = getVelocity(deltaTime, deltaX, deltaY);
          velocityX = v.x;
          velocityY = v.y;
          velocity = (abs(v.x) > abs(v.y)) ? v.x : v.y;
          direction = getDirection(deltaX, deltaY);

          session.lastInterval = input;
      } else {
          // use latest velocity info if it doesn't overtake a minimum period
          velocity = last.velocity;
          velocityX = last.velocityX;
          velocityY = last.velocityY;
          direction = last.direction;
      }

      input.velocity = velocity;
      input.velocityX = velocityX;
      input.velocityY = velocityY;
      input.direction = direction;
  }

  /**
   * create a simple clone from the input used for storage of firstInput and firstMultiple
   * @param {Object} input
   * @returns {Object} clonedInputData
   */
  function simpleCloneInputData(input) {
      // make a simple copy of the pointers because we will get a reference if we don't
      // we only need clientXY for the calculations
      var pointers = [];
      var i = 0;
      while (i < input.pointers.length) {
          pointers[i] = {
              clientX: round(input.pointers[i].clientX),
              clientY: round(input.pointers[i].clientY)
          };
          i++;
      }

      return {
          timeStamp: now(),
          pointers: pointers,
          center: getCenter(pointers),
          deltaX: input.deltaX,
          deltaY: input.deltaY
      };
  }

  /**
   * get the center of all the pointers
   * @param {Array} pointers
   * @return {Object} center contains `x` and `y` properties
   */
  function getCenter(pointers) {
      var pointersLength = pointers.length;

      // no need to loop when only one touch
      if (pointersLength === 1) {
          return {
              x: round(pointers[0].clientX),
              y: round(pointers[0].clientY)
          };
      }

      var x = 0, y = 0, i = 0;
      while (i < pointersLength) {
          x += pointers[i].clientX;
          y += pointers[i].clientY;
          i++;
      }

      return {
          x: round(x / pointersLength),
          y: round(y / pointersLength)
      };
  }

  /**
   * calculate the velocity between two points. unit is in px per ms.
   * @param {Number} deltaTime
   * @param {Number} x
   * @param {Number} y
   * @return {Object} velocity `x` and `y`
   */
  function getVelocity(deltaTime, x, y) {
      return {
          x: x / deltaTime || 0,
          y: y / deltaTime || 0
      };
  }

  /**
   * get the direction between two points
   * @param {Number} x
   * @param {Number} y
   * @return {Number} direction
   */
  function getDirection(x, y) {
      if (x === y) {
          return DIRECTION_NONE;
      }

      if (abs(x) >= abs(y)) {
          return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
      }
      return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
  }

  /**
   * calculate the absolute distance between two points
   * @param {Object} p1 {x, y}
   * @param {Object} p2 {x, y}
   * @param {Array} [props] containing x and y keys
   * @return {Number} distance
   */
  function getDistance(p1, p2, props) {
      if (!props) {
          props = PROPS_XY;
      }
      var x = p2[props[0]] - p1[props[0]],
          y = p2[props[1]] - p1[props[1]];

      return Math.sqrt((x * x) + (y * y));
  }

  /**
   * calculate the angle between two coordinates
   * @param {Object} p1
   * @param {Object} p2
   * @param {Array} [props] containing x and y keys
   * @return {Number} angle
   */
  function getAngle(p1, p2, props) {
      if (!props) {
          props = PROPS_XY;
      }
      var x = p2[props[0]] - p1[props[0]],
          y = p2[props[1]] - p1[props[1]];
      return Math.atan2(y, x) * 180 / Math.PI;
  }

  /**
   * calculate the rotation degrees between two pointersets
   * @param {Array} start array of pointers
   * @param {Array} end array of pointers
   * @return {Number} rotation
   */
  function getRotation(start, end) {
      return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
  }

  /**
   * calculate the scale factor between two pointersets
   * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
   * @param {Array} start array of pointers
   * @param {Array} end array of pointers
   * @return {Number} scale
   */
  function getScale(start, end) {
      return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
  }

  var MOUSE_INPUT_MAP = {
      mousedown: INPUT_START,
      mousemove: INPUT_MOVE,
      mouseup: INPUT_END
  };

  var MOUSE_ELEMENT_EVENTS = 'mousedown';
  var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';

  /**
   * Mouse events input
   * @constructor
   * @extends Input
   */
  function MouseInput() {
      this.evEl = MOUSE_ELEMENT_EVENTS;
      this.evWin = MOUSE_WINDOW_EVENTS;

      this.pressed = false; // mousedown state

      Input.apply(this, arguments);
  }

  inherit(MouseInput, Input, {
      /**
       * handle mouse events
       * @param {Object} ev
       */
      handler: function MEhandler(ev) {
          var eventType = MOUSE_INPUT_MAP[ev.type];

          // on start we want to have the left mouse button down
          if (eventType & INPUT_START && ev.button === 0) {
              this.pressed = true;
          }

          if (eventType & INPUT_MOVE && ev.which !== 1) {
              eventType = INPUT_END;
          }

          // mouse must be down
          if (!this.pressed) {
              return;
          }

          if (eventType & INPUT_END) {
              this.pressed = false;
          }

          this.callback(this.manager, eventType, {
              pointers: [ev],
              changedPointers: [ev],
              pointerType: INPUT_TYPE_MOUSE,
              srcEvent: ev
          });
      }
  });

  var POINTER_INPUT_MAP = {
      pointerdown: INPUT_START,
      pointermove: INPUT_MOVE,
      pointerup: INPUT_END,
      pointercancel: INPUT_CANCEL,
      pointerout: INPUT_CANCEL
  };

  // in IE10 the pointer types is defined as an enum
  var IE10_POINTER_TYPE_ENUM = {
      2: INPUT_TYPE_TOUCH,
      3: INPUT_TYPE_PEN,
      4: INPUT_TYPE_MOUSE,
      5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816
  };

  var POINTER_ELEMENT_EVENTS = 'pointerdown';
  var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel';

  // IE10 has prefixed support, and case-sensitive
  if (window.MSPointerEvent && !window.PointerEvent) {
      POINTER_ELEMENT_EVENTS = 'MSPointerDown';
      POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
  }

  /**
   * Pointer events input
   * @constructor
   * @extends Input
   */
  function PointerEventInput() {
      this.evEl = POINTER_ELEMENT_EVENTS;
      this.evWin = POINTER_WINDOW_EVENTS;

      Input.apply(this, arguments);

      this.store = (this.manager.session.pointerEvents = []);
  }

  inherit(PointerEventInput, Input, {
      /**
       * handle mouse events
       * @param {Object} ev
       */
      handler: function PEhandler(ev) {
          var store = this.store;
          var removePointer = false;

          var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
          var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
          var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;

          var isTouch = (pointerType == INPUT_TYPE_TOUCH);

          // get index of the event in the store
          var storeIndex = inArray(store, ev.pointerId, 'pointerId');

          // start and mouse must be down
          if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
              if (storeIndex < 0) {
                  store.push(ev);
                  storeIndex = store.length - 1;
              }
          } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
              removePointer = true;
          }

          // it not found, so the pointer hasn't been down (so it's probably a hover)
          if (storeIndex < 0) {
              return;
          }

          // update the event in the store
          store[storeIndex] = ev;

          this.callback(this.manager, eventType, {
              pointers: store,
              changedPointers: [ev],
              pointerType: pointerType,
              srcEvent: ev
          });

          if (removePointer) {
              // remove from the store
              store.splice(storeIndex, 1);
          }
      }
  });

  var SINGLE_TOUCH_INPUT_MAP = {
      touchstart: INPUT_START,
      touchmove: INPUT_MOVE,
      touchend: INPUT_END,
      touchcancel: INPUT_CANCEL
  };

  var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
  var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';

  /**
   * Touch events input
   * @constructor
   * @extends Input
   */
  function SingleTouchInput() {
      this.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
      this.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
      this.started = false;

      Input.apply(this, arguments);
  }

  inherit(SingleTouchInput, Input, {
      handler: function TEhandler(ev) {
          var type = SINGLE_TOUCH_INPUT_MAP[ev.type];

          // should we handle the touch events?
          if (type === INPUT_START) {
              this.started = true;
          }

          if (!this.started) {
              return;
          }

          var touches = normalizeSingleTouches.call(this, ev, type);

          // when done, reset the started state
          if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
              this.started = false;
          }

          this.callback(this.manager, type, {
              pointers: touches[0],
              changedPointers: touches[1],
              pointerType: INPUT_TYPE_TOUCH,
              srcEvent: ev
          });
      }
  });

  /**
   * @this {TouchInput}
   * @param {Object} ev
   * @param {Number} type flag
   * @returns {undefined|Array} [all, changed]
   */
  function normalizeSingleTouches(ev, type) {
      var all = toArray(ev.touches);
      var changed = toArray(ev.changedTouches);

      if (type & (INPUT_END | INPUT_CANCEL)) {
          all = uniqueArray(all.concat(changed), 'identifier', true);
      }

      return [all, changed];
  }

  var TOUCH_INPUT_MAP = {
      touchstart: INPUT_START,
      touchmove: INPUT_MOVE,
      touchend: INPUT_END,
      touchcancel: INPUT_CANCEL
  };

  var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';

  /**
   * Multi-user touch events input
   * @constructor
   * @extends Input
   */
  function TouchInput() {
      this.evTarget = TOUCH_TARGET_EVENTS;
      this.targetIds = {};

      Input.apply(this, arguments);
  }

  inherit(TouchInput, Input, {
      handler: function MTEhandler(ev) {
          var type = TOUCH_INPUT_MAP[ev.type];
          var touches = getTouches.call(this, ev, type);
          if (!touches) {
              return;
          }

          this.callback(this.manager, type, {
              pointers: touches[0],
              changedPointers: touches[1],
              pointerType: INPUT_TYPE_TOUCH,
              srcEvent: ev
          });
      }
  });

  /**
   * @this {TouchInput}
   * @param {Object} ev
   * @param {Number} type flag
   * @returns {undefined|Array} [all, changed]
   */
  function getTouches(ev, type) {
      var allTouches = toArray(ev.touches);
      var targetIds = this.targetIds;

      // when there is only one touch, the process can be simplified
      if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
          targetIds[allTouches[0].identifier] = true;
          return [allTouches, allTouches];
      }

      var i,
          targetTouches,
          changedTouches = toArray(ev.changedTouches),
          changedTargetTouches = [],
          target = this.target;

      // get target touches from touches
      targetTouches = allTouches.filter(function(touch) {
          return hasParent(touch.target, target);
      });

      // collect touches
      if (type === INPUT_START) {
          i = 0;
          while (i < targetTouches.length) {
              targetIds[targetTouches[i].identifier] = true;
              i++;
          }
      }

      // filter changed touches to only contain touches that exist in the collected target ids
      i = 0;
      while (i < changedTouches.length) {
          if (targetIds[changedTouches[i].identifier]) {
              changedTargetTouches.push(changedTouches[i]);
          }

          // cleanup removed touches
          if (type & (INPUT_END | INPUT_CANCEL)) {
              delete targetIds[changedTouches[i].identifier];
          }
          i++;
      }

      if (!changedTargetTouches.length) {
          return;
      }

      return [
          // merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
          uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true),
          changedTargetTouches
      ];
  }

  /**
   * Combined touch and mouse input
   *
   * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
   * This because touch devices also emit mouse events while doing a touch.
   *
   * @constructor
   * @extends Input
   */

  var DEDUP_TIMEOUT = 2500;
  var DEDUP_DISTANCE = 25;

  function TouchMouseInput() {
      Input.apply(this, arguments);

      var handler = bindFn(this.handler, this);
      this.touch = new TouchInput(this.manager, handler);
      this.mouse = new MouseInput(this.manager, handler);

      this.primaryTouch = null;
      this.lastTouches = [];
  }

  inherit(TouchMouseInput, Input, {
      /**
       * handle mouse and touch events
       * @param {Hammer} manager
       * @param {String} inputEvent
       * @param {Object} inputData
       */
      handler: function TMEhandler(manager, inputEvent, inputData) {
          var isTouch = (inputData.pointerType == INPUT_TYPE_TOUCH),
              isMouse = (inputData.pointerType == INPUT_TYPE_MOUSE);

          if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
              return;
          }

          // when we're in a touch event, record touches to  de-dupe synthetic mouse event
          if (isTouch) {
              recordTouches.call(this, inputEvent, inputData);
          } else if (isMouse && isSyntheticEvent.call(this, inputData)) {
              return;
          }

          this.callback(manager, inputEvent, inputData);
      },

      /**
       * remove the event listeners
       */
      destroy: function destroy() {
          this.touch.destroy();
          this.mouse.destroy();
      }
  });

  function recordTouches(eventType, eventData) {
      if (eventType & INPUT_START) {
          this.primaryTouch = eventData.changedPointers[0].identifier;
          setLastTouch.call(this, eventData);
      } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
          setLastTouch.call(this, eventData);
      }
  }

  function setLastTouch(eventData) {
      var touch = eventData.changedPointers[0];

      if (touch.identifier === this.primaryTouch) {
          var lastTouch = {x: touch.clientX, y: touch.clientY};
          this.lastTouches.push(lastTouch);
          var lts = this.lastTouches;
          var removeLastTouch = function() {
              var i = lts.indexOf(lastTouch);
              if (i > -1) {
                  lts.splice(i, 1);
              }
          };
          setTimeout(removeLastTouch, DEDUP_TIMEOUT);
      }
  }

  function isSyntheticEvent(eventData) {
      var x = eventData.srcEvent.clientX, y = eventData.srcEvent.clientY;
      for (var i = 0; i < this.lastTouches.length; i++) {
          var t = this.lastTouches[i];
          var dx = Math.abs(x - t.x), dy = Math.abs(y - t.y);
          if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
              return true;
          }
      }
      return false;
  }

  var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
  var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;

  // magical touchAction value
  var TOUCH_ACTION_COMPUTE = 'compute';
  var TOUCH_ACTION_AUTO = 'auto';
  var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented
  var TOUCH_ACTION_NONE = 'none';
  var TOUCH_ACTION_PAN_X = 'pan-x';
  var TOUCH_ACTION_PAN_Y = 'pan-y';
  var TOUCH_ACTION_MAP = getTouchActionProps();

  /**
   * Touch Action
   * sets the touchAction property or uses the js alternative
   * @param {Manager} manager
   * @param {String} value
   * @constructor
   */
  function TouchAction(manager, value) {
      this.manager = manager;
      this.set(value);
  }

  TouchAction.prototype = {
      /**
       * set the touchAction value on the element or enable the polyfill
       * @param {String} value
       */
      set: function(value) {
          // find out the touch-action by the event handlers
          if (value == TOUCH_ACTION_COMPUTE) {
              value = this.compute();
          }

          if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
              this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
          }
          this.actions = value.toLowerCase().trim();
      },

      /**
       * just re-set the touchAction value
       */
      update: function() {
          this.set(this.manager.options.touchAction);
      },

      /**
       * compute the value for the touchAction property based on the recognizer's settings
       * @returns {String} value
       */
      compute: function() {
          var actions = [];
          each(this.manager.recognizers, function(recognizer) {
              if (boolOrFn(recognizer.options.enable, [recognizer])) {
                  actions = actions.concat(recognizer.getTouchAction());
              }
          });
          return cleanTouchActions(actions.join(' '));
      },

      /**
       * this method is called on each input cycle and provides the preventing of the browser behavior
       * @param {Object} input
       */
      preventDefaults: function(input) {
          var srcEvent = input.srcEvent;
          var direction = input.offsetDirection;

          // if the touch action did prevented once this session
          if (this.manager.session.prevented) {
              srcEvent.preventDefault();
              return;
          }

          var actions = this.actions;
          var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
          var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
          var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

          if (hasNone) {
              //do not prevent defaults if this is a tap gesture

              var isTapPointer = input.pointers.length === 1;
              var isTapMovement = input.distance < 2;
              var isTapTouchTime = input.deltaTime < 250;

              if (isTapPointer && isTapMovement && isTapTouchTime) {
                  return;
              }
          }

          if (hasPanX && hasPanY) {
              // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
              return;
          }

          if (hasNone ||
              (hasPanY && direction & DIRECTION_HORIZONTAL) ||
              (hasPanX && direction & DIRECTION_VERTICAL)) {
              return this.preventSrc(srcEvent);
          }
      },

      /**
       * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
       * @param {Object} srcEvent
       */
      preventSrc: function(srcEvent) {
          this.manager.session.prevented = true;
          srcEvent.preventDefault();
      }
  };

  /**
   * when the touchActions are collected they are not a valid value, so we need to clean things up. *
   * @param {String} actions
   * @returns {*}
   */
  function cleanTouchActions(actions) {
      // none
      if (inStr(actions, TOUCH_ACTION_NONE)) {
          return TOUCH_ACTION_NONE;
      }

      var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
      var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y);

      // if both pan-x and pan-y are set (different recognizers
      // for different directions, e.g. horizontal pan but vertical swipe?)
      // we need none (as otherwise with pan-x pan-y combined none of these
      // recognizers will work, since the browser would handle all panning
      if (hasPanX && hasPanY) {
          return TOUCH_ACTION_NONE;
      }

      // pan-x OR pan-y
      if (hasPanX || hasPanY) {
          return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
      }

      // manipulation
      if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
          return TOUCH_ACTION_MANIPULATION;
      }

      return TOUCH_ACTION_AUTO;
  }

  function getTouchActionProps() {
      if (!NATIVE_TOUCH_ACTION) {
          return false;
      }
      var touchMap = {};
      var cssSupports = window.CSS && window.CSS.supports;
      ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function(val) {

          // If css.supports is not supported but there is native touch-action assume it supports
          // all values. This is the case for IE 10 and 11.
          touchMap[val] = cssSupports ? window.CSS.supports('touch-action', val) : true;
      });
      return touchMap;
  }

  /**
   * Recognizer flow explained; *
   * All recognizers have the initial state of POSSIBLE when a input session starts.
   * The definition of a input session is from the first input until the last input, with all it's movement in it. *
   * Example session for mouse-input: mousedown -> mousemove -> mouseup
   *
   * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
   * which determines with state it should be.
   *
   * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
   * POSSIBLE to give it another change on the next cycle.
   *
   *               Possible
   *                  |
   *            +-----+---------------+
   *            |                     |
   *      +-----+-----+               |
   *      |           |               |
   *   Failed      Cancelled          |
   *                          +-------+------+
   *                          |              |
   *                      Recognized       Began
   *                                         |
   *                                      Changed
   *                                         |
   *                                  Ended/Recognized
   */
  var STATE_POSSIBLE = 1;
  var STATE_BEGAN = 2;
  var STATE_CHANGED = 4;
  var STATE_ENDED = 8;
  var STATE_RECOGNIZED = STATE_ENDED;
  var STATE_CANCELLED = 16;
  var STATE_FAILED = 32;

  /**
   * Recognizer
   * Every recognizer needs to extend from this class.
   * @constructor
   * @param {Object} options
   */
  function Recognizer(options) {
      this.options = assign({}, this.defaults, options || {});

      this.id = uniqueId();

      this.manager = null;

      // default is enable true
      this.options.enable = ifUndefined(this.options.enable, true);

      this.state = STATE_POSSIBLE;

      this.simultaneous = {};
      this.requireFail = [];
  }

  Recognizer.prototype = {
      /**
       * @virtual
       * @type {Object}
       */
      defaults: {},

      /**
       * set options
       * @param {Object} options
       * @return {Recognizer}
       */
      set: function(options) {
          assign(this.options, options);

          // also update the touchAction, in case something changed about the directions/enabled state
          this.manager && this.manager.touchAction.update();
          return this;
      },

      /**
       * recognize simultaneous with an other recognizer.
       * @param {Recognizer} otherRecognizer
       * @returns {Recognizer} this
       */
      recognizeWith: function(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
              return this;
          }

          var simultaneous = this.simultaneous;
          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
          if (!simultaneous[otherRecognizer.id]) {
              simultaneous[otherRecognizer.id] = otherRecognizer;
              otherRecognizer.recognizeWith(this);
          }
          return this;
      },

      /**
       * drop the simultaneous link. it doesnt remove the link on the other recognizer.
       * @param {Recognizer} otherRecognizer
       * @returns {Recognizer} this
       */
      dropRecognizeWith: function(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
              return this;
          }

          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
          delete this.simultaneous[otherRecognizer.id];
          return this;
      },

      /**
       * recognizer can only run when an other is failing
       * @param {Recognizer} otherRecognizer
       * @returns {Recognizer} this
       */
      requireFailure: function(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
              return this;
          }

          var requireFail = this.requireFail;
          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
          if (inArray(requireFail, otherRecognizer) === -1) {
              requireFail.push(otherRecognizer);
              otherRecognizer.requireFailure(this);
          }
          return this;
      },

      /**
       * drop the requireFailure link. it does not remove the link on the other recognizer.
       * @param {Recognizer} otherRecognizer
       * @returns {Recognizer} this
       */
      dropRequireFailure: function(otherRecognizer) {
          if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
              return this;
          }

          otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
          var index = inArray(this.requireFail, otherRecognizer);
          if (index > -1) {
              this.requireFail.splice(index, 1);
          }
          return this;
      },

      /**
       * has require failures boolean
       * @returns {boolean}
       */
      hasRequireFailures: function() {
          return this.requireFail.length > 0;
      },

      /**
       * if the recognizer can recognize simultaneous with an other recognizer
       * @param {Recognizer} otherRecognizer
       * @returns {Boolean}
       */
      canRecognizeWith: function(otherRecognizer) {
          return !!this.simultaneous[otherRecognizer.id];
      },

      /**
       * You should use `tryEmit` instead of `emit` directly to check
       * that all the needed recognizers has failed before emitting.
       * @param {Object} input
       */
      emit: function(input) {
          var self = this;
          var state = this.state;

          function emit(event) {
              self.manager.emit(event, input);
          }

          // 'panstart' and 'panmove'
          if (state < STATE_ENDED) {
              emit(self.options.event + stateStr(state));
          }

          emit(self.options.event); // simple 'eventName' events

          if (input.additionalEvent) { // additional event(panleft, panright, pinchin, pinchout...)
              emit(input.additionalEvent);
          }

          // panend and pancancel
          if (state >= STATE_ENDED) {
              emit(self.options.event + stateStr(state));
          }
      },

      /**
       * Check that all the require failure recognizers has failed,
       * if true, it emits a gesture event,
       * otherwise, setup the state to FAILED.
       * @param {Object} input
       */
      tryEmit: function(input) {
          if (this.canEmit()) {
              return this.emit(input);
          }
          // it's failing anyway
          this.state = STATE_FAILED;
      },

      /**
       * can we emit?
       * @returns {boolean}
       */
      canEmit: function() {
          var i = 0;
          while (i < this.requireFail.length) {
              if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
                  return false;
              }
              i++;
          }
          return true;
      },

      /**
       * update the recognizer
       * @param {Object} inputData
       */
      recognize: function(inputData) {
          // make a new copy of the inputData
          // so we can change the inputData without messing up the other recognizers
          var inputDataClone = assign({}, inputData);

          // is is enabled and allow recognizing?
          if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
              this.reset();
              this.state = STATE_FAILED;
              return;
          }

          // reset when we've reached the end
          if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
              this.state = STATE_POSSIBLE;
          }

          this.state = this.process(inputDataClone);

          // the recognizer has recognized a gesture
          // so trigger an event
          if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
              this.tryEmit(inputDataClone);
          }
      },

      /**
       * return the state of the recognizer
       * the actual recognizing happens in this method
       * @virtual
       * @param {Object} inputData
       * @returns {Const} STATE
       */
      process: function(inputData) { }, // jshint ignore:line

      /**
       * return the preferred touch-action
       * @virtual
       * @returns {Array}
       */
      getTouchAction: function() { },

      /**
       * called when the gesture isn't allowed to recognize
       * like when another is being recognized or it is disabled
       * @virtual
       */
      reset: function() { }
  };

  /**
   * get a usable string, used as event postfix
   * @param {Const} state
   * @returns {String} state
   */
  function stateStr(state) {
      if (state & STATE_CANCELLED) {
          return 'cancel';
      } else if (state & STATE_ENDED) {
          return 'end';
      } else if (state & STATE_CHANGED) {
          return 'move';
      } else if (state & STATE_BEGAN) {
          return 'start';
      }
      return '';
  }

  /**
   * direction cons to string
   * @param {Const} direction
   * @returns {String}
   */
  function directionStr(direction) {
      if (direction == DIRECTION_DOWN) {
          return 'down';
      } else if (direction == DIRECTION_UP) {
          return 'up';
      } else if (direction == DIRECTION_LEFT) {
          return 'left';
      } else if (direction == DIRECTION_RIGHT) {
          return 'right';
      }
      return '';
  }

  /**
   * get a recognizer by name if it is bound to a manager
   * @param {Recognizer|String} otherRecognizer
   * @param {Recognizer} recognizer
   * @returns {Recognizer}
   */
  function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
      var manager = recognizer.manager;
      if (manager) {
          return manager.get(otherRecognizer);
      }
      return otherRecognizer;
  }

  /**
   * This recognizer is just used as a base for the simple attribute recognizers.
   * @constructor
   * @extends Recognizer
   */
  function AttrRecognizer() {
      Recognizer.apply(this, arguments);
  }

  inherit(AttrRecognizer, Recognizer, {
      /**
       * @namespace
       * @memberof AttrRecognizer
       */
      defaults: {
          /**
           * @type {Number}
           * @default 1
           */
          pointers: 1
      },

      /**
       * Used to check if it the recognizer receives valid input, like input.distance > 10.
       * @memberof AttrRecognizer
       * @param {Object} input
       * @returns {Boolean} recognized
       */
      attrTest: function(input) {
          var optionPointers = this.options.pointers;
          return optionPointers === 0 || input.pointers.length === optionPointers;
      },

      /**
       * Process the input and return the state for the recognizer
       * @memberof AttrRecognizer
       * @param {Object} input
       * @returns {*} State
       */
      process: function(input) {
          var state = this.state;
          var eventType = input.eventType;

          var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
          var isValid = this.attrTest(input);

          // on cancel input and we've recognized before, return STATE_CANCELLED
          if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
              return state | STATE_CANCELLED;
          } else if (isRecognized || isValid) {
              if (eventType & INPUT_END) {
                  return state | STATE_ENDED;
              } else if (!(state & STATE_BEGAN)) {
                  return STATE_BEGAN;
              }
              return state | STATE_CHANGED;
          }
          return STATE_FAILED;
      }
  });

  /**
   * Pan
   * Recognized when the pointer is down and moved in the allowed direction.
   * @constructor
   * @extends AttrRecognizer
   */
  function PanRecognizer() {
      AttrRecognizer.apply(this, arguments);

      this.pX = null;
      this.pY = null;
  }

  inherit(PanRecognizer, AttrRecognizer, {
      /**
       * @namespace
       * @memberof PanRecognizer
       */
      defaults: {
          event: 'pan',
          threshold: 10,
          pointers: 1,
          direction: DIRECTION_ALL
      },

      getTouchAction: function() {
          var direction = this.options.direction;
          var actions = [];
          if (direction & DIRECTION_HORIZONTAL) {
              actions.push(TOUCH_ACTION_PAN_Y);
          }
          if (direction & DIRECTION_VERTICAL) {
              actions.push(TOUCH_ACTION_PAN_X);
          }
          return actions;
      },

      directionTest: function(input) {
          var options = this.options;
          var hasMoved = true;
          var distance = input.distance;
          var direction = input.direction;
          var x = input.deltaX;
          var y = input.deltaY;

          // lock to axis?
          if (!(direction & options.direction)) {
              if (options.direction & DIRECTION_HORIZONTAL) {
                  direction = (x === 0) ? DIRECTION_NONE : (x < 0) ? DIRECTION_LEFT : DIRECTION_RIGHT;
                  hasMoved = x != this.pX;
                  distance = Math.abs(input.deltaX);
              } else {
                  direction = (y === 0) ? DIRECTION_NONE : (y < 0) ? DIRECTION_UP : DIRECTION_DOWN;
                  hasMoved = y != this.pY;
                  distance = Math.abs(input.deltaY);
              }
          }
          input.direction = direction;
          return hasMoved && distance > options.threshold && direction & options.direction;
      },

      attrTest: function(input) {
          return AttrRecognizer.prototype.attrTest.call(this, input) &&
              (this.state & STATE_BEGAN || (!(this.state & STATE_BEGAN) && this.directionTest(input)));
      },

      emit: function(input) {

          this.pX = input.deltaX;
          this.pY = input.deltaY;

          var direction = directionStr(input.direction);

          if (direction) {
              input.additionalEvent = this.options.event + direction;
          }
          this._super.emit.call(this, input);
      }
  });

  /**
   * Pinch
   * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
   * @constructor
   * @extends AttrRecognizer
   */
  function PinchRecognizer() {
      AttrRecognizer.apply(this, arguments);
  }

  inherit(PinchRecognizer, AttrRecognizer, {
      /**
       * @namespace
       * @memberof PinchRecognizer
       */
      defaults: {
          event: 'pinch',
          threshold: 0,
          pointers: 2
      },

      getTouchAction: function() {
          return [TOUCH_ACTION_NONE];
      },

      attrTest: function(input) {
          return this._super.attrTest.call(this, input) &&
              (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
      },

      emit: function(input) {
          if (input.scale !== 1) {
              var inOut = input.scale < 1 ? 'in' : 'out';
              input.additionalEvent = this.options.event + inOut;
          }
          this._super.emit.call(this, input);
      }
  });

  /**
   * Press
   * Recognized when the pointer is down for x ms without any movement.
   * @constructor
   * @extends Recognizer
   */
  function PressRecognizer() {
      Recognizer.apply(this, arguments);

      this._timer = null;
      this._input = null;
  }

  inherit(PressRecognizer, Recognizer, {
      /**
       * @namespace
       * @memberof PressRecognizer
       */
      defaults: {
          event: 'press',
          pointers: 1,
          time: 251, // minimal time of the pointer to be pressed
          threshold: 9 // a minimal movement is ok, but keep it low
      },

      getTouchAction: function() {
          return [TOUCH_ACTION_AUTO];
      },

      process: function(input) {
          var options = this.options;
          var validPointers = input.pointers.length === options.pointers;
          var validMovement = input.distance < options.threshold;
          var validTime = input.deltaTime > options.time;

          this._input = input;

          // we only allow little movement
          // and we've reached an end event, so a tap is possible
          if (!validMovement || !validPointers || (input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime)) {
              this.reset();
          } else if (input.eventType & INPUT_START) {
              this.reset();
              this._timer = setTimeoutContext(function() {
                  this.state = STATE_RECOGNIZED;
                  this.tryEmit();
              }, options.time, this);
          } else if (input.eventType & INPUT_END) {
              return STATE_RECOGNIZED;
          }
          return STATE_FAILED;
      },

      reset: function() {
          clearTimeout(this._timer);
      },

      emit: function(input) {
          if (this.state !== STATE_RECOGNIZED) {
              return;
          }

          if (input && (input.eventType & INPUT_END)) {
              this.manager.emit(this.options.event + 'up', input);
          } else {
              this._input.timeStamp = now();
              this.manager.emit(this.options.event, this._input);
          }
      }
  });

  /**
   * Rotate
   * Recognized when two or more pointer are moving in a circular motion.
   * @constructor
   * @extends AttrRecognizer
   */
  function RotateRecognizer() {
      AttrRecognizer.apply(this, arguments);
  }

  inherit(RotateRecognizer, AttrRecognizer, {
      /**
       * @namespace
       * @memberof RotateRecognizer
       */
      defaults: {
          event: 'rotate',
          threshold: 0,
          pointers: 2
      },

      getTouchAction: function() {
          return [TOUCH_ACTION_NONE];
      },

      attrTest: function(input) {
          return this._super.attrTest.call(this, input) &&
              (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
      }
  });

  /**
   * Swipe
   * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
   * @constructor
   * @extends AttrRecognizer
   */
  function SwipeRecognizer() {
      AttrRecognizer.apply(this, arguments);
  }

  inherit(SwipeRecognizer, AttrRecognizer, {
      /**
       * @namespace
       * @memberof SwipeRecognizer
       */
      defaults: {
          event: 'swipe',
          threshold: 10,
          velocity: 0.3,
          direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
          pointers: 1
      },

      getTouchAction: function() {
          return PanRecognizer.prototype.getTouchAction.call(this);
      },

      attrTest: function(input) {
          var direction = this.options.direction;
          var velocity;

          if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
              velocity = input.overallVelocity;
          } else if (direction & DIRECTION_HORIZONTAL) {
              velocity = input.overallVelocityX;
          } else if (direction & DIRECTION_VERTICAL) {
              velocity = input.overallVelocityY;
          }

          return this._super.attrTest.call(this, input) &&
              direction & input.offsetDirection &&
              input.distance > this.options.threshold &&
              input.maxPointers == this.options.pointers &&
              abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
      },

      emit: function(input) {
          var direction = directionStr(input.offsetDirection);
          if (direction) {
              this.manager.emit(this.options.event + direction, input);
          }

          this.manager.emit(this.options.event, input);
      }
  });

  /**
   * A tap is ecognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
   * between the given interval and position. The delay option can be used to recognize multi-taps without firing
   * a single tap.
   *
   * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
   * multi-taps being recognized.
   * @constructor
   * @extends Recognizer
   */
  function TapRecognizer() {
      Recognizer.apply(this, arguments);

      // previous time and center,
      // used for tap counting
      this.pTime = false;
      this.pCenter = false;

      this._timer = null;
      this._input = null;
      this.count = 0;
  }

  inherit(TapRecognizer, Recognizer, {
      /**
       * @namespace
       * @memberof PinchRecognizer
       */
      defaults: {
          event: 'tap',
          pointers: 1,
          taps: 1,
          interval: 300, // max time between the multi-tap taps
          time: 250, // max time of the pointer to be down (like finger on the screen)
          threshold: 9, // a minimal movement is ok, but keep it low
          posThreshold: 10 // a multi-tap can be a bit off the initial position
      },

      getTouchAction: function() {
          return [TOUCH_ACTION_MANIPULATION];
      },

      process: function(input) {
          var options = this.options;

          var validPointers = input.pointers.length === options.pointers;
          var validMovement = input.distance < options.threshold;
          var validTouchTime = input.deltaTime < options.time;

          this.reset();

          if ((input.eventType & INPUT_START) && (this.count === 0)) {
              return this.failTimeout();
          }

          // we only allow little movement
          // and we've reached an end event, so a tap is possible
          if (validMovement && validTouchTime && validPointers) {
              if (input.eventType != INPUT_END) {
                  return this.failTimeout();
              }

              var validInterval = this.pTime ? (input.timeStamp - this.pTime < options.interval) : true;
              var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;

              this.pTime = input.timeStamp;
              this.pCenter = input.center;

              if (!validMultiTap || !validInterval) {
                  this.count = 1;
              } else {
                  this.count += 1;
              }

              this._input = input;

              // if tap count matches we have recognized it,
              // else it has began recognizing...
              var tapCount = this.count % options.taps;
              if (tapCount === 0) {
                  // no failing requirements, immediately trigger the tap event
                  // or wait as long as the multitap interval to trigger
                  if (!this.hasRequireFailures()) {
                      return STATE_RECOGNIZED;
                  } else {
                      this._timer = setTimeoutContext(function() {
                          this.state = STATE_RECOGNIZED;
                          this.tryEmit();
                      }, options.interval, this);
                      return STATE_BEGAN;
                  }
              }
          }
          return STATE_FAILED;
      },

      failTimeout: function() {
          this._timer = setTimeoutContext(function() {
              this.state = STATE_FAILED;
          }, this.options.interval, this);
          return STATE_FAILED;
      },

      reset: function() {
          clearTimeout(this._timer);
      },

      emit: function() {
          if (this.state == STATE_RECOGNIZED) {
              this._input.tapCount = this.count;
              this.manager.emit(this.options.event, this._input);
          }
      }
  });

  /**
   * Simple way to create a manager with a default set of recognizers.
   * @param {HTMLElement} element
   * @param {Object} [options]
   * @constructor
   */
  function Hammer(element, options) {
      options = options || {};
      options.recognizers = ifUndefined(options.recognizers, Hammer.defaults.preset);
      return new Manager(element, options);
  }

  /**
   * @const {string}
   */
  Hammer.VERSION = '2.0.7';

  /**
   * default settings
   * @namespace
   */
  Hammer.defaults = {
      /**
       * set if DOM events are being triggered.
       * But this is slower and unused by simple implementations, so disabled by default.
       * @type {Boolean}
       * @default false
       */
      domEvents: false,

      /**
       * The value for the touchAction property/fallback.
       * When set to `compute` it will magically set the correct value based on the added recognizers.
       * @type {String}
       * @default compute
       */
      touchAction: TOUCH_ACTION_COMPUTE,

      /**
       * @type {Boolean}
       * @default true
       */
      enable: true,

      /**
       * EXPERIMENTAL FEATURE -- can be removed/changed
       * Change the parent input target element.
       * If Null, then it is being set the to main element.
       * @type {Null|EventTarget}
       * @default null
       */
      inputTarget: null,

      /**
       * force an input class
       * @type {Null|Function}
       * @default null
       */
      inputClass: null,

      /**
       * Default recognizer setup when calling `Hammer()`
       * When creating a new Manager these will be skipped.
       * @type {Array}
       */
      preset: [
          // RecognizerClass, options, [recognizeWith, ...], [requireFailure, ...]
          [RotateRecognizer, {enable: false}],
          [PinchRecognizer, {enable: false}, ['rotate']],
          [SwipeRecognizer, {direction: DIRECTION_HORIZONTAL}],
          [PanRecognizer, {direction: DIRECTION_HORIZONTAL}, ['swipe']],
          [TapRecognizer],
          [TapRecognizer, {event: 'doubletap', taps: 2}, ['tap']],
          [PressRecognizer]
      ],

      /**
       * Some CSS properties can be used to improve the working of Hammer.
       * Add them to this method and they will be set when creating a new Manager.
       * @namespace
       */
      cssProps: {
          /**
           * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
           * @type {String}
           * @default 'none'
           */
          userSelect: 'none',

          /**
           * Disable the Windows Phone grippers when pressing an element.
           * @type {String}
           * @default 'none'
           */
          touchSelect: 'none',

          /**
           * Disables the default callout shown when you touch and hold a touch target.
           * On iOS, when you touch and hold a touch target such as a link, Safari displays
           * a callout containing information about the link. This property allows you to disable that callout.
           * @type {String}
           * @default 'none'
           */
          touchCallout: 'none',

          /**
           * Specifies whether zooming is enabled. Used by IE10>
           * @type {String}
           * @default 'none'
           */
          contentZooming: 'none',

          /**
           * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
           * @type {String}
           * @default 'none'
           */
          userDrag: 'none',

          /**
           * Overrides the highlight color shown when the user taps a link or a JavaScript
           * clickable element in iOS. This property obeys the alpha value, if specified.
           * @type {String}
           * @default 'rgba(0,0,0,0)'
           */
          tapHighlightColor: 'rgba(0,0,0,0)'
      }
  };

  var STOP = 1;
  var FORCED_STOP = 2;

  /**
   * Manager
   * @param {HTMLElement} element
   * @param {Object} [options]
   * @constructor
   */
  function Manager(element, options) {
      this.options = assign({}, Hammer.defaults, options || {});

      this.options.inputTarget = this.options.inputTarget || element;

      this.handlers = {};
      this.session = {};
      this.recognizers = [];
      this.oldCssProps = {};

      this.element = element;
      this.input = createInputInstance(this);
      this.touchAction = new TouchAction(this, this.options.touchAction);

      toggleCssProps(this, true);

      each(this.options.recognizers, function(item) {
          var recognizer = this.add(new (item[0])(item[1]));
          item[2] && recognizer.recognizeWith(item[2]);
          item[3] && recognizer.requireFailure(item[3]);
      }, this);
  }

  Manager.prototype = {
      /**
       * set options
       * @param {Object} options
       * @returns {Manager}
       */
      set: function(options) {
          assign(this.options, options);

          // Options that need a little more setup
          if (options.touchAction) {
              this.touchAction.update();
          }
          if (options.inputTarget) {
              // Clean up existing event listeners and reinitialize
              this.input.destroy();
              this.input.target = options.inputTarget;
              this.input.init();
          }
          return this;
      },

      /**
       * stop recognizing for this session.
       * This session will be discarded, when a new [input]start event is fired.
       * When forced, the recognizer cycle is stopped immediately.
       * @param {Boolean} [force]
       */
      stop: function(force) {
          this.session.stopped = force ? FORCED_STOP : STOP;
      },

      /**
       * run the recognizers!
       * called by the inputHandler function on every movement of the pointers (touches)
       * it walks through all the recognizers and tries to detect the gesture that is being made
       * @param {Object} inputData
       */
      recognize: function(inputData) {
          var session = this.session;
          if (session.stopped) {
              return;
          }

          // run the touch-action polyfill
          this.touchAction.preventDefaults(inputData);

          var recognizer;
          var recognizers = this.recognizers;

          // this holds the recognizer that is being recognized.
          // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
          // if no recognizer is detecting a thing, it is set to `null`
          var curRecognizer = session.curRecognizer;

          // reset when the last recognizer is recognized
          // or when we're in a new session
          if (!curRecognizer || (curRecognizer && curRecognizer.state & STATE_RECOGNIZED)) {
              curRecognizer = session.curRecognizer = null;
          }

          var i = 0;
          while (i < recognizers.length) {
              recognizer = recognizers[i];

              // find out if we are allowed try to recognize the input for this one.
              // 1.   allow if the session is NOT forced stopped (see the .stop() method)
              // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
              //      that is being recognized.
              // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
              //      this can be setup with the `recognizeWith()` method on the recognizer.
              if (session.stopped !== FORCED_STOP && ( // 1
                      !curRecognizer || recognizer == curRecognizer || // 2
                      recognizer.canRecognizeWith(curRecognizer))) { // 3
                  recognizer.recognize(inputData);
              } else {
                  recognizer.reset();
              }

              // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
              // current active recognizer. but only if we don't already have an active recognizer
              if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
                  curRecognizer = session.curRecognizer = recognizer;
              }
              i++;
          }
      },

      /**
       * get a recognizer by its event name.
       * @param {Recognizer|String} recognizer
       * @returns {Recognizer|Null}
       */
      get: function(recognizer) {
          if (recognizer instanceof Recognizer) {
              return recognizer;
          }

          var recognizers = this.recognizers;
          for (var i = 0; i < recognizers.length; i++) {
              if (recognizers[i].options.event == recognizer) {
                  return recognizers[i];
              }
          }
          return null;
      },

      /**
       * add a recognizer to the manager
       * existing recognizers with the same event name will be removed
       * @param {Recognizer} recognizer
       * @returns {Recognizer|Manager}
       */
      add: function(recognizer) {
          if (invokeArrayArg(recognizer, 'add', this)) {
              return this;
          }

          // remove existing
          var existing = this.get(recognizer.options.event);
          if (existing) {
              this.remove(existing);
          }

          this.recognizers.push(recognizer);
          recognizer.manager = this;

          this.touchAction.update();
          return recognizer;
      },

      /**
       * remove a recognizer by name or instance
       * @param {Recognizer|String} recognizer
       * @returns {Manager}
       */
      remove: function(recognizer) {
          if (invokeArrayArg(recognizer, 'remove', this)) {
              return this;
          }

          recognizer = this.get(recognizer);

          // let's make sure this recognizer exists
          if (recognizer) {
              var recognizers = this.recognizers;
              var index = inArray(recognizers, recognizer);

              if (index !== -1) {
                  recognizers.splice(index, 1);
                  this.touchAction.update();
              }
          }

          return this;
      },

      /**
       * bind event
       * @param {String} events
       * @param {Function} handler
       * @returns {EventEmitter} this
       */
      on: function(events, handler) {
          if (events === undefined) {
              return;
          }
          if (handler === undefined) {
              return;
          }

          var handlers = this.handlers;
          each(splitStr(events), function(event) {
              handlers[event] = handlers[event] || [];
              handlers[event].push(handler);
          });
          return this;
      },

      /**
       * unbind event, leave emit blank to remove all handlers
       * @param {String} events
       * @param {Function} [handler]
       * @returns {EventEmitter} this
       */
      off: function(events, handler) {
          if (events === undefined) {
              return;
          }

          var handlers = this.handlers;
          each(splitStr(events), function(event) {
              if (!handler) {
                  delete handlers[event];
              } else {
                  handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
              }
          });
          return this;
      },

      /**
       * emit event to the listeners
       * @param {String} event
       * @param {Object} data
       */
      emit: function(event, data) {
          // we also want to trigger dom events
          if (this.options.domEvents) {
              triggerDomEvent(event, data);
          }

          // no handlers, so skip it all
          var handlers = this.handlers[event] && this.handlers[event].slice();
          if (!handlers || !handlers.length) {
              return;
          }

          data.type = event;
          data.preventDefault = function() {
              data.srcEvent.preventDefault();
          };

          var i = 0;
          while (i < handlers.length) {
              handlers[i](data);
              i++;
          }
      },

      /**
       * destroy the manager and unbinds all events
       * it doesn't unbind dom events, that is the user own responsibility
       */
      destroy: function() {
          this.element && toggleCssProps(this, false);

          this.handlers = {};
          this.session = {};
          this.input.destroy();
          this.element = null;
      }
  };

  /**
   * add/remove the css properties as defined in manager.options.cssProps
   * @param {Manager} manager
   * @param {Boolean} add
   */
  function toggleCssProps(manager, add) {
      var element = manager.element;
      if (!element.style) {
          return;
      }
      var prop;
      each(manager.options.cssProps, function(value, name) {
          prop = prefixed(element.style, name);
          if (add) {
              manager.oldCssProps[prop] = element.style[prop];
              element.style[prop] = value;
          } else {
              element.style[prop] = manager.oldCssProps[prop] || '';
          }
      });
      if (!add) {
          manager.oldCssProps = {};
      }
  }

  /**
   * trigger dom event
   * @param {String} event
   * @param {Object} data
   */
  function triggerDomEvent(event, data) {
      var gestureEvent = document.createEvent('Event');
      gestureEvent.initEvent(event, true, true);
      gestureEvent.gesture = data;
      data.target.dispatchEvent(gestureEvent);
  }

  assign(Hammer, {
      INPUT_START: INPUT_START,
      INPUT_MOVE: INPUT_MOVE,
      INPUT_END: INPUT_END,
      INPUT_CANCEL: INPUT_CANCEL,

      STATE_POSSIBLE: STATE_POSSIBLE,
      STATE_BEGAN: STATE_BEGAN,
      STATE_CHANGED: STATE_CHANGED,
      STATE_ENDED: STATE_ENDED,
      STATE_RECOGNIZED: STATE_RECOGNIZED,
      STATE_CANCELLED: STATE_CANCELLED,
      STATE_FAILED: STATE_FAILED,

      DIRECTION_NONE: DIRECTION_NONE,
      DIRECTION_LEFT: DIRECTION_LEFT,
      DIRECTION_RIGHT: DIRECTION_RIGHT,
      DIRECTION_UP: DIRECTION_UP,
      DIRECTION_DOWN: DIRECTION_DOWN,
      DIRECTION_HORIZONTAL: DIRECTION_HORIZONTAL,
      DIRECTION_VERTICAL: DIRECTION_VERTICAL,
      DIRECTION_ALL: DIRECTION_ALL,

      Manager: Manager,
      Input: Input,
      TouchAction: TouchAction,

      TouchInput: TouchInput,
      MouseInput: MouseInput,
      PointerEventInput: PointerEventInput,
      TouchMouseInput: TouchMouseInput,
      SingleTouchInput: SingleTouchInput,

      Recognizer: Recognizer,
      AttrRecognizer: AttrRecognizer,
      Tap: TapRecognizer,
      Pan: PanRecognizer,
      Swipe: SwipeRecognizer,
      Pinch: PinchRecognizer,
      Rotate: RotateRecognizer,
      Press: PressRecognizer,

      on: addEventListeners,
      off: removeEventListeners,
      each: each,
      merge: merge,
      extend: extend,
      assign: assign,
      inherit: inherit,
      bindFn: bindFn,
      prefixed: prefixed
  });

  // this prevents errors when Hammer is loaded in the presence of an AMD
  //  style loader but by script tag, not by the loader.
  var freeGlobal = (typeof window !== 'undefined' ? window : (typeof self !== 'undefined' ? self : {})); // jshint ignore:line
  freeGlobal.Hammer = Hammer;

  if (true) {
      !(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
          return Hammer;
      }.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else if (typeof module != 'undefined' && module.exports) {
      module.exports = Hammer;
  } else {
      window[exportName] = Hammer;
  }

  })(window, document, 'Hammer');


/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

  var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;"use strict";
  /**
   * Created by Alex on 11/6/2014.
   */

  // https://github.com/umdjs/umd/blob/master/returnExports.js#L40-L60
  // if the module has no dependencies, the above pattern can be simplified to
  (function (root, factory) {
    if (true) {
      // AMD. Register as an anonymous module.
      !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else if (typeof exports === 'object') {
      // Node. Does not work with strict CommonJS, but
      // only CommonJS-like environments that support module.exports,
      // like Node.
      module.exports = factory();
    } else {
      // Browser globals (root is window)
      root.keycharm = factory();
    }
  }(this, function () {

    function keycharm(options) {
      var preventDefault = options && options.preventDefault || false;

      var container = options && options.container || window;

      var _exportFunctions = {};
      var _bound = {keydown:{}, keyup:{}};
      var _keys = {};
      var i;

      // a - z
      for (i = 97; i <= 122; i++) {_keys[String.fromCharCode(i)] = {code:65 + (i - 97), shift: false};}
      // A - Z
      for (i = 65; i <= 90; i++) {_keys[String.fromCharCode(i)] = {code:i, shift: true};}
      // 0 - 9
      for (i = 0;  i <= 9;   i++) {_keys['' + i] = {code:48 + i, shift: false};}
      // F1 - F12
      for (i = 1;  i <= 12;   i++) {_keys['F' + i] = {code:111 + i, shift: false};}
      // num0 - num9
      for (i = 0;  i <= 9;   i++) {_keys['num' + i] = {code:96 + i, shift: false};}

      // numpad misc
      _keys['num*'] = {code:106, shift: false};
      _keys['num+'] = {code:107, shift: false};
      _keys['num-'] = {code:109, shift: false};
      _keys['num/'] = {code:111, shift: false};
      _keys['num.'] = {code:110, shift: false};
      // arrows
      _keys['left']  = {code:37, shift: false};
      _keys['up']    = {code:38, shift: false};
      _keys['right'] = {code:39, shift: false};
      _keys['down']  = {code:40, shift: false};
      // extra keys
      _keys['space'] = {code:32, shift: false};
      _keys['enter'] = {code:13, shift: false};
      _keys['shift'] = {code:16, shift: undefined};
      _keys['esc']   = {code:27, shift: false};
      _keys['backspace'] = {code:8, shift: false};
      _keys['tab']       = {code:9, shift: false};
      _keys['ctrl']      = {code:17, shift: false};
      _keys['alt']       = {code:18, shift: false};
      _keys['delete']    = {code:46, shift: false};
      _keys['pageup']    = {code:33, shift: false};
      _keys['pagedown']  = {code:34, shift: false};
      // symbols
      _keys['=']     = {code:187, shift: false};
      _keys['-']     = {code:189, shift: false};
      _keys[']']     = {code:221, shift: false};
      _keys['[']     = {code:219, shift: false};



      var down = function(event) {handleEvent(event,'keydown');};
      var up = function(event) {handleEvent(event,'keyup');};

      // handle the actualy bound key with the event
      var handleEvent = function(event,type) {
        if (_bound[type][event.keyCode] !== undefined) {
          var bound = _bound[type][event.keyCode];
          for (var i = 0; i < bound.length; i++) {
            if (bound[i].shift === undefined) {
              bound[i].fn(event);
            }
            else if (bound[i].shift == true && event.shiftKey == true) {
              bound[i].fn(event);
            }
            else if (bound[i].shift == false && event.shiftKey == false) {
              bound[i].fn(event);
            }
          }

          if (preventDefault == true) {
            event.preventDefault();
          }
        }
      };

      // bind a key to a callback
      _exportFunctions.bind = function(key, callback, type) {
        if (type === undefined) {
          type = 'keydown';
        }
        if (_keys[key] === undefined) {
          throw new Error("unsupported key: " + key);
        }
        if (_bound[type][_keys[key].code] === undefined) {
          _bound[type][_keys[key].code] = [];
        }
        _bound[type][_keys[key].code].push({fn:callback, shift:_keys[key].shift});
      };


      // bind all keys to a call back (demo purposes)
      _exportFunctions.bindAll = function(callback, type) {
        if (type === undefined) {
          type = 'keydown';
        }
        for (var key in _keys) {
          if (_keys.hasOwnProperty(key)) {
            _exportFunctions.bind(key,callback,type);
          }
        }
      };

      // get the key label from an event
      _exportFunctions.getKey = function(event) {
        for (var key in _keys) {
          if (_keys.hasOwnProperty(key)) {
            if (event.shiftKey == true && _keys[key].shift == true && event.keyCode == _keys[key].code) {
              return key;
            }
            else if (event.shiftKey == false && _keys[key].shift == false && event.keyCode == _keys[key].code) {
              return key;
            }
            else if (event.keyCode == _keys[key].code && key == 'shift') {
              return key;
            }
          }
        }
        return "unknown key, currently not supported";
      };

      // unbind either a specific callback from a key or all of them (by leaving callback undefined)
      _exportFunctions.unbind = function(key, callback, type) {
        if (type === undefined) {
          type = 'keydown';
        }
        if (_keys[key] === undefined) {
          throw new Error("unsupported key: " + key);
        }
        if (callback !== undefined) {
          var newBindings = [];
          var bound = _bound[type][_keys[key].code];
          if (bound !== undefined) {
            for (var i = 0; i < bound.length; i++) {
              if (!(bound[i].fn == callback && bound[i].shift == _keys[key].shift)) {
                newBindings.push(_bound[type][_keys[key].code][i]);
              }
            }
          }
          _bound[type][_keys[key].code] = newBindings;
        }
        else {
          _bound[type][_keys[key].code] = [];
        }
      };

      // reset all bound variables.
      _exportFunctions.reset = function() {
        _bound = {keydown:{}, keyup:{}};
      };

      // unbind all listeners and reset all variables.
      _exportFunctions.destroy = function() {
        _bound = {keydown:{}, keyup:{}};
        container.removeEventListener('keydown', down, true);
        container.removeEventListener('keyup', up, true);
      };

      // create listeners.
      container.addEventListener('keydown',down,true);
      container.addEventListener('keyup',up,true);

      // return the public functions.
      return _exportFunctions;
    }

    return keycharm;
  }));




/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  // utils
  exports.util = __webpack_require__(1);
  exports.DOMutil = __webpack_require__(90);

  // data
  exports.DataSet = __webpack_require__(91);
  exports.DataView = __webpack_require__(93);
  exports.Queue = __webpack_require__(92);

  // Timeline
  exports.Timeline = __webpack_require__(113);
  exports.Graph2d = __webpack_require__(144);
  exports.timeline = {
    Core: __webpack_require__(126),
    DateUtil: __webpack_require__(125),
    Range: __webpack_require__(123),
    stack: __webpack_require__(131),
    TimeStep: __webpack_require__(129),

    components: {
      items: {
        Item: __webpack_require__(133),
        BackgroundItem: __webpack_require__(137),
        BoxItem: __webpack_require__(135),
        PointItem: __webpack_require__(136),
        RangeItem: __webpack_require__(132)
      },

      BackgroundGroup: __webpack_require__(134),
      Component: __webpack_require__(124),
      CurrentTime: __webpack_require__(142),
      CustomTime: __webpack_require__(140),
      DataAxis: __webpack_require__(146),
      DataScale: __webpack_require__(147),
      GraphGroup: __webpack_require__(148),
      Group: __webpack_require__(130),
      ItemSet: __webpack_require__(127),
      Legend: __webpack_require__(152),
      LineGraph: __webpack_require__(145),
      TimeAxis: __webpack_require__(138)
    }
  };

  // bundled external libraries
  exports.moment = __webpack_require__(84);
  exports.Hammer = __webpack_require__(108);
  exports.keycharm = __webpack_require__(111);

/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _Configurator = __webpack_require__(114);

  var _Configurator2 = _interopRequireDefault(_Configurator);

  var _Validator = __webpack_require__(122);

  var _Validator2 = _interopRequireDefault(_Validator);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var Emitter = __webpack_require__(95);
  var Hammer = __webpack_require__(108);
  var moment = __webpack_require__(84);
  var util = __webpack_require__(1);
  var DataSet = __webpack_require__(91);
  var DataView = __webpack_require__(93);
  var Range = __webpack_require__(123);
  var Core = __webpack_require__(126);
  var TimeAxis = __webpack_require__(138);
  var CurrentTime = __webpack_require__(142);
  var CustomTime = __webpack_require__(140);
  var ItemSet = __webpack_require__(127);

  var printStyle = __webpack_require__(122).printStyle;
  var allOptions = __webpack_require__(143).allOptions;
  var configureOptions = __webpack_require__(143).configureOptions;

  /**
   * Create a timeline visualization
   * @param {HTMLElement} container
   * @param {vis.DataSet | vis.DataView | Array} [items]
   * @param {vis.DataSet | vis.DataView | Array} [groups]
   * @param {Object} [options]  See Timeline.setOptions for the available options.
   * @constructor
   * @extends Core
   */
  function Timeline(container, items, groups, options) {

    if (!(this instanceof Timeline)) {
      throw new SyntaxError('Constructor must be called with the new operator');
    }

    // if the third element is options, the forth is groups (optionally);
    if (!(Array.isArray(groups) || groups instanceof DataSet || groups instanceof DataView) && groups instanceof Object) {
      var forthArgument = options;
      options = groups;
      groups = forthArgument;
    }

    // TODO: REMOVE THIS in the next MAJOR release
    // see https://github.com/almende/vis/issues/2511
    if (options && options.throttleRedraw) {
      console.warn("Timeline option \"throttleRedraw\" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.");
    }

    var me = this;
    this.defaultOptions = {
      start: null,
      end: null,
      autoResize: true,
      orientation: {
        axis: 'bottom', // axis orientation: 'bottom', 'top', or 'both'
        item: 'bottom' // not relevant
      },
      moment: moment,
      width: null,
      height: null,
      maxHeight: null,
      minHeight: null
    };
    this.options = util.deepExtend({}, this.defaultOptions);

    // Create the DOM, props, and emitter
    this._create(container);
    if (!options || options && typeof options.rtl == "undefined") {
      var directionFromDom,
          domNode = this.dom.root;
      while (!directionFromDom && domNode) {
        directionFromDom = window.getComputedStyle(domNode, null).direction;
        domNode = domNode.parentElement;
      }
      this.options.rtl = directionFromDom && directionFromDom.toLowerCase() == "rtl";
    } else {
      this.options.rtl = options.rtl;
    }

    this.options.rollingMode = options && options.rollingMode;

    // all components listed here will be repainted automatically
    this.components = [];

    this.body = {
      dom: this.dom,
      domProps: this.props,
      emitter: {
        on: this.on.bind(this),
        off: this.off.bind(this),
        emit: this.emit.bind(this)
      },
      hiddenDates: [],
      util: {
        getScale: function getScale() {
          return me.timeAxis.step.scale;
        },
        getStep: function getStep() {
          return me.timeAxis.step.step;
        },

        toScreen: me._toScreen.bind(me),
        toGlobalScreen: me._toGlobalScreen.bind(me), // this refers to the root.width
        toTime: me._toTime.bind(me),
        toGlobalTime: me._toGlobalTime.bind(me)
      }
    };

    // range
    this.range = new Range(this.body, this.options);
    this.components.push(this.range);
    this.body.range = this.range;

    // time axis
    this.timeAxis = new TimeAxis(this.body, this.options);
    this.timeAxis2 = null; // used in case of orientation option 'both'
    this.components.push(this.timeAxis);

    // current time bar
    this.currentTime = new CurrentTime(this.body, this.options);
    this.components.push(this.currentTime);

    // item set
    this.itemSet = new ItemSet(this.body, this.options);
    this.components.push(this.itemSet);

    this.itemsData = null; // DataSet
    this.groupsData = null; // DataSet

    this.dom.root.onclick = function (event) {
      me.emit('click', me.getEventProperties(event));
    };
    this.dom.root.ondblclick = function (event) {
      me.emit('doubleClick', me.getEventProperties(event));
    };
    this.dom.root.oncontextmenu = function (event) {
      me.emit('contextmenu', me.getEventProperties(event));
    };
    this.dom.root.onmouseover = function (event) {
      me.emit('mouseOver', me.getEventProperties(event));
    };
    this.dom.root.onmousemove = function (event) {
      me.emit('mouseMove', me.getEventProperties(event));
    };

    //Single time autoscale/fit
    this.fitDone = false;
    this.on('changed', function () {
      if (this.itemsData == null || this.options.rollingMode) return;
      if (!me.fitDone) {
        me.fitDone = true;
        if (me.options.start != undefined || me.options.end != undefined) {
          if (me.options.start == undefined || me.options.end == undefined) {
            var range = me.getItemRange();
          }

          var start = me.options.start != undefined ? me.options.start : range.min;
          var end = me.options.end != undefined ? me.options.end : range.max;
          me.setWindow(start, end, { animation: false });
        } else {
          me.fit({ animation: false });
        }
      }
    });

    // apply options
    if (options) {
      this.setOptions(options);
    }

    // IMPORTANT: THIS HAPPENS BEFORE SET ITEMS!
    if (groups) {
      this.setGroups(groups);
    }

    // create itemset
    if (items) {
      this.setItems(items);
    }

    // draw for the first time
    this._redraw();
  }

  // Extend the functionality from Core
  Timeline.prototype = new Core();

  /**
   * Load a configurator
   * @return {Object}
   * @private
   */
  Timeline.prototype._createConfigurator = function () {
    return new _Configurator2['default'](this, this.dom.container, configureOptions);
  };

  /**
   * Force a redraw. The size of all items will be recalculated.
   * Can be useful to manually redraw when option autoResize=false and the window
   * has been resized, or when the items CSS has been changed.
   *
   * Note: this function will be overridden on construction with a trottled version
   */
  Timeline.prototype.redraw = function () {
    this.itemSet && this.itemSet.markDirty({ refreshItems: true });
    this._redraw();
  };

  Timeline.prototype.setOptions = function (options) {
    // validate options
    var errorFound = _Validator2['default'].validate(options, allOptions);

    if (errorFound === true) {
      console.log('%cErrors have been found in the supplied options object.', printStyle);
    }
    Core.prototype.setOptions.call(this, options);

    if ('type' in options) {
      if (options.type !== this.options.type) {
        this.options.type = options.type;

        // force recreation of all items
        var itemsData = this.itemsData;
        if (itemsData) {
          var selection = this.getSelection();
          this.setItems(null); // remove all
          this.setItems(itemsData); // add all
          this.setSelection(selection); // restore selection
        }
      }
    }
  };

  /**
   * Set items
   * @param {vis.DataSet | Array | null} items
   */
  Timeline.prototype.setItems = function (items) {
    // convert to type DataSet when needed
    var newDataSet;
    if (!items) {
      newDataSet = null;
    } else if (items instanceof DataSet || items instanceof DataView) {
      newDataSet = items;
    } else {
      // turn an array into a dataset
      newDataSet = new DataSet(items, {
        type: {
          start: 'Date',
          end: 'Date'
        }
      });
    }

    // set items
    this.itemsData = newDataSet;
    this.itemSet && this.itemSet.setItems(newDataSet);
  };

  /**
   * Set groups
   * @param {vis.DataSet | Array} groups
   */
  Timeline.prototype.setGroups = function (groups) {
    // convert to type DataSet when needed
    var newDataSet;
    if (!groups) {
      newDataSet = null;
    } else {
      var filter = function filter(group) {
        return group.visible !== false;
      };
      if (groups instanceof DataSet || groups instanceof DataView) {
        newDataSet = new DataView(groups, { filter: filter });
      } else {
        // turn an array into a dataset
        newDataSet = new DataSet(groups.filter(filter));
      }
    }

    this.groupsData = newDataSet;
    this.itemSet.setGroups(newDataSet);
  };

  /**
   * Set both items and groups in one go
   * @param {{items: Array | vis.DataSet, groups: Array | vis.DataSet}} data
   */
  Timeline.prototype.setData = function (data) {
    if (data && data.groups) {
      this.setGroups(data.groups);
    }

    if (data && data.items) {
      this.setItems(data.items);
    }
  };

  /**
   * Set selected items by their id. Replaces the current selection
   * Unknown id's are silently ignored.
   * @param {string[] | string} [ids]  An array with zero or more id's of the items to be
   *                                selected. If ids is an empty array, all items will be
   *                                unselected.
   * @param {Object} [options]      Available options:
   *                                `focus: boolean`
   *                                    If true, focus will be set to the selected item(s)
   *                                `animation: boolean | {duration: number, easingFunction: string}`
   *                                    If true (default), the range is animated
   *                                    smoothly to the new window. An object can be
   *                                    provided to specify duration and easing function.
   *                                    Default duration is 500 ms, and default easing
   *                                    function is 'easeInOutQuad'.
   *                                    Only applicable when option focus is true.
   */
  Timeline.prototype.setSelection = function (ids, options) {
    this.itemSet && this.itemSet.setSelection(ids);

    if (options && options.focus) {
      this.focus(ids, options);
    }
  };

  /**
   * Get the selected items by their id
   * @return {Array} ids  The ids of the selected items
   */
  Timeline.prototype.getSelection = function () {
    return this.itemSet && this.itemSet.getSelection() || [];
  };

  /**
   * Adjust the visible window such that the selected item (or multiple items)
   * are centered on screen.
   * @param {String | String[]} id     An item id or array with item ids
   * @param {Object} [options]      Available options:
   *                                `animation: boolean | {duration: number, easingFunction: string}`
   *                                    If true (default), the range is animated
   *                                    smoothly to the new window. An object can be
   *                                    provided to specify duration and easing function.
   *                                    Default duration is 500 ms, and default easing
   *                                    function is 'easeInOutQuad'.
   */
  Timeline.prototype.focus = function (id, options) {
    if (!this.itemsData || id == undefined) return;

    var ids = Array.isArray(id) ? id : [id];

    // get the specified item(s)
    var itemsData = this.itemsData.getDataSet().get(ids, {
      type: {
        start: 'Date',
        end: 'Date'
      }
    });

    // calculate minimum start and maximum end of specified items
    var start = null;
    var end = null;
    itemsData.forEach(function (itemData) {
      var s = itemData.start.valueOf();
      var e = 'end' in itemData ? itemData.end.valueOf() : itemData.start.valueOf();

      if (start === null || s < start) {
        start = s;
      }

      if (end === null || e > end) {
        end = e;
      }
    });

    if (start !== null && end !== null) {
      // calculate the new middle and interval for the window
      var middle = (start + end) / 2;
      var interval = Math.max(this.range.end - this.range.start, (end - start) * 1.1);

      var animation = options && options.animation !== undefined ? options.animation : true;
      this.range.setRange(middle - interval / 2, middle + interval / 2, animation);
    }
  };

  /**
   * Set Timeline window such that it fits all items
   * @param {Object} [options]  Available options:
   *                                `animation: boolean | {duration: number, easingFunction: string}`
   *                                    If true (default), the range is animated
   *                                    smoothly to the new window. An object can be
   *                                    provided to specify duration and easing function.
   *                                    Default duration is 500 ms, and default easing
   *                                    function is 'easeInOutQuad'.
   */
  Timeline.prototype.fit = function (options) {
    var animation = options && options.animation !== undefined ? options.animation : true;
    var range;

    var dataset = this.itemsData && this.itemsData.getDataSet();
    if (dataset.length === 1 && dataset.get()[0].end === undefined) {
      // a single item -> don't fit, just show a range around the item from -4 to +3 days
      range = this.getDataRange();
      this.moveTo(range.min.valueOf(), { animation: animation });
    } else {
      // exactly fit the items (plus a small margin)
      range = this.getItemRange();
      this.range.setRange(range.min, range.max, animation);
    }
  };

  /**
   * Determine the range of the items, taking into account their actual width
   * and a margin of 10 pixels on both sides.
   * @return {{min: Date | null, max: Date | null}}
   */
  Timeline.prototype.getItemRange = function () {
    var _this = this;

    // get a rough approximation for the range based on the items start and end dates
    var range = this.getDataRange();
    var min = range.min !== null ? range.min.valueOf() : null;
    var max = range.max !== null ? range.max.valueOf() : null;
    var minItem = null;
    var maxItem = null;

    if (min != null && max != null) {
      var interval;
      var factor;
      var lhs;
      var rhs;
      var delta;

      (function () {
        var getStart = function getStart(item) {
          return util.convert(item.data.start, 'Date').valueOf();
        };

        var getEnd = function getEnd(item) {
          var end = item.data.end != undefined ? item.data.end : item.data.start;
          return util.convert(end, 'Date').valueOf();
        };

        // calculate the date of the left side and right side of the items given


        interval = max - min; // ms

        if (interval <= 0) {
          interval = 10;
        }
        factor = interval / _this.props.center.width;
        util.forEach(_this.itemSet.items, function (item) {
          if (item.groupShowing) {
            item.show();
            item.repositionX();
          }

          var start = getStart(item);
          var end = getEnd(item);

          if (this.options.rtl) {
            var startSide = start - (item.getWidthRight() + 10) * factor;
            var endSide = end + (item.getWidthLeft() + 10) * factor;
          } else {
            var startSide = start - (item.getWidthLeft() + 10) * factor;
            var endSide = end + (item.getWidthRight() + 10) * factor;
          }

          if (startSide < min) {
            min = startSide;
            minItem = item;
          }
          if (endSide > max) {
            max = endSide;
            maxItem = item;
          }
        }.bind(_this));

        if (minItem && maxItem) {
          lhs = minItem.getWidthLeft() + 10;
          rhs = maxItem.getWidthRight() + 10;
          delta = _this.props.center.width - lhs - rhs; // px

          if (delta > 0) {
            if (_this.options.rtl) {
              min = getStart(minItem) - rhs * interval / delta; // ms
              max = getEnd(maxItem) + lhs * interval / delta; // ms
            } else {
              min = getStart(minItem) - lhs * interval / delta; // ms
              max = getEnd(maxItem) + rhs * interval / delta; // ms
            }
          }
        }
      })();
    }

    return {
      min: min != null ? new Date(min) : null,
      max: max != null ? new Date(max) : null
    };
  };

  /**
   * Calculate the data range of the items start and end dates
   * @returns {{min: Date | null, max: Date | null}}
   */
  Timeline.prototype.getDataRange = function () {
    var min = null;
    var max = null;

    var dataset = this.itemsData && this.itemsData.getDataSet();
    if (dataset) {
      dataset.forEach(function (item) {
        var start = util.convert(item.start, 'Date').valueOf();
        var end = util.convert(item.end != undefined ? item.end : item.start, 'Date').valueOf();
        if (min === null || start < min) {
          min = start;
        }
        if (max === null || end > max) {
          max = end;
        }
      });
    }

    return {
      min: min != null ? new Date(min) : null,
      max: max != null ? new Date(max) : null
    };
  };

  /**
   * Generate Timeline related information from an event
   * @param {Event} event
   * @return {Object} An object with related information, like on which area
   *                  The event happened, whether clicked on an item, etc.
   */
  Timeline.prototype.getEventProperties = function (event) {
    var clientX = event.center ? event.center.x : event.clientX;
    var clientY = event.center ? event.center.y : event.clientY;
    if (this.options.rtl) {
      var x = util.getAbsoluteRight(this.dom.centerContainer) - clientX;
    } else {
      var x = clientX - util.getAbsoluteLeft(this.dom.centerContainer);
    }
    var y = clientY - util.getAbsoluteTop(this.dom.centerContainer);

    var item = this.itemSet.itemFromTarget(event);
    var group = this.itemSet.groupFromTarget(event);
    var customTime = CustomTime.customTimeFromTarget(event);

    var snap = this.itemSet.options.snap || null;
    var scale = this.body.util.getScale();
    var step = this.body.util.getStep();
    var time = this._toTime(x);
    var snappedTime = snap ? snap(time, scale, step) : time;

    var element = util.getTarget(event);
    var what = null;
    if (item != null) {
      what = 'item';
    } else if (customTime != null) {
      what = 'custom-time';
    } else if (util.hasParent(element, this.timeAxis.dom.foreground)) {
      what = 'axis';
    } else if (this.timeAxis2 && util.hasParent(element, this.timeAxis2.dom.foreground)) {
      what = 'axis';
    } else if (util.hasParent(element, this.itemSet.dom.labelSet)) {
      what = 'group-label';
    } else if (util.hasParent(element, this.currentTime.bar)) {
      what = 'current-time';
    } else if (util.hasParent(element, this.dom.center)) {
      what = 'background';
    }

    return {
      event: event,
      item: item ? item.id : null,
      group: group ? group.groupId : null,
      what: what,
      pageX: event.srcEvent ? event.srcEvent.pageX : event.pageX,
      pageY: event.srcEvent ? event.srcEvent.pageY : event.pageY,
      x: x,
      y: y,
      time: time,
      snappedTime: snappedTime
    };
  };

  module.exports = Timeline;

/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _stringify = __webpack_require__(82);

  var _stringify2 = _interopRequireDefault(_stringify);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  var _classCallCheck2 = __webpack_require__(115);

  var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

  var _createClass2 = __webpack_require__(116);

  var _createClass3 = _interopRequireDefault(_createClass2);

  var _ColorPicker = __webpack_require__(120);

  var _ColorPicker2 = _interopRequireDefault(_ColorPicker);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);

  /**
   * The way this works is for all properties of this.possible options, you can supply the property name in any form to list the options.
   * Boolean options are recognised as Boolean
   * Number options should be written as array: [default value, min value, max value, stepsize]
   * Colors should be written as array: ['color', '#ffffff']
   * Strings with should be written as array: [option1, option2, option3, ..]
   *
   * The options are matched with their counterparts in each of the modules and the values used in the configuration are
   *
   * @param parentModule        | the location where parentModule.setOptions() can be called
   * @param defaultContainer    | the default container of the module
   * @param configureOptions    | the fully configured and predefined options set found in allOptions.js
   * @param pixelRatio          | canvas pixel ratio
   */
  var Configurator = function () {
    function Configurator(parentModule, defaultContainer, configureOptions) {
      var pixelRatio = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
      (0, _classCallCheck3['default'])(this, Configurator);

      this.parent = parentModule;
      this.changedOptions = [];
      this.container = defaultContainer;
      this.allowCreation = false;

      this.options = {};
      this.initialized = false;
      this.popupCounter = 0;
      this.defaultOptions = {
        enabled: false,
        filter: true,
        container: undefined,
        showButton: true
      };
      util.extend(this.options, this.defaultOptions);

      this.configureOptions = configureOptions;
      this.moduleOptions = {};
      this.domElements = [];
      this.popupDiv = {};
      this.popupLimit = 5;
      this.popupHistory = {};
      this.colorPicker = new _ColorPicker2['default'](pixelRatio);
      this.wrapper = undefined;
    }

    /**
     * refresh all options.
     * Because all modules parse their options by themselves, we just use their options. We copy them here.
     *
     * @param options
     */


    (0, _createClass3['default'])(Configurator, [{
      key: 'setOptions',
      value: function setOptions(options) {
        if (options !== undefined) {
          // reset the popup history because the indices may have been changed.
          this.popupHistory = {};
          this._removePopup();

          var enabled = true;
          if (typeof options === 'string') {
            this.options.filter = options;
          } else if (options instanceof Array) {
            this.options.filter = options.join();
          } else if ((typeof options === 'undefined' ? 'undefined' : (0, _typeof3['default'])(options)) === 'object') {
            if (options.container !== undefined) {
              this.options.container = options.container;
            }
            if (options.filter !== undefined) {
              this.options.filter = options.filter;
            }
            if (options.showButton !== undefined) {
              this.options.showButton = options.showButton;
            }
            if (options.enabled !== undefined) {
              enabled = options.enabled;
            }
          } else if (typeof options === 'boolean') {
            this.options.filter = true;
            enabled = options;
          } else if (typeof options === 'function') {
            this.options.filter = options;
            enabled = true;
          }
          if (this.options.filter === false) {
            enabled = false;
          }

          this.options.enabled = enabled;
        }
        this._clean();
      }
    }, {
      key: 'setModuleOptions',
      value: function setModuleOptions(moduleOptions) {
        this.moduleOptions = moduleOptions;
        if (this.options.enabled === true) {
          this._clean();
          if (this.options.container !== undefined) {
            this.container = this.options.container;
          }
          this._create();
        }
      }

      /**
       * Create all DOM elements
       * @private
       */

    }, {
      key: '_create',
      value: function _create() {
        var _this = this;

        this._clean();
        this.changedOptions = [];

        var filter = this.options.filter;
        var counter = 0;
        var show = false;
        for (var option in this.configureOptions) {
          if (this.configureOptions.hasOwnProperty(option)) {
            this.allowCreation = false;
            show = false;
            if (typeof filter === 'function') {
              show = filter(option, []);
              show = show || this._handleObject(this.configureOptions[option], [option], true);
            } else if (filter === true || filter.indexOf(option) !== -1) {
              show = true;
            }

            if (show !== false) {
              this.allowCreation = true;

              // linebreak between categories
              if (counter > 0) {
                this._makeItem([]);
              }
              // a header for the category
              this._makeHeader(option);

              // get the sub options
              this._handleObject(this.configureOptions[option], [option]);
            }
            counter++;
          }
        }

        if (this.options.showButton === true) {
          (function () {
            var generateButton = document.createElement('div');
            generateButton.className = 'vis-configuration vis-config-button';
            generateButton.innerHTML = 'generate options';
            generateButton.onclick = function () {
              _this._printOptions();
            };
            generateButton.onmouseover = function () {
              generateButton.className = 'vis-configuration vis-config-button hover';
            };
            generateButton.onmouseout = function () {
              generateButton.className = 'vis-configuration vis-config-button';
            };

            _this.optionsContainer = document.createElement('div');
            _this.optionsContainer.className = 'vis-configuration vis-config-option-container';

            _this.domElements.push(_this.optionsContainer);
            _this.domElements.push(generateButton);
          })();
        }

        this._push();
        //~ this.colorPicker.insertTo(this.container);
      }

      /**
       * draw all DOM elements on the screen
       * @private
       */

    }, {
      key: '_push',
      value: function _push() {
        this.wrapper = document.createElement('div');
        this.wrapper.className = 'vis-configuration-wrapper';
        this.container.appendChild(this.wrapper);
        for (var i = 0; i < this.domElements.length; i++) {
          this.wrapper.appendChild(this.domElements[i]);
        }

        this._showPopupIfNeeded();
      }

      /**
       * delete all DOM elements
       * @private
       */

    }, {
      key: '_clean',
      value: function _clean() {
        for (var i = 0; i < this.domElements.length; i++) {
          this.wrapper.removeChild(this.domElements[i]);
        }

        if (this.wrapper !== undefined) {
          this.container.removeChild(this.wrapper);
          this.wrapper = undefined;
        }
        this.domElements = [];

        this._removePopup();
      }

      /**
       * get the value from the actualOptions if it exists
       * @param {array} path    | where to look for the actual option
       * @returns {*}
       * @private
       */

    }, {
      key: '_getValue',
      value: function _getValue(path) {
        var base = this.moduleOptions;
        for (var i = 0; i < path.length; i++) {
          if (base[path[i]] !== undefined) {
            base = base[path[i]];
          } else {
            base = undefined;
            break;
          }
        }
        return base;
      }

      /**
       * all option elements are wrapped in an item
       * @param path
       * @param domElements
       * @private
       */

    }, {
      key: '_makeItem',
      value: function _makeItem(path) {
        var _arguments = arguments,
            _this2 = this;

        if (this.allowCreation === true) {
          var _len, domElements, _key;

          var _ret2 = function () {
            var item = document.createElement('div');
            item.className = 'vis-configuration vis-config-item vis-config-s' + path.length;

            for (_len = _arguments.length, domElements = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              domElements[_key - 1] = _arguments[_key];
            }

            domElements.forEach(function (element) {
              item.appendChild(element);
            });
            _this2.domElements.push(item);
            return {
              v: _this2.domElements.length
            };
          }();

          if ((typeof _ret2 === 'undefined' ? 'undefined' : (0, _typeof3['default'])(_ret2)) === "object") return _ret2.v;
        }
        return 0;
      }

      /**
       * header for major subjects
       * @param name
       * @private
       */

    }, {
      key: '_makeHeader',
      value: function _makeHeader(name) {
        var div = document.createElement('div');
        div.className = 'vis-configuration vis-config-header';
        div.innerHTML = name;
        this._makeItem([], div);
      }

      /**
       * make a label, if it is an object label, it gets different styling.
       * @param name
       * @param path
       * @param objectLabel
       * @returns {HTMLElement}
       * @private
       */

    }, {
      key: '_makeLabel',
      value: function _makeLabel(name, path) {
        var objectLabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

        var div = document.createElement('div');
        div.className = 'vis-configuration vis-config-label vis-config-s' + path.length;
        if (objectLabel === true) {
          div.innerHTML = '<i><b>' + name + ':</b></i>';
        } else {
          div.innerHTML = name + ':';
        }
        return div;
      }

      /**
       * make a dropdown list for multiple possible string optoins
       * @param arr
       * @param value
       * @param path
       * @private
       */

    }, {
      key: '_makeDropdown',
      value: function _makeDropdown(arr, value, path) {
        var select = document.createElement('select');
        select.className = 'vis-configuration vis-config-select';
        var selectedValue = 0;
        if (value !== undefined) {
          if (arr.indexOf(value) !== -1) {
            selectedValue = arr.indexOf(value);
          }
        }

        for (var i = 0; i < arr.length; i++) {
          var option = document.createElement('option');
          option.value = arr[i];
          if (i === selectedValue) {
            option.selected = 'selected';
          }
          option.innerHTML = arr[i];
          select.appendChild(option);
        }

        var me = this;
        select.onchange = function () {
          me._update(this.value, path);
        };

        var label = this._makeLabel(path[path.length - 1], path);
        this._makeItem(path, label, select);
      }

      /**
       * make a range object for numeric options
       * @param arr
       * @param value
       * @param path
       * @private
       */

    }, {
      key: '_makeRange',
      value: function _makeRange(arr, value, path) {
        var defaultValue = arr[0];
        var min = arr[1];
        var max = arr[2];
        var step = arr[3];
        var range = document.createElement('input');
        range.className = 'vis-configuration vis-config-range';
        try {
          range.type = 'range'; // not supported on IE9
          range.min = min;
          range.max = max;
        } catch (err) {}
        range.step = step;

        // set up the popup settings in case they are needed.
        var popupString = '';
        var popupValue = 0;

        if (value !== undefined) {
          var factor = 1.20;
          if (value < 0 && value * factor < min) {
            range.min = Math.ceil(value * factor);
            popupValue = range.min;
            popupString = 'range increased';
          } else if (value / factor < min) {
            range.min = Math.ceil(value / factor);
            popupValue = range.min;
            popupString = 'range increased';
          }
          if (value * factor > max && max !== 1) {
            range.max = Math.ceil(value * factor);
            popupValue = range.max;
            popupString = 'range increased';
          }
          range.value = value;
        } else {
          range.value = defaultValue;
        }

        var input = document.createElement('input');
        input.className = 'vis-configuration vis-config-rangeinput';
        input.value = range.value;

        var me = this;
        range.onchange = function () {
          input.value = this.value;me._update(Number(this.value), path);
        };
        range.oninput = function () {
          input.value = this.value;
        };

        var label = this._makeLabel(path[path.length - 1], path);
        var itemIndex = this._makeItem(path, label, range, input);

        // if a popup is needed AND it has not been shown for this value, show it.
        if (popupString !== '' && this.popupHistory[itemIndex] !== popupValue) {
          this.popupHistory[itemIndex] = popupValue;
          this._setupPopup(popupString, itemIndex);
        }
      }

      /**
       * prepare the popup
       * @param string
       * @param index
       * @private
       */

    }, {
      key: '_setupPopup',
      value: function _setupPopup(string, index) {
        var _this3 = this;

        if (this.initialized === true && this.allowCreation === true && this.popupCounter < this.popupLimit) {
          var div = document.createElement("div");
          div.id = "vis-configuration-popup";
          div.className = "vis-configuration-popup";
          div.innerHTML = string;
          div.onclick = function () {
            _this3._removePopup();
          };
          this.popupCounter += 1;
          this.popupDiv = { html: div, index: index };
        }
      }

      /**
       * remove the popup from the dom
       * @private
       */

    }, {
      key: '_removePopup',
      value: function _removePopup() {
        if (this.popupDiv.html !== undefined) {
          this.popupDiv.html.parentNode.removeChild(this.popupDiv.html);
          clearTimeout(this.popupDiv.hideTimeout);
          clearTimeout(this.popupDiv.deleteTimeout);
          this.popupDiv = {};
        }
      }

      /**
       * Show the popup if it is needed.
       * @private
       */

    }, {
      key: '_showPopupIfNeeded',
      value: function _showPopupIfNeeded() {
        var _this4 = this;

        if (this.popupDiv.html !== undefined) {
          var correspondingElement = this.domElements[this.popupDiv.index];
          var rect = correspondingElement.getBoundingClientRect();
          this.popupDiv.html.style.left = rect.left + "px";
          this.popupDiv.html.style.top = rect.top - 30 + "px"; // 30 is the height;
          document.body.appendChild(this.popupDiv.html);
          this.popupDiv.hideTimeout = setTimeout(function () {
            _this4.popupDiv.html.style.opacity = 0;
          }, 1500);
          this.popupDiv.deleteTimeout = setTimeout(function () {
            _this4._removePopup();
          }, 1800);
        }
      }

      /**
       * make a checkbox for boolean options.
       * @param defaultValue
       * @param value
       * @param path
       * @private
       */

    }, {
      key: '_makeCheckbox',
      value: function _makeCheckbox(defaultValue, value, path) {
        var checkbox = document.createElement('input');
        checkbox.type = 'checkbox';
        checkbox.className = 'vis-configuration vis-config-checkbox';
        checkbox.checked = defaultValue;
        if (value !== undefined) {
          checkbox.checked = value;
          if (value !== defaultValue) {
            if ((typeof defaultValue === 'undefined' ? 'undefined' : (0, _typeof3['default'])(defaultValue)) === 'object') {
              if (value !== defaultValue.enabled) {
                this.changedOptions.push({ path: path, value: value });
              }
            } else {
              this.changedOptions.push({ path: path, value: value });
            }
          }
        }

        var me = this;
        checkbox.onchange = function () {
          me._update(this.checked, path);
        };

        var label = this._makeLabel(path[path.length - 1], path);
        this._makeItem(path, label, checkbox);
      }

      /**
       * make a text input field for string options.
       * @param defaultValue
       * @param value
       * @param path
       * @private
       */

    }, {
      key: '_makeTextInput',
      value: function _makeTextInput(defaultValue, value, path) {
        var checkbox = document.createElement('input');
        checkbox.type = 'text';
        checkbox.className = 'vis-configuration vis-config-text';
        checkbox.value = value;
        if (value !== defaultValue) {
          this.changedOptions.push({ path: path, value: value });
        }

        var me = this;
        checkbox.onchange = function () {
          me._update(this.value, path);
        };

        var label = this._makeLabel(path[path.length - 1], path);
        this._makeItem(path, label, checkbox);
      }

      /**
       * make a color field with a color picker for color fields
       * @param arr
       * @param value
       * @param path
       * @private
       */

    }, {
      key: '_makeColorField',
      value: function _makeColorField(arr, value, path) {
        var _this5 = this;

        var defaultColor = arr[1];
        var div = document.createElement('div');
        value = value === undefined ? defaultColor : value;

        if (value !== 'none') {
          div.className = 'vis-configuration vis-config-colorBlock';
          div.style.backgroundColor = value;
        } else {
          div.className = 'vis-configuration vis-config-colorBlock none';
        }

        value = value === undefined ? defaultColor : value;
        div.onclick = function () {
          _this5._showColorPicker(value, div, path);
        };

        var label = this._makeLabel(path[path.length - 1], path);
        this._makeItem(path, label, div);
      }

      /**
       * used by the color buttons to call the color picker.
       * @param event
       * @param value
       * @param div
       * @param path
       * @private
       */

    }, {
      key: '_showColorPicker',
      value: function _showColorPicker(value, div, path) {
        var _this6 = this;

        // clear the callback from this div
        div.onclick = function () {};

        this.colorPicker.insertTo(div);
        this.colorPicker.show();

        this.colorPicker.setColor(value);
        this.colorPicker.setUpdateCallback(function (color) {
          var colorString = 'rgba(' + color.r + ',' + color.g + ',' + color.b + ',' + color.a + ')';
          div.style.backgroundColor = colorString;
          _this6._update(colorString, path);
        });

        // on close of the colorpicker, restore the callback.
        this.colorPicker.setCloseCallback(function () {
          div.onclick = function () {
            _this6._showColorPicker(value, div, path);
          };
        });
      }

      /**
       * parse an object and draw the correct items
       * @param obj
       * @param path
       * @private
       */

    }, {
      key: '_handleObject',
      value: function _handleObject(obj) {
        var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        var checkOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

        var show = false;
        var filter = this.options.filter;
        var visibleInSet = false;
        for (var subObj in obj) {
          if (obj.hasOwnProperty(subObj)) {
            show = true;
            var item = obj[subObj];
            var newPath = util.copyAndExtendArray(path, subObj);
            if (typeof filter === 'function') {
              show = filter(subObj, path);

              // if needed we must go deeper into the object.
              if (show === false) {
                if (!(item instanceof Array) && typeof item !== 'string' && typeof item !== 'boolean' && item instanceof Object) {
                  this.allowCreation = false;
                  show = this._handleObject(item, newPath, true);
                  this.allowCreation = checkOnly === false;
                }
              }
            }

            if (show !== false) {
              visibleInSet = true;
              var value = this._getValue(newPath);

              if (item instanceof Array) {
                this._handleArray(item, value, newPath);
              } else if (typeof item === 'string') {
                this._makeTextInput(item, value, newPath);
              } else if (typeof item === 'boolean') {
                this._makeCheckbox(item, value, newPath);
              } else if (item instanceof Object) {
                // collapse the physics options that are not enabled
                var draw = true;
                if (path.indexOf('physics') !== -1) {
                  if (this.moduleOptions.physics.solver !== subObj) {
                    draw = false;
                  }
                }

                if (draw === true) {
                  // initially collapse options with an disabled enabled option.
                  if (item.enabled !== undefined) {
                    var enabledPath = util.copyAndExtendArray(newPath, 'enabled');
                    var enabledValue = this._getValue(enabledPath);
                    if (enabledValue === true) {
                      var label = this._makeLabel(subObj, newPath, true);
                      this._makeItem(newPath, label);
                      visibleInSet = this._handleObject(item, newPath) || visibleInSet;
                    } else {
                      this._makeCheckbox(item, enabledValue, newPath);
                    }
                  } else {
                    var _label = this._makeLabel(subObj, newPath, true);
                    this._makeItem(newPath, _label);
                    visibleInSet = this._handleObject(item, newPath) || visibleInSet;
                  }
                }
              } else {
                console.error('dont know how to handle', item, subObj, newPath);
              }
            }
          }
        }
        return visibleInSet;
      }

      /**
       * handle the array type of option
       * @param optionName
       * @param arr
       * @param value
       * @param path
       * @private
       */

    }, {
      key: '_handleArray',
      value: function _handleArray(arr, value, path) {
        if (typeof arr[0] === 'string' && arr[0] === 'color') {
          this._makeColorField(arr, value, path);
          if (arr[1] !== value) {
            this.changedOptions.push({ path: path, value: value });
          }
        } else if (typeof arr[0] === 'string') {
          this._makeDropdown(arr, value, path);
          if (arr[0] !== value) {
            this.changedOptions.push({ path: path, value: value });
          }
        } else if (typeof arr[0] === 'number') {
          this._makeRange(arr, value, path);
          if (arr[0] !== value) {
            this.changedOptions.push({ path: path, value: Number(value) });
          }
        }
      }

      /**
       * called to update the network with the new settings.
       * @param value
       * @param path
       * @private
       */

    }, {
      key: '_update',
      value: function _update(value, path) {
        var options = this._constructOptions(value, path);

        if (this.parent.body && this.parent.body.emitter && this.parent.body.emitter.emit) {
          this.parent.body.emitter.emit("configChange", options);
        }
        this.initialized = true;
        this.parent.setOptions(options);
      }
    }, {
      key: '_constructOptions',
      value: function _constructOptions(value, path) {
        var optionsObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

        var pointer = optionsObj;

        // when dropdown boxes can be string or boolean, we typecast it into correct types
        value = value === 'true' ? true : value;
        value = value === 'false' ? false : value;

        for (var i = 0; i < path.length; i++) {
          if (path[i] !== 'global') {
            if (pointer[path[i]] === undefined) {
              pointer[path[i]] = {};
            }
            if (i !== path.length - 1) {
              pointer = pointer[path[i]];
            } else {
              pointer[path[i]] = value;
            }
          }
        }
        return optionsObj;
      }
    }, {
      key: '_printOptions',
      value: function _printOptions() {
        var options = this.getOptions();
        this.optionsContainer.innerHTML = '<pre>var options = ' + (0, _stringify2['default'])(options, null, 2) + '</pre>';
      }
    }, {
      key: 'getOptions',
      value: function getOptions() {
        var options = {};
        for (var i = 0; i < this.changedOptions.length; i++) {
          this._constructOptions(this.changedOptions[i].value, this.changedOptions[i].path, options);
        }
        return options;
      }
    }]);
    return Configurator;
  }();

  exports['default'] = Configurator;

/***/ },
/* 115 */
/***/ function(module, exports) {

  "use strict";

  exports.__esModule = true;

  exports.default = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

  "use strict";

  exports.__esModule = true;

  var _defineProperty = __webpack_require__(117);

  var _defineProperty2 = _interopRequireDefault(_defineProperty);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

  exports.default = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        (0, _defineProperty2.default)(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

  module.exports = { "default": __webpack_require__(118), __esModule: true };

/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

  __webpack_require__(119);
  var $Object = __webpack_require__(17).Object;
  module.exports = function defineProperty(it, key, desc){
    return $Object.defineProperty(it, key, desc);
  };

/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

  var $export = __webpack_require__(15);
  // 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
  $export($export.S + $export.F * !__webpack_require__(25), 'Object', {defineProperty: __webpack_require__(21).f});

/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _stringify = __webpack_require__(82);

  var _stringify2 = _interopRequireDefault(_stringify);

  var _classCallCheck2 = __webpack_require__(115);

  var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

  var _createClass2 = __webpack_require__(116);

  var _createClass3 = _interopRequireDefault(_createClass2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var Hammer = __webpack_require__(108);
  var hammerUtil = __webpack_require__(121);
  var util = __webpack_require__(1);

  var ColorPicker = function () {
    function ColorPicker() {
      var pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      (0, _classCallCheck3['default'])(this, ColorPicker);

      this.pixelRatio = pixelRatio;
      this.generated = false;
      this.centerCoordinates = { x: 289 / 2, y: 289 / 2 };
      this.r = 289 * 0.49;
      this.color = { r: 255, g: 255, b: 255, a: 1.0 };
      this.hueCircle = undefined;
      this.initialColor = { r: 255, g: 255, b: 255, a: 1.0 };
      this.previousColor = undefined;
      this.applied = false;

      // bound by
      this.updateCallback = function () {};
      this.closeCallback = function () {};

      // create all DOM elements
      this._create();
    }

    /**
     * this inserts the colorPicker into a div from the DOM
     * @param container
     */


    (0, _createClass3['default'])(ColorPicker, [{
      key: 'insertTo',
      value: function insertTo(container) {
        if (this.hammer !== undefined) {
          this.hammer.destroy();
          this.hammer = undefined;
        }
        this.container = container;
        this.container.appendChild(this.frame);
        this._bindHammer();

        this._setSize();
      }

      /**
       * the callback is executed on apply and save. Bind it to the application
       * @param callback
       */

    }, {
      key: 'setUpdateCallback',
      value: function setUpdateCallback(callback) {
        if (typeof callback === 'function') {
          this.updateCallback = callback;
        } else {
          throw new Error("Function attempted to set as colorPicker update callback is not a function.");
        }
      }

      /**
       * the callback is executed on apply and save. Bind it to the application
       * @param callback
       */

    }, {
      key: 'setCloseCallback',
      value: function setCloseCallback(callback) {
        if (typeof callback === 'function') {
          this.closeCallback = callback;
        } else {
          throw new Error("Function attempted to set as colorPicker closing callback is not a function.");
        }
      }
    }, {
      key: '_isColorString',
      value: function _isColorString(color) {
        var htmlColors = { black: '#000000', navy: '#000080', darkblue: '#00008B', mediumblue: '#0000CD', blue: '#0000FF', darkgreen: '#006400', green: '#008000', teal: '#008080', darkcyan: '#008B8B', deepskyblue: '#00BFFF', darkturquoise: '#00CED1', mediumspringgreen: '#00FA9A', lime: '#00FF00', springgreen: '#00FF7F', aqua: '#00FFFF', cyan: '#00FFFF', midnightblue: '#191970', dodgerblue: '#1E90FF', lightseagreen: '#20B2AA', forestgreen: '#228B22', seagreen: '#2E8B57', darkslategray: '#2F4F4F', limegreen: '#32CD32', mediumseagreen: '#3CB371', turquoise: '#40E0D0', royalblue: '#4169E1', steelblue: '#4682B4', darkslateblue: '#483D8B', mediumturquoise: '#48D1CC', indigo: '#4B0082', darkolivegreen: '#556B2F', cadetblue: '#5F9EA0', cornflowerblue: '#6495ED', mediumaquamarine: '#66CDAA', dimgray: '#696969', slateblue: '#6A5ACD', olivedrab: '#6B8E23', slategray: '#708090', lightslategray: '#778899', mediumslateblue: '#7B68EE', lawngreen: '#7CFC00', chartreuse: '#7FFF00', aquamarine: '#7FFFD4', maroon: '#800000', purple: '#800080', olive: '#808000', gray: '#808080', skyblue: '#87CEEB', lightskyblue: '#87CEFA', blueviolet: '#8A2BE2', darkred: '#8B0000', darkmagenta: '#8B008B', saddlebrown: '#8B4513', darkseagreen: '#8FBC8F', lightgreen: '#90EE90', mediumpurple: '#9370D8', darkviolet: '#9400D3', palegreen: '#98FB98', darkorchid: '#9932CC', yellowgreen: '#9ACD32', sienna: '#A0522D', brown: '#A52A2A', darkgray: '#A9A9A9', lightblue: '#ADD8E6', greenyellow: '#ADFF2F', paleturquoise: '#AFEEEE', lightsteelblue: '#B0C4DE', powderblue: '#B0E0E6', firebrick: '#B22222', darkgoldenrod: '#B8860B', mediumorchid: '#BA55D3', rosybrown: '#BC8F8F', darkkhaki: '#BDB76B', silver: '#C0C0C0', mediumvioletred: '#C71585', indianred: '#CD5C5C', peru: '#CD853F', chocolate: '#D2691E', tan: '#D2B48C', lightgrey: '#D3D3D3', palevioletred: '#D87093', thistle: '#D8BFD8', orchid: '#DA70D6', goldenrod: '#DAA520', crimson: '#DC143C', gainsboro: '#DCDCDC', plum: '#DDA0DD', burlywood: '#DEB887', lightcyan: '#E0FFFF', lavender: '#E6E6FA', darksalmon: '#E9967A', violet: '#EE82EE', palegoldenrod: '#EEE8AA', lightcoral: '#F08080', khaki: '#F0E68C', aliceblue: '#F0F8FF', honeydew: '#F0FFF0', azure: '#F0FFFF', sandybrown: '#F4A460', wheat: '#F5DEB3', beige: '#F5F5DC', whitesmoke: '#F5F5F5', mintcream: '#F5FFFA', ghostwhite: '#F8F8FF', salmon: '#FA8072', antiquewhite: '#FAEBD7', linen: '#FAF0E6', lightgoldenrodyellow: '#FAFAD2', oldlace: '#FDF5E6', red: '#FF0000', fuchsia: '#FF00FF', magenta: '#FF00FF', deeppink: '#FF1493', orangered: '#FF4500', tomato: '#FF6347', hotpink: '#FF69B4', coral: '#FF7F50', darkorange: '#FF8C00', lightsalmon: '#FFA07A', orange: '#FFA500', lightpink: '#FFB6C1', pink: '#FFC0CB', gold: '#FFD700', peachpuff: '#FFDAB9', navajowhite: '#FFDEAD', moccasin: '#FFE4B5', bisque: '#FFE4C4', mistyrose: '#FFE4E1', blanchedalmond: '#FFEBCD', papayawhip: '#FFEFD5', lavenderblush: '#FFF0F5', seashell: '#FFF5EE', cornsilk: '#FFF8DC', lemonchiffon: '#FFFACD', floralwhite: '#FFFAF0', snow: '#FFFAFA', yellow: '#FFFF00', lightyellow: '#FFFFE0', ivory: '#FFFFF0', white: '#FFFFFF' };
        if (typeof color === 'string') {
          return htmlColors[color];
        }
      }

      /**
       * Set the color of the colorPicker
       * Supported formats:
       * 'red'                   --> HTML color string
       * '#ffffff'               --> hex string
       * 'rbg(255,255,255)'      --> rgb string
       * 'rgba(255,255,255,1.0)' --> rgba string
       * {r:255,g:255,b:255}     --> rgb object
       * {r:255,g:255,b:255,a:1.0} --> rgba object
       * @param color
       * @param setInitial
       */

    }, {
      key: 'setColor',
      value: function setColor(color) {
        var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

        if (color === 'none') {
          return;
        }

        var rgba = void 0;

        // if a html color shorthand is used, convert to hex
        var htmlColor = this._isColorString(color);
        if (htmlColor !== undefined) {
          color = htmlColor;
        }

        // check format
        if (util.isString(color) === true) {
          if (util.isValidRGB(color) === true) {
            var rgbaArray = color.substr(4).substr(0, color.length - 5).split(',');
            rgba = { r: rgbaArray[0], g: rgbaArray[1], b: rgbaArray[2], a: 1.0 };
          } else if (util.isValidRGBA(color) === true) {
            var _rgbaArray = color.substr(5).substr(0, color.length - 6).split(',');
            rgba = { r: _rgbaArray[0], g: _rgbaArray[1], b: _rgbaArray[2], a: _rgbaArray[3] };
          } else if (util.isValidHex(color) === true) {
            var rgbObj = util.hexToRGB(color);
            rgba = { r: rgbObj.r, g: rgbObj.g, b: rgbObj.b, a: 1.0 };
          }
        } else {
          if (color instanceof Object) {
            if (color.r !== undefined && color.g !== undefined && color.b !== undefined) {
              var alpha = color.a !== undefined ? color.a : '1.0';
              rgba = { r: color.r, g: color.g, b: color.b, a: alpha };
            }
          }
        }

        // set color
        if (rgba === undefined) {
          throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: " + (0, _stringify2['default'])(color));
        } else {
          this._setColor(rgba, setInitial);
        }
      }

      /**
       * this shows the color picker.
       * The hue circle is constructed once and stored.
       */

    }, {
      key: 'show',
      value: function show() {
        if (this.closeCallback !== undefined) {
          this.closeCallback();
          this.closeCallback = undefined;
        }

        this.applied = false;
        this.frame.style.display = 'block';
        this._generateHueCircle();
      }

      // ------------------------------------------ PRIVATE ----------------------------- //

      /**
       * Hide the picker. Is called by the cancel button.
       * Optional boolean to store the previous color for easy access later on.
       * @param storePrevious
       * @private
       */

    }, {
      key: '_hide',
      value: function _hide() {
        var _this = this;

        var storePrevious = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

        // store the previous color for next time;
        if (storePrevious === true) {
          this.previousColor = util.extend({}, this.color);
        }

        if (this.applied === true) {
          this.updateCallback(this.initialColor);
        }

        this.frame.style.display = 'none';

        // call the closing callback, restoring the onclick method.
        // this is in a setTimeout because it will trigger the show again before the click is done.
        setTimeout(function () {
          if (_this.closeCallback !== undefined) {
            _this.closeCallback();
            _this.closeCallback = undefined;
          }
        }, 0);
      }

      /**
       * bound to the save button. Saves and hides.
       * @private
       */

    }, {
      key: '_save',
      value: function _save() {
        this.updateCallback(this.color);
        this.applied = false;
        this._hide();
      }

      /**
       * Bound to apply button. Saves but does not close. Is undone by the cancel button.
       * @private
       */

    }, {
      key: '_apply',
      value: function _apply() {
        this.applied = true;
        this.updateCallback(this.color);
        this._updatePicker(this.color);
      }

      /**
       * load the color from the previous session.
       * @private
       */

    }, {
      key: '_loadLast',
      value: function _loadLast() {
        if (this.previousColor !== undefined) {
          this.setColor(this.previousColor, false);
        } else {
          alert("There is no last color to load...");
        }
      }

      /**
       * set the color, place the picker
       * @param rgba
       * @param setInitial
       * @private
       */

    }, {
      key: '_setColor',
      value: function _setColor(rgba) {
        var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

        // store the initial color
        if (setInitial === true) {
          this.initialColor = util.extend({}, rgba);
        }

        this.color = rgba;
        var hsv = util.RGBToHSV(rgba.r, rgba.g, rgba.b);

        var angleConvert = 2 * Math.PI;
        var radius = this.r * hsv.s;
        var x = this.centerCoordinates.x + radius * Math.sin(angleConvert * hsv.h);
        var y = this.centerCoordinates.y + radius * Math.cos(angleConvert * hsv.h);

        this.colorPickerSelector.style.left = x - 0.5 * this.colorPickerSelector.clientWidth + 'px';
        this.colorPickerSelector.style.top = y - 0.5 * this.colorPickerSelector.clientHeight + 'px';

        this._updatePicker(rgba);
      }

      /**
       * bound to opacity control
       * @param value
       * @private
       */

    }, {
      key: '_setOpacity',
      value: function _setOpacity(value) {
        this.color.a = value / 100;
        this._updatePicker(this.color);
      }

      /**
       * bound to brightness control
       * @param value
       * @private
       */

    }, {
      key: '_setBrightness',
      value: function _setBrightness(value) {
        var hsv = util.RGBToHSV(this.color.r, this.color.g, this.color.b);
        hsv.v = value / 100;
        var rgba = util.HSVToRGB(hsv.h, hsv.s, hsv.v);
        rgba['a'] = this.color.a;
        this.color = rgba;
        this._updatePicker();
      }

      /**
       * update the color picker. A black circle overlays the hue circle to mimic the brightness decreasing.
       * @param rgba
       * @private
       */

    }, {
      key: '_updatePicker',
      value: function _updatePicker() {
        var rgba = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.color;

        var hsv = util.RGBToHSV(rgba.r, rgba.g, rgba.b);
        var ctx = this.colorPickerCanvas.getContext('2d');
        if (this.pixelRation === undefined) {
          this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
        }
        ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

        // clear the canvas
        var w = this.colorPickerCanvas.clientWidth;
        var h = this.colorPickerCanvas.clientHeight;
        ctx.clearRect(0, 0, w, h);

        ctx.putImageData(this.hueCircle, 0, 0);
        ctx.fillStyle = 'rgba(0,0,0,' + (1 - hsv.v) + ')';
        ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
        ctx.fill();

        this.brightnessRange.value = 100 * hsv.v;
        this.opacityRange.value = 100 * rgba.a;

        this.initialColorDiv.style.backgroundColor = 'rgba(' + this.initialColor.r + ',' + this.initialColor.g + ',' + this.initialColor.b + ',' + this.initialColor.a + ')';
        this.newColorDiv.style.backgroundColor = 'rgba(' + this.color.r + ',' + this.color.g + ',' + this.color.b + ',' + this.color.a + ')';
      }

      /**
       * used by create to set the size of the canvas.
       * @private
       */

    }, {
      key: '_setSize',
      value: function _setSize() {
        this.colorPickerCanvas.style.width = '100%';
        this.colorPickerCanvas.style.height = '100%';

        this.colorPickerCanvas.width = 289 * this.pixelRatio;
        this.colorPickerCanvas.height = 289 * this.pixelRatio;
      }

      /**
       * create all dom elements
       * TODO: cleanup, lots of similar dom elements
       * @private
       */

    }, {
      key: '_create',
      value: function _create() {
        this.frame = document.createElement('div');
        this.frame.className = 'vis-color-picker';

        this.colorPickerDiv = document.createElement('div');
        this.colorPickerSelector = document.createElement('div');
        this.colorPickerSelector.className = 'vis-selector';
        this.colorPickerDiv.appendChild(this.colorPickerSelector);

        this.colorPickerCanvas = document.createElement('canvas');
        this.colorPickerDiv.appendChild(this.colorPickerCanvas);

        if (!this.colorPickerCanvas.getContext) {
          var noCanvas = document.createElement('DIV');
          noCanvas.style.color = 'red';
          noCanvas.style.fontWeight = 'bold';
          noCanvas.style.padding = '10px';
          noCanvas.innerHTML = 'Error: your browser does not support HTML canvas';
          this.colorPickerCanvas.appendChild(noCanvas);
        } else {
          var ctx = this.colorPickerCanvas.getContext("2d");
          this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);

          this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
        }

        this.colorPickerDiv.className = 'vis-color';

        this.opacityDiv = document.createElement('div');
        this.opacityDiv.className = 'vis-opacity';

        this.brightnessDiv = document.createElement('div');
        this.brightnessDiv.className = 'vis-brightness';

        this.arrowDiv = document.createElement('div');
        this.arrowDiv.className = 'vis-arrow';

        this.opacityRange = document.createElement('input');
        try {
          this.opacityRange.type = 'range'; // Not supported on IE9
          this.opacityRange.min = '0';
          this.opacityRange.max = '100';
        } catch (err) {}
        this.opacityRange.value = '100';
        this.opacityRange.className = 'vis-range';

        this.brightnessRange = document.createElement('input');
        try {
          this.brightnessRange.type = 'range'; // Not supported on IE9
          this.brightnessRange.min = '0';
          this.brightnessRange.max = '100';
        } catch (err) {}
        this.brightnessRange.value = '100';
        this.brightnessRange.className = 'vis-range';

        this.opacityDiv.appendChild(this.opacityRange);
        this.brightnessDiv.appendChild(this.brightnessRange);

        var me = this;
        this.opacityRange.onchange = function () {
          me._setOpacity(this.value);
        };
        this.opacityRange.oninput = function () {
          me._setOpacity(this.value);
        };
        this.brightnessRange.onchange = function () {
          me._setBrightness(this.value);
        };
        this.brightnessRange.oninput = function () {
          me._setBrightness(this.value);
        };

        this.brightnessLabel = document.createElement("div");
        this.brightnessLabel.className = "vis-label vis-brightness";
        this.brightnessLabel.innerHTML = 'brightness:';

        this.opacityLabel = document.createElement("div");
        this.opacityLabel.className = "vis-label vis-opacity";
        this.opacityLabel.innerHTML = 'opacity:';

        this.newColorDiv = document.createElement("div");
        this.newColorDiv.className = "vis-new-color";
        this.newColorDiv.innerHTML = 'new';

        this.initialColorDiv = document.createElement("div");
        this.initialColorDiv.className = "vis-initial-color";
        this.initialColorDiv.innerHTML = 'initial';

        this.cancelButton = document.createElement("div");
        this.cancelButton.className = "vis-button vis-cancel";
        this.cancelButton.innerHTML = 'cancel';
        this.cancelButton.onclick = this._hide.bind(this, false);

        this.applyButton = document.createElement("div");
        this.applyButton.className = "vis-button vis-apply";
        this.applyButton.innerHTML = 'apply';
        this.applyButton.onclick = this._apply.bind(this);

        this.saveButton = document.createElement("div");
        this.saveButton.className = "vis-button vis-save";
        this.saveButton.innerHTML = 'save';
        this.saveButton.onclick = this._save.bind(this);

        this.loadButton = document.createElement("div");
        this.loadButton.className = "vis-button vis-load";
        this.loadButton.innerHTML = 'load last';
        this.loadButton.onclick = this._loadLast.bind(this);

        this.frame.appendChild(this.colorPickerDiv);
        this.frame.appendChild(this.arrowDiv);
        this.frame.appendChild(this.brightnessLabel);
        this.frame.appendChild(this.brightnessDiv);
        this.frame.appendChild(this.opacityLabel);
        this.frame.appendChild(this.opacityDiv);
        this.frame.appendChild(this.newColorDiv);
        this.frame.appendChild(this.initialColorDiv);

        this.frame.appendChild(this.cancelButton);
        this.frame.appendChild(this.applyButton);
        this.frame.appendChild(this.saveButton);
        this.frame.appendChild(this.loadButton);
      }

      /**
       * bind hammer to the color picker
       * @private
       */

    }, {
      key: '_bindHammer',
      value: function _bindHammer() {
        var _this2 = this;

        this.drag = {};
        this.pinch = {};
        this.hammer = new Hammer(this.colorPickerCanvas);
        this.hammer.get('pinch').set({ enable: true });

        hammerUtil.onTouch(this.hammer, function (event) {
          _this2._moveSelector(event);
        });
        this.hammer.on('tap', function (event) {
          _this2._moveSelector(event);
        });
        this.hammer.on('panstart', function (event) {
          _this2._moveSelector(event);
        });
        this.hammer.on('panmove', function (event) {
          _this2._moveSelector(event);
        });
        this.hammer.on('panend', function (event) {
          _this2._moveSelector(event);
        });
      }

      /**
       * generate the hue circle. This is relatively heavy (200ms) and is done only once on the first time it is shown.
       * @private
       */

    }, {
      key: '_generateHueCircle',
      value: function _generateHueCircle() {
        if (this.generated === false) {
          var ctx = this.colorPickerCanvas.getContext('2d');
          if (this.pixelRation === undefined) {
            this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
          }
          ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

          // clear the canvas
          var w = this.colorPickerCanvas.clientWidth;
          var h = this.colorPickerCanvas.clientHeight;
          ctx.clearRect(0, 0, w, h);

          // draw hue circle
          var x = void 0,
              y = void 0,
              hue = void 0,
              sat = void 0;
          this.centerCoordinates = { x: w * 0.5, y: h * 0.5 };
          this.r = 0.49 * w;
          var angleConvert = 2 * Math.PI / 360;
          var hfac = 1 / 360;
          var sfac = 1 / this.r;
          var rgb = void 0;
          for (hue = 0; hue < 360; hue++) {
            for (sat = 0; sat < this.r; sat++) {
              x = this.centerCoordinates.x + sat * Math.sin(angleConvert * hue);
              y = this.centerCoordinates.y + sat * Math.cos(angleConvert * hue);
              rgb = util.HSVToRGB(hue * hfac, sat * sfac, 1);
              ctx.fillStyle = 'rgb(' + rgb.r + ',' + rgb.g + ',' + rgb.b + ')';
              ctx.fillRect(x - 0.5, y - 0.5, 2, 2);
            }
          }
          ctx.strokeStyle = 'rgba(0,0,0,1)';
          ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
          ctx.stroke();

          this.hueCircle = ctx.getImageData(0, 0, w, h);
        }
        this.generated = true;
      }

      /**
       * move the selector. This is called by hammer functions.
       *
       * @param event
       * @private
       */

    }, {
      key: '_moveSelector',
      value: function _moveSelector(event) {
        var rect = this.colorPickerDiv.getBoundingClientRect();
        var left = event.center.x - rect.left;
        var top = event.center.y - rect.top;

        var centerY = 0.5 * this.colorPickerDiv.clientHeight;
        var centerX = 0.5 * this.colorPickerDiv.clientWidth;

        var x = left - centerX;
        var y = top - centerY;

        var angle = Math.atan2(x, y);
        var radius = 0.98 * Math.min(Math.sqrt(x * x + y * y), centerX);

        var newTop = Math.cos(angle) * radius + centerY;
        var newLeft = Math.sin(angle) * radius + centerX;

        this.colorPickerSelector.style.top = newTop - 0.5 * this.colorPickerSelector.clientHeight + 'px';
        this.colorPickerSelector.style.left = newLeft - 0.5 * this.colorPickerSelector.clientWidth + 'px';

        // set color
        var h = angle / (2 * Math.PI);
        h = h < 0 ? h + 1 : h;
        var s = radius / this.r;
        var hsv = util.RGBToHSV(this.color.r, this.color.g, this.color.b);
        hsv.h = h;
        hsv.s = s;
        var rgba = util.HSVToRGB(hsv.h, hsv.s, hsv.v);
        rgba['a'] = this.color.a;
        this.color = rgba;

        // update previews
        this.initialColorDiv.style.backgroundColor = 'rgba(' + this.initialColor.r + ',' + this.initialColor.g + ',' + this.initialColor.b + ',' + this.initialColor.a + ')';
        this.newColorDiv.style.backgroundColor = 'rgba(' + this.color.r + ',' + this.color.g + ',' + this.color.b + ',' + this.color.a + ')';
      }
    }]);
    return ColorPicker;
  }();

  exports['default'] = ColorPicker;

/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var Hammer = __webpack_require__(108);

  /**
   * Register a touch event, taking place before a gesture
   * @param {Hammer} hammer       A hammer instance
   * @param {function} callback   Callback, called as callback(event)
   */
  exports.onTouch = function (hammer, callback) {
    callback.inputHandler = function (event) {
      if (event.isFirst) {
        callback(event);
      }
    };

    hammer.on('hammer.input', callback.inputHandler);
  };

  /**
   * Register a release event, taking place after a gesture
   * @param {Hammer} hammer       A hammer instance
   * @param {function} callback   Callback, called as callback(event)
   */
  exports.onRelease = function (hammer, callback) {
    callback.inputHandler = function (event) {
      if (event.isFinal) {
        callback(event);
      }
    };

    return hammer.on('hammer.input', callback.inputHandler);
  };

  /**
   * Unregister a touch event, taking place before a gesture
   * @param {Hammer} hammer       A hammer instance
   * @param {function} callback   Callback, called as callback(event)
   */
  exports.offTouch = function (hammer, callback) {
    hammer.off('hammer.input', callback.inputHandler);
  };

  /**
   * Unregister a release event, taking place before a gesture
   * @param {Hammer} hammer       A hammer instance
   * @param {function} callback   Callback, called as callback(event)
   */
  exports.offRelease = exports.offTouch;

  /**
   * Hack the PinchRecognizer such that it doesn't prevent default behavior
   * for vertical panning.
   *
   * Yeah ... this is quite a hack ... see https://github.com/hammerjs/hammer.js/issues/932
   *
   * @param {Hammer.Pinch} pinchRecognizer
   * @return {Hammer.Pinch} returns the pinchRecognizer
   */
  exports.disablePreventDefaultVertically = function (pinchRecognizer) {
    var TOUCH_ACTION_PAN_Y = 'pan-y';

    pinchRecognizer.getTouchAction = function () {
      // default method returns [TOUCH_ACTION_NONE]
      return [TOUCH_ACTION_PAN_Y];
    };

    return pinchRecognizer;
  };

/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.printStyle = undefined;

  var _stringify = __webpack_require__(82);

  var _stringify2 = _interopRequireDefault(_stringify);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  var _classCallCheck2 = __webpack_require__(115);

  var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

  var _createClass2 = __webpack_require__(116);

  var _createClass3 = _interopRequireDefault(_createClass2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);

  var errorFound = false;
  var allOptions = void 0;
  var printStyle = 'background: #FFeeee; color: #dd0000';
  /**
   *  Used to validate options.
   */

  var Validator = function () {
    function Validator() {
      (0, _classCallCheck3['default'])(this, Validator);
    }

    /**
     * Main function to be called
     * @param options
     * @param subObject
     * @returns {boolean}
     */


    (0, _createClass3['default'])(Validator, null, [{
      key: 'validate',
      value: function validate(options, referenceOptions, subObject) {
        errorFound = false;
        allOptions = referenceOptions;
        var usedOptions = referenceOptions;
        if (subObject !== undefined) {
          usedOptions = referenceOptions[subObject];
        }
        Validator.parse(options, usedOptions, []);
        return errorFound;
      }

      /**
       * Will traverse an object recursively and check every value
       * @param options
       * @param referenceOptions
       * @param path
       */

    }, {
      key: 'parse',
      value: function parse(options, referenceOptions, path) {
        for (var option in options) {
          if (options.hasOwnProperty(option)) {
            Validator.check(option, options, referenceOptions, path);
          }
        }
      }

      /**
       * Check every value. If the value is an object, call the parse function on that object.
       * @param option
       * @param options
       * @param referenceOptions
       * @param path
       */

    }, {
      key: 'check',
      value: function check(option, options, referenceOptions, path) {
        if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
          Validator.getSuggestion(option, referenceOptions, path);
        } else if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
          // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
          if (Validator.getType(options[option]) === 'object' && referenceOptions['__any__'].__type__ !== undefined) {
            // if the any subgroup is not a predefined object int he configurator we do not look deeper into the object.
            Validator.checkFields(option, options, referenceOptions, '__any__', referenceOptions['__any__'].__type__, path);
          } else {
            Validator.checkFields(option, options, referenceOptions, '__any__', referenceOptions['__any__'], path);
          }
        } else {
          // Since all options in the reference are objects, we can check whether they are supposed to be object to look for the __type__ field.
          if (referenceOptions[option].__type__ !== undefined) {
            // if this should be an object, we check if the correct type has been supplied to account for shorthand options.
            Validator.checkFields(option, options, referenceOptions, option, referenceOptions[option].__type__, path);
          } else {
            Validator.checkFields(option, options, referenceOptions, option, referenceOptions[option], path);
          }
        }
      }

      /**
       *
       * @param {String}  option     | the option property
       * @param {Object}  options    | The supplied options object
       * @param {Object}  referenceOptions    | The reference options containing all options and their allowed formats
       * @param {String}  referenceOption     | Usually this is the same as option, except when handling an __any__ tag.
       * @param {String}  refOptionType       | This is the type object from the reference options
       * @param {Array}   path      | where in the object is the option
       */

    }, {
      key: 'checkFields',
      value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
        var optionType = Validator.getType(options[option]);
        var refOptionType = refOptionObj[optionType];
        if (refOptionType !== undefined) {
          // if the type is correct, we check if it is supposed to be one of a few select values
          if (Validator.getType(refOptionType) === 'array') {
            if (refOptionType.indexOf(options[option]) === -1) {
              console.log('%cInvalid option detected in "' + option + '".' + ' Allowed values are:' + Validator.print(refOptionType) + ' not "' + options[option] + '". ' + Validator.printLocation(path, option), printStyle);
              errorFound = true;
            } else if (optionType === 'object' && referenceOption !== "__any__") {
              path = util.copyAndExtendArray(path, option);
              Validator.parse(options[option], referenceOptions[referenceOption], path);
            }
          } else if (optionType === 'object' && referenceOption !== "__any__") {
            path = util.copyAndExtendArray(path, option);
            Validator.parse(options[option], referenceOptions[referenceOption], path);
          }
        } else if (refOptionObj['any'] === undefined) {
          // type of the field is incorrect and the field cannot be any
          console.log('%cInvalid type received for "' + option + '". Expected: ' + Validator.print((0, _keys2['default'])(refOptionObj)) + '. Received [' + optionType + '] "' + options[option] + '"' + Validator.printLocation(path, option), printStyle);
          errorFound = true;
        }
      }
    }, {
      key: 'getType',
      value: function getType(object) {
        var type = typeof object === 'undefined' ? 'undefined' : (0, _typeof3['default'])(object);

        if (type === 'object') {
          if (object === null) {
            return 'null';
          }
          if (object instanceof Boolean) {
            return 'boolean';
          }
          if (object instanceof Number) {
            return 'number';
          }
          if (object instanceof String) {
            return 'string';
          }
          if (Array.isArray(object)) {
            return 'array';
          }
          if (object instanceof Date) {
            return 'date';
          }
          if (object.nodeType !== undefined) {
            return 'dom';
          }
          if (object._isAMomentObject === true) {
            return 'moment';
          }
          return 'object';
        } else if (type === 'number') {
          return 'number';
        } else if (type === 'boolean') {
          return 'boolean';
        } else if (type === 'string') {
          return 'string';
        } else if (type === undefined) {
          return 'undefined';
        }
        return type;
      }
    }, {
      key: 'getSuggestion',
      value: function getSuggestion(option, options, path) {
        var localSearch = Validator.findInOptions(option, options, path, false);
        var globalSearch = Validator.findInOptions(option, allOptions, [], true);

        var localSearchThreshold = 8;
        var globalSearchThreshold = 4;

        if (localSearch.indexMatch !== undefined) {
          console.log('%cUnknown option detected: "' + option + '" in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n', printStyle);
        } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
          console.log('%cUnknown option detected: "' + option + '" in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was misplaced? Matching option found at: ' + Validator.printLocation(globalSearch.path, globalSearch.closestMatch, ''), printStyle);
        } else if (localSearch.distance <= localSearchThreshold) {
          console.log('%cUnknown option detected: "' + option + '". Did you mean "' + localSearch.closestMatch + '"?' + Validator.printLocation(localSearch.path, option), printStyle);
        } else {
          console.log('%cUnknown option detected: "' + option + '". Did you mean one of these: ' + Validator.print((0, _keys2['default'])(options)) + Validator.printLocation(path, option), printStyle);
        }

        errorFound = true;
      }

      /**
       * traverse the options in search for a match.
       * @param option
       * @param options
       * @param path
       * @param recursive
       * @returns {{closestMatch: string, path: Array, distance: number}}
       */

    }, {
      key: 'findInOptions',
      value: function findInOptions(option, options, path) {
        var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

        var min = 1e9;
        var closestMatch = '';
        var closestMatchPath = [];
        var lowerCaseOption = option.toLowerCase();
        var indexMatch = undefined;
        for (var op in options) {
          var distance = void 0;
          if (options[op].__type__ !== undefined && recursive === true) {
            var result = Validator.findInOptions(option, options[op], util.copyAndExtendArray(path, op));
            if (min > result.distance) {
              closestMatch = result.closestMatch;
              closestMatchPath = result.path;
              min = result.distance;
              indexMatch = result.indexMatch;
            }
          } else {
            if (op.toLowerCase().indexOf(lowerCaseOption) !== -1) {
              indexMatch = op;
            }
            distance = Validator.levenshteinDistance(option, op);
            if (min > distance) {
              closestMatch = op;
              closestMatchPath = util.copyArray(path);
              min = distance;
            }
          }
        }
        return { closestMatch: closestMatch, path: closestMatchPath, distance: min, indexMatch: indexMatch };
      }
    }, {
      key: 'printLocation',
      value: function printLocation(path, option) {
        var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Problem value found at: \n';

        var str = '\n\n' + prefix + 'options = {\n';
        for (var i = 0; i < path.length; i++) {
          for (var j = 0; j < i + 1; j++) {
            str += '  ';
          }
          str += path[i] + ': {\n';
        }
        for (var _j = 0; _j < path.length + 1; _j++) {
          str += '  ';
        }
        str += option + '\n';
        for (var _i = 0; _i < path.length + 1; _i++) {
          for (var _j2 = 0; _j2 < path.length - _i; _j2++) {
            str += '  ';
          }
          str += '}\n';
        }
        return str + '\n\n';
      }
    }, {
      key: 'print',
      value: function print(options) {
        return (0, _stringify2['default'])(options).replace(/(\")|(\[)|(\])|(,"__type__")/g, "").replace(/(\,)/g, ', ');
      }

      // Compute the edit distance between the two given strings
      // http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
      /*
       Copyright (c) 2011 Andrei Mackenzie
        Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
        The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
        THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
       */

    }, {
      key: 'levenshteinDistance',
      value: function levenshteinDistance(a, b) {
        if (a.length === 0) return b.length;
        if (b.length === 0) return a.length;

        var matrix = [];

        // increment along the first column of each row
        var i;
        for (i = 0; i <= b.length; i++) {
          matrix[i] = [i];
        }

        // increment each column in the first row
        var j;
        for (j = 0; j <= a.length; j++) {
          matrix[0][j] = j;
        }

        // Fill in the rest of the matrix
        for (i = 1; i <= b.length; i++) {
          for (j = 1; j <= a.length; j++) {
            if (b.charAt(i - 1) == a.charAt(j - 1)) {
              matrix[i][j] = matrix[i - 1][j - 1];
            } else {
              matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, // substitution
              Math.min(matrix[i][j - 1] + 1, // insertion
              matrix[i - 1][j] + 1)); // deletion
            }
          }
        }

        return matrix[b.length][a.length];
      }
    }]);
    return Validator;
  }();

  exports['default'] = Validator;
  exports.printStyle = printStyle;

/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  var _stringify = __webpack_require__(82);

  var _stringify2 = _interopRequireDefault(_stringify);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var hammerUtil = __webpack_require__(121);
  var moment = __webpack_require__(84);
  var Component = __webpack_require__(124);
  var DateUtil = __webpack_require__(125);

  /**
   * @constructor Range
   * A Range controls a numeric range with a start and end value.
   * The Range adjusts the range based on mouse events or programmatic changes,
   * and triggers events when the range is changing or has been changed.
   * @param {{dom: Object, domProps: Object, emitter: Emitter}} body
   * @param {Object} [options]    See description at Range.setOptions
   */
  function Range(body, options) {
    var now = moment().hours(0).minutes(0).seconds(0).milliseconds(0);
    var start = now.clone().add(-3, 'days').valueOf();
    var end = now.clone().add(3, 'days').valueOf();

    if (options === undefined) {
      this.start = start;
      this.end = end;
    } else {
      this.start = options.start || start;
      this.end = options.end || end;
    }

    this.rolling = false;

    this.body = body;
    this.deltaDifference = 0;
    this.scaleOffset = 0;
    this.startToFront = false;
    this.endToFront = true;

    // default options
    this.defaultOptions = {
      rtl: false,
      start: null,
      end: null,
      moment: moment,
      direction: 'horizontal', // 'horizontal' or 'vertical'
      moveable: true,
      zoomable: true,
      min: null,
      max: null,
      zoomMin: 10, // milliseconds
      zoomMax: 1000 * 60 * 60 * 24 * 365 * 10000 // milliseconds
    };
    this.options = util.extend({}, this.defaultOptions);
    this.props = {
      touch: {}
    };
    this.animationTimer = null;

    // drag listeners for dragging
    this.body.emitter.on('panstart', this._onDragStart.bind(this));
    this.body.emitter.on('panmove', this._onDrag.bind(this));
    this.body.emitter.on('panend', this._onDragEnd.bind(this));

    // mouse wheel for zooming
    this.body.emitter.on('mousewheel', this._onMouseWheel.bind(this));

    // pinch to zoom
    this.body.emitter.on('touch', this._onTouch.bind(this));
    this.body.emitter.on('pinch', this._onPinch.bind(this));

    // on click of rolling mode button
    this.body.dom.rollingModeBtn.addEventListener('click', this.startRolling.bind(this));

    this.setOptions(options);
  }

  Range.prototype = new Component();

  /**
   * Set options for the range controller
   * @param {Object} options      Available options:
   *                              {Number | Date | String} start  Start date for the range
   *                              {Number | Date | String} end    End date for the range
   *                              {Number} min    Minimum value for start
   *                              {Number} max    Maximum value for end
   *                              {Number} zoomMin    Set a minimum value for
   *                                                  (end - start).
   *                              {Number} zoomMax    Set a maximum value for
   *                                                  (end - start).
   *                              {Boolean} moveable Enable moving of the range
   *                                                 by dragging. True by default
   *                              {Boolean} zoomable Enable zooming of the range
   *                                                 by pinching/scrolling. True by default
   */
  Range.prototype.setOptions = function (options) {
    if (options) {
      // copy the options that we know
      var fields = ['animation', 'direction', 'min', 'max', 'zoomMin', 'zoomMax', 'moveable', 'zoomable', 'moment', 'activate', 'hiddenDates', 'zoomKey', 'rtl', 'showCurrentTime', 'rollMode', 'horizontalScroll'];
      util.selectiveExtend(fields, this.options, options);

      if (options.rollingMode) {
        this.startRolling();
      }
      if ('start' in options || 'end' in options) {
        // apply a new range. both start and end are optional
        this.setRange(options.start, options.end);
      }
    }
  };

  /**
   * Test whether direction has a valid value
   * @param {String} direction    'horizontal' or 'vertical'
   */
  function validateDirection(direction) {
    if (direction != 'horizontal' && direction != 'vertical') {
      throw new TypeError('Unknown direction "' + direction + '". ' + 'Choose "horizontal" or "vertical".');
    }
  }

  /**
   * Start auto refreshing the current time bar
   */
  Range.prototype.startRolling = function () {
    var me = this;

    function update() {
      me.stopRolling();
      me.rolling = true;

      var interval = me.end - me.start;
      var t = util.convert(new Date(), 'Date').valueOf();

      var start = t - interval / 2;
      var end = t + interval / 2;
      var animation = me.options && me.options.animation !== undefined ? me.options.animation : true;

      me.setRange(start, end, false);

      // determine interval to refresh
      var scale = me.conversion(me.body.domProps.center.width).scale;
      var interval = 1 / scale / 10;
      if (interval < 30) interval = 30;
      if (interval > 1000) interval = 1000;

      me.body.dom.rollingModeBtn.style.visibility = "hidden";
      // start a renderTimer to adjust for the new time
      me.currentTimeTimer = setTimeout(update, interval);
    }

    update();
  };

  /**
   * Stop auto refreshing the current time bar
   */
  Range.prototype.stopRolling = function () {
    if (this.currentTimeTimer !== undefined) {
      clearTimeout(this.currentTimeTimer);
      this.rolling = false;
      this.body.dom.rollingModeBtn.style.visibility = "visible";
    }
  };

  /**
   * Set a new start and end range
   * @param {Date | Number | String} [start]
   * @param {Date | Number | String} [end]
   * @param {boolean | {duration: number, easingFunction: string}} [animation=false]
   *                                    If true (default), the range is animated
   *                                    smoothly to the new window. An object can be
   *                                    provided to specify duration and easing function.
   *                                    Default duration is 500 ms, and default easing
   *                                    function is 'easeInOutQuad'.
   * @param {Boolean} [byUser=false]
   *
   */
  Range.prototype.setRange = function (start, end, animation, byUser, event) {
    if (byUser !== true) {
      byUser = false;
    }
    var finalStart = start != undefined ? util.convert(start, 'Date').valueOf() : null;
    var finalEnd = end != undefined ? util.convert(end, 'Date').valueOf() : null;
    this._cancelAnimation();

    if (animation) {
      // true or an Object
      var me = this;
      var initStart = this.start;
      var initEnd = this.end;
      var duration = (typeof animation === 'undefined' ? 'undefined' : (0, _typeof3['default'])(animation)) === 'object' && 'duration' in animation ? animation.duration : 500;
      var easingName = (typeof animation === 'undefined' ? 'undefined' : (0, _typeof3['default'])(animation)) === 'object' && 'easingFunction' in animation ? animation.easingFunction : 'easeInOutQuad';
      var easingFunction = util.easingFunctions[easingName];
      if (!easingFunction) {
        throw new Error('Unknown easing function ' + (0, _stringify2['default'])(easingName) + '. ' + 'Choose from: ' + (0, _keys2['default'])(util.easingFunctions).join(', '));
      }

      var initTime = new Date().valueOf();
      var anyChanged = false;

      var next = function next() {
        if (!me.props.touch.dragging) {
          var now = new Date().valueOf();
          var time = now - initTime;
          var ease = easingFunction(time / duration);
          var done = time > duration;
          var s = done || finalStart === null ? finalStart : initStart + (finalStart - initStart) * ease;
          var e = done || finalEnd === null ? finalEnd : initEnd + (finalEnd - initEnd) * ease;

          changed = me._applyRange(s, e);
          DateUtil.updateHiddenDates(me.options.moment, me.body, me.options.hiddenDates);
          anyChanged = anyChanged || changed;

          var params = {
            start: new Date(me.start),
            end: new Date(me.end),
            byUser: byUser,
            event: util.elementsCensor(event)
          };

          if (changed) {
            me.body.emitter.emit('rangechange', params);
          }

          if (done) {
            if (anyChanged) {
              me.body.emitter.emit('rangechanged', params);
            }
          } else {
            // animate with as high as possible frame rate, leave 20 ms in between
            // each to prevent the browser from blocking
            me.animationTimer = setTimeout(next, 20);
          }
        }
      };

      return next();
    } else {
      var changed = this._applyRange(finalStart, finalEnd);
      DateUtil.updateHiddenDates(this.options.moment, this.body, this.options.hiddenDates);
      if (changed) {
        var params = {
          start: new Date(this.start),
          end: new Date(this.end),
          byUser: byUser,
          event: util.elementsCensor(event)
        };
        this.body.emitter.emit('rangechange', params);
        this.body.emitter.emit('rangechanged', params);
      }
    }
  };

  /**
   * Get the number of milliseconds per pixel.
   */
  Range.prototype.getMillisecondsPerPixel = function () {
    return (this.end - this.start) / this.body.dom.center.clientWidth;
  };

  /**
   * Stop an animation
   * @private
   */
  Range.prototype._cancelAnimation = function () {
    if (this.animationTimer) {
      clearTimeout(this.animationTimer);
      this.animationTimer = null;
    }
  };

  /**
   * Set a new start and end range. This method is the same as setRange, but
   * does not trigger a range change and range changed event, and it returns
   * true when the range is changed
   * @param {Number} [start]
   * @param {Number} [end]
   * @return {Boolean} changed
   * @private
   */
  Range.prototype._applyRange = function (start, end) {
    var newStart = start != null ? util.convert(start, 'Date').valueOf() : this.start,
        newEnd = end != null ? util.convert(end, 'Date').valueOf() : this.end,
        max = this.options.max != null ? util.convert(this.options.max, 'Date').valueOf() : null,
        min = this.options.min != null ? util.convert(this.options.min, 'Date').valueOf() : null,
        diff;

    // check for valid number
    if (isNaN(newStart) || newStart === null) {
      throw new Error('Invalid start "' + start + '"');
    }
    if (isNaN(newEnd) || newEnd === null) {
      throw new Error('Invalid end "' + end + '"');
    }

    // prevent end < start
    if (newEnd < newStart) {
      newEnd = newStart;
    }

    // prevent start < min
    if (min !== null) {
      if (newStart < min) {
        diff = min - newStart;
        newStart += diff;
        newEnd += diff;

        // prevent end > max
        if (max != null) {
          if (newEnd > max) {
            newEnd = max;
          }
        }
      }
    }

    // prevent end > max
    if (max !== null) {
      if (newEnd > max) {
        diff = newEnd - max;
        newStart -= diff;
        newEnd -= diff;

        // prevent start < min
        if (min != null) {
          if (newStart < min) {
            newStart = min;
          }
        }
      }
    }

    // prevent (end-start) < zoomMin
    if (this.options.zoomMin !== null) {
      var zoomMin = parseFloat(this.options.zoomMin);
      if (zoomMin < 0) {
        zoomMin = 0;
      }
      if (newEnd - newStart < zoomMin) {
        // compensate for a scale of 0.5 ms
        var compensation = 0.5;
        if (this.end - this.start === zoomMin && newStart >= this.start - compensation && newEnd <= this.end) {
          // ignore this action, we are already zoomed to the minimum
          newStart = this.start;
          newEnd = this.end;
        } else {
          // zoom to the minimum
          diff = zoomMin - (newEnd - newStart);
          newStart -= diff / 2;
          newEnd += diff / 2;
        }
      }
    }

    // prevent (end-start) > zoomMax
    if (this.options.zoomMax !== null) {
      var zoomMax = parseFloat(this.options.zoomMax);
      if (zoomMax < 0) {
        zoomMax = 0;
      }

      if (newEnd - newStart > zoomMax) {
        if (this.end - this.start === zoomMax && newStart < this.start && newEnd > this.end) {
          // ignore this action, we are already zoomed to the maximum
          newStart = this.start;
          newEnd = this.end;
        } else {
          // zoom to the maximum
          diff = newEnd - newStart - zoomMax;
          newStart += diff / 2;
          newEnd -= diff / 2;
        }
      }
    }

    var changed = this.start != newStart || this.end != newEnd;

    // if the new range does NOT overlap with the old range, emit checkRangedItems to avoid not showing ranged items (ranged meaning has end time, not necessarily of type Range)
    if (!(newStart >= this.start && newStart <= this.end || newEnd >= this.start && newEnd <= this.end) && !(this.start >= newStart && this.start <= newEnd || this.end >= newStart && this.end <= newEnd)) {
      this.body.emitter.emit('checkRangedItems');
    }

    this.start = newStart;
    this.end = newEnd;
    return changed;
  };

  /**
   * Retrieve the current range.
   * @return {Object} An object with start and end properties
   */
  Range.prototype.getRange = function () {
    return {
      start: this.start,
      end: this.end
    };
  };

  /**
   * Calculate the conversion offset and scale for current range, based on
   * the provided width
   * @param {Number} width
   * @returns {{offset: number, scale: number}} conversion
   */
  Range.prototype.conversion = function (width, totalHidden) {
    return Range.conversion(this.start, this.end, width, totalHidden);
  };

  /**
   * Static method to calculate the conversion offset and scale for a range,
   * based on the provided start, end, and width
   * @param {Number} start
   * @param {Number} end
   * @param {Number} width
   * @returns {{offset: number, scale: number}} conversion
   */
  Range.conversion = function (start, end, width, totalHidden) {
    if (totalHidden === undefined) {
      totalHidden = 0;
    }
    if (width != 0 && end - start != 0) {
      return {
        offset: start,
        scale: width / (end - start - totalHidden)
      };
    } else {
      return {
        offset: 0,
        scale: 1
      };
    }
  };

  /**
   * Start dragging horizontally or vertically
   * @param {Event} event
   * @private
   */
  Range.prototype._onDragStart = function (event) {
    this.deltaDifference = 0;
    this.previousDelta = 0;

    // only allow dragging when configured as movable
    if (!this.options.moveable) return;

    // only start dragging when the mouse is inside the current range
    if (!this._isInsideRange(event)) return;

    // refuse to drag when we where pinching to prevent the timeline make a jump
    // when releasing the fingers in opposite order from the touch screen
    if (!this.props.touch.allowDragging) return;

    this.stopRolling();

    this.props.touch.start = this.start;
    this.props.touch.end = this.end;
    this.props.touch.dragging = true;

    if (this.body.dom.root) {
      this.body.dom.root.style.cursor = 'move';
    }
  };

  /**
   * Perform dragging operation
   * @param {Event} event
   * @private
   */
  Range.prototype._onDrag = function (event) {
    if (!event) return;

    if (!this.props.touch.dragging) return;

    // only allow dragging when configured as movable
    if (!this.options.moveable) return;

    // TODO: this may be redundant in hammerjs2
    // refuse to drag when we where pinching to prevent the timeline make a jump
    // when releasing the fingers in opposite order from the touch screen
    if (!this.props.touch.allowDragging) return;

    var direction = this.options.direction;
    validateDirection(direction);
    var delta = direction == 'horizontal' ? event.deltaX : event.deltaY;
    delta -= this.deltaDifference;
    var interval = this.props.touch.end - this.props.touch.start;

    // normalize dragging speed if cutout is in between.
    var duration = DateUtil.getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
    interval -= duration;

    var width = direction == 'horizontal' ? this.body.domProps.center.width : this.body.domProps.center.height;

    if (this.options.rtl) {
      var diffRange = delta / width * interval;
    } else {
      var diffRange = -delta / width * interval;
    }

    var newStart = this.props.touch.start + diffRange;
    var newEnd = this.props.touch.end + diffRange;

    // snapping times away from hidden zones
    var safeStart = DateUtil.snapAwayFromHidden(this.body.hiddenDates, newStart, this.previousDelta - delta, true);
    var safeEnd = DateUtil.snapAwayFromHidden(this.body.hiddenDates, newEnd, this.previousDelta - delta, true);
    if (safeStart != newStart || safeEnd != newEnd) {
      this.deltaDifference += delta;
      this.props.touch.start = safeStart;
      this.props.touch.end = safeEnd;
      this._onDrag(event);
      return;
    }

    this.previousDelta = delta;
    this._applyRange(newStart, newEnd);

    var startDate = new Date(this.start);
    var endDate = new Date(this.end);

    // fire a rangechange event
    this.body.emitter.emit('rangechange', {
      start: startDate,
      end: endDate,
      byUser: true,
      event: util.elementsCensor(event)
    });

    // fire a panmove event
    this.body.emitter.emit('panmove');
  };

  /**
   * Stop dragging operation
   * @param {event} event
   * @private
   */
  Range.prototype._onDragEnd = function (event) {
    if (!this.props.touch.dragging) return;

    // only allow dragging when configured as movable
    if (!this.options.moveable) return;

    // TODO: this may be redundant in hammerjs2
    // refuse to drag when we where pinching to prevent the timeline make a jump
    // when releasing the fingers in opposite order from the touch screen
    if (!this.props.touch.allowDragging) return;

    this.props.touch.dragging = false;
    if (this.body.dom.root) {
      this.body.dom.root.style.cursor = 'auto';
    }

    // fire a rangechanged event
    this.body.emitter.emit('rangechanged', {
      start: new Date(this.start),
      end: new Date(this.end),
      byUser: true,
      event: util.elementsCensor(event)
    });
  };

  /**
   * Event handler for mouse wheel event, used to zoom
   * Code from http://adomas.org/javascript-mouse-wheel/
   * @param {Event} event
   * @private
   */
  Range.prototype._onMouseWheel = function (event) {
    // retrieve delta
    var delta = 0;
    if (event.wheelDelta) {
      /* IE/Opera. */
      delta = event.wheelDelta / 120;
    } else if (event.detail) {
      /* Mozilla case. */
      // In Mozilla, sign of delta is different than in IE.
      // Also, delta is multiple of 3.
      delta = -event.detail / 3;
    }

    // don't allow zoom when the according key is pressed and the zoomKey option or not zoomable but movable
    if (this.options.zoomKey && !event[this.options.zoomKey] && this.options.zoomable || !this.options.zoomable && this.options.moveable) {
      if (this.options.horizontalScroll) {
        // Prevent default actions caused by mouse wheel
        // (else the page and timeline both scroll)
        event.preventDefault();

        // calculate a single scroll jump relative to the range scale
        var diff = delta * (this.end - this.start) / 20;
        // calculate new start and end
        var newStart = this.start - diff;
        var newEnd = this.end - diff;

        this.setRange(newStart, newEnd, false, true, event);
      }
      return;
    }

    // only allow zooming when configured as zoomable and moveable
    if (!(this.options.zoomable && this.options.moveable)) return;

    // only zoom when the mouse is inside the current range
    if (!this._isInsideRange(event)) return;

    // If delta is nonzero, handle it.
    // Basically, delta is now positive if wheel was scrolled up,
    // and negative, if wheel was scrolled down.
    if (delta) {
      // perform the zoom action. Delta is normally 1 or -1

      // adjust a negative delta such that zooming in with delta 0.1
      // equals zooming out with a delta -0.1
      var scale;
      if (delta < 0) {
        scale = 1 - delta / 5;
      } else {
        scale = 1 / (1 + delta / 5);
      }

      // calculate center, the date to zoom around
      var pointerDate;
      if (this.rolling) {
        pointerDate = (this.start + this.end) / 2;
      } else {
        var pointer = this.getPointer({ x: event.clientX, y: event.clientY }, this.body.dom.center);
        pointerDate = this._pointerToDate(pointer);
      }
      this.zoom(scale, pointerDate, delta, event);

      // Prevent default actions caused by mouse wheel
      // (else the page and timeline both scroll)
      event.preventDefault();
    }
  };

  /**
   * Start of a touch gesture
   * @private
   */
  Range.prototype._onTouch = function (event) {
    this.props.touch.start = this.start;
    this.props.touch.end = this.end;
    this.props.touch.allowDragging = true;
    this.props.touch.center = null;
    this.scaleOffset = 0;
    this.deltaDifference = 0;
  };

  /**
   * Handle pinch event
   * @param {Event} event
   * @private
   */
  Range.prototype._onPinch = function (event) {
    // only allow zooming when configured as zoomable and moveable
    if (!(this.options.zoomable && this.options.moveable)) return;

    this.props.touch.allowDragging = false;

    if (!this.props.touch.center) {
      this.props.touch.center = this.getPointer(event.center, this.body.dom.center);
    }

    this.stopRolling();

    var scale = 1 / (event.scale + this.scaleOffset);
    var centerDate = this._pointerToDate(this.props.touch.center);

    var hiddenDuration = DateUtil.getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
    var hiddenDurationBefore = DateUtil.getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this, centerDate);
    var hiddenDurationAfter = hiddenDuration - hiddenDurationBefore;

    // calculate new start and end
    var newStart = centerDate - hiddenDurationBefore + (this.props.touch.start - (centerDate - hiddenDurationBefore)) * scale;
    var newEnd = centerDate + hiddenDurationAfter + (this.props.touch.end - (centerDate + hiddenDurationAfter)) * scale;

    // snapping times away from hidden zones
    this.startToFront = 1 - scale <= 0; // used to do the right auto correction with periodic hidden times
    this.endToFront = scale - 1 <= 0; // used to do the right auto correction with periodic hidden times

    var safeStart = DateUtil.snapAwayFromHidden(this.body.hiddenDates, newStart, 1 - scale, true);
    var safeEnd = DateUtil.snapAwayFromHidden(this.body.hiddenDates, newEnd, scale - 1, true);
    if (safeStart != newStart || safeEnd != newEnd) {
      this.props.touch.start = safeStart;
      this.props.touch.end = safeEnd;
      this.scaleOffset = 1 - event.scale;
      newStart = safeStart;
      newEnd = safeEnd;
    }

    this.setRange(newStart, newEnd, false, true, event);

    this.startToFront = false; // revert to default
    this.endToFront = true; // revert to default
  };

  /**
   * Test whether the mouse from a mouse event is inside the visible window,
   * between the current start and end date
   * @param {Object} event
   * @return {boolean} Returns true when inside the visible window
   * @private
   */
  Range.prototype._isInsideRange = function (event) {
    // calculate the time where the mouse is, check whether inside
    // and no scroll action should happen.
    var clientX = event.center ? event.center.x : event.clientX;
    if (this.options.rtl) {
      var x = clientX - util.getAbsoluteLeft(this.body.dom.centerContainer);
    } else {
      var x = util.getAbsoluteRight(this.body.dom.centerContainer) - clientX;
    }
    var time = this.body.util.toTime(x);

    return time >= this.start && time <= this.end;
  };

  /**
   * Helper function to calculate the center date for zooming
   * @param {{x: Number, y: Number}} pointer
   * @return {number} date
   * @private
   */
  Range.prototype._pointerToDate = function (pointer) {
    var conversion;
    var direction = this.options.direction;

    validateDirection(direction);

    if (direction == 'horizontal') {
      return this.body.util.toTime(pointer.x).valueOf();
    } else {
      var height = this.body.domProps.center.height;
      conversion = this.conversion(height);
      return pointer.y / conversion.scale + conversion.offset;
    }
  };

  /**
   * Get the pointer location relative to the location of the dom element
   * @param {{x: Number, y: Number}} touch
   * @param {Element} element   HTML DOM element
   * @return {{x: Number, y: Number}} pointer
   * @private
   */
  Range.prototype.getPointer = function (touch, element) {
    if (this.options.rtl) {
      return {
        x: util.getAbsoluteRight(element) - touch.x,
        y: touch.y - util.getAbsoluteTop(element)
      };
    } else {
      return {
        x: touch.x - util.getAbsoluteLeft(element),
        y: touch.y - util.getAbsoluteTop(element)
      };
    }
  };

  /**
   * Zoom the range the given scale in or out. Start and end date will
   * be adjusted, and the timeline will be redrawn. You can optionally give a
   * date around which to zoom.
   * For example, try scale = 0.9 or 1.1
   * @param {Number} scale      Scaling factor. Values above 1 will zoom out,
   *                            values below 1 will zoom in.
   * @param {Number} [center]   Value representing a date around which will
   *                            be zoomed.
   */
  Range.prototype.zoom = function (scale, center, delta, event) {
    // if centerDate is not provided, take it half between start Date and end Date
    if (center == null) {
      center = (this.start + this.end) / 2;
    }

    var hiddenDuration = DateUtil.getHiddenDurationBetween(this.body.hiddenDates, this.start, this.end);
    var hiddenDurationBefore = DateUtil.getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this, center);
    var hiddenDurationAfter = hiddenDuration - hiddenDurationBefore;

    // calculate new start and end
    var newStart = center - hiddenDurationBefore + (this.start - (center - hiddenDurationBefore)) * scale;
    var newEnd = center + hiddenDurationAfter + (this.end - (center + hiddenDurationAfter)) * scale;

    // snapping times away from hidden zones
    this.startToFront = delta > 0 ? false : true; // used to do the right autocorrection with periodic hidden times
    this.endToFront = -delta > 0 ? false : true; // used to do the right autocorrection with periodic hidden times
    var safeStart = DateUtil.snapAwayFromHidden(this.body.hiddenDates, newStart, delta, true);
    var safeEnd = DateUtil.snapAwayFromHidden(this.body.hiddenDates, newEnd, -delta, true);
    if (safeStart != newStart || safeEnd != newEnd) {
      newStart = safeStart;
      newEnd = safeEnd;
    }

    this.setRange(newStart, newEnd, false, true, event);

    this.startToFront = false; // revert to default
    this.endToFront = true; // revert to default
  };

  /**
   * Move the range with a given delta to the left or right. Start and end
   * value will be adjusted. For example, try delta = 0.1 or -0.1
   * @param {Number}  delta     Moving amount. Positive value will move right,
   *                            negative value will move left
   */
  Range.prototype.move = function (delta) {
    // zoom start Date and end Date relative to the centerDate
    var diff = this.end - this.start;

    // apply new values
    var newStart = this.start + diff * delta;
    var newEnd = this.end + diff * delta;

    // TODO: reckon with min and max range

    this.start = newStart;
    this.end = newEnd;
  };

  /**
   * Move the range to a new center point
   * @param {Number} moveTo      New center point of the range
   */
  Range.prototype.moveTo = function (moveTo) {
    var center = (this.start + this.end) / 2;

    var diff = center - moveTo;

    // calculate new start and end
    var newStart = this.start - diff;
    var newEnd = this.end - diff;

    this.setRange(newStart, newEnd, false, true, event);
  };

  module.exports = Range;

/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var util = __webpack_require__(1);

  /**
   * Prototype for visual components
   * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} [body]
   * @param {Object} [options]
   */
  function Component(body, options) {
    this.options = null;
    this.props = null;
  }

  /**
   * Set options for the component. The new options will be merged into the
   * current options.
   * @param {Object} options
   */
  Component.prototype.setOptions = function (options) {
    if (options) {
      util.extend(this.options, options);
    }
  };

  /**
   * Repaint the component
   * @return {boolean} Returns true if the component is resized
   */
  Component.prototype.redraw = function () {
    // should be implemented by the component
    return false;
  };

  /**
   * Destroy the component. Cleanup DOM and event listeners
   */
  Component.prototype.destroy = function () {
    // should be implemented by the component
  };

  /**
   * Test whether the component is resized since the last time _isResized() was
   * called.
   * @return {Boolean} Returns true if the component is resized
   * @protected
   */
  Component.prototype._isResized = function () {
    var resized = this.props._previousWidth !== this.props.width || this.props._previousHeight !== this.props.height;

    this.props._previousWidth = this.props.width;
    this.props._previousHeight = this.props.height;

    return resized;
  };

  module.exports = Component;

/***/ },
/* 125 */
/***/ function(module, exports) {

  "use strict";

  /**
   * used in Core to convert the options into a volatile variable
   * 
   * @param {function} moment
   * @param {Object} body
   * @param {Array | Object} hiddenDates
   */
  exports.convertHiddenOptions = function (moment, body, hiddenDates) {
    if (hiddenDates && !Array.isArray(hiddenDates)) {
      return exports.convertHiddenOptions(moment, body, [hiddenDates]);
    }

    body.hiddenDates = [];
    if (hiddenDates) {
      if (Array.isArray(hiddenDates) == true) {
        for (var i = 0; i < hiddenDates.length; i++) {
          if (hiddenDates[i].repeat === undefined) {
            var dateItem = {};
            dateItem.start = moment(hiddenDates[i].start).toDate().valueOf();
            dateItem.end = moment(hiddenDates[i].end).toDate().valueOf();
            body.hiddenDates.push(dateItem);
          }
        }
        body.hiddenDates.sort(function (a, b) {
          return a.start - b.start;
        }); // sort by start time
      }
    }
  };

  /**
   * create new entrees for the repeating hidden dates
   * @param {function} moment
   * @param {Object} body
   * @param {Array | Object} hiddenDates
   */
  exports.updateHiddenDates = function (moment, body, hiddenDates) {
    if (hiddenDates && !Array.isArray(hiddenDates)) {
      return exports.updateHiddenDates(moment, body, [hiddenDates]);
    }

    if (hiddenDates && body.domProps.centerContainer.width !== undefined) {
      exports.convertHiddenOptions(moment, body, hiddenDates);

      var start = moment(body.range.start);
      var end = moment(body.range.end);

      var totalRange = body.range.end - body.range.start;
      var pixelTime = totalRange / body.domProps.centerContainer.width;

      for (var i = 0; i < hiddenDates.length; i++) {
        if (hiddenDates[i].repeat !== undefined) {
          var startDate = moment(hiddenDates[i].start);
          var endDate = moment(hiddenDates[i].end);

          if (startDate._d == "Invalid Date") {
            throw new Error("Supplied start date is not valid: " + hiddenDates[i].start);
          }
          if (endDate._d == "Invalid Date") {
            throw new Error("Supplied end date is not valid: " + hiddenDates[i].end);
          }

          var duration = endDate - startDate;
          if (duration >= 4 * pixelTime) {

            var offset = 0;
            var runUntil = end.clone();
            switch (hiddenDates[i].repeat) {
              case "daily":
                // case of time
                if (startDate.day() != endDate.day()) {
                  offset = 1;
                }
                startDate.dayOfYear(start.dayOfYear());
                startDate.year(start.year());
                startDate.subtract(7, 'days');

                endDate.dayOfYear(start.dayOfYear());
                endDate.year(start.year());
                endDate.subtract(7 - offset, 'days');

                runUntil.add(1, 'weeks');
                break;
              case "weekly":
                var dayOffset = endDate.diff(startDate, 'days');
                var day = startDate.day();

                // set the start date to the range.start
                startDate.date(start.date());
                startDate.month(start.month());
                startDate.year(start.year());
                endDate = startDate.clone();

                // force
                startDate.day(day);
                endDate.day(day);
                endDate.add(dayOffset, 'days');

                startDate.subtract(1, 'weeks');
                endDate.subtract(1, 'weeks');

                runUntil.add(1, 'weeks');
                break;
              case "monthly":
                if (startDate.month() != endDate.month()) {
                  offset = 1;
                }
                startDate.month(start.month());
                startDate.year(start.year());
                startDate.subtract(1, 'months');

                endDate.month(start.month());
                endDate.year(start.year());
                endDate.subtract(1, 'months');
                endDate.add(offset, 'months');

                runUntil.add(1, 'months');
                break;
              case "yearly":
                if (startDate.year() != endDate.year()) {
                  offset = 1;
                }
                startDate.year(start.year());
                startDate.subtract(1, 'years');
                endDate.year(start.year());
                endDate.subtract(1, 'years');
                endDate.add(offset, 'years');

                runUntil.add(1, 'years');
                break;
              default:
                console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:", hiddenDates[i].repeat);
                return;
            }
            while (startDate < runUntil) {
              body.hiddenDates.push({ start: startDate.valueOf(), end: endDate.valueOf() });
              switch (hiddenDates[i].repeat) {
                case "daily":
                  startDate.add(1, 'days');
                  endDate.add(1, 'days');
                  break;
                case "weekly":
                  startDate.add(1, 'weeks');
                  endDate.add(1, 'weeks');
                  break;
                case "monthly":
                  startDate.add(1, 'months');
                  endDate.add(1, 'months');
                  break;
                case "yearly":
                  startDate.add(1, 'y');
                  endDate.add(1, 'y');
                  break;
                default:
                  console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:", hiddenDates[i].repeat);
                  return;
              }
            }
            body.hiddenDates.push({ start: startDate.valueOf(), end: endDate.valueOf() });
          }
        }
      }
      // remove duplicates, merge where possible
      exports.removeDuplicates(body);
      // ensure the new positions are not on hidden dates
      var startHidden = exports.isHidden(body.range.start, body.hiddenDates);
      var endHidden = exports.isHidden(body.range.end, body.hiddenDates);
      var rangeStart = body.range.start;
      var rangeEnd = body.range.end;
      if (startHidden.hidden == true) {
        rangeStart = body.range.startToFront == true ? startHidden.startDate - 1 : startHidden.endDate + 1;
      }
      if (endHidden.hidden == true) {
        rangeEnd = body.range.endToFront == true ? endHidden.startDate - 1 : endHidden.endDate + 1;
      }
      if (startHidden.hidden == true || endHidden.hidden == true) {
        body.range._applyRange(rangeStart, rangeEnd);
      }
    }
  };

  /**
   * remove duplicates from the hidden dates list. Duplicates are evil. They mess everything up.
   * Scales with N^2
   * @param body
   */
  exports.removeDuplicates = function (body) {
    var hiddenDates = body.hiddenDates;
    var safeDates = [];
    for (var i = 0; i < hiddenDates.length; i++) {
      for (var j = 0; j < hiddenDates.length; j++) {
        if (i != j && hiddenDates[j].remove != true && hiddenDates[i].remove != true) {
          // j inside i
          if (hiddenDates[j].start >= hiddenDates[i].start && hiddenDates[j].end <= hiddenDates[i].end) {
            hiddenDates[j].remove = true;
          }
          // j start inside i
          else if (hiddenDates[j].start >= hiddenDates[i].start && hiddenDates[j].start <= hiddenDates[i].end) {
              hiddenDates[i].end = hiddenDates[j].end;
              hiddenDates[j].remove = true;
            }
            // j end inside i
            else if (hiddenDates[j].end >= hiddenDates[i].start && hiddenDates[j].end <= hiddenDates[i].end) {
                hiddenDates[i].start = hiddenDates[j].start;
                hiddenDates[j].remove = true;
              }
        }
      }
    }

    for (var i = 0; i < hiddenDates.length; i++) {
      if (hiddenDates[i].remove !== true) {
        safeDates.push(hiddenDates[i]);
      }
    }

    body.hiddenDates = safeDates;
    body.hiddenDates.sort(function (a, b) {
      return a.start - b.start;
    }); // sort by start time
  };

  exports.printDates = function (dates) {
    for (var i = 0; i < dates.length; i++) {
      console.log(i, new Date(dates[i].start), new Date(dates[i].end), dates[i].start, dates[i].end, dates[i].remove);
    }
  };

  /**
   * Used in TimeStep to avoid the hidden times.
   * @param {function} moment
   * @param {TimeStep} timeStep
   * @param previousTime
   */
  exports.stepOverHiddenDates = function (moment, timeStep, previousTime) {
    var stepInHidden = false;
    var currentValue = timeStep.current.valueOf();
    for (var i = 0; i < timeStep.hiddenDates.length; i++) {
      var startDate = timeStep.hiddenDates[i].start;
      var endDate = timeStep.hiddenDates[i].end;
      if (currentValue >= startDate && currentValue < endDate) {
        stepInHidden = true;
        break;
      }
    }

    if (stepInHidden == true && currentValue < timeStep._end.valueOf() && currentValue != previousTime) {
      var prevValue = moment(previousTime);
      var newValue = moment(endDate);
      //check if the next step should be major
      if (prevValue.year() != newValue.year()) {
        timeStep.switchedYear = true;
      } else if (prevValue.month() != newValue.month()) {
        timeStep.switchedMonth = true;
      } else if (prevValue.dayOfYear() != newValue.dayOfYear()) {
        timeStep.switchedDay = true;
      }

      timeStep.current = newValue;
    }
  };

  ///**
  // * Used in TimeStep to avoid the hidden times.
  // * @param timeStep
  // * @param previousTime
  // */
  //exports.checkFirstStep = function(timeStep) {
  //  var stepInHidden = false;
  //  var currentValue = timeStep.current.valueOf();
  //  for (var i = 0; i < timeStep.hiddenDates.length; i++) {
  //    var startDate = timeStep.hiddenDates[i].start;
  //    var endDate = timeStep.hiddenDates[i].end;
  //    if (currentValue >= startDate && currentValue < endDate) {
  //      stepInHidden = true;
  //      break;
  //    }
  //  }
  //
  //  if (stepInHidden == true && currentValue <= timeStep._end.valueOf()) {
  //    var newValue = moment(endDate);
  //    timeStep.current = newValue.toDate();
  //  }
  //};

  /**
   * replaces the Core toScreen methods
   * @param Core
   * @param time
   * @param width
   * @returns {number}
   */
  exports.toScreen = function (Core, time, width) {
    if (Core.body.hiddenDates.length == 0) {
      var conversion = Core.range.conversion(width);
      return (time.valueOf() - conversion.offset) * conversion.scale;
    } else {
      var hidden = exports.isHidden(time, Core.body.hiddenDates);
      if (hidden.hidden == true) {
        time = hidden.startDate;
      }

      var duration = exports.getHiddenDurationBetween(Core.body.hiddenDates, Core.range.start, Core.range.end);
      if (time < Core.range.start) {
        var conversion = Core.range.conversion(width, duration);
        var hiddenBeforeStart = exports.getHiddenDurationBeforeStart(Core.body.hiddenDates, time, conversion.offset);
        time = Core.options.moment(time).toDate().valueOf();
        time = time + hiddenBeforeStart;
        return -(conversion.offset - time.valueOf()) * conversion.scale;
      } else if (time > Core.range.end) {
        var rangeAfterEnd = { start: Core.range.start, end: time };
        time = exports.correctTimeForHidden(Core.options.moment, Core.body.hiddenDates, rangeAfterEnd, time);
        var conversion = Core.range.conversion(width, duration);
        return (time.valueOf() - conversion.offset) * conversion.scale;
      } else {
        time = exports.correctTimeForHidden(Core.options.moment, Core.body.hiddenDates, Core.range, time);
        var conversion = Core.range.conversion(width, duration);
        return (time.valueOf() - conversion.offset) * conversion.scale;
      }
    }
  };

  /**
   * Replaces the core toTime methods
   * @param body
   * @param range
   * @param x
   * @param width
   * @returns {Date}
   */
  exports.toTime = function (Core, x, width) {
    if (Core.body.hiddenDates.length == 0) {
      var conversion = Core.range.conversion(width);
      return new Date(x / conversion.scale + conversion.offset);
    } else {
      var hiddenDuration = exports.getHiddenDurationBetween(Core.body.hiddenDates, Core.range.start, Core.range.end);
      var totalDuration = Core.range.end - Core.range.start - hiddenDuration;
      var partialDuration = totalDuration * x / width;
      var accumulatedHiddenDuration = exports.getAccumulatedHiddenDuration(Core.body.hiddenDates, Core.range, partialDuration);

      var newTime = new Date(accumulatedHiddenDuration + partialDuration + Core.range.start);
      return newTime;
    }
  };

  /**
   * Support function
   *
   * @param hiddenDates
   * @param range
   * @returns {number}
   */
  exports.getHiddenDurationBetween = function (hiddenDates, start, end) {
    var duration = 0;
    for (var i = 0; i < hiddenDates.length; i++) {
      var startDate = hiddenDates[i].start;
      var endDate = hiddenDates[i].end;
      // if time after the cutout, and the
      if (startDate >= start && endDate < end) {
        duration += endDate - startDate;
      }
    }
    return duration;
  };

  /**
     * Support function
     *
     * @param hiddenDates
     * @param start
     * @param end
     * @returns {number}
     */
  exports.getHiddenDurationBeforeStart = function (hiddenDates, start, end) {
    var duration = 0;
    for (var i = 0; i < hiddenDates.length; i++) {
      var startDate = hiddenDates[i].start;
      var endDate = hiddenDates[i].end;

      if (startDate >= start && endDate <= end) {
        duration += endDate - startDate;
      }
    }
    return duration;
  };

  /**
   * Support function
   * @param moment
   * @param hiddenDates
   * @param range
   * @param time
   * @returns {{duration: number, time: *, offset: number}}
   */
  exports.correctTimeForHidden = function (moment, hiddenDates, range, time) {
    time = moment(time).toDate().valueOf();
    time -= exports.getHiddenDurationBefore(moment, hiddenDates, range, time);
    return time;
  };

  exports.getHiddenDurationBefore = function (moment, hiddenDates, range, time) {
    var timeOffset = 0;
    time = moment(time).toDate().valueOf();

    for (var i = 0; i < hiddenDates.length; i++) {
      var startDate = hiddenDates[i].start;
      var endDate = hiddenDates[i].end;
      // if time after the cutout, and the
      if (startDate >= range.start && endDate < range.end) {
        if (time >= endDate) {
          timeOffset += endDate - startDate;
        }
      }
    }
    return timeOffset;
  };

  /**
   * sum the duration from start to finish, including the hidden duration,
   * until the required amount has been reached, return the accumulated hidden duration
   * @param hiddenDates
   * @param range
   * @param time
   * @returns {{duration: number, time: *, offset: number}}
   */
  exports.getAccumulatedHiddenDuration = function (hiddenDates, range, requiredDuration) {
    var hiddenDuration = 0;
    var duration = 0;
    var previousPoint = range.start;
    //exports.printDates(hiddenDates)
    for (var i = 0; i < hiddenDates.length; i++) {
      var startDate = hiddenDates[i].start;
      var endDate = hiddenDates[i].end;
      // if time after the cutout, and the
      if (startDate >= range.start && endDate < range.end) {
        duration += startDate - previousPoint;
        previousPoint = endDate;
        if (duration >= requiredDuration) {
          break;
        } else {
          hiddenDuration += endDate - startDate;
        }
      }
    }

    return hiddenDuration;
  };

  /**
   * used to step over to either side of a hidden block. Correction is disabled on tablets, might be set to true
   * @param hiddenDates
   * @param time
   * @param direction
   * @param correctionEnabled
   * @returns {*}
   */
  exports.snapAwayFromHidden = function (hiddenDates, time, direction, correctionEnabled) {
    var isHidden = exports.isHidden(time, hiddenDates);
    if (isHidden.hidden == true) {
      if (direction < 0) {
        if (correctionEnabled == true) {
          return isHidden.startDate - (isHidden.endDate - time) - 1;
        } else {
          return isHidden.startDate - 1;
        }
      } else {
        if (correctionEnabled == true) {
          return isHidden.endDate + (time - isHidden.startDate) + 1;
        } else {
          return isHidden.endDate + 1;
        }
      }
    } else {
      return time;
    }
  };

  /**
   * Check if a time is hidden
   *
   * @param time
   * @param hiddenDates
   * @returns {{hidden: boolean, startDate: Window.start, endDate: *}}
   */
  exports.isHidden = function (time, hiddenDates) {
    for (var i = 0; i < hiddenDates.length; i++) {
      var startDate = hiddenDates[i].start;
      var endDate = hiddenDates[i].end;

      if (time >= startDate && time < endDate) {
        // if the start is entering a hidden zone
        return { hidden: true, startDate: startDate, endDate: endDate };
        break;
      }
    }
    return { hidden: false, startDate: startDate, endDate: endDate };
  };

/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _stringify = __webpack_require__(82);

  var _stringify2 = _interopRequireDefault(_stringify);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var Emitter = __webpack_require__(95);
  var Hammer = __webpack_require__(108);
  var hammerUtil = __webpack_require__(121);
  var util = __webpack_require__(1);
  var DataSet = __webpack_require__(91);
  var DataView = __webpack_require__(93);
  var Range = __webpack_require__(123);
  var ItemSet = __webpack_require__(127);
  var TimeAxis = __webpack_require__(138);
  var Activator = __webpack_require__(139);
  var DateUtil = __webpack_require__(125);
  var CustomTime = __webpack_require__(140);

  /**
   * Create a timeline visualization
   * @constructor
   */
  function Core() {}

  // turn Core into an event emitter
  Emitter(Core.prototype);

  /**
   * Create the main DOM for the Core: a root panel containing left, right,
   * top, bottom, content, and background panel.
   * @param {Element} container  The container element where the Core will
   *                             be attached.
   * @protected
   */
  Core.prototype._create = function (container) {
    this.dom = {};

    this.dom.container = container;

    this.dom.root = document.createElement('div');
    this.dom.background = document.createElement('div');
    this.dom.backgroundVertical = document.createElement('div');
    this.dom.backgroundHorizontal = document.createElement('div');
    this.dom.centerContainer = document.createElement('div');
    this.dom.leftContainer = document.createElement('div');
    this.dom.rightContainer = document.createElement('div');
    this.dom.center = document.createElement('div');
    this.dom.left = document.createElement('div');
    this.dom.right = document.createElement('div');
    this.dom.top = document.createElement('div');
    this.dom.bottom = document.createElement('div');
    this.dom.shadowTop = document.createElement('div');
    this.dom.shadowBottom = document.createElement('div');
    this.dom.shadowTopLeft = document.createElement('div');
    this.dom.shadowBottomLeft = document.createElement('div');
    this.dom.shadowTopRight = document.createElement('div');
    this.dom.shadowBottomRight = document.createElement('div');
    this.dom.rollingModeBtn = document.createElement('div');

    this.dom.root.className = 'vis-timeline';
    this.dom.background.className = 'vis-panel vis-background';
    this.dom.backgroundVertical.className = 'vis-panel vis-background vis-vertical';
    this.dom.backgroundHorizontal.className = 'vis-panel vis-background vis-horizontal';
    this.dom.centerContainer.className = 'vis-panel vis-center';
    this.dom.leftContainer.className = 'vis-panel vis-left';
    this.dom.rightContainer.className = 'vis-panel vis-right';
    this.dom.top.className = 'vis-panel vis-top';
    this.dom.bottom.className = 'vis-panel vis-bottom';
    this.dom.left.className = 'vis-content';
    this.dom.center.className = 'vis-content';
    this.dom.right.className = 'vis-content';
    this.dom.shadowTop.className = 'vis-shadow vis-top';
    this.dom.shadowBottom.className = 'vis-shadow vis-bottom';
    this.dom.shadowTopLeft.className = 'vis-shadow vis-top';
    this.dom.shadowBottomLeft.className = 'vis-shadow vis-bottom';
    this.dom.shadowTopRight.className = 'vis-shadow vis-top';
    this.dom.shadowBottomRight.className = 'vis-shadow vis-bottom';
    this.dom.rollingModeBtn.className = 'vis-rolling-mode-btn';

    this.dom.root.appendChild(this.dom.background);
    this.dom.root.appendChild(this.dom.backgroundVertical);
    this.dom.root.appendChild(this.dom.backgroundHorizontal);
    this.dom.root.appendChild(this.dom.centerContainer);
    this.dom.root.appendChild(this.dom.leftContainer);
    this.dom.root.appendChild(this.dom.rightContainer);
    this.dom.root.appendChild(this.dom.top);
    this.dom.root.appendChild(this.dom.bottom);
    this.dom.root.appendChild(this.dom.bottom);
    this.dom.root.appendChild(this.dom.rollingModeBtn);

    this.dom.centerContainer.appendChild(this.dom.center);
    this.dom.leftContainer.appendChild(this.dom.left);
    this.dom.rightContainer.appendChild(this.dom.right);
    this.dom.centerContainer.appendChild(this.dom.shadowTop);
    this.dom.centerContainer.appendChild(this.dom.shadowBottom);
    this.dom.leftContainer.appendChild(this.dom.shadowTopLeft);
    this.dom.leftContainer.appendChild(this.dom.shadowBottomLeft);
    this.dom.rightContainer.appendChild(this.dom.shadowTopRight);
    this.dom.rightContainer.appendChild(this.dom.shadowBottomRight);

    // size properties of each of the panels
    this.props = {
      root: {},
      background: {},
      centerContainer: {},
      leftContainer: {},
      rightContainer: {},
      center: {},
      left: {},
      right: {},
      top: {},
      bottom: {},
      border: {},
      scrollTop: 0,
      scrollTopMin: 0
    };

    this.on('rangechange', function () {
      if (this.initialDrawDone === true) {
        this._redraw();
      }
    }.bind(this));
    this.on('touch', this._onTouch.bind(this));
    this.on('panmove', this._onDrag.bind(this));

    var me = this;
    this._origRedraw = this._redraw.bind(this);
    this._redraw = util.throttle(this._origRedraw);

    this.on('_change', function (properties) {
      if (me.itemSet && me.itemSet.initialItemSetDrawn && properties && properties.queue == true) {
        me._redraw();
      } else {
        me._origRedraw();
      }
    });

    // create event listeners for all interesting events, these events will be
    // emitted via emitter
    this.hammer = new Hammer(this.dom.root);
    var pinchRecognizer = this.hammer.get('pinch').set({ enable: true });
    hammerUtil.disablePreventDefaultVertically(pinchRecognizer);
    this.hammer.get('pan').set({ threshold: 5, direction: Hammer.DIRECTION_HORIZONTAL });
    this.listeners = {};

    var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend'
    // TODO: cleanup
    //'touch', 'pinch',
    //'tap', 'doubletap', 'hold',
    //'dragstart', 'drag', 'dragend',
    //'mousewheel', 'DOMMouseScroll' // DOMMouseScroll is needed for Firefox
    ];
    events.forEach(function (type) {
      var listener = function listener(event) {
        if (me.isActive()) {
          me.emit(type, event);
        }
      };
      me.hammer.on(type, listener);
      me.listeners[type] = listener;
    });

    // emulate a touch event (emitted before the start of a pan, pinch, tap, or press)
    hammerUtil.onTouch(this.hammer, function (event) {
      me.emit('touch', event);
    }.bind(this));

    // emulate a release event (emitted after a pan, pinch, tap, or press)
    hammerUtil.onRelease(this.hammer, function (event) {
      me.emit('release', event);
    }.bind(this));

    function onMouseWheel(event) {
      if (this.isActive()) {
        this.emit('mousewheel', event);
      }

      // prevent scrolling if not specified explicitly or when horizontalScroll is true
      if (!this.options.verticalScroll || this.options.horizontalScroll) return;

      // prevent scrolling when zoomKey defined or activated
      if (!this.options.zoomKey || event[this.options.zoomKey]) return;

      // Prevent default actions caused by mouse wheel
      // (else the page and timeline both scroll)
      event.preventDefault();

      var delta = 0;
      if (event.wheelDelta) {
        /* IE/Opera. */
        delta = event.wheelDelta / 120;
      } else if (event.detail) {
        /* Mozilla case. */
        // In Mozilla, sign of delta is different than in IE.
        // Also, delta is multiple of 3.
        delta = -event.detail / 3;
      }

      var current = this.props.scrollTop;
      var adjusted = current + delta * 120;

      if (this.isActive()) {
        this._setScrollTop(adjusted);
        this._redraw();
        this.emit('scroll', event);
      }
    }

    if (this.dom.centerContainer.addEventListener) {
      // IE9, Chrome, Safari, Opera
      this.dom.centerContainer.addEventListener("mousewheel", onMouseWheel.bind(this), false);
      // Firefox
      this.dom.centerContainer.addEventListener("DOMMouseScroll", onMouseWheel.bind(this), false);
    } else {
      // IE 6/7/8
      this.dom.centerContainer.attachEvent("onmousewheel", onMouseWheel.bind(this));
    }

    function onMouseScrollSide(event) {
      if (!me.options.verticalScroll) return;
      event.preventDefault();
      if (me.isActive()) {
        var adjusted = -event.target.scrollTop;
        me._setScrollTop(adjusted);
        me._redraw();
        me.emit('scrollSide', event);
      }
    }

    this.dom.left.parentNode.addEventListener('scroll', onMouseScrollSide.bind(this));
    this.dom.right.parentNode.addEventListener('scroll', onMouseScrollSide.bind(this));

    var itemAddedToTimeline = false;

    function handleDragOver(event) {
      if (event.preventDefault) {
        event.preventDefault(); // Necessary. Allows us to drop.
      }

      // make sure your target is a vis element
      if (!event.target.className.indexOf("vis") > -1) return;

      // make sure only one item is added every time you're over the timeline
      if (itemAddedToTimeline) return;

      event.dataTransfer.dropEffect = 'move';
      itemAddedToTimeline = true;
      return false;
    }

    function handleDrop(event) {
      // return when dropping non-vis items 
      try {
        var itemData = JSON.parse(event.dataTransfer.getData("text"));
        if (!itemData.content) return;
      } catch (err) {
        return false;
      }

      itemAddedToTimeline = false;
      event.center = {
        x: event.clientX,
        y: event.clientY
      };
      me.itemSet._onAddItem(event);

      return false;
    }

    this.dom.center.addEventListener('dragover', handleDragOver.bind(this), false);
    this.dom.center.addEventListener('drop', handleDrop.bind(this), false);

    this.customTimes = [];

    // store state information needed for touch events
    this.touch = {};

    this.redrawCount = 0;
    this.initialDrawDone = false;

    // attach the root panel to the provided container
    if (!container) throw new Error('No container provided');
    container.appendChild(this.dom.root);
  };

  /**
   * Set options. Options will be passed to all components loaded in the Timeline.
   * @param {Object} [options]
   *                           {String} orientation
   *                              Vertical orientation for the Timeline,
   *                              can be 'bottom' (default) or 'top'.
   *                           {String | Number} width
   *                              Width for the timeline, a number in pixels or
   *                              a css string like '1000px' or '75%'. '100%' by default.
   *                           {String | Number} height
   *                              Fixed height for the Timeline, a number in pixels or
   *                              a css string like '400px' or '75%'. If undefined,
   *                              The Timeline will automatically size such that
   *                              its contents fit.
   *                           {String | Number} minHeight
   *                              Minimum height for the Timeline, a number in pixels or
   *                              a css string like '400px' or '75%'.
   *                           {String | Number} maxHeight
   *                              Maximum height for the Timeline, a number in pixels or
   *                              a css string like '400px' or '75%'.
   *                           {Number | Date | String} start
   *                              Start date for the visible window
   *                           {Number | Date | String} end
   *                              End date for the visible window
   */
  Core.prototype.setOptions = function (options) {
    if (options) {
      // copy the known options
      var fields = ['width', 'height', 'minHeight', 'maxHeight', 'autoResize', 'start', 'end', 'clickToUse', 'dataAttributes', 'hiddenDates', 'locale', 'locales', 'moment', 'rtl', 'zoomKey', 'horizontalScroll', 'verticalScroll'];
      util.selectiveExtend(fields, this.options, options);

      this.dom.rollingModeBtn.style.visibility = 'hidden';

      if (this.options.rtl) {
        this.dom.container.style.direction = "rtl";
        this.dom.backgroundVertical.className = 'vis-panel vis-background vis-vertical-rtl';
      }

      if (this.options.verticalScroll) {
        if (this.options.rtl) {
          this.dom.rightContainer.className = 'vis-panel vis-right vis-vertical-scroll';
        } else {
          this.dom.leftContainer.className = 'vis-panel vis-left vis-vertical-scroll';
        }
      }

      this.options.orientation = { item: undefined, axis: undefined };
      if ('orientation' in options) {
        if (typeof options.orientation === 'string') {
          this.options.orientation = {
            item: options.orientation,
            axis: options.orientation
          };
        } else if ((0, _typeof3['default'])(options.orientation) === 'object') {
          if ('item' in options.orientation) {
            this.options.orientation.item = options.orientation.item;
          }
          if ('axis' in options.orientation) {
            this.options.orientation.axis = options.orientation.axis;
          }
        }
      }

      if (this.options.orientation.axis === 'both') {
        if (!this.timeAxis2) {
          var timeAxis2 = this.timeAxis2 = new TimeAxis(this.body);
          timeAxis2.setOptions = function (options) {
            var _options = options ? util.extend({}, options) : {};
            _options.orientation = 'top'; // override the orientation option, always top
            TimeAxis.prototype.setOptions.call(timeAxis2, _options);
          };
          this.components.push(timeAxis2);
        }
      } else {
        if (this.timeAxis2) {
          var index = this.components.indexOf(this.timeAxis2);
          if (index !== -1) {
            this.components.splice(index, 1);
          }
          this.timeAxis2.destroy();
          this.timeAxis2 = null;
        }
      }

      // if the graph2d's drawPoints is a function delegate the callback to the onRender property
      if (typeof options.drawPoints == 'function') {
        options.drawPoints = {
          onRender: options.drawPoints
        };
      }

      if ('hiddenDates' in this.options) {
        DateUtil.convertHiddenOptions(this.options.moment, this.body, this.options.hiddenDates);
      }

      if ('clickToUse' in options) {
        if (options.clickToUse) {
          if (!this.activator) {
            this.activator = new Activator(this.dom.root);
          }
        } else {
          if (this.activator) {
            this.activator.destroy();
            delete this.activator;
          }
        }
      }

      if ('showCustomTime' in options) {
        throw new Error('Option `showCustomTime` is deprecated. Create a custom time bar via timeline.addCustomTime(time [, id])');
      }

      // enable/disable autoResize
      this._initAutoResize();
    }

    // propagate options to all components
    this.components.forEach(function (component) {
      return component.setOptions(options);
    });

    // enable/disable configure
    if ('configure' in options) {
      if (!this.configurator) {
        this.configurator = this._createConfigurator();
      }

      this.configurator.setOptions(options.configure);

      // collect the settings of all components, and pass them to the configuration system
      var appliedOptions = util.deepExtend({}, this.options);
      this.components.forEach(function (component) {
        util.deepExtend(appliedOptions, component.options);
      });
      this.configurator.setModuleOptions({ global: appliedOptions });
    }

    this._redraw();
  };

  /**
   * Returns true when the Timeline is active.
   * @returns {boolean}
   */
  Core.prototype.isActive = function () {
    return !this.activator || this.activator.active;
  };

  /**
   * Destroy the Core, clean up all DOM elements and event listeners.
   */
  Core.prototype.destroy = function () {
    // unbind datasets
    this.setItems(null);
    this.setGroups(null);

    // remove all event listeners
    this.off();

    // stop checking for changed size
    this._stopAutoResize();

    // remove from DOM
    if (this.dom.root.parentNode) {
      this.dom.root.parentNode.removeChild(this.dom.root);
    }
    this.dom = null;

    // remove Activator
    if (this.activator) {
      this.activator.destroy();
      delete this.activator;
    }

    // cleanup hammer touch events
    for (var event in this.listeners) {
      if (this.listeners.hasOwnProperty(event)) {
        delete this.listeners[event];
      }
    }
    this.listeners = null;
    this.hammer = null;

    // give all components the opportunity to cleanup
    this.components.forEach(function (component) {
      return component.destroy();
    });

    this.body = null;
  };

  /**
   * Set a custom time bar
   * @param {Date} time
   * @param {number} [id=undefined] Optional id of the custom time bar to be adjusted.
   */
  Core.prototype.setCustomTime = function (time, id) {
    var customTimes = this.customTimes.filter(function (component) {
      return id === component.options.id;
    });

    if (customTimes.length === 0) {
      throw new Error('No custom time bar found with id ' + (0, _stringify2['default'])(id));
    }

    if (customTimes.length > 0) {
      customTimes[0].setCustomTime(time);
    }
  };

  /**
   * Retrieve the current custom time.
   * @param {number} [id=undefined]    Id of the custom time bar.
   * @return {Date | undefined} customTime
   */
  Core.prototype.getCustomTime = function (id) {
    var customTimes = this.customTimes.filter(function (component) {
      return component.options.id === id;
    });

    if (customTimes.length === 0) {
      throw new Error('No custom time bar found with id ' + (0, _stringify2['default'])(id));
    }
    return customTimes[0].getCustomTime();
  };

  /**
   * Set a custom title for the custom time bar.
   * @param {String} [title] Custom title
   * @param {number} [id=undefined]    Id of the custom time bar.
   */
  Core.prototype.setCustomTimeTitle = function (title, id) {
    var customTimes = this.customTimes.filter(function (component) {
      return component.options.id === id;
    });

    if (customTimes.length === 0) {
      throw new Error('No custom time bar found with id ' + (0, _stringify2['default'])(id));
    }
    if (customTimes.length > 0) {
      return customTimes[0].setCustomTitle(title);
    }
  };

  /**
   * Retrieve meta information from an event.
   * Should be overridden by classes extending Core
   * @param {Event} event
   * @return {Object} An object with related information.
   */
  Core.prototype.getEventProperties = function (event) {
    return { event: event };
  };

  /**
   * Add custom vertical bar
   * @param {Date | String | Number} [time]  A Date, unix timestamp, or
   *                                         ISO date string. Time point where
   *                                         the new bar should be placed.
   *                                         If not provided, `new Date()` will
   *                                         be used.
   * @param {Number | String} [id=undefined] Id of the new bar. Optional
   * @return {Number | String}               Returns the id of the new bar
   */
  Core.prototype.addCustomTime = function (time, id) {
    var timestamp = time !== undefined ? util.convert(time, 'Date').valueOf() : new Date();

    var exists = this.customTimes.some(function (customTime) {
      return customTime.options.id === id;
    });
    if (exists) {
      throw new Error('A custom time with id ' + (0, _stringify2['default'])(id) + ' already exists');
    }

    var customTime = new CustomTime(this.body, util.extend({}, this.options, {
      time: timestamp,
      id: id
    }));

    this.customTimes.push(customTime);
    this.components.push(customTime);
    this._redraw();

    return id;
  };

  /**
   * Remove previously added custom bar
   * @param {int} id ID of the custom bar to be removed
   * @return {boolean} True if the bar exists and is removed, false otherwise
   */
  Core.prototype.removeCustomTime = function (id) {
    var customTimes = this.customTimes.filter(function (bar) {
      return bar.options.id === id;
    });

    if (customTimes.length === 0) {
      throw new Error('No custom time bar found with id ' + (0, _stringify2['default'])(id));
    }

    customTimes.forEach(function (customTime) {
      this.customTimes.splice(this.customTimes.indexOf(customTime), 1);
      this.components.splice(this.components.indexOf(customTime), 1);
      customTime.destroy();
    }.bind(this));
  };

  /**
   * Get the id's of the currently visible items.
   * @returns {Array} The ids of the visible items
   */
  Core.prototype.getVisibleItems = function () {
    return this.itemSet && this.itemSet.getVisibleItems() || [];
  };

  /**
   * Set Core window such that it fits all items
   * @param {Object} [options]  Available options:
   *                                `animation: boolean | {duration: number, easingFunction: string}`
   *                                    If true (default), the range is animated
   *                                    smoothly to the new window. An object can be
   *                                    provided to specify duration and easing function.
   *                                    Default duration is 500 ms, and default easing
   *                                    function is 'easeInOutQuad'.
   */
  Core.prototype.fit = function (options) {
    var range = this.getDataRange();

    // skip range set if there is no min and max date
    if (range.min === null && range.max === null) {
      return;
    }

    // apply a margin of 1% left and right of the data
    var interval = range.max - range.min;
    var min = new Date(range.min.valueOf() - interval * 0.01);
    var max = new Date(range.max.valueOf() + interval * 0.01);
    var animation = options && options.animation !== undefined ? options.animation : true;
    this.range.setRange(min, max, animation);
  };

  /**
   * Calculate the data range of the items start and end dates
   * @returns {{min: Date | null, max: Date | null}}
   * @protected
   */
  Core.prototype.getDataRange = function () {
    // must be implemented by Timeline and Graph2d
    throw new Error('Cannot invoke abstract method getDataRange');
  };

  /**
   * Set the visible window. Both parameters are optional, you can change only
   * start or only end. Syntax:
   *
   *     TimeLine.setWindow(start, end)
   *     TimeLine.setWindow(start, end, options)
   *     TimeLine.setWindow(range)
   *
   * Where start and end can be a Date, number, or string, and range is an
   * object with properties start and end.
   *
   * @param {Date | Number | String | Object} [start] Start date of visible window
   * @param {Date | Number | String} [end]            End date of visible window
   * @param {Object} [options]  Available options:
   *                                `animation: boolean | {duration: number, easingFunction: string}`
   *                                    If true (default), the range is animated
   *                                    smoothly to the new window. An object can be
   *                                    provided to specify duration and easing function.
   *                                    Default duration is 500 ms, and default easing
   *                                    function is 'easeInOutQuad'.
   */
  Core.prototype.setWindow = function (start, end, options) {
    var animation;
    if (arguments.length == 1) {
      var range = arguments[0];
      animation = range.animation !== undefined ? range.animation : true;
      this.range.setRange(range.start, range.end, animation);
    } else {
      animation = options && options.animation !== undefined ? options.animation : true;
      this.range.setRange(start, end, animation);
    }
  };

  /**
   * Move the window such that given time is centered on screen.
   * @param {Date | Number | String} time
   * @param {Object} [options]  Available options:
   *                                `animation: boolean | {duration: number, easingFunction: string}`
   *                                    If true (default), the range is animated
   *                                    smoothly to the new window. An object can be
   *                                    provided to specify duration and easing function.
   *                                    Default duration is 500 ms, and default easing
   *                                    function is 'easeInOutQuad'.
   */
  Core.prototype.moveTo = function (time, options) {
    var interval = this.range.end - this.range.start;
    var t = util.convert(time, 'Date').valueOf();

    var start = t - interval / 2;
    var end = t + interval / 2;
    var animation = options && options.animation !== undefined ? options.animation : true;

    this.range.setRange(start, end, animation);
  };

  /**
   * Get the visible window
   * @return {{start: Date, end: Date}}   Visible range
   */
  Core.prototype.getWindow = function () {
    var range = this.range.getRange();
    return {
      start: new Date(range.start),
      end: new Date(range.end)
    };
  };

  /**
   * Zoom in the window such that given time is centered on screen.
   * @param {Number} percentage - must be between [0..1]
   */
  Core.prototype.zoomIn = function (percentage) {
    if (!percentage || percentage < 0 || percentage > 1) return;
    var range = this.getWindow();
    var start = range.start.valueOf();
    var end = range.end.valueOf();
    var interval = end - start;
    var newInterval = interval / (1 + percentage);
    var distance = (interval - newInterval) / 2;
    var newStart = start + distance;
    var newEnd = end - distance;

    this.setWindow({
      start: newStart,
      end: newEnd
    });
  };

  /**
   * Zoom out the window such that given time is centered on screen.
   * @param {Number} percentage - must be between [0..1]
   */
  Core.prototype.zoomOut = function (percentage) {
    if (!percentage || percentage < 0 || percentage > 1) return;
    var range = this.getWindow();
    var start = range.start.valueOf();
    var end = range.end.valueOf();
    var interval = end - start;
    var newStart = start - interval * percentage / 2;
    var newEnd = end + interval * percentage / 2;

    this.setWindow({
      start: newStart,
      end: newEnd
    });
  };

  /**
   * Force a redraw. Can be overridden by implementations of Core
   *
   * Note: this function will be overridden on construction with a trottled version
   */
  Core.prototype.redraw = function () {
    this._redraw();
  };

  /**
   * Redraw for internal use. Redraws all components. See also the public
   * method redraw.
   * @protected
   */
  Core.prototype._redraw = function () {
    this.redrawCount++;
    var resized = false;
    var options = this.options;
    var props = this.props;
    var dom = this.dom;

    if (!dom || !dom.container || dom.root.offsetWidth == 0) return; // when destroyed, or invisible

    DateUtil.updateHiddenDates(this.options.moment, this.body, this.options.hiddenDates);

    // update class names
    if (options.orientation == 'top') {
      util.addClassName(dom.root, 'vis-top');
      util.removeClassName(dom.root, 'vis-bottom');
    } else {
      util.removeClassName(dom.root, 'vis-top');
      util.addClassName(dom.root, 'vis-bottom');
    }

    // update root width and height options
    dom.root.style.maxHeight = util.option.asSize(options.maxHeight, '');
    dom.root.style.minHeight = util.option.asSize(options.minHeight, '');
    dom.root.style.width = util.option.asSize(options.width, '');

    // calculate border widths
    props.border.left = (dom.centerContainer.offsetWidth - dom.centerContainer.clientWidth) / 2;
    props.border.right = props.border.left;
    props.border.top = (dom.centerContainer.offsetHeight - dom.centerContainer.clientHeight) / 2;
    props.border.bottom = props.border.top;
    props.borderRootHeight = dom.root.offsetHeight - dom.root.clientHeight;
    props.borderRootWidth = dom.root.offsetWidth - dom.root.clientWidth;

    // workaround for a bug in IE: the clientWidth of an element with
    // a height:0px and overflow:hidden is not calculated and always has value 0
    if (dom.centerContainer.clientHeight === 0) {
      props.border.left = props.border.top;
      props.border.right = props.border.left;
    }
    if (dom.root.clientHeight === 0) {
      props.borderRootWidth = props.borderRootHeight;
    }

    // calculate the heights. If any of the side panels is empty, we set the height to
    // minus the border width, such that the border will be invisible
    props.center.height = dom.center.offsetHeight;
    props.left.height = dom.left.offsetHeight;
    props.right.height = dom.right.offsetHeight;
    props.top.height = dom.top.clientHeight || -props.border.top;
    props.bottom.height = dom.bottom.clientHeight || -props.border.bottom;

    // TODO: compensate borders when any of the panels is empty.

    // apply auto height
    // TODO: only calculate autoHeight when needed (else we cause an extra reflow/repaint of the DOM)
    var contentHeight = Math.max(props.left.height, props.center.height, props.right.height);
    var autoHeight = props.top.height + contentHeight + props.bottom.height + props.borderRootHeight + props.border.top + props.border.bottom;
    dom.root.style.height = util.option.asSize(options.height, autoHeight + 'px');

    // calculate heights of the content panels
    props.root.height = dom.root.offsetHeight;
    props.background.height = props.root.height - props.borderRootHeight;
    var containerHeight = props.root.height - props.top.height - props.bottom.height - props.borderRootHeight;
    props.centerContainer.height = containerHeight;
    props.leftContainer.height = containerHeight;
    props.rightContainer.height = props.leftContainer.height;

    // calculate the widths of the panels
    props.root.width = dom.root.offsetWidth;
    props.background.width = props.root.width - props.borderRootWidth;

    if (!this.initialDrawDone) {
      props.scrollbarWidth = util.getScrollBarWidth();
    }

    if (options.verticalScroll) {
      if (options.rtl) {
        props.left.width = dom.leftContainer.clientWidth || -props.border.left;
        props.right.width = dom.rightContainer.clientWidth + props.scrollbarWidth || -props.border.right;
      } else {
        props.left.width = dom.leftContainer.clientWidth + props.scrollbarWidth || -props.border.left;
        props.right.width = dom.rightContainer.clientWidth || -props.border.right;
      }
    } else {
      props.left.width = dom.leftContainer.clientWidth || -props.border.left;
      props.right.width = dom.rightContainer.clientWidth || -props.border.right;
    }

    this._setDOM();

    // update the scrollTop, feasible range for the offset can be changed
    // when the height of the Core or of the contents of the center changed
    var offset = this._updateScrollTop();

    // reposition the scrollable contents
    if (options.orientation.item != 'top') {
      offset += Math.max(props.centerContainer.height - props.center.height - props.border.top - props.border.bottom, 0);
    }
    dom.center.style.top = offset + 'px';

    // show shadows when vertical scrolling is available
    var visibilityTop = props.scrollTop == 0 ? 'hidden' : '';
    var visibilityBottom = props.scrollTop == props.scrollTopMin ? 'hidden' : '';
    dom.shadowTop.style.visibility = visibilityTop;
    dom.shadowBottom.style.visibility = visibilityBottom;
    dom.shadowTopLeft.style.visibility = visibilityTop;
    dom.shadowBottomLeft.style.visibility = visibilityBottom;
    dom.shadowTopRight.style.visibility = visibilityTop;
    dom.shadowBottomRight.style.visibility = visibilityBottom;

    if (options.verticalScroll) {
      dom.rightContainer.className = 'vis-panel vis-right vis-vertical-scroll';
      dom.leftContainer.className = 'vis-panel vis-left vis-vertical-scroll';

      dom.shadowTopRight.style.visibility = "hidden";
      dom.shadowBottomRight.style.visibility = "hidden";
      dom.shadowTopLeft.style.visibility = "hidden";
      dom.shadowBottomLeft.style.visibility = "hidden";

      dom.left.style.top = '0px';
      dom.right.style.top = '0px';
    }

    if (!options.verticalScroll || props.center.height < props.centerContainer.height) {
      dom.left.style.top = offset + 'px';
      dom.right.style.top = offset + 'px';
      dom.rightContainer.className = dom.rightContainer.className.replace(new RegExp('(?:^|\\s)' + 'vis-vertical-scroll' + '(?:\\s|$)'), ' ');
      dom.leftContainer.className = dom.leftContainer.className.replace(new RegExp('(?:^|\\s)' + 'vis-vertical-scroll' + '(?:\\s|$)'), ' ');
      props.left.width = dom.leftContainer.clientWidth || -props.border.left;
      props.right.width = dom.rightContainer.clientWidth || -props.border.right;
      this._setDOM();
    }

    // enable/disable vertical panning
    var contentsOverflow = props.center.height > props.centerContainer.height;
    this.hammer.get('pan').set({
      direction: contentsOverflow ? Hammer.DIRECTION_ALL : Hammer.DIRECTION_HORIZONTAL
    });

    // redraw all components
    this.components.forEach(function (component) {
      resized = component.redraw() || resized;
    });
    var MAX_REDRAW = 5;
    if (resized) {
      if (this.redrawCount < MAX_REDRAW) {
        this.body.emitter.emit('_change');
        return;
      } else {
        console.log('WARNING: infinite loop in redraw?');
      }
    } else {
      this.redrawCount = 0;
    }
    this.initialDrawDone = true;

    //Emit public 'changed' event for UI updates, see issue #1592
    this.body.emitter.emit("changed");
  };

  Core.prototype._setDOM = function () {
    var props = this.props;
    var dom = this.dom;

    props.leftContainer.width = props.left.width;
    props.rightContainer.width = props.right.width;
    var centerWidth = props.root.width - props.left.width - props.right.width - props.borderRootWidth;
    props.center.width = centerWidth;
    props.centerContainer.width = centerWidth;
    props.top.width = centerWidth;
    props.bottom.width = centerWidth;

    // resize the panels
    dom.background.style.height = props.background.height + 'px';
    dom.backgroundVertical.style.height = props.background.height + 'px';
    dom.backgroundHorizontal.style.height = props.centerContainer.height + 'px';
    dom.centerContainer.style.height = props.centerContainer.height + 'px';
    dom.leftContainer.style.height = props.leftContainer.height + 'px';
    dom.rightContainer.style.height = props.rightContainer.height + 'px';

    dom.background.style.width = props.background.width + 'px';
    dom.backgroundVertical.style.width = props.centerContainer.width + 'px';
    dom.backgroundHorizontal.style.width = props.background.width + 'px';
    dom.centerContainer.style.width = props.center.width + 'px';
    dom.top.style.width = props.top.width + 'px';
    dom.bottom.style.width = props.bottom.width + 'px';

    // reposition the panels
    dom.background.style.left = '0';
    dom.background.style.top = '0';
    dom.backgroundVertical.style.left = props.left.width + props.border.left + 'px';
    dom.backgroundVertical.style.top = '0';
    dom.backgroundHorizontal.style.left = '0';
    dom.backgroundHorizontal.style.top = props.top.height + 'px';
    dom.centerContainer.style.left = props.left.width + 'px';
    dom.centerContainer.style.top = props.top.height + 'px';
    dom.leftContainer.style.left = '0';
    dom.leftContainer.style.top = props.top.height + 'px';
    dom.rightContainer.style.left = props.left.width + props.center.width + 'px';
    dom.rightContainer.style.top = props.top.height + 'px';
    dom.top.style.left = props.left.width + 'px';
    dom.top.style.top = '0';
    dom.bottom.style.left = props.left.width + 'px';
    dom.bottom.style.top = props.top.height + props.centerContainer.height + 'px';
    dom.center.style.left = '0';
    dom.left.style.left = '0';
    dom.right.style.left = '0';
  };

  // TODO: deprecated since version 1.1.0, remove some day
  Core.prototype.repaint = function () {
    throw new Error('Function repaint is deprecated. Use redraw instead.');
  };

  /**
   * Set a current time. This can be used for example to ensure that a client's
   * time is synchronized with a shared server time.
   * Only applicable when option `showCurrentTime` is true.
   * @param {Date | String | Number} time     A Date, unix timestamp, or
   *                                          ISO date string.
   */
  Core.prototype.setCurrentTime = function (time) {
    if (!this.currentTime) {
      throw new Error('Option showCurrentTime must be true');
    }

    this.currentTime.setCurrentTime(time);
  };

  /**
   * Get the current time.
   * Only applicable when option `showCurrentTime` is true.
   * @return {Date} Returns the current time.
   */
  Core.prototype.getCurrentTime = function () {
    if (!this.currentTime) {
      throw new Error('Option showCurrentTime must be true');
    }

    return this.currentTime.getCurrentTime();
  };

  /**
   * Convert a position on screen (pixels) to a datetime
   * @param {int}     x    Position on the screen in pixels
   * @return {Date}   time The datetime the corresponds with given position x
   * @protected
   */
  // TODO: move this function to Range
  Core.prototype._toTime = function (x) {
    return DateUtil.toTime(this, x, this.props.center.width);
  };

  /**
   * Convert a position on the global screen (pixels) to a datetime
   * @param {int}     x    Position on the screen in pixels
   * @return {Date}   time The datetime the corresponds with given position x
   * @protected
   */
  // TODO: move this function to Range
  Core.prototype._toGlobalTime = function (x) {
    return DateUtil.toTime(this, x, this.props.root.width);
    //var conversion = this.range.conversion(this.props.root.width);
    //return new Date(x / conversion.scale + conversion.offset);
  };

  /**
   * Convert a datetime (Date object) into a position on the screen
   * @param {Date}   time A date
   * @return {int}   x    The position on the screen in pixels which corresponds
   *                      with the given date.
   * @protected
   */
  // TODO: move this function to Range
  Core.prototype._toScreen = function (time) {
    return DateUtil.toScreen(this, time, this.props.center.width);
  };

  /**
   * Convert a datetime (Date object) into a position on the root
   * This is used to get the pixel density estimate for the screen, not the center panel
   * @param {Date}   time A date
   * @return {int}   x    The position on root in pixels which corresponds
   *                      with the given date.
   * @protected
   */
  // TODO: move this function to Range
  Core.prototype._toGlobalScreen = function (time) {
    return DateUtil.toScreen(this, time, this.props.root.width);
    //var conversion = this.range.conversion(this.props.root.width);
    //return (time.valueOf() - conversion.offset) * conversion.scale;
  };

  /**
   * Initialize watching when option autoResize is true
   * @private
   */
  Core.prototype._initAutoResize = function () {
    if (this.options.autoResize == true) {
      this._startAutoResize();
    } else {
      this._stopAutoResize();
    }
  };

  /**
   * Watch for changes in the size of the container. On resize, the Panel will
   * automatically redraw itself.
   * @private
   */
  Core.prototype._startAutoResize = function () {
    var me = this;

    this._stopAutoResize();

    this._onResize = function () {
      if (me.options.autoResize != true) {
        // stop watching when the option autoResize is changed to false
        me._stopAutoResize();
        return;
      }

      if (me.dom.root) {
        // check whether the frame is resized
        // Note: we compare offsetWidth here, not clientWidth. For some reason,
        // IE does not restore the clientWidth from 0 to the actual width after
        // changing the timeline's container display style from none to visible
        if (me.dom.root.offsetWidth != me.props.lastWidth || me.dom.root.offsetHeight != me.props.lastHeight) {
          me.props.lastWidth = me.dom.root.offsetWidth;
          me.props.lastHeight = me.dom.root.offsetHeight;
          me.props.scrollbarWidth = util.getScrollBarWidth();

          me.body.emitter.emit('_change');
        }
      }
    };

    // add event listener to window resize
    util.addEventListener(window, 'resize', this._onResize);

    //Prevent initial unnecessary redraw
    if (me.dom.root) {
      me.props.lastWidth = me.dom.root.offsetWidth;
      me.props.lastHeight = me.dom.root.offsetHeight;
    }

    this.watchTimer = setInterval(this._onResize, 1000);
  };

  /**
   * Stop watching for a resize of the frame.
   * @private
   */
  Core.prototype._stopAutoResize = function () {
    if (this.watchTimer) {
      clearInterval(this.watchTimer);
      this.watchTimer = undefined;
    }

    // remove event listener on window.resize
    if (this._onResize) {
      util.removeEventListener(window, 'resize', this._onResize);
      this._onResize = null;
    }
  };

  /**
   * Start moving the timeline vertically
   * @param {Event} event
   * @private
   */
  Core.prototype._onTouch = function (event) {
    this.touch.allowDragging = true;
    this.touch.initialScrollTop = this.props.scrollTop;
  };

  /**
   * Start moving the timeline vertically
   * @param {Event} event
   * @private
   */
  Core.prototype._onPinch = function (event) {
    this.touch.allowDragging = false;
  };

  /**
   * Move the timeline vertically
   * @param {Event} event
   * @private
   */
  Core.prototype._onDrag = function (event) {
    if (!event) return;
    // refuse to drag when we where pinching to prevent the timeline make a jump
    // when releasing the fingers in opposite order from the touch screen
    if (!this.touch.allowDragging) return;

    var delta = event.deltaY;

    var oldScrollTop = this._getScrollTop();
    var newScrollTop = this._setScrollTop(this.touch.initialScrollTop + delta);

    if (this.options.verticalScroll) {
      this.dom.left.parentNode.scrollTop = -this.props.scrollTop;
      this.dom.right.parentNode.scrollTop = -this.props.scrollTop;
    }

    if (newScrollTop != oldScrollTop) {
      this.emit("verticalDrag");
    }
  };

  /**
   * Apply a scrollTop
   * @param {Number} scrollTop
   * @returns {Number} scrollTop  Returns the applied scrollTop
   * @private
   */
  Core.prototype._setScrollTop = function (scrollTop) {
    this.props.scrollTop = scrollTop;
    this._updateScrollTop();
    return this.props.scrollTop;
  };

  /**
   * Update the current scrollTop when the height of  the containers has been changed
   * @returns {Number} scrollTop  Returns the applied scrollTop
   * @private
   */
  Core.prototype._updateScrollTop = function () {
    // recalculate the scrollTopMin
    var scrollTopMin = Math.min(this.props.centerContainer.height - this.props.center.height, 0); // is negative or zero
    if (scrollTopMin != this.props.scrollTopMin) {
      // in case of bottom orientation, change the scrollTop such that the contents
      // do not move relative to the time axis at the bottom
      if (this.options.orientation.item != 'top') {
        this.props.scrollTop += scrollTopMin - this.props.scrollTopMin;
      }
      this.props.scrollTopMin = scrollTopMin;
    }

    // limit the scrollTop to the feasible scroll range
    if (this.props.scrollTop > 0) this.props.scrollTop = 0;
    if (this.props.scrollTop < scrollTopMin) this.props.scrollTop = scrollTopMin;

    if (this.options.verticalScroll) {
      this.dom.left.parentNode.scrollTop = -this.props.scrollTop;
      this.dom.right.parentNode.scrollTop = -this.props.scrollTop;
    }

    return this.props.scrollTop;
  };

  /**
   * Get the current scrollTop
   * @returns {number} scrollTop
   * @private
   */
  Core.prototype._getScrollTop = function () {
    return this.props.scrollTop;
  };

  /**
   * Load a configurator
   * @return {Object}
   * @private
   */
  Core.prototype._createConfigurator = function () {
    throw new Error('Cannot invoke abstract method _createConfigurator');
  };

  module.exports = Core;

/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _create = __webpack_require__(55);

  var _create2 = _interopRequireDefault(_create);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  var _Popup = __webpack_require__(128);

  var _Popup2 = _interopRequireDefault(_Popup);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var Hammer = __webpack_require__(108);
  var util = __webpack_require__(1);
  var DataSet = __webpack_require__(91);
  var DataView = __webpack_require__(93);
  var TimeStep = __webpack_require__(129);
  var Component = __webpack_require__(124);
  var Group = __webpack_require__(130);
  var BackgroundGroup = __webpack_require__(134);
  var BoxItem = __webpack_require__(135);
  var PointItem = __webpack_require__(136);
  var RangeItem = __webpack_require__(132);
  var BackgroundItem = __webpack_require__(137);


  var UNGROUPED = '__ungrouped__'; // reserved group id for ungrouped items
  var BACKGROUND = '__background__'; // reserved group id for background items without group

  /**
   * An ItemSet holds a set of items and ranges which can be displayed in a
   * range. The width is determined by the parent of the ItemSet, and the height
   * is determined by the size of the items.
   * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} body
   * @param {Object} [options]      See ItemSet.setOptions for the available options.
   * @constructor ItemSet
   * @extends Component
   */
  function ItemSet(body, options) {
    this.body = body;
    this.defaultOptions = {
      type: null, // 'box', 'point', 'range', 'background'
      orientation: {
        item: 'bottom' // item orientation: 'top' or 'bottom'
      },
      align: 'auto', // alignment of box items
      stack: true,
      stackSubgroups: true,
      groupOrderSwap: function groupOrderSwap(fromGroup, toGroup, groups) {
        var targetOrder = toGroup.order;
        toGroup.order = fromGroup.order;
        fromGroup.order = targetOrder;
      },
      groupOrder: 'order',

      selectable: true,
      multiselect: false,
      itemsAlwaysDraggable: false,

      editable: {
        updateTime: false,
        updateGroup: false,
        add: false,
        remove: false,
        overrideItems: false
      },

      groupEditable: {
        order: false,
        add: false,
        remove: false
      },

      snap: TimeStep.snap,

      onAdd: function onAdd(item, callback) {
        callback(item);
      },
      onUpdate: function onUpdate(item, callback) {
        callback(item);
      },
      onMove: function onMove(item, callback) {
        callback(item);
      },
      onRemove: function onRemove(item, callback) {
        callback(item);
      },
      onMoving: function onMoving(item, callback) {
        callback(item);
      },
      onAddGroup: function onAddGroup(item, callback) {
        callback(item);
      },
      onMoveGroup: function onMoveGroup(item, callback) {
        callback(item);
      },
      onRemoveGroup: function onRemoveGroup(item, callback) {
        callback(item);
      },

      margin: {
        item: {
          horizontal: 10,
          vertical: 10
        },
        axis: 20
      },

      tooltip: {
        followMouse: false,
        overflowMethod: 'flip'
      },

      tooltipOnItemUpdateTime: false
    };

    // options is shared by this ItemSet and all its items
    this.options = util.extend({}, this.defaultOptions);
    this.options.rtl = options.rtl;

    // options for getting items from the DataSet with the correct type
    this.itemOptions = {
      type: { start: 'Date', end: 'Date' }
    };

    this.conversion = {
      toScreen: body.util.toScreen,
      toTime: body.util.toTime
    };
    this.dom = {};
    this.props = {};
    this.hammer = null;

    var me = this;
    this.itemsData = null; // DataSet
    this.groupsData = null; // DataSet

    // listeners for the DataSet of the items
    this.itemListeners = {
      'add': function add(event, params, senderId) {
        me._onAdd(params.items);
      },
      'update': function update(event, params, senderId) {
        me._onUpdate(params.items);
      },
      'remove': function remove(event, params, senderId) {
        me._onRemove(params.items);
      }
    };

    // listeners for the DataSet of the groups
    this.groupListeners = {
      'add': function add(event, params, senderId) {
        me._onAddGroups(params.items);
      },
      'update': function update(event, params, senderId) {
        me._onUpdateGroups(params.items);
      },
      'remove': function remove(event, params, senderId) {
        me._onRemoveGroups(params.items);
      }
    };

    this.items = {}; // object with an Item for every data item
    this.groups = {}; // Group object for every group
    this.groupIds = [];

    this.selection = []; // list with the ids of all selected nodes
    this.stackDirty = true; // if true, all items will be restacked on next redraw

    this.touchParams = {}; // stores properties while dragging
    this.groupTouchParams = {};
    // create the HTML DOM

    this._create();

    this.setOptions(options);
  }

  ItemSet.prototype = new Component();

  // available item types will be registered here
  ItemSet.types = {
    background: BackgroundItem,
    box: BoxItem,
    range: RangeItem,
    point: PointItem
  };

  /**
   * Create the HTML DOM for the ItemSet
   */
  ItemSet.prototype._create = function () {
    var frame = document.createElement('div');
    frame.className = 'vis-itemset';
    frame['timeline-itemset'] = this;
    this.dom.frame = frame;

    // create background panel
    var background = document.createElement('div');
    background.className = 'vis-background';
    frame.appendChild(background);
    this.dom.background = background;

    // create foreground panel
    var foreground = document.createElement('div');
    foreground.className = 'vis-foreground';
    frame.appendChild(foreground);
    this.dom.foreground = foreground;

    // create axis panel
    var axis = document.createElement('div');
    axis.className = 'vis-axis';
    this.dom.axis = axis;

    // create labelset
    var labelSet = document.createElement('div');
    labelSet.className = 'vis-labelset';
    this.dom.labelSet = labelSet;

    // create ungrouped Group
    this._updateUngrouped();

    // create background Group
    var backgroundGroup = new BackgroundGroup(BACKGROUND, null, this);
    backgroundGroup.show();
    this.groups[BACKGROUND] = backgroundGroup;

    // attach event listeners
    // Note: we bind to the centerContainer for the case where the height
    //       of the center container is larger than of the ItemSet, so we
    //       can click in the empty area to create a new item or deselect an item.
    this.hammer = new Hammer(this.body.dom.centerContainer);

    // drag items when selected
    this.hammer.on('hammer.input', function (event) {
      if (event.isFirst) {
        this._onTouch(event);
      }
    }.bind(this));
    this.hammer.on('panstart', this._onDragStart.bind(this));
    this.hammer.on('panmove', this._onDrag.bind(this));
    this.hammer.on('panend', this._onDragEnd.bind(this));
    this.hammer.get('pan').set({ threshold: 5, direction: Hammer.DIRECTION_HORIZONTAL });

    // single select (or unselect) when tapping an item
    this.hammer.on('tap', this._onSelectItem.bind(this));

    // multi select when holding mouse/touch, or on ctrl+click
    this.hammer.on('press', this._onMultiSelectItem.bind(this));

    // add item on doubletap
    this.hammer.on('doubletap', this._onAddItem.bind(this));

    if (this.options.rtl) {
      this.groupHammer = new Hammer(this.body.dom.rightContainer);
    } else {
      this.groupHammer = new Hammer(this.body.dom.leftContainer);
    }

    this.groupHammer.on('tap', this._onGroupClick.bind(this));
    this.groupHammer.on('panstart', this._onGroupDragStart.bind(this));
    this.groupHammer.on('panmove', this._onGroupDrag.bind(this));
    this.groupHammer.on('panend', this._onGroupDragEnd.bind(this));
    this.groupHammer.get('pan').set({ threshold: 5, direction: Hammer.DIRECTION_VERTICAL });

    this.body.dom.centerContainer.addEventListener('mouseover', this._onMouseOver.bind(this));
    this.body.dom.centerContainer.addEventListener('mouseout', this._onMouseOut.bind(this));
    this.body.dom.centerContainer.addEventListener('mousemove', this._onMouseMove.bind(this));
    // right-click on timeline 
    this.body.dom.centerContainer.addEventListener('contextmenu', this._onDragEnd.bind(this));

    this.body.dom.centerContainer.addEventListener('mousewheel', this._onMouseWheel.bind(this));

    // attach to the DOM
    this.show();
  };

  /**
   * Set options for the ItemSet. Existing options will be extended/overwritten.
   * @param {Object} [options] The following options are available:
   *                           {String} type
   *                              Default type for the items. Choose from 'box'
   *                              (default), 'point', 'range', or 'background'.
   *                              The default style can be overwritten by
   *                              individual items.
   *                           {String} align
   *                              Alignment for the items, only applicable for
   *                              BoxItem. Choose 'center' (default), 'left', or
   *                              'right'.
   *                           {String} orientation.item
   *                              Orientation of the item set. Choose 'top' or
   *                              'bottom' (default).
   *                           {Function} groupOrder
   *                              A sorting function for ordering groups
   *                           {Boolean} stack
   *                              If true (default), items will be stacked on
   *                              top of each other.
   *                           {Number} margin.axis
   *                              Margin between the axis and the items in pixels.
   *                              Default is 20.
   *                           {Number} margin.item.horizontal
   *                              Horizontal margin between items in pixels.
   *                              Default is 10.
   *                           {Number} margin.item.vertical
   *                              Vertical Margin between items in pixels.
   *                              Default is 10.
   *                           {Number} margin.item
   *                              Margin between items in pixels in both horizontal
   *                              and vertical direction. Default is 10.
   *                           {Number} margin
   *                              Set margin for both axis and items in pixels.
   *                           {Boolean} selectable
   *                              If true (default), items can be selected.
   *                           {Boolean} multiselect
   *                              If true, multiple items can be selected.
   *                              False by default.
   *                           {Boolean} editable
   *                              Set all editable options to true or false
   *                           {Boolean} editable.updateTime
   *                              Allow dragging an item to an other moment in time
   *                           {Boolean} editable.updateGroup
   *                              Allow dragging an item to an other group
   *                           {Boolean} editable.add
   *                              Allow creating new items on double tap
   *                           {Boolean} editable.remove
   *                              Allow removing items by clicking the delete button
   *                              top right of a selected item.
   *                           {Function(item: Item, callback: Function)} onAdd
   *                              Callback function triggered when an item is about to be added:
   *                              when the user double taps an empty space in the Timeline.
   *                           {Function(item: Item, callback: Function)} onUpdate
   *                              Callback function fired when an item is about to be updated.
   *                              This function typically has to show a dialog where the user
   *                              change the item. If not implemented, nothing happens.
   *                           {Function(item: Item, callback: Function)} onMove
   *                              Fired when an item has been moved. If not implemented,
   *                              the move action will be accepted.
   *                           {Function(item: Item, callback: Function)} onRemove
   *                              Fired when an item is about to be deleted.
   *                              If not implemented, the item will be always removed.
   */
  ItemSet.prototype.setOptions = function (options) {
    if (options) {
      // copy all options that we know
      var fields = ['type', 'rtl', 'align', 'order', 'stack', 'stackSubgroups', 'selectable', 'multiselect', 'itemsAlwaysDraggable', 'multiselectPerGroup', 'groupOrder', 'dataAttributes', 'template', 'groupTemplate', 'visibleFrameTemplate', 'hide', 'snap', 'groupOrderSwap', 'tooltip', 'tooltipOnItemUpdateTime'];
      util.selectiveExtend(fields, this.options, options);

      if ('orientation' in options) {
        if (typeof options.orientation === 'string') {
          this.options.orientation.item = options.orientation === 'top' ? 'top' : 'bottom';
        } else if ((0, _typeof3['default'])(options.orientation) === 'object' && 'item' in options.orientation) {
          this.options.orientation.item = options.orientation.item;
        }
      }

      if ('margin' in options) {
        if (typeof options.margin === 'number') {
          this.options.margin.axis = options.margin;
          this.options.margin.item.horizontal = options.margin;
          this.options.margin.item.vertical = options.margin;
        } else if ((0, _typeof3['default'])(options.margin) === 'object') {
          util.selectiveExtend(['axis'], this.options.margin, options.margin);
          if ('item' in options.margin) {
            if (typeof options.margin.item === 'number') {
              this.options.margin.item.horizontal = options.margin.item;
              this.options.margin.item.vertical = options.margin.item;
            } else if ((0, _typeof3['default'])(options.margin.item) === 'object') {
              util.selectiveExtend(['horizontal', 'vertical'], this.options.margin.item, options.margin.item);
            }
          }
        }
      }

      if ('editable' in options) {
        if (typeof options.editable === 'boolean') {
          this.options.editable.updateTime = options.editable;
          this.options.editable.updateGroup = options.editable;
          this.options.editable.add = options.editable;
          this.options.editable.remove = options.editable;
          this.options.editable.overrideItems = false;
        } else if ((0, _typeof3['default'])(options.editable) === 'object') {
          util.selectiveExtend(['updateTime', 'updateGroup', 'add', 'remove', 'overrideItems'], this.options.editable, options.editable);
        }
      }

      if ('groupEditable' in options) {
        if (typeof options.groupEditable === 'boolean') {
          this.options.groupEditable.order = options.groupEditable;
          this.options.groupEditable.add = options.groupEditable;
          this.options.groupEditable.remove = options.groupEditable;
        } else if ((0, _typeof3['default'])(options.groupEditable) === 'object') {
          util.selectiveExtend(['order', 'add', 'remove'], this.options.groupEditable, options.groupEditable);
        }
      }

      // callback functions
      var addCallback = function (name) {
        var fn = options[name];
        if (fn) {
          if (!(fn instanceof Function)) {
            throw new Error('option ' + name + ' must be a function ' + name + '(item, callback)');
          }
          this.options[name] = fn;
        }
      }.bind(this);
      ['onAdd', 'onUpdate', 'onRemove', 'onMove', 'onMoving', 'onAddGroup', 'onMoveGroup', 'onRemoveGroup'].forEach(addCallback);

      // force the itemSet to refresh: options like orientation and margins may be changed
      this.markDirty();
    }
  };

  /**
   * Mark the ItemSet dirty so it will refresh everything with next redraw.
   * Optionally, all items can be marked as dirty and be refreshed.
   * @param {{refreshItems: boolean}} [options]
   */
  ItemSet.prototype.markDirty = function (options) {
    this.groupIds = [];
    this.stackDirty = true;

    if (options && options.refreshItems) {
      util.forEach(this.items, function (item) {
        item.dirty = true;
        if (item.displayed) item.redraw();
      });
    }
  };

  /**
   * Destroy the ItemSet
   */
  ItemSet.prototype.destroy = function () {
    this.hide();
    this.setItems(null);
    this.setGroups(null);

    this.hammer = null;

    this.body = null;
    this.conversion = null;
  };

  /**
   * Hide the component from the DOM
   */
  ItemSet.prototype.hide = function () {
    // remove the frame containing the items
    if (this.dom.frame.parentNode) {
      this.dom.frame.parentNode.removeChild(this.dom.frame);
    }

    // remove the axis with dots
    if (this.dom.axis.parentNode) {
      this.dom.axis.parentNode.removeChild(this.dom.axis);
    }

    // remove the labelset containing all group labels
    if (this.dom.labelSet.parentNode) {
      this.dom.labelSet.parentNode.removeChild(this.dom.labelSet);
    }
  };

  /**
   * Show the component in the DOM (when not already visible).
   * @return {Boolean} changed
   */
  ItemSet.prototype.show = function () {
    // show frame containing the items
    if (!this.dom.frame.parentNode) {
      this.body.dom.center.appendChild(this.dom.frame);
    }

    // show axis with dots
    if (!this.dom.axis.parentNode) {
      this.body.dom.backgroundVertical.appendChild(this.dom.axis);
    }

    // show labelset containing labels
    if (!this.dom.labelSet.parentNode) {
      if (this.options.rtl) {
        this.body.dom.right.appendChild(this.dom.labelSet);
      } else {
        this.body.dom.left.appendChild(this.dom.labelSet);
      }
    }
  };

  /**
   * Set selected items by their id. Replaces the current selection
   * Unknown id's are silently ignored.
   * @param {string[] | string} [ids] An array with zero or more id's of the items to be
   *                                  selected, or a single item id. If ids is undefined
   *                                  or an empty array, all items will be unselected.
   */
  ItemSet.prototype.setSelection = function (ids) {
    var i, ii, id, item;

    if (ids == undefined) ids = [];
    if (!Array.isArray(ids)) ids = [ids];

    // unselect currently selected items
    for (i = 0, ii = this.selection.length; i < ii; i++) {
      id = this.selection[i];
      item = this.items[id];
      if (item) item.unselect();
    }

    // select items
    this.selection = [];
    for (i = 0, ii = ids.length; i < ii; i++) {
      id = ids[i];
      item = this.items[id];
      if (item) {
        this.selection.push(id);
        item.select();
      }
    }
  };

  /**
   * Get the selected items by their id
   * @return {Array} ids  The ids of the selected items
   */
  ItemSet.prototype.getSelection = function () {
    return this.selection.concat([]);
  };

  /**
   * Get the id's of the currently visible items.
   * @returns {Array} The ids of the visible items
   */
  ItemSet.prototype.getVisibleItems = function () {
    var range = this.body.range.getRange();

    if (this.options.rtl) {
      var right = this.body.util.toScreen(range.start);
      var left = this.body.util.toScreen(range.end);
    } else {
      var left = this.body.util.toScreen(range.start);
      var right = this.body.util.toScreen(range.end);
    }

    var ids = [];
    for (var groupId in this.groups) {
      if (this.groups.hasOwnProperty(groupId)) {
        var group = this.groups[groupId];
        var rawVisibleItems = group.visibleItems;

        // filter the "raw" set with visibleItems into a set which is really
        // visible by pixels
        for (var i = 0; i < rawVisibleItems.length; i++) {
          var item = rawVisibleItems[i];
          // TODO: also check whether visible vertically
          if (this.options.rtl) {
            if (item.right < left && item.right + item.width > right) {
              ids.push(item.id);
            }
          } else {
            if (item.left < right && item.left + item.width > left) {
              ids.push(item.id);
            }
          }
        }
      }
    }

    return ids;
  };

  /**
   * Deselect a selected item
   * @param {String | Number} id
   * @private
   */
  ItemSet.prototype._deselect = function (id) {
    var selection = this.selection;
    for (var i = 0, ii = selection.length; i < ii; i++) {
      if (selection[i] == id) {
        // non-strict comparison!
        selection.splice(i, 1);
        break;
      }
    }
  };

  /**
   * Repaint the component
   * @return {boolean} Returns true if the component is resized
   */
  ItemSet.prototype.redraw = function () {
    var margin = this.options.margin,
        range = this.body.range,
        asSize = util.option.asSize,
        options = this.options,
        orientation = options.orientation.item,
        resized = false,
        frame = this.dom.frame;

    // recalculate absolute position (before redrawing groups)
    this.props.top = this.body.domProps.top.height + this.body.domProps.border.top;

    if (this.options.rtl) {
      this.props.right = this.body.domProps.right.width + this.body.domProps.border.right;
    } else {
      this.props.left = this.body.domProps.left.width + this.body.domProps.border.left;
    }

    // update class name
    frame.className = 'vis-itemset';

    // reorder the groups (if needed)
    resized = this._orderGroups() || resized;

    // check whether zoomed (in that case we need to re-stack everything)
    // TODO: would be nicer to get this as a trigger from Range
    var visibleInterval = range.end - range.start;
    var zoomed = visibleInterval != this.lastVisibleInterval || this.props.width != this.props.lastWidth;
    if (zoomed) this.stackDirty = true;
    this.lastVisibleInterval = visibleInterval;
    this.props.lastWidth = this.props.width;

    var restack = this.stackDirty;
    var firstGroup = this._firstGroup();
    var firstMargin = {
      item: margin.item,
      axis: margin.axis
    };
    var nonFirstMargin = {
      item: margin.item,
      axis: margin.item.vertical / 2
    };
    var height = 0;
    var minHeight = margin.axis + margin.item.vertical;

    // redraw the background group
    this.groups[BACKGROUND].redraw(range, nonFirstMargin, restack);

    // redraw all regular groups
    util.forEach(this.groups, function (group) {
      var groupMargin = group == firstGroup ? firstMargin : nonFirstMargin;
      var groupResized = group.redraw(range, groupMargin, restack);
      resized = groupResized || resized;
      height += group.height;
    });
    height = Math.max(height, minHeight);
    this.stackDirty = false;

    // update frame height
    frame.style.height = asSize(height);

    // calculate actual size
    this.props.width = frame.offsetWidth;
    this.props.height = height;

    // reposition axis
    this.dom.axis.style.top = asSize(orientation == 'top' ? this.body.domProps.top.height + this.body.domProps.border.top : this.body.domProps.top.height + this.body.domProps.centerContainer.height);
    if (this.options.rtl) {
      this.dom.axis.style.right = '0';
    } else {
      this.dom.axis.style.left = '0';
    }

    this.initialItemSetDrawn = true;
    // check if this component is resized
    resized = this._isResized() || resized;

    return resized;
  };

  /**
   * Get the first group, aligned with the axis
   * @return {Group | null} firstGroup
   * @private
   */
  ItemSet.prototype._firstGroup = function () {
    var firstGroupIndex = this.options.orientation.item == 'top' ? 0 : this.groupIds.length - 1;
    var firstGroupId = this.groupIds[firstGroupIndex];
    var firstGroup = this.groups[firstGroupId] || this.groups[UNGROUPED];

    return firstGroup || null;
  };

  /**
   * Create or delete the group holding all ungrouped items. This group is used when
   * there are no groups specified.
   * @protected
   */
  ItemSet.prototype._updateUngrouped = function () {
    var ungrouped = this.groups[UNGROUPED];
    var background = this.groups[BACKGROUND];
    var item, itemId;

    if (this.groupsData) {
      // remove the group holding all ungrouped items
      if (ungrouped) {
        ungrouped.hide();
        delete this.groups[UNGROUPED];

        for (itemId in this.items) {
          if (this.items.hasOwnProperty(itemId)) {
            item = this.items[itemId];
            item.parent && item.parent.remove(item);
            var groupId = this._getGroupId(item.data);
            var group = this.groups[groupId];
            group && group.add(item) || item.hide();
          }
        }
      }
    } else {
      // create a group holding all (unfiltered) items
      if (!ungrouped) {
        var id = null;
        var data = null;
        ungrouped = new Group(id, data, this);
        this.groups[UNGROUPED] = ungrouped;

        for (itemId in this.items) {
          if (this.items.hasOwnProperty(itemId)) {
            item = this.items[itemId];
            ungrouped.add(item);
          }
        }

        ungrouped.show();
      }
    }
  };

  /**
   * Get the element for the labelset
   * @return {HTMLElement} labelSet
   */
  ItemSet.prototype.getLabelSet = function () {
    return this.dom.labelSet;
  };

  /**
   * Set items
   * @param {vis.DataSet | null} items
   */
  ItemSet.prototype.setItems = function (items) {
    var me = this,
        ids,
        oldItemsData = this.itemsData;

    // replace the dataset
    if (!items) {
      this.itemsData = null;
    } else if (items instanceof DataSet || items instanceof DataView) {
      this.itemsData = items;
    } else {
      throw new TypeError('Data must be an instance of DataSet or DataView');
    }

    if (oldItemsData) {
      // unsubscribe from old dataset
      util.forEach(this.itemListeners, function (callback, event) {
        oldItemsData.off(event, callback);
      });

      // remove all drawn items
      ids = oldItemsData.getIds();
      this._onRemove(ids);
    }

    if (this.itemsData) {
      // subscribe to new dataset
      var id = this.id;
      util.forEach(this.itemListeners, function (callback, event) {
        me.itemsData.on(event, callback, id);
      });

      // add all new items
      ids = this.itemsData.getIds();
      this._onAdd(ids);

      // update the group holding all ungrouped items
      this._updateUngrouped();
    }

    this.body.emitter.emit('_change', { queue: true });
  };

  /**
   * Get the current items
   * @returns {vis.DataSet | null}
   */
  ItemSet.prototype.getItems = function () {
    return this.itemsData;
  };

  /**
   * Set groups
   * @param {vis.DataSet} groups
   */
  ItemSet.prototype.setGroups = function (groups) {
    var me = this,
        ids;

    // unsubscribe from current dataset
    if (this.groupsData) {
      util.forEach(this.groupListeners, function (callback, event) {
        me.groupsData.off(event, callback);
      });

      // remove all drawn groups
      ids = this.groupsData.getIds();
      this.groupsData = null;
      this._onRemoveGroups(ids); // note: this will cause a redraw
    }

    // replace the dataset
    if (!groups) {
      this.groupsData = null;
    } else if (groups instanceof DataSet || groups instanceof DataView) {
      this.groupsData = groups;
    } else {
      throw new TypeError('Data must be an instance of DataSet or DataView');
    }

    if (this.groupsData) {
      // go over all groups nesting
      var groupsData = this.groupsData;
      if (this.groupsData instanceof DataView) {
        groupsData = this.groupsData.getDataSet();
      }

      groupsData.get().forEach(function (group) {
        if (group.nestedGroups) {
          group.nestedGroups.forEach(function (nestedGroupId) {
            var updatedNestedGroup = groupsData.get(nestedGroupId);
            updatedNestedGroup.nestedInGroup = group.id;
            if (group.showNested == false) {
              updatedNestedGroup.visible = false;
            }
            groupsData.update(updatedNestedGroup);
          });
        }
      });

      // subscribe to new dataset
      var id = this.id;
      util.forEach(this.groupListeners, function (callback, event) {
        me.groupsData.on(event, callback, id);
      });

      // draw all ms
      ids = this.groupsData.getIds();
      this._onAddGroups(ids);
    }

    // update the group holding all ungrouped items
    this._updateUngrouped();

    // update the order of all items in each group
    this._order();

    this.body.emitter.emit('_change', { queue: true });
  };

  /**
   * Get the current groups
   * @returns {vis.DataSet | null} groups
   */
  ItemSet.prototype.getGroups = function () {
    return this.groupsData;
  };

  /**
   * Remove an item by its id
   * @param {String | Number} id
   */
  ItemSet.prototype.removeItem = function (id) {
    var item = this.itemsData.get(id),
        dataset = this.itemsData.getDataSet(),
        itemObj = this.items[id];

    if (item) {
      // confirm deletion
      this.options.onRemove(item, function (item) {
        if (item) {
          // remove by id here, it is possible that an item has no id defined
          // itself, so better not delete by the item itself
          dataset.remove(id);

          // Remove it's popup
          if (itemObj.popup) {
            itemObj.popup.destroy();
            itemObj.popup = null;
          }
        }
      });
    }
  };

  /**
   * Get the time of an item based on it's data and options.type
   * @param {Object} itemData
   * @returns {string} Returns the type
   * @private
   */
  ItemSet.prototype._getType = function (itemData) {
    return itemData.type || this.options.type || (itemData.end ? 'range' : 'box');
  };

  /**
   * Get the group id for an item
   * @param {Object} itemData
   * @returns {string} Returns the groupId
   * @private
   */
  ItemSet.prototype._getGroupId = function (itemData) {
    var type = this._getType(itemData);
    if (type == 'background' && itemData.group == undefined) {
      return BACKGROUND;
    } else {
      return this.groupsData ? itemData.group : UNGROUPED;
    }
  };

  /**
   * Handle updated items
   * @param {Number[]} ids
   * @protected
   */
  ItemSet.prototype._onUpdate = function (ids) {
    var me = this;

    ids.forEach(function (id) {
      var itemData = me.itemsData.get(id, me.itemOptions);
      var item = me.items[id];
      var type = itemData ? me._getType(itemData) : null;

      var constructor = ItemSet.types[type];
      var selected;

      if (item) {
        // update item   	
        if (!constructor || !(item instanceof constructor)) {
          // item type has changed, delete the item and recreate it
          selected = item.selected; // preserve selection of this item
          me._removeItem(item);
          item = null;
        } else {
          me._updateItem(item, itemData);
        }
      }

      if (!item && itemData) {
        // create item
        if (constructor) {
          item = new constructor(itemData, me.conversion, me.options);
          item.id = id; // TODO: not so nice setting id afterwards

          me._addItem(item);
          if (selected) {
            this.selection.push(id);
            item.select();
          }
        } else if (type == 'rangeoverflow') {
          // TODO: deprecated since version 2.1.0 (or 3.0.0?). cleanup some day
          throw new TypeError('Item type "rangeoverflow" is deprecated. Use css styling instead: ' + '.vis-item.vis-range .vis-item-content {overflow: visible;}');
        } else {
          throw new TypeError('Unknown item type "' + type + '"');
        }
      }
    }.bind(this));

    this._order();
    this.stackDirty = true; // force re-stacking of all items next redraw
    this.body.emitter.emit('_change', { queue: true });
  };

  /**
   * Handle added items
   * @param {Number[]} ids
   * @protected
   */
  ItemSet.prototype._onAdd = ItemSet.prototype._onUpdate;

  /**
   * Handle removed items
   * @param {Number[]} ids
   * @protected
   */
  ItemSet.prototype._onRemove = function (ids) {
    var count = 0;
    var me = this;
    ids.forEach(function (id) {
      var item = me.items[id];
      if (item) {
        count++;
        me._removeItem(item);
      }
    });

    if (count) {
      // update order
      this._order();
      this.stackDirty = true; // force re-stacking of all items next redraw
      this.body.emitter.emit('_change', { queue: true });
    }
  };

  /**
   * Update the order of item in all groups
   * @private
   */
  ItemSet.prototype._order = function () {
    // reorder the items in all groups
    // TODO: optimization: only reorder groups affected by the changed items
    util.forEach(this.groups, function (group) {
      group.order();
    });
  };

  /**
   * Handle updated groups
   * @param {Number[]} ids
   * @private
   */
  ItemSet.prototype._onUpdateGroups = function (ids) {
    this._onAddGroups(ids);
  };

  /**
   * Handle changed groups (added or updated)
   * @param {Number[]} ids
   * @private
   */
  ItemSet.prototype._onAddGroups = function (ids) {
    var me = this;

    ids.forEach(function (id) {
      var groupData = me.groupsData.get(id);
      var group = me.groups[id];

      if (!group) {
        // check for reserved ids
        if (id == UNGROUPED || id == BACKGROUND) {
          throw new Error('Illegal group id. ' + id + ' is a reserved id.');
        }

        var groupOptions = (0, _create2['default'])(me.options);
        util.extend(groupOptions, {
          height: null
        });

        group = new Group(id, groupData, me);
        me.groups[id] = group;

        // add items with this groupId to the new group
        for (var itemId in me.items) {
          if (me.items.hasOwnProperty(itemId)) {
            var item = me.items[itemId];
            if (item.data.group == id) {
              group.add(item);
            }
          }
        }

        group.order();
        group.show();
      } else {
        // update group
        group.setData(groupData);
      }
    });

    this.body.emitter.emit('_change', { queue: true });
  };

  /**
   * Handle removed groups
   * @param {Number[]} ids
   * @private
   */
  ItemSet.prototype._onRemoveGroups = function (ids) {
    var groups = this.groups;
    ids.forEach(function (id) {
      var group = groups[id];

      if (group) {
        group.hide();
        delete groups[id];
      }
    });

    this.markDirty();

    this.body.emitter.emit('_change', { queue: true });
  };

  /**
   * Reorder the groups if needed
   * @return {boolean} changed
   * @private
   */
  ItemSet.prototype._orderGroups = function () {
    if (this.groupsData) {
      // reorder the groups
      var groupIds = this.groupsData.getIds({
        order: this.options.groupOrder
      });

      groupIds = this._orderNestedGroups(groupIds);

      var changed = !util.equalArray(groupIds, this.groupIds);
      if (changed) {
        // hide all groups, removes them from the DOM
        var groups = this.groups;
        groupIds.forEach(function (groupId) {
          groups[groupId].hide();
        });

        // show the groups again, attach them to the DOM in correct order
        groupIds.forEach(function (groupId) {
          groups[groupId].show();
        });

        this.groupIds = groupIds;
      }

      return changed;
    } else {
      return false;
    }
  };

  /**
   * Reorder the nested groups
   * @return {boolean} changed
   * @private
   */
  ItemSet.prototype._orderNestedGroups = function (groupIds) {
    var newGroupIdsOrder = [];

    groupIds.forEach(function (groupId) {
      var groupData = this.groupsData.get(groupId);
      if (!groupData.nestedInGroup) {
        newGroupIdsOrder.push(groupId);
      }
      if (groupData.nestedGroups) {
        var nestedGroups = this.groupsData.get({
          filter: function filter(nestedGroup) {
            return nestedGroup.nestedInGroup == groupId;
          }
        });
        var nestedGroupIds = nestedGroups.map(function (nestedGroup) {
          return nestedGroup.id;
        });
        newGroupIdsOrder = newGroupIdsOrder.concat(nestedGroupIds);
      }
    }, this);
    return newGroupIdsOrder;
  };

  /**
   * Add a new item
   * @param {Item} item
   * @private
   */
  ItemSet.prototype._addItem = function (item) {
    this.items[item.id] = item;

    // add to group
    var groupId = this._getGroupId(item.data);
    var group = this.groups[groupId];

    if (!group) {
      item.groupShowing = false;
    } else if (group && group.data && group.data.showNested) {
      item.groupShowing = true;
    }

    if (group) group.add(item);
  };

  /**
   * Update an existing item
   * @param {Item} item
   * @param {Object} itemData
   * @private
   */
  ItemSet.prototype._updateItem = function (item, itemData) {
    var oldGroupId = item.data.group;
    var oldSubGroupId = item.data.subgroup;

    // update the items data (will redraw the item when displayed)
    item.setData(itemData);

    var groupId = this._getGroupId(item.data);
    var group = this.groups[groupId];
    if (!group) {
      item.groupShowing = false;
    } else if (group && group.data && group.data.showNested) {
      item.groupShowing = true;
    }
    // update group
    if (oldGroupId != item.data.group || oldSubGroupId != item.data.subgroup) {
      var oldGroup = this.groups[oldGroupId];
      if (oldGroup) oldGroup.remove(item);
      if (group) group.add(item);
    }
  };

  /**
   * Delete an item from the ItemSet: remove it from the DOM, from the map
   * with items, and from the map with visible items, and from the selection
   * @param {Item} item
   * @private
   */
  ItemSet.prototype._removeItem = function (item) {
    // remove from DOM
    item.hide();

    // remove from items
    delete this.items[item.id];

    // remove from selection
    var index = this.selection.indexOf(item.id);
    if (index != -1) this.selection.splice(index, 1);

    // remove from group
    item.parent && item.parent.remove(item);
  };

  /**
   * Create an array containing all items being a range (having an end date)
   * @param array
   * @returns {Array}
   * @private
   */
  ItemSet.prototype._constructByEndArray = function (array) {
    var endArray = [];

    for (var i = 0; i < array.length; i++) {
      if (array[i] instanceof RangeItem) {
        endArray.push(array[i]);
      }
    }
    return endArray;
  };

  /**
   * Register the clicked item on touch, before dragStart is initiated.
   *
   * dragStart is initiated from a mousemove event, AFTER the mouse/touch is
   * already moving. Therefore, the mouse/touch can sometimes be above an other
   * DOM element than the item itself.
   *
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onTouch = function (event) {
    // store the touched item, used in _onDragStart
    this.touchParams.item = this.itemFromTarget(event);
    this.touchParams.dragLeftItem = event.target.dragLeftItem || false;
    this.touchParams.dragRightItem = event.target.dragRightItem || false;
    this.touchParams.itemProps = null;
  };

  /**
   * Given an group id, returns the index it has.
   *
   * @param {Number} groupID
   * @private
   */
  ItemSet.prototype._getGroupIndex = function (groupId) {
    for (var i = 0; i < this.groupIds.length; i++) {
      if (groupId == this.groupIds[i]) return i;
    }
  };

  /**
   * Start dragging the selected events
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onDragStart = function (event) {
    if (this.touchParams.itemIsDragging) {
      return;
    }
    var item = this.touchParams.item || null;
    var me = this;
    var props;

    if (item && (item.selected || this.options.itemsAlwaysDraggable)) {

      if (this.options.editable.overrideItems && !this.options.editable.updateTime && !this.options.editable.updateGroup) {
        return;
      }

      // override options.editable
      if (item.editable != null && !item.editable.updateTime && !item.editable.updateGroup && !this.options.editable.overrideItems) {
        return;
      }

      var dragLeftItem = this.touchParams.dragLeftItem;
      var dragRightItem = this.touchParams.dragRightItem;
      this.touchParams.itemIsDragging = true;
      this.touchParams.selectedItem = item;

      if (dragLeftItem) {
        props = {
          item: dragLeftItem,
          initialX: event.center.x,
          dragLeft: true,
          data: this._cloneItemData(item.data)
        };

        this.touchParams.itemProps = [props];
      } else if (dragRightItem) {
        props = {
          item: dragRightItem,
          initialX: event.center.x,
          dragRight: true,
          data: this._cloneItemData(item.data)
        };

        this.touchParams.itemProps = [props];
      } else {
        var baseGroupIndex = this._getGroupIndex(item.data.group);

        var itemsToDrag = this.options.itemsAlwaysDraggable && !item.selected ? [item.id] : this.getSelection();

        this.touchParams.itemProps = itemsToDrag.map(function (id) {
          var item = me.items[id];
          var groupIndex = me._getGroupIndex(item.data.group);
          return {
            item: item,
            initialX: event.center.x,
            groupOffset: baseGroupIndex - groupIndex,
            data: this._cloneItemData(item.data)
          };
        }.bind(this));
      }

      event.stopPropagation();
    } else if (this.options.editable.add && (event.srcEvent.ctrlKey || event.srcEvent.metaKey)) {
      // create a new range item when dragging with ctrl key down
      this._onDragStartAddItem(event);
    }
  };

  /**
   * Start creating a new range item by dragging.
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onDragStartAddItem = function (event) {
    var snap = this.options.snap || null;

    if (this.options.rtl) {
      var xAbs = util.getAbsoluteRight(this.dom.frame);
      var x = xAbs - event.center.x + 10; // plus 10 to compensate for the drag starting as soon as you've moved 10px
    } else {
      var xAbs = util.getAbsoluteLeft(this.dom.frame);
      var x = event.center.x - xAbs - 10; // minus 10 to compensate for the drag starting as soon as you've moved 10px
    }

    var time = this.body.util.toTime(x);
    var scale = this.body.util.getScale();
    var step = this.body.util.getStep();
    var start = snap ? snap(time, scale, step) : time;
    var end = start;

    var itemData = {
      type: 'range',
      start: start,
      end: end,
      content: 'new item'
    };

    var id = util.randomUUID();
    itemData[this.itemsData._fieldId] = id;

    var group = this.groupFromTarget(event);
    if (group) {
      itemData.group = group.groupId;
    }
    var newItem = new RangeItem(itemData, this.conversion, this.options);
    newItem.id = id; // TODO: not so nice setting id afterwards
    newItem.data = this._cloneItemData(itemData);
    this._addItem(newItem);
    this.touchParams.selectedItem = newItem;

    var props = {
      item: newItem,
      initialX: event.center.x,
      data: newItem.data
    };

    if (this.options.rtl) {
      props.dragLeft = true;
    } else {
      props.dragRight = true;
    }
    this.touchParams.itemProps = [props];

    event.stopPropagation();
  };

  /**
   * Drag selected items
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onDrag = function (event) {
    if (this.touchParams.itemProps) {
      event.stopPropagation();

      var me = this;
      var snap = this.options.snap || null;

      if (this.options.rtl) {
        var xOffset = this.body.dom.root.offsetLeft + this.body.domProps.right.width;
      } else {
        var xOffset = this.body.dom.root.offsetLeft + this.body.domProps.left.width;
      }

      var scale = this.body.util.getScale();
      var step = this.body.util.getStep();

      //only calculate the new group for the item that's actually dragged
      var selectedItem = this.touchParams.selectedItem;
      var updateGroupAllowed = (this.options.editable.overrideItems || selectedItem.editable == null) && this.options.editable.updateGroup || !this.options.editable.overrideItems && selectedItem.editable != null && selectedItem.editable.updateGroup;
      var newGroupBase = null;
      if (updateGroupAllowed && selectedItem) {
        if (selectedItem.data.group != undefined) {
          // drag from one group to another
          var group = me.groupFromTarget(event);
          if (group) {
            //we know the offset for all items, so the new group for all items
            //will be relative to this one.
            newGroupBase = this._getGroupIndex(group.groupId);
          }
        }
      }

      // move
      this.touchParams.itemProps.forEach(function (props) {
        var current = me.body.util.toTime(event.center.x - xOffset);
        var initial = me.body.util.toTime(props.initialX - xOffset);

        if (this.options.rtl) {
          var offset = -(current - initial); // ms
        } else {
          var offset = current - initial; // ms
        }

        var itemData = this._cloneItemData(props.item.data); // clone the data
        if (props.item.editable != null && !props.item.editable.updateTime && !props.item.editable.updateGroup && !me.options.editable.overrideItems) {
          return;
        }

        var updateTimeAllowed = (this.options.editable.overrideItems || selectedItem.editable == null) && this.options.editable.updateTime || !this.options.editable.overrideItems && selectedItem.editable != null && selectedItem.editable.updateTime;
        if (updateTimeAllowed) {
          if (props.dragLeft) {
            // drag left side of a range item
            if (this.options.rtl) {
              if (itemData.end != undefined) {
                var initialEnd = util.convert(props.data.end, 'Date');
                var end = new Date(initialEnd.valueOf() + offset);
                // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
                itemData.end = snap ? snap(end, scale, step) : end;
              }
            } else {
              if (itemData.start != undefined) {
                var initialStart = util.convert(props.data.start, 'Date');
                var start = new Date(initialStart.valueOf() + offset);
                // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
                itemData.start = snap ? snap(start, scale, step) : start;
              }
            }
          } else if (props.dragRight) {
            // drag right side of a range item
            if (this.options.rtl) {
              if (itemData.start != undefined) {
                var initialStart = util.convert(props.data.start, 'Date');
                var start = new Date(initialStart.valueOf() + offset);
                // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
                itemData.start = snap ? snap(start, scale, step) : start;
              }
            } else {
              if (itemData.end != undefined) {
                var initialEnd = util.convert(props.data.end, 'Date');
                var end = new Date(initialEnd.valueOf() + offset);
                // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
                itemData.end = snap ? snap(end, scale, step) : end;
              }
            }
          } else {
            // drag both start and end
            if (itemData.start != undefined) {

              var initialStart = util.convert(props.data.start, 'Date').valueOf();
              var start = new Date(initialStart + offset);

              if (itemData.end != undefined) {
                var initialEnd = util.convert(props.data.end, 'Date');
                var duration = initialEnd.valueOf() - initialStart.valueOf();

                // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
                itemData.start = snap ? snap(start, scale, step) : start;
                itemData.end = new Date(itemData.start.valueOf() + duration);
              } else {
                // TODO: pass a Moment instead of a Date to snap(). (Breaking change)
                itemData.start = snap ? snap(start, scale, step) : start;
              }
            }
          }
        }

        if (updateGroupAllowed && !props.dragLeft && !props.dragRight && newGroupBase != null) {
          if (itemData.group != undefined) {
            var newOffset = newGroupBase - props.groupOffset;

            //make sure we stay in bounds
            newOffset = Math.max(0, newOffset);
            newOffset = Math.min(me.groupIds.length - 1, newOffset);

            itemData.group = me.groupIds[newOffset];
          }
        }

        // confirm moving the item
        itemData = this._cloneItemData(itemData); // convert start and end to the correct type
        me.options.onMoving(itemData, function (itemData) {
          if (itemData) {
            props.item.setData(this._cloneItemData(itemData, 'Date'));
          }
        }.bind(this));
      }.bind(this));

      this.stackDirty = true; // force re-stacking of all items next redraw
      this.body.emitter.emit('_change');
    }
  };

  /**
   * Move an item to another group
   * @param {Item} item
   * @param {String | Number} groupId
   * @private
   */
  ItemSet.prototype._moveToGroup = function (item, groupId) {
    var group = this.groups[groupId];
    if (group && group.groupId != item.data.group) {
      var oldGroup = item.parent;
      oldGroup.remove(item);
      oldGroup.order();
      group.add(item);
      group.order();

      item.data.group = group.groupId;
    }
  };

  /**
   * End of dragging selected items
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onDragEnd = function (event) {
    this.touchParams.itemIsDragging = false;
    if (this.touchParams.itemProps) {
      event.stopPropagation();

      var me = this;
      var dataset = this.itemsData.getDataSet();
      var itemProps = this.touchParams.itemProps;
      this.touchParams.itemProps = null;

      itemProps.forEach(function (props) {
        var id = props.item.id;
        var exists = me.itemsData.get(id, me.itemOptions) != null;

        if (!exists) {
          // add a new item
          me.options.onAdd(props.item.data, function (itemData) {
            me._removeItem(props.item); // remove temporary item
            if (itemData) {
              me.itemsData.getDataSet().add(itemData);
            }

            // force re-stacking of all items next redraw
            me.stackDirty = true;
            me.body.emitter.emit('_change');
          });
        } else {
          // update existing item
          var itemData = this._cloneItemData(props.item.data); // convert start and end to the correct type
          me.options.onMove(itemData, function (itemData) {
            if (itemData) {
              // apply changes
              itemData[dataset._fieldId] = id; // ensure the item contains its id (can be undefined)
              dataset.update(itemData);
            } else {
              // restore original values
              props.item.setData(props.data);

              me.stackDirty = true; // force re-stacking of all items next redraw
              me.body.emitter.emit('_change');
            }
          });
        }
      }.bind(this));
    }
  };

  ItemSet.prototype._onGroupClick = function (event) {
    var group = this.groupFromTarget(event);

    if (!group.nestedGroups) return;

    var groupsData = this.groupsData;
    if (this.groupsData instanceof DataView) {
      groupsData = this.groupsData.getDataSet();
    }

    group.showNested = !group.showNested;

    var nestedGroups = groupsData.get(group.nestedGroups).map(function (nestedGroup) {
      if (nestedGroup.visible == undefined) {
        nestedGroup.visible = true;
      }
      nestedGroup.visible = !!group.showNested;
      return nestedGroup;
    });
    groupsData.update(nestedGroups);

    if (group.showNested) {
      util.removeClassName(group.dom.label, 'collapsed');
      util.addClassName(group.dom.label, 'expanded');
    } else {
      util.removeClassName(group.dom.label, 'expanded');
      var collapsedDirClassName = this.options.rtl ? 'collapsed-rtl' : 'collapsed';
      util.addClassName(group.dom.label, collapsedDirClassName);
    }
  };

  ItemSet.prototype._onGroupDragStart = function (event) {
    if (this.options.groupEditable.order) {
      this.groupTouchParams.group = this.groupFromTarget(event);

      if (this.groupTouchParams.group) {
        event.stopPropagation();

        this.groupTouchParams.originalOrder = this.groupsData.getIds({
          order: this.options.groupOrder
        });
      }
    }
  };

  ItemSet.prototype._onGroupDrag = function (event) {
    if (this.options.groupEditable.order && this.groupTouchParams.group) {
      event.stopPropagation();

      var groupsData = this.groupsData;
      if (this.groupsData instanceof DataView) {
        groupsData = this.groupsData.getDataSet();
      }
      // drag from one group to another
      var group = this.groupFromTarget(event);

      // try to avoid toggling when groups differ in height
      if (group && group.height != this.groupTouchParams.group.height) {
        var movingUp = group.top < this.groupTouchParams.group.top;
        var clientY = event.center ? event.center.y : event.clientY;
        var targetGroupTop = util.getAbsoluteTop(group.dom.foreground);
        var draggedGroupHeight = this.groupTouchParams.group.height;
        if (movingUp) {
          // skip swapping the groups when the dragged group is not below clientY afterwards
          if (targetGroupTop + draggedGroupHeight < clientY) {
            return;
          }
        } else {
          var targetGroupHeight = group.height;
          // skip swapping the groups when the dragged group is not below clientY afterwards
          if (targetGroupTop + targetGroupHeight - draggedGroupHeight > clientY) {
            return;
          }
        }
      }

      if (group && group != this.groupTouchParams.group) {
        var targetGroup = groupsData.get(group.groupId);
        var draggedGroup = groupsData.get(this.groupTouchParams.group.groupId);

        // switch groups
        if (draggedGroup && targetGroup) {
          this.options.groupOrderSwap(draggedGroup, targetGroup, groupsData);
          groupsData.update(draggedGroup);
          groupsData.update(targetGroup);
        }

        // fetch current order of groups
        var newOrder = groupsData.getIds({
          order: this.options.groupOrder
        });

        // in case of changes since _onGroupDragStart
        if (!util.equalArray(newOrder, this.groupTouchParams.originalOrder)) {
          var origOrder = this.groupTouchParams.originalOrder;
          var draggedId = this.groupTouchParams.group.groupId;
          var numGroups = Math.min(origOrder.length, newOrder.length);
          var curPos = 0;
          var newOffset = 0;
          var orgOffset = 0;
          while (curPos < numGroups) {
            // as long as the groups are where they should be step down along the groups order
            while (curPos + newOffset < numGroups && curPos + orgOffset < numGroups && newOrder[curPos + newOffset] == origOrder[curPos + orgOffset]) {
              curPos++;
            }

            // all ok
            if (curPos + newOffset >= numGroups) {
              break;
            }

            // not all ok
            // if dragged group was move upwards everything below should have an offset
            if (newOrder[curPos + newOffset] == draggedId) {
              newOffset = 1;
              continue;
            }
            // if dragged group was move downwards everything above should have an offset
            else if (origOrder[curPos + orgOffset] == draggedId) {
                orgOffset = 1;
                continue;
              }
              // found a group (apart from dragged group) that has the wrong position -> switch with the 
              // group at the position where other one should be, fix index arrays and continue
              else {
                  var slippedPosition = newOrder.indexOf(origOrder[curPos + orgOffset]);
                  var switchGroup = groupsData.get(newOrder[curPos + newOffset]);
                  var shouldBeGroup = groupsData.get(origOrder[curPos + orgOffset]);
                  this.options.groupOrderSwap(switchGroup, shouldBeGroup, groupsData);
                  groupsData.update(switchGroup);
                  groupsData.update(shouldBeGroup);

                  var switchGroupId = newOrder[curPos + newOffset];
                  newOrder[curPos + newOffset] = origOrder[curPos + orgOffset];
                  newOrder[slippedPosition] = switchGroupId;

                  curPos++;
                }
          }
        }
      }
    }
  };

  ItemSet.prototype._onGroupDragEnd = function (event) {
    if (this.options.groupEditable.order && this.groupTouchParams.group) {
      event.stopPropagation();

      // update existing group
      var me = this;
      var id = me.groupTouchParams.group.groupId;
      var dataset = me.groupsData.getDataSet();
      var groupData = util.extend({}, dataset.get(id)); // clone the data
      me.options.onMoveGroup(groupData, function (groupData) {
        if (groupData) {
          // apply changes
          groupData[dataset._fieldId] = id; // ensure the group contains its id (can be undefined)
          dataset.update(groupData);
        } else {

          // fetch current order of groups
          var newOrder = dataset.getIds({
            order: me.options.groupOrder
          });

          // restore original order
          if (!util.equalArray(newOrder, me.groupTouchParams.originalOrder)) {
            var origOrder = me.groupTouchParams.originalOrder;
            var numGroups = Math.min(origOrder.length, newOrder.length);
            var curPos = 0;
            while (curPos < numGroups) {
              // as long as the groups are where they should be step down along the groups order
              while (curPos < numGroups && newOrder[curPos] == origOrder[curPos]) {
                curPos++;
              }

              // all ok
              if (curPos >= numGroups) {
                break;
              }

              // found a group that has the wrong position -> switch with the 
              // group at the position where other one should be, fix index arrays and continue
              var slippedPosition = newOrder.indexOf(origOrder[curPos]);
              var switchGroup = dataset.get(newOrder[curPos]);
              var shouldBeGroup = dataset.get(origOrder[curPos]);
              me.options.groupOrderSwap(switchGroup, shouldBeGroup, dataset);
              groupsData.update(switchGroup);
              groupsData.update(shouldBeGroup);

              var switchGroupId = newOrder[curPos];
              newOrder[curPos] = origOrder[curPos];
              newOrder[slippedPosition] = switchGroupId;

              curPos++;
            }
          }
        }
      });

      me.body.emitter.emit('groupDragged', { groupId: id });
    }
  };

  /**
   * Handle selecting/deselecting an item when tapping it
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onSelectItem = function (event) {
    if (!this.options.selectable) return;

    var ctrlKey = event.srcEvent && (event.srcEvent.ctrlKey || event.srcEvent.metaKey);
    var shiftKey = event.srcEvent && event.srcEvent.shiftKey;
    if (ctrlKey || shiftKey) {
      this._onMultiSelectItem(event);
      return;
    }

    var oldSelection = this.getSelection();

    var item = this.itemFromTarget(event);
    var selection = item ? [item.id] : [];
    this.setSelection(selection);

    var newSelection = this.getSelection();

    // emit a select event,
    // except when old selection is empty and new selection is still empty
    if (newSelection.length > 0 || oldSelection.length > 0) {
      this.body.emitter.emit('select', {
        items: newSelection,
        event: util.elementsCensor(event)
      });
    }
  };

  /**
   * Handle hovering an item
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onMouseOver = function (event) {
    var item = this.itemFromTarget(event);
    if (!item) return;

    // Item we just left
    var related = this.itemFromRelatedTarget(event);
    if (item === related) {
      // We haven't changed item, just element in the item
      return;
    }

    if (item.getTitle()) {
      if (item.popup == null) {
        item.setPopup(new _Popup2['default'](this.body.dom.root, this.options.tooltip.overflowMethod || 'flip'));
      }

      var container = this.body.dom.centerContainer;
      item.popup.setPosition(event.clientX - util.getAbsoluteLeft(container) + container.offsetLeft, event.clientY - util.getAbsoluteTop(container) + container.offsetTop);
      item.popup.show();
    }

    this.body.emitter.emit('itemover', {
      item: item.id,
      event: util.elementsCensor(event)
    });
  };
  ItemSet.prototype._onMouseOut = function (event) {
    var item = this.itemFromTarget(event);
    if (!item) return;

    // Item we are going to
    var related = this.itemFromRelatedTarget(event);
    if (item === related) {
      // We aren't changing item, just element in the item
      return;
    }

    if (item.popup != null) {
      item.popup.hide();
    }

    this.body.emitter.emit('itemout', {
      item: item.id,
      event: util.elementsCensor(event)
    });
  };
  ItemSet.prototype._onMouseMove = function (event) {
    var item = this.itemFromTarget(event);
    if (!item) return;

    if (this.options.tooltip.followMouse) {
      if (item.popup) {
        if (!item.popup.hidden) {
          var container = this.body.dom.centerContainer;
          item.popup.setPosition(event.clientX - util.getAbsoluteLeft(container) + container.offsetLeft, event.clientY - util.getAbsoluteTop(container) + container.offsetTop);
          item.popup.show(); // Redraw
        }
      }
    }
  };

  /**
   * Handle mousewheel
   * @param event
   * @private
   */
  ItemSet.prototype._onMouseWheel = function (event) {
    if (this.touchParams.itemIsDragging) {
      this._onDragEnd(event);
    }
  };

  /**
   * Handle updates of an item on double tap
   * @param event
   * @private
   */
  ItemSet.prototype._onUpdateItem = function (item) {
    if (!this.options.selectable) return;
    if (!this.options.editable.add) return;

    var me = this;

    if (item) {
      // execute async handler to update the item (or cancel it)
      var itemData = me.itemsData.get(item.id); // get a clone of the data from the dataset
      this.options.onUpdate(itemData, function (itemData) {
        if (itemData) {
          me.itemsData.getDataSet().update(itemData);
        }
      });
    }
  };

  /**
   * Handle creation of an item on double tap
   * @param event
   * @private
   */
  ItemSet.prototype._onAddItem = function (event) {
    if (!this.options.selectable) return;
    if (!this.options.editable.add) return;

    var me = this;
    var snap = this.options.snap || null;
    var item = this.itemFromTarget(event);

    if (!item) {
      // add item
      if (this.options.rtl) {
        var xAbs = util.getAbsoluteRight(this.dom.frame);
        var x = xAbs - event.center.x;
      } else {
        var xAbs = util.getAbsoluteLeft(this.dom.frame);
        var x = event.center.x - xAbs;
      }
      // var xAbs = util.getAbsoluteLeft(this.dom.frame);
      // var x = event.center.x - xAbs;
      var start = this.body.util.toTime(x);
      var scale = this.body.util.getScale();
      var step = this.body.util.getStep();

      var newItemData = {
        start: snap ? snap(start, scale, step) : start,
        content: 'new item'
      };

      if (event.type == 'drop') {
        var itemData = JSON.parse(event.dataTransfer.getData("text"));
        newItemData.content = itemData.content; // content is required 
        newItemData.type = itemData.type || 'box';
        newItemData[this.itemsData._fieldId] = itemData.id || util.randomUUID();

        if (itemData.type == 'range' || itemData.end && itemData.start) {
          if (!itemData.end) {
            var end = this.body.util.toTime(x + this.props.width / 5);
            newItemData.end = snap ? snap(end, scale, step) : end;
          } else {
            newItemData.end = itemData.end;
            newItemData.start = itemData.start;
          }
        }
      } else {
        newItemData[this.itemsData._fieldId] = util.randomUUID();

        // when default type is a range, add a default end date to the new item
        if (this.options.type === 'range') {
          var end = this.body.util.toTime(x + this.props.width / 5);
          newItemData.end = snap ? snap(end, scale, step) : end;
        }
      }

      var group = this.groupFromTarget(event);
      if (group) {
        newItemData.group = group.groupId;
      }

      // execute async handler to customize (or cancel) adding an item
      newItemData = this._cloneItemData(newItemData); // convert start and end to the correct type
      this.options.onAdd(newItemData, function (item) {
        if (item) {
          me.itemsData.getDataSet().add(item);
          if (event.type == 'drop') {
            me.setSelection([item.id]);
          }
          // TODO: need to trigger a redraw?
        }
      });
    }
  };

  /**
   * Handle selecting/deselecting multiple items when holding an item
   * @param {Event} event
   * @private
   */
  ItemSet.prototype._onMultiSelectItem = function (event) {
    if (!this.options.selectable) return;

    var item = this.itemFromTarget(event);

    if (item) {
      // multi select items (if allowed)

      var selection = this.options.multiselect ? this.getSelection() // take current selection
      : []; // deselect current selection

      var shiftKey = event.srcEvent && event.srcEvent.shiftKey || false;

      if (shiftKey && this.options.multiselect) {
        // select all items between the old selection and the tapped item
        var itemGroup = this.itemsData.get(item.id).group;

        // when filtering get the group of the last selected item
        var lastSelectedGroup = undefined;
        if (this.options.multiselectPerGroup) {
          if (selection.length > 0) {
            lastSelectedGroup = this.itemsData.get(selection[0]).group;
          }
        }

        // determine the selection range
        if (!this.options.multiselectPerGroup || lastSelectedGroup == undefined || lastSelectedGroup == itemGroup) {
          selection.push(item.id);
        }
        var range = ItemSet._getItemRange(this.itemsData.get(selection, this.itemOptions));

        if (!this.options.multiselectPerGroup || lastSelectedGroup == itemGroup) {
          // select all items within the selection range
          selection = [];
          for (var id in this.items) {
            if (this.items.hasOwnProperty(id)) {
              var _item = this.items[id];
              var start = _item.data.start;
              var end = _item.data.end !== undefined ? _item.data.end : start;

              if (start >= range.min && end <= range.max && (!this.options.multiselectPerGroup || lastSelectedGroup == this.itemsData.get(_item.id).group) && !(_item instanceof BackgroundItem)) {
                selection.push(_item.id); // do not use id but item.id, id itself is stringified
              }
            }
          }
        }
      } else {
        // add/remove this item from the current selection
        var index = selection.indexOf(item.id);
        if (index == -1) {
          // item is not yet selected -> select it
          selection.push(item.id);
        } else {
          // item is already selected -> deselect it
          selection.splice(index, 1);
        }
      }

      this.setSelection(selection);

      this.body.emitter.emit('select', {
        items: this.getSelection(),
        event: util.elementsCensor(event)
      });
    }
  };

  /**
   * Calculate the time range of a list of items
   * @param {Array.<Object>} itemsData
   * @return {{min: Date, max: Date}} Returns the range of the provided items
   * @private
   */
  ItemSet._getItemRange = function (itemsData) {
    var max = null;
    var min = null;

    itemsData.forEach(function (data) {
      if (min == null || data.start < min) {
        min = data.start;
      }

      if (data.end != undefined) {
        if (max == null || data.end > max) {
          max = data.end;
        }
      } else {
        if (max == null || data.start > max) {
          max = data.start;
        }
      }
    });

    return {
      min: min,
      max: max
    };
  };

  /**
   * Find an item from an element:
   * searches for the attribute 'timeline-item' in the element's tree
   * @param {HTMLElement} element
   * @return {Item | null} item
   */
  ItemSet.prototype.itemFromElement = function (element) {
    var cur = element;
    while (cur) {
      if (cur.hasOwnProperty('timeline-item')) {
        return cur['timeline-item'];
      }
      cur = cur.parentNode;
    }

    return null;
  };

  /**
   * Find an item from an event target:
   * searches for the attribute 'timeline-item' in the event target's element tree
   * @param {Event} event
   * @return {Item | null} item
   */
  ItemSet.prototype.itemFromTarget = function (event) {
    return this.itemFromElement(event.target);
  };

  /**
   * Find an item from an event's related target:
   * searches for the attribute 'timeline-item' in the related target's element tree
   * @param {Event} event
   * @return {Item | null} item
   */
  ItemSet.prototype.itemFromRelatedTarget = function (event) {
    return this.itemFromElement(event.relatedTarget);
  };

  /**
   * Find the Group from an event target:
   * searches for the attribute 'timeline-group' in the event target's element tree
   * @param {Event} event
   * @return {Group | null} group
   */
  ItemSet.prototype.groupFromTarget = function (event) {
    var clientY = event.center ? event.center.y : event.clientY;
    for (var i = 0; i < this.groupIds.length; i++) {
      var groupId = this.groupIds[i];
      var group = this.groups[groupId];
      var foreground = group.dom.foreground;
      var top = util.getAbsoluteTop(foreground);
      if (clientY > top && clientY < top + foreground.offsetHeight) {
        return group;
      }

      if (this.options.orientation.item === 'top') {
        if (i === this.groupIds.length - 1 && clientY > top) {
          return group;
        }
      } else {
        if (i === 0 && clientY < top + foreground.offset) {
          return group;
        }
      }
    }

    return null;
  };

  /**
   * Find the ItemSet from an event target:
   * searches for the attribute 'timeline-itemset' in the event target's element tree
   * @param {Event} event
   * @return {ItemSet | null} item
   */
  ItemSet.itemSetFromTarget = function (event) {
    var target = event.target;
    while (target) {
      if (target.hasOwnProperty('timeline-itemset')) {
        return target['timeline-itemset'];
      }
      target = target.parentNode;
    }

    return null;
  };

  /**
   * Clone the data of an item, and "normalize" it: convert the start and end date
   * to the type (Date, Moment, ...) configured in the DataSet. If not configured,
   * start and end are converted to Date.
   * @param {Object} itemData, typically `item.data`
   * @param {string} [type]  Optional Date type. If not provided, the type from the DataSet is taken
   * @return {Object} The cloned object
   * @private
   */
  ItemSet.prototype._cloneItemData = function (itemData, type) {
    var clone = util.extend({}, itemData);

    if (!type) {
      // convert start and end date to the type (Date, Moment, ...) configured in the DataSet
      type = this.itemsData.getDataSet()._options.type;
    }

    if (clone.start != undefined) {
      clone.start = util.convert(clone.start, type && type.start || 'Date');
    }
    if (clone.end != undefined) {
      clone.end = util.convert(clone.end, type && type.end || 'Date');
    }

    return clone;
  };

  module.exports = ItemSet;

/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _classCallCheck2 = __webpack_require__(115);

  var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

  var _createClass2 = __webpack_require__(116);

  var _createClass3 = _interopRequireDefault(_createClass2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  /**
   * Popup is a class to create a popup window with some text
   * @param {Element} container       The container object.
   * @param {string}  overflowMethod  How the popup should act to overflowing ('flip' or 'cap')
   */
  var Popup = function () {
    function Popup(container, overflowMethod) {
      (0, _classCallCheck3['default'])(this, Popup);

      this.container = container;
      this.overflowMethod = overflowMethod || 'cap';

      this.x = 0;
      this.y = 0;
      this.padding = 5;
      this.hidden = false;

      // create the frame
      this.frame = document.createElement('div');
      this.frame.className = 'vis-tooltip';
      this.container.appendChild(this.frame);
    }

    /**
     * @param {number} x   Horizontal position of the popup window
     * @param {number} y   Vertical position of the popup window
     */


    (0, _createClass3['default'])(Popup, [{
      key: 'setPosition',
      value: function setPosition(x, y) {
        this.x = parseInt(x);
        this.y = parseInt(y);
      }

      /**
       * Set the content for the popup window. This can be HTML code or text.
       * @param {string | Element} content
       */

    }, {
      key: 'setText',
      value: function setText(content) {
        if (content instanceof Element) {
          this.frame.innerHTML = '';
          this.frame.appendChild(content);
        } else {
          this.frame.innerHTML = content; // string containing text or HTML
        }
      }

      /**
       * Show the popup window
       * @param {boolean} [doShow]    Show or hide the window
       */

    }, {
      key: 'show',
      value: function show(doShow) {
        if (doShow === undefined) {
          doShow = true;
        }

        if (doShow === true) {
          var height = this.frame.clientHeight;
          var width = this.frame.clientWidth;
          var maxHeight = this.frame.parentNode.clientHeight;
          var maxWidth = this.frame.parentNode.clientWidth;

          var left = 0,
              top = 0;

          if (this.overflowMethod == 'flip') {
            var isLeft = false,
                isTop = true; // Where around the position it's located

            if (this.y - height < this.padding) {
              isTop = false;
            }

            if (this.x + width > maxWidth - this.padding) {
              isLeft = true;
            }

            if (isLeft) {
              left = this.x - width;
            } else {
              left = this.x;
            }

            if (isTop) {
              top = this.y - height;
            } else {
              top = this.y;
            }
          } else {
            top = this.y - height;
            if (top + height + this.padding > maxHeight) {
              top = maxHeight - height - this.padding;
            }
            if (top < this.padding) {
              top = this.padding;
            }

            left = this.x;
            if (left + width + this.padding > maxWidth) {
              left = maxWidth - width - this.padding;
            }
            if (left < this.padding) {
              left = this.padding;
            }
          }

          this.frame.style.left = left + "px";
          this.frame.style.top = top + "px";
          this.frame.style.visibility = "visible";
          this.hidden = false;
        } else {
          this.hide();
        }
      }

      /**
       * Hide the popup window
       */

    }, {
      key: 'hide',
      value: function hide() {
        this.hidden = true;
        this.frame.style.visibility = "hidden";
      }

      /**
       * Remove the popup window
       */

    }, {
      key: 'destroy',
      value: function destroy() {
        this.frame.parentNode.removeChild(this.frame); // Remove element from DOM
      }
    }]);
    return Popup;
  }();

  exports['default'] = Popup;

/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var moment = __webpack_require__(84);
  var DateUtil = __webpack_require__(125);
  var util = __webpack_require__(1);

  /**
   * @constructor  TimeStep
   * The class TimeStep is an iterator for dates. You provide a start date and an
   * end date. The class itself determines the best scale (step size) based on the
   * provided start Date, end Date, and minimumStep.
   *
   * If minimumStep is provided, the step size is chosen as close as possible
   * to the minimumStep but larger than minimumStep. If minimumStep is not
   * provided, the scale is set to 1 DAY.
   * The minimumStep should correspond with the onscreen size of about 6 characters
   *
   * Alternatively, you can set a scale by hand.
   * After creation, you can initialize the class by executing first(). Then you
   * can iterate from the start date to the end date via next(). You can check if
   * the end date is reached with the function hasNext(). After each step, you can
   * retrieve the current date via getCurrent().
   * The TimeStep has scales ranging from milliseconds, seconds, minutes, hours,
   * days, to years.
   *
   * Version: 1.2
   *
   * @param {Date} [start]         The start date, for example new Date(2010, 9, 21)
   *                               or new Date(2010, 9, 21, 23, 45, 00)
   * @param {Date} [end]           The end date
   * @param {Number} [minimumStep] Optional. Minimum step size in milliseconds
   */
  function TimeStep(start, end, minimumStep, hiddenDates) {
    this.moment = moment;

    // variables
    this.current = this.moment();
    this._start = this.moment();
    this._end = this.moment();

    this.autoScale = true;
    this.scale = 'day';
    this.step = 1;

    // initialize the range
    this.setRange(start, end, minimumStep);

    // hidden Dates options
    this.switchedDay = false;
    this.switchedMonth = false;
    this.switchedYear = false;
    if (Array.isArray(hiddenDates)) {
      this.hiddenDates = hiddenDates;
    } else if (hiddenDates != undefined) {
      this.hiddenDates = [hiddenDates];
    } else {
      this.hiddenDates = [];
    }

    this.format = TimeStep.FORMAT; // default formatting
  }

  // Time formatting
  TimeStep.FORMAT = {
    minorLabels: {
      millisecond: 'SSS',
      second: 's',
      minute: 'HH:mm',
      hour: 'HH:mm',
      weekday: 'ddd D',
      day: 'D',
      month: 'MMM',
      year: 'YYYY'
    },
    majorLabels: {
      millisecond: 'HH:mm:ss',
      second: 'D MMMM HH:mm',
      minute: 'ddd D MMMM',
      hour: 'ddd D MMMM',
      weekday: 'MMMM YYYY',
      day: 'MMMM YYYY',
      month: 'YYYY',
      year: ''
    }
  };

  /**
   * Set custom constructor function for moment. Can be used to set dates
   * to UTC or to set a utcOffset.
   * @param {function} moment
   */
  TimeStep.prototype.setMoment = function (moment) {
    this.moment = moment;

    // update the date properties, can have a new utcOffset
    this.current = this.moment(this.current.valueOf());
    this._start = this.moment(this._start.valueOf());
    this._end = this.moment(this._end.valueOf());
  };

  /**
   * Set custom formatting for the minor an major labels of the TimeStep.
   * Both `minorLabels` and `majorLabels` are an Object with properties:
   * 'millisecond', 'second', 'minute', 'hour', 'weekday', 'day', 'month', 'year'.
   * @param {{minorLabels: Object, majorLabels: Object}} format
   */
  TimeStep.prototype.setFormat = function (format) {
    var defaultFormat = util.deepExtend({}, TimeStep.FORMAT);
    this.format = util.deepExtend(defaultFormat, format);
  };

  /**
   * Set a new range
   * If minimumStep is provided, the step size is chosen as close as possible
   * to the minimumStep but larger than minimumStep. If minimumStep is not
   * provided, the scale is set to 1 DAY.
   * The minimumStep should correspond with the onscreen size of about 6 characters
   * @param {Date} [start]      The start date and time.
   * @param {Date} [end]        The end date and time.
   * @param {int} [minimumStep] Optional. Minimum step size in milliseconds
   */
  TimeStep.prototype.setRange = function (start, end, minimumStep) {
    if (!(start instanceof Date) || !(end instanceof Date)) {
      throw "No legal start or end date in method setRange";
    }

    this._start = start != undefined ? this.moment(start.valueOf()) : new Date();
    this._end = end != undefined ? this.moment(end.valueOf()) : new Date();

    if (this.autoScale) {
      this.setMinimumStep(minimumStep);
    }
  };

  /**
   * Set the range iterator to the start date.
   */
  TimeStep.prototype.start = function () {
    this.current = this._start.clone();
    this.roundToMinor();
  };

  /**
   * Round the current date to the first minor date value
   * This must be executed once when the current date is set to start Date
   */
  TimeStep.prototype.roundToMinor = function () {
    // round to floor
    // IMPORTANT: we have no breaks in this switch! (this is no bug)
    // noinspection FallThroughInSwitchStatementJS
    switch (this.scale) {
      case 'year':
        this.current.year(this.step * Math.floor(this.current.year() / this.step));
        this.current.month(0);
      case 'month':
        this.current.date(1);
      case 'day': // intentional fall through
      case 'weekday':
        this.current.hours(0);
      case 'hour':
        this.current.minutes(0);
      case 'minute':
        this.current.seconds(0);
      case 'second':
        this.current.milliseconds(0);
      //case 'millisecond': // nothing to do for milliseconds
    }

    if (this.step != 1) {
      // round down to the first minor value that is a multiple of the current step size
      switch (this.scale) {
        case 'millisecond':
          this.current.subtract(this.current.milliseconds() % this.step, 'milliseconds');break;
        case 'second':
          this.current.subtract(this.current.seconds() % this.step, 'seconds');break;
        case 'minute':
          this.current.subtract(this.current.minutes() % this.step, 'minutes');break;
        case 'hour':
          this.current.subtract(this.current.hours() % this.step, 'hours');break;
        case 'weekday': // intentional fall through
        case 'day':
          this.current.subtract((this.current.date() - 1) % this.step, 'day');break;
        case 'month':
          this.current.subtract(this.current.month() % this.step, 'month');break;
        case 'year':
          this.current.subtract(this.current.year() % this.step, 'year');break;
        default:
          break;
      }
    }
  };

  /**
   * Check if the there is a next step
   * @return {boolean}  true if the current date has not passed the end date
   */
  TimeStep.prototype.hasNext = function () {
    return this.current.valueOf() <= this._end.valueOf();
  };

  /**
   * Do the next step
   */
  TimeStep.prototype.next = function () {
    var prev = this.current.valueOf();

    // Two cases, needed to prevent issues with switching daylight savings
    // (end of March and end of October)
    if (this.current.month() < 6) {
      switch (this.scale) {
        case 'millisecond':
          this.current.add(this.step, 'millisecond');break;
        case 'second':
          this.current.add(this.step, 'second');break;
        case 'minute':
          this.current.add(this.step, 'minute');break;
        case 'hour':
          this.current.add(this.step, 'hour');
          // in case of skipping an hour for daylight savings, adjust the hour again (else you get: 0h 5h 9h ... instead of 0h 4h 8h ...)
          // TODO: is this still needed now we use the function of moment.js?
          this.current.subtract(this.current.hours() % this.step, 'hour');
          break;
        case 'weekday': // intentional fall through
        case 'day':
          this.current.add(this.step, 'day');break;
        case 'month':
          this.current.add(this.step, 'month');break;
        case 'year':
          this.current.add(this.step, 'year');break;
        default:
          break;
      }
    } else {
      switch (this.scale) {
        case 'millisecond':
          this.current.add(this.step, 'millisecond');break;
        case 'second':
          this.current.add(this.step, 'second');break;
        case 'minute':
          this.current.add(this.step, 'minute');break;
        case 'hour':
          this.current.add(this.moment.duration(this.step, 'hour'));

          // correct for daylight saving
          // FIXME: use this.current.add(moment.duration(this.step, 'hour'))
          // see http://momentjs.com/docs/#special-considerations-for-months-and-years
          if (this.current.hours() % this.step !== 0) {
            this.current.add(this.step - this.current.hours() % this.step, 'hour');
          }

          break;
        case 'weekday': // intentional fall through
        case 'day':
          this.current.add(this.step, 'day');break;
        case 'month':
          this.current.add(this.step, 'month');break;
        case 'year':
          this.current.add(this.step, 'year');break;
        default:
          break;
      }
    }

    if (this.step != 1) {
      // round down to the correct major value
      switch (this.scale) {
        case 'millisecond':
          if (this.current.milliseconds() > 0 && this.current.milliseconds() < this.step) this.current.milliseconds(0);break;
        case 'second':
          if (this.current.seconds() > 0 && this.current.seconds() < this.step) this.current.seconds(0);break;
        case 'minute':
          if (this.current.minutes() > 0 && this.current.minutes() < this.step) this.current.minutes(0);break;
        case 'hour':
          if (this.current.hours() > 0 && this.current.hours() < this.step) this.current.hours(0);break;
        case 'weekday': // intentional fall through
        case 'day':
          if (this.current.date() < this.step + 1) this.current.date(1);break;
        case 'month':
          if (this.current.month() < this.step) this.current.month(0);break;
        case 'year':
          break; // nothing to do for year
        default:
          break;
      }
    }

    // safety mechanism: if current time is still unchanged, move to the end
    if (this.current.valueOf() == prev) {
      this.current = this._end.clone();
    }

    // Reset switches for year, month and day. Will get set to true where appropriate in DateUtil.stepOverHiddenDates
    this.switchedDay = false;
    this.switchedMonth = false;
    this.switchedYear = false;

    DateUtil.stepOverHiddenDates(this.moment, this, prev);
  };

  /**
   * Get the current datetime
   * @return {Moment}  current The current date
   */
  TimeStep.prototype.getCurrent = function () {
    return this.current;
  };

  /**
   * Set a custom scale. Autoscaling will be disabled.
   * For example setScale('minute', 5) will result
   * in minor steps of 5 minutes, and major steps of an hour.
   *
   * @param {{scale: string, step: number}} params
   *                               An object containing two properties:
   *                               - A string 'scale'. Choose from 'millisecond', 'second',
   *                                 'minute', 'hour', 'weekday', 'day', 'month', 'year'.
   *                               - A number 'step'. A step size, by default 1.
   *                                 Choose for example 1, 2, 5, or 10.
   */
  TimeStep.prototype.setScale = function (params) {
    if (params && typeof params.scale == 'string') {
      this.scale = params.scale;
      this.step = params.step > 0 ? params.step : 1;
      this.autoScale = false;
    }
  };

  /**
   * Enable or disable autoscaling
   * @param {boolean} enable  If true, autoascaling is set true
   */
  TimeStep.prototype.setAutoScale = function (enable) {
    this.autoScale = enable;
  };

  /**
   * Automatically determine the scale that bests fits the provided minimum step
   * @param {Number} [minimumStep]  The minimum step size in milliseconds
   */
  TimeStep.prototype.setMinimumStep = function (minimumStep) {
    if (minimumStep == undefined) {
      return;
    }

    //var b = asc + ds;

    var stepYear = 1000 * 60 * 60 * 24 * 30 * 12;
    var stepMonth = 1000 * 60 * 60 * 24 * 30;
    var stepDay = 1000 * 60 * 60 * 24;
    var stepHour = 1000 * 60 * 60;
    var stepMinute = 1000 * 60;
    var stepSecond = 1000;
    var stepMillisecond = 1;

    // find the smallest step that is larger than the provided minimumStep
    if (stepYear * 1000 > minimumStep) {
      this.scale = 'year';this.step = 1000;
    }
    if (stepYear * 500 > minimumStep) {
      this.scale = 'year';this.step = 500;
    }
    if (stepYear * 100 > minimumStep) {
      this.scale = 'year';this.step = 100;
    }
    if (stepYear * 50 > minimumStep) {
      this.scale = 'year';this.step = 50;
    }
    if (stepYear * 10 > minimumStep) {
      this.scale = 'year';this.step = 10;
    }
    if (stepYear * 5 > minimumStep) {
      this.scale = 'year';this.step = 5;
    }
    if (stepYear > minimumStep) {
      this.scale = 'year';this.step = 1;
    }
    if (stepMonth * 3 > minimumStep) {
      this.scale = 'month';this.step = 3;
    }
    if (stepMonth > minimumStep) {
      this.scale = 'month';this.step = 1;
    }
    if (stepDay * 5 > minimumStep) {
      this.scale = 'day';this.step = 5;
    }
    if (stepDay * 2 > minimumStep) {
      this.scale = 'day';this.step = 2;
    }
    if (stepDay > minimumStep) {
      this.scale = 'day';this.step = 1;
    }
    if (stepDay / 2 > minimumStep) {
      this.scale = 'weekday';this.step = 1;
    }
    if (stepHour * 4 > minimumStep) {
      this.scale = 'hour';this.step = 4;
    }
    if (stepHour > minimumStep) {
      this.scale = 'hour';this.step = 1;
    }
    if (stepMinute * 15 > minimumStep) {
      this.scale = 'minute';this.step = 15;
    }
    if (stepMinute * 10 > minimumStep) {
      this.scale = 'minute';this.step = 10;
    }
    if (stepMinute * 5 > minimumStep) {
      this.scale = 'minute';this.step = 5;
    }
    if (stepMinute > minimumStep) {
      this.scale = 'minute';this.step = 1;
    }
    if (stepSecond * 15 > minimumStep) {
      this.scale = 'second';this.step = 15;
    }
    if (stepSecond * 10 > minimumStep) {
      this.scale = 'second';this.step = 10;
    }
    if (stepSecond * 5 > minimumStep) {
      this.scale = 'second';this.step = 5;
    }
    if (stepSecond > minimumStep) {
      this.scale = 'second';this.step = 1;
    }
    if (stepMillisecond * 200 > minimumStep) {
      this.scale = 'millisecond';this.step = 200;
    }
    if (stepMillisecond * 100 > minimumStep) {
      this.scale = 'millisecond';this.step = 100;
    }
    if (stepMillisecond * 50 > minimumStep) {
      this.scale = 'millisecond';this.step = 50;
    }
    if (stepMillisecond * 10 > minimumStep) {
      this.scale = 'millisecond';this.step = 10;
    }
    if (stepMillisecond * 5 > minimumStep) {
      this.scale = 'millisecond';this.step = 5;
    }
    if (stepMillisecond > minimumStep) {
      this.scale = 'millisecond';this.step = 1;
    }
  };

  /**
   * Snap a date to a rounded value.
   * The snap intervals are dependent on the current scale and step.
   * Static function
   * @param {Date} date    the date to be snapped.
   * @param {string} scale Current scale, can be 'millisecond', 'second',
   *                       'minute', 'hour', 'weekday, 'day', 'month', 'year'.
   * @param {number} step  Current step (1, 2, 4, 5, ...
   * @return {Date} snappedDate
   */
  TimeStep.snap = function (date, scale, step) {
    var clone = moment(date);

    if (scale == 'year') {
      var year = clone.year() + Math.round(clone.month() / 12);
      clone.year(Math.round(year / step) * step);
      clone.month(0);
      clone.date(0);
      clone.hours(0);
      clone.minutes(0);
      clone.seconds(0);
      clone.milliseconds(0);
    } else if (scale == 'month') {
      if (clone.date() > 15) {
        clone.date(1);
        clone.add(1, 'month');
        // important: first set Date to 1, after that change the month.
      } else {
        clone.date(1);
      }

      clone.hours(0);
      clone.minutes(0);
      clone.seconds(0);
      clone.milliseconds(0);
    } else if (scale == 'day') {
      //noinspection FallthroughInSwitchStatementJS
      switch (step) {
        case 5:
        case 2:
          clone.hours(Math.round(clone.hours() / 24) * 24);break;
        default:
          clone.hours(Math.round(clone.hours() / 12) * 12);break;
      }
      clone.minutes(0);
      clone.seconds(0);
      clone.milliseconds(0);
    } else if (scale == 'weekday') {
      //noinspection FallthroughInSwitchStatementJS
      switch (step) {
        case 5:
        case 2:
          clone.hours(Math.round(clone.hours() / 12) * 12);break;
        default:
          clone.hours(Math.round(clone.hours() / 6) * 6);break;
      }
      clone.minutes(0);
      clone.seconds(0);
      clone.milliseconds(0);
    } else if (scale == 'hour') {
      switch (step) {
        case 4:
          clone.minutes(Math.round(clone.minutes() / 60) * 60);break;
        default:
          clone.minutes(Math.round(clone.minutes() / 30) * 30);break;
      }
      clone.seconds(0);
      clone.milliseconds(0);
    } else if (scale == 'minute') {
      //noinspection FallthroughInSwitchStatementJS
      switch (step) {
        case 15:
        case 10:
          clone.minutes(Math.round(clone.minutes() / 5) * 5);
          clone.seconds(0);
          break;
        case 5:
          clone.seconds(Math.round(clone.seconds() / 60) * 60);break;
        default:
          clone.seconds(Math.round(clone.seconds() / 30) * 30);break;
      }
      clone.milliseconds(0);
    } else if (scale == 'second') {
      //noinspection FallthroughInSwitchStatementJS
      switch (step) {
        case 15:
        case 10:
          clone.seconds(Math.round(clone.seconds() / 5) * 5);
          clone.milliseconds(0);
          break;
        case 5:
          clone.milliseconds(Math.round(clone.milliseconds() / 1000) * 1000);break;
        default:
          clone.milliseconds(Math.round(clone.milliseconds() / 500) * 500);break;
      }
    } else if (scale == 'millisecond') {
      var _step = step > 5 ? step / 2 : 1;
      clone.milliseconds(Math.round(clone.milliseconds() / _step) * _step);
    }

    return clone;
  };

  /**
   * Check if the current value is a major value (for example when the step
   * is DAY, a major value is each first day of the MONTH)
   * @return {boolean} true if current date is major, else false.
   */
  TimeStep.prototype.isMajor = function () {
    if (this.switchedYear == true) {
      switch (this.scale) {
        case 'year':
        case 'month':
        case 'weekday':
        case 'day':
        case 'hour':
        case 'minute':
        case 'second':
        case 'millisecond':
          return true;
        default:
          return false;
      }
    } else if (this.switchedMonth == true) {
      switch (this.scale) {
        case 'weekday':
        case 'day':
        case 'hour':
        case 'minute':
        case 'second':
        case 'millisecond':
          return true;
        default:
          return false;
      }
    } else if (this.switchedDay == true) {
      switch (this.scale) {
        case 'millisecond':
        case 'second':
        case 'minute':
        case 'hour':
          return true;
        default:
          return false;
      }
    }

    var date = this.moment(this.current);
    switch (this.scale) {
      case 'millisecond':
        return date.milliseconds() == 0;
      case 'second':
        return date.seconds() == 0;
      case 'minute':
        return date.hours() == 0 && date.minutes() == 0;
      case 'hour':
        return date.hours() == 0;
      case 'weekday': // intentional fall through
      case 'day':
        return date.date() == 1;
      case 'month':
        return date.month() == 0;
      case 'year':
        return false;
      default:
        return false;
    }
  };

  /**
   * Returns formatted text for the minor axislabel, depending on the current
   * date and the scale. For example when scale is MINUTE, the current time is
   * formatted as "hh:mm".
   * @param {Date} [date] custom date. if not provided, current date is taken
   */
  TimeStep.prototype.getLabelMinor = function (date) {
    if (date == undefined) {
      date = this.current;
    }

    if (typeof this.format.minorLabels === "function") {
      return this.format.minorLabels(date, this.scale, this.step);
    }

    var format = this.format.minorLabels[this.scale];
    return format && format.length > 0 ? this.moment(date).format(format) : '';
  };

  /**
   * Returns formatted text for the major axis label, depending on the current
   * date and the scale. For example when scale is MINUTE, the major scale is
   * hours, and the hour will be formatted as "hh".
   * @param {Date} [date] custom date. if not provided, current date is taken
   */
  TimeStep.prototype.getLabelMajor = function (date) {
    if (date == undefined) {
      date = this.current;
    }

    if (typeof this.format.majorLabels === "function") {
      return this.format.majorLabels(date, this.scale, this.step);
    }

    var format = this.format.majorLabels[this.scale];
    return format && format.length > 0 ? this.moment(date).format(format) : '';
  };

  TimeStep.prototype.getClassName = function () {
    var _moment = this.moment;
    var m = this.moment(this.current);
    var current = m.locale ? m.locale('en') : m.lang('en'); // old versions of moment have .lang() function
    var step = this.step;

    function even(value) {
      return value / step % 2 == 0 ? ' vis-even' : ' vis-odd';
    }

    function today(date) {
      if (date.isSame(new Date(), 'day')) {
        return ' vis-today';
      }
      if (date.isSame(_moment().add(1, 'day'), 'day')) {
        return ' vis-tomorrow';
      }
      if (date.isSame(_moment().add(-1, 'day'), 'day')) {
        return ' vis-yesterday';
      }
      return '';
    }

    function currentWeek(date) {
      return date.isSame(new Date(), 'week') ? ' vis-current-week' : '';
    }

    function currentMonth(date) {
      return date.isSame(new Date(), 'month') ? ' vis-current-month' : '';
    }

    function currentYear(date) {
      return date.isSame(new Date(), 'year') ? ' vis-current-year' : '';
    }

    switch (this.scale) {
      case 'millisecond':
        return today(current) + even(current.milliseconds()).trim();

      case 'second':
        return today(current) + even(current.seconds()).trim();

      case 'minute':
        return today(current) + even(current.minutes()).trim();

      case 'hour':
        return 'vis-h' + current.hours() + (this.step == 4 ? '-h' + (current.hours() + 4) : '') + today(current) + even(current.hours());

      case 'weekday':
        return 'vis-' + current.format('dddd').toLowerCase() + today(current) + currentWeek(current) + even(current.date());

      case 'day':
        return 'vis-day' + current.date() + ' vis-' + current.format('MMMM').toLowerCase() + today(current) + currentMonth(current) + (this.step <= 2 ? today(current) : '') + (this.step <= 2 ? ' vis-' + current.format('dddd').toLowerCase() : '' + even(current.date() - 1));

      case 'month':
        return 'vis-' + current.format('MMMM').toLowerCase() + currentMonth(current) + even(current.month());

      case 'year':
        var year = current.year();
        return 'vis-year' + year + currentYear(current) + even(year);

      default:
        return '';
    }
  };

  module.exports = TimeStep;

/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var stack = __webpack_require__(131);
  var RangeItem = __webpack_require__(132);

  /**
   * @constructor Group
   * @param {Number | String} groupId
   * @param {Object} data
   * @param {ItemSet} itemSet
   */
  function Group(groupId, data, itemSet) {
    this.groupId = groupId;
    this.subgroups = {};
    this.subgroupIndex = 0;
    this.subgroupOrderer = data && data.subgroupOrder;
    this.itemSet = itemSet;
    this.isVisible = null;

    if (data && data.nestedGroups) {
      this.nestedGroups = data.nestedGroups;
      if (data.showNested == false) {
        this.showNested = false;
      } else {
        this.showNested = true;
      }
    }

    this.nestedInGroup = null;

    this.dom = {};
    this.props = {
      label: {
        width: 0,
        height: 0
      }
    };
    this.className = null;

    this.items = {}; // items filtered by groupId of this group
    this.visibleItems = []; // items currently visible in window
    this.itemsInRange = []; // items currently in range
    this.orderedItems = {
      byStart: [],
      byEnd: []
    };
    this.checkRangedItems = false; // needed to refresh the ranged items if the window is programatically changed with NO overlap.
    var me = this;
    this.itemSet.body.emitter.on("checkRangedItems", function () {
      me.checkRangedItems = true;
    });

    this._create();

    this.setData(data);
  }

  /**
   * Create DOM elements for the group
   * @private
   */
  Group.prototype._create = function () {
    var label = document.createElement('div');
    if (this.itemSet.options.groupEditable.order) {
      label.className = 'vis-label draggable';
    } else {
      label.className = 'vis-label';
    }
    this.dom.label = label;

    var inner = document.createElement('div');
    inner.className = 'vis-inner';
    label.appendChild(inner);
    this.dom.inner = inner;

    var foreground = document.createElement('div');
    foreground.className = 'vis-group';
    foreground['timeline-group'] = this;
    this.dom.foreground = foreground;

    this.dom.background = document.createElement('div');
    this.dom.background.className = 'vis-group';

    this.dom.axis = document.createElement('div');
    this.dom.axis.className = 'vis-group';

    // create a hidden marker to detect when the Timelines container is attached
    // to the DOM, or the style of a parent of the Timeline is changed from
    // display:none is changed to visible.
    this.dom.marker = document.createElement('div');
    this.dom.marker.style.visibility = 'hidden';
    this.dom.marker.style.position = 'absolute';
    this.dom.marker.innerHTML = '';
    this.dom.background.appendChild(this.dom.marker);
  };

  /**
   * Set the group data for this group
   * @param {Object} data   Group data, can contain properties content and className
   */
  Group.prototype.setData = function (data) {
    // update contents
    var content;
    var templateFunction;

    if (this.itemSet.options && this.itemSet.options.groupTemplate) {
      templateFunction = this.itemSet.options.groupTemplate.bind(this);
      content = templateFunction(data, this.dom.inner);
    } else {
      content = data && data.content;
    }

    if (content instanceof Element) {
      this.dom.inner.appendChild(content);
      while (this.dom.inner.firstChild) {
        this.dom.inner.removeChild(this.dom.inner.firstChild);
      }
      this.dom.inner.appendChild(content);
    } else if (content instanceof Object) {
      templateFunction(data, this.dom.inner);
    } else if (content !== undefined && content !== null) {
      this.dom.inner.innerHTML = content;
    } else {
      this.dom.inner.innerHTML = this.groupId || ''; // groupId can be null
    }

    // update title
    this.dom.label.title = data && data.title || '';
    if (!this.dom.inner.firstChild) {
      util.addClassName(this.dom.inner, 'vis-hidden');
    } else {
      util.removeClassName(this.dom.inner, 'vis-hidden');
    }

    if (data && data.nestedGroups) {
      if (data.showNested == false) {
        this.showNested = false;
      } else {
        this.showNested = true;
      }

      util.addClassName(this.dom.label, 'vis-nesting-group');
      if (this.showNested) {
        util.removeClassName(this.dom.label, 'collapsed');
        util.addClassName(this.dom.label, 'expanded');
      } else {
        util.removeClassName(this.dom.label, 'expanded');
        var collapsedDirClassName = this.itemSet.options.rtl ? 'collapsed-rtl' : 'collapsed';
        util.addClassName(this.dom.label, collapsedDirClassName);
      }
    }

    if (data && data.nestedInGroup) {
      util.addClassName(this.dom.label, 'vis-nested-group');
      if (this.itemSet.options && this.itemSet.options.rtl) {
        this.dom.inner.style.paddingRight = '30px';
      } else {
        this.dom.inner.style.paddingLeft = '30px';
      }
    }

    // update className
    var className = data && data.className || null;
    if (className != this.className) {
      if (this.className) {
        util.removeClassName(this.dom.label, this.className);
        util.removeClassName(this.dom.foreground, this.className);
        util.removeClassName(this.dom.background, this.className);
        util.removeClassName(this.dom.axis, this.className);
      }
      util.addClassName(this.dom.label, className);
      util.addClassName(this.dom.foreground, className);
      util.addClassName(this.dom.background, className);
      util.addClassName(this.dom.axis, className);
      this.className = className;
    }

    // update style
    if (this.style) {
      util.removeCssText(this.dom.label, this.style);
      this.style = null;
    }
    if (data && data.style) {
      util.addCssText(this.dom.label, data.style);
      this.style = data.style;
    }
  };

  /**
   * Get the width of the group label
   * @return {number} width
   */
  Group.prototype.getLabelWidth = function () {
    return this.props.label.width;
  };

  /**
   * Repaint this group
   * @param {{start: number, end: number}} range
   * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
   * @param {boolean} [restack=false]  Force restacking of all items
   * @return {boolean} Returns true if the group is resized
   */
  Group.prototype.redraw = function (range, margin, restack) {
    var resized = false;

    // force recalculation of the height of the items when the marker height changed
    // (due to the Timeline being attached to the DOM or changed from display:none to visible)
    var markerHeight = this.dom.marker.clientHeight;
    if (markerHeight != this.lastMarkerHeight) {
      this.lastMarkerHeight = markerHeight;
      util.forEach(this.items, function (item) {
        item.dirty = true;
        if (item.displayed) item.redraw();
      });

      restack = true;
    }

    // recalculate the height of the subgroups
    this._calculateSubGroupHeights(margin);

    // calculate actual size and position
    var foreground = this.dom.foreground;
    this.top = foreground.offsetTop;
    this.right = foreground.offsetLeft;
    this.width = foreground.offsetWidth;

    this.isVisible = this._isGroupVisible(range, margin);
    // reposition visible items vertically
    if (typeof this.itemSet.options.order === 'function') {
      // a custom order function

      if (restack) {
        // brute force restack of all items

        // show all items
        var me = this;
        var limitSize = false;
        util.forEach(this.items, function (item) {
          if (!item.displayed) {
            item.redraw();
            me.visibleItems.push(item);
          }
          item.repositionX(limitSize);
        });

        // order all items and force a restacking
        var customOrderedItems = this.orderedItems.byStart.slice().sort(function (a, b) {
          return me.itemSet.options.order(a.data, b.data);
        });
        stack.stack(customOrderedItems, margin, true /* restack=true */);
      }

      this.visibleItems = this._updateItemsInRange(this.orderedItems, this.visibleItems, range);
    } else {
      // no custom order function, lazy stacking

      this.visibleItems = this._updateItemsInRange(this.orderedItems, this.visibleItems, range);

      if (this.itemSet.options.stack) {
        // TODO: ugly way to access options...
        stack.stack(this.visibleItems, margin, restack);
      } else {
        // no stacking
        stack.nostack(this.visibleItems, margin, this.subgroups, this.itemSet.options.stackSubgroups);
      }
    }

    this._updateSubgroupsSizes();

    // recalculate the height of the group
    var height = this._calculateHeight(margin);

    // calculate actual size and position
    var foreground = this.dom.foreground;
    this.top = foreground.offsetTop;
    this.right = foreground.offsetLeft;
    this.width = foreground.offsetWidth;
    resized = util.updateProperty(this, 'height', height) || resized;
    // recalculate size of label
    resized = util.updateProperty(this.props.label, 'width', this.dom.inner.clientWidth) || resized;
    resized = util.updateProperty(this.props.label, 'height', this.dom.inner.clientHeight) || resized;

    // apply new height
    this.dom.background.style.height = height + 'px';
    this.dom.foreground.style.height = height + 'px';
    this.dom.label.style.height = height + 'px';

    // update vertical position of items after they are re-stacked and the height of the group is calculated
    for (var i = 0, ii = this.visibleItems.length; i < ii; i++) {
      var item = this.visibleItems[i];
      item.repositionY(margin);
      if (!this.isVisible && this.groupId != "__background__") {
        if (item.displayed) item.hide();
      }
    }

    if (!this.isVisible && this.height) {
      return resized = false;
    }

    return resized;
  };

  /**
   * recalculate the height of the subgroups
   * @private
   */
  Group.prototype._calculateSubGroupHeights = function (margin) {
    if ((0, _keys2['default'])(this.subgroups).length > 0) {
      var me = this;

      this.resetSubgroups();

      util.forEach(this.visibleItems, function (item) {
        if (item.data.subgroup !== undefined) {
          me.subgroups[item.data.subgroup].height = Math.max(me.subgroups[item.data.subgroup].height, item.height + margin.item.vertical);
          me.subgroups[item.data.subgroup].visible = true;
        }
      });
    }
  };

  /**
   * check if group is visible
   * @private
    */
  Group.prototype._isGroupVisible = function (range, margin) {
    var isVisible = this.top <= range.body.domProps.centerContainer.height - range.body.domProps.scrollTop + margin.axis && this.top + this.height + margin.axis >= -range.body.domProps.scrollTop;
    return isVisible;
  };

  /**
   * recalculate the height of the group
   * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
   * @returns {number} Returns the height
   * @private
   */
  Group.prototype._calculateHeight = function (margin) {
    // recalculate the height of the group
    var height;
    var itemsInRange = this.visibleItems;
    if (itemsInRange.length > 0) {
      var min = itemsInRange[0].top;
      var max = itemsInRange[0].top + itemsInRange[0].height;
      util.forEach(itemsInRange, function (item) {
        min = Math.min(min, item.top);
        max = Math.max(max, item.top + item.height);
      });
      if (min > margin.axis) {
        // there is an empty gap between the lowest item and the axis
        var offset = min - margin.axis;
        max -= offset;
        util.forEach(itemsInRange, function (item) {
          item.top -= offset;
        });
      }
      height = max + margin.item.vertical / 2;
    } else {
      height = 0;
    }
    height = Math.max(height, this.props.label.height);

    return height;
  };

  /**
   * Show this group: attach to the DOM
   */
  Group.prototype.show = function () {
    if (!this.dom.label.parentNode) {
      this.itemSet.dom.labelSet.appendChild(this.dom.label);
    }

    if (!this.dom.foreground.parentNode) {
      this.itemSet.dom.foreground.appendChild(this.dom.foreground);
    }

    if (!this.dom.background.parentNode) {
      this.itemSet.dom.background.appendChild(this.dom.background);
    }

    if (!this.dom.axis.parentNode) {
      this.itemSet.dom.axis.appendChild(this.dom.axis);
    }
  };

  /**
   * Hide this group: remove from the DOM
   */
  Group.prototype.hide = function () {
    var label = this.dom.label;
    if (label.parentNode) {
      label.parentNode.removeChild(label);
    }

    var foreground = this.dom.foreground;
    if (foreground.parentNode) {
      foreground.parentNode.removeChild(foreground);
    }

    var background = this.dom.background;
    if (background.parentNode) {
      background.parentNode.removeChild(background);
    }

    var axis = this.dom.axis;
    if (axis.parentNode) {
      axis.parentNode.removeChild(axis);
    }
  };

  /**
   * Add an item to the group
   * @param {Item} item
   */
  Group.prototype.add = function (item) {
    this.items[item.id] = item;
    item.setParent(this);

    // add to
    if (item.data.subgroup !== undefined) {
      if (this.subgroups[item.data.subgroup] === undefined) {
        this.subgroups[item.data.subgroup] = {
          height: 0,
          top: 0,
          start: item.data.start,
          end: item.data.end,
          visible: false,
          index: this.subgroupIndex,
          items: []
        };
        this.subgroupIndex++;
      }

      if (new Date(item.data.start) < new Date(this.subgroups[item.data.subgroup].start)) {
        this.subgroups[item.data.subgroup].start = item.data.start;
      }
      if (new Date(item.data.end) > new Date(this.subgroups[item.data.subgroup].end)) {
        this.subgroups[item.data.subgroup].end = item.data.end;
      }

      this.subgroups[item.data.subgroup].items.push(item);
    }
    this.orderSubgroups();

    if (this.visibleItems.indexOf(item) == -1) {
      var range = this.itemSet.body.range; // TODO: not nice accessing the range like this
      this._checkIfVisible(item, this.visibleItems, range);
    }
  };

  Group.prototype._updateSubgroupsSizes = function () {
    var me = this;
    if (me.subgroups) {
      for (var subgroup in me.subgroups) {
        var newStart = me.subgroups[subgroup].items[0].data.start;
        var newEnd = me.subgroups[subgroup].items[0].data.end;

        me.subgroups[subgroup].items.forEach(function (item) {
          if (new Date(item.data.start) < new Date(newStart)) {
            newStart = item.data.start;
          }
          if (new Date(item.data.end) > new Date(newEnd)) {
            newEnd = item.data.end;
          }
        });

        me.subgroups[subgroup].start = newStart;
        me.subgroups[subgroup].end = newEnd;
      }
    }
  };

  Group.prototype.orderSubgroups = function () {
    if (this.subgroupOrderer !== undefined) {
      var sortArray = [];
      if (typeof this.subgroupOrderer == 'string') {
        for (var subgroup in this.subgroups) {
          sortArray.push({ subgroup: subgroup, sortField: this.subgroups[subgroup].items[0].data[this.subgroupOrderer] });
        }
        sortArray.sort(function (a, b) {
          return a.sortField - b.sortField;
        });
      } else if (typeof this.subgroupOrderer == 'function') {
        for (var subgroup in this.subgroups) {
          sortArray.push(this.subgroups[subgroup].items[0].data);
        }
        sortArray.sort(this.subgroupOrderer);
      }

      if (sortArray.length > 0) {
        for (var i = 0; i < sortArray.length; i++) {
          this.subgroups[sortArray[i].subgroup].index = i;
        }
      }
    }
  };

  Group.prototype.resetSubgroups = function () {
    for (var subgroup in this.subgroups) {
      if (this.subgroups.hasOwnProperty(subgroup)) {
        this.subgroups[subgroup].visible = false;
      }
    }
  };

  /**
   * Remove an item from the group
   * @param {Item} item
   */
  Group.prototype.remove = function (item) {
    delete this.items[item.id];
    item.setParent(null);

    // remove from visible items
    var index = this.visibleItems.indexOf(item);
    if (index != -1) this.visibleItems.splice(index, 1);

    if (item.data.subgroup !== undefined) {
      var subgroup = this.subgroups[item.data.subgroup];
      if (subgroup) {
        var itemIndex = subgroup.items.indexOf(item);
        subgroup.items.splice(itemIndex, 1);
        if (!subgroup.items.length) {
          delete this.subgroups[item.data.subgroup];
          this.subgroupIndex--;
        } else {
          this._updateSubgroupsSizes();
        }
        this.orderSubgroups();
      }
    }
  };

  /**
   * Remove an item from the corresponding DataSet
   * @param {Item} item
   */
  Group.prototype.removeFromDataSet = function (item) {
    this.itemSet.removeItem(item.id);
  };

  /**
   * Reorder the items
   */
  Group.prototype.order = function () {
    var array = util.toArray(this.items);
    var startArray = [];
    var endArray = [];

    for (var i = 0; i < array.length; i++) {
      if (array[i].data.end !== undefined) {
        endArray.push(array[i]);
      }
      startArray.push(array[i]);
    }
    this.orderedItems = {
      byStart: startArray,
      byEnd: endArray
    };

    stack.orderByStart(this.orderedItems.byStart);
    stack.orderByEnd(this.orderedItems.byEnd);
  };

  /**
   * Update the visible items
   * @param {{byStart: Item[], byEnd: Item[]}} orderedItems   All items ordered by start date and by end date
   * @param {Item[]} visibleItems                             The previously visible items.
   * @param {{start: number, end: number}} range              Visible range
   * @return {Item[]} visibleItems                            The new visible items.
   * @private
   */
  Group.prototype._updateItemsInRange = function (orderedItems, oldVisibleItems, range) {
    var visibleItems = [];
    var visibleItemsLookup = {}; // we keep this to quickly look up if an item already exists in the list without using indexOf on visibleItems

    var interval = (range.end - range.start) / 4;
    var lowerBound = range.start - interval;
    var upperBound = range.end + interval;

    // this function is used to do the binary search.
    var searchFunction = function searchFunction(value) {
      if (value < lowerBound) {
        return -1;
      } else if (value <= upperBound) {
        return 0;
      } else {
        return 1;
      }
    };

    // first check if the items that were in view previously are still in view.
    // IMPORTANT: this handles the case for the items with startdate before the window and enddate after the window!
    // also cleans up invisible items.
    if (oldVisibleItems.length > 0) {
      for (var i = 0; i < oldVisibleItems.length; i++) {
        this._checkIfVisibleWithReference(oldVisibleItems[i], visibleItems, visibleItemsLookup, range);
      }
    }

    // we do a binary search for the items that have only start values.
    var initialPosByStart = util.binarySearchCustom(orderedItems.byStart, searchFunction, 'data', 'start');

    // trace the visible items from the inital start pos both ways until an invisible item is found, we only look at the start values.
    this._traceVisible(initialPosByStart, orderedItems.byStart, visibleItems, visibleItemsLookup, function (item) {
      return item.data.start < lowerBound || item.data.start > upperBound;
    });

    // if the window has changed programmatically without overlapping the old window, the ranged items with start < lowerBound and end > upperbound are not shown.
    // We therefore have to brute force check all items in the byEnd list
    if (this.checkRangedItems == true) {
      this.checkRangedItems = false;
      for (i = 0; i < orderedItems.byEnd.length; i++) {
        this._checkIfVisibleWithReference(orderedItems.byEnd[i], visibleItems, visibleItemsLookup, range);
      }
    } else {
      // we do a binary search for the items that have defined end times.
      var initialPosByEnd = util.binarySearchCustom(orderedItems.byEnd, searchFunction, 'data', 'end');

      // trace the visible items from the inital start pos both ways until an invisible item is found, we only look at the end values.
      this._traceVisible(initialPosByEnd, orderedItems.byEnd, visibleItems, visibleItemsLookup, function (item) {
        return item.data.end < lowerBound || item.data.end > upperBound;
      });
    }

    // finally, we reposition all the visible items.
    for (var i = 0; i < visibleItems.length; i++) {
      var item = visibleItems[i];
      if (!item.displayed) item.show();
      // reposition item horizontally
      item.repositionX();
    }

    return visibleItems;
  };

  Group.prototype._traceVisible = function (initialPos, items, visibleItems, visibleItemsLookup, breakCondition) {
    if (initialPos != -1) {
      for (var i = initialPos; i >= 0; i--) {
        var item = items[i];
        if (breakCondition(item)) {
          break;
        } else {
          if (visibleItemsLookup[item.id] === undefined) {
            visibleItemsLookup[item.id] = true;
            visibleItems.push(item);
          }
        }
      }

      for (var i = initialPos + 1; i < items.length; i++) {
        var item = items[i];
        if (breakCondition(item)) {
          break;
        } else {
          if (visibleItemsLookup[item.id] === undefined) {
            visibleItemsLookup[item.id] = true;
            visibleItems.push(item);
          }
        }
      }
    }
  };

  /**
   * this function is very similar to the _checkIfInvisible() but it does not
   * return booleans, hides the item if it should not be seen and always adds to
   * the visibleItems.
   * this one is for brute forcing and hiding.
   *
   * @param {Item} item
   * @param {Array} visibleItems
   * @param {{start:number, end:number}} range
   * @private
   */
  Group.prototype._checkIfVisible = function (item, visibleItems, range) {
    if (item.isVisible(range)) {
      if (!item.displayed) item.show();
      // reposition item horizontally
      item.repositionX();
      visibleItems.push(item);
    } else {
      if (item.displayed) item.hide();
    }
  };

  /**
   * this function is very similar to the _checkIfInvisible() but it does not
   * return booleans, hides the item if it should not be seen and always adds to
   * the visibleItems.
   * this one is for brute forcing and hiding.
   *
   * @param {Item} item
   * @param {Array} visibleItems
   * @param {{start:number, end:number}} range
   * @private
   */
  Group.prototype._checkIfVisibleWithReference = function (item, visibleItems, visibleItemsLookup, range) {
    if (item.isVisible(range)) {
      if (visibleItemsLookup[item.id] === undefined) {
        visibleItemsLookup[item.id] = true;
        visibleItems.push(item);
      }
    } else {
      if (item.displayed) item.hide();
    }
  };

  module.exports = Group;

/***/ },
/* 131 */
/***/ function(module, exports) {

  'use strict';

  // Utility functions for ordering and stacking of items
  var EPSILON = 0.001; // used when checking collisions, to prevent round-off errors

  /**
   * Order items by their start data
   * @param {Item[]} items
   */
  exports.orderByStart = function (items) {
    items.sort(function (a, b) {
      return a.data.start - b.data.start;
    });
  };

  /**
   * Order items by their end date. If they have no end date, their start date
   * is used.
   * @param {Item[]} items
   */
  exports.orderByEnd = function (items) {
    items.sort(function (a, b) {
      var aTime = 'end' in a.data ? a.data.end : a.data.start,
          bTime = 'end' in b.data ? b.data.end : b.data.start;

      return aTime - bTime;
    });
  };

  /**
   * Adjust vertical positions of the items such that they don't overlap each
   * other.
   * @param {Item[]} items
   *            All visible items
   * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
   *            Margins between items and between items and the axis.
   * @param {boolean} [force=false]
   *            If true, all items will be repositioned. If false (default), only
   *            items having a top===null will be re-stacked
   */
  exports.stack = function (items, margin, force) {
    if (force) {
      // reset top position of all items
      for (var i = 0; i < items.length; i++) {
        items[i].top = null;
      }
    }

    // calculate new, non-overlapping positions
    for (var i = 0; i < items.length; i++) {
      var item = items[i];
      if (item.stack && item.top === null) {
        // initialize top position
        item.top = margin.axis;

        do {
          // TODO: optimize checking for overlap. when there is a gap without items,
          //       you only need to check for items from the next item on, not from zero
          var collidingItem = null;
          for (var j = 0, jj = items.length; j < jj; j++) {
            var other = items[j];
            if (other.top !== null && other !== item && other.stack && exports.collision(item, other, margin.item, other.options.rtl)) {
              collidingItem = other;
              break;
            }
          }

          if (collidingItem != null) {
            // There is a collision. Reposition the items above the colliding element
            item.top = collidingItem.top + collidingItem.height + margin.item.vertical;
          }
        } while (collidingItem);
      }
    }
  };

  /**
   * Adjust vertical positions of the items without stacking them
   * @param {Item[]} items
   *            All visible items
   * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
   *            Margins between items and between items and the axis.
  * @param {subgroups[]} subgroups
   *            All subgroups
   */
  exports.nostack = function (items, margin, subgroups, stackSubgroups) {
    for (var i = 0; i < items.length; i++) {
      if (items[i].data.subgroup == undefined) {
        items[i].top = margin.item.vertical;
      } else if (items[i].data.subgroup !== undefined && stackSubgroups) {
        var newTop = 0;
        for (var subgroup in subgroups) {
          if (subgroups.hasOwnProperty(subgroup)) {
            if (subgroups[subgroup].visible == true && subgroups[subgroup].index < subgroups[items[i].data.subgroup].index) {
              newTop += subgroups[subgroup].height;
              subgroups[items[i].data.subgroup].top = newTop;
            }
          }
        }
        items[i].top = newTop + 0.5 * margin.item.vertical;
      }
    }
    if (!stackSubgroups) {
      exports.stackSubgroups(items, margin, subgroups);
    }
  };

  /**
   * Adjust vertical positions of the subgroups such that they don't overlap each
   * other.
   * @param {subgroups[]} subgroups
   *            All subgroups
   * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
   *            Margins between items and between items and the axis.
   */
  exports.stackSubgroups = function (items, margin, subgroups) {
    for (var subgroup in subgroups) {
      if (subgroups.hasOwnProperty(subgroup)) {

        subgroups[subgroup].top = 0;
        do {
          // TODO: optimize checking for overlap. when there is a gap without items,
          //       you only need to check for items from the next item on, not from zero
          var collidingItem = null;
          for (var otherSubgroup in subgroups) {
            if (subgroups[otherSubgroup].top !== null && otherSubgroup !== subgroup && subgroups[subgroup].index > subgroups[otherSubgroup].index && exports.collisionByTimes(subgroups[subgroup], subgroups[otherSubgroup])) {
              collidingItem = subgroups[otherSubgroup];
              break;
            }
          }

          if (collidingItem != null) {
            // There is a collision. Reposition the subgroups above the colliding element
            subgroups[subgroup].top = collidingItem.top + collidingItem.height;
          }
        } while (collidingItem);
      }
    }
    for (var i = 0; i < items.length; i++) {
      if (items[i].data.subgroup !== undefined) {
        items[i].top = subgroups[items[i].data.subgroup].top + 0.5 * margin.item.vertical;
      }
    }
  };

  /**
   * Test if the two provided items collide
   * The items must have parameters left, width, top, and height.
   * @param {Item} a          The first item
   * @param {Item} b          The second item
   * @param {{horizontal: number, vertical: number}} margin
   *                          An object containing a horizontal and vertical
   *                          minimum required margin.
   * @param {boolean} rtl
   * @return {boolean}        true if a and b collide, else false
   */
  exports.collision = function (a, b, margin, rtl) {
    if (rtl) {
      return a.right - margin.horizontal + EPSILON < b.right + b.width && a.right + a.width + margin.horizontal - EPSILON > b.right && a.top - margin.vertical + EPSILON < b.top + b.height && a.top + a.height + margin.vertical - EPSILON > b.top;
    } else {
      return a.left - margin.horizontal + EPSILON < b.left + b.width && a.left + a.width + margin.horizontal - EPSILON > b.left && a.top - margin.vertical + EPSILON < b.top + b.height && a.top + a.height + margin.vertical - EPSILON > b.top;
    }
  };

  /**
   * Test if the two provided objects collide
   * The objects must have parameters start, end, top, and height.
   * @param {Object} a          The first Object
   * @param {Object} b          The second Object
   * @return {boolean}        true if a and b collide, else false
   */
  exports.collisionByTimes = function (a, b) {
    return a.start <= b.start && a.end >= b.start && a.top < b.top + b.height && a.top + a.height > b.top || b.start <= a.start && b.end >= a.start && b.top < a.top + a.height && b.top + b.height > a.top;
  };

/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var Hammer = __webpack_require__(108);
  var Item = __webpack_require__(133);

  /**
   * @constructor RangeItem
   * @extends Item
   * @param {Object} data             Object containing parameters start, end
   *                                  content, className.
   * @param {{toScreen: function, toTime: function}} conversion
   *                                  Conversion functions from time to screen and vice versa
   * @param {Object} [options]        Configuration options
   *                                  // TODO: describe options
   */
  function RangeItem(data, conversion, options) {
    this.props = {
      content: {
        width: 0
      }
    };
    this.overflow = false; // if contents can overflow (css styling), this flag is set to true
    this.options = options;
    // validate data
    if (data) {
      if (data.start == undefined) {
        throw new Error('Property "start" missing in item ' + data.id);
      }
      if (data.end == undefined) {
        throw new Error('Property "end" missing in item ' + data.id);
      }
    }

    Item.call(this, data, conversion, options);
  }

  RangeItem.prototype = new Item(null, null, null);

  RangeItem.prototype.baseClassName = 'vis-item vis-range';

  /**
   * Check whether this item is visible inside given range
   * @returns {{start: Number, end: Number}} range with a timestamp for start and end
   * @returns {boolean} True if visible
   */
  RangeItem.prototype.isVisible = function (range) {
    // determine visibility
    return this.data.start < range.end && this.data.end > range.start;
  };

  /**
   * Repaint the item
   */
  RangeItem.prototype.redraw = function () {
    var dom = this.dom;
    if (!dom) {
      // create DOM
      this.dom = {};
      dom = this.dom;

      // background box
      dom.box = document.createElement('div');
      // className is updated in redraw()

      // frame box (to prevent the item contents from overflowing)
      dom.frame = document.createElement('div');
      dom.frame.className = 'vis-item-overflow';
      dom.box.appendChild(dom.frame);

      // visible frame box (showing the frame that is always visible)
      dom.visibleFrame = document.createElement('div');
      dom.visibleFrame.className = 'vis-item-visible-frame';
      dom.box.appendChild(dom.visibleFrame);

      // contents box
      dom.content = document.createElement('div');
      dom.content.className = 'vis-item-content';
      dom.frame.appendChild(dom.content);

      // attach this item as attribute
      dom.box['timeline-item'] = this;

      this.dirty = true;
    }

    // append DOM to parent DOM
    if (!this.parent) {
      throw new Error('Cannot redraw item: no parent attached');
    }
    if (!dom.box.parentNode) {
      var foreground = this.parent.dom.foreground;
      if (!foreground) {
        throw new Error('Cannot redraw item: parent has no foreground container element');
      }
      foreground.appendChild(dom.box);
    }
    this.displayed = true;

    // Update DOM when item is marked dirty. An item is marked dirty when:
    // - the item is not yet rendered
    // - the item's data is changed
    // - the item is selected/deselected
    if (this.dirty) {
      this._updateContents(this.dom.content);
      this._updateTitle();
      this._updateDataAttributes(this.dom.box);
      this._updateStyle(this.dom.box);

      var editable = (this.options.editable.updateTime || this.options.editable.updateGroup || this.editable === true) && this.editable !== false;

      // update class
      var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '') + (editable ? ' vis-editable' : ' vis-readonly');
      dom.box.className = this.baseClassName + className;

      // determine from css whether this box has overflow
      this.overflow = window.getComputedStyle(dom.frame).overflow !== 'hidden';

      // recalculate size
      // turn off max-width to be able to calculate the real width
      // this causes an extra browser repaint/reflow, but so be it
      this.dom.content.style.maxWidth = 'none';
      this.props.content.width = this.dom.content.offsetWidth;
      this.height = this.dom.box.offsetHeight;
      this.dom.content.style.maxWidth = '';

      this.dirty = false;
    }

    this._repaintOnItemUpdateTimeTooltip(dom.box);
    this._repaintDeleteButton(dom.box);
    this._repaintDragCenter();
    this._repaintDragLeft();
    this._repaintDragRight();
  };

  /**
   * Show the item in the DOM (when not already visible). The items DOM will
   * be created when needed.
   */
  RangeItem.prototype.show = function () {
    if (!this.displayed) {
      this.redraw();
    }
  };

  /**
   * Hide the item from the DOM (when visible)
   * @return {Boolean} changed
   */
  RangeItem.prototype.hide = function () {
    if (this.displayed) {
      var box = this.dom.box;

      if (box.parentNode) {
        box.parentNode.removeChild(box);
      }

      this.displayed = false;
    }
  };

  /**
   * Reposition the item horizontally
   * @param {boolean} [limitSize=true] If true (default), the width of the range
   *                                   item will be limited, as the browser cannot
   *                                   display very wide divs. This means though
   *                                   that the applied left and width may
   *                                   not correspond to the ranges start and end
   * @Override
   */
  RangeItem.prototype.repositionX = function (limitSize) {
    var parentWidth = this.parent.width;
    var start = this.conversion.toScreen(this.data.start);
    var end = this.conversion.toScreen(this.data.end);
    var contentStartPosition;
    var contentWidth;

    // limit the width of the range, as browsers cannot draw very wide divs
    if (limitSize === undefined || limitSize === true) {
      if (start < -parentWidth) {
        start = -parentWidth;
      }
      if (end > 2 * parentWidth) {
        end = 2 * parentWidth;
      }
    }

    // add 0.5 to compensate floating-point values rounding
    var boxWidth = Math.max(end - start + 0.5, 1);

    if (this.overflow) {
      if (this.options.rtl) {
        this.right = start;
      } else {
        this.left = start;
      }
      this.width = boxWidth + this.props.content.width;
      contentWidth = this.props.content.width;

      // Note: The calculation of width is an optimistic calculation, giving
      //       a width which will not change when moving the Timeline
      //       So no re-stacking needed, which is nicer for the eye;
    } else {
      if (this.options.rtl) {
        this.right = start;
      } else {
        this.left = start;
      }
      this.width = boxWidth;
      contentWidth = Math.min(end - start, this.props.content.width);
    }

    if (this.options.rtl) {
      this.dom.box.style.right = this.right + 'px';
    } else {
      this.dom.box.style.left = this.left + 'px';
    }
    this.dom.box.style.width = boxWidth + 'px';

    switch (this.options.align) {
      case 'left':
        if (this.options.rtl) {
          this.dom.content.style.right = '0';
        } else {
          this.dom.content.style.left = '0';
        }
        break;

      case 'right':
        if (this.options.rtl) {
          this.dom.content.style.right = Math.max(boxWidth - contentWidth, 0) + 'px';
        } else {
          this.dom.content.style.left = Math.max(boxWidth - contentWidth, 0) + 'px';
        }
        break;

      case 'center':
        if (this.options.rtl) {
          this.dom.content.style.right = Math.max((boxWidth - contentWidth) / 2, 0) + 'px';
        } else {
          this.dom.content.style.left = Math.max((boxWidth - contentWidth) / 2, 0) + 'px';
        }

        break;

      default:
        // 'auto'
        // when range exceeds left of the window, position the contents at the left of the visible area
        if (this.overflow) {
          if (end > 0) {
            contentStartPosition = Math.max(-start, 0);
          } else {
            contentStartPosition = -contentWidth; // ensure it's not visible anymore
          }
        } else {
          if (start < 0) {
            contentStartPosition = -start;
          } else {
            contentStartPosition = 0;
          }
        }
        if (this.options.rtl) {
          this.dom.content.style.right = contentStartPosition + 'px';
        } else {
          this.dom.content.style.left = contentStartPosition + 'px';
          this.dom.content.style.width = 'calc(100% - ' + contentStartPosition + 'px)';
        }
    }
  };

  /**
   * Reposition the item vertically
   * @Override
   */
  RangeItem.prototype.repositionY = function () {
    var orientation = this.options.orientation.item;
    var box = this.dom.box;

    if (orientation == 'top') {
      box.style.top = this.top + 'px';
    } else {
      box.style.top = this.parent.height - this.top - this.height + 'px';
    }
  };

  /**
   * Repaint a drag area on the left side of the range when the range is selected
   * @protected
   */
  RangeItem.prototype._repaintDragLeft = function () {
    if (this.selected && this.options.editable.updateTime && !this.dom.dragLeft) {
      // create and show drag area
      var dragLeft = document.createElement('div');
      dragLeft.className = 'vis-drag-left';
      dragLeft.dragLeftItem = this;

      this.dom.box.appendChild(dragLeft);
      this.dom.dragLeft = dragLeft;
    } else if (!this.selected && this.dom.dragLeft) {
      // delete drag area
      if (this.dom.dragLeft.parentNode) {
        this.dom.dragLeft.parentNode.removeChild(this.dom.dragLeft);
      }
      this.dom.dragLeft = null;
    }
  };

  /**
   * Repaint a drag area on the right side of the range when the range is selected
   * @protected
   */
  RangeItem.prototype._repaintDragRight = function () {
    if (this.selected && this.options.editable.updateTime && !this.dom.dragRight) {
      // create and show drag area
      var dragRight = document.createElement('div');
      dragRight.className = 'vis-drag-right';
      dragRight.dragRightItem = this;

      this.dom.box.appendChild(dragRight);
      this.dom.dragRight = dragRight;
    } else if (!this.selected && this.dom.dragRight) {
      // delete drag area
      if (this.dom.dragRight.parentNode) {
        this.dom.dragRight.parentNode.removeChild(this.dom.dragRight);
      }
      this.dom.dragRight = null;
    }
  };

  module.exports = RangeItem;

/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var Hammer = __webpack_require__(108);
  var util = __webpack_require__(1);
  var moment = __webpack_require__(84);

  /**
   * @constructor Item
   * @param {Object} data             Object containing (optional) parameters type,
   *                                  start, end, content, group, className.
   * @param {{toScreen: function, toTime: function}} conversion
   *                                  Conversion functions from time to screen and vice versa
   * @param {Object} options          Configuration options
   *                                  // TODO: describe available options
   */
  function Item(data, conversion, options) {
    this.id = null;
    this.parent = null;
    this.data = data;
    this.dom = null;
    this.conversion = conversion || {};
    this.options = options || {};
    this.selected = false;
    this.displayed = false;
    this.groupShowing = true;
    this.dirty = true;
    this.popup = null;

    this.top = null;
    this.right = null;
    this.left = null;
    this.width = null;
    this.height = null;

    this.editable = null;
    if (this.data && this.data.hasOwnProperty('editable')) {
      if (typeof this.data.editable === 'boolean') {
        this.editable = {
          updateTime: this.data.editable,
          updateGroup: this.data.editable,
          remove: this.data.editable
        };
      } else if ((0, _typeof3['default'])(options.editable) === 'object') {
        this.editable = {};
        util.selectiveExtend(['updateTime', 'updateGroup', 'remove'], this.editable, data.editable);
      };
    }
  }

  Item.prototype.stack = true;

  /**
   * Select current item
   */
  Item.prototype.select = function () {
    this.selected = true;
    this.dirty = true;
    if (this.displayed) this.redraw();
  };

  /**
   * Unselect current item
   */
  Item.prototype.unselect = function () {
    this.selected = false;
    this.dirty = true;
    if (this.displayed) this.redraw();
  };

  /**
   * Set data for the item. Existing data will be updated. The id should not
   * be changed. When the item is displayed, it will be redrawn immediately.
   * @param {Object} data
   */
  Item.prototype.setData = function (data) {
    var groupChanged = data.group != undefined && this.data.group != data.group;
    if (groupChanged) {
      this.parent.itemSet._moveToGroup(this, data.group);
    }

    if (data.hasOwnProperty('editable')) {
      if (typeof data.editable === 'boolean') {
        this.editable = {
          updateTime: this.data.editable,
          updateGroup: this.data.editable,
          remove: this.data.editable
        };
      } else if ((0, _typeof3['default'])(options.editable) === 'object') {
        this.editable = {};
        util.selectiveExtend(['updateTime', 'updateGroup', 'remove'], this.editable, data.editable);
      }
    }

    this.data = data;
    this.dirty = true;
    if (this.displayed) this.redraw();
  };

  /**
   * Set a parent for the item
   * @param {ItemSet | Group} parent
   */
  Item.prototype.setParent = function (parent) {
    if (this.displayed) {
      this.hide();
      this.parent = parent;
      if (this.parent) {
        this.show();
      }
    } else {
      this.parent = parent;
    }
  };

  /**
   * Check whether this item is visible inside given range
   * @returns {{start: Number, end: Number}} range with a timestamp for start and end
   * @returns {boolean} True if visible
   */
  Item.prototype.isVisible = function (range) {
    return false;
  };

  /**
   * Show the Item in the DOM (when not already visible)
   * @return {Boolean} changed
   */
  Item.prototype.show = function () {
    return false;
  };

  /**
   * Hide the Item from the DOM (when visible)
   * @return {Boolean} changed
   */
  Item.prototype.hide = function () {
    return false;
  };

  /**
   * Repaint the item
   */
  Item.prototype.redraw = function () {
    // should be implemented by the item
  };

  /**
   * Reposition the Item horizontally
   */
  Item.prototype.repositionX = function () {
    // should be implemented by the item
  };

  /**
   * Reposition the Item vertically
   */
  Item.prototype.repositionY = function () {
    // should be implemented by the item
  };

  /**
   * Repaint a drag area on the center of the item when the item is selected
   * @protected
   */
  Item.prototype._repaintDragCenter = function () {
    if (this.selected && this.options.editable.updateTime && !this.dom.dragCenter) {
      var me = this;

      // create and show drag area
      var dragCenter = document.createElement('div');
      dragCenter.className = 'vis-drag-center';
      dragCenter.dragCenterItem = this;

      new Hammer(dragCenter).on('doubletap', function (event) {
        event.stopPropagation();
        me.parent.itemSet._onUpdateItem(me);
      });

      if (this.dom.box) {
        this.dom.box.appendChild(dragCenter);
      } else if (this.dom.point) {
        this.dom.point.appendChild(dragCenter);
      }

      this.dom.dragCenter = dragCenter;
    } else if (!this.selected && this.dom.dragCenter) {
      // delete drag area
      if (this.dom.dragCenter.parentNode) {
        this.dom.dragCenter.parentNode.removeChild(this.dom.dragCenter);
      }
      this.dom.dragCenter = null;
    }
  };

  /**
   * Repaint a delete button on the top right of the item when the item is selected
   * @param {HTMLElement} anchor
   * @protected
   */
  Item.prototype._repaintDeleteButton = function (anchor) {
    var editable = (this.options.editable.overrideItems || this.editable == null) && this.options.editable.remove || !this.options.editable.overrideItems && this.editable != null && this.editable.remove;

    if (this.selected && editable && !this.dom.deleteButton) {
      // create and show button
      var me = this;

      var deleteButton = document.createElement('div');

      if (this.options.rtl) {
        deleteButton.className = 'vis-delete-rtl';
      } else {
        deleteButton.className = 'vis-delete';
      }
      deleteButton.title = 'Delete this item';

      // TODO: be able to destroy the delete button
      new Hammer(deleteButton).on('tap', function (event) {
        event.stopPropagation();
        me.parent.removeFromDataSet(me);
      });

      anchor.appendChild(deleteButton);
      this.dom.deleteButton = deleteButton;
    } else if (!this.selected && this.dom.deleteButton) {
      // remove button
      if (this.dom.deleteButton.parentNode) {
        this.dom.deleteButton.parentNode.removeChild(this.dom.deleteButton);
      }
      this.dom.deleteButton = null;
    }
  };

  /**
   * Repaint a onChange tooltip on the top right of the item when the item is selected
   * @param {HTMLElement} anchor
   * @protected
   */
  Item.prototype._repaintOnItemUpdateTimeTooltip = function (anchor) {
    if (!this.options.tooltipOnItemUpdateTime) return;

    var editable = (this.options.editable.updateTime || this.data.editable === true) && this.data.editable !== false;

    if (this.selected && editable && !this.dom.onItemUpdateTimeTooltip) {
      // create and show tooltip
      var me = this;

      var onItemUpdateTimeTooltip = document.createElement('div');

      onItemUpdateTimeTooltip.className = 'vis-onUpdateTime-tooltip';
      anchor.appendChild(onItemUpdateTimeTooltip);
      this.dom.onItemUpdateTimeTooltip = onItemUpdateTimeTooltip;
    } else if (!this.selected && this.dom.onItemUpdateTimeTooltip) {
      // remove button
      if (this.dom.onItemUpdateTimeTooltip.parentNode) {
        this.dom.onItemUpdateTimeTooltip.parentNode.removeChild(this.dom.onItemUpdateTimeTooltip);
      }
      this.dom.onItemUpdateTimeTooltip = null;
    }

    // position onChange tooltip
    if (this.dom.onItemUpdateTimeTooltip) {

      // only show when editing
      this.dom.onItemUpdateTimeTooltip.style.visibility = this.parent.itemSet.touchParams.itemIsDragging ? 'visible' : 'hidden';

      // position relative to item's content
      if (this.options.rtl) {
        this.dom.onItemUpdateTimeTooltip.style.right = this.dom.content.style.right;
      } else {
        this.dom.onItemUpdateTimeTooltip.style.left = this.dom.content.style.left;
      }

      // position above or below the item depending on the item's position in the window
      var tooltipOffset = 50; // TODO: should be tooltip height (depends on template)
      var scrollTop = this.parent.itemSet.body.domProps.scrollTop;

      // TODO: this.top for orientation:true is actually the items distance from the bottom... 
      // (should be this.bottom)
      var itemDistanceFromTop;
      if (this.options.orientation.item == 'top') {
        itemDistanceFromTop = this.top;
      } else {
        itemDistanceFromTop = this.parent.height - this.top - this.height;
      }
      var isCloseToTop = itemDistanceFromTop + this.parent.top - tooltipOffset < -scrollTop;

      if (isCloseToTop) {
        this.dom.onItemUpdateTimeTooltip.style.bottom = "";
        this.dom.onItemUpdateTimeTooltip.style.top = this.height + 2 + "px";
      } else {
        this.dom.onItemUpdateTimeTooltip.style.top = "";
        this.dom.onItemUpdateTimeTooltip.style.bottom = this.height + 2 + "px";
      }

      // handle tooltip content
      var content;
      var templateFunction;

      if (this.options.tooltipOnItemUpdateTime && this.options.tooltipOnItemUpdateTime.template) {
        templateFunction = this.options.tooltipOnItemUpdateTime.template.bind(this);
        content = templateFunction(this.data);
      } else {
        content = 'start: ' + moment(this.data.start).format('MM/DD/YYYY hh:mm');
        if (this.data.end) {
          content += '<br> end: ' + moment(this.data.end).format('MM/DD/YYYY hh:mm');
        }
      }
      this.dom.onItemUpdateTimeTooltip.innerHTML = content;
    }
  };

  /**
   * Set HTML contents for the item
   * @param {Element} element   HTML element to fill with the contents
   * @private
   */
  Item.prototype._updateContents = function (element) {
    var content;
    var templateFunction;
    var itemVisibleFrameContent;
    var visibleFrameTemplateFunction;
    var itemData = this.parent.itemSet.itemsData.get(this.id); // get a clone of the data from the dataset

    var frameElement = this.dom.box || this.dom.point;
    var itemVisibleFrameContentElement = frameElement.getElementsByClassName('vis-item-visible-frame')[0];

    if (this.options.visibleFrameTemplate) {
      visibleFrameTemplateFunction = this.options.visibleFrameTemplate.bind(this);
      itemVisibleFrameContent = visibleFrameTemplateFunction(itemData, frameElement);
    } else {
      itemVisibleFrameContent = '';
    }

    if (itemVisibleFrameContentElement) {
      if (itemVisibleFrameContent instanceof Object && !(itemVisibleFrameContent instanceof Element)) {
        visibleFrameTemplateFunction(itemData, itemVisibleFrameContentElement);
      } else {
        var changed = this._contentToString(this.itemVisibleFrameContent) !== this._contentToString(itemVisibleFrameContent);
        if (changed) {
          // only replace the content when changed
          if (itemVisibleFrameContent instanceof Element) {
            itemVisibleFrameContentElement.innerHTML = '';
            itemVisibleFrameContentElement.appendChild(itemVisibleFrameContent);
          } else if (itemVisibleFrameContent != undefined) {
            itemVisibleFrameContentElement.innerHTML = itemVisibleFrameContent;
          } else {
            if (!(this.data.type == 'background' && this.data.content === undefined)) {
              throw new Error('Property "content" missing in item ' + this.id);
            }
          }

          this.itemVisibleFrameContent = itemVisibleFrameContent;
        }
      }
    }

    if (this.options.template) {
      templateFunction = this.options.template.bind(this);
      content = templateFunction(itemData, element);
    } else {
      content = this.data.content;
    }

    if (content instanceof Object && !(content instanceof Element)) {
      templateFunction(itemData, element);
    } else {
      var changed = this._contentToString(this.content) !== this._contentToString(content);
      if (changed) {
        // only replace the content when changed
        if (content instanceof Element) {
          element.innerHTML = '';
          element.appendChild(content);
        } else if (content != undefined) {
          element.innerHTML = content;
        } else {
          if (!(this.data.type == 'background' && this.data.content === undefined)) {
            throw new Error('Property "content" missing in item ' + this.id);
          }
        }

        this.content = content;
      }
    }
  };

  /**
   * Set HTML contents for the item
   * @private
   */
  Item.prototype._updateTitle = function () {
    if (this.data.title != null) {
      if (this.popup != null) {
        this.popup.setText(this.data.title || '');
      }
    }
  };

  /**
   * Process dataAttributes timeline option and set as data- attributes on dom.content
   * @param {Element} element   HTML element to which the attributes will be attached
   * @private
   */
  Item.prototype._updateDataAttributes = function (element) {
    if (this.options.dataAttributes && this.options.dataAttributes.length > 0) {
      var attributes = [];

      if (Array.isArray(this.options.dataAttributes)) {
        attributes = this.options.dataAttributes;
      } else if (this.options.dataAttributes == 'all') {
        attributes = (0, _keys2['default'])(this.data);
      } else {
        return;
      }

      for (var i = 0; i < attributes.length; i++) {
        var name = attributes[i];
        var value = this.data[name];

        if (value != null) {
          element.setAttribute('data-' + name, value);
        } else {
          element.removeAttribute('data-' + name);
        }
      }
    }
  };

  /**
   * Update custom styles of the element
   * @param element
   * @private
   */
  Item.prototype._updateStyle = function (element) {
    // remove old styles
    if (this.style) {
      util.removeCssText(element, this.style);
      this.style = null;
    }

    // append new styles
    if (this.data.style) {
      util.addCssText(element, this.data.style);
      this.style = this.data.style;
    }
  };

  /**
   * Stringify the items contents
   * @param {string | Element | undefined} content
   * @returns {string | undefined}
   * @private
   */
  Item.prototype._contentToString = function (content) {
    if (typeof content === 'string') return content;
    if (content && 'outerHTML' in content) return content.outerHTML;
    return content;
  };

  /**
   * Return the width of the item left from its start date
   * @return {number}
   */
  Item.prototype.getWidthLeft = function () {
    return 0;
  };

  /**
   * Return the width of the item right from the max of its start and end date
   * @return {number}
   */
  Item.prototype.getWidthRight = function () {
    return 0;
  };

  /**
   * Return the title of the item
   * @return {string | undefined}
   */
  Item.prototype.getTitle = function () {
    return this.data.title;
  };

  /**
   * Set the popup object, and update the title
   * @param {Popup} popup
   */
  Item.prototype.setPopup = function (popup) {
    this.popup = popup;
    this._updateTitle();
  };

  module.exports = Item;

/***/ },
/* 134 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _create = __webpack_require__(55);

  var _create2 = _interopRequireDefault(_create);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var Group = __webpack_require__(130);

  /**
   * @constructor BackgroundGroup
   * @param {Number | String} groupId
   * @param {Object} data
   * @param {ItemSet} itemSet
   */
  function BackgroundGroup(groupId, data, itemSet) {
    Group.call(this, groupId, data, itemSet);

    this.width = 0;
    this.height = 0;
    this.top = 0;
    this.left = 0;
  }

  BackgroundGroup.prototype = (0, _create2['default'])(Group.prototype);

  /**
   * Repaint this group
   * @param {{start: number, end: number}} range
   * @param {{item: {horizontal: number, vertical: number}, axis: number}} margin
   * @param {boolean} [restack=false]  Force restacking of all items
   * @return {boolean} Returns true if the group is resized
   */
  BackgroundGroup.prototype.redraw = function (range, margin, restack) {
    var resized = false;

    this.visibleItems = this._updateItemsInRange(this.orderedItems, this.visibleItems, range);

    // calculate actual size
    this.width = this.dom.background.offsetWidth;

    // apply new height (just always zero for BackgroundGroup
    this.dom.background.style.height = '0';

    // update vertical position of items after they are re-stacked and the height of the group is calculated
    for (var i = 0, ii = this.visibleItems.length; i < ii; i++) {
      var item = this.visibleItems[i];
      item.repositionY(margin);
    }

    return resized;
  };

  /**
   * Show this group: attach to the DOM
   */
  BackgroundGroup.prototype.show = function () {
    if (!this.dom.background.parentNode) {
      this.itemSet.dom.background.appendChild(this.dom.background);
    }
  };

  module.exports = BackgroundGroup;

/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var Item = __webpack_require__(133);
  var util = __webpack_require__(1);

  /**
   * @constructor BoxItem
   * @extends Item
   * @param {Object} data             Object containing parameters start
   *                                  content, className.
   * @param {{toScreen: function, toTime: function}} conversion
   *                                  Conversion functions from time to screen and vice versa
   * @param {Object} [options]        Configuration options
   *                                  // TODO: describe available options
   */
  function BoxItem(data, conversion, options) {
    this.props = {
      dot: {
        width: 0,
        height: 0
      },
      line: {
        width: 0,
        height: 0
      }
    };
    this.options = options;
    // validate data
    if (data) {
      if (data.start == undefined) {
        throw new Error('Property "start" missing in item ' + data);
      }
    }

    Item.call(this, data, conversion, options);
  }

  BoxItem.prototype = new Item(null, null, null);

  /**
   * Check whether this item is visible inside given range
   * @param {{start: Number, end: Number}} range with a timestamp for start and end
   * @returns {boolean} True if visible
   */
  BoxItem.prototype.isVisible = function (range) {
    // determine visibility
    var isVisible;
    var align = this.options.align;
    var widthInMs = this.width * range.getMillisecondsPerPixel();

    if (align == 'right') {
      isVisible = this.data.start.getTime() > range.start && this.data.start.getTime() - widthInMs < range.end;
    } else if (align == 'left') {
      isVisible = this.data.start.getTime() + widthInMs > range.start && this.data.start.getTime() < range.end;
    } else {
      // default or 'center'
      isVisible = this.data.start.getTime() + widthInMs / 2 > range.start && this.data.start.getTime() - widthInMs / 2 < range.end;
    }
    return isVisible;
  };

  /**
   * Repaint the item
   */
  BoxItem.prototype.redraw = function () {
    var dom = this.dom;
    if (!dom) {
      // create DOM
      this.dom = {};
      dom = this.dom;

      // create main box
      dom.box = document.createElement('DIV');

      // contents box (inside the background box). used for making margins
      dom.content = document.createElement('DIV');
      dom.content.className = 'vis-item-content';
      dom.box.appendChild(dom.content);

      // line to axis
      dom.line = document.createElement('DIV');
      dom.line.className = 'vis-line';

      // dot on axis
      dom.dot = document.createElement('DIV');
      dom.dot.className = 'vis-dot';

      // attach this item as attribute
      dom.box['timeline-item'] = this;

      this.dirty = true;
    }

    // append DOM to parent DOM
    if (!this.parent) {
      throw new Error('Cannot redraw item: no parent attached');
    }
    if (!dom.box.parentNode) {
      var foreground = this.parent.dom.foreground;
      if (!foreground) throw new Error('Cannot redraw item: parent has no foreground container element');
      foreground.appendChild(dom.box);
    }
    if (!dom.line.parentNode) {
      var background = this.parent.dom.background;
      if (!background) throw new Error('Cannot redraw item: parent has no background container element');
      background.appendChild(dom.line);
    }
    if (!dom.dot.parentNode) {
      var axis = this.parent.dom.axis;
      if (!background) throw new Error('Cannot redraw item: parent has no axis container element');
      axis.appendChild(dom.dot);
    }
    this.displayed = true;

    // Update DOM when item is marked dirty. An item is marked dirty when:
    // - the item is not yet rendered
    // - the item's data is changed
    // - the item is selected/deselected
    if (this.dirty) {
      this._updateContents(this.dom.content);
      this._updateTitle();
      this._updateDataAttributes(this.dom.box);
      this._updateStyle(this.dom.box);

      var editable = (this.options.editable.updateTime || this.options.editable.updateGroup || this.editable === true) && this.editable !== false;

      // update class
      var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '') + (editable ? ' vis-editable' : ' vis-readonly');
      dom.box.className = 'vis-item vis-box' + className;
      dom.line.className = 'vis-item vis-line' + className;
      dom.dot.className = 'vis-item vis-dot' + className;

      // set initial position in the visible range of the grid so that the
      // rendered box size can be determinated correctly, even the content
      // has a dynamic width (fixes #2032).
      var previousRight = dom.box.style.right;
      var previousLeft = dom.box.style.left;
      if (this.options.rtl) {
        dom.box.style.right = "0px";
      } else {
        dom.box.style.left = "0px";
      }

      // recalculate size
      this.props.dot.height = dom.dot.offsetHeight;
      this.props.dot.width = dom.dot.offsetWidth;
      this.props.line.width = dom.line.offsetWidth;
      this.width = dom.box.offsetWidth;
      this.height = dom.box.offsetHeight;

      // restore previous position
      if (this.options.rtl) {
        dom.box.style.right = previousRight;
      } else {
        dom.box.style.left = previousLeft;
      }

      this.dirty = false;
    }

    this._repaintOnItemUpdateTimeTooltip(dom.box);
    this._repaintDragCenter();
    this._repaintDeleteButton(dom.box);
  };

  /**
   * Show the item in the DOM (when not already displayed). The items DOM will
   * be created when needed.
   */
  BoxItem.prototype.show = function () {
    if (!this.displayed) {
      this.redraw();
    }
  };

  /**
   * Hide the item from the DOM (when visible)
   */
  BoxItem.prototype.hide = function () {
    if (this.displayed) {
      var dom = this.dom;

      if (dom.box.parentNode) dom.box.parentNode.removeChild(dom.box);
      if (dom.line.parentNode) dom.line.parentNode.removeChild(dom.line);
      if (dom.dot.parentNode) dom.dot.parentNode.removeChild(dom.dot);

      this.displayed = false;
    }
  };

  /**
   * Reposition the item horizontally
   * @Override
   */
  BoxItem.prototype.repositionX = function () {
    var start = this.conversion.toScreen(this.data.start);
    var align = this.options.align;

    // calculate left position of the box
    if (align == 'right') {
      if (this.options.rtl) {
        this.right = start - this.width;

        // reposition box, line, and dot
        this.dom.box.style.right = this.right + 'px';
        this.dom.line.style.right = start - this.props.line.width + 'px';
        this.dom.dot.style.right = start - this.props.line.width / 2 - this.props.dot.width / 2 + 'px';
      } else {
        this.left = start - this.width;

        // reposition box, line, and dot
        this.dom.box.style.left = this.left + 'px';
        this.dom.line.style.left = start - this.props.line.width + 'px';
        this.dom.dot.style.left = start - this.props.line.width / 2 - this.props.dot.width / 2 + 'px';
      }
    } else if (align == 'left') {
      if (this.options.rtl) {
        this.right = start;

        // reposition box, line, and dot
        this.dom.box.style.right = this.right + 'px';
        this.dom.line.style.right = start + 'px';
        this.dom.dot.style.right = start + this.props.line.width / 2 - this.props.dot.width / 2 + 'px';
      } else {
        this.left = start;

        // reposition box, line, and dot
        this.dom.box.style.left = this.left + 'px';
        this.dom.line.style.left = start + 'px';
        this.dom.dot.style.left = start + this.props.line.width / 2 - this.props.dot.width / 2 + 'px';
      }
    } else {
      // default or 'center'
      if (this.options.rtl) {
        this.right = start - this.width / 2;

        // reposition box, line, and dot
        this.dom.box.style.right = this.right + 'px';
        this.dom.line.style.right = start - this.props.line.width + 'px';
        this.dom.dot.style.right = start - this.props.dot.width / 2 + 'px';
      } else {
        this.left = start - this.width / 2;

        // reposition box, line, and dot
        this.dom.box.style.left = this.left + 'px';
        this.dom.line.style.left = start - this.props.line.width / 2 + 'px';
        this.dom.dot.style.left = start - this.props.dot.width / 2 + 'px';
      }
    }
  };

  /**
   * Reposition the item vertically
   * @Override
   */
  BoxItem.prototype.repositionY = function () {
    var orientation = this.options.orientation.item;
    var box = this.dom.box;
    var line = this.dom.line;
    var dot = this.dom.dot;

    if (orientation == 'top') {
      box.style.top = (this.top || 0) + 'px';

      line.style.top = '0';
      line.style.height = this.parent.top + this.top + 1 + 'px';
      line.style.bottom = '';
    } else {
      // orientation 'bottom'
      var itemSetHeight = this.parent.itemSet.props.height; // TODO: this is nasty
      var lineHeight = itemSetHeight - this.parent.top - this.parent.height + this.top;

      box.style.top = (this.parent.height - this.top - this.height || 0) + 'px';
      line.style.top = itemSetHeight - lineHeight + 'px';
      line.style.bottom = '0';
    }

    dot.style.top = -this.props.dot.height / 2 + 'px';
  };

  /**
   * Return the width of the item left from its start date
   * @return {number}
   */
  BoxItem.prototype.getWidthLeft = function () {
    return this.width / 2;
  };

  /**
   * Return the width of the item right from its start date
   * @return {number}
   */
  BoxItem.prototype.getWidthRight = function () {
    return this.width / 2;
  };

  module.exports = BoxItem;

/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var Item = __webpack_require__(133);

  /**
   * @constructor PointItem
   * @extends Item
   * @param {Object} data             Object containing parameters start
   *                                  content, className.
   * @param {{toScreen: function, toTime: function}} conversion
   *                                  Conversion functions from time to screen and vice versa
   * @param {Object} [options]        Configuration options
   *                                  // TODO: describe available options
   */
  function PointItem(data, conversion, options) {
    this.props = {
      dot: {
        top: 0,
        width: 0,
        height: 0
      },
      content: {
        height: 0,
        marginLeft: 0,
        marginRight: 0
      }
    };
    this.options = options;
    // validate data
    if (data) {
      if (data.start == undefined) {
        throw new Error('Property "start" missing in item ' + data);
      }
    }

    Item.call(this, data, conversion, options);
  }

  PointItem.prototype = new Item(null, null, null);

  /**
   * Check whether this item is visible inside given range
   * @param {{start: Number, end: Number}} range with a timestamp for start and end
   * @returns {boolean} True if visible
   */
  PointItem.prototype.isVisible = function (range) {
    // determine visibility
    var widthInMs = this.width * range.getMillisecondsPerPixel();

    return this.data.start.getTime() + widthInMs > range.start && this.data.start < range.end;
  };

  /**
   * Repaint the item
   */
  PointItem.prototype.redraw = function () {
    var dom = this.dom;
    if (!dom) {
      // create DOM
      this.dom = {};
      dom = this.dom;

      // background box
      dom.point = document.createElement('div');
      // className is updated in redraw()

      // contents box, right from the dot
      dom.content = document.createElement('div');
      dom.content.className = 'vis-item-content';
      dom.point.appendChild(dom.content);

      // dot at start
      dom.dot = document.createElement('div');
      dom.point.appendChild(dom.dot);

      // attach this item as attribute
      dom.point['timeline-item'] = this;

      this.dirty = true;
    }

    // append DOM to parent DOM
    if (!this.parent) {
      throw new Error('Cannot redraw item: no parent attached');
    }
    if (!dom.point.parentNode) {
      var foreground = this.parent.dom.foreground;
      if (!foreground) {
        throw new Error('Cannot redraw item: parent has no foreground container element');
      }
      foreground.appendChild(dom.point);
    }
    this.displayed = true;

    // Update DOM when item is marked dirty. An item is marked dirty when:
    // - the item is not yet rendered
    // - the item's data is changed
    // - the item is selected/deselected
    if (this.dirty) {
      this._updateContents(this.dom.content);
      this._updateTitle();
      this._updateDataAttributes(this.dom.point);
      this._updateStyle(this.dom.point);

      var editable = (this.options.editable.updateTime || this.options.editable.updateGroup || this.editable === true) && this.editable !== false;

      // update class
      var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '') + (editable ? ' vis-editable' : ' vis-readonly');
      dom.point.className = 'vis-item vis-point' + className;
      dom.dot.className = 'vis-item vis-dot' + className;

      // recalculate size of dot and contents
      this.props.dot.width = dom.dot.offsetWidth;
      this.props.dot.height = dom.dot.offsetHeight;
      this.props.content.height = dom.content.offsetHeight;

      // resize contents
      if (this.options.rtl) {
        dom.content.style.marginRight = 2 * this.props.dot.width + 'px';
      } else {
        dom.content.style.marginLeft = 2 * this.props.dot.width + 'px';
      }
      //dom.content.style.marginRight = ... + 'px'; // TODO: margin right

      // recalculate size
      this.width = dom.point.offsetWidth;
      this.height = dom.point.offsetHeight;

      // reposition the dot
      dom.dot.style.top = (this.height - this.props.dot.height) / 2 + 'px';
      if (this.options.rtl) {
        dom.dot.style.right = this.props.dot.width / 2 + 'px';
      } else {
        dom.dot.style.left = this.props.dot.width / 2 + 'px';
      }

      this.dirty = false;
    }

    this._repaintOnItemUpdateTimeTooltip(dom.point);
    this._repaintDragCenter();
    this._repaintDeleteButton(dom.point);
  };

  /**
   * Show the item in the DOM (when not already visible). The items DOM will
   * be created when needed.
   */
  PointItem.prototype.show = function () {
    if (!this.displayed) {
      this.redraw();
    }
  };

  /**
   * Hide the item from the DOM (when visible)
   */
  PointItem.prototype.hide = function () {
    if (this.displayed) {
      if (this.dom.point.parentNode) {
        this.dom.point.parentNode.removeChild(this.dom.point);
      }

      this.displayed = false;
    }
  };

  /**
   * Reposition the item horizontally
   * @Override
   */
  PointItem.prototype.repositionX = function () {
    var start = this.conversion.toScreen(this.data.start);

    if (this.options.rtl) {
      this.right = start - this.props.dot.width;

      // reposition point
      this.dom.point.style.right = this.right + 'px';
    } else {
      this.left = start - this.props.dot.width;

      // reposition point
      this.dom.point.style.left = this.left + 'px';
    }
  };

  /**
   * Reposition the item vertically
   * @Override
   */
  PointItem.prototype.repositionY = function () {
    var orientation = this.options.orientation.item;
    var point = this.dom.point;
    if (orientation == 'top') {
      point.style.top = this.top + 'px';
    } else {
      point.style.top = this.parent.height - this.top - this.height + 'px';
    }
  };

  /**
   * Return the width of the item left from its start date
   * @return {number}
   */
  PointItem.prototype.getWidthLeft = function () {
    return this.props.dot.width;
  };

  /**
   * Return the width of the item right from  its start date
   * @return {number}
   */
  PointItem.prototype.getWidthRight = function () {
    return this.props.dot.width;
  };

  module.exports = PointItem;

/***/ },
/* 137 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var Hammer = __webpack_require__(108);
  var Item = __webpack_require__(133);
  var BackgroundGroup = __webpack_require__(134);
  var RangeItem = __webpack_require__(132);

  /**
   * @constructor BackgroundItem
   * @extends Item
   * @param {Object} data             Object containing parameters start, end
   *                                  content, className.
   * @param {{toScreen: function, toTime: function}} conversion
   *                                  Conversion functions from time to screen and vice versa
   * @param {Object} [options]        Configuration options
   *                                  // TODO: describe options
   */
  // TODO: implement support for the BackgroundItem just having a start, then being displayed as a sort of an annotation
  function BackgroundItem(data, conversion, options) {
    this.props = {
      content: {
        width: 0
      }
    };
    this.overflow = false; // if contents can overflow (css styling), this flag is set to true

    // validate data
    if (data) {
      if (data.start == undefined) {
        throw new Error('Property "start" missing in item ' + data.id);
      }
      if (data.end == undefined) {
        throw new Error('Property "end" missing in item ' + data.id);
      }
    }

    Item.call(this, data, conversion, options);
  }

  BackgroundItem.prototype = new Item(null, null, null);

  BackgroundItem.prototype.baseClassName = 'vis-item vis-background';
  BackgroundItem.prototype.stack = false;

  /**
   * Check whether this item is visible inside given range
   * @returns {{start: Number, end: Number}} range with a timestamp for start and end
   * @returns {boolean} True if visible
   */
  BackgroundItem.prototype.isVisible = function (range) {
    // determine visibility
    return this.data.start < range.end && this.data.end > range.start;
  };

  /**
   * Repaint the item
   */
  BackgroundItem.prototype.redraw = function () {
    var dom = this.dom;
    if (!dom) {
      // create DOM
      this.dom = {};
      dom = this.dom;

      // background box
      dom.box = document.createElement('div');
      // className is updated in redraw()

      // frame box (to prevent the item contents from overflowing
      dom.frame = document.createElement('div');
      dom.frame.className = 'vis-item-overflow';
      dom.box.appendChild(dom.frame);

      // contents box
      dom.content = document.createElement('div');
      dom.content.className = 'vis-item-content';
      dom.frame.appendChild(dom.content);

      // Note: we do NOT attach this item as attribute to the DOM,
      //       such that background items cannot be selected
      //dom.box['timeline-item'] = this;

      this.dirty = true;
    }

    // append DOM to parent DOM
    if (!this.parent) {
      throw new Error('Cannot redraw item: no parent attached');
    }
    if (!dom.box.parentNode) {
      var background = this.parent.dom.background;
      if (!background) {
        throw new Error('Cannot redraw item: parent has no background container element');
      }
      background.appendChild(dom.box);
    }
    this.displayed = true;

    // Update DOM when item is marked dirty. An item is marked dirty when:
    // - the item is not yet rendered
    // - the item's data is changed
    // - the item is selected/deselected
    if (this.dirty) {
      this._updateContents(this.dom.content);
      this._updateTitle();
      this._updateDataAttributes(this.dom.content);
      this._updateStyle(this.dom.box);

      // update class
      var className = (this.data.className ? ' ' + this.data.className : '') + (this.selected ? ' vis-selected' : '');
      dom.box.className = this.baseClassName + className;

      // determine from css whether this box has overflow
      this.overflow = window.getComputedStyle(dom.content).overflow !== 'hidden';

      // recalculate size
      this.props.content.width = this.dom.content.offsetWidth;
      this.height = 0; // set height zero, so this item will be ignored when stacking items

      this.dirty = false;
    }
  };

  /**
   * Show the item in the DOM (when not already visible). The items DOM will
   * be created when needed.
   */
  BackgroundItem.prototype.show = RangeItem.prototype.show;

  /**
   * Hide the item from the DOM (when visible)
   * @return {Boolean} changed
   */
  BackgroundItem.prototype.hide = RangeItem.prototype.hide;

  /**
   * Reposition the item horizontally
   * @Override
   */
  BackgroundItem.prototype.repositionX = RangeItem.prototype.repositionX;

  /**
   * Reposition the item vertically
   * @Override
   */
  BackgroundItem.prototype.repositionY = function (margin) {
    var height;

    // special positioning for subgroups
    if (this.data.subgroup !== undefined) {
      // TODO: instead of calculating the top position of the subgroups here for every BackgroundItem, calculate the top of the subgroup once in Itemset

      var itemSubgroup = this.data.subgroup;
      var subgroups = this.parent.subgroups;
      var subgroupIndex = subgroups[itemSubgroup].index;

      this.dom.box.style.height = this.parent.subgroups[itemSubgroup].height + 'px';

      var orientation = this.options.orientation.item;
      if (orientation == 'top') {
        this.dom.box.style.top = this.parent.top + this.parent.subgroups[itemSubgroup].top + 'px';
      } else {
        this.dom.box.style.top = this.parent.top + this.parent.height - this.parent.subgroups[itemSubgroup].top - this.parent.subgroups[itemSubgroup].height + 'px';
      }
      this.dom.box.style.bottom = '';
    }
    // and in the case of no subgroups:
    else {
        // we want backgrounds with groups to only show in groups.
        if (this.parent instanceof BackgroundGroup) {
          // if the item is not in a group:
          height = Math.max(this.parent.height, this.parent.itemSet.body.domProps.center.height, this.parent.itemSet.body.domProps.centerContainer.height);
          this.dom.box.style.top = orientation == 'top' ? '0' : '';
          this.dom.box.style.bottom = orientation == 'top' ? '' : '0';
        } else {
          height = this.parent.height;
          // same alignment for items when orientation is top or bottom
          this.dom.box.style.top = this.parent.top + 'px';
          this.dom.box.style.bottom = '';
        }
      }
    this.dom.box.style.height = height + 'px';
  };

  module.exports = BackgroundItem;

/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var Component = __webpack_require__(124);
  var TimeStep = __webpack_require__(129);
  var DateUtil = __webpack_require__(125);
  var moment = __webpack_require__(84);

  /**
   * A horizontal time axis
   * @param {{dom: Object, domProps: Object, emitter: Emitter, range: Range}} body
   * @param {Object} [options]        See TimeAxis.setOptions for the available
   *                                  options.
   * @constructor TimeAxis
   * @extends Component
   */
  function TimeAxis(body, options) {
    this.dom = {
      foreground: null,
      lines: [],
      majorTexts: [],
      minorTexts: [],
      redundant: {
        lines: [],
        majorTexts: [],
        minorTexts: []
      }
    };
    this.props = {
      range: {
        start: 0,
        end: 0,
        minimumStep: 0
      },
      lineTop: 0
    };

    this.defaultOptions = {
      orientation: {
        axis: 'bottom'
      }, // axis orientation: 'top' or 'bottom'
      showMinorLabels: true,
      showMajorLabels: true,
      maxMinorChars: 7,
      format: TimeStep.FORMAT,
      moment: moment,
      timeAxis: null
    };
    this.options = util.extend({}, this.defaultOptions);

    this.body = body;

    // create the HTML DOM
    this._create();

    this.setOptions(options);
  }

  TimeAxis.prototype = new Component();

  /**
   * Set options for the TimeAxis.
   * Parameters will be merged in current options.
   * @param {Object} options  Available options:
   *                          {string} [orientation.axis]
   *                          {boolean} [showMinorLabels]
   *                          {boolean} [showMajorLabels]
   */
  TimeAxis.prototype.setOptions = function (options) {
    if (options) {
      // copy all options that we know
      util.selectiveExtend(['showMinorLabels', 'showMajorLabels', 'maxMinorChars', 'hiddenDates', 'timeAxis', 'moment', 'rtl'], this.options, options);

      // deep copy the format options
      util.selectiveDeepExtend(['format'], this.options, options);

      if ('orientation' in options) {
        if (typeof options.orientation === 'string') {
          this.options.orientation.axis = options.orientation;
        } else if ((0, _typeof3['default'])(options.orientation) === 'object' && 'axis' in options.orientation) {
          this.options.orientation.axis = options.orientation.axis;
        }
      }

      // apply locale to moment.js
      // TODO: not so nice, this is applied globally to moment.js
      if ('locale' in options) {
        if (typeof moment.locale === 'function') {
          // moment.js 2.8.1+
          moment.locale(options.locale);
        } else {
          moment.lang(options.locale);
        }
      }
    }
  };

  /**
   * Create the HTML DOM for the TimeAxis
   */
  TimeAxis.prototype._create = function () {
    this.dom.foreground = document.createElement('div');
    this.dom.background = document.createElement('div');

    this.dom.foreground.className = 'vis-time-axis vis-foreground';
    this.dom.background.className = 'vis-time-axis vis-background';
  };

  /**
   * Destroy the TimeAxis
   */
  TimeAxis.prototype.destroy = function () {
    // remove from DOM
    if (this.dom.foreground.parentNode) {
      this.dom.foreground.parentNode.removeChild(this.dom.foreground);
    }
    if (this.dom.background.parentNode) {
      this.dom.background.parentNode.removeChild(this.dom.background);
    }

    this.body = null;
  };

  /**
   * Repaint the component
   * @return {boolean} Returns true if the component is resized
   */
  TimeAxis.prototype.redraw = function () {
    var props = this.props;
    var foreground = this.dom.foreground;
    var background = this.dom.background;

    // determine the correct parent DOM element (depending on option orientation)
    var parent = this.options.orientation.axis == 'top' ? this.body.dom.top : this.body.dom.bottom;
    var parentChanged = foreground.parentNode !== parent;

    // calculate character width and height
    this._calculateCharSize();

    // TODO: recalculate sizes only needed when parent is resized or options is changed
    var showMinorLabels = this.options.showMinorLabels && this.options.orientation.axis !== 'none';
    var showMajorLabels = this.options.showMajorLabels && this.options.orientation.axis !== 'none';

    // determine the width and height of the elemens for the axis
    props.minorLabelHeight = showMinorLabels ? props.minorCharHeight : 0;
    props.majorLabelHeight = showMajorLabels ? props.majorCharHeight : 0;
    props.height = props.minorLabelHeight + props.majorLabelHeight;
    props.width = foreground.offsetWidth;

    props.minorLineHeight = this.body.domProps.root.height - props.majorLabelHeight - (this.options.orientation.axis == 'top' ? this.body.domProps.bottom.height : this.body.domProps.top.height);
    props.minorLineWidth = 1; // TODO: really calculate width
    props.majorLineHeight = props.minorLineHeight + props.majorLabelHeight;
    props.majorLineWidth = 1; // TODO: really calculate width

    //  take foreground and background offline while updating (is almost twice as fast)
    var foregroundNextSibling = foreground.nextSibling;
    var backgroundNextSibling = background.nextSibling;
    foreground.parentNode && foreground.parentNode.removeChild(foreground);
    background.parentNode && background.parentNode.removeChild(background);

    foreground.style.height = this.props.height + 'px';

    this._repaintLabels();

    // put DOM online again (at the same place)
    if (foregroundNextSibling) {
      parent.insertBefore(foreground, foregroundNextSibling);
    } else {
      parent.appendChild(foreground);
    }
    if (backgroundNextSibling) {
      this.body.dom.backgroundVertical.insertBefore(background, backgroundNextSibling);
    } else {
      this.body.dom.backgroundVertical.appendChild(background);
    }
    return this._isResized() || parentChanged;
  };

  /**
   * Repaint major and minor text labels and vertical grid lines
   * @private
   */
  TimeAxis.prototype._repaintLabels = function () {
    var orientation = this.options.orientation.axis;

    // calculate range and step (step such that we have space for 7 characters per label)
    var start = util.convert(this.body.range.start, 'Number');
    var end = util.convert(this.body.range.end, 'Number');
    var timeLabelsize = this.body.util.toTime((this.props.minorCharWidth || 10) * this.options.maxMinorChars).valueOf();
    var minimumStep = timeLabelsize - DateUtil.getHiddenDurationBefore(this.options.moment, this.body.hiddenDates, this.body.range, timeLabelsize);
    minimumStep -= this.body.util.toTime(0).valueOf();

    var step = new TimeStep(new Date(start), new Date(end), minimumStep, this.body.hiddenDates);
    step.setMoment(this.options.moment);
    if (this.options.format) {
      step.setFormat(this.options.format);
    }
    if (this.options.timeAxis) {
      step.setScale(this.options.timeAxis);
    }
    this.step = step;

    // Move all DOM elements to a "redundant" list, where they
    // can be picked for re-use, and clear the lists with lines and texts.
    // At the end of the function _repaintLabels, left over elements will be cleaned up
    var dom = this.dom;
    dom.redundant.lines = dom.lines;
    dom.redundant.majorTexts = dom.majorTexts;
    dom.redundant.minorTexts = dom.minorTexts;
    dom.lines = [];
    dom.majorTexts = [];
    dom.minorTexts = [];

    var current;
    var next;
    var x;
    var xNext;
    var isMajor, nextIsMajor;
    var width = 0,
        prevWidth;
    var line;
    var labelMinor;
    var xFirstMajorLabel = undefined;
    var count = 0;
    var MAX = 1000;
    var className;

    step.start();
    next = step.getCurrent();
    xNext = this.body.util.toScreen(next);
    while (step.hasNext() && count < MAX) {
      count++;

      isMajor = step.isMajor();
      className = step.getClassName();
      labelMinor = step.getLabelMinor();

      current = next;
      x = xNext;

      step.next();
      next = step.getCurrent();
      nextIsMajor = step.isMajor();
      xNext = this.body.util.toScreen(next);

      prevWidth = width;
      width = xNext - x;
      var showMinorGrid = width >= prevWidth * 0.4; // prevent displaying of the 31th of the month on a scale of 5 days

      if (this.options.showMinorLabels && showMinorGrid) {
        var label = this._repaintMinorText(x, labelMinor, orientation, className);
        label.style.width = width + 'px'; // set width to prevent overflow
      }

      if (isMajor && this.options.showMajorLabels) {
        if (x > 0) {
          if (xFirstMajorLabel == undefined) {
            xFirstMajorLabel = x;
          }
          label = this._repaintMajorText(x, step.getLabelMajor(), orientation, className);
        }
        line = this._repaintMajorLine(x, width, orientation, className);
      } else {
        // minor line
        if (showMinorGrid) {
          line = this._repaintMinorLine(x, width, orientation, className);
        } else {
          if (line) {
            // adjust the width of the previous grid
            line.style.width = parseInt(line.style.width) + width + 'px';
          }
        }
      }
    }

    if (count === MAX && !warnedForOverflow) {
      console.warn('Something is wrong with the Timeline scale. Limited drawing of grid lines to ' + MAX + ' lines.');
      warnedForOverflow = true;
    }

    // create a major label on the left when needed
    if (this.options.showMajorLabels) {
      var leftTime = this.body.util.toTime(0),
          leftText = step.getLabelMajor(leftTime),
          widthText = leftText.length * (this.props.majorCharWidth || 10) + 10; // upper bound estimation

      if (xFirstMajorLabel == undefined || widthText < xFirstMajorLabel) {
        this._repaintMajorText(0, leftText, orientation, className);
      }
    }

    // Cleanup leftover DOM elements from the redundant list
    util.forEach(this.dom.redundant, function (arr) {
      while (arr.length) {
        var elem = arr.pop();
        if (elem && elem.parentNode) {
          elem.parentNode.removeChild(elem);
        }
      }
    });
  };

  /**
   * Create a minor label for the axis at position x
   * @param {Number} x
   * @param {String} text
   * @param {String} orientation   "top" or "bottom" (default)
   * @param {String} className
   * @return {Element} Returns the HTML element of the created label
   * @private
   */
  TimeAxis.prototype._repaintMinorText = function (x, text, orientation, className) {
    // reuse redundant label
    var label = this.dom.redundant.minorTexts.shift();

    if (!label) {
      // create new label
      var content = document.createTextNode('');
      label = document.createElement('div');
      label.appendChild(content);
      this.dom.foreground.appendChild(label);
    }
    this.dom.minorTexts.push(label);
    label.innerHTML = text;

    label.style.top = orientation == 'top' ? this.props.majorLabelHeight + 'px' : '0';

    if (this.options.rtl) {
      label.style.left = "";
      label.style.right = x + 'px';
    } else {
      label.style.left = x + 'px';
    };
    label.className = 'vis-text vis-minor ' + className;
    //label.title = title;  // TODO: this is a heavy operation

    return label;
  };

  /**
   * Create a Major label for the axis at position x
   * @param {Number} x
   * @param {String} text
   * @param {String} orientation   "top" or "bottom" (default)
   * @param {String} className
   * @return {Element} Returns the HTML element of the created label
   * @private
   */
  TimeAxis.prototype._repaintMajorText = function (x, text, orientation, className) {
    // reuse redundant label
    var label = this.dom.redundant.majorTexts.shift();

    if (!label) {
      // create label
      var content = document.createElement('div');
      label = document.createElement('div');
      label.appendChild(content);
      this.dom.foreground.appendChild(label);
    }

    label.childNodes[0].innerHTML = text;
    label.className = 'vis-text vis-major ' + className;
    //label.title = title; // TODO: this is a heavy operation

    label.style.top = orientation == 'top' ? '0' : this.props.minorLabelHeight + 'px';
    if (this.options.rtl) {
      label.style.left = "";
      label.style.right = x + 'px';
    } else {
      label.style.left = x + 'px';
    };

    this.dom.majorTexts.push(label);
    return label;
  };

  /**
   * Create a minor line for the axis at position x
   * @param {Number} x
   * @param {Number} width
   * @param {String} orientation   "top" or "bottom" (default)
   * @param {String} className
   * @return {Element} Returns the created line
   * @private
   */
  TimeAxis.prototype._repaintMinorLine = function (x, width, orientation, className) {
    // reuse redundant line
    var line = this.dom.redundant.lines.shift();
    if (!line) {
      // create vertical line
      line = document.createElement('div');
      this.dom.background.appendChild(line);
    }
    this.dom.lines.push(line);

    var props = this.props;
    if (orientation == 'top') {
      line.style.top = props.majorLabelHeight + 'px';
    } else {
      line.style.top = this.body.domProps.top.height + 'px';
    }
    line.style.height = props.minorLineHeight + 'px';
    if (this.options.rtl) {
      line.style.left = "";
      line.style.right = x - props.minorLineWidth / 2 + 'px';
      line.className = 'vis-grid vis-vertical-rtl vis-minor ' + className;
    } else {
      line.style.left = x - props.minorLineWidth / 2 + 'px';
      line.className = 'vis-grid vis-vertical vis-minor ' + className;
    };
    line.style.width = width + 'px';

    return line;
  };

  /**
   * Create a Major line for the axis at position x
   * @param {Number} x
   * @param {Number} width
   * @param {String} orientation   "top" or "bottom" (default)
   * @param {String} className
   * @return {Element} Returns the created line
   * @private
   */
  TimeAxis.prototype._repaintMajorLine = function (x, width, orientation, className) {
    // reuse redundant line
    var line = this.dom.redundant.lines.shift();
    if (!line) {
      // create vertical line
      line = document.createElement('div');
      this.dom.background.appendChild(line);
    }
    this.dom.lines.push(line);

    var props = this.props;
    if (orientation == 'top') {
      line.style.top = '0';
    } else {
      line.style.top = this.body.domProps.top.height + 'px';
    }

    if (this.options.rtl) {
      line.style.left = "";
      line.style.right = x - props.majorLineWidth / 2 + 'px';
      line.className = 'vis-grid vis-vertical-rtl vis-major ' + className;
    } else {
      line.style.left = x - props.majorLineWidth / 2 + 'px';
      line.className = 'vis-grid vis-vertical vis-major ' + className;
    }

    line.style.height = props.majorLineHeight + 'px';
    line.style.width = width + 'px';

    return line;
  };

  /**
   * Determine the size of text on the axis (both major and minor axis).
   * The size is calculated only once and then cached in this.props.
   * @private
   */
  TimeAxis.prototype._calculateCharSize = function () {
    // Note: We calculate char size with every redraw. Size may change, for
    // example when any of the timelines parents had display:none for example.

    // determine the char width and height on the minor axis
    if (!this.dom.measureCharMinor) {
      this.dom.measureCharMinor = document.createElement('DIV');
      this.dom.measureCharMinor.className = 'vis-text vis-minor vis-measure';
      this.dom.measureCharMinor.style.position = 'absolute';

      this.dom.measureCharMinor.appendChild(document.createTextNode('0'));
      this.dom.foreground.appendChild(this.dom.measureCharMinor);
    }
    this.props.minorCharHeight = this.dom.measureCharMinor.clientHeight;
    this.props.minorCharWidth = this.dom.measureCharMinor.clientWidth;

    // determine the char width and height on the major axis
    if (!this.dom.measureCharMajor) {
      this.dom.measureCharMajor = document.createElement('DIV');
      this.dom.measureCharMajor.className = 'vis-text vis-major vis-measure';
      this.dom.measureCharMajor.style.position = 'absolute';

      this.dom.measureCharMajor.appendChild(document.createTextNode('0'));
      this.dom.foreground.appendChild(this.dom.measureCharMajor);
    }
    this.props.majorCharHeight = this.dom.measureCharMajor.clientHeight;
    this.props.majorCharWidth = this.dom.measureCharMajor.clientWidth;
  };

  var warnedForOverflow = false;

  module.exports = TimeAxis;

/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var keycharm = __webpack_require__(111);
  var Emitter = __webpack_require__(95);
  var Hammer = __webpack_require__(108);
  var util = __webpack_require__(1);

  /**
   * Turn an element into an clickToUse element.
   * When not active, the element has a transparent overlay. When the overlay is
   * clicked, the mode is changed to active.
   * When active, the element is displayed with a blue border around it, and
   * the interactive contents of the element can be used. When clicked outside
   * the element, the elements mode is changed to inactive.
   * @param {Element} container
   * @constructor
   */
  function Activator(container) {
    this.active = false;

    this.dom = {
      container: container
    };

    this.dom.overlay = document.createElement('div');
    this.dom.overlay.className = 'vis-overlay';

    this.dom.container.appendChild(this.dom.overlay);

    this.hammer = Hammer(this.dom.overlay);
    this.hammer.on('tap', this._onTapOverlay.bind(this));

    // block all touch events (except tap)
    var me = this;
    var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend'];
    events.forEach(function (event) {
      me.hammer.on(event, function (event) {
        event.stopPropagation();
      });
    });

    // attach a click event to the window, in order to deactivate when clicking outside the timeline
    if (document && document.body) {
      this.onClick = function (event) {
        if (!_hasParent(event.target, container)) {
          me.deactivate();
        }
      };
      document.body.addEventListener('click', this.onClick);
    }

    if (this.keycharm !== undefined) {
      this.keycharm.destroy();
    }
    this.keycharm = keycharm();

    // keycharm listener only bounded when active)
    this.escListener = this.deactivate.bind(this);
  }

  // turn into an event emitter
  Emitter(Activator.prototype);

  // The currently active activator
  Activator.current = null;

  /**
   * Destroy the activator. Cleans up all created DOM and event listeners
   */
  Activator.prototype.destroy = function () {
    this.deactivate();

    // remove dom
    this.dom.overlay.parentNode.removeChild(this.dom.overlay);

    // remove global event listener
    if (this.onClick) {
      document.body.removeEventListener('click', this.onClick);
    }

    // cleanup hammer instances
    this.hammer.destroy();
    this.hammer = null;
    // FIXME: cleaning up hammer instances doesn't work (Timeline not removed from memory)
  };

  /**
   * Activate the element
   * Overlay is hidden, element is decorated with a blue shadow border
   */
  Activator.prototype.activate = function () {
    // we allow only one active activator at a time
    if (Activator.current) {
      Activator.current.deactivate();
    }
    Activator.current = this;

    this.active = true;
    this.dom.overlay.style.display = 'none';
    util.addClassName(this.dom.container, 'vis-active');

    this.emit('change');
    this.emit('activate');

    // ugly hack: bind ESC after emitting the events, as the Network rebinds all
    // keyboard events on a 'change' event
    this.keycharm.bind('esc', this.escListener);
  };

  /**
   * Deactivate the element
   * Overlay is displayed on top of the element
   */
  Activator.prototype.deactivate = function () {
    this.active = false;
    this.dom.overlay.style.display = '';
    util.removeClassName(this.dom.container, 'vis-active');
    this.keycharm.unbind('esc', this.escListener);

    this.emit('change');
    this.emit('deactivate');
  };

  /**
   * Handle a tap event: activate the container
   * @param event
   * @private
   */
  Activator.prototype._onTapOverlay = function (event) {
    // activate the container
    this.activate();
    event.stopPropagation();
  };

  /**
   * Test whether the element has the requested parent element somewhere in
   * its chain of parent nodes.
   * @param {HTMLElement} element
   * @param {HTMLElement} parent
   * @returns {boolean} Returns true when the parent is found somewhere in the
   *                    chain of parent nodes.
   * @private
   */
  function _hasParent(element, parent) {
    while (element) {
      if (element === parent) {
        return true;
      }
      element = element.parentNode;
    }
    return false;
  }

  module.exports = Activator;

/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var Hammer = __webpack_require__(108);
  var util = __webpack_require__(1);
  var Component = __webpack_require__(124);
  var moment = __webpack_require__(84);
  var locales = __webpack_require__(141);

  /**
   * A custom time bar
   * @param {{range: Range, dom: Object}} body
   * @param {Object} [options]        Available parameters:
   *                                  {number | string} id
   *                                  {string} locales
   *                                  {string} locale
   * @constructor CustomTime
   * @extends Component
   */

  function CustomTime(body, options) {
    this.body = body;

    // default options
    this.defaultOptions = {
      moment: moment,
      locales: locales,
      locale: 'en',
      id: undefined,
      title: undefined
    };
    this.options = util.extend({}, this.defaultOptions);

    if (options && options.time) {
      this.customTime = options.time;
    } else {
      this.customTime = new Date();
    }

    this.eventParams = {}; // stores state parameters while dragging the bar

    this.setOptions(options);

    // create the DOM
    this._create();
  }

  CustomTime.prototype = new Component();

  /**
   * Set options for the component. Options will be merged in current options.
   * @param {Object} options  Available parameters:
   *                                  {number | string} id
   *                                  {string} locales
   *                                  {string} locale
   */
  CustomTime.prototype.setOptions = function (options) {
    if (options) {
      // copy all options that we know
      util.selectiveExtend(['moment', 'locale', 'locales', 'id'], this.options, options);
    }
  };

  /**
   * Create the DOM for the custom time
   * @private
   */
  CustomTime.prototype._create = function () {
    var bar = document.createElement('div');
    bar['custom-time'] = this;
    bar.className = 'vis-custom-time ' + (this.options.id || '');
    bar.style.position = 'absolute';
    bar.style.top = '0px';
    bar.style.height = '100%';
    this.bar = bar;

    var drag = document.createElement('div');
    drag.style.position = 'relative';
    drag.style.top = '0px';
    drag.style.left = '-10px';
    drag.style.height = '100%';
    drag.style.width = '20px';

    function onMouseWheel(e) {
      this.body.range._onMouseWheel(e);
    }

    if (drag.addEventListener) {
      // IE9, Chrome, Safari, Opera
      drag.addEventListener("mousewheel", onMouseWheel.bind(this), false);
      // Firefox
      drag.addEventListener("DOMMouseScroll", onMouseWheel.bind(this), false);
    } else {
      // IE 6/7/8
      drag.attachEvent("onmousewheel", onMouseWheel.bind(this));
    }

    bar.appendChild(drag);
    // attach event listeners
    this.hammer = new Hammer(drag);
    this.hammer.on('panstart', this._onDragStart.bind(this));
    this.hammer.on('panmove', this._onDrag.bind(this));
    this.hammer.on('panend', this._onDragEnd.bind(this));
    this.hammer.get('pan').set({ threshold: 5, direction: Hammer.DIRECTION_HORIZONTAL });
  };

  /**
   * Destroy the CustomTime bar
   */
  CustomTime.prototype.destroy = function () {
    this.hide();

    this.hammer.destroy();
    this.hammer = null;

    this.body = null;
  };

  /**
   * Repaint the component
   * @return {boolean} Returns true if the component is resized
   */
  CustomTime.prototype.redraw = function () {
    var parent = this.body.dom.backgroundVertical;
    if (this.bar.parentNode != parent) {
      // attach to the dom
      if (this.bar.parentNode) {
        this.bar.parentNode.removeChild(this.bar);
      }
      parent.appendChild(this.bar);
    }

    var x = this.body.util.toScreen(this.customTime);

    var locale = this.options.locales[this.options.locale];
    if (!locale) {
      if (!this.warned) {
        console.log('WARNING: options.locales[\'' + this.options.locale + '\'] not found. See http://visjs.org/docs/timeline/#Localization');
        this.warned = true;
      }
      locale = this.options.locales['en']; // fall back on english when not available
    }

    var title = this.options.title;
    // To hide the title completely use empty string ''.
    if (title === undefined) {
      title = locale.time + ': ' + this.options.moment(this.customTime).format('dddd, MMMM Do YYYY, H:mm:ss');
      title = title.charAt(0).toUpperCase() + title.substring(1);
    }

    this.bar.style.left = x + 'px';
    this.bar.title = title;

    return false;
  };

  /**
   * Remove the CustomTime from the DOM
   */
  CustomTime.prototype.hide = function () {
    // remove the line from the DOM
    if (this.bar.parentNode) {
      this.bar.parentNode.removeChild(this.bar);
    }
  };

  /**
   * Set custom time.
   * @param {Date | number | string} time
   */
  CustomTime.prototype.setCustomTime = function (time) {
    this.customTime = util.convert(time, 'Date');
    this.redraw();
  };

  /**
   * Retrieve the current custom time.
   * @return {Date} customTime
   */
  CustomTime.prototype.getCustomTime = function () {
    return new Date(this.customTime.valueOf());
  };

  /**
    * Set custom title.
    * @param {Date | number | string} title
    */
  CustomTime.prototype.setCustomTitle = function (title) {
    this.options.title = title;
  };

  /**
   * Start moving horizontally
   * @param {Event} event
   * @private
   */
  CustomTime.prototype._onDragStart = function (event) {
    this.eventParams.dragging = true;
    this.eventParams.customTime = this.customTime;

    event.stopPropagation();
  };

  /**
   * Perform moving operating.
   * @param {Event} event
   * @private
   */
  CustomTime.prototype._onDrag = function (event) {
    if (!this.eventParams.dragging) return;

    var x = this.body.util.toScreen(this.eventParams.customTime) + event.deltaX;
    var time = this.body.util.toTime(x);

    this.setCustomTime(time);

    // fire a timechange event
    this.body.emitter.emit('timechange', {
      id: this.options.id,
      time: new Date(this.customTime.valueOf()),
      event: util.elementsCensor(event)
    });

    event.stopPropagation();
  };

  /**
   * Stop moving operating.
   * @param {Event} event
   * @private
   */
  CustomTime.prototype._onDragEnd = function (event) {
    if (!this.eventParams.dragging) return;

    // fire a timechanged event
    this.body.emitter.emit('timechanged', {
      id: this.options.id,
      time: new Date(this.customTime.valueOf()),
      event: util.elementsCensor(event)
    });

    event.stopPropagation();
  };

  /**
   * Find a custom time from an event target:
   * searches for the attribute 'custom-time' in the event target's element tree
   * @param {Event} event
   * @return {CustomTime | null} customTime
   */
  CustomTime.customTimeFromTarget = function (event) {
    var target = event.target;
    while (target) {
      if (target.hasOwnProperty('custom-time')) {
        return target['custom-time'];
      }
      target = target.parentNode;
    }

    return null;
  };

  module.exports = CustomTime;

/***/ },
/* 141 */
/***/ function(module, exports) {

  'use strict';

  // English
  exports['en'] = {
    current: 'current',
    time: 'time'
  };
  exports['en_EN'] = exports['en'];
  exports['en_US'] = exports['en'];

  // Italiano
  exports['it'] = {
    current: 'attuale',
    time: 'tempo'
  };
  exports['it_IT'] = exports['it'];
  exports['it_CH'] = exports['it'];

  // Dutch
  exports['nl'] = {
    current: 'huidige',
    time: 'tijd'
  };
  exports['nl_NL'] = exports['nl'];
  exports['nl_BE'] = exports['nl'];

  // German
  exports['de'] = {
    current: 'Aktuelle',
    time: 'Zeit'
  };
  exports['de_DE'] = exports['de'];

/***/ },
/* 142 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var util = __webpack_require__(1);
  var Component = __webpack_require__(124);
  var moment = __webpack_require__(84);
  var locales = __webpack_require__(141);

  /**
   * A current time bar
   * @param {{range: Range, dom: Object, domProps: Object}} body
   * @param {Object} [options]        Available parameters:
   *                                  {Boolean} [showCurrentTime]
   * @constructor CurrentTime
   * @extends Component
   */
  function CurrentTime(body, options) {
    this.body = body;

    // default options
    this.defaultOptions = {
      rtl: false,
      showCurrentTime: true,

      moment: moment,
      locales: locales,
      locale: 'en'
    };
    this.options = util.extend({}, this.defaultOptions);
    this.offset = 0;

    this._create();

    this.setOptions(options);
  }

  CurrentTime.prototype = new Component();

  /**
   * Create the HTML DOM for the current time bar
   * @private
   */
  CurrentTime.prototype._create = function () {
    var bar = document.createElement('div');
    bar.className = 'vis-current-time';
    bar.style.position = 'absolute';
    bar.style.top = '0px';
    bar.style.height = '100%';

    this.bar = bar;
  };

  /**
   * Destroy the CurrentTime bar
   */
  CurrentTime.prototype.destroy = function () {
    this.options.showCurrentTime = false;
    this.redraw(); // will remove the bar from the DOM and stop refreshing

    this.body = null;
  };

  /**
   * Set options for the component. Options will be merged in current options.
   * @param {Object} options  Available parameters:
   *                          {boolean} [showCurrentTime]
   */
  CurrentTime.prototype.setOptions = function (options) {
    if (options) {
      // copy all options that we know
      util.selectiveExtend(['rtl', 'showCurrentTime', 'moment', 'locale', 'locales'], this.options, options);
    }
  };

  /**
   * Repaint the component
   * @return {boolean} Returns true if the component is resized
   */
  CurrentTime.prototype.redraw = function () {
    if (this.options.showCurrentTime) {
      var parent = this.body.dom.backgroundVertical;
      if (this.bar.parentNode != parent) {
        // attach to the dom
        if (this.bar.parentNode) {
          this.bar.parentNode.removeChild(this.bar);
        }
        parent.appendChild(this.bar);

        this.start();
      }

      var now = this.options.moment(new Date().valueOf() + this.offset);
      var x = this.body.util.toScreen(now);

      var locale = this.options.locales[this.options.locale];
      if (!locale) {
        if (!this.warned) {
          console.log('WARNING: options.locales[\'' + this.options.locale + '\'] not found. See http://visjs.org/docs/timeline/#Localization');
          this.warned = true;
        }
        locale = this.options.locales['en']; // fall back on english when not available
      }
      var title = locale.current + ' ' + locale.time + ': ' + now.format('dddd, MMMM Do YYYY, H:mm:ss');
      title = title.charAt(0).toUpperCase() + title.substring(1);

      if (this.options.rtl) {
        this.bar.style.right = x + 'px';
      } else {
        this.bar.style.left = x + 'px';
      }
      this.bar.title = title;
    } else {
      // remove the line from the DOM
      if (this.bar.parentNode) {
        this.bar.parentNode.removeChild(this.bar);
      }
      this.stop();
    }

    return false;
  };

  /**
   * Start auto refreshing the current time bar
   */
  CurrentTime.prototype.start = function () {
    var me = this;

    function update() {
      me.stop();

      // determine interval to refresh
      var scale = me.body.range.conversion(me.body.domProps.center.width).scale;
      var interval = 1 / scale / 10;
      if (interval < 30) interval = 30;
      if (interval > 1000) interval = 1000;

      me.redraw();
      me.body.emitter.emit('currentTimeTick');

      // start a renderTimer to adjust for the new time
      me.currentTimeTimer = setTimeout(update, interval);
    }

    update();
  };

  /**
   * Stop auto refreshing the current time bar
   */
  CurrentTime.prototype.stop = function () {
    if (this.currentTimeTimer !== undefined) {
      clearTimeout(this.currentTimeTimer);
      delete this.currentTimeTimer;
    }
  };

  /**
   * Set a current time. This can be used for example to ensure that a client's
   * time is synchronized with a shared server time.
   * @param {Date | String | Number} time     A Date, unix timestamp, or
   *                                          ISO date string.
   */
  CurrentTime.prototype.setCurrentTime = function (time) {
    var t = util.convert(time, 'Date').valueOf();
    var now = new Date().valueOf();
    this.offset = t - now;
    this.redraw();
  };

  /**
   * Get the current time.
   * @return {Date} Returns the current time.
   */
  CurrentTime.prototype.getCurrentTime = function () {
    return new Date(new Date().valueOf() + this.offset);
  };

  module.exports = CurrentTime;

/***/ },
/* 143 */
/***/ function(module, exports) {

  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  /**
   * This object contains all possible options. It will check if the types are correct, if required if the option is one
   * of the allowed values.
   *
   * __any__ means that the name of the property does not matter.
   * __type__ is a required field for all objects and contains the allowed types of all objects
   */
  var string = 'string';
  var bool = 'boolean';
  var number = 'number';
  var array = 'array';
  var date = 'date';
  var object = 'object'; // should only be in a __type__ property
  var dom = 'dom';
  var moment = 'moment';
  var any = 'any';

  var allOptions = {
    configure: {
      enabled: { 'boolean': bool },
      filter: { 'boolean': bool, 'function': 'function' },
      container: { dom: dom },
      __type__: { object: object, 'boolean': bool, 'function': 'function' }
    },

    //globals :
    align: { string: string },
    rtl: { 'boolean': bool, 'undefined': 'undefined' },
    rollingMode: { 'boolean': bool, 'undefined': 'undefined' },
    verticalScroll: { 'boolean': bool, 'undefined': 'undefined' },
    horizontalScroll: { 'boolean': bool, 'undefined': 'undefined' },
    autoResize: { 'boolean': bool },
    throttleRedraw: { number: number }, // TODO: DEPRICATED see https://github.com/almende/vis/issues/2511
    clickToUse: { 'boolean': bool },
    dataAttributes: { string: string, array: array },
    editable: {
      add: { 'boolean': bool, 'undefined': 'undefined' },
      remove: { 'boolean': bool, 'undefined': 'undefined' },
      updateGroup: { 'boolean': bool, 'undefined': 'undefined' },
      updateTime: { 'boolean': bool, 'undefined': 'undefined' },
      overrideItems: { 'boolean': bool, 'undefined': 'undefined' },
      __type__: { 'boolean': bool, object: object }
    },
    end: { number: number, date: date, string: string, moment: moment },
    format: {
      minorLabels: {
        millisecond: { string: string, 'undefined': 'undefined' },
        second: { string: string, 'undefined': 'undefined' },
        minute: { string: string, 'undefined': 'undefined' },
        hour: { string: string, 'undefined': 'undefined' },
        weekday: { string: string, 'undefined': 'undefined' },
        day: { string: string, 'undefined': 'undefined' },
        month: { string: string, 'undefined': 'undefined' },
        year: { string: string, 'undefined': 'undefined' },
        __type__: { object: object, 'function': 'function' }
      },
      majorLabels: {
        millisecond: { string: string, 'undefined': 'undefined' },
        second: { string: string, 'undefined': 'undefined' },
        minute: { string: string, 'undefined': 'undefined' },
        hour: { string: string, 'undefined': 'undefined' },
        weekday: { string: string, 'undefined': 'undefined' },
        day: { string: string, 'undefined': 'undefined' },
        month: { string: string, 'undefined': 'undefined' },
        year: { string: string, 'undefined': 'undefined' },
        __type__: { object: object, 'function': 'function' }
      },
      __type__: { object: object }
    },
    moment: { 'function': 'function' },
    groupOrder: { string: string, 'function': 'function' },
    groupEditable: {
      add: { 'boolean': bool, 'undefined': 'undefined' },
      remove: { 'boolean': bool, 'undefined': 'undefined' },
      order: { 'boolean': bool, 'undefined': 'undefined' },
      __type__: { 'boolean': bool, object: object }
    },
    groupOrderSwap: { 'function': 'function' },
    height: { string: string, number: number },
    hiddenDates: {
      start: { date: date, number: number, string: string, moment: moment },
      end: { date: date, number: number, string: string, moment: moment },
      repeat: { string: string },
      __type__: { object: object, array: array }
    },
    itemsAlwaysDraggable: { 'boolean': bool },
    locale: { string: string },
    locales: {
      __any__: { any: any },
      __type__: { object: object }
    },
    margin: {
      axis: { number: number },
      item: {
        horizontal: { number: number, 'undefined': 'undefined' },
        vertical: { number: number, 'undefined': 'undefined' },
        __type__: { object: object, number: number }
      },
      __type__: { object: object, number: number }
    },
    max: { date: date, number: number, string: string, moment: moment },
    maxHeight: { number: number, string: string },
    maxMinorChars: { number: number },
    min: { date: date, number: number, string: string, moment: moment },
    minHeight: { number: number, string: string },
    moveable: { 'boolean': bool },
    multiselect: { 'boolean': bool },
    multiselectPerGroup: { 'boolean': bool },
    onAdd: { 'function': 'function' },
    onUpdate: { 'function': 'function' },
    onMove: { 'function': 'function' },
    onMoving: { 'function': 'function' },
    onRemove: { 'function': 'function' },
    onAddGroup: { 'function': 'function' },
    onMoveGroup: { 'function': 'function' },
    onRemoveGroup: { 'function': 'function' },
    order: { 'function': 'function' },
    orientation: {
      axis: { string: string, 'undefined': 'undefined' },
      item: { string: string, 'undefined': 'undefined' },
      __type__: { string: string, object: object }
    },
    selectable: { 'boolean': bool },
    showCurrentTime: { 'boolean': bool },
    showMajorLabels: { 'boolean': bool },
    showMinorLabels: { 'boolean': bool },
    stack: { 'boolean': bool },
    stackSubgroups: { 'boolean': bool },
    snap: { 'function': 'function', 'null': 'null' },
    start: { date: date, number: number, string: string, moment: moment },
    template: { 'function': 'function' },
    groupTemplate: { 'function': 'function' },
    visibleFrameTemplate: { string: string, 'function': 'function' },
    tooltip: {
      followMouse: { 'boolean': bool },
      overflowMethod: { 'string': ['cap', 'flip'] },
      __type__: { object: object }
    },
    tooltipOnItemUpdateTime: {
      template: { 'function': 'function' },
      __type__: { 'boolean': bool, object: object }
    },
    timeAxis: {
      scale: { string: string, 'undefined': 'undefined' },
      step: { number: number, 'undefined': 'undefined' },
      __type__: { object: object }
    },
    type: { string: string },
    width: { string: string, number: number },
    zoomable: { 'boolean': bool },
    zoomKey: { string: ['ctrlKey', 'altKey', 'metaKey', ''] },
    zoomMax: { number: number },
    zoomMin: { number: number },

    __type__: { object: object }
  };

  var configureOptions = {
    global: {
      align: ['center', 'left', 'right'],
      direction: false,
      autoResize: true,
      clickToUse: false,
      // dataAttributes: ['all'], // FIXME: can be 'all' or string[]
      editable: {
        add: false,
        remove: false,
        updateGroup: false,
        updateTime: false
      },
      end: '',
      format: {
        minorLabels: {
          millisecond: 'SSS',
          second: 's',
          minute: 'HH:mm',
          hour: 'HH:mm',
          weekday: 'ddd D',
          day: 'D',
          month: 'MMM',
          year: 'YYYY'
        },
        majorLabels: {
          millisecond: 'HH:mm:ss',
          second: 'D MMMM HH:mm',
          minute: 'ddd D MMMM',
          hour: 'ddd D MMMM',
          weekday: 'MMMM YYYY',
          day: 'MMMM YYYY',
          month: 'YYYY',
          year: ''
        }
      },

      //groupOrder: {string, 'function': 'function'},
      groupsDraggable: false,
      height: '',
      //hiddenDates: {object, array},
      locale: '',
      margin: {
        axis: [20, 0, 100, 1],
        item: {
          horizontal: [10, 0, 100, 1],
          vertical: [10, 0, 100, 1]
        }
      },
      max: '',
      maxHeight: '',
      maxMinorChars: [7, 0, 20, 1],
      min: '',
      minHeight: '',
      moveable: false,
      multiselect: false,
      multiselectPerGroup: false,
      //onAdd: {'function': 'function'},
      //onUpdate: {'function': 'function'},
      //onMove: {'function': 'function'},
      //onMoving: {'function': 'function'},
      //onRename: {'function': 'function'},
      //order: {'function': 'function'},
      orientation: {
        axis: ['both', 'bottom', 'top'],
        item: ['bottom', 'top']
      },
      selectable: true,
      showCurrentTime: false,
      showMajorLabels: true,
      showMinorLabels: true,
      stack: true,
      stackSubgroups: true,
      //snap: {'function': 'function', nada},
      start: '',
      //template: {'function': 'function'},
      //timeAxis: {
      //  scale: ['millisecond', 'second', 'minute', 'hour', 'weekday', 'day', 'month', 'year'],
      //  step: [1, 1, 10, 1]
      //},
      tooltip: {
        followMouse: false,
        overflowMethod: 'flip'
      },
      tooltipOnItemUpdateTime: false,
      type: ['box', 'point', 'range', 'background'],
      width: '100%',
      zoomable: true,
      zoomKey: ['ctrlKey', 'altKey', 'metaKey', ''],
      zoomMax: [315360000000000, 10, 315360000000000, 1],
      zoomMin: [10, 10, 315360000000000, 1]
    }
  };

  exports.allOptions = allOptions;
  exports.configureOptions = configureOptions;

/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _Configurator = __webpack_require__(114);

  var _Configurator2 = _interopRequireDefault(_Configurator);

  var _Validator = __webpack_require__(122);

  var _Validator2 = _interopRequireDefault(_Validator);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var Emitter = __webpack_require__(95);
  var Hammer = __webpack_require__(108);
  var moment = __webpack_require__(84);
  var util = __webpack_require__(1);
  var DataSet = __webpack_require__(91);
  var DataView = __webpack_require__(93);
  var Range = __webpack_require__(123);
  var Core = __webpack_require__(126);
  var TimeAxis = __webpack_require__(138);
  var CurrentTime = __webpack_require__(142);
  var CustomTime = __webpack_require__(140);
  var LineGraph = __webpack_require__(145);

  var printStyle = __webpack_require__(122).printStyle;
  var allOptions = __webpack_require__(153).allOptions;
  var configureOptions = __webpack_require__(153).configureOptions;

  /**
   * Create a timeline visualization
   * @param {HTMLElement} container
   * @param {vis.DataSet | Array} [items]
   * @param {Object} [options]  See Graph2d.setOptions for the available options.
   * @constructor
   * @extends Core
   */
  function Graph2d(container, items, groups, options) {
    // if the third element is options, the forth is groups (optionally);
    if (!(Array.isArray(groups) || groups instanceof DataSet || groups instanceof DataView) && groups instanceof Object) {
      var forthArgument = options;
      options = groups;
      groups = forthArgument;
    }

    // TODO: REMOVE THIS in the next MAJOR release
    // see https://github.com/almende/vis/issues/2511
    if (options && options.throttleRedraw) {
      console.warn("Graph2d option \"throttleRedraw\" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.");
    }

    var me = this;
    this.defaultOptions = {
      start: null,
      end: null,

      autoResize: true,

      orientation: {
        axis: 'bottom', // axis orientation: 'bottom', 'top', or 'both'
        item: 'bottom' // not relevant for Graph2d
      },

      moment: moment,

      width: null,
      height: null,
      maxHeight: null,
      minHeight: null
    };
    this.options = util.deepExtend({}, this.defaultOptions);

    // Create the DOM, props, and emitter
    this._create(container);

    // all components listed here will be repainted automatically
    this.components = [];

    this.body = {
      dom: this.dom,
      domProps: this.props,
      emitter: {
        on: this.on.bind(this),
        off: this.off.bind(this),
        emit: this.emit.bind(this)
      },
      hiddenDates: [],
      util: {
        toScreen: me._toScreen.bind(me),
        toGlobalScreen: me._toGlobalScreen.bind(me), // this refers to the root.width
        toTime: me._toTime.bind(me),
        toGlobalTime: me._toGlobalTime.bind(me)
      }
    };

    // range
    this.range = new Range(this.body);
    this.components.push(this.range);
    this.body.range = this.range;

    // time axis
    this.timeAxis = new TimeAxis(this.body);
    this.components.push(this.timeAxis);
    //this.body.util.snap = this.timeAxis.snap.bind(this.timeAxis);

    // current time bar
    this.currentTime = new CurrentTime(this.body);
    this.components.push(this.currentTime);

    // item set
    this.linegraph = new LineGraph(this.body);

    this.components.push(this.linegraph);

    this.itemsData = null; // DataSet
    this.groupsData = null; // DataSet


    this.on('tap', function (event) {
      me.emit('click', me.getEventProperties(event));
    });
    this.on('doubletap', function (event) {
      me.emit('doubleClick', me.getEventProperties(event));
    });
    this.dom.root.oncontextmenu = function (event) {
      me.emit('contextmenu', me.getEventProperties(event));
    };

    // apply options
    if (options) {
      this.setOptions(options);
    }

    // IMPORTANT: THIS HAPPENS BEFORE SET ITEMS!
    if (groups) {
      this.setGroups(groups);
    }

    // create itemset
    if (items) {
      this.setItems(items);
    }

    // draw for the first time
    this._redraw();
  }

  // Extend the functionality from Core
  Graph2d.prototype = new Core();

  Graph2d.prototype.setOptions = function (options) {
    // validate options
    var errorFound = _Validator2['default'].validate(options, allOptions);
    if (errorFound === true) {
      console.log('%cErrors have been found in the supplied options object.', printStyle);
    }

    Core.prototype.setOptions.call(this, options);
  };

  /**
   * Set items
   * @param {vis.DataSet | Array | null} items
   */
  Graph2d.prototype.setItems = function (items) {
    var initialLoad = this.itemsData == null;

    // convert to type DataSet when needed
    var newDataSet;
    if (!items) {
      newDataSet = null;
    } else if (items instanceof DataSet || items instanceof DataView) {
      newDataSet = items;
    } else {
      // turn an array into a dataset
      newDataSet = new DataSet(items, {
        type: {
          start: 'Date',
          end: 'Date'
        }
      });
    }

    // set items
    this.itemsData = newDataSet;
    this.linegraph && this.linegraph.setItems(newDataSet);

    if (initialLoad) {
      if (this.options.start != undefined || this.options.end != undefined) {
        var start = this.options.start != undefined ? this.options.start : null;
        var end = this.options.end != undefined ? this.options.end : null;
        this.setWindow(start, end, { animation: false });
      } else {
        this.fit({ animation: false });
      }
    }
  };

  /**
   * Set groups
   * @param {vis.DataSet | Array} groups
   */
  Graph2d.prototype.setGroups = function (groups) {
    // convert to type DataSet when needed
    var newDataSet;
    if (!groups) {
      newDataSet = null;
    } else if (groups instanceof DataSet || groups instanceof DataView) {
      newDataSet = groups;
    } else {
      // turn an array into a dataset
      newDataSet = new DataSet(groups);
    }

    this.groupsData = newDataSet;
    this.linegraph.setGroups(newDataSet);
  };

  /**
   * Returns an object containing an SVG element with the icon of the group (size determined by iconWidth and iconHeight), the label of the group (content) and the yAxisOrientation of the group (left or right).
   * @param groupId
   * @param width
   * @param height
   */
  Graph2d.prototype.getLegend = function (groupId, width, height) {
    if (width === undefined) {
      width = 15;
    }
    if (height === undefined) {
      height = 15;
    }
    if (this.linegraph.groups[groupId] !== undefined) {
      return this.linegraph.groups[groupId].getLegend(width, height);
    } else {
      return "cannot find group:'" + groupId + "'";
    }
  };

  /**
   * This checks if the visible option of the supplied group (by ID) is true or false.
   * @param groupId
   * @returns {*}
   */
  Graph2d.prototype.isGroupVisible = function (groupId) {
    if (this.linegraph.groups[groupId] !== undefined) {
      return this.linegraph.groups[groupId].visible && (this.linegraph.options.groups.visibility[groupId] === undefined || this.linegraph.options.groups.visibility[groupId] == true);
    } else {
      return false;
    }
  };

  /**
   * Get the data range of the item set.
   * @returns {{min: Date, max: Date}} range  A range with a start and end Date.
   *                                          When no minimum is found, min==null
   *                                          When no maximum is found, max==null
   */
  Graph2d.prototype.getDataRange = function () {
    var min = null;
    var max = null;

    // calculate min from start filed
    for (var groupId in this.linegraph.groups) {
      if (this.linegraph.groups.hasOwnProperty(groupId)) {
        if (this.linegraph.groups[groupId].visible == true) {
          for (var i = 0; i < this.linegraph.groups[groupId].itemsData.length; i++) {
            var item = this.linegraph.groups[groupId].itemsData[i];
            var value = util.convert(item.x, 'Date').valueOf();
            min = min == null ? value : min > value ? value : min;
            max = max == null ? value : max < value ? value : max;
          }
        }
      }
    }

    return {
      min: min != null ? new Date(min) : null,
      max: max != null ? new Date(max) : null
    };
  };

  /**
   * Generate Timeline related information from an event
   * @param {Event} event
   * @return {Object} An object with related information, like on which area
   *                  The event happened, whether clicked on an item, etc.
   */
  Graph2d.prototype.getEventProperties = function (event) {
    var clientX = event.center ? event.center.x : event.clientX;
    var clientY = event.center ? event.center.y : event.clientY;
    var x = clientX - util.getAbsoluteLeft(this.dom.centerContainer);
    var y = clientY - util.getAbsoluteTop(this.dom.centerContainer);
    var time = this._toTime(x);

    var customTime = CustomTime.customTimeFromTarget(event);

    var element = util.getTarget(event);
    var what = null;
    if (util.hasParent(element, this.timeAxis.dom.foreground)) {
      what = 'axis';
    } else if (this.timeAxis2 && util.hasParent(element, this.timeAxis2.dom.foreground)) {
      what = 'axis';
    } else if (util.hasParent(element, this.linegraph.yAxisLeft.dom.frame)) {
      what = 'data-axis';
    } else if (util.hasParent(element, this.linegraph.yAxisRight.dom.frame)) {
      what = 'data-axis';
    } else if (util.hasParent(element, this.linegraph.legendLeft.dom.frame)) {
      what = 'legend';
    } else if (util.hasParent(element, this.linegraph.legendRight.dom.frame)) {
      what = 'legend';
    } else if (customTime != null) {
      what = 'custom-time';
    } else if (util.hasParent(element, this.currentTime.bar)) {
      what = 'current-time';
    } else if (util.hasParent(element, this.dom.center)) {
      what = 'background';
    }

    var value = [];
    var yAxisLeft = this.linegraph.yAxisLeft;
    var yAxisRight = this.linegraph.yAxisRight;
    if (!yAxisLeft.hidden && this.itemsData.length > 0) {
      value.push(yAxisLeft.screenToValue(y));
    }
    if (!yAxisRight.hidden && this.itemsData.length > 0) {
      value.push(yAxisRight.screenToValue(y));
    }

    return {
      event: event,
      what: what,
      pageX: event.srcEvent ? event.srcEvent.pageX : event.pageX,
      pageY: event.srcEvent ? event.srcEvent.pageY : event.pageY,
      x: x,
      y: y,
      time: time,
      value: value
    };
  };

  /**
   * Load a configurator
   * @return {Object}
   * @private
   */
  Graph2d.prototype._createConfigurator = function () {
    return new _Configurator2['default'](this, this.dom.container, configureOptions);
  };

  module.exports = Graph2d;

/***/ },
/* 145 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var DOMutil = __webpack_require__(90);
  var DataSet = __webpack_require__(91);
  var DataView = __webpack_require__(93);
  var Component = __webpack_require__(124);
  var DataAxis = __webpack_require__(146);
  var GraphGroup = __webpack_require__(148);
  var Legend = __webpack_require__(152);
  var Bars = __webpack_require__(149);
  var Lines = __webpack_require__(151);
  var Points = __webpack_require__(150);

  var UNGROUPED = '__ungrouped__'; // reserved group id for ungrouped items

  /**
   * This is the constructor of the LineGraph. It requires a Timeline body and options.
   *
   * @param body
   * @param options
   * @constructor
   */
  function LineGraph(body, options) {
    this.id = util.randomUUID();
    this.body = body;

    this.defaultOptions = {
      yAxisOrientation: 'left',
      defaultGroup: 'default',
      sort: true,
      sampling: true,
      stack: false,
      graphHeight: '400px',
      shaded: {
        enabled: false,
        orientation: 'bottom' // top, bottom, zero
      },
      style: 'line', // line, bar
      barChart: {
        width: 50,
        sideBySide: false,
        align: 'center' // left, center, right
      },
      interpolation: {
        enabled: true,
        parametrization: 'centripetal', // uniform (alpha = 0.0), chordal (alpha = 1.0), centripetal (alpha = 0.5)
        alpha: 0.5
      },
      drawPoints: {
        enabled: true,
        size: 6,
        style: 'square' // square, circle
      },
      dataAxis: {}, //Defaults are done on DataAxis level
      legend: {}, //Defaults are done on Legend level
      groups: {
        visibility: {}
      }
    };

    // options is shared by this lineGraph and all its items
    this.options = util.extend({}, this.defaultOptions);
    this.dom = {};
    this.props = {};
    this.hammer = null;
    this.groups = {};
    this.abortedGraphUpdate = false;
    this.updateSVGheight = false;
    this.updateSVGheightOnResize = false;
    this.forceGraphUpdate = true;

    var me = this;
    this.itemsData = null; // DataSet
    this.groupsData = null; // DataSet

    // listeners for the DataSet of the items
    this.itemListeners = {
      'add': function add(event, params, senderId) {
        me._onAdd(params.items);
      },
      'update': function update(event, params, senderId) {
        me._onUpdate(params.items);
      },
      'remove': function remove(event, params, senderId) {
        me._onRemove(params.items);
      }
    };

    // listeners for the DataSet of the groups
    this.groupListeners = {
      'add': function add(event, params, senderId) {
        me._onAddGroups(params.items);
      },
      'update': function update(event, params, senderId) {
        me._onUpdateGroups(params.items);
      },
      'remove': function remove(event, params, senderId) {
        me._onRemoveGroups(params.items);
      }
    };

    this.items = {}; // object with an Item for every data item
    this.selection = []; // list with the ids of all selected nodes
    this.lastStart = this.body.range.start;
    this.touchParams = {}; // stores properties while dragging

    this.svgElements = {};
    this.setOptions(options);
    this.groupsUsingDefaultStyles = [0];
    this.body.emitter.on('rangechanged', function () {
      me.lastStart = me.body.range.start;
      me.svg.style.left = util.option.asSize(-me.props.width);

      me.forceGraphUpdate = true;
      //Is this local redraw necessary? (Core also does a change event!)
      me.redraw.call(me);
    });

    // create the HTML DOM
    this._create();
    this.framework = { svg: this.svg, svgElements: this.svgElements, options: this.options, groups: this.groups };
  }

  LineGraph.prototype = new Component();

  /**
   * Create the HTML DOM for the ItemSet
   */
  LineGraph.prototype._create = function () {
    var frame = document.createElement('div');
    frame.className = 'vis-line-graph';
    this.dom.frame = frame;

    // create svg element for graph drawing.
    this.svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    this.svg.style.position = 'relative';
    this.svg.style.height = ('' + this.options.graphHeight).replace('px', '') + 'px';
    this.svg.style.display = 'block';
    frame.appendChild(this.svg);

    // data axis
    this.options.dataAxis.orientation = 'left';
    this.yAxisLeft = new DataAxis(this.body, this.options.dataAxis, this.svg, this.options.groups);

    this.options.dataAxis.orientation = 'right';
    this.yAxisRight = new DataAxis(this.body, this.options.dataAxis, this.svg, this.options.groups);
    delete this.options.dataAxis.orientation;

    // legends
    this.legendLeft = new Legend(this.body, this.options.legend, 'left', this.options.groups);
    this.legendRight = new Legend(this.body, this.options.legend, 'right', this.options.groups);

    this.show();
  };

  /**
   * set the options of the LineGraph. the mergeOptions is used for subObjects that have an enabled element.
   * @param {object} options
   */
  LineGraph.prototype.setOptions = function (options) {
    if (options) {
      var fields = ['sampling', 'defaultGroup', 'stack', 'height', 'graphHeight', 'yAxisOrientation', 'style', 'barChart', 'dataAxis', 'sort', 'groups'];
      if (options.graphHeight === undefined && options.height !== undefined) {
        this.updateSVGheight = true;
        this.updateSVGheightOnResize = true;
      } else if (this.body.domProps.centerContainer.height !== undefined && options.graphHeight !== undefined) {
        if (parseInt((options.graphHeight + '').replace("px", '')) < this.body.domProps.centerContainer.height) {
          this.updateSVGheight = true;
        }
      }
      util.selectiveDeepExtend(fields, this.options, options);
      util.mergeOptions(this.options, options, 'interpolation');
      util.mergeOptions(this.options, options, 'drawPoints');
      util.mergeOptions(this.options, options, 'shaded');
      util.mergeOptions(this.options, options, 'legend');

      if (options.interpolation) {
        if ((0, _typeof3['default'])(options.interpolation) == 'object') {
          if (options.interpolation.parametrization) {
            if (options.interpolation.parametrization == 'uniform') {
              this.options.interpolation.alpha = 0;
            } else if (options.interpolation.parametrization == 'chordal') {
              this.options.interpolation.alpha = 1.0;
            } else {
              this.options.interpolation.parametrization = 'centripetal';
              this.options.interpolation.alpha = 0.5;
            }
          }
        }
      }

      if (this.yAxisLeft) {
        if (options.dataAxis !== undefined) {
          this.yAxisLeft.setOptions(this.options.dataAxis);
          this.yAxisRight.setOptions(this.options.dataAxis);
        }
      }

      if (this.legendLeft) {
        if (options.legend !== undefined) {
          this.legendLeft.setOptions(this.options.legend);
          this.legendRight.setOptions(this.options.legend);
        }
      }

      if (this.groups.hasOwnProperty(UNGROUPED)) {
        this.groups[UNGROUPED].setOptions(options);
      }
    }

    // this is used to redraw the graph if the visibility of the groups is changed.
    if (this.dom.frame) {
      //not on initial run?
      this.forceGraphUpdate = true;
      this.body.emitter.emit("_change", { queue: true });
    }
  };

  /**
   * Hide the component from the DOM
   */
  LineGraph.prototype.hide = function () {
    // remove the frame containing the items
    if (this.dom.frame.parentNode) {
      this.dom.frame.parentNode.removeChild(this.dom.frame);
    }
  };

  /**
   * Show the component in the DOM (when not already visible).
   * @return {Boolean} changed
   */
  LineGraph.prototype.show = function () {
    // show frame containing the items
    if (!this.dom.frame.parentNode) {
      this.body.dom.center.appendChild(this.dom.frame);
    }
  };

  /**
   * Set items
   * @param {vis.DataSet | null} items
   */
  LineGraph.prototype.setItems = function (items) {
    var me = this,
        ids,
        oldItemsData = this.itemsData;

    // replace the dataset
    if (!items) {
      this.itemsData = null;
    } else if (items instanceof DataSet || items instanceof DataView) {
      this.itemsData = items;
    } else {
      throw new TypeError('Data must be an instance of DataSet or DataView');
    }

    if (oldItemsData) {
      // unsubscribe from old dataset
      util.forEach(this.itemListeners, function (callback, event) {
        oldItemsData.off(event, callback);
      });

      // remove all drawn items
      ids = oldItemsData.getIds();
      this._onRemove(ids);
    }

    if (this.itemsData) {
      // subscribe to new dataset
      var id = this.id;
      util.forEach(this.itemListeners, function (callback, event) {
        me.itemsData.on(event, callback, id);
      });

      // add all new items
      ids = this.itemsData.getIds();
      this._onAdd(ids);
    }
  };

  /**
   * Set groups
   * @param {vis.DataSet} groups
   */
  LineGraph.prototype.setGroups = function (groups) {
    var me = this;
    var ids;

    // unsubscribe from current dataset
    if (this.groupsData) {
      util.forEach(this.groupListeners, function (callback, event) {
        me.groupsData.off(event, callback);
      });

      // remove all drawn groups
      ids = this.groupsData.getIds();
      this.groupsData = null;
      for (var i = 0; i < ids.length; i++) {
        this._removeGroup(ids[i]);
      }
    }

    // replace the dataset
    if (!groups) {
      this.groupsData = null;
    } else if (groups instanceof DataSet || groups instanceof DataView) {
      this.groupsData = groups;
    } else {
      throw new TypeError('Data must be an instance of DataSet or DataView');
    }

    if (this.groupsData) {
      // subscribe to new dataset
      var id = this.id;
      util.forEach(this.groupListeners, function (callback, event) {
        me.groupsData.on(event, callback, id);
      });

      // draw all ms
      ids = this.groupsData.getIds();
      this._onAddGroups(ids);
    }
  };

  LineGraph.prototype._onUpdate = function (ids) {
    this._updateAllGroupData(ids);
  };
  LineGraph.prototype._onAdd = function (ids) {
    this._onUpdate(ids);
  };
  LineGraph.prototype._onRemove = function (ids) {
    this._onUpdate(ids);
  };
  LineGraph.prototype._onUpdateGroups = function (groupIds) {
    this._updateAllGroupData(null, groupIds);
  };
  LineGraph.prototype._onAddGroups = function (groupIds) {
    this._onUpdateGroups(groupIds);
  };

  /**
   * this cleans the group out off the legends and the dataaxis, updates the ungrouped and updates the graph
   * @param {Array} groupIds
   * @private
   */
  LineGraph.prototype._onRemoveGroups = function (groupIds) {
    for (var i = 0; i < groupIds.length; i++) {
      this._removeGroup(groupIds[i]);
    }
    this.forceGraphUpdate = true;
    this.body.emitter.emit("_change", { queue: true });
  };

  /**
   * this cleans the group out off the legends and the dataaxis
   * @param groupId
   * @private
   */
  LineGraph.prototype._removeGroup = function (groupId) {
    if (this.groups.hasOwnProperty(groupId)) {
      if (this.groups[groupId].options.yAxisOrientation == 'right') {
        this.yAxisRight.removeGroup(groupId);
        this.legendRight.removeGroup(groupId);
        this.legendRight.redraw();
      } else {
        this.yAxisLeft.removeGroup(groupId);
        this.legendLeft.removeGroup(groupId);
        this.legendLeft.redraw();
      }
      delete this.groups[groupId];
    }
  };

  /**
   * update a group object with the group dataset entree
   *
   * @param group
   * @param groupId
   * @private
   */
  LineGraph.prototype._updateGroup = function (group, groupId) {
    if (!this.groups.hasOwnProperty(groupId)) {
      this.groups[groupId] = new GraphGroup(group, groupId, this.options, this.groupsUsingDefaultStyles);
      if (this.groups[groupId].options.yAxisOrientation == 'right') {
        this.yAxisRight.addGroup(groupId, this.groups[groupId]);
        this.legendRight.addGroup(groupId, this.groups[groupId]);
      } else {
        this.yAxisLeft.addGroup(groupId, this.groups[groupId]);
        this.legendLeft.addGroup(groupId, this.groups[groupId]);
      }
    } else {
      this.groups[groupId].update(group);
      if (this.groups[groupId].options.yAxisOrientation == 'right') {
        this.yAxisRight.updateGroup(groupId, this.groups[groupId]);
        this.legendRight.updateGroup(groupId, this.groups[groupId]);
        //If yAxisOrientation changed, clean out the group from the other axis.
        this.yAxisLeft.removeGroup(groupId);
        this.legendLeft.removeGroup(groupId);
      } else {
        this.yAxisLeft.updateGroup(groupId, this.groups[groupId]);
        this.legendLeft.updateGroup(groupId, this.groups[groupId]);
        //If yAxisOrientation changed, clean out the group from the other axis.
        this.yAxisRight.removeGroup(groupId);
        this.legendRight.removeGroup(groupId);
      }
    }
    this.legendLeft.redraw();
    this.legendRight.redraw();
  };

  /**
   * this updates all groups, it is used when there is an update the the itemset.
   *
   * @param  {Array} ids
   * @param  {Array} groupIds
   * @private
   */
  LineGraph.prototype._updateAllGroupData = function (ids, groupIds) {
    if (this.itemsData != null) {
      var groupsContent = {};
      var items = this.itemsData.get();
      var fieldId = this.itemsData._fieldId;
      var idMap = {};
      if (ids) {
        ids.map(function (id) {
          idMap[id] = id;
        });
      }

      //pre-Determine array sizes, for more efficient memory claim
      var groupCounts = {};
      for (var i = 0; i < items.length; i++) {
        var item = items[i];
        var groupId = item.group;
        if (groupId === null || groupId === undefined) {
          groupId = UNGROUPED;
        }
        groupCounts.hasOwnProperty(groupId) ? groupCounts[groupId]++ : groupCounts[groupId] = 1;
      }

      //Pre-load arrays from existing groups if items are not changed (not in ids)
      if (!groupIds && ids) {
        for (var groupId in this.groups) {
          if (this.groups.hasOwnProperty(groupId)) {
            var group = this.groups[groupId];
            var existing_items = group.getItems();

            groupsContent[groupId] = existing_items.filter(function (item) {
              return item[fieldId] !== idMap[item[fieldId]];
            });
            var newLength = groupCounts[groupId];
            groupCounts[groupId] -= groupsContent[groupId].length;
            if (groupsContent[groupId].length < newLength) {
              groupsContent[groupId][newLength - 1] = {};
            }
          }
        }
      }

      //Now insert data into the arrays.
      for (var i = 0; i < items.length; i++) {
        var item = items[i];
        var groupId = item.group;
        if (groupId === null || groupId === undefined) {
          groupId = UNGROUPED;
        }
        if (!groupIds && ids && item[fieldId] !== idMap[item[fieldId]]) {
          continue;
        }
        if (!groupsContent.hasOwnProperty(groupId)) {
          groupsContent[groupId] = new Array(groupCounts[groupId]);
        }
        //Copy data (because of unmodifiable DataView input.
        var extended = util.bridgeObject(item);
        extended.x = util.convert(item.x, 'Date');
        extended.orginalY = item.y; //real Y
        extended.y = Number(item.y);
        extended[fieldId] = item[fieldId];

        var index = groupsContent[groupId].length - groupCounts[groupId]--;
        groupsContent[groupId][index] = extended;
      }

      //Make sure all groups are present, to allow removal of old groups
      for (var groupId in this.groups) {
        if (this.groups.hasOwnProperty(groupId)) {
          if (!groupsContent.hasOwnProperty(groupId)) {
            groupsContent[groupId] = new Array(0);
          }
        }
      }

      //Update legendas, style and axis
      for (var groupId in groupsContent) {
        if (groupsContent.hasOwnProperty(groupId)) {
          if (groupsContent[groupId].length == 0) {
            if (this.groups.hasOwnProperty(groupId)) {
              this._removeGroup(groupId);
            }
          } else {
            var group = undefined;
            if (this.groupsData != undefined) {
              group = this.groupsData.get(groupId);
            }
            if (group == undefined) {
              group = { id: groupId, content: this.options.defaultGroup + groupId };
            }
            this._updateGroup(group, groupId);
            this.groups[groupId].setItems(groupsContent[groupId]);
          }
        }
      }
      this.forceGraphUpdate = true;
      this.body.emitter.emit("_change", { queue: true });
    }
  };

  /**
   * Redraw the component, mandatory function
   * @return {boolean} Returns true if the component is resized
   */
  LineGraph.prototype.redraw = function () {
    var resized = false;

    // calculate actual size and position
    this.props.width = this.dom.frame.offsetWidth;
    this.props.height = this.body.domProps.centerContainer.height - this.body.domProps.border.top - this.body.domProps.border.bottom;

    // check if this component is resized
    resized = this._isResized() || resized;

    // check whether zoomed (in that case we need to re-stack everything)
    var visibleInterval = this.body.range.end - this.body.range.start;
    var zoomed = visibleInterval != this.lastVisibleInterval;
    this.lastVisibleInterval = visibleInterval;

    // the svg element is three times as big as the width, this allows for fully dragging left and right
    // without reloading the graph. the controls for this are bound to events in the constructor
    if (resized == true) {
      this.svg.style.width = util.option.asSize(3 * this.props.width);
      this.svg.style.left = util.option.asSize(-this.props.width);

      // if the height of the graph is set as proportional, change the height of the svg
      if ((this.options.height + '').indexOf("%") != -1 || this.updateSVGheightOnResize == true) {
        this.updateSVGheight = true;
      }
    }

    // update the height of the graph on each redraw of the graph.
    if (this.updateSVGheight == true) {
      if (this.options.graphHeight != this.props.height + 'px') {
        this.options.graphHeight = this.props.height + 'px';
        this.svg.style.height = this.props.height + 'px';
      }
      this.updateSVGheight = false;
    } else {
      this.svg.style.height = ('' + this.options.graphHeight).replace('px', '') + 'px';
    }

    // zoomed is here to ensure that animations are shown correctly.
    if (resized == true || zoomed == true || this.abortedGraphUpdate == true || this.forceGraphUpdate == true) {
      resized = this._updateGraph() || resized;
      this.forceGraphUpdate = false;
    } else {
      // move the whole svg while dragging
      if (this.lastStart != 0) {
        var offset = this.body.range.start - this.lastStart;
        var range = this.body.range.end - this.body.range.start;
        if (this.props.width != 0) {
          var rangePerPixelInv = this.props.width / range;
          var xOffset = offset * rangePerPixelInv;
          this.svg.style.left = -this.props.width - xOffset + 'px';
        }
      }
    }
    this.legendLeft.redraw();
    this.legendRight.redraw();
    return resized;
  };

  LineGraph.prototype._getSortedGroupIds = function () {
    // getting group Ids
    var grouplist = [];
    for (var groupId in this.groups) {
      if (this.groups.hasOwnProperty(groupId)) {
        var group = this.groups[groupId];
        if (group.visible == true && (this.options.groups.visibility[groupId] === undefined || this.options.groups.visibility[groupId] == true)) {
          grouplist.push({ id: groupId, zIndex: group.options.zIndex });
        }
      }
    }
    util.insertSort(grouplist, function (a, b) {
      var az = a.zIndex;
      var bz = b.zIndex;
      if (az === undefined) az = 0;
      if (bz === undefined) bz = 0;
      return az == bz ? 0 : az < bz ? -1 : 1;
    });
    var groupIds = new Array(grouplist.length);
    for (var i = 0; i < grouplist.length; i++) {
      groupIds[i] = grouplist[i].id;
    }
    return groupIds;
  };

  /**
   * Update and redraw the graph.
   *
   */
  LineGraph.prototype._updateGraph = function () {
    // reset the svg elements
    DOMutil.prepareElements(this.svgElements);
    if (this.props.width != 0 && this.itemsData != null) {
      var group, i;
      var groupRanges = {};
      var changeCalled = false;
      // this is the range of the SVG canvas
      var minDate = this.body.util.toGlobalTime(-this.body.domProps.root.width);
      var maxDate = this.body.util.toGlobalTime(2 * this.body.domProps.root.width);

      // getting group Ids
      var groupIds = this._getSortedGroupIds();
      if (groupIds.length > 0) {
        var groupsData = {};

        // fill groups data, this only loads the data we require based on the timewindow
        this._getRelevantData(groupIds, groupsData, minDate, maxDate);

        // apply sampling, if disabled, it will pass through this function.
        this._applySampling(groupIds, groupsData);

        // we transform the X coordinates to detect collisions
        for (i = 0; i < groupIds.length; i++) {
          this._convertXcoordinates(groupsData[groupIds[i]]);
        }

        // now all needed data has been collected we start the processing.
        this._getYRanges(groupIds, groupsData, groupRanges);

        // update the Y axis first, we use this data to draw at the correct Y points
        changeCalled = this._updateYAxis(groupIds, groupRanges);

        //  at changeCalled, abort this update cycle as the graph needs another update with new Width input from the Redraw container.
        //  Cleanup SVG elements on abort.
        if (changeCalled == true) {
          DOMutil.cleanupElements(this.svgElements);
          this.abortedGraphUpdate = true;
          return true;
        }
        this.abortedGraphUpdate = false;

        // With the yAxis scaled correctly, use this to get the Y values of the points.
        var below = undefined;
        for (i = 0; i < groupIds.length; i++) {
          group = this.groups[groupIds[i]];
          if (this.options.stack === true && this.options.style === 'line') {
            if (group.options.excludeFromStacking == undefined || !group.options.excludeFromStacking) {
              if (below != undefined) {
                this._stack(groupsData[group.id], groupsData[below.id]);
                if (group.options.shaded.enabled == true && group.options.shaded.orientation !== "group") {
                  if (group.options.shaded.orientation == "top" && below.options.shaded.orientation !== "group") {
                    below.options.shaded.orientation = "group";
                    below.options.shaded.groupId = group.id;
                  } else {
                    group.options.shaded.orientation = "group";
                    group.options.shaded.groupId = below.id;
                  }
                }
              }
              below = group;
            }
          }
          this._convertYcoordinates(groupsData[groupIds[i]], group);
        }

        //Precalculate paths and draw shading if appropriate. This will make sure the shading is always behind any lines.
        var paths = {};
        for (i = 0; i < groupIds.length; i++) {
          group = this.groups[groupIds[i]];
          if (group.options.style === 'line' && group.options.shaded.enabled == true) {
            var dataset = groupsData[groupIds[i]];
            if (dataset == null || dataset.length == 0) {
              continue;
            }
            if (!paths.hasOwnProperty(groupIds[i])) {
              paths[groupIds[i]] = Lines.calcPath(dataset, group);
            }
            if (group.options.shaded.orientation === "group") {
              var subGroupId = group.options.shaded.groupId;
              if (groupIds.indexOf(subGroupId) === -1) {
                console.log(group.id + ": Unknown shading group target given:" + subGroupId);
                continue;
              }
              if (!paths.hasOwnProperty(subGroupId)) {
                paths[subGroupId] = Lines.calcPath(groupsData[subGroupId], this.groups[subGroupId]);
              }
              Lines.drawShading(paths[groupIds[i]], group, paths[subGroupId], this.framework);
            } else {
              Lines.drawShading(paths[groupIds[i]], group, undefined, this.framework);
            }
          }
        }

        // draw the groups, calculating paths if still necessary.
        Bars.draw(groupIds, groupsData, this.framework);
        for (i = 0; i < groupIds.length; i++) {
          group = this.groups[groupIds[i]];
          if (groupsData[groupIds[i]].length > 0) {
            switch (group.options.style) {
              case "line":
                if (!paths.hasOwnProperty(groupIds[i])) {
                  paths[groupIds[i]] = Lines.calcPath(groupsData[groupIds[i]], group);
                }
                Lines.draw(paths[groupIds[i]], group, this.framework);
              //explicit no break;
              case "point":
              //explicit no break;
              case "points":
                if (group.options.style == "point" || group.options.style == "points" || group.options.drawPoints.enabled == true) {
                  Points.draw(groupsData[groupIds[i]], group, this.framework);
                }
                break;
              case "bar":
              // bar needs to be drawn enmasse
              //explicit no break
              default:
              //do nothing...
            }
          }
        }
      }
    }

    // cleanup unused svg elements
    DOMutil.cleanupElements(this.svgElements);
    return false;
  };

  LineGraph.prototype._stack = function (data, subData) {
    var index, dx, dy, subPrevPoint, subNextPoint;
    index = 0;
    // for each data point we look for a matching on in the set below
    for (var j = 0; j < data.length; j++) {
      subPrevPoint = undefined;
      subNextPoint = undefined;
      // we look for time matches or a before-after point
      for (var k = index; k < subData.length; k++) {
        // if times match exactly
        if (subData[k].x === data[j].x) {
          subPrevPoint = subData[k];
          subNextPoint = subData[k];
          index = k;
          break;
        } else if (subData[k].x > data[j].x) {
          // overshoot
          subNextPoint = subData[k];
          if (k == 0) {
            subPrevPoint = subNextPoint;
          } else {
            subPrevPoint = subData[k - 1];
          }
          index = k;
          break;
        }
      }
      // in case the last data point has been used, we assume it stays like this.
      if (subNextPoint === undefined) {
        subPrevPoint = subData[subData.length - 1];
        subNextPoint = subData[subData.length - 1];
      }
      // linear interpolation
      dx = subNextPoint.x - subPrevPoint.x;
      dy = subNextPoint.y - subPrevPoint.y;
      if (dx == 0) {
        data[j].y = data[j].orginalY + subNextPoint.y;
      } else {
        data[j].y = data[j].orginalY + dy / dx * (data[j].x - subPrevPoint.x) + subPrevPoint.y; // ax + b where b is data[j].y
      }
    }
  };

  /**
   * first select and preprocess the data from the datasets.
   * the groups have their preselection of data, we now loop over this data to see
   * what data we need to draw. Sorted data is much faster.
   * more optimization is possible by doing the sampling before and using the binary search
   * to find the end date to determine the increment.
   *
   * @param {array}  groupIds
   * @param {object} groupsData
   * @param {date}   minDate
   * @param {date}   maxDate
   * @private
   */
  LineGraph.prototype._getRelevantData = function (groupIds, groupsData, minDate, maxDate) {
    var group, i, j, item;
    if (groupIds.length > 0) {
      for (i = 0; i < groupIds.length; i++) {
        group = this.groups[groupIds[i]];
        var itemsData = group.getItems();
        // optimization for sorted data
        if (group.options.sort == true) {
          var dateComparator = function dateComparator(a, b) {
            return a.getTime() == b.getTime() ? 0 : a < b ? -1 : 1;
          };
          var first = Math.max(0, util.binarySearchValue(itemsData, minDate, 'x', 'before', dateComparator));
          var last = Math.min(itemsData.length, util.binarySearchValue(itemsData, maxDate, 'x', 'after', dateComparator) + 1);
          if (last <= 0) {
            last = itemsData.length;
          }
          var dataContainer = new Array(last - first);
          for (j = first; j < last; j++) {
            item = group.itemsData[j];
            dataContainer[j - first] = item;
          }
          groupsData[groupIds[i]] = dataContainer;
        } else {
          // If unsorted data, all data is relevant, just returning entire structure
          groupsData[groupIds[i]] = group.itemsData;
        }
      }
    }
  };

  /**
   *
   * @param groupIds
   * @param groupsData
   * @private
   */
  LineGraph.prototype._applySampling = function (groupIds, groupsData) {
    var group;
    if (groupIds.length > 0) {
      for (var i = 0; i < groupIds.length; i++) {
        group = this.groups[groupIds[i]];
        if (group.options.sampling == true) {
          var dataContainer = groupsData[groupIds[i]];
          if (dataContainer.length > 0) {
            var increment = 1;
            var amountOfPoints = dataContainer.length;

            // the global screen is used because changing the width of the yAxis may affect the increment, resulting in an endless loop
            // of width changing of the yAxis.
            //TODO: This assumes sorted data, but that's not guaranteed!
            var xDistance = this.body.util.toGlobalScreen(dataContainer[dataContainer.length - 1].x) - this.body.util.toGlobalScreen(dataContainer[0].x);
            var pointsPerPixel = amountOfPoints / xDistance;
            increment = Math.min(Math.ceil(0.2 * amountOfPoints), Math.max(1, Math.round(pointsPerPixel)));

            var sampledData = new Array(amountOfPoints);
            for (var j = 0; j < amountOfPoints; j += increment) {
              var idx = Math.round(j / increment);
              sampledData[idx] = dataContainer[j];
            }
            groupsData[groupIds[i]] = sampledData.splice(0, Math.round(amountOfPoints / increment));
          }
        }
      }
    }
  };

  /**
   *
   *
   * @param {array}  groupIds
   * @param {object} groupsData
   * @param {object} groupRanges  | this is being filled here
   * @private
   */
  LineGraph.prototype._getYRanges = function (groupIds, groupsData, groupRanges) {
    var groupData, group, i;
    var combinedDataLeft = [];
    var combinedDataRight = [];
    var options;
    if (groupIds.length > 0) {
      for (i = 0; i < groupIds.length; i++) {
        groupData = groupsData[groupIds[i]];
        options = this.groups[groupIds[i]].options;
        if (groupData.length > 0) {
          group = this.groups[groupIds[i]];
          // if bar graphs are stacked, their range need to be handled differently and accumulated over all groups.
          if (options.stack === true && options.style === 'bar') {
            if (options.yAxisOrientation === 'left') {
              combinedDataLeft = combinedDataLeft.concat(group.getItems());
            } else {
              combinedDataRight = combinedDataRight.concat(group.getItems());
            }
          } else {
            groupRanges[groupIds[i]] = group.getYRange(groupData, groupIds[i]);
          }
        }
      }

      // if bar graphs are stacked, their range need to be handled differently and accumulated over all groups.
      Bars.getStackedYRange(combinedDataLeft, groupRanges, groupIds, '__barStackLeft', 'left');
      Bars.getStackedYRange(combinedDataRight, groupRanges, groupIds, '__barStackRight', 'right');
    }
  };

  /**
   * this sets the Y ranges for the Y axis. It also determines which of the axis should be shown or hidden.
   * @param {Array} groupIds
   * @param {Object} groupRanges
   * @private
   */
  LineGraph.prototype._updateYAxis = function (groupIds, groupRanges) {
    var resized = false;
    var yAxisLeftUsed = false;
    var yAxisRightUsed = false;
    var minLeft = 1e9,
        minRight = 1e9,
        maxLeft = -1e9,
        maxRight = -1e9,
        minVal,
        maxVal;
    // if groups are present
    if (groupIds.length > 0) {
      // this is here to make sure that if there are no items in the axis but there are groups, that there is no infinite draw/redraw loop.
      for (var i = 0; i < groupIds.length; i++) {
        var group = this.groups[groupIds[i]];
        if (group && group.options.yAxisOrientation != 'right') {
          yAxisLeftUsed = true;
          minLeft = 1e9;
          maxLeft = -1e9;
        } else if (group && group.options.yAxisOrientation) {
          yAxisRightUsed = true;
          minRight = 1e9;
          maxRight = -1e9;
        }
      }

      // if there are items:
      for (var i = 0; i < groupIds.length; i++) {
        if (groupRanges.hasOwnProperty(groupIds[i])) {
          if (groupRanges[groupIds[i]].ignore !== true) {
            minVal = groupRanges[groupIds[i]].min;
            maxVal = groupRanges[groupIds[i]].max;

            if (groupRanges[groupIds[i]].yAxisOrientation != 'right') {
              yAxisLeftUsed = true;
              minLeft = minLeft > minVal ? minVal : minLeft;
              maxLeft = maxLeft < maxVal ? maxVal : maxLeft;
            } else {
              yAxisRightUsed = true;
              minRight = minRight > minVal ? minVal : minRight;
              maxRight = maxRight < maxVal ? maxVal : maxRight;
            }
          }
        }
      }

      if (yAxisLeftUsed == true) {
        this.yAxisLeft.setRange(minLeft, maxLeft);
      }
      if (yAxisRightUsed == true) {
        this.yAxisRight.setRange(minRight, maxRight);
      }
    }
    resized = this._toggleAxisVisiblity(yAxisLeftUsed, this.yAxisLeft) || resized;
    resized = this._toggleAxisVisiblity(yAxisRightUsed, this.yAxisRight) || resized;

    if (yAxisRightUsed == true && yAxisLeftUsed == true) {
      this.yAxisLeft.drawIcons = true;
      this.yAxisRight.drawIcons = true;
    } else {
      this.yAxisLeft.drawIcons = false;
      this.yAxisRight.drawIcons = false;
    }
    this.yAxisRight.master = !yAxisLeftUsed;
    this.yAxisRight.masterAxis = this.yAxisLeft;

    if (this.yAxisRight.master == false) {
      if (yAxisRightUsed == true) {
        this.yAxisLeft.lineOffset = this.yAxisRight.width;
      } else {
        this.yAxisLeft.lineOffset = 0;
      }

      resized = this.yAxisLeft.redraw() || resized;
      resized = this.yAxisRight.redraw() || resized;
    } else {
      resized = this.yAxisRight.redraw() || resized;
    }

    // clean the accumulated lists
    var tempGroups = ['__barStackLeft', '__barStackRight', '__lineStackLeft', '__lineStackRight'];
    for (var i = 0; i < tempGroups.length; i++) {
      if (groupIds.indexOf(tempGroups[i]) != -1) {
        groupIds.splice(groupIds.indexOf(tempGroups[i]), 1);
      }
    }

    return resized;
  };

  /**
   * This shows or hides the Y axis if needed. If there is a change, the changed event is emitted by the updateYAxis function
   *
   * @param {boolean} axisUsed
   * @returns {boolean}
   * @private
   * @param axis
   */
  LineGraph.prototype._toggleAxisVisiblity = function (axisUsed, axis) {
    var changed = false;
    if (axisUsed == false) {
      if (axis.dom.frame.parentNode && axis.hidden == false) {
        axis.hide();
        changed = true;
      }
    } else {
      if (!axis.dom.frame.parentNode && axis.hidden == true) {
        axis.show();
        changed = true;
      }
    }
    return changed;
  };

  /**
   * This uses the DataAxis object to generate the correct X coordinate on the SVG window. It uses the
   * util function toScreen to get the x coordinate from the timestamp. It also pre-filters the data and get the minMax ranges for
   * the yAxis.
   *
   * @param datapoints
   * @returns {Array}
   * @private
   */
  LineGraph.prototype._convertXcoordinates = function (datapoints) {
    var toScreen = this.body.util.toScreen;
    for (var i = 0; i < datapoints.length; i++) {
      datapoints[i].screen_x = toScreen(datapoints[i].x) + this.props.width;
      datapoints[i].screen_y = datapoints[i].y; //starting point for range calculations
    }
  };

  /**
   * This uses the DataAxis object to generate the correct X coordinate on the SVG window. It uses the
   * util function toScreen to get the x coordinate from the timestamp. It also pre-filters the data and get the minMax ranges for
   * the yAxis.
   *
   * @param datapoints
   * @param group
   * @returns {Array}
   * @private
   */
  LineGraph.prototype._convertYcoordinates = function (datapoints, group) {
    var axis = this.yAxisLeft;
    var svgHeight = Number(this.svg.style.height.replace('px', ''));
    if (group.options.yAxisOrientation == 'right') {
      axis = this.yAxisRight;
    }
    for (var i = 0; i < datapoints.length; i++) {
      datapoints[i].screen_y = Math.round(axis.convertValue(datapoints[i].y));
    }
    group.setZeroPosition(Math.min(svgHeight, axis.convertValue(0)));
  };

  module.exports = LineGraph;

/***/ },
/* 146 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _keys = __webpack_require__(58);

  var _keys2 = _interopRequireDefault(_keys);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var DOMutil = __webpack_require__(90);
  var Component = __webpack_require__(124);
  var DataScale = __webpack_require__(147);
  /**
   * A horizontal time axis
   * @param {Object} [options]        See DataAxis.setOptions for the available
   *                                  options.
   * @constructor DataAxis
   * @extends Component
   * @param body
   */
  function DataAxis(body, options, svg, linegraphOptions) {
    this.id = util.randomUUID();
    this.body = body;

    this.defaultOptions = {
      orientation: 'left', // supported: 'left', 'right'
      showMinorLabels: true,
      showMajorLabels: true,
      icons: false,
      majorLinesOffset: 7,
      minorLinesOffset: 4,
      labelOffsetX: 10,
      labelOffsetY: 2,
      iconWidth: 20,
      width: '40px',
      visible: true,
      alignZeros: true,
      left: {
        range: { min: undefined, max: undefined },
        format: function format(value) {
          return '' + parseFloat(value.toPrecision(3));
        },
        title: { text: undefined, style: undefined }
      },
      right: {
        range: { min: undefined, max: undefined },
        format: function format(value) {
          return '' + parseFloat(value.toPrecision(3));
        },
        title: { text: undefined, style: undefined }
      }
    };

    this.linegraphOptions = linegraphOptions;
    this.linegraphSVG = svg;
    this.props = {};
    this.DOMelements = { // dynamic elements
      lines: {},
      labels: {},
      title: {}
    };

    this.dom = {};
    this.scale = undefined;
    this.range = { start: 0, end: 0 };

    this.options = util.extend({}, this.defaultOptions);
    this.conversionFactor = 1;

    this.setOptions(options);
    this.width = Number(('' + this.options.width).replace("px", ""));
    this.minWidth = this.width;
    this.height = this.linegraphSVG.getBoundingClientRect().height;
    this.hidden = false;

    this.stepPixels = 25;
    this.zeroCrossing = -1;
    this.amountOfSteps = -1;

    this.lineOffset = 0;
    this.master = true;
    this.masterAxis = null;
    this.svgElements = {};
    this.iconsRemoved = false;

    this.groups = {};
    this.amountOfGroups = 0;

    // create the HTML DOM
    this._create();
    this.framework = { svg: this.svg, svgElements: this.svgElements, options: this.options, groups: this.groups };

    var me = this;
    this.body.emitter.on("verticalDrag", function () {
      me.dom.lineContainer.style.top = me.body.domProps.scrollTop + 'px';
    });
  }

  DataAxis.prototype = new Component();

  DataAxis.prototype.addGroup = function (label, graphOptions) {
    if (!this.groups.hasOwnProperty(label)) {
      this.groups[label] = graphOptions;
    }
    this.amountOfGroups += 1;
  };

  DataAxis.prototype.updateGroup = function (label, graphOptions) {
    if (!this.groups.hasOwnProperty(label)) {
      this.amountOfGroups += 1;
    }
    this.groups[label] = graphOptions;
  };

  DataAxis.prototype.removeGroup = function (label) {
    if (this.groups.hasOwnProperty(label)) {
      delete this.groups[label];
      this.amountOfGroups -= 1;
    }
  };

  DataAxis.prototype.setOptions = function (options) {
    if (options) {
      var redraw = false;
      if (this.options.orientation != options.orientation && options.orientation !== undefined) {
        redraw = true;
      }
      var fields = ['orientation', 'showMinorLabels', 'showMajorLabels', 'icons', 'majorLinesOffset', 'minorLinesOffset', 'labelOffsetX', 'labelOffsetY', 'iconWidth', 'width', 'visible', 'left', 'right', 'alignZeros'];
      util.selectiveDeepExtend(fields, this.options, options);

      this.minWidth = Number(('' + this.options.width).replace("px", ""));
      if (redraw === true && this.dom.frame) {
        this.hide();
        this.show();
      }
    }
  };

  /**
   * Create the HTML DOM for the DataAxis
   */
  DataAxis.prototype._create = function () {
    this.dom.frame = document.createElement('div');
    this.dom.frame.style.width = this.options.width;
    this.dom.frame.style.height = this.height;

    this.dom.lineContainer = document.createElement('div');
    this.dom.lineContainer.style.width = '100%';
    this.dom.lineContainer.style.height = this.height;
    this.dom.lineContainer.style.position = 'relative';

    // create svg element for graph drawing.
    this.svg = document.createElementNS('http://www.w3.org/2000/svg', "svg");
    this.svg.style.position = "absolute";
    this.svg.style.top = '0px';
    this.svg.style.height = '100%';
    this.svg.style.width = '100%';
    this.svg.style.display = "block";
    this.dom.frame.appendChild(this.svg);
  };

  DataAxis.prototype._redrawGroupIcons = function () {
    DOMutil.prepareElements(this.svgElements);

    var x;
    var iconWidth = this.options.iconWidth;
    var iconHeight = 15;
    var iconOffset = 4;
    var y = iconOffset + 0.5 * iconHeight;

    if (this.options.orientation === 'left') {
      x = iconOffset;
    } else {
      x = this.width - iconWidth - iconOffset;
    }

    var groupArray = (0, _keys2['default'])(this.groups);
    groupArray.sort(function (a, b) {
      return a < b ? -1 : 1;
    });

    for (var i = 0; i < groupArray.length; i++) {
      var groupId = groupArray[i];
      if (this.groups[groupId].visible === true && (this.linegraphOptions.visibility[groupId] === undefined || this.linegraphOptions.visibility[groupId] === true)) {
        this.groups[groupId].getLegend(iconWidth, iconHeight, this.framework, x, y);
        y += iconHeight + iconOffset;
      }
    }

    DOMutil.cleanupElements(this.svgElements);
    this.iconsRemoved = false;
  };

  DataAxis.prototype._cleanupIcons = function () {
    if (this.iconsRemoved === false) {
      DOMutil.prepareElements(this.svgElements);
      DOMutil.cleanupElements(this.svgElements);
      this.iconsRemoved = true;
    }
  };

  /**
   * Create the HTML DOM for the DataAxis
   */
  DataAxis.prototype.show = function () {
    this.hidden = false;
    if (!this.dom.frame.parentNode) {
      if (this.options.orientation === 'left') {
        this.body.dom.left.appendChild(this.dom.frame);
      } else {
        this.body.dom.right.appendChild(this.dom.frame);
      }
    }

    if (!this.dom.lineContainer.parentNode) {
      this.body.dom.backgroundHorizontal.appendChild(this.dom.lineContainer);
    }
  };

  /**
   * Create the HTML DOM for the DataAxis
   */
  DataAxis.prototype.hide = function () {
    this.hidden = true;
    if (this.dom.frame.parentNode) {
      this.dom.frame.parentNode.removeChild(this.dom.frame);
    }

    if (this.dom.lineContainer.parentNode) {
      this.dom.lineContainer.parentNode.removeChild(this.dom.lineContainer);
    }
  };

  /**
   * Set a range (start and end)
   * @param end
   * @param start
   * @param end
   */
  DataAxis.prototype.setRange = function (start, end) {
    this.range.start = start;
    this.range.end = end;
  };

  /**
   * Repaint the component
   * @return {boolean} Returns true if the component is resized
   */
  DataAxis.prototype.redraw = function () {
    var resized = false;
    var activeGroups = 0;

    // Make sure the line container adheres to the vertical scrolling.
    this.dom.lineContainer.style.top = this.body.domProps.scrollTop + 'px';

    for (var groupId in this.groups) {
      if (this.groups.hasOwnProperty(groupId)) {
        if (this.groups[groupId].visible === true && (this.linegraphOptions.visibility[groupId] === undefined || this.linegraphOptions.visibility[groupId] === true)) {
          activeGroups++;
        }
      }
    }
    if (this.amountOfGroups === 0 || activeGroups === 0) {
      this.hide();
    } else {
      this.show();
      this.height = Number(this.linegraphSVG.style.height.replace("px", ""));

      // svg offsetheight did not work in firefox and explorer...
      this.dom.lineContainer.style.height = this.height + 'px';
      this.width = this.options.visible === true ? Number(('' + this.options.width).replace("px", "")) : 0;

      var props = this.props;
      var frame = this.dom.frame;

      // update classname
      frame.className = 'vis-data-axis';

      // calculate character width and height
      this._calculateCharSize();

      var orientation = this.options.orientation;
      var showMinorLabels = this.options.showMinorLabels;
      var showMajorLabels = this.options.showMajorLabels;

      // determine the width and height of the elements for the axis
      props.minorLabelHeight = showMinorLabels ? props.minorCharHeight : 0;
      props.majorLabelHeight = showMajorLabels ? props.majorCharHeight : 0;

      props.minorLineWidth = this.body.dom.backgroundHorizontal.offsetWidth - this.lineOffset - this.width + 2 * this.options.minorLinesOffset;
      props.minorLineHeight = 1;
      props.majorLineWidth = this.body.dom.backgroundHorizontal.offsetWidth - this.lineOffset - this.width + 2 * this.options.majorLinesOffset;
      props.majorLineHeight = 1;

      //  take frame offline while updating (is almost twice as fast)
      if (orientation === 'left') {
        frame.style.top = '0';
        frame.style.left = '0';
        frame.style.bottom = '';
        frame.style.width = this.width + 'px';
        frame.style.height = this.height + "px";
        this.props.width = this.body.domProps.left.width;
        this.props.height = this.body.domProps.left.height;
      } else {
        // right
        frame.style.top = '';
        frame.style.bottom = '0';
        frame.style.left = '0';
        frame.style.width = this.width + 'px';
        frame.style.height = this.height + "px";
        this.props.width = this.body.domProps.right.width;
        this.props.height = this.body.domProps.right.height;
      }

      resized = this._redrawLabels();
      resized = this._isResized() || resized;

      if (this.options.icons === true) {
        this._redrawGroupIcons();
      } else {
        this._cleanupIcons();
      }

      this._redrawTitle(orientation);
    }
    return resized;
  };

  /**
   * Repaint major and minor text labels and vertical grid lines
   * @private
   */
  DataAxis.prototype._redrawLabels = function () {
    var _this = this;

    var resized = false;
    DOMutil.prepareElements(this.DOMelements.lines);
    DOMutil.prepareElements(this.DOMelements.labels);
    var orientation = this.options['orientation'];
    var customRange = this.options[orientation].range != undefined ? this.options[orientation].range : {};

    //Override range with manual options:
    var autoScaleEnd = true;
    if (customRange.max != undefined) {
      this.range.end = customRange.max;
      autoScaleEnd = false;
    }
    var autoScaleStart = true;
    if (customRange.min != undefined) {
      this.range.start = customRange.min;
      autoScaleStart = false;
    }

    this.scale = new DataScale(this.range.start, this.range.end, autoScaleStart, autoScaleEnd, this.dom.frame.offsetHeight, this.props.majorCharHeight, this.options.alignZeros, this.options[orientation].format);

    if (this.master === false && this.masterAxis != undefined) {
      this.scale.followScale(this.masterAxis.scale);
    }

    //Is updated in side-effect of _redrawLabel():
    this.maxLabelSize = 0;

    var lines = this.scale.getLines();
    lines.forEach(function (line) {
      var y = line.y;
      var isMajor = line.major;
      if (_this.options['showMinorLabels'] && isMajor === false) {
        _this._redrawLabel(y - 2, line.val, orientation, 'vis-y-axis vis-minor', _this.props.minorCharHeight);
      }
      if (isMajor) {
        if (y >= 0) {
          _this._redrawLabel(y - 2, line.val, orientation, 'vis-y-axis vis-major', _this.props.majorCharHeight);
        }
      }
      if (_this.master === true) {
        if (isMajor) {
          _this._redrawLine(y, orientation, 'vis-grid vis-horizontal vis-major', _this.options.majorLinesOffset, _this.props.majorLineWidth);
        } else {
          _this._redrawLine(y, orientation, 'vis-grid vis-horizontal vis-minor', _this.options.minorLinesOffset, _this.props.minorLineWidth);
        }
      }
    });

    // Note that title is rotated, so we're using the height, not width!
    var titleWidth = 0;
    if (this.options[orientation].title !== undefined && this.options[orientation].title.text !== undefined) {
      titleWidth = this.props.titleCharHeight;
    }
    var offset = this.options.icons === true ? Math.max(this.options.iconWidth, titleWidth) + this.options.labelOffsetX + 15 : titleWidth + this.options.labelOffsetX + 15;

    // this will resize the yAxis to accommodate the labels.
    if (this.maxLabelSize > this.width - offset && this.options.visible === true) {
      this.width = this.maxLabelSize + offset;
      this.options.width = this.width + "px";
      DOMutil.cleanupElements(this.DOMelements.lines);
      DOMutil.cleanupElements(this.DOMelements.labels);
      this.redraw();
      resized = true;
    }
    // this will resize the yAxis if it is too big for the labels.
    else if (this.maxLabelSize < this.width - offset && this.options.visible === true && this.width > this.minWidth) {
        this.width = Math.max(this.minWidth, this.maxLabelSize + offset);
        this.options.width = this.width + "px";
        DOMutil.cleanupElements(this.DOMelements.lines);
        DOMutil.cleanupElements(this.DOMelements.labels);
        this.redraw();
        resized = true;
      } else {
        DOMutil.cleanupElements(this.DOMelements.lines);
        DOMutil.cleanupElements(this.DOMelements.labels);
        resized = false;
      }

    return resized;
  };

  DataAxis.prototype.convertValue = function (value) {
    return this.scale.convertValue(value);
  };

  DataAxis.prototype.screenToValue = function (x) {
    return this.scale.screenToValue(x);
  };

  /**
   * Create a label for the axis at position x
   * @private
   * @param y
   * @param text
   * @param orientation
   * @param className
   * @param characterHeight
   */
  DataAxis.prototype._redrawLabel = function (y, text, orientation, className, characterHeight) {
    // reuse redundant label
    var label = DOMutil.getDOMElement('div', this.DOMelements.labels, this.dom.frame); //this.dom.redundant.labels.shift();
    label.className = className;
    label.innerHTML = text;
    if (orientation === 'left') {
      label.style.left = '-' + this.options.labelOffsetX + 'px';
      label.style.textAlign = "right";
    } else {
      label.style.right = '-' + this.options.labelOffsetX + 'px';
      label.style.textAlign = "left";
    }

    label.style.top = y - 0.5 * characterHeight + this.options.labelOffsetY + 'px';

    text += '';

    var largestWidth = Math.max(this.props.majorCharWidth, this.props.minorCharWidth);
    if (this.maxLabelSize < text.length * largestWidth) {
      this.maxLabelSize = text.length * largestWidth;
    }
  };

  /**
   * Create a minor line for the axis at position y
   * @param y
   * @param orientation
   * @param className
   * @param offset
   * @param width
   */
  DataAxis.prototype._redrawLine = function (y, orientation, className, offset, width) {
    if (this.master === true) {
      var line = DOMutil.getDOMElement('div', this.DOMelements.lines, this.dom.lineContainer); //this.dom.redundant.lines.shift();
      line.className = className;
      line.innerHTML = '';

      if (orientation === 'left') {
        line.style.left = this.width - offset + 'px';
      } else {
        line.style.right = this.width - offset + 'px';
      }

      line.style.width = width + 'px';
      line.style.top = y + 'px';
    }
  };

  /**
   * Create a title for the axis
   * @private
   * @param orientation
   */
  DataAxis.prototype._redrawTitle = function (orientation) {
    DOMutil.prepareElements(this.DOMelements.title);

    // Check if the title is defined for this axes
    if (this.options[orientation].title !== undefined && this.options[orientation].title.text !== undefined) {
      var title = DOMutil.getDOMElement('div', this.DOMelements.title, this.dom.frame);
      title.className = 'vis-y-axis vis-title vis-' + orientation;
      title.innerHTML = this.options[orientation].title.text;

      // Add style - if provided
      if (this.options[orientation].title.style !== undefined) {
        util.addCssText(title, this.options[orientation].title.style);
      }

      if (orientation === 'left') {
        title.style.left = this.props.titleCharHeight + 'px';
      } else {
        title.style.right = this.props.titleCharHeight + 'px';
      }

      title.style.width = this.height + 'px';
    }

    // we need to clean up in case we did not use all elements.
    DOMutil.cleanupElements(this.DOMelements.title);
  };

  /**
   * Determine the size of text on the axis (both major and minor axis).
   * The size is calculated only once and then cached in this.props.
   * @private
   */
  DataAxis.prototype._calculateCharSize = function () {
    // determine the char width and height on the minor axis
    if (!('minorCharHeight' in this.props)) {
      var textMinor = document.createTextNode('0');
      var measureCharMinor = document.createElement('div');
      measureCharMinor.className = 'vis-y-axis vis-minor vis-measure';
      measureCharMinor.appendChild(textMinor);
      this.dom.frame.appendChild(measureCharMinor);

      this.props.minorCharHeight = measureCharMinor.clientHeight;
      this.props.minorCharWidth = measureCharMinor.clientWidth;

      this.dom.frame.removeChild(measureCharMinor);
    }

    if (!('majorCharHeight' in this.props)) {
      var textMajor = document.createTextNode('0');
      var measureCharMajor = document.createElement('div');
      measureCharMajor.className = 'vis-y-axis vis-major vis-measure';
      measureCharMajor.appendChild(textMajor);
      this.dom.frame.appendChild(measureCharMajor);

      this.props.majorCharHeight = measureCharMajor.clientHeight;
      this.props.majorCharWidth = measureCharMajor.clientWidth;

      this.dom.frame.removeChild(measureCharMajor);
    }

    if (!('titleCharHeight' in this.props)) {
      var textTitle = document.createTextNode('0');
      var measureCharTitle = document.createElement('div');
      measureCharTitle.className = 'vis-y-axis vis-title vis-measure';
      measureCharTitle.appendChild(textTitle);
      this.dom.frame.appendChild(measureCharTitle);

      this.props.titleCharHeight = measureCharTitle.clientHeight;
      this.props.titleCharWidth = measureCharTitle.clientWidth;

      this.dom.frame.removeChild(measureCharTitle);
    }
  };

  module.exports = DataAxis;

/***/ },
/* 147 */
/***/ function(module, exports) {

  'use strict';

  /**
   * Created by ludo on 25-1-16.
   */

  function DataScale(start, end, autoScaleStart, autoScaleEnd, containerHeight, majorCharHeight) {
    var zeroAlign = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : false;
    var formattingFunction = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : false;

    this.majorSteps = [1, 2, 5, 10];
    this.minorSteps = [0.25, 0.5, 1, 2];
    this.customLines = null;

    this.containerHeight = containerHeight;
    this.majorCharHeight = majorCharHeight;
    this._start = start;
    this._end = end;

    this.scale = 1;
    this.minorStepIdx = -1;
    this.magnitudefactor = 1;
    this.determineScale();

    this.zeroAlign = zeroAlign;
    this.autoScaleStart = autoScaleStart;
    this.autoScaleEnd = autoScaleEnd;

    this.formattingFunction = formattingFunction;

    if (autoScaleStart || autoScaleEnd) {
      var me = this;
      var roundToMinor = function roundToMinor(value) {
        var rounded = value - value % (me.magnitudefactor * me.minorSteps[me.minorStepIdx]);
        if (value % (me.magnitudefactor * me.minorSteps[me.minorStepIdx]) > 0.5 * (me.magnitudefactor * me.minorSteps[me.minorStepIdx])) {
          return rounded + me.magnitudefactor * me.minorSteps[me.minorStepIdx];
        } else {
          return rounded;
        }
      };
      if (autoScaleStart) {
        this._start -= this.magnitudefactor * 2 * this.minorSteps[this.minorStepIdx];
        this._start = roundToMinor(this._start);
      }

      if (autoScaleEnd) {
        this._end += this.magnitudefactor * this.minorSteps[this.minorStepIdx];
        this._end = roundToMinor(this._end);
      }
      this.determineScale();
    }
  }

  DataScale.prototype.setCharHeight = function (majorCharHeight) {
    this.majorCharHeight = majorCharHeight;
  };

  DataScale.prototype.setHeight = function (containerHeight) {
    this.containerHeight = containerHeight;
  };

  DataScale.prototype.determineScale = function () {
    var range = this._end - this._start;
    this.scale = this.containerHeight / range;
    var minimumStepValue = this.majorCharHeight / this.scale;
    var orderOfMagnitude = range > 0 ? Math.round(Math.log(range) / Math.LN10) : 0;

    this.minorStepIdx = -1;
    this.magnitudefactor = Math.pow(10, orderOfMagnitude);

    var start = 0;
    if (orderOfMagnitude < 0) {
      start = orderOfMagnitude;
    }

    var solutionFound = false;
    for (var l = start; Math.abs(l) <= Math.abs(orderOfMagnitude); l++) {
      this.magnitudefactor = Math.pow(10, l);
      for (var j = 0; j < this.minorSteps.length; j++) {
        var stepSize = this.magnitudefactor * this.minorSteps[j];
        if (stepSize >= minimumStepValue) {
          solutionFound = true;
          this.minorStepIdx = j;
          break;
        }
      }
      if (solutionFound === true) {
        break;
      }
    }
  };

  DataScale.prototype.is_major = function (value) {
    return value % (this.magnitudefactor * this.majorSteps[this.minorStepIdx]) === 0;
  };

  DataScale.prototype.getStep = function () {
    return this.magnitudefactor * this.minorSteps[this.minorStepIdx];
  };

  DataScale.prototype.getFirstMajor = function () {
    var majorStep = this.magnitudefactor * this.majorSteps[this.minorStepIdx];
    return this.convertValue(this._start + (majorStep - this._start % majorStep) % majorStep);
  };

  DataScale.prototype.formatValue = function (current) {
    var returnValue = current.toPrecision(5);
    if (typeof this.formattingFunction === 'function') {
      returnValue = this.formattingFunction(current);
    }

    if (typeof returnValue === 'number') {
      return '' + returnValue;
    } else if (typeof returnValue === 'string') {
      return returnValue;
    } else {
      return current.toPrecision(5);
    }
  };

  DataScale.prototype.getLines = function () {
    var lines = [];
    var step = this.getStep();
    var bottomOffset = (step - this._start % step) % step;
    for (var i = this._start + bottomOffset; this._end - i > 0.00001; i += step) {
      if (i != this._start) {
        //Skip the bottom line
        lines.push({ major: this.is_major(i), y: this.convertValue(i), val: this.formatValue(i) });
      }
    }
    return lines;
  };

  DataScale.prototype.followScale = function (other) {
    var oldStepIdx = this.minorStepIdx;
    var oldStart = this._start;
    var oldEnd = this._end;

    var me = this;
    var increaseMagnitude = function increaseMagnitude() {
      me.magnitudefactor *= 2;
    };
    var decreaseMagnitude = function decreaseMagnitude() {
      me.magnitudefactor /= 2;
    };

    if (other.minorStepIdx <= 1 && this.minorStepIdx <= 1 || other.minorStepIdx > 1 && this.minorStepIdx > 1) {
      //easy, no need to change stepIdx nor multiplication factor
    } else if (other.minorStepIdx < this.minorStepIdx) {
      //I'm 5, they are 4 per major.
      this.minorStepIdx = 1;
      if (oldStepIdx == 2) {
        increaseMagnitude();
      } else {
        increaseMagnitude();
        increaseMagnitude();
      }
    } else {
      //I'm 4, they are 5 per major
      this.minorStepIdx = 2;
      if (oldStepIdx == 1) {
        decreaseMagnitude();
      } else {
        decreaseMagnitude();
        decreaseMagnitude();
      }
    }

    //Get masters stats:
    var lines = other.getLines();
    var otherZero = other.convertValue(0);
    var otherStep = other.getStep() * other.scale;

    var done = false;
    var count = 0;
    //Loop until magnitude is correct for given constrains.
    while (!done && count++ < 5) {

      //Get my stats:
      this.scale = otherStep / (this.minorSteps[this.minorStepIdx] * this.magnitudefactor);
      var newRange = this.containerHeight / this.scale;

      //For the case the magnitudefactor has changed:
      this._start = oldStart;
      this._end = this._start + newRange;

      var myOriginalZero = this._end * this.scale;
      var majorStep = this.magnitudefactor * this.majorSteps[this.minorStepIdx];
      var majorOffset = this.getFirstMajor() - other.getFirstMajor();

      if (this.zeroAlign) {
        var zeroOffset = otherZero - myOriginalZero;
        this._end += zeroOffset / this.scale;
        this._start = this._end - newRange;
      } else {
        if (!this.autoScaleStart) {
          this._start += majorStep - majorOffset / this.scale;
          this._end = this._start + newRange;
        } else {
          this._start -= majorOffset / this.scale;
          this._end = this._start + newRange;
        }
      }
      if (!this.autoScaleEnd && this._end > oldEnd + 0.00001) {
        //Need to decrease magnitude to prevent scale overshoot! (end)
        decreaseMagnitude();
        done = false;
        continue;
      }
      if (!this.autoScaleStart && this._start < oldStart - 0.00001) {
        if (this.zeroAlign && oldStart >= 0) {
          console.warn("Can't adhere to given 'min' range, due to zeroalign");
        } else {
          //Need to decrease magnitude to prevent scale overshoot! (start)
          decreaseMagnitude();
          done = false;
          continue;
        }
      }
      if (this.autoScaleStart && this.autoScaleEnd && newRange < oldEnd - oldStart) {
        increaseMagnitude();
        done = false;
        continue;
      }
      done = true;
    }
  };

  DataScale.prototype.convertValue = function (value) {
    return this.containerHeight - (value - this._start) * this.scale;
  };

  DataScale.prototype.screenToValue = function (pixels) {
    return (this.containerHeight - pixels) / this.scale + this._start;
  };

  module.exports = DataScale;

/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var _typeof2 = __webpack_require__(62);

  var _typeof3 = _interopRequireDefault(_typeof2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var util = __webpack_require__(1);
  var DOMutil = __webpack_require__(90);
  var Bars = __webpack_require__(149);
  var Lines = __webpack_require__(151);
  var Points = __webpack_require__(150);

  /**
   * /**
   * @param {object} group            | the object of the group from the dataset
   * @param {string} groupId          | ID of the group
   * @param {object} options          | the default options
   * @param {array} groupsUsingDefaultStyles  | this array has one entree.
   *                                            It is passed as an array so it is passed by reference.
   *                                            It enumerates through the default styles
   * @constructor
   */
  function GraphGroup(group, groupId, options, groupsUsingDefaultStyles) {
    this.id = groupId;
    var fields = ['sampling', 'style', 'sort', 'yAxisOrientation', 'barChart', 'drawPoints', 'shaded', 'interpolation', 'zIndex', 'excludeFromStacking', 'excludeFromLegend'];
    this.options = util.selectiveBridgeObject(fields, options);
    this.usingDefaultStyle = group.className === undefined;
    this.groupsUsingDefaultStyles = groupsUsingDefaultStyles;
    this.zeroPosition = 0;
    this.update(group);
    if (this.usingDefaultStyle == true) {
      this.groupsUsingDefaultStyles[0] += 1;
    }
    this.itemsData = [];
    this.visible = group.visible === undefined ? true : group.visible;
  }

  /**
   * this loads a reference to all items in this group into this group.
   * @param {array} items
   */
  GraphGroup.prototype.setItems = function (items) {
    if (items != null) {
      this.itemsData = items;
      if (this.options.sort == true) {
        util.insertSort(this.itemsData, function (a, b) {
          return a.x > b.x ? 1 : -1;
        });
      }
    } else {
      this.itemsData = [];
    }
  };

  GraphGroup.prototype.getItems = function () {
    return this.itemsData;
  };

  /**
   * this is used for barcharts and shading, this way, we only have to calculate it once.
   * @param pos
   */
  GraphGroup.prototype.setZeroPosition = function (pos) {
    this.zeroPosition = pos;
  };

  /**
   * set the options of the graph group over the default options.
   * @param options
   */
  GraphGroup.prototype.setOptions = function (options) {
    if (options !== undefined) {
      var fields = ['sampling', 'style', 'sort', 'yAxisOrientation', 'barChart', 'zIndex', 'excludeFromStacking', 'excludeFromLegend'];
      util.selectiveDeepExtend(fields, this.options, options);

      // if the group's drawPoints is a function delegate the callback to the onRender property
      if (typeof options.drawPoints == 'function') {
        options.drawPoints = {
          onRender: options.drawPoints
        };
      }

      util.mergeOptions(this.options, options, 'interpolation');
      util.mergeOptions(this.options, options, 'drawPoints');
      util.mergeOptions(this.options, options, 'shaded');

      if (options.interpolation) {
        if ((0, _typeof3['default'])(options.interpolation) == 'object') {
          if (options.interpolation.parametrization) {
            if (options.interpolation.parametrization == 'uniform') {
              this.options.interpolation.alpha = 0;
            } else if (options.interpolation.parametrization == 'chordal') {
              this.options.interpolation.alpha = 1.0;
            } else {
              this.options.interpolation.parametrization = 'centripetal';
              this.options.interpolation.alpha = 0.5;
            }
          }
        }
      }
    }
  };

  /**
   * this updates the current group class with the latest group dataset entree, used in _updateGroup in linegraph
   * @param group
   */
  GraphGroup.prototype.update = function (group) {
    this.group = group;
    this.content = group.content || 'graph';
    this.className = group.className || this.className || 'vis-graph-group' + this.groupsUsingDefaultStyles[0] % 10;
    this.visible = group.visible === undefined ? true : group.visible;
    this.style = group.style;
    this.setOptions(group.options);
  };

  /**
   * return the legend entree for this group.
   *
   * @param iconWidth
   * @param iconHeight
   * @returns {{icon: HTMLElement, label: (group.content|*|string), orientation: (.options.yAxisOrientation|*)}}
   */
  GraphGroup.prototype.getLegend = function (iconWidth, iconHeight, framework, x, y) {
    if (framework == undefined || framework == null) {
      var svg = document.createElementNS('http://www.w3.org/2000/svg', "svg");
      framework = { svg: svg, svgElements: {}, options: this.options, groups: [this] };
    }
    if (x == undefined || x == null) {
      x = 0;
    }
    if (y == undefined || y == null) {
      y = 0.5 * iconHeight;
    }
    switch (this.options.style) {
      case "line":
        Lines.drawIcon(this, x, y, iconWidth, iconHeight, framework);
        break;
      case "points": //explicit no break
      case "point":
        Points.drawIcon(this, x, y, iconWidth, iconHeight, framework);
        break;
      case "bar":
        Bars.drawIcon(this, x, y, iconWidth, iconHeight, framework);
        break;
    }
    return { icon: framework.svg, label: this.content, orientation: this.options.yAxisOrientation };
  };

  GraphGroup.prototype.getYRange = function (groupData) {
    var yMin = groupData[0].y;
    var yMax = groupData[0].y;
    for (var j = 0; j < groupData.length; j++) {
      yMin = yMin > groupData[j].y ? groupData[j].y : yMin;
      yMax = yMax < groupData[j].y ? groupData[j].y : yMax;
    }
    return { min: yMin, max: yMax, yAxisOrientation: this.options.yAxisOrientation };
  };

  module.exports = GraphGroup;

/***/ },
/* 149 */
/***/ function(module, exports, __webpack_require__) {

  'use strict';

  var DOMutil = __webpack_require__(90);
  var Points = __webpack_require__(150);

  function Bargraph(groupId, options) {}

  Bargraph.drawIcon = function (group, x, y, iconWidth, iconHeight, framework) {
    var fillHeight = iconHeight * 0.5;
    var path, fillPath;

    var outline = DOMutil.getSVGElement("rect", framework.svgElements, framework.svg);
    outline.setAttributeNS(null, "x", x);
    outline.setAttributeNS(null, "y", y - fillHeight);
    outline.setAttributeNS(null, "width", iconWidth);
    outline.setAttributeNS(null, "height", 2 * fillHeight);
    outline.setAttributeNS(null, "class", "vis-outline");

    var barWidth = Math.round(0.3 * iconWidth);
    var originalWidth = group.options.barChart.width;
    var scale = originalWidth / barWidth;
    var bar1Height = Math.round(0.4 * iconHeight);
    var bar2Height = Math.round(0.75 * iconHeight);

    var offset = Math.round((iconWidth - 2 * barWidth) / 3);

    DOMutil.drawBar(x + 0.5 * barWidth + offset, y + fillHeight - bar1Height - 1, barWidth, bar1Height, group.className + ' vis-bar', framework.svgElements, framework.svg, group.style);
    DOMutil.drawBar(x + 1.5 * barWidth + offset + 2, y + fillHeight - bar2Height - 1, barWidth, bar2Height, group.className + ' vis-bar', framework.svgElements, framework.svg, group.style);

    if (group.options.drawPoints.enabled == true) {
      var groupTemplate = {
        style: group.options.drawPoints.style,
        styles: group.options.drawPoints.styles,
        size: group.options.drawPoints.size / scale,
        className: group.className
      };
      DOMutil.drawPoint(x + 0.5 * barWidth + offset, y + fillHeight - bar1Height - 1, groupTemplate, framework.svgElements, framework.svg);
      DOMutil.drawPoint(x + 1.5 * barWidth + offset + 2, y + fillHeight - bar2Height - 1, groupTemplate, framework.svgElements, framework.svg);
    }
  };

  /**
   * draw a bar graph
   *
   * @param groupIds
   * @param processedGroupData
   */
  Bargraph.draw = function (groupIds, processedGroupData, framework) {
    var combinedData = [];
    var intersections = {};
    var coreDistance;
    var key, drawData;
    var group;
    var i, j;
    var barPoints = 0;

    // combine all barchart data
    for (i = 0; i < groupIds.length; i++) {
      group = framework.groups[groupIds[i]];
      if (group.options.style === 'bar') {
        if (group.visible === true && (framework.options.groups.visibility[groupIds[i]] === undefined || framework.options.groups.visibility[groupIds[i]] === true)) {
          for (j = 0; j < processedGroupData[groupIds[i]].length; j++) {
            combinedData.push({
              screen_x: processedGroupData[groupIds[i]][j].screen_x,
              screen_y: processedGroupData[groupIds[i]][j].screen_y,
              x: processedGroupData[groupIds[i]][j].x,
              y: processedGroupData[groupIds[i]][j].y,
              groupId: groupIds[i],
              label: processedGroupData[groupIds[i]][j].label
            });
            barPoints += 1;
          }
        }
      }
    }

    if (barPoints === 0) {
      return;
    }

    // sort by time and by group
    combinedData.sort(function (a, b) {
      if (a.screen_x === b.screen_x) {
        return a.groupId < b.groupId ? -1 : 1;
      } else {
        return a.screen_x - b.screen_x;
      }
    });

    // get intersections
    Bargraph._getDataIntersections(intersections, combinedData);

    // plot barchart
    for (i = 0; i < combinedData.length; i++) {
      group = framework.groups[combinedData[i].groupId];
      var minWidth = group.options.barChart.minWidth != undefined ? group.options.barChart.minWidth : 0.1 * group.options.barChart.width;

      key = combinedData[i].screen_x;
      var heightOffset = 0;
      if (intersections[key] === undefined) {
        if (i + 1 < combinedData.length) {
          coreDistance = Math.abs(combinedData[i + 1].screen_x - key);
        }
        drawData = Bargraph._getSafeDrawData(coreDistance, group, minWidth);
      } else {
        var nextKey = i + (intersections[key].amount - intersections[key].resolved);
        var prevKey = i - (intersections[key].resolved + 1);
        if (nextKey < combinedData.length) {
          coreDistance = Math.abs(combinedData[nextKey].screen_x - key);
        }
        drawData = Bargraph._getSafeDrawData(coreDistance, group, minWidth);
        intersections[key].resolved += 1;

        if (group.options.stack === true && group.options.excludeFromStacking !== true) {
          if (combinedData[i].screen_y < group.zeroPosition) {
            heightOffset = intersections[key].accumulatedNegative;
            intersections[key].accumulatedNegative += group.zeroPosition - combinedData[i].screen_y;
          } else {
            heightOffset = intersections[key].accumulatedPositive;
            intersections[key].accumulatedPositive += group.zeroPosition - combinedData[i].screen_y;
          }
        } else if (group.options.barChart.sideBySide === true) {
          drawData.width = drawData.width / intersections[key].amount;
          drawData.offset += intersections[key].resolved * drawData.width - 0.5 * drawData.width * (intersections[key].amount + 1);
        }
      }
      DOMutil.drawBar(combinedData[i].screen_x + drawData.offset, combinedData[i].screen_y - heightOffset, drawData.width, group.zeroPosition - combinedData[i].screen_y, group.className + ' vis-bar', framework.svgElements, framework.svg, group.style);
      // draw points
      if (group.options.drawPoints.enabled === true) {
        var pointData = {
          screen_x: combinedData[i].screen_x,
          screen_y: combinedData[i].screen_y - heightOffset,
          x: combinedData[i].x,
          y: combinedData[i].y,
          groupId: combinedData[i].groupId,
          label: combinedData[i].label
        };
        Points.draw([pointData], group, framework, drawData.offset);
        //DOMutil.drawPoint(combinedData[i].x + drawData.offset, combinedData[i].y, group, framework.svgElements, framework.svg);
      }
    }
  };

  /**
   * Fill the intersections object with counters of how many datapoints share the same x coordinates
   * @param intersections
   * @param combinedData
   * @private
   */
  Bargraph._getDataIntersections = function (intersections, combinedData) {
    // get intersections
    var coreDistance;
    for (var i = 0; i < combinedData.length; i++) {
      if (i + 1 < combinedData.length) {
        coreDistance = Math.abs(combinedData[i + 1].screen_x - combinedData[i].screen_x);
      }
      if (i > 0) {
        coreDistance = Math.min(coreDistance, Math.abs(combinedData[i - 1].screen_x - combinedData[i].screen_x));
      }
      if (coreDistance === 0) {
        if (intersections[combinedData[i].screen_x] === undefined) {
          intersections[combinedData[i].screen_x] = {
            amount: 0,
            resolved: 0,
            accumulatedPositive: 0,
            accumulatedNegative: 0
          };
        }
        intersections[combinedData[i].screen_x].amount += 1;
      }
    }
  };

  /**
   * Get the width and offset for bargraphs based on the coredistance between datapoints
   *
   * @param coreDistance
   * @param group
   * @param minWidth
   * @returns {{width: Number, offset: Number}}
   * @private
   */
  Bargraph._getSafeDrawData = function (coreDistance, group, minWidth) {
    var width, offset;
    if (coreDistance < group.options.barChart.width && coreDistance > 0) {
      width = coreDistance < minWidth ? minWidth : coreDistance;

      offset = 0; // recalculate offset with the new width;
      if (group.options.barChart.align === 'left') {
        offset -= 0.5 * coreDistance;
      } else if (group.options.barChart.align === 'right') {
        offset += 0.5 * coreDistance;
      }
    } else {
      // default settings
      width = group.options.barChart.width;
      offset = 0;
      if (group.options.barChart.align === 'left') {
        offset -= 0.5 * group.options.barChart.width;
      } else if (group.options.barChart.align === 'right') {
        offset += 0.5 * group.options.barChart.width;
      }
    }

    return { width: width, offset: offset };
  };

  Bargraph.getStackedYRange = function (combinedData, groupRanges, groupIds, groupLabel, orientation) {
    if (combinedData.length > 0) {
      // sort by time and by group
      combinedData.sort(function (a, b) {
        if (a.screen_x === b.screen_x) {
          return a.groupId < b.groupId ? -1 : 1;
        } else {
          return a.screen_x - b.screen_x;
        }
      });
      var intersections = {};

      Bargraph._getDataIntersections(intersections, combinedData);
      groupRanges[groupLabel] = Bargraph._getStackedYRange(intersections, combinedData);
      groupRanges[groupLabel].yAxisOrientation = orientation;
      grou