<?php
// This file is part of Exabis Eportfolio (extension for Moodle)
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
// (c) 2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>.

return [
    'translation:language' => [
        'German',
        'English',
    ],
    'translation:person' => [
        'Andreas Riepl',
        'Andreas Riepl',
    ],
    'translation:organisation' => [
        'GTN GmbH',
        'GTN GmbH',
    ],
    'translation:email' => [
        'ariepl.work@gmail.com',
        'ariepl.work@gmail.com',
    ],

    // === Main ===
    // Shown in admin plugin list.
    'pluginname' => [
        'Exabis ePortfolio',
        'Exabis ePortfolio',
    ],
    // === Shown in block title and all headers.
    'blocktitle' => [
        'Exabis ePortfolio',
        'Exabis ePortfolio',
    ],
    'exaport:use' => [
        'Nutzung',
        'Use allowed',
    ],
    'exaport:addinstance' => [
        'Exabis ePortfolio zum Kurs hinzuf&uumlgen',
        'add Exabis ePortfolio to the course',
    ],
    'exaport:myaddinstance' => [
        'Exabis ePortfolie zur Startseite hinzuf&uumlgen',
        'add Exabis ePortfolio on My home',
    ],
    'exaport:export' => [
        'Export von SCORM-Files',
        'Export of SCORM-Files',
    ],
    'exaport:import' => [
        'Import von SCORM-Files',
        'Import of SCORM-Files',
    ],
    'exaport:importfrommoodle' => [
        'Import von Moodle',
        'Import from Moodle',
    ],
    'exaport:shareintern' => [
        'Internes Teilen von Views',
        'Internal sharing of views',
    ],
    'exaport:shareextern' => [
        'Externes Teilen von Views',
        'External sharing of views',
    ],
    'exaport:allowposts' => [
        'Kommentare erlauben',
        'Allow posting',
    ],
    'exaport:competences' => [
        'Kompetenzen erlauben',
        'Allow competences',
    ],
    'exaport:viewartifactsfromstudents' => [
        'Portfolio Artefakte der eigenen SuS sehen',
        'Can see portfolio artefacts of own students',
    ],
    'new' => [
        'Neu',
        'New',
    ],
    'addbookmark' => [
        'Bookmark hinzufügen',
        'Add bookmark',
    ],
    'addcategory' => [
        'Kategorie hinzufügen',
        'Add category',
    ],
    'attachment' => [
        'Anhang',
        'attachment',
    ],
    'attachincluded' => [
        'Anhang?',
        'attachment?',
    ],
    'awaiting' => [
        '(\\$a wartend)',
        '($a awaiting)',
    ],
    'back' => [
        'zurück',
        'Back',
    ],
    'close' => [
        'Schließen',
        'close',
    ],
    'backtocourse' => [
        'zurück zum Kurs',
        'Back to course',
    ],
    'categories' => [
        'Kategorien',
        'Categories',
    ],
    'explaincategories' => [
        '<span class=\'block_eportfolio_bold\'>Kategorien:</span> hier kannst du die Kategorien einsehen und bearbeiten.',
        'Categories: here you can create and modify categories',
    ],
    'category' => [
        'Kategorie',
        'Category',
    ],
    'categoryhead' => [
        'Bezeichnung der Kategorie',
        'Category name',
    ],
    'categorysaved' => [
        'Kategorie hinzugefügt.',
        'Category added.',
    ],
    'categoryedited' => [
        'Kategorie gespeichert.',
        'Category saved.',
    ],
    'categorydeleted' => [
        'Kategorie gel&ouml;scht.',
        'Category deleted.',
    ],
    'date' => [
        'Datum',
        'Date',
    ],
    'dontincludeurl' => [
        'Diese Option ausw&auml;hlen um die Verknüpfung zwischen Bookmark und URL aufzuheben',
        'Check this box to unassociate the bookmark with the URL',
    ],
    'duplicatedurl' => [
        'Diese URL ist bereits bei den Bookmarks vorhanden.',
        'You already have this URL bookmarked.',
    ],
    'editcategories' => [
        'Kategorien bearbeiten',
        'edit categories',
    ],
    'explaining' => [
        'Das ePortfolio-System kann verwendet werden um Webadressen, Dateien, Notizen und Kommentare zu verwalten.',
        'The Portfolio can be used to store web addresses, files, and notes, allowing users to jot down insights or brief comments',
    ],
    'explainingmoredata' => [
        '<strong>Dies ist dein Bereich, um Belege für deinen Lernweg zu sammeln.</strong>
			<ul>
				<li><strong>Füge deine besten Arbeiten hinzu:</strong> Lade Dateien, Weblinks oder Beschreibungen von Projekten, Präsentationen und mehr hoch.</li>
				<li><strong>Reflektiere über deine Erfahrungen:</strong> Erkläre, was du gelernt hast, welche Herausforderungen du bewältigt hast und deine Erfolge für jeden Eintrag.</li>
			</ul>
			<strong>Betrachte jeden Eintrag als eine Art Geschichte, die deine Fähigkeiten und dein Wissen beschreibt.</strong>',
        '<strong>This is your space to gather evidence of your learning journey.</strong>
            <ul>
                <li><strong>Add your best work:</strong> Upload files, web links, or descriptions of projects, presentations, and more.</li>
                <li><strong>Reflect on your experiences:</strong> Explain what you learned, the challenges you faced, and your achievements for each piece.</li>
            </ul>
            <strong>Think of each item as a story highlighting your skills and knowledge.</strong>',
    ],
    'explaininglink' => [
        '<span class=\'block_eportfolio_bold\'>Externe Links:</span> diese Links k&ouml;nnen mit anderen Kursteilnehmer:innen ausgetauscht werden.',
        'Links.  These links may be shared with all authorized course members.',
    ],
    'explainingfile' => [
        '<span class=\'block_eportfolio_bold\'>Dateien:</span> diese Dateien k&ouml;nnen mit anderen Kursteilnehmer:innen ausgetauscht werden.',
        'Files. These files may be shared with all authorized course members.',
    ],
    'explainingnote' => [
        '<span class=\'block_eportfolio_bold\'>Notizen:</span> diese Notizen k&ouml;nnen mit anderen Kursteilnehmer:innen ausgetauscht werden.',
        'Notes. These notes may be shared with all authorized course members.',
    ],
    'explainingshare' => [
        'Um einem/einer anderen Teilnehmer:in den Link zu ver&ouml;ffentlichen, klicke auf den jeweiligen Namen und speichere dann die &Auml;nderungen.  Du kannst mehr als eine/n Teilnehmer:in ausw&auml;hlen.',
        'To allow a participant to see the link, click on their name and then click on Save Changes. You can choose more than one participant.',
    ],
    'explainingshared' => [
        'Folgende Teilnehmer:innen haben ver&ouml;ffentlichte Links, Dateien bzw. Notizen.',
        'These participants have shared some of their external links, files or notes.',
    ],
    'explainingsharefile' => [
        'Um einem/einer anderen Teilnehmer:in die Datei zu ver&ouml;ffentlichen, klicke auf den jeweiligen Namen und speichere dann die &Auml;nderungen.  Du kannst mehr als eine/n Teilnehmer:in ausw&auml;hlen.',
        'To allow a participant to see the file, click on their name and then click on Save Changes.  You can choose more than one participant.',
    ],
    'explainingsharenote' => [
        'Um einem/einer anderen Teilnehmer:in die Notiz zu ver&ouml;ffentlichen, klicke auf den jeweiligen Namen und speichere dann die &Auml;nderungen.  Du kannst mehr als eine/n Teilnehmer:in ausw&auml;hlen.',
        'To allow a participant to see the note, click on their name and then click on Save Changes.  You can choose more than one participant.',
    ],
    'file' => [
        'Datei',
        'File',
    ],
    'iconfile' => [
        'Miniaturansicht',
        'Thumbnail',
    ],
    'iconfile_merge' => [
        'Symbol mit Ordner-Symbol kombinieren',
        'Merge this icon picture with the folder icon',
    ],
    'iconfile_merge_description' => [
        'Symbolbild verknüpft sich mit dem Ordner-Symbol.',
        'Icon picture will try (without any guarantee) to merge with standard folder icon. The icon will be replaced with the new image.',
    ],
    'firstnameshared' => [
        'Familienname',
        'First Name',
    ],
    'go' => [
        'Go!',
        'Go!',
    ],
    'hidesummary' => [
        '(Gesamtaufstellung ausblenden)',
        '(hide summary)',
    ],
    'managecategories' => [
        'Kategorien verwalten',
        'Manage categories',
    ],
    'mandatoryfields' => [
        'Eine Kategorienbezeichnung und eine kurze Beschreibung ist erforderlich. Bitte fülle beides aus.',
        'The field\'s name, category and intro are required. Please fill them in.',
    ],
    'mandatoryfieldsforcat' => [
        'Eine Feldbezeichnung ist erforderlich. Bitte fülle diese aus.',
        'The field name is required. Please fill them in.',
    ],
    'myportfolio' => [
        'Meine Portfolio Artefakte',
        'My Portfolio Artefacts',
    ],
    'myportfoliotitle' => [
        'ePortfolio-Modul: Füge hier Links und Dateien hinzu.',
        'Exabis ePortfolio module: Add your links and files here.',
    ],
    'newlink' => [
        'Neuen externen Link hinzufügen',
        'Add new link',
    ],
    'newfile' => [
        'Neue Datei hinzufügen',
        'Add new file',
    ],
    'newnote' => [
        'Neue Notiz hinzufügen',
        'Add new note',
    ],
    'nocategories' => [
        '(bisher gibt es noch keine Kategorien)',
        '(no categories yet)',
    ],
    'nobookmarksall' => [
        '(bisher gibt es noch keine Eintr&auml;ge)',
        '(no items yet)',
    ],
    'nobookmarkslink' => [
        '(bisher gibt es noch keine Links)',
        '(no links yet)',
    ],
    'nobookmarksfile' => [
        '(bisher gibt es noch keine Dateien)',
        '(no files yet)',
    ],
    'nobookmarksnote' => [
        '(bisher gibt es noch keine Notizen)',
        '(no notes yet)',
    ],
    'noentry' => [
        'Kein Eintrag',
        'No entry',
    ],
    'note' => [
        'Notiz',
        'Note',
    ],
    'notetitle' => [
        'Notiz',
        'Note',
    ],
    'shared_views' => [
        'Geteilte Views',
        'Shared Views',
    ],
    'showall' => [
        'auch andere Kurse anzeigen',
        'Show Other Courses Too',
    ],
    'showcourse' => [
        'nur diesen Kurs anzeigen',
        'Show This Course Only',
    ],
    'showsummary' => [
        '(Gesamtaufstellung einblenden)',
        '(show summary)',
    ],
    'strshare' => [
        'Ver&ouml;ffentlichen',
        'Share',
    ],
    'strunshare' => [
        'Ver&ouml;ffentlichung zurücknehmen',
        'Unshare',
    ],
    'summary' => [
        'Gesamtaufstellung (optional)',
        'Summary (optional)',
    ],
    'url' => [
        'URL',
        'URL',
    ],
    'maincategory' => [
        'Hauptkategorie',
        'Main category',
    ],
    'subcategory' => [
        'Unterkategorie',
        'Sub category',
    ],
    'accessoptions' => [
        'Wer hat Zugriff?',
        'Who has access?',
    ],
    'shareallexceptthose' => [
        'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span> (auch jene, die hier nicht angezeigt werden) au&szlig;er folgenden Benutzern',
        'Access for <span class=\'block_eportfolio_bold\'>all</span> (even those who aren\'t listed here) except the following users',
    ],
    'sharenoneexceptthose' => [
        'Zugriff für <span class=\'block_eportfolio_bold\'>keine</span> au&szlig;er folgende Benutzer',
        'Access for <span class=\'block_eportfolio_bold\'>nobody</span> except the following users',
    ],
    'internalaccessall' => [
        'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span>',
        'Access for <span class=\'block_eportfolio_bold\'>all</span>',
    ],
    'internalaccessusers' => [
        'Zugriff nur für folgende Benutzer',
        'Access only for the following users',
    ],
    'internalaccessgroups' => [
        'Zugriff für folgende Gruppen',
        'Access only for the following groups',
    ],
    'externaccess' => [
        'externer ePortfolio-Link',
        'external ePortfolio-Link',
    ],
    'emailaccess' => [
        'Per Email teilen',
        'Share by Email',
    ],
    'emailaccessdescription' => [
        'Gib eine Email Adresse pro Zeile ein<br />Jede Adresse erhält einen eindeutigen Link mit Zugriff auf diese View. Das Löschen der Adresse löscht den Zugriff auf diese View.',
        'Input an email address per line<br />Each email will receive a unique link with access to this view. Deleting the email will remove access to this view.',
    ],
    'emailaccessmessagesubject' => [
        'Ein ePortfolio wurde mit dir geteilt',
        'New shared View for you',
    ],
    'emailaccessmessage' => [
        'Hallo! {$a->sendername} hat das ePortfolio "{$a->viewname}" mit dir geteilt. Es kann hier abgerufen werden: {$a->url}',
        'Hello! {$a->sendername} has shared the view "{$a->viewname}" for you. You can view it here: {$a->url}',
    ],
    'emailaccessmessageHTML' => [
        'Hallo!<br />{$a->sendername} hat das ePortfolio "{$a->viewname}" mit dir geteilt.<br />Sie ist kann <a href="{$a->url}">hier</a> aberufen werden',
        'Hello!<br />{$a->sendername} has shared the view "{$a->viewname}" for you.<br />You can view it <a href="{$a->url}">here</a>.',
    ],

    // 'emailaccessmessagesubject_updatedview' => [
    //     'Ich habe ein Eportfolio aktualisiert, welches ich mit Ihnen geteilt habe',
    //     'I updated an eportfolio view I shared with you',
    // ],
    'emailaccessmessagesubject_updatedview' => [
        '{$a->sendername} hat Änderungen an einem E-Portfolio vorgenommen, das mit Ihnen geteilt ist.',
        '{$a->sendername} made changes to an e-portfolio view shared with you.',
    ],
    'emailaccessmessage_updatedview' => [
        'Hallo! {$a->sendername} hat das ePortfolio "{$a->viewname}", welches er mit dir geteilt hat, aktualisiert. Es kann hier abgerufen werden: {$a->url}',
        'Hello! {$a->sendername} has updated the view "{$a->viewname}" they shared with you. You can view it here: {$a->url}',
    ],
    'emailaccessmessageHTML_updatedview' => [
        'Hallo!<br />{$a->sendername} hat das ePortfolio "{$a->viewname}", welches er mit dir geteilt hat, aktualisiert.<br />Sie ist kann <a href="{$a->url}">hier</a> aberufen werden',
        'Hello!<br />{$a->sendername} has updated the view "{$a->viewname}" they shared with you.<br />You can view it <a href="{$a->url}">here</a>.',
    ],

    'showallusers' => [
        'Zeige Benutzer aller meiner Kurse',
        'Show users of all my courses',
    ],
    'showcourseusers' => [
        'Zeige nur Benutzer des aktuellen Kurses',
        'Show only users of the course',
    ],
    'sharedpersons' => [
        'Personen mit ver&ouml;ffentlichten Portfolios',
        'Persons with shared Portfolios',
    ],
    'moodleimport' => [
        'Import aus Moodle-Aufgaben',
        'Import from Moodle-assignments',
    ],
    'nomoodleimportyet' => [
        'Im Moment sind noch keine Abgaben vorhanden!',
        'At the moment you have no submission at any assignment!',
    ],
    'deletecategoryconfirm' => [
        'Willst du die Kategorie "{$a->name}" wirklich l&ouml;schen? Es werden alle Eintr&auml;ge in dieser Kategorie und alle Unterkategorien mitgel&ouml;scht!',
        'Do you really want to delete the category "{$a->name}"? All entries in this category and all subcategories will be deleted!',
    ],
    'name' => [
        'Name',
        'Name',
    ],
    'role' => [
        'Rolle',
        'Role',
    ],
    'nousersfound' => [
        'Keine Benutzer gefunden',
        'No users found',
    ],
    'delete' => [
        'L&ouml;schen',
        'Delete',
    ],
    'add' => [
        'Hinzufügen',
        'Add',
    ],
    'edit' => [
        'Editieren',
        'Edit',
    ],
    'checkall' => [
        'Alle auswählen',
        'Check all',
    ],
    'grouptitle' => [
        'Gruppentitel',
        'Group title',
    ],
    'membercount' => [
        'Anzahl von Mitgliedern',
        'Number of members',
    ],
    'nogroupsfound' => [
        'Keine Gruppen gefunden',
        'No groups found',
    ],
    'make_it_yours' => [
        'Mach\' es zu deinem Eigenen',
        'Make it yours',
    ],

    // === Export/import.
    'import' => [
        'Import SCORM-Datei',
        'Import SCORM-File',
    ],
    'import_short' => [
        'Import',
        'Import',
    ],
    'explainexport' => [
        '<span class=\'block_eportfolio_center\'><span class=\'block_eportfolio_bold\'>Export:</span> hier kannst du dein ePortfolio exportieren</span>',
        'Export your portfolio here.',
    ],
    'createexport' => [
        'SCORM-Datei erstellen',
        'Create SCORM-File',
    ],
    'createexportxapi' => [
        'XAPI-Datei erstellen',
        'Create XAPI-File',
    ],
    'clicktodownloadscorm' => [
        'Folgenden Button drücken, um SCORM-Datei herunterzuladen:',
        'Press button to download the SCORM file:',
    ],
    'add_directory_structure' => [
        'Mit Unterverzeichnissen exportieren',
        'Add directory-structure',
    ],
    'download' => [
        'Herunterladen',
        'Download',
    ],
    'endedit' => [
        'Editieren beenden',
        'End editing',
    ],
    'change' => [
        '&auml;ndern',
        'Change',
    ],
    'explainpersonal' => [
        '<span class=\'block_eportfolio_bold\'>Pers&ouml;nliche Informationen</span>',
        'Personal information',
    ],
    'personal' => [
        'Informationen',
        'Information',
    ],
    'descriptionsaved' => [
        'Beschreibung gespeichert',
        'description saved',
    ],
    'course' => [
        'Kurs',
        'Course',
    ],
    'importexport' => [
        'Import/Export',
        'Import/Export',
    ],
    'explainimport' => [
        'hier kannst du SCORM-Dateien ins Portfolio importieren. Wenn Marker gefunden werden, die darauf hinweisen, dass diese SCORM-Datei zuvor aus dem Portfolio-Modul exportiert wurde, so wird versucht, die Struktur entsprechend zu importieren.',
        'Here you can import a SCORM-File into the portfolio. If markers from previous exports are found the import tries to import the data in the existing filestructure.',
    ],
    'makeimport' => [
        'Import',
        'Import',
    ],
    'add_this_file' => [
        'Diese Datei hinzufügen',
        'add this file',
    ],
    'bookmarksall' => [
        'Alle Eintr&auml;ge',
        'All Items',
    ],
    'bookmarkslinks' => [
        'Links',
        'Links',
    ],
    'bookmarksfiles' => [
        'Dateien',
        'Files',
    ],
    'bookmarksnotes' => [
        'Notizen',
        'Notes',
    ],
    'noguestpost' => [
        'G&auml;ste haben hier keinen Zugriff!',
        'Guests don\'t have access here!',
    ],
    'comments' => [
        'Kommentare',
        'Comments',
    ],
    'addcomment' => [
        'Kommentar hinzufügen',
        'Add comment',
    ],
    'externcomment' => [
        'Kommentare mitver&ouml;ffentlichen',
        'Share comments in external portfolio',
    ],
    'itemgrading' => [
        'Beurteilung',
        'Grading',
    ],
    'gradeitem' => [
        'Abgabe beurteilen',
        'Grade the item',
    ],
    'submititem' => [
        'Abgeben',
        'Submit',
    ],
    'saveitem' => [
        'Speichern',
        'Save',
    ],

    // === Notes.
    'deletenoteconfirm' => [
        'Möchtest du diese Notiz wirklich l&ouml;schen?',
        'Do you really want to delete this note?',
    ],
    'deletelinkconfirm' => [
        'Möchtest du diesen Link wirklich l&ouml;schen?',
        'Do you really want to delete this link?',
    ],
    'deletefileconfirm' => [
        'Möchtest du diese Datei wirklich l&ouml;schen?',
        'Do you really want to delete this file?',
    ],

    // === Different.
    'couldninsertcomment' => [
        'Kommentar konnte nicht eingefügt werden!',
        'Couldn\'t insert comment!',
    ],
    'importedcommentsstart' => [
        'Importierte Kommentare:<br /><br />',
        'Imported comments:<br /><br />',
    ],
    'importedcommentsend' => [
        'Ende importierte Kommentare',
        'End of imported comments',
    ],
    'filetypenotdetected' => [
        'Filetyp von $a->filename ($a->title) konnte nicht ermittelt werden. Datei wurde nicht importiert!',
        'Filetype of $a->filename ($a->title) could not be detected. File not imported!',
    ],
    'linkedfilenotfound' => [
        'Datei $a->filename in $a->url ($a->title) wurde nicht gefunden. Datei wurde nicht importiert!',
        'File $a->filename in $a->url ($a->title) was not found. File not imported!',
    ],
    'couldntinsert' => [
        'Konnte $a nicht in der Datenbank einfügen',
        'Couldn\'t insert $a into database',
    ],
    'couldntcreatedirectory' => [
        'Verzeichnis konnte nicht erstellt werden',
        'Couldn\'t create directory',
    ],
    'couldntcopyfile' => [
        'Konnte Datei $a nicht kopieren! Datei wurde nicht importiert!',
        'Couldn\'t copy file for $a! File not imported.',
    ],
    'success' => [
        'Datei erfolgreich importiert',
        'File imported successful',
    ],
    'couldntinsertcategory' => [
        'Kategorie konnte nicht eingefügt werden!',
        'Could not insert category!',
    ],
    'couldntupdatecategory' => [
        'Kategorie konnte nicht aktualisiert werden!',
        'Could not update category!',
    ],
    'couldntextractscormfile' => [
        'SCORM-Datei konnte nicht extrahiert werden!',
        'Couldn\'t extract SCORM-file!',
    ],
    'couldntcreatetempdir' => [
        'Tempor&auml;res Verzeichnis konnte nicht erstellt werden.!',
        'Couldn\'t create temporary directory!',
    ],
    'scormhastobezip' => [
        'SCORM-Datei muss im zip-Format vorliegen!',
        'SCORM-File has to be a .zip-File',
    ],
    'uploadfailed' => [
        'Upload nicht erfolgreich!',
        'Upload failed.',
    ],
    'couldntupdatedesc' => [
        'Beschreibung konnte nicht aktualisiert werden!',
        'Could not update your description!',
    ],
    'couldntinsertdesc' => [
        'Beschreibung konnte nicht eingefügt werden!',
        'Could not insert the description!',
    ],
    'exportcomment' => [
        'Das ist eine exportierte Datei von exabis ePortfolio. Bitte entferne die Kommentare nicht, da sie sonst nicht mehr mitimportiert werden k&ouml;nnen!',
        'This is an exported file from Exabis ePortfolio. Please do not remove the comments, they are needed for the import!',
    ],
    'comment' => [
        'Kommentar',
        'Comment',
    ],
    'commentshouldnotbeempty' => [
        'Der Kommentar darf nicht leer sein.',
        'You have to enter a comment.',
    ],
    'title' => [
        'Titel',
        'Title',
    ],
    'titlenotemtpy' => [
        'Der Titel darf nicht leer sein.',
        'You have to enter a title.',
    ],
    'intro' => [
        'Inhalt',
        'Content',
    ],
    'shortdescription' => [
        'Kurzbeschreibung',
        'Short description',
    ],
    'project_description' => [
        'Der Grund hinter diesem Projekt',
        'The why behind this project',
    ],
    'project_process' => [
        'Umsetzung des Projekts',
        'Making it happen',
    ],
    'project_result' => [
        'Ergebnisse und Erkenntnisse',
        'Results and learnings',
    ],
    'intronotempty' => [
        'Der Inhalt darf nicht leer sein.',
        'You have to enter a content.',
    ],
    'link' => [
        'Link',
        'Link',
    ],
    'mixed' => [
        'Artefakte',
        'Artefact',
    ],
    'add_mixed' => [
        'Neue Artefakte',
        'Add new artefact',
    ],
    'categorynotempty' => [
        'Es muss eine Kategorie ausgew&auml;hlt sein.',
        'You have to choose a category.',
    ],
    'urlnotempty' => [
        'Die URL darf nicht leer sein.',
        'You have to enter an URL.',
    ],
    'selectall' => [
        'Alle markieren',
        'Select All',
    ],
    'deselectall' => [
        'Alle Markierungen l&ouml;schen',
        'Deselect All',
    ],
    'internalaccess' => [
        'Interner Zugriff',
        'Internal Access',
    ],
    'externalaccess' => [
        'Externer Zugriff',
        'External Access',
    ],
    'loginasmode' => [
        'Du hast als Administrator keine Zugriff auf fremde Portfolios',
        'You can\'t access portfolios in \'Login As\'-Mode.',
    ],
    'badsessionkey' => [
        'Session nicht mehr gültig',
        'Bad Session Key',
    ],
    'invalidinstance' => [
        'Ungültige Instanz',
        'That\'s an invalid instance',
    ],
    'invalidcourseid' => [
        'Ungültige Kursnummer',
        'That\'s an invalid course id',
    ],
    'wronglinkid' => [
        'Falsche Link-Id',
        'Wrong link id',
    ],
    'incorrectlinksid' => [
        'Falsche Links-Post Id',
        'Incorrect links post id',
    ],
    'incorrectnoteid' => [
        'Falsche Notizen Id',
        'Incorrect note id',
    ],
    'unknownaction' => [
        'Unbekannte Aktion',
        'Unknown action',
    ],
    'filenotfound' => [
        'Datei nicht gefunden',
        'File not found',
    ],
    'wrongfileid' => [
        'Falsche Datei Id',
        'Wrong file id',
    ],
    'wrongfilepostid' => [
        'Falsche Datei-Post Id',
        'Wrong file id',
    ],
    'wrongnoteid' => [
        'Falsche Notiz Id',
        'Wrong note id',
    ],
    'wrongnotepostid' => [
        'Falsche Notiz-Post Id',
        'Wrong note postbid',
    ],
    'bookmarknotfound' => [
        'Bookmark nicht gefunden',
        'Bookmark not found',
    ],
    'commentnotfound' => [
        'Kommentar nicht gefunden',
        'Comment not found',
    ],
    'updateposterror' => [
        'Posting konnte in Datenbank nicht aktualisiert werden',
        'There was an error updating this post in the database',
    ],
    'deleteposterror' => [
        'Fehler beim L&ouml;schen des Postings',
        'Error occured while deleting post',
    ],
    'addposterror' => [
        'Posting konnte in Datenbank nicht hinzugefügt werden',
        'There was an error adding this post in the database',
    ],
    'invalidassignmentid' => [
        'Falsche Abgabe-Id',
        'Invalid assignment id',
    ],
    'invalidfileatthisassignment' => [
        'Datei existiert nicht zu dieser Abgabe!',
        'File does not exist at this assignment!',
    ],
    'publishedportfolios' => [
        'Ver&ouml;ffentliche Portfolios',
        'Published portfolios',
    ],
    'viewcategories' => [
        'Kategorien verwalten',
        'manage categories',
    ],
    'updownarrow' => [
        'Pfeil nach oben/nach unten',
        'updown arrow',
    ],
    'comment_delete_confirmation' => [
        'Willst du wirklich diesen Kommentar löschen?',
        'Do you really want to delete this comment?',
    ],

    // Shared portfolios.
    'nocoursetogether' => [
        'Kein Kurs',
        'No Course',
    ],
    'nothingshared' => [
        'Kein freigegebenen ePortfolios gefunden',
        'Nobody is sharing a portfolio with you',
    ],

    // === Errors.
    'nouserforid' => [
        'Kein Benutzer zu dieser Id!',
        'User not found (id unknown)',
    ],
    'nouserforaccess' => [
        'Benutzer nicht gefunden (Zugriffscode unbekannt)',
        'User not found (access-code unknown)',
    ],

    // === Export.
    'export' => [
        'Export SCORM-Datei',
        'Export SCORM-File',
    ],
    'export_short' => [
        'Export',
        'Export',
    ],
    'exportepx' => [
        'Export EPX-Datei',
        'Export EPX-File',
    ],
    'createepxexport' => [
        'EPX-Datei erstellen',
        'Create EPX-File',
    ],
    'exportviewselect' => [
        'Um alle Einträge einer bestimmten View zu exportieren, bitte diese hier w&auml;hlen',
        'To export all items of a specific view, please select it here',
    ],
    'export_directory' => [
        'Exportiere Ordnerstruktur',
        'Export Directory-structure',
    ],
    'createexport_directory' => [
        'Erstelle Ordnerstruktur',
        'Create Directory-structure',
    ],

    // === Stuff.
    'type' => [
        'Typ',
        'Type',
    ],
    'share' => [
        'Share',
        'Share',
    ],
    'explainingall' => [
        'Alle Eintr&auml;ge im Portfolio',
        'All Items in your portfolio',
    ],
    'share_to_other_users' => [
        'Benutzer suchen',
        'Search Users',
    ],
    'other_users_course' => [
        'Benutzer, die nicht in meinen Kursen sind',
        'Users not in my courses',
    ],
    'other_groups_course' => [
        'Andere Kurse',
        'Other courses',
    ],

    // === Item sorting.
    'userdefinedsort' => [
        'Eigene Sortierung vornehmen',
        'Define your own search',
    ],
    'movetop' => [
        'An erste Stelle',
        'Move top',
    ],
    'movebottom' => [
        'An letzte Stelle',
        'Move bottom',
    ],

    // === Views.
    'view' => [
        'View',
        'View',
    ],
    'views' => [
        'Meine Views',
        'My Views',
    ],
    'explainingviews' => [
        'View verwalten',
        'Manage your views.',
    ],
    'noviews' => [
        'Bitte Views anlegen',
        'Please create a new View',
    ],
    'viewnotfound' => [
        'Das Objekt ist für den Benutzer nicht einsehbar / Keine Zugriffsberechtigung.',
        'View not found',
    ],
    'newview' => [
        'Neue View erstellen',
        'Add View',
    ],
    'viewinformation' => [
        'View Informationen',
        'View Information',
    ],
    'viewdescription' => [
        'Beschreibung',
        'description',
    ],
    'viewdesign' => [
        'View Darstellung',
        'View Design',
    ],
    'viewitems' => [
        'Deine Eintr&auml;ge',
        'Your Items',
    ],
    'viewitem' => [
        'Eintrag',
        'Item',
    ],
    'view_specialitems' => [
        'Spezielle Eintr&auml;ge',
        'Special Items',
    ],
    'view_specialitem_headline' => [
        'Kopfzeile',
        'Headline',
    ],
    'view_specialitem_personal' => [
        'Persönliche Information',
        'Personal information',
    ],
    'view_specialitem_text' => [
        'Text',
        'Text',
    ],
    'view_specialitem_text_help' => [
        'Der Block mit individuellem Text. Du kannst den Text nach Belieben formatieren.',
        'The block with custom text. You can format the text as you need',
    ],
    'view_specialitem_media' => [
        'Medieneintrag',
        'Media',
    ],
    'view_specialitem_badge' => [
        'Badge',
        'Badge',
    ],
    'view_specialitem_headline_defaulttext' => [
        'Kopfzeile hier eingeben',
        'Enter Headline Here',
    ],
    'view_specialitem_text_defaulttext' => [
        'Text hier eingeben',
        'Enter Text Here',
    ],
    'view_sharing' => [
        'Ver&ouml;ffentlichen',
        'Sharing',
    ],
    'viewand' => [
        'und',
        'and',
    ],
    'view_sharing_noaccess' => [
        'Kein Zugriff',
        'No Access',
    ],
    'show' => [
        'Anzeigen',
        'Show',
    ],
    'thiscourse' => [
        'Aktueller Kurs',
        'This course',
    ],
    'othercourses' => [
        'Andere Kurse',
        'other courses',
    ],
    'autofillview' => [
        'Alle bestehenden Artefakte in diese View einfügen',
        'Automatically add all available artefacts to this view',
    ],
    'sharetoteacher' => [
        'Sofort mit allen Kurs-Trainer/:innen teilen',
        'Share to all teachers in this course',
    ],
    'createpage' => [
        'Zieh das Elemente in das Feld unterhalb, um deinen Inhalt zu erstellen.',
        'Drag and drop content blocks from the tabs below to create your page.',
    ],
    'chooselayout' => [
        'W&aumlhle ein Layout für deinen View.',
        'Select how you would like the columns in your page to be laid out.',
    ],
    'viewtitle' => [
        'Titel und Beschreibung',
        'Title and description',
    ],
    'viewcontent' => [
        'Inhalt',
        'Content',
    ],
    'viewlayout' => [
        'Layout',
        'Layout',
    ],
    'viewshare' => [
        'Teilen',
        'Share',
    ],
    'viewlayoutgroup1' => [
        '1 Spalte',
        '1 column',
    ],
    'viewlayoutgroup2' => [
        '2 Spalten',
        '2 columns',
    ],
    'viewlayoutgroup3' => [
        '3 Spalten',
        '3 columns',
    ],
    'viewlayoutgroup4' => [
        '4 Spalten',
        '4 columns',
    ],
    'viewlayoutgroup5' => [
        '5 Spalten',
        '5 columns',
    ],
    'viewlayout1' => [
        'Gleiche Breite',
        'Equal widths',
    ],
    'viewlayout2' => [
        'Gleiche Breite',
        'Equal widths',
    ],
    'viewlayout3' => [
        'Linke Spalte breiter',
        'Larger left column',
    ],
    'viewlayout4' => [
        'Rechte Spalte breiter',
        'Larger right column',
    ],
    'viewlayout5' => [
        'Gleiche Breite',
        'Equal widths',
    ],
    'viewlayout6' => [
        'Mittlere Spalte breiter',
        'Larger centre column',
    ],
    'viewlayout7' => [
        'Mittlere Spalte viel breiter',
        'Much larger centre column',
    ],
    'viewlayout8' => [
        'Gleiche Breite',
        'Equal widths',
    ],
    'viewlayout9' => [
        'Mittlere Spalte breiter',
        'Larger centre columns',
    ],
    'viewlayout10' => [
        'Gleiche Breite',
        'Equal widths',
    ],
    'personalinformation' => [
        'Persönliche Information',
        'Personal Information',
    ],
    'personalinformation_help' => [
        'Der Block mit deinen persönlichen Daten, wie: Name, E-Mail.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Profil anzeigen</a></a>',
        'The block with your personal data, like: name, email.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>View your profile</a>',
    ],
    'cvinformation' => [
        'Lebenslauf Information',
        'CV Information',
    ],
    'cvinformation_help' => [
        'Der Block mit deinen exabis ePortfolio-Lebenslaufdaten, wie: Ausbildung, Beschäftigung usw.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Lebenslauf anzeigen</a>',
        'The block with your exabis ePortfolio CV data, like: education, employment, e.t.c.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>View your CV</a>',
    ],
    'cvgroup' => [
        'Lebenslauf',
        'CV',
    ],
    'headertext' => [
        'Kopfzeile',
        'Headertext',
    ],
    'headertext_help' => [
        'Der einfache Block zum Hinzufügen einer einzigen Überschriftzeile',
        'The simple block for adding only header line',
    ],
    'item' => [
        'Artefakt',
        'Item',
    ],
    'items' => [
        'Artefakte',
        'My artefacts',
    ],
    'items_help' => [
        'Der Block mit deinen Artefakten<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Deine Artefakte anzeigen</a>',
        'The block with your artefacts<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>View your artefacts</a>',
    ],
    'media' => [
        'Medieneintrag',
        'Media',
    ],
    'media_help' => [
        'Der Block mit eingebetteten Mediendaten von Quellen wie: YouTube, Vimeo, SlideShare usw.',
        'The block with embeded media data, from source like: Youtube, Vimeo, SlideShare, e.t.c.',
    ],
    'fieldstoshow' => [
        'Anzuzeigende Felder',
        'Fields to show',
    ],
    'listofartefacts' => [
        'W&aumlhle ein Element aus',
        'List of Artefacts',
    ],
    'listofbadges' => [
        'Liste von Badges',
        'List of Badges',
    ],
    'addButton' => [
        'Hinzufügen',
        'Add',
    ],
    'saveButton' => [
        'Speichern',
        'Save',
    ],
    'saveViewShareSettingsButton' => [
        'Portfolio teilen',
        'Share',
    ],
    'saveViewButton' => [
        'Portfolio speichern',
        'Save view',
    ],
    'saveAndNotifyButton' => [
        'Portfolio speichern und Benachrichtigungen senden',
        'Save view and send notifications',
    ],
    'cancelButton' => [
        'Abbrechen',
        'Cancel',
    ],
    'blocktitle2' => [
        'Blocktitel',
        'Block title',
    ],
    'blockcontent' => [
        'Blockinhalt',
        'Block content',
    ],
    'firstname' => [
        'Vorname',
        'First name',
    ],
    'lastname' => [
        'Nachname',
        'Last name',
    ],
    'profilepicture' => [
        'Profilbild',
        'Profile picture',
    ],
    'nopicture' => [
        'kein Bild',
        'no picture',
    ],
    'noprofilepicture' => [
        'kein Bild verfügbar',
        'no profile picture available',
    ],
    'mailadress' => [
        'E-Mail-Adresse',
        'Email adress',
    ],
    'nomail' => [
        'keine Mail-Adresse',
        'no email',
    ],
    'noemails' => [
        'keine Mail-Adresse vorhanden',
        'no email adress available',
    ],
    'aboutme' => [
        'Über mich',
        'About me',
    ],
    'aboutme_description' => [
        'Vordefiniert durch Lebenslaufinformationen, kann jedoch für jeden Block bearbeitet werden.',
        'Predefined by CV information, but can be editabled for every block',
    ],
    'notify' => [
        'Benachrichtigen',
        'notify',
    ],
    'sharejs' => [
        'teilen',
        'share',
    ],
    'viewmustbesafed' => [
        'Vorausgewählt auf Grund globaler Einstellungen. Das Portfolio muss gespeichert werden, bevor diese Benachrichtigen-Einstellung wirksam wird',
        'Preselected due to global settings. The view must be saved before this notify-setting will take effect',
    ],
    'mediacontent' => [
        'URL oder eingebetteter Code*',
        'URL or embed code *',
    ],
    'height' => [
        'H&ouml;he',
        'Height',
    ],
    'width' => [
        'Breite',
        'Width',
    ],
    'media_allowed_notes' => [
        'URLs der folgenden Seiten sind erlaubt:',
        'URLs from the following sites are allowed:',
    ],
    'filterByTag' => [
        'Tag zum Filtern verwenden',
        'Filter by tag',
    ],
    'tagarea_block_exaportitem' => [
        'Meine Portfolio Artefakte',
        'My Portfolio Artefacts',
    ],
    'searchByTitle' => [
        'Suchen',
        'Search',
    ],
    'clearAllFilers' => [
        'Alle Filter zurücksetzen',
        'Clear all filters',
    ],
    'sharedwith' => [
        'Geteilt mit',
        'Shared with',
    ],
    'sharedwith_user_cnt' => [
        'Mit {$a} Benutzern geteilt',
        'Shared with {$a} users',
    ],
    'sharedwith_onlyme' => [
        'Nur mit mir geteilt',
        'Shared only with me',
    ],
    'sharedwith_shareall' => [
        'Mit allen Benutzer::innen geteilt',
        'Shared with all users',
    ],
    'sharedwith_shareexternal' => [
        'Geteilte externe Views',
        'Shared external',
    ],
    'sharedwith_group' => [
        'Mit meiner Gruppe geteilt',
        'Shared with my group',
    ],
    'sharedwith_group_cnt' => [
        'Mit {$a} Gruppe geteilt',
        'Shared with {$a} groups',
    ],

    // === Copy to course.
    'filecopiedtocourse' => [
        'Datei wurde in den Kurs $a->coursename unter dem Namen $a->filename kopiert',
        'File copied to course $a->coursename under the name of $a->filename',
    ],
    'copyitemtocourse' => [
        'In Kurs kopieren',
        'Copy to course',
    ],
    'desp_language' => [
        'Desp Sprache',
        'Desp Language',
    ],
    'cofigureblock' => [
        'Konfigurationsblock',
        'Configure Block',
    ],
    'selectitems' => [
        'W&aumlehle Elemente aus',
        'Select items',
    ],
    'cofigureblock_text' => [
        'Text',
        'Choose text',
    ],
    'cofigureblock_header' => [
        'Konfiguration der Kopfzeile',
        'Choose headline',
    ],
    'cofigureblock_item' => [
        'Auswahl der Artefakte',
        'Choose artefact',
    ],
    'cofigureblock_media' => [
        'Medieneintrag',
        'Choose media',
    ],
    'cofigureblock_personalinfo' => [
        'Pers&ouml;nliche Information',
        'Choose personal info',
    ],
    'cofigureblock_cvinfo' => [
        'Lebenslauf Information',
        'Choose cv info',
    ],
    'cofigureblock_badge' => [
        'Badges auswählen',
        'Choose Badges',
    ],
    'cofigureblock_cvinfo_education_history' => [
        'Bildungs-Karriere',
        'Education history',
    ],
    'cofigureblock_cvinfo_employment_history' => [
        'Bildungs-Karriere',
        'Employment history',
    ],
    'cofigureblock_cvinfo_certif' => [
        'Zertifikate, Akkreditierungen, Auszeichnungen',
        'Certifications, accreditations and awards',
    ],
    'cofigureblock_cvinfo_public' => [
        'Bücher und Publikationen',
        'Books and publications',
    ],
    'cofigureblock_cvinfo_mbrship' => [
        'Mitgliedschaften',
        'Memberships',
    ],
    'cofigureblock_cvinfo_goals' => [
        'Meine Ziele',
        'My goals',
    ],
    'cofigureblock_cvinfo_skills' => [
        'Meine Kompetenzen',
        'My skills',
    ],
    'cofigureblock_cvinfo_interests' => [
        'Interessen',
        'Interests',
    ],
    'in' => [
        'at',
        'at',
    ],
    'cofigureblock_cvinfo_withfiles' => [
        'mit Anhängen publizieren',
        'With attached files',
    ],
    'configureblock_cvinfo_group_by_category' => [
        'Lebenslaufelemente in Kategorien anzeigen',
        'Display CV elements in categories',
    ],

    // === Desp.
    'back_to_desp' => [
        'zurück zum d-ESP',
        'back to language portfolio',
    ],
    'desp_pluginname' => [
        'Dossier',
        'Dossier',
    ],
    'steckbrief' => [
        'Steckbrief',
        'Profile',
    ],
    'desp_categories' => [
        '
    Erzählungen, Rollenspielszenen, Gedichte, Collagen
    Lebenslauf
    Berichte über Theateraufführungen, Ausstellungen
    Berichte über Projekte, Projektreflexionen
    Audio- und Videoclips
    Begegnungen durch Reisen in andere Länder
    Überlegungen zu deinem Sprachenlernen
    Zeugnisse
    Zertifikate
    Bestätigungen
    Hören
    Einzelarbeit
    Partnerarbeit
    Gruppenarbeit
    Lesen
    Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    An Gesprächen teilnehmen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Zusammenhängend sprechen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Schreiben
     - Einzelarbeit
     - Gruppenarbeit
     - Partnerarbeit
',
        '
    stories, roleplays, essays, collagen
    curriculum vitae
    reviews of theatre productions, exhibitions
    project reports and reflections
    audio- and videoclips
    encounters with other nationalities
    thoughts about your language skills
    report cards
    certificates
    acknowledgements
    listening
     - individual work
     - partner work
     - group work
    reading
     - individual work
     - partner work
     - group work
    participating in conversations
     - individual work
     - partner work
     - group work
    speaking fluently
     - individual work
     - partner work
     - group work
    writing
     - individual work
     - partner work
     - group work
',
    ],

    // === Config.
    'config_feature_copy_to_course' => [
        'Schüler dürfen Dateien in den Kurs kopieren',
        'Allow students to copy ePortfolio files to their courses',
    ],
    'competenceinteraction' => [
        'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.',
        'Allow interaction with block Exabis Competence Grid, in case it is installed',
    ],
    'opencomps' => [
        'Kompetenzen auswählen',
        'Choose your competences',
    ],
    'selectcomps' => [
        'W&auml;hle hier die Kompetenzen, die zu deinem Upload passen!',
        'Choose competences associated with your upload!',
    ],
    'competences_old_version' => [
        'Auf diesem Moodle ist eine alte Version von Exabis Competences installiert. Diese wird von Exabis Eportfolio nicht mehr unterstützt.',
        'An outdated version of Exabis Competences that is no longer supported by Exabis Eportfolio is installed on this moodle.',
    ],
    'expandcomps' => [
        'Alle &ouml;ffnen',
        'Expand all',
    ],
    'contactcomps' => [
        'Alle schlie&szlig;en',
        'Contract all',
    ],
    'studentcomps' => [
        'Hier kannst du einsch&auml;tzen, ob folgende Kompetenzen durch Dein Artefakt erreicht wurden.',
        'Here you can self-assess whether you have acquired the competency with your artefact.',
    ],
    'teachercomps' => [
        'Hier kannst du beurteilen, ob die Lernenden folgende Kompetenzen durch Artefakte erreicht haben.',
        'Here you can assess whether your students have acquired the competency with this artefact.',
    ],
    'competences' => [
        'Kompetenzen',
        'competences',
    ],
    'desp_einleitung' => [
        'Hier ist nun meine Sammelmappe, mein Dossier. Hier kann ich anderen zeigen, was ich alles gemacht habe. Ich kann genau sehen, wie viel ich schon gelernt habe.',
        'Here is your portfolio. You can show others what you have accomplished by yourself.',
    ],
    'settings_interaktion_exacomp_head' => [
        'Interaktion exabis ePortfolio - Exabis Competence Grid',
        'Interaction exabis ePortfolio - Exabis Competence Grid',
    ],
    'settings_interaktion_exacomp_body' => [
        'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.',
        'Interaction with block Exabis Competence Grid, in case it is installed',
    ],
    'settings_allow_loginas_head' => [
        '"Login als" erlauben',
        'Allow login as',
    ],
    'settings_allow_loginas_body' => [
        '',
        '',
    ],
    'settings_create_desp_categories_head' => [
        'Create Desp Categories',
        'Create Desp Categories',
    ],
    'settings_create_desp_categories_body' => [
        '',
        '',
    ],
    'settings_disable_shareall_head' => [
        'Mit allen Benutzer::innen teilen deaktivieren',
        'Disable sharing with all users',
    ],
    'settings_disable_shareall_body' => [
        'Klicke <a href="{$a}">hier</a> um alle globalen Freigaben zu löschen',
        'Click <a href="{$a}">here</a>, to remove all global shares',
    ],
    'settings_disable_externaccess_head' => [
        'Teilen Option "Externer Zugriff" auf Portfolios deaktivieren.',
        'Disable Sharing-Option "External Access" for views',
    ],
    'settings_disable_externaccess_body' => [
        '',
        '',
    ],
    'settings_disable_shareemails_head' => [
        'Teilen Option "Per E-Mail teilen" von Portfolios deaktivieren.',
        'Disable Sharing-Option "Share by Email" for views',
    ],
    'settings_disable_shareemails_body' => [
        '',
        '',
    ],
    'settings_disable_external_comments_head' => [
        'Teilen von Kommentaren in externen Views deaktivieren',
        'Disable sharing of comments in external view',
    ],
    'settings_disable_external_comments_body' => [
        '',
        '',
    ],
    'block_exaport_app_externaleportfolio_head' => [
        'Dateien in Mahara speichern',
        'Save files to mahara if checked, save to exaport if not checked',
    ],
    'block_exaport_app_externaleportfolio_body' => [
        'App: Setze das Häkchen um Dateien in Mahara zu speichern, ansonsten werden Datein im exabis ePortfolio hinterlegt.',
        'For App',
    ],
    'block_exaport_maxbytes' => [
        'Maximale Upload-Dateigröße in Exabis ePortfolio',
        'Maximum uploaded file size in Exabis ePortfolio',
    ],
    'block_exaport_maxbytes_body' => [
        'Maximale Dateigröße, die Dateien haben können, die im Exabis ePortfolio hochgeladen werden. <br> Wert für diese Seite ist: {$a->sitemaxbytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>',
        'This specifies a maximum size that uploaded files can be throughout the Exabis ePortfolio.<br> Value for whole site is: {$a->sitemaxbytes}. See <a href="{$a->settingsurl}">settings</a>',
    ],
    'block_exaport_userquota' => [
        'Benutzer-Dateikontingent Exabis ePortfolio',
        'User quota for Exabis ePortfolio',
    ],
    'block_exaport_userquota_body' => [
        'Maximale Anzahl an Bytes, die ein Benutzer im Exabis ePortfolio hochladen kann. <br> Wert für diese Seite ist: {$a->bytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>',
        'The maximum number of bytes that a user can store in their own Exabis ePortfolio.<br> Value for whole site is: {$a->bytes}. See <a href="{$a->settingsurl}">settings</a>',
    ],
    'block_exaport_multiplefilesinitem' => [
        'Mehrere Dateien in Datei-Artefakt hochladen',
        'Multiple files in "File" artefact',
    ],
    'block_exaport_multiplefilesinitem_body' => [
        'limit: 10 Dateien',
        'limit: 10 files',
    ],
    'block_exaport_copytomyportfolio' => [
        'Aktiviere "In mein Portfolio kopieren"',
        'Enable "Copy to my portfolio"',
    ],
    'block_exaport_copytomyportfolio_body' => [
        'Benutzer können Artefakte aus einer geteilten Kategorie in ihr eigenes Portfolio kopieren.',
        'User will be able copy artefacts from shared category into own portfolio',
    ],
    'block_exaport_app_alloweditdelete_head' => [
        'Schüler/:innen dürfen trotz Lehrerbeurteilungen ePortfolio Items editieren und löschen',
        'Students are allowed to edit and delete items after teacher reviews',
    ],
    'block_exaport_app_alloweditdelete_body' => [
        'Nur in Kombination mit Exabis Competence Grid und Dakora sinnvoll',
        'Only useful in combination with Exabis Competence Grid and dakora',
    ],
    'delete_all_shareall' => [
        'Alle globalen Freigaben "shareall" löschen?',
        'Delete all shareall?',
    ],
    'block_exaport_teachercanseeartifactsofstudents_head' => [
        'Trainer/in hat Zugriff auf alle Artefakte eigene Schüler/:innen',
        'Teacher can see ALL artefacts of own students',
    ],
    'block_exaport_teachercanseeartifactsofstudents_body' => [
        'Vertrauenswürdige Trainer/:innen müssen im jeweiligen Profil als solche definiert werden. Dies funktioniert nur, wenn obige Option aktiviert ist.<br />{$a}Die Liste der Teilnehmer/:innen für jede/n als vertrauenswürdig definierte/n Trainer/in generiert sich automatisch durch Kurseinschreibungen<br />Teilnehmer/:innen können diesen Zugriff nicht deaktivieren. Dies hat keine Auswirkungen auf die Gewährung von Zugriffen für andere Teilnehmer/:innen.',
        'Trusted teachers have to be configured in their individual profiles and this will only work, if the option above has been activated.<br />{$a}The list of students for each trusted teacher are generated according to their course enrollments.<br />Students cannot disable this access. Access to other users can be given as before.',
    ],
    'block_exaport_teachercanseeartifactsofstudents_configurationlink' => [
        'erforderliches Profilfeld für vertrauenswürdigen Trainer erstellen',
        'Add required user profile field',
    ],
    'block_exaport_confirm_profilefield_create' => [
        'Willst du wirklich das Profilfeld für vertrauenswürdige Trainer erstellen?',
        'Do you really want to add the required profile field?',
    ],
    'block_exaport_confirm_profilefield_exists' => [
        'Das erforderliche Feld existiert bereits',
        'Profile field for trusted teacher already exists',
    ],
    'block_exaport_profilefield_created' => [
        'Das erforderliche Feld wurde hinzugefügt',
        'Profile field for trusted teacher was added',
    ],

    // === Resume.
    'resume_template_newresume' => [
        '<h2>Mein Lebenslauf</h2>',
        '<h2>My new CV</h2>',
    ],
    'resume_my' => [
        'Mein Lebenslauf',
        'My CV',
    ],
    'resume_cover' => [
        'Begleit-Informationen',
        'About me',
    ],
    'resume_coversaved' => [
        'Begleit-Informationen gespeichert',
        'Cover saved',
    ],
    'resume_eduhistory' => [
        'Bildungs-Karriere',
        'Education history',
    ],
    'resume_edu' => [
        'Bildung',
        'Education',
    ],
    'resume_edusaved' => [
        'Bildungsverlauf gespeichert',
        'Education saved',
    ],
    'resume_deleteeduconfirm' => [
        'Willst du wirklich den Eintrag löschen?',
        'Do you really want to delete this education?',
    ],
    'resume_edudeleted' => [
        'Eintrag gelöscht',
        'Education deleted',
    ],
    'resume_employhistory' => [
        'Beschäftigungs-Historie',
        'Employment history',
    ],
    'resume_employ' => [
        'Beschäftigung',
        'Employment',
    ],
    'resume_employsaved' => [
        'Beschäftigung gespeichert',
        'Employment saved',
    ],
    'resume_deleteemployconfirm' => [
        'Willst du wirklich den Eintrag löschen?',
        'Do you really want to delete this employment?',
    ],
    'resume_employdeleted' => [
        'Beschäftigung gelöscht',
        'Employment deleted',
    ],
    'resume_interests' => [
        'Interessen',
        'Interests',
    ],
    'resume_interestssaved' => [
        'Interessen gespeichert',
        'Interests saved',
    ],
    'resume_startdate' => [
        'Start-Datum',
        'Start date',
    ],
    'resume_enddate' => [
        'End-Datum',
        'End date',
    ],
    'resume_institution' => [
        'Bildungseinrichtung',
        'Institution ',
    ],
    'resume_institutionaddress' => [
        'Adresse der Bildungseinrichtung',
        'Institution address',
    ],
    'resume_qualification' => [
        'Qualifikation',
        'Qualification',
    ],
    'resume_qualtype' => [
        'Art der Qualifikation',
        'Qualification type',
    ],
    'resume_qualname' => [
        'Bezeichnung der Qualifikation',
        'Qualification name',
    ],
    'resume_qualdescription' => [
        'Beschreibung der Qualifikation',
        'Qualification description',
    ],
    'resume_files' => [
        'Anhang',
        'Attachments',
    ],
    'resume_employer' => [
        'Arbeitgeber',
        'Employer',
    ],
    'resume_employeraddress' => [
        'Adresse des Arbeitgebers',
        'Employer address',
    ],
    'resume_jobtitle' => [
        'Job-Titel',
        'Job title',
    ],
    'resume_position' => [
        'Position',
        'Position',
    ],
    'resume_positiondescription' => [
        'Beschreibung der Position',
        'Position description',
    ],
    'resume_certif' => [
        'Zertifikate, Akkreditierungen, Auszeichnungen',
        'Certifications, accreditations and awards',
    ],
    'resume_date' => [
        'Datum',
        'Date',
    ],
    'resume_title' => [
        'Title',
        'Title',
    ],
    'resume_description' => [
        'Beschreibung',
        'description',
    ],
    'resume_certifsaved' => [
        'Zertifikat, Akkreditierung bzw. Auszeichnung gespeichert',
        'Certification, accreditation or award saved',
    ],
    'resume_deletecertifconfirm' => [
        'Willst du wirklich den Eintrag löschen?',
        'Do you really want to delete this certification, accreditation or award?',
    ],
    'resume_certifdeleted' => [
        'Zertifikat, Akkreditierung bzw. Auszeichnung gelöscht',
        'Certification, accreditation or award deleted',
    ],
    'resume_public' => [
        'Bücher und Publikationen',
        'Books and publications',
    ],
    'resume_contribution' => [
        'Beiträge',
        'Contribution',
    ],
    'resume_contributiondetails' => [
        'Details zum Beitrag',
        'Details of your contribution',
    ],
    'resume_url' => [
        'URL',
        'URL',
    ],
    'resume_publicsaved' => [
        'Bücher und Publikationen gespeichert',
        'Books and publications saved',
    ],
    'resume_deletepublicconfirm' => [
        'Willst du wirklich den Eintrag löschen?',
        'Do you really want to delete this book or publication?',
    ],
    'resume_publicdeleted' => [
        'Buch oder Publikation gelöscht',
        'Book or publication deleted',
    ],
    'resume_mbrship' => [
        'Mitgliedschaften',
        'Memberships',
    ],
    'resume_mbrshipsaved' => [
        'Mitgliedschaften gespeichert',
        'Membership saved',
    ],
    'resume_deletembrshipconfirm' => [
        'Willst du wirklich den Eintrag löschen?',
        'Do you really want to delete this membership?',
    ],
    'resume_mbrshipdeleted' => [
        'Mitgliedschaft gelöscht',
        'Membership deleted',
    ],
    'resume_linkedin' => [
        'LinkedIn-Profil',
        'LinkedIn profile',
    ],
    'resume_linkedinsaved' => [
        'LinkedIn-Profil gespeichert',
        'LinkedIn profile saved',
    ],
    'resume_deletelinkedinconfirm' => [
        'Willst du wirklich den Eintrag löschen?',
        'Do you really want to delete this membership?',
    ],
    'resume_linkedindeleted' => [
        'LinkedIn-Profil gelöscht',
        'LinkedIN profile deleted',
    ],
    'resume_mygoals' => [
        'Meine Ziele',
        'My goals',
    ],
    'resume_goals' => [
        'Ziele',
        'Goals',
    ],
    'resume_goalspersonal' => [
        'persönliche Ziele',
        'Personal goals',
    ],
    'resume_goalsacademic' => [
        'Bildungsziele',
        'Academic goals',
    ],
    'resume_goalscareers' => [
        'Karriereziele',
        'Career goals',
    ],
    'resume_goalspersonalsaved' => [
        'Persönliche Ziele gespeichert',
        'Personal goals saved',
    ],
    'resume_goalsacademicsaved' => [
        'Bildungsziele gespeichert',
        'Academic goals saved',
    ],
    'resume_goalscareerssaved' => [
        'Karriereziele gespeichert',
        'Careers goals saved',
    ],
    'resume_myskills' => [
        'Meine Kompetenzen',
        'My skills',
    ],
    'resume_skills' => [
        'Kompetenzen',
        'Skills',
    ],
    'resume_skillspersonal' => [
        'Persönliche Kompetenzen',
        'Personal skills',
    ],
    'resume_skillsacademic' => [
        'Bildungs-Kompetenzen',
        'Academic skills',
    ],
    'resume_skillscareers' => [
        'Karriere-Kompetenzen',
        'Career skills',
    ],
    'resume_skillspersonalsaved' => [
        'Persönliche Kompetenzen gespeichert',
        'Personal skills saved',
    ],
    'resume_skillsacademicsaved' => [
        'Bildungs-Kompetenzen gespeichert',
        'Academic skills saved',
    ],
    'resume_skillscareerssaved' => [
        'Karriere-Kompetenzen gespeichert',
        'Careers skills saved',
    ],
    'resume_goalscomp' => [
        'Kompetenzen',
        'Educational standards',
    ],
    'resume_skillscomp' => [
        'Kompetenzen',
        'Educational standards',
    ],
    'resume_badges' => [
        'Moodle-Auszeichnungen',
        'Badges',
    ],
    'resume_exportto_europass' => [
        'Export für Europass',
        'Export to Europass',
    ],
    'resume_exportto_europass_intro' => [
        '<p>Das Tool hilft den Nutzer:innen und Nutzern bei der Ermittlung von Lern- und Karrieremöglichkeiten. Im Hinblick auf Beratung und Service-Angebot ist das Profil auch für Arbeitgeber, Freiwilligenorganisationen, Recruiter/:innen, Laufbahnberater/:innen, Jugendorganisationen, Bildungseinrichtungen und andere Organisationen interessant.</p>
        <p>We provide a way for using your CV from Exabis eProtfolio in Europass profile<br>
            The generated XML-file has to be inserted into the page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=de" target="_blank">Hier kannst du deinen Lebenslauf erstellen</a><br>
            (better to be logged in in the Europass previously)<br>
            Press the button "<strong>Europass-Lebenslauf importieren</strong>" and upload XML-file wich will genareted the button below
        </p>

    Ein paar Kurznotizen:<br>
    <ul><li>Der generierte Lebenslauf sollte auf alle Fälle nochmals kontrolliert werden</li>
        <li>Persönliche Daten werden aus den persönlichen Moodle-Informationen generiert</li>
        <li>Alle Datumsangaben sollten überprüft werden</li>
        <li>Bilder die über die HTML-Editoren eingefügt wurden werden nicht exportiert</li>
        <li>Texte die über die HTML-Editoren eingefügt wurden müssen unter Umständen neu formatiert werden</li>
        <li>Vorgaben für angehängte Dateien: Formate PDF, PNG, JPG sind erlaubt, maximale Dateigröße: 2,5 MB.</li>
    </ul>',
        '<p>The Europass profile can help people to plan their learning and career development. The profile can be used by organisations – employers, volunteer organisations, recruiters, guidance practitioners, youth organisations, education and training institutions and more – as part of the support and services they offer to people.</p>
        <p>We provide a way for using your CV from Exabis eProtfolio in Europass profile<br>
            The generated XML-file has to be inserted into the page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=en" target="_blank">Create your CV</a><br>
            (better to be logged in in the Europass previously)<br>
            Press the button "Import Europass CV" and upload XML-file wich will genareted the button below
        </p>

    Some notes:<br>
    <ul>
        <li>You definitely need to check out the resulting CV</li>
        <li>Your personal data will be taken from your Moodle account</li>
        <li>Please check all dates, telephones, addresses</li>
        <li>Images from the HTML-editors will not be exported</li>
        <li>Most texts from the HTML-editors need to be reformatted</li>
        <li>Attached files are not implemented in new version of Europass, so they will not be imported</li>
    </ul>',
    ],
    'resume_exportto_europass_getXML' => [
        'XML herunterladen',
        'Download XML',
    ],
    'resume_expand' => [
        'Alles öffnen',
        'Expand all',
    ],
    'resume_collaps' => [
        'Alles schließen',
        'Collaps all',
    ],

    // === Structure sharing.
    'shared_categories' => [
        'Geteilte Kategorien',
        'Shared Categories',
    ],
    'nothingstructureshared' => [
        'Keine geteilten Strukturen',
        'Nobody is sharing a structure with you',
    ],
    'browsecategory' => [
        'Inhalt anzeigen',
        'Browse this category',
    ],
    'copycategory' => [
        'In mein Portfolio kopieren',
        'Copy to my Portfolio',
    ],
    'sharedArtefacts' => [
        'Gruppe-Portfolios, die mit dir geteilt wurden',
        'Group portfolios shared with you',
    ],
    'shareditems_category' => [
        'Gruppen-Portfolios, die mit dir geteilt wurden',
        'Group portfolios shared with you',
    ],
    'create_as_note' => [
        'Als Artefakt hinzufügen',
        'Create as Artefact',
    ],
    'category_not_found' => [
        'Kategorie nicht gefunden',
        'Category not found',
    ],
    'root_category' => [
        'Hauptkategorie',
        'Root Category',
    ],
    'current_category' => [
        'Aktuelle Kategorie',
        'Current Category',
    ],
    'change_layout' => [
        'Darstellung wechseln',
        'Change Layout',
    ],
    'details' => [
        'Details',
        'Details',
    ],
    'tiles' => [
        'Kacheln',
        'Tiles',
    ],
    'category_up' => [
        'übergeordnete Kategorie',
        'back to Parent Category',
    ],
    'supported' => [
        'Projekt wurde unterstützt von',
        'supported by',
    ],
    'developed' => [
        'entwickelt von',
        'developed by',
    ],
    'myfilearea' => [
        'Mein Dateibereich',
        'My file area',
    ],
    'show_mystudents' => [
        'Meine Teilnehmer/:innen',
        'My students',
    ],
    'show_sharedbyuser' => [
        'von Teilnehmer/:innen geteilt',
        'Shared by users',
    ],
    'enrolled_courses' => [
        'mit folgenden Kursen verknüpft',
        'Related with courses',
    ],
    'browseportfolio' => [
        'Inhalt anzeigen',
        'Browse this portfolio',
    ],

    // === Language categories.
    'lang_categories' => [
        null,
        '',
    ],

    // === Message.
    'messageprovider:sharing' => [
        'Nachricht, wenn ein Benutzer/in etwas mit mir teilt',
        'Sharing notifications',
    ],

    'messageprovider:viewupdated' => [
        'Nachricht, wenn ein Benutzer seine geteilte View aktualisiert',
        'Updated view notifications',
    ],

    // === Not Used Anymore.
    // 'i_shared' => [
    //     'Ich habe ein Eportfolio mit Ihnen geteilt',
    //     'I shared an eportfolio view with you',
    // ],
    'i_shared' => [
        '{$a->sendername} hat die ePortfolio Ansicht {$a->title} mit Ihnen geteilt',
        '{$a->sendername} shared the e-portfolio view {$a->title} with you',
    ],
    'i_updated' => [
        '{$a->sendername} hat Änderungen an dem E-Portfolio {$a->title} vorgenommen, welches mit Ihnen geteilt ist.',
        '{$a->sendername} made changes to the e-portfolio view {$a->title} shared with you.',
    ],
    'addstdcat' => [
        'Standardkategorien importieren',
        'import standard categories',
    ],
    'incompatible_video' => [
        'Um dieses Video anzusehen, bitte den direkten Link benutzen: {$a->link}',
        'To view this video please use the direct link: {$a->link}',
    ],
    'download_pdf' => [
        'Download as Pdf',
        'Download as Pdf',
    ],
    'pdf_settings' => [
        'PDF-Einstellungen',
        'Pdf settings',
    ],
    'pdf_settings_description' => [
        'Wenn du spezielle oder ungewöhnliche Schriftzeichen verwendest, kann es zu Problemen mit dem generierten PDF kommen. Du kannst daher versuchen, unterschiedliche Schriftarteinstellungen zu verwenden.<br>
			Deine PDF-Einstellungen werden für diese Ansicht gespeichert.<br>Wenn deine Ansicht mit anderen Benutzern geteilt wird, sehen sie das PDF mit deinen Einstellungen.<br>
			Nicht-standardisierte Schriftarten können einige Optionen wie Fett, Kursiv usw. verlieren.',
        'If you use some special or uncommon language characters the generated pdf can have problems. So, you can try to use different font settings<br>
            Your PDF settings will be saved for this view.<br>So, if your view is shared with other users - they will see the pdf with your settings.<br>
            Non-standard fonts can have some lost options like bold, italic, e.t.c.',
    ],
    'pdf_settings_fontfamily' => [
        'Schriftfamilie',
        'Font family',
    ],
    'pdf_settings_fontsize' => [
        'Grundlegende Schriftgröße',
        'Basic font size',
    ],
    'pdf_settings_showmetadata' => [
        'Metadaten zur Ansicht hinzufügen',
        'Add view meta data',
    ],
    'pdf_settings_showusername' => [
        'Benutzername',
        'user name',
    ],
    'pdf_settings_showuserpicture' => [
        'Profilbild',
        'user picture',
    ],
    'pdf_settings_showuseremail' => [
        'Benutzer E-Mail',
        'user email',
    ],
    'pdf_settings_showuserphone' => [
        'Benutzer Telefon',
        'user phone',
    ],
    'pdf_customfont' => [
        'Benutzerdefinierte Schriftart hochladen',
        'Upload custom font',
    ],
    'pdf_settings_uploadfont' => [
        'Eigene Schriftart hochladen',
        'Upload self font',
    ],
    'pdf_settings_pagesize' => [
        'Seitengröße',
        'Page size',
    ],
    'pdf_settings_pageorient' => [
        'Seitenausrichtung',
        'Page orientation',
    ],
    'pdf_settings_pageorient.portrait' => [
        'Hochformat',
        'Portrait',
    ],
    'pdf_settings_pageorient.landscape' => [
        'Querformat',
        'Landscape',
    ],
    'pdf_customfont_help' => [
        'Du kannst deine eigene .ttf-Datei hochladen. Wir werden versuchen, sie für die PDF-Erstellung zu verwenden.',
        'Your can upload own .ttf file. We will try to use it for PDF generation.',
    ],
    'pdf_settings_fontfamily_fixedgroup' => [
        'Vordefinierte Schriften',
        'Predefined fonts',
    ],
    'pdf_settings_fontfamily_customgroup' => [
        'Benutzerdefinierte hochgeladene Schriftarten',
        'Custom uploaded fonts',
    ],
    'settings_layout_settings_heading' => [
        'Layout-Einstellungen',
        'Layout settings',
    ],
    'block_exaport_allowcustomlayout_head' => [
        'Benutzerdefinierte Optionen für das Layout der Views für View-Eigentümer',
        'Custom options for the view layout for view owners',
    ],
    'block_exaport_allowcustomlayout_body' => [
        'Ermöglicht die Verwendung benutzerdefinierter Layout-Einstellungen für Views (ähnlich den unten aufgeführten Optionen) für reguläre Besitzer der Views.',
        'Allows to use custom view layout settings (similar to options below) for regular owners of the views',
    ],
    'settings_layout_settings_description' => [
        'Hier kannst du einige Layout-Optionen der View ändern oder eigene benutzerdefinierte CSS-Regeln verwenden, um die View nach deinen Wünschen zu gestalten.<br>Diese Einstellungen werden als Standardeinstellungen <strong>für alle Views</strong> verwendet.',
        'Here you can change some view layout options or use own custom CSS rules to have the view as you want<br>These settings will be used as default settings <strong>for all views</strong>',
    ],
    'layout_settings' => [
        'Layout-Einstellungen',
        'Layout settings',
    ],
    'layout_settings_description' => [
        'Hier kannst du einige Layout-Optionen der View ändern oder eigene benutzerdefinierte CSS-Regeln verwenden, um die View nach deinen Wünschen zu gestalten.',
        'Here you can change some view layout options or use own custom CSS rules to have the view as you want',
    ],
    'layout_settings_font_size' => [
        'Schriftgröße',
        'Font size',
    ],
    'layout_settings_border_width' => [
        'Randbreite',
        'Border width',
    ],
    'layout_settings_font_weight' => [
        'Fett',
        'Bold',
    ],
    'layout_settings_border_width_only_bottom' => [
        'Nur unterer Rand',
        'Only bottom border',
    ],
    'layout_settings_view_headers' => [
        'Überschriften der View-Blöcke',
        'Headers of view blocks',
    ],
    'layout_settings_view_content' => [
        'Inhalt der View-Blöcke',
        'Content of view blocks',
    ],
    'layout_settings_custom_css' => [
        'benutzerdefinierte CSS-Regeln',
        'Custom CSS',
    ],
    'layout_settings_custom_css_description' => [
        'Hier kannst du eigene benutzerdefinierte CSS-Regeln verwenden.',
        'You can use own custom CSS rules here',
    ],
    'selected_competencies' => [
        'Erreichte Kompetenz',
        'Achieved Competency',
    ],
    'forms.item.title' => [
        'Titel',
        'Title',
    ],
    'forms.item.title_help' => [
        '',
        '',
    ],
    'forms.item.project_description' => [
        'Der Grund hinter diesem Projekt',
        'The why behind this project',
    ],
    'forms.item.project_description_help' => [
        '<strong>Erkläre kurz den Zweck deiner Arbeit:</strong>
			<ul>
				<li>Welches Problem wurde damit angesprochen?</li>
				<li>Welche Fähigkeiten wolltest du entwickeln?</li>
				<li>Was war der Kontext?</li>
			</ul>',
        '<strong>Briefly explain the purpose of your work:</strong><ul>
                <li>What problem did it address?</li>
                <li>What skills did you aim to develop?</li>
                <li>What was the context?</li>
            </ul>',
    ],
    'forms.item.project_description_editor' => [
        'Der Grund hinter diesem Projekt',
        'The why behind this project',
    ],
    'forms.item.project_description_editor_help' => [
        '<strong>Erkläre kurz den Zweck deiner Arbeit:</strong>
			<ul>
				<li>Welches Problem wurde angesprochen?</li>
				<li>Welche Fähigkeiten wolltest du entwickeln?</li>
				<li>Was war der Kontext?</li>
			</ul>',
        '<strong>Briefly explain the purpose of your work:</strong>
            <ul>
                <li>What problem did it address?</li>
                <li>What skills did you aim to develop?</li>
                <li>What was the context?</li>
            </ul>',
    ],
    'forms.item.project_process' => [
        'Umsetzung des Projekts',
        'Making it happen',
    ],
    'forms.item.project_process_help' => [
        '<strong>Beschreibe deinen Weg:</strong>
			<ul>
				<li>Welche Schritte hast du unternommen, um dieses Projekt abzuschließen?</li>
				<li>Welche Herausforderungen sind dir begegnet und wie hast du sie gemeistert?</li>
				<li>Welche Ressourcen hast du genutzt?</li>
			</ul>',
        '<strong>Describe your journey:</strong>
            <ul>
                <li>What steps did you take to complete this project?</li>
                <li>What challenges did you encounter, and how did you overcome them?</li>
                <li>What resources did you use?</li>
            </ul>',
    ],
    'forms.item.project_process_editor' => [
        'Umsetzung des Projekts',
        'Making it happen',
    ],
    'forms.item.project_process_editor_help' => [
        '<strong>Beschreibe deinen Weg:</strong>
			<ul>
				<li>Welche Schritte hast du unternommen, um dieses Projekt abzuschließen?</li>
				<li>Welche Herausforderungen sind dir begegnet und wie hast du sie gemeistert?</li>
				<li>Welche Ressourcen hast du genutzt?</li>
			</ul>',
        '<strong>Describe your journey:</strong>
            <ul>
                <li>What steps did you take to complete this project?</li>
                <li>What challenges did you encounter, and how did you overcome them?</li>
                <li>What resources did you use?</li>
            </ul>',
    ],
    'forms.item.project_result' => [
        'Ergebnisse und Erkenntnisse',
        'Results and learnings',
    ],
    'forms.item.project_result_help' => [
        '<strong>Fasse die Ergebnisse deines Projekts kurz zusammen:</strong>
			<ul>
				<li>Was hast du erreicht?</li>
				<li>Welche Fähigkeiten und Kompetenzen hast du durch diese Arbeit entwickelt oder gestärkt?</li>
				<li>Was hast du über dich und deine Fähigkeiten gelernt?</li>
				<li>Was würdest du das nächste Mal anders machen?</li>
			</ul>',
        '<strong>Briefly summarize the outcomes of your project:</strong>
                <ul>
                    <li>What did you achieve?</li>
                    <li>What skills and competencies did you develop or strengthen through this work?</li>
                    <li>What did you learn about yourself and your abilities?</li>
                    <li>What would you do differently next time?”</li>
                </ul>',
    ],
    'forms.item.project_result_editor' => [
        'Ergebnisse und Erkenntnisse',
        'Results and learnings',
    ],
    'forms.item.project_result_editor_help' => [
        '<strong>Fasse die Ergebnisse deines Projekts kurz zusammen:</strong>
			<ul>
				<li>Was hast du erreicht?</li>
				<li>Welche Fähigkeiten und Kompetenzen hast du durch diese Arbeit entwickelt oder gestärkt?</li>
				<li>Was hast du über dich und deine Fähigkeiten gelernt?</li>
				<li>Was würdest du das nächste Mal anders machen?</li>
			</ul>',
        '<strong>Briefly summarize the outcomes of your project:</strong>
                <ul>
                    <li>What did you achieve?</li>
                    <li>What skills and competencies did you develop or strengthen through this work?</li>
                    <li>What did you learn about yourself and your abilities?</li>
                    <li>What would you do differently next time?”</li>
                </ul>',
    ],
    'item.project_information' => [
        'Projekt Information',
        'Project Information',
    ],
    'view_saved' => [
        'View gespeichert',
        'View saved',
    ],
    'view_sharing_updated' => [
        'Ver&ouml;ffentlichung gespeichert',
        'View sharing updated',
    ],
    'list' => [
        'Liste',
        'List',
    ],
    'what_is_embed_code_title' => [
        'Was ist ein Einbettungscode?',
        'What is embed code?',
    ],
    'what_is_embed_code_content' => [
        '<p>Einbettungscode ist ein Code, der von einer Drittanbieter-Website wie YouTube oder Twitter generiert wird und den ein Benutzer in seine eigene Webseite kopieren und einfügen kann. Dieser eingebettete Code zeigt dann dasselbe Medium, dieselbe Anwendung oder denselben Feed auf der Webseite des Benutzers wie im Original.</p>
			<p>Wir bieten Anleitungen für die beliebtesten Videoplattformen wie YouTube oder Vimeo.</p>
			<p><strong>So findest du den Einbettungscode auf YouTube:</strong></p>
			<ol>
				<li>Gehe zu YouTube.</li>
				<li>Gehe zu dem Video, das du einbetten möchtest.</li>
				<li>Klicke auf den <strong>Teilen-Link</strong> unter dem Video und dann auf den <strong>Einbetten-Link</strong>.</li>
				<li>Klicke auf die Schaltfläche <strong>Kopieren</strong> im unteren Bereich des geöffneten Fensters.</li>
				<li>Der Einbettungslink wird blau markiert und in die Zwischenablage kopiert.</li>
				<li>Füge den Code in das Textfeld von exabis E-portfolio ein.</li>
			</ol>
			<p><strong>So findest du den Einbettungscode auf Vimeo:</strong></p>
			<ol>
				<li>Gehe zu Vimeo.</li>
				<li>Gehe zu dem Video, das du einbetten möchtest.</li>
				<li>Klicke auf die Schaltfläche <strong>Teilen</strong> oben rechts im Video.</li>
				<li>Ein Popup-Fenster mit den Einbettungslink-Informationen wird angezeigt. Du musst nur den <strong>&lt;<i>iframe</i>&gt;</strong>-Teil des Einbettungslinks kopieren.
					Beispiel:<br>
					<ol>
						<li>
							Der gesamte Einbettungslink zeigt Folgendes:<br>
							<textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; von &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; auf &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>
						</li>
						<li>
							Du musst nur den <strong>&lt;<i>iframe</i>&gt;</strong>-Teil kopieren:<br>
							<textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>
						</li>
					</ol>
				<li>Füge diesen Code in das Textfeld von exabis E-portfolio ein.</li>
			</ol>
            ',
        '<p>Embed code is code that is generated by a third-party website such as YouTube or Twitter, that a user can copy and paste into his or her own webpage.  This embedded code will then show the same media, application, or feed on the user\'s web page as it does in the original source.</p>
            <p>We provide instructions for the most popular video vendors such as YouTube or Vimeo.</p>
            <p><strong>Finding the embed code on YouTube:</strong></p>
            <ol>
                <li>Go to YouTube</a>.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share link</strong> below the video, then click the <strong>Embed link</strong>.</li>
                <li>Press <strong>Copy</strong> button in the footer of opened window.</li>
                <li>The embed link will be highlighted in blue and copied to the clipboard.</li>
                <li>Past the code to exabis E-portfolio textarea field.</li>
            </ol>
            <p><strong>Finding the embed code on Vimeo:</strong></p>
            <ol>
                <li>Go to Vimeo.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share</strong> button, in the top right corner of your video.</li>
                <li>A pop-up will appear with the embed link information. You will need to copy only the <strong>&lt;<i>iframe</i>&gt;</strong> portion of the embed link.
                    Example:<br>
                    <ol>
                        <li>
                            Entire embed link shows the following:<br>
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; from &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; on &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>
                        </li>
                        <li>
                            You only need to copy the <strong>&lt;<i>iframe</i>&gt;</strong> portion:<br>
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>
                        </li>
                    </ol>
                <li>Past this code to exabis E-portfolio textarea field.</li>
            </ol>
            ',
    ],

    // === Privacy wordings
    'privacy:metadata:block_exaportuser' => [
        'Benutzerdaten von exabis e-portfolio',
        'user\'s data from exabis e-portfolio',
    ],
    'privacy:metadata:block_exaportuser:user_id' => [
        'Benutzerid',
        'user id',
    ],
    'privacy:metadata:block_exaportuser:description' => [
        'Beschreibung',
        'description',
    ],
    'privacy:metadata:block_exaportuser:view_items_layout' => [
        'Benutzerid',
        'user id',
    ],

    'privacy:metadata:block_exaportcate' => [
        'Kategorien des Benutzers',
        'user\'s categories',
    ],
    'privacy:metadata:block_exaportcate:pid' => [
        'Hauptkategorie ID',
        'parent category id',
    ],
    'privacy:metadata:block_exaportcate:userid' => [
        'Benutzerid',
        'user id',
    ],
    'privacy:metadata:block_exaportcate:name' => [
        'Titel',
        'title',
    ],
    'privacy:metadata:block_exaportcate:timemodified' => [
        'letzte Änderung',
        'last modified',
    ],
    'privacy:metadata:block_exaportcate:courseid' => [
        'Kurse ID',
        'course id',
    ],
    'privacy:metadata:block_exaportcate:description' => [
        'Beschreibung',
        'description',
    ],
    'privacy:metadata:block_exaportcate:subjid' => [
        'Raster ID',
        'related subject id',
    ],
    'privacy:metadata:block_exaportcate:topicid' => [
        'Kompetenzbereich ID',
        'related topic id',
    ],
    'privacy:metadata:block_exaportcate:source' => [
        'Source',
        'source',
    ],
    'privacy:metadata:block_exaportcate:sourceid' => [
        'Source Id',
        'source id',
    ],
    'privacy:metadata:block_exaportcate:parent_ids' => [
        'Liste der übergeordneten IDs',
        'list of parent ids',
    ],
    'privacy:metadata:block_exaportcate:parent_titles' => [
        'List der übergeordneten Titel',
        'list of parent titles',
    ],
    'privacy:metadata:block_exaportcate:stid' => [
        'Schultyp ID',
        'schooltype id',
    ],
    'privacy:metadata:block_exaportcate:sourcemod' => [
        'Sourcemod',
        'sourcemod',
    ],
    'privacy:metadata:block_exaportcate:name_short' => [
        'Kurztitel',
        'short title',
    ],
    'privacy:metadata:block_exaportcate:shareall' => [
        'Freigegeben für alle? 0 - nicht freigegeben; 1 - für alle freigegeben; 2 - für Gruppen freigegeben',
        'shared for all? 0 - did not share; 1 - shared for all; 2 - shared for groups',
    ],
    'privacy:metadata:block_exaportcate:internshare' => [
        'intern geteilt?',
        'internal share?',
    ],
    'privacy:metadata:block_exaportcate:structure_shareall' => [
        'Als Struktur freigegeben? 0 - nicht freigegeben; 1 - für alle freigegeben; 2 - für Gruppen freigegeben',
        'shared as structure? : 0 - did not share; 1 - shared for all; 2 - shared for groups',
    ],
    'privacy:metadata:block_exaportcate:structure_share' => [
        'Als Struktur freigegeben? Siehe auch \'structure_shareall\'',
        'shared as structure? look also \'structure_shareall\'',
    ],

    'privacy:metadata:block_exaportitem' => [
        'Artefakt des Benutzers',
        'user\'s artefact',
    ],
    'privacy:metadata:block_exaportitem:userid' => [
        'Artefakt des Besitzers',
        'artefact\'s owner',
    ],
    'privacy:metadata:block_exaportitem:type' => [
        'Typ des Artefakts',
        'type of artefact',
    ],
    'privacy:metadata:block_exaportitem:categoryid' => [
        'Kategorie Id',
        'category id',
    ],
    'privacy:metadata:block_exaportitem:name' => [
        'Name',
        'name',
    ],
    'privacy:metadata:block_exaportitem:url' => [
        'Url',
        'url',
    ],
    'privacy:metadata:block_exaportitem:intro' => [
        'Intro',
        'intro',
    ],
    'privacy:metadata:block_exaportitem:timemodified' => [
        'Zeit zuletzt geändert',
        'last modified time',
    ],
    'privacy:metadata:block_exaportitem:courseid' => [
        'Kurs Id',
        'course id',
    ],
    'privacy:metadata:block_exaportitem:shareall' => [
        'Freigegeben für alle?',
        'shared for all?',
    ],
    'privacy:metadata:block_exaportitem:externaccess' => [
        'Externer Zugriff?',
        'external access?',
    ],
    'privacy:metadata:block_exaportitem:externcomment' => [
        'Kommentar für Externe',
        'comment for externals',
    ],
    'privacy:metadata:block_exaportitem:fileurl' => [
        'URL zur Datei',
        'url to file',
    ],
    'privacy:metadata:block_exaportitem:exampid' => [
        'zugehörige Beispiel-ID',
        'related example id',
    ],
    'privacy:metadata:block_exaportitem:langid' => [
        'Sprach-ID',
        'language id',
    ],
    'privacy:metadata:block_exaportitem:source' => [
        'Source',
        'source',
    ],
    'privacy:metadata:block_exaportitem:sourceid' => [
        'Source Id',
        'source id',
    ],
    'privacy:metadata:block_exaportitem:iseditable' => [
        'Ist bearbeitbar?',
        'is editable?',
    ],
    'privacy:metadata:block_exaportitem:example_url' => [
        'Material Url',
        'artefact\'s owner',
    ],
    'privacy:metadata:block_exaportitem:parentid' => [
        'Übergeordnete ID',
        'parent id',
    ],

    'privacy:metadata:block_exaportitemcomm' => [
        'Kommentare zu Artefakten',
        'comments for artefacts',
    ],
    'privacy:metadata:block_exaportitemcomm:itemid' => [
        'Id zu Artefakten',
        'id of artefact',
    ],
    'privacy:metadata:block_exaportitemcomm:userid' => [
        'Autor des Kommentars',
        'author of comment',
    ],
    'privacy:metadata:block_exaportitemcomm:entry' => [
        'Kommentar',
        'comment',
    ],
    'privacy:metadata:block_exaportitemcomm:timemodified' => [
        'zuletzt geändert',
        'last modified',
    ],

    'privacy:metadata:block_exaportview' => [
        'Kommentar zu Artefakten',
        'comments for artefacts',
    ],
    'privacy:metadata:block_exaportview:userid' => [
        'Besitzer der View',
        'owner of view',
    ],
    'privacy:metadata:block_exaportview:name' => [
        'Name',
        'name',
    ],
    'privacy:metadata:block_exaportview:description' => [
        'Beschreibung',
        'description',
    ],
    'privacy:metadata:block_exaportview:timemodified' => [
        'zuletzt geändert',
        'last modified',
    ],
    'privacy:metadata:block_exaportview:shareall' => [
        'Für alle Teilen?',
        'shared for all?',
    ],
    'privacy:metadata:block_exaportview:externaccess' => [
        'Externer Zugriff?',
        'external access?',
    ],
    'privacy:metadata:block_exaportview:externcomment' => [
        'Kommentar von extern?',
        'comment from external?',
    ],
    'privacy:metadata:block_exaportview:langid' => [
        'Sprach-ID',
        'language id',
    ],
    'privacy:metadata:block_exaportview:layout' => [
        'Layout der View',
        'layout of the view',
    ],
    'privacy:metadata:block_exaportview:sharedemails' => [
        'Liste freigegebener E-Mails',
        'shared emails list',
    ],
    'privacy:metadata:block_exaportview:autofill_artefacts' => [
        'Automatisches Ausfüllen bei Artefakten aktiviert',
        'enabled autofill by artefacts',
    ],

    'privacy:metadata:block_exaportresume' => [
        'Lebenslaufdaten',
        'resume data',
    ],
    'privacy:metadata:block_exaportresume:user_id' => [
        'Besitzer des Lebenslaufs',
        'resume owner',
    ],
    'privacy:metadata:block_exaportresume:courseid' => [
        'Kurs ID',
        'course id',
    ],
    'privacy:metadata:block_exaportresume:cover' => [
        'Inhalt des Deckblattes',
        'cover content',
    ],
    'privacy:metadata:block_exaportresume:interests' => [
        'Interessen',
        'interests',
    ],
    'privacy:metadata:block_exaportresume:goalspersonal' => [
        'persönliche Ziele',
        'personal goals',
    ],
    'privacy:metadata:block_exaportresume:goalsacademic' => [
        'akademische Ziele',
        'academic goals',
    ],
    'privacy:metadata:block_exaportresume:goalscareers' => [
        'Karriereziele',
        'careers goals',
    ],
    'privacy:metadata:block_exaportresume:skillspersonal' => [
        'Persönliche Fähigkeiten',
        'personal skills',
    ],
    'privacy:metadata:block_exaportresume:skillsacademic' => [
        'akademische Fähigkeiten',
        'academic skills',
    ],
    'privacy:metadata:block_exaportresume:skillscareers' => [
        'Karriere Fähigkeiten',
        'careers skills',
    ],
    'privacy:metadata:core_files' => [
        'Exabis ePortfolio speichert Dateien, die vom Benutzer hochgeladen wurden, um Teil von Artefakten, Lebenslaufeinträgen und Kommentaren zu werden.',
        'Exabis ePortfolio stores files which have been uploaded by the user to form part of artefacts, resume entries and comments.',
    ],
    'whyEportfolio' => [
        'Warum ein ePortfolio?',
        'Why ePortfolio',
    ],
    'whyEportfolio_description' => [
        '<h4>Machen Sie Arbeit sichtbar: Ihr digitales Portfolio</h4>
            <br>
            <p>Sie investieren viel Zeit und Energie in Aufgaben, Projekte oder Weiterbildungen. Oft verschwinden diese Ergebnisse jedoch nach der Abgabe oder dem Kursende in der Schublade, dabei spiegeln sie Ihr Können, Ihre Kreativität und Ihr Wissen wider.</p>
            <p>Mit einem <strong>ePortfolio</strong> haben Sie die Möglichkeit, Ihre Arbeiten, erworbenen Kompetenzen und Lernfortschritte sichtbar zu machen. So entsteht eine Sammlung, die Sie nicht nur für sich selbst dokumentieren, sondern auch mit Lehrenden, Institutionen oder potenziellen Arbeitgeber:innen teilen können.</p>
            <p>Von Präsentationen über Projektberichte bis hin zu Videos oder Zertifikaten – Ihr Portfolio macht Leistungen greifbar. Auch Microcredentials können integriert werden und unterstreichen Ihre Erfolge in Aus- und Weiterbildung.</p>
            <br>
            <h4>Was ist ein ePortfolio?</h4>
            <br>
            <p>Ein ePortfolio ist mehr als nur ein digitaler Lebenslauf. Es ist eine persönliche Sammlung Ihrer Arbeiten, die Ihre Fähigkeiten und Erfahrungen lebendig darstellt. Anders als ein klassischer CV bietet es echte Nachweise: Arbeitsproben, Reflexionen und den Kontext, in dem Sie Ihre Kompetenzen erworben haben.</p>
            <p>Mit Exabis ePortfolio können Sie mehrere Ansichten erstellen, passgenau für bestimmte Bewerbungen, Jobchancen oder Präsentationen. So zeigen Sie immer das, was für die jeweilige Situation am wichtigsten ist.</p>
            <br>
            <h4>Wie erstellst du dein ePortfolio?</h4>
            <br>
            <ol>
                <li><strong>Sammeln:</strong> Tragen Sie Ihre Arbeiten zusammen, seien es Aufgaben, Präsentationen, Projekte, Videos oder Ähnliches.</li>
                <li><strong>Auswählen:</strong> Entscheiden Sie sich für Ihre besten Arbeiten, die Ihre Stärken am deutlichsten zeigen.</li>
                <li><strong>Reflektieren:</strong> Ergänzen Sie kurze Beschreibungen, die Ihre Kompetenzen verdeutlichen und den Kontext erklären.</li>
                <li><strong>Gestalten:</strong> Bauen Sie ein Portfolio Schritt für Schritt auf und entwickeln Sie es laufend weiter.</li>
            </ol>
            <p>Mit Exabis ePortfolio geht das unkompliziert, flexibel und effizient. Sie haben jederzeit die Kontrolle darüber, wie Sie sich und Ihr Können präsentieren und machen sichtbar, was Sie einzigartig macht.</p>',
        '   <h4>Make Your Work Visible: Your Digital Portfolio</h4>
                <br>
                <p>You invest a lot of time and energy in tasks, projects, or further training. However, these results often disappear after submission or the end of the course, even though they reflect your skills, creativity, and knowledge.</p>
                <p>An ePortfolio gives you the opportunity to showcase your work, acquired skills, and learning progress. This creates a collection that you can not only document for yourself, but also share with teachers, institutions, or potential employers.</p>
                <p>From presentations and project reports to videos and certificates, your portfolio makes your achievements tangible. Microcredentials can also be integrated to highlight your successes in education and training.</p>
                <br>
                <h4>What is an ePortfolio?</h4>
                <br>
                <p> An ePortfolio is more than just a digital resume. It is a personal collection of your work that vividly demonstrates your abilities and experiences. Unlike a traditional CV, it provides real evidence: work samples, reflections, and the context in which you developed your skills.</p>
                <p>With Exabis ePortfolio, you can create multiple views tailored to specific applications, job opportunities, or presentations. This way, you always highlight what is most relevant for the situation.</p>
                <br>
                <h4>How do you create your ePortfolio?</h4>
                <br>
                <ol>
                    <li><strong>Collect:</strong> Gather your work, including assignments, presentations, projects, videos, or similar items.</li>
                    <li><strong>Select:</strong> Choose your strongest pieces that best demonstrate your skills.</li>
                    <li><strong>Reflect:</strong> Add short descriptions to explain your competencies and the context in which they were developed.</li>
                    <li><strong>Build:</strong> Assemble your portfolio step by step and continue to refine it over time.</li>
                </ol>
                <p>Exabis ePortfolio makes this process simple, flexible, and efficient. You always stay in control of how you present yourself and your skills, making visible what makes you unique.</p>
',
    ],
    'cofigureblock_cvinfo_help' => [
        'Du wirst den aktuellen Status der ausgewählten Elemente in deinem Lebenslauf sehen. Der Blockinhalt wird aktualisiert, wenn du später Änderungen an irgendwelchen Elementen in deinem Lebenslauf vornimmst.',
        'You will see the current status of the selected items in your CV. The block content will be updated if you make changes to any items in your CV later.',
    ],
    'cofigureblock_cvinfo_cover' => [
        'Über mich',
        'About me',
    ],
    'cofigureblock_cvinfo_cover_actual' => [
        'Aktuellen Lebenslauf "Über mich" Inhalt hinzufügen',
        'add actual CV "About me" content',
    ],
    'create_view_content_help_title' => [
        'Gestalte deine einzigartige Geschichte: Erstelle dein Portfolio',
        'Craft Your Unique Story: Build Your Portfolio',
    ],
    'create_view_content_help_text' => [
        '<ul>
				<li><strong>Plane dein Layout:</strong> Ziehe und lasse Bausteine fallen und arrangiere sie, um deine Geschichte zu erzählen. Verwende Spalten (verfügbar im Abschnitt "Layout"), um dein Portfolio zu planen.</li>
				<li><strong>Organisiere für Klarheit:</strong> Verwende Überschriften, Links und Notizen, um deine Inhalte effektiv zu strukturieren.</li>
				<li><strong>Personalisiere deinen Stil:</strong> Wähle Schriftarten und Farben innerhalb der verfügbaren Optionen, um einen Hauch von dir hinzuzufügen.</li>
			</ul>
			<strong>Denke daran: Dein e-Portfolio erzählt der Welt von dir und deinen Fähigkeiten. Mache es klar, prägnant und ansprechend!</strong>',
        '<ul>
                <li><strong>Plan your layout:</strong> Drag and drop building blocks and arrange them to tell your story. Use columns (available in the "layout" section) to plan your portfolio.</li>
                <li><strong>Organize for clarity:</strong> Use headers, links, and notes to structure your content effectively.</li>
                <li><strong>Personalize your style:</strong> Choose fonts and colours within the available options to add a touch of you.</li>
            </ul>
            <strong>Remember: Your e-portfolio tells the world about you and your skills. Make it clear, concise, and engaging!</strong>
            ',
    ],
    'moreinfolink' => [
        'Mehr Informationen anzeigen ...',
        'Show more info ...',
    ],
    'badges_help' => [
        'Der Block mit dir verliehenen Abzeichen<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Deine Abzeichen anzeigen</a>',
        'The block with badges granted to you<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>View your badges</a>',
    ],
    'view_preview_help_title' => [
        'Vorschau',
        'Preview',
    ],
    'view_preview_help' => [
        'Vorschau der View',
        'Preview of your view',
    ],
    'block_exaport_used_layout' => [
        'Verwendetes Layout',
        'Used layout',
    ],
    'block_exaport_used_layout_body' => [
        'Ändern Sie das Layout, falls es Darstellungsprobleme gibt. Momentan wird es nur für die Artefaktliste verwendet.',
        'Change the layout if you have some appearance problems. Right now it is used only for artefact list.',
    ],
    'block_exaport_used_layout_moodle_bootstrap' => [
        'Karten-Layout',
        'Cards layout',
    ],
    'block_exaport_used_layout_clean_old' => [
        'Kachel-Layout (Alt - Unterstützung endet mit Version 4.6.7)',
        'Tiles layout (Old - ended of support from v4.6.7)',
    ],
    'settings_export_settings_heading' => [
        'Export-Einstellungen',
        'Export settings',
    ],
    'settings_exaport_mysource' => [
        'Source ID',
        'Source ID',
    ],
    'settings_exaport_mysource_body' => [
        'Automatisch generierte ID dieser Exaport Installation. Diese kann nicht geändert werden',
        'Automatically generated ID of this Exaport installation. This ID can not be changed',
    ],
    'settings_exaport_wp_sso_url' => [
        'Url to WordPress SSO receiver',
        'Url to WordPress SSO receiver',
    ],
    'settings_exaport_wp_sso_url_body' => [
        'The url to server which is ready to recieve commands from exaport',
        'The url to server which is ready to recieve commands from exaport',
    ],
    'settings_exaport_wp_sso_passphrase' => [
        'WordPress SSO Passphrase',
        'WordPress SSO Passphrase',
    ],
    'settings_exaport_wp_sso_passphrase_body' => [
        'The Passphrase to connect with WordPress SSO receiver',
        'The Passphrase to connect with WordPress SSO receiver',
    ],
    'settings_exaport_wp_sso_enabled' => [
        'Enable WordPress SSO connection',
        'Enable WordPress SSO connection',
    ],
    'settings_exaport_wp_sso_enabled_body' => [
        'Enable WordPress connection. Options below must be configured',
        'Enable WordPress connection. Options below must be configured',
    ],
    'settings_exaport_wp_sso_error_no_url_configured' => [
        'First set up the "block_exaport/wp_sso_url" option',
        'First set up the "block_exaport/wp_sso_url" option',
    ],
    'settings_exaport_reload_settings_page' => [
        'Reload',
        'Reload',
    ],
    'settings_exaport_wp_sso_error_no_passphrase_registered' => [
        'The passphrase must be registered in the WordPress SSO server.',
        'The passphrase must be registered in the WordPress SSO server.',
    ],
    'settings_exaport_wp_sso_how_to_get_secret' => [
        'You need to register your "block_exaport/mysource" value into WordPress SSO server and get a secret code<br />Then you need to insert the secret code into field below and get the passphrase',
        'You need to register your "block_exaport/mysource" value into WordPress SSO server and get a secret code<br />Then you need to insert the secret code into field below and get the passphrase',
    ],
    'settings_exaport_wp_sso_url_to_get_secret' => [
        'Get the secret code',
        'Get the secret code',
    ],
    'settings_exaport_wp_sso_enter_secret_placeholder' => [
        'Enter the secret code',
        'Enter the secret code',
    ],
    'settings_exaport_wp_sso_request_passphrase_button' => [
        'Request the passphrase',
        'Request the passphrase',
    ],
    'settings_exaport_wp_sso_passphrase_ok' => [
        'The passphrase is configured',
        'The passphrase is configured',
    ],
    'settings_exaport_wp_sso_test_passphrase_button' => [
        'Test',
        'Test',
    ],
    'settings_exaport_wp_sso_remove_passphrase_button' => [
        'Remove the passphrase',
        'Remove the passphrase',
    ],
    'wp_exported_view' => [
        'Exportierte Ansicht',
        'Exported view',
    ],
    'wp_exported_view_hidden_in_wp' => [
        'Exportiert, aber in Wordpress ausgeblendet',
        'Exported but hidden in your WordPress',
    ],
    'wp_exported_view_newer_than_wp' => [
        'WordPress-Ansicht ist älter als die Moodle-Ansicht',
        'WordPress view version is older than Moodle version',
    ],
    'alwaysnotifywhenshare' => [
        'Immer benachrichtigen, wenn geteilt wird',
        'Always notify when sharing',
    ],
    'alwaysnotifywhenshare_description' => [
        'Wenn aktiviert, wird das Kontrollkästchen "Benachrichtige Benutzer" automatisch aktiviert und deaktiviert, wenn das Kontrollkästchen "Teilen" angeklickt wird.',
        'When enabled, the notify users checkbox will be automatically checked and disabled when the share checkbox is clicked.',
    ],
];
?>
