define("block_timezoneclock/main",["exports","core_form/dynamicform","core/templates","core/fragment","core/notification","core_filters/events"],(function(_exports,_dynamicform,_templates,_fragment,_notification,_events){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Main js functions for block_timezoneclock
   *
   * @module block_timezoneclock/main
   * @copyright 2022 Harshil Patel <harshil8595@gmail.com>
   * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.registerForm=_exports.makeSelectEnhanced=_exports.initBlock=void 0,_dynamicform=_interopRequireDefault(_dynamicform),_fragment=_interopRequireDefault(_fragment);let monthNames,select2registered=!1;const to24Hour=(hour,period)=>{let h=parseInt(hour,10);return"AM"===period&&12===h?"00":("PM"===period&&h<12&&(h+=12),String(h).padStart(2,"0"))},getNumericMonth=monthName=>{monthNames=monthNames||function(){let monthFormat=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"long";const format=new Intl.DateTimeFormat("en",{month:monthFormat}).format;return[...Array(12)].map(((_,i)=>{const d=new Date;return d.setMonth(i),format(d)}))}();const index=monthNames.indexOf(monthName);return-1!==index?String(index+1).padStart(2,"0"):""},getDateInfo=function(timeZone,dateFormat){var _parts$weekday,_parts$month,_parts$year,_parts$dayPeriod,_parts$dayPeriod2;let date=arguments.length>2&&void 0!==arguments[2]?arguments[2]:new Date;const is12Hour=/[hagA]/.test(dateFormat),needsWeekday=/[Dl]/.test(dateFormat),needsMonthName=/[FM]/.test(dateFormat),formatter=new Intl.DateTimeFormat("en",{timeZone:timeZone,year:"numeric",month:needsMonthName?"long":"2-digit",day:"2-digit",weekday:needsWeekday?"long":void 0,hour:"2-digit",minute:"2-digit",second:"2-digit",hour12:is12Hour,timeZoneName:"longOffset"}),parts=formatter.formatToParts(date).reduce(((acc,part)=>("literal"!==part.type&&(acc[part.type]=part.value),acc)),{}),shortWeekday=null===(_parts$weekday=parts.weekday)||void 0===_parts$weekday?void 0:_parts$weekday.slice(0,3),shortMonth=null===(_parts$month=parts.month)||void 0===_parts$month?void 0:_parts$month.slice(0,3),twoDigitYear=null===(_parts$year=parts.year)||void 0===_parts$year?void 0:_parts$year.slice(-2),replacements={Y:parts.year,y:twoDigitYear,m:/^\d+$/.test(parts.month)?parts.month:getNumericMonth(parts.month),F:parts.month||"",M:shortMonth||"",d:parts.day,H:is12Hour?to24Hour(parts.hour,parts.dayPeriod):parts.hour,h:parts.hour,g:String(parseInt(parts.hour,10)),i:parts.minute,s:parts.second,A:(null===(_parts$dayPeriod=parts.dayPeriod)||void 0===_parts$dayPeriod?void 0:_parts$dayPeriod.toUpperCase())||"",a:(null===(_parts$dayPeriod2=parts.dayPeriod)||void 0===_parts$dayPeriod2?void 0:_parts$dayPeriod2.toLowerCase())||"",D:shortWeekday||"",l:parts.weekday||""};return replacements.timeZoneName=parts.timeZoneName,replacements},updateTime=dateFormat=>{document.querySelectorAll('[data-region="clock"]:not([data-autoupdate="false"])').forEach((clock=>{const datefractions=getDateInfo(clock.dataset.timezone,dateFormat);clock.querySelectorAll("[data-fraction]").forEach((sp=>{const{fraction:fraction,unit:unit}=sp.dataset;fraction in datefractions&&unit!=datefractions[fraction]&&(sp.style.setProperty("--unit",datefractions[fraction]),sp.setAttribute("data-unit",datefractions[fraction]),sp.firstElementChild.innerText=datefractions[fraction])}))})),setTimeout((()=>updateTime(dateFormat)),1e3)},makeSelectEnhanced=function(){let parentNode=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document;require(["theme_boost/index","".concat(M.cfg.wwwroot,"/blocks/timezoneclock/tom-select/js/tom-select.complete.min.js")],((_,TomSelect)=>{[].concat(parentNode).forEach((pNode=>{pNode.querySelectorAll('[data-selectenhanced="1"]').forEach((node=>{node.classList.remove("custom-select"),new TomSelect(node,{openOnFocus:!0,maxOptions:null,plugins:[]})}))}))}))};_exports.makeSelectEnhanced=makeSelectEnhanced;_exports.initBlock=dateFormat=>{const d=new Date;setTimeout((()=>updateTime(dateFormat)),1e3-d.getMilliseconds()),select2registered||(select2registered=!0,document.addEventListener(_events.eventTypes.filterContentUpdated,(e=>{makeSelectEnhanced(e.detail.nodes)})));const replacecomputertznode=document.querySelector('[data-action="replacecomputertimezone"]');if(replacecomputertznode){const computrertz=Intl.DateTimeFormat().resolvedOptions().timeZone;replacecomputertznode.setAttribute("data-timezone",computrertz),updateTime(dateFormat),replacecomputertznode.removeAttribute("data-action")}};_exports.registerForm=(formUniqId,dateFormat)=>{const form=document.getElementById(formUniqId),r=new RegExp("(day|month|year|hour|minute)");if(form){const dForm=new _dynamicform.default(form,form.dataset.formClass),getTypeFromElement=sel=>sel.name.match(r).pop(),generateTimeStamp=()=>{const timestampInput=dForm.getFormNode().elements.timestamp,timezoneSelection=dForm.getFormNode().elements.timezone,fractions=[...dForm.getFormNode().querySelector('[data-fieldtype="date_time_selector"]').querySelectorAll("select")].reduce(((acc,sel)=>({...acc,[getTypeFromElement(sel)]:sel.value.padStart(2,0)})),{}),{year:year,month:month,day:day,hour:hour,minute:minute}=fractions,date=new Date("".concat(year,"-").concat(month,"-").concat(day,"T").concat(hour,":").concat(minute,":00.000")),gmtOffset=getDateInfo(timezoneSelection.value,dateFormat,date).timeZoneName.split("GMT").pop(),d=new Date(date+gmtOffset);timestampInput.value=Math.round(d.valueOf()/1e3)},clientTimezone=Intl.DateTimeFormat().resolvedOptions().timeZone,urlParams=new URLSearchParams([...new URLSearchParams(location.search).entries(),...Object.entries({...form.dataset,timezone:clientTimezone})]);dForm.load(Object.fromEntries(urlParams)).then((()=>{0===form.nextElementSibling.childElementCount&&dForm.submitFormAjax({firstload:1})})).catch(_notification.exception),dForm.addEventListener(dForm.events.FORM_SUBMITTED,(e=>{e.preventDefault(),(0,_templates.replaceNodeContents)(form.nextElementSibling,e.detail.html,_fragment.default.processCollectedJavascript(e.detail.js))})),dForm.addEventListener("change",(e=>{const dateTimeNode=e.target.closest('[data-fieldtype="date_time_selector"]'),timezoneSelection=e.target.closest('[name="timezone"]');(dateTimeNode||timezoneSelection)&&generateTimeStamp()})),dForm.addEventListener("change",(e=>{const timestampInput=e.target.closest('[name="timestamp"]'),timezoneSelection=dForm.getFormNode().elements.timezone,dateTimeNode=dForm.getFormNode().querySelector('[data-fieldtype="date_time_selector"]');if(timestampInput){const d=new Date(0);d.setUTCSeconds(timestampInput.value);const info=getDateInfo(timezoneSelection.value,dateFormat,d);info.hour=Number(info.hour),dateTimeNode.querySelectorAll("select").forEach((sel=>{sel.value=info[getTypeFromElement(sel)]}))}}))}}}));

//# sourceMappingURL=main.min.js.map