<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings for block_timezoneclock
 *
 * @package   block_timezoneclock
 * @copyright 2022 Harshil Patel <harshil8595@gmail.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['additionaltimezones'] = 'Timezones';
$string['addtimezone'] = 'Add {no} timezone(s) to form';
$string['clocktype'] = 'Clock type';
$string['clocktype_desc'] = 'Default clock type i.e, digital or analogue';
$string['configtitle'] = 'Block title';
$string['configtitle_placeholder'] = 'Default: Timezone clock';
$string['convert'] = 'Convert';
$string['convertedtimes'] = 'Converted times';
$string['datestamp'] = 'Select time';
$string['datetimeformat'] = 'Format';
$string['datetimeformat_help'] = '<table class="generaltable table-sm">
   <thead>
      <tr>
         <th>Token</th>
         <th>Meaning</th>
         <th>Example</th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>Y</code></td>
         <td>4-digit year</td>
         <td><code>2025</code></td>
      </tr>
      <tr>
         <td><code>y</code></td>
         <td>2-digit year</td>
         <td><code>25</code></td>
      </tr>
      <tr>
         <td><code>m</code></td>
         <td>2-digit month</td>
         <td><code>04</code></td>
      </tr>
      <tr>
         <td><code>F</code></td>
         <td>Full month name</td>
         <td><code>April</code></td>
      </tr>
      <tr>
         <td><code>M</code></td>
         <td>Short month name</td>
         <td><code>Apr</code></td>
      </tr>
      <tr>
         <td><code>d</code></td>
         <td>2-digit day</td>
         <td><code>05</code></td>
      </tr>
      <tr>
         <td><code>H</code></td>
         <td>24-hour</td>
         <td><code>13</code></td>
      </tr>
      <tr>
         <td><code>h</code></td>
         <td>12-hour (padded)</td>
         <td><code>01</code></td>
      </tr>
      <tr>
         <td><code>g</code></td>
         <td>12-hour (unpadded)</td>
         <td><code>1</code></td>
      </tr>
      <tr>
         <td><code>i</code></td>
         <td>Minutes</td>
         <td><code>45</code></td>
      </tr>
      <tr>
         <td><code>s</code></td>
         <td>Seconds</td>
         <td><code>30</code></td>
      </tr>
      <tr>
         <td><code>A</code></td>
         <td>AM/PM (uppercase)</td>
         <td><code>PM</code></td>
      </tr>
      <tr>
         <td><code>a</code></td>
         <td>am/pm (lowercase)</td>
         <td><code>pm</code></td>
      </tr>
      <tr>
         <td><code>D</code></td>
         <td>Short weekday</td>
         <td><code>Sat</code></td>
      </tr>
      <tr>
         <td><code>l</code></td>
         <td>Full weekday</td>
         <td><code>Saturday</code></td>
      </tr>
   </tbody>
</table>';
$string['entervalidtimestamp'] = 'Enter valid unix stamp';
$string['fromtimezone'] = 'From timezone';
$string['invalid_datetimeformat'] = 'Invalid date format defined. See help for valid tokens. Extra characters ",", "/", ":", "-" or space allowed as seperator.';
$string['pagetitle:converter'] = 'Timezone Converter';
$string['pluginname'] = 'Timezone clock';
$string['preferred_timezones'] = 'Preferred Timezones';
$string['privacy:metadata'] = 'The timezone clock block only shows data stored in other locations.';
$string['timestamp'] = 'Unix stamp';
$string['timestamp_placeholder'] = 'Input unixstamp';
$string['timestampnotentered'] = 'Either you have to enter unix Stamp Or select time';
$string['timezoneclock:addinstance'] = 'Add a timezone clock block';
$string['timezoneclock:myaddinstance'] = 'Add a timezone clock block to dashboard';
$string['timezoneconveter'] = 'Converter';
$string['timezones'] = 'Timezones';
$string['timezoneuser'] = 'Your timezone ({$a})';
$string['title'] = 'Timezone clock';
$string['toggletimeinput'] = 'Toggle unixstamp';
$string['toggletimeinput_checkicons'] = '<i class="fa-regular fa-square-check"></i><i class="fa-solid fa-square-check"></i>';
$string['totimezones'] = 'To Timezones';
$string['typeanalog'] = 'Analogue';
$string['typedigital'] = 'Digital';
$string['tzinformation:computerlabel'] = '💻 Computer';
$string['tzinformation:serverlabel'] = 'Server';
$string['tzinformation:title'] = 'Clock';
$string['yourtimezone'] = 'Your timezone';
