<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Stream theme original text strings-
 *
 * @package     theme_stream
 * @category    string
 * @copyright   2022 Hugo Ribeiro <ribeiro.hugo@gmail.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['availablesoon'] = 'Available soon';
$string['backtotopbutton'] = 'Back to top';
$string['backtotopbutton_desc'] = 'Back to top option like in Boost < 4.0';
$string['bunnyfonts'] = 'External font to use';
$string['bunnyfonts_desc'] = 'Select which Bunny Font to use. This service is EU based and doesn\'t store any data. More info: https://bunny.net/fonts/';
$string['catwidget'] = 'Show categories widget';
$string['catwidget_desc'] = 'Show a number of courses categories in a grid layout.';
$string['catwidgetcolumns'] = 'Grid columns number';
$string['catwidgetcolumns_desc'] = 'How many columns should we show.';
$string['catwidgetheading'] = 'Categories Widget';
$string['catwidgetimage'] = 'Category card image';
$string['catwidgetimage_desc'] = 'You can choose a default image to be showed if a givencategory is missing images from the courses.
This image will be repeated if there are more than one category missing images.';
$string['centercolumn'] = 'Center column.';
$string['centercolumn_desc'] = 'HTML content to include in the center column. Usually a list links but it can be any HTML. Bear in mind that the footer is rendered in 3 columns.';
$string['choosencats'] = 'Categories to show';
$string['choosencats_desc'] = 'Choose categories to show in the widget. Don\'t select too many.';
$string['choosereadme'] = 'Stream theme';
$string['colours'] = 'Colours settings';
$string['configtitle'] = 'Stream';
$string['counthiddencourses'] = 'Count hidden courses';
$string['counthiddencourses_desc'] = 'If enabled, counts the total number of courses in categories including the hidden ones.';
$string['coursecardimage'] = 'Course card image';
$string['coursecardimage_desc'] = 'Image to use on any course card missing one. If this happens and this setting is also empty we will look into the theme\'s default folder.';
$string['coursecompletion_desc'] = 'Show own user\'s course completion meter in the course main page';
$string['courseheaderimg'] = 'Course header standard image';
$string['courseheaderimg_desc'] = 'Standard image to be used in courses\' header if no other is provided in course context';
$string['customstylessettings'] = 'Custom styles';
$string['externalfonts'] = 'External fonts';
$string['externalfonts_desc'] = 'Activate external fonts service';
$string['facebookurl'] = 'Facebook URL';
$string['favicon'] = 'Custom favicon';
$string['favicon_desc'] = 'Upload your own .ico favicon.';
$string['featuredcategories'] = 'Featured categories';
$string['featuredcourses'] = 'Featured courses';
$string['featuredcoursescopy'] = 'With our online courses, you can learn anytime, anywhere, at your own pace. <a href="course/" >Explore them!</a>';
$string['featuredcoursesfuture'] = 'Show only future courses';
$string['featuredcoursesfuture_desc'] = 'If enabled, we will show only courses starting from today on.';
$string['featuredcoursesfuturerange'] = 'Courses starting in a time period';
$string['featuredcoursesfuturerange_desc'] = 'Time ahead for which to show featured courses. Always in the future.';
$string['featuredcourseshidden'] = 'Show hidden courses';
$string['featuredcourseshidden_desc'] = 'If enabled, the query will return also hidden courses';
$string['featuredcoursesrating'] = 'Show course rating';
$string['featuredcoursesrating_desc'] = 'You need to install the Course Rating plugin and check this option to have this information showing on each course card.';
$string['featuredcoursesshowcat'] = 'Show category';
$string['featuredcoursesshowcat_desc'] = 'Show course category in each card.';
$string['featuredcoursesshowcatfirst'] = 'Show first level category';
$string['featuredcoursesshowcatfirst_desc'] = 'If enabled, print first level category instead than the sub-category directly related to the course.';
$string['featuredcoursesshowcatmax'] = 'Max courses';
$string['featuredcoursesshowcatmax_desc'] = 'How many courses max should we retrieve from the database.';
$string['featuredcoursesstartdate'] = 'Show course start date';
$string['featuredcoursesstartdate_desc'] = 'If enabled, show the date in which the course will start.';
$string['featuredcourseswidget'] = 'Featured courses widget';
$string['featuredcourseswidget_desc'] = 'Show a section where featured courses are presented in a 3 column card layout. By default,  we query visible courses with a future start date. Check the following settings to check how to tweek that.';
$string['featuredcourseswidgetheading'] = 'Featured courses widget';
$string['fonts'] = 'Font type';
$string['footercolor'] = 'Big footer color';
$string['footercolor_desc'] = 'Main footer background color';
$string['footersettings'] = 'Footer content';
$string['frontendby'] = 'Frontend by Stream theme';
$string['frontpagestream'] = 'Frontpage settings';
$string['fullwidthpage'] = 'Full width';
$string['fullwidthpage_desc'] = 'Full width across all the site. Default behaviour from Boost if empty.';
$string['generalsettings'] = 'General settings';
$string['herolink'] = 'Link URL';
$string['herolink_desc'] = 'URL to print the link for the hero button. It also shows a call-to-action button';
$string['heromotto'] = 'Slider motto';
$string['heromotto_desc'] = 'Motto to print after the title on each slide.';
$string['herotitle'] = 'Hero image highlight';
$string['herotitle_desc'] = 'Text to show on top of each slider image. Heading 1 title.';
$string['hiddencourse'] = 'This course is hidden from students.';
$string['hideprimarynodes'] = 'Hide primary menu nodes';
$string['hideprimarynodes_desc'] = 'One can choose which options should be removed from the first level menu';
$string['homepageheroimage'] = 'Hero image';
$string['homepageheroimage_desc'] = 'Image to show as a background on the main highlight.';
$string['homepagepromoboxbutton'] = 'Button text';
$string['homepagepromoboxbutton_desc'] = 'Text to show in the promobox button.';
$string['homepagepromoboximage'] = 'Promobox image';
$string['homepagepromoboximage_desc'] = 'Image to show in the right side of the promobox widget.';
$string['homepagepromoboxtext'] = 'Promobox text';
$string['homepagepromoboxtext_default'] = 'A wizarding school (also called a magical school) is an educational institution which provides magical instruction to young witches and wizards. Feel like trying? Register now and have fun!';
$string['homepagepromoboxtext_desc'] = 'Text to show in the left side.';
$string['homepagepromoboxtitle'] = 'Promobox title';
$string['homepagepromoboxtitle_desc'] = 'Text to be used as heading for the promobox.';
$string['homepagepromoboxurl'] = 'Button link';
$string['homepagepromoboxurl_desc'] = 'URL to use as a link for the button. Defaults to register page';
$string['homepagepromoboxwidget'] = 'Show promobox widget';
$string['homepagepromoboxwidget_desc'] = 'Show a marketing section with a message, a call to action on the left, and an image on the right.';
$string['instagramurl'] = 'Instagram URL';
$string['jumptoslide'] = 'Go to slide';
$string['leftcolumn'] = 'Left column.';
$string['leftcolumn_desc'] = 'HTML content to include in the left column. Usually a list links but it can be any HTML. Bear in mind that the footer is rendered in 3 columns.';
$string['linkedinurl'] = 'Linkedin URL';
$string['loginimg'] = 'Image on the login page';
$string['loginimg_desc'] = 'Login page is presented on 2 columns: login form on the left and an image on the right. Here you upload that image';
$string['managecourses'] = 'Manage courses';
$string['management'] = 'Manage';
$string['manageusers'] = 'Manage users';
$string['maxcatnumber'] = 'Max categories to show';
$string['maxcatnumber_desc'] = 'Max number of categories we should show in the widget; Your query will be limited to this.';
$string['next'] = 'Next';
$string['nextactivity'] = 'Next activity';
$string['noresults'] = 'Found no results';
$string['pinteresturl'] = 'Pinterest URL';
$string['pluginname'] = 'Stream';
$string['prev'] = 'Previous';
$string['prevactivity'] = 'Previous activity';
$string['primarycolour'] = 'Main colour';
$string['primarycolour_desc'] = 'Brand colour';
$string['promoboxwidgetheading'] = 'Promobox widget';
$string['region-topblock'] = 'Course top area';
$string['searchcourses'] = 'Search courses';
$string['searchusers'] = 'Search users';
$string['secondarycolour'] = 'Secondary colour';
$string['secondarycolour_desc'] = 'Brand second colour';
$string['showcoursescount'] = 'Show courses count';
$string['showcoursescount_desc'] = 'If set, show the total number of courses in each category';
$string['sliderbutton'] = 'Button text';
$string['sliderbutton_desc'] = 'Depending on the added URL, you can specify a text to show on the button.';
$string['slidersettingheading'] = 'Slider contents';
$string['slidestotal'] = 'Number of slider items';
$string['slidestotal_desc'] = 'Select here how many items you wanto to include on the main slider. You need to save changes before adding content.';
$string['socialmedia'] = 'Social Media';
$string['stickynav'] = 'Sticky secondary menu';
$string['stickynav_desc'] = 'Make secondary menu always visible';
$string['stream:changesettings'] = 'Capability to allow non admin users to change theme settings.';
$string['themesettings'] = 'Theme settings';
$string['twitterurl'] = 'Twitter URL';
$string['usingstreamtheme'] = 'with Stream Theme';
$string['youtubeurl'] = 'Youtube URL';

// Privacy API.
$string['privacy:metadata'] = 'Stream theme does not store any personal data about any user.';
$string['featuredcategoriessubtitle'] = 'Categories widget subtitle';
$string['featuredcategoriessubtitle_desc'] = 'A simple text to use as subtitle for the widget. Will show nothing if setting is empy.';
// End of Privacy API.
$string['courseindexheading'] = 'Show extra info in the course index.';
$string['courseindexheading_desc'] = 'Show course name or shortname as heading in the course index.';
$string['homepageheroopacity'] = 'Overlay opacity';
$string['homepageheroopacity_desc'] = 'Overlay opacity. 0 transparent, 10 solid dark gray';
