<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Webhook for receiving events from ifthenpay.
 *
 * @package    paygw_ifthenpay
 * @copyright  2025 ifthenpay <geral@ifthenpay.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define('NO_MOODLE_COOKIES', true);

require(__DIR__ . '/../../../config.php');
require_once(__DIR__ . '/lib.php');

@header('Content-Type: text/plain; charset=utf-8');

// Query params.
$amount   = required_param('amount', PARAM_RAW_TRIMMED);
$token    = required_param('reference', PARAM_ALPHANUMEXT);
$apk      = required_param('apk', PARAM_RAW_TRIMMED);

// Delegate to the shared processor (idempotent).
$ok = paygw_ifthenpay_process_webhook($token, (string)$amount, (string)$apk);

// Keep provider contract simple.
echo $ok ? 'OK' : 'INVALID';
