define("aiprovider_datacurso/consumption",["exports","core/ajax","core/str"],(function(_exports,_ajax,_str){var obj;
/**
   * Consumption history table management.
   *
   * @module     aiprovider_datacurso/consumption
   * @copyright  2025 Industria Elearning
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=(obj=_ajax)&&obj.__esModule?obj:{default:obj};_exports.init=()=>{if(window._consumptionInitialized)return void console.warn("⚠️ Módulo de consumo ya inicializado — se omite nueva carga.");window._consumptionInitialized=!0,console.log("Historial de consumo inicializado ✅");const tableBody=document.getElementById("consumption-table-body"),filterService=document.getElementById("filter-service"),filterAction=document.getElementById("filter-action"),filterFrom=document.getElementById("filter-date-from"),filterTo=document.getElementById("filter-date-to"),prevPageBtn=document.getElementById("prev-page"),nextPageBtn=document.getElementById("next-page"),pageInfo=document.getElementById("page-info");let currentSortField="",currentSortDir="asc";const limitSelect=document.getElementById("filter-limit"),pageInput=document.getElementById("filter-page");let currentPage=parseInt(sessionStorage.getItem("consumptionPage"))||1,currentLimit=parseInt(sessionStorage.getItem("consumptionLimit"))||10;const savePage=page=>sessionStorage.setItem("consumptionPage",page),fetchData=()=>{const serviceValue=filterService.value,actionValue=filterAction.value,fromValue=filterFrom.value,toValue=filterTo.value,args={page:currentPage,limit:currentLimit,servicio:"all"!==serviceValue?serviceValue:"",accion:"all"!==actionValue?actionValue:"",fechadesde:fromValue||"",fechahasta:toValue||""};currentSortField&&(args.short=currentSortField,args.shortdir=currentSortDir),console.log("📤 Enviando petición al WS con args:",JSON.stringify(args)),_ajax.default.call([{methodname:"aiprovider_datacurso_get_consumption_history",args:args}])[0].then((response=>{console.log("📥 Respuesta del servidor:",response);(consumos=>{if(tableBody.innerHTML="",!consumos||0===consumos.length)return(0,_str.get_string)("nodata","aiprovider_datacurso").then((nodata=>{tableBody.innerHTML='<tr><td colspan="7">'.concat(nodata,"</td></tr>")})),pageInfo.textContent="",prevPageBtn.disabled=!0,void(nextPageBtn.disabled=!0);consumos.forEach((item=>{const row=document.createElement("tr");row.innerHTML="\n                <td>".concat(item.id_consumption,"</td>\n                <td>").concat(item.userid||"-","</td>\n                <td>").concat(item.action,"</td>\n                <td>").concat(item.id_service,"</td>\n                <td>").concat(item.cant_tokens,"</td>\n                <td>").concat(item.balance,"</td>\n                <td>").concat(item.date,"</td>\n            "),tableBody.appendChild(row)}))})((null==response?void 0:response.consumption)||[]);const pagination=null==response?void 0:response.pagination;if(pagination){const{current_page:current_page,total_pages:total_pages,total:total}=pagination;pageInfo.textContent="Página ".concat(current_page," de ").concat(total_pages," (").concat(total," registros)"),pageInput&&(pageInput.value=current_page),prevPageBtn.disabled=current_page<=1,nextPageBtn.disabled=current_page>=total_pages}else pageInfo.textContent="",prevPageBtn.disabled=!0,nextPageBtn.disabled=!0})).catch((async e=>{const nodata=await(0,_str.get_string)("nodata","aiprovider_datacurso");tableBody.innerHTML='<tr><td colspan="7">'.concat(nodata,"</td></tr>"),console.error("❌ Error al obtener historial de consumo:",e)}))};[filterService,filterAction,filterFrom,filterTo].forEach((el=>{el.addEventListener("change",(()=>{currentPage=1,savePage(currentPage),fetchData()}))})),prevPageBtn.addEventListener("click",(()=>{currentPage>1&&(currentPage--,savePage(currentPage),fetchData())})),nextPageBtn.addEventListener("click",(()=>{currentPage++,savePage(currentPage),fetchData()})),limitSelect&&(limitSelect.value=currentLimit,limitSelect.addEventListener("change",(()=>{var limit;currentLimit=parseInt(limitSelect.value),limit=currentLimit,sessionStorage.setItem("consumptionLimit",limit),currentPage=1,savePage(currentPage),fetchData()}))),pageInput&&pageInput.addEventListener("change",(()=>{const newPage=parseInt(pageInput.value);newPage&&newPage>0&&(currentPage=newPage,savePage(currentPage),fetchData())})),document.querySelectorAll(".sortable").forEach((header=>{header.addEventListener("click",(()=>{const field=header.dataset.sort,icon=header.querySelector(".sort-icon");currentSortField===field?currentSortDir="asc"===currentSortDir?"desc":"asc":(currentSortField=field,currentSortDir="asc"),document.querySelectorAll(".sort-icon").forEach((i=>{i.className="fa fa-sort sort-icon"})),icon.className="asc"===currentSortDir?"fa fa-sort-up sort-icon":"fa fa-sort-down sort-icon",currentPage=1,savePage(currentPage),fetchData()}))})),Promise.all([(async()=>{try{var _response$services;const response=await _ajax.default.call([{methodname:"aiprovider_datacurso_get_services",args:{}}])[0];filterService.innerHTML='<option value="all">Todos los servicios</option>',null!=response&&null!==(_response$services=response.services)&&void 0!==_response$services&&_response$services.length&&response.services.forEach((s=>{const opt=document.createElement("option");opt.value=s.name,opt.textContent=s.name,filterService.appendChild(opt)}))}catch(error){console.error("❌ Error al cargar servicios:",error)}})(),(async()=>{try{var _response$actions;const response=await _ajax.default.call([{methodname:"aiprovider_datacurso_get_actions",args:{}}])[0];filterAction.innerHTML='<option value="all">Todas las acciones</option>',null!=response&&null!==(_response$actions=response.actions)&&void 0!==_response$actions&&_response$actions.length&&response.actions.forEach((a=>{const opt=document.createElement("option");opt.value=a.id,opt.textContent=a.name,filterAction.appendChild(opt)}))}catch(error){console.error("❌ Error al cargar acciones:",error)}})()]).then((()=>fetchData())).catch((e=>console.error("❌ Error durante carga inicial:",e)))}}));

//# sourceMappingURL=consumption.min.js.map