define("aiprovider_datacurso/report_charts",["exports","core/ajax","core/chartjs"],(function(_exports,_ajax,_chartjs){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Report charts module.
   *
   * @module     aiprovider_datacurso/report_charts
   * @copyright  2025 Industria Elearning
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_chartjs=_interopRequireDefault(_chartjs);_exports.init=()=>{const tokensAvailable=document.getElementById("tokens-available"),tokensConsumed=document.getElementById("tokens-consumed");let chartBar,chartPie,chartDay,cachedData=[];Promise.all([_ajax.default.call([{methodname:"aiprovider_datacurso_get_tokens_saldo",args:{}}])[0],_ajax.default.call([{methodname:"aiprovider_datacurso_get_services",args:{}}])[0],_ajax.default.call([{methodname:"aiprovider_datacurso_get_all_consumption",args:{}}])[0]]).then((_ref=>{let[saldoResponse,servicesResponse,consumptionResponse]=_ref;const saldo=(null==saldoResponse?void 0:saldoResponse.saldo_actual)||0;tokensAvailable.textContent=saldo;const servicios=(null==servicesResponse?void 0:servicesResponse.services)||[];cachedData=(null==consumptionResponse?void 0:consumptionResponse.consumption)||[],initCharts(servicios)})).catch((err=>console.error("Error:",err)));const initCharts=servicios=>{const filterBar=document.getElementById("filter-service-bar"),filterPie=document.getElementById("filter-service-pie"),filterStart=document.getElementById("filter-start-date"),filterEnd=document.getElementById("filter-end-date"),fillSelect=select=>{select.innerHTML='<option value="">Todos</option>',null!=servicios&&servicios.length&&servicios.forEach((s=>{const opt=document.createElement("option");opt.value=s.name,opt.textContent=s.name,select.appendChild(opt)}))};fillSelect(filterBar),fillSelect(filterPie),renderBarChart(cachedData),renderPieChart(cachedData),renderDayChart(cachedData),filterBar.addEventListener("change",(()=>updateBarChart())),filterPie.addEventListener("change",(()=>updatePieChart())),filterStart.addEventListener("change",(()=>updateDayChart())),filterEnd.addEventListener("change",(()=>updateDayChart()))},fetchConsumptionData=async function(){let params=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const defaults={servicio:"",accion:"",fechadesde:"",fechahasta:""},finalParams={...defaults,...params};try{const response=await _ajax.default.call([{methodname:"aiprovider_datacurso_get_all_consumption",args:finalParams}])[0];return"success"!==response.status?(console.warn("⚠️ WS devolvió estado:",response.status),[]):response.consumption||[]}catch(error){return console.error("❌ Error al obtener consumos:",error),[]}},renderBarChart=data=>{const byMonth={};data.forEach((c=>{const month=c.date.substring(0,7);byMonth[month]=(byMonth[month]||0)+c.cant_tokens}));const totalTokens=data.reduce(((sum,c)=>sum+(c.cant_tokens||0)),0);tokensConsumed.textContent=totalTokens;const ctx=document.getElementById("chart-tokens-by-month");chartBar&&chartBar.destroy(),chartBar=new _chartjs.default(ctx,{type:"bar",data:{labels:Object.keys(byMonth),datasets:[{label:"Tokens consumidos por mes",data:Object.values(byMonth),backgroundColor:"#0073e6"}]},options:{responsive:!0,maintainAspectRatio:!1}})},updateBarChart=async()=>{const servicio=document.getElementById("filter-service-bar").value;if(!servicio)return renderBarChart(cachedData);const data=await fetchConsumptionData({servicio:servicio});renderBarChart(data)},renderPieChart=data=>{const byAction={};data.forEach((c=>{byAction[c.action]=(byAction[c.action]||0)+c.cant_tokens}));const ctx=document.getElementById("chart-actions");chartPie&&chartPie.destroy(),chartPie=new _chartjs.default(ctx,{type:"pie",data:{labels:Object.keys(byAction),datasets:[{data:Object.values(byAction),backgroundColor:["#36A2EB","#FF6384","#f1d48bff","#4BC0C0","#0f9c9cff","#0b6eb0ff","#d10f39ff","#c18f12ff","#457f7fff","#a50562ff","#4BC0C0","#efef21ff","#252f2fff","#8f9191ff"]}]},options:{responsive:!0,maintainAspectRatio:!1}})},updatePieChart=async()=>{const servicio=document.getElementById("filter-service-pie").value;if(!servicio)return renderPieChart(cachedData);const data=await fetchConsumptionData({servicio:servicio});renderPieChart(data)},renderDayChart=data=>{const byDay={};data.forEach((c=>{const day=c.date.substring(0,10);byDay[day]=(byDay[day]||0)+c.cant_tokens}));const labels=Object.keys(byDay).sort(((a,b)=>new Date(a)-new Date(b))),values=labels.map((day=>byDay[day])),ctx=document.getElementById("chart-tokens-by-day");chartDay&&chartDay.destroy(),chartDay=new _chartjs.default(ctx,{type:"line",data:{labels:labels,datasets:[{label:"Tokens consumidos por día",data:values,borderColor:"#28a745",backgroundColor:"rgba(40,167,69,0.2)",fill:!0,tension:.2,pointRadius:4,pointHoverRadius:6,borderWidth:2}]},options:{responsive:!0,maintainAspectRatio:!1,scales:{x:{title:{display:!0,text:"Fecha"}},y:{title:{display:!0,text:"Tokens consumidos"},beginAtZero:!0}}}})},updateDayChart=async()=>{const fechadesde=document.getElementById("filter-start-date").value,fechahasta=document.getElementById("filter-end-date").value;if(!fechadesde&&!fechahasta)return renderDayChart(cachedData);const data=await fetchConsumptionData({fechadesde:fechadesde,fechahasta:fechahasta});renderDayChart(data)}}}));

//# sourceMappingURL=report_charts.min.js.map