<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     aiprovider_datacurso
 * @category    string
 * @copyright   Josue <josue@datacurso.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acción';
$string['action:explain_text:endpoint'] = 'Punto final para explicar texto';
$string['action:explain_text:model'] = 'Modelo para explicación';
$string['action:explain_text:model_help'] = 'Seleccione el modelo que generará las explicaciones.';
$string['action:explain_text:systeminstruction'] = 'Instrucción del sistema para explicación';
$string['action:explain_text:systeminstruction_help'] = 'Proporcione contexto para guiar el proceso de explicación.';
$string['action:generate_image:endpoint'] = 'Punto final para generar imagen';
$string['action:generate_image:model'] = 'Modelo para generación de imágenes';
$string['action:generate_image:model_help'] = 'Seleccione el modelo de IA para generar imágenes.';
$string['action:generate_image:systeminstruction'] = 'Instrucción del sistema para generación de imágenes';
$string['action:generate_image:systeminstruction_help'] = 'Instrucciones adicionales que guían a la IA en la generación de la imagen deseada.';
$string['action:generate_text:endpoint'] = 'Punto final para generar texto';
$string['action:generate_text:instruction'] = 'Instrucción del sistema';
$string['action:generate_text:instruction_desc'] = 'Esta instrucción se envía al modelo de IA junto con la solicitud del usuario. No se recomienda editar esta instrucción a menos que sea absolutamente necesario.';
$string['action:generate_text:model'] = 'Modelo para generación de texto';
$string['action:generate_text:model_help'] = 'Seleccione qué modelo de IA se utilizará para generar el texto.';
$string['action:generate_text:systeminstruction'] = 'Instrucción del sistema';
$string['action:generate_text:systeminstruction_help'] = 'Instrucción o contexto dado a la IA antes de generar el texto. Útil para controlar el tono, estructura o propósito de la respuesta.';
$string['action:summarise_text:endpoint'] = 'Punto final para resumir texto';
$string['action:summarise_text:instruction'] = 'Instrucción del sistema';
$string['action:summarise_text:instruction_desc'] = 'Esta instrucción se envía al modelo de IA junto con la solicitud del usuario. No se recomienda editar esta instrucción a menos que sea absolutamente necesario.';
$string['action:summarise_text:model'] = 'Modelo para resumir';
$string['action:summarise_text:model_help'] = 'Seleccione qué modelo de IA se utilizará para resumir el texto.';
$string['action:summarise_text:systeminstruction'] = 'Instrucción del sistema para resumen';
$string['action:summarise_text:systeminstruction_help'] = 'Contexto opcional para influir en cómo se genera el resumen.';
$string['all'] = 'Todos';
$string['alt_datacurso_icon'] = 'Icono de Datacurso';
$string['apikey'] = 'Clave API';
$string['apikey_desc'] = 'Ingrese la clave API de su servicio Datacurso para conectar la IA.';
$string['apiurl'] = 'URL base de la API';
$string['apiurl_desc'] = 'Ingrese la URL base del servicio para conectarse a la API de Datacurso.';
$string['assigned'] = 'Asignado';
$string['chart_actions'] = 'Distribución de créditos por servicio';
$string['chart_tokens_by_day'] = 'Consumo de créditos por día';
$string['chart_tokens_by_month'] = 'Número de créditos consumidos por mes';
$string['configured'] = 'Configurado';
$string['connection'] = 'Configuración de conexión';
$string['contextwstoken'] = 'Token de servicio web para contexto de curso';
$string['contextwstoken_desc'] = 'Token utilizado por la IA para recuperar información del curso (contexto). Almacenado de forma segura. Crear/administrar tokens en Administración del sitio > Servidor > Servicios web > Administrar tokens.';
$string['created'] = 'Creado';
$string['curlerror'] = 'Error cURL de API de Datacurso: {$a}';
$string['custom_model_name'] = 'Nombre de modelo personalizado';
$string['custom_model_name_help'] = 'Nombre opcional para identificar esta configuración específica del modelo de IA.';
$string['datacurso:configurews'] = 'Configurar servicio web de Datacurso';
$string['datacurso:manage'] = 'Administrar configuración del proveedor de IA';
$string['datacurso:use'] = 'Usar servicios de IA de Datacurso';
$string['datacurso:viewreports'] = 'Ver informes de uso de IA';
$string['day'] = 'día';
$string['days'] = 'Días';
$string['description'] = 'Descripción';
$string['descriptionpagelistplugins'] = 'Aquí puede encontrar la lista de plugins compatibles con el proveedor Datacurso';
$string['disabled'] = 'Deshabilitado';
$string['emptyprompt'] = 'Solicitud vacía';
$string['emptyresponse'] = 'Sin respuesta de la API de Datacurso.';
$string['enabled'] = 'Habilitado';
$string['enableglobalratelimit'] = 'Habilitar límite global';
$string['enableglobalratelimit_desc'] = 'Si está habilitado, se aplicará un límite global de solicitudes por hora para todos los usuarios.';
$string['enableuserratelimit'] = 'Habilitar límite por usuario';
$string['enableuserratelimit_desc'] = 'Si está habilitado, cada usuario tendrá un límite de solicitudes por hora.';
$string['endpointurl'] = 'URL del punto final';
$string['endpointurl_help'] = 'URL del punto final base de la API del proveedor de IA Datacurso. Normalmente algo como https://api.datacurso.ai/v1/.';
$string['error_ratelimit_exceeded'] = 'Se ha superado el límite de consumo permitido. Por favor, intente nuevamente en {$a}.';
$string['error_webservice_not_configured'] = 'Esta acción no puede continuar porque el servicio web de Datacurso que alimenta datos contextuales a la IA no está configurado. Complete la configuración automática en <a href="{$a->url}">Configuración del servicio web de Datacurso</a> e intente nuevamente. O contacte a su administrador para más información.';
$string['errorgetbalancecredits'] = 'No se pudo recuperar el saldo de créditos de la API externa';
$string['errorinitinformation'] = 'No se pudo obtener la información inicial.';
$string['exists'] = 'Existe';
$string['forbidden'] = 'No tiene permiso para realizar esta acción con la licencia actual. Por favor, verifique su licencia y créditos disponibles en <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Administrar Créditos</a> en la Tienda de Datacurso.';
$string['generate_activitie'] = 'Generar actividad o recurso con IA';
$string['generate_ai_reinforcement_activity'] = 'Crear actividad de refuerzo con IA';
$string['generate_analysis_comments'] = 'Generar análisis de calificación de una actividad/recurso con IA';
$string['generate_analysis_course'] = 'Generar análisis de calificación del curso con IA';
$string['generate_analysis_general'] = 'Generar análisis de calificación general con IA';
$string['generate_analysis_story_student'] = 'Generar historia de análisis del estudiante con IA';
$string['generate_assign_answer'] = 'Generar revisión de tarea con IA';
$string['generate_certificate_answer'] = 'Generar mensaje de certificado con IA';
$string['generate_chat_message'] = 'Generar mensaje del tutor IA';
$string['generate_creation_course'] = 'Crear curso completo con IA';
$string['generate_forum_chat'] = 'Generar respuesta de foro con IA';
$string['generate_image'] = 'Generar imagen con IA';
$string['generate_plan_course'] = 'Generar plan de creación de curso con IA';
$string['generate_summary'] = 'Generar resumen con IA';
$string['generate_text'] = 'Generar texto con IA';
$string['globalratelimit'] = 'Límite global de solicitudes';
$string['globalratelimit_desc'] = 'Número máximo de solicitudes permitidas por hora para todo el sistema.';
$string['goto'] = 'Ir al Informe';
$string['gotopage'] = 'Ir a la página';
$string['hour'] = 'hora';
$string['hours'] = 'Horas';
$string['httperror'] = 'Error inesperado al procesar su solicitud (HTTP {$a}). Por favor, intente nuevamente más tarde. Si el problema persiste, contacte al administrador del sitio.';
$string['id'] = 'ID';
$string['installed'] = 'Instalado';
$string['invalidlicensekey'] = 'La clave de licencia ha expirado o no es válida. Por favor, vaya a <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Administrar Créditos</a> en la Tienda de Datacurso para renovar o comprar una nueva licencia.';
$string['json_encode_failed'] = 'Falló la codificación Json';
$string['jsondecodeerror'] = 'Error al procesar la respuesta de la API de Datacurso: {$a}';
$string['last_sent'] = 'Último enviado';
$string['license_not_allowed'] = 'Su licencia no tiene permiso para realizar esta solicitud. Por favor, administre sus licencias y créditos en <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Administrar Créditos</a> en la Tienda de Datacurso.';
$string['licensekey'] = 'Clave de licencia';
$string['licensekey_desc'] = 'Ingrese la clave de licencia del área de clientes de la Tienda de Datacurso.';
$string['licensekey_help'] = 'Ingrese su clave de licencia del proveedor de IA Datacurso.';
$string['link_consumptionhistory'] = 'Historial de consumo de créditos';
$string['link_generalreport'] = 'Informe general';
$string['link_generalreport_datacurso'] = 'Informe general de IA Datacurso';
$string['link_listplugings'] = 'Lista de plugins de Datacurso';
$string['link_plugin'] = 'Enlace';
$string['link_provider_config'] = 'Configuración del proveedor';
$string['link_report_statistic'] = 'Informe de estadísticas generales';
$string['link_webservice_config'] = 'Configuración del servicio web de Datacurso';
$string['live_log'] = 'Registro en vivo';
$string['message_no_there_plugins'] = 'No hay plugins disponibles';
$string['minute'] = 'minuto';
$string['minutes'] = 'Minutos';
$string['missing'] = 'Faltante';
$string['month'] = 'mes';
$string['months'] = 'Meses';
$string['needs_repair'] = 'Necesita reparación';
$string['nodata'] = 'No se encontró información';
$string['not_assigned'] = 'No asignado';
$string['not_configured'] = 'No configurado';
$string['not_created'] = 'No creado';
$string['notallowed'] = 'No tiene permiso para realizar esta acción. Por favor, contacte a su administrador para más información.';
$string['notenoughtokens'] = 'Créditos de IA insuficientes. Por favor, visite <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Administrar Créditos</a> en la Tienda de Datacurso para asignar o comprar más créditos. O contacte a su administrador.';
$string['of'] = 'de';
$string['orgid'] = 'ID de Organización';
$string['orgid_desc'] = 'Ingrese el identificador de su organización en el servicio Datacurso.';
$string['pageinfo'] = 'Página {$a->current} de {$a->totalpages} ({$a->total} registros)';
$string['pending'] = 'Pendiente';
$string['plugin'] = 'Plugin';
$string['plugindesc_assign_ai'] = 'Revise tareas con asistencia de IA.';
$string['plugindesc_coursegen'] = 'Cree cursos completos, actividades y recursos con IA.';
$string['plugindesc_datacurso_ratings'] = 'Permite a los estudiantes calificar actividades y recursos; los profesores y administradores pueden generar posteriormente análisis del curso basados en IA.';
$string['plugindesc_dttutor'] = 'Chatee con un tutor de IA dentro del curso.';
$string['plugindesc_forum_ai'] = 'Extienda los foros con análisis impulsado por IA para generar resúmenes automáticamente.';
$string['plugindesc_lifestory'] = 'Informe y análisis impulsado por IA del progreso académico del estudiante.';
$string['plugindesc_smartrules'] = 'Cree actividades automatizadas basadas en las condiciones previas de los estudiantes.';
$string['plugindesc_socialcert'] = 'Genere automáticamente certificados personalizados al completar el curso.';
$string['pluginname'] = 'Proveedor de IA Datacurso';
$string['pluginname_assign_ai'] = 'Tarea IA';
$string['pluginname_coursegen'] = 'Creador de Cursos IA';
$string['pluginname_datacurso_ratings'] = 'Calificación de Actividades IA';
$string['pluginname_dttutor'] = 'Tutor IA';
$string['pluginname_forum_ai'] = 'Foro IA';
$string['pluginname_lifestory'] = 'Historia de Vida del Estudiante IA';
$string['pluginname_smartrules'] = 'SmartRules IA';
$string['pluginname_socialcert'] = 'Compartir Certificado IA';
$string['privacy:metadata'] = 'El plugin Proveedor de IA Datacurso no almacena ningún dato personal localmente. Todos los datos son procesados por los servicios externos de IA de Datacurso.';
$string['privacy:metadata:aiprovider_datacurso'] = 'Cargas útiles de solicitudes de IA de Datacurso enviadas al servicio externo.';
$string['privacy:metadata:aiprovider_datacurso:externalpurpose'] = 'Estos datos se envían a IA Datacurso para cumplir con la acción solicitada.';
$string['privacy:metadata:aiprovider_datacurso:numberimages'] = 'Número total de imágenes solicitadas del servicio de IA.';
$string['privacy:metadata:aiprovider_datacurso:prompt'] = 'El texto de solicitud proporcionado al servicio de IA.';
$string['privacy:metadata:aiprovider_datacurso:userid'] = 'El ID de usuario de Moodle que realiza la solicitud de IA.';
$string['privacy:metadata:aiprovider_datacurso_rlimit'] = 'Estado de uso continuo del límite de tasa por usuario y por servicio almacenado localmente.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:lastsync'] = 'Marca de tiempo de la última sincronización con el historial remoto.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:serviceid'] = 'Identificador del servicio (ej. local_coursegen).';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timecreated'] = 'Hora en que se creó este registro.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timemodified'] = 'Hora en que se modificó por última vez este registro.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:tokensused'] = 'Créditos utilizados dentro de la ventana de tiempo actual.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:userid'] = 'ID de usuario relacionado con la ventana de consumo rastreada.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:windowstart'] = 'Marca de tiempo de inicio de ventana utilizada para calcular los límites de consumo.';
$string['ratelimit_enable'] = 'Habilitar límite';
$string['ratelimit_enable_desc'] = 'Si está habilitado, se aplicará el límite de crédito por usuario para este plugin.';
$string['ratelimit_limit'] = 'Créditos por ventana';
$string['ratelimit_limit_desc'] = 'Número máximo de créditos que un usuario puede consumir dentro de la ventana de tiempo seleccionada. 0 para ilimitado.';
$string['ratelimit_limit_help'] = 'El número máximo de solicitudes permitidas por ventana de límite de tasa.';
$string['ratelimit_local_assign_ai_allowedusers'] = 'Revisores de tareas permitidos (IA)';
$string['ratelimit_local_assign_ai_allowedusers_desc'] = 'Seleccione los usuarios que pueden revisar tareas con IA cuando este servicio esté habilitado.';
$string['ratelimit_local_assign_ai_allowedusers_desc_help'] = 'Esta configuración define una lista de usuarios específicos que están exentos del límite de velocidad global para este servicio de IA, permitiéndoles únicamente generar calificaciones o retroalimentación basadas en IA para las tareas de Moodle.';
$string['ratelimit_local_assign_ai_allowedusers_enable'] = 'Limitar por usuarios permitidos';
$string['ratelimit_local_assign_ai_allowedusers_enable_desc'] = 'Si está habilitado, solo los usuarios seleccionados a continuación podrán revisar tareas con IA.';
$string['ratelimit_local_coursegen_activitycreators'] = 'Creadores de actividades permitidos';
$string['ratelimit_local_coursegen_activitycreators_desc'] = 'Seleccione los usuarios que pueden generar actividades o recursos con IA cuando este servicio esté habilitado.';
$string['ratelimit_local_coursegen_allowedusers_enable'] = 'Limitar por usuarios permitidos';
$string['ratelimit_local_coursegen_allowedusers_enable_desc'] = 'Si está habilitado, solo los usuarios seleccionados a continuación podrán usar este servicio.';
$string['ratelimit_local_coursegen_coursecreators'] = 'Creadores de cursos permitidos';
$string['ratelimit_local_coursegen_coursecreators_desc'] = 'Seleccione los usuarios que pueden crear cursos completos con IA cuando este servicio esté habilitado.';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable'] = 'Limitar por usuarios permitidos';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable_desc'] = 'Si está habilitado, solo los usuarios seleccionados a continuación podrán generar análisis basados en IA en el plugin Calificación de Actividades IA.';
$string['ratelimit_local_datacurso_ratings_courseanalysts'] = 'Generadores de análisis de curso permitidos (IA)';
$string['ratelimit_local_datacurso_ratings_courseanalysts_desc'] = 'Seleccione los usuarios que pueden generar análisis de nivel de curso con IA.';
$string['ratelimit_local_datacurso_ratings_generalanalysts'] = 'Generadores de análisis general permitidos (IA)';
$string['ratelimit_local_datacurso_ratings_generalanalysts_desc'] = 'Seleccione los usuarios que pueden generar análisis general con IA a través de actividades o el curso.';
$string['ratelimit_report_lifestory_allowedusers'] = 'Generadores de retroalimentación IA permitidos';
$string['ratelimit_report_lifestory_allowedusers_desc'] = 'Seleccione los usuarios que pueden presionar "Generar Retroalimentación IA" para enviar datos de rendimiento del estudiante (calificaciones, finalización, participación) al Proveedor de IA Datacurso y mostrar la narrativa de IA con fortalezas, debilidades y recomendaciones.';
$string['ratelimit_report_lifestory_allowedusers_enable'] = 'Limitar por usuarios permitidos';
$string['ratelimit_report_lifestory_allowedusers_enable_desc'] = 'Si está habilitado, solo los usuarios seleccionados a continuación podrán generar retroalimentación IA en el informe Historia de Vida.';
$string['ratelimit_window'] = 'Ventana de tiempo';
$string['ratelimit_window_desc'] = 'Seleccione la duración y unidad para la ventana de límite de tasa.';
$string['ratelimit_window_unit'] = 'Unidad de ventana';
$string['ratelimit_window_value'] = 'Ventana de tiempo';
$string['ratelimits_heading'] = 'Límites de tasa por plugin';
$string['ratelimits_heading_desc'] = 'Configure límites de tasa por usuario por plugin que utiliza el proveedor Datacurso.';
$string['read_context_course'] = 'Leer contexto para creación de curso con IA';
$string['read_context_course_model'] = 'Cargar modelo académico para creación de curso con IA';
$string['registers'] = 'Registros';
$string['registration_error'] = 'Último error';
$string['registration_last'] = 'Registro';
$string['registration_lastsent'] = 'Último enviado';
$string['registration_notverified'] = 'Registro no verificado';
$string['registration_status'] = 'Último estado';
$string['registration_verified'] = 'Registro verificado';
$string['registrationapibearer'] = 'Token bearer de registro';
$string['registrationapibearer_desc'] = 'Token bearer utilizado para autenticar la solicitud de registro.';
$string['registrationapiurl'] = 'URL del punto final de registro';
$string['registrationapiurl_desc'] = 'Punto final para recibir la carga útil de registro del sitio. Predeterminado: http://localhost:8001/register-site';
$string['registrationsettings'] = 'API de Registro';
$string['remainingtokens'] = 'Saldo restante';
$string['responseinvalidai'] = 'Respuesta inválida del servicio de IA.';
$string['responseinvalidaimage'] = 'Respuesta inválida del servicio de IA (Sin imagen).';
$string['responseinvalidaimagecreate'] = 'No se pudo crear el archivo de imagen.';
$string['rest_enabled'] = 'Protocolo REST habilitado';
$string['second'] = 'segundo';
$string['seconds'] = 'Segundos';
$string['service'] = 'Servicio';
$string['showrows'] = 'Mostrar filas';
$string['tokens'] = 'Créditos';
$string['tokens_available'] = 'Créditos Disponibles';
$string['tokensconsumed'] = 'Créditos consumidos';
$string['tokensconsumedday'] = 'Créditos consumidos por día';
$string['tokensconsumedmonth'] = 'Créditos consumidos por mes';
$string['tokensnotsufficient'] = 'Créditos de IA insuficientes. Saldo actual: {$a->current}. Mínimo requerido: {$a->required}. Por favor, visite <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Administrar Créditos</a> en la Tienda de Datacurso para asignar o comprar más créditos. O contacte a su administrador.';
$string['tokensused'] = 'Créditos utilizados';
$string['tokenthreshold'] = 'Umbral de créditos';
$string['tokenthreshold_desc'] = 'Número de créditos a partir del cual se mostrará una notificación para comprar más.';
$string['total_consumed'] = 'Créditos consumidos';
$string['upgrade_sync_error'] = 'Error de actualización de Datacurso: {$a}';
$string['userid'] = 'Usuario';
$string['userratelimit'] = 'Límite de solicitudes por usuario';
$string['userratelimit_desc'] = 'Número máximo de solicitudes permitidas por hora para cada usuario individual.';
$string['verified'] = 'Verificado';
$string['warningconfig_instance'] = 'Advertencia: Solo se debe crear una instancia con este proveedor para su correcto uso.';
$string['webserviceconfig_current'] = 'Configuración actual';
$string['webserviceconfig_desc'] = 'Configura automáticamente un servicio web dedicado para el servicio de IA Datacurso, permitiéndole extraer de forma segura información de la plataforma como datos básicos de usuarios, cursos y actividades para una mejor contextualización de la IA. Esta configuración crea un usuario de servicio, asigna el rol necesario, configura el servicio externo, genera un token seguro y habilita el protocolo REST en un solo clic. Nota: El valor del token no se muestra por razones de seguridad.';
$string['webserviceconfig_heading'] = 'Configuración automática del servicio web';
$string['webserviceconfig_site'] = 'Información del sitio';
$string['webserviceconfig_status'] = 'Estado';
$string['webserviceconfig_title'] = 'Configuración del Servicio Web de Datacurso';
$string['week'] = 'semana';
$string['weeks'] = 'Semanas';
$string['workplace'] = '¿Es este Moodle Workplace?';
$string['workplace_desc'] = 'Define si el encabezado X-Workplace debe enviarse con el valor true (Workplace) o false (Moodle estándar).';
$string['ws_activity'] = 'Registro de actividad';
$string['ws_btn_regenerate'] = 'Regenerar token';
$string['ws_btn_retry'] = 'Reintentar configuración';
$string['ws_btn_setup'] = 'Configurar servicio web';
$string['ws_enabled'] = 'Servicios web habilitados';
$string['ws_error_missing_setup'] = 'Servicio o usuario no encontrado. Ejecute la configuración primero.';
$string['ws_error_missing_token'] = 'Token no encontrado. Genérelo primero.';
$string['ws_error_regenerate_token'] = 'Error al regenerar el token.';
$string['ws_error_registration'] = 'Error al registrar el token del servicio web.';
$string['ws_error_setup'] = 'Error al configurar el servicio web.';
$string['ws_role'] = 'Rol del servicio';
$string['ws_role_desc'] = 'Rol para el servicio web de Datacurso';
$string['ws_role_name'] = 'Servicio web de Datacurso';
$string['ws_service'] = 'Servicio externo';
$string['ws_service_name'] = 'Servicio web de Datacurso';
$string['ws_step_enableauth'] = 'Habilitando plugin de autenticación de servicios web…';
$string['ws_step_enablerest'] = 'Habilitando protocolo REST…';
$string['ws_step_enablews'] = 'Habilitando servicios web del sitio…';
$string['ws_step_registration_sent'] = 'Solicitud de registro enviada.';
$string['ws_step_role_assign'] = 'Asignando rol al usuario del servicio…';
$string['ws_step_role_caps'] = 'Estableciendo capacidades requeridas del rol…';
$string['ws_step_role_create'] = 'Creando rol "{$a}"…';
$string['ws_step_role_exists'] = 'El rol ya existe, usando ID {$a}…';
$string['ws_step_service_enable'] = 'Creando/Habilitando servicio externo…';
$string['ws_step_service_functions'] = 'Agregando funciones principales comunes al servicio…';
$string['ws_step_service_user'] = 'Autorizando usuario para el servicio…';
$string['ws_step_setup'] = 'Iniciando configuración…';
$string['ws_step_token_create'] = 'Asegurando que el token existe…';
$string['ws_step_token_generated'] = 'Token generado.';
$string['ws_step_token_regenerated'] = 'Token regenerado.';
$string['ws_step_token_regenerating'] = 'Regenerando token…';
$string['ws_step_token_retry'] = 'Reintentando configuración…';
$string['ws_step_user_check'] = 'Verificando si el usuario "{$a}" existe…';
$string['ws_step_user_create'] = 'Creando usuario del servicio "{$a}"…';
$string['ws_token_label'] = 'Token de Datacurso';
$string['ws_tokenexists'] = 'El token existe';
$string['ws_user'] = 'Usuario del servicio';
$string['ws_user_firstname'] = 'Datacurso';
$string['ws_user_lastname'] = 'Servicio';
$string['ws_userassigned'] = 'Rol asignado al usuario';
$string['year'] = 'año';
$string['years'] = 'Años';
