<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     aiprovider_datacurso
 * @category    string
 * @copyright   Josue <josue@datacurso.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['action:explain_text:endpoint'] = 'Point de terminaison pour l\'explication de texte';
$string['action:explain_text:model'] = 'Modèle pour l\'explication';
$string['action:explain_text:model_help'] = 'Sélectionnez le modèle qui générera les explications.';
$string['action:explain_text:systeminstruction'] = 'Instruction système pour l\'explication';
$string['action:explain_text:systeminstruction_help'] = 'Fournissez un contexte pour guider le processus d\'explication.';
$string['action:generate_image:endpoint'] = 'Point de terminaison pour la génération d\'image';
$string['action:generate_image:model'] = 'Modèle pour la génération d\'image';
$string['action:generate_image:model_help'] = 'Sélectionnez le modèle d\'IA pour générer des images.';
$string['action:generate_image:systeminstruction'] = 'Invite système pour la génération d\'image';
$string['action:generate_image:systeminstruction_help'] = 'Instructions supplémentaires qui guident l\'IA dans la génération de l\'image souhaitée.';
$string['action:generate_text:endpoint'] = 'Point de terminaison pour la génération de texte';
$string['action:generate_text:instruction'] = 'Instruction système';
$string['action:generate_text:instruction_desc'] = 'Cette instruction est envoyée au modèle d\'IA avec l\'invite de l\'utilisateur. La modification de cette instruction n\'est pas recommandée, sauf si cela est absolument nécessaire.';
$string['action:generate_text:model'] = 'Modèle pour la génération de texte';
$string['action:generate_text:model_help'] = 'Sélectionnez le modèle d\'IA qui sera utilisé pour générer le texte.';
$string['action:generate_text:systeminstruction'] = 'Instruction système';
$string['action:generate_text:systeminstruction_help'] = 'Instruction ou contexte donné à l\'IA avant de générer le texte. Utile pour contrôler le ton, la structure ou le but de la réponse.';
$string['action:summarise_text:endpoint'] = 'Point de terminaison pour la synthèse de texte';
$string['action:summarise_text:instruction'] = 'Instruction système';
$string['action:summarise_text:instruction_desc'] = 'Cette instruction est envoyée au modèle d\'IA avec l\'invite de l\'utilisateur. La modification de cette instruction n\'est pas recommandée, sauf si cela est absolument nécessaire.';
$string['action:summarise_text:model'] = 'Modèle pour la synthèse';
$string['action:summarise_text:model_help'] = 'Sélectionnez le modèle d\'IA qui sera utilisé pour résumer le texte.';
$string['action:summarise_text:systeminstruction'] = 'Instruction système pour le résumé';
$string['action:summarise_text:systeminstruction_help'] = 'Contexte facultatif pour influencer la manière dont le résumé est généré.';
$string['all'] = 'Tous';
$string['alt_datacurso_icon'] = 'Icône Datacurso';
$string['apikey'] = 'Clé API';
$string['apikey_desc'] = 'Entrez la clé API de votre service Datacurso pour connecter l\'IA.';
$string['apiurl'] = 'URL de base de l\'API';
$string['apiurl_desc'] = 'Entrez l\'URL de base du service pour vous connecter à l\'API Datacurso.';
$string['assigned'] = 'Attribué';
$string['chart_actions'] = 'Distribution des crédits par service';
$string['chart_tokens_by_day'] = 'Consommation de crédits par jour';
$string['chart_tokens_by_month'] = 'Nombre de crédits consommés par mois';
$string['configured'] = 'Configuré';
$string['connection'] = 'Paramètres de connexion';
$string['contextwstoken'] = 'Jeton de service web pour le contexte du cours';
$string['contextwstoken_desc'] = 'Jeton utilisé par l\'IA pour récupérer les informations du cours (contexte). Stocké de manière sécurisée. Créez/gérez les jetons dans Administration du site > Serveur > Services web > Gérer les jetons.';
$string['created'] = 'Créé';
$string['curlerror'] = 'Erreur cURL de l\'API Datacurso : {$a}';
$string['custom_model_name'] = 'Nom du modèle personnalisé';
$string['custom_model_name_help'] = 'Nom facultatif pour identifier cette configuration spécifique du modèle d\'IA.';
$string['datacurso:configurews'] = 'Configurer le service web Datacurso';
$string['datacurso:manage'] = 'Gérer les paramètres du fournisseur d\'IA';
$string['datacurso:use'] = 'Utiliser les services d\'IA de Datacurso';
$string['datacurso:viewreports'] = 'Voir les rapports d\'utilisation de l\'IA';
$string['day'] = 'jour';
$string['days'] = 'Jours';
$string['description'] = 'Description';
$string['descriptionpagelistplugins'] = 'Vous trouverez ici la liste des plugins compatibles avec le fournisseur Datacurso';
$string['disabled'] = 'Désactivé';
$string['emptyprompt'] = 'Invite vide';
$string['emptyresponse'] = 'Aucune réponse de l\'API Datacurso.';
$string['enabled'] = 'Activé';
$string['enableglobalratelimit'] = 'Activer la limite globale';
$string['enableglobalratelimit_desc'] = 'Si activé, une limite de requêtes globale par heure sera appliquée pour tous les utilisateurs.';
$string['enableuserratelimit'] = 'Activer la limite par utilisateur';
$string['enableuserratelimit_desc'] = 'Si activé, chaque utilisateur aura une limite de requêtes horaire.';
$string['endpointurl'] = 'URL du point de terminaison';
$string['endpointurl_help'] = 'URL de base du point de terminaison de l\'API du fournisseur d\'IA Datacurso. Généralement quelque chose comme https://api.datacurso.ai/v1/.';
$string['error_ratelimit_exceeded'] = 'La limite de consommation autorisée a été dépassée. Veuillez réessayer à {$a}.';
$string['error_webservice_not_configured'] = 'Cette action ne peut pas continuer car le service web Datacurso qui fournit des données contextuelles à l\'IA n\'est pas configuré. Terminez la configuration automatique sur <a href="{$a->url}">Configuration du service web Datacurso</a> et réessayez. Ou contactez votre administrateur pour plus d\'informations.';
$string['errorgetbalancecredits'] = 'Impossible de récupérer le solde des crédits auprès de l\'API externe';
$string['errorinitinformation'] = 'Impossible d\'obtenir les informations initiales.';
$string['exists'] = 'Existe';
$string['forbidden'] = 'Vous n\'êtes pas autorisé à effectuer cette action avec la licence actuelle. Veuillez vérifier votre licence et les crédits disponibles dans <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gérer les crédits</a> dans la boutique Datacurso.';
$string['generate_activitie'] = 'Générer une activité ou une ressource avec l\'IA';
$string['generate_ai_reinforcement_activity'] = 'Créer une activité de renforcement par IA';
$string['generate_analysis_comments'] = 'Générer une analyse de notation d\'une activité/ressource avec l\'IA';
$string['generate_analysis_course'] = 'Générer une analyse de notation de cours avec l\'IA';
$string['generate_analysis_general'] = 'Générer une analyse de notation générale avec l\'IA';
$string['generate_analysis_story_student'] = 'Générer une histoire d\'analyse d\'étudiant avec l\'IA';
$string['generate_assign_answer'] = 'Générer une révision de devoir avec l\'IA';
$string['generate_certificate_answer'] = 'Générer un message de certificat avec l\'IA';
$string['generate_chat_message'] = 'Générer un message de tuteur IA';
$string['generate_creation_course'] = 'Créer un cours complet avec l\'IA';
$string['generate_forum_chat'] = 'Générer une réponse de forum avec l\'IA';
$string['generate_image'] = 'Générer une image avec l\'IA';
$string['generate_plan_course'] = 'Générer un plan de création de cours avec l\'IA';
$string['generate_summary'] = 'Générer un résumé avec l\'IA';
$string['generate_text'] = 'Générer du texte avec l\'IA';
$string['globalratelimit'] = 'Limite de requêtes globale';
$string['globalratelimit_desc'] = 'Nombre maximal de requêtes autorisées par heure pour l\'ensemble du système.';
$string['goto'] = 'Aller au rapport';
$string['gotopage'] = 'Aller à la page';
$string['hour'] = 'heure';
$string['hours'] = 'Heures';
$string['httperror'] = 'Erreur inattendue lors du traitement de votre requête (HTTP {$a}). Veuillez réessayer plus tard. Si le problème persiste, contactez l\'administrateur de votre site.';
$string['id'] = 'ID';
$string['installed'] = 'Installé';
$string['invalidlicensekey'] = 'La clé de licence a expiré ou est invalide. Veuillez vous rendre sur <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gérer les crédits</a> dans la boutique Datacurso pour renouveler ou acheter une nouvelle licence.';
$string['json_encode_failed'] = 'Échec de l\'encodage Json';
$string['jsondecodeerror'] = 'Erreur lors du traitement de la réponse de l\'API Datacurso : {$a}';
$string['last_sent'] = 'Dernier envoi';
$string['license_not_allowed'] = 'Votre licence n\'est pas autorisée à effectuer cette requête. Veuillez gérer vos licences et crédits dans <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gérer les crédits</a> dans la boutique Datacurso.';
$string['licensekey'] = 'Clé de licence';
$string['licensekey_desc'] = 'Entrez la clé de licence depuis l\'espace client de la boutique Datacurso.';
$string['licensekey_help'] = 'Entrez votre clé de licence du fournisseur d\'IA Datacurso.';
$string['link_consumptionhistory'] = 'Historique de consommation de crédits';
$string['link_generalreport'] = 'Rapport général';
$string['link_generalreport_datacurso'] = 'Rapport général Datacurso IA';
$string['link_listplugings'] = 'Liste des plugins Datacurso';
$string['link_plugin'] = 'Lien';
$string['link_provider_config'] = 'Configuration du fournisseur';
$string['link_report_statistic'] = 'Rapport de statistiques générales';
$string['link_webservice_config'] = 'Configuration du service web Datacurso';
$string['live_log'] = 'Journal en direct';
$string['message_no_there_plugins'] = 'Aucun plugin disponible';
$string['minute'] = 'minute';
$string['minutes'] = 'Minutes';
$string['missing'] = 'Manquant';
$string['month'] = 'mois';
$string['months'] = 'Mois';
$string['needs_repair'] = 'Nécessite une réparation';
$string['nodata'] = 'Aucune information trouvée';
$string['not_assigned'] = 'Non attribué';
$string['not_configured'] = 'Non configuré';
$string['not_created'] = 'Non créé';
$string['notallowed'] = 'Vous n\'êtes pas autorisé à effectuer cette action. Veuillez contacter votre administrateur pour plus d\'informations.';
$string['notenoughtokens'] = 'Crédits IA insuffisants. Veuillez visiter <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gérer les crédits</a> dans la boutique Datacurso pour allouer ou acheter plus de crédits. Ou contactez votre administrateur.';
$string['of'] = 'de';
$string['orgid'] = 'ID de l\'organisation';
$string['orgid_desc'] = 'Entrez l\'identifiant de votre organisation dans le service Datacurso.';
$string['pageinfo'] = 'Page {$a->current} sur {$a->totalpages} ({$a->total} enregistrements)';
$string['pending'] = 'En attente';
$string['plugin'] = 'Plugin';
$string['plugindesc_assign_ai'] = 'Réviser les devoirs avec l\'aide de l\'IA.';
$string['plugindesc_coursegen'] = 'Créer des cours complets, des activités et des ressources avec l\'IA.';
$string['plugindesc_datacurso_ratings'] = 'Permet aux étudiants de noter les activités et les ressources; les enseignants et les administrateurs peuvent ensuite générer une analyse de cours basée sur l\'IA.';
$string['plugindesc_dttutor'] = 'Discuter avec un tuteur IA dans le cours.';
$string['plugindesc_forum_ai'] = 'Étendre les forums avec une analyse basée sur l\'IA pour générer automatiquement des résumés.';
$string['plugindesc_lifestory'] = 'Rapport et analyse basés sur l\'IA du progrès académique de l\'étudiant.';
$string['plugindesc_smartrules'] = 'Créer des activités automatisées basées sur les conditions précédentes des étudiants.';
$string['plugindesc_socialcert'] = 'Générer automatiquement des certificats personnalisés à la fin du cours.';
$string['pluginname'] = 'Fournisseur d\'IA Datacurso';
$string['pluginname_assign_ai'] = 'Devoir IA';
$string['pluginname_coursegen'] = 'Créateur de cours IA';
$string['pluginname_datacurso_ratings'] = 'Notation d\'activités IA';
$string['pluginname_dttutor'] = 'Tuteur IA';
$string['pluginname_forum_ai'] = 'Forum IA';
$string['pluginname_lifestory'] = 'Histoire de vie de l\'étudiant IA';
$string['pluginname_smartrules'] = 'Règles intelligentes IA';
$string['pluginname_socialcert'] = 'Certificat Partagé IA';
$string['privacy:metadata'] = 'Le plugin Fournisseur d\'IA Datacurso ne stocke aucune donnée personnelle localement. Toutes les données sont traitées par des services externes d\'IA Datacurso.';
$string['privacy:metadata:aiprovider_datacurso'] = 'Charges utiles des requêtes d\'IA Datacurso envoyées au service externe.';
$string['privacy:metadata:aiprovider_datacurso:externalpurpose'] = 'Ces données sont envoyées à Datacurso AI afin de réaliser l\'action demandée.';
$string['privacy:metadata:aiprovider_datacurso:numberimages'] = 'Nombre total d\'images demandées au service d\'IA.';
$string['privacy:metadata:aiprovider_datacurso:prompt'] = 'Le texte de l\'invite fourni au service d\'IA.';
$string['privacy:metadata:aiprovider_datacurso:userid'] = 'L\'ID utilisateur Moodle effectuant la requête IA.';
$string['privacy:metadata:aiprovider_datacurso_rlimit'] = 'État d\'utilisation continue du limiteur de débit par utilisateur et par service stocké localement.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:lastsync'] = 'Horodatage de la dernière synchronisation avec l\'historique distant.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:serviceid'] = 'Identifiant du service (par exemple, local_coursegen).';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timecreated'] = 'Heure à laquelle cet enregistrement a été créé.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timemodified'] = 'Heure à laquelle cet enregistrement a été modifié pour la dernière fois.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:tokensused'] = 'Crédits utilisés dans la fenêtre temporelle actuelle.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:userid'] = 'ID utilisateur lié à la fenêtre de consommation suivie.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:windowstart'] = 'Horodatage de début de fenêtre utilisé pour calculer les limites de consommation.';
$string['ratelimit_enable'] = 'Activer la limite de débit';
$string['ratelimit_enable_desc'] = 'Si activé, la limite de crédit par utilisateur sera appliquée pour ce plugin.';
$string['ratelimit_limit'] = 'Limite de débit';
$string['ratelimit_limit_desc'] = 'Le nombre maximum de requêtes autorisées par fenêtre de limite de débit.';
$string['ratelimit_limit_help'] = 'Le nombre maximum de requêtes autorisées par fenêtre de limite de débit.';
$string['ratelimit_local_assign_ai_allowedusers'] = 'Réviseurs de devoirs autorisés (IA)';
$string['ratelimit_local_assign_ai_allowedusers_desc'] = 'Sélectionnez les utilisateurs autorisés à réviser les devoirs avec l\'IA lorsque ce service est activé.';
$string['ratelimit_local_assign_ai_allowedusers_enable'] = 'Limiter par utilisateurs autorisés';
$string['ratelimit_local_assign_ai_allowedusers_enable_desc'] = 'Si activé, seuls les utilisateurs sélectionnés ci-dessous seront autorisés à réviser les devoirs avec l\'IA.';
$string['ratelimit_local_coursegen_activitycreators'] = 'Créateurs d\'activités autorisés';
$string['ratelimit_local_coursegen_activitycreators_desc'] = 'Sélectionnez les utilisateurs qui peuvent générer des activités ou des ressources avec l\'IA lorsque ce service est activé.';
$string['ratelimit_local_coursegen_allowedusers_enable'] = 'Limiter par utilisateurs autorisés';
$string['ratelimit_local_coursegen_allowedusers_enable_desc'] = 'Si activé, seuls les utilisateurs sélectionnés ci-dessous seront autorisés à utiliser ce service.';
$string['ratelimit_local_coursegen_coursecreators'] = 'Créateurs de cours autorisés';
$string['ratelimit_local_coursegen_coursecreators_desc'] = 'Sélectionnez les utilisateurs qui peuvent créer des cours complets avec l\'IA lorsque ce service est activé.';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable'] = 'Limiter par utilisateurs autorisés';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable_desc'] = 'Si activé, seuls les utilisateurs sélectionnés ci-dessous seront autorisés à générer des analyses basées sur l\'IA dans le plugin Notation d\'activités IA.';
$string['ratelimit_local_datacurso_ratings_courseanalysts'] = 'Générateurs d\'analyse de cours autorisés (IA)';
$string['ratelimit_local_datacurso_ratings_courseanalysts_desc'] = 'Sélectionnez les utilisateurs qui peuvent générer une analyse de niveau de cours par IA.';
$string['ratelimit_local_datacurso_ratings_generalanalysts'] = 'Générateurs d\'analyse générale autorisés (IA)';
$string['ratelimit_local_datacurso_ratings_generalanalysts_desc'] = 'Sélectionnez les utilisateurs qui peuvent générer une analyse générale par IA sur les activités ou le cours.';
$string['ratelimit_report_lifestory_allowedusers'] = 'Générateurs de rétroaction IA autorisés';
$string['ratelimit_report_lifestory_allowedusers_desc'] = 'Sélectionnez les utilisateurs qui peuvent cliquer sur « Générer une rétroaction IA » pour envoyer les données de performance de l\'étudiant (notes, achèvement, participation) au fournisseur d\'IA Datacurso et afficher le récit IA avec les forces, les faiblesses et les recommandations.';
$string['ratelimit_report_lifestory_allowedusers_enable'] = 'Limiter par utilisateurs autorisés';
$string['ratelimit_report_lifestory_allowedusers_enable_desc'] = 'Si activé, seuls les utilisateurs sélectionnés ci-dessous seront autorisés à générer une rétroaction IA dans le rapport Histoire de vie.';
$string['ratelimit_window'] = 'Fenêtre de temps';
$string['ratelimit_window_desc'] = 'Sélectionnez la durée et l\'unité pour la fenêtre de limite de débit.';
$string['ratelimit_window_unit'] = 'Unité de la fenêtre';
$string['ratelimit_window_value'] = 'Valeur de la fenêtre';
$string['ratelimits_heading'] = 'Limites de débit par plugin';
$string['ratelimits_heading_desc'] = 'Configurez les limites de débit par utilisateur pour chaque plugin qui utilise le fournisseur Datacurso.';
$string['read_context_course'] = 'Lire le contexte pour la création de cours par IA';
$string['read_context_course_model'] = 'Télécharger le modèle académique pour la création de cours par IA';
$string['registers'] = 'Enregistrements';
$string['registration_error'] = 'Dernière erreur';
$string['registration_last'] = 'Inscription';
$string['registration_lastsent'] = 'Dernier envoi';
$string['registration_notverified'] = 'Inscription non vérifiée';
$string['registration_status'] = 'Dernier statut';
$string['registration_verified'] = 'Inscription vérifiée';
$string['registrationapibearer'] = 'Jeton Bearer d\'inscription';
$string['registrationapibearer_desc'] = 'Jeton Bearer utilisé pour authentifier la requête d\'inscription.';
$string['registrationapiurl'] = 'URL du point de terminaison d\'inscription';
$string['registrationapiurl_desc'] = 'Point de terminaison pour recevoir la charge utile d\'inscription du site. Par défaut : http://localhost:8001/register-site';
$string['registrationsettings'] = 'API d\'inscription';
$string['remainingtokens'] = 'Solde restant';
$string['responseinvalidai'] = 'Réponse non valide du service d\'IA.';
$string['responseinvalidaimage'] = 'Réponse non valide du service d\'IA (Aucune image).';
$string['responseinvalidaimagecreate'] = 'Impossible de créer le fichier image.';
$string['rest_enabled'] = 'Protocole REST activé';
$string['second'] = 'seconde';
$string['seconds'] = 'Secondes';
$string['service'] = 'Service';
$string['showrows'] = 'Afficher les lignes';
$string['tokens'] = 'Crédits';
$string['tokens_available'] = 'Crédits disponibles';
$string['tokensconsumed'] = 'Crédits consommés';
$string['tokensconsumedday'] = 'Crédits consommés par jour';
$string['tokensconsumedmonth'] = 'Crédits consommés par mois';
$string['tokensnotsufficient'] = 'Crédits IA insuffisants. Solde actuel : {$a->current}. Minimum requis : {$a->required}. Veuillez visiter <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gérer les crédits</a> dans la boutique Datacurso pour allouer ou acheter plus de crédits. Ou contactez votre administrateur.';
$string['tokensused'] = 'Crédits utilisés';
$string['tokenthreshold'] = 'Seuil de crédits';
$string['tokenthreshold_desc'] = 'Nombre de crédits à partir duquel une notification sera affichée pour en acheter plus.';
$string['total_consumed'] = 'Crédits consommés';
$string['upgrade_sync_error'] = 'Erreur de mise à jour de Datacurso : {$a}';
$string['userid'] = 'Utilisateur';
$string['userratelimit'] = 'Limite de requêtes par utilisateur';
$string['userratelimit_desc'] = 'Nombre maximal de requêtes autorisées par heure pour chaque utilisateur individuel.';
$string['verified'] = 'Vérifié';
$string['warningconfig_instance'] = 'Avertissement : Une seule instance doit être créée avec ce fournisseur pour une utilisation correcte.';
$string['webserviceconfig_current'] = 'Configuration actuelle';
$string['webserviceconfig_desc'] = 'Configure automatiquement un service web dédié pour le service d\'IA Datacurso, lui permettant d\'extraire en toute sécurité des informations de la plateforme telles que les données de base de l\'utilisateur, les cours et les activités pour une meilleure contextualisation de l\'IA. Cette configuration crée un utilisateur de service, attribue le rôle nécessaire, configure le service externe, génère un jeton sécurisé et active le protocole REST en un clic. Remarque : La valeur du jeton n\'est pas affichée pour des raisons de sécurité.';
$string['webserviceconfig_heading'] = 'Configuration automatique du service web';
$string['webserviceconfig_site'] = 'Informations sur le site';
$string['webserviceconfig_status'] = 'Statut';
$string['webserviceconfig_title'] = 'Configuration du Service Web Datacurso';
$string['week'] = 'semaine';
$string['weeks'] = 'Semaines';
$string['workplace'] = 'Est-ce Moodle Workplace ?';
$string['workplace_desc'] = 'Définit si l\'en-tête X-Workplace doit être envoyé avec la valeur true (Workplace) ou false (Moodle Standard).';
$string['ws_activity'] = 'Journal d\'activité';
$string['ws_btn_regenerate'] = 'Régénérer le jeton';
$string['ws_btn_retry'] = 'Réessayer la configuration';
$string['ws_btn_setup'] = 'Configurer le service web';
$string['ws_enabled'] = 'Services web activés';
$string['ws_error_missing_setup'] = 'Service ou utilisateur introuvable. Exécutez la configuration d\'abord.';
$string['ws_error_missing_token'] = 'Jeton introuvable. Générez-le d\'abord.';
$string['ws_error_regenerate_token'] = 'Erreur lors de la régénération du jeton.';
$string['ws_error_registration'] = 'Erreur lors de l\'enregistrement du jeton de service web.';
$string['ws_error_setup'] = 'Erreur lors de la configuration du service web.';
$string['ws_role'] = 'Rôle de service';
$string['ws_role_desc'] = 'Rôle pour le service web Datacurso';
$string['ws_role_name'] = 'Service web Datacurso';
$string['ws_service'] = 'Service externe';
$string['ws_service_name'] = 'Service web Datacurso';
$string['ws_step_enableauth'] = 'Activation du plugin d\'authentification des services web…';
$string['ws_step_enablerest'] = 'Activation du protocole REST…';
$string['ws_step_enablews'] = 'Activation des services web du site…';
$string['ws_step_registration_sent'] = 'Demande d\'inscription envoyée.';
$string['ws_step_role_assign'] = 'Attribution du rôle à l\'utilisateur de service…';
$string['ws_step_role_caps'] = 'Définition des capacités de rôle requises…';
$string['ws_step_role_create'] = 'Création du rôle "{$a}"…';
$string['ws_step_role_exists'] = 'Le rôle existe déjà, utilisation de l\'ID {$a}…';
$string['ws_step_service_enable'] = 'Création/Activation du service externe…';
$string['ws_step_service_functions'] = 'Ajout des fonctions de base communes au service…';
$string['ws_step_service_user'] = 'Autorisation de l\'utilisateur pour le service…';
$string['ws_step_setup'] = 'Démarrage de la configuration…';
$string['ws_step_token_create'] = 'Assurer l\'existence du jeton…';
$string['ws_step_token_generated'] = 'Jeton généré.';
$string['ws_step_token_regenerated'] = 'Jeton régénéré.';
$string['ws_step_token_regenerating'] = 'Régénération du jeton…';
$string['ws_step_token_retry'] = 'Nouvel essai de la configuration…';
$string['ws_step_user_check'] = 'Vérification de l\'existence de l\'utilisateur "{$a}"…';
$string['ws_step_user_create'] = 'Création de l\'utilisateur de service "{$a}"…';
$string['ws_token_label'] = 'Jeton Datacurso';
$string['ws_tokenexists'] = 'Le jeton existe';
$string['ws_user'] = 'Utilisateur de service';
$string['ws_user_firstname'] = 'Datacurso';
$string['ws_user_lastname'] = 'Service';
$string['ws_userassigned'] = 'Rôle attribué à l\'utilisateur';
$string['year'] = 'année';
$string['years'] = 'Années';
