define("aiprovider_datacurso/report_charts",["exports","core/ajax","core/chartjs","core/str","core/notification"],(function(_exports,_ajax,_chartjs,_str,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Report charts module.
   *
   * @module     aiprovider_datacurso/report_charts
   * @copyright  2025 Industria Elearning
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_chartjs=_interopRequireDefault(_chartjs),_notification=_interopRequireDefault(_notification);_exports.init=async()=>{const date=await(0,_str.get_string)("date","core"),creditsConsumedMonth=await(0,_str.get_string)("tokensconsumedmonth","aiprovider_datacurso"),creditsConsumedDay=await(0,_str.get_string)("tokensconsumedday","aiprovider_datacurso"),creditsConsumed=await(0,_str.get_string)("tokensconsumed","aiprovider_datacurso"),tokensAvailable=document.getElementById("tokens-available"),tokensConsumed=document.getElementById("tokens-consumed");let chartBar,chartPie,chartDay,cachedData=[];Promise.all([_ajax.default.call([{methodname:"aiprovider_datacurso_get_credits_balance",args:{}}])[0],_ajax.default.call([{methodname:"aiprovider_datacurso_get_services",args:{}}])[0],_ajax.default.call([{methodname:"aiprovider_datacurso_get_all_consumption",args:{}}])[0]]).then((_ref=>{let[balanceResponse,servicesResponse,consumptionResponse]=_ref;const balance=(null==balanceResponse?void 0:balanceResponse.balance)||0;tokensAvailable.textContent=balance;const services=(null==servicesResponse?void 0:servicesResponse.services)||[];cachedData=(null==consumptionResponse?void 0:consumptionResponse.consumption)||[],initCharts(services)})).catch((e=>{let msg=e.message;_notification.default.addNotification({message:msg,type:"error"})}));const initCharts=services=>{const filterBar=document.getElementById("filter-service-bar"),filterPie=document.getElementById("filter-service-pie"),filterStart=document.getElementById("filter-start-date"),filterEnd=document.getElementById("filter-end-date"),fillSelect=select=>{null!=services&&services.length&&services.forEach((s=>{const opt=document.createElement("option");opt.value=s.id,opt.textContent=s.name,select.appendChild(opt)}))};fillSelect(filterBar),fillSelect(filterPie),renderBarChart(cachedData),renderPieChart(cachedData),renderDayChart(cachedData),filterBar.addEventListener("change",(()=>updateBarChart())),filterPie.addEventListener("change",(()=>updatePieChart())),filterStart.addEventListener("change",(()=>updateDayChart())),filterEnd.addEventListener("change",(()=>updateDayChart()))},fetchConsumptionData=async function(){let params=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const defaults={service:"",action:"",fromdate:"",todate:""},finalParams={...defaults,...params};try{const response=await _ajax.default.call([{methodname:"aiprovider_datacurso_get_all_consumption",args:finalParams}])[0];return"success"!==response.status?[]:response.consumption||[]}catch(error){return _notification.default.exception(error),[]}},renderBarChart=data=>{const byMonth={};data.forEach((c=>{const month=c.date.substring(0,7);byMonth[month]=(byMonth[month]||0)+c.cant_tokens}));const totalTokens=data.reduce(((sum,c)=>sum+(c.cant_tokens||0)),0);tokensConsumed.textContent=totalTokens;const ctx=document.getElementById("chart-tokens-by-month");chartBar&&chartBar.destroy(),chartBar=new _chartjs.default(ctx,{type:"bar",data:{labels:Object.keys(byMonth),datasets:[{label:creditsConsumedMonth,data:Object.values(byMonth),backgroundColor:"#0073e6"}]},options:{responsive:!0,maintainAspectRatio:!1}})},updateBarChart=async()=>{const service=document.getElementById("filter-service-bar").value;if(!service)return renderBarChart(cachedData);const data=await fetchConsumptionData({service:service});renderBarChart(data)},renderPieChart=data=>{const byAction={};data.forEach((c=>{byAction[c.action]=(byAction[c.action]||0)+c.cant_tokens}));const ctx=document.getElementById("chart-actions");chartPie&&chartPie.destroy(),chartPie=new _chartjs.default(ctx,{type:"pie",data:{labels:Object.keys(byAction),datasets:[{data:Object.values(byAction),backgroundColor:["#36A2EB","#FF6384","#f1d48bff","#5ddcdcff","#049930ff","#0b6eb0ff","#d10f39ff","#7c611dff","#ee9610ff","#a50562ff","#022082ff","#efef21ff","#3f4646ff","#8f9191ff","#0c361bff","#bd836cff"]}]},options:{responsive:!0,maintainAspectRatio:!1}})},updatePieChart=async()=>{const service=document.getElementById("filter-service-pie").value;if(!service)return renderPieChart(cachedData);const data=await fetchConsumptionData({service:service});renderPieChart(data)},renderDayChart=data=>{const byDay={};data.forEach((c=>{const day=c.date.substring(0,10);byDay[day]=(byDay[day]||0)+c.cant_tokens}));const labels=Object.keys(byDay).sort(((a,b)=>new Date(a)-new Date(b))),values=labels.map((day=>byDay[day])),ctx=document.getElementById("chart-tokens-by-day");chartDay&&chartDay.destroy(),chartDay=new _chartjs.default(ctx,{type:"line",data:{labels:labels,datasets:[{label:creditsConsumedDay,data:values,borderColor:"#28a745",backgroundColor:"rgba(40,167,69,0.2)",fill:!0,tension:.2,pointRadius:4,pointHoverRadius:6,borderWidth:2}]},options:{responsive:!0,maintainAspectRatio:!1,scales:{x:{title:{display:!0,text:date}},y:{title:{display:!0,text:creditsConsumed},beginAtZero:!0}}}})},updateDayChart=async()=>{const fromdate=document.getElementById("filter-start-date").value,todate=document.getElementById("filter-end-date").value;if(!fromdate&&!todate)return renderDayChart(cachedData);const data=await fetchConsumptionData({fromdate:fromdate,todate:todate});renderDayChart(data)}}}));

//# sourceMappingURL=report_charts.min.js.map