define("aiprovider_datacurso/webservice_config",["exports","core/notification","core/str","core/templates","aiprovider_datacurso/repository"],(function(_exports,_notification,_str,_templates,_repository){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * AMD module to handle the Webservice configuration actions for Datacurso.
   * It performs setup, token regeneration, and registration calls and
   * displays progress via UI notifications and a simple log list.
   *
   * @module      aiprovider_datacurso/webservice_config
   * @copyright   2025 Wilber Narvaez <wilber@buendata.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=function(){const root=document.querySelector('[data-region="aiprovider_datacurso/webservice-root"]');if(!root)return;bindHandlers(root)},_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates);const logEntries=[];function bindHandlers(root){if(!root)return;const btnSetup=root.querySelector('[data-region="aiprovider_datacurso/webservice-btn-setup"]'),btnRetry=root.querySelector('[data-region="aiprovider_datacurso/webservice-btn-retry"]'),btnRegenerate=root.querySelector('[data-region="aiprovider_datacurso/webservice-btn-regenerate"]');btnSetup&&btnSetup.addEventListener("click",setup),btnRetry&&btnRetry.addEventListener("click",retry),btnRegenerate&&btnRegenerate.addEventListener("click",regenerate)}async function setup(){try{log(await(0,_str.get_string)("ws_step_setup","aiprovider_datacurso"));const res=await(0,_repository.webserviceSetup)();res.messages&&Array.isArray(res.messages)&&res.messages.forEach((m=>log(m))),await refreshStatus(),_notification.default.addNotification({message:"Done: setup",type:"success"})}catch(e){_notification.default.exception(e),log("Error: "+(e.message||e),"error")}}async function retry(){try{log(await(0,_str.get_string)("ws_step_token_retry","aiprovider_datacurso"));(await(0,_repository.webserviceSetup)()).messages.forEach((m=>log(m))),await refreshStatus(),_notification.default.addNotification({message:"Done: retry",type:"success"})}catch(e){_notification.default.exception(e),log("Error: "+(e.message||e),"error")}}async function regenerate(){try{log(await(0,_str.get_string)("ws_step_token_regenerating","aiprovider_datacurso"));(await(0,_repository.webserviceRegenerateToken)()).messages.forEach((m=>log(m))),await refreshStatus(),_notification.default.addNotification({message:"Done: regenerate",type:"success"})}catch(e){_notification.default.exception(e),log("Error: "+(e.message||e),"error")}}function log(msg){let type=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"info";logEntries.push({msg:msg,type:type}),appendLogEntry({msg:msg,type:type})}function appendLogEntry(entry){const list=document.querySelector('[data-region="aiprovider_datacurso/webservice-log"]');list&&list.appendChild(createLogItem(entry))}function createLogItem(entry){const li=document.createElement("li");return li.textContent=entry.msg,li.classList.add("mb-1"),"success"===entry.type?li.classList.add("text-success"):"error"===entry.type?li.classList.add("text-danger"):li.classList.add("text-muted"),li}async function refreshStatus(){try{const status=await(0,_repository.webserviceGetStatus)();await async function(status){const root=document.querySelector('[data-region="aiprovider_datacurso/webservice-root"]');if(!root)return;const render=await _templates.default.renderForPromise("aiprovider_datacurso/webservice_config",status);await _templates.default.replaceNodeContents(root,render.html,render.js);const newRoot=document.querySelector('[data-region="aiprovider_datacurso/webservice-root"]');(function(root){if(!root)return;const list=root.querySelector('[data-region="aiprovider_datacurso/webservice-log"]');list&&(list.innerHTML="",logEntries.forEach((entry=>{list.appendChild(createLogItem(entry))})))})(newRoot),bindHandlers(newRoot)}(status)}catch(e){log("Status refresh error: "+(e.message||e),"error")}}}));

//# sourceMappingURL=webservice_config.min.js.map