<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     aiprovider_datacurso
 * @category    string
 * @copyright   Josue <josue@datacurso.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['action:explain_text:endpoint'] = 'Endpunkt für Texterklärung';
$string['action:explain_text:model'] = 'Modell für Erklärung';
$string['action:explain_text:model_help'] = 'Wählen Sie das Modell aus, das die Erklärungen generiert.';
$string['action:explain_text:systeminstruction'] = 'Systemanweisung für Erklärung';
$string['action:explain_text:systeminstruction_help'] = 'Geben Sie Kontext an, um den Erklärungsprozess zu leiten.';
$string['action:generate_image:endpoint'] = 'Endpunkt für Bildgenerierung';
$string['action:generate_image:model'] = 'Modell für Bildgenerierung';
$string['action:generate_image:model_help'] = 'Wählen Sie das KI-Modell zur Bildgenerierung aus.';
$string['action:generate_image:systeminstruction'] = 'Systemanweisung für Bildgenerierung';
$string['action:generate_image:systeminstruction_help'] = 'Zusätzliche Anweisungen, die die KI bei der Generierung des gewünschten Bildes leiten.';
$string['action:generate_text:endpoint'] = 'Endpunkt für Textgenerierung';
$string['action:generate_text:instruction'] = 'Systemanweisung';
$string['action:generate_text:instruction_desc'] = 'Diese Anweisung wird zusammen mit der Anfrage des Benutzers an das KI-Modell gesendet. Eine Bearbeitung dieser Anweisung wird nicht empfohlen, es sei denn, es ist unbedingt erforderlich.';
$string['action:generate_text:model'] = 'Modell für Textgenerierung';
$string['action:generate_text:model_help'] = 'Wählen Sie aus, welches KI-Modell zur Textgenerierung verwendet wird.';
$string['action:generate_text:systeminstruction'] = 'Systemanweisung';
$string['action:generate_text:systeminstruction_help'] = 'Anweisung oder Kontext, der der KI vor der Textgenerierung gegeben wird. Nützlich zur Steuerung von Ton, Struktur oder Zweck der Antwort.';
$string['action:summarise_text:endpoint'] = 'Endpunkt für Textzusammenfassung';
$string['action:summarise_text:instruction'] = 'Systemanweisung';
$string['action:summarise_text:instruction_desc'] = 'Diese Anweisung wird zusammen mit der Anfrage des Benutzers an das KI-Modell gesendet. Eine Bearbeitung dieser Anweisung wird nicht empfohlen, es sei denn, es ist unbedingt erforderlich.';
$string['action:summarise_text:model'] = 'Modell für Zusammenfassung';
$string['action:summarise_text:model_help'] = 'Wählen Sie aus, welches KI-Modell zur Zusammenfassung des Textes verwendet wird.';
$string['action:summarise_text:systeminstruction'] = 'Systemanweisung für Zusammenfassung';
$string['action:summarise_text:systeminstruction_help'] = 'Optionaler Kontext, um zu beeinflussen, wie die Zusammenfassung generiert wird.';
$string['all'] = 'Alle';
$string['alt_datacurso_icon'] = 'Datacurso-Symbol';
$string['apikey'] = 'API-Schlüssel';
$string['apikey_desc'] = 'Geben Sie den API-Schlüssel Ihres Datacurso-Dienstes ein, um die KI zu verbinden.';
$string['apiurl'] = 'Basis-API-URL';
$string['apiurl_desc'] = 'Geben Sie die Basis-URL des Dienstes ein, um sich mit der Datacurso-API zu verbinden.';
$string['assigned'] = 'Zugewiesen';
$string['chart_actions'] = 'Credits-Verteilung nach Dienst';
$string['chart_tokens_by_day'] = 'Credits-Verbrauch nach Tag';
$string['chart_tokens_by_month'] = 'Anzahl der pro Monat verbrauchten Credits';
$string['configured'] = 'Konfiguriert';
$string['connection'] = 'Verbindungseinstellungen';
$string['contextwstoken'] = 'Webdienst-Token für Kurskontext';
$string['contextwstoken_desc'] = 'Token, das von der KI verwendet wird, um Kursinformationen (Kontext) abzurufen. Sicher gespeichert. Erstellen/Verwalten Sie Token unter Systemverwaltung > Server > Webdienste > Token verwalten.';
$string['created'] = 'Erstellt';
$string['curlerror'] = 'Datacurso API cURL-Fehler: {$a}';
$string['custom_model_name'] = 'Benutzerdefinierter Modellname';
$string['custom_model_name_help'] = 'Optionaler Name zur Identifizierung dieser spezifischen KI-Modellkonfiguration.';
$string['datacurso:configurews'] = 'Datacurso-Webdienst konfigurieren';
$string['datacurso:manage'] = 'KI-Anbieter-Einstellungen verwalten';
$string['datacurso:use'] = 'Datacurso-KI-Dienste verwenden';
$string['datacurso:viewreports'] = 'KI-Nutzungsberichte anzeigen';
$string['day'] = 'Tag';
$string['days'] = 'Tage';
$string['description'] = 'Beschreibung';
$string['descriptionpagelistplugins'] = 'Hier finden Sie die Liste der Plugins, die mit dem Datacurso-Anbieter kompatibel sind';
$string['disabled'] = 'Deaktiviert';
$string['emptyprompt'] = 'Leere Anfrage';
$string['emptyresponse'] = 'Keine Antwort von der Datacurso-API.';
$string['enabled'] = 'Aktiviert';
$string['enableglobalratelimit'] = 'Globales Limit aktivieren';
$string['enableglobalratelimit_desc'] = 'Wenn aktiviert, wird ein globales Anfragelimit pro Stunde für alle Benutzer angewendet.';
$string['enableuserratelimit'] = 'Benutzerbezogenes Limit aktivieren';
$string['enableuserratelimit_desc'] = 'Wenn aktiviert, hat jeder Benutzer ein stündliches Anfragelimit.';
$string['endpointurl'] = 'Endpunkt-URL';
$string['endpointurl_help'] = 'Basis-API-Endpunkt-URL des Datacurso-KI-Anbieters. Normalerweise etwas wie https://api.datacurso.ai/v1/.';
$string['error_ratelimit_exceeded'] = 'Das zulässige Verbrauchslimit wurde überschritten. Bitte versuchen Sie es erneut um {$a}.';
$string['error_webservice_not_configured'] = 'Diese Aktion kann nicht fortgesetzt werden, da der Datacurso-Webdienst, der kontextbezogene Daten an die KI liefert, nicht konfiguriert ist. Führen Sie die automatische Einrichtung unter <a href="{$a->url}">Datacurso-Webdienst-Einrichtung</a> durch und versuchen Sie es erneut. Oder wenden Sie sich an Ihren Administrator für weitere Informationen.';
$string['errorgetbalancecredits'] = 'Credits-Guthaben konnte nicht von der externen API abgerufen werden';
$string['errorinitinformation'] = 'Anfangsinformationen konnten nicht abgerufen werden.';
$string['exists'] = 'Vorhanden';
$string['forbidden'] = 'Sie sind nicht berechtigt, diese Aktion mit der aktuellen Lizenz durchzuführen. Bitte überprüfen Sie Ihre Lizenz und verfügbaren Credits unter <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso-Shop.';
$string['generate_activitie'] = 'Aktivität oder Ressource mit KI generieren';
$string['generate_ai_reinforcement_activity'] = 'KI-Verstärkungsaktivität erstellen';
$string['generate_analysis_comments'] = 'Bewertungsanalyse einer Aktivität/Ressource mit KI generieren';
$string['generate_analysis_course'] = 'Kursbewertungsanalyse mit KI generieren';
$string['generate_analysis_general'] = 'Allgemeine Bewertungsanalyse mit KI generieren';
$string['generate_analysis_story_student'] = 'Analyse-Geschichte des Studenten mit KI generieren';
$string['generate_assign_answer'] = 'Aufgabenüberprüfung mit KI generieren';
$string['generate_certificate_answer'] = 'Zertifikatsnachricht mit KI generieren';
$string['generate_chat_message'] = 'KI-Tutor-Nachricht generieren';
$string['generate_creation_course'] = 'Vollständigen Kurs mit KI erstellen';
$string['generate_forum_chat'] = 'Forumantwort mit KI generieren';
$string['generate_image'] = 'Bild mit KI generieren';
$string['generate_plan_course'] = 'Kurserstellungsplan mit KI generieren';
$string['generate_summary'] = 'Zusammenfassung mit KI generieren';
$string['generate_text'] = 'Text mit KI generieren';
$string['globalratelimit'] = 'Globales Anfragelimit';
$string['globalratelimit_desc'] = 'Maximale Anzahl der pro Stunde für das gesamte System zulässigen Anfragen.';
$string['goto'] = 'Zum Bericht gehen';
$string['gotopage'] = 'Zur Seite gehen';
$string['hour'] = 'Stunde';
$string['hours'] = 'Stunden';
$string['httperror'] = 'Unerwarteter Fehler bei der Verarbeitung Ihrer Anfrage (HTTP {$a}). Bitte versuchen Sie es später erneut. Wenn das Problem weiterhin besteht, wenden Sie sich an Ihren Systemadministrator.';
$string['id'] = 'ID';
$string['installed'] = 'Installiert';
$string['invalidlicensekey'] = 'Der Lizenzschlüssel ist abgelaufen oder ungültig. Bitte gehen Sie zu <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso-Shop, um zu verlängern oder eine neue Lizenz zu erwerben.';
$string['json_encode_failed'] = 'JSON-Kodierung fehlgeschlagen';
$string['jsondecodeerror'] = 'Fehler bei der Verarbeitung der Antwort von der Datacurso-API: {$a}';
$string['last_sent'] = 'Zuletzt gesendet';
$string['license_not_allowed'] = 'Ihre Lizenz ist nicht berechtigt, diese Anfrage durchzuführen. Bitte verwalten Sie Ihre Lizenzen und Credits unter <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso-Shop.';
$string['licensekey'] = 'Lizenzschlüssel';
$string['licensekey_desc'] = 'Geben Sie den Lizenzschlüssel aus dem Kundenbereich des Datacurso-Shops ein.';
$string['licensekey_help'] = 'Geben Sie Ihren Lizenzschlüssel für den Datacurso-KI-Anbieter ein.';
$string['link_consumptionhistory'] = 'Credits-Verbrauchsverlauf';
$string['link_generalreport'] = 'Allgemeiner Bericht';
$string['link_generalreport_datacurso'] = 'Allgemeiner Bericht Datacurso-KI';
$string['link_listplugings'] = 'Datacurso-Plugin-Liste';
$string['link_plugin'] = 'Link';
$string['link_provider_config'] = 'Anbieter-Konfiguration';
$string['link_report_statistic'] = 'Allgemeiner Statistikbericht';
$string['link_webservice_config'] = 'Datacurso-Webdienst-Einrichtung';
$string['live_log'] = 'Live-Protokoll';
$string['message_no_there_plugins'] = 'Keine Plugins verfügbar';
$string['minute'] = 'Minute';
$string['minutes'] = 'Minuten';
$string['missing'] = 'Fehlend';
$string['month'] = 'Monat';
$string['months'] = 'Monate';
$string['needs_repair'] = 'Benötigt Reparatur';
$string['nodata'] = 'Keine Informationen gefunden';
$string['not_assigned'] = 'Nicht zugewiesen';
$string['not_configured'] = 'Nicht konfiguriert';
$string['not_created'] = 'Nicht erstellt';
$string['notallowed'] = 'Sie sind nicht berechtigt, diese Aktion durchzuführen. Bitte wenden Sie sich an Ihren Administrator für weitere Informationen.';
$string['notenoughtokens'] = 'Unzureichende KI-Credits. Bitte besuchen Sie <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso-Shop, um Credits zuzuweisen oder weitere zu erwerben. Oder wenden Sie sich an Ihren Administrator.';
$string['of'] = 'von';
$string['orgid'] = 'Organisations-ID';
$string['orgid_desc'] = 'Geben Sie die Kennung Ihrer Organisation im Datacurso-Dienst ein.';
$string['pageinfo'] = 'Seite {$a->current} von {$a->totalpages} ({$a->total} Einträge)';
$string['pending'] = 'Ausstehend';
$string['plugin'] = 'Plugin';
$string['plugindesc_assign_ai'] = 'Aufgaben mit KI-Unterstützung überprüfen.';
$string['plugindesc_coursegen'] = 'Vollständige Kurse, Aktivitäten und Ressourcen mit KI erstellen.';
$string['plugindesc_datacurso_ratings'] = 'Ermöglicht es Studenten, Aktivitäten und Ressourcen zu bewerten; Lehrer und Administratoren können später KI-basierte Kursanalysen generieren.';
$string['plugindesc_dttutor'] = 'Mit einem KI-Tutor im Kurs chatten.';
$string['plugindesc_forum_ai'] = 'Foren mit KI-gestützter Analyse erweitern, um automatisch Zusammenfassungen zu generieren.';
$string['plugindesc_lifestory'] = 'KI-gestützter Bericht und Analyse des akademischen Fortschritts des Studenten.';
$string['plugindesc_smartrules'] = 'Automatisierte Aktivitäten basierend auf früheren Bedingungen der Studenten erstellen.';
$string['plugindesc_socialcert'] = 'Personalisierte Zertifikate bei Kursabschluss automatisch generieren.';
$string['pluginname'] = 'Datacurso-KI-Anbieter';
$string['pluginname_assign_ai'] = 'Aufgaben-KI';
$string['pluginname_coursegen'] = 'Kursersteller-KI';
$string['pluginname_datacurso_ratings'] = 'Bewertungs-Aktivitäten-KI';
$string['pluginname_dttutor'] = 'Tutor-KI';
$string['pluginname_forum_ai'] = 'Forum-KI';
$string['pluginname_lifestory'] = 'Studenten-Lebensgeschichte-KI';
$string['pluginname_smartrules'] = 'SmartRules-KI';
$string['pluginname_socialcert'] = 'Zertifikat-teilen-KI';
$string['privacy:metadata'] = 'Das Datacurso-KI-Anbieter-Plugin speichert keine persönlichen Daten lokal. Alle Daten werden von externen Datacurso-KI-Diensten verarbeitet.';
$string['privacy:metadata:aiprovider_datacurso'] = 'Datacurso-KI-Anfrage-Nutzlasten, die an den externen Dienst gesendet werden.';
$string['privacy:metadata:aiprovider_datacurso:externalpurpose'] = 'Diese Daten werden an Datacurso-KI gesendet, um die angeforderte Aktion zu erfüllen.';
$string['privacy:metadata:aiprovider_datacurso:numberimages'] = 'Gesamtzahl der vom KI-Dienst angeforderten Bilder.';
$string['privacy:metadata:aiprovider_datacurso:prompt'] = 'Der dem KI-Dienst bereitgestellte Anforderungstext.';
$string['privacy:metadata:aiprovider_datacurso:userid'] = 'Die Moodle-Benutzer-ID, die die KI-Anfrage stellt.';
$string['privacy:metadata:aiprovider_datacurso_rlimit'] = 'Pro Benutzer und Dienst rollierender Nutzungsstatus des Ratenlimits, lokal gespeichert.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:lastsync'] = 'Zeitstempel der letzten Synchronisation mit dem Remote-Verlauf.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:serviceid'] = 'Dienstkennung (z.B. local_coursegen).';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timecreated'] = 'Zeit, zu der dieser Datensatz erstellt wurde.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timemodified'] = 'Zeit, zu der dieser Datensatz zuletzt geändert wurde.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:tokensused'] = 'Innerhalb des aktuellen Zeitfensters verwendete Credits.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:userid'] = 'Benutzer-ID im Zusammenhang mit dem verfolgten Verbrauchsfenster.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:windowstart'] = 'Fensterstart-Zeitstempel zur Berechnung der Verbrauchsgrenzen.';
$string['ratelimit_enable'] = 'Ratenlimit aktivieren';
$string['ratelimit_enable_desc'] = 'Wenn aktiviert, wird das Credit-Limit pro Benutzer für dieses Plugin durchgesetzt.';
$string['ratelimit_limit'] = 'Ratenlimit';
$string['ratelimit_limit_desc'] = 'Die maximale Anzahl der pro Ratenlimit-Fenster zulässigen Anfragen.';
$string['ratelimit_limit_help'] = 'Die maximale Anzahl der pro Ratenlimit-Fenster zulässigen Anfragen.';
$string['ratelimit_local_assign_ai_allowedusers'] = 'Zulässige Aufgabenprüfer (KI)';
$string['ratelimit_local_assign_ai_allowedusers_desc'] = 'Wählen Sie die Benutzer aus, die Aufgaben mit KI überprüfen dürfen, wenn dieser Dienst aktiviert ist.';
$string['ratelimit_local_assign_ai_allowedusers_enable'] = 'Nach zulässigen Benutzern einschränken';
$string['ratelimit_local_assign_ai_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer Aufgaben mit KI überprüfen.';
$string['ratelimit_local_coursegen_activitycreators'] = 'Zulässige Aktivitätsersteller';
$string['ratelimit_local_coursegen_activitycreators_desc'] = 'Wählen Sie die Benutzer aus, die Aktivitäten oder Ressourcen mit KI generieren können, wenn dieser Dienst aktiviert ist.';
$string['ratelimit_local_coursegen_allowedusers_enable'] = 'Nach zulässigen Benutzern einschränken';
$string['ratelimit_local_coursegen_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer diesen Dienst verwenden.';
$string['ratelimit_local_coursegen_coursecreators'] = 'Zulässige Kursersteller';
$string['ratelimit_local_coursegen_coursecreators_desc'] = 'Wählen Sie die Benutzer aus, die vollständige Kurse mit KI erstellen können, wenn dieser Dienst aktiviert ist.';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable'] = 'Nach zulässigen Benutzern einschränken';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer KI-basierte Analysen im Bewertungs-Aktivitäten-KI-Plugin generieren.';
$string['ratelimit_local_datacurso_ratings_courseanalysts'] = 'Zulässige Kursanalyse-Generatoren (KI)';
$string['ratelimit_local_datacurso_ratings_courseanalysts_desc'] = 'Wählen Sie die Benutzer aus, die KI-Kursanalysen auf Kursebene generieren können.';
$string['ratelimit_local_datacurso_ratings_generalanalysts'] = 'Zulässige allgemeine Analyse-Generatoren (KI)';
$string['ratelimit_local_datacurso_ratings_generalanalysts_desc'] = 'Wählen Sie die Benutzer aus, die allgemeine KI-Analysen über Aktivitäten oder den Kurs generieren können.';
$string['ratelimit_report_lifestory_allowedusers'] = 'Zulässige KI-Feedback-Generatoren';
$string['ratelimit_report_lifestory_allowedusers_desc'] = 'Wählen Sie die Benutzer aus, die "KI-Feedback generieren" drücken können, um Leistungsdaten der Studenten (Noten, Abschluss, Teilnahme) an den Datacurso-KI-Anbieter zu senden und die KI-Erzählung mit Stärken, Schwächen und Empfehlungen anzuzeigen.';
$string['ratelimit_report_lifestory_allowedusers_enable'] = 'Nach zulässigen Benutzern einschränken';
$string['ratelimit_report_lifestory_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer KI-Feedback im Lebensgeschichte-Bericht generieren.';
$string['ratelimit_window'] = 'Zeitfenster';
$string['ratelimit_window_desc'] = 'Wählen Sie die Dauer und Einheit für das Ratenlimit-Fenster aus.';
$string['ratelimit_window_unit'] = 'Fenstereinheit';
$string['ratelimit_window_value'] = 'Fensterwert';
$string['ratelimits_heading'] = 'Ratenlimits pro Plugin';
$string['ratelimits_heading_desc'] = 'Konfigurieren Sie Ratenlimits pro Benutzer und Plugin, das den Datacurso-Anbieter verwendet.';
$string['read_context_course'] = 'Kontext für KI-Kurserstellung lesen';
$string['read_context_course_model'] = 'Akademisches Modell für KI-Kurserstellung hochladen';
$string['registers'] = 'Einträge';
$string['registration_error'] = 'Letzter Fehler';
$string['registration_last'] = 'Registrierung';
$string['registration_lastsent'] = 'Zuletzt gesendet';
$string['registration_notverified'] = 'Registrierung nicht verifiziert';
$string['registration_status'] = 'Letzter Status';
$string['registration_verified'] = 'Registrierung verifiziert';
$string['registrationapibearer'] = 'Registrierungs-Bearer-Token';
$string['registrationapibearer_desc'] = 'Bearer-Token zur Authentifizierung der Registrierungsanfrage.';
$string['registrationapiurl'] = 'Registrierungs-Endpunkt-URL';
$string['registrationapiurl_desc'] = 'Endpunkt zum Empfang der Seitenregistrierungs-Nutzlast. Standard: http://localhost:8001/register-site';
$string['registrationsettings'] = 'Registrierungs-API';
$string['remainingtokens'] = 'Verbleibendes Guthaben';
$string['responseinvalidai'] = 'Ungültige Antwort vom KI-Dienst.';
$string['responseinvalidaimage'] = 'Ungültige Antwort vom KI-Dienst (Kein Bild).';
$string['responseinvalidaimagecreate'] = 'Bilddatei konnte nicht erstellt werden.';
$string['rest_enabled'] = 'REST-Protokoll aktiviert';
$string['second'] = 'Sekunde';
$string['seconds'] = 'Sekunden';
$string['service'] = 'Dienst';
$string['showrows'] = 'Zeilen anzeigen';
$string['tokens'] = 'Credits';
$string['tokens_available'] = 'Verfügbare Credits';
$string['tokensconsumed'] = 'Verbrauchte Credits';
$string['tokensconsumedday'] = 'Credits pro Tag verbraucht';
$string['tokensconsumedmonth'] = 'Credits pro Monat verbraucht';
$string['tokensnotsufficient'] = 'Unzureichende KI-Credits. Aktuelles Guthaben: {$a->current}. Mindestanforderung: {$a->required}. Bitte besuchen Sie <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso-Shop, um Credits zuzuweisen oder weitere zu erwerben. Oder wenden Sie sich an Ihren Administrator.';
$string['tokensused'] = 'Verwendete Credits';
$string['tokenthreshold'] = 'Credits-Schwellenwert';
$string['tokenthreshold_desc'] = 'Anzahl der Credits, ab der eine Benachrichtigung zum Kauf weiterer Credits angezeigt wird.';
$string['total_consumed'] = 'Verbrauchte Credits';
$string['upgrade_sync_error'] = 'Datacurso-Aktualisierungsfehler: {$a}';
$string['userid'] = 'Benutzer';
$string['userratelimit'] = 'Anfragelimit pro Benutzer';
$string['userratelimit_desc'] = 'Maximale Anzahl der pro Stunde für jeden einzelnen Benutzer zulässigen Anfragen.';
$string['verified'] = 'Verifiziert';
$string['warningconfig_instance'] = 'Warnung: Für die ordnungsgemäße Verwendung sollte nur eine Instanz mit diesem Anbieter erstellt werden.';
$string['webserviceconfig_current'] = 'Aktuelle Konfiguration';
$string['webserviceconfig_desc'] = 'Konfiguriert automatisch einen dedizierten Webdienst für den Datacurso-KI-Dienst, der es ihm ermöglicht, Plattforminformationen wie grundlegende Benutzerdaten, Kurse und Aktivitäten sicher zu extrahieren, um eine bessere KI-Kontextualisierung zu ermöglichen. Diese Einrichtung erstellt einen Dienstbenutzer, weist die erforderliche Rolle zu, konfiguriert den externen Dienst, generiert ein sicheres Token und aktiviert das REST-Protokoll mit einem Klick. Hinweis: Der Token-Wert wird aus Sicherheitsgründen nicht angezeigt.';
$string['webserviceconfig_heading'] = 'Automatische Webdienst-Einrichtung';
$string['webserviceconfig_site'] = 'Seiteninformationen';
$string['webserviceconfig_status'] = 'Status';
$string['webserviceconfig_title'] = 'Datacurso-Webdienst-Konfiguration';
$string['week'] = 'Woche';
$string['weeks'] = 'Wochen';
$string['workplace'] = 'Ist dies Moodle Workplace?';
$string['workplace_desc'] = 'Definiert, ob der X-Workplace-Header mit dem Wert true (Workplace) oder false (Standard-Moodle) gesendet werden soll.';
$string['ws_activity'] = 'Aktivitätsprotokoll';
$string['ws_btn_regenerate'] = 'Token neu generieren';
$string['ws_btn_retry'] = 'Konfiguration wiederholen';
$string['ws_btn_setup'] = 'Webdienst konfigurieren';
$string['ws_enabled'] = 'Webdienste aktiviert';
$string['ws_error_missing_setup'] = 'Dienst oder Benutzer nicht gefunden. Führen Sie zuerst die Einrichtung durch.';
$string['ws_error_missing_token'] = 'Token nicht gefunden. Generieren Sie es zuerst.';
$string['ws_error_regenerate_token'] = 'Fehler beim Neu-Generieren des Tokens.';
$string['ws_error_registration'] = 'Fehler beim Registrieren des Webdienst-Tokens.';
$string['ws_error_setup'] = 'Fehler beim Konfigurieren des Webdienstes.';
$string['ws_role'] = 'Dienstrolle';
$string['ws_role_desc'] = 'Rolle für Datacurso-Webdienst';
$string['ws_role_name'] = 'Datacurso-Webdienst';
$string['ws_service'] = 'Externer Dienst';
$string['ws_service_name'] = 'Datacurso-Webdienst';
$string['ws_step_enableauth'] = 'Webdienste-Authentifizierungs-Plugin wird aktiviert…';
$string['ws_step_enablerest'] = 'REST-Protokoll wird aktiviert…';
$string['ws_step_enablews'] = 'Seiten-Webdienste werden aktiviert…';
$string['ws_step_registration_sent'] = 'Registrierungsanfrage gesendet.';
$string['ws_step_role_assign'] = 'Rolle wird Dienstbenutzer zugewiesen…';
$string['ws_step_role_caps'] = 'Erforderliche Rollenfähigkeiten werden gesetzt…';
$string['ws_step_role_create'] = 'Rolle "{$a}" wird erstellt…';
$string['ws_step_role_exists'] = 'Rolle existiert bereits, verwende ID {$a}…';
$string['ws_step_service_enable'] = 'Externer Dienst wird erstellt/aktiviert…';
$string['ws_step_service_functions'] = 'Gemeinsame Kernfunktionen werden zum Dienst hinzugefügt…';
$string['ws_step_service_user'] = 'Benutzer wird für den Dienst autorisiert…';
$string['ws_step_setup'] = 'Einrichtung wird gestartet…';
$string['ws_step_token_create'] = 'Token wird sichergestellt…';
$string['ws_step_token_generated'] = 'Token generiert.';
$string['ws_step_token_regenerated'] = 'Token neu generiert.';
$string['ws_step_token_regenerating'] = 'Token wird neu generiert…';
$string['ws_step_token_retry'] = 'Einrichtung wird wiederholt…';
$string['ws_step_user_check'] = 'Es wird überprüft, ob Benutzer "{$a}" existiert…';
$string['ws_step_user_create'] = 'Dienstbenutzer "{$a}" wird erstellt…';
$string['ws_token_label'] = 'Datacurso-Token';
$string['ws_tokenexists'] = 'Token existiert';
$string['ws_user'] = 'Dienstbenutzer';
$string['ws_user_firstname'] = 'Datacurso';
$string['ws_user_lastname'] = 'Dienst';
$string['ws_userassigned'] = 'Rolle dem Benutzer zugewiesen';
$string['year'] = 'Jahr';
$string['years'] = 'Jahre';
