<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     aiprovider_datacurso
 * @category    string
 * @copyright   Josue <josue@datacurso.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Tindakan';
$string['action:explain_text:endpoint'] = 'Endpoint jelaskan teks';
$string['action:explain_text:model'] = 'Model untuk penjelasan';
$string['action:explain_text:model_help'] = 'Pilih model yang akan menghasilkan penjelasan.';
$string['action:explain_text:systeminstruction'] = 'Instruksi sistem untuk penjelasan';
$string['action:explain_text:systeminstruction_help'] = 'Berikan konteks untuk memandu proses penjelasan.';
$string['action:generate_image:endpoint'] = 'Endpoint hasilkan gambar';
$string['action:generate_image:model'] = 'Model untuk menghasilkan gambar';
$string['action:generate_image:model_help'] = 'Pilih model AI untuk menghasilkan gambar.';
$string['action:generate_image:systeminstruction'] = 'Prompt sistem untuk menghasilkan gambar';
$string['action:generate_image:systeminstruction_help'] = 'Instruksi tambahan yang memandu AI dalam menghasilkan gambar yang diinginkan.';
$string['action:generate_text:endpoint'] = 'Endpoint hasilkan teks';
$string['action:generate_text:instruction'] = 'Instruksi sistem';
$string['action:generate_text:instruction_desc'] = 'Instruksi ini dikirim ke model AI bersama dengan prompt pengguna. Mengedit instruksi ini tidak disarankan kecuali benar-benar diperlukan.';
$string['action:generate_text:model'] = 'Model untuk menghasilkan teks';
$string['action:generate_text:model_help'] = 'Pilih model AI mana yang akan digunakan untuk menghasilkan teks.';
$string['action:generate_text:systeminstruction'] = 'Instruksi sistem';
$string['action:generate_text:systeminstruction_help'] = 'Instruksi atau konteks yang diberikan kepada AI sebelum menghasilkan teks. Berguna untuk mengontrol nada, struktur, atau tujuan respons.';
$string['action:summarise_text:endpoint'] = 'Endpoint ringkas teks';
$string['action:summarise_text:instruction'] = 'Instruksi sistem';
$string['action:summarise_text:instruction_desc'] = 'Instruksi ini dikirim ke model AI bersama dengan prompt pengguna. Mengedit instruksi ini tidak disarankan kecuali benar-benar diperlukan.';
$string['action:summarise_text:model'] = 'Model untuk meringkas';
$string['action:summarise_text:model_help'] = 'Pilih model AI mana yang akan digunakan untuk meringkas teks.';
$string['action:summarise_text:systeminstruction'] = 'Instruksi sistem untuk ringkasan';
$string['action:summarise_text:systeminstruction_help'] = 'Konteks opsional untuk memengaruhi cara ringkasan dihasilkan.';
$string['all'] = 'Semua';
$string['alt_datacurso_icon'] = 'Ikon Datacurso';
$string['apikey'] = 'Kunci API';
$string['apikey_desc'] = 'Masukkan kunci API dari layanan Datacurso Anda untuk menghubungkan AI.';
$string['apiurl'] = 'URL API Dasar';
$string['apiurl_desc'] = 'Masukkan URL dasar layanan untuk terhubung ke API Datacurso.';
$string['assigned'] = 'Ditugaskan';
$string['chart_actions'] = 'Distribusi kredit berdasarkan layanan';
$string['chart_tokens_by_day'] = 'Konsumsi kredit per hari';
$string['chart_tokens_by_month'] = 'Jumlah kredit yang dikonsumsi per bulan';
$string['configured'] = 'Dikonfigurasi';
$string['connection'] = 'Pengaturan koneksi';
$string['contextwstoken'] = 'Token layanan web untuk konteks kursus';
$string['contextwstoken_desc'] = 'Token yang digunakan oleh AI untuk mengambil informasi kursus (konteks). Disimpan dengan aman. Buat/kelola token di Administrasi Situs > Server > Layanan web > Kelola token.';
$string['created'] = 'Dibuat';
$string['curlerror'] = 'Kesalahan cURL API Datacurso: {$a}';
$string['custom_model_name'] = 'Nama model kustom';
$string['custom_model_name_help'] = 'Nama opsional untuk mengidentifikasi konfigurasi model AI spesifik ini.';
$string['datacurso:configurews'] = 'Konfigurasi layanan web Datacurso';
$string['datacurso:manage'] = 'Kelola pengaturan penyedia AI';
$string['datacurso:use'] = 'Gunakan layanan AI Datacurso';
$string['datacurso:viewreports'] = 'Lihat laporan penggunaan AI';
$string['day'] = 'hari';
$string['days'] = 'Hari';
$string['description'] = 'Deskripsi';
$string['descriptionpagelistplugins'] = 'Di sini Anda dapat menemukan daftar plugin yang kompatibel dengan penyedia Datacurso';
$string['disabled'] = 'Dinonaktifkan';
$string['emptyprompt'] = 'Prompt kosong';
$string['emptyresponse'] = 'Tidak ada respons dari API Datacurso.';
$string['enabled'] = 'Diaktifkan';
$string['enableglobalratelimit'] = 'Aktifkan batas global';
$string['enableglobalratelimit_desc'] = 'Jika diaktifkan, batas permintaan global per jam akan diterapkan untuk semua pengguna.';
$string['enableuserratelimit'] = 'Aktifkan batas per pengguna';
$string['enableuserratelimit_desc'] = 'Jika diaktifkan, setiap pengguna akan memiliki batas permintaan per jam.';
$string['endpointurl'] = 'URL Endpoint';
$string['endpointurl_help'] = 'URL endpoint API Dasar dari Penyedia AI Datacurso. Biasanya seperti https://api.datacurso.ai/v1/.';
$string['error_ratelimit_exceeded'] = 'Batas konsumsi yang diizinkan telah terlampaui. Silakan coba lagi pada {$a}.';
$string['error_webservice_not_configured'] = 'Tindakan ini tidak dapat dilanjutkan karena layanan web Datacurso yang memberi data kontekstual ke AI tidak dikonfigurasi. Selesaikan pengaturan otomatis di <a href="{$a->url}">Pengaturan layanan web Datacurso</a> dan coba lagi. Atau hubungi administrator Anda untuk informasi lebih lanjut.';
$string['errorgetbalancecredits'] = 'Tidak dapat mengambil saldo kredit dari API eksternal';
$string['errorinitinformation'] = 'Informasi awal tidak dapat diperoleh.';
$string['exists'] = 'Ada';
$string['forbidden'] = 'Anda tidak diizinkan untuk melakukan tindakan ini dengan lisensi saat ini. Harap verifikasi lisensi dan kredit yang tersedia di <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Kelola Kredit</a> di Toko Datacurso.';
$string['generate_activitie'] = 'Hasilkan aktivitas atau sumber daya dengan AI';
$string['generate_ai_reinforcement_activity'] = 'Buat aktivitas penguatan AI';
$string['generate_analysis_comments'] = 'Hasilkan analisis penilaian aktivitas/sumber daya dengan AI';
$string['generate_analysis_course'] = 'Hasilkan analisis penilaian kursus dengan AI';
$string['generate_analysis_general'] = 'Hasilkan analisis penilaian umum dengan AI';
$string['generate_analysis_story_student'] = 'Hasilkan cerita analisis siswa dengan AI';
$string['generate_assign_answer'] = 'Hasilkan tinjauan tugas dengan AI';
$string['generate_certificate_answer'] = 'Hasilkan pesan sertifikat dengan AI';
$string['generate_chat_message'] = 'Hasilkan pesan tutor AI';
$string['generate_creation_course'] = 'Buat kursus lengkap dengan AI';
$string['generate_forum_chat'] = 'Hasilkan respons forum dengan AI';
$string['generate_image'] = 'Hasilkan gambar dengan AI';
$string['generate_plan_course'] = 'Hasilkan rencana pembuatan kursus dengan AI';
$string['generate_summary'] = 'Hasilkan ringkasan dengan AI';
$string['generate_text'] = 'Hasilkan teks dengan AI';
$string['globalratelimit'] = 'Batas permintaan global';
$string['globalratelimit_desc'] = 'Jumlah maksimum permintaan yang diizinkan per jam untuk seluruh sistem.';
$string['goto'] = 'Pergi ke Laporan';
$string['gotopage'] = 'Pergi ke halaman';
$string['hour'] = 'jam';
$string['hours'] = 'Jam';
$string['httperror'] = 'Kesalahan tak terduga saat memproses permintaan Anda (HTTP {$a}). Silakan coba lagi nanti. Jika masalah berlanjut, hubungi administrator situs Anda.';
$string['id'] = 'ID';
$string['installed'] = 'Terinstal';
$string['invalidlicensekey'] = 'Kunci lisensi telah kedaluwarsa atau tidak valid. Silakan kunjungi <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Kelola Kredit</a> di Toko Datacurso untuk memperbarui atau membeli lisensi baru.';
$string['json_encode_failed'] = 'Gagal Mengkodekan Json';
$string['jsondecodeerror'] = 'Kesalahan saat memproses respons dari API Datacurso: {$a}';
$string['last_sent'] = 'Terakhir dikirim';
$string['license_not_allowed'] = 'Lisensi Anda tidak diizinkan untuk melakukan permintaan ini. Harap kelola lisensi dan kredit Anda di <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Kelola Kredit</a> di Toko Datacurso.';
$string['licensekey'] = 'Kunci lisensi';
$string['licensekey_desc'] = 'Masukkan kunci lisensi dari area pelanggan Toko Datacurso.';
$string['licensekey_help'] = 'Masukkan kunci lisensi penyedia AI Datacurso Anda.';
$string['link_consumptionhistory'] = 'Riwayat konsumsi kredit';
$string['link_generalreport'] = 'Laporan umum';
$string['link_generalreport_datacurso'] = 'Laporan umum AI Datacurso';
$string['link_listplugings'] = 'Daftar plugin Datacurso';
$string['link_plugin'] = 'Tautan';
$string['link_provider_config'] = 'Konfigurasi penyedia';
$string['link_report_statistic'] = 'Laporan statistik umum';
$string['link_webservice_config'] = 'Pengaturan layanan web Datacurso';
$string['live_log'] = 'Log langsung';
$string['message_no_there_plugins'] = 'Tidak ada plugin yang tersedia';
$string['minute'] = 'menit';
$string['minutes'] = 'Menit';
$string['missing'] = 'Hilang';
$string['month'] = 'bulan';
$string['months'] = 'Bulan';
$string['needs_repair'] = 'Perlu perbaikan';
$string['nodata'] = 'Tidak ditemukan informasi';
$string['not_assigned'] = 'Tidak ditugaskan';
$string['not_configured'] = 'Tidak dikonfigurasi';
$string['not_created'] = 'Tidak dibuat';
$string['notallowed'] = 'Anda tidak diizinkan untuk melakukan tindakan ini. Silakan hubungi administrator Anda untuk informasi lebih lanjut.';
$string['notenoughtokens'] = 'Kredit AI tidak mencukupi. Silakan kunjungi <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Kelola Kredit</a> di Toko Datacurso untuk mengalokasikan atau membeli lebih banyak kredit. Atau hubungi administrator Anda.';
$string['of'] = 'dari';
$string['orgid'] = 'ID Organisasi';
$string['orgid_desc'] = 'Masukkan pengenal organisasi Anda di layanan Datacurso.';
$string['pageinfo'] = 'Halaman {$a->current} dari {$a->totalpages} ({$a->total} rekaman)';
$string['pending'] = 'Tertunda';
$string['plugin'] = 'Plugin';
$string['plugindesc_assign_ai'] = 'Tinjau tugas dengan bantuan AI.';
$string['plugindesc_coursegen'] = 'Buat kursus lengkap, aktivitas, dan sumber daya dengan AI.';
$string['plugindesc_datacurso_ratings'] = 'Memungkinkan siswa menilai aktivitas dan sumber daya; guru dan administrator kemudian dapat menghasilkan analisis kursus berbasis AI.';
$string['plugindesc_dttutor'] = 'Obrolan dengan tutor AI di dalam kursus.';
$string['plugindesc_forum_ai'] = 'Perluas forum dengan analisis bertenaga AI untuk menghasilkan ringkasan secara otomatis.';
$string['plugindesc_lifestory'] = 'Laporan dan analisis bertenaga AI tentang kemajuan akademik siswa.';
$string['plugindesc_smartrules'] = 'Buat aktivitas otomatis berdasarkan kondisi siswa sebelumnya.';
$string['plugindesc_socialcert'] = 'Secara otomatis menghasilkan sertifikat yang dipersonalisasi setelah menyelesaikan kursus.';
$string['pluginname'] = 'Penyedia AI Datacurso';
$string['pluginname_assign_ai'] = 'Tugas AI';
$string['pluginname_coursegen'] = 'Pembuat Kursus AI';
$string['pluginname_datacurso_ratings'] = 'Peringkat Aktivitas AI';
$string['pluginname_dttutor'] = 'Tutor AI';
$string['pluginname_forum_ai'] = 'Forum AI';
$string['pluginname_lifestory'] = 'Kisah Hidup Siswa AI';
$string['pluginname_smartrules'] = 'Aturan Cerdas AI';
$string['pluginname_socialcert'] = 'Sertifikat Berbagi AI';
$string['privacy:metadata'] = 'Plugin Penyedia AI Datacurso tidak menyimpan data pribadi secara lokal. Semua data diproses oleh layanan AI Datacurso eksternal.';
$string['privacy:metadata:aiprovider_datacurso'] = 'Payload permintaan AI Datacurso dikirim ke layanan eksternal.';
$string['privacy:metadata:aiprovider_datacurso:externalpurpose'] = 'Data ini dikirim ke AI Datacurso untuk memenuhi tindakan yang diminta.';
$string['privacy:metadata:aiprovider_datacurso:numberimages'] = 'Jumlah total gambar yang diminta dari layanan AI.';
$string['privacy:metadata:aiprovider_datacurso:prompt'] = 'Teks prompt yang disediakan untuk layanan AI.';
$string['privacy:metadata:aiprovider_datacurso:userid'] = 'ID pengguna Moodle yang membuat permintaan AI.';
$string['privacy:metadata:aiprovider_datacurso_rlimit'] = 'Status penggunaan bergulir batas kecepatan per pengguna per layanan disimpan secara lokal.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:lastsync'] = 'Stempel waktu sinkronisasi terakhir dengan riwayat jarak jauh.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:serviceid'] = 'Pengidentifikasi layanan (misalnya, local_coursegen).';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timecreated'] = 'Waktu ketika rekaman ini dibuat.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timemodified'] = 'Waktu ketika rekaman ini terakhir dimodifikasi.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:tokensused'] = 'Kredit yang digunakan dalam jendela waktu saat ini.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:userid'] = 'ID pengguna yang terkait dengan jendela konsumsi yang dilacak.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:windowstart'] = 'Stempel waktu mulai jendela yang digunakan untuk menghitung batas konsumsi.';
$string['ratelimit_enable'] = 'Aktifkan batas kecepatan';
$string['ratelimit_enable_desc'] = 'Jika diaktifkan, batas kredit per pengguna akan diberlakukan untuk plugin ini.';
$string['ratelimit_limit'] = 'Batas kecepatan';
$string['ratelimit_limit_desc'] = 'Jumlah maksimum permintaan yang diizinkan per jendela batas kecepatan.';
$string['ratelimit_limit_help'] = 'Jumlah maksimum permintaan yang diizinkan per jendela batas kecepatan.';
$string['ratelimit_local_assign_ai_allowedusers'] = 'Peninjau tugas yang diizinkan (AI)';
$string['ratelimit_local_assign_ai_allowedusers_desc'] = 'Pilih pengguna yang diizinkan untuk meninjau tugas dengan AI saat layanan ini diaktifkan.';
$string['ratelimit_local_assign_ai_allowedusers_enable'] = 'Batas berdasarkan pengguna yang diizinkan';
$string['ratelimit_local_assign_ai_allowedusers_enable_desc'] = 'Jika diaktifkan, hanya pengguna yang dipilih di bawah ini yang diizinkan untuk meninjau tugas dengan AI.';
$string['ratelimit_local_coursegen_activitycreators'] = 'Pembuat aktivitas yang diizinkan';
$string['ratelimit_local_coursegen_activitycreators_desc'] = 'Pilih pengguna yang dapat menghasilkan aktivitas atau sumber daya dengan AI saat layanan ini diaktifkan.';
$string['ratelimit_local_coursegen_allowedusers_enable'] = 'Batas berdasarkan pengguna yang diizinkan';
$string['ratelimit_local_coursegen_allowedusers_enable_desc'] = 'Jika diaktifkan, hanya pengguna yang dipilih di bawah ini yang diizinkan untuk menggunakan layanan ini.';
$string['ratelimit_local_coursegen_coursecreators'] = 'Pembuat kursus yang diizinkan';
$string['ratelimit_local_coursegen_coursecreators_desc'] = 'Pilih pengguna yang dapat membuat kursus lengkap dengan AI saat layanan ini diaktifkan.';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable'] = 'Batas berdasarkan pengguna yang diizinkan';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable_desc'] = 'Jika diaktifkan, hanya pengguna yang dipilih di bawah ini yang diizinkan untuk menghasilkan analisis berbasis AI di plugin Peringkat Aktivitas AI.';
$string['ratelimit_local_datacurso_ratings_courseanalysts'] = 'Penganalisis kursus yang diizinkan (AI)';
$string['ratelimit_local_datacurso_ratings_courseanalysts_desc'] = 'Pilih pengguna yang dapat menghasilkan analisis tingkat kursus AI.';
$string['ratelimit_local_datacurso_ratings_generalanalysts'] = 'Penganalisis umum yang diizinkan (AI)';
$string['ratelimit_local_datacurso_ratings_generalanalysts_desc'] = 'Pilih pengguna yang dapat menghasilkan analisis umum AI di seluruh aktivitas atau kursus.';
$string['ratelimit_report_lifestory_allowedusers'] = 'Pembangkit umpan balik AI yang diizinkan';
$string['ratelimit_report_lifestory_allowedusers_desc'] = 'Pilih pengguna yang dapat menekan "Hasilkan Umpan Balik AI" untuk mengirim data kinerja siswa (nilai, penyelesaian, partisipasi) ke Penyedia AI Datacurso dan menampilkan narasi AI dengan kekuatan, kelemahan, dan rekomendasi.';
$string['ratelimit_report_lifestory_allowedusers_enable'] = 'Batas berdasarkan pengguna yang diizinkan';
$string['ratelimit_report_lifestory_allowedusers_enable_desc'] = 'Jika diaktifkan, hanya pengguna yang dipilih di bawah ini yang diizinkan untuk menghasilkan umpan balik AI dalam laporan Kisah Hidup.';
$string['ratelimit_window'] = 'Jendela waktu';
$string['ratelimit_window_desc'] = 'Pilih durasi dan unit untuk jendela batas kecepatan.';
$string['ratelimit_window_unit'] = 'Unit jendela';
$string['ratelimit_window_value'] = 'Nilai jendela';
$string['ratelimits_heading'] = 'Batas kecepatan per plugin';
$string['ratelimits_heading_desc'] = 'Konfigurasi batas kecepatan per pengguna untuk setiap plugin yang menggunakan penyedia Datacurso.';
$string['read_context_course'] = 'Baca konteks untuk pembuatan kursus AI';
$string['read_context_course_model'] = 'Unggah model akademik untuk pembuatan kursus AI';
$string['registers'] = 'Register';
$string['registration_error'] = 'Kesalahan terakhir';
$string['registration_last'] = 'Pendaftaran';
$string['registration_lastsent'] = 'Terakhir dikirim';
$string['registration_notverified'] = 'Pendaftaran tidak diverifikasi';
$string['registration_status'] = 'Status terakhir';
$string['registration_verified'] = 'Pendaftaran diverifikasi';
$string['registrationapibearer'] = 'Token Bearer pendaftaran';
$string['registrationapibearer_desc'] = 'Token Bearer digunakan untuk mengautentikasi permintaan pendaftaran.';
$string['registrationapiurl'] = 'URL Endpoint pendaftaran';
$string['registrationapiurl_desc'] = 'Endpoint untuk menerima payload pendaftaran situs. Default: http://localhost:8001/register-site';
$string['registrationsettings'] = 'API Pendaftaran';
$string['remainingtokens'] = 'Saldo tersisa';
$string['responseinvalidai'] = 'Respons tidak valid dari layanan AI.';
$string['responseinvalidaimage'] = 'Respons tidak valid dari layanan AI (Tidak ada gambar).';
$string['responseinvalidaimagecreate'] = 'Tidak dapat membuat file gambar.';
$string['rest_enabled'] = 'Protokol REST diaktifkan';
$string['second'] = 'detik';
$string['seconds'] = 'Detik';
$string['service'] = 'Layanan';
$string['showrows'] = 'Tampilkan baris';
$string['tokens'] = 'Kredit';
$string['tokens_available'] = 'Kredit Tersedia';
$string['tokensconsumed'] = 'Kredit dikonsumsi';
$string['tokensconsumedday'] = 'Kredit dikonsumsi per hari';
$string['tokensconsumedmonth'] = 'Kredit dikonsumsi per bulan';
$string['tokensnotsufficient'] = 'Kredit AI tidak mencukupi. Saldo saat ini: {$a->current}. Minimal yang diperlukan: {$a->required}. Silakan kunjungi <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Kelola Kredit</a> di Toko Datacurso untuk mengalokasikan atau membeli lebih banyak kredit. Atau hubungi administrator Anda.';
$string['tokensused'] = 'Kredit digunakan';
$string['tokenthreshold'] = 'Ambang batas kredit';
$string['tokenthreshold_desc'] = 'Jumlah kredit dari mana notifikasi akan ditampilkan untuk membeli lebih banyak.';
$string['total_consumed'] = 'Kredit dikonsumsi';
$string['upgrade_sync_error'] = 'Kesalahan peningkatan Datacurso: {$a}';
$string['userid'] = 'Pengguna';
$string['userratelimit'] = 'Batas permintaan per pengguna';
$string['userratelimit_desc'] = 'Jumlah maksimum permintaan yang diizinkan per jam untuk setiap pengguna individu.';
$string['verified'] = 'Diverifikasi';
$string['warningconfig_instance'] = 'Peringatan: Hanya satu instance yang harus dibuat dengan penyedia ini untuk penggunaan yang tepat.';
$string['webserviceconfig_current'] = 'Konfigurasi saat ini';
$string['webserviceconfig_desc'] = 'Secara otomatis mengkonfigurasi layanan web khusus untuk layanan AI Datacurso, memungkinkannya untuk mengekstrak informasi platform dengan aman seperti data dasar pengguna, kursus, dan aktivitas untuk kontekstualisasi AI yang lebih baik. Pengaturan ini membuat pengguna layanan, menetapkan peran yang diperlukan, mengkonfigurasi layanan eksternal, menghasilkan token aman, dan mengaktifkan protokol REST dalam satu klik. Catatan: Nilai token tidak ditampilkan untuk alasan keamanan.';
$string['webserviceconfig_heading'] = 'Pengaturan layanan web otomatis';
$string['webserviceconfig_site'] = 'Informasi situs';
$string['webserviceconfig_status'] = 'Status';
$string['webserviceconfig_title'] = 'Konfigurasi Layanan Web Datacurso';
$string['week'] = 'minggu';
$string['weeks'] = 'Minggu';
$string['workplace'] = 'Apakah ini Moodle Workplace?';
$string['workplace_desc'] = 'Mendefinisikan apakah header X-Workplace harus dikirim dengan nilai true (Workplace) atau false (Moodle Standar).';
$string['ws_activity'] = 'Log aktivitas';
$string['ws_btn_regenerate'] = 'Regenerasi token';
$string['ws_btn_retry'] = 'Coba lagi konfigurasi';
$string['ws_btn_setup'] = 'Konfigurasi layanan web';
$string['ws_enabled'] = 'Layanan web diaktifkan';
$string['ws_error_missing_setup'] = 'Layanan atau pengguna tidak ditemukan. Jalankan pengaturan terlebih dahulu.';
$string['ws_error_missing_token'] = 'Token tidak ditemukan. Hasilkan terlebih dahulu.';
$string['ws_error_regenerate_token'] = 'Kesalahan saat meregenerasi token.';
$string['ws_error_registration'] = 'Kesalahan saat mendaftarkan token layanan web.';
$string['ws_error_setup'] = 'Kesalahan saat mengkonfigurasi layanan web.';
$string['ws_role'] = 'Peran layanan';
$string['ws_role_desc'] = 'Peran untuk layanan web Datacurso';
$string['ws_role_name'] = 'Layanan web Datacurso';
$string['ws_service'] = 'Layanan eksternal';
$string['ws_service_name'] = 'Layanan web Datacurso';
$string['ws_step_enableauth'] = 'Mengaktifkan plugin otentikasi layanan web…';
$string['ws_step_enablerest'] = 'Mengaktifkan protokol REST…';
$string['ws_step_enablews'] = 'Mengaktifkan layanan web situs…';
$string['ws_step_registration_sent'] = 'Permintaan pendaftaran terkirim.';
$string['ws_step_role_assign'] = 'Menetapkan peran ke pengguna layanan…';
$string['ws_step_role_caps'] = 'Mengatur kapabilitas peran yang diperlukan…';
$string['ws_step_role_create'] = 'Membuat peran "{$a}"…';
$string['ws_step_role_exists'] = 'Peran sudah ada, menggunakan ID {$a}…';
$string['ws_step_service_enable'] = 'Membuat/Mengaktifkan layanan eksternal…';
$string['ws_step_service_functions'] = 'Menambahkan fungsi inti umum ke layanan…';
$string['ws_step_service_user'] = 'Mengotorisasi pengguna untuk layanan…';
$string['ws_step_setup'] = 'Memulai pengaturan…';
$string['ws_step_token_create'] = 'Memastikan token ada…';
$string['ws_step_token_generated'] = 'Token dihasilkan.';
$string['ws_step_token_regenerated'] = 'Token diregenerasi.';
$string['ws_step_token_regenerating'] = 'Meregenerasi token…';
$string['ws_step_token_retry'] = 'Mencoba lagi pengaturan…';
$string['ws_step_user_check'] = 'Memverifikasi apakah pengguna "{$a}" ada…';
$string['ws_step_user_create'] = 'Membuat pengguna layanan "{$a}"…';
$string['ws_token_label'] = 'Token Datacurso';
$string['ws_tokenexists'] = 'Token ada';
$string['ws_user'] = 'Pengguna layanan';
$string['ws_user_firstname'] = 'Datacurso';
$string['ws_user_lastname'] = 'Layanan';
$string['ws_userassigned'] = 'Peran ditugaskan ke pengguna';
$string['year'] = 'tahun';
$string['years'] = 'Tahun';
