<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     aiprovider_datacurso
 * @category    string
 * @copyright   Josue <josue@datacurso.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Действие';
$string['action:explain_text:endpoint'] = 'Конечная точка для объяснения текста';
$string['action:explain_text:model'] = 'Модель для объяснения';
$string['action:explain_text:model_help'] = 'Выберите модель, которая будет генерировать объяснения.';
$string['action:explain_text:systeminstruction'] = 'Системная инструкция для объяснения';
$string['action:explain_text:systeminstruction_help'] = 'Предоставьте контекст для направления процесса объяснения.';
$string['action:generate_image:endpoint'] = 'Конечная точка для генерации изображения';
$string['action:generate_image:model'] = 'Модель для генерации изображений';
$string['action:generate_image:model_help'] = 'Выберите модель ИИ для генерации изображений.';
$string['action:generate_image:systeminstruction'] = 'Системный запрос для генерации изображения';
$string['action:generate_image:systeminstruction_help'] = 'Дополнительные инструкции, которые направляют ИИ при генерации желаемого изображения.';
$string['action:generate_text:endpoint'] = 'Конечная точка для генерации текста';
$string['action:generate_text:instruction'] = 'Системная инструкция';
$string['action:generate_text:instruction_desc'] = 'Эта инструкция отправляется модели ИИ вместе с запросом пользователя. Редактирование этой инструкции не рекомендуется, если это не требуется абсолютно.';
$string['action:generate_text:model'] = 'Модель для генерации текста';
$string['action:generate_text:model_help'] = 'Выберите, какая модель ИИ будет использоваться для генерации текста.';
$string['action:generate_text:systeminstruction'] = 'Системная инструкция';
$string['action:generate_text:systeminstruction_help'] = 'Инструкция или контекст, предоставляемый ИИ перед генерацией текста. Полезно для контроля тона, структуры или цели ответа.';
$string['action:summarise_text:endpoint'] = 'Конечная точка для суммирования текста';
$string['action:summarise_text:instruction'] = 'Системная инструкция';
$string['action:summarise_text:instruction_desc'] = 'Эта инструкция отправляется модели ИИ вместе с запросом пользователя. Редактирование этой инструкции не рекомендуется, если это не требуется абсолютно.';
$string['action:summarise_text:model'] = 'Модель для суммирования';
$string['action:summarise_text:model_help'] = 'Выберите, какая модель ИИ будет использоваться для суммирования текста.';
$string['action:summarise_text:systeminstruction'] = 'Системная инструкция для резюме';
$string['action:summarise_text:systeminstruction_help'] = 'Необязательный контекст для влияния на то, как генерируется резюме.';
$string['all'] = 'Все';
$string['alt_datacurso_icon'] = 'Значок Datacurso';
$string['apikey'] = 'Ключ API';
$string['apikey_desc'] = 'Введите ключ API вашего сервиса Datacurso для подключения ИИ.';
$string['apiurl'] = 'Базовый URL API';
$string['apiurl_desc'] = 'Введите базовый URL сервиса для подключения к API Datacurso.';
$string['assigned'] = 'Назначено';
$string['chart_actions'] = 'Распределение кредитов по услугам';
$string['chart_tokens_by_day'] = 'Потребление кредитов по дням';
$string['chart_tokens_by_month'] = 'Количество потребленных кредитов в месяц';
$string['configured'] = 'Настроено';
$string['connection'] = 'Настройки подключения';
$string['contextwstoken'] = 'Токен веб-сервиса для контекста курса';
$string['contextwstoken_desc'] = 'Токен, используемый ИИ для получения информации о курсе (контекста). Хранится безопасно. Создание/управление токенами в разделе Администрирование сайта > Сервер > Веб-сервисы > Управление токенами.';
$string['created'] = 'Создано';
$string['curlerror'] = 'Ошибка cURL API Datacurso: {$a}';
$string['custom_model_name'] = 'Пользовательское имя модели';
$string['custom_model_name_help'] = 'Необязательное имя для идентификации этой конкретной конфигурации модели ИИ.';
$string['datacurso:configurews'] = 'Настроить веб-сервис Datacurso';
$string['datacurso:manage'] = 'Управление настройками провайдера ИИ';
$string['datacurso:use'] = 'Использовать сервисы ИИ Datacurso';
$string['datacurso:viewreports'] = 'Просмотр отчетов об использовании ИИ';
$string['day'] = 'день';
$string['days'] = 'Дни';
$string['description'] = 'Описание';
$string['descriptionpagelistplugins'] = 'Здесь вы можете найти список плагинов, совместимых с провайдером Datacurso';
$string['disabled'] = 'Отключено';
$string['emptyprompt'] = 'Пустой запрос';
$string['emptyresponse'] = 'Нет ответа от API Datacurso.';
$string['enabled'] = 'Включено';
$string['enableglobalratelimit'] = 'Включить глобальное ограничение';
$string['enableglobalratelimit_desc'] = 'Если включено, будет применяться глобальное ограничение запросов в час для всех пользователей.';
$string['enableuserratelimit'] = 'Включить ограничение для каждого пользователя';
$string['enableuserratelimit_desc'] = 'Если включено, каждый пользователь будет иметь часовое ограничение запросов.';
$string['endpointurl'] = 'URL конечной точки';
$string['endpointurl_help'] = 'Базовый URL конечной точки API провайдера ИИ Datacurso. Обычно что-то вроде https://api.datacurso.ai/v1/.';
$string['error_ratelimit_exceeded'] = 'Превышен разрешенный лимит потребления. Пожалуйста, попробуйте снова в {$a}.';
$string['error_webservice_not_configured'] = 'Это действие не может быть продолжено, так как веб-сервис Datacurso, который предоставляет контекстуальные данные ИИ, не настроен. Завершите автоматическую настройку на <a href="{$a->url}">Настройка веб-сервиса Datacurso</a> и попробуйте снова. Или свяжитесь с вашим администратором для получения дополнительной информации.';
$string['errorgetbalancecredits'] = 'Не удалось получить баланс кредитов от внешнего API';
$string['errorinitinformation'] = 'Не удалось получить начальную информацию.';
$string['exists'] = 'Существует';
$string['forbidden'] = 'Вам не разрешено выполнять это действие с текущей лицензией. Пожалуйста, проверьте вашу лицензию и доступные кредиты в <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Управление кредитами</a> в Магазине Datacurso.';
$string['generate_activitie'] = 'Сгенерировать активность или ресурс с помощью ИИ';
$string['generate_ai_reinforcement_activity'] = 'Создать активность усиления ИИ';
$string['generate_analysis_comments'] = 'Сгенерировать анализ рейтинга активности/ресурса с помощью ИИ';
$string['generate_analysis_course'] = 'Сгенерировать анализ рейтинга курса с помощью ИИ';
$string['generate_analysis_general'] = 'Сгенерировать общий анализ рейтинга с помощью ИИ';
$string['generate_analysis_story_student'] = 'Сгенерировать историю анализа студента с помощью ИИ';
$string['generate_assign_answer'] = 'Сгенерировать обзор задания с помощью ИИ';
$string['generate_certificate_answer'] = 'Сгенерировать сообщение сертификата с помощью ИИ';
$string['generate_chat_message'] = 'Сгенерировать сообщение ИИ-тьютора';
$string['generate_creation_course'] = 'Создать полный курс с помощью ИИ';
$string['generate_forum_chat'] = 'Сгенерировать ответ на форуме с помощью ИИ';
$string['generate_image'] = 'Сгенерировать изображение с помощью ИИ';
$string['generate_plan_course'] = 'Сгенерировать план создания курса с помощью ИИ';
$string['generate_summary'] = 'Сгенерировать резюме с помощью ИИ';
$string['generate_text'] = 'Сгенерировать текст с помощью ИИ';
$string['globalratelimit'] = 'Глобальное ограничение запросов';
$string['globalratelimit_desc'] = 'Максимальное количество запросов, разрешенное в час для всей системы.';
$string['goto'] = 'Перейти к отчету';
$string['gotopage'] = 'Перейти на страницу';
$string['hour'] = 'час';
$string['hours'] = 'Часы';
$string['httperror'] = 'Непредвиденная ошибка при обработке вашего запроса (HTTP {$a}). Пожалуйста, попробуйте снова позже. Если проблема сохраняется, свяжитесь с администратором вашего сайта.';
$string['id'] = 'ID';
$string['installed'] = 'Установлено';
$string['invalidlicensekey'] = 'Срок действия лицензионного ключа истек или он недействителен. Пожалуйста, перейдите в <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Управление кредитами</a> в Магазине Datacurso, чтобы продлить или приобрести новую лицензию.';
$string['json_encode_failed'] = 'Не удалось закодировать Json';
$string['jsondecodeerror'] = 'Ошибка обработки ответа от API Datacurso: {$a}';
$string['last_sent'] = 'Последняя отправка';
$string['license_not_allowed'] = 'Вашей лицензии не разрешено выполнять этот запрос. Пожалуйста, управляйте своими лицензиями и кредитами в <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Управление кредитами</a> в Магазине Datacurso.';
$string['licensekey'] = 'Лицензионный ключ';
$string['licensekey_desc'] = 'Введите лицензионный ключ из клиентской зоны Магазина Datacurso.';
$string['licensekey_help'] = 'Введите ваш лицензионный ключ провайдера ИИ Datacurso.';
$string['link_consumptionhistory'] = 'История потребления кредитов';
$string['link_generalreport'] = 'Общий отчет';
$string['link_generalreport_datacurso'] = 'Общий отчет Datacurso ИИ';
$string['link_listplugings'] = 'Список плагинов Datacurso';
$string['link_plugin'] = 'Ссылка';
$string['link_provider_config'] = 'Конфигурация провайдера';
$string['link_report_statistic'] = 'Отчет об общей статистике';
$string['link_webservice_config'] = 'Настройка веб-сервиса Datacurso';
$string['live_log'] = 'Живой журнал';
$string['message_no_there_plugins'] = 'Нет доступных плагинов';
$string['minute'] = 'минута';
$string['minutes'] = 'Минуты';
$string['missing'] = 'Отсутствует';
$string['month'] = 'месяц';
$string['months'] = 'Месяцы';
$string['needs_repair'] = 'Требуется ремонт';
$string['nodata'] = 'Информация не найдена';
$string['not_assigned'] = 'Не назначен';
$string['not_configured'] = 'Не настроен';
$string['not_created'] = 'Не создан';
$string['notallowed'] = 'Вам не разрешено выполнять это действие. Пожалуйста, свяжитесь с вашим администратором для получения дополнительной информации.';
$string['notenoughtokens'] = 'Недостаточно кредитов ИИ. Пожалуйста, посетите <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Управление кредитами</a> в Магазине Datacurso, чтобы выделить или купить больше кредитов. Или свяжитесь с вашим администратором.';
$string['of'] = 'из';
$string['orgid'] = 'ID Организации';
$string['orgid_desc'] = 'Введите идентификатор вашей организации в сервисе Datacurso.';
$string['pageinfo'] = 'Страница {$a->current} из {$a->totalpages} ({$a->total} записей)';
$string['pending'] = 'Ожидание';
$string['plugin'] = 'Плагин';
$string['plugindesc_assign_ai'] = 'Проверка заданий с помощью ИИ.';
$string['plugindesc_coursegen'] = 'Создание полных курсов, активностей и ресурсов с помощью ИИ.';
$string['plugindesc_datacurso_ratings'] = 'Позволяет студентам оценивать активности и ресурсы; преподаватели и администраторы могут затем генерировать анализ курса на основе ИИ.';
$string['plugindesc_dttutor'] = 'Чат с ИИ-тьютором в рамках курса.';
$string['plugindesc_forum_ai'] = 'Расширение форумов с помощью анализа на основе ИИ для автоматической генерации резюме.';
$string['plugindesc_lifestory'] = 'Отчет и анализ академического прогресса студента на основе ИИ.';
$string['plugindesc_smartrules'] = 'Создание автоматизированных активностей на основе предыдущих условий студентов.';
$string['plugindesc_socialcert'] = 'Автоматическая генерация персонализированных сертификатов по завершении курса.';
$string['pluginname'] = 'Провайдер ИИ Datacurso';
$string['pluginname_assign_ai'] = 'Задание ИИ';
$string['pluginname_coursegen'] = 'Создатель Курсов ИИ';
$string['pluginname_datacurso_ratings'] = 'Рейтинг Активностей ИИ';
$string['pluginname_dttutor'] = 'Тьютор ИИ';
$string['pluginname_forum_ai'] = 'Форум ИИ';
$string['pluginname_lifestory'] = 'История Жизни Студента ИИ';
$string['pluginname_smartrules'] = 'Умные Правила ИИ';
$string['pluginname_socialcert'] = 'Поделиться Сертификатом ИИ';
$string['privacy:metadata'] = 'Плагин Провайдер ИИ Datacurso не хранит никаких персональных данных локально. Все данные обрабатываются внешними сервисами ИИ Datacurso.';
$string['privacy:metadata:aiprovider_datacurso'] = 'Полезные данные запросов ИИ Datacurso, отправляемые внешнему сервису.';
$string['privacy:metadata:aiprovider_datacurso:externalpurpose'] = 'Эти данные отправляются Datacurso AI для выполнения запрошенного действия.';
$string['privacy:metadata:aiprovider_datacurso:numberimages'] = 'Общее количество изображений, запрошенных у сервиса ИИ.';
$string['privacy:metadata:aiprovider_datacurso:prompt'] = 'Текст запроса, предоставленный сервису ИИ.';
$string['privacy:metadata:aiprovider_datacurso:userid'] = 'ID пользователя Moodle, выполняющего запрос ИИ.';
$string['privacy:metadata:aiprovider_datacurso_rlimit'] = 'Состояние скользящего использования ограничения скорости по пользователю и сервису, хранящееся локально.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:lastsync'] = 'Отметка времени последней синхронизации с удаленной историей.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:serviceid'] = 'Идентификатор сервиса (например, local_coursegen).';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timecreated'] = 'Время создания этой записи.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timemodified'] = 'Время последнего изменения этой записи.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:tokensused'] = 'Кредиты, использованные в текущем временном окне.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:userid'] = 'ID пользователя, связанный с отслеживаемым окном потребления.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:windowstart'] = 'Отметка времени начала окна, используемая для расчета лимитов потребления.';
$string['ratelimit_enable'] = 'Включить ограничение скорости';
$string['ratelimit_enable_desc'] = 'Если включено, ограничение кредитов для каждого пользователя будет применяться для этого плагина.';
$string['ratelimit_limit'] = 'Ограничение скорости';
$string['ratelimit_limit_desc'] = 'Максимальное количество запросов, разрешенное в пределах окна ограничения скорости.';
$string['ratelimit_limit_help'] = 'Максимальное количество запросов, разрешенное в пределах окна ограничения скорости.';
$string['ratelimit_local_assign_ai_allowedusers'] = 'Разрешенные рецензенты заданий (ИИ)';
$string['ratelimit_local_assign_ai_allowedusers_desc'] = 'Выберите пользователей, которым разрешено просматривать задания с помощью ИИ, когда этот сервис включен.';
$string['ratelimit_local_assign_ai_allowedusers_enable'] = 'Ограничить разрешенными пользователями';
$string['ratelimit_local_assign_ai_allowedusers_enable_desc'] = 'Если включено, только выбранным ниже пользователям будет разрешено просматривать задания с помощью ИИ.';
$string['ratelimit_local_coursegen_activitycreators'] = 'Разрешенные создатели активностей';
$string['ratelimit_local_coursegen_activitycreators_desc'] = 'Выберите пользователей, которые могут генерировать активности или ресурсы с помощью ИИ, когда этот сервис включен.';
$string['ratelimit_local_coursegen_allowedusers_enable'] = 'Ограничить разрешенными пользователями';
$string['ratelimit_local_coursegen_allowedusers_enable_desc'] = 'Если включено, только выбранным ниже пользователям будет разрешено использовать этот сервис.';
$string['ratelimit_local_coursegen_coursecreators'] = 'Разрешенные создатели курсов';
$string['ratelimit_local_coursegen_coursecreators_desc'] = 'Выберите пользователей, которые могут создавать полные курсы с помощью ИИ, когда этот сервис включен.';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable'] = 'Ограничить разрешенными пользователями';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable_desc'] = 'Если включено, только выбранным ниже пользователям будет разрешено генерировать анализ на основе ИИ в плагине Рейтинг Активностей ИИ.';
$string['ratelimit_local_datacurso_ratings_courseanalysts'] = 'Разрешенные генераторы анализа курсов (ИИ)';
$string['ratelimit_local_datacurso_ratings_courseanalysts_desc'] = 'Выберите пользователей, которые могут генерировать анализ уровня курса ИИ.';
$string['ratelimit_local_datacurso_ratings_generalanalysts'] = 'Разрешенные генераторы общего анализа (ИИ)';
$string['ratelimit_local_datacurso_ratings_generalanalysts_desc'] = 'Выберите пользователей, которые могут генерировать общий анализ ИИ по активностям или курсу.';
$string['ratelimit_report_lifestory_allowedusers'] = 'Разрешенные генераторы обратной связи ИИ';
$string['ratelimit_report_lifestory_allowedusers_desc'] = 'Выберите пользователей, которые могут нажать «Сгенерировать обратную связь ИИ», чтобы отправить данные о производительности студента (оценки, завершение, участие) провайдеру ИИ Datacurso и отобразить нарратив ИИ с сильными, слабыми сторонами и рекомендациями.';
$string['ratelimit_report_lifestory_allowedusers_enable'] = 'Ограничить разрешенными пользователями';
$string['ratelimit_report_lifestory_allowedusers_enable_desc'] = 'Если включено, только выбранным ниже пользователям будет разрешено генерировать обратную связь ИИ в отчете История Жизни.';
$string['ratelimit_window'] = 'Временное окно';
$string['ratelimit_window_desc'] = 'Выберите продолжительность и единицу для окна ограничения скорости.';
$string['ratelimit_window_unit'] = 'Единица окна';
$string['ratelimit_window_value'] = 'Значение окна';
$string['ratelimits_heading'] = 'Ограничения скорости по плагину';
$string['ratelimits_heading_desc'] = 'Настройте ограничения скорости для каждого пользователя для каждого плагина, использующего провайдера Datacurso.';
$string['read_context_course'] = 'Читать контекст для создания курса ИИ';
$string['read_context_course_model'] = 'Загрузить академическую модель для создания курса ИИ';
$string['registers'] = 'Реестры';
$string['registration_error'] = 'Последняя ошибка';
$string['registration_last'] = 'Регистрация';
$string['registration_lastsent'] = 'Последняя отправка';
$string['registration_notverified'] = 'Регистрация не подтверждена';
$string['registration_status'] = 'Последний статус';
$string['registration_verified'] = 'Регистрация подтверждена';
$string['registrationapibearer'] = 'Токен Bearer регистрации';
$string['registrationapibearer_desc'] = 'Токен Bearer, используемый для аутентификации запроса на регистрацию.';
$string['registrationapiurl'] = 'URL конечной точки регистрации';
$string['registrationapiurl_desc'] = 'Конечная точка для получения полезной нагрузки регистрации сайта. По умолчанию: http://localhost:8001/register-site';
$string['registrationsettings'] = 'API Регистрации';
$string['remainingtokens'] = 'Остаток баланса';
$string['responseinvalidai'] = 'Недопустимый ответ от сервиса ИИ.';
$string['responseinvalidaimage'] = 'Недопустимый ответ от сервиса ИИ (Нет изображения).';
$string['responseinvalidaimagecreate'] = 'Не удалось создать файл изображения.';
$string['rest_enabled'] = 'Протокол REST включен';
$string['second'] = 'секунда';
$string['seconds'] = 'Секунды';
$string['service'] = 'Сервис';
$string['showrows'] = 'Показать строки';
$string['tokens'] = 'Кредиты';
$string['tokens_available'] = 'Доступные кредиты';
$string['tokensconsumed'] = 'Кредиты потреблены';
$string['tokensconsumedday'] = 'Кредиты потреблены за день';
$string['tokensconsumedmonth'] = 'Кредиты потреблены за месяц';
$string['tokensnotsufficient'] = 'Недостаточно кредитов ИИ. Текущий баланс: {$a->current}. Минимум требуется: {$a->required}. Пожалуйста, посетите <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Управление кредитами</a> в Магазине Datacurso, чтобы выделить или купить больше кредитов. Или свяжитесь с вашим администратором.';
$string['tokensused'] = 'Использовано кредитов';
$string['tokenthreshold'] = 'Порог кредитов';
$string['tokenthreshold_desc'] = 'Количество кредитов, при котором будет отображаться уведомление о необходимости покупки дополнительных.';
$string['total_consumed'] = 'Кредиты потреблены';
$string['upgrade_sync_error'] = 'Ошибка обновления Datacurso: {$a}';
$string['userid'] = 'Пользователь';
$string['userratelimit'] = 'Ограничение запросов для каждого пользователя';
$string['userratelimit_desc'] = 'Максимальное количество запросов, разрешенное в час для каждого отдельного пользователя.';
$string['verified'] = 'Подтверждено';
$string['warningconfig_instance'] = 'Предупреждение: Должен быть создан только один экземпляр с этим провайдером для корректного использования.';
$string['webserviceconfig_current'] = 'Текущая конфигурация';
$string['webserviceconfig_desc'] = 'Автоматически настраивает выделенный веб-сервис для сервиса ИИ Datacurso, позволяя ему безопасно извлекать информацию о платформе, такую как основные данные пользователя, курсы и активности, для лучшей контекстуализации ИИ. Эта настройка создает сервисного пользователя, назначает необходимую роль, настраивает внешний сервис, генерирует безопасный токен и включает протокол REST одним щелчком. Примечание: Значение токена не отображается по соображениям безопасности.';
$string['webserviceconfig_heading'] = 'Автоматическая настройка веб-сервиса';
$string['webserviceconfig_site'] = 'Информация о сайте';
$string['webserviceconfig_status'] = 'Статус';
$string['webserviceconfig_title'] = 'Конфигурация Веб-Сервиса Datacurso';
$string['week'] = 'неделя';
$string['weeks'] = 'Недели';
$string['workplace'] = 'Это Moodle Workplace?';
$string['workplace_desc'] = 'Определяет, должен ли заголовок X-Workplace отправляться со значением true (Workplace) или false (Стандартный Moodle).';
$string['ws_activity'] = 'Журнал активности';
$string['ws_btn_regenerate'] = 'Регенерировать токен';
$string['ws_btn_retry'] = 'Повторить настройку';
$string['ws_btn_setup'] = 'Настроить веб-сервис';
$string['ws_enabled'] = 'Веб-сервисы включены';
$string['ws_error_missing_setup'] = 'Сервис или пользователь не найден. Сначала выполните настройку.';
$string['ws_error_missing_token'] = 'Токен не найден. Сначала сгенерируйте его.';
$string['ws_error_regenerate_token'] = 'Ошибка при регенерации токена.';
$string['ws_error_registration'] = 'Ошибка при регистрации токена веб-сервиса.';
$string['ws_error_setup'] = 'Ошибка при настройке веб-сервиса.';
$string['ws_role'] = 'Роль сервиса';
$string['ws_role_desc'] = 'Роль для веб-сервиса Datacurso';
$string['ws_role_name'] = 'Веб-сервис Datacurso';
$string['ws_service'] = 'Внешний сервис';
$string['ws_service_name'] = 'Веб-сервис Datacurso';
$string['ws_step_enableauth'] = 'Включение плагина аутентификации веб-сервисов…';
$string['ws_step_enablerest'] = 'Включение протокола REST…';
$string['ws_step_enablews'] = 'Включение веб-сервисов сайта…';
$string['ws_step_registration_sent'] = 'Запрос на регистрацию отправлен.';
$string['ws_step_role_assign'] = 'Назначение роли сервисному пользователю…';
$string['ws_step_role_caps'] = 'Установка необходимых возможностей роли…';
$string['ws_step_role_create'] = 'Создание роли "{$a}"…';
$string['ws_step_role_exists'] = 'Роль уже существует, используется ID {$a}…';
$string['ws_step_service_enable'] = 'Создание/Включение внешнего сервиса…';
$string['ws_step_service_functions'] = 'Добавление общих основных функций к сервису…';
$string['ws_step_service_user'] = 'Авторизация пользователя для сервиса…';
$string['ws_step_setup'] = 'Начало настройки…';
$string['ws_step_token_create'] = 'Проверка существования токена…';
$string['ws_step_token_generated'] = 'Токен сгенерирован.';
$string['ws_step_token_regenerated'] = 'Токен регенерирован.';
$string['ws_step_token_regenerating'] = 'Регенерация токена…';
$string['ws_step_token_retry'] = 'Повторная попытка настройки…';
$string['ws_step_user_check'] = 'Проверка существования пользователя "{$a}"…';
$string['ws_step_user_create'] = 'Создание сервисного пользователя "{$a}"…';
$string['ws_token_label'] = 'Токен Datacurso';
$string['ws_tokenexists'] = 'Токен существует';
$string['ws_user'] = 'Сервисный пользователь';
$string['ws_user_firstname'] = 'Datacurso';
$string['ws_user_lastname'] = 'Сервис';
$string['ws_userassigned'] = 'Роль назначена пользователю';
$string['year'] = 'год';
$string['years'] = 'Годы';
