<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     aiprovider_datacurso
 * @category    string
 * @copyright   Josue <josue@datacurso.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['action:explain_text:endpoint'] = 'Endpoint para explicação de texto';
$string['action:explain_text:model'] = 'Modelo para a explicação';
$string['action:explain_text:model_help'] = 'Selecione o modelo que irá gerar as explicações.';
$string['action:explain_text:systeminstruction'] = 'Instrução de sistema para explicação';
$string['action:explain_text:systeminstruction_help'] = 'Forneça contexto para guiar o processo de explicação.';
$string['action:generate_image:endpoint'] = 'Endpoint para geração de imagem';
$string['action:generate_image:model'] = 'Modelo para geração de imagem';
$string['action:generate_image:model_help'] = 'Selecione o modelo de IA para gerar imagens.';
$string['action:generate_image:systeminstruction'] = 'Prompt de sistema para geração de imagem';
$string['action:generate_image:systeminstruction_help'] = 'Instruções adicionais que guiam a IA na geração da imagem desejada.';
$string['action:generate_text:endpoint'] = 'Endpoint para geração de texto';
$string['action:generate_text:instruction'] = 'Instrução de sistema';
$string['action:generate_text:instruction_desc'] = 'Esta instrução é enviada ao modelo de IA junto com o prompt do usuário. A edição desta instrução não é recomendada, a menos que seja absolutamente necessária.';
$string['action:generate_text:model'] = 'Modelo para geração de texto';
$string['action:generate_text:model_help'] = 'Selecione qual modelo de IA será usado para gerar o texto.';
$string['action:generate_text:systeminstruction'] = 'Instrução de sistema';
$string['action:generate_text:systeminstruction_help'] = 'Instrução ou contexto dado à IA antes de gerar o texto. Útil para controlar tom, estrutura ou propósito da resposta.';
$string['action:summarise_text:endpoint'] = 'Endpoint para resumir texto';
$string['action:summarise_text:instruction'] = 'Instrução de sistema';
$string['action:summarise_text:instruction_desc'] = 'Esta instrução é enviada ao modelo de IA junto com o prompt do usuário. A edição desta instrução não é recomendada, a menos que seja absolutamente necessária.';
$string['action:summarise_text:model'] = 'Modelo para resumo';
$string['action:summarise_text:model_help'] = 'Selecione qual modelo de IA será usado para resumir o texto.';
$string['action:summarise_text:systeminstruction'] = 'Instrução de sistema para resumo';
$string['action:summarise_text:systeminstruction_help'] = 'Contexto opcional para influenciar como o resumo é gerado.';
$string['all'] = 'Todos';
$string['alt_datacurso_icon'] = 'Ícone Datacurso';
$string['apikey'] = 'Chave API';
$string['apikey_desc'] = 'Insira a chave API do seu serviço Datacurso para conectar a IA.';
$string['apiurl'] = 'URL Base da API';
$string['apiurl_desc'] = 'Insira a URL base do serviço para conectar à API Datacurso.';
$string['assigned'] = 'Atribuído';
$string['chart_actions'] = 'Distribuição de créditos por serviço';
$string['chart_tokens_by_day'] = 'Consumo de créditos por dia';
$string['chart_tokens_by_month'] = 'Número de créditos consumidos por mês';
$string['configured'] = 'Configurado';
$string['confirm_delete_message'] = 'Você realmente deseja excluir o limite de crédito para "{$a}"?';
$string['confirm_delete_title'] = 'Excluir limite de crédito';
$string['confirm_reset_usage_message'] = 'Isso redefinirá o contador de uso para "{$a}". Deseja continuar?';
$string['connection'] = 'Configurações de conexão';
$string['contextwstoken'] = 'Token de serviço web para contexto do curso';
$string['contextwstoken_desc'] = 'Token usado pela IA para recuperar informações do curso (contexto). Armazenado de forma segura. Criar/gerenciar tokens em Administração do Site > Servidor > Serviços web > Gerenciar tokens.';
$string['created'] = 'Criado';
$string['curlerror'] = 'Erro cURL da API Datacurso: {$a}';
$string['custom_model_name'] = 'Nome de modelo personalizado';
$string['custom_model_name_help'] = 'Nome opcional para identificar esta configuração específica de modelo de IA.';
$string['datacurso:configurews'] = 'Configurar serviço web Datacurso';
$string['datacurso:manage'] = 'Gerenciar configurações do provedor de IA';
$string['datacurso:managetokenlimits'] = 'Gerenciar limites de créditos por usuário';
$string['datacurso:use'] = 'Usar serviços de IA Datacurso';
$string['datacurso:viewreports'] = 'Visualizar relatórios de uso de IA';
$string['day'] = 'dia';
$string['days'] = 'Dias';
$string['description'] = 'Descrição';
$string['descriptionpagelistplugins'] = 'Aqui você pode encontrar a lista de plugins compatíveis com o provedor Datacurso';
$string['disabled'] = 'Desativado';
$string['emptyprompt'] = 'Prompt vazio';
$string['emptyresponse'] = 'Sem resposta da API Datacurso.';
$string['enabled'] = 'Ativado';
$string['enableglobalratelimit'] = 'Habilitar limite global';
$string['enableglobalratelimit_desc'] = 'Se habilitado, um limite de solicitação global por hora será aplicado para todos os usuários.';
$string['enableuserratelimit'] = 'Habilitar limite por usuário';
$string['enableuserratelimit_desc'] = 'Se habilitado, cada usuário terá um limite de solicitação horária.';
$string['endpointurl'] = 'URL do Endpoint';
$string['endpointurl_help'] = 'URL do endpoint base da API do Provedor de IA Datacurso. Geralmente algo como https://api.datacurso.ai/v1/.';
$string['error_ratelimit_exceeded'] = 'O limite de consumo permitido foi excedido. Por favor, tente novamente às {$a}.';
$string['error_usertokenlimit_exceeded'] = 'Créditos permitidos excedidos ({$a}). Por favor, entre em contato com seu administrador para mais informações.';
$string['error_usertokenlimit_exists'] = 'Um limite de crédito para o usuário selecionado já existe.';
$string['error_usertokenlimit_notfound'] = 'Limite de crédito do usuário não encontrado.';
$string['error_webservice_not_configured'] = 'Esta ação não pode continuar porque o serviço web Datacurso que alimenta dados contextuais para a IA não está configurado. Conclua a configuração automática em <a href="{$a->url}">Configuração do webservice Datacurso</a> e tente novamente. Ou entre em contato com seu administrador para mais informações.';
$string['errorgetbalancecredits'] = 'Não foi possível recuperar o saldo de créditos da API externa';
$string['errorinitinformation'] = 'As informações iniciais não puderam ser obtidas.';
$string['exists'] = 'Existe';
$string['forbidden'] = 'Você não tem permissão para realizar esta ação com a licença atual. Por favor, verifique sua licença e créditos disponíveis em <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gerenciar Créditos</a> na Loja Datacurso.';
$string['generate_activitie'] = 'Gerar atividade ou recurso com IA';
$string['generate_ai_reinforcement_activity'] = 'Criar atividade de reforço de IA';
$string['generate_analysis_comments'] = 'Gerar análise de avaliação de uma atividade/recurso com IA';
$string['generate_analysis_course'] = 'Gerar análise de avaliação de curso com IA';
$string['generate_analysis_general'] = 'Gerar análise de avaliação geral com IA';
$string['generate_analysis_story_student'] = 'Gerar história de análise do aluno com IA';
$string['generate_assign_answer'] = 'Gerar revisão de tarefa com IA';
$string['generate_certificate_answer'] = 'Gerar mensagem de certificado com IA';
$string['generate_chat_message'] = 'Gerar mensagem de tutor de IA';
$string['generate_creation_course'] = 'Criar curso completo com IA';
$string['generate_forum_chat'] = 'Gerar resposta de fórum com IA';
$string['generate_image'] = 'Gerar imagem com IA';
$string['generate_plan_course'] = 'Gerar plano de criação de curso com IA';
$string['generate_summary'] = 'Gerar resumo com IA';
$string['generate_text'] = 'Gerar texto com IA';
$string['globalratelimit'] = 'Limite global de solicitações';
$string['globalratelimit_desc'] = 'Número máximo de solicitações permitidas por hora para todo o sistema.';
$string['goto'] = 'Ir para o Relatório';
$string['gotopage'] = 'Ir para a página';
$string['hour'] = 'hora';
$string['hours'] = 'Horas';
$string['httperror'] = 'Erro inesperado ao processar sua solicitação (HTTP {$a}). Por favor, tente novamente mais tarde. Se o problema persistir, entre em contato com o administrador do seu site.';
$string['id'] = 'ID';
$string['installed'] = 'Instalado';
$string['instance_disabled'] = 'A instância do provedor Datacurso está desativada';
$string['invalidjson'] = 'JSON Inválido';
$string['invalidlicensekey'] = 'A chave de licença expirou ou é inválida. Por favor, vá para <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gerenciar Créditos</a> na Loja Datacurso para renovar ou comprar uma nova licença.';
$string['json_encode_failed'] = 'Falha na Codificação Json';
$string['jsondecodeerror'] = 'Erro ao processar a resposta da API Datacurso: {$a}';
$string['last_sent'] = 'Último envio';
$string['license_not_allowed'] = 'Sua licença não tem permissão para realizar esta solicitação. Por favor, gerencie suas licenças e créditos em <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gerenciar Créditos</a> na Loja Datacurso.';
$string['licensekey'] = 'Chave de licença';
$string['licensekey_desc'] = 'Insira a chave de licença da área de cliente da Loja Datacurso.';
$string['licensekey_help'] = 'Insira sua chave de licença do provedor de IA Datacurso.';
$string['licensekey_missing'] = 'A chave de licença não está configurada';
$string['link_consumptionhistory'] = 'Histórico de consumo de créditos';
$string['link_generalreport'] = 'Relatório geral';
$string['link_generalreport_datacurso'] = 'Relatório geral Datacurso IA';
$string['link_listplugings'] = 'Lista de plugins Datacurso';
$string['link_plugin'] = 'Link';
$string['link_provider_config'] = 'Configuração do provedor';
$string['link_report_statistic'] = 'Relatório de estatísticas gerais';
$string['link_usertokenlimits'] = 'Limites de créditos por usuário Datacurso';
$string['link_webservice_config'] = 'Configuração do webservice Datacurso';
$string['live_log'] = 'Registro em tempo real';
$string['message_no_there_plugins'] = 'Nenhum plugin disponível';
$string['minute'] = 'minuto';
$string['minutes'] = 'Minutos';
$string['missing'] = 'Faltando';
$string['month'] = 'mês';
$string['months'] = 'Meses';
$string['needs_repair'] = 'Precisa de reparo';
$string['nodata'] = 'Nenhuma informação encontrada';
$string['not_assigned'] = 'Não atribuído';
$string['not_configured'] = 'Não configurado';
$string['not_created'] = 'Não criado';
$string['notallowed'] = 'Você não tem permissão para realizar esta ação. Por favor, entre em contato com seu administrador para mais informações.';
$string['notenoughtokens'] = 'Créditos de IA insuficientes. Por favor, visite <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gerenciar Créditos</a> na Loja Datacurso para alocar ou comprar mais créditos. Ou entre em contato com seu administrador.';
$string['of'] = 'de';
$string['orgid'] = 'ID da Organização';
$string['orgid_desc'] = 'Insira o identificador da sua organização no serviço Datacurso.';
$string['pageinfo'] = 'Página {$a->current} de {$a->totalpages} ({$a->total} registros)';
$string['pending'] = 'Pendente';
$string['plugin'] = 'Plugin';
$string['plugindesc_assign_ai'] = 'Revisar tarefas com assistência de IA.';
$string['plugindesc_coursegen'] = 'Criar cursos completos, atividades e recursos com IA.';
$string['plugindesc_datacurso_ratings'] = 'Permite que os alunos avaliem atividades e recursos; professores e administradores podem gerar análises de curso baseadas em IA posteriormente.';
$string['plugindesc_dttutor'] = 'Conversar com um tutor de IA dentro do curso.';
$string['plugindesc_forum_ai'] = 'Estende fóruns com análise impulsionada por IA para gerar resumos automaticamente.';
$string['plugindesc_lifestory'] = 'Relatório e análise impulsionados por IA do progresso acadêmico do aluno.';
$string['plugindesc_smartrules'] = 'Criar atividades automatizadas com base nas condições anteriores dos alunos.';
$string['plugindesc_socialcert'] = 'Gerar automaticamente certificados personalizados após a conclusão do curso.';
$string['pluginname'] = 'Provedor de IA Datacurso';
$string['pluginname_assign_ai'] = 'Tarefa IA';
$string['pluginname_coursegen'] = 'Criador de Cursos IA';
$string['pluginname_datacurso_ratings'] = 'Avaliação de Atividades IA';
$string['pluginname_dttutor'] = 'Tutor IA';
$string['pluginname_forum_ai'] = 'Fórum IA';
$string['pluginname_lifestory'] = 'História de Vida do Aluno IA';
$string['pluginname_smartrules'] = 'SmartRules IA';
$string['pluginname_socialcert'] = 'Compartilhar Certificado IA';
$string['privacy:metadata'] = 'O plugin Provedor de IA Datacurso não armazena dados pessoais localmente. Todos os dados são processados por serviços de IA Datacurso externos.';
$string['privacy:metadata:aiprovider_datacurso'] = 'Cargas úteis de solicitação de IA Datacurso enviadas ao serviço externo.';
$string['privacy:metadata:aiprovider_datacurso:externalpurpose'] = 'Estes dados são enviados ao Datacurso AI para cumprir a ação solicitada.';
$string['privacy:metadata:aiprovider_datacurso:numberimages'] = 'Número total de imagens solicitadas ao serviço de IA.';
$string['privacy:metadata:aiprovider_datacurso:prompt'] = 'O texto do prompt fornecido ao serviço de IA.';
$string['privacy:metadata:aiprovider_datacurso:userid'] = 'O ID de usuário Moodle que faz a solicitação de IA.';
$string['privacy:metadata:aiprovider_datacurso_rlimit'] = 'Status de uso contínuo do limite de taxa por usuário por serviço armazenado localmente.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:lastsync'] = 'Timestamp da última sincronização com o histórico remoto.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:serviceid'] = 'Identificador de serviço (por exemplo, local_coursegen).';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timecreated'] = 'Hora em que este registro foi criado.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timemodified'] = 'Hora em que este registro foi modificado pela última vez.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:tokensused'] = 'Créditos usados dentro da janela de tempo atual.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:userid'] = 'ID de usuário relacionado à janela de consumo rastreada.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:windowstart'] = 'Timestamp de início da janela usado para calcular limites de consumo.';
$string['privacy:metadata:aiprovider_datacurso_userlimit'] = 'Cotas de token Datacurso por usuário armazenadas localmente.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:countfrom'] = 'Timestamp marcando quando a cota começou a rastrear o uso.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:lastsync'] = 'Última vez que as informações de uso foram sincronizadas.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:timecreated'] = 'Hora em que o registro de cota foi criado.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:timemodified'] = 'Hora em que o registro de cota foi atualizado pela última vez.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:tokenlimit'] = 'Número máximo de tokens concedidos ao usuário.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:tokensused'] = 'Tokens consumidos desde o início do rastreamento.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:userid'] = 'ID de usuário associado à cota.';
$string['ratelimit_enable'] = 'Habilitar limite de taxa';
$string['ratelimit_enable_desc'] = 'Se habilitado, o limite de crédito por usuário será imposto para este plugin.';
$string['ratelimit_limit'] = 'Limite de crédito por janela';
$string['ratelimit_limit_desc'] = 'Número máximo de créditos que um usuário pode consumir dentro da janela de tempo selecionada. 0 para ilimitado.';
$string['ratelimit_limit_help'] = 'O número máximo de solicitações permitidas por janela de limite de taxa.';
$string['ratelimit_local_assign_ai_allowedusers'] = 'Revisores de tarefas permitidos (IA)';
$string['ratelimit_local_assign_ai_allowedusers_desc'] = 'Selecione os usuários que têm permissão para revisar tarefas com IA quando este serviço estiver habilitado.';
$string['ratelimit_local_assign_ai_allowedusers_desc_help'] = 'Esta configuração define uma lista de usuários específicos que estão isentos do limite de taxa global para este serviço de IA, permitindo apenas a eles gerar notas ou feedback baseados em IA para tarefas do Moodle.';
$string['ratelimit_local_assign_ai_allowedusers_enable'] = 'Limitar por usuários permitidos';
$string['ratelimit_local_assign_ai_allowedusers_enable_desc'] = 'Se habilitado, apenas os usuários selecionados abaixo terão permissão para revisar tarefas com IA.';
$string['ratelimit_local_coursegen_activitycreators'] = 'Criadores de atividade permitidos';
$string['ratelimit_local_coursegen_activitycreators_desc'] = 'Selecione os usuários que podem gerar atividades ou recursos com IA quando este serviço estiver habilitado.';
$string['ratelimit_local_coursegen_allowedusers_enable'] = 'Limitar por usuários permitidos';
$string['ratelimit_local_coursegen_allowedusers_enable_desc'] = 'Se habilitado, apenas os usuários selecionados abaixo terão permissão para usar este serviço.';
$string['ratelimit_local_coursegen_coursecreators'] = 'Criadores de curso permitidos';
$string['ratelimit_local_coursegen_coursecreators_desc'] = 'Selecione os usuários que podem criar cursos completos com IA quando este serviço estiver habilitado.';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable'] = 'Limitar por usuários permitidos';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable_desc'] = 'Se habilitado, apenas os usuários selecionados abaixo terão permissão para gerar análises baseadas em IA no plugin Avaliação de Atividades IA.';
$string['ratelimit_local_datacurso_ratings_courseanalysts'] = 'Geradores de análise de curso permitidos (IA)';
$string['ratelimit_local_datacurso_ratings_courseanalysts_desc'] = 'Selecione os usuários que podem gerar análise de nível de curso por IA.';
$string['ratelimit_local_datacurso_ratings_generalanalysts'] = 'Geradores de análise geral permitidos (IA)';
$string['ratelimit_local_datacurso_ratings_generalanalysts_desc'] = 'Selecione os usuários que podem gerar análise geral de IA em atividades ou no curso.';
$string['ratelimit_report_lifestory_allowedusers'] = 'Geradores de feedback de IA permitidos';
$string['ratelimit_report_lifestory_allowedusers_desc'] = 'Selecione os usuários que podem pressionar “Gerar Feedback de IA” para enviar dados de desempenho do aluno (notas, conclusão, participação) ao Provedor de IA Datacurso e exibir a narrativa de IA com pontos fortes, fracos e recomendações.';
$string['ratelimit_report_lifestory_allowedusers_enable'] = 'Limitar por usuários permitidos';
$string['ratelimit_report_lifestory_allowedusers_enable_desc'] = 'Se habilitado, apenas os usuários selecionados abaixo terão permissão para gerar feedback de IA no relatório História de Vida do Aluno.';
$string['ratelimit_window'] = 'Janela de tempo';
$string['ratelimit_window_desc'] = 'Selecione a duração e a unidade para a janela de limite de taxa.';
$string['ratelimit_window_unit'] = 'Unidade da janela';
$string['ratelimit_window_value'] = 'Valor da janela';
$string['ratelimits_heading'] = 'Limites de taxa por plugin';
$string['ratelimits_heading_desc'] = 'Configure os limites de taxa por usuário por plugin que usa o provedor Datacurso.';
$string['read_context_course'] = 'Ler contexto para criação de curso IA';
$string['read_context_course_model'] = 'Carregar modelo acadêmico para criação de curso IA';
$string['registers'] = 'Registros';
$string['registration_error'] = 'Último erro';
$string['registration_last'] = 'Registro';
$string['registration_lastsent'] = 'Último envio';
$string['registration_notverified'] = 'Registro não verificado';
$string['registration_status'] = 'Último status';
$string['registration_verified'] = 'Registro verificado';
$string['registrationapibearer'] = 'Token Bearer de registro';
$string['registrationapibearer_desc'] = 'Token Bearer usado para autenticar a solicitação de registro.';
$string['registrationapiurl'] = 'URL do Endpoint de registro';
$string['registrationapiurl_desc'] = 'Endpoint para receber a carga útil de registro do site. Padrão: http://localhost:8001/register-site';
$string['registrationsettings'] = 'API de Registro';
$string['remainingtokens'] = 'Saldo restante';
$string['responseinvalidai'] = 'Resposta inválida do serviço de IA.';
$string['responseinvalidaimage'] = 'Resposta inválida do serviço de IA (Sem imagem).';
$string['responseinvalidaimagecreate'] = 'Não foi possível criar o arquivo de imagem.';
$string['rest_enabled'] = 'Protocolo REST habilitado';
$string['second'] = 'segundo';
$string['seconds'] = 'Segundos';
$string['service'] = 'Serviço';
$string['showrows'] = 'Mostrar linhas';
$string['tokens'] = 'Créditos';
$string['tokens_available'] = 'Créditos Disponíveis';
$string['tokensconsumed'] = 'Créditos consumidos';
$string['tokensconsumedday'] = 'Créditos consumidos por dia';
$string['tokensconsumedmonth'] = 'Créditos consumidos por mês';
$string['tokensnotsufficient'] = 'Créditos de IA insuficientes. Saldo atual: {$a->current}. Mínimo necessário: {$a->required}. Por favor, visite <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Gerenciar Créditos</a> na Loja Datacurso para alocar ou comprar mais créditos. Ou entre em contato com seu administrador.';
$string['tokensused'] = 'Créditos usados';
$string['tokenthreshold'] = 'Limite de créditos';
$string['tokenthreshold_desc'] = 'Número de créditos a partir do qual uma notificação será exibida para comprar mais.';
$string['total_consumed'] = 'Créditos consumidos';
$string['upgrade_sync_error'] = 'Erro de atualização do Datacurso: {$a}';
$string['userid'] = 'Usuário';
$string['userratelimit'] = 'Limite de solicitações por usuário';
$string['userratelimit_desc'] = 'Número máximo de solicitações permitidas por hora para cada usuário individual.';
$string['usertokenlimit_add'] = 'Adicionar limite de crédito';
$string['usertokenlimit_add_title'] = 'Adicionar limite de crédito por usuário';
$string['usertokenlimit_delete_failed'] = 'Não foi possível excluir o limite de crédito do usuário.';
$string['usertokenlimit_deleted'] = 'Limite de crédito do usuário excluído.';
$string['usertokenlimit_edit_title'] = 'Editar limite: {$a}';
$string['usertokenlimit_limit'] = 'Limite de crédito';
$string['usertokenlimit_limit_help'] = 'Insira o número máximo de créditos que o usuário está autorizado a consumir. O valor deve ser maior que zero.';
$string['usertokenlimit_limit_invalid'] = 'O limite deve ser um número positivo maior que zero.';
$string['usertokenlimit_reset'] = 'Redefinir contador de uso';
$string['usertokenlimit_reset_done'] = 'O contador de uso foi redefinido.';
$string['usertokenlimit_reset_failed'] = 'Não foi possível redefinir o contador de uso.';
$string['usertokenlimit_reset_help'] = 'Se habilitado, o contador de uso atual para este usuário será redefinido imediatamente após salvar.';
$string['usertokenlimit_reset_usage'] = 'Redefinir uso';
$string['usertokenlimit_saved'] = 'Limite de crédito do usuário salvo';
$string['usertokenlimit_used'] = 'Créditos usados';
$string['usertokenlimit_user'] = 'Usuário';
$string['usertokenlimit_user_help'] = 'Selecione o usuário ao qual o limite de crédito será aplicado.';
$string['usertokenlimit_user_readonly'] = 'Usuário';
$string['usertokenlimit_user_readonly_help'] = 'Este usuário é fixo para registros existentes e não pode ser alterado.';
$string['verified'] = 'Verificado';
$string['warningconfig_instance'] = 'Aviso: Apenas uma instância deve ser criada com este provedor para uso adequado.';
$string['webserviceconfig_current'] = 'Configuração atual';
$string['webserviceconfig_desc'] = 'Configura automaticamente um serviço web dedicado para o serviço de IA Datacurso, permitindo que ele extraia com segurança informações da plataforma, como dados básicos do usuário, cursos e atividades, para melhor contextualização da IA. Esta configuração cria um usuário de serviço, atribui a função necessária, configura o serviço externo, gera um token seguro e habilita o protocolo REST em um clique. Nota: O valor do token não é exibido por razões de segurança.';
$string['webserviceconfig_heading'] = 'Configuração automática do webservice';
$string['webserviceconfig_site'] = 'Informações do site';
$string['webserviceconfig_status'] = 'Status';
$string['webserviceconfig_title'] = 'Configuração do Serviço Web Datacurso';
$string['week'] = 'semana';
$string['weeks'] = 'Semanas';
$string['workplace'] = 'Este é o Moodle Workplace?';
$string['workplace_desc'] = 'Define se o cabeçalho X-Workplace deve ser enviado com valor true (Workplace) ou false (Moodle Padrão).';
$string['ws_activity'] = 'Registro de atividade';
$string['ws_btn_regenerate'] = 'Regerar token';
$string['ws_btn_retry'] = 'Tentar novamente a configuração';
$string['ws_btn_setup'] = 'Configurar webservice';
$string['ws_enabled'] = 'Serviços web habilitados';
$string['ws_error_missing_setup'] = 'Serviço ou usuário não encontrado. Execute a configuração primeiro.';
$string['ws_error_missing_token'] = 'Token não encontrado. Gere-o primeiro.';
$string['ws_error_regenerate_token'] = 'Erro ao regenerar o token.';
$string['ws_error_registration'] = 'Erro ao registrar o token do serviço web. {$a}';
$string['ws_error_setup'] = 'Erro ao configurar o serviço web.';
$string['ws_role'] = 'Função do serviço';
$string['ws_role_desc'] = 'Função para o serviço web Datacurso';
$string['ws_role_name'] = 'Serviço Web Datacurso';
$string['ws_service'] = 'Serviço externo';
$string['ws_service_name'] = 'Serviço Web Datacurso';
$string['ws_step_enableauth'] = 'Habilitando plugin de autenticação de serviços web…';
$string['ws_step_enablerest'] = 'Habilitando protocolo REST…';
$string['ws_step_enablews'] = 'Habilitando serviços web do site…';
$string['ws_step_registration_sent'] = 'Solicitação de registro enviada.';
$string['ws_step_role_assign'] = 'Atribuindo função ao usuário de serviço…';
$string['ws_step_role_caps'] = 'Configurando capacidades de função necessárias…';
$string['ws_step_role_create'] = 'Criando função "{$a}"…';
$string['ws_step_role_exists'] = 'A função já existe, usando ID {$a}…';
$string['ws_step_service_enable'] = 'Criando/Habilitando serviço externo…';
$string['ws_step_service_functions'] = 'Adicionando funções centrais comuns ao serviço…';
$string['ws_step_service_user'] = 'Autorizando usuário para o serviço…';
$string['ws_step_setup'] = 'Iniciando configuração…';
$string['ws_step_token_create'] = 'Garantindo que o token exista…';
$string['ws_step_token_generated'] = 'Token gerado.';
$string['ws_step_token_regenerated'] = 'Token regerado.';
$string['ws_step_token_regenerating'] = 'Regerando token…';
$string['ws_step_token_retry'] = 'Tentando novamente a configuração…';
$string['ws_step_user_check'] = 'Verificando se o usuário "{$a}" existe…';
$string['ws_step_user_create'] = 'Criando usuário de serviço "{$a}"…';
$string['ws_token_label'] = 'Token Datacurso';
$string['ws_tokenexists'] = 'O token existe';
$string['ws_user'] = 'Usuário de serviço';
$string['ws_user_firstname'] = 'Datacurso';
$string['ws_user_lastname'] = 'Serviço';
$string['ws_userassigned'] = 'Função atribuída ao usuário';
$string['year'] = 'ano';
$string['years'] = 'Anos';
