define("aiprovider_datacurso/consumption",["exports","core/ajax","core/str","core/templates","core/notification","aiprovider_datacurso/repository"],(function(_exports,_ajax,_str,_templates,_notification,_repository){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Consumption history table management.
   *
   * @module     aiprovider_datacurso/consumption
   * @copyright  2025 Industria Elearning
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_notification=_interopRequireDefault(_notification);_exports.init=async()=>{const filterService=document.getElementById("filter-service"),filterAction=document.getElementById("filter-action"),filterFrom=document.getElementById("filter-date-from"),filterTo=document.getElementById("filter-date-to"),prevPageBtn=document.getElementById("prev-page"),nextPageBtn=document.getElementById("next-page"),pageInfo=document.getElementById("page-info"),tableRegionSelector='[data-region="aiprovider_datacurso/consumption-table"]';let currentSortField="",currentSortDir="asc";const limitSelect=document.getElementById("filter-limit"),pageInput=document.getElementById("filter-page");let currentPage=parseInt(sessionStorage.getItem("consumptionPage"))||1,currentLimit=parseInt(sessionStorage.getItem("consumptionLimit"))||10;const savePage=page=>sessionStorage.setItem("consumptionPage",page),updateSortIndicators=()=>{if(document.querySelectorAll("".concat(tableRegionSelector," .sort-icon")).forEach((icon=>{icon.className="fa fa-sort sort-icon"})),!currentSortField)return;const activeHeader=document.querySelector("".concat(tableRegionSelector,' [data-sort="').concat(currentSortField,'"] .sort-icon'));activeHeader&&(activeHeader.className="asc"===currentSortDir?"fa fa-sort-up sort-icon":"fa fa-sort-down sort-icon")},bindSortingHandlers=()=>{document.querySelectorAll("".concat(tableRegionSelector," .sortable")).forEach((header=>{header.addEventListener("click",(()=>{const field=header.dataset.sort;field&&(currentSortField===field?currentSortDir="asc"===currentSortDir?"desc":"asc":(currentSortField=field,currentSortDir="asc"),updateSortIndicators(),currentPage=1,savePage(currentPage),fetchData())}))})),updateSortIndicators()},renderTable=async function(listconsumptions){let{loading:loading=!1}=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const container=document.querySelector(tableRegionSelector);if(!container)return;const consumptions=Array.isArray(listconsumptions)?listconsumptions:[],context={initialized:!loading,consumptions:consumptions};try{const render=await _templates.default.renderForPromise("aiprovider_datacurso/consumption_row",context);await _templates.default.replaceNodeContents(container,render.html,render.js),bindSortingHandlers()}catch(error){_notification.default.exception(error);const fallback=await _templates.default.renderForPromise("aiprovider_datacurso/consumption_row",{initialized:!0,consumptions:[]});await _templates.default.replaceNodeContents(container,fallback.html,fallback.js),bindSortingHandlers()}},fetchData=async()=>{const serviceValue=filterService.value,actionValue=filterAction.value,fromValue=filterFrom.value,toValue=filterTo.value,args={page:currentPage,limit:currentLimit,service:"all"!==serviceValue?serviceValue:"",action:"all"!==actionValue?actionValue:"",fromdate:fromValue||"",todate:toValue||""};currentSortField&&(args.shor=currentSortField,args.shordir=currentSortDir),await renderTable([],{loading:!0});let pagination=0;try{const response=await(0,_repository.getConsumptionHistory)(args),consumptions=(null==response?void 0:response.consumption)||[];await renderTable(consumptions),pagination=null==response?void 0:response.pagination}catch(error){let msg=error.message;_notification.default.addNotification({message:msg,type:"error"})}if(pagination){const{current_page:current_page,total_pages:total_pages,total:total}=pagination,pageInfoText=await(0,_str.get_string)("pageinfo","aiprovider_datacurso",{current:current_page,totalpages:total_pages,total:total});pageInfo.textContent=pageInfoText,pageInput&&(pageInput.value=current_page),prevPageBtn.disabled=current_page<=1,nextPageBtn.disabled=current_page>=total_pages}else pageInfo.textContent="",prevPageBtn.disabled=!0,nextPageBtn.disabled=!0};[filterService,filterAction,filterFrom,filterTo].forEach((el=>{el.addEventListener("change",(()=>{currentPage=1,savePage(currentPage),fetchData()}))})),prevPageBtn.addEventListener("click",(()=>{currentPage>1&&(currentPage--,savePage(currentPage),fetchData())})),nextPageBtn.addEventListener("click",(()=>{currentPage++,savePage(currentPage),fetchData()})),limitSelect&&(limitSelect.value=currentLimit,limitSelect.addEventListener("change",(()=>{var limit;currentLimit=parseInt(limitSelect.value),limit=currentLimit,sessionStorage.setItem("consumptionLimit",limit),currentPage=1,savePage(currentPage),fetchData()}))),pageInput&&pageInput.addEventListener("change",(()=>{const newPage=parseInt(pageInput.value);newPage&&newPage>0&&(currentPage=newPage,savePage(currentPage),fetchData())})),Promise.all([(async()=>{try{var _response$services;const response=await _ajax.default.call([{methodname:"aiprovider_datacurso_get_services",args:{}}])[0];null!=response&&null!==(_response$services=response.services)&&void 0!==_response$services&&_response$services.length&&response.services.forEach((s=>{const opt=document.createElement("option");opt.value=s.id,opt.textContent=s.name,filterService.appendChild(opt)}))}catch(error){return _notification.default.exception(error),[]}})(),(async()=>{try{var _response$actions;const response=await _ajax.default.call([{methodname:"aiprovider_datacurso_get_actions",args:{}}])[0];null!=response&&null!==(_response$actions=response.actions)&&void 0!==_response$actions&&_response$actions.length&&response.actions.forEach((a=>{const opt=document.createElement("option");opt.value=a.id,opt.textContent=a.name,filterAction.appendChild(opt)}))}catch(error){return _notification.default.exception(error),[]}})()]).then((()=>fetchData())).catch(_notification.default.exception),bindSortingHandlers()}}));

//# sourceMappingURL=consumption.min.js.map