<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     aiprovider_datacurso
 * @category    string
 * @copyright   Josue <josue@datacurso.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['action:explain_text:endpoint'] = 'Endpunkt für Texterklärung';
$string['action:explain_text:model'] = 'Modell für die Erklärung';
$string['action:explain_text:model_help'] = 'Wählen Sie das Modell aus, das Erklärungen generieren wird.';
$string['action:explain_text:systeminstruction'] = 'Systemanweisung für die Erklärung';
$string['action:explain_text:systeminstruction_help'] = 'Stellen Sie Kontext bereit, um den Erklärungsprozess zu steuern.';
$string['action:generate_image:endpoint'] = 'Endpunkt für Bilderzeugung';
$string['action:generate_image:model'] = 'Modell für die Bilderzeugung';
$string['action:generate_image:model_help'] = 'Wählen Sie das KI-Modell zur Bilderzeugung.';
$string['action:generate_image:systeminstruction'] = 'System-Prompt für die Bilderzeugung';
$string['action:generate_image:systeminstruction_help'] = 'Zusätzliche Anweisungen, die die KI bei der Erzeugung des gewünschten Bildes leiten.';
$string['action:generate_text:endpoint'] = 'Endpunkt für Texterzeugung';
$string['action:generate_text:instruction'] = 'Systemanweisung';
$string['action:generate_text:instruction_desc'] = 'Diese Anweisung wird zusammen mit der Benutzer-Eingabe an das KI-Modell gesendet. Eine Bearbeitung dieser Anweisung wird nicht empfohlen, es sei denn, sie ist unbedingt erforderlich.';
$string['action:generate_text:model'] = 'Modell für die Texterzeugung';
$string['action:generate_text:model_help'] = 'Wählen Sie das KI-Modell aus, das zur Texterzeugung verwendet wird.';
$string['action:generate_text:systeminstruction'] = 'Systemanweisung';
$string['action:generate_text:systeminstruction_help'] = 'Anweisung oder Kontext, der der KI vor der Texterzeugung gegeben wird. Nützlich zur Steuerung von Ton, Struktur oder Zweck der Antwort.';
$string['action:summarise_text:endpoint'] = 'Endpunkt für Textzusammenfassung';
$string['action:summarise_text:instruction'] = 'Systemanweisung';
$string['action:summarise_text:instruction_desc'] = 'Diese Anweisung wird zusammen mit der Benutzer-Eingabe an das KI-Modell gesendet. Eine Bearbeitung dieser Anweisung wird nicht empfohlen, es sei denn, sie ist unbedingt erforderlich.';
$string['action:summarise_text:model'] = 'Modell für die Zusammenfassung';
$string['action:summarise_text:model_help'] = 'Wählen Sie das KI-Modell aus, das zur Textzusammenfassung verwendet wird.';
$string['action:summarise_text:systeminstruction'] = 'Systemanweisung für die Zusammenfassung';
$string['action:summarise_text:systeminstruction_help'] = 'Optionaler Kontext, um zu beeinflussen, wie die Zusammenfassung generiert wird.';
$string['all'] = 'Alle';
$string['alt_datacurso_icon'] = 'Datacurso-Symbol';
$string['apikey'] = 'API-Schlüssel';
$string['apikey_desc'] = 'Geben Sie den API-Schlüssel von Ihrem Datacurso-Dienst ein, um die KI zu verbinden.';
$string['apiurl'] = 'Basis-API-URL';
$string['apiurl_desc'] = 'Geben Sie die Basis-URL des Dienstes ein, um eine Verbindung zur Datacurso-API herzustellen.';
$string['assigned'] = 'Zugewiesen';
$string['chart_actions'] = 'Verteilung der Credits nach Dienstleistung';
$string['chart_tokens_by_day'] = 'Credits-Verbrauch pro Tag';
$string['chart_tokens_by_month'] = 'Anzahl der verbrauchten Credits pro Monat';
$string['configured'] = 'Konfiguriert';
$string['confirm_delete_message'] = 'Möchten Sie das Credit-Limit für "{$a}" wirklich löschen?';
$string['confirm_delete_title'] = 'Credit-Limit löschen';
$string['confirm_reset_usage_message'] = 'Dadurch wird der Verbrauchszähler für "{$a}" zurückgesetzt. Möchten Sie fortfahren?';
$string['connection'] = 'Verbindungseinstellungen';
$string['contextwstoken'] = 'Webservice-Token für Kurskontext';
$string['contextwstoken_desc'] = 'Token, das von der KI verwendet wird, um Kursinformationen (Kontext) abzurufen. Sicher gespeichert. Tokens erstellen/verwalten unter Website-Administration > Server > Webdienste > Tokens verwalten.';
$string['created'] = 'Erstellt';
$string['curlerror'] = 'Datacurso API cURL-Fehler: {$a}';
$string['custom_model_name'] = 'Benutzerdefinierter Modellname';
$string['custom_model_name_help'] = 'Optionaler Name zur Identifizierung dieser spezifischen KI-Modellkonfiguration.';
$string['datacurso:configurews'] = 'Datacurso-Webdienst konfigurieren';
$string['datacurso:manage'] = 'KI-Anbieter-Einstellungen verwalten';
$string['datacurso:managetokenlimits'] = 'Credit-Limits pro Benutzer verwalten';
$string['datacurso:use'] = 'Datacurso KI-Dienste nutzen';
$string['datacurso:viewreports'] = 'KI-Nutzungsberichte anzeigen';
$string['day'] = 'Tag';
$string['days'] = 'Tage';
$string['description'] = 'Beschreibung';
$string['descriptionpagelistplugins'] = 'Hier finden Sie die Liste der mit dem Datacurso-Anbieter kompatiblen Plugins';
$string['disabled'] = 'Deaktiviert';
$string['emptyprompt'] = 'Leerer Prompt';
$string['emptyresponse'] = 'Keine Antwort von der Datacurso API.';
$string['enabled'] = 'Aktiviert';
$string['enableglobalratelimit'] = 'Globales Limit aktivieren';
$string['enableglobalratelimit_desc'] = 'Wenn aktiviert, wird ein globales Anforderungslimit pro Stunde für alle Benutzer angewendet.';
$string['enableuserratelimit'] = 'Limit pro Benutzer aktivieren';
$string['enableuserratelimit_desc'] = 'Wenn aktiviert, hat jeder Benutzer ein stündliches Anforderungslimit.';
$string['endpointurl'] = 'Endpunkt-URL';
$string['endpointurl_help'] = 'Basis-API-Endpunkt-URL des Datacurso KI-Anbieters. Normalerweise so etwas wie https://api.datacurso.ai/v1/.';
$string['error_ratelimit_exceeded'] = 'Das zulässige Verbrauchslimit wurde überschritten. Bitte versuchen Sie es erneut um {$a}.';
$string['error_usertokenlimit_exceeded'] = 'Zulässige Credits überschritten ({$a}). Bitte kontaktieren Sie Ihren Administrator für weitere Informationen.';
$string['error_usertokenlimit_exists'] = 'Ein Credit-Limit für den ausgewählten Benutzer existiert bereits.';
$string['error_usertokenlimit_notfound'] = 'Credit-Limit des Benutzers nicht gefunden.';
$string['error_webservice_not_configured'] = 'Diese Aktion kann nicht fortgesetzt werden, da der Datacurso-Webdienst, der die KI mit Kontextdaten versorgt, nicht konfiguriert ist. Schließen Sie die automatische Einrichtung unter <a href="{$a->url}">Datacurso Webservice-Einrichtung</a> ab und versuchen Sie es erneut. Oder kontaktieren Sie Ihren Administrator für weitere Informationen.';
$string['errorgetbalancecredits'] = 'Konnte das Credit-Guthaben nicht von der externen API abrufen';
$string['errorinitinformation'] = 'Anfangsinformationen konnten nicht abgerufen werden.';
$string['exists'] = 'Existiert';
$string['forbidden'] = 'Sie dürfen diese Aktion mit der aktuellen Lizenz nicht ausführen. Überprüfen Sie bitte Ihre Lizenz und die verfügbaren Credits unter <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso Shop.';
$string['generate_activitie'] = 'Aktivität oder Ressource mit KI generieren';
$string['generate_ai_reinforcement_activity'] = 'KI-Verstärkungsaktivität erstellen';
$string['generate_analysis_comments'] = 'Bewertungsanalyse einer Aktivität/Ressource mit KI generieren';
$string['generate_analysis_course'] = 'Kursbewertungsanalyse mit KI generieren';
$string['generate_analysis_general'] = 'Allgemeine Bewertungsanalyse mit KI generieren';
$string['generate_analysis_story_student'] = 'Analyse-Story des Studenten mit KI generieren';
$string['generate_assign_answer'] = 'Bewertung der Aufgabe mit KI generieren';
$string['generate_certificate_answer'] = 'Zertifikatsnachricht mit KI generieren';
$string['generate_chat_message'] = 'Tutor-KI-Nachricht generieren';
$string['generate_creation_course'] = 'Vollständigen Kurs mit KI erstellen';
$string['generate_forum_chat'] = 'Forumsantwort mit KI generieren';
$string['generate_image'] = 'Bild mit KI generieren';
$string['generate_plan_course'] = 'Kurs-Erstellungsplan mit KI generieren';
$string['generate_summary'] = 'Zusammenfassung mit KI generieren';
$string['generate_text'] = 'Text mit KI generieren';
$string['globalratelimit'] = 'Globales Anforderungslimit';
$string['globalratelimit_desc'] = 'Maximale Anzahl der pro Stunde für das gesamte System zulässigen Anforderungen.';
$string['goto'] = 'Zum Bericht gehen';
$string['gotopage'] = 'Zur Seite gehen';
$string['hour'] = 'Stunde';
$string['hours'] = 'Stunden';
$string['httperror'] = 'Unerwarteter Fehler bei der Verarbeitung Ihrer Anfrage (HTTP {$a}). Bitte versuchen Sie es später erneut. Wenn das Problem weiterhin besteht, wenden Sie sich an Ihren Site-Administrator.';
$string['id'] = 'ID';
$string['installed'] = 'Installiert';
$string['instance_disabled'] = 'Die Datacurso-Anbieterinstanz ist deaktiviert';
$string['invalidjson'] = 'Ungültiges JSON';
$string['invalidlicensekey'] = 'Der Lizenzschlüssel ist abgelaufen oder ungültig. Bitte gehen Sie zu <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso Shop, um ihn zu erneuern oder einen neuen Lizenzschlüssel zu kaufen.';
$string['json_encode_failed'] = 'Json Encode Fehlgeschlagen';
$string['jsondecodeerror'] = 'Fehler beim Verarbeiten der Antwort von der Datacurso API: {$a}';
$string['last_sent'] = 'Zuletzt gesendet';
$string['license_not_allowed'] = 'Ihre Lizenz ist für diese Anforderung nicht zulässig. Bitte verwalten Sie Ihre Lizenzen und Credits unter <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso Shop.';
$string['licensekey'] = 'Lizenzschlüssel';
$string['licensekey_desc'] = 'Geben Sie den Lizenzschlüssel aus dem Kundenbereich des Datacurso Shops ein.';
$string['licensekey_help'] = 'Geben Sie Ihren Datacurso KI-Anbieter-Lizenzschlüssel ein.';
$string['licensekey_missing'] = 'Der Lizenzschlüssel ist nicht konfiguriert';
$string['link_consumptionhistory'] = 'Verlauf des Credit-Verbrauchs';
$string['link_generalreport'] = 'Allgemeiner Bericht';
$string['link_generalreport_datacurso'] = 'Allgemeiner Bericht Datacurso KI';
$string['link_listplugings'] = 'Datacurso Plugins-Liste';
$string['link_plugin'] = 'Link';
$string['link_provider_config'] = 'Anbieterkonfiguration';
$string['link_report_statistic'] = 'Bericht über allgemeine Statistiken';
$string['link_usertokenlimits'] = 'Datacurso Credit-Limits pro Benutzer';
$string['link_webservice_config'] = 'Datacurso Webservice-Einrichtung';
$string['live_log'] = 'Live-Protokoll';
$string['message_no_there_plugins'] = 'Keine Plugins verfügbar';
$string['minute'] = 'Minute';
$string['minutes'] = 'Minuten';
$string['missing'] = 'Fehlend';
$string['month'] = 'Monat';
$string['months'] = 'Monate';
$string['needs_repair'] = 'Muss repariert werden';
$string['nodata'] = 'Keine Informationen gefunden';
$string['not_assigned'] = 'Nicht zugewiesen';
$string['not_configured'] = 'Nicht konfiguriert';
$string['not_created'] = 'Nicht erstellt';
$string['notallowed'] = 'Sie sind nicht berechtigt, diese Aktion auszuführen. Bitte kontaktieren Sie Ihren Administrator für weitere Informationen.';
$string['notenoughtokens'] = 'Unzureichende KI-Credits. Bitte besuchen Sie <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso Shop, um Credits zuzuweisen oder zu kaufen. Oder kontaktieren Sie Ihren Administrator.';
$string['of'] = 'von';
$string['orgid'] = 'Organisations-ID';
$string['orgid_desc'] = 'Geben Sie die Kennung Ihrer Organisation im Datacurso-Dienst ein.';
$string['pageinfo'] = 'Seite {$a->current} von {$a->totalpages} ({$a->total} Einträge)';
$string['pending'] = 'Ausstehend';
$string['plugin'] = 'Plugin';
$string['plugindesc_assign_ai'] = 'Aufgaben mit KI-Unterstützung bewerten.';
$string['plugindesc_coursegen'] = 'Vollständige Kurse, Aktivitäten und Ressourcen mit KI erstellen.';
$string['plugindesc_datacurso_ratings'] = 'Ermöglicht Studenten, Aktivitäten und Ressourcen zu bewerten; Lehrer und Administratoren können später KI-basierte Kursanalysen generieren.';
$string['plugindesc_dttutor'] = 'Chatten Sie mit einem KI-Tutor innerhalb des Kurses.';
$string['plugindesc_forum_ai'] = 'Erweitert Foren mit KI-gestützter Analyse, um automatisch Zusammenfassungen zu generieren.';
$string['plugindesc_lifestory'] = 'KI-gestützter Bericht und Analyse des akademischen Fortschritts des Studenten.';
$string['plugindesc_smartrules'] = 'Automatisierte Aktivitäten basierend auf den vorherigen Bedingungen der Studenten erstellen.';
$string['plugindesc_socialcert'] = 'Automatisch personalisierte Zertifikate nach Abschluss des Kurses generieren.';
$string['pluginname'] = 'Datacurso KI-Anbieter';
$string['pluginname_assign_ai'] = 'Aufgabe KI';
$string['pluginname_coursegen'] = 'Kurs-Ersteller KI';
$string['pluginname_datacurso_ratings'] = 'Ranking-Aktivitäten KI';
$string['pluginname_dttutor'] = 'Tutor KI';
$string['pluginname_forum_ai'] = 'Forum KI';
$string['pluginname_lifestory'] = 'Studenten-Lebensgeschichte KI';
$string['pluginname_smartrules'] = 'SmartRules KI';
$string['pluginname_socialcert'] = 'Zertifikat teilen KI';
$string['privacy:metadata'] = 'Das Datacurso KI-Anbieter-Plugin speichert keine persönlichen Daten lokal. Alle Daten werden von externen Datacurso KI-Diensten verarbeitet.';
$string['privacy:metadata:aiprovider_datacurso'] = 'An Datacurso KI gesendete Anforderungs-Payloads.';
$string['privacy:metadata:aiprovider_datacurso:externalpurpose'] = 'Diese Daten werden an Datacurso KI gesendet, um die angeforderte Aktion auszuführen.';
$string['privacy:metadata:aiprovider_datacurso:numberimages'] = 'Gesamtzahl der vom KI-Dienst angeforderten Bilder.';
$string['privacy:metadata:aiprovider_datacurso:prompt'] = 'Der an den KI-Dienst gelieferte Prompt-Text.';
$string['privacy:metadata:aiprovider_datacurso:userid'] = 'Die Moodle-Benutzer-ID, die die KI-Anforderung stellt.';
$string['privacy:metadata:aiprovider_datacurso_rlimit'] = 'Lokal gespeicherter laufender Nutzungsstatus des Rate Limits pro Benutzer und Dienst.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:lastsync'] = 'Letzter Synchronisations-Zeitstempel mit der Remote-Historie.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:serviceid'] = 'Dienst-ID (z. B. local_coursegen).';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timecreated'] = 'Zeitpunkt, zu dem dieser Datensatz erstellt wurde.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:timemodified'] = 'Zeitpunkt, zu dem dieser Datensatz zuletzt geändert wurde.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:tokensused'] = 'Innerhalb des aktuellen Zeitfensters verbrauchte Credits.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:userid'] = 'Benutzer-ID, die mit dem verfolgten Verbrauchsfenster verbunden ist.';
$string['privacy:metadata:aiprovider_datacurso_rlimit:windowstart'] = 'Startzeitstempel des Fensters, der zur Berechnung der Verbrauchslimits verwendet wird.';
$string['privacy:metadata:aiprovider_datacurso_userlimit'] = 'Lokal gespeicherte Datacurso Token-Quoten pro Benutzer.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:countfrom'] = 'Zeitstempel, der markiert, wann die Quote mit der Verfolgung des Verbrauchs begonnen hat.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:lastsync'] = 'Letzte Synchronisation der Verbrauchsinformationen.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:timecreated'] = 'Zeitpunkt, zu dem der Quoten-Datensatz erstellt wurde.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:timemodified'] = 'Zeitpunkt, zu dem der Quoten-Datensatz zuletzt aktualisiert wurde.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:tokenlimit'] = 'Maximale Anzahl an Tokens, die dem Benutzer gewährt werden.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:tokensused'] = 'Seit Beginn der Verfolgung verbrauchte Tokens.';
$string['privacy:metadata:aiprovider_datacurso_userlimit:userid'] = 'Mit der Quote verbundene Benutzer-ID.';
$string['ratelimit_enable'] = 'Rate Limit aktivieren';
$string['ratelimit_enable_desc'] = 'Wenn aktiviert, wird das Credit-Limit pro Benutzer für dieses Plugin durchgesetzt.';
$string['ratelimit_limit'] = 'Credit-Limit pro Fenster';
$string['ratelimit_limit_desc'] = 'Maximale Anzahl von Credits, die ein Benutzer innerhalb des ausgewählten Zeitfensters verbrauchen darf. 0 für unbegrenzt.';
$string['ratelimit_limit_help'] = 'Die maximale Anzahl von Anforderungen, die pro Rate-Limit-Fenster zulässig ist.';
$string['ratelimit_local_assign_ai_allowedusers'] = 'Zulässige Aufgabenprüfer (KI)';
$string['ratelimit_local_assign_ai_allowedusers_desc'] = 'Wählen Sie die Benutzer aus, die Aufgaben mit KI bewerten dürfen, wenn dieser Dienst aktiviert ist.';
$string['ratelimit_local_assign_ai_allowedusers_desc_help'] = 'Diese Einstellung definiert eine Liste spezifischer Benutzer, die vom globalen Rate Limit für diesen KI-Dienst ausgenommen sind und nur ihnen erlauben, KI-basierte Bewertungen oder Feedback für Moodle-Aufgaben zu generieren.';
$string['ratelimit_local_assign_ai_allowedusers_enable'] = 'Nach zulässigen Benutzern limitieren';
$string['ratelimit_local_assign_ai_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer Aufgaben mit KI bewerten.';
$string['ratelimit_local_coursegen_activitycreators'] = 'Zulässige Aktivitätsersteller';
$string['ratelimit_local_coursegen_activitycreators_desc'] = 'Wählen Sie die Benutzer aus, die Aktivitäten oder Ressourcen mit KI generieren dürfen, wenn dieser Dienst aktiviert ist.';
$string['ratelimit_local_coursegen_allowedusers_enable'] = 'Nach zulässigen Benutzern limitieren';
$string['ratelimit_local_coursegen_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer diesen Dienst nutzen.';
$string['ratelimit_local_coursegen_coursecreators'] = 'Zulässige Kursersteller';
$string['ratelimit_local_coursegen_coursecreators_desc'] = 'Wählen Sie die Benutzer aus, die vollständige Kurse mit KI erstellen dürfen, wenn dieser Dienst aktiviert ist.';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable'] = 'Nach zulässigen Benutzern limitieren';
$string['ratelimit_local_datacurso_ratings_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer KI-basierte Analysen im Plugin "Ranking-Aktivitäten KI" generieren.';
$string['ratelimit_local_datacurso_ratings_courseanalysts'] = 'Zulässige Kursanalyse-Generatoren (KI)';
$string['ratelimit_local_datacurso_ratings_courseanalysts_desc'] = 'Wählen Sie die Benutzer aus, die KI-Analysen auf Kursebene generieren dürfen.';
$string['ratelimit_local_datacurso_ratings_generalanalysts'] = 'Zulässige allgemeine Analyse-Generatoren (KI)';
$string['ratelimit_local_datacurso_ratings_generalanalysts_desc'] = 'Wählen Sie die Benutzer aus, die allgemeine KI-Analysen über Aktivitäten oder den Kurs hinweg generieren dürfen.';
$string['ratelimit_report_lifestory_allowedusers'] = 'Zulässige KI-Feedback-Generatoren';
$string['ratelimit_report_lifestory_allowedusers_desc'] = 'Wählen Sie die Benutzer aus, die auf "KI-Feedback generieren" klicken dürfen, um Leistungsdaten des Studenten (Noten, Abschluss, Teilnahme) an den Datacurso KI-Anbieter zu senden und die KI-Erzählung mit Stärken, Schwächen und Empfehlungen anzuzeigen.';
$string['ratelimit_report_lifestory_allowedusers_enable'] = 'Nach zulässigen Benutzern limitieren';
$string['ratelimit_report_lifestory_allowedusers_enable_desc'] = 'Wenn aktiviert, dürfen nur die unten ausgewählten Benutzer KI-Feedback im Bericht "Studenten-Lebensgeschichte" generieren.';
$string['ratelimit_window'] = 'Zeitfenster';
$string['ratelimit_window_desc'] = 'Wählen Sie die Dauer und Einheit für das Rate Limit-Fenster.';
$string['ratelimit_window_unit'] = 'Fenster-Einheit';
$string['ratelimit_window_value'] = 'Fensterwert';
$string['ratelimits_heading'] = 'Rate Limits pro Plugin';
$string['ratelimits_heading_desc'] = 'Konfigurieren Sie die Rate Limits pro Benutzer und Plugin, das den Datacurso-Anbieter verwendet.';
$string['read_context_course'] = 'Kontext für die KI-Kurserstellung lesen';
$string['read_context_course_model'] = 'Akademisches Modell für die KI-Kurserstellung hochladen';
$string['registers'] = 'Register';
$string['registration_error'] = 'Letzter Fehler';
$string['registration_last'] = 'Registrierung';
$string['registration_lastsent'] = 'Zuletzt gesendet';
$string['registration_notverified'] = 'Registrierung nicht verifiziert';
$string['registration_status'] = 'Letzter Status';
$string['registration_verified'] = 'Registrierung verifiziert';
$string['registrationapibearer'] = 'Registrierungs-Bearer-Token';
$string['registrationapibearer_desc'] = 'Bearer-Token zur Authentifizierung der Registrierungsanforderung.';
$string['registrationapiurl'] = 'Registrierungs-Endpunkt-URL';
$string['registrationapiurl_desc'] = 'Endpunkt zum Empfangen der Site-Registrierungs-Payload. Standard: http://localhost:8001/register-site';
$string['registrationsettings'] = 'Registrierungs-API';
$string['remainingtokens'] = 'Verbleibendes Guthaben';
$string['responseinvalidai'] = 'Ungültige Antwort vom KI-Dienst.';
$string['responseinvalidaimage'] = 'Ungültige Antwort vom KI-Dienst (Kein Bild).';
$string['responseinvalidaimagecreate'] = 'Konnte Bilddatei nicht erstellen.';
$string['rest_enabled'] = 'REST-Protokoll aktiviert';
$string['second'] = 'Sekunde';
$string['seconds'] = 'Sekunden';
$string['service'] = 'Dienst';
$string['showrows'] = 'Zeilen anzeigen';
$string['tokens'] = 'Credits';
$string['tokens_available'] = 'Verfügbare Credits';
$string['tokensconsumed'] = 'Verbrauchte Credits';
$string['tokensconsumedday'] = 'Verbrauchte Credits pro Tag';
$string['tokensconsumedmonth'] = 'Verbrauchte Credits pro Monat';
$string['tokensnotsufficient'] = 'Unzureichende KI-Credits. Aktuelles Guthaben: {$a->current}. Mindestens erforderlich: {$a->required}. Bitte besuchen Sie <a href="https://shop.datacurso.com/index.php?m=tokens_manager" target="_blank">Credits verwalten</a> im Datacurso Shop, um Credits zuzuweisen oder zu kaufen. Oder kontaktieren Sie Ihren Administrator.';
$string['tokensused'] = 'Verwendete Credits';
$string['tokenthreshold'] = 'Credit-Schwellenwert';
$string['tokenthreshold_desc'] = 'Anzahl der Credits, ab der eine Benachrichtigung zum Kauf weiterer Credits angezeigt wird.';
$string['total_consumed'] = 'Verbrauchte Credits';
$string['upgrade_sync_error'] = 'Datacurso Upgrade-Fehler: {$a}';
$string['userid'] = 'Benutzer';
$string['userratelimit'] = 'Anforderungslimit pro Benutzer';
$string['userratelimit_desc'] = 'Maximale Anzahl von Anforderungen, die pro Stunde für jeden einzelnen Benutzer zulässig sind.';
$string['usertokenlimit_add'] = 'Credit-Limit hinzufügen';
$string['usertokenlimit_add_title'] = 'Benutzer-Credit-Limit hinzufügen';
$string['usertokenlimit_delete_failed'] = 'Benutzer-Credit-Limit konnte nicht gelöscht werden.';
$string['usertokenlimit_deleted'] = 'Benutzer-Credit-Limit gelöscht.';
$string['usertokenlimit_edit_title'] = 'Limit bearbeiten: {$a}';
$string['usertokenlimit_limit'] = 'Credit-Limit';
$string['usertokenlimit_limit_help'] = 'Geben Sie die maximale Anzahl von Credits ein, die der Benutzer verbrauchen darf. Der Wert muss größer als Null sein.';
$string['usertokenlimit_limit_invalid'] = 'Das Limit muss eine positive Zahl größer als Null sein.';
$string['usertokenlimit_reset'] = 'Verbrauchszähler zurücksetzen';
$string['usertokenlimit_reset_done'] = 'Verbrauchszähler wurde zurückgesetzt.';
$string['usertokenlimit_reset_failed'] = 'Verbrauchszähler konnte nicht zurückgesetzt werden.';
$string['usertokenlimit_reset_help'] = 'Wenn aktiviert, wird der aktuelle Verbrauchszähler für diesen Benutzer unmittelbar nach dem Speichern zurückgesetzt.';
$string['usertokenlimit_reset_usage'] = 'Verbrauch zurücksetzen';
$string['usertokenlimit_saved'] = 'Benutzer-Credit-Limit gespeichert';
$string['usertokenlimit_used'] = 'Verwendete Credits';
$string['usertokenlimit_user'] = 'Benutzer';
$string['usertokenlimit_user_help'] = 'Wählen Sie den Benutzer aus, für den das Credit-Limit gelten soll.';
$string['usertokenlimit_user_readonly'] = 'Benutzer';
$string['usertokenlimit_user_readonly_help'] = 'Dieser Benutzer ist für bestehende Datensätze festgelegt und kann nicht geändert werden.';
$string['verified'] = 'Verifiziert';
$string['warningconfig_instance'] = 'Warnung: Es sollte nur eine Instanz mit diesem Anbieter für eine ordnungsgemäße Verwendung erstellt werden.';
$string['webserviceconfig_current'] = 'Aktuelle Konfiguration';
$string['webserviceconfig_desc'] = 'Konfiguriert automatisch einen dedizierten Webdienst für den Datacurso KI-Dienst, der es ihm ermöglicht, Plattforminformationen wie grundlegende Benutzerdaten, Kurse und Aktivitäten sicher für eine bessere KI-Kontextualisierung zu extrahieren. Dieses Setup erstellt einen Dienstbenutzer, weist die notwendige Rolle zu, konfiguriert den externen Dienst, generiert ein sicheres Token und aktiviert das REST-Protokoll mit einem Klick. Hinweis: Der Token-Wert wird aus Sicherheitsgründen nicht angezeigt.';
$string['webserviceconfig_heading'] = 'Automatische Webservice-Einrichtung';
$string['webserviceconfig_site'] = 'Site-Informationen';
$string['webserviceconfig_status'] = 'Status';
$string['webserviceconfig_title'] = 'Datacurso Web Service Konfiguration';
$string['week'] = 'Woche';
$string['weeks'] = 'Wochen';
$string['workplace'] = 'Ist dies Moodle Workplace?';
$string['workplace_desc'] = 'Definiert, ob der X-Workplace-Header mit dem Wert true (Workplace) oder false (Standard Moodle) gesendet werden soll.';
$string['ws_activity'] = 'Aktivitätsprotokoll';
$string['ws_btn_regenerate'] = 'Token neu generieren';
$string['ws_btn_retry'] = 'Konfiguration erneut versuchen';
$string['ws_btn_setup'] = 'Webdienst konfigurieren';
$string['ws_enabled'] = 'Webdienste aktiviert';
$string['ws_error_missing_setup'] = 'Dienst oder Benutzer nicht gefunden. Führen Sie zuerst das Setup aus.';
$string['ws_error_missing_token'] = 'Token nicht gefunden. Generieren Sie es zuerst.';
$string['ws_error_regenerate_token'] = 'Fehler beim Neugenerieren des Tokens.';
$string['ws_error_registration'] = 'Fehler beim Registrieren des Webservice-Tokens. {$a}';
$string['ws_error_setup'] = 'Fehler beim Konfigurieren des Webservice.';
$string['ws_role'] = 'Dienstrolle';
$string['ws_role_desc'] = 'Rolle für den Datacurso-Webdienst';
$string['ws_role_name'] = 'Datacurso Web Service';
$string['ws_service'] = 'Externer Dienst';
$string['ws_service_name'] = 'Datacurso Web Service';
$string['ws_step_enableauth'] = 'Webservices-Authentifizierungs-Plugin wird aktiviert…';
$string['ws_step_enablerest'] = 'REST-Protokoll wird aktiviert…';
$string['ws_step_enablews'] = 'Site-Webservices werden aktiviert…';
$string['ws_step_registration_sent'] = 'Registrierungsanforderung gesendet.';
$string['ws_step_role_assign'] = 'Rolle wird dem Dienstbenutzer zugewiesen…';
$string['ws_step_role_caps'] = 'Erforderliche Rollenfunktionen werden festgelegt…';
$string['ws_step_role_create'] = 'Rolle "{$a}" wird erstellt…';
$string['ws_step_role_exists'] = 'Rolle existiert bereits, ID {$a} wird verwendet…';
$string['ws_step_service_enable'] = 'Externer Dienst wird erstellt/aktiviert…';
$string['ws_step_service_functions'] = 'Gemeinsame Kernfunktionen werden zum Dienst hinzugefügt…';
$string['ws_step_service_user'] = 'Benutzer wird für den Dienst autorisiert…';
$string['ws_step_setup'] = 'Setup wird gestartet…';
$string['ws_step_token_create'] = 'Sicherstellen, dass Token existiert…';
$string['ws_step_token_generated'] = 'Token generiert.';
$string['ws_step_token_regenerated'] = 'Token neu generiert.';
$string['ws_step_token_regenerating'] = 'Token wird neu generiert…';
$string['ws_step_token_retry'] = 'Setup wird erneut versucht…';
$string['ws_step_user_check'] = 'Überprüfen, ob Benutzer "{$a}" existiert…';
$string['ws_step_user_create'] = 'Dienstbenutzer "{$a}" wird erstellt…';
$string['ws_token_label'] = 'Datacurso Token';
$string['ws_tokenexists'] = 'Token existiert';
$string['ws_user'] = 'Dienstbenutzer';
$string['ws_user_firstname'] = 'Datacurso';
$string['ws_user_lastname'] = 'Dienst';
$string['ws_userassigned'] = 'Rolle dem Benutzer zugewiesen';
$string['year'] = 'Jahr';
$string['years'] = 'Jahre';
