<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     local_assign_ai
 * @category    string
 * @copyright   2025 Datacurso
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Actions';
$string['aistatus'] = 'AI Status';
$string['aitaskdone'] = 'AI processing complete. Total submissions processed: {$a}';
$string['aitaskstart'] = 'Processing AI submissions for course: {$a}';
$string['aitaskuserqueued'] = 'Submission queued for user ID {$a->id} ({$a->name})';
$string['altlogo'] = 'Datacurso logo';
$string['assign_ai:changestatus'] = 'Change AI approval status';
$string['assign_ai:review'] = 'Review AI suggestions for assignments';
$string['assign_ai:viewdetails'] = 'View AI feedback details';
$string['default_rubric_name'] = 'Rubric';
$string['email'] = 'Email';
$string['error_airequest'] = 'Error communicating with the AI service: {$a}';
$string['errorparsingrubric'] = 'Error parsing rubric_response: {$a}';
$string['feedbackcomments'] = 'Comments';
$string['fullname'] = 'Full name';
$string['grade'] = 'Grade';
$string['gradesuccess'] = 'Grade successfully injected';
$string['lastmodified'] = 'Last modified';
$string['manytasksreviewed'] = '{$a} tasks reviewed';
$string['missingtaskparams'] = 'Missing task parameters. Unable to start AI batch processing.';
$string['modaltitle'] = 'AI Feedback';
$string['norecords'] = 'No records found';
$string['nostatus'] = 'No feedback';
$string['nosubmissions'] = 'No submissions found to process.';
$string['notasksfound'] = 'No tasks to review';
$string['onetaskreviewed'] = '1 task reviewed';
$string['pluginname'] = 'Assignment AI';
$string['privacy:metadata:local_assign_ai_pending'] = 'Stores AI-generated feedback pending approval.';
$string['privacy:metadata:local_assign_ai_pending:approval_token'] = 'Unique token used to track approvals.';
$string['privacy:metadata:local_assign_ai_pending:assignmentid'] = 'The assignment this AI feedback belongs to.';
$string['privacy:metadata:local_assign_ai_pending:courseid'] = 'The course associated with this feedback.';
$string['privacy:metadata:local_assign_ai_pending:grade'] = 'The AI-generated proposed grade.';
$string['privacy:metadata:local_assign_ai_pending:message'] = 'The feedback message generated by AI.';
$string['privacy:metadata:local_assign_ai_pending:rubric_response'] = 'The AI-generated rubric feedback.';
$string['privacy:metadata:local_assign_ai_pending:status'] = 'The approval status of the feedback.';
$string['privacy:metadata:local_assign_ai_pending:title'] = 'The title of the generated feedback.';
$string['privacy:metadata:local_assign_ai_pending:userid'] = 'The user for whom the AI feedback was generated.';
$string['processed'] = '{$a} submission(s) processed successfully.';
$string['processing'] = 'Processing';
$string['processingerror'] = 'An error occurred while processing the AI review.';
$string['qualify'] = 'Grade';
$string['queued'] = 'All submissions have been queued for AI review. They will be processed shortly.';
$string['reloadpage'] = 'Please reload the page to see the updated results.';
$string['review'] = 'Review';
$string['reviewall'] = 'Review all';
$string['reviewwithai'] = 'Review with AI';
$string['rubricfailed'] = 'Failed to inject rubric after 20 attempts';
$string['rubricmustarray'] = 'rubric_response must be an array';
$string['rubricsuccess'] = 'Rubric successfully injected';
$string['save'] = 'Save';
$string['saveapprove'] = 'Save and Approve';
$string['status'] = 'Status';
$string['statusapprove'] = 'Approved';
$string['statuspending'] = 'Pending';
$string['statusrejected'] = 'Rejected';
$string['submission_draft'] = 'Draft';
$string['submission_new'] = 'New';
$string['submission_none'] = 'No submission';
$string['submission_submitted'] = 'Submitted';
$string['submittedfiles'] = 'Submitted files';
$string['unexpectederror'] = 'An unexpected error occurred: {$a}';
$string['viewdetails'] = 'View details';
