define("local_assign_ai/review_with_ai",["exports","core/ajax","core/notification","core/str","local_assign_ai/review_progress"],(function(_exports,_ajax,_notification,_str,_review_progress){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Handles the "Review with AI" actions on the assignment review page.
   *
   * @module      local_assign_ai/review_with_ai
   * @copyright   2025 Datacurso
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification);_exports.init=async()=>{const[strProcessing,strQueuedShort,strProcessed,strNoSubmissions,strReload,strError,strConfirmReviewAll,strConfirmTitle,strContinue]=await Promise.all([(0,_str.get_string)("processing","local_assign_ai"),(0,_str.get_string)("aistatus_queued_short","local_assign_ai"),(0,_str.get_string)("processed","local_assign_ai"),(0,_str.get_string)("nosubmissions","local_assign_ai"),(0,_str.get_string)("reloadpage","local_assign_ai"),(0,_str.get_string)("processingerror","local_assign_ai"),(0,_str.get_string)("confirm_review_all","local_assign_ai"),(0,_str.get_string)("confirm","moodle"),(0,_str.get_string)("continue","moodle")]);document.querySelectorAll(".js-review-ai").forEach((button=>{button.addEventListener("click",(e=>{e.preventDefault();const cmid=parseInt(button.dataset.cmid),userid=parseInt(button.dataset.userid||0),pendingid=button.dataset.pendingid?parseInt(button.dataset.pendingid,10):0,all="1"===button.dataset.all,processRequest=()=>{const originalHTML=button.innerHTML;button.innerHTML='\n                    <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>\n                    '.concat(strProcessing,"\n                "),button.disabled=!0,_ajax.default.call([{methodname:"local_assign_ai_process_submission",args:{cmid:cmid,userid:userid,all:all,pendingid:pendingid}}])[0].done((result=>{if("queued"!==result.status){if("ok"===result.status)return _notification.default.addNotification({message:"".concat(strProcessed.replace("{$a}",result.processed)," ").concat(strReload),type:"success"}),void window.location.reload();_notification.default.addNotification({message:strNoSubmissions,type:"warning"}),button.innerHTML=originalHTML,button.disabled=!1}else if(_notification.default.addNotification({message:strQueuedShort,type:"info"}),button.innerHTML=originalHTML,all){button.disabled=!0,document.body.classList.add("assign-ai-progress-running");document.querySelectorAll('tr[data-cmid="'+cmid+'"]').forEach((row=>{row.setAttribute("data-status","queued"),row.classList.add("js-row-queued");const badge=row.querySelector(".js-state-badge");badge&&(badge.className="badge bg-warning text-dark js-state-badge",badge.textContent=strQueuedShort);const hint=row.querySelector(".js-state-hint");hint&&(0,_str.get_string)("aistatus_queued_help","local_assign_ai").then((txt=>{hint.textContent=txt})).catch((()=>{})),row.querySelectorAll("button").forEach((b=>b.setAttribute("disabled","disabled")));const btnDetails=row.querySelector(".js-btn-details");btnDetails&&btnDetails.classList.add("d-none")})),(0,_review_progress.ensurePolling)()}else button.disabled=!1})).fail((err=>{_notification.default.addNotification({message:strError,type:"error"}),_notification.default.exception(err),button.innerHTML=originalHTML,button.disabled=!1}))};all?_notification.default.saveCancelPromise(strConfirmTitle,strConfirmReviewAll,strContinue,{triggerElement:button}).then(processRequest).catch((()=>{})):processRequest()}))}))}}));

//# sourceMappingURL=review_with_ai.min.js.map