define("local_assign_ai/review_progress",["exports","core/ajax","core/notification","core/str"],(function(_exports,_ajax,_notification,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Polls backend for progress of AI reviews and updates UI accordingly.
   *
   * @module     local_assign_ai/review_progress
   * @copyright  2025 Wilber Narvaez <https://datacurso.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.ensurePolling=function(){startPolling()},_exports.init=function(cmid){reflectHeaderButtonsState();const initialDelay=document.body.classList.contains("assign-ai-progress-running")?0:8e3;document.addEventListener("click",(e=>{const target=e.target.closest("a.js-btn-grade");target&&(target.classList.contains("disabled")||"true"===target.getAttribute("aria-disabled"))&&(e.preventDefault(),e.stopPropagation())}),!0),hasActiveRows()&&setTimeout((()=>{startPolling()}),initialDelay)},_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification);let intervalid=0;const startTimes=new Map,expectedDurations=new Map,startOffsets=new Map,curveFactors=new Map,lastShown=new Map;function setLinkDisabled(link,disabled){link&&(disabled?(link.classList.add("disabled"),link.setAttribute("aria-disabled","true"),link.setAttribute("tabindex","-1")):(link.classList.remove("disabled"),link.removeAttribute("aria-disabled"),link.removeAttribute("tabindex")))}function hasActiveRows(){return!!document.querySelector('tr[data-status="processing"], tr[data-status="queued"], tr.js-row-inprogress, tr.js-row-queued')}function reflectHeaderButtonsState(){const anyActive=hasActiveRows(),anyPending=!!document.querySelector('tr[data-status="pending"], tr.js-row-pending'),btnReviewAll=document.querySelector(".js-review-all"),btnApproveAll=document.querySelector(".js-approve-all");if(btnReviewAll&&(btnReviewAll.disabled=anyActive||btnReviewAll.disabled),btnApproveAll){anyPending&&!anyActive?btnApproveAll.removeAttribute("disabled"):btnApproveAll.setAttribute("disabled","disabled")}}function applyProgress(entries){const now=Date.now();entries.forEach((entry=>{const row=document.querySelector('tr[data-pendingid="'+entry.id+'"]');if(!row)return;if("processing"===entry.status&&!startTimes.has(entry.id)){startTimes.set(entry.id,now);const expected=2e4+Math.floor(35001*Math.random());expectedDurations.set(entry.id,expected),startOffsets.set(entry.id,1+Math.floor(8*Math.random())),curveFactors.set(entry.id,.6+.8*Math.random()),lastShown.set(entry.id,0)}let adjusted=0;if("processing"===entry.status&&startTimes.has(entry.id)){const startedAt=startTimes.get(entry.id),expected=expectedDurations.get(entry.id)||35e3,elapsed=Math.max(0,now-startedAt),t=Math.min(.999,Math.max(0,elapsed/expected)),start=startOffsets.get(entry.id)||1,curve=curveFactors.get(entry.id)||1,eased=1-Math.pow(1-t,curve);let estimated=start+Math.floor(eased*(99-start));const noise=Math.floor(5*Math.random()-2);estimated=Math.max(start,Math.min(99,estimated+noise));const last=lastShown.get(entry.id)||0;adjusted=Math.max(last,estimated),lastShown.set(entry.id,adjusted)}"processing"!==entry.status&&(startTimes.delete(entry.id),expectedDurations.delete(entry.id),startOffsets.delete(entry.id),curveFactors.delete(entry.id),lastShown.delete(entry.id)),row.setAttribute("data-status",entry.status),"queued"===entry.status?row.classList.add("js-row-queued"):row.classList.remove("js-row-queued"),row.setAttribute("data-progress",String(adjusted)),function(row,progress,status){const badge=row.querySelector(".js-state-badge"),hint=row.querySelector(".js-state-hint");let indicator=row.querySelector(".js-progress-indicator");const btnReview=row.querySelector(".js-btn-review"),btnDetails=row.querySelector(".js-btn-details"),btnGrade=row.querySelector(".js-btn-grade");if("processing"===status&&progress>0&&progress<100){var _row$querySelector;row.classList.add("js-row-inprogress"),indicator||(indicator=document.createElement("div"),indicator.className="small text-warning js-progress-indicator",indicator.innerHTML='<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>',null===(_row$querySelector=row.querySelector("td:nth-child(7)"))||void 0===_row$querySelector||_row$querySelector.appendChild(indicator)),(0,_str.get_string)("processing","local_assign_ai").then((txt=>{indicator.innerHTML='<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>'+txt+" ("+progress+"%)"})).catch((()=>{})),row.querySelectorAll("button").forEach((b=>b.setAttribute("disabled","disabled"))),setLinkDisabled(btnGrade,!0)}else row.classList.remove("js-row-inprogress"),indicator&&indicator.remove(),"initial"===status?(row.querySelectorAll(".js-review-ai").forEach((b=>b.removeAttribute("disabled"))),setLinkDisabled(btnGrade,!1)):"pending"===status?(row.querySelectorAll(".view-details").forEach((b=>b.removeAttribute("disabled"))),setLinkDisabled(btnGrade,!1)):"queued"===status?(row.querySelectorAll("button").forEach((b=>b.setAttribute("disabled","disabled"))),setLinkDisabled(btnGrade,!0)):(row.querySelectorAll("button").forEach((b=>b.removeAttribute("disabled"))),setLinkDisabled(btnGrade,!1));badge&&hint&&("initial"===status?(badge.className="badge bg-secondary js-state-badge",(0,_str.get_string)("aistatus_initial_short","local_assign_ai").then((t=>{badge.textContent=t})).catch((()=>{})),(0,_str.get_string)("aistatus_initial_help","local_assign_ai").then((t=>{hint.textContent=t})).catch((()=>{}))):"queued"===status?(badge.className="badge bg-warning js-state-badge",(0,_str.get_string)("aistatus_queued_short","local_assign_ai").then((t=>{badge.textContent=t})).catch((()=>{})),(0,_str.get_string)("aistatus_queued_help","local_assign_ai").then((t=>{hint.textContent=t})).catch((()=>{}))):"processing"===status?(badge.className="badge bg-warning js-state-badge",(0,_str.get_string)("processing","local_assign_ai").then((t=>{badge.textContent=t})).catch((()=>{})),(0,_str.get_string)("aistatus_processing_help","local_assign_ai").then((t=>{hint.textContent=t})).catch((()=>{}))):"pending"===status&&(badge.className="badge bg-info js-state-badge",(0,_str.get_string)("aistatus_pending_short","local_assign_ai").then((t=>{badge.textContent=t})).catch((()=>{})),(0,_str.get_string)("aistatus_pending_help","local_assign_ai").then((t=>{hint.textContent=t})).catch((()=>{})))),btnReview&&btnDetails&&("pending"===status||progress>=100?(btnReview.classList.add("d-none"),btnDetails.classList.remove("d-none")):"initial"!==status&&"queued"!==status&&"processing"!==status||(btnDetails.classList.add("d-none"),btnReview.classList.remove("d-none")))}(row,adjusted,entry.status)})),reflectHeaderButtonsState()}function poll(){const ids=function(){const rows=document.querySelectorAll("tr[data-pendingid]"),ids=[];return rows.forEach((row=>{const pid=parseInt(row.getAttribute("data-pendingid"),10);if(!pid)return;const status=(row.getAttribute("data-status")||"").toLowerCase(),isProcessing="processing"===status,isQueued="queued"===status,fallbackProcessing=!status&&row.classList.contains("js-row-inprogress"),fallbackQueued=!status&&row.classList.contains("js-row-queued");(isProcessing||isQueued||fallbackProcessing||fallbackQueued)&&ids.push(pid)})),ids}();return 0===ids.length?(intervalid&&(clearInterval(intervalid),intervalid=0),reflectHeaderButtonsState(),!1):(_ajax.default.call([{methodname:"local_assign_ai_get_progress",args:{pendingids:ids}}])[0].done((result=>{applyProgress(result)})).fail((err=>{_notification.default.exception(err)})),!0)}function startPolling(){intervalid||poll()&&(intervalid=setInterval(poll,8e3))}}));

//# sourceMappingURL=review_progress.min.js.map