<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     local_assign_ai
 * @category    string
 * @copyright   2025 Datacurso
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Actions';
$string['aiconfigheader'] = 'Datacurso Assignment AI';
$string['aistatus'] = 'AI Status';
$string['aistatus_initial_help'] = 'Send the submission to AI to generate a proposal.';
$string['aistatus_initial_short'] = 'Pending AI review';
$string['aistatus_pending_help'] = 'AI proposal ready. Open the details to edit or approve it.';
$string['aistatus_pending_short'] = 'Pending approval';
$string['aistatus_processing_help'] = 'AI is currently processing this submission. This may take a while.';
$string['aistatus_queued_help'] = 'This submission has been queued and will start processing soon.';
$string['aistatus_queued_short'] = 'queued';
$string['aitaskdone'] = 'AI processing complete. Total submissions processed: {$a}';
$string['aitaskstart'] = 'Processing AI submissions for course: {$a}';
$string['aitaskuserqueued'] = 'Submission queued for user ID {$a->id} ({$a->name})';
$string['altlogo'] = 'Datacurso logo';
$string['approveall'] = 'Approve all';
$string['assign_ai:changestatus'] = 'Change AI approval status';
$string['assign_ai:review'] = 'Review AI suggestions for assignments';
$string['assign_ai:viewdetails'] = 'View AI feedback details';
$string['autograde'] = 'Auto-approve AI feedback';
$string['autograde_help'] = 'When enabled, AI-generated grades and comments are applied automatically to student submissions without requiring manual approval.';
$string['autogradegrader'] = 'Recorded grader for auto approvals';
$string['autogradegrader_help'] = 'Select the user who will be recorded as the grader whenever AI feedback is auto approved. Only users who can grade assignments in this course are listed.';
$string['backtocourse'] = 'Back to course';
$string['backtoreview'] = 'Back to AI review';
$string['confirm_approve_all'] = 'Approve every AI proposal currently pending and apply its grades/comments to students. Do you want to continue?';
$string['confirm_review_all'] = 'Send every submission marked "Pending AI review" to the AI and start processing. This may take a few minutes. Do you want to continue?';
$string['default_rubric_name'] = 'Rubric';
$string['editgrade'] = 'Edit grade';
$string['email'] = 'Email';
$string['error_airequest'] = 'Error communicating with the AI service: {$a}';
$string['error_ws_not_configured'] = 'AI review actions are unavailable because the Datacurso web service is not configured. Complete the setup at <a href="{$a->url}">Datacurso webservice setup</a> or contact your administrator.';
$string['errorparsingrubric'] = 'Error parsing rubric_response: {$a}';
$string['feedbackcomments'] = 'Comments';
$string['feedbackcommentsfull'] = 'Feedback comments';
$string['fullname'] = 'Full name';
$string['grade'] = 'Grade';
$string['gradesuccess'] = 'Grade successfully injected';
$string['lastmodified'] = 'Last modified';
$string['manytasksreviewed'] = '{$a} tasks reviewed';
$string['missingtaskparams'] = 'Missing task parameters. Unable to start AI batch processing.';
$string['modaltitle'] = 'AI Feedback';
$string['norecords'] = 'No records found';
$string['nostatus'] = 'No feedback';
$string['nosubmissions'] = 'No submissions found to process.';
$string['notasksfound'] = 'No tasks to review';
$string['onetaskreviewed'] = '1 task reviewed';
$string['pluginname'] = 'Assignment AI';
$string['privacy:metadata:local_assign_ai_pending'] = 'Stores AI-generated feedback pending approval.';
$string['privacy:metadata:local_assign_ai_pending:approval_token'] = 'Unique token used to track approvals.';
$string['privacy:metadata:local_assign_ai_pending:assignmentid'] = 'The assignment this AI feedback belongs to.';
$string['privacy:metadata:local_assign_ai_pending:courseid'] = 'The course associated with this feedback.';
$string['privacy:metadata:local_assign_ai_pending:grade'] = 'The AI-generated proposed grade.';
$string['privacy:metadata:local_assign_ai_pending:message'] = 'The feedback message generated by AI.';
$string['privacy:metadata:local_assign_ai_pending:rubric_response'] = 'The AI-generated rubric feedback.';
$string['privacy:metadata:local_assign_ai_pending:status'] = 'The approval status of the feedback.';
$string['privacy:metadata:local_assign_ai_pending:title'] = 'The title of the generated feedback.';
$string['privacy:metadata:local_assign_ai_pending:userid'] = 'The user for whom the AI feedback was generated.';
$string['processed'] = '{$a} submission(s) processed successfully.';
$string['processing'] = 'Processing';
$string['processingerror'] = 'An error occurred while processing the AI review.';
$string['qualify'] = 'Grade';
$string['queued'] = 'Queued';
$string['reloadpage'] = 'Please reload the page to see the updated results.';
$string['review'] = 'Review';
$string['reviewall'] = 'Review all';
$string['reviewhistory'] = 'AI review history';
$string['reviewwithai'] = 'Review with AI';
$string['rubricfailed'] = 'Failed to inject rubric after 20 attempts';
$string['rubricmustarray'] = 'rubric_response must be an array';
$string['rubricsuccess'] = 'Rubric successfully injected';
$string['save'] = 'Save';
$string['saveapprove'] = 'Save and Approve';
$string['status'] = 'Status';
$string['statusapprove'] = 'Approved';
$string['statuserror'] = 'Error';
$string['statuspending'] = 'Pending';
$string['statusrejected'] = 'Rejected';
$string['submission_draft'] = 'Draft';
$string['submission_new'] = 'New';
$string['submission_none'] = 'No submission';
$string['submission_submitted'] = 'Submitted';
$string['submittedfiles'] = 'Submitted files';
$string['unexpectederror'] = 'An unexpected error occurred: {$a}';
$string['viewaifeedback'] = 'View AI feedback';
$string['viewdetails'] = 'View details';
