define("local_coursegen/add_course_ai_modal",["exports","core/modal","core/templates","core/notification","core/str","local_coursegen/course_streaming","local_coursegen/repository/chatbot"],(function(_exports,_modal,_templates,_notification,_str,_course_streaming,_chatbot){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Course AI Modal Module using Moodle's modal factory
   *
   * @module     local_coursegen/add_course_ai_modal
   * @copyright  2025 Wilber Narvaez <https://datacurso.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal=_interopRequireDefault(_modal),_templates=_interopRequireDefault(_templates),_notification=_interopRequireDefault(_notification);let currentModal=null,userHasScrolled=!1,scrollTimeout=null;const setupScrollDetection=scrollContainer=>{if(!scrollContainer)return;scrollContainer.addEventListener("scroll",(()=>{var element;scrollTimeout&&clearTimeout(scrollTimeout),userHasScrolled=!0,(element=scrollContainer).scrollTop+element.clientHeight>=element.scrollHeight-50&&(scrollTimeout=setTimeout((()=>{userHasScrolled=!1}),1e3))}),{passive:!0})};_exports.init=async function(){let params=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};try{currentModal&&(currentModal.destroy(),currentModal=null);const[title,bodyHTML,footerHTML]=await Promise.all([(0,_str.get_string)("addcourseai_modaltitle","local_coursegen"),_templates.default.render("local_coursegen/add_course_ai_modal",{}),_templates.default.render("local_coursegen/add_course_ai_modal_footer",{})]);currentModal=await _modal.default.create({title:title,body:bodyHTML,footer:footerHTML,large:!0,scrollable:!0,removeOnClose:!0}),currentModal.getRoot().addClass("local_coursegen_course_ai_modal"),currentModal.show();const bodyEl=currentModal.getBody()[0];userHasScrolled=!1,scrollTimeout&&(clearTimeout(scrollTimeout),scrollTimeout=null);const modalBody=currentModal.getBody()[0];return modalBody&&setupScrollDetection(modalBody),initializeChatInterface(bodyEl,params),setupPlanningButtons(bodyEl,params),setupPlanningToggle(bodyEl),currentModal}catch(error){return _notification.default.exception(error),null}};const initializeChatInterface=async(container,params)=>{try{const chatInterface=container.querySelector("#course-chat-interface");chatInterface&&(chatInterface.style.display="none"),await(0,_course_streaming.startStreaming)(params.streamingurl,container)}catch(error){_notification.default.exception(error)}},addBubble=(wrap,text,role)=>{const row=document.createElement("div");row.className="local_coursegen_ai_msg ".concat(role);const bubble=document.createElement("div");bubble.className="bubble",bubble.textContent=text,row.appendChild(bubble),wrap.appendChild(row),scrollToBottom(wrap)},scrollToBottom=wrap=>{if(!userHasScrolled){const modalBody=document.querySelector(".modal-body");modalBody?modalBody.scrollTop=modalBody.scrollHeight:wrap.scrollTop=wrap.scrollHeight}};async function typeWriter(element,text,speed){let scrollContainer=arguments.length>3&&void 0!==arguments[3]?arguments[3]:document.querySelector(".modal-body");if(!element||"string"!=typeof text)return;let index=0,userHasScrolled=!1;if(scrollContainer){const onUserScroll=()=>{userHasScrolled=!0,scrollContainer.removeEventListener("scroll",onUserScroll)};scrollContainer.addEventListener("scroll",onUserScroll)}for(;index<text.length;)element.textContent+=text[index++],scrollContainer&&!userHasScrolled&&(scrollContainer.scrollTop=scrollContainer.scrollHeight),await new Promise((resolve=>setTimeout(resolve,speed)))}const setupPlanningToggle=container=>{const toggleBtn=container.querySelector("#toggle-planning-details"),collapseElement=container.querySelector("#planning-details-collapse"),toggleIcon=container.querySelector("#planning-toggle-icon");toggleBtn&&collapseElement&&toggleIcon&&toggleBtn.addEventListener("click",(()=>{!collapseElement.classList.contains("show")?(collapseElement.classList.add("show"),toggleIcon.classList.remove("fa-chevron-down"),toggleIcon.classList.add("fa-chevron-up")):(collapseElement.classList.remove("show"),toggleIcon.classList.remove("fa-chevron-up"),toggleIcon.classList.add("fa-chevron-down"))}))},setupPlanningButtons=(container,params)=>{const acceptBtn=container.querySelector("#accept-planning-btn"),adjustBtn=container.querySelector("#adjust-planning-btn"),chatInterface=container.querySelector("#course-chat-interface"),chatForm=container.querySelector("#course-chat-form"),chatInput=container.querySelector("#courseChatInput"),streamingContainer=container.querySelector("[data-region='local_coursegen/course_streaming']");acceptBtn&&acceptBtn.addEventListener("click",(async()=>{acceptBtn.disabled=!0,acceptBtn.textContent=await(0,_str.get_string)("creating_course","local_coursegen");try{const courseId=params.courseid;if(!courseId)throw new Error(await(0,_str.get_string)("error_no_course_id","local_coursegen"));const response=await(0,_chatbot.planCourseExecute)(courseId);if(!response.success)throw new Error(response.message||await(0,_str.get_string)("error_executing_plan","local_coursegen"));const planningActions=container.querySelector("#course-planning-actions");planningActions&&(planningActions.style.display="none"),(container=>{const planningPhase=container.querySelector("#planning-phase-section"),planningSummary=container.querySelector("#planning-summary-collapsed"),planningDetailsContent=container.querySelector("#planning-details-content");if(planningPhase&&planningSummary&&planningDetailsContent){const planningContent=planningPhase.innerHTML;planningDetailsContent.innerHTML=planningContent,planningPhase.style.display="none",planningSummary.style.display="block"}})(container);const executionContainer=container.querySelector("#execution-phase-container");if(response.data&&response.data.streamingurl&&executionContainer){const html=await _templates.default.render("local_coursegen/course_streaming_inline",{title:await(0,_str.get_string)("course_creating_title","local_coursegen"),subtitle:await(0,_str.get_string)("course_creating_subtitle","local_coursegen")}),temp=document.createElement("div");temp.innerHTML=html;const streamingBlock=temp.firstElementChild;executionContainer.appendChild(streamingBlock),await(0,_course_streaming.startExecutionStreaming)(response.data.streamingurl,streamingBlock,courseId)}const message=await(0,_str.get_string)("addcourseai_done","local_coursegen");_notification.default.addNotification({message:message,type:"success"})}catch(error){acceptBtn.disabled=!1,acceptBtn.textContent=await(0,_str.get_string)("accept_planning_create_course","local_coursegen"),_notification.default.exception(error)}})),adjustBtn&&adjustBtn.addEventListener("click",(()=>{adjustBtn.disabled=!0,chatInterface&&(chatInterface.style.display="block",chatInput.focus())})),chatInput&&chatInput.addEventListener("keydown",(e=>{"Enter"!==e.key||e.shiftKey||(e.preventDefault(),chatForm&&chatForm.dispatchEvent(new Event("submit")))})),chatForm&&chatForm.addEventListener("submit",(async e=>{e.preventDefault();const message=chatInput.value.trim();if(!message)return;if(!streamingContainer)return;addBubble(streamingContainer,message,"user"),chatInput.value="";const submitBtn=chatForm.querySelector('button[type="submit"]');submitBtn.disabled=!0;try{const response=await(0,_chatbot.planCourseMessage)({courseid:params.courseid,text:message});if(!response.success){const errorResponse=document.createElement("div");errorResponse.className="mb-3 text-danger",streamingContainer.appendChild(errorResponse);const errorMsg=response.message||await(0,_str.get_string)("error_processing_request","local_coursegen");return void await typeWriter(errorResponse,errorMsg,15)}const streamingUrl=response.data.streamingurl;if(streamingUrl){chatInterface&&(chatInterface.style.display="none");const separator=document.createElement("div");separator.className="mt-4 mb-3 border-top pt-3";const correctionText=await(0,_str.get_string)("adjust_planning_title","local_coursegen");separator.innerHTML='<h6 class="text-muted"><i class="fa fa-edit"></i> '.concat(correctionText,"</h6>"),streamingContainer.appendChild(separator);const html=await _templates.default.render("local_coursegen/course_streaming_inline",{}),temp=document.createElement("div");temp.innerHTML=html;const streamingBlock=temp.firstElementChild;streamingContainer.appendChild(streamingBlock),await(0,_course_streaming.startStreaming)(streamingUrl,streamingBlock,!0)}}catch(error){const errorResponse=document.createElement("div");errorResponse.className="mb-3 text-danger",streamingContainer.appendChild(errorResponse);const errorMsg=await(0,_str.get_string)("error_sending_message","local_coursegen");await typeWriter(errorResponse,"".concat(errorMsg,": ").concat(error.message),15)}finally{submitBtn.disabled=!1}}))}}));

//# sourceMappingURL=add_course_ai_modal.min.js.map