<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_coursegen', language 'es'
 *
 * @package    local_coursegen
 * @category   string
 * @copyright  2025 Wilber Narvaez <https://datacurso.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();
$string['accept_planning_create_course'] = 'Aceptar y crear curso';
$string['actions'] = 'Acciones';
$string['addactivityai_arialabel'] = 'Asistente de IA para crear recursos/actividades';
$string['addactivityai_done'] = '¡Hecho! El recurso o actividad fue creada.';
$string['addactivityai_error'] = 'Ocurrió un error al crear el recurso. Por favor, inténtalo nuevamente o modifica el mensaje.';
$string['addactivityai_faildefault'] = 'No fue posible crear el recurso.';
$string['addactivityai_label'] = 'Describe lo que necesitas';
$string['addactivityai_modaltitle'] = 'Crear recurso o actividad con IA';
$string['addactivityai_placeholder'] = 'Describe qué recurso o actividad quieres crear';
$string['addactivityai_welcome'] = '¡Hola! Cuéntame qué recurso o actividad necesitas y lo crearé en tu curso. 😊';
$string['addactivitywithia'] = 'Agregar actividad o recurso con IA';
$string['addcourseai_arialabel'] = 'Asistente de IA para crear cursos';
$string['addcourseai_done'] = '¡Hecho! El curso fue creado exitosamente.';
$string['addcourseai_modaltitle'] = 'Crear curso con IA';
$string['addmodel'] = 'Agregar modelo';
$string['adjust_course_planning'] = 'Ajustar planificación del curso';
$string['adjust_planning_title'] = 'Ajustar planificación del curso';
$string['click_to_view_details'] = 'Haz clic para ver detalles';
$string['confirmdelete'] = '¿Estás seguro de que deseas eliminar este modelo?';
$string['context_type_field'] = 'Tipo de contexto';
$string['context_type_model'] = 'Modelo instruccional';
$string['context_type_syllabus'] = 'Sílabus';
$string['course_created_success'] = '¡Curso creado exitosamente!';
$string['course_created_success_simple'] = '✅ Curso creado exitosamente';
$string['course_creating_subtitle'] = 'Generando contenido del curso...';
$string['course_creating_title'] = 'Creando el curso';
$string['course_planning_started'] = 'La sesión de planificación del curso se inició correctamente.';
$string['course_streaming_loading'] = 'Cargando...';
$string['course_streaming_planning_subtitle'] = 'Generando contenido del curso...';
$string['course_streaming_planning_title'] = 'Planificación de la creación del curso';
$string['coursecreated'] = 'Curso creado exitosamente';
$string['coursegen:createactivitywithai'] = 'Crear actividades y recursos con IA';
$string['coursegen:createcoursewithai'] = 'Crear cursos con IA';
$string['coursegen:managemodels'] = 'Gestionar modelos';
$string['coursegen:view_syllabus'] = 'Ver sílabus';
$string['createwithai'] = 'Crear con IA';
$string['creating_course'] = 'Creando curso...';
$string['custom_model_select_field'] = 'Elige el modelo a usar';
$string['delete'] = 'Eliminar';
$string['deletemodel'] = 'Eliminar modelo';
$string['edit'] = 'Editar';
$string['editmodel'] = 'Editar modelo';
$string['enter_message'] = 'Escribe tu mensaje';
$string['error_context_type_required'] = 'Selecciona el tipo de contexto para continuar (Modelo instruccional o Sílabus).';
$string['error_creating_course'] = '❌ Error al crear el curso: {$a}';
$string['error_executing_plan'] = 'Error al ejecutar el plan del curso';
$string['error_generating_resource'] = 'Hubo un problema al generar el recurso solicitado. Por favor, inténtalo más tarde.';
$string['error_invalid_resource_type'] = 'No se pudo encontrar un tipo de recurso válido en la respuesta de la IA: {$a}. Por favor, inténtalo nuevamente.';
$string['error_label'] = 'Error';
$string['error_missing_parameters'] = 'No se pudieron obtener los parámetros para crear el módulo desde la respuesta de la IA. Por favor, inténtalo nuevamente.';
$string['error_missing_resource_type'] = 'No se pudo obtener el tipo de recurso desde la respuesta de la IA. Por favor, inténtalo nuevamente.';
$string['error_model_required'] = 'Selecciona un modelo instruccional cuando el tipo de contexto sea "Modelo instruccional".';
$string['error_no_course_id'] = 'No se pudo obtener el ID del curso';
$string['error_no_models_configured'] = 'No hay modelos instruccionales configurados. Primero crea modelos en la página Gestionar modelos.';
$string['error_no_session_found'] = 'No se encontró ninguna sesión de planificación para este curso y usuario.';
$string['error_processing_request'] = 'Error al procesar tu solicitud';
$string['error_saving_session'] = 'No se pudo guardar la planificación del curso. Por favor, inténtalo nuevamente.';
$string['error_sending_message'] = 'Error al enviar el mensaje';
$string['error_starting_course_planning'] = 'Ocurrió un error al iniciar la planificación del curso. Por favor, inténtalo nuevamente.';
$string['error_syllabus_pdf_required'] = 'Debes subir un archivo PDF del sílabus cuando el tipo de contexto sea "Sílabus".';
$string['error_upload_failed'] = 'Error al subir el sílabus: {$a}';
$string['error_upload_failed_model'] = 'Error al subir el modelo: {$a}';
$string['execution_activity_done'] = '✅ Actividad completada ({$a->done}/{$a->total}) — {$a->percent}%';
$string['execution_activity_start'] = '🧩 Iniciando actividad #{$a->index} (sección {$a->section}): {$a->title}';
$string['execution_error_activity'] = '❌ Error en una actividad';
$string['execution_progress'] = '📈 Progreso: {$a->done}/{$a->total} ({$a->percent}%)';
$string['generalsettings'] = 'Configuración general';
$string['invalidmodel'] = 'Modelo no válido';
$string['managemodels'] = 'Gestionar modelos';
$string['message_sent_successfully'] = 'Mensaje enviado correctamente a la sesión de planificación con IA.';
$string['modelcontent'] = 'Contenido del modelo';
$string['modelcontent_help'] = 'Proporciona la descripción completa del modelo instruccional, incluyendo sus fases/pasos, su propósito y cómo debe guiar el diseño del curso.';
$string['modelcreated'] = 'Creado';
$string['modeldeleted'] = 'Modelo eliminado correctamente';
$string['modelmodified'] = 'Modificado';
$string['modelname'] = 'Nombre del modelo';
$string['modelname_help'] = 'Ingresa el nombre del modelo instruccional que utilizarás para el diseño de los cursos. Por ejemplo: ADDIE, Gagné, u otro marco reconocido.';
$string['modelnameexists'] = 'Ya existe un modelo con este nombre';
$string['modelsaved'] = 'Modelo guardado correctamente';
$string['module_creation_subtitle'] = 'Por favor, espera mientras se genera el contenido';
$string['module_creation_title'] = 'Creando módulo...';
$string['module_streaming_add_error'] = 'No se pudo añadir la actividad al curso.';
$string['module_streaming_add_problem'] = 'Hubo un problema al añadir la actividad: {$a}';
$string['module_streaming_added_success'] = '✅ Actividad añadida correctamente al curso';
$string['module_streaming_complete'] = '🎉 ¡Tu actividad ha sido creada con éxito!';
$string['module_streaming_creation_error'] = '⚠️ Ocurrió un error durante la creación de la actividad';
$string['module_streaming_images_done'] = '✅ Imágenes generadas correctamente';
$string['module_streaming_images_start'] = '🎨 Creando imágenes personalizadas...';
$string['module_streaming_output_start'] = '⚙️ Finalizando y preparando la actividad...';
$string['module_streaming_parameters_done'] = '✅ Configuración aplicada';
$string['module_streaming_parameters_start'] = '🔧 Aplicando configuración de la actividad...';
$string['module_streaming_schema_done'] = '✅ Estructura del contenido lista';
$string['module_streaming_schema_start'] = '📋 Diseñando estructura del contenido...';
$string['module_streaming_start'] = '🚀 Iniciando creación de actividad...';
$string['no_models_configured_notice'] = 'Para usar este tipo de contexto, primero debes crear modelos instruccionales. Ir a la página <a href="{$a}">Gestionar modelos</a>.';
$string['noimages'] = 'No generar imágenes';
$string['nomodels'] = 'No se encontraron modelos';
$string['planning_chat_placeholder'] = 'Describe los ajustes que deseas realizar en la planificación del curso...';
$string['planning_completed'] = 'Planificación completada';
$string['pluginname'] = 'Creador de Curso IA';
$string['privacy:metadata:local_coursegen'] = 'Course Creator AI almacena datos personales para admitir la generación de cursos y módulos impulsada por IA.';
$string['privacy:metadata:local_coursegen_course_context'] = 'Preferencias de contexto almacenadas para la planificación del curso.';
$string['privacy:metadata:local_coursegen_course_context:context_type'] = 'El tipo de contexto seleccionado para el curso.';
$string['privacy:metadata:local_coursegen_course_context:courseid'] = 'El ID del curso cuyas preferencias de contexto se almacenan.';
$string['privacy:metadata:local_coursegen_course_context:model_id'] = 'El ID del modelo instruccional seleccionado para el curso.';
$string['privacy:metadata:local_coursegen_course_context:timecreated'] = 'La hora en que se creó el registro de contexto del curso.';
$string['privacy:metadata:local_coursegen_course_context:timemodified'] = 'La hora en que se actualizó por última vez el registro de contexto del curso.';
$string['privacy:metadata:local_coursegen_course_context:usermodified'] = 'El ID del usuario que modificó por última vez el contexto del curso.';
$string['privacy:metadata:local_coursegen_course_data'] = 'Datos de curso personalizados almacenados para la integración con DataCurso.';
$string['privacy:metadata:local_coursegen_course_data:courseid'] = 'El ID del curso al que pertenecen estos datos.';
$string['privacy:metadata:local_coursegen_course_data:custom_checkbox'] = 'Un valor de casilla de verificación personalizado asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_date'] = 'Un valor de fecha personalizado asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_select'] = 'Un valor de selección personalizado asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_text'] = 'Un valor de texto corto personalizado asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_textarea'] = 'Un valor de área de texto personalizado asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:timecreated'] = 'La hora en que se creó el registro.';
$string['privacy:metadata:local_coursegen_course_data:timemodified'] = 'La hora en que se actualizó por última vez el registro.';
$string['privacy:metadata:local_coursegen_course_sessions'] = 'Sesiones de planificación de cursos creadas a través del servicio de IA.';
$string['privacy:metadata:local_coursegen_course_sessions:courseid'] = 'El ID del curso que se está planificando.';
$string['privacy:metadata:local_coursegen_course_sessions:session_id'] = 'El identificador de sesión devuelto por el servicio de IA.';
$string['privacy:metadata:local_coursegen_course_sessions:status'] = 'El estado actual de la sesión de planificación del curso.';
$string['privacy:metadata:local_coursegen_course_sessions:timecreated'] = 'La hora en que se creó la sesión de planificación del curso.';
$string['privacy:metadata:local_coursegen_course_sessions:timemodified'] = 'La hora de la última actualización de la sesión de planificación del curso.';
$string['privacy:metadata:local_coursegen_course_sessions:userid'] = 'El ID del usuario que inició la sesión de planificación del curso.';
$string['privacy:metadata:local_coursegen_model'] = 'Modelos instruccionales creados o editados para la generación del curso.';
$string['privacy:metadata:local_coursegen_model:content'] = 'La descripción almacenada del modelo instruccional.';
$string['privacy:metadata:local_coursegen_model:deleted'] = 'Si el modelo instruccional está marcado como eliminado.';
$string['privacy:metadata:local_coursegen_model:name'] = 'El nombre del modelo instruccional.';
$string['privacy:metadata:local_coursegen_model:timecreated'] = 'La hora en que se creó el modelo instruccional.';
$string['privacy:metadata:local_coursegen_model:timemodified'] = 'La hora en que se actualizó por última vez el modelo instruccional.';
$string['privacy:metadata:local_coursegen_model:usermodified'] = 'El ID del usuario que modificó por última vez el modelo instruccional.';
$string['privacy:metadata:local_coursegen_module_jobs'] = 'Detalles de los trabajos de generación de módulos con IA en cola por los usuarios.';
$string['privacy:metadata:local_coursegen_module_jobs:beforemod'] = 'El ID del módulo antes del cual se debe insertar la nueva actividad.';
$string['privacy:metadata:local_coursegen_module_jobs:context_type'] = 'El tipo de contexto proporcionado al ejecutar el trabajo de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:courseid'] = 'El ID del curso asociado al trabajo de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:generate_images'] = 'Si el trabajo de módulo generará imágenes.';
$string['privacy:metadata:local_coursegen_module_jobs:job_id'] = 'El identificador devuelto por el servicio de IA para el trabajo de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:model_name'] = 'El nombre del modelo instruccional proporcionado al servicio de IA.';
$string['privacy:metadata:local_coursegen_module_jobs:sectionnum'] = 'El número de sección del curso donde se debe crear la actividad.';
$string['privacy:metadata:local_coursegen_module_jobs:status'] = 'El estado actual del trabajo de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:timecreated'] = 'La hora en que se creó el trabajo de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:timemodified'] = 'La hora de la última actualización del trabajo de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:userid'] = 'El ID del usuario que inició el trabajo de módulo.';
$string['resource_created'] = 'Recurso {$a} creado correctamente.';
$string['send'] = 'Enviar';
$string['syllabus_pdf_field'] = 'Subir PDF del sílabus';
$string['syllabus_pdf_field_help'] = 'Sube un archivo PDF que contenga el sílabus del curso. Será enviado a la IA para análisis contextual. Tamaño máximo: 10 MB.';
$string['unauthorized'] = 'Acceso no autorizado';
$string['yesimages'] = 'Generar imágenes';
