<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_coursegen', language 'fr'
 *
 * @package    local_coursegen
 * @category   string
 * @copyright  2025 Wilber Narvaez <https://datacurso.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_planning_create_course'] = 'Accepter et créer le cours';
$string['actions'] = 'Actions';
$string['addactivityai_arialabel'] = 'Assistant IA pour créer des ressources/activités';
$string['addactivityai_done'] = 'Terminé ! La ressource ou l’activité a été créée.';
$string['addactivityai_error'] = 'Une erreur s’est produite lors de la création de la ressource. Veuillez réessayer ou modifier la demande.';
$string['addactivityai_faildefault'] = 'Impossible de créer la ressource.';
$string['addactivityai_label'] = 'Décrivez ce dont vous avez besoin';
$string['addactivityai_modaltitle'] = 'Créer une ressource/activité avec l’IA';
$string['addactivityai_placeholder'] = 'Décrivez la ressource ou l’activité que vous souhaitez créer';
$string['addactivityai_welcome'] = 'Bonjour ! Dites-moi quelle ressource ou activité vous souhaitez et je la créerai dans votre cours. 😊';
$string['addactivitywithia'] = 'Ajouter une activité ou ressource avec l’IA';
$string['addcourseai_arialabel'] = 'Assistant IA pour créer des cours';
$string['addcourseai_done'] = 'Terminé ! Le cours a été créé avec succès.';
$string['addcourseai_modaltitle'] = 'Créer un cours avec l’IA';
$string['addmodel'] = 'Ajouter un modèle';
$string['adjust_course_planning'] = 'Ajuster la planification du cours';
$string['adjust_planning_title'] = 'Ajuster la planification du cours';
$string['click_to_view_details'] = 'Cliquez pour voir les détails';
$string['confirmdelete'] = 'Êtes-vous sûr de vouloir supprimer ce modèle ?';
$string['context_type_field'] = 'Type de contexte';
$string['context_type_model'] = 'Modèle pédagogique';
$string['context_type_syllabus'] = 'Programme';
$string['course_created_success'] = 'Cours créé avec succès !';
$string['course_created_success_simple'] = '✅ Cours créé avec succès';
$string['course_creating_subtitle'] = 'Génération du contenu du cours...';
$string['course_creating_title'] = 'Création du cours';
$string['course_planning_started'] = 'La session de planification du cours a démarré avec succès.';
$string['course_streaming_loading'] = 'Chargement...';
$string['course_streaming_planning_subtitle'] = 'Génération du contenu du cours...';
$string['course_streaming_planning_title'] = 'Planification de la création du cours';
$string['coursecreated'] = 'Cours créé avec succès';
$string['coursegen:managemodels'] = 'Gérer les modèles';
$string['coursegen:view_syllabus'] = 'Voir le programme';
$string['createwithai'] = 'Créer avec l’IA';
$string['creating_course'] = 'Création du cours...';
$string['custom_model_select_field'] = 'Choisissez le modèle à utiliser';
$string['delete'] = 'Supprimer';
$string['deletemodel'] = 'Supprimer le modèle';
$string['edit'] = 'Modifier';
$string['editmodel'] = 'Modifier le modèle';
$string['enter_message'] = 'Saisissez votre message';
$string['error'] = 'Erreur : {$a}';
$string['error_creating_course'] = '❌ Erreur lors de la création du cours : {$a}';
$string['error_executing_plan'] = 'Erreur lors de l’exécution du plan du cours';
$string['error_generating_resource'] = 'Un problème est survenu lors de la génération de la ressource demandée. Veuillez réessayer plus tard.';
$string['error_no_course_id'] = 'Impossible d’obtenir l’ID du cours';
$string['error_no_session_found'] = 'Aucune session de planification trouvée pour ce cours et cet utilisateur.';
$string['error_processing_request'] = 'Erreur lors du traitement de votre demande';
$string['error_saving_session'] = 'Échec de l’enregistrement de la session de planification. Veuillez réessayer.';
$string['error_sending_message'] = 'Erreur lors de l’envoi du message';
$string['error_starting_course_planning'] = 'Une erreur est survenue lors du démarrage de la planification du cours. Veuillez réessayer.';
$string['error_upload_failed'] = 'Échec du téléchargement du programme : {$a}';
$string['error_upload_failed_model'] = 'Échec du téléchargement du modèle : {$a}';
$string['execution_activity_done'] = '✅ Activité terminée ({$a->done}/{$a->total}) — {$a->percent}%';
$string['execution_activity_start'] = '🧩 Démarrage de l’activité #{$a->index} (section {$a->section}) : {$a->title}';
$string['execution_error_activity'] = '❌ Erreur dans une activité';
$string['execution_progress'] = '📈 Progression : {$a->done}/{$a->total} ({$a->percent}%)';
$string['generalsettings'] = 'Paramètres généraux';
$string['invalidmodel'] = 'Modèle invalide';
$string['managemodels'] = 'Gérer les modèles';
$string['message_sent_successfully'] = 'Message envoyé avec succès à la session de planification IA.';
$string['modelcontent'] = 'Contenu du modèle';
$string['modelcontent_help'] = 'Fournissez la description complète du modèle pédagogique, y compris ses phases/étapes, sa finalité et la manière dont il doit guider la conception du cours.';
$string['modelcreated'] = 'Créé';
$string['modeldeleted'] = 'Modèle supprimé avec succès';
$string['modelmodified'] = 'Modifié';
$string['modelname'] = 'Nom du modèle';
$string['modelname_help'] = 'Saisissez le nom du modèle pédagogique que vous utiliserez pour la conception du cours. Par exemple : ADDIE, Gagné, ou un autre cadre reconnu.';
$string['modelnameexists'] = 'Un modèle avec ce nom existe déjà';
$string['modelsaved'] = 'Modèle enregistré avec succès';
$string['module_creation_subtitle'] = 'Veuillez patienter pendant la génération du contenu';
$string['module_creation_title'] = 'Création du module...';
$string['module_streaming_add_error'] = 'Impossible d’ajouter l’activité au cours.';
$string['module_streaming_add_problem'] = 'Un problème est survenu lors de l’ajout de l’activité : {$a}';
$string['module_streaming_added_success'] = '✅ Activité ajoutée au cours avec succès !';
$string['module_streaming_complete'] = '🎉 Votre activité a été créée avec succès !';
$string['module_streaming_creation_error'] = '⚠️ Une erreur s’est produite lors de la création de l’activité';
$string['module_streaming_images_done'] = '✅ Images générées avec succès';
$string['module_streaming_images_start'] = '🎨 Création d’images personnalisées...';
$string['module_streaming_output_start'] = '⚙️ Finalisation et préparation de l’activité...';
$string['module_streaming_parameters_done'] = '✅ Configuration appliquée';
$string['module_streaming_parameters_start'] = '🔧 Application de la configuration de l’activité...';
$string['module_streaming_schema_done'] = '✅ Structure du contenu prête';
$string['module_streaming_schema_start'] = '📋 Conception de la structure du contenu...';
$string['module_streaming_start'] = '🚀 Démarrage de la création de l’activité...';
$string['noimages'] = 'Ne pas générer d’images';
$string['nomodels'] = 'Aucun modèle trouvé';
$string['planning_chat_placeholder'] = 'Décrivez les ajustements que vous souhaitez apporter à la planification du cours...';
$string['planning_completed'] = 'Planification terminée';
$string['pluginname'] = 'Créateur de cours IA';
$string['privacy:metadata:local_coursegen'] = 'Course Creator AI stocke des données personnelles pour prendre en charge la génération de cours et de modules pilotée par l’IA.';
$string['privacy:metadata:local_coursegen_course_context'] = 'Préférences de contexte stockées pour la planification du cours.';
$string['privacy:metadata:local_coursegen_course_context:context_type'] = 'Le type de contexte sélectionné pour le cours.';
$string['privacy:metadata:local_coursegen_course_context:courseid'] = 'L’ID du cours dont les préférences de contexte sont stockées.';
$string['privacy:metadata:local_coursegen_course_context:model_id'] = 'L’ID du modèle pédagogique sélectionné pour le cours.';
$string['privacy:metadata:local_coursegen_course_context:timecreated'] = 'La date de création de l’enregistrement de contexte du cours.';
$string['privacy:metadata:local_coursegen_course_context:timemodified'] = 'La date de dernière mise à jour de l’enregistrement de contexte du cours.';
$string['privacy:metadata:local_coursegen_course_context:usermodified'] = 'L’ID de l’utilisateur ayant modifié pour la dernière fois le contexte du cours.';
$string['privacy:metadata:local_coursegen_course_sessions'] = 'Sessions de planification de cours créées via le service d’IA.';
$string['privacy:metadata:local_coursegen_course_sessions:courseid'] = 'L’ID du cours en cours de planification.';
$string['privacy:metadata:local_coursegen_course_sessions:session_id'] = 'L’identifiant de session renvoyé par le service d’IA.';
$string['privacy:metadata:local_coursegen_course_sessions:status'] = 'Le statut actuel de la session de planification du cours.';
$string['privacy:metadata:local_coursegen_course_sessions:timecreated'] = 'La date de création de la session de planification du cours.';
$string['privacy:metadata:local_coursegen_course_sessions:timemodified'] = 'La date de dernière mise à jour de la session de planification du cours.';
$string['privacy:metadata:local_coursegen_course_sessions:userid'] = 'L’ID de l’utilisateur ayant initié la session de planification du cours.';
$string['privacy:metadata:local_coursegen_model'] = 'Modèles pédagogiques créés ou modifiés pour la génération de cours.';
$string['privacy:metadata:local_coursegen_model:content'] = 'La description enregistrée du modèle pédagogique.';
$string['privacy:metadata:local_coursegen_model:deleted'] = 'Indique si le modèle pédagogique est marqué comme supprimé.';
$string['privacy:metadata:local_coursegen_model:name'] = 'Le nom du modèle pédagogique.';
$string['privacy:metadata:local_coursegen_model:timecreated'] = 'La date de création du modèle pédagogique.';
$string['privacy:metadata:local_coursegen_model:timemodified'] = 'La date de dernière mise à jour du modèle pédagogique.';
$string['privacy:metadata:local_coursegen_model:usermodified'] = 'L’ID de l’utilisateur ayant modifié pour la dernière fois le modèle pédagogique.';
$string['privacy:metadata:local_coursegen_module_jobs'] = 'Détails des travaux de génération de modules par IA mis en file d’attente par les utilisateurs.';
$string['privacy:metadata:local_coursegen_module_jobs:beforemod'] = 'L’ID du module avant lequel la nouvelle activité doit être insérée.';
$string['privacy:metadata:local_coursegen_module_jobs:context_type'] = 'Le type de contexte fourni lors de l’exécution du travail de module.';
$string['privacy:metadata:local_coursegen_module_jobs:courseid'] = 'L’ID du cours associé au travail de module.';
$string['privacy:metadata:local_coursegen_module_jobs:generate_images'] = 'Indique si le travail de module générera des images.';
$string['privacy:metadata:local_coursegen_module_jobs:job_id'] = 'L’identifiant renvoyé par le service d’IA pour le travail de module.';
$string['privacy:metadata:local_coursegen_module_jobs:model_name'] = 'Le nom du modèle pédagogique fourni au service d’IA.';
$string['privacy:metadata:local_coursegen_module_jobs:sectionnum'] = 'Le numéro de section du cours où l’activité doit être créée.';
$string['privacy:metadata:local_coursegen_module_jobs:status'] = 'Le statut actuel du travail de module.';
$string['privacy:metadata:local_coursegen_module_jobs:timecreated'] = 'La date de création du travail de module.';
$string['privacy:metadata:local_coursegen_module_jobs:timemodified'] = 'La date de dernière mise à jour du travail de module.';
$string['privacy:metadata:local_coursegen_module_jobs:userid'] = 'L’ID de l’utilisateur ayant démarré le travail de module.';
$string['resource_created'] = 'Ressource {$a} créée avec succès.';
$string['send'] = 'Envoyer';
$string['syllabus_pdf_field'] = 'Téléverser le PDF du programme';
$string['syllabus_pdf_field_help'] = 'Téléversez un fichier PDF contenant le programme du cours. Il sera envoyé à l’IA pour une analyse contextuelle. Taille maximale : 10 Mo.';
$string['unauthorized'] = 'Accès non autorisé';
$string['yesimages'] = 'Générer des images';
