/**
 * TODO describe module add_activity_ai
 *
 * @module     local_coursegen/add_activity_ai
 * @copyright  2025 Wilber Narvaez <https://datacurso.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_coursegen/add_activity_ai",["core/templates","core/notification","core/modal","core/custom_interaction_events","core/str","local_coursegen/repository/chatbot","local_coursegen/module_streaming"],((Templates,Notification,Modal,CustomEvents,Str,chatbotRepository,moduleStreaming)=>{let modal=null,initialized=!1,userHasScrolled=!1,scrollTimeout=null;const readDataset=el=>{const{sectionnum:sectionnum,beforemod:beforemod}=el.dataset;return{sectionnum:Number(sectionnum),beforemod:beforemod?Number(beforemod):null}},openChatModal=async payload=>{try{modal&&(await modal.destroy(),modal=null);const[bodyHTML,footerHTML]=await Promise.all([Templates.render("local_coursegen/add_activity_ai_modal",{}),Templates.render("local_coursegen/activity_chat_footer",{})]),title=await Str.get_string("addactivityai_modaltitle","local_coursegen");modal=await Modal.create({title:title,body:bodyHTML,footer:footerHTML,large:!0,scrollable:!0,removeOnClose:!0}),modal.getRoot().addClass("local_coursegen_course_ai_modal"),modal.show(),modal.getRoot().on("hidden.bs.modal",(()=>{modal&&(modal.destroy(),modal=null)})),userHasScrolled=!1,scrollTimeout&&(clearTimeout(scrollTimeout),scrollTimeout=null);const modalBody=modal.getBody()[0];modalBody&&(scrollContainer=>{if(!scrollContainer)return;scrollContainer.addEventListener("scroll",(()=>{var element;scrollTimeout&&clearTimeout(scrollTimeout),userHasScrolled=!0,(element=scrollContainer).scrollTop+element.clientHeight>=element.scrollHeight-50&&(scrollTimeout=setTimeout((()=>{userHasScrolled=!1}),1e3))}),{passive:!0})})(modalBody);const bodyEl=modal.getBody()[0],footerEl=modal.getFooter()[0];wireChatHandlers(bodyEl,footerEl,payload)}catch(err){Notification.exception(err)}},wireChatHandlers=(container,footerContainer,payload)=>{const streamingSection=container.querySelector("#activity-streaming-section"),userMessagesSection=container.querySelector("#activity-user-messages"),form=footerContainer.querySelector("form.local_coursegen_ai_input"),textarea=form.querySelector("textarea"),sendBtn=form.querySelector(".local_coursegen_ai_send");form.addEventListener("submit",(async e=>{e.preventDefault();const prompt=textarea.value.trim();if(!prompt)return;pushUser(userMessagesSection,prompt),userMessagesSection&&(userMessagesSection.style.display="block");const generateImages=document.querySelector('input[name="generate_images"]:checked').value;textarea.value="",sendBtn.disabled=!0,textarea.disabled=!0;const radioButtons=document.querySelectorAll('input[name="generate_images"]');radioButtons.forEach((rb=>{rb.disabled=!0})),setLoading(sendBtn,!0);try{const response=await chatbotRepository.createModStream({...payload,prompt:prompt,generateimages:generateImages});if(!response.ok)throw new Error(response.message);if(streamingSection){streamingSection.style.display="block";const progressIndicator=streamingSection.querySelector("[data-region='local_coursegen/course_streaming/progress']");if(progressIndicator){const titleElement=progressIndicator.querySelector("h6, h5"),subtitleElement=progressIndicator.querySelector("small");if(titleElement){const titleText=await Str.get_string("module_creation_title","local_coursegen");titleElement.textContent=titleText}if(subtitleElement){const subtitleText=await Str.get_string("module_creation_subtitle","local_coursegen");subtitleElement.textContent=subtitleText}progressIndicator.style.display="block"}}await moduleStreaming.startModuleStreaming(response.streamingurl,streamingSection,{courseid:payload.courseid,sectionnum:payload.sectionnum,beforemod:payload.beforemod,jobid:response.job_id})}catch(err){if(streamingSection){streamingSection.style.display="block";const eventList=streamingSection.querySelector("[data-region='local_coursegen/course_streaming']");if(eventList){const errorDiv=document.createElement("div");errorDiv.className="alert alert-danger mb-2";const errorMsg=err.message||await Str.get_string("addactivityai_error","local_coursegen"),errorLabel=await Str.get_string("error_label","local_coursegen");if(errorDiv.innerHTML="<small>❌ ".concat(errorLabel,": ").concat(errorMsg,"</small>"),eventList.appendChild(errorDiv),!userHasScrolled){const modalBody=document.querySelector(".modal-body");modalBody?modalBody.scrollTop=modalBody.scrollHeight:eventList.scrollTop=eventList.scrollHeight}}}}finally{radioButtons.forEach((rb=>{rb.disabled=!1})),textarea.disabled=!1,sendBtn.disabled=!1,setLoading(sendBtn,!1)}})),textarea.addEventListener("keydown",(e=>{"Enter"!==e.key||e.shiftKey||(e.preventDefault(),form.requestSubmit())}))},pushUser=(wrap,text)=>addBubble(wrap,text,"user"),addBubble=(wrap,text,role)=>{const row=document.createElement("div");row.className="local_coursegen_ai_msg ".concat(role);const b=document.createElement("div");b.className="bubble",b.textContent=text,row.appendChild(b),wrap.appendChild(row),scrollToBottom(wrap)},scrollToBottom=wrap=>{if(!userHasScrolled){const modalBody=document.querySelector(".modal-body");modalBody?modalBody.scrollTop=modalBody.scrollHeight:wrap.scrollTop=wrap.scrollHeight}},setLoading=(btn,isLoading)=>{btn.disabled=isLoading,btn.style.opacity=isLoading?.7:1};return{init:()=>{if(initialized)return;initialized=!0;const events=["click",CustomEvents.events.activate,CustomEvents.events.keyboardActivate];CustomEvents.define(document,events),events.forEach((event=>{document.addEventListener(event,(async e=>{const link=e.target.closest('[data-action="local_coursegen/add_activity_ai"]');if(!link)return;e.preventDefault();const payload=readDataset(link);await openChatModal(payload)}))}))},openChatModal:openChatModal}}));

//# sourceMappingURL=add_activity_ai.min.js.map