<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_coursegen', language 'de'
 *
 * @package    local_coursegen
 * @category   string
 * @copyright  2025 Wilber Narvaez <https://datacurso.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_planning_create_course'] = 'Planung akzeptieren und Kurs erstellen';
$string['actions'] = 'Aktionen';
$string['addactivityai_arialabel'] = 'KI-Assistent zum Erstellen von Materialien/Aktivitäten';
$string['addactivityai_done'] = 'Fertig! Das Material/die Aktivität wurde erstellt.';
$string['addactivityai_error'] = 'Beim Erstellen des Materials ist ein Fehler aufgetreten. Bitte versuchen Sie es erneut oder passen Sie die Eingabe an.';
$string['addactivityai_faildefault'] = 'Das Material konnte nicht erstellt werden.';
$string['addactivityai_label'] = 'Beschreiben Sie, was Sie benötigen';
$string['addactivityai_modaltitle'] = 'Material/Aktivität mit KI erstellen';
$string['addactivityai_placeholder'] = 'Beschreiben Sie, welches Material oder welche Aktivität Sie erstellen möchten';
$string['addactivityai_welcome'] = 'Hallo! Sagen Sie mir, welches Material oder welche Aktivität Sie benötigen, und ich erstelle es in Ihrem Kurs. 😊';
$string['addactivitywithia'] = 'Aktivität oder Material mit KI hinzufügen';
$string['addcourseai_arialabel'] = 'KI-Assistent zum Erstellen von Kursen';
$string['addcourseai_done'] = 'Fertig! Der Kurs wurde erfolgreich erstellt.';
$string['addcourseai_modaltitle'] = 'Kurs mit KI erstellen';
$string['addsysteminstruction'] = 'Systemanweisung hinzufügen';
$string['adjust_course_planning'] = 'Kursplanung anpassen';
$string['adjust_planning_title'] = 'Kursplanung anpassen';
$string['ai_response_language'] = 'Sprache der KI-Antworten';
$string['ai_response_language_help'] = 'Wählen Sie die Sprache aus, in der die KI antwortet und die Kursinhalte generiert.';
$string['click_to_view_details'] = 'Klicken Sie hier, um Details anzuzeigen';
$string['confirmdeletesysteminstruction'] = 'Sind Sie sicher, dass Sie diese Systemanweisung löschen möchten?';
$string['context_type_customprompt'] = 'Benutzerdefinierte Eingabe';
$string['context_type_field'] = 'Kontexttyp';
$string['context_type_syllabus'] = 'Syllabus';
$string['context_type_system_instruction'] = 'Systemanweisung';
$string['course_ai_language'] = 'Sprache der KI-Antworten';
$string['course_ai_language_help'] = 'Wählen Sie die Sprache aus, in der die KI antwortet und die Kursinhalte generiert.';
$string['course_created_success'] = 'Kurs wurde erfolgreich erstellt!';
$string['course_created_success_simple'] = '✅ Kurs erfolgreich erstellt';
$string['course_creating_subtitle'] = 'Kursinhalt wird generiert...';
$string['course_creating_title'] = 'Kurs wird erstellt';
$string['course_generate_images_field'] = 'Bilder für den Kurs';
$string['course_generate_images_field_help'] = 'Wählen Sie, ob die KI bei der Erstellung des Kurses Bilder generieren soll (für Abschnitte, Aktivitäten und andere visuelle Elemente).';
$string['course_planning_started'] = 'Kursplanungssitzung wurde erfolgreich gestartet.';
$string['course_streaming_loading'] = 'Laden...';
$string['course_streaming_planning_subtitle'] = 'Kursinhalt wird generiert...';
$string['course_streaming_planning_title'] = 'Planung der Kurserstellung';
$string['coursecreated'] = 'Kurs erfolgreich erstellt';
$string['coursegen:createactivitywithai'] = 'Aktivitäten und Materialien mit KI erstellen';
$string['coursegen:createcoursewithai'] = 'Kurse mit KI erstellen';
$string['coursegen:managesysteminstructions'] = 'Systemanweisungen verwalten';
$string['coursegen:view_syllabus'] = 'Syllabus anzeigen';
$string['createwithai'] = 'Mit KI erstellen';
$string['creating_course'] = 'Kurs wird erstellt...';
$string['custom_fields_header'] = 'DataCurso';
$string['custom_prompt_field'] = 'Eingabe für die KI';
$string['custom_prompt_field_help'] = 'Schreiben Sie einen ausführlichen Prompt, den die KI als Hauptkontext für die Kursgestaltung verwendet (Lernziele, Zielgruppe/Teilnehmerprofil, Inhalte, Niveau, Einschränkungen usw.).';
$string['custom_system_instruction_select_field'] = 'Anzuwendende Systemanweisung';
$string['custom_system_instruction_select_field_help'] = 'Wählen Sie, welche Systemanweisung zusammen mit dem ausgewählten Kontext angewendet wird. Jede Systemanweisung enthält vordefinierte Regeln und Richtlinien (Ton, Struktur, Einschränkungen usw.), an die sich die KI bei der Generierung von Kursinhalten immer hält.';
$string['delete'] = 'Löschen';
$string['deletesysteminstruction'] = 'Systemanweisung löschen';
$string['edit'] = 'Bearbeiten';
$string['editsysteminstruction'] = 'Systemanweisung bearbeiten';
$string['enter_message'] = 'Nachricht eingeben';
$string['error'] = 'Fehler: {$a}';
$string['error_context_type_required'] = 'Bitte wählen Sie einen Kontexttyp aus, um fortzufahren (Syllabus oder Benutzerdefinierte Eingabe).';
$string['error_creating_course'] = '❌ Fehler beim Erstellen des Kurses: {$a}';
$string['error_executing_plan'] = 'Fehler bei der Ausführung des Kursplans';
$string['error_generating_resource'] = 'Beim Generieren des angeforderten Materials ist ein Problem aufgetreten. Bitte versuchen Sie es später erneut.';
$string['error_invalid_resource_type'] = 'Es konnte kein gültiger Materialtyp aus der KI-Antwort gefunden werden: {$a}. Bitte versuchen Sie es erneut.';
$string['error_label'] = 'Fehler';
$string['error_missing_parameters'] = 'Die Parameter zum Erstellen des Moduls konnten aus der KI-Antwort nicht abgeleitet werden. Bitte versuchen Sie es erneut.';
$string['error_missing_resource_type'] = 'Der Materialtyp konnte aus der KI-Antwort nicht abgeleitet werden. Bitte versuchen Sie es erneut.';
$string['error_no_course_id'] = 'Kurs-ID konnte nicht ermittelt werden';
$string['error_no_session_found'] = 'Für diesen Kurs und Benutzer wurde keine Planungssitzung gefunden.';
$string['error_no_system_instructions_configured'] = 'Es sind keine Systemanweisungen konfiguriert. Bitte erstellen Sie zuerst Systemanweisungen auf der Seite „Systemanweisungen verwalten“.';
$string['error_processing_request'] = 'Fehler bei der Verarbeitung Ihrer Anfrage';
$string['error_prompt_required'] = 'Sie müssen eine Eingabe angeben, wenn der Kontexttyp "Benutzerdefinierte Eingabe" ist.';
$string['error_saving_session'] = 'Die Planungssitzung konnte nicht gespeichert werden. Bitte versuchen Sie es erneut.';
$string['error_sending_message'] = 'Fehler beim Senden der Nachricht';
$string['error_starting_course_planning'] = 'Beim Starten der Kursplanung ist ein Fehler aufgetreten. Bitte versuchen Sie es erneut.';
$string['error_syllabus_pdf_required'] = 'Sie müssen ein Syllabus-PDF hochladen, wenn der Kontexttyp "Syllabus" ist.';
$string['error_system_instruction_required'] = 'Bitte wählen Sie eine Systemanweisung aus, wenn die Option "Systemanweisung verwenden" aktiviert ist.';
$string['error_upload_failed'] = 'Fehler beim Hochladen des Syllabus: {$a}';
$string['error_upload_failed_system_instruction'] = 'Fehler beim Hochladen der Systemanweisung: {$a}';
$string['execution_activity_done'] = '✅ Aktivität abgeschlossen ({$a->done}/{$a->total}) — {$a->percent}%';
$string['execution_activity_start'] = '🧩 Starte Aktivität #{$a->index} (Abschnitt {$a->section}): {$a->title}';
$string['execution_error_activity'] = '❌ Fehler in einer Aktivität';
$string['execution_progress'] = '📈 Fortschritt: {$a->done}/{$a->total} ({$a->percent}%)';

$string['generalsettings'] = 'Allgemeine Einstellungen';
$string['invalidsysteminstruction'] = 'Ungültige Systemanweisung';
$string['managesysteminstructions'] = 'Systemanweisungen verwalten';
$string['message_sent_successfully'] = 'Nachricht erfolgreich an die KI-Planungssitzung gesendet.';
$string['module_creation_subtitle'] = 'Bitte warten Sie, während der Inhalt generiert wird';
$string['module_creation_title'] = 'Modul wird erstellt...';
$string['module_streaming_add_error'] = 'Die Aktivität konnte nicht zum Kurs hinzugefügt werden.';
$string['module_streaming_add_problem'] = 'Beim Hinzufügen der Aktivität ist ein Problem aufgetreten: {$a}';
$string['module_streaming_added_success'] = '✅ Aktivität erfolgreich zum Kurs hinzugefügt!';
$string['module_streaming_complete'] = '🎉 Ihre Aktivität wurde erfolgreich erstellt!';
$string['module_streaming_creation_error'] = '⚠️ Beim Erstellen der Aktivität ist ein Fehler aufgetreten';
$string['module_streaming_images_done'] = '✅ Bilder erfolgreich generiert';
$string['module_streaming_images_start'] = '🎨 Benutzerdefinierte Bilder werden erstellt...';
$string['module_streaming_output_start'] = '⚙️ Aktivität wird finalisiert und vorbereitet...';
$string['module_streaming_parameters_done'] = '✅ Konfiguration angewendet';
$string['module_streaming_parameters_start'] = '🔧 Aktivitätskonfiguration wird angewendet...';
$string['module_streaming_schema_done'] = '✅ Inhaltsstruktur bereit';
$string['module_streaming_schema_start'] = '📋 Inhaltsstruktur wird entworfen...';
$string['module_streaming_start'] = '🚀 Start der Aktivitätserstellung...';
$string['no_system_instructions_configured_notice'] = 'Um diesen Kontexttyp zu verwenden, müssen Sie zuerst Systemanweisungen erstellen. Wechseln Sie zur Seite <a href="{$a}">Systemanweisungen verwalten</a>.';
$string['noimages'] = 'Keine Bilder generieren';
$string['nosysteminstructions'] = 'Keine Systemanweisungen gefunden';
$string['planning_chat_placeholder'] = 'Beschreiben Sie die Anpassungen, die Sie an der Kursplanung vornehmen möchten...';
$string['planning_completed'] = 'Planung abgeschlossen';
$string['pluginname'] = 'Kurs-Erstellung mit KI';
$string['privacy:metadata:local_coursegen'] = 'Kurs-Erstellung mit KI speichert personenbezogene Daten zur Unterstützung der KI-gesteuerten Kurs- und Modulerstellung.';
$string['privacy:metadata:local_coursegen_course_context'] = 'Für die Kursplanung gespeicherte Kontextpräferenzen.';
$string['privacy:metadata:local_coursegen_course_context:context_type'] = 'Der ausgewählte Kontexttyp für den Kurs.';
$string['privacy:metadata:local_coursegen_course_context:courseid'] = 'Die ID des Kurses, für den die Kontextpräferenzen gespeichert werden.';
$string['privacy:metadata:local_coursegen_course_context:lang'] = 'Der Sprachcode, den die KI für Antworten und die Generierung von Kursinhalten verwendet.';
$string['privacy:metadata:local_coursegen_course_context:prompt_text'] = 'Der benutzerdefinierte Prompt-Text, der für den Kurs angegeben wurde.';
$string['privacy:metadata:local_coursegen_course_context:system_instruction_id'] = 'Die ausgewählte Systemanweisungs-ID für den Kurs.';
$string['privacy:metadata:local_coursegen_course_context:timecreated'] = 'Zeitpunkt, zu dem der Kurskontext-Datensatz erstellt wurde.';
$string['privacy:metadata:local_coursegen_course_context:timemodified'] = 'Zeitpunkt, zu dem der Kurskontext-Datensatz zuletzt aktualisiert wurde.';
$string['privacy:metadata:local_coursegen_course_context:usermodified'] = 'Die ID des Benutzers, der den Kurskontext zuletzt geändert hat.';
$string['privacy:metadata:local_coursegen_course_data'] = 'Benutzerdefinierte Kursdaten, die für die Integration mit DataCurso gespeichert werden.';
$string['privacy:metadata:local_coursegen_course_data:courseid'] = 'Die ID des Kurses, zu dem diese Daten gehören.';
$string['privacy:metadata:local_coursegen_course_data:custom_checkbox'] = 'Ein benutzerdefinierter Kontrollkästchenwert, der dem Kurs zugeordnet ist.';
$string['privacy:metadata:local_coursegen_course_data:custom_date'] = 'Ein benutzerdefinierter Datumswert, der dem Kurs zugeordnet ist.';
$string['privacy:metadata:local_coursegen_course_data:custom_select'] = 'Ein benutzerdefinierter Auswahlwert, der dem Kurs zugeordnet ist.';
$string['privacy:metadata:local_coursegen_course_data:custom_text'] = 'Ein benutzerdefinierter Kurztextwert, der dem Kurs zugeordnet ist.';
$string['privacy:metadata:local_coursegen_course_data:custom_textarea'] = 'Ein benutzerdefinierter Textfeldwert, der dem Kurs zugeordnet ist.';
$string['privacy:metadata:local_coursegen_course_data:timecreated'] = 'Zeitpunkt, zu dem der Datensatz erstellt wurde.';
$string['privacy:metadata:local_coursegen_course_data:timemodified'] = 'Zeitpunkt, zu dem der Datensatz zuletzt aktualisiert wurde.';
$string['privacy:metadata:local_coursegen_course_sessions'] = 'Kursplanungssitzungen, die über den KI-Dienst erstellt wurden.';
$string['privacy:metadata:local_coursegen_course_sessions:courseid'] = 'Die ID des Kurses, der geplant wird.';
$string['privacy:metadata:local_coursegen_course_sessions:session_id'] = 'Die von dem KI-Dienst zurückgegebene Sitzungskennung.';
$string['privacy:metadata:local_coursegen_course_sessions:status'] = 'Der aktuelle Status der Kursplanungssitzung.';
$string['privacy:metadata:local_coursegen_course_sessions:timecreated'] = 'Zeitpunkt, zu dem die Kursplanungssitzung erstellt wurde.';
$string['privacy:metadata:local_coursegen_course_sessions:timemodified'] = 'Zeitpunkt, zu dem die Kursplanungssitzung zuletzt aktualisiert wurde.';
$string['privacy:metadata:local_coursegen_course_sessions:userid'] = 'Die ID des Benutzers, der die Kursplanungssitzung gestartet hat.';
$string['privacy:metadata:local_coursegen_module_jobs'] = 'Details zu von Benutzern eingereihten KI-Modulerstellungsaufträgen.';
$string['privacy:metadata:local_coursegen_module_jobs:beforemod'] = 'Die Modul-ID, vor der die neue Aktivität eingefügt werden soll.';
$string['privacy:metadata:local_coursegen_module_jobs:context_type'] = 'Der Kontexttyp, der beim Ausführen des Modulauftrags bereitgestellt wurde.';
$string['privacy:metadata:local_coursegen_module_jobs:courseid'] = 'Die ID des Kurses, der mit dem Modulauftrag verknüpft ist.';
$string['privacy:metadata:local_coursegen_module_jobs:generate_images'] = 'Gibt an, ob der Modulauftrag Bilder generiert.';
$string['privacy:metadata:local_coursegen_module_jobs:job_id'] = 'Die vom KI-Dienst zurückgegebene Kennung für den Modulauftrag.';
$string['privacy:metadata:local_coursegen_module_jobs:sectionnum'] = 'Die Kursabschnittsnummer, in der die Aktivität erstellt werden soll.';
$string['privacy:metadata:local_coursegen_module_jobs:status'] = 'Der aktuelle Status des Modulauftrags.';
$string['privacy:metadata:local_coursegen_module_jobs:system_instruction_name'] = 'Der Name der Systemanweisung, die dem KI-Dienst übergeben wurde.';
$string['privacy:metadata:local_coursegen_module_jobs:timecreated'] = 'Zeitpunkt, zu dem der Modulauftrag erstellt wurde.';
$string['privacy:metadata:local_coursegen_module_jobs:timemodified'] = 'Zeitpunkt, zu dem der Modulauftrag zuletzt aktualisiert wurde.';
$string['privacy:metadata:local_coursegen_module_jobs:userid'] = 'Die ID des Benutzers, der den Modulauftrag gestartet hat.';
$string['privacy:metadata:local_coursegen_system_instruction'] = 'Systemanweisungen, die für die Kurserstellung erstellt oder bearbeitet wurden.';
$string['privacy:metadata:local_coursegen_system_instruction:content'] = 'Die gespeicherte Beschreibung der Systemanweisung.';
$string['privacy:metadata:local_coursegen_system_instruction:deleted'] = 'Gibt an, ob die Systemanweisung als gelöscht markiert ist.';
$string['privacy:metadata:local_coursegen_system_instruction:name'] = 'Der Name der Systemanweisung.';
$string['privacy:metadata:local_coursegen_system_instruction:timecreated'] = 'Zeitpunkt, zu dem die Systemanweisung erstellt wurde.';
$string['privacy:metadata:local_coursegen_system_instruction:timemodified'] = 'Zeitpunkt, zu dem die Systemanweisung zuletzt aktualisiert wurde.';
$string['privacy:metadata:local_coursegen_system_instruction:usermodified'] = 'Die ID des Benutzers, der die Systemanweisung zuletzt geändert hat.';
$string['resource_created'] = 'Ressource {$a} erfolgreich erstellt.';
$string['send'] = 'Senden';
$string['syllabus_pdf_field'] = 'Syllabus-PDF hochladen';
$string['syllabus_pdf_field_help'] = 'Laden Sie eine PDF-Datei mit dem Kurssyllabus hoch. Diese wird für die Kontextanalyse an die KI gesendet. Maximale Dateigröße: 10 MB.';
$string['systeminstructioncontent'] = 'Inhalt der Systemanweisung';
$string['systeminstructioncontent_help'] = 'Definieren Sie klare, detaillierte Anweisungen, denen die KI bei der Erstellung von Kursinhalten genau folgen soll, einschließlich Schritte, Einschränkungen, Ton und aller Richtlinien, die sie stets beachten muss.';
$string['systeminstructioncreated'] = 'Erstellt';
$string['systeminstructiondeleted'] = 'Systemanweisung erfolgreich gelöscht';
$string['systeminstructionmodified'] = 'Geändert';
$string['systeminstructionname'] = 'Name der Systemanweisung';
$string['systeminstructionname_help'] = 'Geben Sie den Namen der Systemanweisung ein, die Sie für das Kursdesign verwenden möchten.';
$string['systeminstructionnameexists'] = 'Es existiert bereits eine Systemanweisung mit diesem Namen';
$string['systeminstructionsaved'] = 'Systemanweisung erfolgreich gespeichert';
$string['unauthorized'] = 'Unbefugter Zugriff';
$string['use_system_instruction_field'] = 'Aktivieren, um eine Systemanweisung zu verwenden';
$string['use_system_instruction_field_help'] = 'Aktivieren Sie diese Option, wenn Sie den ausgewählten Kontext (Prompt oder Syllabus) mit einer wiederverwendbaren Systemanweisung ergänzen möchten. Systemanweisungen definieren globale Regeln, die die KI bei der Erstellung von Kursinhalten stets beachten muss.';
$string['yesimages'] = 'Bilder generieren';
