<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_coursegen', language 'fr'
 *
 * @package    local_coursegen
 * @category   string
 * @copyright  2025 Wilber Narvaez <https://datacurso.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_planning_create_course'] = 'Accepter et créer le cours';
$string['actions'] = 'Actions';
$string['addactivityai_arialabel'] = 'Assistant IA pour créer des ressources/activités';
$string['addactivityai_done'] = 'C\'est fait ! La ressource/l\'activité a été créée.';
$string['addactivityai_error'] = 'Une erreur s\'est produite lors de la création de la ressource. Veuillez réessayer ou modifier l\'invite.';
$string['addactivityai_faildefault'] = 'Impossible de créer la ressource.';
$string['addactivityai_label'] = 'Décrivez ce dont vous avez besoin';
$string['addactivityai_modaltitle'] = 'Créer une ressource/activité avec l\'IA';
$string['addactivityai_placeholder'] = 'Décrivez la ressource ou l\'activité que vous souhaitez créer';
$string['addactivityai_welcome'] = 'Bonjour ! Dites-moi quelle ressource ou activité vous souhaitez et je la créerai dans votre cours. 😊';
$string['addactivitywithia'] = 'Ajouter une activité ou ressource avec l\'IA';
$string['addcourseai_arialabel'] = 'Assistant IA pour créer des cours';
$string['addcourseai_done'] = 'C\'est fait ! Le cours a été créé avec succès.';
$string['addcourseai_modaltitle'] = 'Créer un cours avec l\'IA';
$string['addsysteminstruction'] = 'Ajouter une instruction système';
$string['adjust_course_planning'] = 'Ajuster la planification du cours';
$string['adjust_planning_title'] = 'Ajuster la planification du cours';
$string['ai_response_language'] = 'Langue des réponses de l\'IA';
$string['ai_response_language_help'] = 'Sélectionnez la langue dans laquelle l\'IA répondra et générera le contenu du cours.';
$string['click_to_view_details'] = 'Cliquer pour voir les détails';
$string['confirmdeletesysteminstruction'] = 'Êtes-vous sûr de vouloir supprimer cette instruction système ?';
$string['context_type_customprompt'] = 'Invite personnalisée';
$string['context_type_field'] = 'Type de contexte';
$string['context_type_syllabus'] = 'Programme';
$string['context_type_system_instruction'] = 'Instruction système';
$string['course_ai_language'] = 'Langue des réponses de l\'IA';
$string['course_ai_language_help'] = 'Sélectionnez la langue dans laquelle l\'IA répondra et générera le contenu du cours.';
$string['course_created_success'] = 'Cours créé avec succès !';
$string['course_created_success_simple'] = '✅ Cours créé avec succès';
$string['course_creating_subtitle'] = 'Génération du contenu du cours...';
$string['course_creating_title'] = 'Création du cours';
$string['course_generate_images_field'] = 'Images pour le cours';
$string['course_generate_images_field_help'] = 'Choisissez si l\'IA doit générer des images lors de la création du cours (pour les sections, les activités et autres éléments visuels).';
$string['course_planning_started'] = 'La session de planification du cours a démarré avec succès.';
$string['course_streaming_loading'] = 'Chargement...';
$string['course_streaming_planning_subtitle'] = 'Génération du contenu du cours...';
$string['course_streaming_planning_title'] = 'Planification de la création du cours';
$string['coursecreated'] = 'Cours créé avec succès';
$string['coursegen:createactivitywithai'] = 'Créer des activités et ressources avec l\'IA';
$string['coursegen:createcoursewithai'] = 'Créer des cours avec l\'IA';
$string['coursegen:managesysteminstructions'] = 'Gérer les instructions système';
$string['coursegen:view_syllabus'] = 'Afficher le programme';
$string['createwithai'] = 'Créer avec l\'IA';
$string['creating_course'] = 'Création du cours...';
$string['custom_fields_header'] = 'DataCurso';
$string['custom_prompt_field'] = 'Invite pour l\'IA';
$string['custom_prompt_field_help'] = 'Rédigez une invite détaillée que l\'IA utilisera comme contexte principal pour concevoir le cours (objectifs, profil des étudiant·e·s, contenus, niveau, contraintes, etc.).';
$string['custom_system_instruction_select_field'] = 'Instruction système à appliquer';
$string['custom_system_instruction_select_field_help'] = 'Choisissez quelle instruction système sera appliquée avec le contexte sélectionné. Chaque instruction système contient des règles et des lignes directrices prédéfinies (ton, structure, contraintes, etc.) que l\'IA respectera toujours lors de la génération du contenu du cours.';
$string['delete'] = 'Supprimer';
$string['deletesysteminstruction'] = 'Supprimer l\'instruction système';
$string['edit'] = 'Modifier';
$string['editsysteminstruction'] = 'Modifier l\'instruction système';
$string['enter_message'] = 'Saisissez votre message';
$string['error'] = 'Erreur : {$a}';
$string['error_context_type_required'] = 'Veuillez sélectionner un type de contexte pour continuer (Programme ou Invite personnalisée).';
$string['error_creating_course'] = '❌ Erreur lors de la création du cours : {$a}';
$string['error_executing_plan'] = 'Erreur lors de l\'exécution du plan du cours';
$string['error_generating_resource'] = 'Un problème est survenu lors de la génération de la ressource demandée. Veuillez réessayer plus tard.';
$string['error_invalid_resource_type'] = 'Impossible de trouver un type de ressource valide dans la réponse de l\'IA : {$a}. Veuillez réessayer.';
$string['error_label'] = 'Erreur';
$string['error_missing_parameters'] = 'Impossible d\'obtenir les paramètres pour créer le module à partir de la réponse de l\'IA. Veuillez réessayer.';
$string['error_missing_resource_type'] = 'Impossible d\'obtenir le type de ressource à partir de la réponse de l\'IA. Veuillez réessayer.';
$string['error_no_course_id'] = 'Impossible d\'obtenir l\'identifiant du cours';
$string['error_no_session_found'] = 'Aucune session de planification trouvée pour ce cours et cet utilisateur.';
$string['error_no_system_instructions_configured'] = 'Aucune instruction système n\'est configurée. Veuillez d\'abord créer des instructions système dans la page Gérer les instructions système.';
$string['error_prompt_required'] = 'Vous devez fournir une invite lorsque le type de contexte est "Invite personnalisée".';
$string['error_saving_session'] = 'Échec de l\'enregistrement de la session de planification. Veuillez réessayer.';
$string['error_sending_message'] = 'Erreur lors de l\'envoi du message';
$string['error_starting_course_planning'] = 'Une erreur s\'est produite lors du démarrage de la planification du cours. Veuillez réessayer.';
$string['error_syllabus_pdf_required'] = 'Vous devez téléverser un PDF du programme lorsque le type de contexte est "Programme".';
$string['error_system_instruction_required'] = 'Veuillez sélectionner une instruction système lorsque l\'option "Utiliser une instruction système" est activée.';
$string['error_upload_failed'] = 'Échec du téléversement du programme : {$a}';
$string['error_upload_failed_system_instruction'] = 'Échec du téléversement de l\'instruction système : {$a}';
$string['execution_activity_done'] = '✅ Activité terminée ({$a->done}/{$a->total}) — {$a->percent}%';
$string['execution_activity_start'] = '🧩 Démarrage de l\'activité n°{$a->index} (section {$a->section}) : {$a->title}';
$string['execution_error_activity'] = '❌ Erreur dans une activité';
$string['execution_progress'] = '📈 Progression : {$a->done}/{$a->total} ({$a->percent}%)';

$string['generalsettings'] = 'Paramètres généraux';
$string['invalidsysteminstruction'] = 'Instruction système non valide';
$string['managesysteminstructions'] = 'Gérer les instructions système';
$string['message_sent_successfully'] = 'Message envoyé avec succès à la session de planification IA.';
$string['module_creation_subtitle'] = 'Veuillez patienter pendant la génération du contenu';
$string['module_creation_title'] = 'Création du module...';
$string['module_streaming_add_error'] = 'Impossible d\'ajouter l\'activité au cours.';
$string['module_streaming_add_problem'] = 'Un problème est survenu lors de l\'ajout de l\'activité : {$a}';
$string['module_streaming_added_success'] = '✅ Activité ajoutée au cours avec succès !';
$string['module_streaming_complete'] = '🎉 Votre activité a été créée avec succès !';
$string['module_streaming_creation_error'] = '⚠️ Une erreur s\'est produite lors de la création de l\'activité';
$string['module_streaming_images_done'] = '✅ Images générées avec succès';
$string['module_streaming_images_start'] = '🎨 Création d\'images personnalisées...';
$string['module_streaming_output_start'] = '⚙️ Finalisation et préparation de l\'activité...';
$string['module_streaming_parameters_done'] = '✅ Configuration appliquée';
$string['module_streaming_parameters_start'] = '🔧 Application de la configuration de l\'activité...';
$string['module_streaming_schema_done'] = '✅ Structure de contenu prête';
$string['module_streaming_schema_start'] = '📋 Conception de la structure de contenu...';
$string['module_streaming_start'] = '🚀 Démarrage de la création de l\'activité...';
$string['no_system_instructions_configured_notice'] = 'Pour utiliser ce type de contexte, vous devez d\'abord créer des instructions système. Allez à la page <a href="{$a}">Gérer les instructions système</a>.';
$string['noimages'] = 'Ne pas générer d\'images';
$string['nosysteminstructions'] = 'Aucune instruction système trouvée';
$string['planning_chat_placeholder'] = 'Décrivez les ajustements que vous souhaitez apporter à la planification du cours...';
$string['planning_completed'] = 'Planification terminée';
$string['pluginname'] = 'Créateur de cours IA';
$string['privacy:metadata:local_coursegen'] = 'Le Créateur de cours IA stocke des données personnelles pour prendre en charge la génération de cours et de modules pilotée par IA.';
$string['privacy:metadata:local_coursegen_course_context'] = 'Préférences de contexte stockées pour la planification du cours.';
$string['privacy:metadata:local_coursegen_course_context:context_type'] = 'Le type de contexte sélectionné pour le cours.';
$string['privacy:metadata:local_coursegen_course_context:courseid'] = 'L\'identifiant du cours pour lequel les préférences de contexte sont stockées.';
$string['privacy:metadata:local_coursegen_course_context:lang'] = 'Le code de langue utilisé par l\'IA pour répondre et générer le contenu du cours.';
$string['privacy:metadata:local_coursegen_course_context:prompt_text'] = 'Le texte de l\'invite personnalisée fourni pour le cours.';
$string['privacy:metadata:local_coursegen_course_context:system_instruction_id'] = 'L\'identifiant de l\'instruction système sélectionnée pour le cours.';
$string['privacy:metadata:local_coursegen_course_context:timecreated'] = 'La date à laquelle l\'enregistrement de contexte du cours a été créé.';
$string['privacy:metadata:local_coursegen_course_context:timemodified'] = 'La date à laquelle l\'enregistrement de contexte du cours a été mis à jour pour la dernière fois.';
$string['privacy:metadata:local_coursegen_course_context:usermodified'] = 'L\'identifiant de l\'utilisateur qui a modifié pour la dernière fois le contexte du cours.';
$string['privacy:metadata:local_coursegen_course_data'] = 'Données de cours personnalisées stockées pour l\'intégration avec DataCurso.';
$string['privacy:metadata:local_coursegen_course_data:courseid'] = 'L\'identifiant du cours auquel ces données appartiennent.';
$string['privacy:metadata:local_coursegen_course_data:custom_checkbox'] = 'Une valeur de case à cocher personnalisée associée au cours.';
$string['privacy:metadata:local_coursegen_course_data:custom_date'] = 'Une valeur de date personnalisée associée au cours.';
$string['privacy:metadata:local_coursegen_course_data:custom_select'] = 'Une valeur de sélection personnalisée associée au cours.';
$string['privacy:metadata:local_coursegen_course_data:custom_text'] = 'Une valeur de texte court personnalisé associée au cours.';
$string['privacy:metadata:local_coursegen_course_data:custom_textarea'] = 'Une valeur de zone de texte personnalisée associée au cours.';
$string['privacy:metadata:local_coursegen_course_data:timecreated'] = 'La date à laquelle l\'enregistrement a été créé.';
$string['privacy:metadata:local_coursegen_course_data:timemodified'] = 'La date à laquelle l\'enregistrement a été mis à jour pour la dernière fois.';
$string['privacy:metadata:local_coursegen_course_sessions'] = 'Sessions de planification de cours créées via le service IA.';
$string['privacy:metadata:local_coursegen_course_sessions:courseid'] = 'L\'identifiant du cours en cours de planification.';
$string['privacy:metadata:local_coursegen_course_sessions:session_id'] = 'L\'identifiant de session renvoyé par le service IA.';
$string['privacy:metadata:local_coursegen_course_sessions:status'] = 'L\'état actuel de la session de planification du cours.';
$string['privacy:metadata:local_coursegen_course_sessions:timecreated'] = 'La date à laquelle la session de planification du cours a été créée.';
$string['privacy:metadata:local_coursegen_course_sessions:timemodified'] = 'La date à laquelle la session de planification du cours a été mise à jour pour la dernière fois.';
$string['privacy:metadata:local_coursegen_course_sessions:userid'] = 'L\'identifiant de l\'utilisateur qui a lancé la session de planification du cours.';
$string['privacy:metadata:local_coursegen_module_jobs'] = 'Détails des tâches de génération de modules IA mises en file d\'attente par les utilisateurs.';
$string['privacy:metadata:local_coursegen_module_jobs:beforemod'] = 'L\'identifiant du module avant lequel la nouvelle activité doit être insérée.';
$string['privacy:metadata:local_coursegen_module_jobs:context_type'] = 'Le type de contexte fourni lors de l\'exécution de la tâche de module.';
$string['privacy:metadata:local_coursegen_module_jobs:courseid'] = 'L\'identifiant du cours associé à la tâche de module.';
$string['privacy:metadata:local_coursegen_module_jobs:generate_images'] = 'Indique si la tâche de module générera des images.';
$string['privacy:metadata:local_coursegen_module_jobs:job_id'] = 'L\'identifiant renvoyé par le service IA pour la tâche de module.';
$string['privacy:metadata:local_coursegen_module_jobs:sectionnum'] = 'Le numéro de section du cours où l\'activité doit être créée.';
$string['privacy:metadata:local_coursegen_module_jobs:status'] = 'L\'état actuel de la tâche de module.';
$string['privacy:metadata:local_coursegen_module_jobs:system_instruction_name'] = 'Le nom de l\'instruction système fourni au service IA.';
$string['privacy:metadata:local_coursegen_module_jobs:timecreated'] = 'La date à laquelle la tâche de module a été créée.';
$string['privacy:metadata:local_coursegen_module_jobs:timemodified'] = 'La date à laquelle la tâche de module a été mise à jour pour la dernière fois.';
$string['privacy:metadata:local_coursegen_module_jobs:userid'] = 'L\'identifiant de l\'utilisateur qui a lancé la tâche de module.';
$string['privacy:metadata:local_coursegen_system_instruction'] = 'Instructions système créées ou modifiées pour la génération de cours.';
$string['privacy:metadata:local_coursegen_system_instruction:content'] = 'La description enregistrée de l\'instruction système.';
$string['privacy:metadata:local_coursegen_system_instruction:deleted'] = 'Indique si l\'instruction système est marquée comme supprimée.';
$string['privacy:metadata:local_coursegen_system_instruction:name'] = 'Le nom de l\'instruction système.';
$string['privacy:metadata:local_coursegen_system_instruction:timecreated'] = 'La date à laquelle l\'instruction système a été créée.';
$string['privacy:metadata:local_coursegen_system_instruction:timemodified'] = 'La date à laquelle l\'instruction système a été mise à jour pour la dernière fois.';
$string['privacy:metadata:local_coursegen_system_instruction:usermodified'] = 'L\'identifiant de l\'utilisateur qui a modifié pour la dernière fois l\'instruction système.';
$string['resource_created'] = 'Ressource {$a} créée avec succès.';
$string['send'] = 'Envoyer';
$string['syllabus_pdf_field'] = 'Téléverser le PDF du programme';
$string['syllabus_pdf_field_help'] = 'Téléversez un fichier PDF contenant le programme du cours. Il sera envoyé à l\'IA pour analyse de contexte. Taille maximale du fichier : 10 Mo.';
$string['systeminstructioncontent'] = 'Contenu de l\'instruction système';
$string['systeminstructioncontent_help'] = 'Définissez des instructions claires et détaillées que l\'IA doit suivre précisément lors de la génération de contenu de cours, y compris les étapes, les contraintes, le ton et toute directive qu\'elle doit toujours respecter.';
$string['systeminstructioncreated'] = 'Créée';
$string['systeminstructiondeleted'] = 'Instruction système supprimée avec succès';
$string['systeminstructionmodified'] = 'Modifiée';
$string['systeminstructionname'] = 'Nom de l\'instruction système';
$string['systeminstructionname_help'] = 'Saisissez le nom de l\'instruction système que vous utiliserez pour la conception du cours.';
$string['systeminstructionnameexists'] = 'Une instruction système portant ce nom existe déjà';
$string['systeminstructionsaved'] = 'Instruction système enregistrée avec succès';
$string['unauthorized'] = 'Accès non autorisé';
$string['use_system_instruction_field'] = 'Activer pour utiliser une instruction système';
$string['use_system_instruction_field_help'] = 'Activez cette option lorsque vous souhaitez compléter le contexte sélectionné (invite ou programme) par une instruction système réutilisable. Les instructions système définissent des règles globales que l\'IA doit toujours respecter lors de la génération de contenu de cours.';
$string['yesimages'] = 'Générer des images';
