define("local_coursegen/course_streaming",["exports","local_coursegen/repository/chatbot","core/str"],(function(_exports,_chatbot,_str){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.startStreaming=_exports.startExecutionStreaming=void 0;
/**
   * Course Streaming Module for handling real-time course generation
   *
   * @module     local_coursegen/course_streaming
   * @copyright  2025 Wilber Narvaez <https://datacurso.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
let userHasScrolled=!1,scrollTimeout=null;const setupScrollDetection=scrollContainer=>{if(!scrollContainer)return;scrollContainer.addEventListener("scroll",(()=>{var element;scrollTimeout&&clearTimeout(scrollTimeout),userHasScrolled=!0,(element=scrollContainer).scrollTop+element.clientHeight>=element.scrollHeight-50&&(scrollTimeout=setTimeout((()=>{userHasScrolled=!1}),1e3))}),{passive:!0})};_exports.startStreaming=async function(streamingUrl,container){let isCorrection=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const progressIndicator=container.querySelector("[data-region='local_coursegen/course_streaming/progress']"),eventList=container.querySelector("[data-region='local_coursegen/course_streaming']"),progressIcon=container.querySelector("[data-region='local_coursegen/course_streaming/progress/icon']");let htmlBuffer="",rafPending=!1;isCorrection||(eventList.innerHTML=""),progressIndicator&&(progressIndicator.style.display="block"),userHasScrolled=!1,scrollTimeout&&(clearTimeout(scrollTimeout),scrollTimeout=null);const modalBody=document.querySelector(".modal-body");modalBody&&setupScrollDetection(modalBody);const acceptBtn=document.getElementById("accept-planning-btn"),adjustBtn=document.getElementById("adjust-planning-btn");acceptBtn&&(acceptBtn.disabled=!0),adjustBtn&&(adjustBtn.disabled=!0);const updateHtmlSoon=container=>{rafPending||(rafPending=!0,requestAnimationFrame((()=>{if(rafPending=!1,container.innerHTML=htmlBuffer,!userHasScrolled){const modalBody=document.querySelector(".modal-body");modalBody?modalBody.scrollTop=modalBody.scrollHeight:container.scrollTop=container.scrollHeight}})))},appendToken=(token,container)=>{htmlBuffer+=token,updateHtmlSoon(container)},evtSource=new EventSource(streamingUrl);evtSource.addEventListener("assistant_token",(event=>{appendToken(event.data,eventList)})),evtSource.addEventListener("assistant_message_end",(()=>{progressIcon.innerHTML='\n        <div class="bg-success rounded-circle d-flex align-items-center justify-content-center"\n              style="width: 1.5rem; height: 1.5rem;">\n          <i class="text-white" style="font-size: 0.8rem;">✓</i>\n        </div>\n      ';const planningActions=document.getElementById("course-planning-actions");planningActions&&(planningActions.style.display="block");const acceptBtn=document.getElementById("accept-planning-btn"),adjustBtn=document.getElementById("adjust-planning-btn");acceptBtn&&(acceptBtn.disabled=!1),adjustBtn&&(adjustBtn.disabled=!1),evtSource.close()}))};const parseBest=raw=>{if(!raw)return null;const s=String(raw).trim();try{return JSON.parse(s)}catch(_){}try{let t=s.replace(/'/g,'"').replace(/\bNone\b/g,"null").replace(/\bTrue\b/g,"true").replace(/\bFalse\b/g,"false");return JSON.parse(t)}catch(_){return null}},addStatus=(message,type,container)=>{const statusDiv=document.createElement("div");if(statusDiv.className="alert alert-".concat({success:"success",error:"danger",info:"info"}[type]||"info"," mb-2"),statusDiv.innerHTML="<small>".concat(message,"</small>"),container.appendChild(statusDiv),!userHasScrolled){const modalBody=document.querySelector(".modal-body");modalBody?modalBody.scrollTop=modalBody.scrollHeight:container.scrollTop=container.scrollHeight}};_exports.startExecutionStreaming=async(streamingUrl,container,courseid)=>{const progressIndicator=container.querySelector("[data-region='local_coursegen/course_streaming/progress']"),eventList=container.querySelector("[data-region='local_coursegen/course_streaming']"),progressIcon=container.querySelector("[data-region='local_coursegen/course_streaming/progress/icon']");eventList.innerHTML="",progressIndicator&&(progressIndicator.style.display="block"),userHasScrolled=!1,scrollTimeout&&(clearTimeout(scrollTimeout),scrollTimeout=null);const modalBody=document.querySelector(".modal-body");modalBody&&setupScrollDetection(modalBody);const es=new EventSource(streamingUrl);es.addEventListener("execution_activity_start",(async e=>{var _obj$index,_obj$section_index;const obj=parseBest(e.data)||{},idx=null!==(_obj$index=obj.index)&&void 0!==_obj$index?_obj$index:"?",title=obj.title||"",sec=null!==(_obj$section_index=obj.section_index)&&void 0!==_obj$section_index?_obj$section_index:"?",msg=await(0,_str.get_string)("execution_activity_start","local_coursegen",{index:idx,section:sec,title:title});addStatus(msg,"info",eventList)})),es.addEventListener("execution_activity_done",(async e=>{var _obj$done,_obj$total,_obj$percent;const obj=parseBest(e.data)||{},done=null!==(_obj$done=obj.done)&&void 0!==_obj$done?_obj$done:0,total=null!==(_obj$total=obj.total)&&void 0!==_obj$total?_obj$total:0,percent=null!==(_obj$percent=obj.percent)&&void 0!==_obj$percent?_obj$percent:0,msg=await(0,_str.get_string)("execution_activity_done","local_coursegen",{done:done,total:total,percent:percent});addStatus(msg,"ok",eventList)})),es.addEventListener("execution_progress",(async e=>{var _obj$done2,_obj$total2,_obj$percent2;const obj=parseBest(e.data)||{},done=null!==(_obj$done2=obj.done)&&void 0!==_obj$done2?_obj$done2:0,total=null!==(_obj$total2=obj.total)&&void 0!==_obj$total2?_obj$total2:0,percent=null!==(_obj$percent2=obj.percent)&&void 0!==_obj$percent2?_obj$percent2:0,msg=await(0,_str.get_string)("execution_progress","local_coursegen",{done:done,total:total,percent:percent});addStatus(msg,"info",eventList)})),es.addEventListener("execution_error",(async()=>{const msg=await(0,_str.get_string)("execution_error_activity","local_coursegen");addStatus(msg,"error",eventList)})),es.addEventListener("execution_complete",(async()=>{es.close(),progressIcon.innerHTML='\n        <div class="bg-success rounded-circle d-flex align-items-center justify-content-center"\n              style="width: 1.5rem; height: 1.5rem;">\n          <i class="text-white" style="font-size: 0.8rem;">✓</i>\n        </div>\n      ';try{const result=await(0,_chatbot.createCourse)({courseid:courseid});if(result.success){const okmsg=await(0,_str.get_string)("course_created_success_simple","local_coursegen");addStatus(okmsg,"ok",eventList),setTimeout((()=>{window.location.reload()}),500)}else{const errmsg=await(0,_str.get_string)("error_creating_course","local_coursegen",result.message||"");addStatus(errmsg,"error",eventList)}}catch(error){const errmsg=await(0,_str.get_string)("error_creating_course","local_coursegen",error.message||"");addStatus(errmsg,"error",eventList)}}))}}));

//# sourceMappingURL=course_streaming.min.js.map