<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_coursegen', language 'es'
 *
 * @package    local_coursegen
 * @category   string
 * @copyright  2025 Wilber Narvaez <https://datacurso.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_planning_create_course'] = 'Aceptar y crear curso';
$string['actions'] = 'Acciones';
$string['addactivityai_arialabel'] = 'Asistente de IA para crear recursos/actividades';
$string['addactivityai_done'] = '¡Listo! El recurso/actividad ha sido creado.';
$string['addactivityai_error'] = 'Se ha producido un error al crear el recurso. Por favor, inténtalo de nuevo o modifica el mensaje.';
$string['addactivityai_faildefault'] = 'No ha sido posible crear el recurso.';
$string['addactivityai_label'] = 'Describe lo que necesitas';
$string['addactivityai_modaltitle'] = 'Crear recurso/actividad con IA';
$string['addactivityai_placeholder'] = 'Describe qué recurso o actividad quieres crear';
$string['addactivityai_welcome'] = '¡Hola! Dime qué recurso o actividad necesitas y lo crearé en tu curso. 😊';
$string['addactivitywithia'] = 'Añadir actividad o recurso con IA';
$string['addcourseai_arialabel'] = 'Asistente de IA para crear cursos';
$string['addcourseai_done'] = '¡Listo! El curso se ha creado correctamente.';
$string['addcourseai_modaltitle'] = 'Crear curso con IA';
$string['addsysteminstruction'] = 'Añadir instrucción del sistema';
$string['adjust_course_planning'] = 'Ajustar planificación del curso';
$string['adjust_planning_title'] = 'Ajustar la planificación del curso';
$string['ai_response_language'] = 'Idioma de respuesta de la IA';
$string['ai_response_language_help'] = 'Selecciona el idioma en el que la IA responderá y generará el contenido del curso.';
$string['click_to_view_details'] = 'Haz clic para ver los detalles';
$string['confirmdeletesysteminstruction'] = '¿Seguro que quieres eliminar esta instrucción del sistema?';
$string['context_type_customprompt'] = 'Prompt personalizado';
$string['context_type_field'] = 'Tipo de contexto';
$string['context_type_syllabus'] = 'Silabo';
$string['context_type_system_instruction'] = 'Instrucción del sistema';
$string['course_ai_language'] = 'Idioma de respuesta de la IA';
$string['course_ai_language_help'] = 'Selecciona el idioma en el que la IA responderá y generará el contenido del curso.';
$string['course_created_success'] = '¡Curso creado correctamente!';
$string['course_created_success_simple'] = '✅ Curso creado correctamente';
$string['course_creating_subtitle'] = 'Generando el contenido del curso...';
$string['course_creating_title'] = 'Creando el curso';
$string['course_generate_images_field'] = 'Imágenes para el curso';
$string['course_generate_images_field_help'] = 'Elige si la IA debe generar imágenes al crear el curso (para secciones, actividades y otros elementos visuales).';
$string['course_planning_started'] = 'La sesión de planificación del curso se ha iniciado correctamente.';
$string['course_streaming_loading'] = 'Cargando...';
$string['course_streaming_planning_subtitle'] = 'Generando el contenido del curso...';
$string['course_streaming_planning_title'] = 'Planificando la creación del curso';
$string['coursecreated'] = 'Curso creado correctamente';
$string['coursegen:createactivitywithai'] = 'Crear actividades y recursos con IA';
$string['coursegen:createcoursewithai'] = 'Crear cursos con IA';
$string['coursegen:managesysteminstructions'] = 'Gestionar instrucciones del sistema';
$string['coursegen:view_syllabus'] = 'Ver silabo';
$string['createwithai'] = 'Crear con IA';
$string['creating_course'] = 'Creando curso...';
$string['custom_fields_header'] = 'DataCurso';
$string['custom_prompt_field'] = 'Prompt para la IA';
$string['custom_prompt_field_help'] = 'Escribe un prompt detallado que la IA usará como contexto principal para diseñar el curso (objetivos, perfil de estudiantes, contenidos, nivel, restricciones, etc.).';
$string['custom_system_instruction_select_field'] = 'Instrucción del sistema a aplicar';
$string['custom_system_instruction_select_field_help'] = 'Elige qué instrucción del sistema se aplicará junto con el contexto seleccionado. Cada instrucción del sistema contiene reglas y directrices predefinidas (tono, estructura, restricciones, etc.) que la IA respetará siempre al generar contenido del curso.';
$string['datacurso_service_url'] = 'URL del servicio de DataCurso';
$string['datacurso_service_url_desc'] = 'URL por defecto del servicio de IA de DataCurso (región estándar).';
$string['datacurso_service_url_eu'] = 'URL del servicio de DataCurso (UE)';
$string['datacurso_service_url_eu_desc'] = 'URL por defecto del servicio de IA de DataCurso alojado en la región UE (compatible con RGPD).';
$string['delete'] = 'Eliminar';
$string['deletesysteminstruction'] = 'Eliminar instrucción del sistema';
$string['edit'] = 'Editar';
$string['editsysteminstruction'] = 'Editar instrucción del sistema';
$string['enter_message'] = 'Escribe tu mensaje';
$string['error'] = 'Error: {$a}';
$string['error_context_type_required'] = 'Selecciona un tipo de contexto para continuar (Silabo o Prompt personalizado).';
$string['error_creating_course'] = '❌ Error al crear el curso: {$a}';
$string['error_executing_plan'] = 'Error al ejecutar el plan del curso';
$string['error_generating_resource'] = 'Hubo un problema al generar el recurso solicitado. Por favor, inténtalo de nuevo más tarde.';
$string['error_invalid_resource_type'] = 'No se ha podido encontrar un tipo de recurso válido en la respuesta de la IA: {$a}. Por favor, inténtalo de nuevo.';
$string['error_label'] = 'Error';
$string['error_missing_parameters'] = 'No se han podido obtener los parámetros para crear el módulo a partir de la respuesta de la IA. Por favor, inténtalo de nuevo.';
$string['error_missing_resource_type'] = 'No se ha podido obtener el tipo de recurso a partir de la respuesta de la IA. Por favor, inténtalo de nuevo.';
$string['error_no_course_id'] = 'No se ha podido obtener el ID del curso';
$string['error_no_session_found'] = 'No se ha encontrado ninguna sesión de planificación para este curso y usuario.';
$string['error_no_system_instructions_configured'] = 'No hay instrucciones del sistema configuradas. Por favor, crea primero instrucciones del sistema en la página Gestionar instrucciones del sistema.';
$string['error_processing_request'] = 'Error al procesar tu solicitud';
$string['error_prompt_required'] = 'Debes proporcionar un prompt cuando el tipo de contexto es "Prompt personalizado".';
$string['error_saving_session'] = 'No se ha podido guardar la sesión de planificación. Por favor, inténtalo de nuevo.';
$string['error_sending_message'] = 'Error al enviar el mensaje';
$string['error_starting_course_planning'] = 'Se ha producido un error al iniciar la planificación del curso. Por favor, inténtalo de nuevo';
$string['error_syllabus_pdf_required'] = 'Debes subir un archivo PDF del silabo cuando el tipo de contexto es "Silabo".';
$string['error_system_instruction_required'] = 'Selecciona una instrucción del sistema cuando la opción "Usar instrucción del sistema" esté activada.';
$string['error_upload_failed'] = 'Error al subir el silabo: {$a}';
$string['error_upload_failed_system_instruction'] = 'Error al subir la instrucción del sistema: {$a}';
$string['execution_activity_done'] = '✅ Actividad completada ({$a->done}/{$a->total}) — {$a->percent}%';
$string['execution_activity_start'] = '🧩 Iniciando actividad #{$a->index} (sección {$a->section}): {$a->title}';
$string['execution_error_activity'] = '❌ Error en una actividad';
$string['execution_progress'] = '📈 Progreso: {$a->done}/{$a->total} ({$a->percent}%)';

$string['generalsettings'] = 'Ajustes generales';
$string['invalidsysteminstruction'] = 'Instrucción del sistema no válida';
$string['managesysteminstructions'] = 'Gestionar instrucciones del sistema';
$string['message_sent_successfully'] = 'Mensaje enviado correctamente a la sesión de planificación con IA.';
$string['module_creation_subtitle'] = 'Por favor, espera mientras se genera el contenido';
$string['module_creation_title'] = 'Creando módulo...';
$string['module_streaming_add_error'] = 'No se pudo añadir la actividad al curso.';
$string['module_streaming_add_problem'] = 'Hubo un problema al añadir la actividad: {$a}';
$string['module_streaming_added_success'] = '✅ ¡Actividad añadida correctamente al curso!';
$string['module_streaming_complete'] = '🎉 ¡Tu actividad se ha creado correctamente!';
$string['module_streaming_creation_error'] = '⚠️ Se ha producido un error durante la creación de la actividad';
$string['module_streaming_images_done'] = '✅ Imágenes generadas correctamente';
$string['module_streaming_images_start'] = '🎨 Creando imágenes personalizadas...';
$string['module_streaming_output_start'] = '⚙️ Finalizando y preparando la actividad...';
$string['module_streaming_parameters_done'] = '✅ Configuración aplicada';
$string['module_streaming_parameters_start'] = '🔧 Aplicando la configuración de la actividad...';
$string['module_streaming_schema_done'] = '✅ Estructura de contenido lista';
$string['module_streaming_schema_start'] = '📋 Diseñando la estructura del contenido...';
$string['module_streaming_start'] = '🚀 Iniciando la creación de la actividad...';
$string['no_system_instructions_configured_notice'] = 'Para usar este tipo de contexto, primero debes crear instrucciones del sistema. Ve a la página <a href="{$a}">Gestionar instrucciones del sistema</a>.';
$string['noimages'] = 'No generar imágenes';
$string['nosysteminstructions'] = 'No se encontraron instrucciones del sistema';
$string['planning_chat_placeholder'] = 'Describe los ajustes que quieres hacer en la planificación del curso...';
$string['planning_completed'] = 'Planificación completada';
$string['pluginname'] = 'Creador de cursos con IA';
$string['privacy:metadata:local_coursegen'] = 'Creador de cursos con IA almacena datos personales para admitir la generación de cursos y módulos mediante IA.';
$string['privacy:metadata:local_coursegen_course_context'] = 'Preferencias de contexto almacenadas para la planificación del curso.';
$string['privacy:metadata:local_coursegen_course_context:context_type'] = 'El tipo de contexto seleccionado para el curso.';
$string['privacy:metadata:local_coursegen_course_context:courseid'] = 'El ID del curso para el que se almacenan las preferencias de contexto.';
$string['privacy:metadata:local_coursegen_course_context:lang'] = 'El código de idioma que usa la IA para responder y generar el contenido del curso.';
$string['privacy:metadata:local_coursegen_course_context:prompt_text'] = 'El texto del prompt personalizado proporcionado para el curso.';
$string['privacy:metadata:local_coursegen_course_context:system_instruction_id'] = 'El ID de la instrucción del sistema seleccionada para el curso.';
$string['privacy:metadata:local_coursegen_course_context:timecreated'] = 'La hora en que se creó el registro de contexto del curso.';
$string['privacy:metadata:local_coursegen_course_context:timemodified'] = 'La hora en que se actualizó por última vez el registro de contexto del curso.';
$string['privacy:metadata:local_coursegen_course_context:usermodified'] = 'El ID del usuario que modificó por última vez el contexto del curso.';
$string['privacy:metadata:local_coursegen_course_data'] = 'Datos de curso personalizados almacenados para la integración con DataCurso.';
$string['privacy:metadata:local_coursegen_course_data:courseid'] = 'El ID del curso al que pertenecen estos datos.';
$string['privacy:metadata:local_coursegen_course_data:custom_checkbox'] = 'Un valor de casilla personalizada asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_date'] = 'Un valor de fecha personalizada asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_select'] = 'Un valor de selección personalizada asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_text'] = 'Un valor de texto corto personalizado asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_textarea'] = 'Un valor de área de texto personalizada asociado al curso.';
$string['privacy:metadata:local_coursegen_course_data:timecreated'] = 'La hora en que se creó el registro.';
$string['privacy:metadata:local_coursegen_course_data:timemodified'] = 'La hora en que el registro se actualizó por última vez.';
$string['privacy:metadata:local_coursegen_course_sessions'] = 'Sesiones de planificación de curso creadas mediante el servicio de IA.';
$string['privacy:metadata:local_coursegen_course_sessions:courseid'] = 'El ID del curso que se está planificando.';
$string['privacy:metadata:local_coursegen_course_sessions:session_id'] = 'El identificador de sesión devuelto por el servicio de IA.';
$string['privacy:metadata:local_coursegen_course_sessions:status'] = 'El estado actual de la sesión de planificación del curso.';
$string['privacy:metadata:local_coursegen_course_sessions:timecreated'] = 'La hora en que se creó la sesión de planificación del curso.';
$string['privacy:metadata:local_coursegen_course_sessions:timemodified'] = 'La hora en que la sesión de planificación del curso se actualizó por última vez.';
$string['privacy:metadata:local_coursegen_course_sessions:userid'] = 'El ID del usuario que inició la sesión de planificación del curso.';
$string['privacy:metadata:local_coursegen_module_jobs'] = 'Detalles de los trabajos de generación de módulos con IA encolados por los usuarios.';
$string['privacy:metadata:local_coursegen_module_jobs:beforemod'] = 'El ID del módulo antes del cual se debe insertar la nueva actividad.';
$string['privacy:metadata:local_coursegen_module_jobs:context_type'] = 'El tipo de contexto proporcionado al ejecutar el trabajo del módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:courseid'] = 'El ID del curso asociado con el trabajo del módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:generate_images'] = 'Indica si el trabajo del módulo generará imágenes.';
$string['privacy:metadata:local_coursegen_module_jobs:job_id'] = 'El identificador devuelto por el servicio de IA para el trabajo del módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:sectionnum'] = 'El número de la sección del curso donde se debe crear la actividad.';
$string['privacy:metadata:local_coursegen_module_jobs:status'] = 'El estado actual del trabajo del módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:system_instruction_name'] = 'El nombre de la instrucción del sistema proporcionado al servicio de IA.';
$string['privacy:metadata:local_coursegen_module_jobs:timecreated'] = 'La hora en que se creó el trabajo del módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:timemodified'] = 'La hora en que el trabajo del módulo se actualizó por última vez.';
$string['privacy:metadata:local_coursegen_module_jobs:userid'] = 'El ID del usuario que inició el trabajo del módulo.';
$string['privacy:metadata:local_coursegen_system_instruction'] = 'Instrucciones del sistema creadas o editadas para la generación de cursos.';
$string['privacy:metadata:local_coursegen_system_instruction:content'] = 'La descripción almacenada de la instrucción del sistema.';
$string['privacy:metadata:local_coursegen_system_instruction:deleted'] = 'Indica si la instrucción del sistema está marcada como eliminada.';
$string['privacy:metadata:local_coursegen_system_instruction:name'] = 'El nombre de la instrucción del sistema.';
$string['privacy:metadata:local_coursegen_system_instruction:timecreated'] = 'La hora en que se creó la instrucción del sistema.';
$string['privacy:metadata:local_coursegen_system_instruction:timemodified'] = 'La hora en que la instrucción del sistema se actualizó por última vez.';
$string['privacy:metadata:local_coursegen_system_instruction:usermodified'] = 'El ID del usuario que modificó por última vez la instrucción del sistema.';
$string['resource_created'] = 'Recurso {$a} creado correctamente.';
$string['send'] = 'Enviar';
$string['syllabus_pdf_field'] = 'Subir PDF del silabo';
$string['syllabus_pdf_field_help'] = 'Sube un archivo PDF que contenga el silabo del curso. Se enviará a la IA para el análisis de contexto. Tamaño máximo del archivo: 10 MB.';
$string['systeminstructioncontent'] = 'Contenido de la instrucción del sistema';
$string['systeminstructioncontent_help'] = 'Define instrucciones claras y detalladas que la IA deba seguir al pie de la letra al generar contenido del curso, incluyendo pasos, restricciones, tono y cualquier directriz que siempre deba respetar.';
$string['systeminstructioncreated'] = 'Creado';
$string['systeminstructiondeleted'] = 'Instrucción del sistema eliminada correctamente';
$string['systeminstructionmodified'] = 'Modificado';
$string['systeminstructionname'] = 'Nombre de la instrucción del sistema';
$string['systeminstructionname_help'] = 'Introduce el nombre de la instrucción del sistema que usarás para el diseño del curso.';
$string['systeminstructionnameexists'] = 'Ya existe una instrucción del sistema con este nombre';
$string['systeminstructionsaved'] = 'Instrucción del sistema guardada correctamente';
$string['unauthorized'] = 'Acceso no autorizado';
$string['use_system_instruction_field'] = 'Activar para usar una instrucción del sistema';
$string['use_system_instruction_field_help'] = 'Activa esta opción cuando quieras complementar el contexto seleccionado (prompt o silabo) con una instrucción del sistema reutilizable. Las instrucciones del sistema definen reglas globales que la IA debe seguir siempre al generar contenido del curso.';
$string['yesimages'] = 'Generar imágenes';
