<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_coursegen', language 'pt'
 *
 * @package    local_coursegen
 * @category   string
 * @copyright  2025 Wilber Narvaez <https://datacurso.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_planning_create_course'] = 'Aceitar e criar curso';
$string['actions'] = 'Ações';
$string['addactivityai_arialabel'] = 'Assistente de IA para criar recursos/atividades';
$string['addactivityai_done'] = 'Pronto! O recurso/atividade foi criado.';
$string['addactivityai_error'] = 'Ocorreu um erro ao criar o recurso. Por favor, tente novamente ou modifique o prompt.';
$string['addactivityai_faildefault'] = 'Não foi possível criar o recurso.';
$string['addactivityai_label'] = 'Descreva o que você precisa';
$string['addactivityai_modaltitle'] = 'Criar recurso/atividade com IA';
$string['addactivityai_placeholder'] = 'Descreva qual recurso ou atividade você deseja criar';
$string['addactivityai_welcome'] = 'Olá! Diga-me qual recurso ou atividade você precisa e eu o criarei no seu curso. 😊';
$string['addactivitywithia'] = 'Adicionar atividade ou recurso com IA';
$string['addcourseai_arialabel'] = 'Assistente de IA para criar cursos';
$string['addcourseai_done'] = 'Pronto! O curso foi criado com sucesso.';
$string['addcourseai_modaltitle'] = 'Criar curso com IA';
$string['addsysteminstruction'] = 'Adicionar instrução de sistema';
$string['adjust_course_planning'] = 'Ajustar planejamento do curso';
$string['adjust_planning_title'] = 'Ajustar o planejamento do curso';
$string['ai_response_language'] = 'Idioma das respostas da IA';
$string['ai_response_language_help'] = 'Selecione o idioma em que a IA responderá e gerará o conteúdo do curso.';
$string['click_to_view_details'] = 'Clique para ver os detalhes';
$string['confirmdeletesysteminstruction'] = 'Tem certeza de que deseja excluir esta instrução de sistema?';
$string['context_type_customprompt'] = 'Prompt personalizado';
$string['context_type_field'] = 'Tipo de contexto';
$string['context_type_syllabus'] = 'Plano de ensino';
$string['context_type_system_instruction'] = 'Instrução de sistema';
$string['course_ai_language'] = 'Idioma das respostas da IA';
$string['course_ai_language_help'] = 'Selecione o idioma em que a IA responderá e gerará o conteúdo do curso.';
$string['course_created_success'] = 'Curso criado com sucesso!';
$string['course_created_success_simple'] = '✅ Curso criado com sucesso';
$string['course_creating_subtitle'] = 'Gerando conteúdo do curso...';
$string['course_creating_title'] = 'Criando o curso';
$string['course_generate_images_field'] = 'Imagens para o curso';
$string['course_generate_images_field_help'] = 'Escolha se a IA deve gerar imagens ao criar o curso (para seções, atividades e outros elementos visuais).';
$string['course_planning_started'] = 'Sessão de planejamento do curso iniciada com sucesso.';
$string['course_streaming_loading'] = 'Carregando...';
$string['course_streaming_planning_subtitle'] = 'Gerando conteúdo do curso...';
$string['course_streaming_planning_title'] = 'Planejando a criação do curso';
$string['coursecreated'] = 'Curso criado com sucesso';
$string['coursegen:createactivitywithai'] = 'Criar atividades e recursos com IA';
$string['coursegen:createcoursewithai'] = 'Criar cursos com IA';
$string['coursegen:managesysteminstructions'] = 'Gerenciar instruções de sistema';
$string['coursegen:view_syllabus'] = 'Ver plano de ensino';
$string['createwithai'] = 'Criar com IA';
$string['creating_course'] = 'Criando curso...';
$string['custom_fields_header'] = 'DataCurso';
$string['custom_prompt_field'] = 'Prompt para IA';
$string['custom_prompt_field_help'] = 'Escreva um prompt detalhado que a IA usará como contexto principal para desenhar o curso (objetivos, perfil dos estudantes, conteúdos, nível, restrições, etc.).';
$string['custom_system_instruction_select_field'] = 'Instrução de sistema a aplicar';
$string['custom_system_instruction_select_field_help'] = 'Escolha qual instrução de sistema será aplicada juntamente com o contexto selecionado. Cada instrução de sistema contém regras e diretrizes predefinidas (tom, estrutura, restrições, etc.) que a IA sempre respeitará ao gerar conteúdo do curso.';
$string['datacurso_service_url'] = 'URL do serviço DataCurso';
$string['datacurso_service_url_desc'] = 'URL padrão do serviço de IA DataCurso (região padrão).';
$string['datacurso_service_url_eu'] = 'URL do serviço DataCurso (UE)';
$string['datacurso_service_url_eu_desc'] = 'URL padrão do serviço de IA DataCurso hospedado na região da UE (compatível com RGPD).';
$string['delete'] = 'Excluir';
$string['deletesysteminstruction'] = 'Excluir instrução de sistema';
$string['edit'] = 'Editar';
$string['editsysteminstruction'] = 'Editar instrução de sistema';
$string['enter_message'] = 'Digite sua mensagem';
$string['error'] = 'Erro: {$a}';
$string['error_context_type_required'] = 'Selecione um tipo de contexto para continuar (Plano de ensino ou Prompt personalizado).';
$string['error_creating_course'] = '❌ Erro ao criar o curso: {$a}';
$string['error_executing_plan'] = 'Erro ao executar o plano do curso';
$string['error_generating_resource'] = 'Ocorreu um problema ao gerar o recurso solicitado. Por favor, tente novamente mais tarde.';
$string['error_invalid_resource_type'] = 'Não foi possível encontrar um tipo de recurso válido na resposta da IA: {$a}. Por favor, tente novamente.';
$string['error_label'] = 'Erro';
$string['error_missing_parameters'] = 'Não foi possível obter os parâmetros para criar o módulo a partir da resposta da IA. Por favor, tente novamente.';
$string['error_missing_resource_type'] = 'Não foi possível obter o tipo de recurso a partir da resposta da IA. Por favor, tente novamente.';
$string['error_no_course_id'] = 'Não foi possível obter o ID do curso';
$string['error_no_session_found'] = 'Nenhuma sessão de planejamento encontrada para este curso e usuário.';
$string['error_no_system_instructions_configured'] = 'Não há instruções de sistema configuradas. Por favor, crie instruções de sistema primeiro na página Gerenciar instruções de sistema.';
$string['error_processing_request'] = 'Erro ao processar sua solicitação';
$string['error_prompt_required'] = 'Você deve fornecer um prompt quando o tipo de contexto for "Prompt personalizado".';
$string['error_saving_session'] = 'Falha ao salvar a sessão de planejamento. Por favor, tente novamente.';
$string['error_sending_message'] = 'Erro ao enviar a mensagem';
$string['error_starting_course_planning'] = 'Ocorreu um erro ao iniciar o planejamento do curso. Por favor, tente novamente.';
$string['error_syllabus_pdf_required'] = 'Você deve enviar um PDF do plano de ensino quando o tipo de contexto for "Plano de ensino".';
$string['error_system_instruction_required'] = 'Selecione uma instrução de sistema quando a opção "Usar instrução de sistema" estiver ativada.';
$string['error_upload_failed'] = 'Falha ao enviar o plano de ensino: {$a}';
$string['error_upload_failed_system_instruction'] = 'Falha ao enviar a instrução de sistema: {$a}';
$string['execution_activity_done'] = '✅ Atividade concluída ({$a->done}/{$a->total}) — {$a->percent}%';
$string['execution_activity_start'] = '🧩 Iniciando atividade #{$a->index} (seção {$a->section}): {$a->title}';
$string['execution_error_activity'] = '❌ Erro em uma atividade';
$string['execution_progress'] = '📈 Progresso: {$a->done}/{$a->total} ({$a->percent}%)';

$string['generalsettings'] = 'Configurações gerais';
$string['invalidsysteminstruction'] = 'Instrução de sistema inválida';
$string['managesysteminstructions'] = 'Gerenciar instruções de sistema';
$string['message_sent_successfully'] = 'Mensagem enviada com sucesso para a sessão de planejamento com IA.';
$string['module_creation_subtitle'] = 'Aguarde enquanto o conteúdo é gerado';
$string['module_creation_title'] = 'Criando módulo...';
$string['module_streaming_add_error'] = 'Não foi possível adicionar a atividade ao curso.';
$string['module_streaming_add_problem'] = 'Ocorreu um problema ao adicionar a atividade: {$a}';
$string['module_streaming_added_success'] = '✅ Atividade adicionada ao curso com sucesso!';
$string['module_streaming_complete'] = '🎉 Sua atividade foi criada com sucesso!';
$string['module_streaming_creation_error'] = '⚠️ Ocorreu um erro durante a criação da atividade';
$string['module_streaming_images_done'] = '✅ Imagens geradas com sucesso';
$string['module_streaming_images_start'] = '🎨 Criando imagens personalizadas...';
$string['module_streaming_output_start'] = '⚙️ Finalizando e preparando a atividade...';
$string['module_streaming_parameters_done'] = '✅ Configuração aplicada';
$string['module_streaming_parameters_start'] = '🔧 Aplicando a configuração da atividade...';
$string['module_streaming_schema_done'] = '✅ Estrutura de conteúdo pronta';
$string['module_streaming_schema_start'] = '📋 Desenhando a estrutura do conteúdo...';
$string['module_streaming_start'] = '🚀 Iniciando a criação da atividade...';
$string['no_system_instructions_configured_notice'] = 'Para usar este tipo de contexto, você precisa primeiro criar instruções de sistema. Acesse a página <a href="{$a}">Gerenciar instruções de sistema</a>.';
$string['noimages'] = 'Não gerar imagens';
$string['nosysteminstructions'] = 'Nenhuma instrução de sistema encontrada';
$string['planning_chat_placeholder'] = 'Descreva os ajustes que você deseja fazer no planejamento do curso...';
$string['planning_completed'] = 'Planejamento concluído';
$string['pluginname'] = 'Criador de cursos com IA';
$string['privacy:metadata:local_coursegen'] = 'O Criador de cursos com IA armazena dados pessoais para apoiar a geração de cursos e módulos com IA.';
$string['privacy:metadata:local_coursegen_course_context'] = 'Preferências de contexto armazenadas para o planejamento do curso.';
$string['privacy:metadata:local_coursegen_course_context:context_type'] = 'O tipo de contexto selecionado para o curso.';
$string['privacy:metadata:local_coursegen_course_context:courseid'] = 'O ID do curso para o qual as preferências de contexto são armazenadas.';
$string['privacy:metadata:local_coursegen_course_context:lang'] = 'O código de idioma usado pela IA para responder e gerar o conteúdo do curso.';
$string['privacy:metadata:local_coursegen_course_context:prompt_text'] = 'O texto do prompt personalizado fornecido para o curso.';
$string['privacy:metadata:local_coursegen_course_context:system_instruction_id'] = 'O ID da instrução de sistema selecionada para o curso.';
$string['privacy:metadata:local_coursegen_course_context:timecreated'] = 'A data em que o registro de contexto do curso foi criado.';
$string['privacy:metadata:local_coursegen_course_context:timemodified'] = 'A data em que o registro de contexto do curso foi atualizado pela última vez.';
$string['privacy:metadata:local_coursegen_course_context:usermodified'] = 'O ID do usuário que modificou o contexto do curso pela última vez.';
$string['privacy:metadata:local_coursegen_course_data'] = 'Dados de curso personalizados armazenados para integração com o DataCurso.';
$string['privacy:metadata:local_coursegen_course_data:courseid'] = 'O ID do curso ao qual esses dados pertencem.';
$string['privacy:metadata:local_coursegen_course_data:custom_checkbox'] = 'Um valor de caixa de seleção personalizada associado ao curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_date'] = 'Um valor de data personalizada associado ao curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_select'] = 'Um valor de seleção personalizada associado ao curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_text'] = 'Um valor de texto curto personalizado associado ao curso.';
$string['privacy:metadata:local_coursegen_course_data:custom_textarea'] = 'Um valor de área de texto personalizada associado ao curso.';
$string['privacy:metadata:local_coursegen_course_data:timecreated'] = 'A data em que o registro foi criado.';
$string['privacy:metadata:local_coursegen_course_data:timemodified'] = 'A data em que o registro foi atualizado pela última vez.';
$string['privacy:metadata:local_coursegen_course_sessions'] = 'Sessões de planejamento de curso criadas por meio do serviço de IA.';
$string['privacy:metadata:local_coursegen_course_sessions:courseid'] = 'O ID do curso que está sendo planejado.';
$string['privacy:metadata:local_coursegen_course_sessions:session_id'] = 'O identificador de sessão retornado pelo serviço de IA.';
$string['privacy:metadata:local_coursegen_course_sessions:status'] = 'O status atual da sessão de planejamento do curso.';
$string['privacy:metadata:local_coursegen_course_sessions:timecreated'] = 'A data em que a sessão de planejamento do curso foi criada.';
$string['privacy:metadata:local_coursegen_course_sessions:timemodified'] = 'A data em que a sessão de planejamento do curso foi atualizada pela última vez.';
$string['privacy:metadata:local_coursegen_course_sessions:userid'] = 'O ID do usuário que iniciou a sessão de planejamento do curso.';
$string['privacy:metadata:local_coursegen_module_jobs'] = 'Detalhes dos trabalhos de geração de módulos com IA colocados em fila pelos usuários.';
$string['privacy:metadata:local_coursegen_module_jobs:beforemod'] = 'O ID do módulo antes do qual a nova atividade deve ser inserida.';
$string['privacy:metadata:local_coursegen_module_jobs:context_type'] = 'O tipo de contexto fornecido ao executar o trabalho de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:courseid'] = 'O ID do curso associado ao trabalho de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:generate_images'] = 'Indica se o trabalho de módulo irá gerar imagens.';
$string['privacy:metadata:local_coursegen_module_jobs:job_id'] = 'O identificador retornado pelo serviço de IA para o trabalho de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:sectionnum'] = 'O número da seção do curso onde a atividade deve ser criada.';
$string['privacy:metadata:local_coursegen_module_jobs:status'] = 'O status atual do trabalho de módulo.';
$string['privacy:metadata:local_coursegen_module_jobs:system_instruction_name'] = 'O nome da instrução de sistema fornecido ao serviço de IA.';
$string['privacy:metadata:local_coursegen_module_jobs:timecreated'] = 'A data em que o trabalho de módulo foi criado.';
$string['privacy:metadata:local_coursegen_module_jobs:timemodified'] = 'A data em que o trabalho de módulo foi atualizado pela última vez.';
$string['privacy:metadata:local_coursegen_module_jobs:userid'] = 'O ID do usuário que iniciou o trabalho de módulo.';
$string['privacy:metadata:local_coursegen_system_instruction'] = 'Instruções de sistema criadas ou editadas para a geração de cursos.';
$string['privacy:metadata:local_coursegen_system_instruction:content'] = 'A descrição armazenada da instrução de sistema.';
$string['privacy:metadata:local_coursegen_system_instruction:deleted'] = 'Indica se a instrução de sistema está marcada como excluída.';
$string['privacy:metadata:local_coursegen_system_instruction:name'] = 'O nome da instrução de sistema.';
$string['privacy:metadata:local_coursegen_system_instruction:timecreated'] = 'A data em que a instrução de sistema foi criada.';
$string['privacy:metadata:local_coursegen_system_instruction:timemodified'] = 'A data em que a instrução de sistema foi atualizada pela última vez.';
$string['privacy:metadata:local_coursegen_system_instruction:usermodified'] = 'O ID do usuário que modificou a instrução de sistema pela última vez.';
$string['resource_created'] = 'Recurso {$a} criado com sucesso.';
$string['send'] = 'Enviar';
$string['syllabus_pdf_field'] = 'Enviar PDF do plano de ensino';
$string['syllabus_pdf_field_help'] = 'Envie um arquivo PDF contendo o plano de ensino do curso. Ele será enviado para a IA para análise de contexto. Tamanho máximo do arquivo: 10 MB.';
$string['systeminstructioncontent'] = 'Conteúdo da instrução de sistema';
$string['systeminstructioncontent_help'] = 'Defina instruções claras e detalhadas que a IA deve seguir rigorosamente ao gerar conteúdo do curso, incluindo etapas, restrições, tom e quaisquer diretrizes que ela deva sempre respeitar.';
$string['systeminstructioncreated'] = 'Criada';
$string['systeminstructiondeleted'] = 'Instrução de sistema excluída com sucesso';
$string['systeminstructionmodified'] = 'Modificada';
$string['systeminstructionname'] = 'Nome da instrução de sistema';
$string['systeminstructionname_help'] = 'Informe o nome da instrução de sistema que você usará para o desenho do curso.';
$string['systeminstructionnameexists'] = 'Já existe uma instrução de sistema com este nome';
$string['systeminstructionsaved'] = 'Instrução de sistema salva com sucesso';
$string['unauthorized'] = 'Acesso não autorizado';
$string['use_system_instruction_field'] = 'Ativar para usar uma instrução de sistema';
$string['use_system_instruction_field_help'] = 'Ative esta opção quando quiser complementar o contexto selecionado (prompt ou plano de ensino) com uma instrução de sistema reutilizável. As instruções de sistema definem regras globais que a IA deve sempre seguir ao gerar conteúdo do curso.';
$string['yesimages'] = 'Gerar imagens';
