define("local_datacurso_ratings/comments_modal",["exports","core/ajax","core/templates","core/modal","core/modal_events","core/notification","core/str"],(function(_exports,_ajax,_templates,_modal,_modal_events,_notification,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Handles the display of comments in a modal window.
   *
   * @module local_datacurso_ratings/comments_modal
   * @copyright 2025 Industria Elearning <info@industriaelearning.com>
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_modal=_interopRequireDefault(_modal),_modal_events=_interopRequireDefault(_modal_events),_notification=_interopRequireDefault(_notification);const init=()=>{document.addEventListener("click",(function(e){if(e.target.classList.contains("view-comments-modal")||e.target.closest(".view-comments-modal")){e.preventDefault();const button=e.target.classList.contains("view-comments-modal")?e.target:e.target.closest(".view-comments-modal"),cmid=button.getAttribute("data-cmid"),activityName=button.getAttribute("data-activity");cmid&&async function(cmid,activityName){try{const[comments,initialBodyHTML]=await Promise.all([(0,_str.get_string)("comments","local_datacurso_ratings"),_templates.default.render("local_datacurso_ratings/report_ratings_loading",{})]),modal=await _modal.default.create({title:comments+" : "+activityName,body:initialBodyHTML,large:!0,scrollable:!0,removeOnClose:!0});modal.show(),loadCommentsData(cmid,0,"",modal),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()}))}catch(err){return _notification.default.exception(err),null}}(cmid,activityName)}}))};function loadCommentsData(cmid){let page=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,search=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",modal=arguments.length>3?arguments[3]:void 0;_ajax.default.call([{methodname:"local_datacurso_ratings_get_activity_comments",args:{cmid:cmid,page:page,perpage:20,search:search}}])[0].then((data=>_templates.default.render("local_datacurso_ratings/comments_modal_content",{...data,searchterm:search}))).then(((html,js)=>{modal.setBody(html),_templates.default.runTemplateJS(js),initModalFeatures(cmid,modal)})).catch((err=>{modal.setBody(_notification.default.exception(err))}))}function initModalFeatures(cmid,modal){const modalBody=modal.getBody()[0],searchInput=modalBody.querySelector("#comments-search");if(searchInput){let searchTimeout;searchInput.addEventListener("input",(function(){clearTimeout(searchTimeout),searchTimeout=setTimeout((()=>{const searchTerm=this.value.trim();loadCommentsData(cmid,0,searchTerm,modal)}),500)}))}const clearSearch=modalBody.querySelector("#clear-search");clearSearch&&clearSearch.addEventListener("click",(function(){searchInput.value="",loadCommentsData(cmid,0,"",modal)})),modalBody.addEventListener("click",(function(e){if(e.target.classList.contains("comments-pagination")){e.preventDefault();const page=parseInt(e.target.getAttribute("data-page")),searchTerm=searchInput?searchInput.value.trim():"";loadCommentsData(cmid,page,searchTerm,modal)}})),modalBody.addEventListener("click",(function(e){if(e.target.classList.contains("keyword-filter")){e.preventDefault();const keyword=e.target.textContent.trim();searchInput&&(searchInput.value=keyword,loadCommentsData(cmid,0,keyword,modal))}}))}_exports.init=init;var _default={init:init};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=comments_modal.min.js.map