define("local_datacurso_ratings/rate",["exports","core/ajax","core/str","core/notification","core/templates"],(function(_exports,_ajax,_str,_notification,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Handles rating and feedback interactions for course modules.
   *
   * @module     local_datacurso_ratings/rate
   * @copyright  2025 Industria Elearning
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates);const init=cmid=>{const container=document.querySelector('.local-dcr-rate[data-cmid="'.concat(cmid,'"]'));if(!container)return;const fbBlock=container.querySelector(".local-dcr-feedback"),fbInput=container.querySelector("#local-dcr-feedback-input"),fbTextareaWrap=container.querySelector("#local-dcr-feedback-textarea"),sendBtn=container.querySelector('[data-action="send"]'),cancelBtn=container.querySelector('[data-action="cancel"]'),likeOptions=container.querySelector(".like-options"),dislikeOptions=container.querySelector(".dislike-options"),msgResponse=container.querySelector(".message-response-rate"),show=el=>{el&&(el.style.display="block",el.setAttribute("aria-hidden","false"))},hide=el=>{el&&(el.style.display="none",el.setAttribute("aria-hidden","true"))};container.querySelectorAll('[data-action="rate"]').forEach((btn=>{btn.addEventListener("click",(()=>{container.querySelectorAll('input[name="feedback_choice"]').forEach((r=>{r.checked=!1})),hide(fbTextareaWrap);0===parseInt(btn.dataset.rating,10)?(show(fbBlock),show(dislikeOptions),hide(likeOptions),null==sendBtn||sendBtn.setAttribute("data-rating","0")):(show(fbBlock),show(likeOptions),hide(dislikeOptions),null==sendBtn||sendBtn.setAttribute("data-rating","1"))}))})),container.querySelectorAll('input[name="feedback_choice"]').forEach((radio=>{radio.addEventListener("change",(()=>{"other"===radio.value&&radio.checked?(show(fbTextareaWrap),null==fbInput||fbInput.focus()):radio.checked&&hide(fbTextareaWrap)}))})),null==cancelBtn||cancelBtn.addEventListener("click",(()=>{hide(fbBlock),hide(fbTextareaWrap),fbInput&&(fbInput.value="",fbInput.disabled=!1),container.querySelectorAll('input[name="feedback_choice"]').forEach((r=>{r.checked=!1,r.disabled=!1})),null==sendBtn||sendBtn.removeAttribute("data-rating"),sendBtn.disabled=!1,cancelBtn.disabled=!1,msgResponse.innerHTML=""})),null==sendBtn||sendBtn.addEventListener("click",(()=>{const rating=parseInt(sendBtn.getAttribute("data-rating")||"0",10),selected=container.querySelector('input[name="feedback_choice"]:checked');let feedback="";selected&&(feedback="other"===selected.value?((null==fbInput?void 0:fbInput.value)||"").trim():selected.value),sendRating(cmid,rating,feedback)}));const sendRating=(cmid,rating,feedback)=>{_ajax.default.call([{methodname:"local_datacurso_ratings_save_rating",args:{cmid:cmid,rating:rating,feedback:feedback}}])[0].then((async()=>{(async(message,type)=>{if(!msgResponse)return;const htmlMessage=await _templates.default.render("local_datacurso_ratings/rate_message_response",{message:message,type:type});msgResponse.innerHTML=htmlMessage})(await(0,_str.get_string)("ratingsaved","local_datacurso_ratings"),"success"),container.querySelectorAll('[data-action="rate"]').forEach((btn=>{btn.disabled=!0})),container.querySelectorAll('input[name="feedback_choice"]').forEach((r=>{r.disabled=!0})),sendBtn&&(sendBtn.disabled=!0),cancelBtn&&(cancelBtn.disabled=!0),fbInput&&(fbInput.disabled=!0),hide(fbBlock),hide(fbTextareaWrap)})).catch((e=>_notification.default.exception(e)))}};_exports.init=init;var _default={init:init};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=rate.min.js.map