define("local_datacurso_ratings/ratings_report",["exports","core/ajax","core/templates","core/notification"],(function(_exports,_ajax,_templates,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * General ratings report JS
   *
   * @module     local_datacurso_ratings/ratings_report
   * @copyright  2025 Industria Elearning
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=_exports.default=void 0,_exports.showLoading=showLoading,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_notification=_interopRequireDefault(_notification);const init=()=>{const container=document.querySelector("#general-ratings-report-container");if(!container)return;let categories=[];try{categories=JSON.parse(container.dataset.categories||"[]")}catch(e){return void _notification.default.alert("Error","Error parsing categories data: "+e.message,"OK")}showLoading(container),_ajax.default.call([{methodname:"local_datacurso_ratings_get_ratings_report",args:{}}])[0].then((data=>function(data,categories){const courseGroups={};let totalLikes=0,totalDislikes=0,totalActivities=0;data.forEach((activity=>{const courseName=activity.course||"Unnamed course";courseGroups[courseName]||(courseGroups[courseName]={courseName:courseName,categoryid:activity.categoryid||"",activities:[],courseLikes:0,courseDislikes:0,courseActivities:0});const likes=Number(activity.likes||0),dislikes=Number(activity.dislikes||0),approvalpercent=Number(activity.approvalpercent||0),comments=Array.isArray(activity.comments)?activity.comments:[],processedActivity={...activity,likes:likes,dislikes:dislikes,total_ratings:likes+dislikes,has_ratings:likes+dislikes>0,has_comments:comments.length>0,satisfaction_class:getSatisfactionClass(approvalpercent),formatted_percentage:"".concat(approvalpercent.toFixed(1),"%"),comments_count:comments.length,comments_text:comments.join(" / ")};courseGroups[courseName].activities.push(processedActivity),courseGroups[courseName].courseLikes+=likes,courseGroups[courseName].courseDislikes+=dislikes,courseGroups[courseName].courseActivities+=1,totalLikes+=likes,totalDislikes+=dislikes,totalActivities+=1})),Object.keys(courseGroups).forEach((courseName=>{const course=courseGroups[courseName],courseTotal=course.courseLikes+course.courseDislikes;course.courseSatisfaction=courseTotal>0?(course.courseLikes/courseTotal*100).toFixed(1):"0",course.courseSatisfactionClass=getSatisfactionClass(parseFloat(course.courseSatisfaction)),course.courseTotal=courseTotal,course.activities.sort(((a,b)=>b.approvalpercent-a.approvalpercent))}));const coursesArray=Object.values(courseGroups).sort(((a,b)=>b.courseTotal-a.courseTotal)),totalRatings=totalLikes+totalDislikes,overallSatisfaction=totalRatings>0?totalLikes/totalRatings*100:0;return{courses:coursesArray,has_data:coursesArray.length>0,categories:categories,summary:{total_courses:coursesArray.length,total_activities:totalActivities,total_ratings:totalRatings,total_likes:totalLikes,total_dislikes:totalDislikes,overall_satisfaction:overallSatisfaction.toFixed(1),satisfaction_class:getSatisfactionClass(overallSatisfaction),activities_with_ratings:data.filter((a=>Number(a.likes||0)+Number(a.dislikes||0)>0)).length}}}(data,categories))).then((templateData=>_templates.default.render("local_datacurso_ratings/ratings_report_page",templateData))).then(((html,js)=>{container.innerHTML=html,_templates.default.runTemplateJS(js),document.querySelectorAll(".course-toggle").forEach((button=>{button.addEventListener("click",(()=>{const target=button.getAttribute("data-target"),courseContent=document.querySelector(target),icon=button.querySelector("i");courseContent&&(courseContent.classList.contains("show")?(courseContent.classList.remove("show"),icon&&(icon.classList.remove("fa-chevron-down"),icon.classList.add("fa-chevron-right"))):(courseContent.classList.add("show"),icon&&(icon.classList.remove("fa-chevron-right"),icon.classList.add("fa-chevron-down"))))}))})),function(){const searchInput=document.querySelector("#activity-search"),courseFilter=document.querySelector("#course-filter"),categoryFilter=document.querySelector("#category-filter");searchInput&&searchInput.addEventListener("input",filterActivities),courseFilter&&courseFilter.addEventListener("input",filterActivities),categoryFilter&&categoryFilter.addEventListener("input",(()=>{const selectedName=categoryFilter.value;let categoryid="";const datalist=document.querySelector("#categories");datalist&&datalist.querySelectorAll("option").forEach((option=>{option.value===selectedName&&(categoryid=option.getAttribute("data-id")||"")})),categoryFilter.dataset.categoryId=categoryid,filterActivities(),function(categoryid){const courseFilter=document.querySelector("#course-filter"),coursesDatalist=document.querySelector("#courses");courseFilter&&coursesDatalist&&(courseFilter.value="",categoryid&&_ajax.default.call([{methodname:"local_datacurso_ratings_get_courses_by_category",args:{categoryid:parseInt(categoryid,10)}}])[0].then((courses=>{Array.isArray(courses)&&courses.length&&courses.forEach((course=>{const option=document.createElement("option");option.value=course.fullname,option.textContent=course.fullname,coursesDatalist.appendChild(option)}))})).catch((err=>{_notification.default.exception(err)})))}(categoryid)}))}()})).catch((error=>{_notification.default.exception(error)}))};function getSatisfactionClass(percentage){return percentage>=80?"success":percentage>=60?"warning":percentage>=40?"info":"danger"}async function showLoading(container){const html=await _templates.default.render("local_datacurso_ratings/report_ratings_loading",{});container.innerHTML=html}function filterActivities(){var _document$querySelect,_document$querySelect2,_categoryFilter$datas;const searchTerm=((null===(_document$querySelect=document.querySelector("#activity-search"))||void 0===_document$querySelect?void 0:_document$querySelect.value)||"").toLowerCase(),selectedCourse=(null===(_document$querySelect2=document.querySelector("#course-filter"))||void 0===_document$querySelect2?void 0:_document$querySelect2.value)||"",categoryFilter=document.querySelector("#category-filter"),selectedCategory=(null==categoryFilter||null===(_categoryFilter$datas=categoryFilter.dataset)||void 0===_categoryFilter$datas?void 0:_categoryFilter$datas.categoryId)||"";document.querySelectorAll(".course-section").forEach((section=>{const courseId=section.getAttribute("data-course")||"",categoryId=section.getAttribute("data-category")||"";let courseVisible=!1;!(""===selectedCategory||categoryId===selectedCategory)||""!==selectedCourse&&courseId!==selectedCourse?courseVisible=!1:section.querySelectorAll(".activity-row").forEach((row=>{const activityName=(row.getAttribute("data-activity")||"").toLowerCase();""===searchTerm||activityName.includes(searchTerm)?(row.style.display="",courseVisible=!0):row.style.display="none"})),section.style.display=courseVisible?"":"none"}))}_exports.init=init;var _default={init:init};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=ratings_report.min.js.map